/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.sourcelookup;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.debug.core.DebugUtils;
import org.jkiss.dbeaver.debug.internal.core.DebugCoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class DatabaseNavigatorSourceContainer
extends CompositeSourceContainer {
    private final DBPDataSourceContainer datasource;
    private final IProject project;

    public DatabaseNavigatorSourceContainer(DBPDataSourceContainer descriptor) {
        this.datasource = descriptor;
        this.project = this.datasource.getRegistry().getProject();
    }

    public String getName() {
        return this.datasource.getName();
    }

    protected Object[] findSourceElements(String name, ISourceContainer[] containers) throws CoreException {
        DBNNode node;
        try {
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            node = DBWorkbench.getPlatform().getNavigatorModel().getNodeByPath((DBRProgressMonitor)monitor, this.project, name);
        }
        catch (DBException e) {
            String message = NLS.bind((String)DebugCoreMessages.DatasourceSourceContainer_e_extract_node, (Object)name);
            throw new CoreException((IStatus)DebugUtils.newErrorStatus(message, e));
        }
        if (node != null) {
            return new Object[]{node};
        }
        return super.findSourceElements(name, containers);
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType("org.jkiss.dbeaver.debug.core.datasourceSourceContainerType");
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        return new ISourceContainer[0];
    }
}

