/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.app.DBPProjectManager;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPResourceHandlerDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.ResourceHandlerDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class ProjectRegistry
implements DBPProjectManager,
DBPExternalFileManager {
    private static final Log log = Log.getLog(ProjectRegistry.class);
    public static final String DEFAULT_RESOURCES_ROOT = "Resources";
    private static final String PROP_PROJECT_ACTIVE = "project.active";
    private static final String EXT_FILES_PROPS_STORE = "dbeaver-external-files.data";
    private final List<ResourceHandlerDescriptor> handlerDescriptors = new ArrayList<ResourceHandlerDescriptor>();
    private final Map<IProject, DataSourceRegistry> projectDatabases = new HashMap<IProject, DataSourceRegistry>();
    private IProject activeProject;
    private IWorkspace workspace;
    private final Map<String, Map<String, Object>> externalFileProperties = new HashMap<String, Map<String, Object>>();
    private final List<DBPProjectListener> projectListeners = new ArrayList<DBPProjectListener>();

    public ProjectRegistry(IWorkspace workspace) {
        this.workspace = workspace;
        this.loadExtensions(Platform.getExtensionRegistry());
        this.loadExternalFileProperties();
    }

    public void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.resourceHandler");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            ResourceHandlerDescriptor handlerDescriptor = new ResourceHandlerDescriptor(ext);
            this.handlerDescriptors.add(handlerDescriptor);
            ++n2;
        }
    }

    public void loadProjects(IProgressMonitor monitor) throws DBException {
        DBPPlatform platform = DBWorkbench.getPlatform();
        String activeProjectName = platform.getPreferenceStore().getString(PROP_PROJECT_ACTIVE);
        List projects = platform.getLiveProjects();
        monitor.beginTask("Open active project", projects.size());
        try {
            for (IProject project : projects) {
                if (project.exists() && !project.isHidden()) {
                    if (project.getName().equals(activeProjectName)) {
                        this.activeProject = project;
                        break;
                    }
                    if (this.activeProject == null) {
                        this.activeProject = project;
                    }
                }
                monitor.worked(1);
            }
            if (this.activeProject != null) {
                try {
                    this.activeProject.open(monitor);
                    this.activeProject.refreshLocal(1, monitor);
                    this.setActiveProject(this.activeProject);
                }
                catch (CoreException coreException) {
                    projects.remove(this.activeProject);
                    this.activeProject = null;
                }
            }
        }
        finally {
            monitor.done();
        }
        if (DBWorkbench.getPlatform().getApplication().isStandalone() && CommonUtils.isEmpty((Collection)projects)) {
            monitor.beginTask("Create default project", 1);
            try {
                try {
                    this.activeProject = this.createDefaultProject(monitor);
                    this.activeProject.open(monitor);
                    this.setActiveProject(this.activeProject);
                }
                catch (CoreException e) {
                    throw new DBException("Can't create default project", (Throwable)e);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<IProject, DataSourceRegistry> map = this.projectDatabases;
        synchronized (map) {
            if (!this.projectDatabases.isEmpty()) {
                log.warn((Object)("Some projects are still open: " + this.projectDatabases.keySet()));
            }
            for (DataSourceRegistry dataSourceRegistry : this.projectDatabases.values()) {
                dataSourceRegistry.dispose();
            }
            this.projectDatabases.clear();
        }
        for (ResourceHandlerDescriptor handlerDescriptor : this.handlerDescriptors) {
            handlerDescriptor.dispose();
        }
        this.handlerDescriptors.clear();
        this.workspace = null;
        if (!this.projectListeners.isEmpty()) {
            log.warn((Object)("Some project listeners are still register: " + this.projectListeners));
            this.projectListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectListener(DBPProjectListener listener) {
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            this.projectListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectListener(DBPProjectListener listener) {
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            this.projectListeners.remove(listener);
        }
    }

    private ResourceHandlerDescriptor getHandlerDescriptor(String id) {
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            if (!rhd.getId().equals(id)) continue;
            return rhd;
        }
        return null;
    }

    private ResourceHandlerDescriptor getHandlerDescriptorByRootPath(IProject project, String path) {
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            String defaultRoot = rhd.getDefaultRoot(project);
            if (defaultRoot == null || !defaultRoot.equals(path)) continue;
            return rhd;
        }
        return null;
    }

    public DBPResourceHandler getResourceHandler(IResource resource) {
        if (resource == null || resource.isHidden() || resource.isPhantom()) {
            return null;
        }
        if (resource.getParent() instanceof IProject && resource.getName().startsWith(".dbeaver-data-sources")) {
            return null;
        }
        if (resource instanceof IFile && !resource.isSynchronized(0)) {
            ContentUtils.syncFile((DBRProgressMonitor)new VoidProgressMonitor(), (IResource)resource);
        }
        DBPResourceHandler handler = null;
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            if (!rhd.canHandle(resource)) continue;
            handler = rhd.getHandler();
            break;
        }
        if (handler == null && resource instanceof IFolder) {
            IProject project = resource.getProject();
            IPath relativePath = resource.getFullPath().makeRelativeTo(project.getFullPath());
            while (relativePath.segmentCount() > 0) {
                String folderPath = relativePath.toString();
                ResourceHandlerDescriptor handlerDescriptor = this.getHandlerDescriptorByRootPath(project, folderPath);
                if (handlerDescriptor != null) {
                    handler = handlerDescriptor.getHandler();
                }
                relativePath = relativePath.removeLastSegments(1);
            }
        }
        if (handler == null) {
            handler = DBWorkbench.getPlatform().getDefaultResourceHandler();
        }
        return handler;
    }

    public DBPResourceHandlerDescriptor[] getAllResourceHandlers() {
        return this.handlerDescriptors.toArray(new DBPResourceHandlerDescriptor[0]);
    }

    public IFolder getResourceDefaultRoot(IProject project, DBPResourceHandlerDescriptor rhd, boolean forceCreate) {
        if (project == null) {
            return null;
        }
        String defaultRoot = rhd.getDefaultRoot(project);
        if (defaultRoot == null) {
            return null;
        }
        IFolder realFolder = project.getFolder(defaultRoot);
        if (forceCreate && !realFolder.exists()) {
            try {
                realFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                log.error((Object)("Can't create '" + rhd.getName() + "' root folder '" + realFolder.getName() + "'"), (Throwable)e);
                return realFolder;
            }
        }
        return realFolder;
    }

    public IFolder getResourceDefaultRoot(IProject project, Class<? extends DBPResourceHandler> handlerType, boolean forceCreate) {
        if (project == null) {
            return null;
        }
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            DBPResourceHandler handler = rhd.getHandler();
            if (handler == null || handler.getClass() != handlerType) continue;
            String defaultRoot = rhd.getDefaultRoot(project);
            if (defaultRoot == null) {
                return null;
            }
            IFolder realFolder = project.getFolder(defaultRoot);
            if (forceCreate && !realFolder.exists()) {
                try {
                    realFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    log.error((Object)("Can't create '" + rhd.getName() + "' root folder '" + realFolder.getName() + "'"), (Throwable)e);
                    return realFolder;
                }
            }
            return realFolder;
        }
        return project.getFolder(DEFAULT_RESOURCES_ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceRegistry getDataSourceRegistry(IProject project) {
        DataSourceRegistry registry;
        if (project == null) {
            log.warn((Object)"No active project - can't get datasource registry");
            return null;
        }
        if (!project.isOpen()) {
            log.warn((Object)("Project '" + project.getName() + "' is not open - can't get datasource registry"));
            return null;
        }
        DataSourceRegistry registry2 = null;
        Map<IProject, DataSourceRegistry> map = this.projectDatabases;
        synchronized (map) {
            registry = this.projectDatabases.get(project);
        }
        if (registry == null) {
            registry = new DataSourceRegistry(DBWorkbench.getPlatform(), project);
            map = this.projectDatabases;
            synchronized (map) {
                registry2 = this.projectDatabases.get(project);
                if (registry2 == null) {
                    this.projectDatabases.put(project, registry);
                }
            }
        }
        if (registry2 != null) {
            registry.dispose();
            return registry2;
        }
        return registry;
    }

    public DBPDataSourceRegistry getDefaultDataSourceRegistry() {
        return this.activeProject == null ? null : this.getDataSourceRegistry(this.activeProject);
    }

    public DBPResourceHandlerDescriptor[] getResourceHandlerDescriptors() {
        DBPResourceHandlerDescriptor[] result = new DBPResourceHandlerDescriptor[this.handlerDescriptors.size()];
        int i = 0;
        while (i < this.handlerDescriptors.size()) {
            result[i] = this.handlerDescriptors.get(i);
            ++i;
        }
        return result;
    }

    public DataSourceRegistry getActiveDataSourceRegistry() {
        if (this.activeProject == null) {
            return null;
        }
        return this.getDataSourceRegistry(this.activeProject);
    }

    public IProject getActiveProject() {
        return this.activeProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveProject(IProject project) {
        DBPProjectListener[] listeners;
        IProject oldValue = this.activeProject;
        this.activeProject = project;
        DBWorkbench.getPlatform().getPreferenceStore().setValue(PROP_PROJECT_ACTIVE, project == null ? "" : project.getName());
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            listeners = this.projectListeners.toArray(new DBPProjectListener[this.projectListeners.size()]);
        }
        DBPProjectListener[] dBPProjectListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            DBPProjectListener listener = dBPProjectListenerArray[n2];
            listener.handleActiveProjectChange(oldValue, this.activeProject);
            ++n2;
        }
    }

    private IProject createDefaultProject(IProgressMonitor monitor) throws CoreException {
        String baseProjectName;
        String projectName = baseProjectName = DBWorkbench.getPlatform().getApplication().getDefaultProjectName();
        int i = 1;
        while (true) {
            IProject project;
            if (!(project = this.workspace.getRoot().getProject(projectName)).exists()) {
                project.create(monitor);
                project.open(monitor);
                IProjectDescription description = this.workspace.newProjectDescription(project.getName());
                description.setComment("General DBeaver project");
                description.setNatureIds(new String[]{"org.jkiss.dbeaver.DBeaverNature"});
                project.setDescription(description, monitor);
                return project;
            }
            projectName = String.valueOf(baseProjectName) + i;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProject(IProject project) {
        Map<IProject, DataSourceRegistry> map = this.projectDatabases;
        synchronized (map) {
            if (this.projectDatabases.containsKey(project)) {
                log.warn((Object)("Project [" + project + "] already added"));
                return;
            }
            this.projectDatabases.put(project, new DataSourceRegistry(DBWorkbench.getPlatform(), project));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProject(IProject project) {
        if (project != null) {
            Map<IProject, DataSourceRegistry> map = this.projectDatabases;
            synchronized (map) {
                DataSourceRegistry dataSourceRegistry = this.projectDatabases.get(project);
                if (dataSourceRegistry == null) {
                    log.warn((Object)("Project '" + project.getName() + "' not found in the registry"));
                } else {
                    dataSourceRegistry.dispose();
                    this.projectDatabases.remove(project);
                }
            }
        }
    }

    public Map<String, Object> getFileProperties(File file) {
        return this.externalFileProperties.get(file.getAbsolutePath());
    }

    public Object getFileProperty(File file, String property) {
        Map<String, Object> fileProps = this.externalFileProperties.get(file.getAbsolutePath());
        return fileProps == null ? null : fileProps.get(property);
    }

    public void setFileProperty(File file, String property, Object value) {
        String filePath = file.getAbsolutePath();
        Map<String, Object> fileProps = this.externalFileProperties.get(filePath);
        if (fileProps == null) {
            fileProps = new HashMap<String, Object>();
            this.externalFileProperties.put(filePath, fileProps);
        }
        if (value == null) {
            fileProps.remove(property);
        } else {
            fileProps.put(property, value);
        }
        this.saveExternalFileProperties();
    }

    public Map<String, Map<String, Object>> getAllFiles() {
        return this.externalFileProperties;
    }

    private void loadExternalFileProperties() {
        this.externalFileProperties.clear();
        File propsFile = new File(GeneralUtils.getMetadataFolder(), EXT_FILES_PROPS_STORE);
        if (propsFile.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream is = new FileInputStream(propsFile);){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (ObjectInputStream ois = new ObjectInputStream(is);){
                        Object object = ois.readObject();
                        if (object instanceof Map) {
                            this.externalFileProperties.putAll((Map)object);
                        } else {
                            log.error((Object)("Bad external files properties data format: " + object));
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error saving external files properties", (Throwable)e);
            }
        }
    }

    private void saveExternalFileProperties() {
        File propsFile = new File(GeneralUtils.getMetadataFolder(), EXT_FILES_PROPS_STORE);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream os = new FileOutputStream(propsFile);){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (ObjectOutputStream oos = new ObjectOutputStream(os);){
                    oos.writeObject(this.externalFileProperties);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error saving external files properties", (Throwable)e);
        }
    }
}

