/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql;

import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerAuthentication;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectClass;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.utils.CommonUtils;

public class SQLServerUtils {
    private static final Log log = Log.getLog(SQLServerUtils.class);

    public static boolean isDriverSqlServer(DBPDriver driver) {
        return driver.getSampleURL().contains(":sqlserver");
    }

    public static boolean isDriverGeneric(DBPDriver driver) {
        return driver.getId().contains("generic");
    }

    public static boolean isDriverAzure(DBPDriver driver) {
        return driver.getId().contains("azure");
    }

    public static boolean isDriverJtds(DBPDriver driver) {
        return driver.getSampleURL().startsWith("jdbc:jtds");
    }

    public static boolean isWindowsAuth(DBPConnectionConfiguration connectionInfo) {
        return CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-connection-windows-auth@")) || CommonUtils.toBoolean(connectionInfo.getProperties().get("integratedSecurity"));
    }

    public static boolean isActiveDirectoryAuth(DBPConnectionConfiguration connectionInfo) {
        return "ActiveDirectoryPassword".equals(connectionInfo.getProperty("authentication"));
    }

    public static void setCurrentDatabase(JDBCSession session, String schema) throws SQLException {
        JDBCUtils.executeSQL((Connection)session, (String)("use " + DBUtils.getQuotedIdentifier((DBPDataSource)session.getDataSource(), (String)schema)), (Object[])new Object[0]);
    }

    public static String getCurrentDatabase(JDBCSession session) throws SQLException {
        return JDBCUtils.queryString((JDBCSession)session, (String)"select db_name()", (Object[])new Object[0]);
    }

    public static boolean isShowAllSchemas(DBPDataSource dataSource) {
        return CommonUtils.toBoolean((Object)dataSource.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-show-all-schemas@"));
    }

    public static String getSystemSchemaFQN(JDBCDataSource dataSource, String catalog, String systemSchema) {
        return catalog != null && dataSource.isServerVersionAtLeast(9, 0) ? String.valueOf(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)catalog)) + "." + systemSchema : systemSchema;
    }

    public static String getSystemTableName(SQLServerDatabase database, String tableName) {
        return String.valueOf(SQLServerUtils.getSystemSchemaFQN(database.getDataSource(), database.getName(), "sys")) + "." + tableName;
    }

    public static String getExtendedPropsTableName(SQLServerDatabase database) {
        return SQLServerUtils.getSystemTableName(database, "extended_properties");
    }

    public static DBSForeignKeyModifyRule getForeignKeyModifyRule(int actionNum) {
        switch (actionNum) {
            case 0: {
                return DBSForeignKeyModifyRule.NO_ACTION;
            }
            case 1: {
                return DBSForeignKeyModifyRule.CASCADE;
            }
            case 2: {
                return DBSForeignKeyModifyRule.SET_NULL;
            }
            case 3: {
                return DBSForeignKeyModifyRule.SET_DEFAULT;
            }
        }
        return DBSForeignKeyModifyRule.NO_ACTION;
    }

    /*
     * Exception decompiling
     */
    public static String extractSource(@NotNull DBRProgressMonitor monitor, @NotNull SQLServerDatabase database, @NotNull SQLServerObject object) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String extractSource(@NotNull DBRProgressMonitor monitor, @NotNull SQLServerDatabase database, @Nullable SQLServerSchema schema, @NotNull String objectName) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public static boolean isCommentSet(DBRProgressMonitor monitor, SQLServerDatabase database, SQLServerObjectClass objectClass, long majorId, long minorId) {
        JDBCResultSet dbResult;
        JDBCPreparedStatement dbStat;
        JDBCSession session;
        block40: {
            block41: {
                Throwable throwable = null;
                Object var8_8 = null;
                session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)database, (String)"Check extended property");
                Throwable throwable2 = null;
                Object var11_13 = null;
                dbStat = session.prepareStatement("SELECT 1 FROM " + SQLServerUtils.getExtendedPropsTableName(database) + " WHERE [class] = ? AND [major_id] = ? AND [minor_id] = ? AND [name] = N'MS_Description'");
                dbStat.setInt(1, objectClass.getClassId());
                dbStat.setLong(2, majorId);
                dbStat.setLong(3, minorId);
                Throwable throwable3 = null;
                Object var14_18 = null;
                dbResult = dbStat.executeQuery();
                if (!dbResult.next()) break block40;
                if (dbResult == null) break block41;
                {
                    catch (Throwable throwable4) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                if (throwable3 == null) {
                                    throwable3 = throwable5;
                                } else if (throwable3 != throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable6) {
                                try {
                                    if (dbStat != null) {
                                        dbStat.close();
                                    }
                                    throw throwable6;
                                }
                                catch (Throwable throwable7) {
                                    try {
                                        if (throwable2 == null) {
                                            throwable2 = throwable7;
                                        } else if (throwable2 != throwable7) {
                                            throwable2.addSuppressed(throwable7);
                                        }
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable8) {
                                        try {
                                            if (session != null) {
                                                session.close();
                                            }
                                            throw throwable8;
                                        }
                                        catch (Throwable throwable9) {
                                            try {
                                                if (throwable == null) {
                                                    throwable = throwable9;
                                                } else if (throwable != throwable9) {
                                                    throwable.addSuppressed(throwable9);
                                                }
                                                throw throwable;
                                            }
                                            catch (Throwable e) {
                                                log.debug((Object)"Error checking extended property in dictionary", e);
                                                return false;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                dbResult.close();
            }
            if (dbStat != null) {
                dbStat.close();
            }
            if (session != null) {
                session.close();
            }
            return true;
        }
        if (dbResult != null) {
            dbResult.close();
        }
        if (dbStat != null) {
            dbStat.close();
        }
        if (session != null) {
            session.close();
        }
        return false;
    }

    @NotNull
    public static SQLServerAuthentication detectAuthSchema(DBPConnectionConfiguration connectionInfo) {
        SQLServerAuthentication auth = SQLServerUtils.isWindowsAuth(connectionInfo) ? SQLServerAuthentication.WINDOWS_INTEGRATED : (SQLServerUtils.isActiveDirectoryAuth(connectionInfo) ? SQLServerAuthentication.AD_PASSWORD : SQLServerAuthentication.SQL_SERVER_PASSWORD);
        String authProp = connectionInfo.getProviderProperty("@dbeaver-authentication@");
        if (authProp != null) {
            try {
                auth = SQLServerAuthentication.valueOf(authProp);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn((Object)("Bad auth schema: " + authProp));
            }
        }
        return auth;
    }

    public static String changeCreateToAlterDDL(SQLDialect sqlDialect, String ddl) {
        String firstKeyword = SQLUtils.getFirstKeyword((SQLDialect)sqlDialect, (String)ddl);
        if ("CREATE".equalsIgnoreCase(firstKeyword)) {
            return ddl.replaceFirst(firstKeyword, "ALTER");
        }
        return ddl;
    }
}

