/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.tools.sqldeveloper;

import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedHashMap;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.import_config.wizards.ConfigImportWizardPage;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportData;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportDriverInfo;
import org.jkiss.dbeaver.ext.oracle.Activator;
import org.jkiss.dbeaver.ext.oracle.OracleMessages;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleConnectionType;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigImportWizardPageSqlDeveloper
extends ConfigImportWizardPage {
    public static final String SQLD_HOME_FOLDER = "SQL Developer";
    public static final String SQLD_CONFIG_FILE = "connections.xml";
    public static final String SQLD_SYSCONFIG_FOLDER = "system";
    public static final String SQLD_CONNECTIONS_FOLDER = "o.jdeveloper.db.connection.";
    private final ImportDriverInfo oraDriver;

    protected ConfigImportWizardPageSqlDeveloper() {
        super("SQLDeveloper");
        this.setTitle(SQLD_HOME_FOLDER);
        this.setDescription("Import Oracle SQL Developer connections");
        this.setImageDescriptor(Activator.getImageDescriptor("icons/sqldeveloper_big.png"));
        this.oraDriver = new ImportDriverInfo(null, "Oracle", "jdbc:oracle:thin:@{host}[:{port}]/{database}", "oracle.jdbc.OracleDriver");
    }

    protected void loadConnections(ImportData importData) throws DBException {
        importData.addDriver(this.oraDriver);
        File homeFolder = RuntimeUtils.getUserHomeDir();
        File sqlDevHome = new File(homeFolder, "AppData/Roaming/SQL Developer");
        if (!(sqlDevHome.exists() || (sqlDevHome = new File(homeFolder, "Application Data/SQL Developer")).exists() || (sqlDevHome = new File(homeFolder, ".sqldeveloper")).exists())) {
            throw new DBException(OracleMessages.config_import_wizard_page_sql_developer_label_installation_not_found);
        }
        File[] sysConfFolders = sqlDevHome.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(ConfigImportWizardPageSqlDeveloper.SQLD_SYSCONFIG_FOLDER);
            }
        });
        if (sysConfFolders == null || sysConfFolders.length == 0) {
            throw new DBException("SQL Developer config not found");
        }
        File[] fileArray = sysConfFolders;
        int n = sysConfFolders.length;
        int n2 = 0;
        while (n2 < n) {
            File connectionFolder;
            File connectionsFile;
            File sysConfFolder = fileArray[n2];
            File[] connectionFolders = sysConfFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(ConfigImportWizardPageSqlDeveloper.SQLD_CONNECTIONS_FOLDER);
                }
            });
            if (connectionFolders != null && connectionFolders.length == 1 && (connectionsFile = new File(connectionFolder = connectionFolders[0], SQLD_CONFIG_FILE)).exists()) {
                this.parseConnections(connectionsFile, importData);
            }
            ++n2;
        }
    }

    private void parseConnections(File connectionsFile, ImportData importData) throws DBException {
        try {
            Document configDocument = XMLUtils.parseDocument((File)connectionsFile);
            for (Element refElement : XMLUtils.getChildElementList((Element)configDocument.getDocumentElement(), (String)"Reference")) {
                String conName = refElement.getAttribute("name");
                if (CommonUtils.isEmpty((String)conName)) continue;
                LinkedHashMap<String, String> propsMap = new LinkedHashMap<String, String>();
                Element refAddressesElement = XMLUtils.getChildElement((Element)refElement, (String)"RefAddresses");
                if (refAddressesElement != null) {
                    for (Element refAddr : XMLUtils.getChildElementList((Element)refAddressesElement, (String)"StringRefAddr")) {
                        String addrType = refAddr.getAttribute("addrType");
                        String addrContent = XMLUtils.getChildElementBody((Element)refAddr, (String)"Contents");
                        if (CommonUtils.isEmpty((String)addrType) || CommonUtils.isEmpty((String)addrContent)) continue;
                        propsMap.put(addrType, addrContent);
                    }
                }
                String host = (String)propsMap.get("hostname");
                String port = (String)propsMap.get("port");
                String sid = (String)propsMap.get("sid");
                String serviceName = (String)propsMap.get("serviceName");
                String user = (String)propsMap.get("user");
                String role = (String)propsMap.get("role");
                String osAuth = (String)propsMap.get("OS_AUTHENTICATION");
                String url = (String)propsMap.get("customUrl");
                if (CommonUtils.isEmpty((String)host) && CommonUtils.isEmpty((String)url)) continue;
                String dbName = CommonUtils.isEmpty((String)sid) ? serviceName : sid;
                ImportConnectionInfo connectionInfo = new ImportConnectionInfo(this.oraDriver, null, conName, url, host, port, dbName, user, null);
                if (!CommonUtils.isEmpty((String)sid)) {
                    connectionInfo.setProviderProperty("@dbeaver-sid-service@", OracleConnectionType.SID.name());
                } else if (!CommonUtils.isEmpty((String)serviceName)) {
                    connectionInfo.setProviderProperty("@dbeaver-sid-service@", OracleConnectionType.SERVICE.name());
                }
                if (CommonUtils.toBoolean((Object)osAuth)) {
                    connectionInfo.setUser("@dbeaver-os-authentication@");
                }
                if (!CommonUtils.isEmpty((String)role)) {
                    connectionInfo.setProviderProperty("@dbeaver-internal-logon@", role);
                }
                importData.addConnection(connectionInfo);
            }
        }
        catch (XMLException e) {
            throw new DBException("Configuration parse error: " + e.getMessage());
        }
    }
}

