/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.exec;

import java.net.Authenticator;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWForwarder;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.runtime.net.GlobalProxyAuthenticator;
import org.jkiss.utils.CommonUtils;

public class DBExecUtils {
    private static final ThreadLocal<DBPDataSourceContainer> ACTIVE_CONTEXT = new ThreadLocal();
    private static final List<DBPDataSourceContainer> ACTIVE_CONTEXTS = new ArrayList<DBPDataSourceContainer>();

    public static DBPDataSourceContainer getCurrentThreadContext() {
        return ACTIVE_CONTEXT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DBPDataSourceContainer> getActiveContexts() {
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            return new ArrayList<DBPDataSourceContainer>(ACTIVE_CONTEXTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startContextInitiation(DBPDataSourceContainer context) {
        ACTIVE_CONTEXT.set(context);
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            ACTIVE_CONTEXTS.add(context);
        }
        boolean hasProxy = false;
        for (DBWHandlerConfiguration handler : context.getConnectionConfiguration().getDeclaredHandlers()) {
            if (!handler.isEnabled() || handler.getType() != DBWHandlerType.PROXY) continue;
            hasProxy = true;
            break;
        }
        if (hasProxy) {
            Authenticator.setDefault(new GlobalProxyAuthenticator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishContextInitiation(DBPDataSourceContainer context) {
        ACTIVE_CONTEXT.remove();
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            ACTIVE_CONTEXTS.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBPDataSourceContainer findConnectionContext(String host, int port, String path) {
        DBPDataSourceContainer curContext = DBExecUtils.getCurrentThreadContext();
        if (curContext != null) {
            return DBExecUtils.contextMatches(host, port, curContext) ? curContext : null;
        }
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            for (DBPDataSourceContainer ctx : ACTIVE_CONTEXTS) {
                if (!DBExecUtils.contextMatches(host, port, ctx)) continue;
                return ctx;
            }
        }
        return null;
    }

    private static boolean contextMatches(String host, int port, DBPDataSourceContainer ctx) {
        DBPConnectionConfiguration cfg = ctx.getConnectionConfiguration();
        if (CommonUtils.equalObjects((Object)cfg.getHostName(), (Object)host) && String.valueOf(port).equals(cfg.getHostPort())) {
            return true;
        }
        DBWNetworkHandler[] dBWNetworkHandlerArray = ctx.getActiveNetworkHandlers();
        int n = dBWNetworkHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBWNetworkHandler networkHandler = dBWNetworkHandlerArray[n2];
            if (networkHandler instanceof DBWForwarder && ((DBWForwarder)((Object)networkHandler)).matchesParameters(host, port)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

