/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.gis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Set;
import org.cts.CRSFactory;
import org.cts.IllegalCoordinateException;
import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeodeticCRS;
import org.cts.crs.ProjectedCRS;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationException;
import org.cts.op.CoordinateOperationFactory;
import org.cts.registry.EPSGRegistry;
import org.cts.registry.Registry;
import org.cts.registry.RegistryManager;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.gis.GisTransformRequest;
import org.jkiss.utils.CommonUtils;

public class GisTransformUtils {
    private static final Log log = Log.getLog(GisTransformUtils.class);
    private static CRSFactory crsFactory = new CRSFactory();
    private static CoordinateReferenceSystem crs3857;

    static {
        RegistryManager registryManager = crsFactory.getRegistryManager();
        registryManager.addRegistry((Registry)new EPSGRegistry());
        try {
            crs3857 = crsFactory.getCRS("EPSG:3857");
        }
        catch (CRSException e) {
            log.error((Object)"Error getting default CRS", (Throwable)e);
        }
    }

    public static CRSFactory getCRSFactory() {
        return crsFactory;
    }

    public static void transformGisData(GisTransformRequest request) throws DBException {
        try {
            CoordinateReferenceSystem crs1 = crsFactory.getCRS("EPSG:" + request.getSourceSRID());
            CoordinateReferenceSystem crs2 = crsFactory.getCRS("EPSG:" + request.getTargetSRID());
            try {
                Geometry targetValue = GisTransformUtils.transformGisData(request.getSourceValue(), crs1, crs2);
                targetValue.setSRID(request.getTargetSRID());
                request.setTargetValue(targetValue);
                request.setShowOnMap(true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (CommonUtils.equalObjects((Object)crs1.getCoordinateSystem(), (Object)crs3857.getCoordinateSystem())) {
                    Geometry geometry = GisTransformUtils.transformGisData(request.getSourceValue(), crs3857, crs2);
                    geometry.setSRID(request.getTargetSRID());
                    request.setTargetValue(geometry);
                    request.setShowOnMap(false);
                }
            }
        }
        catch (Exception e) {
            throw new DBException("Error transforming SRIDs", (Throwable)e);
        }
    }

    private static Geometry transformGeometryTo(ProjectedCRS projectedCRS, Geometry geometry) throws CoordinateOperationException, IllegalCoordinateException {
        CoordinateOperation coordinateOperation = projectedCRS.toGeographicCoordinateConverter();
        Coordinate[] coordinateArray = geometry.getCoordinates();
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coord = coordinateArray[n2];
            double[] srcCoord = GisTransformUtils.getCoordinateValues(coord);
            double[] transform = coordinateOperation.transform(srcCoord);
            GisTransformUtils.setCoordinateValues(coord, transform);
            ++n2;
        }
        return null;
    }

    public static Geometry transformGisData(Geometry jtsValue, CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) throws Exception {
        Set coordOps;
        if (crs1 instanceof GeodeticCRS && crs2 instanceof GeodeticCRS && !(coordOps = CoordinateOperationFactory.createCoordinateOperations((GeodeticCRS)((GeodeticCRS)crs1), (GeodeticCRS)((GeodeticCRS)crs2))).isEmpty()) {
            for (CoordinateOperation op : coordOps) {
                jtsValue = GisTransformUtils.transformGeometry(jtsValue, op);
            }
            return jtsValue;
        }
        return jtsValue;
    }

    private static Geometry transformGeometry(Geometry geom, CoordinateOperation op) throws Exception {
        geom = (Geometry)geom.clone();
        Coordinate[] coordinateArray = geom.getCoordinates();
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coord = coordinateArray[n2];
            double[] srcCoord = GisTransformUtils.getCoordinateValues(coord);
            double[] targetCoord = op.transform(srcCoord);
            GisTransformUtils.setCoordinateValues(coord, targetCoord);
            ++n2;
        }
        return geom;
    }

    private static void setCoordinateValues(Coordinate coord, double[] targetCoord) {
        if (targetCoord != null) {
            coord.x = targetCoord[0] - 123.0;
            coord.y = targetCoord[1];
            if (targetCoord.length > 2) {
                coord.z = targetCoord[2];
            }
        }
    }

    private static double[] getCoordinateValues(Coordinate coord) {
        double[] srcCoord = Double.isNaN(coord.z) ? new double[]{coord.x, coord.y} : new double[]{coord.x, coord.y, coord.z};
        return srcCoord;
    }
}

