Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

/** @babel */

var _atom = require('atom');

var _ctags = require('ctags');

var _ctags2 = _interopRequireDefault(_ctags);

var _async = require('async');

var _async2 = _interopRequireDefault(_async);

var _getTagsFile = require('./get-tags-file');

var _getTagsFile2 = _interopRequireDefault(_getTagsFile);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var handlerPath = require.resolve('./load-tags-handler');

var wordAtCursor = function wordAtCursor(text, cursorIndex, wordSeparator, noStripBefore) {
  var beforeCursor = text.slice(0, cursorIndex);
  var afterCursor = text.slice(cursorIndex);
  var beforeCursorWordBegins = noStripBefore ? 0 : beforeCursor.lastIndexOf(wordSeparator) + 1;
  var afterCursorWordEnds = afterCursor.indexOf(wordSeparator);
  if (afterCursorWordEnds === -1) {
    afterCursorWordEnds = afterCursor.length;
  }
  return beforeCursor.slice(beforeCursorWordBegins) + afterCursor.slice(0, afterCursorWordEnds);
};

exports['default'] = {
  find: function find(editor, callback) {
    var symbol = undefined;
    var symbols = [];

    if (symbol = editor.getSelectedText()) {
      symbols.push(symbol);
    }

    if (!symbols.length) {
      (function () {
        var nonWordCharacters = undefined;
        var cursor = editor.getLastCursor();
        var cursorPosition = cursor.getBufferPosition();
        var scope = cursor.getScopeDescriptor();
        var rubyScopes = scope.getScopesArray().filter(function (s) {
          return (/^source\.ruby($|\.)/.test(s)
          );
        });

        var wordRegExp = rubyScopes.length ? (nonWordCharacters = atom.config.get('editor.nonWordCharacters', { scope: scope }),
        // Allow special handling for fully-qualified ruby constants
        nonWordCharacters = nonWordCharacters.replace(/:/g, ''), new RegExp('[^\\s' + _underscorePlus2['default'].escapeRegExp(nonWordCharacters) + ']+([!?]|\\s*=>?)?|[<=>]+', 'g')) : cursor.wordRegExp();

        var addSymbol = function addSymbol(symbol) {
          if (rubyScopes.length) {
            // Normalize assignment syntax
            if (/\s+=?$/.test(symbol)) {
              symbols.push(symbol.replace(/\s+=$/, '='));
            }
            // Strip away assignment & hashrocket syntax
            symbols.push(symbol.replace(/\s+=>?$/, ''));
          } else {
            symbols.push(symbol);
          }
        };

        // Can't use `getCurrentWordBufferRange` here because we want to select
        // the last match of the potential 2 matches under cursor.
        editor.scanInBufferRange(wordRegExp, cursor.getCurrentLineBufferRange(), function (_ref) {
          var range = _ref.range;
          var match = _ref.match;

          if (range.containsPoint(cursorPosition)) {
            symbol = match[0];
            if (rubyScopes.length && symbol.indexOf(':') > -1) {
              var cursorWithinSymbol = cursorPosition.column - range.start.column;
              // Add fully-qualified ruby constant up until the cursor position
              addSymbol(wordAtCursor(symbol, cursorWithinSymbol, ':', true));
              // Additionally, also look up the bare word under cursor
              addSymbol(wordAtCursor(symbol, cursorWithinSymbol, ':'));
            } else {
              addSymbol(symbol);
            }
          }
        });
      })();
    }

    if (!symbols.length) {
      process.nextTick(function () {
        callback(null, []);
      });
    }

    _async2['default'].map(atom.project.getPaths(), function (projectPath, done) {
      var tagsFile = (0, _getTagsFile2['default'])(projectPath);
      var foundTags = [];
      var foundErr = null;
      var detectCallback = function detectCallback() {
        done(foundErr, foundTags);
      };
      if (!tagsFile) {
        return detectCallback();
      }
      // Find the first symbol in the list that matches a tag
      return _async2['default'].detectSeries(symbols, function (symbol, doneDetect) {
        _ctags2['default'].findTags(tagsFile, symbol, function (err, tags) {
          if (!tags) {
            tags = [];
          }
          if (err) {
            foundErr = err;
            doneDetect(false);
          } else if (tags.length) {
            for (var tag of Array.from(tags)) {
              tag.directory = projectPath;
            }
            foundTags = tags;
            doneDetect(true);
          } else {
            doneDetect(false);
          }
        });
      }, detectCallback);
    }, function (err, foundTags) {
      callback(err, _underscorePlus2['default'].flatten(foundTags));
    });
  },

  getAllTags: function getAllTags(callback) {
    var projectTags = [];
    var task = _atom.Task.once(handlerPath, atom.project.getPaths(), function () {
      return callback(projectTags);
    });
    task.on('tags', function (tags) {
      projectTags.push.apply(projectTags, _toConsumableArray(tags));
    });
    return task;
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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