"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareIssueCommentView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _timeago = _interopRequireDefault(require("../timeago"));

var _githubDotcomMarkdown = _interopRequireDefault(require("../github-dotcom-markdown"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareIssueCommentView extends _react.default.Component {
  render() {
    const comment = this.props.item;
    const author = comment.author;
    return _react.default.createElement("div", {
      className: "issue timeline-item"
    }, _react.default.createElement("div", {
      className: "info-row"
    }, _react.default.createElement(_octicon.default, {
      className: "pre-timeline-item-icon",
      icon: "comment"
    }), author && _react.default.createElement("img", {
      className: "author-avatar",
      src: author.avatarUrl,
      alt: comment.author.login,
      title: comment.author.login
    }), _react.default.createElement("span", {
      className: "comment-message-header"
    }, author ? author.login : 'someone', " commented", ' ', _react.default.createElement("a", {
      href: comment.url
    }, _react.default.createElement(_timeago.default, {
      time: comment.createdAt
    })))), _react.default.createElement(_githubDotcomMarkdown.default, {
      html: comment.bodyHTML,
      switchToIssueish: this.props.switchToIssueish
    }));
  }

}

exports.BareIssueCommentView = BareIssueCommentView;

_defineProperty(BareIssueCommentView, "propTypes", {
  switchToIssueish: _propTypes.default.func.isRequired,
  item: _propTypes.default.shape({
    author: _propTypes.default.shape({
      avatarUrl: _propTypes.default.string.isRequired,
      login: _propTypes.default.string.isRequired
    }),
    bodyHTML: _propTypes.default.string.isRequired,
    createdAt: _propTypes.default.string.isRequired,
    url: _propTypes.default.string.isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueCommentView, {
  item: function () {
    const node = require("./__generated__/issueCommentView_item.graphql");

    if (node.hash && node.hash !== "adc36c52f51de14256693ab9e4eb84bb") {
      console.error("The definition of 'issueCommentView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueCommentView_item.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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