"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BarePullRequestDetailView = exports.checkoutStates = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _reactTabs = require("react-tabs");

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

var _periodicRefresher = _interopRequireDefault(require("../periodic-refresher"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _prChangedFilesContainer = _interopRequireDefault(require("../containers/pr-changed-files-container"));

var _prTimelineController = _interopRequireDefault(require("../controllers/pr-timeline-controller"));

var _githubDotcomMarkdown = _interopRequireDefault(require("../views/github-dotcom-markdown"));

var _emojiReactionsView = _interopRequireDefault(require("../views/emoji-reactions-view"));

var _issueishBadge = _interopRequireDefault(require("../views/issueish-badge"));

var _prCommitsView = _interopRequireDefault(require("../views/pr-commits-view"));

var _prStatusesView = _interopRequireDefault(require("../views/pr-statuses-view"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CheckoutState {
  constructor(name) {
    this.name = name;
  }

  when(cases) {
    return cases[this.name] || cases.default;
  }

}

const checkoutStates = {
  HIDDEN: new CheckoutState('hidden'),
  DISABLED: new CheckoutState('disabled'),
  BUSY: new CheckoutState('busy'),
  CURRENT: new CheckoutState('current')
};
exports.checkoutStates = checkoutStates;

class BarePullRequestDetailView extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      refreshing: false
    });

    _defineProperty(this, "handleRefreshClick", e => {
      e.preventDefault();
      this.refresher.refreshNow(true);
    });

    _defineProperty(this, "recordOpenInBrowserEvent", () => {
      (0, _reporterProxy.addEvent)('open-pull-request-in-browser', {
        package: 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "recordOpenTabEvent", ind => {
      const eventName = ['open-pr-tab-overview', 'open-pr-tab-build-status', 'open-pr-tab-commits', 'open-pr-tab-files-changed'][ind];
      (0, _reporterProxy.addEvent)(eventName, {
        package: 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "refresh", () => {
      if (this.state.refreshing) {
        return;
      }

      this.setState({
        refreshing: true
      });
      this.props.relay.refetch({
        repoId: this.props.repository.id,
        issueishId: this.props.pullRequest.id,
        timelineCount: _helpers.PAGE_SIZE,
        timelineCursor: null,
        commitCount: _helpers.PAGE_SIZE,
        commitCursor: null,
        reviewCount: _helpers.PAGE_SIZE,
        reviewCursor: null,
        commentCount: _helpers.PAGE_SIZE,
        commentCursor: null
      }, null, () => {
        this.setState({
          refreshing: false
        });
      }, {
        force: true
      });
    });
  }

  componentDidMount() {
    this.refresher = new _periodicRefresher.default(BarePullRequestDetailView, {
      interval: () => 5 * 60 * 1000,
      getCurrentId: () => this.props.pullRequest.id,
      refresh: this.refresh,
      minimumIntervalPerId: 2 * 60 * 1000
    }); // auto-refresh disabled for now until pagination is handled
    // this.refresher.start();
  }

  componentWillUnmount() {
    this.refresher.destroy();
  }

  renderPrMetadata(pullRequest, repo) {
    return _react.default.createElement("span", {
      className: "github-IssueishDetailView-meta"
    }, _react.default.createElement("code", {
      className: "github-IssueishDetailView-baseRefName"
    }, pullRequest.isCrossRepository ? `${repo.owner.login}/${pullRequest.baseRefName}` : pullRequest.baseRefName), ' ‹ ', _react.default.createElement("code", {
      className: "github-IssueishDetailView-headRefName"
    }, pullRequest.isCrossRepository ? `${pullRequest.author.login}/${pullRequest.headRefName}` : pullRequest.headRefName));
  }

  renderPullRequestBody(pullRequest) {
    const onBranch = this.props.checkoutOp.why() === checkoutStates.CURRENT;
    return _react.default.createElement(_reactTabs.Tabs, {
      onSelect: this.recordOpenTabEvent
    }, _react.default.createElement(_reactTabs.TabList, {
      className: "github-IssueishDetailView-tablist"
    }, _react.default.createElement(_reactTabs.Tab, {
      className: "github-IssueishDetailView-tab"
    }, _react.default.createElement(_octicon.default, {
      icon: "info",
      className: "github-IssueishDetailView-tab-icon"
    }), "Overview"), _react.default.createElement(_reactTabs.Tab, {
      className: "github-IssueishDetailView-tab"
    }, _react.default.createElement(_octicon.default, {
      icon: "checklist",
      className: "github-IssueishDetailView-tab-icon"
    }), "Build Status"), _react.default.createElement(_reactTabs.Tab, {
      className: "github-IssueishDetailView-tab"
    }, _react.default.createElement(_octicon.default, {
      icon: "git-commit",
      className: "github-IssueishDetailView-tab-icon"
    }), "Commits", _react.default.createElement("span", {
      className: "github-IssueishDetailView-tab-count"
    }, pullRequest.countedCommits.totalCount)), _react.default.createElement(_reactTabs.Tab, {
      className: "github-IssueishDetailView-tab"
    }, _react.default.createElement(_octicon.default, {
      icon: "diff",
      className: "github-IssueishDetailView-tab-icon"
    }), "Files", _react.default.createElement("span", {
      className: "github-IssueishDetailView-tab-count"
    }, pullRequest.changedFiles))), _react.default.createElement(_reactTabs.TabPanel, null, _react.default.createElement("div", {
      className: "github-IssueishDetailView-overview"
    }, _react.default.createElement(_githubDotcomMarkdown.default, {
      html: pullRequest.bodyHTML || '<em>No description provided.</em>',
      switchToIssueish: this.props.switchToIssueish
    }), _react.default.createElement(_emojiReactionsView.default, {
      reactionGroups: pullRequest.reactionGroups
    }), _react.default.createElement(_prTimelineController.default, {
      onBranch: onBranch,
      openCommit: this.props.openCommit,
      pullRequest: pullRequest,
      switchToIssueish: this.props.switchToIssueish
    }))), _react.default.createElement(_reactTabs.TabPanel, null, _react.default.createElement("div", {
      className: "github-IssueishDetailView-buildStatus"
    }, _react.default.createElement(_prStatusesView.default, {
      pullRequest: pullRequest,
      displayType: "full"
    }))), _react.default.createElement(_reactTabs.TabPanel, null, _react.default.createElement(_prCommitsView.default, {
      pullRequest: pullRequest,
      onBranch: onBranch,
      openCommit: this.props.openCommit
    })), _react.default.createElement(_reactTabs.TabPanel, {
      className: "github-IssueishDetailView-filesChanged"
    }, _react.default.createElement(_prChangedFilesContainer.default, {
      localRepository: this.props.localRepository,
      owner: this.props.repository.owner.login,
      repo: this.props.repository.name,
      number: pullRequest.number,
      endpoint: this.props.endpoint,
      token: this.props.token,
      workspace: this.props.workspace,
      commands: this.props.commands,
      keymaps: this.props.keymaps,
      tooltips: this.props.tooltips,
      config: this.props.config,
      itemType: this.props.itemType,
      refEditor: this.props.refEditor,
      destroy: this.props.destroy,
      shouldRefetch: this.state.refreshing,
      switchToIssueish: this.props.switchToIssueish,
      pullRequest: this.props.pullRequest
    })));
  }

  render() {
    const repo = this.props.repository;
    const pullRequest = this.props.pullRequest;
    return _react.default.createElement("div", {
      className: "github-IssueishDetailView native-key-bindings"
    }, _react.default.createElement("div", {
      className: "github-IssueishDetailView-container"
    }, _react.default.createElement("header", {
      className: "github-IssueishDetailView-header"
    }, _react.default.createElement("div", {
      className: "github-IssueishDetailView-headerColumn"
    }, _react.default.createElement("a", {
      className: "github-IssueishDetailView-avatar",
      href: pullRequest.author.url
    }, _react.default.createElement("img", {
      className: "github-IssueishDetailView-avatarImage",
      src: pullRequest.author.avatarUrl,
      title: pullRequest.author.login,
      alt: pullRequest.author.login
    }))), _react.default.createElement("div", {
      className: "github-IssueishDetailView-headerColumn is-flexible"
    }, _react.default.createElement("div", {
      className: "github-IssueishDetailView-headerRow is-fullwidth"
    }, _react.default.createElement("a", {
      className: "github-IssueishDetailView-title",
      href: pullRequest.url
    }, pullRequest.title)), _react.default.createElement("div", {
      className: "github-IssueishDetailView-headerRow"
    }, _react.default.createElement(_issueishBadge.default, {
      className: "github-IssueishDetailView-headerBadge",
      type: pullRequest.__typename,
      state: pullRequest.state
    }), _react.default.createElement(_octicon.default, {
      icon: "repo-sync",
      className: (0, _classnames.default)('github-IssueishDetailView-headerRefreshButton', {
        refreshing: this.state.refreshing
      }),
      onClick: this.handleRefreshClick
    }), _react.default.createElement("a", {
      className: "github-IssueishDetailView-headerLink",
      title: "open on GitHub.com",
      href: pullRequest.url,
      onClick: this.recordOpenInBrowserEvent
    }, repo.owner.login, "/", repo.name, "#", pullRequest.number), _react.default.createElement("span", {
      className: "github-IssueishDetailView-headerStatus"
    }, _react.default.createElement(_prStatusesView.default, {
      pullRequest: pullRequest,
      displayType: "check"
    }))), _react.default.createElement("div", {
      className: "github-IssueishDetailView-headerRow"
    }, this.renderPrMetadata(pullRequest, repo))), _react.default.createElement("div", {
      className: "github-IssueishDetailView-headerColumn"
    }, this.renderCheckoutButton())), this.renderPullRequestBody(pullRequest), _react.default.createElement("footer", {
      className: "github-IssueishDetailView-footer"
    }, _react.default.createElement("a", {
      className: "github-IssueishDetailView-footerLink icon icon-mark-github",
      href: pullRequest.url
    }, repo.owner.login, "/", repo.name, "#", pullRequest.number))));
  }

  renderCheckoutButton() {
    const {
      checkoutOp
    } = this.props;
    let extraClass = null;
    let buttonText = 'Checkout';
    let buttonTitle = null;

    if (!checkoutOp.isEnabled()) {
      buttonTitle = checkoutOp.getMessage();
      const reason = checkoutOp.why();

      if (reason === checkoutStates.HIDDEN) {
        return null;
      }

      buttonText = reason.when({
        current: 'Checked out',
        default: 'Checkout'
      });
      extraClass = 'github-IssueishDetailView-checkoutButton--' + reason.when({
        disabled: 'disabled',
        busy: 'busy',
        current: 'current'
      });
    }

    const classNames = (0, _classnames.default)('btn', 'btn-primary', 'github-IssueishDetailView-checkoutButton', extraClass);
    return _react.default.createElement("button", {
      className: classNames,
      disabled: !checkoutOp.isEnabled(),
      title: buttonTitle,
      onClick: () => checkoutOp.run()
    }, buttonText);
  }

}

exports.BarePullRequestDetailView = BarePullRequestDetailView;

_defineProperty(BarePullRequestDetailView, "propTypes", {
  // Relay response
  relay: _propTypes.default.shape({
    refetch: _propTypes.default.func.isRequired
  }),
  switchToIssueish: _propTypes.default.func.isRequired,
  checkoutOp: _propTypes2.EnableableOperationPropType.isRequired,
  repository: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    name: _propTypes.default.string.isRequired,
    owner: _propTypes.default.shape({
      login: _propTypes.default.string
    })
  }),
  pullRequest: _propTypes.default.shape({
    __typename: _propTypes.default.string.isRequired,
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string,
    countedCommits: _propTypes.default.shape({
      totalCount: _propTypes.default.number.isRequired
    }).isRequired,
    isCrossRepository: _propTypes.default.bool,
    changedFiles: _propTypes.default.number.isRequired,
    url: _propTypes.default.string.isRequired,
    bodyHTML: _propTypes.default.string,
    number: _propTypes.default.number,
    state: _propTypes.default.oneOf(['OPEN', 'CLOSED', 'MERGED']).isRequired,
    author: _propTypes.default.shape({
      login: _propTypes.default.string.isRequired,
      avatarUrl: _propTypes.default.string.isRequired,
      url: _propTypes.default.string.isRequired
    }).isRequired,
    reactionGroups: _propTypes.default.arrayOf(_propTypes.default.shape({
      content: _propTypes.default.string.isRequired,
      users: _propTypes.default.shape({
        totalCount: _propTypes.default.number.isRequired
      }).isRequired
    })).isRequired
  }).isRequired,
  // Local model objects
  localRepository: _propTypes.default.object.isRequired,
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes.default.string.isRequired,
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  keymaps: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  // Action functions
  openCommit: _propTypes.default.func.isRequired,
  destroy: _propTypes.default.func.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  refEditor: _propTypes2.RefHolderPropType.isRequired
});

var _default = (0, _reactRelay.createRefetchContainer)(BarePullRequestDetailView, {
  repository: function () {
    const node = require("./__generated__/prDetailView_repository.graphql");

    if (node.hash && node.hash !== "3f3d61ddd6afa1c9e0811c3b5be51bb0") {
      console.error("The definition of 'prDetailView_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prDetailView_repository.graphql");
  },
  pullRequest: function () {
    const node = require("./__generated__/prDetailView_pullRequest.graphql");

    if (node.hash && node.hash !== "e3868f3180aae27226fe92ba6f444412") {
      console.error("The definition of 'prDetailView_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prDetailView_pullRequest.graphql");
  }
}, function () {
  const node = require("./__generated__/prDetailViewRefetchQuery.graphql");

  if (node.hash && node.hash !== "bbddc1ac39ae868ae2b12317af98efa4") {
    console.error("The definition of 'prDetailViewRefetchQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/prDetailViewRefetchQuery.graphql");
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInByLWRldGFpbC12aWV3LmpzIl0sIm5hbWVzIjpbIkNoZWNrb3V0U3RhdGUiLCJjb25zdHJ1Y3RvciIsIm5hbWUiLCJ3aGVuIiwiY2FzZXMiLCJkZWZhdWx0IiwiY2hlY2tvdXRTdGF0ZXMiLCJISURERU4iLCJESVNBQkxFRCIsIkJVU1kiLCJDVVJSRU5UIiwiQmFyZVB1bGxSZXF1ZXN0RGV0YWlsVmlldyIsIlJlYWN0IiwiQ29tcG9uZW50IiwicmVmcmVzaGluZyIsImUiLCJwcmV2ZW50RGVmYXVsdCIsInJlZnJlc2hlciIsInJlZnJlc2hOb3ciLCJwYWNrYWdlIiwiY29tcG9uZW50IiwiaW5kIiwiZXZlbnROYW1lIiwic3RhdGUiLCJzZXRTdGF0ZSIsInByb3BzIiwicmVsYXkiLCJyZWZldGNoIiwicmVwb0lkIiwicmVwb3NpdG9yeSIsImlkIiwiaXNzdWVpc2hJZCIsInB1bGxSZXF1ZXN0IiwidGltZWxpbmVDb3VudCIsIlBBR0VfU0laRSIsInRpbWVsaW5lQ3Vyc29yIiwiY29tbWl0Q291bnQiLCJjb21taXRDdXJzb3IiLCJyZXZpZXdDb3VudCIsInJldmlld0N1cnNvciIsImNvbW1lbnRDb3VudCIsImNvbW1lbnRDdXJzb3IiLCJmb3JjZSIsImNvbXBvbmVudERpZE1vdW50IiwiUGVyaW9kaWNSZWZyZXNoZXIiLCJpbnRlcnZhbCIsImdldEN1cnJlbnRJZCIsInJlZnJlc2giLCJtaW5pbXVtSW50ZXJ2YWxQZXJJZCIsImNvbXBvbmVudFdpbGxVbm1vdW50IiwiZGVzdHJveSIsInJlbmRlclByTWV0YWRhdGEiLCJyZXBvIiwiaXNDcm9zc1JlcG9zaXRvcnkiLCJvd25lciIsImxvZ2luIiwiYmFzZVJlZk5hbWUiLCJhdXRob3IiLCJoZWFkUmVmTmFtZSIsInJlbmRlclB1bGxSZXF1ZXN0Qm9keSIsIm9uQnJhbmNoIiwiY2hlY2tvdXRPcCIsIndoeSIsInJlY29yZE9wZW5UYWJFdmVudCIsImNvdW50ZWRDb21taXRzIiwidG90YWxDb3VudCIsImNoYW5nZWRGaWxlcyIsImJvZHlIVE1MIiwic3dpdGNoVG9Jc3N1ZWlzaCIsInJlYWN0aW9uR3JvdXBzIiwib3BlbkNvbW1pdCIsImxvY2FsUmVwb3NpdG9yeSIsIm51bWJlciIsImVuZHBvaW50IiwidG9rZW4iLCJ3b3Jrc3BhY2UiLCJjb21tYW5kcyIsImtleW1hcHMiLCJ0b29sdGlwcyIsImNvbmZpZyIsIml0ZW1UeXBlIiwicmVmRWRpdG9yIiwicmVuZGVyIiwidXJsIiwiYXZhdGFyVXJsIiwidGl0bGUiLCJfX3R5cGVuYW1lIiwiaGFuZGxlUmVmcmVzaENsaWNrIiwicmVjb3JkT3BlbkluQnJvd3NlckV2ZW50IiwicmVuZGVyQ2hlY2tvdXRCdXR0b24iLCJleHRyYUNsYXNzIiwiYnV0dG9uVGV4dCIsImJ1dHRvblRpdGxlIiwiaXNFbmFibGVkIiwiZ2V0TWVzc2FnZSIsInJlYXNvbiIsImN1cnJlbnQiLCJkaXNhYmxlZCIsImJ1c3kiLCJjbGFzc05hbWVzIiwicnVuIiwiUHJvcFR5cGVzIiwic2hhcGUiLCJmdW5jIiwiaXNSZXF1aXJlZCIsIkVuYWJsZWFibGVPcGVyYXRpb25Qcm9wVHlwZSIsInN0cmluZyIsImJvb2wiLCJvbmVPZiIsImFycmF5T2YiLCJjb250ZW50IiwidXNlcnMiLCJvYmplY3QiLCJFbmRwb2ludFByb3BUeXBlIiwiSXRlbVR5cGVQcm9wVHlwZSIsIlJlZkhvbGRlclByb3BUeXBlIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBRUE7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7Ozs7OztBQUVBLE1BQU1BLGFBQU4sQ0FBb0I7QUFDbEJDLEVBQUFBLFdBQVcsQ0FBQ0MsSUFBRCxFQUFPO0FBQ2hCLFNBQUtBLElBQUwsR0FBWUEsSUFBWjtBQUNEOztBQUVEQyxFQUFBQSxJQUFJLENBQUNDLEtBQUQsRUFBUTtBQUNWLFdBQU9BLEtBQUssQ0FBQyxLQUFLRixJQUFOLENBQUwsSUFBb0JFLEtBQUssQ0FBQ0MsT0FBakM7QUFDRDs7QUFQaUI7O0FBVWIsTUFBTUMsY0FBYyxHQUFHO0FBQzVCQyxFQUFBQSxNQUFNLEVBQUUsSUFBSVAsYUFBSixDQUFrQixRQUFsQixDQURvQjtBQUU1QlEsRUFBQUEsUUFBUSxFQUFFLElBQUlSLGFBQUosQ0FBa0IsVUFBbEIsQ0FGa0I7QUFHNUJTLEVBQUFBLElBQUksRUFBRSxJQUFJVCxhQUFKLENBQWtCLE1BQWxCLENBSHNCO0FBSTVCVSxFQUFBQSxPQUFPLEVBQUUsSUFBSVYsYUFBSixDQUFrQixTQUFsQjtBQUptQixDQUF2Qjs7O0FBT0EsTUFBTVcseUJBQU4sU0FBd0NDLGVBQU1DLFNBQTlDLENBQXdEO0FBQUE7QUFBQTs7QUFBQSxtQ0FvRXJEO0FBQ05DLE1BQUFBLFVBQVUsRUFBRTtBQUROLEtBcEVxRDs7QUFBQSxnREFpU3hDQyxDQUFDLElBQUk7QUFDeEJBLE1BQUFBLENBQUMsQ0FBQ0MsY0FBRjtBQUNBLFdBQUtDLFNBQUwsQ0FBZUMsVUFBZixDQUEwQixJQUExQjtBQUNELEtBcFM0RDs7QUFBQSxzREFzU2xDLE1BQU07QUFDL0IsbUNBQVMsOEJBQVQsRUFBeUM7QUFBQ0MsUUFBQUEsT0FBTyxFQUFFLFFBQVY7QUFBb0JDLFFBQUFBLFNBQVMsRUFBRSxLQUFLbkIsV0FBTCxDQUFpQkM7QUFBaEQsT0FBekM7QUFDRCxLQXhTNEQ7O0FBQUEsZ0RBMFN4Q21CLEdBQUcsSUFBSTtBQUMxQixZQUFNQyxTQUFTLEdBQUcsQ0FDaEIsc0JBRGdCLEVBRWhCLDBCQUZnQixFQUdoQixxQkFIZ0IsRUFJaEIsMkJBSmdCLEVBS2hCRCxHQUxnQixDQUFsQjtBQU1BLG1DQUFTQyxTQUFULEVBQW9CO0FBQUNILFFBQUFBLE9BQU8sRUFBRSxRQUFWO0FBQW9CQyxRQUFBQSxTQUFTLEVBQUUsS0FBS25CLFdBQUwsQ0FBaUJDO0FBQWhELE9BQXBCO0FBQ0QsS0FsVDREOztBQUFBLHFDQW9UbkQsTUFBTTtBQUNkLFVBQUksS0FBS3FCLEtBQUwsQ0FBV1QsVUFBZixFQUEyQjtBQUN6QjtBQUNEOztBQUVELFdBQUtVLFFBQUwsQ0FBYztBQUFDVixRQUFBQSxVQUFVLEVBQUU7QUFBYixPQUFkO0FBQ0EsV0FBS1csS0FBTCxDQUFXQyxLQUFYLENBQWlCQyxPQUFqQixDQUF5QjtBQUN2QkMsUUFBQUEsTUFBTSxFQUFFLEtBQUtILEtBQUwsQ0FBV0ksVUFBWCxDQUFzQkMsRUFEUDtBQUV2QkMsUUFBQUEsVUFBVSxFQUFFLEtBQUtOLEtBQUwsQ0FBV08sV0FBWCxDQUF1QkYsRUFGWjtBQUd2QkcsUUFBQUEsYUFBYSxFQUFFQyxrQkFIUTtBQUl2QkMsUUFBQUEsY0FBYyxFQUFFLElBSk87QUFLdkJDLFFBQUFBLFdBQVcsRUFBRUYsa0JBTFU7QUFNdkJHLFFBQUFBLFlBQVksRUFBRSxJQU5TO0FBT3ZCQyxRQUFBQSxXQUFXLEVBQUVKLGtCQVBVO0FBUXZCSyxRQUFBQSxZQUFZLEVBQUUsSUFSUztBQVN2QkMsUUFBQUEsWUFBWSxFQUFFTixrQkFUUztBQVV2Qk8sUUFBQUEsYUFBYSxFQUFFO0FBVlEsT0FBekIsRUFXRyxJQVhILEVBV1MsTUFBTTtBQUNiLGFBQUtqQixRQUFMLENBQWM7QUFBQ1YsVUFBQUEsVUFBVSxFQUFFO0FBQWIsU0FBZDtBQUNELE9BYkQsRUFhRztBQUFDNEIsUUFBQUEsS0FBSyxFQUFFO0FBQVIsT0FiSDtBQWNELEtBeFU0RDtBQUFBOztBQXdFN0RDLEVBQUFBLGlCQUFpQixHQUFHO0FBQ2xCLFNBQUsxQixTQUFMLEdBQWlCLElBQUkyQiwwQkFBSixDQUFzQmpDLHlCQUF0QixFQUFpRDtBQUNoRWtDLE1BQUFBLFFBQVEsRUFBRSxNQUFNLElBQUksRUFBSixHQUFTLElBRHVDO0FBRWhFQyxNQUFBQSxZQUFZLEVBQUUsTUFBTSxLQUFLckIsS0FBTCxDQUFXTyxXQUFYLENBQXVCRixFQUZxQjtBQUdoRWlCLE1BQUFBLE9BQU8sRUFBRSxLQUFLQSxPQUhrRDtBQUloRUMsTUFBQUEsb0JBQW9CLEVBQUUsSUFBSSxFQUFKLEdBQVM7QUFKaUMsS0FBakQsQ0FBakIsQ0FEa0IsQ0FPbEI7QUFDQTtBQUNEOztBQUVEQyxFQUFBQSxvQkFBb0IsR0FBRztBQUNyQixTQUFLaEMsU0FBTCxDQUFlaUMsT0FBZjtBQUNEOztBQUVEQyxFQUFBQSxnQkFBZ0IsQ0FBQ25CLFdBQUQsRUFBY29CLElBQWQsRUFBb0I7QUFDbEMsV0FDRTtBQUFNLE1BQUEsU0FBUyxFQUFDO0FBQWhCLE9BQ0U7QUFBTSxNQUFBLFNBQVMsRUFBQztBQUFoQixPQUF5RHBCLFdBQVcsQ0FBQ3FCLGlCQUFaLEdBQ3RELEdBQUVELElBQUksQ0FBQ0UsS0FBTCxDQUFXQyxLQUFNLElBQUd2QixXQUFXLENBQUN3QixXQUFZLEVBRFEsR0FDSnhCLFdBQVcsQ0FBQ3dCLFdBRGpFLENBREYsRUFFdUYsS0FGdkYsRUFHRTtBQUFNLE1BQUEsU0FBUyxFQUFDO0FBQWhCLE9BQXlEeEIsV0FBVyxDQUFDcUIsaUJBQVosR0FDdEQsR0FBRXJCLFdBQVcsQ0FBQ3lCLE1BQVosQ0FBbUJGLEtBQU0sSUFBR3ZCLFdBQVcsQ0FBQzBCLFdBQVksRUFEQSxHQUNJMUIsV0FBVyxDQUFDMEIsV0FEekUsQ0FIRixDQURGO0FBUUQ7O0FBRURDLEVBQUFBLHFCQUFxQixDQUFDM0IsV0FBRCxFQUFjO0FBQ2pDLFVBQU00QixRQUFRLEdBQUcsS0FBS25DLEtBQUwsQ0FBV29DLFVBQVgsQ0FBc0JDLEdBQXRCLE9BQWdDeEQsY0FBYyxDQUFDSSxPQUFoRTtBQUVBLFdBQ0UsNkJBQUMsZUFBRDtBQUFNLE1BQUEsUUFBUSxFQUFFLEtBQUtxRDtBQUFyQixPQUNFLDZCQUFDLGtCQUFEO0FBQVMsTUFBQSxTQUFTLEVBQUM7QUFBbkIsT0FDRSw2QkFBQyxjQUFEO0FBQUssTUFBQSxTQUFTLEVBQUM7QUFBZixPQUNFLDZCQUFDLGdCQUFEO0FBQVMsTUFBQSxJQUFJLEVBQUMsTUFBZDtBQUFxQixNQUFBLFNBQVMsRUFBQztBQUEvQixNQURGLGFBREYsRUFHRSw2QkFBQyxjQUFEO0FBQUssTUFBQSxTQUFTLEVBQUM7QUFBZixPQUNFLDZCQUFDLGdCQUFEO0FBQVMsTUFBQSxJQUFJLEVBQUMsV0FBZDtBQUEwQixNQUFBLFNBQVMsRUFBQztBQUFwQyxNQURGLGlCQUhGLEVBT0UsNkJBQUMsY0FBRDtBQUFLLE1BQUEsU0FBUyxFQUFDO0FBQWYsT0FDRSw2QkFBQyxnQkFBRDtBQUFTLE1BQUEsSUFBSSxFQUFDLFlBQWQ7QUFDRSxNQUFBLFNBQVMsRUFBQztBQURaLE1BREYsYUFLRTtBQUFNLE1BQUEsU0FBUyxFQUFDO0FBQWhCLE9BQXVEL0IsV0FBVyxDQUFDZ0MsY0FBWixDQUEyQkMsVUFBbEYsQ0FMRixDQVBGLEVBY0UsNkJBQUMsY0FBRDtBQUFLLE1BQUEsU0FBUyxFQUFDO0FBQWYsT0FDRSw2QkFBQyxnQkFBRDtBQUFTLE1BQUEsSUFBSSxFQUFDLE1BQWQ7QUFDRSxNQUFBLFNBQVMsRUFBQztBQURaLE1BREYsV0FJUztBQUFNLE1BQUEsU0FBUyxFQUFDO0FBQWhCLE9BQXVEakMsV0FBVyxDQUFDa0MsWUFBbkUsQ0FKVCxDQWRGLENBREYsRUF5QkUsNkJBQUMsbUJBQUQsUUFDRTtBQUFLLE1BQUEsU0FBUyxFQUFDO0FBQWYsT0FDRSw2QkFBQyw2QkFBRDtBQUNFLE1BQUEsSUFBSSxFQUFFbEMsV0FBVyxDQUFDbUMsUUFBWixJQUF3QixtQ0FEaEM7QUFFRSxNQUFBLGdCQUFnQixFQUFFLEtBQUsxQyxLQUFMLENBQVcyQztBQUYvQixNQURGLEVBS0UsNkJBQUMsMkJBQUQ7QUFBb0IsTUFBQSxjQUFjLEVBQUVwQyxXQUFXLENBQUNxQztBQUFoRCxNQUxGLEVBTUUsNkJBQUMsNkJBQUQ7QUFDRSxNQUFBLFFBQVEsRUFBRVQsUUFEWjtBQUVFLE1BQUEsVUFBVSxFQUFFLEtBQUtuQyxLQUFMLENBQVc2QyxVQUZ6QjtBQUdFLE1BQUEsV0FBVyxFQUFFdEMsV0FIZjtBQUlFLE1BQUEsZ0JBQWdCLEVBQUUsS0FBS1AsS0FBTCxDQUFXMkM7QUFKL0IsTUFORixDQURGLENBekJGLEVBMENFLDZCQUFDLG1CQUFELFFBQ0U7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BQ0UsNkJBQUMsdUJBQUQ7QUFBZ0IsTUFBQSxXQUFXLEVBQUVwQyxXQUE3QjtBQUEwQyxNQUFBLFdBQVcsRUFBQztBQUF0RCxNQURGLENBREYsQ0ExQ0YsRUFpREUsNkJBQUMsbUJBQUQsUUFDRSw2QkFBQyxzQkFBRDtBQUFlLE1BQUEsV0FBVyxFQUFFQSxXQUE1QjtBQUF5QyxNQUFBLFFBQVEsRUFBRTRCLFFBQW5EO0FBQTZELE1BQUEsVUFBVSxFQUFFLEtBQUtuQyxLQUFMLENBQVc2QztBQUFwRixNQURGLENBakRGLEVBc0RFLDZCQUFDLG1CQUFEO0FBQVUsTUFBQSxTQUFTLEVBQUM7QUFBcEIsT0FDRSw2QkFBQyxnQ0FBRDtBQUNFLE1BQUEsZUFBZSxFQUFFLEtBQUs3QyxLQUFMLENBQVc4QyxlQUQ5QjtBQUdFLE1BQUEsS0FBSyxFQUFFLEtBQUs5QyxLQUFMLENBQVdJLFVBQVgsQ0FBc0J5QixLQUF0QixDQUE0QkMsS0FIckM7QUFJRSxNQUFBLElBQUksRUFBRSxLQUFLOUIsS0FBTCxDQUFXSSxVQUFYLENBQXNCM0IsSUFKOUI7QUFLRSxNQUFBLE1BQU0sRUFBRThCLFdBQVcsQ0FBQ3dDLE1BTHRCO0FBT0UsTUFBQSxRQUFRLEVBQUUsS0FBSy9DLEtBQUwsQ0FBV2dELFFBUHZCO0FBUUUsTUFBQSxLQUFLLEVBQUUsS0FBS2hELEtBQUwsQ0FBV2lELEtBUnBCO0FBVUUsTUFBQSxTQUFTLEVBQUUsS0FBS2pELEtBQUwsQ0FBV2tELFNBVnhCO0FBV0UsTUFBQSxRQUFRLEVBQUUsS0FBS2xELEtBQUwsQ0FBV21ELFFBWHZCO0FBWUUsTUFBQSxPQUFPLEVBQUUsS0FBS25ELEtBQUwsQ0FBV29ELE9BWnRCO0FBYUUsTUFBQSxRQUFRLEVBQUUsS0FBS3BELEtBQUwsQ0FBV3FELFFBYnZCO0FBY0UsTUFBQSxNQUFNLEVBQUUsS0FBS3JELEtBQUwsQ0FBV3NELE1BZHJCO0FBZ0JFLE1BQUEsUUFBUSxFQUFFLEtBQUt0RCxLQUFMLENBQVd1RCxRQWhCdkI7QUFpQkUsTUFBQSxTQUFTLEVBQUUsS0FBS3ZELEtBQUwsQ0FBV3dELFNBakJ4QjtBQWtCRSxNQUFBLE9BQU8sRUFBRSxLQUFLeEQsS0FBTCxDQUFXeUIsT0FsQnRCO0FBb0JFLE1BQUEsYUFBYSxFQUFFLEtBQUszQixLQUFMLENBQVdULFVBcEI1QjtBQXFCRSxNQUFBLGdCQUFnQixFQUFFLEtBQUtXLEtBQUwsQ0FBVzJDLGdCQXJCL0I7QUF1QkUsTUFBQSxXQUFXLEVBQUUsS0FBSzNDLEtBQUwsQ0FBV087QUF2QjFCLE1BREYsQ0F0REYsQ0FERjtBQW9GRDs7QUFFRGtELEVBQUFBLE1BQU0sR0FBRztBQUNQLFVBQU05QixJQUFJLEdBQUcsS0FBSzNCLEtBQUwsQ0FBV0ksVUFBeEI7QUFDQSxVQUFNRyxXQUFXLEdBQUcsS0FBS1AsS0FBTCxDQUFXTyxXQUEvQjtBQUVBLFdBQ0U7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BQ0U7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BRUU7QUFBUSxNQUFBLFNBQVMsRUFBQztBQUFsQixPQUNFO0FBQUssTUFBQSxTQUFTLEVBQUM7QUFBZixPQUNFO0FBQUcsTUFBQSxTQUFTLEVBQUMsa0NBQWI7QUFBZ0QsTUFBQSxJQUFJLEVBQUVBLFdBQVcsQ0FBQ3lCLE1BQVosQ0FBbUIwQjtBQUF6RSxPQUNFO0FBQUssTUFBQSxTQUFTLEVBQUMsdUNBQWY7QUFDRSxNQUFBLEdBQUcsRUFBRW5ELFdBQVcsQ0FBQ3lCLE1BQVosQ0FBbUIyQixTQUQxQjtBQUVFLE1BQUEsS0FBSyxFQUFFcEQsV0FBVyxDQUFDeUIsTUFBWixDQUFtQkYsS0FGNUI7QUFHRSxNQUFBLEdBQUcsRUFBRXZCLFdBQVcsQ0FBQ3lCLE1BQVosQ0FBbUJGO0FBSDFCLE1BREYsQ0FERixDQURGLEVBV0U7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BQ0U7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BQ0U7QUFBRyxNQUFBLFNBQVMsRUFBQyxpQ0FBYjtBQUErQyxNQUFBLElBQUksRUFBRXZCLFdBQVcsQ0FBQ21EO0FBQWpFLE9BQXVFbkQsV0FBVyxDQUFDcUQsS0FBbkYsQ0FERixDQURGLEVBSUU7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BQ0UsNkJBQUMsc0JBQUQ7QUFBZSxNQUFBLFNBQVMsRUFBQyx1Q0FBekI7QUFDRSxNQUFBLElBQUksRUFBRXJELFdBQVcsQ0FBQ3NELFVBRHBCO0FBRUUsTUFBQSxLQUFLLEVBQUV0RCxXQUFXLENBQUNUO0FBRnJCLE1BREYsRUFLRSw2QkFBQyxnQkFBRDtBQUNFLE1BQUEsSUFBSSxFQUFDLFdBRFA7QUFFRSxNQUFBLFNBQVMsRUFBRSx5QkFBRywrQ0FBSCxFQUFvRDtBQUFDVCxRQUFBQSxVQUFVLEVBQUUsS0FBS1MsS0FBTCxDQUFXVDtBQUF4QixPQUFwRCxDQUZiO0FBR0UsTUFBQSxPQUFPLEVBQUUsS0FBS3lFO0FBSGhCLE1BTEYsRUFVRTtBQUFHLE1BQUEsU0FBUyxFQUFDLHNDQUFiO0FBQ0UsTUFBQSxLQUFLLEVBQUMsb0JBRFI7QUFFRSxNQUFBLElBQUksRUFBRXZELFdBQVcsQ0FBQ21ELEdBRnBCO0FBRXlCLE1BQUEsT0FBTyxFQUFFLEtBQUtLO0FBRnZDLE9BR0dwQyxJQUFJLENBQUNFLEtBQUwsQ0FBV0MsS0FIZCxPQUdzQkgsSUFBSSxDQUFDbEQsSUFIM0IsT0FHa0M4QixXQUFXLENBQUN3QyxNQUg5QyxDQVZGLEVBZUU7QUFBTSxNQUFBLFNBQVMsRUFBQztBQUFoQixPQUNFLDZCQUFDLHVCQUFEO0FBQWdCLE1BQUEsV0FBVyxFQUFFeEMsV0FBN0I7QUFBMEMsTUFBQSxXQUFXLEVBQUM7QUFBdEQsTUFERixDQWZGLENBSkYsRUF1QkU7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BQ0csS0FBS21CLGdCQUFMLENBQXNCbkIsV0FBdEIsRUFBbUNvQixJQUFuQyxDQURILENBdkJGLENBWEYsRUF1Q0U7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BQ0csS0FBS3FDLG9CQUFMLEVBREgsQ0F2Q0YsQ0FGRixFQThDRyxLQUFLOUIscUJBQUwsQ0FBMkIzQixXQUEzQixDQTlDSCxFQWdERTtBQUFRLE1BQUEsU0FBUyxFQUFDO0FBQWxCLE9BQ0U7QUFBRyxNQUFBLFNBQVMsRUFBQyw0REFBYjtBQUNFLE1BQUEsSUFBSSxFQUFFQSxXQUFXLENBQUNtRDtBQURwQixPQUMwQi9CLElBQUksQ0FBQ0UsS0FBTCxDQUFXQyxLQURyQyxPQUM2Q0gsSUFBSSxDQUFDbEQsSUFEbEQsT0FDeUQ4QixXQUFXLENBQUN3QyxNQURyRSxDQURGLENBaERGLENBREYsQ0FERjtBQTJERDs7QUFFRGlCLEVBQUFBLG9CQUFvQixHQUFHO0FBQ3JCLFVBQU07QUFBQzVCLE1BQUFBO0FBQUQsUUFBZSxLQUFLcEMsS0FBMUI7QUFDQSxRQUFJaUUsVUFBVSxHQUFHLElBQWpCO0FBQ0EsUUFBSUMsVUFBVSxHQUFHLFVBQWpCO0FBQ0EsUUFBSUMsV0FBVyxHQUFHLElBQWxCOztBQUVBLFFBQUksQ0FBQy9CLFVBQVUsQ0FBQ2dDLFNBQVgsRUFBTCxFQUE2QjtBQUMzQkQsTUFBQUEsV0FBVyxHQUFHL0IsVUFBVSxDQUFDaUMsVUFBWCxFQUFkO0FBQ0EsWUFBTUMsTUFBTSxHQUFHbEMsVUFBVSxDQUFDQyxHQUFYLEVBQWY7O0FBQ0EsVUFBSWlDLE1BQU0sS0FBS3pGLGNBQWMsQ0FBQ0MsTUFBOUIsRUFBc0M7QUFDcEMsZUFBTyxJQUFQO0FBQ0Q7O0FBRURvRixNQUFBQSxVQUFVLEdBQUdJLE1BQU0sQ0FBQzVGLElBQVAsQ0FBWTtBQUN2QjZGLFFBQUFBLE9BQU8sRUFBRSxhQURjO0FBRXZCM0YsUUFBQUEsT0FBTyxFQUFFO0FBRmMsT0FBWixDQUFiO0FBS0FxRixNQUFBQSxVQUFVLEdBQUcsK0NBQStDSyxNQUFNLENBQUM1RixJQUFQLENBQVk7QUFDdEU4RixRQUFBQSxRQUFRLEVBQUUsVUFENEQ7QUFFdEVDLFFBQUFBLElBQUksRUFBRSxNQUZnRTtBQUd0RUYsUUFBQUEsT0FBTyxFQUFFO0FBSDZELE9BQVosQ0FBNUQ7QUFLRDs7QUFFRCxVQUFNRyxVQUFVLEdBQUcseUJBQUcsS0FBSCxFQUFVLGFBQVYsRUFBeUIsMENBQXpCLEVBQXFFVCxVQUFyRSxDQUFuQjtBQUNBLFdBQ0U7QUFDRSxNQUFBLFNBQVMsRUFBRVMsVUFEYjtBQUVFLE1BQUEsUUFBUSxFQUFFLENBQUN0QyxVQUFVLENBQUNnQyxTQUFYLEVBRmI7QUFHRSxNQUFBLEtBQUssRUFBRUQsV0FIVDtBQUlFLE1BQUEsT0FBTyxFQUFFLE1BQU0vQixVQUFVLENBQUN1QyxHQUFYO0FBSmpCLE9BS0dULFVBTEgsQ0FERjtBQVNEOztBQS9SNEQ7Ozs7Z0JBQWxEaEYseUIsZUFDUTtBQUNqQjtBQUNBZSxFQUFBQSxLQUFLLEVBQUUyRSxtQkFBVUMsS0FBVixDQUFnQjtBQUNyQjNFLElBQUFBLE9BQU8sRUFBRTBFLG1CQUFVRSxJQUFWLENBQWVDO0FBREgsR0FBaEIsQ0FGVTtBQUtqQnBDLEVBQUFBLGdCQUFnQixFQUFFaUMsbUJBQVVFLElBQVYsQ0FBZUMsVUFMaEI7QUFNakIzQyxFQUFBQSxVQUFVLEVBQUU0Qyx3Q0FBNEJELFVBTnZCO0FBT2pCM0UsRUFBQUEsVUFBVSxFQUFFd0UsbUJBQVVDLEtBQVYsQ0FBZ0I7QUFDMUJ4RSxJQUFBQSxFQUFFLEVBQUV1RSxtQkFBVUssTUFBVixDQUFpQkYsVUFESztBQUUxQnRHLElBQUFBLElBQUksRUFBRW1HLG1CQUFVSyxNQUFWLENBQWlCRixVQUZHO0FBRzFCbEQsSUFBQUEsS0FBSyxFQUFFK0MsbUJBQVVDLEtBQVYsQ0FBZ0I7QUFDckIvQyxNQUFBQSxLQUFLLEVBQUU4QyxtQkFBVUs7QUFESSxLQUFoQjtBQUhtQixHQUFoQixDQVBLO0FBY2pCMUUsRUFBQUEsV0FBVyxFQUFFcUUsbUJBQVVDLEtBQVYsQ0FBZ0I7QUFDM0JoQixJQUFBQSxVQUFVLEVBQUVlLG1CQUFVSyxNQUFWLENBQWlCRixVQURGO0FBRTNCMUUsSUFBQUEsRUFBRSxFQUFFdUUsbUJBQVVLLE1BQVYsQ0FBaUJGLFVBRk07QUFHM0JuQixJQUFBQSxLQUFLLEVBQUVnQixtQkFBVUssTUFIVTtBQUkzQjFDLElBQUFBLGNBQWMsRUFBRXFDLG1CQUFVQyxLQUFWLENBQWdCO0FBQzlCckMsTUFBQUEsVUFBVSxFQUFFb0MsbUJBQVU3QixNQUFWLENBQWlCZ0M7QUFEQyxLQUFoQixFQUViQSxVQU53QjtBQU8zQm5ELElBQUFBLGlCQUFpQixFQUFFZ0QsbUJBQVVNLElBUEY7QUFRM0J6QyxJQUFBQSxZQUFZLEVBQUVtQyxtQkFBVTdCLE1BQVYsQ0FBaUJnQyxVQVJKO0FBUzNCckIsSUFBQUEsR0FBRyxFQUFFa0IsbUJBQVVLLE1BQVYsQ0FBaUJGLFVBVEs7QUFVM0JyQyxJQUFBQSxRQUFRLEVBQUVrQyxtQkFBVUssTUFWTztBQVczQmxDLElBQUFBLE1BQU0sRUFBRTZCLG1CQUFVN0IsTUFYUztBQVkzQmpELElBQUFBLEtBQUssRUFBRThFLG1CQUFVTyxLQUFWLENBQWdCLENBQ3JCLE1BRHFCLEVBQ2IsUUFEYSxFQUNILFFBREcsQ0FBaEIsRUFFSkosVUFkd0I7QUFlM0IvQyxJQUFBQSxNQUFNLEVBQUU0QyxtQkFBVUMsS0FBVixDQUFnQjtBQUN0Qi9DLE1BQUFBLEtBQUssRUFBRThDLG1CQUFVSyxNQUFWLENBQWlCRixVQURGO0FBRXRCcEIsTUFBQUEsU0FBUyxFQUFFaUIsbUJBQVVLLE1BQVYsQ0FBaUJGLFVBRk47QUFHdEJyQixNQUFBQSxHQUFHLEVBQUVrQixtQkFBVUssTUFBVixDQUFpQkY7QUFIQSxLQUFoQixFQUlMQSxVQW5Cd0I7QUFvQjNCbkMsSUFBQUEsY0FBYyxFQUFFZ0MsbUJBQVVRLE9BQVYsQ0FDZFIsbUJBQVVDLEtBQVYsQ0FBZ0I7QUFDZFEsTUFBQUEsT0FBTyxFQUFFVCxtQkFBVUssTUFBVixDQUFpQkYsVUFEWjtBQUVkTyxNQUFBQSxLQUFLLEVBQUVWLG1CQUFVQyxLQUFWLENBQWdCO0FBQ3JCckMsUUFBQUEsVUFBVSxFQUFFb0MsbUJBQVU3QixNQUFWLENBQWlCZ0M7QUFEUixPQUFoQixFQUVKQTtBQUpXLEtBQWhCLENBRGMsRUFPZEE7QUEzQnlCLEdBQWhCLEVBNEJWQSxVQTFDYztBQTRDakI7QUFDQWpDLEVBQUFBLGVBQWUsRUFBRThCLG1CQUFVVyxNQUFWLENBQWlCUixVQTdDakI7QUErQ2pCO0FBQ0EvQixFQUFBQSxRQUFRLEVBQUV3Qyw2QkFBaUJULFVBaERWO0FBaURqQjlCLEVBQUFBLEtBQUssRUFBRTJCLG1CQUFVSyxNQUFWLENBQWlCRixVQWpEUDtBQW1EakI7QUFDQTdCLEVBQUFBLFNBQVMsRUFBRTBCLG1CQUFVVyxNQUFWLENBQWlCUixVQXBEWDtBQXFEakI1QixFQUFBQSxRQUFRLEVBQUV5QixtQkFBVVcsTUFBVixDQUFpQlIsVUFyRFY7QUFzRGpCM0IsRUFBQUEsT0FBTyxFQUFFd0IsbUJBQVVXLE1BQVYsQ0FBaUJSLFVBdERUO0FBdURqQjFCLEVBQUFBLFFBQVEsRUFBRXVCLG1CQUFVVyxNQUFWLENBQWlCUixVQXZEVjtBQXdEakJ6QixFQUFBQSxNQUFNLEVBQUVzQixtQkFBVVcsTUFBVixDQUFpQlIsVUF4RFI7QUEwRGpCO0FBQ0FsQyxFQUFBQSxVQUFVLEVBQUUrQixtQkFBVUUsSUFBVixDQUFlQyxVQTNEVjtBQTREakJ0RCxFQUFBQSxPQUFPLEVBQUVtRCxtQkFBVUUsSUFBVixDQUFlQyxVQTVEUDtBQThEakI7QUFDQXhCLEVBQUFBLFFBQVEsRUFBRWtDLDZCQUFpQlYsVUEvRFY7QUFnRWpCdkIsRUFBQUEsU0FBUyxFQUFFa0MsOEJBQWtCWDtBQWhFWixDOztlQTBVTix3Q0FBdUI3Rix5QkFBdkIsRUFBa0Q7QUFDL0RrQixFQUFBQSxVQUFVO0FBQUE7O0FBQUE7QUFBQTtBQUFBOztBQUFBO0FBQUEsR0FEcUQ7QUFXL0RHLEVBQUFBLFdBQVc7QUFBQTs7QUFBQTtBQUFBO0FBQUE7O0FBQUE7QUFBQTtBQVhvRCxDQUFsRDtBQUFBOztBQUFBO0FBQUE7QUFBQTs7QUFBQTtBQUFBLEUiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNi4xL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQge2dyYXBocWwsIGNyZWF0ZVJlZmV0Y2hDb250YWluZXJ9IGZyb20gJ3JlYWN0LXJlbGF5JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgY3ggZnJvbSAnY2xhc3NuYW1lcyc7XG5pbXBvcnQge1RhYiwgVGFicywgVGFiTGlzdCwgVGFiUGFuZWx9IGZyb20gJ3JlYWN0LXRhYnMnO1xuXG5pbXBvcnQge0VuYWJsZWFibGVPcGVyYXRpb25Qcm9wVHlwZSwgSXRlbVR5cGVQcm9wVHlwZSwgRW5kcG9pbnRQcm9wVHlwZSwgUmVmSG9sZGVyUHJvcFR5cGV9IGZyb20gJy4uL3Byb3AtdHlwZXMnO1xuaW1wb3J0IHthZGRFdmVudH0gZnJvbSAnLi4vcmVwb3J0ZXItcHJveHknO1xuaW1wb3J0IFBlcmlvZGljUmVmcmVzaGVyIGZyb20gJy4uL3BlcmlvZGljLXJlZnJlc2hlcic7XG5pbXBvcnQgT2N0aWNvbiBmcm9tICcuLi9hdG9tL29jdGljb24nO1xuaW1wb3J0IFB1bGxSZXF1ZXN0Q2hhbmdlZEZpbGVzQ29udGFpbmVyIGZyb20gJy4uL2NvbnRhaW5lcnMvcHItY2hhbmdlZC1maWxlcy1jb250YWluZXInO1xuaW1wb3J0IFByVGltZWxpbmVDb250YWluZXIgZnJvbSAnLi4vY29udHJvbGxlcnMvcHItdGltZWxpbmUtY29udHJvbGxlcic7XG5pbXBvcnQgR2l0aHViRG90Y29tTWFya2Rvd24gZnJvbSAnLi4vdmlld3MvZ2l0aHViLWRvdGNvbS1tYXJrZG93bic7XG5pbXBvcnQgRW1vamlSZWFjdGlvbnNWaWV3IGZyb20gJy4uL3ZpZXdzL2Vtb2ppLXJlYWN0aW9ucy12aWV3JztcbmltcG9ydCBJc3N1ZWlzaEJhZGdlIGZyb20gJy4uL3ZpZXdzL2lzc3VlaXNoLWJhZGdlJztcbmltcG9ydCBQckNvbW1pdHNWaWV3IGZyb20gJy4uL3ZpZXdzL3ByLWNvbW1pdHMtdmlldyc7XG5pbXBvcnQgUHJTdGF0dXNlc1ZpZXcgZnJvbSAnLi4vdmlld3MvcHItc3RhdHVzZXMtdmlldyc7XG5pbXBvcnQge1BBR0VfU0laRX0gZnJvbSAnLi4vaGVscGVycyc7XG5cbmNsYXNzIENoZWNrb3V0U3RhdGUge1xuICBjb25zdHJ1Y3RvcihuYW1lKSB7XG4gICAgdGhpcy5uYW1lID0gbmFtZTtcbiAgfVxuXG4gIHdoZW4oY2FzZXMpIHtcbiAgICByZXR1cm4gY2FzZXNbdGhpcy5uYW1lXSB8fCBjYXNlcy5kZWZhdWx0O1xuICB9XG59XG5cbmV4cG9ydCBjb25zdCBjaGVja291dFN0YXRlcyA9IHtcbiAgSElEREVOOiBuZXcgQ2hlY2tvdXRTdGF0ZSgnaGlkZGVuJyksXG4gIERJU0FCTEVEOiBuZXcgQ2hlY2tvdXRTdGF0ZSgnZGlzYWJsZWQnKSxcbiAgQlVTWTogbmV3IENoZWNrb3V0U3RhdGUoJ2J1c3knKSxcbiAgQ1VSUkVOVDogbmV3IENoZWNrb3V0U3RhdGUoJ2N1cnJlbnQnKSxcbn07XG5cbmV4cG9ydCBjbGFzcyBCYXJlUHVsbFJlcXVlc3REZXRhaWxWaWV3IGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICAvLyBSZWxheSByZXNwb25zZVxuICAgIHJlbGF5OiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgcmVmZXRjaDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICB9KSxcbiAgICBzd2l0Y2hUb0lzc3VlaXNoOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIGNoZWNrb3V0T3A6IEVuYWJsZWFibGVPcGVyYXRpb25Qcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIHJlcG9zaXRvcnk6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICBpZDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgbmFtZTogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgb3duZXI6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgIGxvZ2luOiBQcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgfSksXG4gICAgfSksXG4gICAgcHVsbFJlcXVlc3Q6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICBfX3R5cGVuYW1lOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICBpZDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgdGl0bGU6IFByb3BUeXBlcy5zdHJpbmcsXG4gICAgICBjb3VudGVkQ29tbWl0czogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgICAgdG90YWxDb3VudDogUHJvcFR5cGVzLm51bWJlci5pc1JlcXVpcmVkLFxuICAgICAgfSkuaXNSZXF1aXJlZCxcbiAgICAgIGlzQ3Jvc3NSZXBvc2l0b3J5OiBQcm9wVHlwZXMuYm9vbCxcbiAgICAgIGNoYW5nZWRGaWxlczogUHJvcFR5cGVzLm51bWJlci5pc1JlcXVpcmVkLFxuICAgICAgdXJsOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICBib2R5SFRNTDogUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgIG51bWJlcjogUHJvcFR5cGVzLm51bWJlcixcbiAgICAgIHN0YXRlOiBQcm9wVHlwZXMub25lT2YoW1xuICAgICAgICAnT1BFTicsICdDTE9TRUQnLCAnTUVSR0VEJyxcbiAgICAgIF0pLmlzUmVxdWlyZWQsXG4gICAgICBhdXRob3I6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgIGxvZ2luOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICAgIGF2YXRhclVybDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgICB1cmw6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgIH0pLmlzUmVxdWlyZWQsXG4gICAgICByZWFjdGlvbkdyb3VwczogUHJvcFR5cGVzLmFycmF5T2YoXG4gICAgICAgIFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgICAgY29udGVudDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgICAgIHVzZXJzOiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICAgICAgdG90YWxDb3VudDogUHJvcFR5cGVzLm51bWJlci5pc1JlcXVpcmVkLFxuICAgICAgICAgIH0pLmlzUmVxdWlyZWQsXG4gICAgICAgIH0pLFxuICAgICAgKS5pc1JlcXVpcmVkLFxuICAgIH0pLmlzUmVxdWlyZWQsXG5cbiAgICAvLyBMb2NhbCBtb2RlbCBvYmplY3RzXG4gICAgbG9jYWxSZXBvc2l0b3J5OiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG5cbiAgICAvLyBDb25uZWN0aW9uIGluZm9ybWF0aW9uXG4gICAgZW5kcG9pbnQ6IEVuZHBvaW50UHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICB0b2tlbjogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuXG4gICAgLy8gQXRvbSBlbnZpcm9ubWVudFxuICAgIHdvcmtzcGFjZTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGNvbW1hbmRzOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAga2V5bWFwczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIHRvb2x0aXBzOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgY29uZmlnOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG5cbiAgICAvLyBBY3Rpb24gZnVuY3Rpb25zXG4gICAgb3BlbkNvbW1pdDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBkZXN0cm95OiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuXG4gICAgLy8gSXRlbSBjb250ZXh0XG4gICAgaXRlbVR5cGU6IEl0ZW1UeXBlUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICByZWZFZGl0b3I6IFJlZkhvbGRlclByb3BUeXBlLmlzUmVxdWlyZWQsXG4gIH1cblxuICBzdGF0ZSA9IHtcbiAgICByZWZyZXNoaW5nOiBmYWxzZSxcbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIHRoaXMucmVmcmVzaGVyID0gbmV3IFBlcmlvZGljUmVmcmVzaGVyKEJhcmVQdWxsUmVxdWVzdERldGFpbFZpZXcsIHtcbiAgICAgIGludGVydmFsOiAoKSA9PiA1ICogNjAgKiAxMDAwLFxuICAgICAgZ2V0Q3VycmVudElkOiAoKSA9PiB0aGlzLnByb3BzLnB1bGxSZXF1ZXN0LmlkLFxuICAgICAgcmVmcmVzaDogdGhpcy5yZWZyZXNoLFxuICAgICAgbWluaW11bUludGVydmFsUGVySWQ6IDIgKiA2MCAqIDEwMDAsXG4gICAgfSk7XG4gICAgLy8gYXV0by1yZWZyZXNoIGRpc2FibGVkIGZvciBub3cgdW50aWwgcGFnaW5hdGlvbiBpcyBoYW5kbGVkXG4gICAgLy8gdGhpcy5yZWZyZXNoZXIuc3RhcnQoKTtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIHRoaXMucmVmcmVzaGVyLmRlc3Ryb3koKTtcbiAgfVxuXG4gIHJlbmRlclByTWV0YWRhdGEocHVsbFJlcXVlc3QsIHJlcG8pIHtcbiAgICByZXR1cm4gKFxuICAgICAgPHNwYW4gY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy1tZXRhXCI+XG4gICAgICAgIDxjb2RlIGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaERldGFpbFZpZXctYmFzZVJlZk5hbWVcIj57cHVsbFJlcXVlc3QuaXNDcm9zc1JlcG9zaXRvcnkgP1xuICAgICAgICAgIGAke3JlcG8ub3duZXIubG9naW59LyR7cHVsbFJlcXVlc3QuYmFzZVJlZk5hbWV9YCA6IHB1bGxSZXF1ZXN0LmJhc2VSZWZOYW1lfTwvY29kZT57JyDigLkgJ31cbiAgICAgICAgPGNvZGUgY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy1oZWFkUmVmTmFtZVwiPntwdWxsUmVxdWVzdC5pc0Nyb3NzUmVwb3NpdG9yeSA/XG4gICAgICAgICAgYCR7cHVsbFJlcXVlc3QuYXV0aG9yLmxvZ2lufS8ke3B1bGxSZXF1ZXN0LmhlYWRSZWZOYW1lfWAgOiBwdWxsUmVxdWVzdC5oZWFkUmVmTmFtZX08L2NvZGU+XG4gICAgICA8L3NwYW4+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlclB1bGxSZXF1ZXN0Qm9keShwdWxsUmVxdWVzdCkge1xuICAgIGNvbnN0IG9uQnJhbmNoID0gdGhpcy5wcm9wcy5jaGVja291dE9wLndoeSgpID09PSBjaGVja291dFN0YXRlcy5DVVJSRU5UO1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxUYWJzIG9uU2VsZWN0PXt0aGlzLnJlY29yZE9wZW5UYWJFdmVudH0+XG4gICAgICAgIDxUYWJMaXN0IGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaERldGFpbFZpZXctdGFibGlzdFwiPlxuICAgICAgICAgIDxUYWIgY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy10YWJcIj5cbiAgICAgICAgICAgIDxPY3RpY29uIGljb249XCJpbmZvXCIgY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy10YWItaWNvblwiIC8+T3ZlcnZpZXc8L1RhYj5cbiAgICAgICAgICA8VGFiIGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaERldGFpbFZpZXctdGFiXCI+XG4gICAgICAgICAgICA8T2N0aWNvbiBpY29uPVwiY2hlY2tsaXN0XCIgY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy10YWItaWNvblwiIC8+XG4gICAgICAgICAgICBCdWlsZCBTdGF0dXNcbiAgICAgICAgICA8L1RhYj5cbiAgICAgICAgICA8VGFiIGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaERldGFpbFZpZXctdGFiXCI+XG4gICAgICAgICAgICA8T2N0aWNvbiBpY29uPVwiZ2l0LWNvbW1pdFwiXG4gICAgICAgICAgICAgIGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaERldGFpbFZpZXctdGFiLWljb25cIlxuICAgICAgICAgICAgLz5cbiAgICAgICAgICAgICAgQ29tbWl0c1xuICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy10YWItY291bnRcIj57cHVsbFJlcXVlc3QuY291bnRlZENvbW1pdHMudG90YWxDb3VudH08L3NwYW4+XG4gICAgICAgICAgPC9UYWI+XG4gICAgICAgICAgPFRhYiBjbGFzc05hbWU9XCJnaXRodWItSXNzdWVpc2hEZXRhaWxWaWV3LXRhYlwiPlxuICAgICAgICAgICAgPE9jdGljb24gaWNvbj1cImRpZmZcIlxuICAgICAgICAgICAgICBjbGFzc05hbWU9XCJnaXRodWItSXNzdWVpc2hEZXRhaWxWaWV3LXRhYi1pY29uXCJcbiAgICAgICAgICAgIC8+XG4gICAgICAgICAgICAgIEZpbGVzPHNwYW4gY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy10YWItY291bnRcIj57cHVsbFJlcXVlc3QuY2hhbmdlZEZpbGVzfTwvc3Bhbj5cbiAgICAgICAgICA8L1RhYj5cbiAgICAgICAgPC9UYWJMaXN0PlxuICAgICAgICB7LyogJ1Jldmlld3MnIHRhYiB0byBiZSBhZGRlZCBpbiB0aGUgZnV0dXJlLiAqL31cblxuICAgICAgICB7Lyogb3ZlcnZpZXcgKi99XG4gICAgICAgIDxUYWJQYW5lbD5cbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaERldGFpbFZpZXctb3ZlcnZpZXdcIj5cbiAgICAgICAgICAgIDxHaXRodWJEb3Rjb21NYXJrZG93blxuICAgICAgICAgICAgICBodG1sPXtwdWxsUmVxdWVzdC5ib2R5SFRNTCB8fCAnPGVtPk5vIGRlc2NyaXB0aW9uIHByb3ZpZGVkLjwvZW0+J31cbiAgICAgICAgICAgICAgc3dpdGNoVG9Jc3N1ZWlzaD17dGhpcy5wcm9wcy5zd2l0Y2hUb0lzc3VlaXNofVxuICAgICAgICAgICAgLz5cbiAgICAgICAgICAgIDxFbW9qaVJlYWN0aW9uc1ZpZXcgcmVhY3Rpb25Hcm91cHM9e3B1bGxSZXF1ZXN0LnJlYWN0aW9uR3JvdXBzfSAvPlxuICAgICAgICAgICAgPFByVGltZWxpbmVDb250YWluZXJcbiAgICAgICAgICAgICAgb25CcmFuY2g9e29uQnJhbmNofVxuICAgICAgICAgICAgICBvcGVuQ29tbWl0PXt0aGlzLnByb3BzLm9wZW5Db21taXR9XG4gICAgICAgICAgICAgIHB1bGxSZXF1ZXN0PXtwdWxsUmVxdWVzdH1cbiAgICAgICAgICAgICAgc3dpdGNoVG9Jc3N1ZWlzaD17dGhpcy5wcm9wcy5zd2l0Y2hUb0lzc3VlaXNofVxuICAgICAgICAgICAgLz5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgPC9UYWJQYW5lbD5cblxuICAgICAgICB7LyogYnVpbGQgc3RhdHVzICovfVxuICAgICAgICA8VGFiUGFuZWw+XG4gICAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItSXNzdWVpc2hEZXRhaWxWaWV3LWJ1aWxkU3RhdHVzXCI+XG4gICAgICAgICAgICA8UHJTdGF0dXNlc1ZpZXcgcHVsbFJlcXVlc3Q9e3B1bGxSZXF1ZXN0fSBkaXNwbGF5VHlwZT1cImZ1bGxcIiAvPlxuICAgICAgICAgIDwvZGl2PlxuICAgICAgICA8L1RhYlBhbmVsPlxuXG4gICAgICAgIHsvKiBjb21taXRzICovfVxuICAgICAgICA8VGFiUGFuZWw+XG4gICAgICAgICAgPFByQ29tbWl0c1ZpZXcgcHVsbFJlcXVlc3Q9e3B1bGxSZXF1ZXN0fSBvbkJyYW5jaD17b25CcmFuY2h9IG9wZW5Db21taXQ9e3RoaXMucHJvcHMub3BlbkNvbW1pdH0gLz5cbiAgICAgICAgPC9UYWJQYW5lbD5cblxuICAgICAgICB7LyogZmlsZXMgY2hhbmdlZCAqL31cbiAgICAgICAgPFRhYlBhbmVsIGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaERldGFpbFZpZXctZmlsZXNDaGFuZ2VkXCI+XG4gICAgICAgICAgPFB1bGxSZXF1ZXN0Q2hhbmdlZEZpbGVzQ29udGFpbmVyXG4gICAgICAgICAgICBsb2NhbFJlcG9zaXRvcnk9e3RoaXMucHJvcHMubG9jYWxSZXBvc2l0b3J5fVxuXG4gICAgICAgICAgICBvd25lcj17dGhpcy5wcm9wcy5yZXBvc2l0b3J5Lm93bmVyLmxvZ2lufVxuICAgICAgICAgICAgcmVwbz17dGhpcy5wcm9wcy5yZXBvc2l0b3J5Lm5hbWV9XG4gICAgICAgICAgICBudW1iZXI9e3B1bGxSZXF1ZXN0Lm51bWJlcn1cblxuICAgICAgICAgICAgZW5kcG9pbnQ9e3RoaXMucHJvcHMuZW5kcG9pbnR9XG4gICAgICAgICAgICB0b2tlbj17dGhpcy5wcm9wcy50b2tlbn1cblxuICAgICAgICAgICAgd29ya3NwYWNlPXt0aGlzLnByb3BzLndvcmtzcGFjZX1cbiAgICAgICAgICAgIGNvbW1hbmRzPXt0aGlzLnByb3BzLmNvbW1hbmRzfVxuICAgICAgICAgICAga2V5bWFwcz17dGhpcy5wcm9wcy5rZXltYXBzfVxuICAgICAgICAgICAgdG9vbHRpcHM9e3RoaXMucHJvcHMudG9vbHRpcHN9XG4gICAgICAgICAgICBjb25maWc9e3RoaXMucHJvcHMuY29uZmlnfVxuXG4gICAgICAgICAgICBpdGVtVHlwZT17dGhpcy5wcm9wcy5pdGVtVHlwZX1cbiAgICAgICAgICAgIHJlZkVkaXRvcj17dGhpcy5wcm9wcy5yZWZFZGl0b3J9XG4gICAgICAgICAgICBkZXN0cm95PXt0aGlzLnByb3BzLmRlc3Ryb3l9XG5cbiAgICAgICAgICAgIHNob3VsZFJlZmV0Y2g9e3RoaXMuc3RhdGUucmVmcmVzaGluZ31cbiAgICAgICAgICAgIHN3aXRjaFRvSXNzdWVpc2g9e3RoaXMucHJvcHMuc3dpdGNoVG9Jc3N1ZWlzaH1cblxuICAgICAgICAgICAgcHVsbFJlcXVlc3Q9e3RoaXMucHJvcHMucHVsbFJlcXVlc3R9XG4gICAgICAgICAgLz5cbiAgICAgICAgPC9UYWJQYW5lbD5cbiAgICAgIDwvVGFicz5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGNvbnN0IHJlcG8gPSB0aGlzLnByb3BzLnJlcG9zaXRvcnk7XG4gICAgY29uc3QgcHVsbFJlcXVlc3QgPSB0aGlzLnByb3BzLnB1bGxSZXF1ZXN0O1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldyBuYXRpdmUta2V5LWJpbmRpbmdzXCI+XG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy1jb250YWluZXJcIj5cblxuICAgICAgICAgIDxoZWFkZXIgY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy1oZWFkZXJcIj5cbiAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy1oZWFkZXJDb2x1bW5cIj5cbiAgICAgICAgICAgICAgPGEgY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy1hdmF0YXJcIiBocmVmPXtwdWxsUmVxdWVzdC5hdXRob3IudXJsfT5cbiAgICAgICAgICAgICAgICA8aW1nIGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaERldGFpbFZpZXctYXZhdGFySW1hZ2VcIlxuICAgICAgICAgICAgICAgICAgc3JjPXtwdWxsUmVxdWVzdC5hdXRob3IuYXZhdGFyVXJsfVxuICAgICAgICAgICAgICAgICAgdGl0bGU9e3B1bGxSZXF1ZXN0LmF1dGhvci5sb2dpbn1cbiAgICAgICAgICAgICAgICAgIGFsdD17cHVsbFJlcXVlc3QuYXV0aG9yLmxvZ2lufVxuICAgICAgICAgICAgICAgIC8+XG4gICAgICAgICAgICAgIDwvYT5cbiAgICAgICAgICAgIDwvZGl2PlxuXG4gICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaERldGFpbFZpZXctaGVhZGVyQ29sdW1uIGlzLWZsZXhpYmxlXCI+XG4gICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy1oZWFkZXJSb3cgaXMtZnVsbHdpZHRoXCI+XG4gICAgICAgICAgICAgICAgPGEgY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy10aXRsZVwiIGhyZWY9e3B1bGxSZXF1ZXN0LnVybH0+e3B1bGxSZXF1ZXN0LnRpdGxlfTwvYT5cbiAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLUlzc3VlaXNoRGV0YWlsVmlldy1oZWFkZXJSb3dcIj5cbiAgICAgICAgICAgICAgICA8SXNzdWVpc2hCYWRnZSBjbGFzc05hbWU9XCJnaXRodWItSXNzdWVpc2hEZXRhaWxWaWV3LWhlYWRlckJhZGdlXCJcbiAgICAgICAgICAgICAgICAgIHR5cGU9e3B1bGxSZXF1ZXN0Ll9fdHlwZW5hbWV9XG4gICAgICAgICAgICAgICAgICBzdGF0ZT17cHVsbFJlcXVlc3Quc3RhdGV9XG4gICAgICAgICAgICAgICAgLz5cbiAgICAgICAgICAgICAgICA8T2N0aWNvblxuICAgICAgICAgICAgICAgICAgaWNvbj1cInJlcG8tc3luY1wiXG4gICAgICAgICAgICAgICAgICBjbGFzc05hbWU9e2N4KCdnaXRodWItSXNzdWVpc2hEZXRhaWxWaWV3LWhlYWRlclJlZnJlc2hCdXR0b24nLCB7cmVmcmVzaGluZzogdGhpcy5zdGF0ZS5yZWZyZXNoaW5nfSl9XG4gICAgICAgICAgICAgICAgICBvbkNsaWNrPXt0aGlzLmhhbmRsZVJlZnJlc2hDbGlja31cbiAgICAgICAgICAgICAgICAvPlxuICAgICAgICAgICAgICAgIDxhIGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaERldGFpbFZpZXctaGVhZGVyTGlua1wiXG4gICAgICAgICAgICAgICAgICB0aXRsZT1cIm9wZW4gb24gR2l0SHViLmNvbVwiXG4gICAgICAgICAgICAgICAgICBocmVmPXtwdWxsUmVxdWVzdC51cmx9IG9uQ2xpY2s9e3RoaXMucmVjb3JkT3BlbkluQnJvd3NlckV2ZW50fT5cbiAgICAgICAgICAgICAgICAgIHtyZXBvLm93bmVyLmxvZ2lufS97cmVwby5uYW1lfSN7cHVsbFJlcXVlc3QubnVtYmVyfVxuICAgICAgICAgICAgICAgIDwvYT5cbiAgICAgICAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJnaXRodWItSXNzdWVpc2hEZXRhaWxWaWV3LWhlYWRlclN0YXR1c1wiPlxuICAgICAgICAgICAgICAgICAgPFByU3RhdHVzZXNWaWV3IHB1bGxSZXF1ZXN0PXtwdWxsUmVxdWVzdH0gZGlzcGxheVR5cGU9XCJjaGVja1wiIC8+XG4gICAgICAgICAgICAgICAgPC9zcGFuPlxuICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItSXNzdWVpc2hEZXRhaWxWaWV3LWhlYWRlclJvd1wiPlxuICAgICAgICAgICAgICAgIHt0aGlzLnJlbmRlclByTWV0YWRhdGEocHVsbFJlcXVlc3QsIHJlcG8pfVxuICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgIDwvZGl2PlxuXG4gICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaERldGFpbFZpZXctaGVhZGVyQ29sdW1uXCI+XG4gICAgICAgICAgICAgIHt0aGlzLnJlbmRlckNoZWNrb3V0QnV0dG9uKCl9XG4gICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8L2hlYWRlcj5cblxuICAgICAgICAgIHt0aGlzLnJlbmRlclB1bGxSZXF1ZXN0Qm9keShwdWxsUmVxdWVzdCl9XG5cbiAgICAgICAgICA8Zm9vdGVyIGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaERldGFpbFZpZXctZm9vdGVyXCI+XG4gICAgICAgICAgICA8YSBjbGFzc05hbWU9XCJnaXRodWItSXNzdWVpc2hEZXRhaWxWaWV3LWZvb3RlckxpbmsgaWNvbiBpY29uLW1hcmstZ2l0aHViXCJcbiAgICAgICAgICAgICAgaHJlZj17cHVsbFJlcXVlc3QudXJsfT57cmVwby5vd25lci5sb2dpbn0ve3JlcG8ubmFtZX0je3B1bGxSZXF1ZXN0Lm51bWJlcn1cbiAgICAgICAgICAgIDwvYT5cbiAgICAgICAgICA8L2Zvb3Rlcj5cblxuICAgICAgICA8L2Rpdj5cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICByZW5kZXJDaGVja291dEJ1dHRvbigpIHtcbiAgICBjb25zdCB7Y2hlY2tvdXRPcH0gPSB0aGlzLnByb3BzO1xuICAgIGxldCBleHRyYUNsYXNzID0gbnVsbDtcbiAgICBsZXQgYnV0dG9uVGV4dCA9ICdDaGVja291dCc7XG4gICAgbGV0IGJ1dHRvblRpdGxlID0gbnVsbDtcblxuICAgIGlmICghY2hlY2tvdXRPcC5pc0VuYWJsZWQoKSkge1xuICAgICAgYnV0dG9uVGl0bGUgPSBjaGVja291dE9wLmdldE1lc3NhZ2UoKTtcbiAgICAgIGNvbnN0IHJlYXNvbiA9IGNoZWNrb3V0T3Aud2h5KCk7XG4gICAgICBpZiAocmVhc29uID09PSBjaGVja291dFN0YXRlcy5ISURERU4pIHtcbiAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgICB9XG5cbiAgICAgIGJ1dHRvblRleHQgPSByZWFzb24ud2hlbih7XG4gICAgICAgIGN1cnJlbnQ6ICdDaGVja2VkIG91dCcsXG4gICAgICAgIGRlZmF1bHQ6ICdDaGVja291dCcsXG4gICAgICB9KTtcblxuICAgICAgZXh0cmFDbGFzcyA9ICdnaXRodWItSXNzdWVpc2hEZXRhaWxWaWV3LWNoZWNrb3V0QnV0dG9uLS0nICsgcmVhc29uLndoZW4oe1xuICAgICAgICBkaXNhYmxlZDogJ2Rpc2FibGVkJyxcbiAgICAgICAgYnVzeTogJ2J1c3knLFxuICAgICAgICBjdXJyZW50OiAnY3VycmVudCcsXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICBjb25zdCBjbGFzc05hbWVzID0gY3goJ2J0bicsICdidG4tcHJpbWFyeScsICdnaXRodWItSXNzdWVpc2hEZXRhaWxWaWV3LWNoZWNrb3V0QnV0dG9uJywgZXh0cmFDbGFzcyk7XG4gICAgcmV0dXJuIChcbiAgICAgIDxidXR0b25cbiAgICAgICAgY2xhc3NOYW1lPXtjbGFzc05hbWVzfVxuICAgICAgICBkaXNhYmxlZD17IWNoZWNrb3V0T3AuaXNFbmFibGVkKCl9XG4gICAgICAgIHRpdGxlPXtidXR0b25UaXRsZX1cbiAgICAgICAgb25DbGljaz17KCkgPT4gY2hlY2tvdXRPcC5ydW4oKX0+XG4gICAgICAgIHtidXR0b25UZXh0fVxuICAgICAgPC9idXR0b24+XG4gICAgKTtcbiAgfVxuXG4gIGhhbmRsZVJlZnJlc2hDbGljayA9IGUgPT4ge1xuICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICB0aGlzLnJlZnJlc2hlci5yZWZyZXNoTm93KHRydWUpO1xuICB9XG5cbiAgcmVjb3JkT3BlbkluQnJvd3NlckV2ZW50ID0gKCkgPT4ge1xuICAgIGFkZEV2ZW50KCdvcGVuLXB1bGwtcmVxdWVzdC1pbi1icm93c2VyJywge3BhY2thZ2U6ICdnaXRodWInLCBjb21wb25lbnQ6IHRoaXMuY29uc3RydWN0b3IubmFtZX0pO1xuICB9XG5cbiAgcmVjb3JkT3BlblRhYkV2ZW50ID0gaW5kID0+IHtcbiAgICBjb25zdCBldmVudE5hbWUgPSBbXG4gICAgICAnb3Blbi1wci10YWItb3ZlcnZpZXcnLFxuICAgICAgJ29wZW4tcHItdGFiLWJ1aWxkLXN0YXR1cycsXG4gICAgICAnb3Blbi1wci10YWItY29tbWl0cycsXG4gICAgICAnb3Blbi1wci10YWItZmlsZXMtY2hhbmdlZCcsXG4gICAgXVtpbmRdO1xuICAgIGFkZEV2ZW50KGV2ZW50TmFtZSwge3BhY2thZ2U6ICdnaXRodWInLCBjb21wb25lbnQ6IHRoaXMuY29uc3RydWN0b3IubmFtZX0pO1xuICB9XG5cbiAgcmVmcmVzaCA9ICgpID0+IHtcbiAgICBpZiAodGhpcy5zdGF0ZS5yZWZyZXNoaW5nKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgdGhpcy5zZXRTdGF0ZSh7cmVmcmVzaGluZzogdHJ1ZX0pO1xuICAgIHRoaXMucHJvcHMucmVsYXkucmVmZXRjaCh7XG4gICAgICByZXBvSWQ6IHRoaXMucHJvcHMucmVwb3NpdG9yeS5pZCxcbiAgICAgIGlzc3VlaXNoSWQ6IHRoaXMucHJvcHMucHVsbFJlcXVlc3QuaWQsXG4gICAgICB0aW1lbGluZUNvdW50OiBQQUdFX1NJWkUsXG4gICAgICB0aW1lbGluZUN1cnNvcjogbnVsbCxcbiAgICAgIGNvbW1pdENvdW50OiBQQUdFX1NJWkUsXG4gICAgICBjb21taXRDdXJzb3I6IG51bGwsXG4gICAgICByZXZpZXdDb3VudDogUEFHRV9TSVpFLFxuICAgICAgcmV2aWV3Q3Vyc29yOiBudWxsLFxuICAgICAgY29tbWVudENvdW50OiBQQUdFX1NJWkUsXG4gICAgICBjb21tZW50Q3Vyc29yOiBudWxsLFxuICAgIH0sIG51bGwsICgpID0+IHtcbiAgICAgIHRoaXMuc2V0U3RhdGUoe3JlZnJlc2hpbmc6IGZhbHNlfSk7XG4gICAgfSwge2ZvcmNlOiB0cnVlfSk7XG4gIH1cbn1cblxuZXhwb3J0IGRlZmF1bHQgY3JlYXRlUmVmZXRjaENvbnRhaW5lcihCYXJlUHVsbFJlcXVlc3REZXRhaWxWaWV3LCB7XG4gIHJlcG9zaXRvcnk6IGdyYXBocWxgXG4gICAgZnJhZ21lbnQgcHJEZXRhaWxWaWV3X3JlcG9zaXRvcnkgb24gUmVwb3NpdG9yeSB7XG4gICAgICBpZFxuICAgICAgbmFtZVxuICAgICAgb3duZXIge1xuICAgICAgICBsb2dpblxuICAgICAgfVxuICAgIH1cbiAgYCxcblxuICBwdWxsUmVxdWVzdDogZ3JhcGhxbGBcbiAgICBmcmFnbWVudCBwckRldGFpbFZpZXdfcHVsbFJlcXVlc3Qgb24gUHVsbFJlcXVlc3RcbiAgICBAYXJndW1lbnREZWZpbml0aW9ucyhcbiAgICAgIHRpbWVsaW5lQ291bnQ6IHt0eXBlOiBcIkludCFcIn0sXG4gICAgICB0aW1lbGluZUN1cnNvcjoge3R5cGU6IFwiU3RyaW5nXCJ9LFxuICAgICAgY29tbWl0Q291bnQ6IHt0eXBlOiBcIkludCFcIn0sXG4gICAgICBjb21taXRDdXJzb3I6IHt0eXBlOiBcIlN0cmluZ1wifSxcbiAgICAgIHJldmlld0NvdW50OiB7dHlwZTogXCJJbnQhXCJ9LFxuICAgICAgcmV2aWV3Q3Vyc29yOiB7dHlwZTogXCJTdHJpbmdcIn0sXG4gICAgICBjb21tZW50Q291bnQ6IHt0eXBlOiBcIkludCFcIn0sXG4gICAgICBjb21tZW50Q3Vyc29yOiB7dHlwZTogXCJTdHJpbmdcIn0sXG4gICAgKSB7XG4gICAgICBfX3R5cGVuYW1lXG5cbiAgICAgIC4uLiBvbiBOb2RlIHtcbiAgICAgICAgaWRcbiAgICAgIH1cblxuICAgICAgLi4uIG9uIFB1bGxSZXF1ZXN0IHtcbiAgICAgICAgaXNDcm9zc1JlcG9zaXRvcnlcbiAgICAgICAgY2hhbmdlZEZpbGVzXG5cbiAgICAgICAgLi4ucHJSZXZpZXdzQ29udGFpbmVyX3B1bGxSZXF1ZXN0IEBhcmd1bWVudHMoXG4gICAgICAgICAgcmV2aWV3Q291bnQ6ICRyZXZpZXdDb3VudCxcbiAgICAgICAgICByZXZpZXdDdXJzb3I6ICRyZXZpZXdDdXJzb3IsXG4gICAgICAgICAgY29tbWVudENvdW50OiAkY29tbWVudENvdW50LFxuICAgICAgICAgIGNvbW1lbnRDdXJzb3I6ICRjb21tZW50Q3Vyc29yLFxuICAgICAgICApXG5cbiAgICAgICAgLi4ucHJDb21taXRzVmlld19wdWxsUmVxdWVzdCBAYXJndW1lbnRzKGNvbW1pdENvdW50OiAkY29tbWl0Q291bnQsIGNvbW1pdEN1cnNvcjogJGNvbW1pdEN1cnNvcilcbiAgICAgICAgY291bnRlZENvbW1pdHM6IGNvbW1pdHMge1xuICAgICAgICAgIHRvdGFsQ291bnRcbiAgICAgICAgfVxuICAgICAgICAuLi5wclN0YXR1c2VzVmlld19wdWxsUmVxdWVzdFxuICAgICAgICBzdGF0ZSBudW1iZXIgdGl0bGUgYm9keUhUTUwgYmFzZVJlZk5hbWUgaGVhZFJlZk5hbWVcbiAgICAgICAgYXV0aG9yIHtcbiAgICAgICAgICBsb2dpbiBhdmF0YXJVcmxcbiAgICAgICAgICAuLi4gb24gVXNlciB7IHVybCB9XG4gICAgICAgICAgLi4uIG9uIEJvdCB7IHVybCB9XG4gICAgICAgIH1cblxuICAgICAgICAuLi5wclRpbWVsaW5lQ29udHJvbGxlcl9wdWxsUmVxdWVzdCBAYXJndW1lbnRzKHRpbWVsaW5lQ291bnQ6ICR0aW1lbGluZUNvdW50LCB0aW1lbGluZUN1cnNvcjogJHRpbWVsaW5lQ3Vyc29yKVxuICAgICAgfVxuXG4gICAgICAuLi4gb24gVW5pZm9ybVJlc291cmNlTG9jYXRhYmxlIHsgdXJsIH1cblxuICAgICAgLi4uIG9uIFJlYWN0YWJsZSB7XG4gICAgICAgIHJlYWN0aW9uR3JvdXBzIHtcbiAgICAgICAgICBjb250ZW50IHVzZXJzIHsgdG90YWxDb3VudCB9XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG4gIGAsXG59LCBncmFwaHFsYFxuICBxdWVyeSBwckRldGFpbFZpZXdSZWZldGNoUXVlcnlcbiAgKFxuICAgICRyZXBvSWQ6IElEISxcbiAgICAkaXNzdWVpc2hJZDogSUQhLFxuICAgICR0aW1lbGluZUNvdW50OiBJbnQhLFxuICAgICR0aW1lbGluZUN1cnNvcjogU3RyaW5nLFxuICAgICRjb21taXRDb3VudDogSW50ISxcbiAgICAkY29tbWl0Q3Vyc29yOiBTdHJpbmcsXG4gICAgJHJldmlld0NvdW50OiBJbnQhLFxuICAgICRyZXZpZXdDdXJzb3I6IFN0cmluZyxcbiAgICAkY29tbWVudENvdW50OiBJbnQhLFxuICAgICRjb21tZW50Q3Vyc29yOiBTdHJpbmcsXG4gICkge1xuICAgIHJlcG9zaXRvcnk6bm9kZShpZDogJHJlcG9JZCkge1xuICAgICAgLi4ucHJEZXRhaWxWaWV3X3JlcG9zaXRvcnkgQGFyZ3VtZW50cyhcbiAgICAgICAgdGltZWxpbmVDb3VudDogJHRpbWVsaW5lQ291bnQsXG4gICAgICAgIHRpbWVsaW5lQ3Vyc29yOiAkdGltZWxpbmVDdXJzb3JcbiAgICAgIClcbiAgICB9XG5cbiAgICBwdWxsUmVxdWVzdDpub2RlKGlkOiAkaXNzdWVpc2hJZCkge1xuICAgICAgLi4ucHJEZXRhaWxWaWV3X3B1bGxSZXF1ZXN0IEBhcmd1bWVudHMoXG4gICAgICAgIHRpbWVsaW5lQ291bnQ6ICR0aW1lbGluZUNvdW50LFxuICAgICAgICB0aW1lbGluZUN1cnNvcjogJHRpbWVsaW5lQ3Vyc29yLFxuICAgICAgICBjb21taXRDb3VudDogJGNvbW1pdENvdW50LFxuICAgICAgICBjb21taXRDdXJzb3I6ICRjb21taXRDdXJzb3IsXG4gICAgICAgIHJldmlld0NvdW50OiAkcmV2aWV3Q291bnQsXG4gICAgICAgIHJldmlld0N1cnNvcjogJHJldmlld0N1cnNvcixcbiAgICAgICAgY29tbWVudENvdW50OiAkY29tbWVudENvdW50LFxuICAgICAgICBjb21tZW50Q3Vyc29yOiAkY29tbWVudEN1cnNvcixcbiAgICAgIClcbiAgICB9XG4gIH1cbmApO1xuIl19