"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareIssueDetailView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _issueTimelineController = _interopRequireDefault(require("../controllers/issue-timeline-controller"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _issueishBadge = _interopRequireDefault(require("../views/issueish-badge"));

var _githubDotcomMarkdown = _interopRequireDefault(require("../views/github-dotcom-markdown"));

var _emojiReactionsView = _interopRequireDefault(require("../views/emoji-reactions-view"));

var _periodicRefresher = _interopRequireDefault(require("../periodic-refresher"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareIssueDetailView extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      refreshing: false
    });

    _defineProperty(this, "handleRefreshClick", e => {
      e.preventDefault();
      this.refresher.refreshNow(true);
    });

    _defineProperty(this, "recordOpenInBrowserEvent", () => {
      (0, _reporterProxy.addEvent)('open-issue-in-browser', {
        package: 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "refresh", () => {
      if (this.state.refreshing) {
        return;
      }

      this.setState({
        refreshing: true
      });
      this.props.relay.refetch({
        repoId: this.props.repository.id,
        issueishId: this.props.issue.id,
        timelineCount: 100,
        timelineCursor: null
      }, null, () => {
        this.setState({
          refreshing: false
        });
      }, {
        force: true
      });
    });
  }

  componentDidMount() {
    this.refresher = new _periodicRefresher.default(BareIssueDetailView, {
      interval: () => 5 * 60 * 1000,
      getCurrentId: () => this.props.issue.id,
      refresh: this.refresh,
      minimumIntervalPerId: 2 * 60 * 1000
    }); // auto-refresh disabled for now until pagination is handled
    // this.refresher.start();
  }

  componentWillUnmount() {
    this.refresher.destroy();
  }

  renderIssueBody(issue) {
    return _react.default.createElement("div", {
      className: "github-IssueishDetailView-issueBody"
    }, _react.default.createElement(_githubDotcomMarkdown.default, {
      html: issue.bodyHTML || '<em>No description provided.</em>',
      switchToIssueish: this.props.switchToIssueish
    }), _react.default.createElement(_emojiReactionsView.default, {
      reactionGroups: issue.reactionGroups
    }), _react.default.createElement(_issueTimelineController.default, {
      issue: issue,
      switchToIssueish: this.props.switchToIssueish
    }));
  }

  render() {
    const repo = this.props.repository;
    const issue = this.props.issue;
    return _react.default.createElement("div", {
      className: "github-IssueishDetailView native-key-bindings"
    }, _react.default.createElement("div", {
      className: "github-IssueishDetailView-container"
    }, _react.default.createElement("header", {
      className: "github-IssueishDetailView-header"
    }, _react.default.createElement("div", {
      className: "github-IssueishDetailView-headerColumn"
    }, _react.default.createElement("a", {
      className: "github-IssueishDetailView-avatar",
      href: issue.author.url
    }, _react.default.createElement("img", {
      className: "github-IssueishDetailView-avatarImage",
      src: issue.author.avatarUrl,
      title: issue.author.login,
      alt: issue.author.login
    }))), _react.default.createElement("div", {
      className: "github-IssueishDetailView-headerColumn is-flexible"
    }, _react.default.createElement("div", {
      className: "github-IssueishDetailView-headerRow is-fullwidth"
    }, _react.default.createElement("a", {
      className: "github-IssueishDetailView-title",
      href: issue.url
    }, issue.title)), _react.default.createElement("div", {
      className: "github-IssueishDetailView-headerRow"
    }, _react.default.createElement(_issueishBadge.default, {
      className: "github-IssueishDetailView-headerBadge",
      type: issue.__typename,
      state: issue.state
    }), _react.default.createElement(_octicon.default, {
      icon: "repo-sync",
      className: (0, _classnames.default)('github-IssueishDetailView-headerRefreshButton', {
        refreshing: this.state.refreshing
      }),
      onClick: this.handleRefreshClick
    }), _react.default.createElement("a", {
      className: "github-IssueishDetailView-headerLink",
      title: "open on GitHub.com",
      href: issue.url,
      onClick: this.recordOpenInBrowserEvent
    }, repo.owner.login, "/", repo.name, "#", issue.number)))), this.renderIssueBody(issue), _react.default.createElement("footer", {
      className: "github-IssueishDetailView-footer"
    }, _react.default.createElement("a", {
      className: "github-IssueishDetailView-footerLink icon icon-mark-github",
      href: issue.url
    }, repo.owner.login, "/", repo.name, "#", issue.number))));
  }

}

exports.BareIssueDetailView = BareIssueDetailView;

_defineProperty(BareIssueDetailView, "propTypes", {
  relay: _propTypes.default.shape({
    refetch: _propTypes.default.func.isRequired
  }),
  switchToIssueish: _propTypes.default.func.isRequired,
  repository: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    name: _propTypes.default.string.isRequired,
    owner: _propTypes.default.shape({
      login: _propTypes.default.string
    })
  }),
  issue: _propTypes.default.shape({
    __typename: _propTypes.default.string.isRequired,
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string,
    url: _propTypes.default.string.isRequired,
    bodyHTML: _propTypes.default.string,
    number: _propTypes.default.number,
    state: _propTypes.default.oneOf(['OPEN', 'CLOSED']).isRequired,
    author: _propTypes.default.shape({
      login: _propTypes.default.string.isRequired,
      avatarUrl: _propTypes.default.string.isRequired,
      url: _propTypes.default.string.isRequired
    }).isRequired,
    reactionGroups: _propTypes.default.arrayOf(_propTypes.default.shape({
      content: _propTypes.default.string.isRequired,
      users: _propTypes.default.shape({
        totalCount: _propTypes.default.number.isRequired
      }).isRequired
    })).isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createRefetchContainer)(BareIssueDetailView, {
  repository: function () {
    const node = require("./__generated__/issueDetailView_repository.graphql");

    if (node.hash && node.hash !== "295a60f53b25b6fdb07a1539cda447f2") {
      console.error("The definition of 'issueDetailView_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueDetailView_repository.graphql");
  },
  issue: function () {
    const node = require("./__generated__/issueDetailView_issue.graphql");

    if (node.hash && node.hash !== "e1cf4b71a99cbade6149738c70451892") {
      console.error("The definition of 'issueDetailView_issue' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueDetailView_issue.graphql");
  }
}, function () {
  const node = require("./__generated__/issueDetailViewRefetchQuery.graphql");

  if (node.hash && node.hash !== "82666b2748036545eb131b3e34f48e72") {
    console.error("The definition of 'issueDetailViewRefetchQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/issueDetailViewRefetchQuery.graphql");
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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