"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _helpers = require("../helpers");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CredentialDialog extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'confirm', 'cancel', 'onUsernameChange', 'onPasswordChange', 'onRememberChange', 'focusFirstInput', 'toggleShowPassword');
    this.state = {
      username: '',
      password: '',
      remember: false,
      showPassword: false
    };
  }

  componentDidMount() {
    setTimeout(this.focusFirstInput);
  }

  render() {
    return _react.default.createElement("div", {
      className: "github-Dialog github-Credentials modal native-key-bindings"
    }, _react.default.createElement(_commands.default, {
      registry: this.props.commandRegistry,
      target: ".github-Credentials"
    }, _react.default.createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancel
    }), _react.default.createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.confirm
    })), _react.default.createElement("header", {
      className: "github-DialogPrompt"
    }, this.props.prompt), _react.default.createElement("main", {
      className: "github-DialogInputs"
    }, this.props.includeUsername ? _react.default.createElement("label", {
      className: "github-DialogLabel"
    }, "Username:", _react.default.createElement("input", {
      type: "text",
      ref: e => this.usernameInput = e,
      className: "input-text github-CredentialDialog-Username",
      value: this.state.username,
      onChange: this.onUsernameChange,
      tabIndex: "1"
    })) : null, _react.default.createElement("label", {
      className: "github-DialogLabel"
    }, "Password:", _react.default.createElement("input", {
      type: this.state.showPassword ? 'text' : 'password',
      ref: e => this.passwordInput = e,
      className: "input-text github-CredentialDialog-Password",
      value: this.state.password,
      onChange: this.onPasswordChange,
      tabIndex: "2"
    }), _react.default.createElement("button", {
      className: "github-DialogLabelButton",
      onClick: this.toggleShowPassword
    }, this.state.showPassword ? 'Hide' : 'Show'))), _react.default.createElement("footer", {
      className: "github-DialogButtons"
    }, this.props.includeRemember ? _react.default.createElement("label", {
      className: "github-DialogButtons-leftItem input-label"
    }, _react.default.createElement("input", {
      className: "github-CredentialDialog-remember input-checkbox",
      type: "checkbox",
      checked: this.state.remember,
      onChange: this.onRememberChange
    }), "Remember") : null, _react.default.createElement("button", {
      className: "btn github-CancelButton",
      tabIndex: "3",
      onClick: this.cancel
    }, "Cancel"), _react.default.createElement("button", {
      className: "btn btn-primary",
      tabIndex: "4",
      onClick: this.confirm
    }, "Sign in")));
  }

  confirm() {
    const payload = {
      password: this.state.password
    };

    if (this.props.includeUsername) {
      payload.username = this.state.username;
    }

    if (this.props.includeRemember) {
      payload.remember = this.state.remember;
    }

    this.props.onSubmit(payload);
  }

  cancel() {
    this.props.onCancel();
  }

  onUsernameChange(e) {
    this.setState({
      username: e.target.value
    });
  }

  onPasswordChange(e) {
    this.setState({
      password: e.target.value
    });
  }

  onRememberChange(e) {
    this.setState({
      remember: e.target.checked
    });
  }

  focusFirstInput() {
    (this.usernameInput || this.passwordInput).focus();
  }

  toggleShowPassword() {
    this.setState({
      showPassword: !this.state.showPassword
    });
  }

}

exports.default = CredentialDialog;

_defineProperty(CredentialDialog, "propTypes", {
  commandRegistry: _propTypes.default.object.isRequired,
  prompt: _propTypes.default.string.isRequired,
  includeUsername: _propTypes.default.bool,
  includeRemember: _propTypes.default.bool,
  onSubmit: _propTypes.default.func,
  onCancel: _propTypes.default.func
});

_defineProperty(CredentialDialog, "defaultProps", {
  includeUsername: false,
  includeRemember: false,
  onSubmit: () => {},
  onCancel: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNyZWRlbnRpYWwtZGlhbG9nLmpzIl0sIm5hbWVzIjpbIkNyZWRlbnRpYWxEaWFsb2ciLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJjb250ZXh0Iiwic3RhdGUiLCJ1c2VybmFtZSIsInBhc3N3b3JkIiwicmVtZW1iZXIiLCJzaG93UGFzc3dvcmQiLCJjb21wb25lbnREaWRNb3VudCIsInNldFRpbWVvdXQiLCJmb2N1c0ZpcnN0SW5wdXQiLCJyZW5kZXIiLCJjb21tYW5kUmVnaXN0cnkiLCJjYW5jZWwiLCJjb25maXJtIiwicHJvbXB0IiwiaW5jbHVkZVVzZXJuYW1lIiwiZSIsInVzZXJuYW1lSW5wdXQiLCJvblVzZXJuYW1lQ2hhbmdlIiwicGFzc3dvcmRJbnB1dCIsIm9uUGFzc3dvcmRDaGFuZ2UiLCJ0b2dnbGVTaG93UGFzc3dvcmQiLCJpbmNsdWRlUmVtZW1iZXIiLCJvblJlbWVtYmVyQ2hhbmdlIiwicGF5bG9hZCIsIm9uU3VibWl0Iiwib25DYW5jZWwiLCJzZXRTdGF0ZSIsInRhcmdldCIsInZhbHVlIiwiY2hlY2tlZCIsImZvY3VzIiwiUHJvcFR5cGVzIiwib2JqZWN0IiwiaXNSZXF1aXJlZCIsInN0cmluZyIsImJvb2wiLCJmdW5jIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0FBQ0E7O0FBRUE7O0FBQ0E7Ozs7Ozs7O0FBRWUsTUFBTUEsZ0JBQU4sU0FBK0JDLGVBQU1DLFNBQXJDLENBQStDO0FBaUI1REMsRUFBQUEsV0FBVyxDQUFDQyxLQUFELEVBQVFDLE9BQVIsRUFBaUI7QUFDMUIsVUFBTUQsS0FBTixFQUFhQyxPQUFiO0FBQ0EsMkJBQVMsSUFBVCxFQUFlLFNBQWYsRUFBMEIsUUFBMUIsRUFBb0Msa0JBQXBDLEVBQXdELGtCQUF4RCxFQUE0RSxrQkFBNUUsRUFDRSxpQkFERixFQUNxQixvQkFEckI7QUFHQSxTQUFLQyxLQUFMLEdBQWE7QUFDWEMsTUFBQUEsUUFBUSxFQUFFLEVBREM7QUFFWEMsTUFBQUEsUUFBUSxFQUFFLEVBRkM7QUFHWEMsTUFBQUEsUUFBUSxFQUFFLEtBSEM7QUFJWEMsTUFBQUEsWUFBWSxFQUFFO0FBSkgsS0FBYjtBQU1EOztBQUVEQyxFQUFBQSxpQkFBaUIsR0FBRztBQUNsQkMsSUFBQUEsVUFBVSxDQUFDLEtBQUtDLGVBQU4sQ0FBVjtBQUNEOztBQUVEQyxFQUFBQSxNQUFNLEdBQUc7QUFDUCxXQUNFO0FBQUssTUFBQSxTQUFTLEVBQUM7QUFBZixPQUNFLDZCQUFDLGlCQUFEO0FBQVUsTUFBQSxRQUFRLEVBQUUsS0FBS1YsS0FBTCxDQUFXVyxlQUEvQjtBQUFnRCxNQUFBLE1BQU0sRUFBQztBQUF2RCxPQUNFLDZCQUFDLGlCQUFEO0FBQVMsTUFBQSxPQUFPLEVBQUMsYUFBakI7QUFBK0IsTUFBQSxRQUFRLEVBQUUsS0FBS0M7QUFBOUMsTUFERixFQUVFLDZCQUFDLGlCQUFEO0FBQVMsTUFBQSxPQUFPLEVBQUMsY0FBakI7QUFBZ0MsTUFBQSxRQUFRLEVBQUUsS0FBS0M7QUFBL0MsTUFGRixDQURGLEVBS0U7QUFBUSxNQUFBLFNBQVMsRUFBQztBQUFsQixPQUF5QyxLQUFLYixLQUFMLENBQVdjLE1BQXBELENBTEYsRUFNRTtBQUFNLE1BQUEsU0FBUyxFQUFDO0FBQWhCLE9BQ0csS0FBS2QsS0FBTCxDQUFXZSxlQUFYLEdBQ0M7QUFBTyxNQUFBLFNBQVMsRUFBQztBQUFqQixvQkFFRTtBQUNFLE1BQUEsSUFBSSxFQUFDLE1BRFA7QUFFRSxNQUFBLEdBQUcsRUFBRUMsQ0FBQyxJQUFLLEtBQUtDLGFBQUwsR0FBcUJELENBRmxDO0FBR0UsTUFBQSxTQUFTLEVBQUMsNkNBSFo7QUFJRSxNQUFBLEtBQUssRUFBRSxLQUFLZCxLQUFMLENBQVdDLFFBSnBCO0FBS0UsTUFBQSxRQUFRLEVBQUUsS0FBS2UsZ0JBTGpCO0FBTUUsTUFBQSxRQUFRLEVBQUM7QUFOWCxNQUZGLENBREQsR0FZRyxJQWJOLEVBY0U7QUFBTyxNQUFBLFNBQVMsRUFBQztBQUFqQixvQkFFRTtBQUNFLE1BQUEsSUFBSSxFQUFFLEtBQUtoQixLQUFMLENBQVdJLFlBQVgsR0FBMEIsTUFBMUIsR0FBbUMsVUFEM0M7QUFFRSxNQUFBLEdBQUcsRUFBRVUsQ0FBQyxJQUFLLEtBQUtHLGFBQUwsR0FBcUJILENBRmxDO0FBR0UsTUFBQSxTQUFTLEVBQUMsNkNBSFo7QUFJRSxNQUFBLEtBQUssRUFBRSxLQUFLZCxLQUFMLENBQVdFLFFBSnBCO0FBS0UsTUFBQSxRQUFRLEVBQUUsS0FBS2dCLGdCQUxqQjtBQU1FLE1BQUEsUUFBUSxFQUFDO0FBTlgsTUFGRixFQVVFO0FBQVEsTUFBQSxTQUFTLEVBQUMsMEJBQWxCO0FBQTZDLE1BQUEsT0FBTyxFQUFFLEtBQUtDO0FBQTNELE9BQ0csS0FBS25CLEtBQUwsQ0FBV0ksWUFBWCxHQUEwQixNQUExQixHQUFtQyxNQUR0QyxDQVZGLENBZEYsQ0FORixFQW1DRTtBQUFRLE1BQUEsU0FBUyxFQUFDO0FBQWxCLE9BQ0csS0FBS04sS0FBTCxDQUFXc0IsZUFBWCxHQUNDO0FBQU8sTUFBQSxTQUFTLEVBQUM7QUFBakIsT0FDRTtBQUNFLE1BQUEsU0FBUyxFQUFDLGlEQURaO0FBRUUsTUFBQSxJQUFJLEVBQUMsVUFGUDtBQUdFLE1BQUEsT0FBTyxFQUFFLEtBQUtwQixLQUFMLENBQVdHLFFBSHRCO0FBSUUsTUFBQSxRQUFRLEVBQUUsS0FBS2tCO0FBSmpCLE1BREYsYUFERCxHQVVHLElBWE4sRUFZRTtBQUFRLE1BQUEsU0FBUyxFQUFDLHlCQUFsQjtBQUE0QyxNQUFBLFFBQVEsRUFBQyxHQUFyRDtBQUF5RCxNQUFBLE9BQU8sRUFBRSxLQUFLWDtBQUF2RSxnQkFaRixFQWFFO0FBQVEsTUFBQSxTQUFTLEVBQUMsaUJBQWxCO0FBQW9DLE1BQUEsUUFBUSxFQUFDLEdBQTdDO0FBQWlELE1BQUEsT0FBTyxFQUFFLEtBQUtDO0FBQS9ELGlCQWJGLENBbkNGLENBREY7QUFxREQ7O0FBRURBLEVBQUFBLE9BQU8sR0FBRztBQUNSLFVBQU1XLE9BQU8sR0FBRztBQUFDcEIsTUFBQUEsUUFBUSxFQUFFLEtBQUtGLEtBQUwsQ0FBV0U7QUFBdEIsS0FBaEI7O0FBRUEsUUFBSSxLQUFLSixLQUFMLENBQVdlLGVBQWYsRUFBZ0M7QUFDOUJTLE1BQUFBLE9BQU8sQ0FBQ3JCLFFBQVIsR0FBbUIsS0FBS0QsS0FBTCxDQUFXQyxRQUE5QjtBQUNEOztBQUVELFFBQUksS0FBS0gsS0FBTCxDQUFXc0IsZUFBZixFQUFnQztBQUM5QkUsTUFBQUEsT0FBTyxDQUFDbkIsUUFBUixHQUFtQixLQUFLSCxLQUFMLENBQVdHLFFBQTlCO0FBQ0Q7O0FBRUQsU0FBS0wsS0FBTCxDQUFXeUIsUUFBWCxDQUFvQkQsT0FBcEI7QUFDRDs7QUFFRFosRUFBQUEsTUFBTSxHQUFHO0FBQ1AsU0FBS1osS0FBTCxDQUFXMEIsUUFBWDtBQUNEOztBQUVEUixFQUFBQSxnQkFBZ0IsQ0FBQ0YsQ0FBRCxFQUFJO0FBQ2xCLFNBQUtXLFFBQUwsQ0FBYztBQUFDeEIsTUFBQUEsUUFBUSxFQUFFYSxDQUFDLENBQUNZLE1BQUYsQ0FBU0M7QUFBcEIsS0FBZDtBQUNEOztBQUVEVCxFQUFBQSxnQkFBZ0IsQ0FBQ0osQ0FBRCxFQUFJO0FBQ2xCLFNBQUtXLFFBQUwsQ0FBYztBQUFDdkIsTUFBQUEsUUFBUSxFQUFFWSxDQUFDLENBQUNZLE1BQUYsQ0FBU0M7QUFBcEIsS0FBZDtBQUNEOztBQUVETixFQUFBQSxnQkFBZ0IsQ0FBQ1AsQ0FBRCxFQUFJO0FBQ2xCLFNBQUtXLFFBQUwsQ0FBYztBQUFDdEIsTUFBQUEsUUFBUSxFQUFFVyxDQUFDLENBQUNZLE1BQUYsQ0FBU0U7QUFBcEIsS0FBZDtBQUNEOztBQUVEckIsRUFBQUEsZUFBZSxHQUFHO0FBQ2hCLEtBQUMsS0FBS1EsYUFBTCxJQUFzQixLQUFLRSxhQUE1QixFQUEyQ1ksS0FBM0M7QUFDRDs7QUFFRFYsRUFBQUEsa0JBQWtCLEdBQUc7QUFDbkIsU0FBS00sUUFBTCxDQUFjO0FBQUNyQixNQUFBQSxZQUFZLEVBQUUsQ0FBQyxLQUFLSixLQUFMLENBQVdJO0FBQTNCLEtBQWQ7QUFDRDs7QUE5SDJEOzs7O2dCQUF6Q1YsZ0IsZUFDQTtBQUNqQmUsRUFBQUEsZUFBZSxFQUFFcUIsbUJBQVVDLE1BQVYsQ0FBaUJDLFVBRGpCO0FBRWpCcEIsRUFBQUEsTUFBTSxFQUFFa0IsbUJBQVVHLE1BQVYsQ0FBaUJELFVBRlI7QUFHakJuQixFQUFBQSxlQUFlLEVBQUVpQixtQkFBVUksSUFIVjtBQUlqQmQsRUFBQUEsZUFBZSxFQUFFVSxtQkFBVUksSUFKVjtBQUtqQlgsRUFBQUEsUUFBUSxFQUFFTyxtQkFBVUssSUFMSDtBQU1qQlgsRUFBQUEsUUFBUSxFQUFFTSxtQkFBVUs7QUFOSCxDOztnQkFEQXpDLGdCLGtCQVVHO0FBQ3BCbUIsRUFBQUEsZUFBZSxFQUFFLEtBREc7QUFFcEJPLEVBQUFBLGVBQWUsRUFBRSxLQUZHO0FBR3BCRyxFQUFBQSxRQUFRLEVBQUUsTUFBTSxDQUFFLENBSEU7QUFJcEJDLEVBQUFBLFFBQVEsRUFBRSxNQUFNLENBQUU7QUFKRSxDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzYuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcblxuaW1wb3J0IENvbW1hbmRzLCB7Q29tbWFuZH0gZnJvbSAnLi4vYXRvbS9jb21tYW5kcyc7XG5pbXBvcnQge2F1dG9iaW5kfSBmcm9tICcuLi9oZWxwZXJzJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgQ3JlZGVudGlhbERpYWxvZyBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgY29tbWFuZFJlZ2lzdHJ5OiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgcHJvbXB0OiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgaW5jbHVkZVVzZXJuYW1lOiBQcm9wVHlwZXMuYm9vbCxcbiAgICBpbmNsdWRlUmVtZW1iZXI6IFByb3BUeXBlcy5ib29sLFxuICAgIG9uU3VibWl0OiBQcm9wVHlwZXMuZnVuYyxcbiAgICBvbkNhbmNlbDogUHJvcFR5cGVzLmZ1bmMsXG4gIH1cblxuICBzdGF0aWMgZGVmYXVsdFByb3BzID0ge1xuICAgIGluY2x1ZGVVc2VybmFtZTogZmFsc2UsXG4gICAgaW5jbHVkZVJlbWVtYmVyOiBmYWxzZSxcbiAgICBvblN1Ym1pdDogKCkgPT4ge30sXG4gICAgb25DYW5jZWw6ICgpID0+IHt9LFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMsIGNvbnRleHQpIHtcbiAgICBzdXBlcihwcm9wcywgY29udGV4dCk7XG4gICAgYXV0b2JpbmQodGhpcywgJ2NvbmZpcm0nLCAnY2FuY2VsJywgJ29uVXNlcm5hbWVDaGFuZ2UnLCAnb25QYXNzd29yZENoYW5nZScsICdvblJlbWVtYmVyQ2hhbmdlJyxcbiAgICAgICdmb2N1c0ZpcnN0SW5wdXQnLCAndG9nZ2xlU2hvd1Bhc3N3b3JkJyk7XG5cbiAgICB0aGlzLnN0YXRlID0ge1xuICAgICAgdXNlcm5hbWU6ICcnLFxuICAgICAgcGFzc3dvcmQ6ICcnLFxuICAgICAgcmVtZW1iZXI6IGZhbHNlLFxuICAgICAgc2hvd1Bhc3N3b3JkOiBmYWxzZSxcbiAgICB9O1xuICB9XG5cbiAgY29tcG9uZW50RGlkTW91bnQoKSB7XG4gICAgc2V0VGltZW91dCh0aGlzLmZvY3VzRmlyc3RJbnB1dCk7XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLURpYWxvZyBnaXRodWItQ3JlZGVudGlhbHMgbW9kYWwgbmF0aXZlLWtleS1iaW5kaW5nc1wiPlxuICAgICAgICA8Q29tbWFuZHMgcmVnaXN0cnk9e3RoaXMucHJvcHMuY29tbWFuZFJlZ2lzdHJ5fSB0YXJnZXQ9XCIuZ2l0aHViLUNyZWRlbnRpYWxzXCI+XG4gICAgICAgICAgPENvbW1hbmQgY29tbWFuZD1cImNvcmU6Y2FuY2VsXCIgY2FsbGJhY2s9e3RoaXMuY2FuY2VsfSAvPlxuICAgICAgICAgIDxDb21tYW5kIGNvbW1hbmQ9XCJjb3JlOmNvbmZpcm1cIiBjYWxsYmFjaz17dGhpcy5jb25maXJtfSAvPlxuICAgICAgICA8L0NvbW1hbmRzPlxuICAgICAgICA8aGVhZGVyIGNsYXNzTmFtZT1cImdpdGh1Yi1EaWFsb2dQcm9tcHRcIj57dGhpcy5wcm9wcy5wcm9tcHR9PC9oZWFkZXI+XG4gICAgICAgIDxtYWluIGNsYXNzTmFtZT1cImdpdGh1Yi1EaWFsb2dJbnB1dHNcIj5cbiAgICAgICAgICB7dGhpcy5wcm9wcy5pbmNsdWRlVXNlcm5hbWUgPyAoXG4gICAgICAgICAgICA8bGFiZWwgY2xhc3NOYW1lPVwiZ2l0aHViLURpYWxvZ0xhYmVsXCI+XG4gICAgICAgICAgICAgIFVzZXJuYW1lOlxuICAgICAgICAgICAgICA8aW5wdXRcbiAgICAgICAgICAgICAgICB0eXBlPVwidGV4dFwiXG4gICAgICAgICAgICAgICAgcmVmPXtlID0+ICh0aGlzLnVzZXJuYW1lSW5wdXQgPSBlKX1cbiAgICAgICAgICAgICAgICBjbGFzc05hbWU9XCJpbnB1dC10ZXh0IGdpdGh1Yi1DcmVkZW50aWFsRGlhbG9nLVVzZXJuYW1lXCJcbiAgICAgICAgICAgICAgICB2YWx1ZT17dGhpcy5zdGF0ZS51c2VybmFtZX1cbiAgICAgICAgICAgICAgICBvbkNoYW5nZT17dGhpcy5vblVzZXJuYW1lQ2hhbmdlfVxuICAgICAgICAgICAgICAgIHRhYkluZGV4PVwiMVwiXG4gICAgICAgICAgICAgIC8+XG4gICAgICAgICAgICA8L2xhYmVsPlxuICAgICAgICAgICkgOiBudWxsfVxuICAgICAgICAgIDxsYWJlbCBjbGFzc05hbWU9XCJnaXRodWItRGlhbG9nTGFiZWxcIj5cbiAgICAgICAgICAgIFBhc3N3b3JkOlxuICAgICAgICAgICAgPGlucHV0XG4gICAgICAgICAgICAgIHR5cGU9e3RoaXMuc3RhdGUuc2hvd1Bhc3N3b3JkID8gJ3RleHQnIDogJ3Bhc3N3b3JkJ31cbiAgICAgICAgICAgICAgcmVmPXtlID0+ICh0aGlzLnBhc3N3b3JkSW5wdXQgPSBlKX1cbiAgICAgICAgICAgICAgY2xhc3NOYW1lPVwiaW5wdXQtdGV4dCBnaXRodWItQ3JlZGVudGlhbERpYWxvZy1QYXNzd29yZFwiXG4gICAgICAgICAgICAgIHZhbHVlPXt0aGlzLnN0YXRlLnBhc3N3b3JkfVxuICAgICAgICAgICAgICBvbkNoYW5nZT17dGhpcy5vblBhc3N3b3JkQ2hhbmdlfVxuICAgICAgICAgICAgICB0YWJJbmRleD1cIjJcIlxuICAgICAgICAgICAgLz5cbiAgICAgICAgICAgIDxidXR0b24gY2xhc3NOYW1lPVwiZ2l0aHViLURpYWxvZ0xhYmVsQnV0dG9uXCIgb25DbGljaz17dGhpcy50b2dnbGVTaG93UGFzc3dvcmR9PlxuICAgICAgICAgICAgICB7dGhpcy5zdGF0ZS5zaG93UGFzc3dvcmQgPyAnSGlkZScgOiAnU2hvdyd9XG4gICAgICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgICA8L2xhYmVsPlxuICAgICAgICA8L21haW4+XG4gICAgICAgIDxmb290ZXIgY2xhc3NOYW1lPVwiZ2l0aHViLURpYWxvZ0J1dHRvbnNcIj5cbiAgICAgICAgICB7dGhpcy5wcm9wcy5pbmNsdWRlUmVtZW1iZXIgPyAoXG4gICAgICAgICAgICA8bGFiZWwgY2xhc3NOYW1lPVwiZ2l0aHViLURpYWxvZ0J1dHRvbnMtbGVmdEl0ZW0gaW5wdXQtbGFiZWxcIj5cbiAgICAgICAgICAgICAgPGlucHV0XG4gICAgICAgICAgICAgICAgY2xhc3NOYW1lPVwiZ2l0aHViLUNyZWRlbnRpYWxEaWFsb2ctcmVtZW1iZXIgaW5wdXQtY2hlY2tib3hcIlxuICAgICAgICAgICAgICAgIHR5cGU9XCJjaGVja2JveFwiXG4gICAgICAgICAgICAgICAgY2hlY2tlZD17dGhpcy5zdGF0ZS5yZW1lbWJlcn1cbiAgICAgICAgICAgICAgICBvbkNoYW5nZT17dGhpcy5vblJlbWVtYmVyQ2hhbmdlfVxuICAgICAgICAgICAgICAvPlxuICAgICAgICAgICAgICBSZW1lbWJlclxuICAgICAgICAgICAgPC9sYWJlbD5cbiAgICAgICAgICApIDogbnVsbH1cbiAgICAgICAgICA8YnV0dG9uIGNsYXNzTmFtZT1cImJ0biBnaXRodWItQ2FuY2VsQnV0dG9uXCIgdGFiSW5kZXg9XCIzXCIgb25DbGljaz17dGhpcy5jYW5jZWx9PkNhbmNlbDwvYnV0dG9uPlxuICAgICAgICAgIDxidXR0b24gY2xhc3NOYW1lPVwiYnRuIGJ0bi1wcmltYXJ5XCIgdGFiSW5kZXg9XCI0XCIgb25DbGljaz17dGhpcy5jb25maXJtfT5TaWduIGluPC9idXR0b24+XG4gICAgICAgIDwvZm9vdGVyPlxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxuXG4gIGNvbmZpcm0oKSB7XG4gICAgY29uc3QgcGF5bG9hZCA9IHtwYXNzd29yZDogdGhpcy5zdGF0ZS5wYXNzd29yZH07XG5cbiAgICBpZiAodGhpcy5wcm9wcy5pbmNsdWRlVXNlcm5hbWUpIHtcbiAgICAgIHBheWxvYWQudXNlcm5hbWUgPSB0aGlzLnN0YXRlLnVzZXJuYW1lO1xuICAgIH1cblxuICAgIGlmICh0aGlzLnByb3BzLmluY2x1ZGVSZW1lbWJlcikge1xuICAgICAgcGF5bG9hZC5yZW1lbWJlciA9IHRoaXMuc3RhdGUucmVtZW1iZXI7XG4gICAgfVxuXG4gICAgdGhpcy5wcm9wcy5vblN1Ym1pdChwYXlsb2FkKTtcbiAgfVxuXG4gIGNhbmNlbCgpIHtcbiAgICB0aGlzLnByb3BzLm9uQ2FuY2VsKCk7XG4gIH1cblxuICBvblVzZXJuYW1lQ2hhbmdlKGUpIHtcbiAgICB0aGlzLnNldFN0YXRlKHt1c2VybmFtZTogZS50YXJnZXQudmFsdWV9KTtcbiAgfVxuXG4gIG9uUGFzc3dvcmRDaGFuZ2UoZSkge1xuICAgIHRoaXMuc2V0U3RhdGUoe3Bhc3N3b3JkOiBlLnRhcmdldC52YWx1ZX0pO1xuICB9XG5cbiAgb25SZW1lbWJlckNoYW5nZShlKSB7XG4gICAgdGhpcy5zZXRTdGF0ZSh7cmVtZW1iZXI6IGUudGFyZ2V0LmNoZWNrZWR9KTtcbiAgfVxuXG4gIGZvY3VzRmlyc3RJbnB1dCgpIHtcbiAgICAodGhpcy51c2VybmFtZUlucHV0IHx8IHRoaXMucGFzc3dvcmRJbnB1dCkuZm9jdXMoKTtcbiAgfVxuXG4gIHRvZ2dsZVNob3dQYXNzd29yZCgpIHtcbiAgICB0aGlzLnNldFN0YXRlKHtzaG93UGFzc3dvcmQ6ICF0aGlzLnN0YXRlLnNob3dQYXNzd29yZH0pO1xuICB9XG59XG4iXX0=