"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Git is asynchronously cloning a repository into this working directory.
 */
class Cloning extends _state.default {
  constructor(repository, remoteUrl) {
    super(repository);
    this.remoteUrl = remoteUrl;
  }

  async start() {
    await _fsExtra.default.mkdirs(this.workdir());
    await this.doClone(this.remoteUrl, {
      recursive: true
    });
    await this.transitionTo('Loading');
  }

  showGitTabLoading() {
    return true;
  }

  directClone(remoteUrl, options) {
    return this.git().clone(remoteUrl, options);
  }

}

exports.default = Cloning;

_state.default.register(Cloning);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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