"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _electron = require("electron");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _search = _interopRequireDefault(require("../models/search"));

var _issueishSearchContainer = _interopRequireDefault(require("../containers/issueish-search-container"));

var _currentPullRequestContainer = _interopRequireDefault(require("../containers/current-pull-request-container"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishSearchesController extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'onOpenIssueish', 'onOpenSearch');
    this.state = {};
  }

  static getDerivedStateFromProps(props) {
    return {
      searches: [_search.default.inRemote(props.remote, 'Open pull requests', 'type:pr state:open')]
    };
  }

  render() {
    return _react.default.createElement("div", {
      className: "github-IssueishSearch"
    }, _react.default.createElement(_currentPullRequestContainer.default, {
      repository: this.props.repository,
      token: this.props.token,
      endpoint: this.props.endpoint,
      remoteOperationObserver: this.props.remoteOperationObserver,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onOpenIssueish: this.onOpenIssueish,
      onCreatePr: this.props.onCreatePr
    }), this.state.searches.map(search => _react.default.createElement(_issueishSearchContainer.default, {
      key: search.getName(),
      token: this.props.token,
      endpoint: this.props.endpoint,
      search: search,
      remoteOperationObserver: this.props.remoteOperationObserver,
      onOpenIssueish: this.onOpenIssueish,
      onOpenSearch: this.onOpenSearch
    })));
  }

  onOpenIssueish(issueish) {
    return this.props.workspace.open(_issueishDetailItem.default.buildURI(this.props.endpoint.getHost(), this.props.remote.getOwner(), this.props.remote.getRepo(), issueish.getNumber(), this.props.workingDirectory), {
      pending: true,
      searchAllPanes: true
    }).then(() => {
      (0, _reporterProxy.addEvent)('open-issueish-in-pane', {
        package: 'github',
        from: 'issueish-list'
      });
    });
  }

  onOpenSearch(search) {
    const searchURL = search.getWebURL(this.props.remote);
    return new Promise((resolve, reject) => {
      _electron.shell.openExternal(searchURL, {}, err => {
        if (err) {
          reject(err);
        } else {
          resolve();
        }
      });
    });
  }

}

exports.default = IssueishSearchesController;

_defineProperty(IssueishSearchesController, "propTypes", {
  // Relay payload
  repository: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    defaultBranchRef: _propTypes.default.shape({
      prefix: _propTypes.default.string.isRequired,
      name: _propTypes.default.string.isRequired
    })
  }),
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes.default.string.isRequired,
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  // Repository model attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  workingDirectory: _propTypes.default.string.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes.default.number,
  pushInProgress: _propTypes.default.bool.isRequired,
  // Actions
  onCreatePr: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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