"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BarePullRequestReviewCommentsContainer = void 0;

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BarePullRequestReviewCommentsContainer extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "accumulateComments", error => {
      /* istanbul ignore if */
      if (error) {
        // eslint-disable-next-line no-console
        console.error(error);
        return;
      }

      const {
        submittedAt,
        comments,
        id
      } = this.props.review;
      this.props.collectComments({
        reviewId: id,
        submittedAt,
        comments,
        fetchingMoreComments: this.props.relay.hasMore()
      });

      this._attemptToLoadMoreComments();
    });

    _defineProperty(this, "_attemptToLoadMoreComments", () => {
      if (!this.props.relay.hasMore()) {
        return;
      }

      if (this.props.relay.isLoading()) {
        setTimeout(this._loadMoreComments, _helpers.PAGINATION_WAIT_TIME_MS);
      } else {
        this._loadMoreComments();
      }
    });

    _defineProperty(this, "_loadMoreComments", () => {
      this.props.relay.loadMore(_helpers.PAGE_SIZE, this.accumulateComments);
    });
  }

  componentDidMount() {
    this.accumulateComments();
  }

  render() {
    return null;
  }

}

exports.BarePullRequestReviewCommentsContainer = BarePullRequestReviewCommentsContainer;

_defineProperty(BarePullRequestReviewCommentsContainer, "propTypes", {
  collectComments: _propTypes.default.func.isRequired,
  review: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    submittedAt: _propTypes.default.string.isRequired,
    comments: _propTypes.default.object.isRequired
  }),
  relay: _propTypes.default.shape({
    hasMore: _propTypes.default.func.isRequired,
    loadMore: _propTypes.default.func.isRequired,
    isLoading: _propTypes.default.func.isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createPaginationContainer)(BarePullRequestReviewCommentsContainer, {
  review: function () {
    const node = require("./__generated__/prReviewCommentsContainer_review.graphql");

    if (node.hash && node.hash !== "ccea6475d7b22690b4aa61757b705968") {
      console.error("The definition of 'prReviewCommentsContainer_review' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prReviewCommentsContainer_review.graphql");
  }
}, {
  direction: 'forward',

  getConnectionFromProps(props) {
    return props.review.comments;
  },

  getFragmentVariables(prevVars, totalCount) {
    return _objectSpread({}, prevVars, {
      commentCount: totalCount
    });
  },

  getVariables(props, {
    count,
    cursor
  }, fragmentVariables) {
    return {
      id: props.review.id,
      commentCount: count,
      commentCursor: cursor
    };
  },

  query: function () {
    const node = require("./__generated__/prReviewCommentsContainerQuery.graphql");

    if (node.hash && node.hash !== "d48507a6296f84357e94000010c34713") {
      console.error("The definition of 'prReviewCommentsContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prReviewCommentsContainerQuery.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInByLXJldmlldy1jb21tZW50cy1jb250YWluZXIuanMiXSwibmFtZXMiOlsiQmFyZVB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudHNDb250YWluZXIiLCJSZWFjdCIsIkNvbXBvbmVudCIsImVycm9yIiwiY29uc29sZSIsInN1Ym1pdHRlZEF0IiwiY29tbWVudHMiLCJpZCIsInByb3BzIiwicmV2aWV3IiwiY29sbGVjdENvbW1lbnRzIiwicmV2aWV3SWQiLCJmZXRjaGluZ01vcmVDb21tZW50cyIsInJlbGF5IiwiaGFzTW9yZSIsIl9hdHRlbXB0VG9Mb2FkTW9yZUNvbW1lbnRzIiwiaXNMb2FkaW5nIiwic2V0VGltZW91dCIsIl9sb2FkTW9yZUNvbW1lbnRzIiwiUEFHSU5BVElPTl9XQUlUX1RJTUVfTVMiLCJsb2FkTW9yZSIsIlBBR0VfU0laRSIsImFjY3VtdWxhdGVDb21tZW50cyIsImNvbXBvbmVudERpZE1vdW50IiwicmVuZGVyIiwiUHJvcFR5cGVzIiwiZnVuYyIsImlzUmVxdWlyZWQiLCJzaGFwZSIsInN0cmluZyIsIm9iamVjdCIsImRpcmVjdGlvbiIsImdldENvbm5lY3Rpb25Gcm9tUHJvcHMiLCJnZXRGcmFnbWVudFZhcmlhYmxlcyIsInByZXZWYXJzIiwidG90YWxDb3VudCIsImNvbW1lbnRDb3VudCIsImdldFZhcmlhYmxlcyIsImNvdW50IiwiY3Vyc29yIiwiZnJhZ21lbnRWYXJpYWJsZXMiLCJjb21tZW50Q3Vyc29yIiwicXVlcnkiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFDQTs7QUFFQTs7Ozs7Ozs7QUFFTyxNQUFNQSxzQ0FBTixTQUFxREMsZUFBTUMsU0FBM0QsQ0FBcUU7QUFBQTtBQUFBOztBQUFBLGdEQW9CckRDLEtBQUssSUFBSTtBQUM1QjtBQUNBLFVBQUlBLEtBQUosRUFBVztBQUNUO0FBQ0FDLFFBQUFBLE9BQU8sQ0FBQ0QsS0FBUixDQUFjQSxLQUFkO0FBQ0E7QUFDRDs7QUFFRCxZQUFNO0FBQUNFLFFBQUFBLFdBQUQ7QUFBY0MsUUFBQUEsUUFBZDtBQUF3QkMsUUFBQUE7QUFBeEIsVUFBOEIsS0FBS0MsS0FBTCxDQUFXQyxNQUEvQztBQUNBLFdBQUtELEtBQUwsQ0FBV0UsZUFBWCxDQUEyQjtBQUN6QkMsUUFBQUEsUUFBUSxFQUFFSixFQURlO0FBRXpCRixRQUFBQSxXQUZ5QjtBQUd6QkMsUUFBQUEsUUFIeUI7QUFJekJNLFFBQUFBLG9CQUFvQixFQUFFLEtBQUtKLEtBQUwsQ0FBV0ssS0FBWCxDQUFpQkMsT0FBakI7QUFKRyxPQUEzQjs7QUFPQSxXQUFLQywwQkFBTDtBQUNELEtBckN5RTs7QUFBQSx3REF1QzdDLE1BQU07QUFDakMsVUFBSSxDQUFDLEtBQUtQLEtBQUwsQ0FBV0ssS0FBWCxDQUFpQkMsT0FBakIsRUFBTCxFQUFpQztBQUMvQjtBQUNEOztBQUVELFVBQUksS0FBS04sS0FBTCxDQUFXSyxLQUFYLENBQWlCRyxTQUFqQixFQUFKLEVBQWtDO0FBQ2hDQyxRQUFBQSxVQUFVLENBQUMsS0FBS0MsaUJBQU4sRUFBeUJDLGdDQUF6QixDQUFWO0FBQ0QsT0FGRCxNQUVPO0FBQ0wsYUFBS0QsaUJBQUw7QUFDRDtBQUNGLEtBakR5RTs7QUFBQSwrQ0FtRHRELE1BQU07QUFDeEIsV0FBS1YsS0FBTCxDQUFXSyxLQUFYLENBQWlCTyxRQUFqQixDQUNFQyxrQkFERixFQUVFLEtBQUtDLGtCQUZQO0FBSUQsS0F4RHlFO0FBQUE7O0FBZ0IxRUMsRUFBQUEsaUJBQWlCLEdBQUc7QUFDbEIsU0FBS0Qsa0JBQUw7QUFDRDs7QUF3Q0RFLEVBQUFBLE1BQU0sR0FBRztBQUNQLFdBQU8sSUFBUDtBQUNEOztBQTVEeUU7Ozs7Z0JBQS9EeEIsc0MsZUFFUTtBQUNqQlUsRUFBQUEsZUFBZSxFQUFFZSxtQkFBVUMsSUFBVixDQUFlQyxVQURmO0FBRWpCbEIsRUFBQUEsTUFBTSxFQUFFZ0IsbUJBQVVHLEtBQVYsQ0FBZ0I7QUFDdEJyQixJQUFBQSxFQUFFLEVBQUVrQixtQkFBVUksTUFBVixDQUFpQkYsVUFEQztBQUV0QnRCLElBQUFBLFdBQVcsRUFBRW9CLG1CQUFVSSxNQUFWLENBQWlCRixVQUZSO0FBR3RCckIsSUFBQUEsUUFBUSxFQUFFbUIsbUJBQVVLLE1BQVYsQ0FBaUJIO0FBSEwsR0FBaEIsQ0FGUztBQU9qQmQsRUFBQUEsS0FBSyxFQUFFWSxtQkFBVUcsS0FBVixDQUFnQjtBQUNyQmQsSUFBQUEsT0FBTyxFQUFFVyxtQkFBVUMsSUFBVixDQUFlQyxVQURIO0FBRXJCUCxJQUFBQSxRQUFRLEVBQUVLLG1CQUFVQyxJQUFWLENBQWVDLFVBRko7QUFHckJYLElBQUFBLFNBQVMsRUFBRVMsbUJBQVVDLElBQVYsQ0FBZUM7QUFITCxHQUFoQixFQUlKQTtBQVhjLEM7O2VBNkROLDJDQUEwQjNCLHNDQUExQixFQUFrRTtBQUMvRVMsRUFBQUEsTUFBTTtBQUFBOztBQUFBO0FBQUE7QUFBQTs7QUFBQTtBQUFBO0FBRHlFLENBQWxFLEVBd0NaO0FBQ0RzQixFQUFBQSxTQUFTLEVBQUUsU0FEVjs7QUFFREMsRUFBQUEsc0JBQXNCLENBQUN4QixLQUFELEVBQVE7QUFDNUIsV0FBT0EsS0FBSyxDQUFDQyxNQUFOLENBQWFILFFBQXBCO0FBQ0QsR0FKQTs7QUFLRDJCLEVBQUFBLG9CQUFvQixDQUFDQyxRQUFELEVBQVdDLFVBQVgsRUFBdUI7QUFDekMsNkJBQ0tELFFBREw7QUFFRUUsTUFBQUEsWUFBWSxFQUFFRDtBQUZoQjtBQUlELEdBVkE7O0FBV0RFLEVBQUFBLFlBQVksQ0FBQzdCLEtBQUQsRUFBUTtBQUFDOEIsSUFBQUEsS0FBRDtBQUFRQyxJQUFBQTtBQUFSLEdBQVIsRUFBeUJDLGlCQUF6QixFQUE0QztBQUN0RCxXQUFPO0FBQ0xqQyxNQUFBQSxFQUFFLEVBQUVDLEtBQUssQ0FBQ0MsTUFBTixDQUFhRixFQURaO0FBRUw2QixNQUFBQSxZQUFZLEVBQUVFLEtBRlQ7QUFHTEcsTUFBQUEsYUFBYSxFQUFFRjtBQUhWLEtBQVA7QUFLRCxHQWpCQTs7QUFrQkRHLEVBQUFBLEtBQUs7QUFBQTs7QUFBQTtBQUFBO0FBQUE7O0FBQUE7QUFBQTtBQWxCSixDQXhDWSxDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzYuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge2dyYXBocWwsIGNyZWF0ZVBhZ2luYXRpb25Db250YWluZXJ9IGZyb20gJ3JlYWN0LXJlbGF5JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuXG5pbXBvcnQge1BBR0VfU0laRSwgUEFHSU5BVElPTl9XQUlUX1RJTUVfTVN9IGZyb20gJy4uL2hlbHBlcnMnO1xuXG5leHBvcnQgY2xhc3MgQmFyZVB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudHNDb250YWluZXIgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuXG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgY29sbGVjdENvbW1lbnRzOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIHJldmlldzogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgIGlkOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICBzdWJtaXR0ZWRBdDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgY29tbWVudHM6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICB9KSxcbiAgICByZWxheTogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgIGhhc01vcmU6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgICBsb2FkTW9yZTogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICAgIGlzTG9hZGluZzogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICB9KS5pc1JlcXVpcmVkLFxuICB9XG5cbiAgY29tcG9uZW50RGlkTW91bnQoKSB7XG4gICAgdGhpcy5hY2N1bXVsYXRlQ29tbWVudHMoKTtcbiAgfVxuXG4gIGFjY3VtdWxhdGVDb21tZW50cyA9IGVycm9yID0+IHtcbiAgICAvKiBpc3RhbmJ1bCBpZ25vcmUgaWYgKi9cbiAgICBpZiAoZXJyb3IpIHtcbiAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1jb25zb2xlXG4gICAgICBjb25zb2xlLmVycm9yKGVycm9yKTtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBjb25zdCB7c3VibWl0dGVkQXQsIGNvbW1lbnRzLCBpZH0gPSB0aGlzLnByb3BzLnJldmlldztcbiAgICB0aGlzLnByb3BzLmNvbGxlY3RDb21tZW50cyh7XG4gICAgICByZXZpZXdJZDogaWQsXG4gICAgICBzdWJtaXR0ZWRBdCxcbiAgICAgIGNvbW1lbnRzLFxuICAgICAgZmV0Y2hpbmdNb3JlQ29tbWVudHM6IHRoaXMucHJvcHMucmVsYXkuaGFzTW9yZSgpLFxuICAgIH0pO1xuXG4gICAgdGhpcy5fYXR0ZW1wdFRvTG9hZE1vcmVDb21tZW50cygpO1xuICB9XG5cbiAgX2F0dGVtcHRUb0xvYWRNb3JlQ29tbWVudHMgPSAoKSA9PiB7XG4gICAgaWYgKCF0aGlzLnByb3BzLnJlbGF5Lmhhc01vcmUoKSkge1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGlmICh0aGlzLnByb3BzLnJlbGF5LmlzTG9hZGluZygpKSB7XG4gICAgICBzZXRUaW1lb3V0KHRoaXMuX2xvYWRNb3JlQ29tbWVudHMsIFBBR0lOQVRJT05fV0FJVF9USU1FX01TKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5fbG9hZE1vcmVDb21tZW50cygpO1xuICAgIH1cbiAgfVxuXG4gIF9sb2FkTW9yZUNvbW1lbnRzID0gKCkgPT4ge1xuICAgIHRoaXMucHJvcHMucmVsYXkubG9hZE1vcmUoXG4gICAgICBQQUdFX1NJWkUsXG4gICAgICB0aGlzLmFjY3VtdWxhdGVDb21tZW50cyxcbiAgICApO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiBudWxsO1xuICB9XG59XG5cbmV4cG9ydCBkZWZhdWx0IGNyZWF0ZVBhZ2luYXRpb25Db250YWluZXIoQmFyZVB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudHNDb250YWluZXIsIHtcbiAgcmV2aWV3OiBncmFwaHFsYFxuICAgIGZyYWdtZW50IHByUmV2aWV3Q29tbWVudHNDb250YWluZXJfcmV2aWV3IG9uIFB1bGxSZXF1ZXN0UmV2aWV3XG4gICAgQGFyZ3VtZW50RGVmaW5pdGlvbnMoXG4gICAgICBjb21tZW50Q291bnQ6IHt0eXBlOiBcIkludCFcIn0sXG4gICAgICBjb21tZW50Q3Vyc29yOiB7dHlwZTogXCJTdHJpbmdcIn1cbiAgICApIHtcbiAgICAgIGlkXG4gICAgICBzdWJtaXR0ZWRBdFxuICAgICAgY29tbWVudHMoXG4gICAgICAgIGZpcnN0OiAkY29tbWVudENvdW50LFxuICAgICAgICBhZnRlcjogJGNvbW1lbnRDdXJzb3JcbiAgICAgICkgQGNvbm5lY3Rpb24oa2V5OiBcIlByUmV2aWV3Q29tbWVudHNDb250YWluZXJfY29tbWVudHNcIikge1xuICAgICAgICBwYWdlSW5mbyB7XG4gICAgICAgICAgaGFzTmV4dFBhZ2VcbiAgICAgICAgICBlbmRDdXJzb3JcbiAgICAgICAgfVxuXG4gICAgICAgIGVkZ2VzIHtcbiAgICAgICAgICBjdXJzb3JcbiAgICAgICAgICBub2RlIHtcbiAgICAgICAgICAgIGlkXG4gICAgICAgICAgICBhdXRob3Ige1xuICAgICAgICAgICAgICBhdmF0YXJVcmxcbiAgICAgICAgICAgICAgbG9naW5cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGJvZHlIVE1MXG4gICAgICAgICAgICBpc01pbmltaXplZFxuICAgICAgICAgICAgcGF0aFxuICAgICAgICAgICAgcG9zaXRpb25cbiAgICAgICAgICAgIHJlcGx5VG8ge1xuICAgICAgICAgICAgICBpZFxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgY3JlYXRlZEF0XG4gICAgICAgICAgICB1cmxcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG4gIGAsXG59LCB7XG4gIGRpcmVjdGlvbjogJ2ZvcndhcmQnLFxuICBnZXRDb25uZWN0aW9uRnJvbVByb3BzKHByb3BzKSB7XG4gICAgcmV0dXJuIHByb3BzLnJldmlldy5jb21tZW50cztcbiAgfSxcbiAgZ2V0RnJhZ21lbnRWYXJpYWJsZXMocHJldlZhcnMsIHRvdGFsQ291bnQpIHtcbiAgICByZXR1cm4ge1xuICAgICAgLi4ucHJldlZhcnMsXG4gICAgICBjb21tZW50Q291bnQ6IHRvdGFsQ291bnQsXG4gICAgfTtcbiAgfSxcbiAgZ2V0VmFyaWFibGVzKHByb3BzLCB7Y291bnQsIGN1cnNvcn0sIGZyYWdtZW50VmFyaWFibGVzKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGlkOiBwcm9wcy5yZXZpZXcuaWQsXG4gICAgICBjb21tZW50Q291bnQ6IGNvdW50LFxuICAgICAgY29tbWVudEN1cnNvcjogY3Vyc29yLFxuICAgIH07XG4gIH0sXG4gIHF1ZXJ5OiBncmFwaHFsYFxuICAgIHF1ZXJ5IHByUmV2aWV3Q29tbWVudHNDb250YWluZXJRdWVyeSgkY29tbWVudENvdW50OiBJbnQhLCAkY29tbWVudEN1cnNvcjogU3RyaW5nLCAkaWQ6IElEISkge1xuICAgICAgbm9kZShpZDogJGlkKSB7XG4gICAgICAgIC4uLiBvbiBQdWxsUmVxdWVzdFJldmlldyB7XG4gICAgICAgICAgLi4ucHJSZXZpZXdDb21tZW50c0NvbnRhaW5lcl9yZXZpZXcgQGFyZ3VtZW50cyhcbiAgICAgICAgICAgIGNvbW1lbnRDb3VudDogJGNvbW1lbnRDb3VudCxcbiAgICAgICAgICAgIGNvbW1lbnRDdXJzb3I6ICRjb21tZW50Q3Vyc29yXG4gICAgICAgICAgKVxuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICBgLFxufSk7XG4iXX0=