"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _issueishListController = _interopRequireWildcard(require("../controllers/issueish-list-controller"));

var _createPullRequestTile = _interopRequireDefault(require("../views/create-pull-request-tile"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _graphql;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CurrentPullRequestContainer extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult', 'renderEmptyTile');
    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager.default.getEnvironmentForHost(this.props.endpoint, this.props.token);

    const head = this.props.branches.getHeadBranch();

    if (!head.isPresent()) {
      return this.renderEmptyResult();
    }

    const push = head.getPush();

    if (!push.isPresent() || !push.isRemoteTracking()) {
      return this.renderEmptyResult();
    }

    const pushRemote = this.props.remotes.withName(push.getRemoteName());

    if (!pushRemote.isPresent() || !pushRemote.isGithubRepo()) {
      return this.renderEmptyResult();
    }

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/currentPullRequestContainerQuery.graphql");

      if (node.hash && node.hash !== "ade50c0777277f2032b27dfced670a2d") {
        console.error("The definition of 'currentPullRequestContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/currentPullRequestContainerQuery.graphql");
    });

    const variables = {
      headOwner: pushRemote.getOwner(),
      headName: pushRemote.getRepo(),
      headRef: push.getRemoteRef(),
      first: this.props.limit
    };
    return _react.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderEmptyResult() {
    this.sub.dispose();
    this.sub = this.props.remoteOperationObserver.onDidComplete(() => this.forceUpdate());
    return _react.default.createElement(_issueishListController.BareIssueishListController, _extends({
      isLoading: false
    }, this.controllerProps()));
  }

  renderQueryResult({
    error,
    props,
    retry
  }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    if (!props.repository || !props.repository.ref) {
      return _react.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false
      }, this.controllerProps()));
    }

    const associatedPullRequests = props.repository.ref.associatedPullRequests;
    return _react.default.createElement(_issueishListController.default, _extends({
      total: associatedPullRequests.totalCount,
      results: associatedPullRequests.nodes,
      isLoading: false,
      resultFilter: issueish => issueish.getHeadRepositoryID() === this.props.repository.id
    }, this.controllerProps()));
  }

  renderEmptyTile() {
    return _react.default.createElement(_createPullRequestTile.default, {
      repository: this.props.repository,
      remote: this.props.remote,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onCreatePr: this.props.onCreatePr
    });
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: 'Checked out pull request',
      onOpenIssueish: this.props.onOpenIssueish,
      emptyComponent: this.renderEmptyTile
    };
  }

}

exports.default = CurrentPullRequestContainer;

_defineProperty(CurrentPullRequestContainer, "propTypes", {
  // Relay payload
  repository: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    defaultBranchRef: _propTypes.default.shape({
      prefix: _propTypes.default.string.isRequired,
      name: _propTypes.default.string.isRequired
    })
  }).isRequired,
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes.default.string.isRequired,
  // Search constraints
  limit: _propTypes.default.number,
  // Repository model attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes.default.number,
  pushInProgress: _propTypes.default.bool.isRequired,
  // Actions
  onOpenIssueish: _propTypes.default.func.isRequired,
  onCreatePr: _propTypes.default.func.isRequired
});

_defineProperty(CurrentPullRequestContainer, "defaultProps", {
  limit: 5
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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