#!/bin/bash

clear
npm run build:debug || exit 1

rm -f /cores/core.*
ulimit -c unlimited

clear
npm test

if ls 2>/dev/null 1>&2 /cores/core.*; then
  for COREFILE in /cores/core.* ; do
    printf "${COREFILE}\n\n"
    lldb --core "${COREFILE}" --one-line 'thread backtrace all' --one-line 'quit'
  done
fi

ulimit -c 0
