/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.files;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import processing.app.PreferencesData;
import processing.app.helpers.FileUtils;

public class DeleteFilesOnShutdown
implements Runnable {
    public static final DeleteFilesOnShutdown INSTANCE = new DeleteFilesOnShutdown();
    private final List<File> files = new LinkedList<File>();

    public static void add(File file) {
        INSTANCE.addFile(file);
    }

    public synchronized void addFile(File file) {
        this.files.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LinkedList<File> copyOfFiles;
        boolean preserveTempFiles = PreferencesData.getBoolean("runtime.preserve.temp.files");
        if (preserveTempFiles) {
            return;
        }
        DeleteFilesOnShutdown deleteFilesOnShutdown = this;
        synchronized (deleteFilesOnShutdown) {
            copyOfFiles = new LinkedList<File>(this.files);
        }
        Collections.reverse(copyOfFiles);
        for (File file : copyOfFiles) {
            if (!file.exists() || !file.canWrite()) continue;
            FileUtils.recursiveDelete(file);
        }
    }
}

