/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.impl.Renderer;
import java.security.AccessController;
import java.util.HashSet;

public class ImageData {
    private static HashSet<ImageData> alldatas;
    private ImageData sharedOwner;
    private FilterContext fctx;
    private int refcount;
    private Filterable image;
    private final Rectangle bounds;
    private BaseTransform transform;
    private Throwable fromwhere;
    private boolean reusable;

    public ImageData(FilterContext fctx, Filterable image, Rectangle bounds) {
        this(fctx, image, bounds, BaseTransform.IDENTITY_TRANSFORM);
    }

    public ImageData(FilterContext fctx, Filterable image, Rectangle bounds, BaseTransform transform) {
        this.fctx = fctx;
        this.refcount = 1;
        this.image = image;
        this.bounds = bounds;
        this.transform = transform;
        if (alldatas != null) {
            alldatas.add(this);
            this.fromwhere = new Throwable();
        }
    }

    public ImageData transform(BaseTransform concattx) {
        if (concattx.isIdentity()) {
            return this;
        }
        BaseTransform newtx = this.transform.isIdentity() ? concattx : concattx.copy().deriveWithConcatenation(this.transform);
        return new ImageData(this, newtx, this.bounds);
    }

    private ImageData(ImageData original, BaseTransform transform, Rectangle bounds) {
        this(original.fctx, original.image, bounds, transform);
        this.sharedOwner = original;
    }

    public void setReusable(boolean reusable) {
        if (this.sharedOwner != null) {
            throw new InternalError("cannot make a shared ImageData reusable");
        }
        this.reusable = reusable;
    }

    public FilterContext getFilterContext() {
        return this.fctx;
    }

    public Filterable getUntransformedImage() {
        return this.image;
    }

    public Rectangle getUntransformedBounds() {
        return this.bounds;
    }

    public BaseTransform getTransform() {
        return this.transform;
    }

    public Filterable getTransformedImage(Rectangle clip) {
        if (this.image == null || this.fctx == null) {
            return null;
        }
        if (this.transform.isIdentity()) {
            return this.image;
        }
        Rectangle txbounds = this.getTransformedBounds(clip);
        return Renderer.getRenderer(this.fctx).transform(this.fctx, this.image, this.transform, this.bounds, txbounds);
    }

    public void releaseTransformedImage(Filterable tximage) {
        if (this.fctx != null && tximage != null && tximage != this.image) {
            Effect.releaseCompatibleImage(this.fctx, tximage);
        }
    }

    public Rectangle getTransformedBounds(Rectangle clip) {
        if (this.transform.isIdentity()) {
            return this.bounds;
        }
        Rectangle txbounds = new Rectangle();
        this.transform.transform(this.bounds, txbounds);
        if (clip != null) {
            txbounds.intersectWith(clip);
        }
        return txbounds;
    }

    public int getReferenceCount() {
        return this.refcount;
    }

    public boolean addref() {
        if (this.reusable && this.refcount == 0 && this.image != null) {
            this.image.lock();
        }
        ++this.refcount;
        return this.image != null && !this.image.isLost();
    }

    public void unref() {
        if (--this.refcount == 0) {
            if (this.sharedOwner != null) {
                this.sharedOwner.unref();
                this.sharedOwner = null;
            } else if (this.fctx != null && this.image != null) {
                if (this.reusable) {
                    this.image.unlock();
                    return;
                }
                Effect.releaseCompatibleImage(this.fctx, this.image);
            }
            this.fctx = null;
            this.image = null;
            if (alldatas != null) {
                alldatas.remove(this);
            }
        }
    }

    public boolean validate(FilterContext fctx) {
        return this.image != null && Renderer.getRenderer(fctx).isImageDataCompatible(this);
    }

    public String toString() {
        return "ImageData{sharedOwner=" + this.sharedOwner + ", fctx=" + this.fctx + ", refcount=" + this.refcount + ", image=" + this.image + ", bounds=" + this.bounds + ", transform=" + this.transform + ", reusable=" + this.reusable + '}';
    }

    static {
        AccessController.doPrivileged(() -> {
            if (System.getProperty("decora.showleaks") != null) {
                alldatas = new HashSet();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        for (ImageData id : alldatas) {
                            Rectangle r = id.getUntransformedBounds();
                            System.out.println("id[" + r.width + "x" + r.height + ", refcount=" + id.refcount + "] leaked from:");
                            id.fromwhere.printStackTrace(System.out);
                        }
                    }
                });
            }
            return null;
        });
    }
}

