/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.DateCellBehavior;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import javafx.scene.control.DateCell;
import javafx.scene.text.Text;

public class DateCellSkin
extends CellSkinBase<DateCell, DateCellBehavior> {
    public DateCellSkin(DateCell control) {
        super(control, new DateCellBehavior(control));
        control.setMaxWidth(Double.MAX_VALUE);
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        Text secondaryText = (Text)((DateCell)this.getSkinnable()).getProperties().get("DateCell.secondaryText");
        if (secondaryText != null) {
            secondaryText.setManaged(false);
            this.getChildren().add(secondaryText);
        }
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        Text secondaryText = (Text)((DateCell)this.getSkinnable()).getProperties().get("DateCell.secondaryText");
        if (secondaryText != null) {
            double textX = x + w - this.rightLabelPadding() - secondaryText.getLayoutBounds().getWidth();
            double textY = y + h - this.bottomLabelPadding() - secondaryText.getLayoutBounds().getHeight();
            secondaryText.relocate(this.snapPosition(textX), this.snapPosition(textY));
        }
    }

    private double cellSize() {
        double cellSize = this.getCellSize();
        Text secondaryText = (Text)((DateCell)this.getSkinnable()).getProperties().get("DateCell.secondaryText");
        if (secondaryText != null && cellSize == 24.0) {
            cellSize = 36.0;
        }
        return cellSize;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double pref = super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
        return this.snapSize(Math.max(pref, this.cellSize()));
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double pref = super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        return this.snapSize(Math.max(pref, this.cellSize()));
    }
}

