/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ChartSelectionModel;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineTooltipPainter;

final class TimelineTooltipOverlay
extends ChartOverlay
implements ActionListener {
    static final int TOOLTIP_OFFSET = 15;
    static final int TOOLTIP_MARGIN = 10;
    private static final int TOOLTIP_RESPONSE = 50;
    private static final int ANIMATION_STEPS = 5;
    private TimelineTooltipPainter.Model[] rowModels;
    private Set<Integer> selectedTimestamps = Collections.EMPTY_SET;
    private Timer timer;
    private int currentStep;
    private Point[] targetPositions;

    TimelineTooltipOverlay(final TimelineSupport timelineSupport) {
        final TimelineChart timelineChart = timelineSupport.getChart();
        if (timelineChart.getSelectionModel() == null) {
            throw new NullPointerException("No ChartSelectionModel set for " + (Object)((Object)timelineChart));
        }
        if (!Utils.forceSpeed()) {
            this.timer = new Timer(10, this);
            this.timer.setInitialDelay(0);
        }
        this.setLayout(null);
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TimelineTooltipOverlay.this.updateTooltip(timelineChart);
            }
        };
        timelineChart.getSelectionModel().addSelectionListener(new ChartSelectionListener(){

            public void selectionModeChanged(int n, int n2) {
            }

            public void selectionBoundsChanged(Rectangle rectangle, Rectangle rectangle2) {
            }

            public void highlightedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
                runnable.run();
            }

            public void selectedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
            }
        });
        timelineChart.addConfigurationListener((ChartConfigurationListener)new ChartConfigurationListener.Adapter(){

            public void contentsUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4, int n, int n2) {
                if (l3 != l || l4 != l2 || d != d3 || d2 != d4) {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
        timelineChart.addRowListener(new TimelineChart.RowListener(){

            @Override
            public void rowsAdded(List<TimelineChart.Row> list) {
                runnable.run();
            }

            @Override
            public void rowsRemoved(List<TimelineChart.Row> list) {
                runnable.run();
            }

            @Override
            public void rowsResized(List<TimelineChart.Row> list) {
                runnable.run();
            }
        });
        timelineSupport.addSelectionListener(new TimelineSupport.SelectionListener(){

            @Override
            public void intervalsSelectionChanged() {
            }

            @Override
            public void indexSelectionChanged() {
            }

            @Override
            public void timeSelectionChanged(boolean bl, boolean bl2) {
                TimelineTooltipOverlay.this.selectedTimestamps = new TreeSet<Integer>(timelineSupport.getSelectedTimestamps());
                runnable.run();
            }
        });
    }

    void setupModel(TimelineTooltipPainter.Model[] modelArray) {
        this.removeAll();
        this.rowModels = modelArray;
        for (TimelineTooltipPainter.Model model : modelArray) {
            TimelineTooltipPainter timelineTooltipPainter = new TimelineTooltipPainter(false);
            this.add(timelineTooltipPainter);
            timelineTooltipPainter.setVisible(false);
        }
        this.targetPositions = new Point[modelArray.length];
    }

    private void setPosition(Point point, TimelineTooltipPainter timelineTooltipPainter, int n, boolean bl) {
        if (this.getComponentCount() > 0) {
            if (point == null) {
                if (timelineTooltipPainter.isVisible()) {
                    timelineTooltipPainter.setVisible(false);
                }
                if (this.timer != null) {
                    this.timer.stop();
                }
            } else if (bl || !timelineTooltipPainter.isVisible() || this.timer == null) {
                timelineTooltipPainter.setVisible(true);
                timelineTooltipPainter.setLocation(point);
            } else {
                this.currentStep = 0;
                this.targetPositions[n] = point;
                this.timer.restart();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.rowModels.length; ++i) {
            TimelineTooltipPainter timelineTooltipPainter = (TimelineTooltipPainter)this.getComponent(i);
            Point point = this.targetPositions[i];
            Point point2 = timelineTooltipPainter.getLocation();
            point2.x += (point.x - point2.x) / (5 - this.currentStep);
            point2.y += (point.y - point2.y) / (5 - this.currentStep);
            timelineTooltipPainter.setLocation(point2);
        }
        if (++this.currentStep == 5) {
            this.timer.stop();
        }
    }

    private void checkAllocatedSelectionPainters() {
        int n;
        int n2 = this.getComponentCount() - this.rowModels.length;
        if (n2 == (n = this.rowModels.length * this.selectedTimestamps.size())) {
            return;
        }
        int n3 = n - n2;
        if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                this.add(new TimelineTooltipPainter(true));
            }
        } else {
            for (int i = 0; i > n3; --i) {
                this.remove(this.getComponentCount() - 1);
            }
            this.repaint();
        }
    }

    private void updateTooltip(TimelineChart timelineChart) {
        Object object;
        Object object2;
        int n;
        ChartContext chartContext;
        if (this.rowModels == null) {
            return;
        }
        ChartSelectionModel chartSelectionModel = timelineChart.getSelectionModel();
        if (chartSelectionModel == null) {
            return;
        }
        this.checkAllocatedSelectionPainters();
        int n2 = this.getComponentCount() - 1;
        for (int i = 0; i < timelineChart.getRowsCount(); ++i) {
            TimelineChart.Row row = timelineChart.getRow(i);
            chartContext = row.getContext();
            n = row.getItemsCount();
            object2 = this.rowModels[i];
            object = this.selectedTimestamps.iterator();
            while (object.hasNext()) {
                int n3 = object.next();
                ArrayList arrayList = new ArrayList(n);
                for (int j = 0; j < n; ++j) {
                    SynchronousXYItem synchronousXYItem = (SynchronousXYItem)row.getItem(j);
                    arrayList.add(new XYItemSelection.Default((XYItem)synchronousXYItem, n3, Integer.MAX_VALUE));
                }
                TimelineTooltipPainter timelineTooltipPainter = (TimelineTooltipPainter)this.getComponent(n2--);
                timelineTooltipPainter.update((TimelineTooltipPainter.Model)object2, arrayList);
                timelineTooltipPainter.setSize(timelineTooltipPainter.getPreferredSize());
                this.setPosition(arrayList, timelineChart.getPaintersModel(), chartContext, timelineTooltipPainter, i, true);
            }
        }
        List list = chartSelectionModel.getHighlightedItems();
        boolean bl = list.isEmpty();
        if (!bl) {
            chartContext = (XYItemSelection)list.get(0);
            bl = chartContext.getItem().getValuesCount() <= chartContext.getValueIndex();
        }
        int n4 = timelineChart.getRowsCount();
        for (n = 0; n < n4; ++n) {
            object2 = (TimelineTooltipPainter)this.getComponent(n);
            if (bl) {
                this.setPosition(null, (TimelineTooltipPainter)object2, n, false);
                continue;
            }
            object = timelineChart.getRow(n);
            ArrayList<ItemSelection> arrayList = new ArrayList<ItemSelection>(list.size());
            for (TimelineTooltipPainter timelineTooltipPainter : list) {
                if (!((TimelineChart.Row)object).containsItem(timelineTooltipPainter.getItem())) continue;
                arrayList.add((ItemSelection)timelineTooltipPainter);
            }
            ((TimelineTooltipPainter)object2).update(this.rowModels[n], arrayList);
            ((Component)object2).setSize(((JComponent)object2).getPreferredSize());
            this.setPosition(arrayList, timelineChart.getPaintersModel(), ((TimelineChart.Row)object).getContext(), (TimelineTooltipPainter)object2, n, false);
        }
    }

    private void setPosition(List<ItemSelection> list, PaintersModel paintersModel, ChartContext chartContext, TimelineTooltipPainter timelineTooltipPainter, int n, boolean bl) {
        LongRect longRect = null;
        for (ItemSelection itemSelection : list) {
            ItemPainter itemPainter = paintersModel.getPainter(itemSelection.getItem());
            LongRect longRect2 = itemPainter.getSelectionBounds(itemSelection, chartContext);
            if (longRect == null) {
                longRect = longRect2;
                continue;
            }
            LongRect.add((LongRect)longRect, (LongRect)longRect2);
        }
        this.setPosition(this.normalizePosition(Utils.checkedRectangle(longRect), timelineTooltipPainter, chartContext), timelineTooltipPainter, n, bl);
    }

    private Point normalizePosition(Rectangle rectangle, TimelineTooltipPainter timelineTooltipPainter, ChartContext chartContext) {
        Point point = new Point();
        point.x = rectangle.x + rectangle.width + 15;
        if (point.x > chartContext.getViewportWidth() - timelineTooltipPainter.getWidth() - 10) {
            point.x = rectangle.x - timelineTooltipPainter.getWidth() - 15;
        }
        int n = Utils.checkedInt((double)chartContext.getViewportOffsetY());
        int n2 = chartContext.getViewportHeight();
        point.y = n + (n2 - timelineTooltipPainter.getHeight()) / 2;
        return point;
    }

    public void paint(Graphics graphics) {
        if (this.getComponentCount() == 0) {
            return;
        }
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle2 == null) {
            graphics.setClip(rectangle);
        } else {
            graphics.setClip(rectangle2.intersection(rectangle));
        }
        super.paint(graphics);
    }
}

