/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_uz_Cyrl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "\u0413\u0443\u0436\u0430\u0440\u0430\u0442\u0438";
        final String metaValue_he = "\u0418\u0431\u0440\u043e\u043d\u0438\u0439";
        final String metaValue_kn = "\u041a\u0430\u043d\u043d\u0430\u0434\u0430";
        final String metaValue_lo = "\u041b\u0430\u043e";
        final String metaValue_ml = "\u041c\u0430\u043b\u0430\u0439\u0430\u043b\u0430\u043c";
        final String metaValue_or = "\u041e\u0440\u0438\u044f";
        final String metaValue_si = "\u0421\u0438\u043d\u0445\u0430\u043b\u0430";
        final String metaValue_te = "\u0422\u0435\u043b\u0443\u0433\u0443";
        final Object[][] data = new Object[][] {
            { "Zsym", "\u0420\u0430\u043c\u0437\u043b\u0430\u0440" },
            { "fil", "\u0424\u0438\u043b\u0438\u043f\u0438\u043d\u043e" },
            { "ab", "\u0410\u0431\u0445\u0430\u0437\u0447\u0430" },
            { "AC", "\u0412\u043e\u0437\u043d\u0435\u0441\u0435\u043d\u0438\u0435 \u043e\u0440\u043e\u043b\u0438" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u0411\u0438\u0440\u043b\u0430\u0448\u0433\u0430\u043d \u0410\u0440\u0430\u0431 \u0410\u043c\u0438\u0440\u043b\u0438\u043a\u043b\u0430\u0440\u0438" },
            { "nl_BE", "\u0424\u043b\u0430\u043c\u0430\u043d\u0434\u0447\u0430" },
            { "AF", "\u0410\u0444\u0493\u043e\u043d\u0438\u0441\u0442\u043e\u043d" },
            { "af", "\u0410\u0444\u0440\u0438\u043a\u0430\u043d\u0447\u0430" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0432\u0430 \u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "AI", "\u0410\u043d\u0433\u0438\u043b\u0430" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438\u044f" },
            { "AM", "\u0410\u0440\u043c\u0430\u043d\u0438\u0441\u0442\u043e\u043d" },
            { "am", "\u0410\u043c\u0445\u0430\u0440\u0447\u0430" },
            { "Arab", "\u0410\u0440\u0430\u0431" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u043a\u0430" },
            { "Jpan", "\u042f\u043f\u043e\u043d" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "ar", "\u0410\u0440\u0430\u0431\u0447\u0430" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0421\u0430\u043c\u043e\u0430\u0441\u0438" },
            { "as", "\u0410\u0441\u0441\u0430\u043c\u0447\u0430" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "AZ", "\u041e\u0437\u0430\u0440\u0431\u0430\u0439\u0436\u043e\u043d" },
            { "az", "\u041e\u0437\u0430\u0440\u0431\u0430\u0439\u0436\u043e\u043d\u0447\u0430" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438\u044f \u0432\u0430 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0438\u044f" },
            { "be", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u0447\u0430" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430-\u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f" },
            { "bg", "\u0411\u043e\u043b\u0433\u0430\u0440\u0447\u0430" },
            { "BH", "\u0411\u0430\u04b3\u0440\u0430\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u041c\u0443\u049b\u0430\u0434\u0434\u0430\u0441 \u0412\u0430\u0440\u0444\u0430\u043b\u043e\u043c\u0435\u0439" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0430" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439" },
            { "bn", "\u0411\u0435\u043d\u0433\u0430\u043b\u0447\u0430" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438\u044f" },
            { "bo", "\u0422\u0438\u0431\u0435\u0442\u0447\u0430" },
            { "BQ", "\u041a\u0430\u0440\u0438\u0431 \u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0438\u044f\u0441\u0438" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c\u0430 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "bs", "\u0411\u043e\u0441\u043d\u0438\u044f\u0447\u0430" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0411\u0443\u0432\u0435\u0442 \u043e\u0440\u043e\u043b\u0438" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u043d\u0430" },
            { "Mymr", "\u041c\u044c\u044f\u043d\u043c\u0430" },
            { "type.nu.laoo", "\u041b\u0430\u043e \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "BY", "\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0438\u044f" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437" },
            { "type.nu.hebr", "\u0418\u0431\u0440\u043e\u043d\u0438\u0439 \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "ca", "\u041a\u0430\u0442\u0430\u043b\u0430\u043d\u0447\u0430" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u043b\u0438\u043d\u0433) \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "CD", "\u041a\u043e\u043d\u0433\u043e-\u041a\u0438\u043d\u0448\u0430\u0441\u0430" },
            { "CF", "\u041c\u0430\u0440\u043a\u0430\u0437\u0438\u0439 \u0410\u0444\u0440\u0438\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u0438" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f" },
            { "CI", "\u041a\u043e\u0442-\u0434-\u0418\u0432\u0443\u0430\u0440" },
            { "CK", "\u041a\u0443\u043a \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u0425\u0438\u0442\u043e\u0439" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u044f" },
            { "CP", "\u041a\u043b\u0438\u043f\u043f\u0435\u0440\u0442\u043e\u043d \u043e\u0440\u043e\u043b\u0438" },
            { "Orya", metaValue_or },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430" },
            { "cs", "\u0427\u0435\u0445\u0447\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u0443\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u0420\u043e\u0436\u0434\u0435\u0441\u0442\u0432\u043e \u043e\u0440\u043e\u043b\u0438" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "cy", "\u0423\u044d\u043b\u0441\u0447\u0430" },
            { "CZ", "\u0427\u0435\u0445\u0438\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u0438" },
            { "type.nu.ethi", "\u04b2\u0430\u0431\u0430\u0448 \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "da", "\u0414\u0430\u043d\u0438\u044f\u0447\u0430" },
            { "DE", "\u041e\u043b\u043c\u043e\u043d\u0438\u044f" },
            { "de", "\u041e\u043b\u043c\u043e\u043d\u0447\u0430" },
            { "DG", "\u0414\u0438\u0435\u0433\u043e \u0413\u0430\u0440\u0441\u0438\u044f" },
            { "type.nu.deva", "\u0414\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "DJ", "\u0414\u0436\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438\u044f" },
            { "Brai", "\u0411\u0440\u0430\u0438\u043b\u043b\u0435" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "type.nu.armnlow", "\u0410\u0440\u043c\u0430\u043d \u043a\u0438\u0447\u0438\u043a \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "DO", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u0438" },
            { "es_419", "\u041b\u043e\u0442\u0438\u043d \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0438\u0441\u043f\u0430\u043d\u0447\u0430\u0441\u0438" },
            { "DZ", "\u0416\u0430\u0437\u043e\u0438\u0440" },
            { "EA", "\u0421\u0435\u0439\u0442\u0430 \u0432\u0430 \u041c\u0435\u043b\u0438\u043b\u043b\u0430" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "type.nu.grek", "\u0413\u0440\u0435\u043a \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0438\u044f" },
            { "EG", "\u041c\u0438\u0441\u0440" },
            { "EH", "\u0492\u0430\u0440\u0431\u0438\u0439 \u0421\u0430\u04b3\u0440\u043e\u0438 \u041a\u0430\u0431\u0438\u0440" },
            { "el", "\u0413\u0440\u0435\u043a\u0447\u0430" },
            { "en", "\u0418\u043d\u0433\u043b\u0438\u0437\u0447\u0430" },
            { "eo", "\u042d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "ER", "\u042d\u0440\u0438\u0442\u0440\u0435\u044f" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438\u044f" },
            { "es", "\u0418\u0441\u043f\u0430\u043d\u0447\u0430" },
            { "ET", "\u042d\u0444\u0438\u043e\u043f\u0438\u044f" },
            { "et", "\u042d\u0441\u0442\u043e\u043d\u0447\u0430" },
            { "EU", "\u0415\u0432\u0440\u043e\u043f\u0430 \u0418\u0442\u0442\u0438\u0444\u043e\u049b\u0438" },
            { "eu", "\u0411\u0430\u0441\u043a\u0447\u0430" },
            { "Hang", "\u0425\u0430\u043d\u0433\u0443\u043b" },
            { "type.ca.gregorian", "\u0413\u0440\u0438\u0433\u043e\u0440\u0438\u0430\u043d \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u0438" },
            { "type.nu.gujr", "\u0413\u0443\u0436\u0430\u0440\u0430\u0442\u0438 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "Hani", "\u0425\u0430\u043d" },
            { "fa", "\u0424\u043e\u0440\u0441\u0447\u0430" },
            { "Hans", "\u0421\u043e\u0434\u0434\u0430\u043b\u0430\u0448\u0442\u0438\u0440\u0438\u043b\u0433\u0430\u043d" },
            { "type.nu.latn", "\u0492\u0430\u0440\u0431 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "Hant", "\u0410\u043d\u044a\u0430\u043d\u0430\u0432\u0438\u0439" },
            { "FI", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f" },
            { "fi", "\u0424\u0438\u043d\u0447\u0430" },
            { "FJ", "\u0424\u0438\u0436\u0438 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "fj", "\u0424\u0438\u0436\u0438\u0447\u0430" },
            { "FK", "\u0424\u043e\u043b\u044c\u043a\u043b\u0435\u043d\u0434 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "FO", "\u0424\u0430\u0440\u0435\u0440 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "fo", "\u0424\u0430\u0440\u044d\u0440\u0447\u0430" },
            { "Taml", "\u0422\u0430\u043c\u0438\u043b" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u0438\u044f" },
            { "fr", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0447\u0430" },
            { "fy", "\u0492\u0430\u0440\u0431\u0438\u0439 \u0444\u0440\u0438\u0437\u0438\u0430\u043d\u0447\u0430" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "ga", "\u0418\u0440\u043b\u0430\u043d\u0434\u0447\u0430" },
            { "GB", "\u0411\u0438\u0440\u043b\u0430\u0448\u0433\u0430\u043d \u049a\u0438\u0440\u043e\u043b\u043b\u0438\u043a" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u0440\u0443\u0437\u0438\u044f" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437 \u0413\u0432\u0438\u0430\u043d\u0430\u0441\u0438" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "gl", "\u0413\u0430\u043b\u0438\u0446\u0438\u0439\u0447\u0430" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438\u044f" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u044f" },
            { "gn", "\u0413\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0435" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b \u0413\u0432\u0438\u043d\u0435\u044f" },
            { "und", "\u041d\u043e\u043c\u0430\u044a\u043b\u0443\u043c \u0442\u0438\u043b" },
            { "GR", "\u0413\u0440\u0435\u0446\u0438\u044f" },
            { "GS", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u0414\u0436\u043e\u0440\u0434\u0436\u0438\u044f \u0432\u0430 \u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u0421\u0435\u043d\u0434\u0432\u0438\u0447 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "gu", metaValue_gu },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u044f-\u0411\u0438\u0441\u0430\u0443" },
            { "GY", "\u0413\u0430\u044f\u043d\u0430" },
            { "ha", "\u0425\u0430\u0443\u0441\u0430" },
            { "zxx", "\u0422\u0438\u043b \u0442\u0430\u0440\u043a\u0438\u0431\u0438 \u0439\u045e\u049b" },
            { "he", metaValue_he },
            { "hi", "\u04b2\u0438\u043d\u0434\u0447\u0430" },
            { "HK", "\u0413\u043e\u043d\u043a\u043e\u043d\u0433 \u0425\u0438\u0442\u043e\u0439 \u041c\u041c\u04b2" },
            { "HM", "\u0413\u0435\u0440\u0434 \u043e\u0440\u043e\u043b\u0438 \u0432\u0430 \u041c\u0430\u043a\u0414\u043e\u043d\u0430\u043b\u0434 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442\u0438\u044f" },
            { "hr", "\u0425\u043e\u0440\u0432\u0430\u0442\u0447\u0430" },
            { "gsw", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f \u043d\u0435\u043c\u0438\u0441\u0447\u0430\u0441\u0438" },
            { "HT", "\u0413\u0430\u0438\u0442\u0438" },
            { "ht", "\u0413\u0430\u0438\u0442\u0438\u0430\u043d\u0447\u0430" },
            { "HU", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f" },
            { "hu", "\u0412\u0435\u043d\u0433\u0440\u0447\u0430" },
            { "hy", "\u0410\u0440\u043c\u0430\u043d\u0447\u0430" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "id", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f\u0447\u0430" },
            { "type.nu.tibt", "\u0422\u0438\u0431\u0435\u0442 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "ig", "\u0418\u0433\u0431\u043e" },
            { "IL", "\u0418\u0441\u0440\u043e\u0438\u043b" },
            { "IM", "\u041c\u044d\u043d \u043e\u0440\u043e\u043b\u0438" },
            { "IN", "\u04b2\u0438\u043d\u0434\u0438\u0441\u0442\u043e\u043d" },
            { "IO", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f \u04b2\u0438\u043d\u0434 \u043e\u043a\u0435\u0430\u043d\u0438 \u04b3\u0443\u0434\u0443\u0434\u0438" },
            { "IQ", "\u0418\u0440\u043e\u049b" },
            { "IR", "\u042d\u0440\u043e\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "is", "\u0418\u0441\u043b\u0430\u043d\u0434\u0447\u0430" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438\u044f" },
            { "it", "\u0418\u0442\u0430\u043b\u044f\u043d\u0447\u0430" },
            { "type.nu.thai", "\u0422\u0430\u0439 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.beng", "\u0411\u0435\u043d\u0433\u0430\u043b\u0438 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "Mlym", metaValue_ml },
            { "ja", "\u042f\u043f\u043e\u043d\u0447\u0430" },
            { "JE", "\u0414\u0436\u0435\u0440\u0441\u0438" },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "Beng", "\u0411\u0435\u043d\u0433\u0430\u043b\u0438" },
            { "JO", "\u0418\u043e\u0440\u0434\u0430\u043d\u0438\u044f" },
            { "JP", "\u042f\u043f\u043e\u043d\u0438\u044f" },
            { "jv", "\u042f\u0432\u0430\u043d\u0447\u0430" },
            { "type.nu.knda", "\u041a\u0430\u043d\u043d\u0430\u0434\u0430 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "ka", "\u0413\u0440\u0443\u0437\u0438\u043d\u0447\u0430" },
            { "KE", "\u041a\u0435\u043d\u0438\u044f" },
            { "419", "\u041b\u043e\u0442\u0438\u043d \u0410\u043c\u0435\u0440\u0438\u043a\u0430\u0441\u0438" },
            { "KG", "\u049a\u0438\u0440\u0493\u0438\u0437\u0438\u0441\u0442\u043e\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "kk", "\u049a\u043e\u0437\u043e\u049b\u0447\u0430" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "km", "\u0425\u043c\u0435\u0440\u0447\u0430" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0432\u0430 \u041d\u0435\u0432\u0438\u0441" },
            { "ko", "\u041a\u043e\u0440\u0435\u0439\u0441\u0447\u0430" },
            { "KP", "\u0428\u0438\u043c\u043e\u043b\u0438\u0439 \u041a\u043e\u0440\u0435\u044f" },
            { "KR", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u041a\u043e\u0440\u0435\u044f" },
            { "ks", "\u041a\u0430\u0448\u043c\u0438\u0440\u0447\u0430" },
            { "ku", "\u041a\u0443\u0440\u0434\u0447\u0430" },
            { "KW", "\u041a\u0443\u0432\u0430\u0439\u0442" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "ky", "\u049a\u0438\u0440\u0493\u0438\u0437\u0447\u0430" },
            { "KZ", "\u049a\u043e\u0437\u043e\u0493\u0438\u0441\u0442\u043e\u043d" },
            { "Cyrl", "\u041a\u0438\u0440\u0438\u043b" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "la", "\u041b\u043e\u0442\u0438\u043d\u0447\u0430" },
            { "LB", "\u041b\u0438\u0432\u0430\u043d" },
            { "lb", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u0447\u0430" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438\u044f" },
            { "type.nu.mlym", "\u041c\u0430\u043b\u0430\u0439\u0430\u043b\u0430\u043c \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "LK", "\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430" },
            { "Tibt", "\u0422\u0438\u0431\u0435\u0442" },
            { "lo", metaValue_lo },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438\u044f" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "lt", "\u041b\u0438\u0442\u0432\u0430\u0447\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438\u044f" },
            { "lv", "\u041b\u0430\u0442\u0438\u0448\u0447\u0430" },
            { "Kana", "\u041a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "LY", "\u041b\u0438\u0432\u0438\u044f" },
            { "Thaa", "\u0422\u0430\u0430\u043d\u0430" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u0430\u0448" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u043e\u0432\u0430" },
            { "ME", "\u0427\u0435\u0440\u043d\u043e\u0433\u043e\u0440\u0438\u044f" },
            { "MF", "\u0421\u0435\u043d\u0442-\u041c\u0430\u0440\u0442\u0438\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "mg", "\u041c\u0430\u043b\u0430\u0433\u0430\u0441\u0438" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "Thai", "\u0422\u0430\u0439" },
            { "type.co.ducet", "\u0421\u0443\u043a\u0443\u0442 \u0431\u045e\u0439\u0438\u0447\u0430 \u0441\u0430\u0440\u0430\u043b\u0430\u0448 \u0442\u0430\u0440\u0442\u0438\u0431\u0438" },
            { "mi", "\u041c\u0430\u043e\u0440\u0438" },
            { "MK", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u044f" },
            { "mk", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0447\u0430" },
            { "ml", metaValue_ml },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "MM", "\u041c\u044c\u044f\u043d\u043c\u0430 (\u0411\u0438\u0440\u043c\u0430)" },
            { "MN", "\u041c\u0443\u0493\u0443\u043b\u0438\u0441\u0442\u043e\u043d" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e \u0425\u0438\u0442\u043e\u0439 \u041c\u041c\u04b2" },
            { "MP", "\u0428\u0438\u043c\u043e\u043b\u0438\u0439 \u041c\u0430\u0440\u0438\u0430\u043d\u043d\u0430 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a\u0430" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f" },
            { "mr", "\u041c\u0430\u0440\u0430\u0442\u0438" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "ms", "\u041c\u0430\u043b\u0430\u0439\u0447\u0430" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "mt", "\u041c\u0430\u043b\u044c\u0442\u0430\u0447\u0430" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u0438\u0432 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u044f" },
            { "my", "\u0411\u0438\u0440\u043c\u0430\u043d\u0447\u0430" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "Armn", "\u0410\u0440\u043c\u0430\u043d" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438\u044f" },
            { "type.co.search", "\u0423\u043c\u0443\u043c\u0438\u0439 \u049b\u0438\u0434\u0438\u0440\u0438\u0448" },
            { "nb", "\u041d\u043e\u0440\u0432\u0435\u0433\u0447\u0430 \u0411\u043e\u043a\u043c\u0430\u043b" },
            { "NC", "\u042f\u043d\u0433\u0438 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "ne", "\u041d\u0435\u043f\u0430\u043b\u0447\u0430" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438\u044f" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "nl", "\u0413\u043e\u043b\u043b\u0430\u043d\u0434\u0447\u0430" },
            { "nn", "\u041d\u043e\u0440\u0432\u0435\u0433\u0447\u0430 \u041d\u0438\u043d\u043e\u0440\u0441\u043a" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0438\u044f" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u0435" },
            { "NZ", "\u042f\u043d\u0433\u0438 \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "type.nu.armn", "\u0410\u0440\u043c\u0430\u043d \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "OM", "\u0423\u043c\u043c\u043e\u043d" },
            { "or", metaValue_or },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "pa", "\u041f\u0430\u043d\u0436\u043e\u0431\u0447\u0430" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f\u0441\u0438" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 \u042f\u043d\u0433\u0438 \u0413\u0432\u0438\u043d\u0435\u044f" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "PK", "\u041f\u043e\u043a\u0438\u0441\u0442\u043e\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448\u0430" },
            { "pl", "\u041f\u043e\u043b\u044f\u043a\u0447\u0430" },
            { "PM", "\u0421\u0435\u043d\u0442-\u041f\u044c\u0435\u0440 \u0432\u0430 \u041c\u0438\u043a\u0435\u043b\u043e\u043d" },
            { "PN", "\u041f\u0438\u0442\u043a\u0430\u0440\u0438\u043d \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e" },
            { "PS", "\u0424\u0430\u043b\u0430\u0441\u0442\u0438\u043d \u04b3\u0443\u0434\u0443\u0434\u0438" },
            { "ps", "\u041f\u0443\u0448\u0442\u0443" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u044f" },
            { "pt", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0447\u0430" },
            { "key.co", "\u0421\u0430\u0440\u0430\u043b\u0430\u0448 \u0442\u0430\u0440\u0442\u0438\u0431\u0438" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "type.nu.greklow", "\u0413\u0440\u0435\u043a \u043a\u0438\u0447\u0438\u043a \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "Hebr", metaValue_he },
            { "QA", "\u049a\u0430\u0442\u0430\u0440" },
            { "key.ca", "\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "Laoo", metaValue_lo },
            { "type.nu.mymr", "\u041c\u044c\u044f\u043d\u043c\u0430 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "QO", "\u0401\u043d\u0434\u043e\u0448 \u041e\u043a\u0435\u0430\u043d\u0438\u044f" },
            { "qu", "\u041a\u0432\u0435\u0447\u0443\u0430" },
            { "001", "\u0414\u0443\u043d\u0451" },
            { "Ethi", "\u04b2\u0430\u0431\u0430\u0448" },
            { "002", "\u0410\u0444\u0440\u0438\u043a\u0430" },
            { "003", "\u0428\u0438\u043c\u043e\u043b\u0438\u0439 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "RE", "\u0420\u0435\u044e\u043d\u044c\u043e\u043d" },
            { "005", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "009", "\u041e\u043a\u0435\u0430\u043d\u0438\u044f" },
            { "rm", "\u0420\u043e\u043c\u0430\u043d\u0447\u0430" },
            { "key.cu", "\u0412\u0430\u043b\u044e\u0442\u0430" },
            { "RO", "\u0420\u0443\u043c\u0438\u043d\u0438\u044f" },
            { "ro", "\u0420\u0443\u043c\u0438\u043d\u0447\u0430" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438\u044f" },
            { "type.nu.orya", "\u041e\u0440\u0438\u044f \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.hanidec", "\u0425\u0438\u0442\u043e\u0439 \u045e\u043d\u043b\u0438\u043a \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "RU", "\u0420\u043e\u0441\u0441\u0438\u044f" },
            { "ru", "\u0420\u0443\u0441\u0447\u0430" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "SA", "\u0421\u0430\u0443\u0434\u0438\u044f \u0410\u0440\u0430\u0431\u0438\u0441\u0442\u043e\u043d\u0438" },
            { "sa", "\u0421\u0430\u043d\u0441\u043a\u0440\u0438\u0442\u0447\u0430" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "011", "\u0492\u0430\u0440\u0431\u0438\u0439 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "sd", "\u0421\u0438\u043d\u0434\u0445\u0438" },
            { "013", "\u041c\u0430\u0440\u043a\u0430\u0437\u0438\u0439 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "SE", "\u0428\u0432\u0435\u0446\u0438\u044f" },
            { "014", "\u0428\u0430\u0440\u049b\u0438\u0439 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "015", "\u0428\u0438\u043c\u043e\u043b\u0438\u0439 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u041c\u0443\u049b\u0430\u0434\u0434\u0430\u0441 \u0415\u043b\u0435\u043d\u0430 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "si", metaValue_si },
            { "017", "\u041c\u0430\u0440\u043a\u0430\u0437\u0438\u0439 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u044f" },
            { "018", "\u0416\u0430\u043d\u0443\u0431\u0438-\u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SJ", "\u0421\u0430\u0432\u043b\u044c\u0431\u0430\u0440\u0434 \u0432\u0430 \u0416\u0430\u043d \u041c\u0430\u0435\u043d" },
            { "019", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a\u0438\u044f" },
            { "sk", "\u0421\u043b\u043e\u0432\u0430\u043a\u0447\u0430" },
            { "SL", "\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "sl", "\u0421\u043b\u043e\u0432\u0435\u043d\u0447\u0430" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438" },
            { "so", "\u0421\u043e\u043c\u0430\u043b\u0438\u0447\u0430" },
            { "type.nu.arab", "\u0410\u0440\u0430\u0431-\u04b3\u0438\u043d\u0434 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "sq", "\u0410\u043b\u0431\u0430\u043d\u0447\u0430" },
            { "type.nu.taml", "\u0410\u043d\u044a\u0430\u043d\u0430\u0432\u0438\u0439 \u0422\u0430\u043c\u0438\u043b \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "sr", "\u0421\u0435\u0440\u0431\u0447\u0430" },
            { "SS", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0432\u0430 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "su", "\u0421\u0443\u043d\u0434\u0430\u043d\u0447\u0430" },
            { "SV", "\u042d\u043b\u044c-\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "sv", "\u0428\u0432\u0435\u0434\u0447\u0430" },
            { "sw", "\u0421\u0443\u0430\u0445\u0438\u043b\u0438" },
            { "SX", "\u0421\u0438\u043d\u0442-\u041c\u0430\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0421\u0443\u0440\u0438\u044f" },
            { "type.nu.hantfin", "\u0410\u043d\u044a\u0430\u043d\u0430\u0432\u0438\u0439 \u0425\u0438\u0442\u043e\u0439 \u043c\u043e\u043b\u0438\u044f \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434" },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d \u0434\u0435 \u041a\u0443\u043d\u0430" },
            { "ta", "\u0422\u0430\u043c\u0438\u043b\u0447\u0430" },
            { "021", "\u0428\u0438\u043c\u043e\u043b\u0438-\u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "142", "\u041e\u0441\u0438\u0451" },
            { "TC", "\u0422\u0443\u0440\u043a\u0441 \u0432\u0430 \u041a\u0430\u0439\u043a\u043e\u0441 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "143", "\u041c\u0430\u0440\u043a\u0430\u0437\u0438\u0439 \u041e\u0441\u0438\u0451" },
            { "TD", "\u0427\u0430\u0434" },
            { "te", metaValue_te },
            { "145", "\u0492\u0430\u0440\u0431\u0438\u0439 \u041e\u0441\u0438\u0451" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0438\u044f \u0436\u0430\u043d\u0443\u0431\u0438\u0439 \u0445\u0443\u0434\u0443\u0434\u043b\u0430\u0440\u0438" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "tg", "\u0422\u043e\u0436\u0438\u043a\u0447\u0430" },
            { "TH", "\u0422\u0430\u0439\u043b\u0430\u043d\u0434" },
            { "th", "\u0422\u0430\u0439\u0447\u0430" },
            { "ti", "\u0422\u0438\u0433\u0440\u0438\u043d\u044c\u044f" },
            { "TJ", "\u0422\u043e\u0436\u0438\u043a\u0438\u0441\u0442\u043e\u043d" },
            { "029", "\u041a\u0430\u0440\u0438\u0431 \u04b3\u0430\u0432\u0437\u0430\u0441\u0438" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "tk", "\u0422\u0443\u0440\u043a\u043c\u0430\u043d\u0447\u0430" },
            { "TL", "\u0428\u0430\u0440\u049b\u0438\u0439-\u0422\u0438\u043c\u043e\u0440" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0430\u043d\u0438\u0441\u0442\u043e\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "to", "\u0422\u043e\u043d\u0433\u043e\u0447\u0430" },
            { "type.nu.jpan", "\u042f\u043f\u043e\u043d\u0438\u044f \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "TR", "\u0422\u0443\u0440\u043a\u0438\u044f" },
            { "tr", "\u0422\u0443\u0440\u043a\u0447\u0430" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0432\u0430 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "tt", "\u0422\u0430\u0442\u0430\u0440\u0447\u0430" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u044f" },
            { "Zzzz", "\u041d\u043e\u043c\u0430\u044a\u043b\u0443\u043c \u0448\u0440\u0438\u0444\u0442" },
            { "150", "\u0415\u0432\u0440\u043e\u043f\u0430" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d\u0430" },
            { "030", "\u0428\u0430\u0440\u049b\u0438\u0439 \u041e\u0441\u0438\u0451" },
            { "151", "\u0428\u0430\u0440\u049b\u0438\u0439 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "154", "\u0428\u0438\u043c\u043e\u043b\u0438\u0439 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "034", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u041e\u0441\u0438\u0451" },
            { "155", "\u0492\u0430\u0440\u0431\u0438\u0439 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "035", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439-\u0428\u0430\u0440\u049b\u0438\u0439 \u041e\u0441\u0438\u0451" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "ug", "\u0423\u0439\u0493\u0443\u0440\u0447\u0430" },
            { "Kore", "\u041a\u043e\u0440\u0435\u0439\u0441" },
            { "Zyyy", "\u0423\u043c\u0443\u043c\u0438\u0439" },
            { "039", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "uk", "\u0423\u043a\u0440\u0430\u0438\u043d\u0447\u0430" },
            { "Sinh", metaValue_si },
            { "UM", "\u0410\u049a\u0428 \u0451\u043d\u0434\u043e\u0448 \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "ur", "\u0423\u0440\u0434\u0443" },
            { "US", "\u049a\u045e\u0448\u043c\u0430 \u0428\u0442\u0430\u0442\u043b\u0430\u0440" },
            { "haw", "\u0413\u0430\u0432\u0430\u0439\u0447\u0430" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "UZ", "\u040e\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u043e\u043d" },
            { "uz", "\u040e\u0437\u0431\u0435\u043a" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0432\u0430 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430" },
            { "VG", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f \u0412\u0438\u0440\u0434\u0436\u0438\u043d\u0438\u044f \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "VI", "\u0410\u049a\u0428 \u0412\u0438\u0440\u0434\u0436\u0438\u043d\u0438\u044f \u043e\u0440\u043e\u043b\u043b\u0430\u0440\u0438" },
            { "vi", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c\u0447\u0430" },
            { "VN", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0430\u0437\u0438\u044f" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0438\u044f" },
            { "WF", "\u0423\u044d\u043b\u043b\u0438\u0441 \u0432\u0430 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "Grek", "\u042e\u043d\u043e\u043d" },
            { "057", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u044f \u043c\u0438\u043d\u0442\u0430\u049b\u0430\u0441\u0438" },
            { "wo", "\u0412\u043e\u043b\u043e\u0444\u0447\u0430" },
            { "zgh", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u041c\u0430\u0440\u043e\u043a\u0430\u0448 \u0422\u0430\u043c\u0430\u0437\u0438\u0442" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "Mong", "\u041c\u045e\u0493\u0443\u043b\u0447\u0430" },
            { "061", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f" },
            { "Latn", "\u041b\u043e\u0442\u0438\u043d" },
            { "type.nu.hans", "\u0421\u043e\u0434\u0434\u0430\u043b\u0430\u0448\u0442\u0438\u0440\u0438\u043b\u0433\u0430\u043d \u0425\u0438\u0442\u043e\u0439 \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.hant", "\u0410\u043d\u044a\u0430\u043d\u0430\u0432\u0438\u0439 \u0425\u0438\u0442\u043e\u0439 \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "xh", "\u0425\u043e\u0441\u0430" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "type.nu.romanlow", "\u0420\u0438\u043c \u043a\u0438\u0447\u0438\u043a \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0401\u0437\u0438\u043b\u043c\u0430\u0433\u0430\u043d" },
            { "YE", "\u042f\u043c\u0430\u043d" },
            { "type.co.standard", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0441\u0430\u0440\u0430\u043b\u0430\u0448 \u0442\u0430\u0440\u0442\u0438\u0431\u0438" },
            { "yo", "\u0419\u043e\u0440\u0443\u0431\u0430" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0430" },
            { "ZA", "\u0416\u0430\u043d\u0443\u0431\u0438\u0439 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "Deva", "\u0414\u0435\u0432\u0430\u043d\u0433\u0430\u0440\u0438" },
            { "zh", "\u0425\u0438\u0442\u043e\u0439\u0447\u0430" },
            { "type.nu.geor", "\u0413\u0440\u0443\u0437\u0438\u043d \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "Hira", "\u0425\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438\u044f" },
            { "Bopo", "\u0411\u043e\u043f\u043e\u043c\u043e\u0444\u043e" },
            { "zu", "\u0417\u0443\u043b\u0443" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u041d\u043e\u043c\u0430\u044a\u043b\u0443\u043c \u043c\u0438\u043d\u0442\u0430\u049b\u0430" },
            { "Geor", "\u0413\u0440\u0443\u0437\u0438\u043d" },
            { "type.nu.telu", "\u0422\u0435\u043b\u0443\u0433\u0443 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.jpanfin", "\u042f\u043f\u043e\u043d\u0438\u044f \u043c\u043e\u043b\u0438\u044f \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.hansfin", "\u0421\u043e\u0434\u0434\u0430\u043b\u0430\u0448\u0442\u0438\u0440\u0438\u043b\u0433\u0430\u043d \u0425\u0438\u0442\u043e\u0439 \u043c\u043e\u043b\u0438\u044f \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.arabext", "\u041a\u0435\u043d\u0433\u0430\u0439\u0442\u0438\u0440\u0438\u043b\u0433\u0430\u043d \u0430\u0440\u0430\u0431-\u04b3\u0438\u043d\u0434 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.fullwide", "\u0422\u045e\u043b\u0438\u049b \u043a\u0435\u043d\u0433\u043b\u0438\u043a\u0434\u0430\u0433\u0438 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440" },
            { "type.nu.khmr", "\u0425\u043c\u0435\u0440 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "type.nu.guru", "\u0413\u0443\u0440\u043c\u0443\u0445\u0438 \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "Khmr", "\u0425\u043c\u0435\u0440" },
            { "type.nu.roman", "\u0420\u0438\u043c \u0441\u043e\u043d\u043b\u0430\u0440\u0438" },
            { "type.nu.tamldec", "\u0422\u0430\u043c\u0438\u043b \u0440\u0430\u049b\u0430\u043c\u043b\u0430\u0440\u0438" },
            { "key.nu", "\u0420\u0430\u049b\u0430\u043c\u043b\u0430\u0440" },
            { "Guru", "\u0413\u0443\u0440\u043c\u0443\u0445\u0438" },
            { "Telu", metaValue_te },
        };
        return data;
    }
}
