#ifndef _EFL_CANVAS_ANIMATION_PLAYER_EO_H_
#define _EFL_CANVAS_ANIMATION_PLAYER_EO_H_

#ifndef _EFL_CANVAS_ANIMATION_PLAYER_EO_CLASS_TYPE
#define _EFL_CANVAS_ANIMATION_PLAYER_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Animation_Player;

#endif

#ifndef _EFL_CANVAS_ANIMATION_PLAYER_EO_TYPES
#define _EFL_CANVAS_ANIMATION_PLAYER_EO_TYPES


#endif
/** Efl animation object class
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
#define EFL_CANVAS_ANIMATION_PLAYER_CLASS efl_canvas_animation_player_class_get()

EWAPI const Efl_Class *efl_canvas_animation_player_class_get(void);

EOAPI void efl_animation_player_animation_set(Eo *obj, Efl_Canvas_Animation *animation);

EOAPI Efl_Canvas_Animation *efl_animation_player_animation_get(const Eo *obj);

/**
 * @brief Auto delete property
 *
 * @param[in] obj The object.
 * @param[in] auto_del @c true to delete animation object automatically when
 * animation is finished or animation is cancelled, @c false otherwise.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
EOAPI void efl_animation_player_auto_del_set(Eo *obj, Eina_Bool auto_del);

/**
 * @brief Auto delete property
 *
 * @param[in] obj The object.
 *
 * @return @c true to delete animation object automatically when animation is
 * finished or animation is cancelled, @c false otherwise.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
EOAPI Eina_Bool efl_animation_player_auto_del_get(const Eo *obj);

/**
 * @brief Target object property
 *
 * @param[in] obj The object.
 * @param[in] target Target object which is applied animation.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
EOAPI void efl_animation_player_target_set(Eo *obj, Efl_Canvas_Object *target);

/**
 * @brief Target object property
 *
 * @param[in] obj The object.
 *
 * @return Target object which is applied animation.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
EOAPI Efl_Canvas_Object *efl_animation_player_target_get(const Eo *obj);

EWAPI extern const Efl_Event_Description _EFL_ANIMATION_PLAYER_EVENT_STARTED;

/** Animation is started.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
#define EFL_ANIMATION_PLAYER_EVENT_STARTED (&(_EFL_ANIMATION_PLAYER_EVENT_STARTED))

EWAPI extern const Efl_Event_Description _EFL_ANIMATION_PLAYER_EVENT_RUNNING;

/** Animation is running.
 * @return Efl_Canvas_Object_Animation_Event
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
#define EFL_ANIMATION_PLAYER_EVENT_RUNNING (&(_EFL_ANIMATION_PLAYER_EVENT_RUNNING))

EWAPI extern const Efl_Event_Description _EFL_ANIMATION_PLAYER_EVENT_ENDED;

/** Animation is ended.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
#define EFL_ANIMATION_PLAYER_EVENT_ENDED (&(_EFL_ANIMATION_PLAYER_EVENT_ENDED))

#endif
