/*
 * Decompiled with CFR 0.152.
 */
package javafx.geometry;

public class Point3D {
    private double x;
    private double y;
    private double z;
    private int hash = 0;

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public Point3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public double distance(double d, double d2, double d3) {
        double d4 = this.getX() - d;
        double d5 = this.getY() - d2;
        double d6 = this.getZ() - d3;
        return Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
    }

    public double distance(Point3D point3D) {
        return this.distance(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Point3D) {
            Point3D point3D = (Point3D)object;
            return this.getX() == point3D.getX() && this.getY() == point3D.getY() && this.getZ() == point3D.getZ();
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long l = 7L;
            l = 31L * l + Double.doubleToLongBits(this.getX());
            l = 31L * l + Double.doubleToLongBits(this.getY());
            l = 31L * l + Double.doubleToLongBits(this.getZ());
            this.hash = (int)(l ^ l >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return "Point3D [x = " + this.getX() + ", y = " + this.getY() + ", z = " + this.getZ() + "]";
    }
}

