"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
var SettingsType_1 = require("../settings/SettingsType");
var pkg = require('../../package.json');
var currentEnvironment;
var BackendType;
(function (BackendType) {
    BackendType["DEV"] = "DEV";
    BackendType["EDGE"] = "EDGE";
    BackendType["INTERNAL"] = "INTERNAL";
    BackendType["LOCALHOST"] = "LOCALHOST";
    BackendType["PRODUCTION"] = "PRODUCTION";
    BackendType["RC"] = "RC";
})(BackendType || (BackendType = {}));
exports.BackendType = BackendType;
var BackendTypeLabel;
(function (BackendTypeLabel) {
    BackendTypeLabel["DEV"] = "Development";
    BackendTypeLabel["EDGE"] = "Edge";
    BackendTypeLabel["INTERNAL"] = "Internal";
    BackendTypeLabel["LOCALHOST"] = "Localhost";
    BackendTypeLabel["PRODUCTION"] = "Production";
    BackendTypeLabel["RC"] = "RC";
})(BackendTypeLabel || (BackendTypeLabel = {}));
exports.BackendTypeLabel = BackendTypeLabel;
var URL_ADMIN = {
    PRODUCTION: pkg.adminUrl || 'https://teams.wire.com',
    STAGING: 'https://wire-admin-staging.zinfra.io',
};
var URL_LEGAL = pkg.legalUrl || 'https://wire.com/legal/';
exports.URL_LEGAL = URL_LEGAL;
var URL_LICENSES = pkg.licensesUrl || 'https://wire.com/legal/licenses/';
exports.URL_LICENSES = URL_LICENSES;
var URL_PRIVACY = pkg.privacyUrl || 'https://wire.com/privacy/';
exports.URL_PRIVACY = URL_PRIVACY;
var URL_SUPPORT = pkg.supportUrl || 'https://support.wire.com';
exports.URL_SUPPORT = URL_SUPPORT;
var URL_WEBSITE = {
    PRODUCTION: pkg.websiteUrl || 'https://wire.com',
    STAGING: 'https://wire-website-staging.zinfra.io',
};
var URL_WEBAPP = {
    DEV: 'https://wire-webapp-dev.zinfra.io',
    EDGE: 'https://wire-webapp-edge.zinfra.io',
    INTERNAL: 'https://wire-webapp-staging.wire.com/',
    LOCALHOST: 'http://localhost:8081',
    PRODUCTION: pkg.appBase || 'https://app.wire.com',
    RC: 'https://wire-webapp-rc.zinfra.io',
};
exports.URL_WEBAPP = URL_WEBAPP;
var app = {
    ENV: pkg.environment,
    IS_DEVELOPMENT: pkg.environment !== 'production',
    IS_PRODUCTION: pkg.environment === 'production',
    UPDATE_URL_WIN: pkg.updateWinUrl,
};
exports.app = app;
var getEnvironment = function () {
    return (currentEnvironment ? currentEnvironment : restoreEnvironment()).toUpperCase();
};
exports.getEnvironment = getEnvironment;
var isProdEnvironment = function () {
    return [BackendType.INTERNAL, BackendType.PRODUCTION].includes(getEnvironment());
};
var isLinuxDesktop = function (identifier) {
    var xdgDesktop = process.env.XDG_CURRENT_DESKTOP;
    return !!xdgDesktop && xdgDesktop.includes(identifier);
};
var platform = {
    IS_LINUX: process.platform === 'linux',
    IS_MAC_OS: process.platform === 'darwin',
    IS_WINDOWS: process.platform === 'win32',
};
exports.platform = platform;
var linuxDesktop = {
    isGnome: isLinuxDesktop('GNOME'),
    isPopOS: isLinuxDesktop('pop'),
    isUbuntuUnity: isLinuxDesktop('Unity'),
};
exports.linuxDesktop = linuxDesktop;
var restoreEnvironment = function () {
    currentEnvironment = ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.ENV, BackendType.INTERNAL);
    return currentEnvironment;
};
var setEnvironment = function (env) {
    currentEnvironment = env ? env : restoreEnvironment();
    ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.ENV, currentEnvironment.toUpperCase());
};
exports.setEnvironment = setEnvironment;
var web = {
    getAdminUrl: function (path) {
        var baseUrl = isProdEnvironment() ? URL_ADMIN.PRODUCTION : URL_ADMIN.STAGING;
        return "" + baseUrl + (path ? path : '');
    },
    getWebappUrl: function (env) {
        if (env) {
            return env;
        }
        if (app.IS_DEVELOPMENT) {
            var currentEnvironment_1 = getEnvironment();
            if (currentEnvironment_1) {
                return URL_WEBAPP[currentEnvironment_1.toUpperCase()];
            }
        }
        return URL_WEBAPP.PRODUCTION;
    },
    getWebsiteUrl: function (path) {
        var baseUrl = isProdEnvironment() ? URL_WEBSITE.PRODUCTION : URL_WEBSITE.STAGING;
        return "" + baseUrl + (path ? path : '');
    },
};
exports.web = web;
//# sourceMappingURL=EnvironmentUtil.js.map