import * as Electron from 'electron';
import { i18nLanguageIdentifier } from './locale';
export interface ElectronMenuWithI18n extends Electron.Menu {
    i18n?: i18nLanguageIdentifier;
}
export interface ElectronMenuWithTimeAndImage extends Electron.Menu {
    image?: string;
    timestamp?: string;
}
export interface ElectronMenuItemWithI18n extends Electron.MenuItemConstructorOptions {
    i18n?: i18nLanguageIdentifier;
    selector?: string;
    submenu?: ElectronMenuItemWithI18n[] | ElectronMenuWithI18n;
}
export interface PinningResult {
    decoding?: boolean;
    errorMessage?: string;
    verifiedIssuerRootPubkeys?: boolean;
    verifiedPublicKeyInfo?: boolean;
}
export interface Schemata {
    [version: string]: any;
}
export declare type Point = [number, number];
export declare type Rectangle = {
    height: number;
    width: number;
    x: number;
    y: number;
};
export declare type SpawnCallback = (error: SpawnError | null, stdout: string) => void;
export declare type SpawnError = Error & {
    code?: number | null;
    stdout?: string | null;
};
