/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AArch64 target                         *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 19;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AArch64InstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AArch64InstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr&) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static AArch64InstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AArch64InstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(1),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasFPARMv8Bit = 5,
  Feature_HasNEONBit = 2,
  Feature_HasSHA2Bit = 8,
  Feature_HasAESBit = 7,
  Feature_HasDotProdBit = 0,
  Feature_HasCRCBit = 3,
  Feature_HasLSEBit = 9,
  Feature_HasRDMBit = 6,
  Feature_HasPerfMonBit = 10,
  Feature_HasFullFP16Bit = 4,
  Feature_HasFP16FMLBit = 1,
  Feature_HasFuseAESBit = 15,
  Feature_IsLEBit = 11,
  Feature_IsBEBit = 16,
  Feature_UseAlternateSExtLoadCVTF32Bit = 14,
  Feature_NotForCodeSizeBit = 13,
  Feature_UseSTRQroBit = 12,
  Feature_UseBTIBit = 18,
  Feature_NotUseBTIBit = 17,
};

PredicateBitset AArch64InstructionSelector::
computeAvailableModuleFeatures(const AArch64Subtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->hasFPARMv8())
    Features[Feature_HasFPARMv8Bit] = 1;
  if (Subtarget->hasNEON())
    Features[Feature_HasNEONBit] = 1;
  if (Subtarget->hasSHA2())
    Features[Feature_HasSHA2Bit] = 1;
  if (Subtarget->hasAES())
    Features[Feature_HasAESBit] = 1;
  if (Subtarget->hasDotProd())
    Features[Feature_HasDotProdBit] = 1;
  if (Subtarget->hasCRC())
    Features[Feature_HasCRCBit] = 1;
  if (Subtarget->hasLSE())
    Features[Feature_HasLSEBit] = 1;
  if (Subtarget->hasRDM())
    Features[Feature_HasRDMBit] = 1;
  if (Subtarget->hasPerfMon())
    Features[Feature_HasPerfMonBit] = 1;
  if (Subtarget->hasFullFP16())
    Features[Feature_HasFullFP16Bit] = 1;
  if (Subtarget->hasFP16FML())
    Features[Feature_HasFP16FMLBit] = 1;
  if (Subtarget->hasFuseAES())
    Features[Feature_HasFuseAESBit] = 1;
  if (Subtarget->isLittleEndian())
    Features[Feature_IsLEBit] = 1;
  if (!Subtarget->isLittleEndian())
    Features[Feature_IsBEBit] = 1;
  if (Subtarget->useAlternateSExtLoadCVTF32Pattern())
    Features[Feature_UseAlternateSExtLoadCVTF32Bit] = 1;
  return Features;
}

PredicateBitset AArch64InstructionSelector::
computeAvailableFunctionFeatures(const AArch64Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  if (!MF->getFunction().optForSize())
    Features[Feature_NotForCodeSizeBit] = 1;
  if (!Subtarget->isSTRQroSlow() || MF->getFunction().optForSize())
    Features[Feature_UseSTRQroBit] = 1;
  if ( MF->getFunction().hasFnAttribute("branch-target-enforcement") )
    Features[Feature_UseBTIBit] = 1;
  if ( !MF->getFunction().hasFnAttribute("branch-target-enforcement") )
    Features[Feature_NotUseBTIBit] = 1;
  return Features;
}

// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_s128,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 11;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(128),
  LLT::vector(2, 32),
  LLT::vector(2, 64),
  LLT::vector(4, 16),
  LLT::vector(4, 32),
  LLT::vector(8, 8),
  LLT::vector(8, 16),
  LLT::vector(16, 8),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasAES,
  GIFBS_HasCRC,
  GIFBS_HasDotProd,
  GIFBS_HasFPARMv8,
  GIFBS_HasFullFP16,
  GIFBS_HasFuseAES,
  GIFBS_HasLSE,
  GIFBS_HasNEON,
  GIFBS_HasRDM,
  GIFBS_HasSHA2,
  GIFBS_IsBE,
  GIFBS_IsLE,
  GIFBS_HasFP16FML_HasNEON,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasNEON_HasRDM,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasAESBit, },
  {Feature_HasCRCBit, },
  {Feature_HasDotProdBit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasFuseAESBit, },
  {Feature_HasLSEBit, },
  {Feature_HasNEONBit, },
  {Feature_HasRDMBit, },
  {Feature_HasSHA2Bit, },
  {Feature_IsBEBit, },
  {Feature_IsLEBit, },
  {Feature_HasFP16FMLBit, Feature_HasNEONBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasNEONBit, Feature_HasRDMBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_addsub_shifted_imm32,
  GICP_gi_addsub_shifted_imm64,
  GICP_gi_am_indexed128,
  GICP_gi_am_indexed16,
  GICP_gi_am_indexed32,
  GICP_gi_am_indexed64,
  GICP_gi_am_indexed8,
  GICP_gi_am_unscaled128,
  GICP_gi_am_unscaled16,
  GICP_gi_am_unscaled32,
  GICP_gi_am_unscaled64,
  GICP_gi_am_unscaled8,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_VectorIndex1 = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_VectorIndexB,
  GIPFP_I64_Predicate_VectorIndexD,
  GIPFP_I64_Predicate_VectorIndexH,
  GIPFP_I64_Predicate_VectorIndexS,
  GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i16,
  GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i32,
  GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i64,
  GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i8,
  GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i16,
  GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i32,
  GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i64,
  GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i8,
  GIPFP_I64_Predicate_i64imm_32bit,
  GIPFP_I64_Predicate_imm0_1,
  GIPFP_I64_Predicate_imm0_127,
  GIPFP_I64_Predicate_imm0_15,
  GIPFP_I64_Predicate_imm0_255,
  GIPFP_I64_Predicate_imm0_31,
  GIPFP_I64_Predicate_imm0_63,
  GIPFP_I64_Predicate_imm0_65535,
  GIPFP_I64_Predicate_imm0_7,
  GIPFP_I64_Predicate_imm32_0_15,
  GIPFP_I64_Predicate_imm32_0_31,
  GIPFP_I64_Predicate_maski16_or_more,
  GIPFP_I64_Predicate_maski8_or_more,
  GIPFP_I64_Predicate_s64imm_32bit,
  GIPFP_I64_Predicate_simm4s1,
  GIPFP_I64_Predicate_simm4s16,
  GIPFP_I64_Predicate_simm4s2,
  GIPFP_I64_Predicate_simm4s3,
  GIPFP_I64_Predicate_simm4s4,
  GIPFP_I64_Predicate_simm5_32b,
  GIPFP_I64_Predicate_simm5_64b,
  GIPFP_I64_Predicate_simm6_32b,
  GIPFP_I64_Predicate_simm6s1,
  GIPFP_I64_Predicate_simm8,
  GIPFP_I64_Predicate_simm9,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_b,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_d,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_h,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_q,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_s,
  GIPFP_I64_Predicate_sve_incdec_imm,
  GIPFP_I64_Predicate_sve_pred_enum,
  GIPFP_I64_Predicate_sve_prfop,
  GIPFP_I64_Predicate_tbz_imm0_31_diag,
  GIPFP_I64_Predicate_tbz_imm0_31_nodiag,
  GIPFP_I64_Predicate_tbz_imm32_63,
  GIPFP_I64_Predicate_uimm16,
  GIPFP_I64_Predicate_uimm5s2,
  GIPFP_I64_Predicate_uimm5s4,
  GIPFP_I64_Predicate_uimm5s8,
  GIPFP_I64_Predicate_uimm6,
  GIPFP_I64_Predicate_uimm6s1,
  GIPFP_I64_Predicate_uimm6s16,
  GIPFP_I64_Predicate_uimm6s2,
  GIPFP_I64_Predicate_uimm6s4,
  GIPFP_I64_Predicate_uimm6s8,
  GIPFP_I64_Predicate_vecshiftL16,
  GIPFP_I64_Predicate_vecshiftL32,
  GIPFP_I64_Predicate_vecshiftL64,
  GIPFP_I64_Predicate_vecshiftL8,
  GIPFP_I64_Predicate_vecshiftR16,
  GIPFP_I64_Predicate_vecshiftR16Narrow,
  GIPFP_I64_Predicate_vecshiftR32,
  GIPFP_I64_Predicate_vecshiftR32Narrow,
  GIPFP_I64_Predicate_vecshiftR64,
  GIPFP_I64_Predicate_vecshiftR64Narrow,
  GIPFP_I64_Predicate_vecshiftR8,
};
bool AArch64InstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_VectorIndex1: {
     return ((uint64_t)Imm) == 1; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexB: {
     return ((uint64_t)Imm) < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexD: {
     return ((uint64_t)Imm) < 2; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexH: {
     return ((uint64_t)Imm) < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexS: {
     return ((uint64_t)Imm) < 4; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i16: {
    
  return AArch64_AM::isSVEAddSubImm<int16_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i32: {
    
  return AArch64_AM::isSVEAddSubImm<int32_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i64: {
    
  return AArch64_AM::isSVEAddSubImm<int64_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_addsub_imm8_opt_lsl_i8: {
    
  return AArch64_AM::isSVEAddSubImm<int8_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i16: {
    
  return AArch64_AM::isSVECpyImm<int16_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i32: {
    
  return AArch64_AM::isSVECpyImm<int32_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i64: {
    
  return AArch64_AM::isSVECpyImm<int64_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_cpy_imm8_opt_lsl_i8: {
    
  return AArch64_AM::isSVECpyImm<int8_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_i64imm_32bit: {
    
  return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_1: {
    
  return ((uint64_t)Imm) < 2;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_127: {
    
  return ((uint32_t)Imm) < 128;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_15: {
    
  return ((uint64_t)Imm) < 16;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_255: {
    
  return ((uint32_t)Imm) < 256;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_31: {
    
  return ((uint64_t)Imm) < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_63: {
    
  return ((uint64_t)Imm) < 64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_65535: {
    
  return ((uint32_t)Imm) < 65536;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_7: {
    
  return ((uint64_t)Imm) < 8;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm32_0_15: {
    
  return ((uint32_t)Imm) < 16;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm32_0_31: {
    
  return ((uint64_t)Imm) < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_maski16_or_more: {
     return (Imm & 0xffff) == 0xffff; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_maski8_or_more: {
     return (Imm & 0xff) == 0xff; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_s64imm_32bit: {
    
  int64_t Imm64 = static_cast<int64_t>(Imm);
  return Imm64 >= std::numeric_limits<int32_t>::min() &&
         Imm64 <= std::numeric_limits<int32_t>::max();

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s1: {
     return Imm >=-8  && Imm <= 7; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s16: {
     return Imm >=-128  && Imm <= 112 && (Imm % 16) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s2: {
     return Imm >=-16  && Imm <= 14 && (Imm % 2) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s3: {
     return Imm >=-24  && Imm <= 21 && (Imm % 3) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s4: {
     return Imm >=-32  && Imm <= 28 && (Imm % 4) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_32b: {
     return Imm >= -16 && Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_64b: {
     return Imm >= -16 && Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm6_32b: {
     return Imm >= -32 && Imm < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm6s1: {
     return Imm >= -32 && Imm < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm8: {
     return Imm >= -128 && Imm < 127; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm9: {
     return Imm >= -256 && Imm < 256; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_b: {
     return ((uint64_t)Imm) < 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_d: {
     return ((uint64_t)Imm) < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_h: {
     return ((uint64_t)Imm) < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_q: {
     return ((uint64_t)Imm) < 4; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_s: {
     return ((uint64_t)Imm) < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_incdec_imm: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_pred_enum: {
    
  return (((uint32_t)Imm) < 32);
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_prfop: {
    
    return (((uint32_t)Imm) <= 15);
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tbz_imm0_31_diag: {
    
  return (((uint32_t)Imm) < 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tbz_imm0_31_nodiag: {
    
  return (((uint32_t)Imm) < 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tbz_imm32_63: {
    
  return (((uint32_t)Imm) > 31) && (((uint32_t)Imm) < 64);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm16: {
    return Imm >= 0 && Imm < 65536;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm5s2: {
     return Imm >= 0 && Imm < (32*2) && ((Imm % 2) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm5s4: {
     return Imm >= 0 && Imm < (32*4) && ((Imm % 4) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm5s8: {
     return Imm >= 0 && Imm < (32*8) && ((Imm % 8) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6: {
     return Imm >= 0 && Imm < 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s1: {
     return Imm >= 0 && Imm < 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s16: {
     return Imm >= 0 && Imm < (64*16) && ((Imm % 16) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s2: {
     return Imm >= 0 && Imm < (64*2) && ((Imm % 2) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s4: {
     return Imm >= 0 && Imm < (64*4) && ((Imm % 4) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s8: {
     return Imm >= 0 && Imm < (64*8) && ((Imm % 8) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftL16: {
    
  return (((uint32_t)Imm) < 16);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftL32: {
    
  return (((uint32_t)Imm) < 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftL64: {
    
  return (((uint32_t)Imm) < 64);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftL8: {
    
  return (((uint32_t)Imm) < 8);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR16: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR16Narrow: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR32: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR32Narrow: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR64: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 65);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR64Narrow: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR8: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_APFloat_Predicate_fpimm0 = GIPFP_APFloat_Invalid + 1,
  GIPFP_APFloat_Predicate_fpimm16,
  GIPFP_APFloat_Predicate_fpimm32,
  GIPFP_APFloat_Predicate_fpimm64,
  GIPFP_APFloat_Predicate_simdimmtype10,
};
bool AArch64InstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GIPFP_APFloat_Predicate_fpimm0: {
    
  return Imm.isExactlyValue(+0.0);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm16: {
    
      return AArch64_AM::getFP16Imm(Imm) != -1;
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm32: {
    
      return AArch64_AM::getFP32Imm(Imm) != -1;
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm64: {
    
      return AArch64_AM::getFP64Imm(Imm) != -1;
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_simdimmtype10: {
    
      return AArch64_AM::isAdvSIMDModImmType10(
                 Imm.bitcastToAPInt().getZExtValue());
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_APInt_Predicate_logical_imm32 = GIPFP_APInt_Invalid + 1,
  GIPFP_APInt_Predicate_logical_imm64,
};
bool AArch64InstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GIPFP_APInt_Predicate_logical_imm32: {
    
  return AArch64_AM::isLogicalImmediate(Imm.getZExtValue(), 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APInt_Predicate_logical_imm64: {
    
  return AArch64_AM::isLogicalImmediate(Imm.getZExtValue(), 64);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AArch64InstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}

AArch64InstructionSelector::ComplexMatcherMemFn
AArch64InstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AArch64InstructionSelector::selectArithImmed, // gi_addsub_shifted_imm32
  &AArch64InstructionSelector::selectArithImmed, // gi_addsub_shifted_imm64
  &AArch64InstructionSelector::selectAddrModeIndexed<128>, // gi_am_indexed128
  &AArch64InstructionSelector::selectAddrModeIndexed<16>, // gi_am_indexed16
  &AArch64InstructionSelector::selectAddrModeIndexed<32>, // gi_am_indexed32
  &AArch64InstructionSelector::selectAddrModeIndexed<64>, // gi_am_indexed64
  &AArch64InstructionSelector::selectAddrModeIndexed<8>, // gi_am_indexed8
  &AArch64InstructionSelector::selectAddrModeUnscaled128, // gi_am_unscaled128
  &AArch64InstructionSelector::selectAddrModeUnscaled16, // gi_am_unscaled16
  &AArch64InstructionSelector::selectAddrModeUnscaled32, // gi_am_unscaled32
  &AArch64InstructionSelector::selectAddrModeUnscaled64, // gi_am_unscaled64
  &AArch64InstructionSelector::selectAddrModeUnscaled8, // gi_am_unscaled8
};

// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderTruncImm, 
};
AArch64InstructionSelector::CustomRendererFn
AArch64InstructionSelector::CustomRenderers[] = {
  nullptr, // GICP_Invalid
  &AArch64InstructionSelector::renderTruncImm, // gi_trunc_imm
};

bool AArch64InstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  // FIXME: This should be computed on a per-function basis rather than per-insn.
  AvailableFunctionFeatures = computeAvailableFunctionFeatures(&STI, &MF);
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *AArch64InstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/34, 139, /*)*//*default:*//*Label 53*/ 83121,
    /*TargetOpcode::G_ADD*//*Label 0*/ 110,
    /*TargetOpcode::G_SUB*//*Label 1*/ 7523,
    /*TargetOpcode::G_MUL*//*Label 2*/ 10104,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 10885,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 10954, 0, 0,
    /*TargetOpcode::G_AND*//*Label 5*/ 11023,
    /*TargetOpcode::G_OR*//*Label 6*/ 11681,
    /*TargetOpcode::G_XOR*//*Label 7*/ 12223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 8*/ 12933, 0, 0,
    /*TargetOpcode::G_LOAD*//*Label 9*/ 20426,
    /*TargetOpcode::G_SEXTLOAD*//*Label 10*/ 22482,
    /*TargetOpcode::G_ZEXTLOAD*//*Label 11*/ 22953,
    /*TargetOpcode::G_STORE*//*Label 12*/ 23305, 0,
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 13*/ 25552,
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 14*/ 26749,
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 15*/ 27778,
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 16*/ 28807,
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 17*/ 30216, 0,
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 18*/ 31625,
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 19*/ 32654,
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 20*/ 33683,
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 21*/ 34712,
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 22*/ 35741,
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 23*/ 36770, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 24*/ 37799,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 25*/ 73460,
    /*TargetOpcode::G_ANYEXT*//*Label 26*/ 73702,
    /*TargetOpcode::G_TRUNC*//*Label 27*/ 73816,
    /*TargetOpcode::G_CONSTANT*//*Label 28*/ 73941,
    /*TargetOpcode::G_FCONSTANT*//*Label 29*/ 73994, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 30*/ 74072,
    /*TargetOpcode::G_ZEXT*//*Label 31*/ 74252,
    /*TargetOpcode::G_SHL*//*Label 32*/ 74711,
    /*TargetOpcode::G_LSHR*//*Label 33*/ 74887,
    /*TargetOpcode::G_ASHR*//*Label 34*/ 75138, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 35*/ 75389,
    /*TargetOpcode::G_FSUB*//*Label 36*/ 75962,
    /*TargetOpcode::G_FMUL*//*Label 37*/ 76235,
    /*TargetOpcode::G_FMA*//*Label 38*/ 76901,
    /*TargetOpcode::G_FDIV*//*Label 39*/ 79725, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 40*/ 79998,
    /*TargetOpcode::G_FPEXT*//*Label 41*/ 80546,
    /*TargetOpcode::G_FPTRUNC*//*Label 42*/ 80675,
    /*TargetOpcode::G_FPTOSI*//*Label 43*/ 80804,
    /*TargetOpcode::G_FPTOUI*//*Label 44*/ 81080,
    /*TargetOpcode::G_SITOFP*//*Label 45*/ 81356,
    /*TargetOpcode::G_UITOFP*//*Label 46*/ 81634, 0, 0, 0,
    /*TargetOpcode::G_BR*//*Label 47*/ 81912, 0,
    /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 48*/ 81925, 0,
    /*TargetOpcode::G_CTTZ*//*Label 49*/ 82284, 0,
    /*TargetOpcode::G_CTLZ*//*Label 50*/ 82387, 0,
    /*TargetOpcode::G_CTPOP*//*Label 51*/ 83010,
    /*TargetOpcode::G_BSWAP*//*Label 52*/ 83068,
    // Label 0: @110
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 11, /*)*//*default:*//*Label 63*/ 7522,
    /*GILLT_s32*//*Label 54*/ 126,
    /*GILLT_s64*//*Label 55*/ 227, 0,
    /*GILLT_v2s32*//*Label 56*/ 1437,
    /*GILLT_v2s64*//*Label 57*/ 2050,
    /*GILLT_v4s16*//*Label 58*/ 3153,
    /*GILLT_v4s32*//*Label 59*/ 3766,
    /*GILLT_v8s8*//*Label 60*/ 5239,
    /*GILLT_v8s16*//*Label 61*/ 5644,
    /*GILLT_v16s8*//*Label 62*/ 7117,
    // Label 54: @126
    GIM_Try, /*On fail goto*//*Label 64*/ 226,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 65*/ 170, // Rule ID 3828 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_addsub_shifted_imm32,
        // (add:{ *:[i32] } addsub_shifted_imm32:{ *:[i32] }:$imm, GPR32sp:{ *:[i32] }:$Rn)  =>  (ADDWri:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3828,
        GIR_Done,
      // Label 65: @170
      GIM_Try, /*On fail goto*//*Label 66*/ 204, // Rule ID 50 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm32,
        // (add:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (ADDWri:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50,
        GIR_Done,
      // Label 66: @204
      GIM_Try, /*On fail goto*//*Label 67*/ 225, // Rule ID 52 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ADDWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52,
        GIR_Done,
      // Label 67: @225
      GIM_Reject,
    // Label 64: @226
    GIM_Reject,
    // Label 55: @227
    GIM_Try, /*On fail goto*//*Label 68*/ 1436,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 69*/ 306, // Rule ID 3500 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 0,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] Rn
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 0:{ *:[i64] }), (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 1:{ *:[i64] }))  =>  (ADDPv2i64p:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDPv2i64p,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3500,
        GIR_Done,
      // Label 69: @306
      GIM_Try, /*On fail goto*//*Label 70*/ 375, // Rule ID 4247 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] Rn
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 0,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 1:{ *:[i64] }), (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 0:{ *:[i64] }))  =>  (ADDPv2i64p:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDPv2i64p,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4247,
        GIR_Done,
      // Label 70: @375
      GIM_Try, /*On fail goto*//*Label 71*/ 409, // Rule ID 3829 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_addsub_shifted_imm64,
        // (add:{ *:[i64] } addsub_shifted_imm64:{ *:[i64] }:$imm, GPR64sp:{ *:[i64] }:$Rn)  =>  (ADDXri:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3829,
        GIR_Done,
      // Label 71: @409
      GIM_Try, /*On fail goto*//*Label 72*/ 505, // Rule ID 1913 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1913,
        GIR_Done,
      // Label 72: @505
      GIM_Try, /*On fail goto*//*Label 73*/ 601, // Rule ID 1914 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1914,
        GIR_Done,
      // Label 73: @601
      GIM_Try, /*On fail goto*//*Label 74*/ 635, // Rule ID 51 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm64,
        // (add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (ADDXri:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51,
        GIR_Done,
      // Label 74: @635
      GIM_Try, /*On fail goto*//*Label 75*/ 731, // Rule ID 4080 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4080,
        GIR_Done,
      // Label 75: @731
      GIM_Try, /*On fail goto*//*Label 76*/ 827, // Rule ID 4081 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4081,
        GIR_Done,
      // Label 76: @827
      GIM_Try, /*On fail goto*//*Label 77*/ 912, // Rule ID 3840 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3840,
        GIR_Done,
      // Label 77: @912
      GIM_Try, /*On fail goto*//*Label 78*/ 997, // Rule ID 3841 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3841,
        GIR_Done,
      // Label 78: @997
      GIM_Try, /*On fail goto*//*Label 79*/ 1082, // Rule ID 82 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 82,
        GIR_Done,
      // Label 79: @1082
      GIM_Try, /*On fail goto*//*Label 80*/ 1167, // Rule ID 84 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 84,
        GIR_Done,
      // Label 80: @1167
      GIM_Try, /*On fail goto*//*Label 81*/ 1223, // Rule ID 3894 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } (intrinsic_wo_chain:{ *:[v1i64] } 321:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3894,
        GIR_Done,
      // Label 81: @1223
      GIM_Try, /*On fail goto*//*Label 82*/ 1279, // Rule ID 3900 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } (intrinsic_wo_chain:{ *:[v1i64] } 379:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3900,
        GIR_Done,
      // Label 82: @1279
      GIM_Try, /*On fail goto*//*Label 83*/ 1335, // Rule ID 714 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (intrinsic_wo_chain:{ *:[v1i64] } 321:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn))  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 714,
        GIR_Done,
      // Label 83: @1335
      GIM_Try, /*On fail goto*//*Label 84*/ 1391, // Rule ID 758 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (intrinsic_wo_chain:{ *:[v1i64] } 379:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn))  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 758,
        GIR_Done,
      // Label 84: @1391
      GIM_Try, /*On fail goto*//*Label 85*/ 1412, // Rule ID 53 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ADDXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53,
        GIR_Done,
      // Label 85: @1412
      GIM_Try, /*On fail goto*//*Label 86*/ 1435, // Rule ID 1213 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)  =>  (ADDv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv1i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1213,
        GIR_Done,
      // Label 86: @1435
      GIM_Reject,
    // Label 68: @1436
    GIM_Reject,
    // Label 56: @1437
    GIM_Try, /*On fail goto*//*Label 87*/ 2049,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 88*/ 1515, // Rule ID 3912 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 320:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (SABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3912,
        GIR_Done,
      // Label 88: @1515
      GIM_Try, /*On fail goto*//*Label 89*/ 1579, // Rule ID 3918 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 378:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (UABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3918,
        GIR_Done,
      // Label 89: @1579
      GIM_Try, /*On fail goto*//*Label 90*/ 1631, // Rule ID 3892 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 321:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3892,
        GIR_Done,
      // Label 90: @1631
      GIM_Try, /*On fail goto*//*Label 91*/ 1683, // Rule ID 3898 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 379:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3898,
        GIR_Done,
      // Label 91: @1683
      GIM_Try, /*On fail goto*//*Label 92*/ 1747, // Rule ID 988 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 320:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 988,
        GIR_Done,
      // Label 92: @1747
      GIM_Try, /*On fail goto*//*Label 93*/ 1811, // Rule ID 1099 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 378:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1099,
        GIR_Done,
      // Label 93: @1811
      GIM_Try, /*On fail goto*//*Label 94*/ 1863, // Rule ID 712 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 321:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn))  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 712,
        GIR_Done,
      // Label 94: @1863
      GIM_Try, /*On fail goto*//*Label 95*/ 1915, // Rule ID 756 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 379:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn))  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 756,
        GIR_Done,
      // Label 95: @1915
      GIM_Try, /*On fail goto*//*Label 96*/ 1972, // Rule ID 3906 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (mul:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (MLAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3906,
        GIR_Done,
      // Label 96: @1972
      GIM_Try, /*On fail goto*//*Label 97*/ 2029, // Rule ID 968 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (mul:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (MLAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 968,
        GIR_Done,
      // Label 97: @2029
      GIM_Try, /*On fail goto*//*Label 98*/ 2048, // Rule ID 792 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (ADDv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv2i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 792,
        GIR_Done,
      // Label 98: @2048
      GIM_Reject,
    // Label 87: @2049
    GIM_Reject,
    // Label 57: @2050
    GIM_Try, /*On fail goto*//*Label 99*/ 3152,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 100*/ 2141, // Rule ID 3966 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 320:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (SABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3966,
        GIR_Done,
      // Label 100: @2141
      GIM_Try, /*On fail goto*//*Label 101*/ 2218, // Rule ID 3984 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 378:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (UABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3984,
        GIR_Done,
      // Label 101: @2218
      GIM_Try, /*On fail goto*//*Label 102*/ 2295, // Rule ID 1295 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 320:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)))  =>  (SABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1295,
        GIR_Done,
      // Label 102: @2295
      GIM_Try, /*On fail goto*//*Label 103*/ 2372, // Rule ID 1361 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 378:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)))  =>  (UABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1361,
        GIR_Done,
      // Label 103: @2372
      GIM_Try, /*On fail goto*//*Label 104*/ 2436, // Rule ID 3978 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 337:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3978,
        GIR_Done,
      // Label 104: @2436
      GIM_Try, /*On fail goto*//*Label 105*/ 2500, // Rule ID 3996 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 391:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3996,
        GIR_Done,
      // Label 105: @2500
      GIM_Try, /*On fail goto*//*Label 106*/ 2552, // Rule ID 3895 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 321:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3895,
        GIR_Done,
      // Label 106: @2552
      GIM_Try, /*On fail goto*//*Label 107*/ 2604, // Rule ID 3901 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 379:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3901,
        GIR_Done,
      // Label 107: @2604
      GIM_Try, /*On fail goto*//*Label 108*/ 2668, // Rule ID 1319 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 337:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1319,
        GIR_Done,
      // Label 108: @2668
      GIM_Try, /*On fail goto*//*Label 109*/ 2732, // Rule ID 1379 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 391:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1379,
        GIR_Done,
      // Label 109: @2732
      GIM_Try, /*On fail goto*//*Label 110*/ 2784, // Rule ID 715 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 321:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 715,
        GIR_Done,
      // Label 110: @2784
      GIM_Try, /*On fail goto*//*Label 111*/ 2836, // Rule ID 759 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 379:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 759,
        GIR_Done,
      // Label 111: @2836
      GIM_Try, /*On fail goto*//*Label 112*/ 2894, // Rule ID 1307 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1307,
        GIR_Done,
      // Label 112: @2894
      GIM_Try, /*On fail goto*//*Label 113*/ 2952, // Rule ID 1367 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1367,
        GIR_Done,
      // Label 113: @2952
      GIM_Try, /*On fail goto*//*Label 114*/ 2997, // Rule ID 3972 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (SADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3972,
        GIR_Done,
      // Label 114: @2997
      GIM_Try, /*On fail goto*//*Label 115*/ 3042, // Rule ID 3990 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3990,
        GIR_Done,
      // Label 115: @3042
      GIM_Try, /*On fail goto*//*Label 116*/ 3087, // Rule ID 1313 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1313,
        GIR_Done,
      // Label 116: @3087
      GIM_Try, /*On fail goto*//*Label 117*/ 3132, // Rule ID 1373 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1373,
        GIR_Done,
      // Label 117: @3132
      GIM_Try, /*On fail goto*//*Label 118*/ 3151, // Rule ID 794 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)  =>  (ADDv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv2i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 794,
        GIR_Done,
      // Label 118: @3151
      GIM_Reject,
    // Label 99: @3152
    GIM_Reject,
    // Label 58: @3153
    GIM_Try, /*On fail goto*//*Label 119*/ 3765,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 120*/ 3231, // Rule ID 3910 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 320:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (SABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3910,
        GIR_Done,
      // Label 120: @3231
      GIM_Try, /*On fail goto*//*Label 121*/ 3295, // Rule ID 3916 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 378:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (UABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3916,
        GIR_Done,
      // Label 121: @3295
      GIM_Try, /*On fail goto*//*Label 122*/ 3347, // Rule ID 3890 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 321:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3890,
        GIR_Done,
      // Label 122: @3347
      GIM_Try, /*On fail goto*//*Label 123*/ 3399, // Rule ID 3896 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 379:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3896,
        GIR_Done,
      // Label 123: @3399
      GIM_Try, /*On fail goto*//*Label 124*/ 3463, // Rule ID 986 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 320:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 986,
        GIR_Done,
      // Label 124: @3463
      GIM_Try, /*On fail goto*//*Label 125*/ 3527, // Rule ID 1097 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 378:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1097,
        GIR_Done,
      // Label 125: @3527
      GIM_Try, /*On fail goto*//*Label 126*/ 3579, // Rule ID 710 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 321:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn))  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 710,
        GIR_Done,
      // Label 126: @3579
      GIM_Try, /*On fail goto*//*Label 127*/ 3631, // Rule ID 754 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 379:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn))  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 754,
        GIR_Done,
      // Label 127: @3631
      GIM_Try, /*On fail goto*//*Label 128*/ 3688, // Rule ID 3904 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (mul:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (MLAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3904,
        GIR_Done,
      // Label 128: @3688
      GIM_Try, /*On fail goto*//*Label 129*/ 3745, // Rule ID 966 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (mul:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (MLAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 966,
        GIR_Done,
      // Label 129: @3745
      GIM_Try, /*On fail goto*//*Label 130*/ 3764, // Rule ID 790 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (ADDv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv4i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 790,
        GIR_Done,
      // Label 130: @3764
      GIM_Reject,
    // Label 119: @3765
    GIM_Reject,
    // Label 59: @3766
    GIM_Try, /*On fail goto*//*Label 131*/ 5238,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 132*/ 3857, // Rule ID 3964 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 320:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (SABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3964,
        GIR_Done,
      // Label 132: @3857
      GIM_Try, /*On fail goto*//*Label 133*/ 3934, // Rule ID 3982 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 378:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (UABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3982,
        GIR_Done,
      // Label 133: @3934
      GIM_Try, /*On fail goto*//*Label 134*/ 4011, // Rule ID 1293 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 320:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)))  =>  (SABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1293,
        GIR_Done,
      // Label 134: @4011
      GIM_Try, /*On fail goto*//*Label 135*/ 4088, // Rule ID 1359 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 378:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)))  =>  (UABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1359,
        GIR_Done,
      // Label 135: @4088
      GIM_Try, /*On fail goto*//*Label 136*/ 4152, // Rule ID 3913 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 320:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (SABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3913,
        GIR_Done,
      // Label 136: @4152
      GIM_Try, /*On fail goto*//*Label 137*/ 4216, // Rule ID 3919 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 378:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (UABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3919,
        GIR_Done,
      // Label 137: @4216
      GIM_Try, /*On fail goto*//*Label 138*/ 4280, // Rule ID 3976 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 337:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3976,
        GIR_Done,
      // Label 138: @4280
      GIM_Try, /*On fail goto*//*Label 139*/ 4344, // Rule ID 3994 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 391:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3994,
        GIR_Done,
      // Label 139: @4344
      GIM_Try, /*On fail goto*//*Label 140*/ 4396, // Rule ID 3893 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 321:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3893,
        GIR_Done,
      // Label 140: @4396
      GIM_Try, /*On fail goto*//*Label 141*/ 4448, // Rule ID 3899 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 379:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3899,
        GIR_Done,
      // Label 141: @4448
      GIM_Try, /*On fail goto*//*Label 142*/ 4512, // Rule ID 989 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 320:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (SABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 989,
        GIR_Done,
      // Label 142: @4512
      GIM_Try, /*On fail goto*//*Label 143*/ 4576, // Rule ID 1100 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 378:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (UABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1100,
        GIR_Done,
      // Label 143: @4576
      GIM_Try, /*On fail goto*//*Label 144*/ 4640, // Rule ID 1317 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 337:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1317,
        GIR_Done,
      // Label 144: @4640
      GIM_Try, /*On fail goto*//*Label 145*/ 4704, // Rule ID 1377 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 391:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1377,
        GIR_Done,
      // Label 145: @4704
      GIM_Try, /*On fail goto*//*Label 146*/ 4756, // Rule ID 713 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 321:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 713,
        GIR_Done,
      // Label 146: @4756
      GIM_Try, /*On fail goto*//*Label 147*/ 4808, // Rule ID 757 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 379:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 757,
        GIR_Done,
      // Label 147: @4808
      GIM_Try, /*On fail goto*//*Label 148*/ 4866, // Rule ID 1305 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1305,
        GIR_Done,
      // Label 148: @4866
      GIM_Try, /*On fail goto*//*Label 149*/ 4924, // Rule ID 1365 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1365,
        GIR_Done,
      // Label 149: @4924
      GIM_Try, /*On fail goto*//*Label 150*/ 4981, // Rule ID 3907 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (MLAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3907,
        GIR_Done,
      // Label 150: @4981
      GIM_Try, /*On fail goto*//*Label 151*/ 5026, // Rule ID 3970 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (SADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3970,
        GIR_Done,
      // Label 151: @5026
      GIM_Try, /*On fail goto*//*Label 152*/ 5071, // Rule ID 3988 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3988,
        GIR_Done,
      // Label 152: @5071
      GIM_Try, /*On fail goto*//*Label 153*/ 5128, // Rule ID 969 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (mul:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (MLAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 969,
        GIR_Done,
      // Label 153: @5128
      GIM_Try, /*On fail goto*//*Label 154*/ 5173, // Rule ID 1311 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1311,
        GIR_Done,
      // Label 154: @5173
      GIM_Try, /*On fail goto*//*Label 155*/ 5218, // Rule ID 1371 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1371,
        GIR_Done,
      // Label 155: @5218
      GIM_Try, /*On fail goto*//*Label 156*/ 5237, // Rule ID 793 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (ADDv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv4i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 793,
        GIR_Done,
      // Label 156: @5237
      GIM_Reject,
    // Label 131: @5238
    GIM_Reject,
    // Label 60: @5239
    GIM_Try, /*On fail goto*//*Label 157*/ 5643,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 158*/ 5317, // Rule ID 3908 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 320:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (SABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3908,
        GIR_Done,
      // Label 158: @5317
      GIM_Try, /*On fail goto*//*Label 159*/ 5381, // Rule ID 3914 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 378:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (UABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3914,
        GIR_Done,
      // Label 159: @5381
      GIM_Try, /*On fail goto*//*Label 160*/ 5445, // Rule ID 984 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 320:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 984,
        GIR_Done,
      // Label 160: @5445
      GIM_Try, /*On fail goto*//*Label 161*/ 5509, // Rule ID 1095 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 378:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1095,
        GIR_Done,
      // Label 161: @5509
      GIM_Try, /*On fail goto*//*Label 162*/ 5566, // Rule ID 3902 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (mul:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (MLAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3902,
        GIR_Done,
      // Label 162: @5566
      GIM_Try, /*On fail goto*//*Label 163*/ 5623, // Rule ID 964 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (mul:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (MLAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 964,
        GIR_Done,
      // Label 163: @5623
      GIM_Try, /*On fail goto*//*Label 164*/ 5642, // Rule ID 788 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ADDv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 788,
        GIR_Done,
      // Label 164: @5642
      GIM_Reject,
    // Label 157: @5643
    GIM_Reject,
    // Label 61: @5644
    GIM_Try, /*On fail goto*//*Label 165*/ 7116,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 166*/ 5735, // Rule ID 3962 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 320:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (SABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3962,
        GIR_Done,
      // Label 166: @5735
      GIM_Try, /*On fail goto*//*Label 167*/ 5812, // Rule ID 3980 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 378:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (UABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3980,
        GIR_Done,
      // Label 167: @5812
      GIM_Try, /*On fail goto*//*Label 168*/ 5889, // Rule ID 1291 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 320:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)))  =>  (SABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1291,
        GIR_Done,
      // Label 168: @5889
      GIM_Try, /*On fail goto*//*Label 169*/ 5966, // Rule ID 1357 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 378:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)))  =>  (UABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1357,
        GIR_Done,
      // Label 169: @5966
      GIM_Try, /*On fail goto*//*Label 170*/ 6030, // Rule ID 3911 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 320:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (SABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3911,
        GIR_Done,
      // Label 170: @6030
      GIM_Try, /*On fail goto*//*Label 171*/ 6094, // Rule ID 3917 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 378:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (UABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3917,
        GIR_Done,
      // Label 171: @6094
      GIM_Try, /*On fail goto*//*Label 172*/ 6158, // Rule ID 3974 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 337:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (SMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3974,
        GIR_Done,
      // Label 172: @6158
      GIM_Try, /*On fail goto*//*Label 173*/ 6222, // Rule ID 3992 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 391:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (UMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3992,
        GIR_Done,
      // Label 173: @6222
      GIM_Try, /*On fail goto*//*Label 174*/ 6274, // Rule ID 3891 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 321:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3891,
        GIR_Done,
      // Label 174: @6274
      GIM_Try, /*On fail goto*//*Label 175*/ 6326, // Rule ID 3897 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 379:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3897,
        GIR_Done,
      // Label 175: @6326
      GIM_Try, /*On fail goto*//*Label 176*/ 6390, // Rule ID 987 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 320:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (SABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 987,
        GIR_Done,
      // Label 176: @6390
      GIM_Try, /*On fail goto*//*Label 177*/ 6454, // Rule ID 1098 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 378:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (UABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1098,
        GIR_Done,
      // Label 177: @6454
      GIM_Try, /*On fail goto*//*Label 178*/ 6518, // Rule ID 1315 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 337:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1315,
        GIR_Done,
      // Label 178: @6518
      GIM_Try, /*On fail goto*//*Label 179*/ 6582, // Rule ID 1375 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 391:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1375,
        GIR_Done,
      // Label 179: @6582
      GIM_Try, /*On fail goto*//*Label 180*/ 6634, // Rule ID 711 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 321:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn))  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 711,
        GIR_Done,
      // Label 180: @6634
      GIM_Try, /*On fail goto*//*Label 181*/ 6686, // Rule ID 755 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 379:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn))  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 755,
        GIR_Done,
      // Label 181: @6686
      GIM_Try, /*On fail goto*//*Label 182*/ 6744, // Rule ID 1303 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1303,
        GIR_Done,
      // Label 182: @6744
      GIM_Try, /*On fail goto*//*Label 183*/ 6802, // Rule ID 1363 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1363,
        GIR_Done,
      // Label 183: @6802
      GIM_Try, /*On fail goto*//*Label 184*/ 6859, // Rule ID 3905 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (MLAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3905,
        GIR_Done,
      // Label 184: @6859
      GIM_Try, /*On fail goto*//*Label 185*/ 6904, // Rule ID 3968 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (SADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3968,
        GIR_Done,
      // Label 185: @6904
      GIM_Try, /*On fail goto*//*Label 186*/ 6949, // Rule ID 3986 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3986,
        GIR_Done,
      // Label 186: @6949
      GIM_Try, /*On fail goto*//*Label 187*/ 7006, // Rule ID 967 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (mul:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (MLAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 967,
        GIR_Done,
      // Label 187: @7006
      GIM_Try, /*On fail goto*//*Label 188*/ 7051, // Rule ID 1309 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1309,
        GIR_Done,
      // Label 188: @7051
      GIM_Try, /*On fail goto*//*Label 189*/ 7096, // Rule ID 1369 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1369,
        GIR_Done,
      // Label 189: @7096
      GIM_Try, /*On fail goto*//*Label 190*/ 7115, // Rule ID 791 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (ADDv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv8i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 791,
        GIR_Done,
      // Label 190: @7115
      GIM_Reject,
    // Label 165: @7116
    GIM_Reject,
    // Label 62: @7117
    GIM_Try, /*On fail goto*//*Label 191*/ 7521,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 192*/ 7195, // Rule ID 3909 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 320:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm), V128:{ *:[v16i8] }:$Rd)  =>  (SABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3909,
        GIR_Done,
      // Label 192: @7195
      GIM_Try, /*On fail goto*//*Label 193*/ 7259, // Rule ID 3915 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 378:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm), V128:{ *:[v16i8] }:$Rd)  =>  (UABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3915,
        GIR_Done,
      // Label 193: @7259
      GIM_Try, /*On fail goto*//*Label 194*/ 7323, // Rule ID 985 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (intrinsic_wo_chain:{ *:[v16i8] } 320:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm))  =>  (SABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 985,
        GIR_Done,
      // Label 194: @7323
      GIM_Try, /*On fail goto*//*Label 195*/ 7387, // Rule ID 1096 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (intrinsic_wo_chain:{ *:[v16i8] } 378:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm))  =>  (UABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1096,
        GIR_Done,
      // Label 195: @7387
      GIM_Try, /*On fail goto*//*Label 196*/ 7444, // Rule ID 3903 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm), V128:{ *:[v16i8] }:$Rd)  =>  (MLAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3903,
        GIR_Done,
      // Label 196: @7444
      GIM_Try, /*On fail goto*//*Label 197*/ 7501, // Rule ID 965 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (mul:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm))  =>  (MLAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 965,
        GIR_Done,
      // Label 197: @7501
      GIM_Try, /*On fail goto*//*Label 198*/ 7520, // Rule ID 789 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ADDv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 789,
        GIR_Done,
      // Label 198: @7520
      GIM_Reject,
    // Label 191: @7521
    GIM_Reject,
    // Label 63: @7522
    GIM_Reject,
    // Label 1: @7523
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 11, /*)*//*default:*//*Label 208*/ 10103,
    /*GILLT_s32*//*Label 199*/ 7539,
    /*GILLT_s64*//*Label 200*/ 7659, 0,
    /*GILLT_v2s32*//*Label 201*/ 8530,
    /*GILLT_v2s64*//*Label 202*/ 8618,
    /*GILLT_v4s16*//*Label 203*/ 8987,
    /*GILLT_v4s32*//*Label 204*/ 9075,
    /*GILLT_v8s8*//*Label 205*/ 9501,
    /*GILLT_v8s16*//*Label 206*/ 9589,
    /*GILLT_v16s8*//*Label 207*/ 10015,
    // Label 199: @7539
    GIM_Try, /*On fail goto*//*Label 209*/ 7658,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 210*/ 7607, // Rule ID 1899 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm))  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1899,
        GIR_Done,
      // Label 210: @7607
      GIM_Try, /*On fail goto*//*Label 211*/ 7637, // Rule ID 1865 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm32,
        // (sub:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1865,
        GIR_Done,
      // Label 211: @7637
      GIM_Try, /*On fail goto*//*Label 212*/ 7657, // Rule ID 1867 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (SUBSWrr:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBSWrr,
        GIR_AddImplicitDef, /*InsnID*/0, AArch64::NZCV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1867,
        GIR_Done,
      // Label 212: @7657
      GIM_Reject,
    // Label 209: @7658
    GIM_Reject,
    // Label 200: @7659
    GIM_Try, /*On fail goto*//*Label 213*/ 8529,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 214*/ 7764, // Rule ID 1910 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1910,
        GIR_Done,
      // Label 214: @7764
      GIM_Try, /*On fail goto*//*Label 215*/ 7859, // Rule ID 1911 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1911,
        GIR_Done,
      // Label 215: @7859
      GIM_Try, /*On fail goto*//*Label 216*/ 7943, // Rule ID 1905 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1905,
        GIR_Done,
      // Label 216: @7943
      GIM_Try, /*On fail goto*//*Label 217*/ 8027, // Rule ID 1906 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1906,
        GIR_Done,
      // Label 217: @8027
      GIM_Try, /*On fail goto*//*Label 218*/ 8123, // Rule ID 1916 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1916,
        GIR_Done,
      // Label 218: @8123
      GIM_Try, /*On fail goto*//*Label 219*/ 8219, // Rule ID 1917 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1917,
        GIR_Done,
      // Label 219: @8219
      GIM_Try, /*On fail goto*//*Label 220*/ 8304, // Rule ID 83 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 83,
        GIR_Done,
      // Label 220: @8304
      GIM_Try, /*On fail goto*//*Label 221*/ 8389, // Rule ID 85 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 85,
        GIR_Done,
      // Label 221: @8389
      GIM_Try, /*On fail goto*//*Label 222*/ 8447, // Rule ID 1900 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm))  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1900,
        GIR_Done,
      // Label 222: @8447
      GIM_Try, /*On fail goto*//*Label 223*/ 8481, // Rule ID 1866 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm64,
        // (sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1866,
        GIR_Done,
      // Label 223: @8481
      GIM_Try, /*On fail goto*//*Label 224*/ 8504, // Rule ID 1250 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)  =>  (SUBv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv1i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1250,
        GIR_Done,
      // Label 224: @8504
      GIM_Try, /*On fail goto*//*Label 225*/ 8528, // Rule ID 1868 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (SUBSXrr:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBSXrr,
        GIR_AddImplicitDef, /*InsnID*/0, AArch64::NZCV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1868,
        GIR_Done,
      // Label 225: @8528
      GIM_Reject,
    // Label 213: @8529
    GIM_Reject,
    // Label 201: @8530
    GIM_Try, /*On fail goto*//*Label 226*/ 8617,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 227*/ 8601, // Rule ID 974 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (mul:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (MLSv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLSv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 974,
        GIR_Done,
      // Label 227: @8601
      GIM_Try, /*On fail goto*//*Label 228*/ 8616, // Rule ID 1092 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (SUBv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv2i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1092,
        GIR_Done,
      // Label 228: @8616
      GIM_Reject,
    // Label 226: @8617
    GIM_Reject,
    // Label 202: @8618
    GIM_Try, /*On fail goto*//*Label 229*/ 8986,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 230*/ 8696, // Rule ID 1325 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 337:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SMLSLv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLSLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1325,
        GIR_Done,
      // Label 230: @8696
      GIM_Try, /*On fail goto*//*Label 231*/ 8760, // Rule ID 1385 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 391:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UMLSLv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLSLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1385,
        GIR_Done,
      // Label 231: @8760
      GIM_Try, /*On fail goto*//*Label 232*/ 8818, // Rule ID 1349 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SSUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1349,
        GIR_Done,
      // Label 232: @8818
      GIM_Try, /*On fail goto*//*Label 233*/ 8876, // Rule ID 1397 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1397,
        GIR_Done,
      // Label 233: @8876
      GIM_Try, /*On fail goto*//*Label 234*/ 8921, // Rule ID 1355 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SSUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1355,
        GIR_Done,
      // Label 234: @8921
      GIM_Try, /*On fail goto*//*Label 235*/ 8966, // Rule ID 1403 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1403,
        GIR_Done,
      // Label 235: @8966
      GIM_Try, /*On fail goto*//*Label 236*/ 8985, // Rule ID 1094 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)  =>  (SUBv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv2i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1094,
        GIR_Done,
      // Label 236: @8985
      GIM_Reject,
    // Label 229: @8986
    GIM_Reject,
    // Label 203: @8987
    GIM_Try, /*On fail goto*//*Label 237*/ 9074,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 238*/ 9058, // Rule ID 972 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (mul:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (MLSv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLSv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 972,
        GIR_Done,
      // Label 238: @9058
      GIM_Try, /*On fail goto*//*Label 239*/ 9073, // Rule ID 1090 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (SUBv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv4i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1090,
        GIR_Done,
      // Label 239: @9073
      GIM_Reject,
    // Label 237: @9074
    GIM_Reject,
    // Label 204: @9075
    GIM_Try, /*On fail goto*//*Label 240*/ 9500,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 241*/ 9153, // Rule ID 1323 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 337:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SMLSLv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLSLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1323,
        GIR_Done,
      // Label 241: @9153
      GIM_Try, /*On fail goto*//*Label 242*/ 9217, // Rule ID 1383 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 391:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UMLSLv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLSLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1383,
        GIR_Done,
      // Label 242: @9217
      GIM_Try, /*On fail goto*//*Label 243*/ 9275, // Rule ID 1347 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SSUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1347,
        GIR_Done,
      // Label 243: @9275
      GIM_Try, /*On fail goto*//*Label 244*/ 9333, // Rule ID 1395 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1395,
        GIR_Done,
      // Label 244: @9333
      GIM_Try, /*On fail goto*//*Label 245*/ 9390, // Rule ID 975 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (mul:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (MLSv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLSv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 975,
        GIR_Done,
      // Label 245: @9390
      GIM_Try, /*On fail goto*//*Label 246*/ 9435, // Rule ID 1353 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SSUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1353,
        GIR_Done,
      // Label 246: @9435
      GIM_Try, /*On fail goto*//*Label 247*/ 9480, // Rule ID 1401 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1401,
        GIR_Done,
      // Label 247: @9480
      GIM_Try, /*On fail goto*//*Label 248*/ 9499, // Rule ID 1093 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (SUBv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv4i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1093,
        GIR_Done,
      // Label 248: @9499
      GIM_Reject,
    // Label 240: @9500
    GIM_Reject,
    // Label 205: @9501
    GIM_Try, /*On fail goto*//*Label 249*/ 9588,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 250*/ 9572, // Rule ID 970 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (mul:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (MLSv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLSv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 970,
        GIR_Done,
      // Label 250: @9572
      GIM_Try, /*On fail goto*//*Label 251*/ 9587, // Rule ID 1088 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (SUBv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1088,
        GIR_Done,
      // Label 251: @9587
      GIM_Reject,
    // Label 249: @9588
    GIM_Reject,
    // Label 206: @9589
    GIM_Try, /*On fail goto*//*Label 252*/ 10014,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 253*/ 9667, // Rule ID 1321 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_smull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 337:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SMLSLv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMLSLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1321,
        GIR_Done,
      // Label 253: @9667
      GIM_Try, /*On fail goto*//*Label 254*/ 9731, // Rule ID 1381 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_umull,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 391:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UMLSLv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMLSLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1381,
        GIR_Done,
      // Label 254: @9731
      GIM_Try, /*On fail goto*//*Label 255*/ 9789, // Rule ID 1345 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SSUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1345,
        GIR_Done,
      // Label 255: @9789
      GIM_Try, /*On fail goto*//*Label 256*/ 9847, // Rule ID 1393 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1393,
        GIR_Done,
      // Label 256: @9847
      GIM_Try, /*On fail goto*//*Label 257*/ 9904, // Rule ID 973 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (mul:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (MLSv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLSv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 973,
        GIR_Done,
      // Label 257: @9904
      GIM_Try, /*On fail goto*//*Label 258*/ 9949, // Rule ID 1351 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SSUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1351,
        GIR_Done,
      // Label 258: @9949
      GIM_Try, /*On fail goto*//*Label 259*/ 9994, // Rule ID 1399 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1399,
        GIR_Done,
      // Label 259: @9994
      GIM_Try, /*On fail goto*//*Label 260*/ 10013, // Rule ID 1091 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (SUBv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv8i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1091,
        GIR_Done,
      // Label 260: @10013
      GIM_Reject,
    // Label 252: @10014
    GIM_Reject,
    // Label 207: @10015
    GIM_Try, /*On fail goto*//*Label 261*/ 10102,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 262*/ 10086, // Rule ID 971 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (mul:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm))  =>  (MLSv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MLSv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 971,
        GIR_Done,
      // Label 262: @10086
      GIM_Try, /*On fail goto*//*Label 263*/ 10101, // Rule ID 1089 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (SUBv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1089,
        GIR_Done,
      // Label 263: @10101
      GIM_Reject,
    // Label 261: @10102
    GIM_Reject,
    // Label 208: @10103
    GIM_Reject,
    // Label 2: @10104
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 11, /*)*//*default:*//*Label 272*/ 10884,
    /*GILLT_s32*//*Label 264*/ 10120,
    /*GILLT_s64*//*Label 265*/ 10277, 0,
    /*GILLT_v2s32*//*Label 266*/ 10692, 0,
    /*GILLT_v4s16*//*Label 267*/ 10724,
    /*GILLT_v4s32*//*Label 268*/ 10756,
    /*GILLT_v8s8*//*Label 269*/ 10788,
    /*GILLT_v8s16*//*Label 270*/ 10820,
    /*GILLT_v16s8*//*Label 271*/ 10852,
    // Label 264: @10120
    GIM_Try, /*On fail goto*//*Label 273*/ 10276,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 274*/ 10188, // Rule ID 1901 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i32] } (sub:{ *:[i32] } 0:{ *:[i32] }, GPR32:{ *:[i32] }:$Rn), GPR32:{ *:[i32] }:$Rm)  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1901,
        GIR_Done,
      // Label 274: @10188
      GIM_Try, /*On fail goto*//*Label 275*/ 10242, // Rule ID 4078 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, (sub:{ *:[i32] } 0:{ *:[i32] }, GPR32:{ *:[i32] }:$Rn))  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4078,
        GIR_Done,
      // Label 275: @10242
      GIM_Try, /*On fail goto*//*Label 276*/ 10275, // Rule ID 1897 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (MADDWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MADDWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1897,
        GIR_Done,
      // Label 276: @10275
      GIM_Reject,
    // Label 273: @10276
    GIM_Reject,
    // Label 265: @10277
    GIM_Try, /*On fail goto*//*Label 277*/ 10691,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 278*/ 10345, // Rule ID 1902 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i64] } (sub:{ *:[i64] } 0:{ *:[i64] }, GPR64:{ *:[i64] }:$Rn), GPR64:{ *:[i64] }:$Rm)  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1902,
        GIR_Done,
      // Label 278: @10345
      GIM_Try, /*On fail goto*//*Label 279*/ 10399, // Rule ID 4079 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, (sub:{ *:[i64] } 0:{ *:[i64] }, GPR64:{ *:[i64] }:$Rn))  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4079,
        GIR_Done,
      // Label 279: @10399
      GIM_Try, /*On fail goto*//*Label 280*/ 10469, // Rule ID 1907 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/2, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1907,
        GIR_Done,
      // Label 280: @10469
      GIM_Try, /*On fail goto*//*Label 281*/ 10539, // Rule ID 1908 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/2, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1908,
        GIR_Done,
      // Label 281: @10539
      GIM_Try, /*On fail goto*//*Label 282*/ 10598, // Rule ID 1903 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1903,
        GIR_Done,
      // Label 282: @10598
      GIM_Try, /*On fail goto*//*Label 283*/ 10657, // Rule ID 1904 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1904,
        GIR_Done,
      // Label 283: @10657
      GIM_Try, /*On fail goto*//*Label 284*/ 10690, // Rule ID 1898 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (MADDXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MADDXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1898,
        GIR_Done,
      // Label 284: @10690
      GIM_Reject,
    // Label 277: @10691
    GIM_Reject,
    // Label 266: @10692
    GIM_Try, /*On fail goto*//*Label 285*/ 10723, // Rule ID 980 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (mul:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (MULv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 980,
      GIR_Done,
    // Label 285: @10723
    GIM_Reject,
    // Label 267: @10724
    GIM_Try, /*On fail goto*//*Label 286*/ 10755, // Rule ID 978 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (mul:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (MULv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 978,
      GIR_Done,
    // Label 286: @10755
    GIM_Reject,
    // Label 268: @10756
    GIM_Try, /*On fail goto*//*Label 287*/ 10787, // Rule ID 981 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (mul:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (MULv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 981,
      GIR_Done,
    // Label 287: @10787
    GIM_Reject,
    // Label 269: @10788
    GIM_Try, /*On fail goto*//*Label 288*/ 10819, // Rule ID 976 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (mul:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (MULv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 976,
      GIR_Done,
    // Label 288: @10819
    GIM_Reject,
    // Label 270: @10820
    GIM_Try, /*On fail goto*//*Label 289*/ 10851, // Rule ID 979 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (mul:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (MULv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 979,
      GIR_Done,
    // Label 289: @10851
    GIM_Reject,
    // Label 271: @10852
    GIM_Try, /*On fail goto*//*Label 290*/ 10883, // Rule ID 977 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (mul:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (MULv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 977,
      GIR_Done,
    // Label 290: @10883
    GIM_Reject,
    // Label 272: @10884
    GIM_Reject,
    // Label 3: @10885
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 293*/ 10953,
    /*GILLT_s32*//*Label 291*/ 10893,
    /*GILLT_s64*//*Label 292*/ 10923,
    // Label 291: @10893
    GIM_Try, /*On fail goto*//*Label 294*/ 10922, // Rule ID 76 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
      // (sdiv:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (SDIVWr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SDIVWr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 76,
      GIR_Done,
    // Label 294: @10922
    GIM_Reject,
    // Label 292: @10923
    GIM_Try, /*On fail goto*//*Label 295*/ 10952, // Rule ID 77 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
      // (sdiv:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (SDIVXr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SDIVXr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 77,
      GIR_Done,
    // Label 295: @10952
    GIM_Reject,
    // Label 293: @10953
    GIM_Reject,
    // Label 4: @10954
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 298*/ 11022,
    /*GILLT_s32*//*Label 296*/ 10962,
    /*GILLT_s64*//*Label 297*/ 10992,
    // Label 296: @10962
    GIM_Try, /*On fail goto*//*Label 299*/ 10991, // Rule ID 74 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
      // (udiv:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (UDIVWr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::UDIVWr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 74,
      GIR_Done,
    // Label 299: @10991
    GIM_Reject,
    // Label 297: @10992
    GIM_Try, /*On fail goto*//*Label 300*/ 11021, // Rule ID 75 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
      // (udiv:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (UDIVXr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::UDIVXr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 75,
      GIR_Done,
    // Label 300: @11021
    GIM_Reject,
    // Label 298: @11022
    GIM_Reject,
    // Label 5: @11023
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 11, /*)*//*default:*//*Label 310*/ 11680,
    /*GILLT_s32*//*Label 301*/ 11039,
    /*GILLT_s64*//*Label 302*/ 11290, 0,
    /*GILLT_v2s32*//*Label 303*/ 11456,
    /*GILLT_v2s64*//*Label 304*/ 11488,
    /*GILLT_v4s16*//*Label 305*/ 11520,
    /*GILLT_v4s32*//*Label 306*/ 11552,
    /*GILLT_v8s8*//*Label 307*/ 11584,
    /*GILLT_v8s16*//*Label 308*/ 11616,
    /*GILLT_v16s8*//*Label 309*/ 11648,
    // Label 301: @11039
    GIM_Try, /*On fail goto*//*Label 311*/ 11289,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 312*/ 11111, // Rule ID 2701 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexB,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx), 255:{ *:[i32] })  =>  (UMOVvi8:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMOVvi8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2701,
        GIR_Done,
      // Label 312: @11111
      GIM_Try, /*On fail goto*//*Label 313*/ 11169, // Rule ID 2702 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 65535:{ *:[i32] })  =>  (UMOVvi16:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMOVvi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2702,
        GIR_Done,
      // Label 313: @11169
      GIM_Try, /*On fail goto*//*Label 314*/ 11220, // Rule ID 3850 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (BICWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3850,
        GIR_Done,
      // Label 314: @11220
      GIM_Try, /*On fail goto*//*Label 315*/ 11271, // Rule ID 116 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 116,
        GIR_Done,
      // Label 315: @11271
      GIM_Try, /*On fail goto*//*Label 316*/ 11288, // Rule ID 112 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ANDWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 112,
        GIR_Done,
      // Label 316: @11288
      GIM_Reject,
    // Label 311: @11289
    GIM_Reject,
    // Label 302: @11290
    GIM_Try, /*On fail goto*//*Label 317*/ 11455,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 318*/ 11355, // Rule ID 3851 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (BICXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3851,
        GIR_Done,
      // Label 318: @11355
      GIM_Try, /*On fail goto*//*Label 319*/ 11410, // Rule ID 117 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (BICXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 117,
        GIR_Done,
      // Label 319: @11410
      GIM_Try, /*On fail goto*//*Label 320*/ 11431, // Rule ID 113 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ANDXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 113,
        GIR_Done,
      // Label 320: @11431
      GIM_Try, /*On fail goto*//*Label 321*/ 11454, // Rule ID 1793 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (ANDv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1793,
        GIR_Done,
      // Label 321: @11454
      GIM_Reject,
    // Label 317: @11455
    GIM_Reject,
    // Label 303: @11456
    GIM_Try, /*On fail goto*//*Label 322*/ 11487, // Rule ID 1792 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (ANDv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1792,
      GIR_Done,
    // Label 322: @11487
    GIM_Reject,
    // Label 304: @11488
    GIM_Try, /*On fail goto*//*Label 323*/ 11519, // Rule ID 1796 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (ANDv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1796,
      GIR_Done,
    // Label 323: @11519
    GIM_Reject,
    // Label 305: @11520
    GIM_Try, /*On fail goto*//*Label 324*/ 11551, // Rule ID 1791 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (ANDv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1791,
      GIR_Done,
    // Label 324: @11551
    GIM_Reject,
    // Label 306: @11552
    GIM_Try, /*On fail goto*//*Label 325*/ 11583, // Rule ID 1795 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (ANDv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1795,
      GIR_Done,
    // Label 325: @11583
    GIM_Reject,
    // Label 307: @11584
    GIM_Try, /*On fail goto*//*Label 326*/ 11615, // Rule ID 1199 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ANDv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1199,
      GIR_Done,
    // Label 326: @11615
    GIM_Reject,
    // Label 308: @11616
    GIM_Try, /*On fail goto*//*Label 327*/ 11647, // Rule ID 1794 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (ANDv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1794,
      GIR_Done,
    // Label 327: @11647
    GIM_Reject,
    // Label 309: @11648
    GIM_Try, /*On fail goto*//*Label 328*/ 11679, // Rule ID 1200 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ANDv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1200,
      GIR_Done,
    // Label 328: @11679
    GIM_Reject,
    // Label 310: @11680
    GIM_Reject,
    // Label 6: @11681
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 11, /*)*//*default:*//*Label 338*/ 12222,
    /*GILLT_s32*//*Label 329*/ 11697,
    /*GILLT_s64*//*Label 330*/ 11832, 0,
    /*GILLT_v2s32*//*Label 331*/ 11998,
    /*GILLT_v2s64*//*Label 332*/ 12030,
    /*GILLT_v4s16*//*Label 333*/ 12062,
    /*GILLT_v4s32*//*Label 334*/ 12094,
    /*GILLT_v8s8*//*Label 335*/ 12126,
    /*GILLT_v8s16*//*Label 336*/ 12158,
    /*GILLT_v16s8*//*Label 337*/ 12190,
    // Label 329: @11697
    GIM_Try, /*On fail goto*//*Label 339*/ 11831,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 340*/ 11762, // Rule ID 3870 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (ORNWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3870,
        GIR_Done,
      // Label 340: @11762
      GIM_Try, /*On fail goto*//*Label 341*/ 11813, // Rule ID 128 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (ORNWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 128,
        GIR_Done,
      // Label 341: @11813
      GIM_Try, /*On fail goto*//*Label 342*/ 11830, // Rule ID 132 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ORRWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 132,
        GIR_Done,
      // Label 342: @11830
      GIM_Reject,
    // Label 339: @11831
    GIM_Reject,
    // Label 330: @11832
    GIM_Try, /*On fail goto*//*Label 343*/ 11997,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 344*/ 11897, // Rule ID 3871 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (ORNXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3871,
        GIR_Done,
      // Label 344: @11897
      GIM_Try, /*On fail goto*//*Label 345*/ 11952, // Rule ID 129 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (ORNXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 129,
        GIR_Done,
      // Label 345: @11952
      GIM_Try, /*On fail goto*//*Label 346*/ 11973, // Rule ID 133 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ORRXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 133,
        GIR_Done,
      // Label 346: @11973
      GIM_Try, /*On fail goto*//*Label 347*/ 11996, // Rule ID 2425 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (or:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (ORRv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2425,
        GIR_Done,
      // Label 347: @11996
      GIM_Reject,
    // Label 343: @11997
    GIM_Reject,
    // Label 331: @11998
    GIM_Try, /*On fail goto*//*Label 348*/ 12029, // Rule ID 2424 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (ORRv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2424,
      GIR_Done,
    // Label 348: @12029
    GIM_Reject,
    // Label 332: @12030
    GIM_Try, /*On fail goto*//*Label 349*/ 12061, // Rule ID 2428 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (ORRv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2428,
      GIR_Done,
    // Label 349: @12061
    GIM_Reject,
    // Label 333: @12062
    GIM_Try, /*On fail goto*//*Label 350*/ 12093, // Rule ID 2423 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (or:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (ORRv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2423,
      GIR_Done,
    // Label 350: @12093
    GIM_Reject,
    // Label 334: @12094
    GIM_Try, /*On fail goto*//*Label 351*/ 12125, // Rule ID 2427 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (or:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (ORRv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2427,
      GIR_Done,
    // Label 351: @12125
    GIM_Reject,
    // Label 335: @12126
    GIM_Try, /*On fail goto*//*Label 352*/ 12157, // Rule ID 1211 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (or:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ORRv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1211,
      GIR_Done,
    // Label 352: @12157
    GIM_Reject,
    // Label 336: @12158
    GIM_Try, /*On fail goto*//*Label 353*/ 12189, // Rule ID 2426 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (or:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (ORRv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2426,
      GIR_Done,
    // Label 353: @12189
    GIM_Reject,
    // Label 337: @12190
    GIM_Try, /*On fail goto*//*Label 354*/ 12221, // Rule ID 1212 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (or:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ORRv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1212,
      GIR_Done,
    // Label 354: @12221
    GIM_Reject,
    // Label 338: @12222
    GIM_Reject,
    // Label 7: @12223
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 11, /*)*//*default:*//*Label 364*/ 12932,
    /*GILLT_s32*//*Label 355*/ 12239,
    /*GILLT_s64*//*Label 356*/ 12454, 0,
    /*GILLT_v2s32*//*Label 357*/ 12708,
    /*GILLT_v2s64*//*Label 358*/ 12740,
    /*GILLT_v4s16*//*Label 359*/ 12772,
    /*GILLT_v4s32*//*Label 360*/ 12804,
    /*GILLT_v8s8*//*Label 361*/ 12836,
    /*GILLT_v8s16*//*Label 362*/ 12868,
    /*GILLT_v16s8*//*Label 363*/ 12900,
    // Label 355: @12239
    GIM_Try, /*On fail goto*//*Label 365*/ 12453,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 366*/ 12304, // Rule ID 3854 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rm)  =>  (EONWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3854,
        GIR_Done,
      // Label 366: @12304
      GIM_Try, /*On fail goto*//*Label 367*/ 12355, // Rule ID 120 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm), -1:{ *:[i32] })  =>  (EONWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 120,
        GIR_Done,
      // Label 367: @12355
      GIM_Try, /*On fail goto*//*Label 368*/ 12406, // Rule ID 3855 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }))  =>  (EONWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3855,
        GIR_Done,
      // Label 368: @12406
      GIM_Try, /*On fail goto*//*Label 369*/ 12435, // Rule ID 1919 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Wm, -1:{ *:[i32] })  =>  (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Wm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Wm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1919,
        GIR_Done,
      // Label 369: @12435
      GIM_Try, /*On fail goto*//*Label 370*/ 12452, // Rule ID 124 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (EORWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 124,
        GIR_Done,
      // Label 370: @12452
      GIM_Reject,
    // Label 365: @12453
    GIM_Reject,
    // Label 356: @12454
    GIM_Try, /*On fail goto*//*Label 371*/ 12707,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 372*/ 12519, // Rule ID 3856 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rm)  =>  (EONXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3856,
        GIR_Done,
      // Label 372: @12519
      GIM_Try, /*On fail goto*//*Label 373*/ 12574, // Rule ID 121 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm), -1:{ *:[i64] })  =>  (EONXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 121,
        GIR_Done,
      // Label 373: @12574
      GIM_Try, /*On fail goto*//*Label 374*/ 12629, // Rule ID 3857 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }))  =>  (EONXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3857,
        GIR_Done,
      // Label 374: @12629
      GIM_Try, /*On fail goto*//*Label 375*/ 12662, // Rule ID 1920 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Xm, -1:{ *:[i64] })  =>  (ORNXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Xm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Xm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1920,
        GIR_Done,
      // Label 375: @12662
      GIM_Try, /*On fail goto*//*Label 376*/ 12683, // Rule ID 125 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (EORXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 125,
        GIR_Done,
      // Label 376: @12683
      GIM_Try, /*On fail goto*//*Label 377*/ 12706, // Rule ID 2413 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (EORv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2413,
        GIR_Done,
      // Label 377: @12706
      GIM_Reject,
    // Label 371: @12707
    GIM_Reject,
    // Label 357: @12708
    GIM_Try, /*On fail goto*//*Label 378*/ 12739, // Rule ID 2412 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (EORv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2412,
      GIR_Done,
    // Label 378: @12739
    GIM_Reject,
    // Label 358: @12740
    GIM_Try, /*On fail goto*//*Label 379*/ 12771, // Rule ID 2416 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (EORv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2416,
      GIR_Done,
    // Label 379: @12771
    GIM_Reject,
    // Label 359: @12772
    GIM_Try, /*On fail goto*//*Label 380*/ 12803, // Rule ID 2411 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (EORv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2411,
      GIR_Done,
    // Label 380: @12803
    GIM_Reject,
    // Label 360: @12804
    GIM_Try, /*On fail goto*//*Label 381*/ 12835, // Rule ID 2415 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (EORv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2415,
      GIR_Done,
    // Label 381: @12835
    GIM_Reject,
    // Label 361: @12836
    GIM_Try, /*On fail goto*//*Label 382*/ 12867, // Rule ID 1207 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (EORv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1207,
      GIR_Done,
    // Label 382: @12867
    GIM_Reject,
    // Label 362: @12868
    GIM_Try, /*On fail goto*//*Label 383*/ 12899, // Rule ID 2414 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (EORv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2414,
      GIR_Done,
    // Label 383: @12899
    GIM_Reject,
    // Label 363: @12900
    GIM_Try, /*On fail goto*//*Label 384*/ 12931, // Rule ID 1208 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (EORv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1208,
      GIR_Done,
    // Label 384: @12931
    GIM_Reject,
    // Label 364: @12932
    GIM_Reject,
    // Label 8: @12933
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 11, /*)*//*default:*//*Label 395*/ 20425,
    /*GILLT_s32*//*Label 385*/ 12949,
    /*GILLT_s64*//*Label 386*/ 12995,
    /*GILLT_s128*//*Label 387*/ 14571,
    /*GILLT_v2s32*//*Label 388*/ 15243,
    /*GILLT_v2s64*//*Label 389*/ 16138,
    /*GILLT_v4s16*//*Label 390*/ 16919,
    /*GILLT_v4s32*//*Label 391*/ 17814,
    /*GILLT_v8s8*//*Label 392*/ 18659,
    /*GILLT_v8s16*//*Label 393*/ 19132,
    /*GILLT_v16s8*//*Label 394*/ 19977,
    // Label 385: @12949
    GIM_Try, /*On fail goto*//*Label 396*/ 12994,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 397*/ 12974, // Rule ID 3262 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        // (bitconvert:{ *:[f32] } GPR32:{ *:[i32] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[f32] } GPR32:{ *:[i32] }:$Xn, FPR32:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR32*/5,
        // GIR_Coverage, 3262,
        GIR_Done,
      // Label 397: @12974
      GIM_Try, /*On fail goto*//*Label 398*/ 12993, // Rule ID 3263 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR32RegClassID,
        // (bitconvert:{ *:[i32] } FPR32:{ *:[f32] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[i32] } FPR32:{ *:[f32] }:$Xn, GPR32:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR32*/6,
        // GIR_Coverage, 3263,
        GIR_Done,
      // Label 398: @12993
      GIM_Reject,
    // Label 396: @12994
    GIM_Reject,
    // Label 386: @12995
    GIM_Try, /*On fail goto*//*Label 399*/ 13020, // Rule ID 3240 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v8i8] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v8i8] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3240,
      GIR_Done,
    // Label 399: @13020
    GIM_Try, /*On fail goto*//*Label 400*/ 13045, // Rule ID 3241 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v4i16] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v4i16] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3241,
      GIR_Done,
    // Label 400: @13045
    GIM_Try, /*On fail goto*//*Label 401*/ 13070, // Rule ID 3242 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v2i32] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v2i32] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3242,
      GIR_Done,
    // Label 401: @13070
    GIM_Try, /*On fail goto*//*Label 402*/ 13095, // Rule ID 3243 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v4f16] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v4f16] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3243,
      GIR_Done,
    // Label 402: @13095
    GIM_Try, /*On fail goto*//*Label 403*/ 13120, // Rule ID 3244 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v2f32] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v2f32] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3244,
      GIR_Done,
    // Label 403: @13120
    GIM_Try, /*On fail goto*//*Label 404*/ 13145, // Rule ID 3245 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v1f64] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v1f64] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3245,
      GIR_Done,
    // Label 404: @13145
    GIM_Try, /*On fail goto*//*Label 405*/ 13193, // Rule ID 3251 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v8i8] }:$Vn)  =>  (REV64v8i8:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v8i8] }:$Vn, GPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3251,
      GIR_Done,
    // Label 405: @13193
    GIM_Try, /*On fail goto*//*Label 406*/ 13241, // Rule ID 3252 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v4i16] }:$Vn)  =>  (REV64v4i16:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v4i16] }:$Vn, GPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3252,
      GIR_Done,
    // Label 406: @13241
    GIM_Try, /*On fail goto*//*Label 407*/ 13289, // Rule ID 3253 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v2i32] }:$Vn)  =>  (REV64v2i32:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v2i32] }:$Vn, GPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3253,
      GIR_Done,
    // Label 407: @13289
    GIM_Try, /*On fail goto*//*Label 408*/ 13337, // Rule ID 3254 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v4f16] }:$Vn)  =>  (REV64v4i16:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v4f16] }:$Vn, GPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3254,
      GIR_Done,
    // Label 408: @13337
    GIM_Try, /*On fail goto*//*Label 409*/ 13385, // Rule ID 3255 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v2f32] }:$Vn)  =>  (REV64v2i32:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v2f32] }:$Vn, GPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3255,
      GIR_Done,
    // Label 409: @13385
    GIM_Try, /*On fail goto*//*Label 410*/ 13408, // Rule ID 3256 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v1i64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3256,
      GIR_Done,
    // Label 410: @13408
    GIM_Try, /*On fail goto*//*Label 411*/ 13431, // Rule ID 3257 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v1f64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3257,
      GIR_Done,
    // Label 411: @13431
    GIM_Try, /*On fail goto*//*Label 412*/ 13454, // Rule ID 3258 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v1i64] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v1i64] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3258,
      GIR_Done,
    // Label 412: @13454
    GIM_Try, /*On fail goto*//*Label 413*/ 13477, // Rule ID 3264 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[f64] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[f64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3264,
      GIR_Done,
    // Label 413: @13477
    GIM_Try, /*On fail goto*//*Label 414*/ 13500, // Rule ID 3265 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } FPR64:{ *:[f64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } FPR64:{ *:[f64] }:$Xn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3265,
      GIR_Done,
    // Label 414: @13500
    GIM_Try, /*On fail goto*//*Label 415*/ 13523, // Rule ID 3266 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[i64] } V64:{ *:[v1f64] }:$Vn)  =>  (COPY_TO_REGCLASS:{ *:[i64] } V64:{ *:[v1f64] }:$Vn, GPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/17,
      // GIR_Coverage, 3266,
      GIR_Done,
    // Label 415: @13523
    GIM_Try, /*On fail goto*//*Label 416*/ 13557, // Rule ID 3267 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3267,
      GIR_Done,
    // Label 416: @13557
    GIM_Try, /*On fail goto*//*Label 417*/ 13591, // Rule ID 3268 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3268,
      GIR_Done,
    // Label 417: @13591
    GIM_Try, /*On fail goto*//*Label 418*/ 13625, // Rule ID 3269 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3269,
      GIR_Done,
    // Label 418: @13625
    GIM_Try, /*On fail goto*//*Label 419*/ 13659, // Rule ID 3270 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3270,
      GIR_Done,
    // Label 419: @13659
    GIM_Try, /*On fail goto*//*Label 420*/ 13693, // Rule ID 3271 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3271,
      GIR_Done,
    // Label 420: @13693
    GIM_Try, /*On fail goto*//*Label 421*/ 13716, // Rule ID 3272 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v2i32] }:$src)  =>  (REV64v2i32:{ *:[v1i64] } FPR64:{ *:[v2i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3272,
      GIR_Done,
    // Label 421: @13716
    GIM_Try, /*On fail goto*//*Label 422*/ 13739, // Rule ID 3273 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v4i16] }:$src)  =>  (REV64v4i16:{ *:[v1i64] } FPR64:{ *:[v4i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3273,
      GIR_Done,
    // Label 422: @13739
    GIM_Try, /*On fail goto*//*Label 423*/ 13762, // Rule ID 3274 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v8i8] }:$src)  =>  (REV64v8i8:{ *:[v1i64] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3274,
      GIR_Done,
    // Label 423: @13762
    GIM_Try, /*On fail goto*//*Label 424*/ 13785, // Rule ID 3275 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v4f16] }:$src)  =>  (REV64v4i16:{ *:[v1i64] } FPR64:{ *:[v4f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3275,
      GIR_Done,
    // Label 424: @13785
    GIM_Try, /*On fail goto*//*Label 425*/ 13808, // Rule ID 3276 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v2f32] }:$src)  =>  (REV64v2i32:{ *:[v1i64] } FPR64:{ *:[v2f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3276,
      GIR_Done,
    // Label 425: @13808
    GIM_Try, /*On fail goto*//*Label 426*/ 13840, // Rule ID 3277 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3277,
      GIR_Done,
    // Label 426: @13840
    GIM_Try, /*On fail goto*//*Label 427*/ 13872, // Rule ID 3278 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1i64] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3278,
      GIR_Done,
    // Label 427: @13872
    GIM_Try, /*On fail goto*//*Label 428*/ 13906, // Rule ID 3332 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3332,
      GIR_Done,
    // Label 428: @13906
    GIM_Try, /*On fail goto*//*Label 429*/ 13940, // Rule ID 3333 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3333,
      GIR_Done,
    // Label 429: @13940
    GIM_Try, /*On fail goto*//*Label 430*/ 13974, // Rule ID 3334 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3334,
      GIR_Done,
    // Label 430: @13974
    GIM_Try, /*On fail goto*//*Label 431*/ 14008, // Rule ID 3335 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3335,
      GIR_Done,
    // Label 431: @14008
    GIM_Try, /*On fail goto*//*Label 432*/ 14042, // Rule ID 3336 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3336,
      GIR_Done,
    // Label 432: @14042
    GIM_Try, /*On fail goto*//*Label 433*/ 14065, // Rule ID 3337 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v2i32] }:$src)  =>  (REV64v2i32:{ *:[f64] } FPR64:{ *:[v2i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3337,
      GIR_Done,
    // Label 433: @14065
    GIM_Try, /*On fail goto*//*Label 434*/ 14088, // Rule ID 3338 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v4i16] }:$src)  =>  (REV64v4i16:{ *:[f64] } FPR64:{ *:[v4i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3338,
      GIR_Done,
    // Label 434: @14088
    GIM_Try, /*On fail goto*//*Label 435*/ 14111, // Rule ID 3339 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v2f32] }:$src)  =>  (REV64v2i32:{ *:[f64] } FPR64:{ *:[v2f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3339,
      GIR_Done,
    // Label 435: @14111
    GIM_Try, /*On fail goto*//*Label 436*/ 14134, // Rule ID 3340 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v8i8] }:$src)  =>  (REV64v8i8:{ *:[f64] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3340,
      GIR_Done,
    // Label 436: @14134
    GIM_Try, /*On fail goto*//*Label 437*/ 14157, // Rule ID 3341 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v4f16] }:$src)  =>  (REV64v4i16:{ *:[f64] } FPR64:{ *:[v4f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3341,
      GIR_Done,
    // Label 437: @14157
    GIM_Try, /*On fail goto*//*Label 438*/ 14189, // Rule ID 3342 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3342,
      GIR_Done,
    // Label 438: @14189
    GIM_Try, /*On fail goto*//*Label 439*/ 14221, // Rule ID 3343 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[f64] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3343,
      GIR_Done,
    // Label 439: @14221
    GIM_Try, /*On fail goto*//*Label 440*/ 14255, // Rule ID 3344 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3344,
      GIR_Done,
    // Label 440: @14255
    GIM_Try, /*On fail goto*//*Label 441*/ 14289, // Rule ID 3345 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3345,
      GIR_Done,
    // Label 441: @14289
    GIM_Try, /*On fail goto*//*Label 442*/ 14323, // Rule ID 3346 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3346,
      GIR_Done,
    // Label 442: @14323
    GIM_Try, /*On fail goto*//*Label 443*/ 14357, // Rule ID 3347 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3347,
      GIR_Done,
    // Label 443: @14357
    GIM_Try, /*On fail goto*//*Label 444*/ 14391, // Rule ID 3348 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3348,
      GIR_Done,
    // Label 444: @14391
    GIM_Try, /*On fail goto*//*Label 445*/ 14414, // Rule ID 3349 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v2i32] }:$src)  =>  (REV64v2i32:{ *:[v1f64] } FPR64:{ *:[v2i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3349,
      GIR_Done,
    // Label 445: @14414
    GIM_Try, /*On fail goto*//*Label 446*/ 14437, // Rule ID 3350 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v4i16] }:$src)  =>  (REV64v4i16:{ *:[v1f64] } FPR64:{ *:[v4i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3350,
      GIR_Done,
    // Label 446: @14437
    GIM_Try, /*On fail goto*//*Label 447*/ 14460, // Rule ID 3351 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v8i8] }:$src)  =>  (REV64v8i8:{ *:[v1f64] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3351,
      GIR_Done,
    // Label 447: @14460
    GIM_Try, /*On fail goto*//*Label 448*/ 14483, // Rule ID 3352 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v2f32] }:$src)  =>  (REV64v2i32:{ *:[v1f64] } FPR64:{ *:[v2f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3352,
      GIR_Done,
    // Label 448: @14483
    GIM_Try, /*On fail goto*//*Label 449*/ 14506, // Rule ID 3353 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v4f16] }:$src)  =>  (REV64v4i16:{ *:[v1f64] } FPR64:{ *:[v4f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3353,
      GIR_Done,
    // Label 449: @14506
    GIM_Try, /*On fail goto*//*Label 450*/ 14538, // Rule ID 3354 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3354,
      GIR_Done,
    // Label 450: @14538
    GIM_Try, /*On fail goto*//*Label 451*/ 14570, // Rule ID 3355 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v1f64] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v1f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3355,
      GIR_Done,
    // Label 451: @14570
    GIM_Reject,
    // Label 387: @14571
    GIM_Try, /*On fail goto*//*Label 452*/ 14605, // Rule ID 3369 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3369,
      GIR_Done,
    // Label 452: @14605
    GIM_Try, /*On fail goto*//*Label 453*/ 14639, // Rule ID 3370 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3370,
      GIR_Done,
    // Label 453: @14639
    GIM_Try, /*On fail goto*//*Label 454*/ 14673, // Rule ID 3371 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3371,
      GIR_Done,
    // Label 454: @14673
    GIM_Try, /*On fail goto*//*Label 455*/ 14707, // Rule ID 3372 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3372,
      GIR_Done,
    // Label 455: @14707
    GIM_Try, /*On fail goto*//*Label 456*/ 14741, // Rule ID 3373 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3373,
      GIR_Done,
    // Label 456: @14741
    GIM_Try, /*On fail goto*//*Label 457*/ 14775, // Rule ID 3374 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3374,
      GIR_Done,
    // Label 457: @14775
    GIM_Try, /*On fail goto*//*Label 458*/ 14809, // Rule ID 3375 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3375,
      GIR_Done,
    // Label 458: @14809
    GIM_Try, /*On fail goto*//*Label 459*/ 14848, // Rule ID 3376 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v2i64] }:$src)  =>  (EXTv16i8:{ *:[f128] } FPR128:{ *:[v2i64] }:$src, FPR128:{ *:[v2i64] }:$src, 8:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3376,
      GIR_Done,
    // Label 459: @14848
    GIM_Try, /*On fail goto*//*Label 460*/ 14919, // Rule ID 3377 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v4i32] }:$src)  =>  (EXTv16i8:{ *:[f128] } (REV64v4i32:{ *:[f128] } FPR128:{ *:[v4i32] }:$src), (REV64v4i32:{ *:[f128] } FPR128:{ *:[v4i32] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3377,
      GIR_Done,
    // Label 460: @14919
    GIM_Try, /*On fail goto*//*Label 461*/ 14990, // Rule ID 3378 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v8i16] }:$src)  =>  (EXTv16i8:{ *:[f128] } (REV64v8i16:{ *:[f128] } FPR128:{ *:[v8i16] }:$src), (REV64v8i16:{ *:[f128] } FPR128:{ *:[v8i16] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3378,
      GIR_Done,
    // Label 461: @14990
    GIM_Try, /*On fail goto*//*Label 462*/ 15061, // Rule ID 3379 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v8f16] }:$src)  =>  (EXTv16i8:{ *:[f128] } (REV64v8i16:{ *:[f128] } FPR128:{ *:[v8f16] }:$src), (REV64v8i16:{ *:[f128] } FPR128:{ *:[v8f16] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3379,
      GIR_Done,
    // Label 462: @15061
    GIM_Try, /*On fail goto*//*Label 463*/ 15100, // Rule ID 3380 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v2f64] }:$src)  =>  (EXTv16i8:{ *:[f128] } FPR128:{ *:[v2f64] }:$src, FPR128:{ *:[v2f64] }:$src, 8:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3380,
      GIR_Done,
    // Label 463: @15100
    GIM_Try, /*On fail goto*//*Label 464*/ 15171, // Rule ID 3381 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v4f32] }:$src)  =>  (EXTv16i8:{ *:[f128] } (REV64v4i32:{ *:[f128] } FPR128:{ *:[v4f32] }:$src), (REV64v4i32:{ *:[f128] } FPR128:{ *:[v4f32] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3381,
      GIR_Done,
    // Label 464: @15171
    GIM_Try, /*On fail goto*//*Label 465*/ 15242, // Rule ID 3382 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[f128] } FPR128:{ *:[v16i8] }:$src)  =>  (EXTv16i8:{ *:[f128] } (REV64v16i8:{ *:[f128] } FPR128:{ *:[v16i8] }:$src), (REV64v16i8:{ *:[f128] } FPR128:{ *:[v16i8] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v16i8,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v16i8,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3382,
      GIR_Done,
    // Label 465: @15242
    GIM_Reject,
    // Label 388: @15243
    GIM_Try, /*On fail goto*//*Label 466*/ 15268, // Rule ID 3237 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v2i32] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3237,
      GIR_Done,
    // Label 466: @15268
    GIM_Try, /*On fail goto*//*Label 467*/ 15293, // Rule ID 3239 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v2f32] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3239,
      GIR_Done,
    // Label 467: @15293
    GIM_Try, /*On fail goto*//*Label 468*/ 15341, // Rule ID 3248 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } GPR64:{ *:[i64] }:$Xn)  =>  (REV64v2i32:{ *:[v2i32] } (COPY_TO_REGCLASS:{ *:[i64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Xn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3248,
      GIR_Done,
    // Label 468: @15341
    GIM_Try, /*On fail goto*//*Label 469*/ 15389, // Rule ID 3250 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } GPR64:{ *:[i64] }:$Xn)  =>  (REV64v2i32:{ *:[v2f32] } (COPY_TO_REGCLASS:{ *:[i64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Xn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3250,
      GIR_Done,
    // Label 469: @15389
    GIM_Try, /*On fail goto*//*Label 470*/ 15423, // Rule ID 3279 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3279,
      GIR_Done,
    // Label 470: @15423
    GIM_Try, /*On fail goto*//*Label 471*/ 15457, // Rule ID 3280 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3280,
      GIR_Done,
    // Label 471: @15457
    GIM_Try, /*On fail goto*//*Label 472*/ 15491, // Rule ID 3281 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3281,
      GIR_Done,
    // Label 472: @15491
    GIM_Try, /*On fail goto*//*Label 473*/ 15525, // Rule ID 3282 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3282,
      GIR_Done,
    // Label 473: @15525
    GIM_Try, /*On fail goto*//*Label 474*/ 15559, // Rule ID 3283 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3283,
      GIR_Done,
    // Label 474: @15559
    GIM_Try, /*On fail goto*//*Label 475*/ 15593, // Rule ID 3284 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3284,
      GIR_Done,
    // Label 475: @15593
    GIM_Try, /*On fail goto*//*Label 476*/ 15616, // Rule ID 3285 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v1i64] }:$src)  =>  (REV64v2i32:{ *:[v2i32] } FPR64:{ *:[v1i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3285,
      GIR_Done,
    // Label 476: @15616
    GIM_Try, /*On fail goto*//*Label 477*/ 15639, // Rule ID 3286 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v4i16] }:$src)  =>  (REV32v4i16:{ *:[v2i32] } FPR64:{ *:[v4i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3286,
      GIR_Done,
    // Label 477: @15639
    GIM_Try, /*On fail goto*//*Label 478*/ 15662, // Rule ID 3287 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v8i8] }:$src)  =>  (REV32v8i8:{ *:[v2i32] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3287,
      GIR_Done,
    // Label 478: @15662
    GIM_Try, /*On fail goto*//*Label 479*/ 15685, // Rule ID 3288 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[f64] }:$src)  =>  (REV64v2i32:{ *:[v2i32] } FPR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3288,
      GIR_Done,
    // Label 479: @15685
    GIM_Try, /*On fail goto*//*Label 480*/ 15708, // Rule ID 3289 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v1f64] }:$src)  =>  (REV64v2i32:{ *:[v2i32] } FPR64:{ *:[v1f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3289,
      GIR_Done,
    // Label 480: @15708
    GIM_Try, /*On fail goto*//*Label 481*/ 15731, // Rule ID 3290 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v4f16] }:$src)  =>  (REV32v4i16:{ *:[v2i32] } FPR64:{ *:[v4f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3290,
      GIR_Done,
    // Label 481: @15731
    GIM_Try, /*On fail goto*//*Label 482*/ 15763, // Rule ID 3291 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2i32] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3291,
      GIR_Done,
    // Label 482: @15763
    GIM_Try, /*On fail goto*//*Label 483*/ 15797, // Rule ID 3356 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3356,
      GIR_Done,
    // Label 483: @15797
    GIM_Try, /*On fail goto*//*Label 484*/ 15831, // Rule ID 3357 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3357,
      GIR_Done,
    // Label 484: @15831
    GIM_Try, /*On fail goto*//*Label 485*/ 15865, // Rule ID 3358 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3358,
      GIR_Done,
    // Label 485: @15865
    GIM_Try, /*On fail goto*//*Label 486*/ 15899, // Rule ID 3359 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3359,
      GIR_Done,
    // Label 486: @15899
    GIM_Try, /*On fail goto*//*Label 487*/ 15933, // Rule ID 3360 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3360,
      GIR_Done,
    // Label 487: @15933
    GIM_Try, /*On fail goto*//*Label 488*/ 15967, // Rule ID 3361 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3361,
      GIR_Done,
    // Label 488: @15967
    GIM_Try, /*On fail goto*//*Label 489*/ 15990, // Rule ID 3362 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v1i64] }:$src)  =>  (REV64v2i32:{ *:[v2f32] } FPR64:{ *:[v1i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3362,
      GIR_Done,
    // Label 489: @15990
    GIM_Try, /*On fail goto*//*Label 490*/ 16013, // Rule ID 3363 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v4i16] }:$src)  =>  (REV32v4i16:{ *:[v2f32] } FPR64:{ *:[v4i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3363,
      GIR_Done,
    // Label 490: @16013
    GIM_Try, /*On fail goto*//*Label 491*/ 16036, // Rule ID 3364 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v8i8] }:$src)  =>  (REV32v8i8:{ *:[v2f32] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3364,
      GIR_Done,
    // Label 491: @16036
    GIM_Try, /*On fail goto*//*Label 492*/ 16059, // Rule ID 3365 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v1f64] }:$src)  =>  (REV64v2i32:{ *:[v2f32] } FPR64:{ *:[v1f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3365,
      GIR_Done,
    // Label 492: @16059
    GIM_Try, /*On fail goto*//*Label 493*/ 16082, // Rule ID 3366 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[f64] }:$src)  =>  (REV64v2i32:{ *:[v2f32] } FPR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v2i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3366,
      GIR_Done,
    // Label 493: @16082
    GIM_Try, /*On fail goto*//*Label 494*/ 16105, // Rule ID 3367 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v4f16] }:$src)  =>  (REV32v4i16:{ *:[v2f32] } FPR64:{ *:[v4f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3367,
      GIR_Done,
    // Label 494: @16105
    GIM_Try, /*On fail goto*//*Label 495*/ 16137, // Rule ID 3368 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v2f32] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3368,
      GIR_Done,
    // Label 495: @16137
    GIM_Reject,
    // Label 389: @16138
    GIM_Try, /*On fail goto*//*Label 496*/ 16172, // Rule ID 3383 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3383,
      GIR_Done,
    // Label 496: @16172
    GIM_Try, /*On fail goto*//*Label 497*/ 16206, // Rule ID 3384 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3384,
      GIR_Done,
    // Label 497: @16206
    GIM_Try, /*On fail goto*//*Label 498*/ 16240, // Rule ID 3385 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3385,
      GIR_Done,
    // Label 498: @16240
    GIM_Try, /*On fail goto*//*Label 499*/ 16274, // Rule ID 3386 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3386,
      GIR_Done,
    // Label 499: @16274
    GIM_Try, /*On fail goto*//*Label 500*/ 16308, // Rule ID 3387 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3387,
      GIR_Done,
    // Label 500: @16308
    GIM_Try, /*On fail goto*//*Label 501*/ 16342, // Rule ID 3388 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3388,
      GIR_Done,
    // Label 501: @16342
    GIM_Try, /*On fail goto*//*Label 502*/ 16381, // Rule ID 3389 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v2f64] } FPR128:{ *:[f128] }:$src, FPR128:{ *:[f128] }:$src, 8:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3389,
      GIR_Done,
    // Label 502: @16381
    GIM_Try, /*On fail goto*//*Label 503*/ 16404, // Rule ID 3390 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v4i32] }:$src)  =>  (REV64v4i32:{ *:[v2f64] } FPR128:{ *:[v4i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3390,
      GIR_Done,
    // Label 503: @16404
    GIM_Try, /*On fail goto*//*Label 504*/ 16427, // Rule ID 3391 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v8i16] }:$src)  =>  (REV64v8i16:{ *:[v2f64] } FPR128:{ *:[v8i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3391,
      GIR_Done,
    // Label 504: @16427
    GIM_Try, /*On fail goto*//*Label 505*/ 16450, // Rule ID 3392 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v8f16] }:$src)  =>  (REV64v8i16:{ *:[v2f64] } FPR128:{ *:[v8f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3392,
      GIR_Done,
    // Label 505: @16450
    GIM_Try, /*On fail goto*//*Label 506*/ 16473, // Rule ID 3393 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v16i8] }:$src)  =>  (REV64v16i8:{ *:[v2f64] } FPR128:{ *:[v16i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3393,
      GIR_Done,
    // Label 506: @16473
    GIM_Try, /*On fail goto*//*Label 507*/ 16496, // Rule ID 3394 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v4f32] }:$src)  =>  (REV64v4i32:{ *:[v2f64] } FPR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3394,
      GIR_Done,
    // Label 507: @16496
    GIM_Try, /*On fail goto*//*Label 508*/ 16528, // Rule ID 3395 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2f64] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3395,
      GIR_Done,
    // Label 508: @16528
    GIM_Try, /*On fail goto*//*Label 509*/ 16562, // Rule ID 3409 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3409,
      GIR_Done,
    // Label 509: @16562
    GIM_Try, /*On fail goto*//*Label 510*/ 16596, // Rule ID 3410 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3410,
      GIR_Done,
    // Label 510: @16596
    GIM_Try, /*On fail goto*//*Label 511*/ 16630, // Rule ID 3411 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3411,
      GIR_Done,
    // Label 511: @16630
    GIM_Try, /*On fail goto*//*Label 512*/ 16664, // Rule ID 3412 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3412,
      GIR_Done,
    // Label 512: @16664
    GIM_Try, /*On fail goto*//*Label 513*/ 16698, // Rule ID 3413 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3413,
      GIR_Done,
    // Label 513: @16698
    GIM_Try, /*On fail goto*//*Label 514*/ 16732, // Rule ID 3414 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3414,
      GIR_Done,
    // Label 514: @16732
    GIM_Try, /*On fail goto*//*Label 515*/ 16771, // Rule ID 3415 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v2i64] } FPR128:{ *:[f128] }:$src, FPR128:{ *:[f128] }:$src, 8:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3415,
      GIR_Done,
    // Label 515: @16771
    GIM_Try, /*On fail goto*//*Label 516*/ 16794, // Rule ID 3416 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v4i32] }:$src)  =>  (REV64v4i32:{ *:[v2i64] } FPR128:{ *:[v4i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3416,
      GIR_Done,
    // Label 516: @16794
    GIM_Try, /*On fail goto*//*Label 517*/ 16817, // Rule ID 3417 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v8i16] }:$src)  =>  (REV64v8i16:{ *:[v2i64] } FPR128:{ *:[v8i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3417,
      GIR_Done,
    // Label 517: @16817
    GIM_Try, /*On fail goto*//*Label 518*/ 16840, // Rule ID 3418 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v16i8] }:$src)  =>  (REV64v16i8:{ *:[v2i64] } FPR128:{ *:[v16i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3418,
      GIR_Done,
    // Label 518: @16840
    GIM_Try, /*On fail goto*//*Label 519*/ 16863, // Rule ID 3419 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v4f32] }:$src)  =>  (REV64v4i32:{ *:[v2i64] } FPR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3419,
      GIR_Done,
    // Label 519: @16863
    GIM_Try, /*On fail goto*//*Label 520*/ 16886, // Rule ID 3420 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v8f16] }:$src)  =>  (REV64v8i16:{ *:[v2i64] } FPR128:{ *:[v8f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3420,
      GIR_Done,
    // Label 520: @16886
    GIM_Try, /*On fail goto*//*Label 521*/ 16918, // Rule ID 3421 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v2i64] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3421,
      GIR_Done,
    // Label 521: @16918
    GIM_Reject,
    // Label 390: @16919
    GIM_Try, /*On fail goto*//*Label 522*/ 16944, // Rule ID 3236 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v4i16] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3236,
      GIR_Done,
    // Label 522: @16944
    GIM_Try, /*On fail goto*//*Label 523*/ 16969, // Rule ID 3238 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v4f16] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3238,
      GIR_Done,
    // Label 523: @16969
    GIM_Try, /*On fail goto*//*Label 524*/ 17017, // Rule ID 3247 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } GPR64:{ *:[i64] }:$Xn)  =>  (REV64v4i16:{ *:[v4i16] } (COPY_TO_REGCLASS:{ *:[i64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Xn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3247,
      GIR_Done,
    // Label 524: @17017
    GIM_Try, /*On fail goto*//*Label 525*/ 17065, // Rule ID 3249 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } GPR64:{ *:[i64] }:$Xn)  =>  (REV64v4i16:{ *:[v4f16] } (COPY_TO_REGCLASS:{ *:[i64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Xn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3249,
      GIR_Done,
    // Label 525: @17065
    GIM_Try, /*On fail goto*//*Label 526*/ 17099, // Rule ID 3292 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3292,
      GIR_Done,
    // Label 526: @17099
    GIM_Try, /*On fail goto*//*Label 527*/ 17133, // Rule ID 3293 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3293,
      GIR_Done,
    // Label 527: @17133
    GIM_Try, /*On fail goto*//*Label 528*/ 17167, // Rule ID 3294 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3294,
      GIR_Done,
    // Label 528: @17167
    GIM_Try, /*On fail goto*//*Label 529*/ 17201, // Rule ID 3295 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3295,
      GIR_Done,
    // Label 529: @17201
    GIM_Try, /*On fail goto*//*Label 530*/ 17235, // Rule ID 3296 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3296,
      GIR_Done,
    // Label 530: @17235
    GIM_Try, /*On fail goto*//*Label 531*/ 17269, // Rule ID 3297 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3297,
      GIR_Done,
    // Label 531: @17269
    GIM_Try, /*On fail goto*//*Label 532*/ 17292, // Rule ID 3298 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v1i64] }:$src)  =>  (REV64v4i16:{ *:[v4i16] } FPR64:{ *:[v1i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3298,
      GIR_Done,
    // Label 532: @17292
    GIM_Try, /*On fail goto*//*Label 533*/ 17315, // Rule ID 3299 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v2i32] }:$src)  =>  (REV32v4i16:{ *:[v4i16] } FPR64:{ *:[v2i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3299,
      GIR_Done,
    // Label 533: @17315
    GIM_Try, /*On fail goto*//*Label 534*/ 17338, // Rule ID 3300 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v8i8] }:$src)  =>  (REV16v8i8:{ *:[v4i16] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3300,
      GIR_Done,
    // Label 534: @17338
    GIM_Try, /*On fail goto*//*Label 535*/ 17361, // Rule ID 3301 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[f64] }:$src)  =>  (REV64v4i16:{ *:[v4i16] } FPR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3301,
      GIR_Done,
    // Label 535: @17361
    GIM_Try, /*On fail goto*//*Label 536*/ 17384, // Rule ID 3302 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v2f32] }:$src)  =>  (REV32v4i16:{ *:[v4i16] } FPR64:{ *:[v2f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3302,
      GIR_Done,
    // Label 536: @17384
    GIM_Try, /*On fail goto*//*Label 537*/ 17407, // Rule ID 3303 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v1f64] }:$src)  =>  (REV64v4i16:{ *:[v4i16] } FPR64:{ *:[v1f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3303,
      GIR_Done,
    // Label 537: @17407
    GIM_Try, /*On fail goto*//*Label 538*/ 17439, // Rule ID 3304 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4i16] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3304,
      GIR_Done,
    // Label 538: @17439
    GIM_Try, /*On fail goto*//*Label 539*/ 17473, // Rule ID 3305 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3305,
      GIR_Done,
    // Label 539: @17473
    GIM_Try, /*On fail goto*//*Label 540*/ 17507, // Rule ID 3306 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3306,
      GIR_Done,
    // Label 540: @17507
    GIM_Try, /*On fail goto*//*Label 541*/ 17541, // Rule ID 3307 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v8i8] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3307,
      GIR_Done,
    // Label 541: @17541
    GIM_Try, /*On fail goto*//*Label 542*/ 17575, // Rule ID 3308 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3308,
      GIR_Done,
    // Label 542: @17575
    GIM_Try, /*On fail goto*//*Label 543*/ 17609, // Rule ID 3309 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3309,
      GIR_Done,
    // Label 543: @17609
    GIM_Try, /*On fail goto*//*Label 544*/ 17643, // Rule ID 3310 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3310,
      GIR_Done,
    // Label 544: @17643
    GIM_Try, /*On fail goto*//*Label 545*/ 17666, // Rule ID 3311 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v1i64] }:$src)  =>  (REV64v4i16:{ *:[v4f16] } FPR64:{ *:[v1i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3311,
      GIR_Done,
    // Label 545: @17666
    GIM_Try, /*On fail goto*//*Label 546*/ 17689, // Rule ID 3312 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v2i32] }:$src)  =>  (REV32v4i16:{ *:[v4f16] } FPR64:{ *:[v2i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3312,
      GIR_Done,
    // Label 546: @17689
    GIM_Try, /*On fail goto*//*Label 547*/ 17712, // Rule ID 3313 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v8i8] }:$src)  =>  (REV16v8i8:{ *:[v4f16] } FPR64:{ *:[v8i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3313,
      GIR_Done,
    // Label 547: @17712
    GIM_Try, /*On fail goto*//*Label 548*/ 17735, // Rule ID 3314 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[f64] }:$src)  =>  (REV64v4i16:{ *:[v4f16] } FPR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3314,
      GIR_Done,
    // Label 548: @17735
    GIM_Try, /*On fail goto*//*Label 549*/ 17758, // Rule ID 3315 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v2f32] }:$src)  =>  (REV32v4i16:{ *:[v4f16] } FPR64:{ *:[v2f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3315,
      GIR_Done,
    // Label 549: @17758
    GIM_Try, /*On fail goto*//*Label 550*/ 17781, // Rule ID 3316 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v1f64] }:$src)  =>  (REV64v4i16:{ *:[v4f16] } FPR64:{ *:[v1f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3316,
      GIR_Done,
    // Label 550: @17781
    GIM_Try, /*On fail goto*//*Label 551*/ 17813, // Rule ID 3317 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v4f16] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3317,
      GIR_Done,
    // Label 551: @17813
    GIM_Reject,
    // Label 391: @17814
    GIM_Try, /*On fail goto*//*Label 552*/ 17848, // Rule ID 3396 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3396,
      GIR_Done,
    // Label 552: @17848
    GIM_Try, /*On fail goto*//*Label 553*/ 17882, // Rule ID 3397 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3397,
      GIR_Done,
    // Label 553: @17882
    GIM_Try, /*On fail goto*//*Label 554*/ 17916, // Rule ID 3398 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3398,
      GIR_Done,
    // Label 554: @17916
    GIM_Try, /*On fail goto*//*Label 555*/ 17950, // Rule ID 3399 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3399,
      GIR_Done,
    // Label 555: @17950
    GIM_Try, /*On fail goto*//*Label 556*/ 17984, // Rule ID 3400 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3400,
      GIR_Done,
    // Label 556: @17984
    GIM_Try, /*On fail goto*//*Label 557*/ 18018, // Rule ID 3401 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3401,
      GIR_Done,
    // Label 557: @18018
    GIM_Try, /*On fail goto*//*Label 558*/ 18089, // Rule ID 3402 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v4f32] } (REV64v4i32:{ *:[f128] } FPR128:{ *:[f128] }:$src), (REV64v4i32:{ *:[f128] } FPR128:{ *:[f128] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3402,
      GIR_Done,
    // Label 558: @18089
    GIM_Try, /*On fail goto*//*Label 559*/ 18112, // Rule ID 3403 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v8i16] }:$src)  =>  (REV32v8i16:{ *:[v4f32] } FPR128:{ *:[v8i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3403,
      GIR_Done,
    // Label 559: @18112
    GIM_Try, /*On fail goto*//*Label 560*/ 18135, // Rule ID 3404 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v8f16] }:$src)  =>  (REV32v8i16:{ *:[v4f32] } FPR128:{ *:[v8f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3404,
      GIR_Done,
    // Label 560: @18135
    GIM_Try, /*On fail goto*//*Label 561*/ 18158, // Rule ID 3405 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v16i8] }:$src)  =>  (REV32v16i8:{ *:[v4f32] } FPR128:{ *:[v16i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3405,
      GIR_Done,
    // Label 561: @18158
    GIM_Try, /*On fail goto*//*Label 562*/ 18181, // Rule ID 3406 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v2i64] }:$src)  =>  (REV64v4i32:{ *:[v4f32] } FPR128:{ *:[v2i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3406,
      GIR_Done,
    // Label 562: @18181
    GIM_Try, /*On fail goto*//*Label 563*/ 18204, // Rule ID 3407 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v2f64] }:$src)  =>  (REV64v4i32:{ *:[v4f32] } FPR128:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3407,
      GIR_Done,
    // Label 563: @18204
    GIM_Try, /*On fail goto*//*Label 564*/ 18236, // Rule ID 3408 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4f32] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3408,
      GIR_Done,
    // Label 564: @18236
    GIM_Try, /*On fail goto*//*Label 565*/ 18270, // Rule ID 3422 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3422,
      GIR_Done,
    // Label 565: @18270
    GIM_Try, /*On fail goto*//*Label 566*/ 18304, // Rule ID 3423 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3423,
      GIR_Done,
    // Label 566: @18304
    GIM_Try, /*On fail goto*//*Label 567*/ 18338, // Rule ID 3424 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3424,
      GIR_Done,
    // Label 567: @18338
    GIM_Try, /*On fail goto*//*Label 568*/ 18372, // Rule ID 3425 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3425,
      GIR_Done,
    // Label 568: @18372
    GIM_Try, /*On fail goto*//*Label 569*/ 18406, // Rule ID 3426 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3426,
      GIR_Done,
    // Label 569: @18406
    GIM_Try, /*On fail goto*//*Label 570*/ 18440, // Rule ID 3427 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3427,
      GIR_Done,
    // Label 570: @18440
    GIM_Try, /*On fail goto*//*Label 571*/ 18511, // Rule ID 3428 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v4i32] } (REV64v4i32:{ *:[f128] } FPR128:{ *:[f128] }:$src), (REV64v4i32:{ *:[f128] } FPR128:{ *:[f128] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v4i32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3428,
      GIR_Done,
    // Label 571: @18511
    GIM_Try, /*On fail goto*//*Label 572*/ 18534, // Rule ID 3429 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v2i64] }:$src)  =>  (REV64v4i32:{ *:[v4i32] } FPR128:{ *:[v2i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3429,
      GIR_Done,
    // Label 572: @18534
    GIM_Try, /*On fail goto*//*Label 573*/ 18557, // Rule ID 3430 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v8i16] }:$src)  =>  (REV32v8i16:{ *:[v4i32] } FPR128:{ *:[v8i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3430,
      GIR_Done,
    // Label 573: @18557
    GIM_Try, /*On fail goto*//*Label 574*/ 18580, // Rule ID 3431 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v16i8] }:$src)  =>  (REV32v16i8:{ *:[v4i32] } FPR128:{ *:[v16i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3431,
      GIR_Done,
    // Label 574: @18580
    GIM_Try, /*On fail goto*//*Label 575*/ 18603, // Rule ID 3432 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v2f64] }:$src)  =>  (REV64v4i32:{ *:[v4i32] } FPR128:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v4i32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3432,
      GIR_Done,
    // Label 575: @18603
    GIM_Try, /*On fail goto*//*Label 576*/ 18626, // Rule ID 3433 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v8f16] }:$src)  =>  (REV32v8i16:{ *:[v4i32] } FPR128:{ *:[v8f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3433,
      GIR_Done,
    // Label 576: @18626
    GIM_Try, /*On fail goto*//*Label 577*/ 18658, // Rule ID 3434 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v4i32] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3434,
      GIR_Done,
    // Label 577: @18658
    GIM_Reject,
    // Label 392: @18659
    GIM_Try, /*On fail goto*//*Label 578*/ 18684, // Rule ID 3235 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } GPR64:{ *:[i64] }:$Xn)  =>  (COPY_TO_REGCLASS:{ *:[v8i8] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3235,
      GIR_Done,
    // Label 578: @18684
    GIM_Try, /*On fail goto*//*Label 579*/ 18732, // Rule ID 3246 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } GPR64:{ *:[i64] }:$Xn)  =>  (REV64v8i8:{ *:[v8i8] } (COPY_TO_REGCLASS:{ *:[i64] } GPR64:{ *:[i64] }:$Xn, FPR64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Xn
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3246,
      GIR_Done,
    // Label 579: @18732
    GIM_Try, /*On fail goto*//*Label 580*/ 18766, // Rule ID 3318 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v1i64] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3318,
      GIR_Done,
    // Label 580: @18766
    GIM_Try, /*On fail goto*//*Label 581*/ 18800, // Rule ID 3319 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v2i32] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3319,
      GIR_Done,
    // Label 581: @18800
    GIM_Try, /*On fail goto*//*Label 582*/ 18834, // Rule ID 3320 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v4i16] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3320,
      GIR_Done,
    // Label 582: @18834
    GIM_Try, /*On fail goto*//*Label 583*/ 18868, // Rule ID 3321 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[f64] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3321,
      GIR_Done,
    // Label 583: @18868
    GIM_Try, /*On fail goto*//*Label 584*/ 18902, // Rule ID 3322 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v2f32] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3322,
      GIR_Done,
    // Label 584: @18902
    GIM_Try, /*On fail goto*//*Label 585*/ 18936, // Rule ID 3323 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v1f64] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3323,
      GIR_Done,
    // Label 585: @18936
    GIM_Try, /*On fail goto*//*Label 586*/ 18970, // Rule ID 3324 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v4f16] }:$src)  =>  FPR64:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR64*/16,
      // GIR_Coverage, 3324,
      GIR_Done,
    // Label 586: @18970
    GIM_Try, /*On fail goto*//*Label 587*/ 18993, // Rule ID 3325 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v1i64] }:$src)  =>  (REV64v8i8:{ *:[v8i8] } FPR64:{ *:[v1i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3325,
      GIR_Done,
    // Label 587: @18993
    GIM_Try, /*On fail goto*//*Label 588*/ 19016, // Rule ID 3326 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v2i32] }:$src)  =>  (REV32v8i8:{ *:[v8i8] } FPR64:{ *:[v2i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3326,
      GIR_Done,
    // Label 588: @19016
    GIM_Try, /*On fail goto*//*Label 589*/ 19039, // Rule ID 3327 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v4i16] }:$src)  =>  (REV16v8i8:{ *:[v8i8] } FPR64:{ *:[v4i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3327,
      GIR_Done,
    // Label 589: @19039
    GIM_Try, /*On fail goto*//*Label 590*/ 19062, // Rule ID 3328 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[f64] }:$src)  =>  (REV64v8i8:{ *:[v8i8] } FPR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3328,
      GIR_Done,
    // Label 590: @19062
    GIM_Try, /*On fail goto*//*Label 591*/ 19085, // Rule ID 3329 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v2f32] }:$src)  =>  (REV32v8i8:{ *:[v8i8] } FPR64:{ *:[v2f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3329,
      GIR_Done,
    // Label 591: @19085
    GIM_Try, /*On fail goto*//*Label 592*/ 19108, // Rule ID 3330 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v1f64] }:$src)  =>  (REV64v8i8:{ *:[v8i8] } FPR64:{ *:[v1f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3330,
      GIR_Done,
    // Label 592: @19108
    GIM_Try, /*On fail goto*//*Label 593*/ 19131, // Rule ID 3331 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      // (bitconvert:{ *:[v8i8] } FPR64:{ *:[v4f16] }:$src)  =>  (REV16v8i8:{ *:[v8i8] } FPR64:{ *:[v4f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3331,
      GIR_Done,
    // Label 593: @19131
    GIM_Reject,
    // Label 393: @19132
    GIM_Try, /*On fail goto*//*Label 594*/ 19166, // Rule ID 3435 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3435,
      GIR_Done,
    // Label 594: @19166
    GIM_Try, /*On fail goto*//*Label 595*/ 19200, // Rule ID 3436 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3436,
      GIR_Done,
    // Label 595: @19200
    GIM_Try, /*On fail goto*//*Label 596*/ 19234, // Rule ID 3437 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3437,
      GIR_Done,
    // Label 596: @19234
    GIM_Try, /*On fail goto*//*Label 597*/ 19268, // Rule ID 3438 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3438,
      GIR_Done,
    // Label 597: @19268
    GIM_Try, /*On fail goto*//*Label 598*/ 19302, // Rule ID 3439 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3439,
      GIR_Done,
    // Label 598: @19302
    GIM_Try, /*On fail goto*//*Label 599*/ 19336, // Rule ID 3440 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3440,
      GIR_Done,
    // Label 599: @19336
    GIM_Try, /*On fail goto*//*Label 600*/ 19407, // Rule ID 3441 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v8i16] } (REV64v8i16:{ *:[f128] } FPR128:{ *:[f128] }:$src), (REV64v8i16:{ *:[f128] } FPR128:{ *:[f128] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3441,
      GIR_Done,
    // Label 600: @19407
    GIM_Try, /*On fail goto*//*Label 601*/ 19430, // Rule ID 3442 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v2i64] }:$src)  =>  (REV64v8i16:{ *:[v8i16] } FPR128:{ *:[v2i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3442,
      GIR_Done,
    // Label 601: @19430
    GIM_Try, /*On fail goto*//*Label 602*/ 19453, // Rule ID 3443 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v4i32] }:$src)  =>  (REV32v8i16:{ *:[v8i16] } FPR128:{ *:[v4i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3443,
      GIR_Done,
    // Label 602: @19453
    GIM_Try, /*On fail goto*//*Label 603*/ 19476, // Rule ID 3444 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v16i8] }:$src)  =>  (REV16v16i8:{ *:[v8i16] } FPR128:{ *:[v16i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3444,
      GIR_Done,
    // Label 603: @19476
    GIM_Try, /*On fail goto*//*Label 604*/ 19499, // Rule ID 3445 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v2f64] }:$src)  =>  (REV64v8i16:{ *:[v8i16] } FPR128:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3445,
      GIR_Done,
    // Label 604: @19499
    GIM_Try, /*On fail goto*//*Label 605*/ 19522, // Rule ID 3446 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v4f32] }:$src)  =>  (REV32v8i16:{ *:[v8i16] } FPR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3446,
      GIR_Done,
    // Label 605: @19522
    GIM_Try, /*On fail goto*//*Label 606*/ 19554, // Rule ID 3447 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8i16] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3447,
      GIR_Done,
    // Label 606: @19554
    GIM_Try, /*On fail goto*//*Label 607*/ 19588, // Rule ID 3448 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3448,
      GIR_Done,
    // Label 607: @19588
    GIM_Try, /*On fail goto*//*Label 608*/ 19622, // Rule ID 3449 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3449,
      GIR_Done,
    // Label 608: @19622
    GIM_Try, /*On fail goto*//*Label 609*/ 19656, // Rule ID 3450 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3450,
      GIR_Done,
    // Label 609: @19656
    GIM_Try, /*On fail goto*//*Label 610*/ 19690, // Rule ID 3451 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v16i8] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3451,
      GIR_Done,
    // Label 610: @19690
    GIM_Try, /*On fail goto*//*Label 611*/ 19724, // Rule ID 3452 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3452,
      GIR_Done,
    // Label 611: @19724
    GIM_Try, /*On fail goto*//*Label 612*/ 19758, // Rule ID 3453 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3453,
      GIR_Done,
    // Label 612: @19758
    GIM_Try, /*On fail goto*//*Label 613*/ 19829, // Rule ID 3454 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v8f16] } (REV64v8i16:{ *:[f128] } FPR128:{ *:[f128] }:$src), (REV64v8i16:{ *:[f128] } FPR128:{ *:[f128] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v8i16,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3454,
      GIR_Done,
    // Label 613: @19829
    GIM_Try, /*On fail goto*//*Label 614*/ 19852, // Rule ID 3455 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v2i64] }:$src)  =>  (REV64v8i16:{ *:[v8f16] } FPR128:{ *:[v2i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3455,
      GIR_Done,
    // Label 614: @19852
    GIM_Try, /*On fail goto*//*Label 615*/ 19875, // Rule ID 3456 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v4i32] }:$src)  =>  (REV32v8i16:{ *:[v8f16] } FPR128:{ *:[v4i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3456,
      GIR_Done,
    // Label 615: @19875
    GIM_Try, /*On fail goto*//*Label 616*/ 19898, // Rule ID 3457 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v16i8] }:$src)  =>  (REV16v16i8:{ *:[v8f16] } FPR128:{ *:[v16i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3457,
      GIR_Done,
    // Label 616: @19898
    GIM_Try, /*On fail goto*//*Label 617*/ 19921, // Rule ID 3458 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v2f64] }:$src)  =>  (REV64v8i16:{ *:[v8f16] } FPR128:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3458,
      GIR_Done,
    // Label 617: @19921
    GIM_Try, /*On fail goto*//*Label 618*/ 19944, // Rule ID 3459 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v4f32] }:$src)  =>  (REV32v8i16:{ *:[v8f16] } FPR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v8i16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3459,
      GIR_Done,
    // Label 618: @19944
    GIM_Try, /*On fail goto*//*Label 619*/ 19976, // Rule ID 3460 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v8f16] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3460,
      GIR_Done,
    // Label 619: @19976
    GIM_Reject,
    // Label 394: @19977
    GIM_Try, /*On fail goto*//*Label 620*/ 20011, // Rule ID 3461 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[f128] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3461,
      GIR_Done,
    // Label 620: @20011
    GIM_Try, /*On fail goto*//*Label 621*/ 20045, // Rule ID 3462 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v2i64] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3462,
      GIR_Done,
    // Label 621: @20045
    GIM_Try, /*On fail goto*//*Label 622*/ 20079, // Rule ID 3463 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v4i32] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3463,
      GIR_Done,
    // Label 622: @20079
    GIM_Try, /*On fail goto*//*Label 623*/ 20113, // Rule ID 3464 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v8i16] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3464,
      GIR_Done,
    // Label 623: @20113
    GIM_Try, /*On fail goto*//*Label 624*/ 20147, // Rule ID 3465 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v2f64] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3465,
      GIR_Done,
    // Label 624: @20147
    GIM_Try, /*On fail goto*//*Label 625*/ 20181, // Rule ID 3466 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v4f32] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3466,
      GIR_Done,
    // Label 625: @20181
    GIM_Try, /*On fail goto*//*Label 626*/ 20215, // Rule ID 3467 //
      GIM_CheckFeatures, GIFBS_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v8f16] }:$src)  =>  FPR128:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FPR128*/34,
      // GIR_Coverage, 3467,
      GIR_Done,
    // Label 626: @20215
    GIM_Try, /*On fail goto*//*Label 627*/ 20286, // Rule ID 3468 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[f128] }:$src)  =>  (EXTv16i8:{ *:[v16i8] } (REV64v16i8:{ *:[f128] } FPR128:{ *:[f128] }:$src), (REV64v16i8:{ *:[f128] } FPR128:{ *:[f128] }:$src), 8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AArch64::REV64v16i8,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::REV64v16i8,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EXTv16i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/8,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3468,
      GIR_Done,
    // Label 627: @20286
    GIM_Try, /*On fail goto*//*Label 628*/ 20309, // Rule ID 3469 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v2i64] }:$src)  =>  (REV64v16i8:{ *:[v16i8] } FPR128:{ *:[v2i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3469,
      GIR_Done,
    // Label 628: @20309
    GIM_Try, /*On fail goto*//*Label 629*/ 20332, // Rule ID 3470 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v4i32] }:$src)  =>  (REV32v16i8:{ *:[v16i8] } FPR128:{ *:[v4i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3470,
      GIR_Done,
    // Label 629: @20332
    GIM_Try, /*On fail goto*//*Label 630*/ 20355, // Rule ID 3471 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v8i16] }:$src)  =>  (REV16v16i8:{ *:[v16i8] } FPR128:{ *:[v8i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3471,
      GIR_Done,
    // Label 630: @20355
    GIM_Try, /*On fail goto*//*Label 631*/ 20378, // Rule ID 3472 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v2f64] }:$src)  =>  (REV64v16i8:{ *:[v16i8] } FPR128:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV64v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3472,
      GIR_Done,
    // Label 631: @20378
    GIM_Try, /*On fail goto*//*Label 632*/ 20401, // Rule ID 3473 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v4f32] }:$src)  =>  (REV32v16i8:{ *:[v16i8] } FPR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV32v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3473,
      GIR_Done,
    // Label 632: @20401
    GIM_Try, /*On fail goto*//*Label 633*/ 20424, // Rule ID 3474 //
      GIM_CheckFeatures, GIFBS_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      // (bitconvert:{ *:[v16i8] } FPR128:{ *:[v8f16] }:$src)  =>  (REV16v16i8:{ *:[v16i8] } FPR128:{ *:[v8f16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::REV16v16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3474,
      GIR_Done,
    // Label 633: @20424
    GIM_Reject,
    // Label 395: @20425
    GIM_Reject,
    // Label 9: @20426
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 11, /*)*//*default:*//*Label 645*/ 22481,
    /*GILLT_s16*//*Label 634*/ 20443,
    /*GILLT_s32*//*Label 635*/ 20524,
    /*GILLT_s64*//*Label 636*/ 21009,
    /*GILLT_s128*//*Label 637*/ 21353,
    /*GILLT_v2s32*//*Label 638*/ 21465,
    /*GILLT_v2s64*//*Label 639*/ 21629,
    /*GILLT_v4s16*//*Label 640*/ 21793,
    /*GILLT_v4s32*//*Label 641*/ 21957,
    /*GILLT_v8s8*//*Label 642*/ 22121,
    /*GILLT_v8s16*//*Label 643*/ 22219,
    /*GILLT_v16s8*//*Label 644*/ 22383,
    // Label 634: @20443
    GIM_Try, /*On fail goto*//*Label 646*/ 20523,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR16RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 647*/ 20491, // Rule ID 212 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed16,
        // (ld:{ *:[f16] } (am_indexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRHui:{ *:[f16] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRHui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 212,
        GIR_Done,
      // Label 647: @20491
      GIM_Try, /*On fail goto*//*Label 648*/ 20522, // Rule ID 233 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
        // (ld:{ *:[f16] } (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURHi:{ *:[f16] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURHi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 233,
        GIR_Done,
      // Label 648: @20522
      GIM_Reject,
    // Label 646: @20523
    GIM_Reject,
    // Label 635: @20524
    GIM_Try, /*On fail goto*//*Label 649*/ 20570, // Rule ID 210 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed32,
      // (ld:{ *:[i32] } (am_indexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRWui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRWui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 210,
      GIR_Done,
    // Label 649: @20570
    GIM_Try, /*On fail goto*//*Label 650*/ 20616, // Rule ID 213 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed32,
      // (ld:{ *:[f32] } (am_indexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRSui:{ *:[f32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 213,
      GIR_Done,
    // Label 650: @20616
    GIM_Try, /*On fail goto*//*Label 651*/ 20662, // Rule ID 231 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled32,
      // (ld:{ *:[i32] } (am_unscaled32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURWi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURWi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 231,
      GIR_Done,
    // Label 651: @20662
    GIM_Try, /*On fail goto*//*Label 652*/ 20708, // Rule ID 234 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled32,
      // (ld:{ *:[f32] } (am_unscaled32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURSi:{ *:[f32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURSi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 234,
      GIR_Done,
    // Label 652: @20708
    GIM_Try, /*On fail goto*//*Label 653*/ 20758, // Rule ID 2072 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed16,
      // (ld:{ *:[i32] } (am_indexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>>  =>  (LDRHHui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRHHui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2072,
      GIR_Done,
    // Label 653: @20758
    GIM_Try, /*On fail goto*//*Label 654*/ 20808, // Rule ID 2073 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed8,
      // (ld:{ *:[i32] } (am_indexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>>  =>  (LDRBBui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRBBui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2073,
      GIR_Done,
    // Label 654: @20808
    GIM_Try, /*On fail goto*//*Label 655*/ 20858, // Rule ID 2074 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed8,
      // (ld:{ *:[i32] } (am_indexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi1>>  =>  (LDRBBui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRBBui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2074,
      GIR_Done,
    // Label 655: @20858
    GIM_Try, /*On fail goto*//*Label 656*/ 20908, // Rule ID 2095 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
      // (ld:{ *:[i32] } (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>>  =>  (LDURHHi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURHHi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2095,
      GIR_Done,
    // Label 656: @20908
    GIM_Try, /*On fail goto*//*Label 657*/ 20958, // Rule ID 2096 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled8,
      // (ld:{ *:[i32] } (am_unscaled8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>>  =>  (LDURBBi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURBBi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2096,
      GIR_Done,
    // Label 657: @20958
    GIM_Try, /*On fail goto*//*Label 658*/ 21008, // Rule ID 2097 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled8,
      // (ld:{ *:[i32] } (am_unscaled8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi1>>  =>  (LDURBBi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURBBi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2097,
      GIR_Done,
    // Label 658: @21008
    GIM_Reject,
    // Label 636: @21009
    GIM_Try, /*On fail goto*//*Label 659*/ 21352,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 660*/ 21057, // Rule ID 209 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[i64] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRXui:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRXui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 209,
        GIR_Done,
      // Label 660: @21057
      GIM_Try, /*On fail goto*//*Label 661*/ 21096, // Rule ID 214 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[f64] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[f64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 214,
        GIR_Done,
      // Label 661: @21096
      GIM_Try, /*On fail goto*//*Label 662*/ 21135, // Rule ID 230 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[i64] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURXi:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURXi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 230,
        GIR_Done,
      // Label 662: @21135
      GIM_Try, /*On fail goto*//*Label 663*/ 21174, // Rule ID 235 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[f64] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[f64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 235,
        GIR_Done,
      // Label 663: @21174
      GIM_Try, /*On fail goto*//*Label 664*/ 21213, // Rule ID 2058 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[v1f64] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v1f64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2058,
        GIR_Done,
      // Label 664: @21213
      GIM_Try, /*On fail goto*//*Label 665*/ 21252, // Rule ID 2059 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[v1i64] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v1i64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2059,
        GIR_Done,
      // Label 665: @21252
      GIM_Try, /*On fail goto*//*Label 666*/ 21291, // Rule ID 2086 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[v1f64] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v1f64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2086,
        GIR_Done,
      // Label 666: @21291
      GIM_Try, /*On fail goto*//*Label 667*/ 21330, // Rule ID 2087 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[v1i64] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v1i64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2087,
        GIR_Done,
      // Label 667: @21330
      GIM_Try, /*On fail goto*//*Label 668*/ 21351, // Rule ID 3058 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v1i64] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev1d:{ *:[v1i64] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev1d,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3058,
        GIR_Done,
      // Label 668: @21351
      GIM_Reject,
    // Label 659: @21352
    GIM_Reject,
    // Label 637: @21353
    GIM_Try, /*On fail goto*//*Label 669*/ 21464,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 670*/ 21401, // Rule ID 215 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[f128] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[f128] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 215,
        GIR_Done,
      // Label 670: @21401
      GIM_Try, /*On fail goto*//*Label 671*/ 21432, // Rule ID 236 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[f128] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[f128] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 236,
        GIR_Done,
      // Label 671: @21432
      GIM_Try, /*On fail goto*//*Label 672*/ 21463, // Rule ID 2067 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[f128] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[f128] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2067,
        GIR_Done,
      // Label 672: @21463
      GIM_Reject,
    // Label 669: @21464
    GIM_Reject,
    // Label 638: @21465
    GIM_Try, /*On fail goto*//*Label 673*/ 21628,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 674*/ 21515, // Rule ID 2053 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[v2f32] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v2f32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2053,
        GIR_Done,
      // Label 674: @21515
      GIM_Try, /*On fail goto*//*Label 675*/ 21548, // Rule ID 2056 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[v2i32] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v2i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2056,
        GIR_Done,
      // Label 675: @21548
      GIM_Try, /*On fail goto*//*Label 676*/ 21581, // Rule ID 2081 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[v2f32] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v2f32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2081,
        GIR_Done,
      // Label 676: @21581
      GIM_Try, /*On fail goto*//*Label 677*/ 21614, // Rule ID 2082 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[v2i32] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v2i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2082,
        GIR_Done,
      // Label 677: @21614
      GIM_Try, /*On fail goto*//*Label 678*/ 21627, // Rule ID 3057 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v2i32] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev2s:{ *:[v2i32] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev2s,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3057,
        GIR_Done,
      // Label 678: @21627
      GIM_Reject,
    // Label 673: @21628
    GIM_Reject,
    // Label 639: @21629
    GIM_Try, /*On fail goto*//*Label 679*/ 21792,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 680*/ 21679, // Rule ID 2061 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v2f64] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v2f64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2061,
        GIR_Done,
      // Label 680: @21679
      GIM_Try, /*On fail goto*//*Label 681*/ 21712, // Rule ID 2065 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v2i64] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v2i64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2065,
        GIR_Done,
      // Label 681: @21712
      GIM_Try, /*On fail goto*//*Label 682*/ 21745, // Rule ID 2088 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v2f64] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v2f64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2088,
        GIR_Done,
      // Label 682: @21745
      GIM_Try, /*On fail goto*//*Label 683*/ 21778, // Rule ID 2089 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v2i64] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v2i64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2089,
        GIR_Done,
      // Label 683: @21778
      GIM_Try, /*On fail goto*//*Label 684*/ 21791, // Rule ID 3054 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v2i64] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev2d:{ *:[v2i64] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev2d,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3054,
        GIR_Done,
      // Label 684: @21791
      GIM_Reject,
    // Label 679: @21792
    GIM_Reject,
    // Label 640: @21793
    GIM_Try, /*On fail goto*//*Label 685*/ 21956,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 686*/ 21843, // Rule ID 2055 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[v4i16] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v4i16] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2055,
        GIR_Done,
      // Label 686: @21843
      GIM_Try, /*On fail goto*//*Label 687*/ 21876, // Rule ID 2057 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[v4f16] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v4f16] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2057,
        GIR_Done,
      // Label 687: @21876
      GIM_Try, /*On fail goto*//*Label 688*/ 21909, // Rule ID 2083 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[v4i16] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v4i16] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2083,
        GIR_Done,
      // Label 688: @21909
      GIM_Try, /*On fail goto*//*Label 689*/ 21942, // Rule ID 2085 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[v4f16] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v4f16] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2085,
        GIR_Done,
      // Label 689: @21942
      GIM_Try, /*On fail goto*//*Label 690*/ 21955, // Rule ID 3056 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v4i16] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev4h:{ *:[v4i16] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev4h,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3056,
        GIR_Done,
      // Label 690: @21955
      GIM_Reject,
    // Label 685: @21956
    GIM_Reject,
    // Label 641: @21957
    GIM_Try, /*On fail goto*//*Label 691*/ 22120,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 692*/ 22007, // Rule ID 2060 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v4f32] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v4f32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2060,
        GIR_Done,
      // Label 692: @22007
      GIM_Try, /*On fail goto*//*Label 693*/ 22040, // Rule ID 2064 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v4i32] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v4i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2064,
        GIR_Done,
      // Label 693: @22040
      GIM_Try, /*On fail goto*//*Label 694*/ 22073, // Rule ID 2090 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v4f32] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v4f32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2090,
        GIR_Done,
      // Label 694: @22073
      GIM_Try, /*On fail goto*//*Label 695*/ 22106, // Rule ID 2091 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v4i32] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v4i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2091,
        GIR_Done,
      // Label 695: @22106
      GIM_Try, /*On fail goto*//*Label 696*/ 22119, // Rule ID 3053 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v4i32] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev4s:{ *:[v4i32] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev4s,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3053,
        GIR_Done,
      // Label 696: @22119
      GIM_Reject,
    // Label 691: @22120
    GIM_Reject,
    // Label 642: @22121
    GIM_Try, /*On fail goto*//*Label 697*/ 22218,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 698*/ 22171, // Rule ID 2054 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (ld:{ *:[v8i8] } (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRDui:{ *:[v8i8] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2054,
        GIR_Done,
      // Label 698: @22171
      GIM_Try, /*On fail goto*//*Label 699*/ 22204, // Rule ID 2084 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (ld:{ *:[v8i8] } (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURDi:{ *:[v8i8] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2084,
        GIR_Done,
      // Label 699: @22204
      GIM_Try, /*On fail goto*//*Label 700*/ 22217, // Rule ID 3055 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v8i8] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev8b:{ *:[v8i8] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev8b,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3055,
        GIR_Done,
      // Label 700: @22217
      GIM_Reject,
    // Label 697: @22218
    GIM_Reject,
    // Label 643: @22219
    GIM_Try, /*On fail goto*//*Label 701*/ 22382,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 702*/ 22269, // Rule ID 2063 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v8i16] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v8i16] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2063,
        GIR_Done,
      // Label 702: @22269
      GIM_Try, /*On fail goto*//*Label 703*/ 22302, // Rule ID 2066 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v8f16] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v8f16] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2066,
        GIR_Done,
      // Label 703: @22302
      GIM_Try, /*On fail goto*//*Label 704*/ 22335, // Rule ID 2092 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v8i16] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v8i16] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2092,
        GIR_Done,
      // Label 704: @22335
      GIM_Try, /*On fail goto*//*Label 705*/ 22368, // Rule ID 2094 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v8f16] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v8f16] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2094,
        GIR_Done,
      // Label 705: @22368
      GIM_Try, /*On fail goto*//*Label 706*/ 22381, // Rule ID 3052 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v8i16] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev8h:{ *:[v8i16] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev8h,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3052,
        GIR_Done,
      // Label 706: @22381
      GIM_Reject,
    // Label 701: @22382
    GIM_Reject,
    // Label 644: @22383
    GIM_Try, /*On fail goto*//*Label 707*/ 22480,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 708*/ 22433, // Rule ID 2062 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (ld:{ *:[v16i8] } (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDRQui:{ *:[v16i8] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2062,
        GIR_Done,
      // Label 708: @22433
      GIM_Try, /*On fail goto*//*Label 709*/ 22466, // Rule ID 2093 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (ld:{ *:[v16i8] } (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LDURQi:{ *:[v16i8] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2093,
        GIR_Done,
      // Label 709: @22466
      GIM_Try, /*On fail goto*//*Label 710*/ 22479, // Rule ID 3051 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (ld:{ *:[v16i8] } GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LD1Onev16b:{ *:[v16i8] } GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::LD1Onev16b,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3051,
        GIR_Done,
      // Label 710: @22479
      GIM_Reject,
    // Label 707: @22480
    GIM_Reject,
    // Label 645: @22481
    GIM_Reject,
    // Label 10: @22482
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 713*/ 22952,
    /*GILLT_s32*//*Label 711*/ 22490,
    /*GILLT_s64*//*Label 712*/ 22675,
    // Label 711: @22490
    GIM_Try, /*On fail goto*//*Label 714*/ 22536, // Rule ID 218 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed16,
      // (ld:{ *:[i32] } (am_indexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LDRSHWui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSHWui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 218,
      GIR_Done,
    // Label 714: @22536
    GIM_Try, /*On fail goto*//*Label 715*/ 22582, // Rule ID 220 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed8,
      // (ld:{ *:[i32] } (am_indexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>>  =>  (LDRSBWui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSBWui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 220,
      GIR_Done,
    // Label 715: @22582
    GIM_Try, /*On fail goto*//*Label 716*/ 22628, // Rule ID 239 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
      // (ld:{ *:[i32] } (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LDURSHWi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURSHWi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 239,
      GIR_Done,
    // Label 716: @22628
    GIM_Try, /*On fail goto*//*Label 717*/ 22674, // Rule ID 241 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled8,
      // (ld:{ *:[i32] } (am_unscaled8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>>  =>  (LDURSBWi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURSBWi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 241,
      GIR_Done,
    // Label 717: @22674
    GIM_Reject,
    // Label 712: @22675
    GIM_Try, /*On fail goto*//*Label 718*/ 22721, // Rule ID 219 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed16,
      // (ld:{ *:[i64] } (am_indexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LDRSHXui:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSHXui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 219,
      GIR_Done,
    // Label 718: @22721
    GIM_Try, /*On fail goto*//*Label 719*/ 22767, // Rule ID 221 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed8,
      // (ld:{ *:[i64] } (am_indexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>>  =>  (LDRSBXui:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSBXui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 221,
      GIR_Done,
    // Label 719: @22767
    GIM_Try, /*On fail goto*//*Label 720*/ 22813, // Rule ID 222 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed32,
      // (ld:{ *:[i64] } (am_indexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi32>>  =>  (LDRSWui:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRSWui,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 222,
      GIR_Done,
    // Label 720: @22813
    GIM_Try, /*On fail goto*//*Label 721*/ 22859, // Rule ID 240 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
      // (ld:{ *:[i64] } (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LDURSHXi:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURSHXi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 240,
      GIR_Done,
    // Label 721: @22859
    GIM_Try, /*On fail goto*//*Label 722*/ 22905, // Rule ID 242 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled8,
      // (ld:{ *:[i64] } (am_unscaled8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>>  =>  (LDURSBXi:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURSBXi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 242,
      GIR_Done,
    // Label 722: @22905
    GIM_Try, /*On fail goto*//*Label 723*/ 22951, // Rule ID 243 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled32,
      // (ld:{ *:[i64] } (am_unscaled32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi32>>  =>  (LDURSWi:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURSWi,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 243,
      GIR_Done,
    // Label 723: @22951
    GIM_Reject,
    // Label 713: @22952
    GIM_Reject,
    // Label 11: @22953
    GIM_Try, /*On fail goto*//*Label 724*/ 23304,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 725*/ 23005, // Rule ID 216 //
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed16,
        // (ld:{ *:[i32] } (am_indexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi16>>  =>  (LDRHHui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRHHui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 216,
        GIR_Done,
      // Label 725: @23005
      GIM_Try, /*On fail goto*//*Label 726*/ 23051, // Rule ID 217 //
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed8,
        // (ld:{ *:[i32] } (am_indexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi8>>  =>  (LDRBBui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRBBui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 217,
        GIR_Done,
      // Label 726: @23051
      GIM_Try, /*On fail goto*//*Label 727*/ 23097, // Rule ID 237 //
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
        // (ld:{ *:[i32] } (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi16>>  =>  (LDURHHi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURHHi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 237,
        GIR_Done,
      // Label 727: @23097
      GIM_Try, /*On fail goto*//*Label 728*/ 23177,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_Try, /*On fail goto*//*Label 729*/ 23145, // Rule ID 238 //
          GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
          // (ld:{ *:[i32] } (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi8>>  =>  (LDURBBi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURBBi,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
          GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 238,
          GIR_Done,
        // Label 729: @23145
        GIM_Try, /*On fail goto*//*Label 730*/ 23176, // Rule ID 2070 //
          GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed8,
          // (ld:{ *:[i32] } (am_indexed8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi1>>  =>  (LDRBBui:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, uimm12s1:{ *:[i64] }:$offset)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDRBBui,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
          GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2070,
          GIR_Done,
        // Label 730: @23176
        GIM_Reject,
      // Label 728: @23177
      GIM_Try, /*On fail goto*//*Label 731*/ 23223, // Rule ID 2102 //
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
        // (ld:{ *:[i32] } (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi16>>  =>  (LDURHHi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURHHi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2102,
        GIR_Done,
      // Label 731: @23223
      GIM_Try, /*On fail goto*//*Label 732*/ 23303,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_Try, /*On fail goto*//*Label 733*/ 23271, // Rule ID 2103 //
          GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled8,
          // (ld:{ *:[i32] } (am_unscaled8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi8>>  =>  (LDURBBi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURBBi,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
          GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2103,
          GIR_Done,
        // Label 733: @23271
        GIM_Try, /*On fail goto*//*Label 734*/ 23302, // Rule ID 2104 //
          GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled8,
          // (ld:{ *:[i32] } (am_unscaled8:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi1>>  =>  (LDURBBi:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDURBBi,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
          GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2104,
          GIR_Done,
        // Label 734: @23302
        GIM_Reject,
      // Label 732: @23303
      GIM_Reject,
    // Label 724: @23304
    GIM_Reject,
    // Label 12: @23305
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 11, /*)*//*default:*//*Label 746*/ 25551,
    /*GILLT_s16*//*Label 735*/ 23322,
    /*GILLT_s32*//*Label 736*/ 23475,
    /*GILLT_s64*//*Label 737*/ 23776,
    /*GILLT_s128*//*Label 738*/ 24250,
    /*GILLT_v2s32*//*Label 739*/ 24358,
    /*GILLT_v2s64*//*Label 740*/ 24546,
    /*GILLT_v4s16*//*Label 741*/ 24775,
    /*GILLT_v4s32*//*Label 742*/ 24963,
    /*GILLT_v8s8*//*Label 743*/ 25151,
    /*GILLT_v8s16*//*Label 744*/ 25257,
    /*GILLT_v16s8*//*Label 745*/ 25445,
    // Label 735: @23322
    GIM_Try, /*On fail goto*//*Label 747*/ 23474,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 748*/ 23395, // Rule ID 3099 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (st (vector_extract:{ *:[f16] } VecListOne128:{ *:[v8f16] }:$Vt, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1i16 VecListOne128:{ *:[v8f16] }:$Vt, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ST1i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, 2, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3099,
        GIR_Done,
      // Label 748: @23395
      GIM_Try, /*On fail goto*//*Label 749*/ 23434, // Rule ID 264 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR16RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed16,
        // (st FPR16Op:{ *:[f16] }:$Rt, (am_indexed16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRHui FPR16Op:{ *:[f16] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s2:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRHui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 264,
        GIR_Done,
      // Label 749: @23434
      GIM_Try, /*On fail goto*//*Label 750*/ 23473, // Rule ID 272 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR16RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled16,
        // (st FPR16Op:{ *:[f16] }:$Rt, (am_unscaled16:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURHi FPR16Op:{ *:[f16] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURHi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 272,
        GIR_Done,
      // Label 750: @23473
      GIM_Reject,
    // Label 747: @23474
    GIM_Reject,
    // Label 736: @23475
    GIM_Try, /*On fail goto*//*Label 751*/ 23775,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 752*/ 23548, // Rule ID 3095 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexS,
        // MIs[2] Operand 1
        // No operand predicates
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (st (vector_extract:{ *:[i32] } VecListOne128:{ *:[v4i32] }:$Vt, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1i32 VecListOne128:{ *:[v4i32] }:$Vt, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ST1i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, 2, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3095,
        GIR_Done,
      // Label 752: @23548
      GIM_Try, /*On fail goto*//*Label 753*/ 23616, // Rule ID 3096 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexS,
        // MIs[2] Operand 1
        // No operand predicates
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (st (vector_extract:{ *:[f32] } VecListOne128:{ *:[v4f32] }:$Vt, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1i32 VecListOne128:{ *:[v4f32] }:$Vt, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ST1i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, 2, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3096,
        GIR_Done,
      // Label 753: @23616
      GIM_Try, /*On fail goto*//*Label 754*/ 23656, // Rule ID 262 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed32,
        // (st GPR32z:{ *:[i32] }:$Rt, (am_indexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRWui GPR32z:{ *:[i32] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRWui,
        GIR_CopyOrAddZeroReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, AArch64::WZR, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 262,
        GIR_Done,
      // Label 754: @23656
      GIM_Try, /*On fail goto*//*Label 755*/ 23695, // Rule ID 265 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR32RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed32,
        // (st FPR32Op:{ *:[f32] }:$Rt, (am_indexed32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRSui FPR32Op:{ *:[f32] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s4:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRSui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 265,
        GIR_Done,
      // Label 755: @23695
      GIM_Try, /*On fail goto*//*Label 756*/ 23735, // Rule ID 270 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled32,
        // (st GPR32z:{ *:[i32] }:$Rt, (am_unscaled32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURWi GPR32z:{ *:[i32] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURWi,
        GIR_CopyOrAddZeroReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, AArch64::WZR, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 270,
        GIR_Done,
      // Label 756: @23735
      GIM_Try, /*On fail goto*//*Label 757*/ 23774, // Rule ID 273 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR32RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled32,
        // (st FPR32Op:{ *:[f32] }:$Rt, (am_unscaled32:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURSi FPR32Op:{ *:[f32] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURSi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 273,
        GIR_Done,
      // Label 757: @23774
      GIM_Reject,
    // Label 751: @23775
    GIM_Reject,
    // Label 737: @23776
    GIM_Try, /*On fail goto*//*Label 758*/ 24249,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 759*/ 23849, // Rule ID 3097 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexD,
        // MIs[2] Operand 1
        // No operand predicates
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (st (vector_extract:{ *:[i64] } VecListOne128:{ *:[v2i64] }:$Vt, (imm:{ *:[i64] })<<P:Predicate_VectorIndexD>>:$idx), GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1i64 VecListOne128:{ *:[v2i64] }:$Vt, (imm:{ *:[i64] })<<P:Predicate_VectorIndexD>>:$idx, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ST1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, 2, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3097,
        GIR_Done,
      // Label 759: @23849
      GIM_Try, /*On fail goto*//*Label 760*/ 23917, // Rule ID 3098 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexD,
        // MIs[2] Operand 1
        // No operand predicates
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (st (vector_extract:{ *:[f64] } VecListOne128:{ *:[v2f64] }:$Vt, (imm:{ *:[i64] })<<P:Predicate_VectorIndexD>>:$idx), GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1i64 VecListOne128:{ *:[v2f64] }:$Vt, (imm:{ *:[i64] })<<P:Predicate_VectorIndexD>>:$idx, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ST1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, 2, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3098,
        GIR_Done,
      // Label 760: @23917
      GIM_Try, /*On fail goto*//*Label 761*/ 23957, // Rule ID 261 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (st GPR64z:{ *:[i64] }:$Rt, (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRXui GPR64z:{ *:[i64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRXui,
        GIR_CopyOrAddZeroReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, AArch64::XZR, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 261,
        GIR_Done,
      // Label 761: @23957
      GIM_Try, /*On fail goto*//*Label 762*/ 23996, // Rule ID 266 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (st FPR64Op:{ *:[f64] }:$Rt, (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRDui FPR64Op:{ *:[f64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 266,
        GIR_Done,
      // Label 762: @23996
      GIM_Try, /*On fail goto*//*Label 763*/ 24035, // Rule ID 2159 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (st FPR64:{ *:[v1i64] }:$Rt, (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRDui FPR64:{ *:[v1i64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2159,
        GIR_Done,
      // Label 763: @24035
      GIM_Try, /*On fail goto*//*Label 764*/ 24074, // Rule ID 2160 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (st FPR64:{ *:[v1f64] }:$Rt, (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRDui FPR64:{ *:[v1f64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2160,
        GIR_Done,
      // Label 764: @24074
      GIM_Try, /*On fail goto*//*Label 765*/ 24114, // Rule ID 269 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (st GPR64z:{ *:[i64] }:$Rt, (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURXi GPR64z:{ *:[i64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURXi,
        GIR_CopyOrAddZeroReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, AArch64::XZR, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 269,
        GIR_Done,
      // Label 765: @24114
      GIM_Try, /*On fail goto*//*Label 766*/ 24153, // Rule ID 274 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (st FPR64Op:{ *:[f64] }:$Rt, (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURDi FPR64Op:{ *:[f64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 274,
        GIR_Done,
      // Label 766: @24153
      GIM_Try, /*On fail goto*//*Label 767*/ 24192, // Rule ID 2183 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (st FPR64:{ *:[v1f64] }:$Rt, (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURDi FPR64:{ *:[v1f64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2183,
        GIR_Done,
      // Label 767: @24192
      GIM_Try, /*On fail goto*//*Label 768*/ 24231, // Rule ID 2184 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (st FPR64:{ *:[v1i64] }:$Rt, (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURDi FPR64:{ *:[v1i64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2184,
        GIR_Done,
      // Label 768: @24231
      GIM_Try, /*On fail goto*//*Label 769*/ 24248, // Rule ID 3066 //
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (st v1i64:{ *:[v1i64] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1Onev1d v1i64:{ *:[v1i64] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ST1Onev1d,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3066,
        GIR_Done,
      // Label 769: @24248
      GIM_Reject,
    // Label 758: @24249
    GIM_Reject,
    // Label 738: @24250
    GIM_Try, /*On fail goto*//*Label 770*/ 24357,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_Try, /*On fail goto*//*Label 771*/ 24294, // Rule ID 2166 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (st FPR128:{ *:[f128] }:$Rt, (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRQui FPR128:{ *:[f128] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2166,
        GIR_Done,
      // Label 771: @24294
      GIM_Try, /*On fail goto*//*Label 772*/ 24325, // Rule ID 2190 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (st FPR128:{ *:[f128] }:$Rt, (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURQi FPR128:{ *:[f128] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2190,
        GIR_Done,
      // Label 772: @24325
      GIM_Try, /*On fail goto*//*Label 773*/ 24356, // Rule ID 275 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (st FPR128Op:{ *:[f128] }:$Rt, (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURQi FPR128Op:{ *:[f128] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] }):$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 275,
        GIR_Done,
      // Label 773: @24356
      GIM_Reject,
    // Label 770: @24357
    GIM_Reject,
    // Label 739: @24358
    GIM_Try, /*On fail goto*//*Label 774*/ 24545,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 775*/ 24404, // Rule ID 2161 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (st FPR64:{ *:[v2f32] }:$Rt, (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRDui FPR64:{ *:[v2f32] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2161,
        GIR_Done,
      // Label 775: @24404
      GIM_Try, /*On fail goto*//*Label 776*/ 24445, // Rule ID 2164 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (st FPR64:{ *:[v2i32] }:$Rt, (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRDui FPR64:{ *:[v2i32] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2164,
        GIR_Done,
      // Label 776: @24445
      GIM_Try, /*On fail goto*//*Label 777*/ 24486, // Rule ID 2185 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (st FPR64:{ *:[v2f32] }:$Rt, (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURDi FPR64:{ *:[v2f32] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2185,
        GIR_Done,
      // Label 777: @24486
      GIM_Try, /*On fail goto*//*Label 778*/ 24527, // Rule ID 2188 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (st FPR64:{ *:[v2i32] }:$Rt, (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURDi FPR64:{ *:[v2i32] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2188,
        GIR_Done,
      // Label 778: @24527
      GIM_Try, /*On fail goto*//*Label 779*/ 24544, // Rule ID 3065 //
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (st v2i32:{ *:[v2i32] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1Onev2s v2i32:{ *:[v2i32] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ST1Onev2s,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3065,
        GIR_Done,
      // Label 779: @24544
      GIM_Reject,
    // Label 774: @24545
    GIM_Reject,
    // Label 740: @24546
    GIM_Try, /*On fail goto*//*Label 780*/ 24774,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 781*/ 24592, // Rule ID 2168 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (st FPR128:{ *:[v2f64] }:$Rt, (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRQui FPR128:{ *:[v2f64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2168,
        GIR_Done,
      // Label 781: @24592
      GIM_Try, /*On fail goto*//*Label 782*/ 24633, // Rule ID 2172 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (st FPR128:{ *:[v2i64] }:$Rt, (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRQui FPR128:{ *:[v2i64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2172,
        GIR_Done,
      // Label 782: @24633
      GIM_Try, /*On fail goto*//*Label 783*/ 24674, // Rule ID 2192 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (st FPR128:{ *:[v2f64] }:$Rt, (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURQi FPR128:{ *:[v2f64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2192,
        GIR_Done,
      // Label 783: @24674
      GIM_Try, /*On fail goto*//*Label 784*/ 24715, // Rule ID 2196 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (st FPR128:{ *:[v2i64] }:$Rt, (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURQi FPR128:{ *:[v2i64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2196,
        GIR_Done,
      // Label 784: @24715
      GIM_Try, /*On fail goto*//*Label 785*/ 24756, // Rule ID 2197 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (st FPR128:{ *:[v2f64] }:$Rt, (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURQi FPR128:{ *:[v2f64] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2197,
        GIR_Done,
      // Label 785: @24756
      GIM_Try, /*On fail goto*//*Label 786*/ 24773, // Rule ID 3062 //
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (st v2i64:{ *:[v2i64] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1Onev2d v2i64:{ *:[v2i64] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ST1Onev2d,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3062,
        GIR_Done,
      // Label 786: @24773
      GIM_Reject,
    // Label 780: @24774
    GIM_Reject,
    // Label 741: @24775
    GIM_Try, /*On fail goto*//*Label 787*/ 24962,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 788*/ 24821, // Rule ID 2163 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (st FPR64:{ *:[v4i16] }:$Rt, (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRDui FPR64:{ *:[v4i16] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2163,
        GIR_Done,
      // Label 788: @24821
      GIM_Try, /*On fail goto*//*Label 789*/ 24862, // Rule ID 2165 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (st FPR64:{ *:[v4f16] }:$Rt, (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRDui FPR64:{ *:[v4f16] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2165,
        GIR_Done,
      // Label 789: @24862
      GIM_Try, /*On fail goto*//*Label 790*/ 24903, // Rule ID 2187 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (st FPR64:{ *:[v4i16] }:$Rt, (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURDi FPR64:{ *:[v4i16] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2187,
        GIR_Done,
      // Label 790: @24903
      GIM_Try, /*On fail goto*//*Label 791*/ 24944, // Rule ID 2189 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (st FPR64:{ *:[v4f16] }:$Rt, (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURDi FPR64:{ *:[v4f16] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2189,
        GIR_Done,
      // Label 791: @24944
      GIM_Try, /*On fail goto*//*Label 792*/ 24961, // Rule ID 3064 //
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (st v4i16:{ *:[v4i16] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1Onev4h v4i16:{ *:[v4i16] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ST1Onev4h,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3064,
        GIR_Done,
      // Label 792: @24961
      GIM_Reject,
    // Label 787: @24962
    GIM_Reject,
    // Label 742: @24963
    GIM_Try, /*On fail goto*//*Label 793*/ 25150,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 794*/ 25009, // Rule ID 2167 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (st FPR128:{ *:[v4f32] }:$Rt, (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRQui FPR128:{ *:[v4f32] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2167,
        GIR_Done,
      // Label 794: @25009
      GIM_Try, /*On fail goto*//*Label 795*/ 25050, // Rule ID 2171 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (st FPR128:{ *:[v4i32] }:$Rt, (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRQui FPR128:{ *:[v4i32] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2171,
        GIR_Done,
      // Label 795: @25050
      GIM_Try, /*On fail goto*//*Label 796*/ 25091, // Rule ID 2191 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (st FPR128:{ *:[v4f32] }:$Rt, (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURQi FPR128:{ *:[v4f32] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2191,
        GIR_Done,
      // Label 796: @25091
      GIM_Try, /*On fail goto*//*Label 797*/ 25132, // Rule ID 2195 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (st FPR128:{ *:[v4i32] }:$Rt, (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURQi FPR128:{ *:[v4i32] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2195,
        GIR_Done,
      // Label 797: @25132
      GIM_Try, /*On fail goto*//*Label 798*/ 25149, // Rule ID 3061 //
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (st v4i32:{ *:[v4i32] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1Onev4s v4i32:{ *:[v4i32] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ST1Onev4s,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3061,
        GIR_Done,
      // Label 798: @25149
      GIM_Reject,
    // Label 793: @25150
    GIM_Reject,
    // Label 743: @25151
    GIM_Try, /*On fail goto*//*Label 799*/ 25256,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 800*/ 25197, // Rule ID 2162 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed64,
        // (st FPR64:{ *:[v8i8] }:$Rt, (am_indexed64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRDui FPR64:{ *:[v8i8] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s8:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRDui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2162,
        GIR_Done,
      // Label 800: @25197
      GIM_Try, /*On fail goto*//*Label 801*/ 25238, // Rule ID 2186 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled64,
        // (st FPR64:{ *:[v8i8] }:$Rt, (am_unscaled64:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURDi FPR64:{ *:[v8i8] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2186,
        GIR_Done,
      // Label 801: @25238
      GIM_Try, /*On fail goto*//*Label 802*/ 25255, // Rule ID 3063 //
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (st v8i8:{ *:[v8i8] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1Onev8b v8i8:{ *:[v8i8] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ST1Onev8b,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3063,
        GIR_Done,
      // Label 802: @25255
      GIM_Reject,
    // Label 799: @25256
    GIM_Reject,
    // Label 744: @25257
    GIM_Try, /*On fail goto*//*Label 803*/ 25444,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 804*/ 25303, // Rule ID 2170 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (st FPR128:{ *:[v8i16] }:$Rt, (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRQui FPR128:{ *:[v8i16] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2170,
        GIR_Done,
      // Label 804: @25303
      GIM_Try, /*On fail goto*//*Label 805*/ 25344, // Rule ID 2173 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (st FPR128:{ *:[v8f16] }:$Rt, (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRQui FPR128:{ *:[v8f16] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2173,
        GIR_Done,
      // Label 805: @25344
      GIM_Try, /*On fail goto*//*Label 806*/ 25385, // Rule ID 2194 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (st FPR128:{ *:[v8i16] }:$Rt, (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURQi FPR128:{ *:[v8i16] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2194,
        GIR_Done,
      // Label 806: @25385
      GIM_Try, /*On fail goto*//*Label 807*/ 25426, // Rule ID 2198 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (st FPR128:{ *:[v8f16] }:$Rt, (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURQi FPR128:{ *:[v8f16] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2198,
        GIR_Done,
      // Label 807: @25426
      GIM_Try, /*On fail goto*//*Label 808*/ 25443, // Rule ID 3060 //
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (st v8i16:{ *:[v8i16] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1Onev8h v8i16:{ *:[v8i16] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ST1Onev8h,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3060,
        GIR_Done,
      // Label 808: @25443
      GIM_Reject,
    // Label 803: @25444
    GIM_Reject,
    // Label 745: @25445
    GIM_Try, /*On fail goto*//*Label 809*/ 25550,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 810*/ 25491, // Rule ID 2169 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_indexed128,
        // (st FPR128:{ *:[v16i8] }:$Rt, (am_indexed128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STRQui FPR128:{ *:[v16i8] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, uimm12s16:{ *:[i64] }:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STRQui,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2169,
        GIR_Done,
      // Label 810: @25491
      GIM_Try, /*On fail goto*//*Label 811*/ 25532, // Rule ID 2193 //
        GIM_CheckFeatures, GIFBS_IsLE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_am_unscaled128,
        // (st FPR128:{ *:[v16i8] }:$Rt, (am_unscaled128:{ *:[iPTR] } GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset))<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (STURQi FPR128:{ *:[v16i8] }:$Rt, GPR64sp:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_simm9>>:$offset)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::STURQi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2193,
        GIR_Done,
      // Label 811: @25532
      GIM_Try, /*On fail goto*//*Label 812*/ 25549, // Rule ID 3059 //
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        // (st v16i8:{ *:[v16i8] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (ST1Onev16b v16i8:{ *:[v16i8] }:$Vt, GPR64sp:{ *:[i64] }:$Rn)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ST1Onev16b,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3059,
        GIR_Done,
      // Label 812: @25549
      GIM_Reject,
    // Label 809: @25550
    GIM_Reject,
    // Label 746: @25551
    GIM_Reject,
    // Label 13: @25552
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 815*/ 26748,
    /*GILLT_s32*//*Label 813*/ 25560,
    /*GILLT_s64*//*Label 814*/ 26457,
    // Label 813: @25560
    GIM_Try, /*On fail goto*//*Label 816*/ 26456,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 817*/ 25629, // Rule ID 3773 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_monotonic>>  =>  (CASW:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3773,
        GIR_Done,
      // Label 817: @25629
      GIM_Try, /*On fail goto*//*Label 818*/ 25688, // Rule ID 3774 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acquire>>  =>  (CASAW:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3774,
        GIR_Done,
      // Label 818: @25688
      GIM_Try, /*On fail goto*//*Label 819*/ 25747, // Rule ID 3775 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_release>>  =>  (CASLW:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3775,
        GIR_Done,
      // Label 819: @25747
      GIM_Try, /*On fail goto*//*Label 820*/ 25806, // Rule ID 3776 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acq_rel>>  =>  (CASALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3776,
        GIR_Done,
      // Label 820: @25806
      GIM_Try, /*On fail goto*//*Label 821*/ 25865, // Rule ID 3777 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_seq_cst>>  =>  (CASALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3777,
        GIR_Done,
      // Label 821: @25865
      GIM_Try, /*On fail goto*//*Label 822*/ 25924, // Rule ID 3778 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_16>><<P:Predicate_atomic_cmp_swap_16_monotonic>>  =>  (CASH:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3778,
        GIR_Done,
      // Label 822: @25924
      GIM_Try, /*On fail goto*//*Label 823*/ 25983, // Rule ID 3779 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_16>><<P:Predicate_atomic_cmp_swap_16_acquire>>  =>  (CASAH:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3779,
        GIR_Done,
      // Label 823: @25983
      GIM_Try, /*On fail goto*//*Label 824*/ 26042, // Rule ID 3780 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_16>><<P:Predicate_atomic_cmp_swap_16_release>>  =>  (CASLH:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3780,
        GIR_Done,
      // Label 824: @26042
      GIM_Try, /*On fail goto*//*Label 825*/ 26101, // Rule ID 3781 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_16>><<P:Predicate_atomic_cmp_swap_16_acq_rel>>  =>  (CASALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3781,
        GIR_Done,
      // Label 825: @26101
      GIM_Try, /*On fail goto*//*Label 826*/ 26160, // Rule ID 3782 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_16>><<P:Predicate_atomic_cmp_swap_16_seq_cst>>  =>  (CASALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3782,
        GIR_Done,
      // Label 826: @26160
      GIM_Try, /*On fail goto*//*Label 827*/ 26219, // Rule ID 3783 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_8>><<P:Predicate_atomic_cmp_swap_8_monotonic>>  =>  (CASB:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3783,
        GIR_Done,
      // Label 827: @26219
      GIM_Try, /*On fail goto*//*Label 828*/ 26278, // Rule ID 3784 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_8>><<P:Predicate_atomic_cmp_swap_8_acquire>>  =>  (CASAB:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3784,
        GIR_Done,
      // Label 828: @26278
      GIM_Try, /*On fail goto*//*Label 829*/ 26337, // Rule ID 3785 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_8>><<P:Predicate_atomic_cmp_swap_8_release>>  =>  (CASLB:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3785,
        GIR_Done,
      // Label 829: @26337
      GIM_Try, /*On fail goto*//*Label 830*/ 26396, // Rule ID 3786 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_8>><<P:Predicate_atomic_cmp_swap_8_acq_rel>>  =>  (CASALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3786,
        GIR_Done,
      // Label 830: @26396
      GIM_Try, /*On fail goto*//*Label 831*/ 26455, // Rule ID 3787 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew)<<P:Predicate_atomic_cmp_swap_8>><<P:Predicate_atomic_cmp_swap_8_seq_cst>>  =>  (CASALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rold, GPR32:{ *:[i32] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3787,
        GIR_Done,
      // Label 831: @26455
      GIM_Reject,
    // Label 816: @26456
    GIM_Reject,
    // Label 814: @26457
    GIM_Try, /*On fail goto*//*Label 832*/ 26747,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_Try, /*On fail goto*//*Label 833*/ 26526, // Rule ID 1848 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rold, GPR64:{ *:[i64] }:$Rnew)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_monotonic>>  =>  (CASX:{ *:[i64] } GPR64:{ *:[i64] }:$Rold, GPR64:{ *:[i64] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1848,
        GIR_Done,
      // Label 833: @26526
      GIM_Try, /*On fail goto*//*Label 834*/ 26581, // Rule ID 1849 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rold, GPR64:{ *:[i64] }:$Rnew)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acquire>>  =>  (CASAX:{ *:[i64] } GPR64:{ *:[i64] }:$Rold, GPR64:{ *:[i64] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1849,
        GIR_Done,
      // Label 834: @26581
      GIM_Try, /*On fail goto*//*Label 835*/ 26636, // Rule ID 1850 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rold, GPR64:{ *:[i64] }:$Rnew)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_release>>  =>  (CASLX:{ *:[i64] } GPR64:{ *:[i64] }:$Rold, GPR64:{ *:[i64] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1850,
        GIR_Done,
      // Label 835: @26636
      GIM_Try, /*On fail goto*//*Label 836*/ 26691, // Rule ID 1851 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rold, GPR64:{ *:[i64] }:$Rnew)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acq_rel>>  =>  (CASALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rold, GPR64:{ *:[i64] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1851,
        GIR_Done,
      // Label 836: @26691
      GIM_Try, /*On fail goto*//*Label 837*/ 26746, // Rule ID 1852 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rold, GPR64:{ *:[i64] }:$Rnew)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_seq_cst>>  =>  (CASALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rold, GPR64:{ *:[i64] }:$Rnew, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::CASALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rold
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rnew
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1852,
        GIR_Done,
      // Label 837: @26746
      GIM_Reject,
    // Label 832: @26747
    GIM_Reject,
    // Label 815: @26748
    GIM_Reject,
    // Label 14: @26749
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 840*/ 27777,
    /*GILLT_s32*//*Label 838*/ 26757,
    /*GILLT_s64*//*Label 839*/ 27530,
    // Label 838: @26757
    GIM_Try, /*On fail goto*//*Label 841*/ 27529,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 842*/ 26814, // Rule ID 3758 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_monotonic>>  =>  (SWPW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3758,
        GIR_Done,
      // Label 842: @26814
      GIM_Try, /*On fail goto*//*Label 843*/ 26865, // Rule ID 3759 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_acquire>>  =>  (SWPAW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3759,
        GIR_Done,
      // Label 843: @26865
      GIM_Try, /*On fail goto*//*Label 844*/ 26916, // Rule ID 3760 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_release>>  =>  (SWPLW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3760,
        GIR_Done,
      // Label 844: @26916
      GIM_Try, /*On fail goto*//*Label 845*/ 26967, // Rule ID 3761 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_acq_rel>>  =>  (SWPALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3761,
        GIR_Done,
      // Label 845: @26967
      GIM_Try, /*On fail goto*//*Label 846*/ 27018, // Rule ID 3762 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_seq_cst>>  =>  (SWPALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3762,
        GIR_Done,
      // Label 846: @27018
      GIM_Try, /*On fail goto*//*Label 847*/ 27069, // Rule ID 3763 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_16>><<P:Predicate_atomic_swap_16_monotonic>>  =>  (SWPH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3763,
        GIR_Done,
      // Label 847: @27069
      GIM_Try, /*On fail goto*//*Label 848*/ 27120, // Rule ID 3764 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_16>><<P:Predicate_atomic_swap_16_acquire>>  =>  (SWPAH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3764,
        GIR_Done,
      // Label 848: @27120
      GIM_Try, /*On fail goto*//*Label 849*/ 27171, // Rule ID 3765 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_16>><<P:Predicate_atomic_swap_16_release>>  =>  (SWPLH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3765,
        GIR_Done,
      // Label 849: @27171
      GIM_Try, /*On fail goto*//*Label 850*/ 27222, // Rule ID 3766 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_16>><<P:Predicate_atomic_swap_16_acq_rel>>  =>  (SWPALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3766,
        GIR_Done,
      // Label 850: @27222
      GIM_Try, /*On fail goto*//*Label 851*/ 27273, // Rule ID 3767 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_16>><<P:Predicate_atomic_swap_16_seq_cst>>  =>  (SWPALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3767,
        GIR_Done,
      // Label 851: @27273
      GIM_Try, /*On fail goto*//*Label 852*/ 27324, // Rule ID 3768 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_8>><<P:Predicate_atomic_swap_8_monotonic>>  =>  (SWPB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3768,
        GIR_Done,
      // Label 852: @27324
      GIM_Try, /*On fail goto*//*Label 853*/ 27375, // Rule ID 3769 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_8>><<P:Predicate_atomic_swap_8_acquire>>  =>  (SWPAB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3769,
        GIR_Done,
      // Label 853: @27375
      GIM_Try, /*On fail goto*//*Label 854*/ 27426, // Rule ID 3770 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_8>><<P:Predicate_atomic_swap_8_release>>  =>  (SWPLB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3770,
        GIR_Done,
      // Label 854: @27426
      GIM_Try, /*On fail goto*//*Label 855*/ 27477, // Rule ID 3771 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_8>><<P:Predicate_atomic_swap_8_acq_rel>>  =>  (SWPALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3771,
        GIR_Done,
      // Label 855: @27477
      GIM_Try, /*On fail goto*//*Label 856*/ 27528, // Rule ID 3772 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_swap:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_swap_8>><<P:Predicate_atomic_swap_8_seq_cst>>  =>  (SWPALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3772,
        GIR_Done,
      // Label 856: @27528
      GIM_Reject,
    // Label 841: @27529
    GIM_Reject,
    // Label 839: @27530
    GIM_Try, /*On fail goto*//*Label 857*/ 27776,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_Try, /*On fail goto*//*Label 858*/ 27587, // Rule ID 3753 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_swap:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_monotonic>>  =>  (SWPX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3753,
        GIR_Done,
      // Label 858: @27587
      GIM_Try, /*On fail goto*//*Label 859*/ 27634, // Rule ID 3754 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_swap:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_acquire>>  =>  (SWPAX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3754,
        GIR_Done,
      // Label 859: @27634
      GIM_Try, /*On fail goto*//*Label 860*/ 27681, // Rule ID 3755 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_swap:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_release>>  =>  (SWPLX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3755,
        GIR_Done,
      // Label 860: @27681
      GIM_Try, /*On fail goto*//*Label 861*/ 27728, // Rule ID 3756 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_swap:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_acq_rel>>  =>  (SWPALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3756,
        GIR_Done,
      // Label 861: @27728
      GIM_Try, /*On fail goto*//*Label 862*/ 27775, // Rule ID 3757 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_swap:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_seq_cst>>  =>  (SWPALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SWPALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3757,
        GIR_Done,
      // Label 862: @27775
      GIM_Reject,
    // Label 857: @27776
    GIM_Reject,
    // Label 840: @27777
    GIM_Reject,
    // Label 15: @27778
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 865*/ 28806,
    /*GILLT_s32*//*Label 863*/ 27786,
    /*GILLT_s64*//*Label 864*/ 28559,
    // Label 863: @27786
    GIM_Try, /*On fail goto*//*Label 866*/ 28558,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 867*/ 27843, // Rule ID 3598 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_monotonic>>  =>  (LDADDW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3598,
        GIR_Done,
      // Label 867: @27843
      GIM_Try, /*On fail goto*//*Label 868*/ 27894, // Rule ID 3599 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_acquire>>  =>  (LDADDAW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3599,
        GIR_Done,
      // Label 868: @27894
      GIM_Try, /*On fail goto*//*Label 869*/ 27945, // Rule ID 3600 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_release>>  =>  (LDADDLW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3600,
        GIR_Done,
      // Label 869: @27945
      GIM_Try, /*On fail goto*//*Label 870*/ 27996, // Rule ID 3601 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_acq_rel>>  =>  (LDADDALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3601,
        GIR_Done,
      // Label 870: @27996
      GIM_Try, /*On fail goto*//*Label 871*/ 28047, // Rule ID 3602 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_seq_cst>>  =>  (LDADDALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3602,
        GIR_Done,
      // Label 871: @28047
      GIM_Try, /*On fail goto*//*Label 872*/ 28098, // Rule ID 3603 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_16>><<P:Predicate_atomic_load_add_16_monotonic>>  =>  (LDADDH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3603,
        GIR_Done,
      // Label 872: @28098
      GIM_Try, /*On fail goto*//*Label 873*/ 28149, // Rule ID 3604 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_16>><<P:Predicate_atomic_load_add_16_acquire>>  =>  (LDADDAH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3604,
        GIR_Done,
      // Label 873: @28149
      GIM_Try, /*On fail goto*//*Label 874*/ 28200, // Rule ID 3605 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_16>><<P:Predicate_atomic_load_add_16_release>>  =>  (LDADDLH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3605,
        GIR_Done,
      // Label 874: @28200
      GIM_Try, /*On fail goto*//*Label 875*/ 28251, // Rule ID 3606 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_16>><<P:Predicate_atomic_load_add_16_acq_rel>>  =>  (LDADDALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3606,
        GIR_Done,
      // Label 875: @28251
      GIM_Try, /*On fail goto*//*Label 876*/ 28302, // Rule ID 3607 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_16>><<P:Predicate_atomic_load_add_16_seq_cst>>  =>  (LDADDALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3607,
        GIR_Done,
      // Label 876: @28302
      GIM_Try, /*On fail goto*//*Label 877*/ 28353, // Rule ID 3608 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_8>><<P:Predicate_atomic_load_add_8_monotonic>>  =>  (LDADDB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3608,
        GIR_Done,
      // Label 877: @28353
      GIM_Try, /*On fail goto*//*Label 878*/ 28404, // Rule ID 3609 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_8>><<P:Predicate_atomic_load_add_8_acquire>>  =>  (LDADDAB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3609,
        GIR_Done,
      // Label 878: @28404
      GIM_Try, /*On fail goto*//*Label 879*/ 28455, // Rule ID 3610 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_8>><<P:Predicate_atomic_load_add_8_release>>  =>  (LDADDLB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3610,
        GIR_Done,
      // Label 879: @28455
      GIM_Try, /*On fail goto*//*Label 880*/ 28506, // Rule ID 3611 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_8>><<P:Predicate_atomic_load_add_8_acq_rel>>  =>  (LDADDALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3611,
        GIR_Done,
      // Label 880: @28506
      GIM_Try, /*On fail goto*//*Label 881*/ 28557, // Rule ID 3612 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_add:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_add_8>><<P:Predicate_atomic_load_add_8_seq_cst>>  =>  (LDADDALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3612,
        GIR_Done,
      // Label 881: @28557
      GIM_Reject,
    // Label 866: @28558
    GIM_Reject,
    // Label 864: @28559
    GIM_Try, /*On fail goto*//*Label 882*/ 28805,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_Try, /*On fail goto*//*Label 883*/ 28616, // Rule ID 1843 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_monotonic>>  =>  (LDADDX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1843,
        GIR_Done,
      // Label 883: @28616
      GIM_Try, /*On fail goto*//*Label 884*/ 28663, // Rule ID 1844 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_acquire>>  =>  (LDADDAX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1844,
        GIR_Done,
      // Label 884: @28663
      GIM_Try, /*On fail goto*//*Label 885*/ 28710, // Rule ID 1845 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_release>>  =>  (LDADDLX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1845,
        GIR_Done,
      // Label 885: @28710
      GIM_Try, /*On fail goto*//*Label 886*/ 28757, // Rule ID 1846 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_acq_rel>>  =>  (LDADDALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1846,
        GIR_Done,
      // Label 886: @28757
      GIM_Try, /*On fail goto*//*Label 887*/ 28804, // Rule ID 1847 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_seq_cst>>  =>  (LDADDALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1847,
        GIR_Done,
      // Label 887: @28804
      GIM_Reject,
    // Label 882: @28805
    GIM_Reject,
    // Label 865: @28806
    GIM_Reject,
    // Label 16: @28807
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 890*/ 30215,
    /*GILLT_s32*//*Label 888*/ 28815,
    /*GILLT_s64*//*Label 889*/ 29873,
    // Label 888: @28815
    GIM_Try, /*On fail goto*//*Label 891*/ 29872,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 892*/ 28891, // Rule ID 3793 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_monotonic>>  =>  (LDADDW:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3793,
        GIR_Done,
      // Label 892: @28891
      GIM_Try, /*On fail goto*//*Label 893*/ 28961, // Rule ID 3794 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_acquire>>  =>  (LDADDAW:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3794,
        GIR_Done,
      // Label 893: @28961
      GIM_Try, /*On fail goto*//*Label 894*/ 29031, // Rule ID 3795 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_release>>  =>  (LDADDLW:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3795,
        GIR_Done,
      // Label 894: @29031
      GIM_Try, /*On fail goto*//*Label 895*/ 29101, // Rule ID 3796 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_acq_rel>>  =>  (LDADDALW:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3796,
        GIR_Done,
      // Label 895: @29101
      GIM_Try, /*On fail goto*//*Label 896*/ 29171, // Rule ID 3797 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_seq_cst>>  =>  (LDADDALW:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3797,
        GIR_Done,
      // Label 896: @29171
      GIM_Try, /*On fail goto*//*Label 897*/ 29241, // Rule ID 3798 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_16>><<P:Predicate_atomic_load_sub_16_monotonic>>  =>  (LDADDH:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3798,
        GIR_Done,
      // Label 897: @29241
      GIM_Try, /*On fail goto*//*Label 898*/ 29311, // Rule ID 3799 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_16>><<P:Predicate_atomic_load_sub_16_acquire>>  =>  (LDADDAH:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3799,
        GIR_Done,
      // Label 898: @29311
      GIM_Try, /*On fail goto*//*Label 899*/ 29381, // Rule ID 3800 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_16>><<P:Predicate_atomic_load_sub_16_release>>  =>  (LDADDLH:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3800,
        GIR_Done,
      // Label 899: @29381
      GIM_Try, /*On fail goto*//*Label 900*/ 29451, // Rule ID 3801 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_16>><<P:Predicate_atomic_load_sub_16_acq_rel>>  =>  (LDADDALH:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3801,
        GIR_Done,
      // Label 900: @29451
      GIM_Try, /*On fail goto*//*Label 901*/ 29521, // Rule ID 3802 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_16>><<P:Predicate_atomic_load_sub_16_seq_cst>>  =>  (LDADDALH:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3802,
        GIR_Done,
      // Label 901: @29521
      GIM_Try, /*On fail goto*//*Label 902*/ 29591, // Rule ID 3803 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_8>><<P:Predicate_atomic_load_sub_8_monotonic>>  =>  (LDADDB:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3803,
        GIR_Done,
      // Label 902: @29591
      GIM_Try, /*On fail goto*//*Label 903*/ 29661, // Rule ID 3804 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_8>><<P:Predicate_atomic_load_sub_8_acquire>>  =>  (LDADDAB:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3804,
        GIR_Done,
      // Label 903: @29661
      GIM_Try, /*On fail goto*//*Label 904*/ 29731, // Rule ID 3805 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_8>><<P:Predicate_atomic_load_sub_8_release>>  =>  (LDADDLB:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3805,
        GIR_Done,
      // Label 904: @29731
      GIM_Try, /*On fail goto*//*Label 905*/ 29801, // Rule ID 3806 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_8>><<P:Predicate_atomic_load_sub_8_acq_rel>>  =>  (LDADDALB:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3806,
        GIR_Done,
      // Label 905: @29801
      GIM_Try, /*On fail goto*//*Label 906*/ 29871, // Rule ID 3807 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_sub_8>><<P:Predicate_atomic_load_sub_8_seq_cst>>  =>  (LDADDALB:{ *:[i32] } (SUBWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3807,
        GIR_Done,
      // Label 906: @29871
      GIM_Reject,
    // Label 891: @29872
    GIM_Reject,
    // Label 889: @29873
    GIM_Try, /*On fail goto*//*Label 907*/ 30214,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_Try, /*On fail goto*//*Label 908*/ 29949, // Rule ID 3788 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_monotonic>>  =>  (LDADDX:{ *:[i64] } (SUBXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBXrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::XZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3788,
        GIR_Done,
      // Label 908: @29949
      GIM_Try, /*On fail goto*//*Label 909*/ 30015, // Rule ID 3789 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_acquire>>  =>  (LDADDAX:{ *:[i64] } (SUBXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBXrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::XZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3789,
        GIR_Done,
      // Label 909: @30015
      GIM_Try, /*On fail goto*//*Label 910*/ 30081, // Rule ID 3790 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_release>>  =>  (LDADDLX:{ *:[i64] } (SUBXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBXrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::XZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3790,
        GIR_Done,
      // Label 910: @30081
      GIM_Try, /*On fail goto*//*Label 911*/ 30147, // Rule ID 3791 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_acq_rel>>  =>  (LDADDALX:{ *:[i64] } (SUBXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBXrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::XZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3791,
        GIR_Done,
      // Label 911: @30147
      GIM_Try, /*On fail goto*//*Label 912*/ 30213, // Rule ID 3792 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_seq_cst>>  =>  (LDADDALX:{ *:[i64] } (SUBXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::SUBXrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::XZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDADDALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3792,
        GIR_Done,
      // Label 912: @30213
      GIM_Reject,
    // Label 907: @30214
    GIM_Reject,
    // Label 890: @30215
    GIM_Reject,
    // Label 17: @30216
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 915*/ 31624,
    /*GILLT_s32*//*Label 913*/ 30224,
    /*GILLT_s64*//*Label 914*/ 31282,
    // Label 913: @30224
    GIM_Try, /*On fail goto*//*Label 916*/ 31281,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 917*/ 30300, // Rule ID 3813 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_monotonic>>  =>  (LDCLRW:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3813,
        GIR_Done,
      // Label 917: @30300
      GIM_Try, /*On fail goto*//*Label 918*/ 30370, // Rule ID 3814 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_acquire>>  =>  (LDCLRAW:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3814,
        GIR_Done,
      // Label 918: @30370
      GIM_Try, /*On fail goto*//*Label 919*/ 30440, // Rule ID 3815 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_release>>  =>  (LDCLRLW:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3815,
        GIR_Done,
      // Label 919: @30440
      GIM_Try, /*On fail goto*//*Label 920*/ 30510, // Rule ID 3816 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_acq_rel>>  =>  (LDCLRALW:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3816,
        GIR_Done,
      // Label 920: @30510
      GIM_Try, /*On fail goto*//*Label 921*/ 30580, // Rule ID 3817 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_seq_cst>>  =>  (LDCLRALW:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3817,
        GIR_Done,
      // Label 921: @30580
      GIM_Try, /*On fail goto*//*Label 922*/ 30650, // Rule ID 3818 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_16>><<P:Predicate_atomic_load_and_16_monotonic>>  =>  (LDCLRH:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3818,
        GIR_Done,
      // Label 922: @30650
      GIM_Try, /*On fail goto*//*Label 923*/ 30720, // Rule ID 3819 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_16>><<P:Predicate_atomic_load_and_16_acquire>>  =>  (LDCLRAH:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3819,
        GIR_Done,
      // Label 923: @30720
      GIM_Try, /*On fail goto*//*Label 924*/ 30790, // Rule ID 3820 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_16>><<P:Predicate_atomic_load_and_16_release>>  =>  (LDCLRLH:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3820,
        GIR_Done,
      // Label 924: @30790
      GIM_Try, /*On fail goto*//*Label 925*/ 30860, // Rule ID 3821 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_16>><<P:Predicate_atomic_load_and_16_acq_rel>>  =>  (LDCLRALH:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3821,
        GIR_Done,
      // Label 925: @30860
      GIM_Try, /*On fail goto*//*Label 926*/ 30930, // Rule ID 3822 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_16>><<P:Predicate_atomic_load_and_16_seq_cst>>  =>  (LDCLRALH:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3822,
        GIR_Done,
      // Label 926: @30930
      GIM_Try, /*On fail goto*//*Label 927*/ 31000, // Rule ID 3823 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_8>><<P:Predicate_atomic_load_and_8_monotonic>>  =>  (LDCLRB:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3823,
        GIR_Done,
      // Label 927: @31000
      GIM_Try, /*On fail goto*//*Label 928*/ 31070, // Rule ID 3824 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_8>><<P:Predicate_atomic_load_and_8_acquire>>  =>  (LDCLRAB:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3824,
        GIR_Done,
      // Label 928: @31070
      GIM_Try, /*On fail goto*//*Label 929*/ 31140, // Rule ID 3825 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_8>><<P:Predicate_atomic_load_and_8_release>>  =>  (LDCLRLB:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3825,
        GIR_Done,
      // Label 929: @31140
      GIM_Try, /*On fail goto*//*Label 930*/ 31210, // Rule ID 3826 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_8>><<P:Predicate_atomic_load_and_8_acq_rel>>  =>  (LDCLRALB:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3826,
        GIR_Done,
      // Label 930: @31210
      GIM_Try, /*On fail goto*//*Label 931*/ 31280, // Rule ID 3827 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_and:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_and_8>><<P:Predicate_atomic_load_and_8_seq_cst>>  =>  (LDCLRALB:{ *:[i32] } (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNWrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::WZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3827,
        GIR_Done,
      // Label 931: @31280
      GIM_Reject,
    // Label 916: @31281
    GIM_Reject,
    // Label 914: @31282
    GIM_Try, /*On fail goto*//*Label 932*/ 31623,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_Try, /*On fail goto*//*Label 933*/ 31358, // Rule ID 3808 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_and:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_monotonic>>  =>  (LDCLRX:{ *:[i64] } (ORNXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNXrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::XZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3808,
        GIR_Done,
      // Label 933: @31358
      GIM_Try, /*On fail goto*//*Label 934*/ 31424, // Rule ID 3809 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_and:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_acquire>>  =>  (LDCLRAX:{ *:[i64] } (ORNXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNXrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::XZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3809,
        GIR_Done,
      // Label 934: @31424
      GIM_Try, /*On fail goto*//*Label 935*/ 31490, // Rule ID 3810 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_and:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_release>>  =>  (LDCLRLX:{ *:[i64] } (ORNXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNXrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::XZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3810,
        GIR_Done,
      // Label 935: @31490
      GIM_Try, /*On fail goto*//*Label 936*/ 31556, // Rule ID 3811 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_and:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_acq_rel>>  =>  (LDCLRALX:{ *:[i64] } (ORNXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNXrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::XZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3811,
        GIR_Done,
      // Label 936: @31556
      GIM_Try, /*On fail goto*//*Label 937*/ 31622, // Rule ID 3812 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_and:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_seq_cst>>  =>  (LDCLRALX:{ *:[i64] } (ORNXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Rm), GPR64sp:{ *:[i64] }:$Rn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::ORNXrr,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, AArch64::XZR,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDCLRALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3812,
        GIR_Done,
      // Label 937: @31622
      GIM_Reject,
    // Label 932: @31623
    GIM_Reject,
    // Label 915: @31624
    GIM_Reject,
    // Label 18: @31625
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 940*/ 32653,
    /*GILLT_s32*//*Label 938*/ 31633,
    /*GILLT_s64*//*Label 939*/ 32406,
    // Label 938: @31633
    GIM_Try, /*On fail goto*//*Label 941*/ 32405,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 942*/ 31690, // Rule ID 3618 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_monotonic>>  =>  (LDSETW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3618,
        GIR_Done,
      // Label 942: @31690
      GIM_Try, /*On fail goto*//*Label 943*/ 31741, // Rule ID 3619 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_acquire>>  =>  (LDSETAW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3619,
        GIR_Done,
      // Label 943: @31741
      GIM_Try, /*On fail goto*//*Label 944*/ 31792, // Rule ID 3620 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_release>>  =>  (LDSETLW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3620,
        GIR_Done,
      // Label 944: @31792
      GIM_Try, /*On fail goto*//*Label 945*/ 31843, // Rule ID 3621 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_acq_rel>>  =>  (LDSETALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3621,
        GIR_Done,
      // Label 945: @31843
      GIM_Try, /*On fail goto*//*Label 946*/ 31894, // Rule ID 3622 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_seq_cst>>  =>  (LDSETALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3622,
        GIR_Done,
      // Label 946: @31894
      GIM_Try, /*On fail goto*//*Label 947*/ 31945, // Rule ID 3623 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_16>><<P:Predicate_atomic_load_or_16_monotonic>>  =>  (LDSETH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3623,
        GIR_Done,
      // Label 947: @31945
      GIM_Try, /*On fail goto*//*Label 948*/ 31996, // Rule ID 3624 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_16>><<P:Predicate_atomic_load_or_16_acquire>>  =>  (LDSETAH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3624,
        GIR_Done,
      // Label 948: @31996
      GIM_Try, /*On fail goto*//*Label 949*/ 32047, // Rule ID 3625 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_16>><<P:Predicate_atomic_load_or_16_release>>  =>  (LDSETLH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3625,
        GIR_Done,
      // Label 949: @32047
      GIM_Try, /*On fail goto*//*Label 950*/ 32098, // Rule ID 3626 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_16>><<P:Predicate_atomic_load_or_16_acq_rel>>  =>  (LDSETALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3626,
        GIR_Done,
      // Label 950: @32098
      GIM_Try, /*On fail goto*//*Label 951*/ 32149, // Rule ID 3627 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_16>><<P:Predicate_atomic_load_or_16_seq_cst>>  =>  (LDSETALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3627,
        GIR_Done,
      // Label 951: @32149
      GIM_Try, /*On fail goto*//*Label 952*/ 32200, // Rule ID 3628 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_8>><<P:Predicate_atomic_load_or_8_monotonic>>  =>  (LDSETB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3628,
        GIR_Done,
      // Label 952: @32200
      GIM_Try, /*On fail goto*//*Label 953*/ 32251, // Rule ID 3629 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_8>><<P:Predicate_atomic_load_or_8_acquire>>  =>  (LDSETAB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3629,
        GIR_Done,
      // Label 953: @32251
      GIM_Try, /*On fail goto*//*Label 954*/ 32302, // Rule ID 3630 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_8>><<P:Predicate_atomic_load_or_8_release>>  =>  (LDSETLB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3630,
        GIR_Done,
      // Label 954: @32302
      GIM_Try, /*On fail goto*//*Label 955*/ 32353, // Rule ID 3631 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_8>><<P:Predicate_atomic_load_or_8_acq_rel>>  =>  (LDSETALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3631,
        GIR_Done,
      // Label 955: @32353
      GIM_Try, /*On fail goto*//*Label 956*/ 32404, // Rule ID 3632 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_or:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_or_8>><<P:Predicate_atomic_load_or_8_seq_cst>>  =>  (LDSETALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3632,
        GIR_Done,
      // Label 956: @32404
      GIM_Reject,
    // Label 941: @32405
    GIM_Reject,
    // Label 939: @32406
    GIM_Try, /*On fail goto*//*Label 957*/ 32652,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_Try, /*On fail goto*//*Label 958*/ 32463, // Rule ID 3613 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_or:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_monotonic>>  =>  (LDSETX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3613,
        GIR_Done,
      // Label 958: @32463
      GIM_Try, /*On fail goto*//*Label 959*/ 32510, // Rule ID 3614 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_or:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_acquire>>  =>  (LDSETAX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3614,
        GIR_Done,
      // Label 959: @32510
      GIM_Try, /*On fail goto*//*Label 960*/ 32557, // Rule ID 3615 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_or:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_release>>  =>  (LDSETLX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3615,
        GIR_Done,
      // Label 960: @32557
      GIM_Try, /*On fail goto*//*Label 961*/ 32604, // Rule ID 3616 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_or:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_acq_rel>>  =>  (LDSETALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3616,
        GIR_Done,
      // Label 961: @32604
      GIM_Try, /*On fail goto*//*Label 962*/ 32651, // Rule ID 3617 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_or:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_seq_cst>>  =>  (LDSETALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSETALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3617,
        GIR_Done,
      // Label 962: @32651
      GIM_Reject,
    // Label 957: @32652
    GIM_Reject,
    // Label 940: @32653
    GIM_Reject,
    // Label 19: @32654
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 965*/ 33682,
    /*GILLT_s32*//*Label 963*/ 32662,
    /*GILLT_s64*//*Label 964*/ 33435,
    // Label 963: @32662
    GIM_Try, /*On fail goto*//*Label 966*/ 33434,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 967*/ 32719, // Rule ID 3638 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_monotonic>>  =>  (LDEORW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3638,
        GIR_Done,
      // Label 967: @32719
      GIM_Try, /*On fail goto*//*Label 968*/ 32770, // Rule ID 3639 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_acquire>>  =>  (LDEORAW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3639,
        GIR_Done,
      // Label 968: @32770
      GIM_Try, /*On fail goto*//*Label 969*/ 32821, // Rule ID 3640 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_release>>  =>  (LDEORLW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3640,
        GIR_Done,
      // Label 969: @32821
      GIM_Try, /*On fail goto*//*Label 970*/ 32872, // Rule ID 3641 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_acq_rel>>  =>  (LDEORALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3641,
        GIR_Done,
      // Label 970: @32872
      GIM_Try, /*On fail goto*//*Label 971*/ 32923, // Rule ID 3642 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_seq_cst>>  =>  (LDEORALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3642,
        GIR_Done,
      // Label 971: @32923
      GIM_Try, /*On fail goto*//*Label 972*/ 32974, // Rule ID 3643 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_16>><<P:Predicate_atomic_load_xor_16_monotonic>>  =>  (LDEORH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3643,
        GIR_Done,
      // Label 972: @32974
      GIM_Try, /*On fail goto*//*Label 973*/ 33025, // Rule ID 3644 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_16>><<P:Predicate_atomic_load_xor_16_acquire>>  =>  (LDEORAH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3644,
        GIR_Done,
      // Label 973: @33025
      GIM_Try, /*On fail goto*//*Label 974*/ 33076, // Rule ID 3645 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_16>><<P:Predicate_atomic_load_xor_16_release>>  =>  (LDEORLH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3645,
        GIR_Done,
      // Label 974: @33076
      GIM_Try, /*On fail goto*//*Label 975*/ 33127, // Rule ID 3646 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_16>><<P:Predicate_atomic_load_xor_16_acq_rel>>  =>  (LDEORALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3646,
        GIR_Done,
      // Label 975: @33127
      GIM_Try, /*On fail goto*//*Label 976*/ 33178, // Rule ID 3647 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_16>><<P:Predicate_atomic_load_xor_16_seq_cst>>  =>  (LDEORALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3647,
        GIR_Done,
      // Label 976: @33178
      GIM_Try, /*On fail goto*//*Label 977*/ 33229, // Rule ID 3648 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_8>><<P:Predicate_atomic_load_xor_8_monotonic>>  =>  (LDEORB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3648,
        GIR_Done,
      // Label 977: @33229
      GIM_Try, /*On fail goto*//*Label 978*/ 33280, // Rule ID 3649 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_8>><<P:Predicate_atomic_load_xor_8_acquire>>  =>  (LDEORAB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3649,
        GIR_Done,
      // Label 978: @33280
      GIM_Try, /*On fail goto*//*Label 979*/ 33331, // Rule ID 3650 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_8>><<P:Predicate_atomic_load_xor_8_release>>  =>  (LDEORLB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3650,
        GIR_Done,
      // Label 979: @33331
      GIM_Try, /*On fail goto*//*Label 980*/ 33382, // Rule ID 3651 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_8>><<P:Predicate_atomic_load_xor_8_acq_rel>>  =>  (LDEORALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3651,
        GIR_Done,
      // Label 980: @33382
      GIM_Try, /*On fail goto*//*Label 981*/ 33433, // Rule ID 3652 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_xor_8>><<P:Predicate_atomic_load_xor_8_seq_cst>>  =>  (LDEORALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3652,
        GIR_Done,
      // Label 981: @33433
      GIM_Reject,
    // Label 966: @33434
    GIM_Reject,
    // Label 964: @33435
    GIM_Try, /*On fail goto*//*Label 982*/ 33681,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_Try, /*On fail goto*//*Label 983*/ 33492, // Rule ID 3633 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_monotonic>>  =>  (LDEORX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3633,
        GIR_Done,
      // Label 983: @33492
      GIM_Try, /*On fail goto*//*Label 984*/ 33539, // Rule ID 3634 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_acquire>>  =>  (LDEORAX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3634,
        GIR_Done,
      // Label 984: @33539
      GIM_Try, /*On fail goto*//*Label 985*/ 33586, // Rule ID 3635 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_release>>  =>  (LDEORLX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3635,
        GIR_Done,
      // Label 985: @33586
      GIM_Try, /*On fail goto*//*Label 986*/ 33633, // Rule ID 3636 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_acq_rel>>  =>  (LDEORALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3636,
        GIR_Done,
      // Label 986: @33633
      GIM_Try, /*On fail goto*//*Label 987*/ 33680, // Rule ID 3637 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_seq_cst>>  =>  (LDEORALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDEORALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3637,
        GIR_Done,
      // Label 987: @33680
      GIM_Reject,
    // Label 982: @33681
    GIM_Reject,
    // Label 965: @33682
    GIM_Reject,
    // Label 20: @33683
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 990*/ 34711,
    /*GILLT_s32*//*Label 988*/ 33691,
    /*GILLT_s64*//*Label 989*/ 34464,
    // Label 988: @33691
    GIM_Try, /*On fail goto*//*Label 991*/ 34463,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 992*/ 33748, // Rule ID 3678 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_monotonic>>  =>  (LDSMAXW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3678,
        GIR_Done,
      // Label 992: @33748
      GIM_Try, /*On fail goto*//*Label 993*/ 33799, // Rule ID 3679 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_acquire>>  =>  (LDSMAXAW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3679,
        GIR_Done,
      // Label 993: @33799
      GIM_Try, /*On fail goto*//*Label 994*/ 33850, // Rule ID 3680 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_release>>  =>  (LDSMAXLW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3680,
        GIR_Done,
      // Label 994: @33850
      GIM_Try, /*On fail goto*//*Label 995*/ 33901, // Rule ID 3681 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_acq_rel>>  =>  (LDSMAXALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3681,
        GIR_Done,
      // Label 995: @33901
      GIM_Try, /*On fail goto*//*Label 996*/ 33952, // Rule ID 3682 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_seq_cst>>  =>  (LDSMAXALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3682,
        GIR_Done,
      // Label 996: @33952
      GIM_Try, /*On fail goto*//*Label 997*/ 34003, // Rule ID 3683 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_16>><<P:Predicate_atomic_load_max_16_monotonic>>  =>  (LDSMAXH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3683,
        GIR_Done,
      // Label 997: @34003
      GIM_Try, /*On fail goto*//*Label 998*/ 34054, // Rule ID 3684 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_16>><<P:Predicate_atomic_load_max_16_acquire>>  =>  (LDSMAXAH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3684,
        GIR_Done,
      // Label 998: @34054
      GIM_Try, /*On fail goto*//*Label 999*/ 34105, // Rule ID 3685 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_16>><<P:Predicate_atomic_load_max_16_release>>  =>  (LDSMAXLH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3685,
        GIR_Done,
      // Label 999: @34105
      GIM_Try, /*On fail goto*//*Label 1000*/ 34156, // Rule ID 3686 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_16>><<P:Predicate_atomic_load_max_16_acq_rel>>  =>  (LDSMAXALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3686,
        GIR_Done,
      // Label 1000: @34156
      GIM_Try, /*On fail goto*//*Label 1001*/ 34207, // Rule ID 3687 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_16>><<P:Predicate_atomic_load_max_16_seq_cst>>  =>  (LDSMAXALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3687,
        GIR_Done,
      // Label 1001: @34207
      GIM_Try, /*On fail goto*//*Label 1002*/ 34258, // Rule ID 3688 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_8>><<P:Predicate_atomic_load_max_8_monotonic>>  =>  (LDSMAXB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3688,
        GIR_Done,
      // Label 1002: @34258
      GIM_Try, /*On fail goto*//*Label 1003*/ 34309, // Rule ID 3689 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_8>><<P:Predicate_atomic_load_max_8_acquire>>  =>  (LDSMAXAB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3689,
        GIR_Done,
      // Label 1003: @34309
      GIM_Try, /*On fail goto*//*Label 1004*/ 34360, // Rule ID 3690 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_8>><<P:Predicate_atomic_load_max_8_release>>  =>  (LDSMAXLB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3690,
        GIR_Done,
      // Label 1004: @34360
      GIM_Try, /*On fail goto*//*Label 1005*/ 34411, // Rule ID 3691 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_8>><<P:Predicate_atomic_load_max_8_acq_rel>>  =>  (LDSMAXALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3691,
        GIR_Done,
      // Label 1005: @34411
      GIM_Try, /*On fail goto*//*Label 1006*/ 34462, // Rule ID 3692 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_max:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_max_8>><<P:Predicate_atomic_load_max_8_seq_cst>>  =>  (LDSMAXALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3692,
        GIR_Done,
      // Label 1006: @34462
      GIM_Reject,
    // Label 991: @34463
    GIM_Reject,
    // Label 989: @34464
    GIM_Try, /*On fail goto*//*Label 1007*/ 34710,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_Try, /*On fail goto*//*Label 1008*/ 34521, // Rule ID 3673 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_max:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_monotonic>>  =>  (LDSMAXX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3673,
        GIR_Done,
      // Label 1008: @34521
      GIM_Try, /*On fail goto*//*Label 1009*/ 34568, // Rule ID 3674 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_max:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_acquire>>  =>  (LDSMAXAX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3674,
        GIR_Done,
      // Label 1009: @34568
      GIM_Try, /*On fail goto*//*Label 1010*/ 34615, // Rule ID 3675 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_max:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_release>>  =>  (LDSMAXLX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3675,
        GIR_Done,
      // Label 1010: @34615
      GIM_Try, /*On fail goto*//*Label 1011*/ 34662, // Rule ID 3676 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_max:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_acq_rel>>  =>  (LDSMAXALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3676,
        GIR_Done,
      // Label 1011: @34662
      GIM_Try, /*On fail goto*//*Label 1012*/ 34709, // Rule ID 3677 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_max:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_seq_cst>>  =>  (LDSMAXALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMAXALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3677,
        GIR_Done,
      // Label 1012: @34709
      GIM_Reject,
    // Label 1007: @34710
    GIM_Reject,
    // Label 990: @34711
    GIM_Reject,
    // Label 21: @34712
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1015*/ 35740,
    /*GILLT_s32*//*Label 1013*/ 34720,
    /*GILLT_s64*//*Label 1014*/ 35493,
    // Label 1013: @34720
    GIM_Try, /*On fail goto*//*Label 1016*/ 35492,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1017*/ 34777, // Rule ID 3698 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_monotonic>>  =>  (LDSMINW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3698,
        GIR_Done,
      // Label 1017: @34777
      GIM_Try, /*On fail goto*//*Label 1018*/ 34828, // Rule ID 3699 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_acquire>>  =>  (LDSMINAW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3699,
        GIR_Done,
      // Label 1018: @34828
      GIM_Try, /*On fail goto*//*Label 1019*/ 34879, // Rule ID 3700 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_release>>  =>  (LDSMINLW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3700,
        GIR_Done,
      // Label 1019: @34879
      GIM_Try, /*On fail goto*//*Label 1020*/ 34930, // Rule ID 3701 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_acq_rel>>  =>  (LDSMINALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3701,
        GIR_Done,
      // Label 1020: @34930
      GIM_Try, /*On fail goto*//*Label 1021*/ 34981, // Rule ID 3702 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_seq_cst>>  =>  (LDSMINALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3702,
        GIR_Done,
      // Label 1021: @34981
      GIM_Try, /*On fail goto*//*Label 1022*/ 35032, // Rule ID 3703 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_16>><<P:Predicate_atomic_load_min_16_monotonic>>  =>  (LDSMINH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3703,
        GIR_Done,
      // Label 1022: @35032
      GIM_Try, /*On fail goto*//*Label 1023*/ 35083, // Rule ID 3704 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_16>><<P:Predicate_atomic_load_min_16_acquire>>  =>  (LDSMINAH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3704,
        GIR_Done,
      // Label 1023: @35083
      GIM_Try, /*On fail goto*//*Label 1024*/ 35134, // Rule ID 3705 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_16>><<P:Predicate_atomic_load_min_16_release>>  =>  (LDSMINLH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3705,
        GIR_Done,
      // Label 1024: @35134
      GIM_Try, /*On fail goto*//*Label 1025*/ 35185, // Rule ID 3706 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_16>><<P:Predicate_atomic_load_min_16_acq_rel>>  =>  (LDSMINALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3706,
        GIR_Done,
      // Label 1025: @35185
      GIM_Try, /*On fail goto*//*Label 1026*/ 35236, // Rule ID 3707 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_16>><<P:Predicate_atomic_load_min_16_seq_cst>>  =>  (LDSMINALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3707,
        GIR_Done,
      // Label 1026: @35236
      GIM_Try, /*On fail goto*//*Label 1027*/ 35287, // Rule ID 3708 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_8>><<P:Predicate_atomic_load_min_8_monotonic>>  =>  (LDSMINB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3708,
        GIR_Done,
      // Label 1027: @35287
      GIM_Try, /*On fail goto*//*Label 1028*/ 35338, // Rule ID 3709 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_8>><<P:Predicate_atomic_load_min_8_acquire>>  =>  (LDSMINAB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3709,
        GIR_Done,
      // Label 1028: @35338
      GIM_Try, /*On fail goto*//*Label 1029*/ 35389, // Rule ID 3710 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_8>><<P:Predicate_atomic_load_min_8_release>>  =>  (LDSMINLB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3710,
        GIR_Done,
      // Label 1029: @35389
      GIM_Try, /*On fail goto*//*Label 1030*/ 35440, // Rule ID 3711 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_8>><<P:Predicate_atomic_load_min_8_acq_rel>>  =>  (LDSMINALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3711,
        GIR_Done,
      // Label 1030: @35440
      GIM_Try, /*On fail goto*//*Label 1031*/ 35491, // Rule ID 3712 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_min:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_min_8>><<P:Predicate_atomic_load_min_8_seq_cst>>  =>  (LDSMINALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3712,
        GIR_Done,
      // Label 1031: @35491
      GIM_Reject,
    // Label 1016: @35492
    GIM_Reject,
    // Label 1014: @35493
    GIM_Try, /*On fail goto*//*Label 1032*/ 35739,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_Try, /*On fail goto*//*Label 1033*/ 35550, // Rule ID 3693 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_min:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_monotonic>>  =>  (LDSMINX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3693,
        GIR_Done,
      // Label 1033: @35550
      GIM_Try, /*On fail goto*//*Label 1034*/ 35597, // Rule ID 3694 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_min:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_acquire>>  =>  (LDSMINAX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3694,
        GIR_Done,
      // Label 1034: @35597
      GIM_Try, /*On fail goto*//*Label 1035*/ 35644, // Rule ID 3695 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_min:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_release>>  =>  (LDSMINLX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3695,
        GIR_Done,
      // Label 1035: @35644
      GIM_Try, /*On fail goto*//*Label 1036*/ 35691, // Rule ID 3696 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_min:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_acq_rel>>  =>  (LDSMINALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3696,
        GIR_Done,
      // Label 1036: @35691
      GIM_Try, /*On fail goto*//*Label 1037*/ 35738, // Rule ID 3697 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_min:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_seq_cst>>  =>  (LDSMINALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDSMINALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3697,
        GIR_Done,
      // Label 1037: @35738
      GIM_Reject,
    // Label 1032: @35739
    GIM_Reject,
    // Label 1015: @35740
    GIM_Reject,
    // Label 22: @35741
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1040*/ 36769,
    /*GILLT_s32*//*Label 1038*/ 35749,
    /*GILLT_s64*//*Label 1039*/ 36522,
    // Label 1038: @35749
    GIM_Try, /*On fail goto*//*Label 1041*/ 36521,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1042*/ 35806, // Rule ID 3718 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_monotonic>>  =>  (LDUMAXW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3718,
        GIR_Done,
      // Label 1042: @35806
      GIM_Try, /*On fail goto*//*Label 1043*/ 35857, // Rule ID 3719 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_acquire>>  =>  (LDUMAXAW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3719,
        GIR_Done,
      // Label 1043: @35857
      GIM_Try, /*On fail goto*//*Label 1044*/ 35908, // Rule ID 3720 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_release>>  =>  (LDUMAXLW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3720,
        GIR_Done,
      // Label 1044: @35908
      GIM_Try, /*On fail goto*//*Label 1045*/ 35959, // Rule ID 3721 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_acq_rel>>  =>  (LDUMAXALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3721,
        GIR_Done,
      // Label 1045: @35959
      GIM_Try, /*On fail goto*//*Label 1046*/ 36010, // Rule ID 3722 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_seq_cst>>  =>  (LDUMAXALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3722,
        GIR_Done,
      // Label 1046: @36010
      GIM_Try, /*On fail goto*//*Label 1047*/ 36061, // Rule ID 3723 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_16>><<P:Predicate_atomic_load_umax_16_monotonic>>  =>  (LDUMAXH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3723,
        GIR_Done,
      // Label 1047: @36061
      GIM_Try, /*On fail goto*//*Label 1048*/ 36112, // Rule ID 3724 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_16>><<P:Predicate_atomic_load_umax_16_acquire>>  =>  (LDUMAXAH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3724,
        GIR_Done,
      // Label 1048: @36112
      GIM_Try, /*On fail goto*//*Label 1049*/ 36163, // Rule ID 3725 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_16>><<P:Predicate_atomic_load_umax_16_release>>  =>  (LDUMAXLH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3725,
        GIR_Done,
      // Label 1049: @36163
      GIM_Try, /*On fail goto*//*Label 1050*/ 36214, // Rule ID 3726 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_16>><<P:Predicate_atomic_load_umax_16_acq_rel>>  =>  (LDUMAXALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3726,
        GIR_Done,
      // Label 1050: @36214
      GIM_Try, /*On fail goto*//*Label 1051*/ 36265, // Rule ID 3727 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_16>><<P:Predicate_atomic_load_umax_16_seq_cst>>  =>  (LDUMAXALH:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXALH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3727,
        GIR_Done,
      // Label 1051: @36265
      GIM_Try, /*On fail goto*//*Label 1052*/ 36316, // Rule ID 3728 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_8>><<P:Predicate_atomic_load_umax_8_monotonic>>  =>  (LDUMAXB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3728,
        GIR_Done,
      // Label 1052: @36316
      GIM_Try, /*On fail goto*//*Label 1053*/ 36367, // Rule ID 3729 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_8>><<P:Predicate_atomic_load_umax_8_acquire>>  =>  (LDUMAXAB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3729,
        GIR_Done,
      // Label 1053: @36367
      GIM_Try, /*On fail goto*//*Label 1054*/ 36418, // Rule ID 3730 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_8>><<P:Predicate_atomic_load_umax_8_release>>  =>  (LDUMAXLB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3730,
        GIR_Done,
      // Label 1054: @36418
      GIM_Try, /*On fail goto*//*Label 1055*/ 36469, // Rule ID 3731 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_8>><<P:Predicate_atomic_load_umax_8_acq_rel>>  =>  (LDUMAXALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3731,
        GIR_Done,
      // Label 1055: @36469
      GIM_Try, /*On fail goto*//*Label 1056*/ 36520, // Rule ID 3732 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umax_8>><<P:Predicate_atomic_load_umax_8_seq_cst>>  =>  (LDUMAXALB:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXALB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3732,
        GIR_Done,
      // Label 1056: @36520
      GIM_Reject,
    // Label 1041: @36521
    GIM_Reject,
    // Label 1039: @36522
    GIM_Try, /*On fail goto*//*Label 1057*/ 36768,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_Try, /*On fail goto*//*Label 1058*/ 36579, // Rule ID 3713 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_monotonic>>  =>  (LDUMAXX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3713,
        GIR_Done,
      // Label 1058: @36579
      GIM_Try, /*On fail goto*//*Label 1059*/ 36626, // Rule ID 3714 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_acquire>>  =>  (LDUMAXAX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3714,
        GIR_Done,
      // Label 1059: @36626
      GIM_Try, /*On fail goto*//*Label 1060*/ 36673, // Rule ID 3715 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_release>>  =>  (LDUMAXLX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3715,
        GIR_Done,
      // Label 1060: @36673
      GIM_Try, /*On fail goto*//*Label 1061*/ 36720, // Rule ID 3716 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_acq_rel>>  =>  (LDUMAXALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3716,
        GIR_Done,
      // Label 1061: @36720
      GIM_Try, /*On fail goto*//*Label 1062*/ 36767, // Rule ID 3717 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_seq_cst>>  =>  (LDUMAXALX:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMAXALX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3717,
        GIR_Done,
      // Label 1062: @36767
      GIM_Reject,
    // Label 1057: @36768
    GIM_Reject,
    // Label 1040: @36769
    GIM_Reject,
    // Label 23: @36770
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1065*/ 37798,
    /*GILLT_s32*//*Label 1063*/ 36778,
    /*GILLT_s64*//*Label 1064*/ 37551,
    // Label 1063: @36778
    GIM_Try, /*On fail goto*//*Label 1066*/ 37550,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1067*/ 36835, // Rule ID 3738 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_monotonic>>  =>  (LDUMINW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMINW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3738,
        GIR_Done,
      // Label 1067: @36835
      GIM_Try, /*On fail goto*//*Label 1068*/ 36886, // Rule ID 3739 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_acquire>>  =>  (LDUMINAW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMINAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3739,
        GIR_Done,
      // Label 1068: @36886
      GIM_Try, /*On fail goto*//*Label 1069*/ 36937, // Rule ID 3740 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_release>>  =>  (LDUMINLW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMINLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3740,
        GIR_Done,
      // Label 1069: @36937
      GIM_Try, /*On fail goto*//*Label 1070*/ 36988, // Rule ID 3741 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_acq_rel>>  =>  (LDUMINALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMINALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3741,
        GIR_Done,
      // Label 1070: @36988
      GIM_Try, /*On fail goto*//*Label 1071*/ 37039, // Rule ID 3742 //
        GIM_CheckFeatures, GIFBS_HasLSE,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, GPR32:{ *:[i32] }:$Rm)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_seq_cst>>  =>  (LDUMINALW:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, GPR64sp:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::LDUMINALW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3742,
        GIR_Done,
      // Labe