M = Manifold(3, 'M')
X = M.chart('x1 x2 x3'); x1, x2, x3 = X[:]
D = X.symbolic_velocities()
eqns = [D[1], -D[0], 0]
p = M.point((0,0,0), name='p')
Tp = M.tangent_space(p)
v = Tp((1,0,1))
t = var('t')
c = M.integrated_curve(eqns, D, (t, 0, 6), v, name='c')
sol = c.solve()
interp = c.interpolate()
c_plot_2d_1 = c.plot_integrated(ambient_coords=[x1, x2],
                thickness=2.5,
                display_tangent=True, plot_points=200,
                plot_points_tangent=10, scale=0.5,
                color='blue', color_tangent='red')
sphinx_plot(c_plot_2d_1)