/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.command.HgResolveStatusEnum;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;

public class HgResolveCommand {
    private static final int ITEM_COUNT = 3;
    private final Project myProject;

    public HgResolveCommand(Project project) {
        this.myProject = project;
    }

    public Map<HgFile, HgResolveStatusEnum> getListSynchronously(VirtualFile repo) {
        if (repo == null) {
            return Collections.emptyMap();
        }
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.setSilent(true);
        HgCommandResult result = executor.executeInCurrentThread(repo, "resolve", Collections.singletonList("--list"));
        if (result == null) {
            return Collections.emptyMap();
        }
        return HgResolveCommand.handleResult(repo, result);
    }

    public void getListAsynchronously(final VirtualFile repo, final Consumer<Map<HgFile, HgResolveStatusEnum>> resultHandler) {
        if (repo == null) {
            resultHandler.consume(Collections.emptyMap());
        }
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.setSilent(true);
        executor.execute(repo, "resolve", Collections.singletonList("--list"), new HgCommandResultHandler(){

            @Override
            public void process(@Nullable HgCommandResult result) {
                if (result == null) {
                    resultHandler.consume(Collections.emptyMap());
                }
                Map resolveStatus = HgResolveCommand.handleResult(repo, result);
                resultHandler.consume((Object)resolveStatus);
            }
        });
    }

    private static Map<HgFile, HgResolveStatusEnum> handleResult(VirtualFile repo, HgCommandResult result) {
        HashMap<HgFile, HgResolveStatusEnum> resolveStatus = new HashMap<HgFile, HgResolveStatusEnum>();
        for (String line : result.getOutputLines()) {
            HgResolveStatusEnum status;
            if (StringUtil.isEmptyOrSpaces((String)line) || line.length() < 3 || (status = HgResolveStatusEnum.valueOf(line.charAt(0))) == null) continue;
            File ioFile = new File(repo.getPath(), line.substring(2));
            resolveStatus.put(new HgFile(repo, ioFile), status);
        }
        return resolveStatus;
    }

    public void markResolved(@NotNull VirtualFile repo, @NotNull VirtualFile path) {
        if (repo == null) {
            HgResolveCommand.$$$reportNull$$$0(0);
        }
        if (path == null) {
            HgResolveCommand.$$$reportNull$$$0(1);
        }
        this.markResolved(repo, Collections.singleton(VcsUtil.getFilePath((VirtualFile)path)));
    }

    public void markResolved(@NotNull VirtualFile repo, @NotNull Collection<FilePath> paths) {
        if (repo == null) {
            HgResolveCommand.$$$reportNull$$$0(2);
        }
        if (paths == null) {
            HgResolveCommand.$$$reportNull$$$0(3);
        }
        for (List chunk : VcsFileUtil.chunkPaths((VirtualFile)repo, paths)) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--mark");
            args.addAll(chunk);
            new HgCommandExecutor(this.myProject).execute(repo, "resolve", args, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "repo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "path";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "paths";
                break;
            }
        }
        objectArray[1] = "org/zmlx/hg4idea/command/HgResolveCommand";
        objectArray[2] = "markResolved";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

