/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.events.impl;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartBuildEventImpl
extends StartEventImpl
implements StartBuildEvent {
    private final String myBuildTitle;
    private final String myWorkingDir;
    @Nullable
    private BuildProcessHandler myProcessHandler;
    private Consumer<ConsoleView> myAttachedConsoleConsumer;
    @NotNull
    private final List<AnAction> myRestartActions;
    @NotNull
    private final List<Filter> myFilters;
    @Nullable
    private ExecutionEnvironment myExecutionEnvironment;
    @Nullable
    private Supplier<RunContentDescriptor> myContentDescriptorSupplier;

    public StartBuildEventImpl(@NotNull BuildDescriptor descriptor, @NotNull String message) {
        if (descriptor == null) {
            StartBuildEventImpl.$$$reportNull$$$0(0);
        }
        if (message == null) {
            StartBuildEventImpl.$$$reportNull$$$0(1);
        }
        super(descriptor.getId(), null, descriptor.getStartTime(), message);
        this.myRestartActions = new SmartList();
        this.myFilters = new SmartList();
        this.myBuildTitle = descriptor.getTitle();
        this.myWorkingDir = descriptor.getWorkingDir();
    }

    public String getBuildTitle() {
        return this.myBuildTitle;
    }

    @NotNull
    public String getWorkingDir() {
        String string = this.myWorkingDir;
        if (string == null) {
            StartBuildEventImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public BuildProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Nullable
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.myExecutionEnvironment;
    }

    @NotNull
    public AnAction[] getRestartActions() {
        AnAction[] anActionArray = this.myRestartActions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            StartBuildEventImpl.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    @NotNull
    public Filter[] getExecutionFilters() {
        Filter[] filterArray = this.myFilters.toArray(Filter.EMPTY_ARRAY);
        if (filterArray == null) {
            StartBuildEventImpl.$$$reportNull$$$0(4);
        }
        return filterArray;
    }

    @Nullable
    public Supplier<RunContentDescriptor> getContentDescriptorSupplier() {
        return this.myContentDescriptorSupplier;
    }

    @Nullable
    public Consumer<ConsoleView> getAttachedConsoleConsumer() {
        return this.myAttachedConsoleConsumer;
    }

    public StartBuildEventImpl withProcessHandler(@Nullable BuildProcessHandler processHandler2, @Nullable Consumer<ConsoleView> attachedConsoleConsumer) {
        this.myProcessHandler = processHandler2;
        this.myAttachedConsoleConsumer = attachedConsoleConsumer;
        return this;
    }

    public StartBuildEventImpl withRestartAction(@NotNull AnAction anAction) {
        if (anAction == null) {
            StartBuildEventImpl.$$$reportNull$$$0(5);
        }
        this.myRestartActions.add(anAction);
        return this;
    }

    public StartBuildEventImpl withRestartActions(AnAction ... actions) {
        this.myRestartActions.addAll(Arrays.asList(actions));
        return this;
    }

    public StartBuildEventImpl withExecutionEnvironment(ExecutionEnvironment env) {
        this.myExecutionEnvironment = env;
        return this;
    }

    public StartBuildEventImpl withContentDescriptorSupplier(Supplier<RunContentDescriptor> contentDescriptorSupplier) {
        this.myContentDescriptorSupplier = contentDescriptorSupplier;
        return this;
    }

    public StartBuildEventImpl withExecutionFilter(@NotNull Filter filter) {
        if (filter == null) {
            StartBuildEventImpl.$$$reportNull$$$0(6);
        }
        this.myFilters.add(filter);
        return this;
    }

    public StartBuildEventImpl withExecutionFilters(Filter ... filters) {
        this.myFilters.addAll(Arrays.asList(filters));
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/events/impl/StartBuildEventImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/events/impl/StartBuildEventImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDir";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withRestartAction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withExecutionFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

