/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ContributorSearchResult<T> {
    private final List<T> items;
    private final boolean hasMoreItems;

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static <E> ContributorSearchResult<E> empty() {
        return new ContributorSearchResult(Collections.emptyList(), false);
    }

    public ContributorSearchResult(List<T> items, boolean hasMoreItems) {
        this.items = items;
        this.hasMoreItems = hasMoreItems;
    }

    public ContributorSearchResult(List<T> items) {
        this(items, false);
    }

    public List<T> getItems() {
        return this.items;
    }

    public boolean hasMoreItems() {
        return this.hasMoreItems;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public static class Builder<T> {
        private final Set<T> items = new LinkedHashSet<T>();
        private boolean hasMore;

        public void addItem(T item) {
            this.items.add(item);
        }

        public void setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
        }

        public int itemsCount() {
            return this.items.size();
        }

        public ContributorSearchResult<T> build() {
            List<T> list = Collections.unmodifiableList(new ArrayList<T>(this.items));
            return new ContributorSearchResult<T>(list, this.hasMore);
        }
    }
}

