/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitHttpAuthService;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitNativeSshGuiAuthenticator;
import git4idea.commands.GitPassthroughAuthenticationGate;
import git4idea.commands.GitSSHGUIHandler;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersionSpecialty;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.ssh.GitXmlRpcNativeSshService;
import org.jetbrains.git4idea.ssh.GitXmlRpcSshService;

public class GitHandlerAuthenticationManager
implements AutoCloseable {
    private static final Logger LOG = Logger.getInstance(GitHandlerAuthenticationManager.class);
    @NotNull
    private final GitLineHandler myHandler;
    @NotNull
    private final Project myProject;
    @Nullable
    private UUID myHttpHandler;
    private volatile boolean myHttpAuthFailed;
    @Nullable
    private UUID mySshHandler;
    @Nullable
    private UUID myNativeSshHandler;

    private GitHandlerAuthenticationManager(@NotNull Project project, @NotNull GitLineHandler handler) {
        if (project == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myHandler = handler;
    }

    @NotNull
    public static GitHandlerAuthenticationManager prepare(@NotNull Project project, @NotNull GitLineHandler handler) throws IOException {
        if (project == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(3);
        }
        GitHandlerAuthenticationManager manager = new GitHandlerAuthenticationManager(project, handler);
        manager.prepareHttpAuth();
        if (GitVcsApplicationSettings.getInstance().isUseIdeaSsh()) {
            manager.prepareSshAuth();
        } else if (Registry.is((String)"git.ssh.native.override.ssh.askpass")) {
            manager.prepareNativeSshAuth();
        }
        GitHandlerAuthenticationManager gitHandlerAuthenticationManager = manager;
        if (gitHandlerAuthenticationManager == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(4);
        }
        return gitHandlerAuthenticationManager;
    }

    @Override
    public void close() {
        this.cleanupHttpAuth();
        this.cleanupSshAuth();
        this.cleanupNativeSshAuth();
    }

    private void prepareHttpAuth() throws IOException {
        GitHttpAuthService service = (GitHttpAuthService)ServiceManager.getService(GitHttpAuthService.class);
        this.myHandler.addCustomEnvironmentVariable("GIT_ASKPASS", service.getScriptPath().getPath());
        GitAuthenticationGate authenticationGate = (GitAuthenticationGate)ObjectUtils.notNull((Object)this.myHandler.getAuthenticationGate(), (Object)GitPassthroughAuthenticationGate.getInstance());
        final GitHttpAuthenticator httpAuthenticator = service.createAuthenticator(this.myProject, this.myHandler.getUrls(), authenticationGate, this.myHandler.isIgnoreAuthenticationRequest());
        this.myHttpHandler = service.registerHandler(httpAuthenticator, (Disposable)this.myProject);
        this.myHandler.addCustomEnvironmentVariable("GIT_ASKPASS_HANDLER", this.myHttpHandler.toString());
        int port = service.getXmlRcpPort();
        this.myHandler.addCustomEnvironmentVariable("GIT_ASKPASS_PORT", Integer.toString(port));
        LOG.debug(String.format("myHandler=%s, port=%s", this.myHttpHandler, port));
        this.myHandler.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(@NonNls String line, Key outputType) {
                String lowerCaseLine = line.toLowerCase();
                if (lowerCaseLine.contains("authentication failed") || lowerCaseLine.contains("403 forbidden") || lowerCaseLine.contains("error: 400") || lowerCaseLine.contains("fatal: repository") && lowerCaseLine.contains("not found") || lowerCaseLine.contains("fatal: unable to access") && lowerCaseLine.contains("the requested url returned error: 403") || lowerCaseLine.contains("[remote rejected] (permission denied)")) {
                    LOG.debug("auth listener: auth failure detected: " + line);
                    GitHandlerAuthenticationManager.this.myHttpAuthFailed = true;
                }
            }

            public void processTerminated(int exitCode) {
                LOG.debug("auth listener: process terminated. auth failed=" + GitHandlerAuthenticationManager.this.myHttpAuthFailed + ", cancelled=" + httpAuthenticator.wasCancelled());
                if (!httpAuthenticator.wasCancelled()) {
                    if (GitHandlerAuthenticationManager.this.myHttpAuthFailed) {
                        httpAuthenticator.forgetPassword();
                    } else {
                        httpAuthenticator.saveAuthData();
                    }
                } else {
                    GitHandlerAuthenticationManager.this.myHttpAuthFailed = false;
                }
            }
        });
    }

    private void cleanupHttpAuth() {
        if (this.myHttpHandler != null) {
            ((GitHttpAuthService)ServiceManager.getService(GitHttpAuthService.class)).unregisterHandler(this.myHttpHandler);
            this.myHttpHandler = null;
        }
    }

    public boolean isHttpAuthFailed() {
        return this.myHttpAuthFailed;
    }

    private void prepareSshAuth() throws IOException {
        GitXmlRpcSshService ssh = (GitXmlRpcSshService)ServiceManager.getService(GitXmlRpcSshService.class);
        this.myHandler.addCustomEnvironmentVariable("GIT_SSH", ssh.getScriptPath().getPath());
        this.myHandler.addCustomEnvironmentVariable("GIT_SSH_VARIANT", "ssh");
        GitAuthenticationGate authenticationGate = (GitAuthenticationGate)ObjectUtils.notNull((Object)this.myHandler.getAuthenticationGate(), (Object)GitPassthroughAuthenticationGate.getInstance());
        GitSSHGUIHandler guiHandler = new GitSSHGUIHandler(this.myProject, authenticationGate, this.myHandler.isIgnoreAuthenticationRequest());
        this.mySshHandler = ssh.registerHandler(guiHandler, (Disposable)this.myProject);
        this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_HANDLER", this.mySshHandler.toString());
        int port = ssh.getXmlRcpPort();
        this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_PORT", Integer.toString(port));
        LOG.debug(String.format("myHandler=%s, port=%s", this.mySshHandler, port));
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        boolean useHttpProxy = httpConfigurable.USE_HTTP_PROXY && !GitHandlerAuthenticationManager.isSshUrlExcluded(httpConfigurable, this.myHandler.getUrls());
        this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_USE_PROXY", String.valueOf(useHttpProxy));
        if (useHttpProxy) {
            this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_PROXY_HOST", StringUtil.notNullize((String)httpConfigurable.PROXY_HOST));
            this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_PROXY_PORT", String.valueOf(httpConfigurable.PROXY_PORT));
            boolean proxyAuthentication = httpConfigurable.PROXY_AUTHENTICATION;
            this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_PROXY_AUTHENTICATION", String.valueOf(proxyAuthentication));
            if (proxyAuthentication) {
                this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_PROXY_USER", StringUtil.notNullize((String)httpConfigurable.getProxyLogin()));
                this.myHandler.addCustomEnvironmentVariable("GIT4IDEA_SSH_PROXY_PASSWORD", StringUtil.notNullize((String)httpConfigurable.getPlainProxyPassword()));
            }
        }
    }

    private void cleanupSshAuth() {
        if (this.mySshHandler != null) {
            ((GitXmlRpcSshService)ServiceManager.getService(GitXmlRpcSshService.class)).unregisterHandler(this.mySshHandler);
            this.mySshHandler = null;
        }
    }

    private void prepareNativeSshAuth() throws IOException {
        GitXmlRpcNativeSshService service = (GitXmlRpcNativeSshService)ServiceManager.getService(GitXmlRpcNativeSshService.class);
        boolean doNotRememberPasswords = this.myHandler.getUrls().size() > 1;
        GitAuthenticationGate authenticationGate = (GitAuthenticationGate)ObjectUtils.notNull((Object)this.myHandler.getAuthenticationGate(), (Object)GitPassthroughAuthenticationGate.getInstance());
        GitNativeSshGuiAuthenticator authenticator = new GitNativeSshGuiAuthenticator(this.myProject, authenticationGate, this.myHandler.isIgnoreAuthenticationRequest(), doNotRememberPasswords);
        this.myNativeSshHandler = service.registerHandler(authenticator, (Disposable)this.myProject);
        int port = service.getXmlRcpPort();
        boolean useBatchFile = SystemInfo.isWindows && (!Registry.is((String)"git.use.shell.script.on.windows") || !GitVersionSpecialty.CAN_USE_SHELL_HELPER_SCRIPT_ON_WINDOWS.existsIn(this.myProject));
        this.myHandler.addCustomEnvironmentVariable("SSH_ASKPASS", service.getScriptPath(useBatchFile).getPath());
        this.myHandler.addCustomEnvironmentVariable("INTELLIJ_SSH_ASKPASS_HANDLER", this.myNativeSshHandler.toString());
        this.myHandler.addCustomEnvironmentVariable("INTELLIJ_SSH_ASKPASS_PORT", Integer.toString(port));
        LOG.debug(String.format("myHandler=%s, port=%s", this.myNativeSshHandler, port));
        String displayEnv = StringUtil.nullize((String)System.getenv("DISPLAY"));
        this.myHandler.addCustomEnvironmentVariable("DISPLAY", StringUtil.notNullize((String)displayEnv, (String)":0.0"));
        if (Registry.is((String)"git.use.setsid.for.native.ssh")) {
            this.myHandler.withNoTty();
        }
    }

    private void cleanupNativeSshAuth() {
        if (this.myNativeSshHandler != null) {
            ((GitXmlRpcNativeSshService)ServiceManager.getService(GitXmlRpcNativeSshService.class)).unregisterHandler(this.myNativeSshHandler);
            this.myNativeSshHandler = null;
        }
    }

    private static boolean isSshUrlExcluded(@NotNull HttpConfigurable httpConfigurable, @NotNull Collection<String> urls) {
        if (httpConfigurable == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(5);
        }
        if (urls == null) {
            GitHandlerAuthenticationManager.$$$reportNull$$$0(6);
        }
        return ContainerUtil.exists(urls, url -> {
            String host = URLUtil.parseHostFromSshUrl((String)url);
            return httpConfigurable.isProxyException(host);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitHandlerAuthenticationManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpConfigurable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitHandlerAuthenticationManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepare";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSshUrlExcluded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

