/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.preference;

import javafx.scene.control.RadioButton;
import org.pdfsam.context.BooleanUserPreference;
import org.pdfsam.context.UserContext;
import org.pdfsam.support.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreferenceRadioButton
extends RadioButton {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceRadioButton.class);
    private final BooleanUserPreference preference;

    PreferenceRadioButton(BooleanUserPreference preference, String label, boolean selected, UserContext userContext) {
        super(label);
        RequireUtils.requireNotNull((Object)preference, (String)"Preference cannot be null");
        RequireUtils.requireNotNull((Object)userContext, (String)"UserContext cannot be null");
        this.setSelected(selected);
        this.preference = preference;
        this.selectedProperty().addListener((ov, oldVal, newVal) -> {
            userContext.setBooleanPreference(this.preference, newVal.booleanValue());
            LOG.trace("Preference {} set to {}", (Object)this.preference, newVal);
        });
    }
}

