/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.util.Arrays;
import java.util.LinkedList;
import org.sejda.conversion.AdapterUtils;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.RectangularBox;
import org.sejda.model.exception.SejdaRuntimeException;

public class RectangularBoxAdapter {
    private static final int INDEX_OF_BOTTOM_TOKEN = 0;
    private static final int INDEX_OF_LEFT_TOKEN = 1;
    private static final int INDEX_OF_TOP_TOKEN = 2;
    private static final int INDEX_OF_RIGHT_TOKEN = 3;
    private static final int MIN_TOKENS = 4;
    private RectangularBox rectangularBox;

    public RectangularBoxAdapter(String input) {
        try {
            this.doParse(input);
        }
        catch (SejdaRuntimeException e) {
            throw new ConversionException("Unparsable rectangular box: '" + input + "'. " + e.getMessage(), e);
        }
    }

    private void doParse(String input) {
        String[] tokens = this.doubleSplit(input.replaceFirst("^\\[", "").replaceFirst("\\]$", ""), "\\]\\[", ":");
        if (tokens.length < 4) {
            throw new ConversionException("Expected format is: '[bottom:left][top:right]'");
        }
        int bottom = AdapterUtils.parseInt(tokens[0], "bottom");
        int left = AdapterUtils.parseInt(tokens[1], "left");
        int top = AdapterUtils.parseInt(tokens[2], "top");
        int right = AdapterUtils.parseInt(tokens[3], "right");
        this.rectangularBox = RectangularBox.newInstance((int)bottom, (int)left, (int)top, (int)right);
    }

    private String[] doubleSplit(String input, String firstDelimter, String secondDelimiter) {
        return this.splitStrings(this.splitStrings(new String[]{input}, firstDelimter), secondDelimiter);
    }

    private String[] splitStrings(String[] inputs, String delimiter) {
        LinkedList<String> result = new LinkedList<String>();
        for (String eachInput : inputs) {
            String[] newTokens = eachInput.split(delimiter);
            result.addAll(Arrays.asList(newTokens));
        }
        return result.toArray(new String[result.size()]);
    }

    public final RectangularBox getRectangularBox() {
        return this.rectangularBox;
    }
}

