/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer.ui;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class FixDescription {
    private final ErrorDescription err;
    private final Fix fix;
    private boolean selected;
    private final AtomicBoolean fixed = new AtomicBoolean();
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    public FixDescription(ErrorDescription err, Fix fix) {
        this.err = err;
        this.fix = fix;
    }

    public boolean isSelected() {
        return this.selected && !this.fixed.get();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.cs.fireChange();
    }

    public String getText() {
        return this.fix.getText();
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    public void implement() throws Exception {
        FileObject file = this.err.getFile();
        if (!file.canWrite()) {
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(FixDescription.class, (String)"CTL_File_Not_Writable", (Object)file.getNameExt()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            return;
        }
        this.fix.implement();
        this.fixed.set(true);
        this.cs.fireChange();
    }

    public boolean isFixed() {
        return this.fixed.get();
    }

    public ErrorDescription getErrors() {
        return this.err;
    }
}

