/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.graalsdk.impl;

import java.io.Reader;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.netbeans.libs.graalsdk.impl.GraalContext;
import org.netbeans.libs.graalsdk.impl.GraalEngineFactory;

final class GraalEngine
implements ScriptEngine,
Invocable {
    private final GraalEngineFactory factory;

    GraalEngine(GraalEngineFactory f) {
        this.factory = f;
    }

    private String id() {
        return this.factory.id;
    }

    @Override
    public GraalContext getContext() {
        return this.factory.ctx;
    }

    @Override
    public GraalEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object eval(String src, ScriptContext arg1) throws ScriptException {
        Value result = this.evalImpl(arg1, src);
        return this.unbox(result);
    }

    private Value evalImpl(ScriptContext arg1, String src) throws ScriptException {
        try {
            return ((GraalContext)arg1).ctx().eval(this.id(), src);
        }
        catch (PolyglotException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object eval(Reader arg0, ScriptContext arg1) throws ScriptException {
        Source src = Source.newBuilder(this.id(), arg0, null).buildLiteral();
        Value result = ((GraalContext)arg1).ctx().eval(src);
        return this.unbox(result);
    }

    @Override
    public Object eval(String arg0) throws ScriptException {
        return this.eval(arg0, (ScriptContext)this.factory.ctx);
    }

    @Override
    public Object eval(Reader arg0) throws ScriptException {
        return this.eval(arg0, (ScriptContext)this.factory.ctx);
    }

    @Override
    public Object eval(String arg0, Bindings arg1) throws ScriptException {
        throw new ScriptException("Cannot use alternative bindings!");
    }

    @Override
    public Object eval(Reader arg0, Bindings arg1) throws ScriptException {
        throw new ScriptException("Cannot use alternative bindings!");
    }

    @Override
    public void put(String arg0, Object arg1) {
    }

    @Override
    public Object get(String arg0) {
        return null;
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.getContext().getBindings(scope);
    }

    @Override
    public void setBindings(Bindings arg0, int arg1) {
    }

    @Override
    public Bindings createBindings() {
        return null;
    }

    @Override
    public void setContext(ScriptContext arg0) {
        throw new IllegalStateException();
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (!(thiz instanceof Value)) {
            throw new IllegalArgumentException();
        }
        Value thisValue = (Value)thiz;
        Value fn = thisValue.getMember(name);
        if (!fn.canExecute()) {
            throw new NoSuchMethodException(name);
        }
        Value result = fn.execute(args);
        return this.unbox(result);
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        Value fn = this.evalImpl(this.getContext(), name);
        Value result = fn.execute(args);
        return this.unbox(result);
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        return this.getInterface(this.getContext().ctx().getPolyglotBindings(), clasz);
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (thiz instanceof Value) {
            return ((Value)thiz).as(clasz);
        }
        if (clasz.isInstance(thiz)) {
            return clasz.cast(thiz);
        }
        return null;
    }

    private Object unbox(Value result) {
        if (result.isNull()) {
            return null;
        }
        if (result.isNumber()) {
            return result.as(Number.class);
        }
        if (result.isString()) {
            return result.as(String.class);
        }
        return result;
    }
}

