/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.nb.indexing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.parsing.impl.indexing.implspi.ActiveDocumentProvider;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class NbActiveDocumentProvider
implements ActiveDocumentProvider,
PropertyChangeListener {
    private final AtomicBoolean listens = new AtomicBoolean();
    private final List<ActiveDocumentProvider.ActiveDocumentListener> listeners = new CopyOnWriteArrayList<ActiveDocumentProvider.ActiveDocumentListener>();
    private Reference<JTextComponent> activeComponentRef;

    @CheckForNull
    public Document getActiveDocument() {
        JTextComponent last = EditorRegistry.lastFocusedComponent();
        return last == null ? null : last.getDocument();
    }

    public Set<? extends Document> getActiveDocuments() {
        Set res = Collections.newSetFromMap(new IdentityHashMap());
        for (JTextComponent jtc : EditorRegistry.componentList()) {
            Document doc = jtc.getDocument();
            if (doc == null) continue;
            res.add(doc);
        }
        return res;
    }

    public void addActiveDocumentListener(@NonNull ActiveDocumentProvider.ActiveDocumentListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.attachListener();
        this.listeners.add(listener);
    }

    public void removeActiveDocumentListener(@NonNull ActiveDocumentProvider.ActiveDocumentListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.remove(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        assert (SwingUtilities.isEventDispatchThread()) : "Changes in focused editor component should be delivered on AWT";
        Document deactivate = null;
        Document activate = null;
        List<JTextComponent> components = Collections.emptyList();
        boolean steady = false;
        String propName = evt.getPropertyName();
        if (propName == null) {
            components = EditorRegistry.componentList();
        } else if (propName.equals("focusLost") || propName.equals("lastFocusedRemoved")) {
            Object newValue;
            if (evt.getOldValue() instanceof JTextComponent && (!((newValue = evt.getNewValue()) instanceof JTextComponent) || ((JTextComponent)newValue).getClientProperty("AsTextField") == null)) {
                deactivate = ((JTextComponent)evt.getOldValue()).getDocument();
            }
        } else if (propName.equals("componentRemoved")) {
            if (evt.getOldValue() instanceof JTextComponent) {
                JTextComponent jtc = (JTextComponent)evt.getOldValue();
                components = Collections.singletonList(jtc);
                steady = true;
            }
        } else if (propName.equals("focusGained")) {
            JTextComponent jtc;
            if (evt.getNewValue() instanceof JTextComponent && (jtc = (JTextComponent)evt.getNewValue()).getClientProperty("AsTextField") == null) {
                JTextComponent activeComponent;
                activate = jtc.getDocument();
                JTextComponent jTextComponent = activeComponent = this.activeComponentRef == null ? null : this.activeComponentRef.get();
                if (activeComponent != jtc) {
                    if (activeComponent != null) {
                        components = Collections.singletonList(activeComponent);
                    }
                    this.activeComponentRef = new WeakReference<JTextComponent>(jtc);
                }
            }
        } else if (propName.equals("focusedDocument")) {
            JTextComponent jtc = EditorRegistry.focusedComponent();
            if (jtc == null) {
                jtc = EditorRegistry.lastFocusedComponent();
            }
            if (jtc != null) {
                components = Collections.singletonList(jtc);
            }
            deactivate = (Document)evt.getOldValue();
            activate = (Document)evt.getNewValue();
        }
        this.fire(deactivate, activate, NbActiveDocumentProvider.map(components, new F<JTextComponent, Document>(){

            @Override
            public Document apply(JTextComponent jtc) {
                return jtc.getDocument();
            }
        }), steady);
    }

    private void attachListener() {
        if (this.listens.compareAndSet(false, true)) {
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, EditorRegistry.class));
        }
    }

    private void fire(@NullAllowed Document deactivated, @NullAllowed Document activated, @NonNull Collection<? extends Document> toRefresh, boolean steady) {
        ActiveDocumentProvider.ActiveDocumentEvent event = new ActiveDocumentProvider.ActiveDocumentEvent((ActiveDocumentProvider)this, deactivated, activated, toRefresh, steady);
        for (ActiveDocumentProvider.ActiveDocumentListener l : this.listeners) {
            l.activeDocumentChanged(event);
        }
    }

    private static <P, R> Collection<? extends R> map(@NonNull Collection<? extends P> elements, @NonNull F<? super P, ? extends R> fnc) {
        ArrayList<R> result = new ArrayList<R>(elements.size());
        for (P p : elements) {
            result.add(fnc.apply(p));
        }
        return result;
    }

    private static interface F<P, R> {
        public R apply(P var1);
    }
}

