/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.spi.ui;

import javax.swing.Action;
import javax.swing.JEditorPane;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.spi.ui.JavaRefactoringGlobalAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.cookies.EditorCookie;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class JavaRefactoringActionDelegate {
    private final boolean requiresSelection;
    private final String name;

    protected JavaRefactoringActionDelegate(String name) {
        this(name, false);
    }

    protected JavaRefactoringActionDelegate(String name, boolean requiresSelection) {
        this.requiresSelection = requiresSelection;
        this.name = name;
    }

    public abstract RefactoringUI createRefactoringUI(TreePathHandle var1, int var2, int var3, CompilationInfo var4);

    public String getErrorMessage() {
        return NbBundle.getMessage(JavaRefactoringActionDelegate.class, (String)"MSG_CANNOT_PERFORM", (Object)this.name);
    }

    public static Action createAction(JavaRefactoringActionDelegate delegate) {
        return new JavaRefactoringGlobalAction(delegate.name, delegate);
    }

    protected boolean isEnabled(Lookup context) {
        EditorCookie ck = JavaRefactoringGlobalAction.getEditorCookie(context);
        boolean result = false;
        if (ck != null) {
            JEditorPane pane = NbDocument.findRecentEditorPane((EditorCookie)ck);
            boolean bl = result = pane != null;
            if (this.requiresSelection) {
                result = result && pane.getSelectionStart() != pane.getSelectionEnd();
            }
        }
        return result;
    }
}

