/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api;

import java.io.IOException;
import java.util.Properties;
import org.netbeans.modules.profiler.spi.ProfilerStorageProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class ProfilerStorage {
    public static FileObject getGlobalFolder(boolean create) throws IOException {
        ProfilerStorageProvider p = ProfilerStorage.provider();
        if (p != null) {
            return p.getGlobalFolder(create);
        }
        return null;
    }

    public static void loadGlobalProperties(Properties properties, String filename) throws IOException {
        ProfilerStorageProvider p = ProfilerStorage.provider();
        if (p != null) {
            p.loadGlobalProperties(properties, filename);
        }
    }

    public static void saveGlobalProperties(Properties properties, String filename) throws IOException {
        ProfilerStorageProvider p = ProfilerStorage.provider();
        if (p != null) {
            p.saveGlobalProperties(properties, filename);
        }
    }

    public static void deleteGlobalProperties(String filename) throws IOException {
        ProfilerStorageProvider p = ProfilerStorage.provider();
        if (p != null) {
            p.deleteGlobalProperties(filename);
        }
    }

    public static FileObject getProjectFolder(Lookup.Provider project, boolean create) throws IOException {
        if (project == null) {
            return ProfilerStorage.getGlobalFolder(create);
        }
        ProfilerStorageProvider p = ProfilerStorage.provider();
        if (p != null) {
            return p.getProjectFolder(project, create);
        }
        return null;
    }

    public static Lookup.Provider getProjectFromFolder(FileObject settingsFolder) {
        ProfilerStorageProvider p = ProfilerStorage.provider();
        if (p != null) {
            return p.getProjectFromFolder(settingsFolder);
        }
        return null;
    }

    public static void loadProjectProperties(Properties properties, Lookup.Provider project, String filename) throws IOException {
        if (project == null) {
            ProfilerStorage.loadGlobalProperties(properties, filename);
        } else {
            ProfilerStorageProvider p = ProfilerStorage.provider();
            if (p != null) {
                p.loadProjectProperties(properties, project, filename);
            }
        }
    }

    public static void saveProjectProperties(Properties properties, Lookup.Provider project, String filename) throws IOException {
        if (project == null) {
            ProfilerStorage.saveGlobalProperties(properties, filename);
        } else {
            ProfilerStorageProvider p = ProfilerStorage.provider();
            if (p != null) {
                p.saveProjectProperties(properties, project, filename);
            }
        }
    }

    public static void deleteProjectProperties(Lookup.Provider project, String filename) throws IOException {
        if (project == null) {
            ProfilerStorage.deleteGlobalProperties(filename);
        } else {
            ProfilerStorageProvider p = ProfilerStorage.provider();
            if (p != null) {
                p.deleteProjectProperties(project, filename);
            }
        }
    }

    private static ProfilerStorageProvider provider() {
        return (ProfilerStorageProvider)Lookup.getDefault().lookup(ProfilerStorageProvider.class);
    }
}

