/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.util.List;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.SchemaReference;
import org.netbeans.modules.xml.axi.impl.AXIComponentCreator;
import org.netbeans.modules.xml.axi.impl.AXIDocumentImpl;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.axi.impl.AbstractModelBuilder;
import org.netbeans.modules.xml.axi.impl.Util;
import org.netbeans.modules.xml.schema.model.All;
import org.netbeans.modules.xml.schema.model.AnyAttribute;
import org.netbeans.modules.xml.schema.model.AnyElement;
import org.netbeans.modules.xml.schema.model.AttributeGroupReference;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.Choice;
import org.netbeans.modules.xml.schema.model.ComplexContent;
import org.netbeans.modules.xml.schema.model.ComplexExtension;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GroupReference;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.Include;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalComplexType;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.Sequence;
import org.netbeans.modules.xml.schema.model.SimpleContent;
import org.netbeans.modules.xml.schema.model.SimpleExtension;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

public class AXIModelBuilder
extends AbstractModelBuilder {
    private AXIComponent parent;
    private List<AXIComponent> children;

    public AXIModelBuilder(AXIComponent parent) {
        super((AXIModelImpl)parent.getModel());
        this.parent = parent;
    }

    public void populateChildren(SchemaComponent schemaComponent, boolean visitChildren, List<AXIComponent> children) {
        this.children = children;
        if (!visitChildren) {
            schemaComponent.accept((SchemaVisitor)this);
            return;
        }
        for (SchemaComponent child : schemaComponent.getChildren()) {
            child.accept((SchemaVisitor)this);
        }
    }

    @Override
    public void visit(Schema schema) {
    }

    @Override
    public void visit(AnyElement schemaComponent) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)schemaComponent, false);
        this.addChild(child);
    }

    @Override
    public void visit(AnyAttribute schemaComponent) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)schemaComponent, false);
        this.addChild(child);
    }

    @Override
    public void visit(GlobalElement component) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)component, true);
        this.addChild(child);
    }

    @Override
    public void visit(LocalElement component) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)component, false);
        this.addChild(child);
    }

    @Override
    public void visit(ElementReference component) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)component, false);
        this.addChild(child);
    }

    @Override
    public void visit(GlobalAttribute component) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)component, true);
        this.addChild(child);
    }

    @Override
    public void visit(LocalAttribute component) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)component, false);
        this.addChild(child);
    }

    @Override
    public void visit(AttributeReference component) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)component, false);
        this.addChild(child);
    }

    @Override
    public void visit(Sequence component) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)component, false);
        this.addChild(child);
    }

    @Override
    public void visit(Choice component) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)component, false);
        this.addChild(child);
    }

    @Override
    public void visit(All component) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)component, false);
        this.addChild(child);
    }

    @Override
    public void visit(GlobalGroup component) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)component, true);
        this.addChild(child);
    }

    @Override
    public void visit(GroupReference component) {
        NamedComponentReference ref = component.getRef();
        if (ref == null) {
            return;
        }
        SchemaComponent sc = this.model.getReferenceableSchemaComponent(ref);
        if (sc == null) {
            return;
        }
        AXIComponent child = this.getAXIComponent(sc, true);
        this.addChild(child);
    }

    @Override
    public void visit(GlobalAttributeGroup component) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)component, true);
        this.addChild(child);
    }

    @Override
    public void visit(AttributeGroupReference component) {
        NamedComponentReference ref = component.getGroup();
        if (ref == null) {
            return;
        }
        SchemaComponent sc = this.model.getReferenceableSchemaComponent(ref);
        if (sc == null) {
            return;
        }
        AXIComponent child = this.getAXIComponent(sc, true);
        this.addChild(child);
    }

    @Override
    public void visit(GlobalComplexType component) {
        AXIComponent child = this.getAXIComponent((SchemaComponent)component, true);
        this.addChild(child);
    }

    @Override
    public void visit(LocalComplexType component) {
        this.visitChildren((SchemaComponent)component);
    }

    @Override
    public void visit(ComplexContent component) {
        this.visitChildren((SchemaComponent)component);
    }

    @Override
    public void visit(SimpleContent component) {
        this.visitChildren((SchemaComponent)component);
    }

    @Override
    public void visit(SimpleExtension component) {
        SchemaComponent type;
        NamedComponentReference ref = component.getBase();
        if (ref != null && (type = this.model.getReferenceableSchemaComponent(ref)) != null) {
            AXIComponent child = this.getAXIComponent(type, true);
            this.addChild(child);
        }
        this.visitChildren((SchemaComponent)component);
    }

    @Override
    public void visit(ComplexExtension component) {
        SchemaComponent type;
        NamedComponentReference ref = component.getBase();
        if (ref != null && (type = this.model.getReferenceableSchemaComponent(ref)) != null) {
            AXIComponent child = this.getAXIComponent(type, true);
            this.addChild(child);
        }
        this.visitChildren((SchemaComponent)component);
    }

    public void visit(Include include) {
        SchemaReference ref = this.model.getComponentFactory().createSchemaReference((SchemaComponent)include);
        this.addChild(ref);
        this.visitChildren((SchemaComponent)include);
    }

    public void visit(Import im) {
        SchemaReference ref = this.model.getComponentFactory().createSchemaReference((SchemaComponent)im);
        this.addChild(ref);
        this.visitChildren((SchemaComponent)im);
    }

    private AXIComponent getAXIComponent(SchemaComponent schemaComponent, boolean isGlobal) {
        if (this.parent instanceof AXIDocument || !isGlobal) {
            return new AXIComponentCreator(this.getModel()).createNew(schemaComponent);
        }
        if (!this.getModel().fromSameSchemaModel(schemaComponent)) {
            return this.getModel().lookupFromOtherModel(schemaComponent);
        }
        return this.getModel().lookup(schemaComponent);
    }

    private void addChild(AXIComponent child) {
        if (child == null) {
            return;
        }
        if (this.parent instanceof AXIDocument) {
            this.children.add(child);
            ((AXIDocumentImpl)this.parent).addToCache(child);
            return;
        }
        if (child instanceof ContentModel) {
            Util.addProxyChildren(this.parent, child, this.children);
            return;
        }
        this.children.add(child);
    }
}

