module.exports = function () {
  "use strict";
  /*
   * Generated by PEG.js 0.9.0.
   *
   * http://pegjs.org/
   */

  function peg$subclass(child, parent) {
    function ctor() {
      this.constructor = child;
    }

    ctor.prototype = parent.prototype;
    child.prototype = new ctor();
  }

  function peg$SyntaxError(message, expected, found, location) {
    this.message = message;
    this.expected = expected;
    this.found = found;
    this.location = location;
    this.name = "SyntaxError";

    if (typeof Error.captureStackTrace === "function") {
      Error.captureStackTrace(this, peg$SyntaxError);
    }
  }

  peg$subclass(peg$SyntaxError, Error);

  function peg$parse(input) {
    var options = arguments.length > 1 ? arguments[1] : {},
        parser = this,
        peg$FAILED = {},
        peg$startRuleFunctions = {
      start: peg$parsestart
    },
        peg$startRuleFunction = peg$parsestart,
        peg$c0 = function peg$c0(query) {
      if (query.type === 'literal') {
        return addMeta(nodeTypes.function.buildNode('and', [query]), text(), location());
      }

      return query;
    },
        peg$c1 = /^[ \t\r\n]/,
        peg$c2 = {
      type: "class",
      value: "[\\ \\t\\r\\n]",
      description: "[\\ \\t\\r\\n]"
    },
        peg$c3 = function peg$c3(whitespace) {
      return addMeta(nodeTypes.function.buildNode('is', '*', '*', false), text(), location());
    },
        peg$c4 = "or",
        peg$c5 = {
      type: "literal",
      value: "or",
      description: "\"or\""
    },
        peg$c6 = function peg$c6(left, right) {
      return addMeta(nodeTypes.function.buildNode('or', [left, right]), text(), location());
    },
        peg$c7 = "and",
        peg$c8 = {
      type: "literal",
      value: "and",
      description: "\"and\""
    },
        peg$c9 = function peg$c9(left, right) {
      return addMeta(nodeTypes.function.buildNode('and', [left, right]), text(), location());
    },
        peg$c10 = /^[!]/,
        peg$c11 = {
      type: "class",
      value: "[!]",
      description: "[!]"
    },
        peg$c12 = function peg$c12(clause) {
      return addMeta(nodeTypes.function.buildNode('not', clause), text(), location());
    },
        peg$c13 = "(",
        peg$c14 = {
      type: "literal",
      value: "(",
      description: "\"(\""
    },
        peg$c15 = ")",
        peg$c16 = {
      type: "literal",
      value: ")",
      description: "\")\""
    },
        peg$c17 = function peg$c17(subQuery) {
      return subQuery;
    },
        peg$c18 = ":",
        peg$c19 = {
      type: "literal",
      value: ":",
      description: "\":\""
    },
        peg$c20 = function peg$c20(field, value) {
      return addMeta(nodeTypes.function.buildNodeWithArgumentNodes('is', [field, value, nodeTypes.literal.buildNode(true)]), text(), location());
    },
        peg$c21 = ":[",
        peg$c22 = {
      type: "literal",
      value: ":[",
      description: "\":[\""
    },
        peg$c23 = "to",
        peg$c24 = {
      type: "literal",
      value: "to",
      description: "\"to\""
    },
        peg$c25 = "]",
        peg$c26 = {
      type: "literal",
      value: "]",
      description: "\"]\""
    },
        peg$c27 = function peg$c27(field, gt, lt) {
      return addMeta(nodeTypes.function.buildNodeWithArgumentNodes('range', [field, gt, lt]), text(), location());
    },
        peg$c28 = function peg$c28(literal) {
      return literal;
    },
        peg$c29 = /^[a-zA-Z]/,
        peg$c30 = {
      type: "class",
      value: "[a-zA-Z]",
      description: "[a-zA-Z]"
    },
        peg$c31 = /^[.a-zA-Z0-9_\-]/,
        peg$c32 = {
      type: "class",
      value: "[.a-zA-Z0-9_-]",
      description: "[.a-zA-Z0-9_-]"
    },
        peg$c33 = function peg$c33(first, rest) {
      return first.join('') + rest.join('');
    },
        peg$c34 = {
      type: "other",
      description: "function"
    },
        peg$c35 = function peg$c35(name, arg_list) {
      return addMeta(nodeTypes.function.buildNodeWithArgumentNodes(name, arg_list || []), text(), location());
    },
        peg$c36 = ",",
        peg$c37 = {
      type: "literal",
      value: ",",
      description: "\",\""
    },
        peg$c38 = function peg$c38(first, arg) {
      return arg;
    },
        peg$c39 = function peg$c39(first, rest) {
      return [first].concat(rest);
    },
        peg$c40 = "=",
        peg$c41 = {
      type: "literal",
      value: "=",
      description: "\"=\""
    },
        peg$c42 = function peg$c42(name, value) {
      return addMeta(nodeTypes.namedArg.buildNode(name, value), text(), location());
    },
        peg$c43 = function peg$c43(element) {
      return element;
    },
        peg$c44 = function peg$c44(literal) {
      var result = addMeta(nodeTypes.literal.buildNode(literal), text(), location());
      return result;
    },
        peg$c45 = {
      type: "other",
      description: "literal"
    },
        peg$c46 = "\"",
        peg$c47 = {
      type: "literal",
      value: "\"",
      description: "\"\\\"\""
    },
        peg$c48 = function peg$c48(chars) {
      return chars.join('');
    },
        peg$c49 = "'",
        peg$c50 = {
      type: "literal",
      value: "'",
      description: "\"'\""
    },
        peg$c51 = "true",
        peg$c52 = {
      type: "literal",
      value: "true",
      description: "\"true\""
    },
        peg$c53 = function peg$c53() {
      return true;
    },
        peg$c54 = "false",
        peg$c55 = {
      type: "literal",
      value: "false",
      description: "\"false\""
    },
        peg$c56 = function peg$c56() {
      return false;
    },
        peg$c57 = "null",
        peg$c58 = {
      type: "literal",
      value: "null",
      description: "\"null\""
    },
        peg$c59 = function peg$c59() {
      return null;
    },
        peg$c60 = /^[^[\]()"',:= \t]/,
        peg$c61 = {
      type: "class",
      value: "[^\\[\\]()\"',:=\\ \\t]",
      description: "[^\\[\\]()\"',:=\\ \\t]"
    },
        peg$c62 = function peg$c62(string) {
      // this also matches numbers via Number()
      var result = string.join(''); // Sort of hacky, but PEG doesn't have backtracking so
      // a number rule is hard to read, and performs worse

      if (isNaN(Number(result))) return result;
      return Number(result);
    },
        peg$c63 = "\\",
        peg$c64 = {
      type: "literal",
      value: "\\",
      description: "\"\\\\\""
    },
        peg$c65 = function peg$c65(sequence) {
      return sequence;
    },
        peg$c66 = /^[^"]/,
        peg$c67 = {
      type: "class",
      value: "[^\"]",
      description: "[^\"]"
    },
        peg$c68 = /^[^']/,
        peg$c69 = {
      type: "class",
      value: "[^']",
      description: "[^']"
    },
        peg$c70 = /^[0-9]/,
        peg$c71 = {
      type: "class",
      value: "[0-9]",
      description: "[0-9]"
    },
        peg$c72 = function peg$c72(digits) {
      return parseInt(digits.join(''));
    },
        peg$currPos = 0,
        peg$savedPos = 0,
        peg$posDetailsCache = [{
      line: 1,
      column: 1,
      seenCR: false
    }],
        peg$maxFailPos = 0,
        peg$maxFailExpected = [],
        peg$silentFails = 0,
        peg$result;

    if ("startRule" in options) {
      if (!(options.startRule in peg$startRuleFunctions)) {
        throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
      }

      peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }

    function text() {
      return input.substring(peg$savedPos, peg$currPos);
    }

    function location() {
      return peg$computeLocation(peg$savedPos, peg$currPos);
    }

    function expected(description) {
      throw peg$buildException(null, [{
        type: "other",
        description: description
      }], input.substring(peg$savedPos, peg$currPos), peg$computeLocation(peg$savedPos, peg$currPos));
    }

    function error(message) {
      throw peg$buildException(message, null, input.substring(peg$savedPos, peg$currPos), peg$computeLocation(peg$savedPos, peg$currPos));
    }

    function peg$computePosDetails(pos) {
      var details = peg$posDetailsCache[pos],
          p,
          ch;

      if (details) {
        return details;
      } else {
        p = pos - 1;

        while (!peg$posDetailsCache[p]) {
          p--;
        }

        details = peg$posDetailsCache[p];
        details = {
          line: details.line,
          column: details.column,
          seenCR: details.seenCR
        };

        while (p < pos) {
          ch = input.charAt(p);

          if (ch === "\n") {
            if (!details.seenCR) {
              details.line++;
            }

            details.column = 1;
            details.seenCR = false;
          } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
            details.line++;
            details.column = 1;
            details.seenCR = true;
          } else {
            details.column++;
            details.seenCR = false;
          }

          p++;
        }

        peg$posDetailsCache[pos] = details;
        return details;
      }
    }

    function peg$computeLocation(startPos, endPos) {
      var startPosDetails = peg$computePosDetails(startPos),
          endPosDetails = peg$computePosDetails(endPos);
      return {
        start: {
          offset: startPos,
          line: startPosDetails.line,
          column: startPosDetails.column
        },
        end: {
          offset: endPos,
          line: endPosDetails.line,
          column: endPosDetails.column
        }
      };
    }

    function peg$fail(expected) {
      if (peg$currPos < peg$maxFailPos) {
        return;
      }

      if (peg$currPos > peg$maxFailPos) {
        peg$maxFailPos = peg$currPos;
        peg$maxFailExpected = [];
      }

      peg$maxFailExpected.push(expected);
    }

    function peg$buildException(message, expected, found, location) {
      function cleanupExpected(expected) {
        var i = 1;
        expected.sort(function (a, b) {
          if (a.description < b.description) {
            return -1;
          } else if (a.description > b.description) {
            return 1;
          } else {
            return 0;
          }
        });

        while (i < expected.length) {
          if (expected[i - 1] === expected[i]) {
            expected.splice(i, 1);
          } else {
            i++;
          }
        }
      }

      function buildMessage(expected, found) {
        function stringEscape(s) {
          function hex(ch) {
            return ch.charCodeAt(0).toString(16).toUpperCase();
          }

          return s.replace(/\\/g, '\\\\').replace(/"/g, '\\"').replace(/\x08/g, '\\b').replace(/\t/g, '\\t').replace(/\n/g, '\\n').replace(/\f/g, '\\f').replace(/\r/g, '\\r').replace(/[\x00-\x07\x0B\x0E\x0F]/g, function (ch) {
            return '\\x0' + hex(ch);
          }).replace(/[\x10-\x1F\x80-\xFF]/g, function (ch) {
            return '\\x' + hex(ch);
          }).replace(/[\u0100-\u0FFF]/g, function (ch) {
            return "\\u0" + hex(ch);
          }).replace(/[\u1000-\uFFFF]/g, function (ch) {
            return "\\u" + hex(ch);
          });
        }

        var expectedDescs = new Array(expected.length),
            expectedDesc,
            foundDesc,
            i;

        for (i = 0; i < expected.length; i++) {
          expectedDescs[i] = expected[i].description;
        }

        expectedDesc = expected.length > 1 ? expectedDescs.slice(0, -1).join(", ") + " or " + expectedDescs[expected.length - 1] : expectedDescs[0];
        foundDesc = found ? "\"" + stringEscape(found) + "\"" : "end of input";
        return "Expected " + expectedDesc + " but " + foundDesc + " found.";
      }

      if (expected !== null) {
        cleanupExpected(expected);
      }

      return new peg$SyntaxError(message !== null ? message : buildMessage(expected, found), expected, found, location);
    }

    function peg$parsestart() {
      var s0, s1, s2, s3;
      s0 = peg$currPos;
      s1 = peg$parsespace();

      if (s1 === peg$FAILED) {
        s1 = null;
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parseOrQuery();

        if (s2 !== peg$FAILED) {
          s3 = peg$parsespace();

          if (s3 === peg$FAILED) {
            s3 = null;
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c0(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = [];

        if (peg$c1.test(input.charAt(peg$currPos))) {
          s2 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c2);
          }
        }

        while (s2 !== peg$FAILED) {
          s1.push(s2);

          if (peg$c1.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c2);
            }
          }
        }

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c3(s1);
        }

        s0 = s1;
      }

      return s0;
    }

    function peg$parseOrQuery() {
      var s0, s1, s2, s3, s4, s5;
      s0 = peg$currPos;
      s1 = peg$parseAndQuery();

      if (s1 !== peg$FAILED) {
        s2 = peg$parsespace();

        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 2).toLowerCase() === peg$c4) {
            s3 = input.substr(peg$currPos, 2);
            peg$currPos += 2;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c5);
            }
          }

          if (s3 !== peg$FAILED) {
            s4 = peg$parsespace();

            if (s4 !== peg$FAILED) {
              s5 = peg$parseOrQuery();

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c6(s1, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseAndQuery();
      }

      return s0;
    }

    function peg$parseAndQuery() {
      var s0, s1, s2, s3, s4, s5;
      s0 = peg$currPos;
      s1 = peg$parseNegatedClause();

      if (s1 !== peg$FAILED) {
        s2 = peg$parsespace();

        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c7) {
            s3 = input.substr(peg$currPos, 3);
            peg$currPos += 3;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c8);
            }
          }

          if (s3 !== peg$FAILED) {
            s4 = peg$parsespace();

            if (s4 !== peg$FAILED) {
              s5 = peg$parseAndQuery();

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c9(s1, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseNegatedClause();

        if (s1 !== peg$FAILED) {
          s2 = peg$parsespace();

          if (s2 !== peg$FAILED) {
            s3 = peg$currPos;
            peg$silentFails++;

            if (input.substr(peg$currPos, 2).toLowerCase() === peg$c4) {
              s4 = input.substr(peg$currPos, 2);
              peg$currPos += 2;
            } else {
              s4 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c5);
              }
            }

            peg$silentFails--;

            if (s4 === peg$FAILED) {
              s3 = void 0;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }

            if (s3 !== peg$FAILED) {
              s4 = peg$parseAndQuery();

              if (s4 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c9(s1, s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }

        if (s0 === peg$FAILED) {
          s0 = peg$parseNegatedClause();
        }
      }

      return s0;
    }

    function peg$parseNegatedClause() {
      var s0, s1, s2;
      s0 = peg$currPos;

      if (peg$c10.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c11);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parseClause();

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c12(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseClause();
      }

      return s0;
    }

    function peg$parseClause() {
      var s0, s1, s2, s3;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c13;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c14);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = peg$parsestart();

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 41) {
            s3 = peg$c15;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c16);
            }
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c17(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$parseTerm();
      }

      return s0;
    }

    function peg$parseTerm() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;
      s0 = peg$currPos;
      s1 = peg$parseliteral_arg_type();

      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 58) {
          s2 = peg$c18;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c19);
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parseliteral_arg_type();

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c20(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseliteral_arg_type();

        if (s1 !== peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c21) {
            s2 = peg$c21;
            peg$currPos += 2;
          } else {
            s2 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c22);
            }
          }

          if (s2 !== peg$FAILED) {
            s3 = peg$parsespace();

            if (s3 === peg$FAILED) {
              s3 = null;
            }

            if (s3 !== peg$FAILED) {
              s4 = peg$parseliteral_arg_type();

              if (s4 !== peg$FAILED) {
                s5 = peg$parsespace();

                if (s5 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 2).toLowerCase() === peg$c23) {
                    s6 = input.substr(peg$currPos, 2);
                    peg$currPos += 2;
                  } else {
                    s6 = peg$FAILED;

                    if (peg$silentFails === 0) {
                      peg$fail(peg$c24);
                    }
                  }

                  if (s6 !== peg$FAILED) {
                    s7 = peg$parsespace();

                    if (s7 !== peg$FAILED) {
                      s8 = peg$parseliteral_arg_type();

                      if (s8 !== peg$FAILED) {
                        s9 = peg$parsespace();

                        if (s9 === peg$FAILED) {
                          s9 = null;
                        }

                        if (s9 !== peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 93) {
                            s10 = peg$c25;
                            peg$currPos++;
                          } else {
                            s10 = peg$FAILED;

                            if (peg$silentFails === 0) {
                              peg$fail(peg$c26);
                            }
                          }

                          if (s10 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c27(s1, s4, s8);
                            s0 = s1;
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }

        if (s0 === peg$FAILED) {
          s0 = peg$parsefunction();

          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$currPos;
            peg$silentFails++;
            s2 = peg$parseKeywords();
            peg$silentFails--;

            if (s2 === peg$FAILED) {
              s1 = void 0;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }

            if (s1 !== peg$FAILED) {
              s2 = peg$parseliteral_arg_type();

              if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c28(s2);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          }
        }
      }

      return s0;
    }

    function peg$parsefunction_name() {
      var s0, s1, s2, s3;
      s0 = peg$currPos;
      s1 = [];

      if (peg$c29.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c30);
        }
      }

      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);

          if (peg$c29.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c30);
            }
          }
        }
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        s2 = [];

        if (peg$c31.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c32);
          }
        }

        while (s3 !== peg$FAILED) {
          s2.push(s3);

          if (peg$c31.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c32);
            }
          }
        }

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c33(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsefunction() {
      var s0, s1, s2, s3, s4, s5, s6, s7;
      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsefunction_name();

      if (s1 !== peg$FAILED) {
        s2 = peg$parsespace();

        if (s2 === peg$FAILED) {
          s2 = null;
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 40) {
            s3 = peg$c13;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c14);
            }
          }

          if (s3 !== peg$FAILED) {
            s4 = peg$parsespace();

            if (s4 === peg$FAILED) {
              s4 = null;
            }

            if (s4 !== peg$FAILED) {
              s5 = peg$parsearg_list();

              if (s5 === peg$FAILED) {
                s5 = null;
              }

              if (s5 !== peg$FAILED) {
                s6 = peg$parsespace();

                if (s6 === peg$FAILED) {
                  s6 = null;
                }

                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s7 = peg$c15;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;

                    if (peg$silentFails === 0) {
                      peg$fail(peg$c16);
                    }
                  }

                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c35(s1, s5);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c34);
        }
      }

      return s0;
    }

    function peg$parsearg_list() {
      var s0, s1, s2, s3, s4, s5, s6, s7;
      s0 = peg$currPos;
      s1 = peg$parseargument();

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$parsespace();

        if (s4 === peg$FAILED) {
          s4 = null;
        }

        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 44) {
            s5 = peg$c36;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c37);
            }
          }

          if (s5 !== peg$FAILED) {
            s6 = peg$parsespace();

            if (s6 === peg$FAILED) {
              s6 = null;
            }

            if (s6 !== peg$FAILED) {
              s7 = peg$parseargument();

              if (s7 !== peg$FAILED) {
                peg$savedPos = s3;
                s4 = peg$c38(s1, s7);
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parsespace();

          if (s4 === peg$FAILED) {
            s4 = null;
          }

          if (s4 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 44) {
              s5 = peg$c36;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c37);
              }
            }

            if (s5 !== peg$FAILED) {
              s6 = peg$parsespace();

              if (s6 === peg$FAILED) {
                s6 = null;
              }

              if (s6 !== peg$FAILED) {
                s7 = peg$parseargument();

                if (s7 !== peg$FAILED) {
                  peg$savedPos = s3;
                  s4 = peg$c38(s1, s7);
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }

        if (s2 !== peg$FAILED) {
          s3 = peg$parsespace();

          if (s3 === peg$FAILED) {
            s3 = null;
          }

          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 44) {
              s4 = peg$c36;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c37);
              }
            }

            if (s4 === peg$FAILED) {
              s4 = null;
            }

            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c39(s1, s2);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseargument() {
      var s0, s1, s2, s3, s4, s5;
      s0 = peg$currPos;
      s1 = peg$parsefunction_name();

      if (s1 !== peg$FAILED) {
        s2 = peg$parsespace();

        if (s2 === peg$FAILED) {
          s2 = null;
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 61) {
            s3 = peg$c40;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c41);
            }
          }

          if (s3 !== peg$FAILED) {
            s4 = peg$parsespace();

            if (s4 === peg$FAILED) {
              s4 = null;
            }

            if (s4 !== peg$FAILED) {
              s5 = peg$parsearg_type();

              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c42(s1, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsearg_type();

        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c43(s1);
        }

        s0 = s1;
      }

      return s0;
    }

    function peg$parsearg_type() {
      var s0;
      s0 = peg$parseOrQuery();

      if (s0 === peg$FAILED) {
        s0 = peg$parseliteral_arg_type();
      }

      return s0;
    }

    function peg$parseliteral_arg_type() {
      var s0, s1;
      s0 = peg$currPos;
      s1 = peg$parseliteral();

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c44(s1);
      }

      s0 = s1;
      return s0;
    }

    function peg$parseKeywords() {
      var s0;

      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c7) {
        s0 = input.substr(peg$currPos, 3);
        peg$currPos += 3;
      } else {
        s0 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c8);
        }
      }

      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 2).toLowerCase() === peg$c4) {
          s0 = input.substr(peg$currPos, 2);
          peg$currPos += 2;
        } else {
          s0 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c5);
          }
        }
      }

      return s0;
    }

    function peg$parseliteral() {
      var s0, s1, s2, s3;
      peg$silentFails++;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 34) {
        s1 = peg$c46;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c47);
        }
      }

      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parsedq_char();

        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsedq_char();
        }

        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 34) {
            s3 = peg$c46;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c47);
            }
          }

          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c48(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        s0 = peg$currPos;

        if (input.charCodeAt(peg$currPos) === 39) {
          s1 = peg$c49;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c50);
          }
        }

        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parsesq_char();

          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parsesq_char();
          }

          if (s2 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 39) {
              s3 = peg$c49;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c50);
              }
            }

            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c48(s2);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }

        if (s0 === peg$FAILED) {
          s0 = peg$currPos;

          if (input.substr(peg$currPos, 4) === peg$c51) {
            s1 = peg$c51;
            peg$currPos += 4;
          } else {
            s1 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c52);
            }
          }

          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c53();
          }

          s0 = s1;

          if (s0 === peg$FAILED) {
            s0 = peg$currPos;

            if (input.substr(peg$currPos, 5) === peg$c54) {
              s1 = peg$c54;
              peg$currPos += 5;
            } else {
              s1 = peg$FAILED;

              if (peg$silentFails === 0) {
                peg$fail(peg$c55);
              }
            }

            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c56();
            }

            s0 = s1;

            if (s0 === peg$FAILED) {
              s0 = peg$currPos;

              if (input.substr(peg$currPos, 4) === peg$c57) {
                s1 = peg$c57;
                peg$currPos += 4;
              } else {
                s1 = peg$FAILED;

                if (peg$silentFails === 0) {
                  peg$fail(peg$c58);
                }
              }

              if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c59();
              }

              s0 = s1;

              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                s1 = [];

                if (peg$c60.test(input.charAt(peg$currPos))) {
                  s2 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s2 = peg$FAILED;

                  if (peg$silentFails === 0) {
                    peg$fail(peg$c61);
                  }
                }

                if (s2 !== peg$FAILED) {
                  while (s2 !== peg$FAILED) {
                    s1.push(s2);

                    if (peg$c60.test(input.charAt(peg$currPos))) {
                      s2 = input.charAt(peg$currPos);
                      peg$currPos++;
                    } else {
                      s2 = peg$FAILED;

                      if (peg$silentFails === 0) {
                        peg$fail(peg$c61);
                      }
                    }
                  }
                } else {
                  s1 = peg$FAILED;
                }

                if (s1 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c62(s1);
                }

                s0 = s1;
              }
            }
          }
        }
      }

      peg$silentFails--;

      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c45);
        }
      }

      return s0;
    }

    function peg$parsespace() {
      var s0, s1;
      s0 = [];

      if (peg$c1.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c2);
        }
      }

      if (s1 !== peg$FAILED) {
        while (s1 !== peg$FAILED) {
          s0.push(s1);

          if (peg$c1.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s1 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c2);
            }
          }
        }
      } else {
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parsedq_char() {
      var s0, s1, s2;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c63;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c64);
        }
      }

      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 34) {
          s2 = peg$c46;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c47);
          }
        }

        if (s2 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 92) {
            s2 = peg$c63;
            peg$currPos++;
          } else {
            s2 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c64);
            }
          }
        }

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c65(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        if (peg$c66.test(input.charAt(peg$currPos))) {
          s0 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s0 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c67);
          }
        }
      }

      return s0;
    }

    function peg$parsesq_char() {
      var s0, s1, s2;
      s0 = peg$currPos;

      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c63;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c64);
        }
      }

      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 39) {
          s2 = peg$c49;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c50);
          }
        }

        if (s2 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 92) {
            s2 = peg$c63;
            peg$currPos++;
          } else {
            s2 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c64);
            }
          }
        }

        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c65(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      if (s0 === peg$FAILED) {
        if (peg$c68.test(input.charAt(peg$currPos))) {
          s0 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s0 = peg$FAILED;

          if (peg$silentFails === 0) {
            peg$fail(peg$c69);
          }
        }
      }

      return s0;
    }

    function peg$parseinteger() {
      var s0, s1, s2;
      s0 = peg$currPos;
      s1 = [];

      if (peg$c70.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;

        if (peg$silentFails === 0) {
          peg$fail(peg$c71);
        }
      }

      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);

          if (peg$c70.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;

            if (peg$silentFails === 0) {
              peg$fail(peg$c71);
            }
          }
        }
      } else {
        s1 = peg$FAILED;
      }

      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c72(s1);
      }

      s0 = s1;
      return s0;
    }

    var nodeTypes = options.helpers.nodeTypes;

    if (options.includeMetadata === undefined) {
      options.includeMetadata = true;
    }

    function addMeta(source, text, location) {
      if (options.includeMetadata) {
        return Object.assign({}, source, {
          text: text,
          location: simpleLocation(location)
        });
      }

      return source;
    }

    function simpleLocation(location) {
      // Returns an object representing the position of the function within the expression,
      // demarcated by the position of its first character and last character. We calculate these values
      // using the offset because the expression could span multiple lines, and we don't want to deal
      // with column and line values.
      return {
        min: location.start.offset,
        max: location.end.offset
      };
    }

    peg$result = peg$startRuleFunction();

    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
      return peg$result;
    } else {
      if (peg$result !== peg$FAILED && peg$currPos < input.length) {
        peg$fail({
          type: "end",
          description: "end of input"
        });
      }

      throw peg$buildException(null, peg$maxFailExpected, peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null, peg$maxFailPos < input.length ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1) : peg$computeLocation(peg$maxFailPos, peg$maxFailPos));
    }
  }

  return {
    SyntaxError: peg$SyntaxError,
    parse: peg$parse
  };
}();