#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tls
version: 1.4.1
id: tls-1.4.1-K2yPt49ylKFE5O8uL7p2rw
key: tls-1.4.1-K2yPt49ylKFE5O8uL7p2rw
license: BSD-3-Clause
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
author: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
synopsis: TLS/SSL protocol native implementation (Server and Client)
description:
    Native Haskell TLS and SSL protocol implementation for server and client.
    .
    This provides a high-level implementation of a sensitive security protocol,
    eliminating a common set of security issues through the use of the advanced
    type system, high level constructions and common Haskell features.
    .
    Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
    and support RSA and Ephemeral (Elliptic curve and regular) Diffie Hellman key exchanges,
    and many extensions.
    .
    Some debug tools linked with tls, are available through the
    <http://hackage.haskell.org/package/tls-debug/>.
category: Network
abi: d762b15984d06a5246ccb372f8851d15
exposed: True
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Extra Network.TLS.Extra.Cipher Network.TLS.Extra.FFDHE
    Network.TLS.Internal
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.Core
                Network.TLS.Context Network.TLS.Context.Internal
                Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
                Network.TLS.Crypto.DH Network.TLS.Crypto.IES
                Network.TLS.Crypto.Types Network.TLS.ErrT Network.TLS.Extension
                Network.TLS.Handshake Network.TLS.Handshake.Common
                Network.TLS.Handshake.Certificate Network.TLS.Handshake.Key
                Network.TLS.Handshake.Client Network.TLS.Handshake.Server
                Network.TLS.Handshake.Process Network.TLS.Handshake.Signature
                Network.TLS.Handshake.State Network.TLS.Hooks Network.TLS.IO
                Network.TLS.Imports Network.TLS.MAC Network.TLS.Measurement
                Network.TLS.Packet Network.TLS.Parameters Network.TLS.Record
                Network.TLS.Record.Types Network.TLS.Record.Engage
                Network.TLS.Record.Disengage Network.TLS.Record.State
                Network.TLS.RNG Network.TLS.State Network.TLS.Session
                Network.TLS.Sending Network.TLS.Receiving Network.TLS.Util
                Network.TLS.Util.ASN1 Network.TLS.Util.Serialization
                Network.TLS.Types Network.TLS.Wire Network.TLS.X509
import-dirs: /usr/lib/ghc-8.6.5/site-local/tls-1.4.1
library-dirs: /usr/lib/ghc-8.6.5/site-local/tls-1.4.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/tls-1.4.1
hs-libraries: HStls-1.4.1-K2yPt49ylKFE5O8uL7p2rw
depends:
    asn1-encoding-0.9.5-BJSvqDJDx54IPJiXnFLbIv
    asn1-types-0.3.2-9EHsiBYRqUhKidaP0Vcp2k
    async-2.2.1-GYH0rb5jjEHH7NChV9fWYh base-4.12.0.0
    bytestring-0.10.8.2 cereal-0.5.8.0-DifhRWa8By0JYDe2id7eOT
    cryptonite-0.25-DtJYWQJTat6yrCxAz9OOT
    data-default-class-0.1.2.0-1aigY0ifYUs4kfvMygEld7
    memory-0.14.18-IbWiQctDwmh73RXfnLR7k6 mtl-2.2.2
    network-2.8.0.0-JWTbamlNgQDGa4CnHHLrSE transformers-0.5.6.2
    x509-1.7.5-2xExHLJ3VNlBZRhBywKbfo
    x509-store-1.6.7-G986kl4ujQjFFn5YKMuPr5
    x509-validation-1.6.11-2U1hkNRxBAw4ERaFellGZN
haddock-interfaces: /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html: /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

