/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.build.BuildState;
import org.gradle.util.Path;

public class DefaultProjectComponentSelector
implements ProjectComponentSelector {
    private final BuildIdentifier buildIdentifier;
    private final Path projectPath;
    private final Path identityPath;
    private final String projectName;
    private final ImmutableAttributes attributes;
    private String displayName;

    public DefaultProjectComponentSelector(BuildIdentifier buildIdentifier, Path identityPath, Path projectPath, String projectName, ImmutableAttributes attributes) {
        assert (buildIdentifier != null) : "build cannot be null";
        assert (identityPath != null) : "identity path cannot be null";
        assert (projectPath != null) : "project path cannot be null";
        assert (projectName != null) : "project name cannot be null";
        assert (attributes != null) : "attributes cannot be null";
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.projectPath = projectPath;
        this.projectName = projectName;
        this.attributes = attributes;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = "project " + this.identityPath;
        }
        return this.displayName;
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public String getBuildName() {
        return this.buildIdentifier.getName();
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public String getProjectPath() {
        return this.projectPath.getPath();
    }

    public Path projectPath() {
        return this.projectPath;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof DefaultProjectComponentIdentifier) {
            DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)identifier;
            return projectComponentIdentifier.getIdentityPath().equals((Object)this.identityPath);
        }
        return false;
    }

    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultProjectComponentSelector)) {
            return false;
        }
        DefaultProjectComponentSelector that = (DefaultProjectComponentSelector)o;
        if (!this.identityPath.equals((Object)that.identityPath)) {
            return false;
        }
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return this.identityPath.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ProjectComponentSelector newSelector(Project project) {
        return DefaultProjectComponentSelector.newSelector(project, ImmutableAttributes.EMPTY);
    }

    public static ProjectComponentSelector newSelector(Project project, ImmutableAttributes attributes) {
        ProjectInternal projectInternal = (ProjectInternal)project;
        BuildIdentifier currentBuild = ((BuildState)projectInternal.getServices().get(BuildState.class)).getBuildIdentifier();
        return new DefaultProjectComponentSelector(currentBuild, projectInternal.getIdentityPath(), projectInternal.getProjectPath(), project.getName(), attributes);
    }

    public static ProjectComponentSelector newSelector(ProjectComponentIdentifier identifier) {
        DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)identifier;
        return new DefaultProjectComponentSelector(projectComponentIdentifier.getBuild(), projectComponentIdentifier.getIdentityPath(), projectComponentIdentifier.projectPath(), projectComponentIdentifier.getProjectName(), ImmutableAttributes.EMPTY);
    }

    public ProjectComponentIdentifier toIdentifier() {
        return new DefaultProjectComponentIdentifier(this.buildIdentifier, this.identityPath, this.projectPath, this.projectName);
    }
}

