/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.Build;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class Version
implements Comparable<Version>,
ToXContentFragment {
    public static final int V_EMPTY_ID = 0;
    public static final Version V_EMPTY = new Version(0, org.apache.lucene.util.Version.LATEST);
    public static final int V_6_0_0_alpha1_ID = 6000001;
    public static final Version V_6_0_0_alpha1 = new Version(6000001, org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final int V_6_0_0_alpha2_ID = 6000002;
    public static final Version V_6_0_0_alpha2 = new Version(6000002, org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final int V_6_0_0_beta1_ID = 6000026;
    public static final Version V_6_0_0_beta1 = new Version(6000026, org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final int V_6_0_0_beta2_ID = 6000027;
    public static final Version V_6_0_0_beta2 = new Version(6000027, org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final int V_6_0_0_rc1_ID = 6000051;
    public static final Version V_6_0_0_rc1 = new Version(6000051, org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final int V_6_0_0_rc2_ID = 6000052;
    public static final Version V_6_0_0_rc2 = new Version(6000052, org.apache.lucene.util.Version.LUCENE_7_0_1);
    public static final int V_6_0_0_ID = 6000099;
    public static final Version V_6_0_0 = new Version(6000099, org.apache.lucene.util.Version.LUCENE_7_0_1);
    public static final int V_6_0_1_ID = 6000199;
    public static final Version V_6_0_1 = new Version(6000199, org.apache.lucene.util.Version.LUCENE_7_0_1);
    public static final int V_6_1_0_ID = 6010099;
    public static final Version V_6_1_0 = new Version(6010099, org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final int V_6_1_1_ID = 0x5BB557;
    public static final Version V_6_1_1 = new Version(0x5BB557, org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final int V_6_1_2_ID = 0x5BB5BB;
    public static final Version V_6_1_2 = new Version(0x5BB5BB, org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final int V_6_1_3_ID = 6010399;
    public static final Version V_6_1_3 = new Version(6010399, org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final int V_6_1_4_ID = 6010499;
    public static final Version V_6_1_4 = new Version(6010499, org.apache.lucene.util.Version.LUCENE_7_1_0);
    private static final org.apache.lucene.util.Version LUCENE_7_2_1 = org.apache.lucene.util.Version.fromBits((int)7, (int)2, (int)1);
    public static final int V_6_2_0_ID = 6020099;
    public static final Version V_6_2_0 = new Version(6020099, LUCENE_7_2_1);
    public static final int V_6_2_1_ID = 6020199;
    public static final Version V_6_2_1 = new Version(6020199, LUCENE_7_2_1);
    public static final int V_6_2_2_ID = 6020299;
    public static final Version V_6_2_2 = new Version(6020299, LUCENE_7_2_1);
    public static final int V_6_2_3_ID = 6020399;
    public static final Version V_6_2_3 = new Version(6020399, LUCENE_7_2_1);
    public static final int V_6_2_4_ID = 6020499;
    public static final Version V_6_2_4 = new Version(6020499, LUCENE_7_2_1);
    public static final int V_6_3_0_ID = 6030099;
    public static final Version V_6_3_0 = new Version(6030099, org.apache.lucene.util.Version.LUCENE_7_3_1);
    public static final int V_6_3_1_ID = 6030199;
    public static final Version V_6_3_1 = new Version(6030199, org.apache.lucene.util.Version.LUCENE_7_3_1);
    public static final int V_6_3_2_ID = 6030299;
    public static final Version V_6_3_2 = new Version(6030299, org.apache.lucene.util.Version.LUCENE_7_3_1);
    public static final int V_6_4_0_ID = 6040099;
    public static final Version V_6_4_0 = new Version(6040099, org.apache.lucene.util.Version.LUCENE_7_4_0);
    public static final int V_6_4_1_ID = 6040199;
    public static final Version V_6_4_1 = new Version(6040199, org.apache.lucene.util.Version.LUCENE_7_4_0);
    public static final int V_6_4_2_ID = 6040299;
    public static final Version V_6_4_2 = new Version(6040299, org.apache.lucene.util.Version.LUCENE_7_4_0);
    public static final int V_6_4_3_ID = 6040399;
    public static final Version V_6_4_3 = new Version(6040399, org.apache.lucene.util.Version.LUCENE_7_4_0);
    public static final int V_6_5_0_ID = 6050099;
    public static final Version V_6_5_0 = new Version(6050099, org.apache.lucene.util.Version.LUCENE_7_5_0);
    public static final int V_6_5_1_ID = 6050199;
    public static final Version V_6_5_1 = new Version(6050199, org.apache.lucene.util.Version.LUCENE_7_5_0);
    public static final int V_6_5_2_ID = 6050299;
    public static final Version V_6_5_2 = new Version(6050299, org.apache.lucene.util.Version.LUCENE_7_5_0);
    public static final int V_6_5_3_ID = 6050399;
    public static final Version V_6_5_3 = new Version(6050399, org.apache.lucene.util.Version.LUCENE_7_5_0);
    public static final int V_6_5_4_ID = 6050499;
    public static final Version V_6_5_4 = new Version(6050499, org.apache.lucene.util.Version.LUCENE_7_5_0);
    public static final int V_6_6_0_ID = 6060099;
    public static final Version V_6_6_0 = new Version(6060099, org.apache.lucene.util.Version.LUCENE_7_6_0);
    public static final int V_6_6_1_ID = 6060199;
    public static final Version V_6_6_1 = new Version(6060199, org.apache.lucene.util.Version.LUCENE_7_6_0);
    public static final int V_6_6_2_ID = 6060299;
    public static final Version V_6_6_2 = new Version(6060299, org.apache.lucene.util.Version.LUCENE_7_6_0);
    public static final int V_6_7_0_ID = 6070099;
    public static final Version V_6_7_0 = new Version(6070099, org.apache.lucene.util.Version.LUCENE_7_7_0);
    public static final int V_6_7_1_ID = 6070199;
    public static final Version V_6_7_1 = new Version(6070199, org.apache.lucene.util.Version.LUCENE_7_7_0);
    public static final int V_6_7_2_ID = 6070299;
    public static final Version V_6_7_2 = new Version(6070299, org.apache.lucene.util.Version.LUCENE_7_7_0);
    public static final int V_7_0_0_ID = 7000099;
    public static final Version V_7_0_0 = new Version(7000099, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final int V_7_0_1_ID = 7000199;
    public static final Version V_7_0_1;
    public static final Version CURRENT;
    public final int id;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    public final org.apache.lucene.util.Version luceneVersion;

    public static Version readVersion(StreamInput in) throws IOException {
        return Version.fromId(in.readVInt());
    }

    public static Version fromId(int id) {
        switch (id) {
            case 7000199: {
                return V_7_0_1;
            }
            case 7000099: {
                return V_7_0_0;
            }
            case 6070199: {
                return V_6_7_1;
            }
            case 6070299: {
                return V_6_7_2;
            }
            case 6070099: {
                return V_6_7_0;
            }
            case 6060299: {
                return V_6_6_2;
            }
            case 6060199: {
                return V_6_6_1;
            }
            case 6060099: {
                return V_6_6_0;
            }
            case 6050499: {
                return V_6_5_4;
            }
            case 6050399: {
                return V_6_5_3;
            }
            case 6050299: {
                return V_6_5_2;
            }
            case 6050199: {
                return V_6_5_1;
            }
            case 6050099: {
                return V_6_5_0;
            }
            case 6040399: {
                return V_6_4_3;
            }
            case 6040299: {
                return V_6_4_2;
            }
            case 6040199: {
                return V_6_4_1;
            }
            case 6040099: {
                return V_6_4_0;
            }
            case 6030299: {
                return V_6_3_2;
            }
            case 6030199: {
                return V_6_3_1;
            }
            case 6030099: {
                return V_6_3_0;
            }
            case 6020499: {
                return V_6_2_4;
            }
            case 6020399: {
                return V_6_2_3;
            }
            case 6020299: {
                return V_6_2_2;
            }
            case 6020199: {
                return V_6_2_1;
            }
            case 6020099: {
                return V_6_2_0;
            }
            case 6010499: {
                return V_6_1_4;
            }
            case 6010399: {
                return V_6_1_3;
            }
            case 0x5BB5BB: {
                return V_6_1_2;
            }
            case 0x5BB557: {
                return V_6_1_1;
            }
            case 6010099: {
                return V_6_1_0;
            }
            case 6000199: {
                return V_6_0_1;
            }
            case 6000099: {
                return V_6_0_0;
            }
            case 6000052: {
                return V_6_0_0_rc2;
            }
            case 6000027: {
                return V_6_0_0_beta2;
            }
            case 6000051: {
                return V_6_0_0_rc1;
            }
            case 6000026: {
                return V_6_0_0_beta1;
            }
            case 6000002: {
                return V_6_0_0_alpha2;
            }
            case 6000001: {
                return V_6_0_0_alpha1;
            }
            case 0: {
                return V_EMPTY;
            }
        }
        List<Version> versions = DeclaredVersionsHolder.DECLARED_VERSIONS;
        Version tmp = new Version(id, org.apache.lucene.util.Version.LATEST);
        int index = Collections.binarySearch(versions, tmp);
        if (index < 0) {
            index = -2 - index;
        } else assert (false) : "Version [" + tmp + "] is declared but absent from the switch statement in Version#fromId";
        org.apache.lucene.util.Version luceneVersion = index == -1 ? org.apache.lucene.util.Version.fromBits((int)(versions.get((int)0).luceneVersion.major - 1), (int)0, (int)0) : versions.get((int)index).luceneVersion;
        return new Version(id, luceneVersion);
    }

    public static Version indexCreated(Settings indexSettings) {
        Version indexVersion = IndexMetaData.SETTING_INDEX_VERSION_CREATED.get(indexSettings);
        if (indexVersion == V_EMPTY) {
            String message = String.format(Locale.ROOT, "[%s] is not present in the index settings for index with UUID [%s]", IndexMetaData.SETTING_INDEX_VERSION_CREATED.getKey(), indexSettings.get("index.uuid"));
            throw new IllegalStateException(message);
        }
        return indexVersion;
    }

    public static void writeVersion(Version version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static Version min(Version version1, Version version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static Version max(Version version1, Version version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static Version fromString(String version) {
        String[] parts;
        if (!Strings.hasLength(version)) {
            return CURRENT;
        }
        boolean snapshot = version.endsWith("-SNAPSHOT");
        if (snapshot) {
            version = version.substring(0, version.length() - 9);
        }
        if ((parts = version.split("[.-]")).length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        try {
            int rawMajor = Integer.parseInt(parts[0]);
            if (rawMajor >= 5 && snapshot) {
                throw new IllegalArgumentException("illegal version format - snapshots are only supported until version 2.x");
            }
            if (rawMajor >= 7 && parts.length == 4) {
                throw new IllegalArgumentException("illegal version format - qualifiers are only supported until version 6.x");
            }
            int betaOffset = rawMajor < 5 ? 0 : 25;
            int major = rawMajor * 1000000;
            int minor = Integer.parseInt(parts[1]) * 10000;
            int revision = Integer.parseInt(parts[2]) * 100;
            int build = 99;
            if (parts.length == 4) {
                String buildStr = parts[3];
                if (buildStr.startsWith("alpha")) {
                    assert (rawMajor >= 5) : "major must be >= 5 but was " + major;
                    build = Integer.parseInt(buildStr.substring(5));
                    assert (build < 25) : "expected a beta build but " + build + " >= 25";
                } else if (buildStr.startsWith("Beta") || buildStr.startsWith("beta")) {
                    build = betaOffset + Integer.parseInt(buildStr.substring(4));
                    assert (build < 50) : "expected a beta build but " + build + " >= 50";
                } else if (buildStr.startsWith("RC") || buildStr.startsWith("rc")) {
                    build = Integer.parseInt(buildStr.substring(2)) + 50;
                } else {
                    throw new IllegalArgumentException("unable to parse version " + version);
                }
            }
            return Version.fromId(major + minor + revision + build);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse version " + version, e);
        }
    }

    Version(int id, org.apache.lucene.util.Version luceneVersion) {
        this.id = id;
        this.major = (byte)(id / 1000000 % 100);
        this.minor = (byte)(id / 10000 % 100);
        this.revision = (byte)(id / 100 % 100);
        this.build = (byte)(id % 100);
        this.luceneVersion = Objects.requireNonNull(luceneVersion);
    }

    public boolean after(Version version) {
        return version.id < this.id;
    }

    public boolean onOrAfter(Version version) {
        return version.id <= this.id;
    }

    public boolean before(Version version) {
        return version.id > this.id;
    }

    public boolean onOrBefore(Version version) {
        return version.id >= this.id;
    }

    @Override
    public int compareTo(Version other) {
        return Integer.compare(this.id, other.id);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    public Version minimumCompatibilityVersion() {
        if (this.major == 6) {
            return Version.fromId(5060099);
        }
        if (this.major >= 7) {
            Version bwcVersion = null;
            for (int i = DeclaredVersionsHolder.DECLARED_VERSIONS.size() - 1; i >= 0; --i) {
                Version candidateVersion = DeclaredVersionsHolder.DECLARED_VERSIONS.get(i);
                if (candidateVersion.major != this.major - 1 || !candidateVersion.isRelease() || !this.after(candidateVersion)) continue;
                if (bwcVersion != null && candidateVersion.minor < bwcVersion.minor) break;
                bwcVersion = candidateVersion;
            }
            return bwcVersion == null ? this : bwcVersion;
        }
        return Version.min(this, Version.fromId(this.major * 1000000 + 0 + 99));
    }

    public Version minimumIndexCompatibilityVersion() {
        int bwcMajor;
        if (this.major == 5) {
            bwcMajor = 2;
        } else {
            if (this.major == 7) {
                return V_6_0_0_beta1;
            }
            bwcMajor = this.major - 1;
        }
        boolean bwcMinor = false;
        return Version.min(this, Version.fromId(bwcMajor * 1000000 + 0 + 99));
    }

    public boolean isCompatible(Version version) {
        boolean compatible;
        boolean bl = compatible = this.onOrAfter(version.minimumCompatibilityVersion()) && version.onOrAfter(this.minimumCompatibilityVersion());
        assert (!compatible || Math.max(this.major, version.major) - Math.min(this.major, version.major) <= 1);
        return compatible;
    }

    @SuppressForbidden(reason="System.out.*")
    public static void main(String[] args) {
        String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s/%s, JVM: %s", Build.CURRENT.getQualifiedVersion(), Build.CURRENT.flavor().displayName(), Build.CURRENT.type().displayName(), Build.CURRENT.shortHash(), Build.CURRENT.date(), JvmInfo.jvmInfo().version());
        System.out.println(versionOutput);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
        if (this.isAlpha()) {
            sb.append("-alpha");
            sb.append(this.build);
        } else if (this.isBeta()) {
            if (this.major >= 2) {
                sb.append("-beta");
            } else {
                sb.append(".Beta");
            }
            sb.append(this.major < 5 ? this.build : this.build - 25);
        } else if (this.build < 99) {
            if (this.major >= 2) {
                sb.append("-rc");
            } else {
                sb.append(".RC");
            }
            sb.append(this.build - 50);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isBeta() {
        return this.major < 5 ? this.build < 50 : this.build >= 25 && this.build < 50;
    }

    public boolean isAlpha() {
        return this.major < 5 ? false : this.build < 25;
    }

    public boolean isRC() {
        return this.build > 50 && this.build < 99;
    }

    public boolean isRelease() {
        return this.build == 99;
    }

    public static List<Version> getDeclaredVersions(Class<?> versionClass) {
        Field[] fields = versionClass.getFields();
        ArrayList<Version> versions = new ArrayList<Version>(fields.length);
        block9: for (Field field : fields) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) && Modifier.isFinal(mod) && Modifier.isPublic(mod) || field.getType() != Version.class) continue;
            switch (field.getName()) {
                case "CURRENT": 
                case "V_EMPTY": {
                    continue block9;
                }
                default: {
                    assert (field.getName().matches("V(_\\d+)+(_(alpha|beta|rc)\\d+)?")) : field.getName();
                    try {
                        versions.add((Version)field.get(null));
                        continue block9;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        Collections.sort(versions);
        return versions;
    }

    static {
        CURRENT = V_7_0_1 = new Version(7000199, org.apache.lucene.util.Version.LUCENE_8_0_0);
        assert (Version.CURRENT.luceneVersion.equals((Object)org.apache.lucene.util.Version.LATEST)) : "Version must be upgraded to [" + org.apache.lucene.util.Version.LATEST + "] is still set to [" + Version.CURRENT.luceneVersion + "]";
    }

    private static class DeclaredVersionsHolder {
        static final List<Version> DECLARED_VERSIONS = Collections.unmodifiableList(Version.getDeclaredVersions(Version.class));

        private DeclaredVersionsHolder() {
        }
    }
}

