/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;

public class DBGpCommand {
    private static final String id = " -i ";
    public static final String status = "status";
    public static final String featureGet = "feature_get";
    public static final String featureSet = "feature_set";
    public static final String run = "run";
    public static final String stepInto = "step_into";
    public static final String stepOver = "step_over";
    public static final String StepOut = "step_out";
    public static final String stop = "stop";
    public static final String detach = "detach";
    public static final String breakPointSet = "breakpoint_set";
    public static final String breakPointGet = "breakpoint_get";
    public static final String breakPointUpdate = "breakpoint_update";
    public static final String breakPointRemove = "breakpoint_remove";
    public static final String breakPointList = "breakpoint_list";
    public static final String stackDepth = "stack-depth";
    public static final String stackGet = "stack_get";
    public static final String propSet = "property_set";
    public static final String propGet = "property_get";
    public static final String propValue = "property_value";
    public static final String contextGet = "context_get";
    public static final String eval = "eval";
    public static final String stdout = "stdout";
    public static final String stderr = "stderr";
    public static final String suspend = "break";
    Socket socket;
    OutputStreamWriter outStream;
    private static int trId = 0;
    private static Object idMonitor = new Object();
    private int lastIdSent;
    private String lastCmdSent;

    public String getLastCmdSent() {
        return this.lastCmdSent;
    }

    public DBGpCommand(Socket socket) {
        this.socket = socket;
    }

    public int send(String command, String args, int cmdId, String encoding) throws IOException {
        try {
            return this.writeToStream(command, args, cmdId, encoding);
        }
        catch (IOException e) {
            DBGpLogger.logException(null, this, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextId() {
        Object object = idMonitor;
        synchronized (object) {
            if (++trId < 0) {
                trId = 1;
            }
        }
        return trId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeToStream(String command, String args, int cmdId, String encoding) throws IOException {
        String fullCmd = String.valueOf(command) + id + cmdId;
        if (args != null) {
            fullCmd = String.valueOf(fullCmd) + " " + args;
        }
        if (DBGpLogger.debugCmd()) {
            DBGpLogger.debug("cmd: " + fullCmd);
        }
        Socket socket = this.socket;
        synchronized (socket) {
            OutputStream os = this.socket.getOutputStream();
            byte[] cmdBytes = fullCmd.getBytes(encoding);
            byte[] cmdWithTerm = new byte[cmdBytes.length + 1];
            System.arraycopy(cmdBytes, 0, cmdWithTerm, 0, cmdBytes.length);
            os.write(cmdWithTerm);
            os.flush();
            this.lastIdSent = cmdId;
            this.lastCmdSent = fullCmd;
        }
        return cmdId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastIdSent() {
        int id;
        Socket socket = this.socket;
        synchronized (socket) {
            id = this.lastIdSent;
        }
        return id;
    }
}

