/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.interpret;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.core.interpret.ObjectValue;
import org.eclipse.wst.jsdt.internal.core.interpret.Value;
import org.eclipse.wst.jsdt.internal.core.interpret.ValueReference;
import org.eclipse.wst.jsdt.internal.core.interpret.builtin.BuiltInHelper;

public class InterpreterContext
implements ValueReference {
    protected HashtableOfObject values = new HashtableOfObject();
    protected InterpreterContext parent;
    InterpreterContext lastReference;
    public Value returnValue;
    ValueReference thisObject;
    public int returnCode;

    public InterpreterContext() {
        this(null, null);
    }

    public InterpreterContext(InterpreterContext parent, ObjectValue thisObject) {
        this.parent = parent;
        this.thisObject = thisObject != null ? thisObject : this.globalContext();
    }

    @Override
    public Value getValue(char[] name) {
        InterpreterContext checkContext = this;
        do {
            this.lastReference = checkContext;
            Value value = (Value)checkContext.values.get(name);
            if (value == null) continue;
            return value;
        } while ((checkContext = checkContext.parent) != null);
        return Value.UndefinedObjectValue;
    }

    @Override
    public void setValue(char[] name, Value value) {
        this.values.put(name, value);
    }

    public ValueReference getReference(char[] name) {
        if (this.parent == null || this.values.containsKey(name)) {
            return this;
        }
        return this.parent.getReference(name);
    }

    public void initailizeBuiltins() {
        BuiltInHelper.initializeBuiltinObjects(this);
    }

    public InterpreterContext globalContext() {
        InterpreterContext checkContext = this;
        while (checkContext.parent != null) {
            checkContext = checkContext.parent;
        }
        return checkContext;
    }

    public List getContextStack() {
        ArrayList<InterpreterContext> list = new ArrayList<InterpreterContext>();
        InterpreterContext currentContext = this;
        while (currentContext != null) {
            list.add(0, currentContext);
            currentContext = currentContext.parent;
        }
        return list;
    }

    public ValueReference getThisObject() {
        return this.thisObject;
    }

    public InterpreterContext getParent() {
        return this.parent;
    }
}

