/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.security.GeneralSecurityException;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.transport.digest.SHA256;
import net.schmizz.sshj.transport.kex.AbstractDHG;
import net.schmizz.sshj.transport.kex.Curve25519DH;
import net.schmizz.sshj.transport.kex.DHBase;
import net.schmizz.sshj.transport.kex.KeyExchange;

public class Curve25519SHA256
extends AbstractDHG {
    public Curve25519SHA256() {
        super(new Curve25519DH(), new SHA256());
    }

    @Override
    protected void initDH(DHBase dh) throws GeneralSecurityException {
        dh.init(Curve25519DH.getCurve25519Params(), this.trans.getConfig().getRandomFactory());
    }

    public static class Factory
    implements Factory.Named<KeyExchange> {
        @Override
        public KeyExchange create() {
            return new Curve25519SHA256();
        }

        @Override
        public String getName() {
            return "curve25519-sha256";
        }
    }

    public static class FactoryLibSsh
    implements Factory.Named<KeyExchange> {
        @Override
        public KeyExchange create() {
            return new Curve25519SHA256();
        }

        @Override
        public String getName() {
            return "curve25519-sha256@libssh.org";
        }
    }
}

