Welcome to the Dart API reference documentation, covering the core Dart API
libraries. Some of the most fundamental Dart libraries include:
   
  * [dart:core](dart-core/dart-core-library.html): Core functionality such as
    strings, numbers, collections, errors, dates, and URIs.
  * [dart:html](dart-html/dart-html-library.html): DOM manipulation for web apps
    (available only to web apps).
  * [dart:io](dart-io/dart-io-library.html): I/O for non-web apps.
  
Except for `dart:core`, you must import a library before you can use it. Here's
an example of importing `dart:async` and `dart:math`:

```dart
import 'dart:async';
import 'dart:math';
```

You can install more libraries using the
[pub package manager](https://www.dartlang.org/tools/pub).
  
The main site for learning and using Dart is
[www.dartlang.org](https://www.dartlang.org). Check out these pages:
  
  * [Get started](https://www.dartlang.org/guides/get-started)
  * [Language tour](https://www.dartlang.org/guides/language/language-tour)
  * [Library tour](https://www.dartlang.org/guides/libraries/library-tour)
  * [Sample code](https://www.dartlang.org/samples)
  
This API reference is automatically generated from source code in the [Dart
SDK project](https://github.com/dart-lang/sdk).
If you'd like to give feedback or edit this documentation, see
[Contributing](https://github.com/dart-lang/sdk/wiki/Contributing).
