"use strict";
((window, Notification) => {
    const notifications = new Map();
    // Handle events sent from the browser process
    window.addEventListener('message', ({ data: { type, data } }) => {
        if (type === 'notification-callback') {
            const { callbackName, id } = data;
            const notification = notifications.get(id);
            if (!notification) {
                return;
            }
            if (notification[callbackName]) {
                notification[callbackName]();
            }
            if (callbackName === 'onclose') {
                notifications.delete(id);
            }
        }
        if (type === 'notification-reply-callback') {
            const { callbackName, id, previousConversation, reply } = data;
            const notification = notifications.get(id);
            if (!notification) {
                return;
            }
            if (notification[callbackName]) {
                notification[callbackName]();
            }
            notifications.delete(id);
            window.postMessage({ type: 'notification-reply', data: { previousConversation, reply } }, '*');
        }
    });
    let counter = 1;
    const AugmentedNotification = Object.assign(class {
        constructor(title, options) {
            // According to https://github.com/sindresorhus/caprine/pull/637, the Notification
            // constructor can be called with non-string title and body.
            let { body } = options;
            const bodyProps = body.props;
            body = bodyProps ? bodyProps.content[0] : options.body;
            const titleProps = title.props;
            title = titleProps ? titleProps.content[0] : title;
            this._id = counter++;
            notifications.set(this._id, this);
            window.postMessage({ type: 'notification', data: { title, id: this._id, ...options, body } }, '*');
        }
        // No-op, but Messenger expects this method to be present
        close() { }
    }, Notification);
    Object.assign(window, { Notification: AugmentedNotification });
})(window, Notification);
//# sourceMappingURL=notifications-isolated.js.map