var snapshotAuxiliaryData={lessSourcesByRelativeFilePath:{"static/atom-ui/_index.less":{content:'// Atom UI\n\n// Private! Don\'t use these in packages.\n// If you need something, feel free to open an issue and it might can be made public\n@import "styles/private/scaffolding.less";\n\n@import "styles/private/alerts.less";\n@import "styles/private/close.less";\n@import "styles/private/code.less";\n@import "styles/private/forms.less";\n@import "styles/private/links.less";\n@import "styles/private/navs.less";\n@import "styles/private/sections.less";\n@import "styles/private/tables.less";\n@import "styles/private/utilities.less";\n\n\n// Public components\n// Open the Styleguide to see them in action\n@import "styles/badges.less";\n@import "styles/button-groups.less";\n@import "styles/buttons.less";\n@import "styles/git-status.less";\n@import "styles/icons.less";\n@import "styles/inputs.less";\n@import "styles/layout.less";\n@import "styles/lists.less";\n@import "styles/loading.less";\n@import "styles/messages.less";\n@import "styles/modals.less";\n@import "styles/panels.less";\n@import "styles/select-list.less";\n@import "styles/site-colors.less";\n@import "styles/text.less";\n@import "styles/tooltip.less";\n',digest:"f69b9488d6479f3be5c9e4bb947eb6785dd82c66"},"static/atom-ui/styles/badges.less":{content:'@import "ui-variables";\n\n.badge {\n  display: inline-block;\n  line-height: 1;\n  vertical-align: middle;\n  font-weight: normal;\n  text-align: center;\n  white-space: nowrap;\n  border-radius: 1em;\n\n  &:empty {\n    display: none; // Hide when un-used\n  }\n\n\n  // Color ----------------------\n\n  .badge-color( @fg: @text-color-selected; @bg: @background-color-selected; ) {\n    color: @fg;\n    background-color: @bg;\n  }\n  .badge-color();\n  &.badge-info    { .badge-color(white, @background-color-info); }\n  &.badge-success { .badge-color(white, @background-color-success); }\n  &.badge-warning { .badge-color(white, @background-color-warning); }\n  &.badge-error   { .badge-color(white, @background-color-error); }\n\n\n  // Size ----------------------\n\n  .badge-size( @size: @font-size; ) {\n    @padding: round(@size/4);\n    font-size: @size;\n    min-width: @size + @padding*2;\n    padding: @padding round(@padding*1.5);\n  }\n  .badge-size(); // default\n\n  // Fixed size\n  &.badge-large  { .badge-size(18px); }\n  &.badge-medium { .badge-size(14px); }\n  &.badge-small  { .badge-size(10px); }\n\n  // Flexible size\n  // The size changes depending on the parent element\n  // Best used for larger sizes, since em\'s can cause rounding errors\n  &.badge-flexible {\n    @size: .8em;\n    @padding: @size/2;\n    font-size: @size;\n    min-width: @size + @padding*2;\n    padding: @padding @padding*1.5;\n  }\n\n\n  // Icon ----------------------\n\n  &.icon {\n    font-size: round(@component-icon-size*0.8);\n    padding: @component-icon-padding @component-icon-padding*2;\n  }\n\n}\n',digest:"01641d6ee53f9a1f0d108c1cbba0fba697cd57e4"},"static/atom-ui/styles/button-groups.less":{content:'@import "variables/variables";\n@import "ui-variables";\n@import "mixins/mixins";\n\n//\n// Button groups\n// --------------------------------------------------\n\n// Make the div behave like a button\n.btn-group,\n.btn-group-vertical {\n  position: relative;\n  display: inline-block;\n  vertical-align: middle; // match .btn alignment given font-size hack above\n  > .btn {\n    position: relative;\n    float: left;\n    // Bring the "active" button to the front\n    &:hover,\n    &:focus,\n    &:active,\n    &.active {\n      z-index: 2;\n    }\n  }\n}\n\n\n// Borders\n// ---------------------------------------------------------\n\n.btn-group > .btn {\n  border-left: 1px solid @button-border-color;\n  border-right: 1px solid @button-border-color;\n}\n.btn-group > .btn:first-child {\n  border-left: none;\n  border-top-left-radius: @component-border-radius;\n  border-bottom-left-radius: @component-border-radius;\n}\n.btn-group > .btn:last-child,\n.btn-group > .btn.selected:last-child,\n.btn-group > .dropdown-toggle {\n  border-right: none;\n  border-top-right-radius: @component-border-radius;\n  border-bottom-right-radius: @component-border-radius;\n}\n\n// Prevent double borders when buttons are next to each other\n.btn-group {\n  .btn + .btn,\n  .btn + .btn-group,\n  .btn-group + .btn,\n  .btn-group + .btn-group {\n    margin-left: -1px;\n  }\n}\n\n// Optional: Group multiple button groups together for a toolbar\n.btn-toolbar {\n  margin-left: -5px; // Offset the first child\'s margin\n  &:extend(.clearfix all);\n\n  .btn,\n  .btn-group,\n  .input-group {\n    float: left;\n  }\n  > .btn,\n  > .btn-group,\n  > .input-group {\n    margin-left: 5px;\n  }\n}\n\n.btn-group > .btn:not(:first-child):not(:last-child):not(.dropdown-toggle) {\n  border-radius: 0;\n}\n\n// Set corners individual because sometimes a single button can be in a .btn-group and we need :first-child and :last-child to both match\n.btn-group > .btn:first-child {\n  margin-left: 0;\n  &:not(:last-child):not(.dropdown-toggle) {\n    .border-right-radius(0);\n  }\n}\n// Need .dropdown-toggle since :last-child doesn\'t apply given a .dropdown-menu immediately after it\n.btn-group > .btn:last-child:not(:first-child),\n.btn-group > .dropdown-toggle:not(:first-child) {\n  .border-left-radius(0);\n}\n\n// Custom edits for including btn-groups within btn-groups (useful for including dropdown buttons within a btn-group)\n.btn-group > .btn-group {\n  float: left;\n}\n.btn-group > .btn-group:not(:first-child):not(:last-child) > .btn {\n  border-radius: 0;\n}\n.btn-group > .btn-group:first-child:not(:last-child) {\n  > .btn:last-child,\n  > .dropdown-toggle {\n    .border-right-radius(0);\n  }\n}\n.btn-group > .btn-group:last-child:not(:first-child) > .btn:first-child {\n  .border-left-radius(0);\n}\n\n// On active and open, don\'t show outline\n.btn-group .dropdown-toggle:active,\n.btn-group.open .dropdown-toggle {\n  outline: 0;\n}\n\n\n// Sizing\n//\n// Remix the default button sizing classes into new ones for easier manipulation.\n\n.btn-group-xs > .btn { &:extend(.btn-xs); }\n.btn-group-sm > .btn { &:extend(.btn-sm); }\n.btn-group-lg > .btn { &:extend(.btn-lg); }\n\n\n// Split button dropdowns\n// ----------------------\n\n// Give the line between buttons some depth\n.btn-group > .btn + .dropdown-toggle {\n  padding-left: 8px;\n  padding-right: 8px;\n}\n.btn-group > .btn-lg + .dropdown-toggle {\n  padding-left: 12px;\n  padding-right: 12px;\n}\n\n// The clickable button for toggling the menu\n// Remove the gradient and set the same inset shadow as the :active state\n.btn-group.open .dropdown-toggle {\n  box-shadow: inset 0 3px 5px rgba(0,0,0,.125);\n\n  // Show no shadow for `.btn-link` since it has no other button styles.\n  &.btn-link {\n    box-shadow: none;\n  }\n}\n\n\n// Reposition the caret\n.btn .caret {\n  margin-left: 0;\n}\n// Carets in other button sizes\n.btn-lg .caret {\n  border-width: @caret-width-large @caret-width-large 0;\n  border-bottom-width: 0;\n}\n// Upside down carets for .dropup\n.dropup .btn-lg .caret {\n  border-width: 0 @caret-width-large @caret-width-large;\n}\n\n\n// Justified button groups\n// ----------------------\n\n.btn-group-justified {\n  display: table;\n  width: 100%;\n  table-layout: fixed;\n  border-collapse: separate;\n  > .btn,\n  > .btn-group {\n    float: none;\n    display: table-cell;\n    width: 1%;\n  }\n  > .btn-group .btn {\n    width: 100%;\n  }\n\n  > .btn-group .dropdown-menu {\n    left: auto;\n  }\n}\n',digest:"bb487c05d50cd0c463b14de9274deb1bb9507ac6"},"static/atom-ui/styles/buttons.less":{content:'@import "variables/variables";\n@import "ui-variables";\n@import "mixins/mixins";\n\n//\n// Buttons\n// --------------------------------------------------\n\n\n// Base styles\n// --------------------------------------------------\n\n.btn {\n  display: inline-block;\n  margin-bottom: 0; // For input.btn\n  height: @component-line-height + 2px;\n  padding: 0 @component-padding;\n  font-size: @font-size;\n  font-weight: normal;\n  line-height: @component-line-height;\n  text-align: center;\n  vertical-align: middle;\n  border: none;\n  border-radius: @component-border-radius;\n  background-color: @btn-default-bg;\n  white-space: nowrap;\n  cursor: pointer;\n  z-index: 0;\n  -webkit-user-select: none;\n\n  &,\n  &:active,\n  &.active {\n    &:focus,\n    &.focus {\n      .tab-focus();\n    }\n  }\n\n  &:hover,\n  &:focus,\n  &.focus {\n    color: @btn-default-color;\n    text-decoration: none;\n    background-color: @button-background-color-hover;\n  }\n\n  &:active,\n  &.active {\n    outline: 0;\n    background-image: none;\n    box-shadow: inset 0 3px 5px rgba(0,0,0,.125);\n  }\n\n  &.selected,\n  &.selected:hover {\n    // we want the selected button to behave like the :hover button; it\'s on top of the other buttons.\n    z-index: 1;\n    color: @text-color-selected;\n    background-color: @button-background-color-selected;\n  }\n\n  &.disabled,\n  &[disabled],\n  fieldset[disabled] & {\n    cursor: @cursor-disabled;\n    opacity: .65;\n    box-shadow: none;\n  }\n\n  a& {\n    &.disabled,\n    fieldset[disabled] & {\n      pointer-events: none; // Future-proof disabling of clicks on `<a>` elements\n    }\n  }\n}\n\n\n// Button variants\n// --------------------------------------------------\n\n.button-variant(@color; @background;) {\n  color: @color;\n  background-color: @background;\n\n  &:focus,\n  &.focus {\n    color: @color;\n    background-color: darken(@background, 10%);\n  }\n  &:hover {\n    color: @color;\n    background-color: darken(@background, 10%);\n  }\n  &:active,\n  &.active {\n    color: @color;\n    background-color: darken(@background, 10%);\n\n    &:hover,\n    &:focus,\n    &.focus {\n      color: @color;\n      background-color: darken(@background, 17%);\n    }\n  }\n  &.selected,\n  &.selected:hover {\n    // we want the selected button to behave like the :hover button; it\'s on top of the other buttons.\n    z-index: 1;\n    background-color: darken(@background, 10%);\n  }\n\n  &.disabled,\n  &[disabled],\n  fieldset[disabled] & {\n    &:hover,\n    &:focus,\n    &.focus {\n      background-color: @background;\n    }\n  }\n\n  .badge {\n    color: @background;\n    background-color: @color;\n  }\n}\n\n.btn-primary {\n  .button-variant(@btn-primary-color; @btn-primary-bg;);\n}\n// Success appears as green\n.btn-success {\n  .button-variant(@btn-success-color; @btn-success-bg;);\n}\n// Info appears as blue-green\n.btn-info {\n  .button-variant(@btn-info-color; @btn-info-bg;);\n}\n// Warning appears as orange\n.btn-warning {\n  .button-variant(@btn-warning-color; @btn-warning-bg;);\n}\n// Danger and error appear as red\n.btn-error {\n  .button-variant(@btn-error-color; @btn-error-bg;);\n}\n\n\n// Button Sizes\n// --------------------------------------------------\n\n.btn-xs,\n.btn-group-xs > .btn {\n  padding: @component-padding/4 @component-padding/2;\n  font-size: @font-size - 2px;\n  height: auto;\n  line-height: 1.3em;\n  &.icon:before {\n    font-size: @font-size - 2px;\n  }\n}\n.btn-sm,\n.btn-group-sm > .btn {\n  padding: @component-padding/4 @component-padding/2;\n  height: auto;\n  line-height: 1.3em;\n  &.icon:before {\n    font-size: @font-size + 1px;\n  }\n}\n.btn-lg,\n.btn-group-lg > .btn {\n  font-size: @font-size + 2px;\n  padding: @component-padding - 2px  @component-padding + 2px;\n  height: auto;\n  line-height: 1.3em;\n  &.icon:before {\n    font-size: @font-size + 6px;\n  }\n}\n\n\n// Link button\n// -------------------------\n\n// Make a button look and behave like a link\n.btn-link {\n  color: @link-color;\n  font-weight: normal;\n  border-radius: 0;\n  &,\n  &:active,\n  &.active,\n  &[disabled],\n  fieldset[disabled] & {\n    background-color: transparent;\n    box-shadow: none;\n  }\n  &:hover,\n  &:focus {\n    color: @link-hover-color;\n    text-decoration: @link-hover-decoration;\n    background-color: transparent;\n  }\n  &[disabled],\n  fieldset[disabled] & {\n    &:hover,\n    &:focus {\n      color: @btn-link-disabled-color;\n      text-decoration: none;\n    }\n  }\n}\n\n\n// Block button\n// --------------------------------------------------\n\n.btn-block {\n  display: block;\n  width: 100%;\n}\n\n// Vertically space out multiple block buttons\n.btn-block + .btn-block {\n  margin-top: 5px;\n}\n\n// Specificity overrides\ninput[type="submit"],\ninput[type="reset"],\ninput[type="button"] {\n  &.btn-block {\n    width: 100%;\n  }\n}\n\n\n// Icon buttons\n// --------------------------------------------------\n\n.btn.icon {\n  &:before {\n    width: initial;\n    height: initial;\n    margin-right: .3125em;\n  }\n  &:empty:before {\n    margin-right: 0;\n  }\n}\n\n\n// Button Toolbar\n// --------------------------------------------------\n\n.btn-toolbar {\n  > .btn-group + .btn-group,\n  > .btn-group + .btn,\n  > .btn + .btn {\n    float: none;\n    display: inline-block;\n    margin-left: 0;\n  }\n  > * {\n    margin-right: @component-padding / 2;\n  }\n  > *:last-child {\n    margin-right: 0;\n  }\n}\n',digest:"950958d9762691dbebaa846ea0e5aa7afcd719a0"},"static/atom-ui/styles/git-status.less":{content:'@import "ui-variables";\n\n//\n// Git Status\n// --------------------------------------------------\n\n.status {\n  &-ignored  { color: @text-color-subtle; }\n  &-added    { color: @text-color-success; }\n  &-modified { color: @text-color-warning; }\n  &-removed  { color: @text-color-error; }\n  &-renamed  { color: @text-color-info; }\n}\n',digest:"b447ce83f78f01b1fc2e7e9133882cc666559697"},"static/atom-ui/styles/icons.less":{content:'@import "ui-variables";\n\n.icon::before {\n  margin-right: @component-icon-padding;\n}\n\na.icon {\n  text-decoration: none;\n  color: @text-color;\n  &:hover{\n    color: @text-color-highlight;\n  }\n}\n',digest:"441039bd4f65e2ee4d541f3d5667b755cd68d839"},"static/atom-ui/styles/inputs.less":{content:'@import "./variables/ui-variables"; // Fallback for @use-custom-controls\n@import "ui-variables";\n\n@component-size: @component-icon-size; // use for text-less controls like radio, checkboxes etc.\n@component-margin-side: .3em;\n@text-component-height: 2em;\n@component-background-color: mix(@text-color, @base-background-color, 20%);\n\n\n//\n// Overrides\n// -------------------------\n\ninput.input-radio,\ninput.input-checkbox,\ninput.input-toggle {\n  margin-top: 0; // Override Bootstrap\'s 4px\n}\n.input-label {\n  margin-bottom: 0;\n}\n\n//\n// Mixins\n// -------------------------\n\n.input-field-mixin() {\n  padding: .25em .4em;\n  line-height: 1.5; // line-height + padding = @text-component-height\n  border-radius: @component-border-radius;\n  border: 1px solid @input-border-color;\n  background-color: @input-background-color;\n  &::-webkit-input-placeholder {\n    color: @text-color-subtle;\n  }\n  &:invalid {\n    color: @text-color-error;\n    border-color: @background-color-error;\n  }\n}\n\n.input-block-mixin() {\n  display: block;\n  width: 100%;\n}\n\n\n//\n// Checkbox\n// -------------------------\n\n.input-checkbox {\n  vertical-align: middle;\n\n  & when (@use-custom-controls) {\n    -webkit-appearance: none;\n    display: inline-block;\n    position: relative;\n    width: @component-size;\n    height: @component-size;\n    font-size: inherit;\n    border-radius: @component-border-radius;\n    background-color: @component-background-color;\n    transition: background-color .16s cubic-bezier(0.5, 0.15, 0.2, 1);\n\n    &&:focus {\n      outline: 0; // TODO: Add it back\n    }\n    &:active {\n      background-color: @background-color-info;\n    }\n\n    &:before,\n    &:after {\n      content: "";\n      position: absolute;\n      top: @component-size * .75;\n      left: @component-size * .4;\n      height: 2px;\n      border-radius: 1px;\n      background-color: @base-background-color;\n      transform-origin: 0 0;\n      opacity: 0;\n      transition: transform .1s cubic-bezier(0.5, 0.15, 0.2, 1), opacity .1s cubic-bezier(0.5, 0.15, 0.2, 1);\n    }\n    &:before {\n      width: @component-size * .33;\n      transform: translate3d(0,0,0) rotate(225deg) scale(0);\n    }\n    &:after {\n      width: @component-size * .66;\n      margin: -1px;\n      transform: translate3d(0,0,0) rotate(-45deg) scale(0);\n      transition-delay: .05s;\n    }\n\n    &:checked {\n      background-color: @background-color-info;\n      &:active {\n        background-color: @component-background-color;\n      }\n      &:before {\n        opacity: 1;\n        transform: translate3d(0,0,0) rotate(225deg) scale(1);\n        transition-delay: .05s;\n      }\n      &:after {\n        opacity: 1;\n        transform: translate3d(0, 0, 0) rotate(-45deg) scale(1);\n        transition-delay: 0;\n      }\n    }\n\n    &:indeterminate {\n      background-color: @background-color-info;\n      &:active {\n        background-color: @component-background-color;\n      }\n      &:after {\n        opacity: 1;\n        transform: translate3d(@component-size * -.14, @component-size * -.25, 0) rotate(0deg) scale(1);\n        transition-delay: 0;\n      }\n    }\n  }\n}\n\n\n//\n// Color\n// -------------------------\n\n\n.input-color {\n  vertical-align: middle;\n\n  & when (@use-custom-controls) {\n    -webkit-appearance: none;\n    padding: 0;\n    width: @component-size * 2.5;\n    height: @component-size * 2.5;\n    border-radius: 50%;\n    border: 2px solid @input-border-color;\n    background-color: @input-background-color;\n    &::-webkit-color-swatch-wrapper { padding: 0; }\n    &::-webkit-color-swatch {\n      border: 1px solid hsla(0,0%,0%,.1);\n      border-radius: 50%;\n      transition: transform .16s cubic-bezier(0.5, 0.15, 0.2, 1);\n      &:active {\n        transition-duration: 0s;\n        transform: scale(.9);\n      }\n    }\n  }\n}\n\n\n\n//\n// Label\n// -------------------------\n\n.input-label {\n  .input-radio,\n  .input-checkbox,\n  .input-toggle {\n    margin-top: -.25em; // Vertical center (visually) - since most labels are upper case.\n    margin-right: @component-margin-side;\n  }\n}\n\n\n//\n// Number\n// -------------------------\n\n.input-number {\n  vertical-align: middle;\n\n  & when (@use-custom-controls) {\n    .input-field-mixin();\n    position: relative;\n    width: auto;\n    .platform-darwin & {\n      padding-right: 1.2em; // space for the spin button\n      &::-webkit-inner-spin-button {\n        -webkit-appearance: menulist-button;\n        position: absolute;\n        top: 1px;\n        bottom: 1px;\n        right: 1px;\n        width: calc(.6em ~\'+\' 9px); // magic numbers, OMG!\n        outline: 1px solid @input-background-color;\n        outline-offset: -1px; // reduces border radius (that can\'t be changed)\n        border-right: .2em solid @background-color-highlight; // a bit more padding\n        background-color: @background-color-highlight;\n        transition: transform .16s cubic-bezier(0.5, 0.15, 0.2, 1);\n        &:active {\n          transform: scale(.9);\n          transition-duration: 0s;\n        }\n      }\n    }\n  }\n}\n\n\n//\n// Radio\n// -------------------------\n\n.input-radio {\n  vertical-align: middle;\n\n  & when (@use-custom-controls) {\n    -webkit-appearance: none;\n    display: inline-block;\n    position: relative;\n    width: @component-size;\n    height: @component-size;\n    font-size: inherit;\n    border-radius: 50%;\n    background-color: @component-background-color;\n    transition: background-color .16s cubic-bezier(0.5, 0.15, 0.2, 1);\n\n    &:before {\n      content: "";\n      position: absolute;\n      width: inherit;\n      height: inherit;\n      border-radius: inherit;\n      border: @component-size/3 solid transparent;\n      background-clip: content-box;\n      background-color: @base-background-color;\n      transform: scale(0);\n      transition: transform .1s cubic-bezier(0.5, 0.15, 0.2, 1);\n    }\n    &&:focus {\n      outline: none;\n    }\n    &:active {\n      background-color: @background-color-info;\n    }\n    &:checked {\n      background-color: @background-color-info;\n      &:before {\n        transform: scale(1);\n      }\n    }\n  }\n}\n\n\n//\n// Range (Slider)\n// -------------------------\n\n.input-range {\n  & when (@use-custom-controls) {\n    -webkit-appearance: none;\n    margin: @component-padding 0;\n    height: 4px;\n    border-radius: @component-border-radius;\n    background-color: @component-background-color;\n    &::-webkit-slider-thumb {\n      -webkit-appearance: none;\n      width: @component-size;\n      height: @component-size;\n      border-radius: 50%;\n      background-color: @background-color-info;\n      transition: transform .16s;\n      &:active {\n        transition-duration: 0s;\n        transform: scale(.9);\n      }\n    }\n  }\n}\n\n\n//\n// Search\n// -------------------------\n\n.input-search {\n  .input-block-mixin();\n  &&::-webkit-search-cancel-button {\n    -webkit-appearance: searchfield-cancel-button;\n  }\n\n  & when (@use-custom-controls) {\n    .input-field-mixin();\n  }\n}\n\n\n//\n// Select\n// -------------------------\n\n.input-select {\n  vertical-align: middle;\n\n  & when (@use-custom-controls) {\n    height: calc(@text-component-height ~\'+\' 2px); // + 2px? Magic!\n    border-radius: @component-border-radius;\n    border: 1px solid @button-border-color;\n    background-color: @button-background-color;\n  }\n}\n\n\n//\n// Text\n// -------------------------\n\n.input-text {\n  .input-block-mixin();\n\n  & when (@use-custom-controls) {\n    .input-field-mixin();\n  }\n}\n\n\n//\n// Text Area\n// -------------------------\n\n.input-textarea {\n  .input-block-mixin();\n\n  & when (@use-custom-controls) {\n    .input-field-mixin();\n  }\n}\n\n\n//\n// Toggle\n// -------------------------\n\n.input-toggle {\n  & when (@use-custom-controls) {\n    -webkit-appearance: none;\n    display: inline-block;\n    position: relative;\n    font-size: inherit;\n    width: @component-size * 2;\n    height: @component-size;\n    vertical-align: middle;\n    border-radius: 2em;\n    background-color: @component-background-color;\n    transition: background-color .2s cubic-bezier(0.5, 0.15, 0.2, 1);\n\n    &&:focus {\n      outline: 0;\n    }\n    &:checked {\n      background-color: @background-color-info;\n    }\n\n    // Thumb\n    &:before {\n      content: "";\n      position: absolute;\n      width: @component-size;\n      height: @component-size;\n      border-radius: inherit;\n      border: @component-size/4 solid transparent;\n      background-clip: content-box;\n      background-color: @base-background-color;\n      transition: transform .2s cubic-bezier(0.5, 0.15, 0.2, 1);\n    }\n    &:active:before {\n      opacity: .5;\n    }\n    &:checked:before {\n      transform: translate3d(100%, 0, 0);\n    }\n  }\n}\n',digest:"0611ff2f714f0ac6b9b35684b15986f4a732f35e"},"static/atom-ui/styles/layout.less":{content:'@import "ui-variables";\n@import "mixins/mixins";\n\n.padded {\n  padding: @component-padding;\n}\n\n// Blocks\n\n.center-block {\n  display: block;\n  margin-left: auto;\n  margin-right: auto;\n}\n\n// Must be div.block so as not to affect syntax highlighting.\nul.block,\ndiv.block {\n  margin-bottom: @component-padding;\n}\ndiv > ul.block:last-child,\ndiv > div.block:last-child {\n  margin-bottom: 0;\n}\n\n// Inline Blocks\n\n.inline-block,\n.inline-block-tight {\n  display: inline-block;\n  vertical-align: middle;\n}\n.inline-block {\n  margin-right: @component-padding;\n}\n.inline-block-tight {\n  margin-right: @component-padding/2;\n}\ndiv > .inline-block:last-child,\ndiv > .inline-block-tight:last-child {\n  margin-right: 0;\n}\n\n.inline-block .inline-block {\n  vertical-align: top;\n}\n\n// Centering\n// -------------------------\n\n.pull-center {\n  margin-left: auto;\n  margin-right: auto;\n}\n\n// Floats\n// -------------------------\n\n// Use left margin when it\'s in a float: right element.\n// Sets the margin correctly when inline blocks are hidden and shown.\n.pull-right {\n  float: right !important;\n\n  .inline-block {\n    margin-right: 0;\n    margin-left: @component-padding;\n  }\n  .inline-block-tight {\n    margin-right: 0;\n    margin-left: @component-padding/2;\n  }\n\n  > .inline-block:first-child,\n  > .inline-block-tight:first-child {\n    margin-left: 0;\n  }\n}\n\n.pull-left {\n  float: left !important;\n}\n\n.clearfix {\n  .clearfix();\n}\n',digest:"8abf0895a6d88f60a8fb1e7ecba0b217b7526aef"},"static/atom-ui/styles/lists.less":{content:'@import "variables/variables";\n@import "ui-variables";\n@import "mixins/mixins";\n\n@import "octicon-mixins";\n\n//\n// List options\n// --------------------------------------------------\n\n// Unstyled keeps list items block level, just removes default browser padding and list-style\n.list-unstyled {\n  padding-left: 0;\n  list-style: none;\n}\n\n// Inline turns list items into inline-block\n.list-inline {\n  .list-unstyled();\n  margin-left: -5px;\n\n  > li {\n    display: inline-block;\n    padding-left: 5px;\n    padding-right: 5px;\n  }\n}\n\n\n//\n// List groups\n// --------------------------------------------------\n\n// Mixins\n\n.list-group-item-variant(@state; @background; @color) {\n  .list-group-item-@{state} {\n    color: @color;\n    background-color: @background;\n\n    a&,\n    button& {\n      color: @color;\n\n      .list-group-item-heading {\n        color: inherit;\n      }\n\n      &:hover,\n      &:focus {\n        color: @color;\n        background-color: darken(@background, 5%);\n      }\n      &.active,\n      &.active:hover,\n      &.active:focus {\n        color: #fff;\n        background-color: @color;\n        border-color: @color;\n      }\n    }\n  }\n}\n\n\n\n// Individual list items\n//\n// Use on `li`s or `div`s within the `.list-group` parent.\n\n.list-group-item {\n  position: relative;\n  display: block;\n  padding: 10px 15px;\n  // Place the border on the list items and negative margin up for better styling\n  margin-bottom: -1px;\n  background-color: @list-group-bg;\n  border: 1px solid @list-group-border;\n\n  // Round the first and last items\n  &:first-child {\n    .border-top-radius(@list-group-border-radius);\n  }\n  &:last-child {\n    margin-bottom: 0;\n    .border-bottom-radius(@list-group-border-radius);\n  }\n}\n\n\n// Interactive list items\n//\n// Use anchor or button elements instead of `li`s or `div`s to create interactive items.\n// Includes an extra `.active` modifier class for showing selected items.\n\na.list-group-item,\nbutton.list-group-item {\n  color: @list-group-link-color;\n\n  .list-group-item-heading {\n    color: @list-group-link-heading-color;\n  }\n\n  // Hover state\n  &:hover,\n  &:focus {\n    text-decoration: none;\n    color: @list-group-link-hover-color;\n    background-color: @list-group-hover-bg;\n  }\n}\n\nbutton.list-group-item {\n  width: 100%;\n  text-align: left;\n}\n\n.list-group-item {\n  // Disabled state\n  &.disabled,\n  &.disabled:hover,\n  &.disabled:focus {\n    background-color: @list-group-disabled-bg;\n    color: @list-group-disabled-color;\n    cursor: @cursor-disabled;\n\n    // Force color to inherit for custom content\n    .list-group-item-heading {\n      color: inherit;\n    }\n    .list-group-item-text {\n      color: @list-group-disabled-text-color;\n    }\n  }\n\n  // Active class on item itself, not parent\n  &.active,\n  &.active:hover,\n  &.active:focus {\n    z-index: 2; // Place active items above their siblings for proper border styling\n    color: @list-group-active-color;\n    background-color: @list-group-active-bg;\n    border-color: @list-group-active-border;\n\n    // Force color to inherit for custom content\n    .list-group-item-heading,\n    .list-group-item-heading > small,\n    .list-group-item-heading > .small {\n      color: inherit;\n    }\n    .list-group-item-text {\n      color: @list-group-active-text-color;\n    }\n  }\n}\n\n\n// Contextual variants\n//\n// Add modifier classes to change text and background color on individual items.\n// Organizationally, this must come after the `:hover` states.\n\n.list-group-item-variant(success; @state-success-bg; @state-success-text);\n.list-group-item-variant(info; @state-info-bg; @state-info-text);\n.list-group-item-variant(warning; @state-warning-bg; @state-warning-text);\n.list-group-item-variant(danger; @state-danger-bg; @state-danger-text);\n\n\n// Custom content options\n//\n// Extra classes for creating well-formatted content within `.list-group-item`s.\n\n.list-group-item-heading {\n  margin-top: 0;\n  margin-bottom: 5px;\n}\n.list-group-item-text {\n  margin-bottom: 0;\n  line-height: 1.3;\n}\n\n\n\n// This is a bootstrap override\n// ---------------------------------------------\n\n.list-group,\n.list-group .list-group-item {\n  background-color: transparent;\n  border: none;\n  padding: 0;\n  margin: 0;\n  position: static;\n}\n\n.list-group,\n.list-tree {\n  margin: 0;\n  padding: 0;\n  list-style: none;\n  cursor: default;\n\n  li:not(.list-nested-item),\n  li.list-nested-item > .list-item {\n    line-height: @component-line-height;\n    text-wrap: none;\n    white-space: nowrap;\n  }\n\n  // The background highlight uses ::before rather than the item background so\n  // it can span the entire width of the parent container rather than the size\n  // of the list item.\n  .selected::before {\n    content: \'\';\n    background-color: @background-color-selected;\n    position: absolute;\n    left: 0;\n    right: 0;\n    height: @component-line-height;\n  }\n\n  // Make sure the background highlight is below the content.\n  .selected > * {\n    position: relative;\n  }\n\n  .icon::before {\n    margin-right: @component-icon-padding;\n    position: relative;\n    top: 1px;\n  }\n  .no-icon {\n    padding-left: @component-icon-padding + @component-icon-size;\n  }\n}\n\n\n\n//\n// List Tree\n// --------------------------------------------------\n\n// Handle indentation of the tree. Assume disclosure arrows.\n\n.list-tree {\n  .list-nested-item > .list-tree > li,\n  .list-nested-item > .list-group > li {\n    padding-left: @component-icon-size + @component-icon-padding;\n  }\n\n  &.has-collapsable-children {\n    @disclosure-arrow-padding: @disclosure-arrow-size + @component-icon-padding;\n    li.list-item {\n      margin-left: @disclosure-arrow-padding;\n    }\n\n    .list-nested-item.collapsed > .list-group,\n    .list-nested-item.collapsed > .list-tree {\n      display: none;\n    }\n\n    // Nested items always get disclosure arrows\n    .list-nested-item > .list-item {\n      .octicon(chevron-down, @disclosure-arrow-size);\n      &::before{\n        position: relative;\n        top: -1px;\n        margin-right: @component-icon-padding;\n      }\n    }\n    .list-nested-item.collapsed > .list-item {\n      .octicon(chevron-right, @disclosure-arrow-size);\n      &::before{\n        left: 1px;\n      }\n    }\n\n    .list-nested-item > .list-tree > li,\n    .list-nested-item > .list-group > li {\n      padding-left: @disclosure-arrow-padding;\n    }\n\n    // You want a subtree to be flat -- no collapsable children\n    .has-flat-children,\n    &.has-flat-children {\n      li.list-item {\n        margin-left: 0;\n      }\n    }\n  }\n}\n',digest:"3d35a95a6e5d74bb2cddfe5b704d89fc757ca962"},"static/atom-ui/styles/loading.less":{content:"//\n// Loading\n// --------------------------------------------------\n\n.loading-spinner(@size) {\n  display: block;\n  width: @size;\n  height: @size;\n  background-image: url(images/octocat-spinner-128.gif);\n  background-repeat: no-repeat;\n  background-size: cover;\n\n  &.inline-block {\n    display: inline-block;\n  }\n}\n\n.loading-spinner-tiny   { .loading-spinner(16px); }\n.loading-spinner-small  { .loading-spinner(32px); }\n.loading-spinner-medium { .loading-spinner(48px); }\n.loading-spinner-large  { .loading-spinner(64px); }\n",digest:"d7fac726ef76e0c8ba33629fc4551f97748bf83f"},"static/atom-ui/styles/messages.less":{content:'@import "ui-variables";\n\n.info-messages,\n.error-messages {\n  margin: 0;\n  padding: 0;\n  list-style: none;\n}\n\n.error-messages {\n  color: @text-color-error;\n}\n\nul.background-message {\n  font-size: @font-size * 3;\n\n  margin: 0;\n  padding: 0;\n\n  li {\n    margin: 0;\n    padding: 0;\n    list-style: none;\n  }\n\n  &.centered {\n    display: flex;\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n\n    align-items: center;\n    text-align: center;\n\n    li {\n      width: 100%;\n    }\n  }\n}\n',digest:"b549523e13f2ad116c02a6dfb42db8e1e4891e43"},"static/atom-ui/styles/mixins/mixins.less":{content:'@import "ui-variables";\n\n// Core mixins\n// ----------------------------------------\n\n// Focus\n//\n.tab-focus() {\n  outline: 2px auto @text-color-info;\n  outline-offset: -2px;\n}\n\n\n// Border-radius\n//\n.border-top-radius(@radius) {\n  border-top-right-radius: @radius;\n  border-top-left-radius: @radius;\n}\n.border-right-radius(@radius) {\n  border-bottom-right-radius: @radius;\n  border-top-right-radius: @radius;\n}\n.border-bottom-radius(@radius) {\n  border-bottom-right-radius: @radius;\n  border-bottom-left-radius: @radius;\n}\n.border-left-radius(@radius) {\n  border-bottom-left-radius: @radius;\n  border-top-left-radius: @radius;\n}\n\n\n// Clearfix\n//\n// For modern browsers\n// 1. The space content is one way to avoid an Opera bug when the\n//    contenteditable attribute is included anywhere else in the document.\n//    Otherwise it causes space to appear at the top and bottom of elements\n//    that are clearfixed.\n// 2. The use of `table` rather than `block` is only necessary if using\n//    `:before` to contain the top-margins of child elements.\n//\n// Source: http://nicolasgallagher.com/micro-clearfix-hack/\n\n.clearfix() {\n  &:before,\n  &:after {\n    content: " "; // 1\n    display: table; // 2\n  }\n  &:after {\n    clear: both;\n  }\n}\n\n\n// CSS image replacement\n//\n// Heads up! v3 launched with only `.hide-text()`, but per our pattern for\n// mixins being reused as classes with the same name, this doesn\'t hold up. As\n// of v3.0.1 we have added `.text-hide()` and deprecated `.hide-text()`.\n//\n// Source: https://github.com/h5bp/html5-boilerplate/commit/aa0396eae757\n\n// Deprecated as of v3.0.1 (has been removed in v4)\n.hide-text() {\n  font: ~"0/0" a;\n  color: transparent;\n  text-shadow: none;\n  background-color: transparent;\n  border: 0;\n}\n\n// New mixin to use as of v3.0.1\n.text-hide() {\n  .hide-text();\n}\n\n\n// Text overflow\n// Requires inline-block or block for proper styling\n\n.text-overflow() {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n',digest:"f58c7339263968781cab4843b9453ae5a8d5c54f"},"static/atom-ui/styles/modals.less":{content:'@import "ui-variables";\n\n//\n// Modals\n// --------------------------------------------------\n\n.overlay, // deprecated .overlay\natom-panel.modal {\n  position: absolute;\n  display: block;\n  top: 0;\n  left: 50%;\n  width: 500px;\n  margin-left: -250px;\n  z-index: 9999;\n  box-sizing: border-box;\n  border-top: none;\n  border-top-left-radius: 0;\n  border-top-right-radius: 0;\n\n  color: @text-color;\n  background-color: @overlay-background-color;\n\n  padding: 10px;\n\n  // shrink modals when window gets narrow\n  @media (max-width: 500px) {\n    & {\n      width: 100%;\n      left: 0;\n      margin-left: 0;\n    }\n  }\n\n  h1 {\n    margin-top: 0;\n    color: @text-color-highlight;\n    font-size: 1.6em;\n    font-weight: bold;\n  }\n\n  h2 {\n    font-size: 1.3em;\n  }\n\n  atom-text-editor[mini] {\n    margin-bottom: 10px;\n  }\n\n  .message {\n    padding-top: 5px;\n    font-size: 11px;\n  }\n\n  &.mini {\n    width: 200px;\n    margin-left: -100px;\n    font-size: 12px;\n  }\n}\n\n\n// Deprecated: overlay, from-top, from-bottom, floating\n// --------------------------------------------------\n// TODO: Remove these!\n\n.overlay.from-top {\n  top: 0;\n  border-top: none;\n  border-top-left-radius: 0;\n  border-top-right-radius: 0;\n}\n\n.overlay.from-bottom {\n  bottom: 0;\n  border-bottom: none;\n  border-bottom-left-radius: 0;\n  border-bottom-right-radius: 0;\n}\n\n.overlay.floating {\n  left: auto;\n}\n',digest:"88449574ac1ef93cc1f5cb71ca2caf3b2831d565"},"static/atom-ui/styles/panels.less":{content:'@import "ui-variables";\n\n//\n// Panels\n// --------------------------------------------------\n\n.tool-panel, // deprecated: .tool-panel\n.panel, // deprecated: .panel\natom-panel {\n  background-color: @tool-panel-background-color;\n}\n\n.inset-panel {\n  border-radius: @component-border-radius;\n  background-color: @inset-panel-background-color;\n}\n\n.panel-heading {\n  margin: 0;\n  padding: @component-padding;\n  border-radius: 0;\n  font-size: @font-size;\n  line-height: 1;\n  background-color: @panel-heading-background-color;\n\n  .inset-panel & {\n    border-radius: @component-border-radius @component-border-radius 0 0;\n  }\n\n  .btn {\n    @btn-height: @component-line-height - 5px;\n    height: @btn-height;\n    line-height: @btn-height;\n    font-size: @font-size - 2px;\n    position: relative;\n    top: -5px;\n  }\n}\n',digest:"28c03c4e82c44cc0d11fcfd02187affc984dc4be"},"static/atom-ui/styles/private/alerts.less":{content:'@import "../variables/variables";\n@import "ui-variables";\n\n//\n// Alerts\n// --------------------------------------------------\n\n//## Define alert colors, border radius, and padding.\n\n@alert-padding:               15px;\n@alert-border-radius:         @border-radius-base;\n@alert-link-font-weight:      bold;\n\n@alert-success-bg:            @state-success-bg;\n@alert-success-text:          @state-success-text;\n@alert-success-border:        @state-success-border;\n\n@alert-info-bg:               @state-info-bg;\n@alert-info-text:             @state-info-text;\n@alert-info-border:           @state-info-border;\n\n@alert-warning-bg:            @state-warning-bg;\n@alert-warning-text:          @state-warning-text;\n@alert-warning-border:        @state-warning-border;\n\n@alert-danger-bg:             @state-danger-bg;\n@alert-danger-text:           @state-danger-text;\n@alert-danger-border:         @state-danger-border;\n\n\n//## variant mixin\n\n.alert-variant(@background; @border; @text-color) {\n  background-color: @background;\n  border-color: @border;\n  color: @text-color;\n\n  hr {\n    border-top-color: darken(@border, 5%);\n  }\n  .alert-link {\n    color: darken(@text-color, 10%);\n  }\n}\n\n\n// Base styles\n// -------------------------\n\n.alert {\n  padding: @alert-padding;\n  margin-bottom: @line-height-computed;\n  border: 1px solid transparent;\n  border-radius: @alert-border-radius;\n\n  // Headings for larger alerts\n  h4 {\n    margin-top: 0;\n    // Specified for the h4 to prevent conflicts of changing @headings-color\n    color: inherit;\n  }\n\n  // Provide class for links that match alerts\n  .alert-link {\n    font-weight: @alert-link-font-weight;\n  }\n\n  // Improve alignment and spacing of inner content\n  > p,\n  > ul {\n    margin-bottom: 0;\n  }\n\n  > p + p {\n    margin-top: 5px;\n  }\n}\n\n// Dismissible alerts\n//\n// Expand the right padding and account for the close button\'s positioning.\n\n.alert-dismissable, // The misspelled .alert-dismissable was deprecated in 3.2.0.\n.alert-dismissible {\n  padding-right: (@alert-padding + 20);\n\n  // Adjust close link position\n  .close {\n    position: relative;\n    top: -2px;\n    right: -21px;\n    color: inherit;\n  }\n}\n\n// Alternate styles\n//\n// Generate contextual modifier classes for colorizing the alert.\n\n.alert-success {\n  .alert-variant(@alert-success-bg; @alert-success-border; @alert-success-text);\n}\n\n.alert-info {\n  .alert-variant(@alert-info-bg; @alert-info-border; @alert-info-text);\n}\n\n.alert-warning {\n  .alert-variant(@alert-warning-bg; @alert-warning-border; @alert-warning-text);\n}\n\n.alert-danger {\n  .alert-variant(@alert-danger-bg; @alert-danger-border; @alert-danger-text);\n}\n',digest:"9419c3622f08e1c99a5eaa25196791f0f129219e"},"static/atom-ui/styles/private/close.less":{content:'//\n// Close icon (deprecated)\n// --------------------------------------------------\n\n.close {\n  @font-size-base:              14px;\n  @close-font-weight:           bold;\n  @close-color:                 #000;\n  @close-text-shadow:           0 1px 0 #fff;\n\n  float: right;\n  font-size: (@font-size-base * 1.5);\n  font-weight: @close-font-weight;\n  line-height: 1;\n  color: @close-color;\n  text-shadow: @close-text-shadow;\n  opacity: .2;\n\n  &:hover,\n  &:focus {\n    color: @close-color;\n    text-decoration: none;\n    cursor: pointer;\n    opacity: .5;\n  }\n\n  // Additional properties for button version\n  // iOS requires the button element instead of an anchor tag.\n  // If you want the anchor version, it requires `href="#"`.\n  // See https://developer.mozilla.org/en-US/docs/Web/Events/click#Safari_Mobile\n  button& {\n    padding: 0;\n    cursor: pointer;\n    background: transparent;\n    border: 0;\n    -webkit-appearance: none;\n  }\n}\n',digest:"cea1d83a2d61e483c5e943877738d5c230ec2c1c"},"static/atom-ui/styles/private/code.less":{content:'@import "../variables/variables";\n@import "ui-variables";\n\n//\n// Code (inline and block)\n// --------------------------------------------------\n\n@code-color: @text-color-highlight;\n@code-bg: @background-color-highlight;\n\n@pre-color:                   @code-color;\n@pre-bg:                      @code-bg;\n@pre-border-color:            @base-border-color;\n@pre-scrollable-max-height:   340px;\n\n// Inline and block code styles\ncode,\nkbd,\npre,\nsamp {\n  font-family: @font-family-monospace;\n}\n\n// Inline code\ncode {\n  padding: 2px 4px;\n  font-size: 90%;\n  color: @code-color;\n  background-color: @code-bg;\n  border-radius: @border-radius-base;\n}\n\n// User input typically entered via keyboard\nkbd {\n  padding: 2px 4px;\n  font-size: 90%;\n  color: @code-color;\n  background-color: @code-bg;\n  border-radius: @border-radius-small;\n\n  kbd {\n    padding: 0;\n    font-size: 100%;\n    font-weight: bold;\n  }\n}\n\n// Blocks of code\npre {\n  display: block;\n  padding: ((@line-height-computed - 1) / 2);\n  margin: 0 0 (@line-height-computed / 2);\n  font-size: (@font-size-base - 1); // 14px to 13px\n  line-height: @line-height-base;\n  word-break: break-all;\n  word-wrap: break-word;\n  color: @pre-color;\n  background-color: @pre-bg;\n  border: 1px solid @pre-border-color;\n  border-radius: @border-radius-base;\n\n  // Account for some code outputs that place code tags in pre tags\n  code {\n    padding: 0;\n    font-size: inherit;\n    color: inherit;\n    white-space: pre-wrap;\n    background-color: transparent;\n    border-radius: 0;\n  }\n}\n\n// Enable scrollable blocks of code\n.pre-scrollable {\n  max-height: @pre-scrollable-max-height;\n  overflow-y: scroll;\n}\n',digest:"117b7c504d7d217641262f1e6ffc95a850270333"},"static/atom-ui/styles/private/forms.less":{content:'@import "../variables/variables";\n@import "ui-variables";\n@import "../mixins/mixins";\n\n//\n// Forms\n// --------------------------------------------------\n\n\n@input-bg:                       #fff; //** `<input>` background color\n@input-bg-disabled:              @gray-lighter; //** `<input disabled>` background color\n@input-color:                    @gray; //** Text color for `<input>`s\n@input-border:                   #ccc; //** `<input>` border color\n\n// TODO: Rename `@input-border-radius` to `@input-border-radius-base` in v4\n//** Default `.form-control` border radius\n// This has no effect on `<select>`s in some browsers, due to the limited stylability of `<select>`s in CSS.\n@input-border-radius:            @border-radius-base; //** Large `.form-control` border radius\n@input-border-radius-large:      @border-radius-large; //** Small `.form-control` border radius\n@input-border-radius-small:      @border-radius-small;\n@input-border-focus:             #66afe9; //** Border color for inputs on focus\n@input-color-placeholder:        #999; //** Placeholder text color\n@input-height-base:              (@line-height-computed + (@padding-base-vertical * 2) + 2); //** Default `.form-control` height\n@input-height-large:             (ceil(@font-size-large * @line-height-large) + (@padding-large-vertical * 2) + 2); //** Large `.form-control` height\n@input-height-small:             (floor(@font-size-small * @line-height-small) + (@padding-small-vertical * 2) + 2); //** Small `.form-control` height\n\n@form-group-margin-bottom:       15px; //** `.form-group` margin\n\n@legend-color:                   @gray-dark;\n@legend-border-color:            #e5e5e5;\n\n@input-group-addon-bg:           @gray-lighter; //** Background color for textual input addons\n@input-group-addon-border-color: @input-border; //** Border color for textual input addons\n\n@cursor-disabled:                not-allowed; //** Disabled cursor for form controls and buttons.\n\n@grid-gutter-width:         30px; //** Padding between columns. Gets divided in half for the left and right.\n\n\n// Form validation states\n//\n// Used in forms.less to generate the form validation CSS for warnings, errors,\n// and successes.\n\n.form-control-validation(@text-color: #555; @border-color: #ccc; @background-color: #f5f5f5) {\n  // Color the label and help text\n  .help-block,\n  .control-label,\n  .radio,\n  .checkbox,\n  .radio-inline,\n  .checkbox-inline,\n  &.radio label,\n  &.checkbox label,\n  &.radio-inline label,\n  &.checkbox-inline label  {\n    color: @text-color;\n  }\n  // Set the border and box shadow on specific inputs to match\n  .form-control {\n    border-color: @border-color;\n    box-shadow: inset 0 1px 1px rgba(0,0,0,.075); // Redeclare so transitions work\n    &:focus {\n      border-color: darken(@border-color, 10%);\n      box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 6px lighten(@border-color, 20%);\n    }\n  }\n  // Set validation states also for addons\n  .input-group-addon {\n    color: @text-color;\n    border-color: @border-color;\n    background-color: @background-color;\n  }\n  // Optional feedback icon\n  .form-control-feedback {\n    color: @text-color;\n  }\n}\n\n\n// Form control focus state\n//\n// Generate a customized focus state and for any input with the specified color,\n// which defaults to the `@input-border-focus` variable.\n//\n// We highly encourage you to not customize the default value, but instead use\n// this to tweak colors on an as-needed basis. This aesthetic change is based on\n// WebKit\'s default styles, but applicable to a wider range of browsers. Its\n// usability and accessibility should be taken into account with any change.\n//\n// Example usage: change the default blue border and shadow to white for better\n// contrast against a dark gray background.\n.form-control-focus(@color: @input-border-focus) {\n  @color-rgba: rgba(red(@color), green(@color), blue(@color), .6);\n  &:focus {\n    border-color: @color;\n    outline: 0;\n    box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px @color-rgba;\n  }\n}\n\n// Form control sizing\n//\n// Relative text size, padding, and border-radii changes for form controls. For\n// horizontal sizing, wrap controls in the predefined grid classes. `<select>`\n// element gets special love because it\'s special, and that\'s a fact!\n.input-size(@input-height; @padding-vertical; @padding-horizontal; @font-size; @line-height; @border-radius) {\n  height: @input-height;\n  padding: @padding-vertical @padding-horizontal;\n  font-size: @font-size;\n  line-height: @line-height;\n  border-radius: @border-radius;\n\n  select& {\n    height: @input-height;\n    line-height: @input-height;\n  }\n\n  textarea&,\n  select[multiple]& {\n    height: auto;\n  }\n}\n\n// Placeholder text\n.placeholder(@color: @input-color-placeholder) {\n  &::-webkit-input-placeholder  { color: @color; } // Safari and Chrome\n}\n\n// Creates a wrapper for a series of columns\n.make-row(@gutter: @grid-gutter-width) {\n  margin-left:  ceil((@gutter / -2));\n  margin-right: floor((@gutter / -2));\n  &:extend(.clearfix all);\n}\n\n\n// -----------------------------------------------------\n\n\n// Normalize non-controls\n//\n// Restyle and baseline non-control form elements.\n\nfieldset {\n  padding: 0;\n  margin: 0;\n  border: 0;\n  // Chrome and Firefox set a `min-width: min-content;` on fieldsets,\n  // so we reset that to ensure it behaves more like a standard block element.\n  // See https://github.com/twbs/bootstrap/issues/12359.\n  min-width: 0;\n}\n\nlegend {\n  display: block;\n  width: 100%;\n  padding: 0;\n  margin-bottom: @line-height-computed;\n  font-size: (@font-size-base * 1.5);\n  line-height: inherit;\n  color: @legend-color;\n  border: 0;\n  border-bottom: 1px solid @legend-border-color;\n}\n\nlabel {\n  display: inline-block;\n  max-width: 100%; // Force IE8 to wrap long content (see https://github.com/twbs/bootstrap/issues/13141)\n  margin-bottom: 5px;\n  font-weight: bold;\n}\n\n\n// Normalize form controls\n//\n// While most of our form styles require extra classes, some basic normalization\n// is required to ensure optimum display with or without those classes to better\n// address browser inconsistencies.\n\n// Override content-box in Normalize (* isn\'t specific enough)\ninput[type="search"] {\n  box-sizing: border-box;\n}\n\n// Position radios and checkboxes better\ninput[type="radio"],\ninput[type="checkbox"] {\n  margin: 4px 0 0;\n  margin-top: 1px \\9; // IE8-9\n  line-height: normal;\n}\n\ninput[type="file"] {\n  display: block;\n}\n\n// Make range inputs behave like textual form controls\ninput[type="range"] {\n  display: block;\n  width: 100%;\n}\n\n// Make multiple select elements height not fixed\nselect[multiple],\nselect[size] {\n  height: auto;\n}\n\n// Focus for file, radio, and checkbox\ninput[type="file"]:focus,\ninput[type="radio"]:focus,\ninput[type="checkbox"]:focus {\n  .tab-focus();\n}\n\n// Adjust output element\noutput {\n  display: block;\n  padding-top: (@padding-base-vertical + 1);\n  font-size: @font-size-base;\n  line-height: @line-height-base;\n  color: @input-color;\n}\n\n\n// Common form controls\n//\n// Shared size and type resets for form controls. Apply `.form-control` to any\n// of the following form controls:\n//\n// select\n// textarea\n// input[type="text"]\n// input[type="password"]\n// input[type="datetime"]\n// input[type="datetime-local"]\n// input[type="date"]\n// input[type="month"]\n// input[type="time"]\n// input[type="week"]\n// input[type="number"]\n// input[type="email"]\n// input[type="url"]\n// input[type="search"]\n// input[type="tel"]\n// input[type="color"]\n\n.form-control {\n  display: block;\n  width: 100%;\n  height: @input-height-base; // Make inputs at least the height of their button counterpart (base line-height + padding + border)\n  padding: @padding-base-vertical @padding-base-horizontal;\n  font-size: @font-size-base;\n  line-height: @line-height-base;\n  color: @input-color;\n  background-color: @input-bg;\n  background-image: none; // Reset unusual Firefox-on-Android default style; see https://github.com/necolas/normalize.css/issues/214\n  border: 1px solid @input-border;\n  border-radius: @input-border-radius; // Note: This has no effect on <select>s in some browsers, due to the limited stylability of <select>s in CSS.\n  box-shadow: inset 0 1px 1px rgba(0,0,0,.075);\n  transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;\n\n  // Customize the `:focus` state to imitate native WebKit styles.\n  .form-control-focus();\n\n  // Placeholder\n  .placeholder();\n\n  // Unstyle the caret on `<select>`s in IE10+.\n  &::-ms-expand {\n    border: 0;\n    background-color: transparent;\n  }\n\n  // Disabled and read-only inputs\n  //\n  // HTML5 says that controls under a fieldset > legend:first-child won\'t be\n  // disabled if the fieldset is disabled. Due to implementation difficulty, we\n  // don\'t honor that edge case; we style them as disabled anyway.\n  &[disabled],\n  &[readonly],\n  fieldset[disabled] & {\n    background-color: @input-bg-disabled;\n    opacity: 1; // iOS fix for unreadable disabled content; see https://github.com/twbs/bootstrap/issues/11655\n  }\n\n  &[disabled],\n  fieldset[disabled] & {\n    cursor: @cursor-disabled;\n  }\n\n  // Reset height for `textarea`s\n  textarea& {\n    height: auto;\n  }\n}\n\n\n// Form groups\n//\n// Designed to help with the organization and spacing of vertical forms. For\n// horizontal forms, use the predefined grid classes.\n\n.form-group {\n  margin-bottom: @form-group-margin-bottom;\n}\n\n\n// Checkboxes and radios\n//\n// Indent the labels to position radios/checkboxes as hanging controls.\n\n.radio,\n.checkbox {\n  position: relative;\n  display: block;\n  margin-top: 10px;\n  margin-bottom: 10px;\n\n  label {\n    min-height: @line-height-computed; // Ensure the input doesn\'t jump when there is no text\n    padding-left: 20px;\n    margin-bottom: 0;\n    font-weight: normal;\n    cursor: pointer;\n  }\n}\n.radio input[type="radio"],\n.radio-inline input[type="radio"],\n.checkbox input[type="checkbox"],\n.checkbox-inline input[type="checkbox"] {\n  position: absolute;\n  margin-left: -20px;\n  margin-top: 4px \\9;\n}\n\n.radio + .radio,\n.checkbox + .checkbox {\n  margin-top: -5px; // Move up sibling radios or checkboxes for tighter spacing\n}\n\n// Radios and checkboxes on same line\n.radio-inline,\n.checkbox-inline {\n  position: relative;\n  display: inline-block;\n  padding-left: 20px;\n  margin-bottom: 0;\n  vertical-align: middle;\n  font-weight: normal;\n  cursor: pointer;\n}\n.radio-inline + .radio-inline,\n.checkbox-inline + .checkbox-inline {\n  margin-top: 0;\n  margin-left: 10px; // space out consecutive inline controls\n}\n\n// Apply same disabled cursor tweak as for inputs\n// Some special care is needed because <label>s don\'t inherit their parent\'s `cursor`.\n//\n// Note: Neither radios nor checkboxes can be readonly.\ninput[type="radio"],\ninput[type="checkbox"] {\n  &[disabled],\n  &.disabled,\n  fieldset[disabled] & {\n    cursor: @cursor-disabled;\n  }\n}\n// These classes are used directly on <label>s\n.radio-inline,\n.checkbox-inline {\n  &.disabled,\n  fieldset[disabled] & {\n    cursor: @cursor-disabled;\n  }\n}\n// These classes are used on elements with <label> descendants\n.radio,\n.checkbox {\n  &.disabled,\n  fieldset[disabled] & {\n    label {\n      cursor: @cursor-disabled;\n    }\n  }\n}\n\n\n// Static form control text\n//\n// Apply class to a `p` element to make any string of text align with labels in\n// a horizontal form layout.\n\n.form-control-static {\n  // Size it appropriately next to real form controls\n  padding-top: (@padding-base-vertical + 1);\n  padding-bottom: (@padding-base-vertical + 1);\n  // Remove default margin from `p`\n  margin-bottom: 0;\n  min-height: (@line-height-computed + @font-size-base);\n\n  &.input-lg,\n  &.input-sm {\n    padding-left: 0;\n    padding-right: 0;\n  }\n}\n\n\n// Form control sizing\n//\n// Build on `.form-control` with modifier classes to decrease or increase the\n// height and font-size of form controls.\n//\n// The `.form-group-* form-control` variations are sadly duplicated to avoid the\n// issue documented in https://github.com/twbs/bootstrap/issues/15074.\n\n.input-sm {\n  .input-size(@input-height-small; @padding-small-vertical; @padding-small-horizontal; @font-size-small; @line-height-small; @input-border-radius-small);\n}\n.form-group-sm {\n  .form-control {\n    height: @input-height-small;\n    padding: @padding-small-vertical @padding-small-horizontal;\n    font-size: @font-size-small;\n    line-height: @line-height-small;\n    border-radius: @input-border-radius-small;\n  }\n  select.form-control {\n    height: @input-height-small;\n    line-height: @input-height-small;\n  }\n  textarea.form-control,\n  select[multiple].form-control {\n    height: auto;\n  }\n  .form-control-static {\n    height: @input-height-small;\n    min-height: (@line-height-computed + @font-size-small);\n    padding: (@padding-small-vertical + 1) @padding-small-horizontal;\n    font-size: @font-size-small;\n    line-height: @line-height-small;\n  }\n}\n\n.input-lg {\n  .input-size(@input-height-large; @padding-large-vertical; @padding-large-horizontal; @font-size-large; @line-height-large; @input-border-radius-large);\n}\n.form-group-lg {\n  .form-control {\n    height: @input-height-large;\n    padding: @padding-large-vertical @padding-large-horizontal;\n    font-size: @font-size-large;\n    line-height: @line-height-large;\n    border-radius: @input-border-radius-large;\n  }\n  select.form-control {\n    height: @input-height-large;\n    line-height: @input-height-large;\n  }\n  textarea.form-control,\n  select[multiple].form-control {\n    height: auto;\n  }\n  .form-control-static {\n    height: @input-height-large;\n    min-height: (@line-height-computed + @font-size-large);\n    padding: (@padding-large-vertical + 1) @padding-large-horizontal;\n    font-size: @font-size-large;\n    line-height: @line-height-large;\n  }\n}\n\n\n// Form control feedback states\n//\n// Apply contextual and semantic states to individual form controls.\n\n.has-feedback {\n  // Enable absolute positioning\n  position: relative;\n\n  // Ensure icons don\'t overlap text\n  .form-control {\n    padding-right: (@input-height-base * 1.25);\n  }\n}\n// Feedback icon (requires .glyphicon classes)\n.form-control-feedback {\n  position: absolute;\n  top: 0;\n  right: 0;\n  z-index: 2; // Ensure icon is above input groups\n  display: block;\n  width: @input-height-base;\n  height: @input-height-base;\n  line-height: @input-height-base;\n  text-align: center;\n  pointer-events: none;\n}\n.input-lg + .form-control-feedback,\n.input-group-lg + .form-control-feedback,\n.form-group-lg .form-control + .form-control-feedback {\n  width: @input-height-large;\n  height: @input-height-large;\n  line-height: @input-height-large;\n}\n.input-sm + .form-control-feedback,\n.input-group-sm + .form-control-feedback,\n.form-group-sm .form-control + .form-control-feedback {\n  width: @input-height-small;\n  height: @input-height-small;\n  line-height: @input-height-small;\n}\n\n// Feedback states\n.has-success {\n  .form-control-validation(@state-success-text; @state-success-text; @state-success-bg);\n}\n.has-warning {\n  .form-control-validation(@state-warning-text; @state-warning-text; @state-warning-bg);\n}\n.has-error {\n  .form-control-validation(@state-danger-text; @state-danger-text; @state-danger-bg);\n}\n\n// Reposition feedback icon if input has visible label above\n.has-feedback label {\n\n  & ~ .form-control-feedback {\n    top: (@line-height-computed + 5); // Height of the `label` and its margin\n  }\n  &.sr-only ~ .form-control-feedback {\n    top: 0;\n  }\n}\n\n\n// Help text\n//\n// Apply to any element you wish to create light text for placement immediately\n// below a form control. Use for general help, formatting, or instructional text.\n\n.help-block {\n  display: block; // account for any element using help-block\n  margin-top: 5px;\n  margin-bottom: 10px;\n  color: lighten(@text-color, 25%); // lighten the text some for contrast\n}\n\n\n// Inline forms\n//\n// Make forms appear inline(-block) by adding the `.form-inline` class. Inline\n// forms begin stacked on extra small (mobile) devices and then go inline when\n// viewports reach <768px.\n//\n// Requires wrapping inputs and labels with `.form-group` for proper display of\n// default HTML form controls and our custom form controls (e.g., input groups).\n//\n// Heads up! This is mixin-ed into `.navbar-form` in navbars.less.\n\n.form-inline {\n\n  // Kick in the inline\n  @media (min-width: @screen-sm-min) {\n    // Inline-block all the things for "inline"\n    .form-group {\n      display: inline-block;\n      margin-bottom: 0;\n      vertical-align: middle;\n    }\n\n    // In navbar-form, allow folks to *not* use `.form-group`\n    .form-control {\n      display: inline-block;\n      width: auto; // Prevent labels from stacking above inputs in `.form-group`\n      vertical-align: middle;\n    }\n\n    // Make static controls behave like regular ones\n    .form-control-static {\n      display: inline-block;\n    }\n\n    .input-group {\n      display: inline-table;\n      vertical-align: middle;\n\n      .input-group-addon,\n      .input-group-btn,\n      .form-control {\n        width: auto;\n      }\n    }\n\n    // Input groups need that 100% width though\n    .input-group > .form-control {\n      width: 100%;\n    }\n\n    .control-label {\n      margin-bottom: 0;\n      vertical-align: middle;\n    }\n\n    // Remove default margin on radios/checkboxes that were used for stacking, and\n    // then undo the floating of radios and checkboxes to match.\n    .radio,\n    .checkbox {\n      display: inline-block;\n      margin-top: 0;\n      margin-bottom: 0;\n      vertical-align: middle;\n\n      label {\n        padding-left: 0;\n      }\n    }\n    .radio input[type="radio"],\n    .checkbox input[type="checkbox"] {\n      position: relative;\n      margin-left: 0;\n    }\n\n    // Re-override the feedback icon.\n    .has-feedback .form-control-feedback {\n      top: 0;\n    }\n  }\n}\n\n\n// Horizontal forms\n//\n// Horizontal forms are built on grid classes and allow you to create forms with\n// labels on the left and inputs on the right.\n\n.form-horizontal {\n\n  // Consistent vertical alignment of radios and checkboxes\n  //\n  // Labels also get some reset styles, but that is scoped to a media query below.\n  .radio,\n  .checkbox,\n  .radio-inline,\n  .checkbox-inline {\n    margin-top: 0;\n    margin-bottom: 0;\n    padding-top: (@padding-base-vertical + 1); // Default padding plus a border\n  }\n  // Account for padding we\'re adding to ensure the alignment and of help text\n  // and other content below items\n  .radio,\n  .checkbox {\n    min-height: (@line-height-computed + (@padding-base-vertical + 1));\n  }\n\n  // Make form groups behave like rows\n  .form-group {\n    .make-row();\n  }\n\n  // Reset spacing and right align labels, but scope to media queries so that\n  // labels on narrow viewports stack the same as a default form example.\n  @media (min-width: @screen-sm-min) {\n    .control-label {\n      text-align: right;\n      margin-bottom: 0;\n      padding-top: (@padding-base-vertical + 1); // Default padding plus a border\n    }\n  }\n\n  // Validation states\n  //\n  // Reposition the icon because it\'s now within a grid column and columns have\n  // `position: relative;` on them. Also accounts for the grid gutter padding.\n  .has-feedback .form-control-feedback {\n    right: floor((@grid-gutter-width / 2));\n  }\n\n  // Form group sizes\n  //\n  // Quick utility class for applying `.input-lg` and `.input-sm` styles to the\n  // inputs and labels within a `.form-group`.\n  .form-group-lg {\n    @media (min-width: @screen-sm-min) {\n      .control-label {\n        padding-top: (@padding-large-vertical + 1);\n        font-size: @font-size-large;\n      }\n    }\n  }\n  .form-group-sm {\n    @media (min-width: @screen-sm-min) {\n      .control-label {\n        padding-top: (@padding-small-vertical + 1);\n        font-size: @font-size-small;\n      }\n    }\n  }\n}\n',digest:"3a89d47796311e302bdcee941d9f97a67f23e1bc"},"static/atom-ui/styles/private/links.less":{content:'@import "ui-variables";\n@import "../mixins/mixins";\n\n// Links\n\na {\n  cursor: pointer;\n  color: @text-color-highlight;\n  text-decoration: none;\n  &:hover,\n  &:focus {\n    color: @text-color-highlight;\n    text-decoration: underline;\n  }\n  &:focus {\n    .tab-focus();\n  }\n}\n',digest:"1b67395c0f1c96d9b4af3d82db7246f7f76f5f38"},"static/atom-ui/styles/private/navs.less":{content:'@import "../variables/variables";\n@import "ui-variables";\n@import "../mixins/mixins";\n\n//\n// Navs\n// --------------------------------------------------\n\n//=== Shared nav styles\n@nav-link-padding:                            10px 15px;\n@nav-link-hover-bg:                           @gray-lighter;\n@nav-disabled-link-color:                     @gray-light;\n@nav-disabled-link-hover-color:               @gray-light;\n\n//== Tabs\n@nav-tabs-border-color:                       #ddd;\n@nav-tabs-link-hover-border-color:            @gray-lighter;\n@nav-tabs-active-link-hover-bg:               @body-bg;\n@nav-tabs-active-link-hover-color:            @gray;\n@nav-tabs-active-link-hover-border-color:     #ddd;\n@nav-tabs-justified-link-border-color:        #ddd;\n@nav-tabs-justified-active-link-border-color: @body-bg;\n\n//== Pills\n@nav-pills-border-radius:                     @border-radius-base;\n@nav-pills-active-link-hover-bg:              @component-active-bg;\n@nav-pills-active-link-hover-color:           @component-active-color;\n\n\n.nav-divider(@color: #e5e5e5) {\n  height: 1px;\n  margin: ((@line-height-computed / 2) - 1) 0;\n  overflow: hidden;\n  background-color: @color;\n}\n\n\n// Base class\n// --------------------------------------------------\n\n.nav {\n  margin-bottom: 0;\n  padding-left: 0; // Override default ul/ol\n  list-style: none;\n  &:extend(.clearfix all);\n\n  > li {\n    position: relative;\n    display: block;\n\n    > a {\n      position: relative;\n      display: block;\n      padding: @nav-link-padding;\n      border-radius: @component-border-radius;\n      &:hover,\n      &:focus {\n        text-decoration: none;\n        background-color: @background-color-highlight;\n      }\n    }\n\n    // Disabled state sets text to gray and nukes hover/tab effects\n    &.disabled > a {\n      color: @nav-disabled-link-color;\n\n      &:hover,\n      &:focus {\n        color: @nav-disabled-link-hover-color;\n        text-decoration: none;\n        background-color: transparent;\n        cursor: @cursor-disabled;\n      }\n    }\n  }\n\n  // Open dropdowns\n  .open > a {\n    &,\n    &:hover,\n    &:focus {\n      background-color: @nav-link-hover-bg;\n      border-color: @link-color;\n    }\n  }\n\n  // Nav dividers (deprecated with v3.0.1)\n  //\n  // This should have been removed in v3 with the dropping of `.nav-list`, but\n  // we missed it. We don\'t currently support this anywhere, but in the interest\n  // of maintaining backward compatibility in case you use it, it\'s deprecated.\n  .nav-divider {\n    .nav-divider();\n  }\n\n  // Prevent IE8 from misplacing imgs\n  //\n  // See https://github.com/h5bp/html5-boilerplate/issues/984#issuecomment-3985989\n  > li > a > img {\n    max-width: none;\n  }\n}\n\n\n// Tabs\n// -------------------------\n\n// Give the tabs something to sit on\n.nav-tabs {\n  border-bottom: 1px solid @nav-tabs-border-color;\n  > li {\n    float: left;\n    // Make the list-items overlay the bottom border\n    margin-bottom: -1px;\n\n    // Actual tabs (as links)\n    > a {\n      margin-right: 2px;\n      line-height: @line-height-base;\n      border: 1px solid transparent;\n      border-radius: @border-radius-base @border-radius-base 0 0;\n      &:hover {\n        border-color: @nav-tabs-link-hover-border-color @nav-tabs-link-hover-border-color @nav-tabs-border-color;\n      }\n    }\n\n    // Active state, and its :hover to override normal :hover\n    &.active > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @nav-tabs-active-link-hover-color;\n        background-color: @nav-tabs-active-link-hover-bg;\n        border: 1px solid @nav-tabs-active-link-hover-border-color;\n        border-bottom-color: transparent;\n        cursor: default;\n      }\n    }\n  }\n  // pulling this in mainly for less shorthand\n  &.nav-justified {\n    .nav-justified();\n    .nav-tabs-justified();\n  }\n}\n\n\n// Pills\n// -------------------------\n.nav-pills {\n  > li {\n    float: left;\n\n    // Links rendered as pills\n    > a {\n      border-radius: @nav-pills-border-radius;\n    }\n    + li {\n      margin-left: 2px;\n    }\n\n    // Active state\n    &.active > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @nav-pills-active-link-hover-color;\n        background-color: @background-color-selected;\n      }\n    }\n  }\n}\n\n\n// Stacked pills\n.nav-stacked {\n  > li {\n    float: none;\n    + li {\n      margin-top: 2px;\n      margin-left: 0; // no need for this gap between nav items\n    }\n  }\n}\n\n\n// Nav variations\n// --------------------------------------------------\n\n// Justified nav links\n// -------------------------\n\n.nav-justified {\n  width: 100%;\n\n  > li {\n    float: none;\n    > a {\n      text-align: center;\n      margin-bottom: 5px;\n    }\n  }\n\n  > .dropdown .dropdown-menu {\n    top: auto;\n    left: auto;\n  }\n\n  @media (min-width: @screen-sm-min) {\n    > li {\n      display: table-cell;\n      width: 1%;\n      > a {\n        margin-bottom: 0;\n      }\n    }\n  }\n}\n\n// Move borders to anchors instead of bottom of list\n//\n// Mixin for adding on top the shared `.nav-justified` styles for our tabs\n.nav-tabs-justified {\n  border-bottom: 0;\n\n  > li > a {\n    // Override margin from .nav-tabs\n    margin-right: 0;\n    border-radius: @border-radius-base;\n  }\n\n  > .active > a,\n  > .active > a:hover,\n  > .active > a:focus {\n    border: 1px solid @nav-tabs-justified-link-border-color;\n  }\n\n  @media (min-width: @screen-sm-min) {\n    > li > a {\n      border-bottom: 1px solid @nav-tabs-justified-link-border-color;\n      border-radius: @border-radius-base @border-radius-base 0 0;\n    }\n    > .active > a,\n    > .active > a:hover,\n    > .active > a:focus {\n      border-bottom-color: @nav-tabs-justified-active-link-border-color;\n    }\n  }\n}\n\n\n// Tabbable tabs\n// -------------------------\n\n// Hide tabbable panes to start, show them when `.active`\n.tab-content {\n  > .tab-pane {\n    display: none;\n  }\n  > .active {\n    display: block;\n  }\n}\n\n\n// Dropdowns\n// -------------------------\n\n// Specific dropdowns\n.nav-tabs .dropdown-menu {\n  // make dropdown border overlap tab border\n  margin-top: -1px;\n  // Remove the top rounded corners here since there is a hard edge above the menu\n  .border-top-radius(0);\n}\n',digest:"b5935924a646fe81617f04f418e6fb77b6ad9393"},"static/atom-ui/styles/private/scaffolding.less":{content:'@import "../variables/variables";\n@import "ui-variables";\n@import "../mixins/mixins";\n\n//\n// Scaffolding\n// --------------------------------------------------\n\n// Remove focus style, be sure to add them back where useful\n:focus {\n  outline: none;\n}\n\n// Reset fonts for relevant elements\ninput,\nbutton,\nselect,\ntextarea {\n  font-family: inherit;\n  font-size: inherit;\n  line-height: inherit;\n}\n\n\n// Figures\n//\n// We reset this here because previously Normalize had no `figure` margins. This\n// ensures we don\'t break anyone\'s use of the element.\n\nfigure {\n  margin: 0;\n}\n\n\n// Images\n\nimg {\n  vertical-align: middle;\n}\n\n// Responsive images (ensure images don\'t scale beyond their parents)\n.img-responsive {\n  display: block;\n  max-width: 100%; // Set a maximum relative to the parent\n}\n\n\n// Horizontal rules\n\nhr {\n  margin-top:    @line-height-computed;\n  margin-bottom: @line-height-computed;\n  border: 0;\n  border-top: 1px solid @hr-border;\n}\n',digest:"ecbeeca81d2b52e9af5ff5e988c2d1aeb73751aa"},"static/atom-ui/styles/private/sections.less":{content:'@import "ui-variables";\n\n// Deprecated\n// These selectors are too vague and should be used directly in Settings and Styleguide\n\nsection, .section {\n  position: relative;\n  margin-top: 0;\n  &:last-child { margin-bottom: 0; }\n\n  &.bordered {\n    margin: 0;\n    padding: @component-padding*2 0;\n    border-top: 1px solid @background-color-highlight;\n    border-bottom: 1px solid @tool-panel-border-color;\n  }\n\n  .section-heading:first-child {\n    margin-top: 0;\n    font-weight: bold;\n    color: @text-color-highlight;\n  }\n}\n\ndiv > section:first-child,\nform > section:first-child,\ndiv > .section:first-child,\nform > .section:first-child {\n  border-top: none;\n  padding-top: 0;\n}\ndiv > section:last-child,\nform > section:last-child,\ndiv > .section:last-child,\nform > .section:last-child {\n  border-bottom: none;\n  padding-bottom: 0;\n}\n',digest:"15cd6c2abed73f5339bd79465c7945ca6ce563c4"},"static/atom-ui/styles/private/tables.less":{content:'@import "../variables/variables";\n@import "ui-variables";\n\n//\n// Tables\n// --------------------------------------------------\n\n//## Customizes the `.table` component with basic values, each used across all table variations.\n\n@table-cell-padding:            8px; //** Padding for `<th>`s and `<td>`s.\n@table-condensed-cell-padding:  5px; //** Padding for cells in `.table-condensed`.\n@table-bg:                      transparent; //** Default background color used for all tables.\n@table-bg-accent:               #f9f9f9; //** Background color used for `.table-striped`.\n@table-bg-hover:                #f5f5f5; //** Background color used for `.table-hover`.\n@table-bg-active:               @table-bg-hover;\n@table-border-color:            #ddd; //** Border color for table and cell borders.\n\n\n\n// Variant mixin\n\n.table-row-variant(@state; @background) {\n  // Exact selectors below required to override `.table-striped` and prevent\n  // inheritance to nested tables.\n  .table > thead > tr,\n  .table > tbody > tr,\n  .table > tfoot > tr {\n    > td.@{state},\n    > th.@{state},\n    &.@{state} > td,\n    &.@{state} > th {\n      background-color: @background;\n    }\n  }\n\n  // Hover states for `.table-hover`\n  // Note: this is not available for cells or rows within `thead` or `tfoot`.\n  .table-hover > tbody > tr {\n    > td.@{state}:hover,\n    > th.@{state}:hover,\n    &.@{state}:hover > td,\n    &:hover > .@{state},\n    &.@{state}:hover > th {\n      background-color: darken(@background, 5%);\n    }\n  }\n}\n\n\n// Global overrides\n\ntable {\n  background-color: @table-bg;\n}\ncaption {\n  padding-top: @table-cell-padding;\n  padding-bottom: @table-cell-padding;\n  color: @text-muted;\n  text-align: left;\n}\nth {\n  text-align: left;\n}\n\n\n// Baseline styles\n\n.table {\n  width: 100%;\n  max-width: 100%;\n  margin-bottom: @line-height-computed;\n  // Cells\n  > thead,\n  > tbody,\n  > tfoot {\n    > tr {\n      > th,\n      > td {\n        padding: @table-cell-padding;\n        line-height: @line-height-base;\n        vertical-align: top;\n        border-top: 1px solid @table-border-color;\n      }\n    }\n  }\n  // Bottom align for column headings\n  > thead > tr > th {\n    vertical-align: bottom;\n    border-bottom: 2px solid @table-border-color;\n  }\n  // Remove top border from thead by default\n  > caption + thead,\n  > colgroup + thead,\n  > thead:first-child {\n    > tr:first-child {\n      > th,\n      > td {\n        border-top: 0;\n      }\n    }\n  }\n  // Account for multiple tbody instances\n  > tbody + tbody {\n    border-top: 2px solid @table-border-color;\n  }\n\n  // Nesting\n  .table {\n    background-color: @body-bg;\n  }\n}\n\n\n// Condensed table w/ half padding\n\n.table-condensed {\n  > thead,\n  > tbody,\n  > tfoot {\n    > tr {\n      > th,\n      > td {\n        padding: @table-condensed-cell-padding;\n      }\n    }\n  }\n}\n\n\n// Bordered version\n//\n// Add borders all around the table and between all the columns.\n\n.table-bordered {\n  border: 1px solid @table-border-color;\n  > thead,\n  > tbody,\n  > tfoot {\n    > tr {\n      > th,\n      > td {\n        border: 1px solid @table-border-color;\n      }\n    }\n  }\n  > thead > tr {\n    > th,\n    > td {\n      border-bottom-width: 2px;\n    }\n  }\n}\n\n\n// Zebra-striping\n//\n// Default zebra-stripe styles (alternating gray and transparent backgrounds)\n\n.table-striped {\n  > tbody > tr:nth-of-type(odd) {\n    background-color: @table-bg-accent;\n  }\n}\n\n\n// Hover effect\n//\n// Placed here since it has to come after the potential zebra striping\n\n.table-hover {\n  > tbody > tr:hover {\n    background-color: @table-bg-hover;\n  }\n}\n\n\n// Table cell sizing\n//\n// Reset default table behavior\n\ntable col[class*="col-"] {\n  position: static; // Prevent border hiding in Firefox and IE9-11 (see https://github.com/twbs/bootstrap/issues/11623)\n  float: none;\n  display: table-column;\n}\ntable {\n  td,\n  th {\n    &[class*="col-"] {\n      position: static; // Prevent border hiding in Firefox and IE9-11 (see https://github.com/twbs/bootstrap/issues/11623)\n      float: none;\n      display: table-cell;\n    }\n  }\n}\n\n\n// Table backgrounds\n//\n// Exact selectors below required to override `.table-striped` and prevent\n// inheritance to nested tables.\n\n// Generate the contextual variants\n.table-row-variant(active; @table-bg-active);\n.table-row-variant(success; @state-success-bg);\n.table-row-variant(info; @state-info-bg);\n.table-row-variant(warning; @state-warning-bg);\n.table-row-variant(danger; @state-danger-bg);\n',digest:"43ec0b62ed5ff57800040281069c44f9d177a599"},"static/atom-ui/styles/private/utilities.less":{content:'@import "ui-variables";\n@import "../mixins/mixins";\n\n// Toggling content\n// -------------------------\n\n// Note: Deprecated .hide in favor of .hidden or .sr-only (as appropriate) in v3.0.1\n.hide {\n  display: none !important;\n}\n.show {\n  display: block !important;\n}\n.invisible {\n  visibility: hidden;\n}\n.text-hide {\n  .text-hide();\n}\n\n\n// Hide from screenreaders and browsers\n//\n// Credit: HTML5 Boilerplate\n\n.hidden {\n  display: none !important;\n}\n\n\n// Only display content to screen readers\n//\n// See: http://a11yproject.com/posts/how-to-hide-content/\n\n.sr-only {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  margin: -1px;\n  padding: 0;\n  overflow: hidden;\n  clip: rect(0,0,0,0);\n  border: 0;\n}\n\n// Use in conjunction with .sr-only to only display content when it\'s focused.\n// Useful for "Skip to main content" links; see http://www.w3.org/TR/2013/NOTE-WCAG20-TECHS-20130905/G1\n// Credit: HTML5 Boilerplate\n\n.sr-only-focusable {\n  &:active,\n  &:focus {\n    position: static;\n    width: auto;\n    height: auto;\n    margin: 0;\n    overflow: visible;\n    clip: auto;\n  }\n}\n',digest:"d7308fc13c56e919be53b486744b05819a64fd40"},"static/atom-ui/styles/select-list.less":{content:'@import "ui-variables";\n@import "octicon-mixins";\n\n.select-list {\n  .loading {\n    .loading-message {\n      .octicon(hourglass);\n\n      &:before {\n        font-size: 1.1em;\n        width: 1.1em;\n        height: 1.1em;\n        margin-right: 5px;\n      }\n    }\n\n    .badge {\n      margin-left: 10px;\n    }\n  }\n\n  ol.list-group {\n    position: relative;\n    overflow-y: auto;\n    max-height: 312px;\n    margin: @component-padding 0 0 0;\n    padding: 0;\n\n    li {\n      display: block;\n\n      .primary-line,\n      .secondary-line {\n        text-overflow: ellipsis;\n        white-space: nowrap;\n        overflow: hidden;\n      }\n    }\n  }\n}\n\n\n// Popover List\n\n.select-list.popover-list {\n  width: 200px;\n  min-width: 200px;\n  margin-left: 0;\n  position: relative;\n  background-color: @overlay-background-color;\n\n  ol.list-group {\n    position: relative;\n    overflow-y: scroll;\n    max-height: 200px;\n  }\n}\n',digest:"518848bc20eb40cc04f71321a2842ce354550fcf"},"static/atom-ui/styles/site-colors.less":{content:'@import "ui-variables";\n\n//\n// Site colors\n// --------------------------------------------------\n\n.ui-site-1 { background-color: @ui-site-color-1; }\n.ui-site-2 { background-color: @ui-site-color-2; }\n.ui-site-3 { background-color: @ui-site-color-3; }\n.ui-site-4 { background-color: @ui-site-color-4; }\n.ui-site-5 { background-color: @ui-site-color-5; }\n',digest:"4ad232d8f723f55e3d7fbe2c713d0d7d0eb631ba"},"static/atom-ui/styles/text.less":{content:'@import "variables/variables";\n@import "ui-variables";\n@import "mixins/mixins";\n\n//\n// Typography\n// --------------------------------------------------\n\n@font-size-h1:            floor((@font-size-base * 2.6)); // ~36px\n@font-size-h2:            floor((@font-size-base * 2.15)); // ~30px\n@font-size-h3:            ceil((@font-size-base * 1.7)); // ~24px\n@font-size-h4:            ceil((@font-size-base * 1.25)); // ~18px\n@font-size-h5:            @font-size-base;\n@font-size-h6:            ceil((@font-size-base * 0.85)); // ~12px\n\n@headings-font-family:    inherit;\n@headings-font-weight:    500;\n@headings-line-height:    1.1;\n@headings-color:          inherit;\n\n// Mixins\n// -------------------------\n\n.text-variant(@type) {\n  @text-color-name: "text-color-@{type}";\n  @bg-color-name: "background-color-@{type}";\n\n  @text-color: @@text-color-name;\n  @bg-color: @@bg-color-name;\n\n  color: @text-color;\n  a&:hover,\n  a&:focus {\n    color: darken(@text-color, 10%);\n  }\n\n  code {\n    color: @text-color;\n    background: fadeout(@bg-color, 80%);\n  }\n\n  a, a code {\n    text-decoration: underline;\n    color: darken(@text-color, 10%);\n\n    &:hover {\n      color: darken(@text-color, 15%);\n    }\n  }\n}\n\n.bg-variant(@color) {\n  background-color: @color;\n  a&:hover,\n  a&:focus {\n    background-color: darken(@color, 10%);\n  }\n}\n\n// Headings\n// -------------------------\n\nh1, h2, h3, h4, h5, h6,\n.h1, .h2, .h3, .h4, .h5, .h6 {\n  font-family: @headings-font-family;\n  font-weight: @headings-font-weight;\n  line-height: @headings-line-height;\n  color: @headings-color;\n\n  small,\n  .small {\n    font-weight: normal;\n    line-height: 1;\n    color: @headings-small-color;\n  }\n}\n\nh1, .h1,\nh2, .h2,\nh3, .h3 {\n  margin-top: @line-height-computed;\n  margin-bottom: (@line-height-computed / 2);\n\n  small,\n  .small {\n    font-size: 65%;\n  }\n}\nh4, .h4,\nh5, .h5,\nh6, .h6 {\n  margin-top: (@line-height-computed / 2);\n  margin-bottom: (@line-height-computed / 2);\n\n  small,\n  .small {\n    font-size: 75%;\n  }\n}\n\nh1, .h1 { font-size: @font-size-h1; }\nh2, .h2 { font-size: @font-size-h2; }\nh3, .h3 { font-size: @font-size-h3; }\nh4, .h4 { font-size: @font-size-h4; }\nh5, .h5 { font-size: @font-size-h5; }\nh6, .h6 { font-size: @font-size-h6; }\n\n\n// Body text\n// -------------------------\n\np {\n  margin: 0 0 (@line-height-computed / 2);\n}\n\n\n// Emphasis & misc\n// -------------------------\n\n// Ex: (12px small font / 14px base font) * 100% = about 85%\n.text-smaller,\nsmall,\n.small {\n  font-size: floor((100% * @font-size-small / @font-size-base));\n}\n\nmark,\n.mark {\n  background-color: @state-warning-bg;\n  padding: .2em;\n}\n\n// Alignment\n.text-left           { text-align: left; }\n.text-right          { text-align: right; }\n.text-center         { text-align: center; }\n.text-justify        { text-align: justify; }\n.text-nowrap         { white-space: nowrap; }\n\n// Transformation\n.text-lowercase      { text-transform: lowercase; }\n.text-uppercase      { text-transform: uppercase; }\n.text-capitalize     { text-transform: capitalize; }\n\n// text-classes\n.text-subtle, .text-muted { color: @text-color-subtle; }\n.text-highlight           { color: @text-color-highlight; }\n\n// Contextual colors\n.text-info, .text-primary { .text-variant(info); }\n.text-success             { .text-variant(success); }\n.text-warning             { .text-variant(warning); }\n.text-error, .text-danger { .text-variant(error); }\n\n// Contextual backgrounds\n// For now we\'ll leave these alongside the text classes until v4 when we can\n// safely shift things around (per SemVer rules).\n.bg-primary {\n  // Given the contrast here, this is the only class to have its color inverted\n  // automatically.\n  color: #fff;\n  .bg-variant(@brand-primary);\n}\n.bg-success {\n  .bg-variant(@state-success-bg);\n}\n.bg-info {\n  .bg-variant(@state-info-bg);\n}\n.bg-warning {\n  .bg-variant(@state-warning-bg);\n}\n.bg-danger {\n  .bg-variant(@state-danger-bg);\n}\n\n\n// Highlight\n// -------------------------\n\n.highlight() {\n  font-weight: bold;\n  border-radius: @component-border-radius;\n}\n\n.highlight {\n  .highlight();\n  color: @text-color-highlight;\n  background-color: @background-color-highlight;\n}\n\n.highlight-color(@name, @color) {\n  .highlight-@{name} {\n    .highlight();\n    color: #fff;\n    background-color: fadeout(@color, 50%);\n  }\n}\n\n.highlight-color(info,    @background-color-info);\n.highlight-color(warning, @background-color-warning);\n.highlight-color(error,   @background-color-error);\n.highlight-color(success, @background-color-success);\n\n\n// Lists\n// -------------------------\n\n// Unordered and Ordered lists\nul,\nol {\n  margin-top: 0;\n  margin-bottom: (@line-height-computed / 2);\n  ul,\n  ol {\n    margin-bottom: 0;\n  }\n}\n\n// Description Lists\ndl {\n  margin-top: 0; // Remove browser default\n  margin-bottom: @line-height-computed;\n}\ndt,\ndd {\n  line-height: @line-height-base;\n}\ndt {\n  font-weight: bold;\n}\ndd {\n  margin-left: 0; // Undo browser default\n}\n\n\n// Misc\n// -------------------------\n\n// Abbreviations and acronyms\nabbr[title],\n// Add data-* attribute to help out our tooltip plugin, per https://github.com/twbs/bootstrap/issues/5257\nabbr[data-original-title] {\n  cursor: help;\n  border-bottom: 1px dotted @abbr-border-color;\n}\n\n// Blockquotes\nblockquote {\n  padding: (@line-height-computed / 2) @line-height-computed;\n  margin: 0 0 @line-height-computed;\n  font-size: @blockquote-font-size;\n  border-left: 5px solid @blockquote-border-color;\n\n  p,\n  ul,\n  ol {\n    &:last-child {\n      margin-bottom: 0;\n    }\n  }\n}\n\n// Addresses\naddress {\n  margin-bottom: @line-height-computed;\n  font-style: normal;\n  line-height: @line-height-base;\n}\n',digest:"d7d7f46cfbf517e31d08e97d60eb3eb2d646c1d7"},"static/atom-ui/styles/tooltip.less":{content:'@import "ui-variables";\n\n//\n// Tooltips\n// --------------------------------------------------\n\n@tooltip-max-width:           200px; //** Tooltip max width\n@tooltip-color:               #fff; //** Tooltip text color\n@tooltip-bg:                  @background-color-info; //** Tooltip background color\n@tooltip-opacity:             .9;\n@tooltip-arrow-width:         5px; //** Tooltip arrow width\n@tooltip-arrow-color:         @tooltip-bg; //** Tooltip arrow color\n@tooltip-zindex:              1070;\n\n\n// Base class\n.tooltip {\n  // Our parent element can be arbitrary since tooltips are by default inserted as a sibling of their target element.\n  // So reset our font and text properties to avoid inheriting weird values.\n  all: initial;\n\n  position: absolute;\n  z-index: @tooltip-zindex;\n  display: block;\n  font-family: @font-family;\n  font-size: @font-size;\n  opacity: 0;\n\n  &.in     { opacity: @tooltip-opacity; }\n  &.top    { margin-top:  -3px; padding: @tooltip-arrow-width 0; }\n  &.right  { margin-left:  3px; padding: 0 @tooltip-arrow-width; }\n  &.bottom { margin-top:   3px; padding: @tooltip-arrow-width 0; }\n  &.left   { margin-left: -3px; padding: 0 @tooltip-arrow-width; }\n}\n\n// Wrapper for the tooltip content\n.tooltip-inner {\n  max-width: @tooltip-max-width;\n  padding: 3px 8px;\n  color: @tooltip-color;\n  text-align: center;\n  background-color: @tooltip-bg;\n  border-radius: @component-border-radius;\n}\n\n// Arrows\n.tooltip-arrow {\n  position: absolute;\n  width: 0;\n  height: 0;\n  border-color: transparent;\n  border-style: solid;\n}\n// Note: Deprecated .top-left, .top-right, .bottom-left, and .bottom-right as of v3.3.1\n.tooltip {\n  &.top .tooltip-arrow {\n    bottom: 0;\n    left: 50%;\n    margin-left: -@tooltip-arrow-width;\n    border-width: @tooltip-arrow-width @tooltip-arrow-width 0;\n    border-top-color: @tooltip-arrow-color;\n  }\n  &.top-left .tooltip-arrow {\n    bottom: 0;\n    right: @tooltip-arrow-width;\n    margin-bottom: -@tooltip-arrow-width;\n    border-width: @tooltip-arrow-width @tooltip-arrow-width 0;\n    border-top-color: @tooltip-arrow-color;\n  }\n  &.top-right .tooltip-arrow {\n    bottom: 0;\n    left: @tooltip-arrow-width;\n    margin-bottom: -@tooltip-arrow-width;\n    border-width: @tooltip-arrow-width @tooltip-arrow-width 0;\n    border-top-color: @tooltip-arrow-color;\n  }\n  &.right .tooltip-arrow {\n    top: 50%;\n    left: 0;\n    margin-top: -@tooltip-arrow-width;\n    border-width: @tooltip-arrow-width @tooltip-arrow-width @tooltip-arrow-width 0;\n    border-right-color: @tooltip-arrow-color;\n  }\n  &.left .tooltip-arrow {\n    top: 50%;\n    right: 0;\n    margin-top: -@tooltip-arrow-width;\n    border-width: @tooltip-arrow-width 0 @tooltip-arrow-width @tooltip-arrow-width;\n    border-left-color: @tooltip-arrow-color;\n  }\n  &.bottom .tooltip-arrow {\n    top: 0;\n    left: 50%;\n    margin-left: -@tooltip-arrow-width;\n    border-width: 0 @tooltip-arrow-width @tooltip-arrow-width;\n    border-bottom-color: @tooltip-arrow-color;\n  }\n  &.bottom-left .tooltip-arrow {\n    top: 0;\n    right: @tooltip-arrow-width;\n    margin-top: -@tooltip-arrow-width;\n    border-width: 0 @tooltip-arrow-width @tooltip-arrow-width;\n    border-bottom-color: @tooltip-arrow-color;\n  }\n  &.bottom-right .tooltip-arrow {\n    top: 0;\n    left: @tooltip-arrow-width;\n    margin-top: -@tooltip-arrow-width;\n    border-width: 0 @tooltip-arrow-width @tooltip-arrow-width;\n    border-bottom-color: @tooltip-arrow-color;\n  }\n}\n',digest:"4a9234eaed3a3b47b953cdfd4cf4526070c05eea"},"static/atom-ui/styles/variables/variables.less":{content:'@import "ui-variables";\n\n//\n// Variables (Forked from Bootstrap 3.3.6)\n// Don\'t use these variables in packages/themes.\n// Only use the public ui-variables.less + syntax-variables.less\n// --------------------------------------------------\n\n\n//== Colors\n//\n//## Gray and brand colors for use across Bootstrap.\n\n@gray-base:              #000;\n@gray-darker:            lighten(@gray-base, 13.5%); // #222\n@gray-dark:              lighten(@gray-base, 20%);   // #333\n@gray:                   lighten(@gray-base, 33.5%); // #555\n@gray-light:             lighten(@gray-base, 46.7%); // #777\n@gray-lighter:           lighten(@gray-base, 93.5%); // #eee\n\n@brand-primary:         @text-color-info;\n@brand-info:            @text-color-info;\n@brand-success:         @text-color-success;\n@brand-warning:         @text-color-warning;\n@brand-danger:          @text-color-error;\n\n\n//== Scaffolding\n//\n//## Settings for some of the most global styles.\n\n//** Background color for `<body>`.\n@body-bg:               @app-background-color;\n//** Global textual link color.\n@link-color:            @brand-primary;\n//** Link hover color set via `darken()` function.\n@link-hover-color:      darken(@link-color, 15%);\n//** Link hover decoration.\n@link-hover-decoration: underline;\n\n\n//== Typography\n//\n//## Font, line-height, and color for body text, headings, and more.\n\n//** Default monospace fonts for `<code>`, `<kbd>`, and `<pre>`.\n@font-family-monospace:   Menlo, Monaco, Consolas, "Courier New", monospace;\n\n@font-size-base:          @font-size;\n@font-size-large:         ceil((@font-size-base * 1.25)); // ~18px\n@font-size-small:         ceil((@font-size-base * 0.85)); // ~12px\n\n//** Unit-less `line-height` for use in components like buttons.\n@line-height-base:        1.428571429; // 20/14\n//** Computed "line-height" (`font-size` * `line-height`) for use with `margin`, `padding`, etc.\n@line-height-computed:    floor((@font-size-base * @line-height-base)); // ~20px\n\n\n//== Components\n//\n//## Define common padding and border radius sizes and more. Values based on 14px text and 1.428 line-height (~20px to start).\n\n@padding-base-vertical:     6px;\n@padding-base-horizontal:   12px;\n\n@padding-large-vertical:    10px;\n@padding-large-horizontal:  16px;\n\n@padding-small-vertical:    5px;\n@padding-small-horizontal:  10px;\n\n@padding-xs-vertical:       1px;\n@padding-xs-horizontal:     5px;\n\n@line-height-large:         1.3333333; // extra decimals for Win 8.1 Chrome\n@line-height-small:         1.5;\n\n@border-radius-base:        4px;\n@border-radius-large:       6px;\n@border-radius-small:       3px;\n\n//** Global color for active items (e.g., navs or dropdowns).\n@component-active-color:    #fff;\n//** Global background color for active items (e.g., navs or dropdowns).\n@component-active-bg:       @brand-primary;\n\n//** Width of the `border` for generating carets that indicator dropdowns.\n@caret-width-base:          4px;\n//** Carets increase slightly in size for larger components.\n@caret-width-large:         5px;\n\n\n//== Buttons\n//\n//## For each of Bootstrap\'s buttons, define text, background and border color.\n\n@btn-default-color:              @text-color;\n@btn-default-bg:                 @button-background-color;\n\n@btn-primary-color:              #fff;\n@btn-primary-bg:                 @background-color-info;\n\n@btn-success-color:              #fff;\n@btn-success-bg:                 @background-color-success;\n\n@btn-info-color:                 #fff;\n@btn-info-bg:                    @background-color-info;\n\n@btn-warning-color:              #fff;\n@btn-warning-bg:                 @background-color-warning;\n\n@btn-error-color:               #fff;\n@btn-error-bg:                  @background-color-error;\n\n@btn-link-disabled-color:        @text-color-subtle;\n\n// Allows for customizing button radius independently from global border radius\n@btn-border-radius-base:         @component-border-radius;\n@btn-border-radius-large:        @component-border-radius * 2;\n@btn-border-radius-small:        @component-border-radius / 2;\n\n\n\n//== Media queries breakpoints\n//\n//## Define the breakpoints at which your layout will change, adapting to different screen sizes\n\n@screen-sm:                  768px;\n@screen-sm-min:              @screen-sm;\n\n@screen-xs-max:              (@screen-sm-min - 1);\n\n// //== Form states and alerts\n// //\n// //## Define colors for form feedback states and, by default, alerts.\n//\n@state-success-text:             #3c763d;\n@state-success-bg:               #dff0d8;\n@state-success-border:           darken(spin(@state-success-bg, -10), 5%);\n\n@state-info-text:                #31708f;\n@state-info-bg:                  #d9edf7;\n@state-info-border:              darken(spin(@state-info-bg, -10), 7%);\n\n@state-warning-text:             #8a6d3b;\n@state-warning-bg:               #fcf8e3;\n@state-warning-border:           darken(spin(@state-warning-bg, -10), 5%);\n\n@state-danger-text:              #a94442;\n@state-danger-bg:                #f2dede;\n@state-danger-border:            darken(spin(@state-danger-bg, -10), 5%);\n\n\n// == List group\n//\n// ##\n\n//** Background color on `.list-group-item`\n@list-group-bg:                 #fff;\n//** `.list-group-item` border color\n@list-group-border:             #ddd;\n//** List group border radius\n@list-group-border-radius:      @border-radius-base;\n\n//** Background color of single list items on hover\n@list-group-hover-bg:           #f5f5f5;\n//** Text color of active list items\n@list-group-active-color:       @component-active-color;\n//** Background color of active list items\n@list-group-active-bg:          @component-active-bg;\n//** Border color of active list elements\n@list-group-active-border:      @list-group-active-bg;\n//** Text color for content within active list items\n@list-group-active-text-color:  lighten(@list-group-active-bg, 40%);\n\n//** Text color of disabled list items\n@list-group-disabled-color:      @gray-light;\n//** Background color of disabled list items\n@list-group-disabled-bg:         @gray-lighter;\n//** Text color for content within disabled list items\n@list-group-disabled-text-color: @list-group-disabled-color;\n\n@list-group-link-color:         #555;\n@list-group-link-hover-color:   @list-group-link-color;\n@list-group-link-heading-color: #333;\n\n\n//== Thumbnails\n//\n//##\n\n//** Padding around the thumbnail image\n@thumbnail-padding:           4px;\n//** Thumbnail background color\n@thumbnail-bg:                @body-bg;\n//** Thumbnail border color\n@thumbnail-border:            #ddd;\n//** Thumbnail border radius\n@thumbnail-border-radius:     @border-radius-base;\n\n\n//== Type\n//\n//##\n\n//** Horizontal offset for forms and lists.\n@component-offset-horizontal: 180px;\n//** Text muted color\n@text-muted:                  @gray-light;\n//** Abbreviations and acronyms border color\n@abbr-border-color:           @gray-light;\n//** Headings small color\n@headings-small-color:        @gray-light;\n//** Blockquote small color\n@blockquote-small-color:      @gray-light;\n//** Blockquote font size\n@blockquote-font-size:        (@font-size-base * 1.25);\n//** Blockquote border color\n@blockquote-border-color:     @gray-lighter;\n//** Page header border color\n@page-header-border-color:    @gray-lighter;\n//** Horizontal line color.\n@hr-border:                   @gray-lighter;\n\n\n//== Misc\n//\n//##\n\n//** Disabled cursor for form controls and buttons.\n@cursor-disabled: not-allowed;\n',digest:"e874519c3f95c02da4def52962c25490bf586713"},"static/atom.less":{content:'// Import from the syntax theme\'s variables with a fallback to ./variables/syntax-variables.less\n@import "./variables/syntax-variables";\n@import "syntax-variables";\n\n// Import from the ui theme\'s variables with a fallback to ./variables/ui-variables.less\n@import "./variables/ui-variables";\n@import "ui-variables";\n\n// Icons\n@import "icons/octicons";\n\n// Normalize + scaffolding\n@import "normalize";\n@import "scaffolding";\n\n// Core UI styles\n@import "core-ui/_index";\n\n// Atom UI library/components\n@import "atom-ui/_index";\n',digest:"5e6a3ce45d1b4e52689dde658b3103230ead7ea0"},"static/core-ui/_index.less":{content:'// Atom Core UI\n// These styles are part of Atom Core\n\n@import "cursors";\n@import "panels";\n@import "docks";\n@import "panes";\n@import "syntax";\n@import "text-editor";\n@import "title-bar";\n@import "workspace-view";\n',digest:"541ab42e31070b871f20d053ef4830ab50177112"},"static/core-ui/cursors.less":{content:'@import "./variables/syntax-variables";\n@import "syntax-variables";\n\n@import "./variables/ui-variables";\n@import "ui-variables";\n\n@ibeam-1x: url(\'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAQAAAC1+jfqAAAAL0lEQVQoz2NgCD3x//9/BhBYBWdhgFVAiVW4JBFKGIa4AqD0//9D3pt4I4tAdAMAHTQ/j5Zom30AAAAASUVORK5CYII=\');\n@ibeam-2x: url(\'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAQAAADZc7J/AAAAz0lEQVRIx2NgYGBY/R8I/vx5eelX3n82IJ9FxGf6tksvf/8FiTMQAcAGQMDvSwu09abffY8QYSAScNk45G198eX//yev73/4///701eh//kZSARckrNBRvz//+8+6ZohwCzjGNjdgQxkAg7B9WADeBjIBqtJCbhRA0YNoIkBSNmaPEMoNmA0FkYNoFKhapJ6FGyAH3nauaSmPfwI0v/3OukVi0CIZ+F25KrtYcx/CTIy0e+rC7R1Z4KMICVTQQ14feVXIbR695u14+Ir4gwAAD49E54wc1kWAAAAAElFTkSuQmCC\');\n\n.cursor-white() {\n  cursor: -webkit-image-set(@ibeam-1x 1x, @ibeam-2x 2x) 5 8, text;\n}\n\n// Editors\n& when ( lightness(@syntax-background-color) < 50% ) {\n  .platform-darwin atom-text-editor:not([mini]) {\n    .cursor-white();\n  }\n}\n\n// Mini Editors\n& when ( lightness(@input-background-color) < 50% ) {\n  .platform-darwin atom-text-editor[mini] {\n    .cursor-white();\n  }\n}\n',digest:"1735d16beddc1b6fefb5ea5c8d599c9e7a285a7a"},"static/core-ui/docks.less":{content:"@import 'ui-variables';\n@import 'syntax-variables';\n\n@atom-dock-toggle-button-size: 50px;\n@atom-dock-resize-handle-size: 4px;\n\n// Dock --------------\n\n// The actual dock element is used as a kind of placeholder in the DOM, relative\n// to which its children can be positioned.\natom-dock {\n  display: flex;\n  position: relative;\n}\n\n.atom-dock-inner {\n  display: flex;\n\n  &.bottom { width: 100%; }\n  &.left, &.right { height: 100%; }\n\n  // Make sure to center the toggle buttons\n  &.bottom { flex-direction: column; }\n  align-items: center;\n\n  // Position the docks flush with their side of the editor.\n  &.right { right: 0; }\n  &.bottom { bottom: 0; }\n  &.left { left: 0; }\n\n  // Position the docks flush with their side of the editor.\n  &.right { right: 0; }\n  &.bottom { bottom: 0; }\n  &.left { left: 0; }\n\n  &:not(.atom-dock-open) {\n    // The dock should only take up space when it's active (i.e. it shouldn't\n    // take up space when you're dragging something into it).\n    position: absolute;\n    z-index: 10; // An arbitrary number. Seems high enough. ¯\\_(ツ)_/¯\n  }\n}\n\n.atom-dock-mask {\n  position: relative;\n  background-color: @tool-panel-background-color;\n  overflow: hidden; // Mask the content.\n\n  // One of these will be overridden by the component with an explicit size.\n  // Which depends on the position of the dock.\n  width: 100%;\n  height: 100%;\n\n  transition: none;\n  &.atom-dock-should-animate {\n    transition: width 0.2s ease-out, height 0.2s ease-out;\n  }\n}\n\n.atom-dock-content-wrapper {\n  position: absolute;\n  display: flex;\n  flex: 1;\n  align-items: stretch;\n  width: 100%;\n  height: 100%;\n\n  // The contents of the dock should be \"stuck\" to the moving edge of the mask,\n  // so it looks like they're sliding in (instead of being unmasked in place).\n  &.right { left: 0; }\n  &.bottom { top: 0; }\n  &.left { right: 0; }\n\n  // Use flex-direction to put the resize handle in the correct place.\n  &.left { flex-direction: row-reverse; }\n  &.bottom { flex-direction: column; }\n  &.right { flex-direction: row; }\n}\n\n// Toggle button --------------\n\n.atom-dock-toggle-button {\n  position: absolute;\n  overflow: hidden; // Mask half of the circle.\n\n  // Must be > .scrollbar-content and inactive atom-dock\n  z-index: 11;\n\n  // Position the toggle button target at the edge of the dock. It's important\n  // that this is absolutely positioned so that it doesn't expand the area of\n  // its container (which would block mouse events).\n  &.right { right: 100%; }\n  &.bottom { bottom: 100%; }\n  &.left { left: 100%; }\n\n  width: @atom-dock-toggle-button-size;\n  height: @atom-dock-toggle-button-size;\n  &.bottom { height: @atom-dock-toggle-button-size / 2; }\n  &.left, &.right { width: @atom-dock-toggle-button-size / 2; }\n\n  .atom-dock-toggle-button-inner {\n    width: @atom-dock-toggle-button-size;\n    height: @atom-dock-toggle-button-size;\n    border-radius: @atom-dock-toggle-button-size / 2;\n\n    position: absolute;\n    display: flex;\n    text-align: center;\n    justify-content: center;\n    align-items: center;\n    cursor: pointer;\n\n    // Promote to own layer, fixes rendering issue atom/atom#14915\n    will-change: transform;\n\n    &.right {\n      left: 0;\n    }\n    &.bottom {\n      top: 0;\n    }\n    &.left {\n      right: 0;\n    }\n  }\n\n  // Hide the button.\n  &:not(.atom-dock-toggle-button-visible) {\n    .atom-dock-toggle-button-inner {\n      &.right { transform: translateX(50%); }\n      &.bottom { transform: translateY(50%); }\n      &.left { transform: translateX(-50%); }\n    }\n  }\n\n  // Center the icon.\n  @offset: 8px;\n  .atom-dock-toggle-button-inner {\n    &.right .icon { transform: translateX(-@offset); }\n    &.bottom .icon { transform: translateY(-@offset); }\n    &.left .icon { transform: translateX(@offset); }\n  }\n\n  // Animate the icon.\n  .icon {\n    transition: opacity 0.1s ease-in 0.1s; // intro\n    opacity: 1;\n\n    &::before {\n      // Shrink the icon element to the size of the character.\n      width: auto;\n      margin: 0;\n    }\n  }\n  &:not(.atom-dock-toggle-button-visible) .icon {\n    opacity: 0;\n    transition: opacity 0.2s ease-out 0s; // outro\n  }\n\n  .atom-dock-toggle-button-inner {\n    background-color: @tool-panel-background-color;\n    border: 1px solid @pane-item-border-color;\n    transition: transform 0.2s ease-out 0s; // intro\n  }\n\n  &:not(.atom-dock-toggle-button-visible) {\n    // Don't contribute to mouseenter/drag events when not visible.\n    pointer-events: none;\n\n    .atom-dock-toggle-button-inner {\n      transition: transform 0.2s ease-out 0.1s; // outro\n    }\n  }\n}\n\n// Resize handle --------------\n\n.atom-dock-resize-handle {\n  width: auto;\n  height: auto;\n  flex: 0 0 auto;\n\n  // Use the resize cursor when the handle's resizable\n  &.atom-dock-resize-handle-resizable {\n    &.left, &.right { cursor: col-resize; }\n    &.bottom { cursor: row-resize; }\n  }\n\n  &.left, &.right { width: @atom-dock-resize-handle-size; }\n  &.bottom { height: @atom-dock-resize-handle-size; }\n}\n\n// Cursor overlay --------------\n\n.atom-dock-cursor-overlay {\n  position: fixed;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  z-index: 4;\n\n  &.left,\n  &.right {\n    cursor: col-resize;\n  }\n\n  &.bottom {\n    cursor: row-resize;\n  }\n\n  &:not(.atom-dock-cursor-overlay-visible) {\n    display: none;\n  }\n}\n",digest:"fa9f34316f1caf5509c0b72c722805481205abd2"},"static/core-ui/panels.less":{content:"@import \"ui-variables\";\n\n// Atom panels\n\natom-panel-container.left,\natom-panel-container.right {\n  display: flex;\n}\n\natom-panel-container.left {\n  // Align panels to the right of the panel container. The effect of this is\n  // that the left dock's toggle button will appear on the right side of the\n  // empty space when the panel container has a min width in the theme.\n  justify-content: flex-end;\n}\n\n.tool-panel, // deprecated: .tool-panel\natom-panel {\n  display: block;\n  position: relative;\n}\n\natom-panel-container > atom-panel.left,\natom-panel-container > atom-panel.right {\n  display: flex;\n}\n\n// Some packages use `height: 100%` which doesn't play nice with flexbox\natom-panel-container > atom-panel.left > *,\natom-panel-container > atom-panel.right > * {\n  height: initial;\n}\n",digest:"c914b2dc5aa4dd33d986620897ffd8175f27a82a"},"static/core-ui/panes.less":{content:'@import "ui-variables";\n\n// Pane-items are things that go inside a pane. Like the UI-Demo, the\n// settings-view, the archive-view, the image-view. Etc. Basically a non-\n// editor resource with a tab.\natom-pane-container {\n  position: relative;\n  display: flex;\n  flex: 1;\n  min-width: 0;\n  min-height: 0;\n\n  atom-pane-axis {\n    position: relative;\n    display: flex;\n    flex: 1;\n    min-width: 0;\n    min-height: 0;\n\n    & > atom-pane-resize-handle {\n      position: relative;\n      &:before {\n        content: "";\n        position: absolute;\n        z-index: 3;\n      }\n    }\n  }\n\n  atom-pane-axis.vertical {\n    flex-direction: column;\n\n    & > atom-pane-resize-handle {\n      border-bottom: none;\n      &:before {\n        height: 8px;\n        top: -4px;\n        left: 0;\n        right: 0;\n        cursor: row-resize;\n      }\n    }\n  }\n\n  atom-pane-axis.horizontal {\n    flex-direction: row;\n\n    & > atom-pane-resize-handle {\n      border-right: none;\n      &:before {\n        width: 8px;\n        left: -4px;\n        top: 0;\n        bottom: 0;\n        cursor: col-resize;\n      }\n    }\n  }\n\n  atom-pane {\n    position: relative;\n    display: flex;\n    flex: 1;\n    flex-direction: column;\n    overflow: visible;\n    min-width: 0;\n    min-height: 0;\n\n    .item-views {\n      flex: 1;\n      display: flex;\n      min-width: 0;\n      min-height: 0;\n      position: relative;\n\n      .pane-item {\n        color: @text-color;\n        background-color: @pane-item-background-color;\n      }\n\n      > *, > atom-text-editor.react > * {\n        position: absolute;\n        top: 0;\n        right: 0;\n        bottom: 0;\n        left: 0;\n      }\n    }\n  }\n}\n\n// Windows doesn\'t have row- and col-resize cursors\n.platform-win32 {\n  atom-pane-container {\n    atom-pane-axis.vertical {\n      & > atom-pane-resize-handle {\n        cursor: ns-resize;\n      }\n    }\n\n    atom-pane-axis.horizontal {\n      & > atom-pane-resize-handle {\n        cursor: ew-resize;\n      }\n    }\n  }\n}\n',digest:"6e09826167bc6efad6d102ff6ee0e5b1cc2578d1"},"static/core-ui/syntax.less":{content:'@import "syntax-variables";\n\natom-text-editor {\n  .lines {\n    .markup {\n      &.git-commit {\n        &.changed {\n          color: @syntax-color-modified;\n        }\n\n        &.deleted {\n          color: @syntax-color-removed;\n        }\n\n        &.inserted {\n          color: @syntax-color-added;\n        }\n      }\n    }\n  }\n}\n\n.define-selection-flash-color-if-not-defined() { @syntax-selection-flash-color: rgba(100, 255, 100, 0.7); }\n.define-selection-flash-color-if-not-defined();\n\n@keyframes flash {\n  from { background-color: @syntax-selection-flash-color; }\n  to { background-color: null; }\n}\n\natom-text-editor .flash.selection .region {\n  animation-name: flash;\n  animation-duration: .5s;\n  animation-iteration-count: 1;\n}\n',digest:"bb074c8cc4d337b86f3e16712aa4b1a10174df24"},"static/core-ui/text-editor.less":{content:'@import "ui-variables";\n@import "octicon-utf-codes";\n@import "octicon-mixins";\n\n:root {\n  // Fixes specs\n  --editor-font-family: Menlo, Consolas, \'DejaVu Sans Mono\', monospace;\n}\n\natom-text-editor {\n  display: flex;\n  cursor: text;\n  font-family: var(--editor-font-family);\n  font-size: var(--editor-font-size);\n  line-height: var(--editor-line-height);\n\n  .gutter-container {\n    width: min-content;\n    background-color: inherit;\n    cursor: default;\n  }\n\n  .gutter {\n    overflow: hidden;\n    z-index: 0;\n    text-align: right;\n    min-width: 1em;\n    box-sizing: border-box;\n    background-color: inherit;\n    position: relative;\n  }\n\n  .gutter:hover {\n    .line-number.foldable .icon-right {\n      visibility: visible;\n\n      &:hover {\n        opacity: 1;\n      }\n    }\n  }\n\n  .gutter, .gutter:hover {\n    .line-number.folded .icon-right {\n      .octicon(chevron-right, 0.8em);\n\n      visibility: visible;\n\n      &::before {\n        position: relative;\n        left: -.1em;\n      }\n    }\n  }\n\n  .line-numbers {\n    width: max-content;\n    background-color: inherit;\n  }\n\n  .line-number {\n    padding-left: .5em;\n    white-space: nowrap;\n    opacity: 0.6;\n    position: relative;\n\n    .icon-right {\n      .octicon(chevron-down, 0.8em);\n      display: inline-block;\n      visibility: hidden;\n      opacity: .6;\n      padding: 0 .4em;\n\n      &::before {\n        text-align: center;\n      }\n    }\n  }\n\n  .highlight {\n    background: none;\n    padding: 0;\n  }\n\n  .highlight .region {\n    pointer-events: none;\n    z-index: -1;\n  }\n\n  .line {\n    white-space: pre;\n    contain: layout;\n\n    &.cursor-line .fold-marker::after {\n      opacity: 1;\n    }\n  }\n\n  .fold-marker {\n    cursor: default;\n\n    &::after {\n      .icon(0.8em, inline);\n\n      content: @ellipsis;\n      padding-left: 0.2em;\n    }\n  }\n\n  .placeholder-text {\n    position: absolute;\n    color: @text-color-subtle;\n  }\n\n  .invisible-character {\n    font-weight: normal !important;\n    font-style: normal !important;\n  }\n\n  .indent-guide {\n    display: inline-block;\n    box-shadow: inset 1px 0;\n  }\n\n  .cursor {\n    z-index: 4;\n    pointer-events: none;\n    box-sizing: border-box;\n    position: absolute;\n    border-left: 1px solid;\n    opacity: 0;\n  }\n\n  &.is-focused .cursor {\n    opacity: 1;\n  }\n\n  .cursors.blink-off .cursor {\n    opacity: 0;\n  }\n\n  // Atom manages the selection independent of Blink / the OS. We never want a\n  // native selection.\n  user-select: none;\n}\n\natom-text-editor[mini] {\n  font-size: @input-font-size;\n  line-height: @component-line-height;\n  max-height: @component-line-height + 2; // +2 for borders\n  overflow: auto;\n}\n\natom-overlay {\n  position: fixed;\n  display: block;\n  z-index: 4;\n}\n',digest:"f8ba2541fac65fd0892165574c0e03f14cdbbd31"},"static/core-ui/title-bar.less":{content:'@import "ui-variables";\n\n@title-bar-height:           22px;\n@traffic-lights-width:       68px;\n\n@inset-title-bar-height:     38px;\n@inset-traffic-lights-width: 78px;\n\n@title-bar-text-size: 13px;\n@title-bar-background-color: @base-background-color;\n@title-bar-border-color: @base-border-color;\n\n\n// Title Bar -------------------------------\n\n.title-bar {\n  display: flex;\n  flex-shrink: 0;\n  align-items: center;\n  justify-content: center;\n  overflow: hidden;\n  box-sizing: content-box;\n  font-size: @title-bar-text-size;\n  background-color: @title-bar-background-color;\n  border-bottom: 1px solid @title-bar-border-color;\n  transition: margin-top 160ms;\n  -webkit-user-select: none;\n  -webkit-app-region: drag;\n\n  .title {\n    flex: 0 1 auto;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n  }\n\n  .is-blurred & {\n    color: @text-color-subtle;\n  }\n}\n\n\n// Custom -------------------------------\n\n.custom-title-bar {\n  .title-bar {\n    height: @title-bar-height;\n    padding-left: @traffic-lights-width;\n    padding-right: @traffic-lights-width;\n  }\n\n  &.fullscreen .title-bar {\n    margin-top: -@title-bar-height; // hide title bar in fullscreen mode\n  }\n\n  atom-panel.modal {\n    top: @title-bar-height; // Move modals down\n  }\n}\n\n\n// Custom Inset -------------------------------\n\n.custom-inset-title-bar {\n  .title-bar {\n    height: @inset-title-bar-height;\n    padding-left: @inset-traffic-lights-width;\n    padding-right: @inset-traffic-lights-width;\n  }\n\n  &.fullscreen .title-bar {\n    margin-top: -@inset-title-bar-height; // hide title bar in fullscreen mode\n  }\n\n  atom-panel.modal {\n    top: @inset-title-bar-height; // Move modals down\n  }\n}\n\n\n// Hidden -------------------------------\n\n.hidden-title-bar {\n  .status-bar {\n    -webkit-app-region: drag; // Enable dragging\n  }\n}\n',digest:"7aeb076632ef30bcb6f4c3b25facc4f487b1929d"},"static/core-ui/workspace-view.less":{content:'@import "ui-variables";\n\natom-workspace {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n  overflow: hidden;\n  position: relative;\n  color: @text-color;\n  background-color: @app-background-color;\n  font-family: @font-family;\n\n  atom-workspace-axis {\n    position: relative;\n  }\n\n  atom-workspace-axis.horizontal {\n    display: flex;\n    flex: 1;\n    min-width: 0;\n    min-height: 0;\n  }\n\n  atom-workspace-axis.vertical {\n    display: flex;\n    flex: 1;\n    flex-direction: column;\n    min-width: 0;\n    min-height: 0;\n  }\n}\n',digest:"a2c3f77adc22e4dbff693a00d43be77c3431eea5"},"static/icons/octicons.less":{content:'@import "octicon-mixins";\n\n//\n// Add icon font\n// --------------------------------------------------\n\n@font-face { .octicon-font-legacy(); } // keep for backwards compatibility\n@font-face { .octicon-font(); }\n@font-face { .atomicon-font(); } // Private\n\n\n//\n// Create icons\n// --------------------------------------------------\n\n.make-icon(@name) {\n  .icon-@{name} { .octicon(@name); }\n}\n\n// There seems to be no way to make an array, or grab all the local vars in\n// less, so I am copying the octicon-utf-codes in, then doing a find and\n// replace.\n// Find: @([a-z-]+): "[^"]+";\n// Replace: .make-icon(\\1);\n\n\n// Atomicons (private)\n\n.make-icon(type-array);\n.make-icon(type-boolean);\n.make-icon(type-class);\n.make-icon(type-constant);\n.make-icon(type-constructor);\n.make-icon(type-enum);\n.make-icon(type-field);\n.make-icon(type-file);\n.make-icon(type-function);\n.make-icon(type-interface);\n.make-icon(type-method);\n.make-icon(type-module);\n.make-icon(type-namespace);\n.make-icon(type-number);\n.make-icon(type-package);\n.make-icon(type-property);\n.make-icon(type-string);\n.make-icon(type-variable);\n\n\n// Octicons\n\n.make-icon(alert);\n.make-icon(alignment-align);\n.make-icon(alignment-aligned-to);\n.make-icon(alignment-unalign);\n.make-icon(arrow-down);\n.make-icon(arrow-left);\n.make-icon(arrow-right);\n.make-icon(arrow-small-down);\n.make-icon(arrow-small-left);\n.make-icon(arrow-small-right);\n.make-icon(arrow-small-up);\n.make-icon(arrow-up);\n.make-icon(beaker);\n.make-icon(beer);\n.make-icon(bell);\n.make-icon(bold);\n.make-icon(book);\n.make-icon(bookmark);\n.make-icon(briefcase);\n.make-icon(broadcast);\n.make-icon(browser);\n.make-icon(bug);\n.make-icon(calendar);\n.make-icon(check);\n.make-icon(checklist);\n.make-icon(chevron-down);\n.make-icon(chevron-left);\n.make-icon(chevron-right);\n.make-icon(chevron-up);\n.make-icon(circle-slash);\n.make-icon(circuit-board);\n.make-icon(clippy);\n.make-icon(clock);\n.make-icon(cloud-download);\n.make-icon(cloud-upload);\n.make-icon(code);\n.make-icon(color-mode);\n.make-icon(comment);\n.make-icon(comment-add);\n.make-icon(comment-discussion);\n.make-icon(credit-card);\n.make-icon(dash);\n.make-icon(dashboard);\n.make-icon(database);\n.make-icon(desktop-download);\n.make-icon(device-camera);\n.make-icon(device-camera-video);\n.make-icon(device-desktop);\n.make-icon(device-mobile);\n.make-icon(diff);\n.make-icon(diff-added);\n.make-icon(diff-ignored);\n.make-icon(diff-modified);\n.make-icon(diff-removed);\n.make-icon(diff-renamed);\n.make-icon(ellipses);\n.make-icon(ellipsis);\n.make-icon(eye);\n.make-icon(eye-unwatch);\n.make-icon(eye-watch);\n.make-icon(file);\n.make-icon(file-add);\n.make-icon(file-binary);\n.make-icon(file-code);\n.make-icon(file-directory);\n.make-icon(file-directory-create);\n.make-icon(file-media);\n.make-icon(file-pdf);\n.make-icon(file-submodule);\n.make-icon(file-symlink-directory);\n.make-icon(file-symlink-file);\n.make-icon(file-text);\n.make-icon(file-zip);\n.make-icon(flame);\n.make-icon(fold);\n.make-icon(gear);\n.make-icon(gift);\n.make-icon(gist);\n.make-icon(gist-fork);\n.make-icon(gist-new);\n.make-icon(gist-private);\n.make-icon(gist-secret);\n.make-icon(git-branch);\n.make-icon(git-branch-create);\n.make-icon(git-branch-delete);\n.make-icon(git-commit);\n.make-icon(git-compare);\n.make-icon(git-fork-private);\n.make-icon(git-merge);\n.make-icon(git-pull-request);\n.make-icon(git-pull-request-abandoned);\n.make-icon(globe);\n.make-icon(grabber);\n.make-icon(graph);\n.make-icon(heart);\n.make-icon(history);\n.make-icon(home);\n.make-icon(horizontal-rule);\n.make-icon(hourglass);\n.make-icon(hubot);\n.make-icon(inbox);\n.make-icon(info);\n.make-icon(issue-closed);\n.make-icon(issue-opened);\n.make-icon(issue-reopened);\n.make-icon(italic);\n.make-icon(jersey);\n.make-icon(jump-down);\n.make-icon(jump-left);\n.make-icon(jump-right);\n.make-icon(jump-up);\n.make-icon(key);\n.make-icon(keyboard);\n.make-icon(law);\n.make-icon(light-bulb);\n.make-icon(link);\n.make-icon(link-external);\n.make-icon(list-ordered);\n.make-icon(list-unordered);\n.make-icon(location);\n.make-icon(lock);\n.make-icon(log-in);\n.make-icon(log-out);\n.make-icon(logo-gist);\n.make-icon(logo-github);\n.make-icon(mail);\n.make-icon(mail-read);\n.make-icon(mail-reply);\n.make-icon(mark-github);\n.make-icon(markdown);\n.make-icon(megaphone);\n.make-icon(mention);\n.make-icon(microscope);\n.make-icon(milestone);\n.make-icon(mirror);\n.make-icon(mirror-private);\n.make-icon(mirror-public);\n.make-icon(mortar-board);\n.make-icon(move-down);\n.make-icon(move-left);\n.make-icon(move-right);\n.make-icon(move-up);\n.make-icon(mute);\n.make-icon(no-newline);\n.make-icon(octoface);\n.make-icon(organization);\n.make-icon(package);\n.make-icon(paintcan);\n.make-icon(pencil);\n.make-icon(person);\n.make-icon(person-add);\n.make-icon(person-follow);\n.make-icon(pin);\n.make-icon(playback-fast-forward);\n.make-icon(playback-pause);\n.make-icon(playback-play);\n.make-icon(playback-rewind);\n.make-icon(plug);\n.make-icon(plus);\n.make-icon(plus-small);\n.make-icon(podium);\n.make-icon(primitive-dot);\n.make-icon(primitive-square);\n.make-icon(pulse);\n.make-icon(puzzle);\n.make-icon(question);\n.make-icon(quote);\n.make-icon(radio-tower);\n.make-icon(remove-close);\n.make-icon(reply);\n.make-icon(repo);\n.make-icon(repo-clone);\n.make-icon(repo-create);\n.make-icon(repo-delete);\n.make-icon(repo-force-push);\n.make-icon(repo-forked);\n.make-icon(repo-pull);\n.make-icon(repo-push);\n.make-icon(repo-sync);\n.make-icon(rocket);\n.make-icon(rss);\n.make-icon(ruby);\n.make-icon(screen-full);\n.make-icon(screen-normal);\n.make-icon(search);\n.make-icon(search-save);\n.make-icon(server);\n.make-icon(settings);\n.make-icon(shield);\n.make-icon(sign-in);\n.make-icon(sign-out);\n.make-icon(smiley);\n.make-icon(split);\n.make-icon(squirrel);\n.make-icon(star);\n.make-icon(star-add);\n.make-icon(star-delete);\n.make-icon(steps);\n.make-icon(stop);\n.make-icon(sync);\n.make-icon(tag);\n.make-icon(tag-add);\n.make-icon(tag-remove);\n.make-icon(tasklist);\n.make-icon(telescope);\n.make-icon(terminal);\n.make-icon(text-size);\n.make-icon(three-bars);\n.make-icon(thumbsdown);\n.make-icon(thumbsup);\n.make-icon(tools);\n.make-icon(trashcan);\n.make-icon(triangle-down);\n.make-icon(triangle-left);\n.make-icon(triangle-right);\n.make-icon(triangle-up);\n.make-icon(unfold);\n.make-icon(unmute);\n.make-icon(unverified);\n.make-icon(verified);\n.make-icon(versions);\n.make-icon(watch);\n.make-icon(x);\n.make-icon(zap);\n',digest:"88befa385ae43f46cf5b0b404ac94d45d37b26f6"},"static/jasmine.less":{content:'@import "ui-variables";\n@import "octicon-mixins";\n\nhtml {\n  background-color: @base-background-color;\n}\n\nbody {\n  padding: 0;\n  background-color: transparent;\n}\n\n.spec-reporter-container {\n  position: fixed;\n  display: flex;\n  flex-direction: column;\n  justify-content: flex-end;\n  z-index: 99999;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n\n.spec-reporter {\n  flex: 1 1 0;\n  overflow-y: auto;\n  font-size: 11px;\n  line-height: 1.6em;\n  color: #333;\n  background-color: hsl(0, 0%, 98%);\n\n  // 578px initial window height, resize to see underlying editor\n  @media (min-height: 578px) {\n    flex: 0 1 75%;\n    min-height: 578px;\n  }\n\n  .list-unstyled {\n    list-style: none;\n  }\n\n  .reload-button {\n    color: #333;\n    background-color: #fff;\n    border: 1px solid #ccc;\n\n    &:hover {\n      background-color: #ddd;\n      color: #222;\n    }\n  }\n\n  .symbol-header {\n    font-size: 18px;\n    font-weight: bold;\n    padding-bottom: 10px;\n  }\n\n  .symbol-area {\n    padding: 10px;\n  }\n\n  .symbol-summary {\n    overflow: hidden;\n    margin: 0;\n\n    li {\n      font-family: Monaco, Consolas, monospace;\n      float: left;\n      line-height: 10px;\n      height: 10px;\n      width: 10px;\n      font-size: 10px;\n\n      &.passed {\n        color: #5cb85c;\n      }\n\n      &.failed {\n        color: #d9534f;\n      }\n\n      &.skipped {\n        color: #f0ad4e;\n      }\n\n      &.pending {\n        color: #eee;\n      }\n\n      &::before {\n        content: "\\02022";\n      }\n    }\n  }\n\n  .status {\n    font-size: 20px;\n    line-height: 2em;\n    padding: 5px;\n    border-radius: 0;\n    text-align: center;\n\n    .spec-count {\n      float: left;\n    }\n\n    .time {\n      float: right;\n    }\n  }\n\n  .results {\n    padding: 10px;\n\n    .description {\n      font-size: 16px;\n      padding: 5px 0 5px 0;\n    }\n\n    > .suite {\n      > .description {\n        font-size: 18px;\n        font-weight: bold;\n      }\n\n      margin-bottom: 20px;\n    }\n\n    .spec {\n      margin-top: 5px;\n      padding: 0 10px 10px 10px;\n      border-left: 3px solid #d9534f;\n\n      .spec-toggle {\n        .octicon(fold);\n        float: right;\n        cursor: pointer;\n        opacity: 0;\n        color: #999;\n\n        &.folded {\n          .octicon(unfold);\n        }\n      }\n\n      .spec-toggle:hover {\n        color: #333;\n      }\n\n      &:hover .spec-toggle {\n        opacity: 1;\n      }\n    }\n\n    .suite > .suite,\n    .suite > .spec {\n      margin-left: 10px;\n    }\n  }\n\n  .result-message {\n    font-size: 16px;\n    font-weight: bold;\n    color: #d9534f;\n    padding: 5px 0 5px 0;\n    white-space: pre-wrap;\n  }\n\n  .result-message.deprecation-message {\n    font-weight: normal;\n    color: darken(#f0ad4e, 20%);\n    line-height: 1.4;\n\n    a {\n      color: darken(#f0ad4e, 15%);\n    }\n\n    code {\n      color: darken(#f0ad4e, 20%);\n      background: lighten(#f0ad4e, 35%);\n    }\n  }\n\n  .stack-trace {\n    font-size: 12px;\n    margin: 5px 0 0 0;\n    border-radius: 2px;\n    line-height: 18px;\n    color: #ccc;\n    border: 1px solid #ddd;\n    overflow: auto;\n  }\n\n  .tooltip {\n    .tooltip-inner {\n      border: 1px solid #ccc;\n      background: #fff;\n      color: #666;\n      max-width: 400px;\n    }\n\n    &.in {\n      opacity: 1;\n    }\n\n    .tooltip-arrow {\n      visibility: hidden;\n    }\n  }\n\n  .result-message.fail, .stack-trace.padded {\n    text-overflow: ellipsis;\n    display: -webkit-box;\n    -webkit-box-orient: vertical;\n    -webkit-line-clamp: 10;\n    overflow: hidden;\n\n    &.expanded {\n      -webkit-line-clamp: inherit;\n      // overflow: hidden;\n    }\n  }\n\n  .deprecation-toggle {\n    .octicon(fold);\n    float: right;\n    cursor: pointer;\n    opacity: 0;\n    color: #999;\n\n    &.folded {\n      .octicon(unfold);\n    }\n  }\n\n  .deprecation-toggle:hover {\n    color: #333;\n  }\n\n  &:hover .deprecation-toggle {\n    opacity: 1;\n  }\n}\n',digest:"e40f499e4c81187cb45b28968d0307a73e146103"},"static/linux.less":{content:"::-webkit-scrollbar-corner {\n  background-color: transparent;\n}\n\n::-webkit-scrollbar {\n  width: 8px;\n  height: 8px;\n}\n\n::-webkit-scrollbar-thumb {\n  border-radius: 2px;\n  background: rgba(150, 150, 150, .33);\n}\n",digest:"4c4a94845e7f223b4aca5a2ac1fb52a02eb1ce43"},"static/normalize.less":{content:'/*! normalize.css v3.0.3 | MIT License | github.com/necolas/normalize.css */\n// Modified to Chrome only.\n\n//\n// Remove default margin.\n//\n\nbody {\n  margin: 0;\n}\n\n// HTML5 display definitions\n// ==========================================================================\n\n//\n// 1. Normalize vertical alignment of `progress` in Chrome, Firefox, and Opera.\n//\n\naudio,\ncanvas,\nprogress,\nvideo {\n  vertical-align: baseline; // 1\n}\n\n//\n// Prevent modern browsers from displaying `audio` without controls.\n//\n\naudio:not([controls]) {\n  display: none;\n}\n\n// Links\n// ==========================================================================\n\n//\n// Improve readability of focused elements when they are also in an\n// active/hover state.\n//\n\na:active,\na:hover {\n  outline: 0;\n}\n\n// Text-level semantics\n// ==========================================================================\n\n//\n// Address styling not present in IE 8/9/10/11, Safari, and Chrome.\n//\n\nabbr[title] {\n  border-bottom: 1px dotted;\n}\n\n//\n// Address style set to `bolder` in Firefox 4+, Safari, and Chrome.\n//\n\nb,\nstrong {\n  font-weight: bold;\n}\n\n//\n// Address styling not present in Safari and Chrome.\n//\n\ndfn {\n  font-style: italic;\n}\n\n//\n// Address variable `h1` font-size and margin within `section` and `article`\n// contexts in Firefox 4+, Safari, and Chrome.\n//\n\nh1 {\n  font-size: 2em;\n  margin: 0.67em 0;\n}\n\n//\n// Address inconsistent and variable font size in all browsers.\n//\n\nsmall {\n  font-size: 80%;\n}\n\n//\n// Prevent `sub` and `sup` affecting `line-height` in all browsers.\n//\n\nsub,\nsup {\n  font-size: 75%;\n  line-height: 0;\n  position: relative;\n  vertical-align: baseline;\n}\n\nsup {\n  top: -0.5em;\n}\n\nsub {\n  bottom: -0.25em;\n}\n\n// Grouping content\n// ==========================================================================\n\n//\n// Address differences between Firefox and other browsers.\n//\n\nhr {\n  box-sizing: content-box;\n  height: 0;\n}\n\n//\n// Contain overflow in all browsers.\n//\n\npre {\n  overflow: auto;\n}\n\n//\n// Address odd `em`-unit font size rendering in all browsers.\n//\n\ncode,\nkbd,\npre,\nsamp {\n  font-family: monospace, monospace;\n  font-size: 1em;\n}\n\n// Forms\n// ==========================================================================\n\n//\n// Known limitation: by default, Chrome and Safari on OS X allow very limited\n// styling of `select`, unless a `border` property is set.\n//\n\n//\n// 1. Correct color not being inherited.\n//    Known issue: affects color of disabled elements.\n// 2. Correct font properties not being inherited.\n// 3. Address margins set differently in Firefox 4+, Safari, and Chrome.\n//\n\nbutton,\ninput,\noptgroup,\nselect,\ntextarea {\n  color: inherit; // 1\n  font: inherit; // 2\n  margin: 0; // 3\n}\n\n//\n// Address inconsistent `text-transform` inheritance for `button` and `select`.\n// All other form control elements do not inherit `text-transform` values.\n//\n\nbutton,\nselect {\n  text-transform: none;\n}\n\n//\n// 1. Improve usability and consistency of cursor style between image-type\n//    `input` and others.\n//\n\nbutton,\ninput[type="reset"],\ninput[type="submit"] {\n  cursor: pointer; // 1\n}\n\n//\n// Re-set default cursor for disabled elements.\n//\n\nbutton[disabled],\nhtml input[disabled] {\n  cursor: default;\n}\n\n//\n// Fix the cursor style for Chrome\'s increment/decrement buttons. For certain\n// `font-size` values of the `input`, it causes the cursor style of the\n// decrement button to change from `default` to `text`.\n//\n\ninput[type="number"]::-webkit-inner-spin-button,\ninput[type="number"]::-webkit-outer-spin-button {\n  height: auto;\n}\n\n//\n// 1. Address `appearance` set to `searchfield` in Safari and Chrome.\n// 2. Address `box-sizing` set to `border-box` in Safari and Chrome.\n//\n\ninput[type="search"] {\n  -webkit-appearance: textfield; // 1\n  box-sizing: content-box; //2\n}\n\n//\n// Remove inner padding and search cancel button in Safari and Chrome on OS X.\n// Safari (but not Chrome) clips the cancel button when the search input has\n// padding (and `textfield` appearance).\n//\n\ninput[type="search"]::-webkit-search-cancel-button,\ninput[type="search"]::-webkit-search-decoration {\n  -webkit-appearance: none;\n}\n\n//\n// Define consistent border, margin, and padding.\n//\n\nfieldset {\n  border: 1px solid;\n  margin: 0 2px;\n  padding: 0.35em 0.625em 0.75em;\n}\n\n//\n// 1. Remove padding so people aren\'t caught out if they zero out fieldsets.\n//\n\nlegend {\n  padding: 0; // 1\n}\n\n//\n// Don\'t inherit the `font-weight` (applied by a rule above).\n// NOTE: the default cannot safely be changed in Chrome and Safari on OS X.\n//\n\noptgroup {\n  font-weight: bold;\n}\n\n// Tables\n// ==========================================================================\n\n//\n// Remove most spacing between table cells.\n//\n\ntable {\n  border-collapse: collapse;\n  border-spacing: 0;\n}\n\ntd,\nth {\n  padding: 0;\n}\n',digest:"ab87f6d9d1264047613b807775d6a8407ee6675a"},"static/scaffolding.less":{content:'@import "ui-variables";\n\n\n//\n// Scaffolding\n// --------------------------------------------------\n\n*,\n*:before,\n*:after {\n  box-sizing: border-box; // Reset the box-sizing\n}\n\nhtml,\nbody {\n  width: 100%;\n  height: 100%;\n  overflow: hidden;\n}\n\nhtml {\n  font-family: @font-family;\n  font-size: @font-size;\n  line-height: 1.428571429; // 20/14\n  color: @text-color;\n  background-color: @app-background-color;\n}\n',digest:"87e3fd6fec379bfe1d44e7b51b8083af88fab0bb"},"static/variables/octicon-mixins.less":{content:"@import \"octicon-utf-codes.less\";\n\n.icon-size(@size) {\n  font-size: @size;\n  width: @size;\n  height: @size;\n}\n\n.icon(@size, @display: inline-block) {\n  font-family: 'Octicons Regular';\n  font-weight: normal;\n  font-style: normal;\n  display: @display;\n  line-height: 1;\n  -webkit-font-smoothing: antialiased;\n  text-decoration: none;\n\n  .icon-size(@size);\n}\n\n.octicon(@name, @size: 16px) {\n  &::before {\n    .icon(@size);\n    content: @@name\n  }\n}\n\n.mega-octicon(@name, @size: 32px) {\n  &::before {\n    .icon(@size);\n    content: @@name\n  }\n}\n\n// keep for backwards compatibility\n.octicon-font-legacy() {\n  font-family: 'Octicons Regular';\n  src: url(\"icons/octicons-2.1.2.woff\") format(\"woff\");\n  font-weight: normal;\n  font-style: normal;\n}\n\n.octicon-font() {\n  font-family: 'Octicons Regular';\n  src: url(\"icons/octicons.woff\") format(\"woff\");\n  font-weight: normal;\n  font-style: normal;\n}\n\n.atomicon-font() {\n  font-family: 'Octicons Regular';\n  src: url('icons/atomicons.woff') format('woff');\n  font-weight: normal;\n  font-style: normal;\n}\n",digest:"920e51dbba5c8b551e5bd82dc3190d5943304d11"},"static/variables/octicon-utf-codes.less":{content:'\n// Atomicons (private)\n\n@type-array: "\\e900";\n@type-boolean: "\\e901";\n@type-class: "\\e902";\n@type-constant: "\\e903";\n@type-constructor: "\\e904";\n@type-enum: "\\e905";\n@type-field: "\\e906";\n@type-file: "\\e907";\n@type-function: "\\e908";\n@type-interface: "\\e909";\n@type-method: "\\e90a";\n@type-module: "\\e90b";\n@type-namespace: "\\e90c";\n@type-number: "\\e90d";\n@type-package: "\\e90e";\n@type-property: "\\e90f";\n@type-string: "\\e910";\n@type-variable: "\\e911";\n\n\n// Octicons\n\n@alert: "\\f02d";\n@alignment-align: "\\f08a";\n@alignment-aligned-to: "\\f08e";\n@alignment-unalign: "\\f08b";\n@arrow-down: "\\f03f";\n@arrow-left: "\\f040";\n@arrow-right: "\\f03e";\n@arrow-small-down: "\\f0a0";\n@arrow-small-left: "\\f0a1";\n@arrow-small-right: "\\f071";\n@arrow-small-up: "\\f09f";\n@arrow-up: "\\f03d";\n@beaker: "\\f0dd";\n@beer: "\\f069";\n@bell: "\\f0de";\n@bold: "\\f0e2";\n@book: "\\f007";\n@bookmark: "\\f07b";\n@briefcase: "\\f0d3";\n@broadcast: "\\f048";\n@browser: "\\f0c5";\n@bug: "\\f091";\n@calendar: "\\f068";\n@check: "\\f03a";\n@checklist: "\\f076";\n@chevron-down: "\\f0a3";\n@chevron-left: "\\f0a4";\n@chevron-right: "\\f078";\n@chevron-up: "\\f0a2";\n@circle-slash: "\\f084";\n@circuit-board: "\\f0d6";\n@clippy: "\\f035";\n@clock: "\\f046";\n@cloud-download: "\\f00b";\n@cloud-upload: "\\f00c";\n@code: "\\f05f";\n@color-mode: "\\f065";\n@comment: "\\f02b";\n@comment-add: "\\f02b";\n@comment-discussion: "\\f04f";\n@credit-card: "\\f045";\n@dash: "\\f0ca";\n@dashboard: "\\f07d";\n@database: "\\f096";\n@desktop-download: "\\f0dc";\n@device-camera: "\\f056";\n@device-camera-video: "\\f057";\n@device-desktop: "\\f27c";\n@device-mobile: "\\f038";\n@diff: "\\f04d";\n@diff-added: "\\f06b";\n@diff-ignored: "\\f099";\n@diff-modified: "\\f06d";\n@diff-removed: "\\f06c";\n@diff-renamed: "\\f06e";\n@ellipses: "\\f101";\n@ellipsis: "\\f09a";\n@eye: "\\f04e";\n@eye-unwatch: "\\f04e";\n@eye-watch: "\\f04e";\n@file: "\\f102";\n@file-add: "\\f05d";\n@file-binary: "\\f094";\n@file-code: "\\f010";\n@file-directory: "\\f016";\n@file-directory-create: "\\f05d";\n@file-media: "\\f012";\n@file-pdf: "\\f014";\n@file-submodule: "\\f017";\n@file-symlink-directory: "\\f0b1";\n@file-symlink-file: "\\f0b0";\n@file-text: "\\f011";\n@file-zip: "\\f013";\n@flame: "\\f0d2";\n@fold: "\\f0cc";\n@gear: "\\f02f";\n@gift: "\\f042";\n@gist: "\\f00e";\n@gist-fork: "\\f002";\n@gist-new: "\\f05d";\n@gist-private: "\\f06a";\n@gist-secret: "\\f08c";\n@git-branch: "\\f020";\n@git-branch-create: "\\f020";\n@git-branch-delete: "\\f020";\n@git-commit: "\\f01f";\n@git-compare: "\\f0ac";\n@git-fork-private: "\\f06a";\n@git-merge: "\\f023";\n@git-pull-request: "\\f009";\n@git-pull-request-abandoned: "\\f009";\n@globe: "\\f0b6";\n@grabber: "\\f103";\n@graph: "\\f043";\n@heart: "\\2665";\n@history: "\\f07e";\n@home: "\\f08d";\n@horizontal-rule: "\\f070";\n@hourglass: "\\f09e";\n@hubot: "\\f09d";\n@inbox: "\\f0cf";\n@info: "\\f059";\n@issue-closed: "\\f028";\n@issue-opened: "\\f026";\n@issue-reopened: "\\f027";\n@italic: "\\f0e4";\n@jersey: "\\f019";\n@jump-down: "\\f072";\n@jump-left: "\\f0a5";\n@jump-right: "\\f0a6";\n@jump-up: "\\f073";\n@key: "\\f049";\n@keyboard: "\\f00d";\n@law: "\\f0d8";\n@light-bulb: "\\f000";\n@link: "\\f05c";\n@link-external: "\\f07f";\n@list-ordered: "\\f062";\n@list-unordered: "\\f061";\n@location: "\\f060";\n@lock: "\\f06a";\n@log-in: "\\f036";\n@log-out: "\\f032";\n@logo-gist: "\\f0ad";\n@logo-github: "\\f092";\n@mail: "\\f03b";\n@mail-read: "\\f03c";\n@mail-reply: "\\f051";\n@mark-github: "\\f00a";\n@markdown: "\\f0c9";\n@megaphone: "\\f077";\n@mention: "\\f0be";\n@microscope: "\\f089";\n@milestone: "\\f075";\n@mirror: "\\f024";\n@mirror-private: "\\f06a";\n@mirror-public: "\\f024";\n@mortar-board: "\\f0d7";\n@move-down: "\\f0a8";\n@move-left: "\\f074";\n@move-right: "\\f0a9";\n@move-up: "\\f0a7";\n@mute: "\\f080";\n@no-newline: "\\f09c";\n@octoface: "\\f008";\n@organization: "\\f037";\n@package: "\\f0c4";\n@paintcan: "\\f0d1";\n@pencil: "\\f058";\n@person: "\\f018";\n@person-add: "\\f018";\n@person-follow: "\\f018";\n@pin: "\\f041";\n@playback-fast-forward: "\\f0bd";\n@playback-pause: "\\f0bb";\n@playback-play: "\\f0bf";\n@playback-rewind: "\\f0bc";\n@plug: "\\f0d4";\n@plus: "\\f05d";\n@plus-small: "\\f104";\n@podium: "\\f0af";\n@primitive-dot: "\\f052";\n@primitive-square: "\\f053";\n@pulse: "\\f085";\n@puzzle: "\\f0c0";\n@question: "\\f02c";\n@quote: "\\f063";\n@radio-tower: "\\f030";\n@remove-close: "\\f081";\n@reply: "\\f105";\n@repo: "\\f001";\n@repo-clone: "\\f04c";\n@repo-create: "\\f05d";\n@repo-delete: "\\f001";\n@repo-force-push: "\\f04a";\n@repo-forked: "\\f002";\n@repo-pull: "\\f006";\n@repo-push: "\\f005";\n@repo-sync: "\\f087";\n@rocket: "\\f033";\n@rss: "\\f034";\n@ruby: "\\f047";\n@screen-full: "\\f066";\n@screen-normal: "\\f067";\n@search: "\\f02e";\n@search-save: "\\f02e";\n@server: "\\f097";\n@settings: "\\f07c";\n@shield: "\\f0e1";\n@sign-in: "\\f036";\n@sign-out: "\\f032";\n@smiley: "\\f0e7";\n@split: "\\f0c6";\n@squirrel: "\\f0b2";\n@star: "\\f02a";\n@star-add: "\\f02a";\n@star-delete: "\\f02a";\n@steps: "\\f0c7";\n@stop: "\\f08f";\n@sync: "\\f087";\n@tag: "\\f015";\n@tag-add: "\\f015";\n@tag-remove: "\\f015";\n@tasklist: "\\f0e5";\n@telescope: "\\f088";\n@terminal: "\\f0c8";\n@text-size: "\\f0e3";\n@three-bars: "\\f05e";\n@thumbsdown: "\\f0db";\n@thumbsup: "\\f0da";\n@tools: "\\f031";\n@trashcan: "\\f0d0";\n@triangle-down: "\\f05b";\n@triangle-left: "\\f044";\n@triangle-right: "\\f05a";\n@triangle-up: "\\f0aa";\n@unfold: "\\f039";\n@unmute: "\\f0ba";\n@unverified: "\\f0e8";\n@verified: "\\f0e6";\n@versions: "\\f064";\n@watch: "\\f0e0";\n@x: "\\f081";\n@zap: "\\26A1";\n',digest:"fca97c7cecae6f10fc64d90751603b41f79a4a0d"},"static/variables/syntax-variables.less":{content:"// This file has fallback variables. It specifies all syntax variables that\n// themes must implement if they include a syntax-variables.less file.\n\n// General colors\n@syntax-text-color: #333;\n@syntax-cursor-color: #333;\n@syntax-selection-color: #69c;\n@syntax-selection-flash-color: #00f; // Color the selection is 'flashed' when you run find next\n@syntax-background-color: #fff;\n\n// Guide colors\n@syntax-wrap-guide-color: #ccc;\n@syntax-indent-guide-color: #ccc;\n@syntax-invisible-character-color: #ccc;\n\n// For find and replace markers\n@syntax-result-marker-color: #444;\n@syntax-result-marker-color-selected: #000;\n\n// Gutter colors\n@syntax-gutter-text-color: #333;\n@syntax-gutter-text-color-selected: #000;\n@syntax-gutter-background-color: #ccc;\n@syntax-gutter-background-color-selected: #eee;\n\n// For git diff info. i.e. in the gutter\n@syntax-color-added: green;\n@syntax-color-modified: orange;\n@syntax-color-removed: red;\n@syntax-color-renamed: blue;\n\n// For language entity colors\n@syntax-color-variable: #DF6A73;\n@syntax-color-constant: #DF6A73;\n@syntax-color-property: #DF6A73;\n@syntax-color-value: #D29B67;\n@syntax-color-function: #61AEEF;\n@syntax-color-method: @syntax-color-function;\n@syntax-color-class: #E5C17C;\n@syntax-color-keyword: #a431c4;\n@syntax-color-tag: #b72424;\n@syntax-color-attribute: #87400d;\n@syntax-color-import: #97C378;\n@syntax-color-snippet: #97C378;\n",digest:"812c1b7883a023f768773d14294653adcdb932d7"},"static/variables/ui-variables.less":{content:"// This file has fallback variables. It specifies the variables themes\n// must implement.\n\n// Colors\n\n@text-color: #333;\n@text-color-subtle: #777;\n@text-color-highlight: #111;\n@text-color-selected: @text-color-highlight;\n\n@text-color-info: #5293d8;\n@text-color-success: #1fe977;\n@text-color-warning: #f78a46;\n@text-color-error: #c00;\n\n@background-color-info: #0098ff;\n@background-color-success: #17ca65;\n@background-color-warning: #ff4800;\n@background-color-error: #c00;\n@background-color-highlight: hsla(0,0%,0%,.1);\n@background-color-selected: @background-color-highlight;\n\n@app-background-color: #fff;\n\n@base-background-color: #fff;\n@base-border-color: #eee;\n\n@pane-item-background-color: @base-background-color;\n@pane-item-border-color: @base-border-color;\n\n@input-background-color: #fff;\n@input-border-color: @base-border-color;\n\n@tool-panel-background-color: #f4f4f4;\n@tool-panel-border-color: @base-border-color;\n\n@inset-panel-background-color: #eee;\n@inset-panel-border-color: @base-border-color;\n\n@panel-heading-background-color: #ddd;\n@panel-heading-border-color: transparent;\n\n@overlay-background-color: #f4f4f4;\n@overlay-border-color: @base-border-color;\n\n@button-background-color: #ccc;\n@button-background-color-hover: lighten(@button-background-color, 5%);\n@button-background-color-selected: @button-background-color-hover;\n@button-border-color: #aaa;\n\n@tab-bar-background-color: #fff;\n@tab-bar-border-color: darken(@tab-background-color-active, 10%);\n@tab-background-color: #f4f4f4;\n@tab-background-color-active: #fff;\n@tab-border-color: @base-border-color;\n\n@tree-view-background-color: @tool-panel-background-color;\n@tree-view-border-color: @tool-panel-border-color;\n\n@ui-site-color-1: @background-color-success; // green\n@ui-site-color-2: @background-color-info; // blue\n@ui-site-color-3: @background-color-warning; // orange\n@ui-site-color-4: #db2ff4; // purple\n@ui-site-color-5: #f5e11d; // yellow\n\n\n// Sizes\n\n@font-size: 13px;\n@input-font-size: 14px;\n\n@disclosure-arrow-size: 12px;\n\n@component-padding: 10px;\n@component-icon-padding: 5px;\n@component-icon-size: 16px;\n@component-line-height: 25px;\n@component-border-radius: 2px;\n\n@tab-height: 30px;\n\n// Other\n\n@font-family: system-ui;\n@use-custom-controls: true; // false uses native controls\n",digest:"b28ed6c38c4cfce23f83a1b012a3968aa63fce4c"},"node_modules/about/styles/about.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n@import "variables";\n\n.about {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: flex-start;\n  -webkit-user-select: none;\n  cursor: default;\n  overflow: auto;\n  text-align: center;\n  font-size: 1.25em;\n  line-height: 1.4;\n  padding: 4em;\n  color: @text-color;\n  background-color: @base-background-color;\n\n  button {\n    cursor: default;\n  }\n\n  a:focus {\n    // Don\'t use Bootstrap default here\n    color: inherit;\n  }\n\n  img, a {\n    -webkit-user-drag: none;\n  }\n\n  .input-checkbox {\n    margin-top: -.2em;\n  }\n\n  // used to group different elements\n  .group-start {\n    margin-top: 4em;\n  }\n  .group-item {\n    margin-top: 1.5em;\n  }\n}\n\n.about-container {\n  width: 100%;\n  max-width: 500px;\n}\n\n// Header --------------------------------\n\n.about-atom-io:hover {\n  .about-logo {\n    color: @atom-green;\n  }\n}\n\n.about-logo {\n  display: block;\n  width: 100%;\n  max-width: 280px;\n  margin: 0 auto 1em auto;\n  color: @text-color-highlight;\n  transition: color 0.2s;\n}\n\n.about-version-container {\n  &:hover {\n    color: lighten(@text-color, 15%);\n  }\n  &:active {\n    color: lighten(@text-color, 30%);\n  }\n}\n\n.about-version {\n  margin-right: .5em;\n  font-size: 1.25em;\n  vertical-align: middle;\n}\n\n.about-more-version {\n  color: @text-color-subtle;\n  font-size: .9em;\n}\n\n.about-header-release-notes {\n  vertical-align: middle;\n  margin-left: 1em;\n}\n\n\n// Updates --------------------------------\n\n.about-updates {\n  width: 100%;\n  max-width: 500px;\n}\n\n.about-updates-box {\n  display: flex;\n  align-items: center;\n  padding: @component-padding;\n  border: 1px solid @base-border-color;\n  border-radius: @component-border-radius * 2;\n  background-color: @background-color-highlight;\n}\n\n.about-updates-status {\n  flex: 1;\n  margin-left: .5em;\n  text-align: left;\n}\n\n.about-updates-item,\n.about-default-update-message .about-updates-label {\n  display: block;\n}\n\n.about-updates-label {\n  color: @text-color-subtle;\n  &.is-strong {\n    color: @text-color;\n  }\n}\n\n.about-updates-version {\n  margin: 0 .4em;\n}\n\n.about-updates-release-notes,\n.about-updates-instructions {\n  margin: 0 1em 0 1.5em;\n}\n\n.about-auto-updates {\n  margin-top: 1em;\n  input {\n    margin-right: .5em;\n  }\n}\n\n\n// Love --------------------------------\n\n.about-love {\n  .icon::before {\n    // Make these octicons look good inlined with text\n    position: relative;\n    width: auto;\n    height: auto;\n    margin-right: 0;\n    font-size: 1.5em;\n    vertical-align: text-top;\n  }\n\n  .icon-logo-github::before {\n    font-size: 3.6em;\n    height: .36em;\n  }\n}\n\n.about-credits {\n  color: @text-color-subtle;\n}\n\n\n// the blue squirrel --------------------------------\n\n.about-release-notes {\n  color: @background-color-info;\n  &:hover {\n    color: lighten(@background-color-info, 15%);\n  }\n}\n',digest:"48603f4adb2ca350de73bbf81da2dedff7276264"},"node_modules/about/styles/variables.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@atom-green: #40a977;\n',digest:"af218163acb279019a92806f4afe744bb0e0ccbf"},"node_modules/archive-view/styles/archive-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n.archive-editor {\n  background-color: @inset-panel-background-color;\n  overflow: auto;\n  contain: strict;\n\n  .archive-container {\n    height: 100%;\n    width: 100%;\n\n    .inset-panel {\n      border-width: 0;\n\n      .panel-heading {\n        border-radius: 0;\n      }\n\n      .archive-tree {\n        padding: 5px;\n      }\n    }\n  }\n}\n',digest:"b1f00da854ca81e8fc8879034edfb54f8fb7d6ad"},"node_modules/autocomplete-plus/styles/autocomplete.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n// TODO: remove this fallback when 193 is out for a while\n.attr-syntax-color() { @syntax-color-attribute: #888; } .attr-syntax-color();\n\n@import "ui-variables";\n@import "syntax-variables";\n\n@font-size-small: .9em;\n@type-icon-font-size: 1em;\n@type-letter-icon-font-size: @font-size-small;\n@row-line-height: 2em;\n@item-padding: .75em;\n@item-side-padding: .6em;\n\natom-overlay.autocomplete-plus {\n  z-index: 12; // higher than docks\n}\n\nautocomplete-suggestion-list.select-list.popover-list {\n  width: auto !important; // TODO: Can be removed once the inline style is gone\n  display: inline-block;\n  min-width: 243px; // Try and fail until the specs pass\n  padding: 0;\n  overflow: hidden;\n  color: @text-color;\n\n  .suggestion-list-scroller {\n    overflow-y: auto;\n  }\n\n  .suggestion-description {\n    padding: 5px 0;\n    padding-left: @item-side-padding;\n    padding-right: @item-side-padding;\n    min-height: @row-line-height;\n    line-height: 1.3;\n    background: darken(@overlay-background-color, 4%);\n    border-radius: 0 0 @component-border-radius @component-border-radius;\n\n    // let the other sibling decide how large the container should be\n    width: min-content;\n    min-width: 100%;\n  }\n\n  .suggestion-description-content {\n    font-size: @font-size + 1px;\n    font-family: @font-family;\n    max-height: 33vh;\n    display: block;\n    overflow-y: auto;\n    white-space: pre-wrap;\n  }\n\n  .suggestion-description-more-link {\n    font-size: @font-size + 1px;\n    font-family: @font-family;\n    color: @text-color-info;\n  }\n\n  input {\n    position: absolute;\n    opacity: 0.00;\n  }\n\n  ol.list-group {\n    margin-top: 0;\n    display: table;\n    width: 100%;\n    margin-right: 10px; // Needed to prevent horizontal scrolling when right label is too long\n\n    li {\n      display: table-row;\n      color: @text-color;\n      line-height: @row-line-height;\n\n      > span {\n        display: table-cell;\n        vertical-align: middle;\n      }\n\n      &:after {\n        clear: both;\n        display: block;\n        content: \' \';\n      }\n\n      &.selected {\n        .word {\n          color: fadeout(@text-color-selected, 20%);\n        }\n        .character-match {\n          color: @text-color-selected;\n        }\n        .left-label, .right-label, .snippet-completion {\n          color: fadeout(@text-color-selected, 50%);\n        }\n      }\n    }\n  }\n}\n\nautocomplete-suggestion-list {\n  .icon-container {\n    width: @row-line-height;\n    padding-left: 0;\n    padding-right: @item-padding;\n    &:empty {\n      width: @item-side-padding;\n      padding: 0;\n    }\n  }\n\n  .icon {\n    display: block;\n    width: @row-line-height;\n    line-height: @row-line-height;\n    text-align: center;\n    font-style: normal;\n    font-weight: bold;\n\n    color: @text-color-subtle;\n    background: fadeout(@text-color, 90%);\n\n    &:empty { display: none; }\n    > *::before {\n      font-size: @type-icon-font-size;\n      width: @type-icon-font-size;\n      height: @type-icon-font-size;\n    }\n\n    .icon-letter {\n      // I\'m failing to vert center these letters. So shift them up...\n      position: relative;\n      top: -.1em;\n      font-size: @type-letter-icon-font-size;\n      line-height: @type-letter-icon-font-size;\n    }\n  }\n\n  .left-label {\n    text-align: right;\n    padding-right: @item-padding;\n    vertical-align: middle;\n\n    font-size: @font-size-small;\n    color: @text-color-subtle;\n\n    &:empty {\n      padding-right: 0;\n    }\n  }\n\n  .right-label {\n    padding-right: @item-padding;\n    font-size: @font-size-small;\n    color: @text-color-subtle;\n\n    &:empty {\n      padding-right: 0;\n    }\n  }\n\n  .word-container {\n    padding-right: @item-padding;\n  }\n\n  .word {\n    float: left;\n  }\n\n  .character-match {\n    font-weight: bold;\n    color: @text-color-highlight;\n  }\n\n  .snippet-completion {\n    color: @text-color-subtle;\n  }\n\n  // Here we set the max width of the popup\n  .left-label {\n    max-width: 20vw;\n  }\n  .word {\n    max-width: 35vw;\n  }\n  .right-label {\n    max-width: 25vw;\n  }\n\n  .word, .left-label, .right-label {\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis;\n  }\n\n  .make-type-icon(attribute, @syntax-color-attribute);\n  .make-type-icon(builtin, @syntax-color-keyword);\n  .make-type-icon(class, @syntax-color-class);\n  .make-type-icon(constant, @syntax-color-constant);\n  .make-type-icon(function, @syntax-color-function);\n  .make-type-icon(import, @syntax-color-import);\n  .make-type-icon(keyword, @syntax-color-keyword);\n  .make-type-icon(method, @syntax-color-method);\n  .make-type-icon(module, @syntax-color-import);\n  .make-type-icon(mixin, @syntax-color-class);\n  .make-type-icon(package, @syntax-color-import);\n  .make-type-icon(property, @syntax-color-property);\n  .make-type-icon(require, @syntax-color-import);\n  .make-type-icon(snippet, @syntax-color-snippet);\n  .make-type-icon(tag, @syntax-color-tag);\n  .make-type-icon(type, @syntax-color-class);\n  .make-type-icon(value, @syntax-color-value);\n  .make-type-icon(variable, @syntax-color-variable);\n  .make-type-icon(selector, @syntax-color-attribute);\n  .make-type-icon(pseudo-selector, @syntax-color-attribute);\n}\n\n.make-type-icon(@type, @color) {\n  .icon.@{type} {\n    color: @color;\n    background: fadeout(@color, 80%)\n  }\n}\n.make-type-icon(@type, @color)\n  when (hsvvalue(@color) - hsvvalue(@overlay-background-color) > -20)\n  and (hsvvalue(@color) - hsvvalue(@overlay-background-color) < 20) {\n  .icon.@{type} {\n    @corrected-color: contrast(@overlay-background-color, darken(@color, 30%), lighten(@color, 30%));\n    color: @corrected-color;\n    background: fadeout(@corrected-color, 80%);\n  }\n}\n',digest:"a67bb2a764bd14a0d0d022deaaf06a02f0205088"},"node_modules/background-tips/styles/background-tips.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n// The ui-variables file is provided by base themes provided by Atom.\n//\n// See https://github.com/atom/atom-dark-ui/blob/master/styles/ui-variables.less\n// for a full listing of what\'s available.\n@import "ui-variables";\n\nbackground-tips {\n  display: block;\n  pointer-events: none;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow: hidden;\n\n  .background-message {\n    user-select: none;\n    cursor: default;\n\n    .message {\n      padding: 0 @component-padding*3;\n      opacity: 0;\n      transition: opacity .3s ease-in-out;\n      &.fade-in {\n        opacity: 1;\n      }\n\n      .keystroke {\n        border: 2px solid;\n        padding: 0 @component-padding/2;\n        border-radius: @component-border-radius * 3;\n        font-family: "Helvetica Neue", Arial, sans-serif;\n      }\n    }\n  }\n}\n',digest:"f92e8b9e946e6782d754a7433029bdac8fbfaef1"},"node_modules/bookmarks/styles/bookmarks.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "octicon-utf-codes.less";\n\natom-text-editor {\n  .gutter .line-number.bookmarked .icon-right {\n    visibility: visible;\n\n    &:before {\n      content: @bookmark;\n      color: #09C;\n    }\n  }\n}\n\n.bookmarks-view {\n  .bookmark {\n    .line-text {\n      font-family: monospace;\n    }\n  }\n}\n',digest:"16ccb42180dde26a0525047c649420fc349cc803"},"node_modules/bracket-matcher/styles/bracket-matcher.atom-text-editor.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "syntax-variables";\n\n.bracket-matcher .region {\n  border-bottom: 1px dotted lime;\n  position: absolute;\n}\n\n.line-number.bracket-matcher.bracket-matcher {\n  color: @syntax-gutter-text-color-selected;\n  background-color: @syntax-gutter-background-color-selected;\n}\n',digest:"522a08b7a093a3dfd6382de4357e7578a4899fbd"},"node_modules/command-palette/styles/command-palette.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n// Highlight matched text\n.command-palette .list-group .character-match {\n  color: @text-color-highlight;\n  font-weight: bold;\n}\n',digest:"4b22bbd3a8da4831603f9cd9a6719906e27b0f60"},"node_modules/deprecation-cop/styles/deprecation-cop.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n// The ui-variables file is provided by base themes provided by Atom.\n//\n// See https://github.com/atom/atom-dark-ui/blob/master/stylesheets/ui-variables.less\n// for a full listing of what\'s available.\n@import "ui-variables";\n\n.deprecation-cop-status {\n  .icon.icon-alert:before {\n    // It\'s a really big icon...\n    width: 17px;\n  }\n}\n.deprecation-cop {\n  overflow: auto;\n  -webkit-flex: 1;\n  background-color: @app-background-color;\n\n  .deprecation-overview {    \n    &:after {\n      content: \'\';\n      clear: both;\n      display: block;\n    }\n  }\n\n  .deprecation-info {\n    padding: 0 @component-padding;\n  }\n\n  .deprecation-info:hover {\n    background-color: @background-color-selected;\n  }\n\n  .deprecation-detail.list-item {\n    white-space: normal;\n    clear: both;\n\n    .deprecation-message {\n      padding: 5px 0 5px 28px;\n      line-height: 1.4;\n      font-size: @font-size;\n\n      p:last-child {\n        margin-bottom: 0;\n      }\n    }\n\n    .icon-alert {\n      margin-top: 5px;\n      float: left;\n    }\n  }\n\n  .collapsed > ul {\n    display: none;\n  }\n\n  .list {\n    list-style-type: none;\n    padding: 0;\n  }\n\n  .stack-trace {\n    background-color: @tool-panel-background-color;\n    padding: @component-padding;\n    margin-bottom: @component-padding;\n  }\n\n  a {\n    color: @text-color-highlight;\n  }\n}\n',digest:"b99937e3313aad5de5c5166d5246aab4a721fdea"},"node_modules/dev-live-reload/spec/fixtures/package-with-styles-folder/styles/sub/2.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@size: 2px;\n\n#jasmine-content {\n  font-size: @size;\n}\n',digest:"272fda56636a0fbd244e1c5ee06810f702a6278a"},"node_modules/dev-live-reload/spec/fixtures/package-with-styles-manifest/styles/2.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@size: 2px;\n\n#jasmine-content {\n  font-size: @size;\n}\n',digest:"272fda56636a0fbd244e1c5ee06810f702a6278a"},"node_modules/dev-live-reload/spec/fixtures/packages/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "styles/first";\n@import "styles/second";\n@import "styles/last";\n',digest:"45fc52f17cb81e82b9ed08ad48855f9fbae40636"},"node_modules/dev-live-reload/spec/fixtures/packages/styles/2.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@size: 2px;\n\n#jasmine-content {\n  font-size: @size;\n}\n',digest:"272fda56636a0fbd244e1c5ee06810f702a6278a"},"node_modules/dev-live-reload/spec/fixtures/packages/styles/first.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n.editor {\n  padding-top: 101px;\n  padding-right: 101px;\n  padding-bottom: 101px;\n\n  color: red;\n}',digest:"7c9c254d90501860124a53d65da20b8a72baee35"},"node_modules/dev-live-reload/spec/fixtures/packages/styles/last.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n.editor {\n/*  padding-top: 103px;\n  padding-right: 103px;*/\n  padding-bottom: 103px;\n}',digest:"5a1afc3f8adb37f8242eeafb5c435a41bf4b241d"},"node_modules/dev-live-reload/spec/fixtures/packages/styles/second.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n@number: 102px;\n\n.editor {\n/*  padding-top: 102px;*/\n  padding-right: @number;\n  padding-bottom: @number;\n}\n',digest:"5f24f3f8494272b1ef372b0d42604593cc006fa3"},"node_modules/dev-live-reload/spec/fixtures/packages/styles/ui-variables.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n// Variables different from the original are marked \'Changed\'\n\n@text-color: #333;\n@text-color-subtle: #777;\n@text-color-highlight: #111;\n@text-color-selected: @text-color-highlight;\n\n@text-color-info: #5293d8;\n@text-color-success: #1fe977;\n@text-color-warning: #f78a46;\n@text-color-error: #c00;\n\n@background-color-info: #0098ff;\n@background-color-success: #17ca65;\n@background-color-warning: #ff4800;\n@background-color-error: #c00;\n@background-color-highlight: rgba(255, 255, 255, 0.10);\n@background-color-selected: @background-color-highlight;\n\n@app-background-color: #00f; // Changed\n\n@base-background-color: #fff;\n@base-border-color: #eee;\n\n@pane-item-background-color: @base-background-color;\n@pane-item-border-color: @base-border-color;\n\n@input-background-color: #f00; // Changed\n@input-border-color: @base-border-color;\n\n@tool-panel-background-color: #f4f4f4;\n@tool-panel-border-color: @base-border-color;\n\n@inset-panel-background-color: #eee;\n@inset-panel-border-color: @base-border-color;\n\n@panel-heading-background-color: #ddd;\n@panel-heading-border-color: transparent;\n\n@overlay-background-color: #f4f4f4;\n@overlay-border-color: @base-border-color;\n\n@button-background-color: #ccc;\n@button-background-color-hover: lighten(@button-background-color, 5%);\n@button-background-color-selected: @button-background-color-hover;\n@button-border-color: #aaa;\n\n@tab-bar-background-color: #fff;\n@tab-bar-border-color: darken(@tab-background-color-active, 10%);\n@tab-background-color: #f4f4f4;\n@tab-background-color-active: #fff;\n@tab-border-color: @base-border-color;\n\n@tree-view-background-color: @tool-panel-background-color;\n@tree-view-border-color: @tool-panel-border-color;\n\n@ui-site-color-1: @background-color-success; // green\n@ui-site-color-2: @background-color-info; // blue\n@ui-site-color-3: @background-color-warning; // orange\n@ui-site-color-4: #db2ff4; // purple\n@ui-site-color-5: #f5e11d; // yellow\n\n@font-size: 12px;\n\n@disclosure-arrow-size: 12px;\n\n@component-padding: 150px;\n@component-icon-padding: 5px;\n@component-icon-size: 16px;\n@component-line-height: 25px;\n@component-border-radius: 2px;\n\n@tab-height: 30px;\n\n@font-family: Arial;\n',digest:"f48698994f6a348a121783a172e458659b45164a"},"node_modules/dev-live-reload/spec/fixtures/static/atom.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n',digest:"1623f317a1e51de8d2b3580ed09884dae3b41691"},"node_modules/dev-live-reload/spec/fixtures/theme-with-index-less/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@padding: 4321px;\n\natom-text-editor {\n  padding-top: @padding;\n}\n',digest:"da8b06366e3e9934fa7cccb4fd64a299c26579c8"},"node_modules/dev-live-reload/spec/fixtures/theme-with-multiple-imported-files/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "styles/first";\n@import "styles/second";\n@import "styles/last";\n',digest:"45fc52f17cb81e82b9ed08ad48855f9fbae40636"},"node_modules/dev-live-reload/spec/fixtures/theme-with-multiple-imported-files/styles/first.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n.editor {\n  padding-top: 101px;\n  padding-right: 101px;\n  padding-bottom: 101px;\n\n  color: red;\n}',digest:"7c9c254d90501860124a53d65da20b8a72baee35"},"node_modules/dev-live-reload/spec/fixtures/theme-with-multiple-imported-files/styles/last.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n.editor {\n/*  padding-top: 103px;\n  padding-right: 103px;*/\n  padding-bottom: 103px;\n}',digest:"5a1afc3f8adb37f8242eeafb5c435a41bf4b241d"},"node_modules/dev-live-reload/spec/fixtures/theme-with-multiple-imported-files/styles/second.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n@number: 102px;\n\n.editor {\n/*  padding-top: 102px;*/\n  padding-right: @number;\n  padding-bottom: @number;\n}\n',digest:"5f24f3f8494272b1ef372b0d42604593cc006fa3"},"node_modules/dev-live-reload/spec/fixtures/theme-with-multiple-imported-files/styles/ui-variables.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n// Variables different from the original are marked \'Changed\'\n\n@text-color: #333;\n@text-color-subtle: #777;\n@text-color-highlight: #111;\n@text-color-selected: @text-color-highlight;\n\n@text-color-info: #5293d8;\n@text-color-success: #1fe977;\n@text-color-warning: #f78a46;\n@text-color-error: #c00;\n\n@background-color-info: #0098ff;\n@background-color-success: #17ca65;\n@background-color-warning: #ff4800;\n@background-color-error: #c00;\n@background-color-highlight: rgba(255, 255, 255, 0.10);\n@background-color-selected: @background-color-highlight;\n\n@app-background-color: #00f; // Changed\n\n@base-background-color: #fff;\n@base-border-color: #eee;\n\n@pane-item-background-color: @base-background-color;\n@pane-item-border-color: @base-border-color;\n\n@input-background-color: #f00; // Changed\n@input-border-color: @base-border-color;\n\n@tool-panel-background-color: #f4f4f4;\n@tool-panel-border-color: @base-border-color;\n\n@inset-panel-background-color: #eee;\n@inset-panel-border-color: @base-border-color;\n\n@panel-heading-background-color: #ddd;\n@panel-heading-border-color: transparent;\n\n@overlay-background-color: #f4f4f4;\n@overlay-border-color: @base-border-color;\n\n@button-background-color: #ccc;\n@button-background-color-hover: lighten(@button-background-color, 5%);\n@button-background-color-selected: @button-background-color-hover;\n@button-border-color: #aaa;\n\n@tab-bar-background-color: #fff;\n@tab-bar-border-color: darken(@tab-background-color-active, 10%);\n@tab-background-color: #f4f4f4;\n@tab-background-color-active: #fff;\n@tab-border-color: @base-border-color;\n\n@tree-view-background-color: @tool-panel-background-color;\n@tree-view-border-color: @tool-panel-border-color;\n\n@ui-site-color-1: @background-color-success; // green\n@ui-site-color-2: @background-color-info; // blue\n@ui-site-color-3: @background-color-warning; // orange\n@ui-site-color-4: #db2ff4; // purple\n@ui-site-color-5: #f5e11d; // yellow\n\n@font-size: 12px;\n\n@disclosure-arrow-size: 12px;\n\n@component-padding: 150px;\n@component-icon-padding: 5px;\n@component-icon-size: 16px;\n@component-line-height: 25px;\n@component-border-radius: 2px;\n\n@tab-height: 30px;\n\n@font-family: Arial;\n',digest:"f48698994f6a348a121783a172e458659b45164a"},"node_modules/dev-live-reload/spec/fixtures/theme-with-package-file/styles/second.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@number: 102px;\n\natom-text-editor {\n/*  padding-top: 102px;*/\n  padding-right: @number;\n  padding-bottom: @number;\n}',digest:"18eb8caec5ea29952ec3222b6e1b7dd7a3d958bb"},"node_modules/dev-live-reload/spec/fixtures/theme-with-syntax-variables/styles/editor.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n',digest:"1623f317a1e51de8d2b3580ed09884dae3b41691"},"node_modules/dev-live-reload/spec/fixtures/theme-with-ui-variables/styles/editor.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\natom-text-editor {\n  padding-top: @component-padding;\n  padding-right: @component-padding;\n  padding-bottom: @component-padding;\n\n  color: @input-background-color;\n}\n',digest:"14feae1023deaf948dcfc9f975fb888c8d69c150"},"node_modules/dev-live-reload/spec/fixtures/theme-with-ui-variables/styles/ui-variables.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n// Variables different from the original are marked \'Changed\'\n\n@text-color: #333;\n@text-color-subtle: #777;\n@text-color-highlight: #111;\n@text-color-selected: @text-color-highlight;\n\n@text-color-info: #5293d8;\n@text-color-success: #1fe977;\n@text-color-warning: #f78a46;\n@text-color-error: #c00;\n\n@background-color-info: #0098ff;\n@background-color-success: #17ca65;\n@background-color-warning: #ff4800;\n@background-color-error: #c00;\n@background-color-highlight: rgba(255, 255, 255, 0.10);\n@background-color-selected: @background-color-highlight;\n\n@app-background-color: #00f; // Changed\n\n@base-background-color: #fff;\n@base-border-color: #eee;\n\n@pane-item-background-color: @base-background-color;\n@pane-item-border-color: @base-border-color;\n\n@input-background-color: #f00; // Changed\n@input-border-color: @base-border-color;\n\n@tool-panel-background-color: #f4f4f4;\n@tool-panel-border-color: @base-border-color;\n\n@inset-panel-background-color: #eee;\n@inset-panel-border-color: @base-border-color;\n\n@panel-heading-background-color: #ddd;\n@panel-heading-border-color: transparent;\n\n@overlay-background-color: #f4f4f4;\n@overlay-border-color: @base-border-color;\n\n@button-background-color: #ccc;\n@button-background-color-hover: lighten(@button-background-color, 5%);\n@button-background-color-selected: @button-background-color-hover;\n@button-border-color: #aaa;\n\n@tab-bar-background-color: #fff;\n@tab-bar-border-color: darken(@tab-background-color-active, 10%);\n@tab-background-color: #f4f4f4;\n@tab-background-color-active: #fff;\n@tab-border-color: @base-border-color;\n\n@tree-view-background-color: @tool-panel-background-color;\n@tree-view-border-color: @tool-panel-border-color;\n\n@ui-site-color-1: @background-color-success; // green\n@ui-site-color-2: @background-color-info; // blue\n@ui-site-color-3: @background-color-warning; // orange\n@ui-site-color-4: #db2ff4; // purple\n@ui-site-color-5: #f5e11d; // yellow\n\n@font-size: 12px;\n\n@disclosure-arrow-size: 12px;\n\n@component-padding: 150px;\n@component-icon-padding: 5px;\n@component-icon-size: 16px;\n@component-line-height: 25px;\n@component-border-radius: 2px;\n\n@tab-height: 30px;\n\n@font-family: Arial;\n',digest:"f48698994f6a348a121783a172e458659b45164a"},"node_modules/encoding-selector/styles/encoding-selector.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n.encoding-status a,\n.encoding-status a:hover {\n  color: @text-color;\n}\n',digest:"32b0dfd811078fe30702e597d22d2709785f2742"},"node_modules/find-and-replace/styles/find-and-replace.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n@import "syntax-variables";\n\n// result markers\natom-text-editor {\n  .find-result .region {\n    background-color: transparent;\n    border-radius: @component-border-radius;\n    border: 1px solid @syntax-result-marker-color;\n    box-sizing: border-box;\n    z-index: 0;\n  }\n\n  .current-result .region {\n    border-radius: @component-border-radius;\n    border: 1px solid @syntax-result-marker-color-selected;\n    box-sizing: border-box;\n    z-index: 0;\n  }\n\n  .find-result,\n  .current-result {\n    display: none;\n  }\n}\n\natom-workspace.find-visible {\n  atom-text-editor {\n    .find-result,\n    .current-result {\n      display: block;\n    }\n  }\n}\n\n// Both project and buffer FNR styles\n.find-and-replace,\n.preview-pane,\n.project-find {\n  @min-width: 200px; // min width before it starts scrolling\n\n  -webkit-user-select: none;\n  padding: @component-padding/2;\n  overflow-x: auto;\n\n  .header {\n    padding: @component-padding/4 @component-padding/2;\n    min-width: @min-width;\n    line-height: 1.75;\n  }\n  .header-item {\n    margin: @component-padding/4 0;\n  }\n\n  .input-block {\n    display: flex;\n    flex-wrap: wrap;\n    width: 100%;\n    min-width: @min-width;\n  }\n  .input-block-item {\n    display: flex;\n    flex: 1;\n    padding: @component-padding / 2;\n  }\n\n  .btn-group {\n    display: flex;\n    flex: 1;\n    .btn {\n      flex: 1;\n    }\n    & + .btn-group {\n      margin-left: @component-padding;\n    }\n  }\n\n  .btn > .icon {\n    width: 20px;\n    height: 16px;\n    vertical-align: middle;\n    fill: currentColor;\n    stroke: currentColor;\n    pointer-events: none;\n  }\n\n  .close-button {\n    margin-left: @component-padding;\n    cursor: pointer;\n    color: @text-color-subtle;\n    &:hover {\n      color: @text-color-highlight;\n    }\n    .icon::before {\n      margin-right: 0;\n      text-align: center;\n      vertical-align: middle;\n    }\n  }\n\n  .description {\n    display: inline-block;\n    .subtle-info-message {\n      padding-left: 5px;\n      color: @text-color-subtle;\n      .highlight {\n        color: @text-color;\n        font-weight: normal;\n      }\n    }\n  }\n\n  .options-label {\n    color: @text-color-subtle;\n    position: relative;\n    .options {\n      margin-right: .5em;\n      color: @text-color;\n    }\n  }\n\n  .btn-group-options {\n    display: inline-flex;\n    margin-top: -.1em;\n\n    .btn {\n      width: 36px;\n      padding: 0;\n      line-height: 1.75;\n    }\n  }\n\n  .editor-container {\n    position: relative;\n    atom-text-editor {\n      width: 100%;\n    }\n  }\n\n}\n\n// Buffer find and replace\n.find-and-replace {\n  @input-width: 260px;\n  @block-width: 260px;\n\n  .input-block-item {\n    flex: 1 1 @block-width;\n  }\n  .input-block-item--flex {\n    flex: 100 1 @input-width;\n  }\n\n  .btn-group-find,\n  .btn-group-replace {\n    flex: 1;\n  }\n\n  .btn-group-find-all,\n  .btn-group-replace-all {\n    flex: 2;\n  }\n\n  .find-container atom-text-editor {\n    padding-right: 64px; // leave some room for the results count\n  }\n\n  // results count\n  .find-meta-container {\n    position: absolute;\n    top: 1px;\n    right: 0;\n    margin: @component-padding/2 @component-padding/2 0 0;\n    z-index: 2;\n    font-size: .9em;\n    line-height: @component-line-height;\n    pointer-events: none;\n    .result-counter {\n      margin-right: @component-padding;\n    }\n  }\n}\n\n.find-wrap-icon {\n  @wrap-size: @font-size * 10;\n\n  opacity: 0;\n  transition: opacity 0.5s;\n  &.visible { opacity: 1; }\n\n  position: absolute;\n\n  // These are getting placed in the DOM as a pane item, so override the pane\n  // item positioning styles. :/\n  top: 50% !important;\n  left: 50% !important;\n  right: initial !important;\n  bottom: initial !important;\n\n  margin-top: @wrap-size * -0.5;\n  margin-left: @wrap-size * -0.5;\n\n  background: fadeout(darken(@syntax-background-color, 4%), 55%);\n  border-radius: @component-border-radius * 2;\n  text-align: center;\n  pointer-events: none;\n  &:before {\n    // Octicons look best in sizes that are multiples of 16px\n    font-size: @wrap-size - mod(@wrap-size, 16px) - 32px;\n    line-height: @wrap-size;\n    height: @wrap-size;\n    width: @wrap-size;\n    color: @syntax-text-color;\n    opacity: .5;\n  }\n}\n\n// Project find and replace\n.project-find {\n  @project-input-width: 260px;\n  @project-block-width: 160px;\n\n  .input-block-item {\n    flex: 1 1 @project-block-width;\n  }\n  .input-block-item--flex {\n    flex: 100 1 @project-input-width;\n  }\n\n  .loading,\n  .preview-block,\n  .error-messages,\n  .filter-container {\n    display: none;\n  }\n}\n\n.preview-pane {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  padding: 0;\n\n  .preview-header {\n    display: flex;\n    flex-wrap: wrap;\n    padding: @component-padding/2;\n    align-items: center;\n    justify-content: space-between;\n    overflow: hidden;\n    font-weight: normal;\n    border-bottom: 1px solid @panel-heading-border-color;\n    background-color: @panel-heading-background-color;\n  }\n\n  .preview-count {\n    margin: @component-padding/2;\n  }\n\n  .preview-controls {\n    display: flex;\n    flex-wrap: wrap;\n    .btn-group {\n      margin: @component-padding/2;\n    }\n  }\n\n  .loading-spinner-tiny,\n  .loading-spinner-tiny + .inline-block {\n    vertical-align: middle;\n  }\n\n  .no-results-overlay {\n    visibility: hidden;\n  }\n\n  &.no-results .no-results-overlay {\n    visibility: visible;\n  }\n\n  .results-view {\n    overflow: auto;\n    position: relative;\n    flex: 1;\n\n    &-container {\n      // adds some padding\n      // so the last item can be clicked\n      // when there is a horizontal scrollbar -> #943\n      padding-bottom: @component-padding;\n    }\n\n    .list-item {\n      padding: 0 0 0 @component-padding;\n    }\n    .context-row, .match-row {\n      padding: 0 0 0 @component-padding;\n      margin-left: 8px;\n\n      box-shadow: inset 0 1px 0 mix(@base-border-color, @base-background-color);\n\n      // box-shadow over a border is used to not affect height calculation\n      &.separator {\n        box-shadow: inset 0 1px 0 @base-border-color;\n      }\n    }\n\n    .line-number {\n      margin-right: 1ex;\n      text-align: right;\n      display: inline-block;\n    }\n    .match-row.selected .line-number {\n      color: @text-color-selected;\n    }\n\n    .path-match-number {\n      padding-left: @component-padding;\n      color: @text-color-subtle;\n    }\n\n    .preview {\n      word-break: break-all;\n      white-space: pre;\n      color: @text-color-subtle;\n    }\n\n    .match-row .preview {\n      color: @text-color-highlight;\n    }\n    .match-row.selected .preview {\n      color: @text-color-selected;\n    }\n\n\n    .selected {\n      .highlight-info {\n        box-shadow: inset 0 0 1px lighten(@background-color-info, 50%);\n      }\n\n      .highlight-error {\n        box-shadow: inset 0 0 1px lighten(@background-color-error, 25%);\n      }\n\n      .highlight-success {\n        box-shadow: inset 0 0 1px lighten(@background-color-success, 25%);\n      }\n    }\n  }\n}\n\n.find-container atom-text-editor, .replace-container atom-text-editor {\n  // Styles for regular expression highlighting\n  .syntax--regexp {\n    .syntax--escape {\n      color: @text-color-info;\n    }\n    .syntax--range, .syntax--character-class, .syntax--wildcard {\n      color: @text-color-success;\n    }\n    .syntax--wildcard {\n      font-weight: bold;\n    }\n    .syntax--set {\n      color: inherit;\n    }\n    .syntax--keyword, .syntax--punctuation {\n      color: @text-color-error;\n      font-weight: normal;\n    }\n\n    .syntax--replacement.syntax--variable {\n      color: @text-color-warning;\n    }\n  }\n}\n',digest:"217091db388e17482d7d7b10d67b6a012261993f"},"node_modules/fuzzy-finder/styles/fuzzy-finder.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n// Highlight matched text\n.fuzzy-finder .list-group .character-match {\n  color: @text-color-highlight;\n  font-weight: bold;\n}\n\n.FuzzyFinderResult {\n  position: relative;\n\n  @size: 28px;\n\n  &.has-avatar {\n    // add some extra space for the avatar\n    padding-right: @size + (@component-padding * 2) !important;\n  }\n\n  &-avatar {\n    position: absolute !important;\n    border-radius: @size;\n    width: @size;\n    top: 50%;\n    margin-top: -(@size / 2);\n    right: @component-padding;\n  }\n}\n',digest:"0889cafc60d9241894b64fa1585196a02db51f59"},"node_modules/github/styles/accordion.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n.github-Accordion {\n  cursor: default;\n  user-select: none;\n\n  &-header {\n    font-weight: 600;\n    color: @text-color-subtle;\n    padding: @component-padding/2;\n    border-bottom: 1px solid @base-border-color;\n\n    &::-webkit-details-marker {\n      color: @text-color-subtle;\n    }\n  }\n\n  &-content {\n    border-bottom: 1px solid @base-border-color;\n    background-color: @base-background-color;\n\n    // Add an "Empty" label for empty items\n    &:empty::before {\n      content: "Empty";\n      display: block;\n      font-style: italic;\n      text-align: center;\n      color: @text-color-subtle;\n    }\n  }\n\n  &-list {\n    margin: 0;\n    padding: 0;\n    list-style: none;\n  }\n\n  &[open] &-header {\n    color: @text-color-highlight;\n  }\n\n  &-listItem {\n    display: flex;\n    align-items: center;\n    padding: @component-padding / 4;\n    border-bottom: 1px solid @base-border-color;\n\n    &:last-child {\n      border: none;\n    }\n\n    &:active {\n      background-color: @background-color-highlight;\n    }\n  }\n\n}\n',digest:"f87748966656f0aab426d80bd6f112c7641a3052"},"node_modules/github/styles/atom-text-editor.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n// Our AtomTextEditor React component adds a parent <div> to the <atom-text-editor> element.\n.github-AtomTextEditor-container {\n  width: 100%;\n  height: 100%;\n}\n\n// Conceal the automatically added blank line element within TextEditors that we want to actually be empty\n.github-AtomTextEditor-empty .cursor-line {\n  display: none;\n}\n',digest:"224523dad07713285e6e0477f688bbf91844f870"},"node_modules/github/styles/branch-menu-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n.github-BranchMenuView {\n\n  .hidden {\n    display: none\n  }\n\n  &-selector {\n    display: flex;\n    align-items: center;\n  }\n\n  &-item {\n    margin: @component-padding / 2;\n  }\n\n  .icon-sync::before {\n    @keyframes github-BranchViewSync-animation {\n      100% { transform: rotate(360deg); }\n    }\n    animation: github-BranchViewSync-animation 2s linear 30; // limit to 1min in case something gets stuck\n  }\n\n  .icon-git-branch {\n    flex-basis: 16px;\n    flex-grow: 0;\n    flex-shrink: 0;\n    color: @text-color-subtle;\n  }\n\n  .icon-git-branch::before {\n    margin-right: 0;\n    text-align: center;\n  }\n\n  &-select {\n    flex-grow: 1;\n    flex-shrink: 1;\n    width: 100%;\n  }\n\n  &-button {\n    flex-grow: 0;\n    flex-shrink: 0;\n  }\n\n  &-editor {\n    flex: 1;\n\n    atom-text-editor,\n    atom-text-editor .cursor-line {\n      background-color: inherit;\n    }\n    atom-text-editor[mini] {\n      font-size: inherit;\n      text-align: left;\n    }\n    atom-text-editor[readonly] {\n      color: @text-color-subtle;\n      pointer-events: none;\n    }\n  }\n\n  &-message {\n    max-height: 20em;\n    margin: @component-padding / 2;\n    padding: @component-padding / 2;\n    line-height: 1.4;\n    white-space: normal;\n    text-align: left;\n    overflow-y: auto;\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n    background-color: @inset-panel-background-color;\n\n    &:empty {\n      display: none;\n    }\n  }\n}\n',digest:"b8209a3a4978893ded14af34e12802d8f14c250b"},"node_modules/github/styles/cache-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n.github-CacheView {\n  width: 100%;\n  height: 100%;\n  overflow-y: auto;\n\n  header {\n    text-align: center;\n    border-bottom: 1px solid @base-border-color;\n    padding: @component-padding;\n  }\n\n  &-Controls {\n    padding: 0 @component-padding;\n    text-align: right;\n  }\n\n  &-Clear {\n    margin-left: 1em;\n  }\n\n  &-Order select {\n    margin-left: 0.5em;\n  }\n\n  table {\n    margin: 10px 20px;\n    width: 90%;\n  }\n\n  thead {\n    color: @text-color-highlight;\n    background-color: @background-color-highlight;\n    font-weight: bold;\n  }\n\n  td {\n    padding: @component-padding / 2;\n    vertical-align: top;\n  }\n\n  &-Key {\n    button {\n      width: 100%;\n      font-family: monospace;\n      text-align: left;\n    }\n  }\n\n  &-Age {\n    min-width: 100px;\n  }\n\n  &-Hits {\n    min-width: 50px;\n  }\n\n  &-Content {\n    white-space: pre-wrap;\n    max-height: 100px;\n    overflow-y: scroll;\n  }\n}\n',digest:"35e8961d68a6a10a451743fa7052ff050204d896"},"node_modules/github/styles/changed-files-count-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n// Used in the status-bar\n\n.github-ChangedFilesCount {\n  background-color: inherit;\n  border: none;\n\n  &.icon-git-commit::before {\n    margin-right: .2em;\n  }\n\n}\n',digest:"81bdea9da95e161211e3b986e7f74993011184ef"},"node_modules/github/styles/co-author-form.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n.github-CoAuthorForm {\n  display: flex;\n  flex-direction: column;\n  margin-top: @component-padding;\n  padding: @component-padding/2;\n  border-radius: @component-border-radius @component-border-radius 0 0;\n  border: 1px solid @base-border-color;\n  border-bottom: 0;\n  background-color: @syntax-background-color;\n\n  &-row {\n    display: flex;\n    align-items: center;\n    margin: @component-padding/2;\n\n    &.has-buttons {\n      margin: 0;\n      flex-wrap: wrap;\n      .btn {\n        flex: 1;\n        margin: @component-padding/2;\n      }\n      .btn-primary {\n        flex: 4;\n      }\n    }\n  }\n\n  &-label {\n    min-width: 6ch; // fit 6 characters\n  }\n\n\n  // make it look connected with the editor below\n  & + .github-CommitView-coAuthorEditor {\n    margin-top: 0;\n    border-top-left-radius: 0;\n    border-top-right-radius: 0;\n  }\n}\n',digest:"40cefd199170c4928c60cd1e593dce5d3bd430fa"},"node_modules/github/styles/commit-detail.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n@default-padding: @component-padding;\n@avatar-dimensions: 16px;\n\n.github-CommitDetailView {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n\n  &-header {\n    flex: 0;\n    border-bottom: 1px solid @base-border-color;\n    background-color: @syntax-background-color;\n  }\n\n  &-commit {\n    padding: @default-padding*2;\n    padding-bottom: 0;\n  }\n\n  &-title {\n    margin: 0 0 .25em 0;\n    font-size: 1.4em;\n    line-height: 1.3;\n    color: @text-color-highlight;\n  }\n\n  &-avatar {\n    border-radius: @component-border-radius;\n    height: @avatar-dimensions;\n    margin-right: .4em;\n    width: @avatar-dimensions;\n  }\n\n  &-meta {\n    display: flex;\n    align-items: center;\n    margin:  @default-padding/2 0 @default-padding*2 0;\n  }\n\n  &-metaText {\n    flex: 1;\n    margin-left: @avatar-dimensions * 1.4; // leave some space for the avatars\n    line-height: @avatar-dimensions;\n    color: @text-color-subtle;\n  }\n\n  &-moreButton {\n    position: absolute;\n    left: 50%;\n    transform: translate(-50%, -50%);\n    padding: 0em .4em;\n    color: @text-color-subtle;\n    font-style: italic;\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n    background-color: @button-background-color;\n\n    &:hover {\n      background-color: @button-background-color-hover\n    }\n  }\n\n  &-moreText {\n    padding: @default-padding*2 0;\n    font-size: inherit;\n    font-family: var(--editor-font-family);\n    word-wrap: initial;\n    word-break: break-word;\n    white-space: pre-wrap;\n    border-top: 1px solid @base-border-color;\n    background-color: transparent;\n    // in the case of loonnng commit message bodies, we want to cap the height so that\n    // the content beneath will remain visible / scrollable.\n    max-height: 55vh;\n    &:empty {\n      display: none;\n    }\n  }\n\n  &-sha {\n    flex: 0 0 7ch; // Limit to 7 characters\n    margin-left: @default-padding*2;\n    line-height: @avatar-dimensions;\n    color: @text-color-subtle;\n    font-family: var(--editor-font-family);\n    white-space: nowrap;\n    overflow: hidden;\n    a {\n      color: @text-color-info;\n    }\n  }\n}\n',digest:"0842762b98884c75fbc02e787eb79988cd84d6e9"},"node_modules/github/styles/commit-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n@import (less) "../node_modules/react-select/dist/react-select.css";\n\n.github-CommitView {\n  padding: @component-padding;\n  flex: 0 0 auto;\n\n  &-editor {\n    position: relative;\n    border: 1px solid @input-border-color;\n    border-radius: @component-border-radius;\n    padding: @component-padding / 2;\n    font-size: @font-size;\n    background-color: @syntax-background-color;\n\n    .github-CommitView-hardwrap {\n      position: absolute;\n      right: 20px;\n      bottom: 0;\n      padding: (@component-padding / 5) (@component-padding / 2);\n      line-height: 1;\n      border: none;\n      background-color: @syntax-background-color;\n      cursor: default;\n      opacity: .3;\n      &:hover {\n        opacity: 1;\n      }\n      &:active {\n        opacity: .5;\n      }\n    }\n  }\n\n  &-editor.hidden {\n    display: none;\n  }\n\n  &-editor atom-text-editor {\n    height: 100px;\n    .cursor-line.cursor-line.cursor-line {\n      background-color: transparent;\n    }\n  }\n\n  &-coAuthorToggle {\n    position: absolute;\n    left: 0;\n    bottom: 0;\n    padding: @component-padding / 2;\n    line-height: 1;\n    border: none;\n    background-color: @syntax-background-color;\n    cursor: default;\n    opacity: .3;\n    // in expanded editor view, make this button sit on top of\n    // the editor toggle button so the co author toggle is still clickable.\n    z-index: 1;\n    &:hover {\n      opacity: 1;\n      cursor: pointer;\n    }\n    &:active {\n      opacity: .5;\n    }\n    &.focused {\n      opacity: 1;\n    }\n\n    &Icon {\n      width: 12px;\n      height: 7px;\n      fill: @text-color;\n\n      &.focused {\n        fill: @button-background-color-selected;\n      }\n    }\n  }\n\n  &-buttonWrapper {\n    align-items: center;\n    display: flex;\n    margin: 0 -@component-padding @component-padding -@component-padding;\n    padding: @component-padding;\n    padding-top: 0;\n    border-bottom: 1px solid @base-border-color;\n  }\n\n  &-coAuthorEditor {\n    position: relative;\n    margin-top: @component-padding / 2;\n    padding: (@component-padding / 4) (@component-padding / 2);\n    border: 1px solid @base-border-color;\n    color: @syntax-text-color;\n    border-radius: @component-border-radius;\n    background-color: @syntax-background-color;\n    cursor: text;\n\n    &&, &.is-open, &.is-focused, &.is-searchable, &.is-searchable.is-open, &.is-searchable.is-focused:not(.is-open) {\n      & > .Select-control {\n        background-color: inherit;\n        border: none;\n        border-radius: 0;\n        color: inherit;\n        cursor: inherit;\n        height: @component-line-height;\n        box-shadow: none;\n      }\n    }\n\n    .Select-placeholder {\n      line-height: @component-line-height;\n      padding: 0;\n      color: @text-color-subtle;\n    }\n\n    .Select-input {\n      line-height: @component-line-height;\n      padding: 0;\n      margin: 0;\n      height: auto;\n\n      & > input {\n        padding: 0;\n        line-height: inherit;\n      }\n    }\n\n    // Token\n    .Select-value {\n      margin: 0;\n      margin-right: .5em;\n      vertical-align: middle;\n      line-height: 1.1;\n      color: mix(@text-color-highlight, @text-color-info, 70%);\n      border-color: fade(@background-color-info, 15%);\n      background-color: fade(@background-color-info, 10%);\n\n      &-icon {\n        border-color: inherit;\n      }\n    }\n\n    // Popup\n    .Select-menu-outer {\n      top: auto;\n      left: -1px;\n      right: -1px;\n      width: auto;\n      bottom: calc(100% ~\'+\' 2px);\n      border-radius: @component-border-radius;\n      border: 1px solid @overlay-border-color;\n      background-color: @overlay-background-color;\n      box-shadow: 0 2px 4px hsla(0,0%,0%,.15);\n      overflow: hidden;\n    }\n\n    .Select-option {\n      display: inline-block;\n      margin: 0;\n      border-radius: 0;\n      border: 0;\n      background-color: transparent;\n      width: 100%;\n\n      padding: @component-padding / 2;\n      padding-right: 10px; // space for scrollbar\n      border-top: 1px solid @overlay-border-color;\n      white-space: nowrap;\n\n      &:first-child {\n        border-top: none;\n      }\n\n      &.is-focused {\n        color: white;\n        background-color: @background-color-info;\n\n        .github-CommitView-coAuthorEditor-selectListItem > span {\n          color: inherit;\n        }\n      }\n    }\n\n    &-selectListItem {\n      text-overflow: ellipsis;\n      white-space: nowrap;\n      overflow: hidden;\n\n      &> span:first-child {\n        font-weight: 600;\n        color: @text-color-highlight;\n      }\n      &> span {\n        color: @text-color-subtle;\n        margin-right: .75em;\n      }\n      &> span:last-child {\n        margin-right: 0;\n      }\n    }\n\n    .new-author {\n      font-style: italic;\n    }\n  }\n\n  &-expandButton {\n    position: absolute;\n    right: 0;\n    bottom: 0;\n    padding: @component-padding / 2;\n    line-height: 1;\n    border: none;\n    background-color: @syntax-background-color;\n    cursor: default;\n    opacity: .3;\n    &:hover {\n      opacity: 1;\n    }\n    &:active {\n      opacity: .5;\n    }\n    &:before {\n      margin: 0;\n    }\n  }\n\n  &-bar {\n    display: flex;\n    align-items: center;\n    margin-top: @component-padding;\n  }\n\n  &-label {\n    margin-right: @component-padding;\n  }\n\n  &-button {\n    flex: 1;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    cursor: default;\n    &.is-secondary {\n      flex: 0 1 auto;\n      margin-right: @component-padding;\n    }\n  }\n\n  &-remaining-characters {\n    width: 1.25em;\n    text-align: right;\n    margin-left: @component-padding;\n    color: @text-color-subtle;\n\n    &.is-warning { color: @text-color-warning; }\n    &.is-error   { color: @text-color-error; }\n  }\n\n\n  // States ---------------------------------------------------\n\n  &-editor.is-expanded {\n    background-color: transparent;\n    atom-text-editor {\n      display: none;\n    }\n    .github-CommitView-expandButton {\n      position: relative;\n      width: 100%;\n      line-height: inherit;\n      background-color: transparent;\n      opacity: .5;\n      &::before {\n        margin-right: @component-padding / 2;\n      }\n      &::after {\n        content: "Toggle expanded commit message";\n      }\n      &:active {\n        opacity: .3;\n      }\n    }\n  }\n\n  .hard-wrap-icons {\n    fill: @text-color\n  }\n}\n',digest:"55ca75e80b0d42f8223560fb2d776cf4140483fb"},"node_modules/github/styles/conflicting-editor.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n@conflict-color-ours:     spin(@syntax-color-renamed, 80); // usually magenta/purple-ish\n@conflict-color-theirs:   @syntax-color-renamed;\n@conflict-color-base:     desaturate( @syntax-color-renamed, 100% );\n@conflict-color-modified: @syntax-color-modified;\n@conflict-color-resolved: @syntax-color-added;\n\n\natom-text-editor {\n\n  .github-ConflictBlock {\n    display: flex;\n    align-items: center;\n    margin-right: @component-padding;\n    padding: @component-padding / 2;\n    cursor: default;\n    color: fade(@syntax-text-color, 75%);\n\n    .github-ResolutionControls {\n      flex: 1;\n      button {\n        margin-right: @component-padding;\n      }\n\n      span {\n        cursor: pointer;\n      }\n    }\n  }\n\n  .github-SideDescription {\n    font-family: @font-family;\n    font-size: .9em;\n  }\n\n  .github-ResolutionControls .icon {\n    line-height: 0;\n  }\n\n  .github-ConflictTopBlock {\n    margin-top: @component-padding;\n    border-top-left-radius: @component-border-radius * 1.5;\n    border-top-right-radius: @component-border-radius * 1.5;\n  }\n  .github-ConflictBottomBlock {\n    margin-bottom: @component-padding;\n    border-bottom-left-radius: @component-border-radius * 1.5;\n    border-bottom-right-radius: @component-border-radius * 1.5;\n  }\n\n\n  // Color variations -------------------------\n\n  .generate-conflicts(@name, @color) {\n    .github-Conflict@{name} {\n      margin-right: @component-padding;\n      background-color: @color;\n      &.cursor-line { background-color: fadein(@color, 10%) !important; }\n    }\n\n    .github-Conflict@{name}Banner {\n      margin-right: @component-padding;\n      background-color: @color;\n      &.cursor-line { background-color: fadein(@color, 10%) !important; }\n      &.github-ConflictUnmodifiedBanner span { color: fade(@color, 66%) !important; };\n    }\n\n    .github-Conflict@{name}Block {\n      color: contrast(@syntax-background-color, hsla(0,0%,0%,.66), hsla(0,0%,100%,.5));\n      background-color: fadein(@color, 20%);\n\n      .btn {\n        color: white;\n        border-color: hsla(0,0%,0%,.15);\n        border: none;\n        background: fade(@color, 100%);\n      }\n    }\n  }\n\n  .generate-conflicts(Ours,      fade(@conflict-color-ours, 15%) );\n  .generate-conflicts(Theirs,    fade(@conflict-color-theirs, 15%) );\n  .generate-conflicts(Base,      fade(@conflict-color-base, 15%) );\n  .generate-conflicts(Modified,  fade(@conflict-color-modified, 15%) );\n\n\n  // Separator -------------------------\n  // Uses same color as Base\n\n  .github-ConflictSeparator {\n    margin-right: @component-padding;\n    background-color: fade(@conflict-color-base, 15%);\n    &.cursor-line { background-color: fade(@conflict-color-base, 25%) !important; }\n    span { color: fade(@conflict-color-base, 66%) !important; };\n  }\n\n  // Resolved -------------------------\n\n  .github-ResolvedLines {\n    background-color: fade(@conflict-color-resolved, 15%);\n    &.cursor-line { background-color: fade(@conflict-color-resolved, 25%) !important; }\n  }\n}\n',digest:"b186401a41aa0364bfed9c88162b18a96f3bbb87"},"node_modules/github/styles/dialog.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n@github-dialog-spacing: @component-padding / 2;\n\n.github-Dialog {\n\n  &Prompt {\n    margin: @component-padding;\n    text-align: center;\n    font-size: 1.2em;\n  }\n\n  &Inputs {\n    display: flex;\n    flex-direction: column;\n    padding: @github-dialog-spacing;\n  }\n\n  &Label {\n    flex: 1;\n    margin: @github-dialog-spacing;\n    position: relative;\n    line-height: 2;\n\n    &Button {\n      position: absolute;\n      background: transparent;\n      right: .3em;\n      bottom: 0;\n      border: none;\n      color: @text-color-subtle;\n      cursor: pointer;\n\n      &:hover {\n        color: @text-color-highlight;\n      }\n    }\n  }\n\n  &Buttons {\n    display: flex;\n    align-items: center;\n    justify-content: flex-end;\n    padding: @github-dialog-spacing;\n\n    // Switch button order on Windows\n    .platform-win32 & {\n      flex-direction: row-reverse;\n      justify-content: flex-start;\n    }\n\n    .btn {\n      margin: @github-dialog-spacing;\n    }\n\n    &-leftItem,\n    &-leftItem.btn {\n      margin: @github-dialog-spacing;\n      margin-right: auto;\n    }\n  }\n\n  &Spinner {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    padding: @component-padding;\n\n    .loading {\n      margin: @component-padding;\n    }\n  }\n\n  atom-text-editor[mini].editor {\n    margin: 0;\n  }\n}\n',digest:"2ce1bd39fb7a92badf0d54eac45a347539f0ca80"},"node_modules/github/styles/dock.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n// Dock overrides\n// Here ALL the overrides when a pane/panel gets used as a dock item\n// It\'s not too high of a priority, but still good to check (and fix) once in a while\n\n\n// Git Panel (in bottom dock) ----------------------------------------------\n\natom-dock.bottom {\n  .github-Git {\n    flex-direction: row;\n  }\n\n  .github-StagingView {\n    display: contents; // make these invisible to layout\n  }\n\n  .github-Git > div {\n    flex: 1;\n  }\n\n  .github-StagedChanges {\n    border-left: 1px solid @base-border-color;\n    border-right: 1px solid @base-border-color;\n  }\n\n  .github-StagingView-header {\n    flex-wrap: wrap;\n  }\n  .github-StagingView-group:first-child .github-StagingView-header {\n    border-top: 1px solid @base-border-color;\n  }\n\n  .github-RecentCommits {\n    max-height: none;\n    border-left: 1px solid @base-border-color;\n  }\n\n}\n\n\n// GitHub Pane (in left/right dock) ----------------------------------------------\n\natom-dock.left .github-IssueishDetailView,\natom-dock.right .github-IssueishDetailView {\n\n  // Header\n  &-header {\n    display: block;\n    padding: @component-padding;\n    background-color: @tool-panel-background-color;\n  }\n  &-avatar { position: absolute; }\n  &-avatarImage {\n    width: 20px;\n    height: 20px;\n  }\n  &-headerRow:nth-child(1) {\n    padding-left: 25px; // space for avatar\n    overflow: hidden;\n  }\n  &-title {\n    text-overflow: ellipsis;\n    white-space: nowrap;\n    overflow: hidden;\n  }\n  &-checkoutButton {\n    margin: @component-padding 0 0 0;\n  }\n\n\n  &-tablist   { flex-wrap: wrap; }\n  &-tab       { padding: @component-padding/2 @component-padding; }\n  &-tab-icon  { display: none; }\n\n\n  // [Overview]\n  &-overview {\n    font-size: .9em;\n\n    & > .github-DotComMarkdownHtml,\n    .timeline-item {\n      padding: @component-padding;\n    }\n  }\n\n\n  // [Build Status]\n  &-buildStatus { padding: 0; }\n  .github-PrStatuses {\n    &-header { border-top: none; }\n    &-header,\n    &-list-item {\n      border-radius: 0;\n      border-left: none;\n      border-right: none;\n    }\n  }\n\n\n  // [Commits]\n  .github-PrCommitsView-commitWrapper {\n    padding: 0;\n  }\n  .github-PrCommitView-container {\n    font-size: .9em;\n    border-left: none;\n    border-right: none;\n\n    &:first-child {\n      border-top: none;\n      border-radius: 0;\n    }\n    &:last-child {\n      border-bottom: none;\n      border-radius: 0;\n    }\n  }\n\n}\n\n\n// Commit Detail (in left/right dock) ----------------------------------------------\n\natom-dock.left .github-CommitDetailView,\natom-dock.right .github-CommitDetailView {\n  &-header { background-color: @tool-panel-background-color; }\n  &-commit { padding: @component-padding @component-padding 0 @component-padding; }\n  &-meta { margin-bottom: @component-padding; }\n  &-moreText { padding: @component-padding 0; }\n}\n',digest:"414406bbf0eefd0388d77c9570821f734bc3762b"},"node_modules/github/styles/donut-chart.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import \'variables\';\n\n.donut-ring-pending {\n  stroke: @gh-background-color-yellow;\n}\n\n.donut-ring-success {\n  stroke: @gh-background-color-green;\n}\n\n.donut-ring-failure {\n  stroke: @gh-background-color-red;\n}\n',digest:"79e68e96d56b3990473170e95b181b2e139b41fd"},"node_modules/github/styles/file-patch-list-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n.github-FilePatchListView {\n  &:empty:before {\n    content:\'No changes\';\n    display: block;\n    padding: @component-padding;\n    text-align: center;\n    color: @text-color-subtle;\n    font-style: italic;\n  }\n\n  &-item {\n    position: relative;\n    display: flex;\n    align-items: flex-start;\n    padding: @component-padding/2 @component-padding;\n    padding-left: @component-padding * 3.5;\n    overflow: hidden;\n    -webkit-user-select: none;\n    cursor: default;\n  }\n\n  &-icon {\n    text-align: right;\n    &:before {\n      margin-right: @component-padding / 1.2;\n    }\n  }\n\n  &-path {\n    flex: 1;\n    word-break: break-word;\n  }\n\n  &-resolutionItem {\n    padding-top: 0;\n    padding-bottom: @component-padding / 2;\n  }\n}\n\n.github-MergeConflictPaths .github-FilePatchListView-icon:last-child {\n  margin-left: @component-padding / 2;\n}\n',digest:"a86dc9565052d0e9c830974a7f164ae66a7b0e06"},"node_modules/github/styles/file-patch-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n@import "octicon-utf-codes";\n@import "octicon-mixins";\n\n@header-bg-color: mix(@syntax-text-color, @syntax-background-color, 6%);\n\n.github-FilePatchView {\n  display: flex;\n  flex-direction: column;\n  -webkit-user-select: none;\n  cursor: default;\n  flex: 1;\n  min-width: 0;\n  height: 100%;\n\n  &--blank &-container {\n    flex: 1;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    text-align: center;\n    font-size: 1.2em;\n    padding: @component-padding;\n  }\n\n  &-controlBlock {\n    background-color: @syntax-background-color;\n    display: flow-root;\n  }\n\n  &-controlBlock &-header {\n    margin: @component-padding*4 @component-padding @component-padding 0;\n  }\n\n  &-controlBlock .github-HunkHeaderView {\n    margin: @component-padding @component-padding @component-padding 0;\n  }\n\n  &-controlBlock + &-controlBlock {\n    .github-FilePatchView-header , .github-HunkHeaderView {\n      margin-top: 0;\n    }\n  }\n\n  &-header {\n    display: flex;\n    align-items: center;\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n    font-family: @font-family;\n    font-size: @font-size;\n    background-color: @header-bg-color;\n    cursor: default;\n\n    .btn {\n      font-size: .9em;\n      &.icon-move-up::before,\n      &.icon-move-down::before {\n        font-size: 1em;\n        margin-right: .5em;\n      }\n    }\n\n    .btn-group {\n      margin: @component-padding/2;\n    }\n  }\n\n  &-title {\n    flex: 1;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n    margin-left: @component-padding;\n  }\n\n  &-message {\n    font-family: @font-family;\n    text-align: center;\n    margin: 15px 0 0 0;\n  }\n\n  &-showDiffButton {\n    background: transparent;\n    border: none;\n    color: @text-color-highlight;\n    font-size: 18px;\n    margin-bottom: 15px;\n\n    &:hover {\n        color: @gh-background-color-blue;\n      }\n  }\n\n  &-collapseButton {\n    background: transparent;\n    border: none;\n    padding: @component-padding/1.5;\n\n    & + .github-FilePatchView-title {\n      margin-left: 0; // chevron already has margin\n    }\n  }\n\n  &-collapseButtonIcon {\n    &:before {\n      margin-right: 0;\n      vertical-align: -2px;\n    }\n  }\n\n  &-container {\n    flex: 1;\n    display: flex;\n    height: 100%;\n    flex-direction: column;\n\n    .large-file-patch {\n      flex: 1;\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      text-align: center;\n      font-size: 1.2em;\n      padding: @component-padding;\n    }\n\n    .large-file-patch {\n      flex-direction: column;\n    }\n\n    atom-text-editor {\n      width: 100%;\n      height: 100%;\n    }\n  }\n\n  // Meta section\n  // Used for mode changes\n\n  &-meta {\n    font-family: @font-family;\n    padding-top: @component-padding;\n  }\n\n  &-metaContainer {\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n  }\n\n  &-metaHeader {\n    display: flex;\n    align-items: center;\n    font-size: .9em;\n    border-bottom: 1px solid @base-border-color;\n  }\n\n  &-metaTitle {\n    flex: 1;\n    margin: 0;\n    padding-left: @component-padding;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n  }\n\n  &-metaControls {\n    margin-left: @component-padding;\n  }\n\n  &-metaButton {\n    line-height: 1.9; // Magic number to match the hunk height\n    padding-left: @component-padding;\n    padding-right: @component-padding;\n    font-family: @font-family;\n    border: none;\n    border-left: 1px solid @base-border-color;\n    background-color: transparent;\n    cursor: default;\n    &:hover  { background-color: mix(@syntax-text-color, @syntax-background-color, 4%); }\n    &:active { background-color: mix(@syntax-text-color, @syntax-background-color, 2%); }\n\n    &.icon-move-up::before,\n    &.icon-move-down::before {\n      font-size: 1em;\n      margin-right: .25em;\n      vertical-align: baseline;\n    }\n  }\n\n  &-metaDetails {\n    padding: @component-padding;\n  }\n\n  &-metaDiff {\n    margin: 0 .2em;\n    padding: .2em .4em;\n    line-height: 1.6;\n    border-radius: @component-border-radius;\n    &--added {\n      color: mix(@text-color-highlight, @text-color-success, 40%);\n      background-color: mix(@base-background-color, @background-color-success, 80%);\n    }\n    &--removed {\n      color: mix(@text-color-highlight, @text-color-error, 40%);\n      background-color: mix(@base-background-color, @background-color-error, 80%);\n    }\n    &--fullWidth {\n      display: block;\n      margin: @component-padding/2 0 0 0;\n      &:first-child {\n        margin-top: 0;\n      }\n    }\n\n    code {\n      margin: 0 .2em;\n      padding: 0 .2em;\n      font-size: .9em;\n      color: inherit;\n      line-height: 1;\n      vertical-align: middle;\n      word-break: break-all;\n      background-color: @base-background-color;\n    }\n  }\n\n  // Line decorations\n\n  &-line {\n    &--deleted {\n      background-color: @github-diff-deleted;\n      &.line.cursor-line {\n        background-color: fadein(@github-diff-deleted, 3%);\n      }\n    }\n    &--added {\n      background-color: @github-diff-added;\n      &.line.cursor-line {\n        background-color: fadein(@github-diff-added, 3%);\n      }\n    }\n  }\n\n\n  // Gutter\n\n  .gutter {\n    .icon-right {\n      display: none; // remove fold icon\n    }\n\n    &.old .line-number, &.new .line-number {\n      min-width: 6ch; // Fit up to 4 characters (+1 padding on each side)\n      opacity: 1;\n      padding: 0 1ch 0 0;\n    }\n\n    &.icons .line-number {\n      padding: 0;\n      opacity: 1;\n      width: 2ch;\n      font-family: @font-family;\n      text-align: center;\n      color: mix(@syntax-gutter-text-color, @syntax-text-color);\n      -webkit-font-smoothing: antialiased;\n\n      &:before {\n        display: inline-block;\n        min-width: 2ch;\n      }\n\n      &.github-FilePatchView-line--added:before {\n        content: "+";\n      }\n\n      &.github-FilePatchView-line--deleted:before {\n        content: "-";\n      }\n\n      &.github-FilePatchView-line--nonewline:before {\n        content: @no-newline;\n        .octicon-font();\n        width: inherit;\n        min-width: auto;\n      }\n    }\n  }\n\n  // Inactive\n\n  &--inactive .highlights .highlight.selection {\n    display: none;\n  }\n\n  // Readonly editor\n\n  atom-text-editor[readonly] {\n    .cursors {\n      display: none;\n    }\n  }\n}\n\n\n// States\n\n// Selected\n.github-FilePatchView {\n  .gutter {\n    &.old .line-number,\n    &.new .line-number,\n    &.icons .line-number {\n      &.github-FilePatchView-line--selected {\n        color: @text-color-selected;\n        background: @background-color-selected;\n      }\n    }\n  }\n\n  atom-text-editor {\n    .selection .region {\n      background-color: transparent; // remove default selection\n    }\n  }\n}\n\n// Selected + focused\n.github-FilePatchView:focus-within {\n  .gutter {\n    &.old .line-number,\n    &.new .line-number,\n    &.icons .line-number {\n      &.github-FilePatchView-line--selected {\n        color: contrast(@button-background-color-selected);\n        background: @button-background-color-selected;\n      }\n    }\n  }\n\n  atom-text-editor {\n    .selection .region {\n      background-color: mix(@button-background-color-selected, @syntax-background-color, 25%);\n    }\n  }\n}\n\n// Selected + focused hunkmode\n.github-FilePatchView.github-FilePatchView--hunkMode:focus-within {\n\n  atom-text-editor {\n    .selection .region {\n      background-color: mix(@button-background-color-selected, @syntax-background-color, 8%);\n    }\n  }\n}\n\n.gitub-FilePatchHeaderView-basename {\n  font-weight: bold;\n}\n',digest:"e8dfbcde47b1c5441a18dffd82c6640767491156"},"node_modules/github/styles/git-tab.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n.github-StubItem-git,\n.github-Git-root {\n  flex: 1;\n  display: flex;\n}\n\n.github-Git {\n  flex: 1;\n  display: flex;\n  flex-direction: column;\n  min-width: 0;\n  font-family: @font-family;\n  font-size: @font-size;\n  color: @text-color;\n  -webkit-user-select: none;\n  cursor: default;\n\n  &.is-loading {\n    color: @text-color-subtle;\n  }\n\n  &.no-repository,\n  &.too-many-changes,\n  &.unsupported-directory {\n    display: flex;\n    justify-content: center;\n    font-size: 1.25em;\n    padding: @component-padding * 3;\n    text-align: center;\n\n    > * {\n      margin: @component-padding 0;\n    }\n\n    h1 {\n      margin-bottom: @component-padding * 3;\n    }\n\n    button {\n      overflow: hidden;\n      text-overflow: ellipsis;\n    }\n  }\n\n  &-LargeIcon:before {\n    margin-right: 0;\n    margin-bottom: @component-padding * 5;\n    width: auto;\n    height: auto;\n    font-size: 8em;\n    color: mix(@base-background-color, @text-color, 66%); // 2/3 of bg color\n  }\n}\n',digest:"0a25d61cc6a62297ae12fede424856f9d03d5fbc"},"node_modules/github/styles/github-dotcom-markdown.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n// This styles Markdown used in issueish panes.\n\n@margin: 1em;\n\n.github-DotComMarkdownHtml {\n\n  font-size: 1.15em;\n  line-height: 1.5;\n\n  & > *:first-child {\n    margin-top: 0;\n  }\n  & > *:last-child {\n    margin-bottom: 0;\n  }\n\n  // Headings --------------------\n\n  h1, h2, h3, h4, h5, h6 {\n    line-height: 1.2;\n    margin-top: @margin;\n    margin-bottom: @margin/3;\n    color: @text-color-highlight;\n  }\n\n  h1 { font-size: 1.5em; font-weight: 400; }\n  h2 { font-size: 1.3em; font-weight: 400; }\n  h3 { font-size: 1.2em; font-weight: 500; }\n  h4 { font-size: 1.1em; font-weight: 600; }\n  h5 { font-size: 1em;   font-weight: 600; }\n  h6 { font-size: .9em;  font-weight: 600; }\n\n  h2 {\n    padding-bottom: .25em;\n    margin-bottom: @margin/2;\n    border-bottom: 1px solid @base-border-color;\n  }\n\n\n  // Emphasis --------------------\n\n  strong {\n    color: @text-color-highlight;\n  }\n\n  del {\n    color: @text-color-subtle;\n  }\n\n\n  // Link --------------------\n\n  a,\n  a code {\n    color: @text-color-info;\n  }\n\n\n  // Images --------------------\n\n  img {\n    max-width: 100%;\n  }\n\n\n  // Paragraph --------------------\n\n  & > p {\n    margin-top: 0;\n    margin-bottom: @margin;\n  }\n\n\n  // List --------------------\n\n  & > ul,\n  & > ol {\n    margin-bottom: @margin;\n    padding-left: 2em;\n  }\n\n  li {\n    // font-size: .9em;\n    padding-top: .1em;\n    padding-bottom: .1em;\n\n    li {\n      font-size: 1em;\n    }\n  }\n\n  .task-list-item {\n    position: relative;\n    // indent task lists\n    list-style: none;\n    .task-list-item-checkbox {\n      position: absolute;\n      margin-left: -20px;\n    }\n  }\n\n  // Blockquotes --------------------\n\n  blockquote {\n    margin: @margin 0;\n    padding: .25em 1em;\n    font-size: inherit;\n    color: @text-color-subtle;\n    border-color: @base-border-color;\n    border-width: 3px;\n  }\n\n\n  // HR --------------------\n\n  hr {\n    margin: @margin*1.5 25%;\n    border-top: 1px solid @base-border-color;\n    background: none;\n  }\n\n\n  // Table --------------------\n\n  table {\n    margin: @margin 0;\n  }\n\n  th {\n    color: @text-color-highlight;\n  }\n\n  th,\n  td {\n    padding: .66em 1em;\n    border: 1px solid @base-border-color;\n  }\n\n\n  // Code --------------------\n\n  pre,\n  code {\n    color: @text-color-highlight;\n    background-color: @background-color-highlight;\n\n  }\n\n  pre {\n    margin: @margin 0;\n\n    & > code {\n      white-space: pre;\n    }\n  }\n\n  .highlight {\n    margin: @margin 0;\n    pre {\n      margin: 0;\n    }\n  }\n\n\n  // KBD --------------------\n\n  kbd {\n    color: @text-color-highlight;\n    border: 1px solid @base-border-color;\n    border-bottom: 2px solid darken(@base-border-color, 6%);\n    background-color: @background-color-highlight;\n  }\n\n  // Custom --------------------\n\n  .issue-link {\n    color: @text-color-subtle; // same as .cross-referenced-event-label-number\n  }\n\n  .js-suggested-changes-blob { // gets used for suggested changes\n    margin: @margin 0;\n  }\n\n}\n',digest:"8adbca92ebf469fbec5e923bf54b282e43d82799"},"node_modules/github/styles/github-login-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n.github-GithubLoginView {\n  flex: 1;\n  display: flex;\n  flex-direction: column;\n  font-size: 1.25em;\n\n  .github-GithubLoginView-Subview {\n    flex: 1;\n    display: flex;\n    flex-direction: column;\n    justify-content: center;\n    text-align: center;\n    padding: @component-padding * 3;\n\n    > * {\n      margin: @component-padding 0;\n    }\n\n    h1 {\n      margin-bottom: @component-padding * 3;\n    }\n\n    button {\n      width: 100%;\n      overflow: hidden;\n      text-overflow: ellipsis;\n    }\n\n    ol {\n      text-align: left;\n      padding: @component-padding 0;\n\n      a {\n        color: @text-color-info;\n      }\n    }\n\n    ul {\n      list-style: none;\n      padding-left: 0;\n\n      li:not(:last-child) {\n        margin-bottom: @component-padding;\n      }\n    }\n  }\n}\n',digest:"589cf1cb497c5ed917bc3e4413be50a50c473317"},"node_modules/github/styles/github-status-bar-tile.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n.github-StatusBarTile {\n  background-color: inherit;\n  border: none;\n\n  &.icon-mark-github::before {\n    margin-right: .2em;\n  }\n\n}\n',digest:"51c5b99823f38bff9b599d2ea356676fa5adbb6f"},"node_modules/github/styles/github-tab.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n.github-StubItem-github,\n.github-GitHub-root {\n  flex: 1;\n  display: flex;\n}\n\n.github-GitHub {\n  flex: 1;\n  min-width: 0;\n  display: flex;\n  flex-direction: column;\n  -webkit-user-select: none;\n  cursor: default;\n\n  &-content {\n    flex: 1;\n    display: flex;\n    flex-direction: column;\n  }\n\n  &-noRemotes,\n  .github-RemoteSelector {\n    flex: 1;\n    display: flex;\n    flex-direction: column;\n    justify-content: center;\n    font-size: 1.25em;\n    text-align: center;\n    padding: @component-padding * 3;\n\n    > * {\n      margin: @component-padding 0;\n    }\n\n    h1 {\n      margin-bottom: @component-padding * 3;\n    }\n  }\n\n  .github-RemoteSelector {\n    ul {\n      list-style: none;\n      padding-left: 0;\n\n      li:not(:last-child) {\n        margin-bottom: @component-padding;\n      }\n    }\n\n    button {\n      width: 100%;\n      overflow: hidden;\n      text-overflow: ellipsis;\n    }\n  }\n\n  &-LargeIcon:before {\n    margin-right: 0;\n    margin-bottom: @component-padding * 5;\n    width: auto;\n    height: auto;\n    font-size: 8em;\n    color: mix(@base-background-color, @text-color, 66%); // 2/3 of bg color\n  }\n}\n',digest:"2758ad70995f1d1a09dc9fed3f726d7cfe505368"},"node_modules/github/styles/hunk-header-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n@hunk-fg-color: @text-color-subtle;\n@hunk-bg-color: mix(@syntax-text-color, @syntax-background-color, 0%);\n@hunk-bg-color-hover: mix(@syntax-text-color, @syntax-background-color, 4%);\n@hunk-bg-color-active: mix(@syntax-text-color, @syntax-background-color, 2%);\n\n.github-HunkHeaderView {\n  display: flex;\n  align-items: stretch;\n  font-size: @font-size;\n  border: 1px solid @base-border-color;\n  border-radius: @component-border-radius;\n  background-color: @hunk-bg-color;\n  cursor: default;\n\n  &-title {\n    flex: 1;\n    line-height: 2.4;\n    padding: 0 @component-padding;\n    color: @text-color-subtle;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    -webkit-font-smoothing: antialiased;\n    &:hover  { background-color: @hunk-bg-color-hover; }\n    &:active { background-color: @hunk-bg-color-active; }\n  }\n\n  &-stageButton,\n  &-discardButton {\n    line-height: 1;\n    padding-left: @component-padding;\n    padding-right: @component-padding;\n    font-family: @font-family;\n    border: none;\n    border-left: inherit;\n    background-color: transparent;\n    cursor: default;\n    &:hover  { background-color: @hunk-bg-color-hover; }\n    &:active { background-color: @hunk-bg-color-active; }\n\n    .keystroke {\n      margin-right: 1em;\n    }\n  }\n\n  // pixel fit the icon\n  &-discardButton:before {\n    text-align: left;\n    width: auto;\n    vertical-align: 2px;\n  }\n}\n\n//\n// States\n// -------------------------------\n\n.github-HunkHeaderView {\n  &-title,\n  &-stageButton,\n  &-discardButton {\n    &:hover  { background-color: @hunk-bg-color-hover; }\n    &:active { background-color: @hunk-bg-color-active; }\n  }\n}\n\n// Selected\n.github-HunkHeaderView--isSelected {\n  color: @text-color-selected;\n  background-color: @background-color-selected;\n  border-color: transparent;\n  .github-HunkHeaderView-title {\n    color: inherit;\n  }\n  .github-HunkHeaderView-title,\n  .github-HunkHeaderView-stageButton,\n  .github-HunkHeaderView-discardButton {\n    &:hover  { background-color: @background-color-highlight; }\n    &:active { background-color: @background-color-selected; }\n  }\n}\n\n\n// Selected + focused\n.github-FilePatchView:focus-within {\n  .github-HunkHeaderView--isSelected {\n    color: contrast(@button-background-color-selected);\n    background-color: @button-background-color-selected;\n    .github-HunkHeaderView-title,\n    .github-HunkHeaderView-stageButton,\n    .github-HunkHeaderView-discardButton {\n      &:hover  { background-color: lighten(@button-background-color-selected, 4%); }\n      &:active { background-color: darken(@button-background-color-selected, 4%); }\n    }\n  }\n}\n',digest:"5b4a8fa3711d7110975c081ff97b3d2dcad2b6b9"},"node_modules/github/styles/issueish-badge.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import \'variables\';\n\n// Issueish Badge\n// Shows the [Open], [Closed], [Merged] state\n\n.github-IssueishBadge {\n  @space: .4em;\n\n  display: inline-block;\n  padding: @space/1.5  @space;\n  font-size: .9em;\n  font-weight: 500;\n  line-height: 1;\n  text-transform: capitalize;\n  border-radius: @component-border-radius;\n  white-space: nowrap;\n\n  .icon::before {\n    font-size: inherit;\n    width: auto;\n    height: auto;\n    margin-right: @space/2;\n  }\n\n  &.open {\n    color: contrast(@gh-background-color-green, black, white, 50%);\n    background-color: @gh-background-color-green;\n  }\n\n  &.closed {\n    color: contrast(@gh-background-color-red, black, white, 50%);\n    background-color: @gh-background-color-red;\n  }\n\n  &.merged {\n    color: contrast(@gh-background-color-purple, black, white, 50%);\n    background-color: @gh-background-color-purple;\n  }\n}\n',digest:"47ec5ae097d2268ffef8d3b87e20178b512f9cbe"},"node_modules/github/styles/issueish-detail-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import \'variables\';\n\n.github-IssueishDetailView {\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  background-color: @base-background-color;\n\n\n  // Layout ------------------------\n\n  &-container {\n    display: flex;\n    flex-direction: column;\n    height: 100%;\n  }\n\n  .react-tabs {\n    flex: 1;\n    display: flex;\n    flex-direction: column;\n  }\n\n  .react-tabs__tab-panel--selected {\n    flex: 1;\n    overflow: auto;\n  }\n\n\n  // Header ------------------------\n\n  &-header {\n    display: flex;\n    align-items: center;\n    padding: @component-padding*1.5 @component-padding*2;\n    border-bottom: 1px solid @base-border-color;\n  }\n\n  &-headerColumn {\n    &.is-flexible {\n      flex: 1;\n      display: flex;\n      flex-wrap: wrap;\n    }\n  }\n\n  &-headerRow {\n    display: flex;\n    align-items: center;\n    flex-wrap: wrap;\n    margin: 2px 0;\n    &.is-fullwidth {\n      flex: 1 1 100%;\n    }\n  }\n\n  // Avatar ------------------------\n\n  &-avatar {\n    align-self: flex-start;\n    margin-right: @component-padding;\n  }\n\n  &-title {\n    margin: 0;\n    font-size: 1.25em;\n    font-weight: 500;\n    line-height: 1.3;\n    color: @text-color-highlight;\n    &:hover,\n    &:focus {\n      text-decoration: none;\n    }\n  }\n\n  &-headerBadge {\n    margin-right: @component-padding;\n    padding: 0 0.75em;\n    line-height: 1.65em;\n  }\n\n  &-headerLink {\n    color: @text-color-subtle;\n  }\n\n  &-headerStatus {\n    margin-left: @component-padding;\n  }\n\n  // Checkout button -----------------------\n  &-checkoutButton {\n    font-weight: 600;\n    margin-left: @component-padding;\n  }\n\n  // Refresh Button ------------------------\n\n  &-headerRefreshButton {\n    display: inline-block;\n    margin-right: @component-padding;\n    color: @text-color-subtle;\n    cursor: pointer;\n\n    &::before {\n      display: block;\n      width: 16px;\n      height: 16px;\n      line-height: .9;\n      margin-right: 0;\n      text-align: center;\n    }\n    &.refreshing::before {\n      @keyframes github-IssueishDetailView-headerRefreshButtonAnimation {\n        100% { transform: rotate(360deg); }\n      }\n      animation: github-IssueishDetailView-headerRefreshButtonAnimation 2s linear 30; // limit to 1min in case something gets stuck\n    }\n  }\n\n  &-avatarImage {\n    width: 40px;\n    height: 40px;\n    border-radius: @component-border-radius;\n  }\n\n\n  // Meta ------------------------\n\n  &-meta {\n    color: @text-color-subtle;\n\n    &Author {\n      color: inherit;\n    }\n  }\n\n\n  // Tabs ------------------------\n\n  &-tablist {\n    flex: none;\n    display: flex;\n    justify-content: center;\n    padding: 0;\n    margin: 0;\n    list-style: none;\n    border-bottom: 1px solid @base-border-color;\n    background-color: @app-background-color;\n  }\n\n  &-tab {\n    padding: @component-padding/2 @component-padding*1.5;\n    text-align: center;\n    font-weight: 600;\n    color: mix(@text-color, @app-background-color, 75%);\n    cursor: default;\n    user-select: none;\n  }\n\n  &-tab-icon {\n    color: mix(@text-color, @app-background-color, 33%);\n    vertical-align: middle;\n    &:before {\n      margin-right: .4em;\n    }\n  }\n\n  &-tab-count {\n    display: inline-block;\n    background-color: mix(@text-color-subtle, @app-background-color, 20%);\n    border-radius: @component-border-radius;\n    padding: 0 .25em;\n    margin-left: @component-padding/2;\n  }\n\n\n  // Selected tab\n  &-tab.react-tabs__tab--selected {\n    color: @text-color-selected;\n    box-shadow: 0 1px 0 @button-background-color-selected;\n\n    .github-IssueishDetailView-tab-icon {\n      color: @text-color;\n    }\n  }\n\n  // Footer ------------------------\n\n  &-footer {\n    padding: @component-padding;\n    text-align: center;\n    border-top: 1px solid @base-border-color;\n    background-color: @app-background-color;\n\n    &Link.icon {\n      color: @text-color-subtle;\n      &:before {\n        vertical-align: -2px;\n      }\n    }\n  }\n\n  // Tab Content ------------------------\n\n  // Overview\n  &-overview {\n    max-width: 60em;\n    margin: 0 auto;\n\n    & > .github-DotComMarkdownHtml {\n      padding: @component-padding*2;\n    }\n  }\n\n\n  &-reactions {\n    padding: 0 @component-padding*2 @component-padding @component-padding*2;\n    &:empty {\n      display: none;\n    }\n    &Group {\n      margin-right: @component-padding*2;\n    }\n  }\n\n  // Build Status\n  &-buildStatus {\n    padding: @component-padding*2;\n    &:empty {\n      display: none;\n    }\n  }\n\n  // Commits\n  .github-PrCommitsView-commitWrapper {\n    padding: @component-padding*2;\n  }\n\n\n  // Issue Body ------------------------\n\n  &-issueBody {\n    flex: 1;\n    overflow: auto;\n\n    & > .github-DotComMarkdownHtml {\n      padding: @component-padding*2;\n    }\n  }\n\n}\n',digest:"650aa1328c04118b39f33e109058d87e2e01962a"},"node_modules/github/styles/issueish-list-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n.github-IssueishList {\n  &-item {\n    margin: @component-padding / 4;\n\n    &--avatar {\n      @size: 16px;\n      border-radius: @component-border-radius;\n      height: @size;\n      width: @size;\n    }\n\n    &--title {\n      flex: 1;\n      text-overflow: ellipsis;\n      white-space: nowrap;\n      overflow: hidden;\n    }\n\n    &--number {\n      font-size: .9em;\n      color: @text-color-subtle;\n    }\n\n    &--status {\n      @size: 20px;\n      text-align: center;\n\n      &:before {\n        margin-right: 0;\n        width: @size;\n      }\n      &.icon-check {\n        color: @text-color-success;\n      }\n      &.icon-x {\n        color: @text-color-error;\n      }\n      &.icon-dash {\n        color: @text-color-subtle;\n      }\n      svg& {\n        height: @size;\n        width: @size;\n\n        circle {\n          cx: @size/2;\n          cy: @size/2;\n          r: 5.5;\n          stroke-width: 3;\n        }\n      }\n    }\n\n    &--age {\n      color: @text-color-subtle;\n      font-size: .9em;\n\n      // Better balance for 3 characters (10M)\n      margin-left: 0;\n      min-width: 3ch;\n      text-align: center;\n    }\n\n  }\n\n  &-more {\n    padding: @component-padding / 2;\n    display: flex;\n    flex-direction: row;\n    justify-content: center;\n    border-top: 1px solid @base-border-color;\n    a {\n      font-style: italic;\n      color: @text-color-subtle;\n    }\n  }\n\n  &-loading {\n    padding: @component-padding / 2;\n    min-height: 29px; // Magic number: Prevents jumping.\n    font-style: italic;\n    text-align: center;\n    color: @text-color-subtle;\n  }\n}\n\n.github-CreatePullRequestTile {\n  &-message,\n  &-controls {\n    padding: @component-padding;\n    text-align: center;\n    margin-bottom: 0;\n  }\n  &-message + .github-CreatePullRequestTile-controls {\n    border-top: 1px solid @base-border-color;\n  }\n  &-message .icon {\n    vertical-align: middle;\n    &:before {\n      width: auto;\n    }\n  }\n  &-divider {\n    margin: @component-padding/1.25 20%;\n    border-color: @base-border-color;\n  }\n  &-createPr {\n    width: 100%;\n  }\n}\n\n.github-QueryErrorTile {\n  padding: @component-padding;\n  display: flex;\n  color: @text-color-error;\n\n  &-messages {\n    display: flex;\n    flex-direction: column;\n    flex-grow: 1\n  }\n\n  .icon-alert {\n    vertical-align: text-top;\n  }\n\n  &-message {\n    font-weight: bold;\n  }\n}\n',digest:"2b190df1a253bb87d090e6b732b8232549554d1a"},"node_modules/github/styles/issueish-search.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import \'variables\';\n\n.github-IssueishSearch {\n  flex: 1;\n  min-width: 0;\n  display: flex;\n  flex-direction: column;\n  overflow-y: auto;\n}\n',digest:"c26b8f8f5a595533e10391be7ce3f89016b70180"},"node_modules/github/styles/issueish-tooltip.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import \'variables\';\n\n.github-IssueishTooltip {\n  display: flex;\n  flex-direction: column;\n  padding: @component-padding/2;\n  font-size: .9em;\n  text-align: left;\n\n  .issueish-avatar-and-title {\n    display: flex;\n    align-items: center;\n    margin: @component-padding/2;\n  }\n\n  .author-avatar {\n    margin-right: @component-padding;\n    flex: 0 0 26px; // prevent sqeezing\n    width: 26px;\n    height: 26px;\n    align-self: flex-start;\n    border-radius: @component-border-radius;\n  }\n\n  .issueish-title {\n    margin: 0;\n    font-size: 1.25em;\n    font-weight: 600;\n    line-height: 1.3;\n    color: @text-color-highlight;\n    white-space: initial;\n  }\n\n  .issueish-badge-and-link {\n    margin: @component-padding/2;\n  }\n\n  .issueish-badge {\n    margin-right: @component-padding;\n    font-weight: 500;\n    text-transform: capitalize;\n    border-radius: @component-border-radius;\n\n    &.open {\n      color: contrast(@gh-background-color-green, black, white, 50%);\n      background-color: @gh-background-color-green;\n    }\n\n    &.closed {\n      color: contrast(@gh-background-color-red, black, white, 50%);\n      background-color: @gh-background-color-red;\n    }\n\n    &.merged {\n      color: contrast(@gh-background-color-purple, black, white, 50%);\n      background-color: @gh-background-color-purple;\n    }\n\n    .icon:before {\n      width: auto;\n      font-size: 14px;\n      vertical-align: -1px;\n    }\n  }\n\n  .issueish-link {\n    color: @text-color-subtle;\n  }\n\n}\n',digest:"8e02635aa2245c6b483dc75ba166eb986329ef84"},"node_modules/github/styles/loader.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n@import "variables";\n\n// Loader\n// Shows a spinner with an Octoface\n\n/* Usage: ---------------------------------------------\n\n<div className="github-Loader">\n  <span className="github-Spinner"></span>\n</div>\n\n--------------------------------------------------- */\n\n// Loader (just the container)\n\n.github-Loader {\n  height: 100%;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  font-size: 32px;\n  color: @gh-background-color-purple;\n\n  .tooltip & { color: inherit; }\n}\n\n\n// Spinner (can be used outside of github-Loader too)\n\n.github-Spinner {\n  position: relative;\n  display: inline-block;\n  vertical-align: middle;\n  width: 2em;\n  height: 2em;\n\n  // Octoface\n  &::before {\n    display: inline-block;\n    width: inherit;\n    height: inherit;\n    content: "\\f008";\n    font-family: \'Octicons Regular\';\n    font-weight: normal;\n    font-style: normal;\n    line-height: 2;\n    text-align: center;\n    -webkit-font-smoothing: antialiased;\n  }\n\n  // spinner\n  &::after {\n    content: "";\n    position: absolute;\n    width: inherit;\n    height: inherit;\n    top: 0;\n    left: 0;\n    border-right: 2px dotted;\n    border-bottom: 2px dotted;\n    border-left: 2px solid transparent;\n    border-radius: 1em;\n\n    // To limit CPU usage, the animation plays for some time at normal speed,\n    // then slows down frame-rate for a while and stops at some point\n    animation: github-Spinner-animation 4s linear 12,\n               github-Spinner-animation 4s 48s steps(12) 100;\n\n    @keyframes github-Spinner-animation {\n      100% { transform: rotate(360deg); }\n    }\n  }\n}\n',digest:"fcfbd015c3136813441bacb738856357318e1533"},"node_modules/github/styles/message.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n@import "variables";\n\n// Message\n// Use to show some sort of message, like an error or so\n\n/* Usage: ---------------------------------------------\n\n<div className="github-Message">\n  <div className="github-Message-wrapper">\n    <h1 className="github-Message-title">Whooops</h1>\n    <p className="github-Message-description">Bad things happened</p>\n    <p className="github-Message-action">\n      <button className="github-Message-button btn btn-primary">Get me out of here</button>\n    </p>\n  </div>\n</div>\n\n--------------------------------------------------- */\n\n\n.github-Message {\n  flex: 1;\n  display: flex;\n  overflow-x: hidden;\n  overflow-y: auto;\n\n  &-wrapper {\n    margin: auto;\n    padding: @component-padding*2;\n    text-align: center;\n    width: 100%;\n  }\n\n  &-title {\n    color: @text-color-highlight;\n    font-size: 1.5em;\n    margin-bottom: .5em;\n  }\n\n  &-description {\n    font-size: 1.2em;\n    line-height: 1.4;\n    margin-bottom: 0;\n\n    pre& {\n      text-align: left;\n    }\n  }\n\n  &-longDescription {\n    font-size: 1.1em;\n    line-height: 1.4;\n    text-align: left;\n    margin-bottom: 0;\n  }\n\n  &-action {\n    margin-top: @component-padding* 2;\n  }\n\n  &-button {\n    margin: @component-padding/2;\n  }\n\n}\n',digest:"eecefdbd9802f3b262fb298c0cd33df0ba151bd2"},"node_modules/github/styles/pane-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n@import "ui-variables";\n\n.github-PaneView {\n  display: flex;\n  height: 100%;\n}\n',digest:"d767a2539746faac8959261c770bd262e58c4587"},"node_modules/github/styles/popover.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n// Popover: Custom tooltip\n// Used for branch switcher and hovercards\n\n.github-Popover {\n  &.tooltip {\n    max-width: 400px; // Same as the github-Git\n    padding-left: @component-padding;\n    padding-right: @component-padding;\n    box-sizing: border-box;\n  }\n  .tooltip-inner.tooltip-inner {\n    padding: @component-padding / 2;\n    background-color: @tool-panel-background-color;\n    border: 1px solid @base-border-color;\n    box-shadow: 0 4px 8px hsla(0, 0, 0, .1);\n    color: @text-color;\n  }\n  &.top .tooltip-arrow.tooltip-arrow {\n    width: @component-padding;\n    height: @component-padding;\n    border-width: 0 0 1px 1px;\n    border-color: @base-border-color;\n    background-color: @tool-panel-background-color;\n    border-bottom-right-radius: 2px;\n    transform: rotate(-45deg);\n  }\n}\n',digest:"b4c63ea5b9b28be0f7fda54713bcb31c29382f9a"},"node_modules/github/styles/pr-comment.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import \'variables\';\n\n@avatar-size: 16px;\n@avatar-spacing: 6px;\n\n\n.github-PrCommentThread {\n  padding: @component-padding @component-padding @component-padding 0;\n}\n\n\n.github-PrComment {\n  max-width: 60em;\n  padding: @component-padding;\n  font-family: @font-family;\n  font-size: @font-size;\n  border: 1px solid @base-border-color;\n\n  &:first-child {\n    border-top-left-radius: @component-border-radius;\n    border-top-right-radius: @component-border-radius;\n  }\n  &:last-child {\n    border-bottom-left-radius: @component-border-radius;\n    border-bottom-right-radius: @component-border-radius;\n  }\n\n  & + .github-PrComment {\n    border-top: none;\n  }\n\n  &-header {\n    color: @text-color-subtle;\n    line-height: @avatar-size;\n  }\n\n  &-avatar {\n    margin-right: @avatar-spacing;\n    height: @avatar-size;\n    width: @avatar-size;\n    border-radius: @component-border-radius;\n    vertical-align: top;\n  }\n\n  &-timeAgo {\n    color: inherit;\n  }\n\n  &-body {\n    margin-left: @avatar-size + @avatar-spacing; // avatar + margin\n  }\n\n  &-hidden {\n    font-size: 14px;\n  }\n\n  &-icon {\n    vertical-align: middle;\n  }\n\n\n  // Suggested changes\n  .js-suggested-changes-blob {\n    font-size: .9em;\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n\n    .d-flex { display: flex; }\n    .d-inline-block { display: inline-block; }\n    .flex-auto { flex: 1 1 auto; }\n    .p-1 { padding: @component-padding/2; }\n    .px-1 { padding-left: @component-padding/2; padding-right: @component-padding/2; }\n    .p-2 { padding: @component-padding; }\n    .text-gray { color: @text-color-subtle; }\n    .lh-condensed { line-height: 1.25; }\n    .rounded-1 { border-radius: @component-border-radius; }\n    .border { border: 1px solid; }\n    .border-bottom { border-bottom: 1px solid @base-border-color; }\n    .border-green { border-color: @text-color-success; }\n    .octicon { vertical-align: -4px; fill: currentColor; }\n\n    .blob-wrapper > table {\n      width: 100%;\n      margin: 0;\n      font-family: var(--editor-font-family);\n      font-size: var(--editor-font-size);\n      line-height: var(--editor-line-height);\n\n      td {\n        border: none;\n        padding: 0 .5em;\n      }\n    }\n\n    .blob-num {\n      padding: 0 .5em;\n      color: @text-color-subtle;\n      &:before {\n        content: attr(data-line-number);\n      }\n      &-addition {\n        background-color: fadein(@github-diff-added, 10%);\n      }\n      &-deletion {\n        background-color: fadein(@github-diff-deleted, 10%);\n      }\n    }\n\n    .blob-code {\n      &-inner {\n        &:before { margin-right: .5em; }\n        .x {\n          &-first {\n            border-bottom-left-radius: @component-border-radius;\n            border-top-left-radius: @component-border-radius;\n          }\n          &-last {\n            border-bottom-right-radius: @component-border-radius;\n            border-top-right-radius: @component-border-radius;\n          }\n        }\n      }\n\n      &-addition {\n        background-color: @github-diff-added;\n        &:before { content: "+"; }\n        .x {\n          background-color: @github-diff-added-highlight;\n        }\n      }\n\n      &-deletion {\n        background-color: @github-diff-deleted;\n        &:before { content: "-"; }\n        .x {\n          background-color: @github-diff-deleted-highlight;\n        }\n      }\n    }\n\n    // These styles are mostly copied from the Primer tooltips\n    .tooltipped {\n      position: relative;\n\n      // This is the tooltip bubble\n      &::after {\n        position: absolute;\n        z-index: 1000000;\n        display: none;\n        width: max-content;\n        max-width: 22em;\n        padding: .5em .6em;\n        font-weight: 500;\n        color: @base-background-color;\n        text-align: center;\n        pointer-events: none;\n        content: attr(aria-label);\n        background: @background-color-info;\n        border-radius: @component-border-radius;\n      }\n\n      // This is the tooltip arrow\n      &::before {\n        position: absolute;\n        z-index: 1000001;\n        display: none;\n        width: 0;\n        height: 0;\n        color: @background-color-info;\n        pointer-events: none;\n        content: "";\n        border: 6px solid transparent;\n      }\n\n      // This will indicate when we\'ll activate the tooltip\n      &:hover,\n      &:active,\n      &:focus {\n        &::before,\n        &::after {\n          display: inline-block;\n          text-decoration: none;\n        }\n      }\n\n      // Tooltipped south\n      &::after {\n        top: 100%;\n        right: 50%;\n        margin-top: 6px;\n      }\n      &::before {\n        top: auto;\n        right: 50%;\n        bottom: -7px;\n        margin-right: -6px;\n        border-bottom-color: @background-color-info;\n      }\n\n      // Move the tooltip body to the center of the object.\n      &::after {\n        transform: translateX(50%);\n      }\n    }\n\n  }\n\n}\n',digest:"dec88bc582ca128c28366e197b5251a8ab0ac951"},"node_modules/github/styles/pr-commit-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import \'variables\';\n\n@default-padding: @component-padding;\n@avatar-dimensions: 16px;\n\n.github-PrCommitView {\n\n  &-container {\n    display: flex;\n    align-items: center;\n    padding: @default-padding;\n    font-size: @font-size;\n    border: 1px solid @base-border-color;\n    border-bottom: none;\n\n    &:first-child {\n      border-top-left-radius: @component-border-radius;\n      border-top-right-radius: @component-border-radius;\n    }\n\n    &:last-child {\n      border-bottom: 1px solid @base-border-color;\n      border-bottom-left-radius: @component-border-radius;\n      border-bottom-right-radius: @component-border-radius;\n    }\n  }\n\n  &-commit {\n    flex: 1;\n  }\n\n  &-messageHeadline.is-button {\n    padding: 0;\n    margin-right: @default-padding/1.5;\n    background-color: transparent;\n    border: none;\n    cursor: pointer;\n    text-align: left;\n    color: @text-color-highlight;\n\n    &:hover,\n    &:focus {\n      color: mix(@text-color-highlight, @text-color-subtle);\n    }\n  }\n\n  &-title {\n    margin: 0 0 .25em 0;\n    font-size: 1.2em;\n    line-height: 1.4;\n  }\n\n  &-avatar {\n    border-radius: @component-border-radius;\n    height: @avatar-dimensions;\n    margin-right: .4em;\n    width: @avatar-dimensions;\n  }\n\n  &-metaText {\n    line-height: @avatar-dimensions;\n    vertical-align: middle;\n    color: @text-color-subtle;\n  }\n\n  &-moreButton {\n    margin: 0 auto 0 @default-padding;\n    padding: 0em .2em;\n    color: @text-color-subtle;\n    font-style: italic;\n    font-size: .8em;\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n    background-color: @button-background-color;\n\n    &:hover {\n      background-color: @button-background-color-hover\n    }\n  }\n\n  &-moreText {\n    margin-top: @default-padding/2;\n    padding: 0;\n    font-size: inherit;\n    font-family: var(--editor-font-family);\n    word-wrap: initial;\n    word-break: break-word;\n    white-space: initial;\n    background-color: transparent;\n  }\n\n  &-sha {\n    margin-left: @default-padding;\n    line-height: @avatar-dimensions;\n    vertical-align: middle;\n    color: @text-color-info;\n    font-family: var(--editor-font-family);\n    a {\n      color: inherit;\n    }\n  }\n}\n',digest:"3d0e3fa00e0bad678850ac9cf8314a3c34114faf"},"node_modules/github/styles/pr-statuses.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import \'variables\';\n\n@donut-size: 26px;\n@donut-stroke: 4px;\n\n.github-PrStatuses {\n\n  &-header {\n    display: flex;\n    align-items: center;\n    border: 1px solid @base-border-color;\n    padding: @component-padding;\n    border-radius: @component-border-radius @component-border-radius 0 0;\n  }\n\n  &-donut-chart {\n    margin-right: @component-padding;\n\n    svg {\n      display: block;\n      width: @donut-size;\n      height: @donut-size;\n\n      circle {\n        cx: @donut-size/2;\n        cy: @donut-size/2;\n        r: @donut-size/2 - @donut-stroke/2;\n        stroke-width: @donut-stroke;\n      }\n    }\n  }\n\n  &-summary {\n    font-weight: bold;\n    flex: 1;\n  }\n\n  &-list {\n    display: flex;\n    flex-direction: column;\n    list-style: none;\n    padding: 0;\n    margin-bottom: 0;\n  }\n\n  &-list-item {\n    display: flex;\n    flex-direction: row;\n    padding: @component-padding/2 @component-padding;\n    border: 1px solid @base-border-color;\n    border-top: none;\n\n    &:last-child {\n      border-radius: 0 0 @component-border-radius @component-border-radius;\n    }\n\n    &-icon {\n      width: @donut-size;\n      margin-right: @component-padding;\n      text-align: center;\n      .icon::before { margin-right: 0; }\n    }\n\n    &-context {\n      flex: 1;\n      color: @text-color-subtle;\n      strong {\n        margin-right: .5em;\n        color: @text-color-highlight;\n      }\n    }\n\n    &-details-link {\n      margin-left: .5em;\n      a {\n        color: @text-color-info;\n      }\n    }\n  }\n\n\n  // States --------------------\n\n  &--warning {\n    color: @gh-background-color-yellow;\n  }\n\n  &--success {\n    color: @gh-background-color-green;\n  }\n\n  &--error {\n    color: @gh-background-color-red;\n  }\n}\n',digest:"364bdc49dd2b6cb2c78ccc0ccb9aae02d23aba92"},"node_modules/github/styles/pr-timeline.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import \'variables\';\n\n@avatar-size: 20px;\n\n.github-PrTimeline {\n  position: relative;\n  border-top: 1px solid mix(@text-color, @base-background-color, 15%);\n\n  // all items\n  .timeline-item {\n    padding: @component-padding*1.5 @component-padding*2;\n    padding-left:@component-padding * 4.5;\n    border-top: 1px solid mix(@text-color, @base-background-color, 15%);\n  }\n\n  .emoji,\n  g-emoji {\n    margin-right: .25em;\n  }\n\n\n  .author-avatar {\n    width: @avatar-size;\n    height: @avatar-size;\n    margin-right: 5px;\n    border-radius: @component-border-radius;\n  }\n\n  .open-commit-detail-button {\n    padding: 0;\n    background-color: transparent;\n    border: none;\n    &:hover,\n    &:focus {\n      color: @text-color-highlight;\n    }\n    &:active {\n      color: @text-color-subtle;\n    }\n  }\n\n  .pre-timeline-item-icon {\n    position: absolute;\n    margin-left: -@component-padding * 2.5;\n    text-align: center;\n    margin-top: 2px;\n    color: mix(@text-color, @base-background-color, 33%);\n    border-radius: 20px;\n  }\n\n  .commits {\n    .info-row {\n      margin-bottom: @component-padding;\n    }\n  }\n\n  .commit {\n    display: table-row;\n    align-items: center;\n    margin-left: @component-padding * 2;\n\n    &:first-child {\n      padding-top: @component-padding;\n    }\n\n    &:only-child {\n      padding-top: 0;\n      padding-bottom: 0;\n      margin-left: -@component-padding;\n    }\n\n    & + .issue {\n      margin-top: @component-padding/2;\n    }\n\n    .commit-author {\n      position: absolute;\n      display: flex;\n    }\n\n    .author-avatar {\n      @size: 20px;\n      position: relative;\n      margin-right: -@size + 4px;\n      width: @size;\n      height: @size;\n      border-radius: @component-border-radius;\n      background-color: mix(@text-color, @base-background-color, 15%);\n      box-shadow: 1px 0 @base-background-color;\n      transition: margin .12s cubic-bezier(.5,.1,0,1);\n\n      &:nth-child(1) { z-index: 3; }\n      &:nth-child(2) { z-index: 2; opacity: .7; }\n      &:nth-child(3) { z-index: 1; opacity: .4; }\n      &:nth-child(n+4) {\n        display: none;\n      }\n      &:only-child,\n      &:last-child {\n        box-shadow: none;\n      }\n    }\n\n    .commit-author:hover .author-avatar {\n      display: inline-block;\n      margin-right: 1px;\n      opacity: 1;\n    }\n\n    .commit-message-headline {\n      display: table-cell;\n      line-height: @avatar-size + 4px;\n      padding: 0 @component-padding/3;\n      padding-left: @avatar-size + @component-padding;\n      max-height: @avatar-size;\n      text-overflow: ellipsis;\n      white-space: nowrap;\n      overflow: hidden;\n      max-width: 0; // this makes sure the ellipsis work in table-cell\n      width: 100%;\n    }\n\n    .commit-sha {\n      display: table-cell;\n      text-align: right;\n      font-family: monospace;\n      padding-left: 5px;\n      color: @text-color-info;\n    }\n  }\n\n  .comment-message-header {\n    color: @text-color-subtle;\n    a {\n      color: inherit;\n    }\n  }\n\n  .cross-referenced-events {\n    // provides spacing between cross-referenced-event rows\n    border-spacing: 0 @component-padding / 2;\n\n    .info-row {\n      margin-bottom: @component-padding;\n    }\n  }\n\n  .cross-referenced-event {\n    display: table-row;\n\n    &:last-child {\n      margin-bottom: 0;\n    }\n\n    &-header {\n      color: @text-color-subtle;\n    }\n\n    &-label {\n      display: table-cell;\n      width: 100%;\n\n      &-title {\n        font-weight: bold;\n      }\n\n      &-number {\n        display: inline;\n        margin-left: 5px;\n        white-space: nowrap;\n        color: @text-color-subtle;\n      }\n    }\n\n    &-private {\n      display: table-cell;\n    }\n\n    &-state {\n      display: table-cell;\n      text-align: right;\n\n      .badge {\n        margin-left: 5px;\n      }\n    }\n  }\n\n  .sha {\n    font-family: monospace;\n  }\n\n  .merged-event {\n    display: flex;\n    align-items: center;\n    font-size: .9em;\n    line-height: 1.3;\n    color: @text-color-subtle;\n\n    .username,\n    .merge-ref {\n      font-weight: bold;\n      color: @text-color-highlight;\n    }\n  }\n\n  .merged-event ~ .issue {\n    border-bottom-style: dashed;\n  }\n\n  .head-ref-force-pushed-event {\n    .username {\n      font-weight: bold;\n      color: @text-color-highlight;\n    }\n    .sha {\n      font-weight: bold;\n    }\n  }\n\n  .issue {\n\n    .info-row {\n      margin-bottom: @component-padding/1.5;\n    }\n\n    .github-DotComMarkdownHtml {\n      pre > code {\n        white-space: pre;\n      }\n    }\n  }\n\n  &-loadMore {\n    margin: 20px auto 0;\n    text-align: center;\n  }\n\n}\n',digest:"2a689bdd6c49360b284b4f04c973dfb9e0615a73"},"node_modules/github/styles/push-pull-menu-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n.github-PushPullMenuView {\n\n  &-selector {\n    display: flex;\n    align-items: center;\n  }\n\n  &-item {\n    margin: @component-padding / 2;\n    &.is-flexible {\n      flex: 1;\n    }\n  }\n\n  // margin not needed, .github-PushPullMenuView-item takes care of the spacing\n  .icon-mark-github::before {\n    margin-right: 0;\n    color: @text-color-subtle;\n  }\n\n  // Make Pull/Push buttons take up available space\n  // since they\'re more important than Fetch\n  .btn-group {\n    display: flex;\n    .btn {\n      flex: 1;\n    }\n  }\n\n  // Removes flickering of the toolip if there is an icon inside\n  .btn-tooltip-wrapper .icon {\n    pointer-events: none;\n  }\n\n  &-message {\n    max-height: 4.8em;\n    margin: @component-padding / 2;\n    padding: @component-padding / 2;\n    line-height: 1.4;\n    white-space: normal;\n    text-align: left;\n    overflow-y: auto;\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n    background-color: @inset-panel-background-color;\n\n    &:empty {\n      display: none;\n    }\n  }\n\n\n  // Progress indicator\n  &.in-progress {\n    .icon-mark-github {\n      position: relative;\n      color: @text-color;\n      &:before {\n        color: inherit;\n      }\n      &:after {\n        content: "";\n        position: absolute;\n        top: -4px;\n        left: -4px;\n        width: 24px;\n        height: 24px;\n        border-top: 2px dotted;\n        border-right: 2px dotted;\n        border-bottom: 2px dotted transparent;\n        border-radius: 16px;\n\n        // To limit CPU usage, the animation plays for some time at normal speed,\n        // then slows down frame-rate for a while and stops at some point\n        -webkit-animation: github-PushPullMenuView-animation 2s linear 12,\n                           github-PushPullMenuView-animation 4s 24s steps(12) 100;\n      }\n    }\n  }\n}\n\n\n// Animations\n@-webkit-keyframes github-PushPullMenuView-animation {\n  100% { transform: rotate(360deg); }\n}\n',digest:"118a5da77647865a0ccc7dce4494103e94bf99cb"},"node_modules/github/styles/push-pull-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n// Used in the status-bar\n\n.github-PushPull {\n  &-icon.icon.icon.icon {\n    margin-right: 0;\n    text-align: center;\n  }\n\n  .secondary {\n      color: @text-color-subtle;\n  }\n\n}\n',digest:"a7601461ddd65091b36971bf6ec82ba26d7f63a5"},"node_modules/github/styles/recent-commits.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n// Recents commits\n// Shown under the commit message input\n\n@size: 16px; // make sure to double the size of the avatar in recent-commits-view.js to make it look crisp\n@show-max: 3; // how many commits should be shown\n\n.github-RecentCommits {\n  // Fit @show-max + 1px for the top border\n  max-height: @show-max * @size + @component-padding * @show-max + @component-padding + 1px;\n  overflow-x: hidden;\n  overflow-y: auto;\n  border-top: 1px solid @base-border-color;\n\n  &-list {\n    margin: 0;\n    padding: @component-padding/2 0;\n    list-style: none;\n  }\n\n  &-message {\n    padding: @component-padding/2 @component-padding;\n    text-align: center;\n    color: @text-color-subtle;\n  }\n}\n\n.github-RecentCommit {\n  position: relative;\n  display: flex;\n  align-items: center;\n  padding: 0 @component-padding;\n  line-height: @size + @component-padding;\n\n  &-authors {\n    position: absolute;\n    display: flex;\n  }\n\n  &-avatar {\n    position: relative;\n    margin-right: -@size + 3px;\n    width: @size;\n    height: @size;\n    border-radius: @component-border-radius;\n    background-color: mix(@text-color, @base-background-color, 15%);\n    box-shadow: 1px 0 @base-background-color;\n    transition: margin .12s cubic-bezier(.5,.1,0,1);\n\n    &:nth-child(1) { z-index: 3; }\n    &:nth-child(2) { z-index: 2; opacity: .7; }\n    &:nth-child(3) { z-index: 1; opacity: .4; }\n    &:nth-child(n+4) {\n      display: none;\n    }\n    &:only-child,\n    &:last-child {\n      box-shadow: none;\n    }\n  }\n\n  &-authors:hover .github-RecentCommit-avatar {\n    display: inline-block;\n    margin-right: 1px;\n    opacity: 1;\n  }\n\n  &-message {\n    flex: 1;\n    margin: 0 .5em;\n    margin-left: @size + @component-padding;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n    overflow: hidden;\n  }\n\n  &-undoButton.btn {\n    padding: 0 @component-padding/1.5;\n    margin-right: @component-padding/2;\n    height: @size * 1.25;\n    line-height: 1;\n    font-size: .9em;\n  }\n\n  &-time {\n    color: @text-color-subtle;\n  }\n\n  &:hover {\n    color: @text-color-highlight;\n    background: @background-color-highlight;\n  }\n\n  &.is-selected {\n    // is selected\n    color: @text-color-selected;\n    background: @background-color-selected;\n\n    // also has focus\n    .github-RecentCommits:focus & {\n      color: contrast(@button-background-color-selected);\n      background: @button-background-color-selected;\n    }\n  }\n\n}\n\n\n// Responsive\n// Show more commits if window height gets larger\n\n@media (min-height: 900px) {\n  .github-RecentCommits {\n    @show-max: 5;\n    max-height: @show-max * @size + @component-padding * @show-max + @component-padding + 1px;\n  }\n}\n\n@media (min-height: 1200px) {\n  .github-RecentCommits {\n    @show-max: 10;\n    max-height: @show-max * @size + @component-padding * @show-max + @component-padding + 1px;\n  }\n}\n',digest:"6b231265331f6e511f56b7b62d8a02264a20618c"},"node_modules/github/styles/resizer.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n.resizer-container {\n  height: 100%;\n  display: flex;\n\n  .sizing-handle, .content {\n    display: inline;\n  }\n\n  .sizing-handle {\n    position: absolute;\n    width: 8px;\n    top: 0;\n    bottom: 0;\n    left: -5px;\n    z-index: 3;\n    cursor: col-resize;\n  }\n}\n',digest:"36d765d44e0dbf2bed725bfacb3eb25a6ce9b732"},"node_modules/github/styles/staging-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n.github-StagingView {\n  flex: 1;\n  display: flex;\n  flex-direction: column;\n\n  &-group {\n    flex: 1;\n    display: flex;\n    flex-direction: column;\n  }\n\n  &-header {\n    display: flex;\n    align-items: center;\n    padding: 0 0 0 @component-padding;\n    font-weight: 600;\n    border-top: 1px solid @panel-heading-border-color;\n    border-bottom: 1px solid @panel-heading-border-color;\n\n    .github-UnstagedChanges > & {\n      border-top: none;\n    }\n\n    .icon {\n      text-align: center;\n      &:before {\n        color: @text-color-subtle;\n        margin-right: @component-padding / 1.2;\n        vertical-align: middle;\n      }\n    }\n  }\n\n  &-headerButton {\n    height: 2.5em;\n    border: none;\n    padding: 0 @component-padding;\n    font-weight: normal;\n    border-left: 1px solid @panel-heading-border-color;\n    white-space: nowrap;\n    background: none;\n    cursor: default;\n\n    &:disabled {\n      color: @text-color-subtle;\n    }\n\n    &:active {\n      background-color: @button-background-color-hover;\n    }\n\n    &.icon:before {\n      margin-right: 0;\n      font-size: 1em;\n      text-align: left;\n    }\n\n    &--fullWidth {\n      border-left: none;\n      border-bottom: 1px solid @panel-heading-border-color;\n    }\n\n    &--iconOnly:before {\n      width: auto;\n    }\n  }\n\n\n  &-title {\n    flex: 1;\n    margin-right: @component-padding;\n    line-height: 2.5em;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n  }\n\n  &-list {\n    flex: 1 1 0;\n    overflow-x: auto;\n  }\n}\n\n\n//\n// States\n// -----------------------------------------\n\n.github-StagingView-group-truncatedMsg {\n  padding: @component-padding / 2 @component-padding;\n}\n\n.github-StagingView-group.is-focused .is-selected {\n  // is selected\n  color: @text-color-selected;\n  background: @background-color-selected;\n\n  // also has focus\n  .github-StagingView:focus & {\n    color: contrast(@button-background-color-selected);\n    background: @button-background-color-selected;\n  }\n}\n',digest:"6199b2b5d3b6d5635fbef381b97f3168ea5f5372"},"node_modules/github/styles/status-bar-tile-controller.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n.github-StatusBarTileController {\n  display: inline-block;\n\n  &-tooltipMenu {\n    &.tooltip {\n      width: 400px; // Same as the github-Panel\n      padding-left: @component-padding;\n      padding-right: @component-padding;\n      box-sizing: border-box;\n    }\n    .tooltip-inner.tooltip-inner {\n      padding: @component-padding / 2;\n      background-color: @tool-panel-background-color;\n      border: 1px solid @base-border-color;\n      box-shadow: 0 4px 8px hsla(0, 0, 0, .1);\n      color: @text-color;\n    }\n    &.top .tooltip-arrow.tooltip-arrow {\n      width: @component-padding;\n      height: @component-padding;\n      border-width: 0 0 1px 1px;\n      border-color: @base-border-color;\n      background-color: @tool-panel-background-color;\n      border-bottom-right-radius: 2px;\n      transform: rotate(-45deg);\n    }\n  }\n\n  & > .inline-block:hover {\n    text-decoration: underline;\n    cursor: default;\n  }\n\n  @keyframes github-StatusBarAnimation-fade {\n      0% { opacity: 0; }\n      25% { opacity: 1; }\n      85% { opacity: 1; }\n      100% { opacity: 0; }\n  }\n\n  // Sync animation\n  .animate-rotate.github-PushPull-icon::before {\n    @keyframes github-StatusBarAnimation-rotate {\n      100% { transform: rotate(360deg); }\n    }\n    animation: github-StatusBarAnimation-rotate 1s linear infinite;\n  }\n\n  // Push animation\n  .animate-up.github-PushPull-icon::before {\n    @keyframes github-StatusBarAnimation-up {\n      0% { transform: translateY(40%); }\n      100% { transform: translateY(-20%); }\n    }\n    animation:\n        github-StatusBarAnimation-up 800ms ease-out infinite,\n        github-StatusBarAnimation-fade 800ms ease-out infinite;\n  }\n\n  // Pull animation\n  .animate-down.github-PushPull-icon::before {\n    @keyframes github-StatusBarAnimation-down {\n        0% { transform: translateY(-20%); }\n        100% { transform: translateY(40%); }\n    }\n    animation:\n        github-StatusBarAnimation-down 800ms ease-out infinite,\n        github-StatusBarAnimation-fade 800ms ease-out infinite;\n  }\n\n  // Merge conflict icon\n  .github-ChangedFilesCount .icon-alert {\n    margin-left: @component-padding / 2;\n  }\n\n  .github-branch-detached {\n    color: @text-color-subtle;\n    font-style: italic;\n  }\n}\n',digest:"d7675d13adeca6cd1d5b0946ec343bb80f6e3117"},"node_modules/github/styles/timings-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "variables";\n\n.github-GitTimingsView {\n  width: 100%;\n  height: 100%;\n  overflow: auto;\n\n  &-header {\n    display: flex;\n    justify-content: flex-end;\n    padding: @component-padding;\n    border-bottom: 1px solid @base-border-color;\n  }\n\n  .waterfall-widget {\n    border-radius: @component-border-radius;\n    border: 1px solid @pane-item-border-color;\n    background-color: @pane-item-background-color;\n    margin: 10px;\n  }\n\n  .waterfall-header {\n    padding: 5px 5px 0 5px;\n    color: @text-color;\n    font-size: @font-size;\n    display: flex;\n    border-bottom: 1px solid @pane-item-border-color;\n\n    .collapse-toggle {\n      cursor: pointer;\n      margin-right: 2px;\n    }\n\n    &-text {\n      flex: 1;\n    }\n\n    &-controls {\n      flex-basis: 250px;\n      display: flex;\n      align-items: center;\n    }\n  }\n\n  .waterfall-export-button {\n    margin: 0 10px 3px 0;\n  }\n\n  .waterfall-scroller {\n    overflow: auto;\n  }\n\n  .waterfall-container {\n    position: relative;\n    display: inline-block; // stretches to childs width\n    min-width: 100%;\n  }\n\n  .waterfall-time-marker {\n    position: absolute;\n    height: 100%;\n    width: 1px;\n    border-left: 1px solid @pane-item-border-color;\n  }\n\n  .waterfall-timeline {\n    position: relative;\n    margin: 5px 0;\n  }\n\n  .waterfall-timeline-label {\n    position: absolute;\n    padding-left: 5px;\n    color: @text-color;\n  }\n\n  .waterfall-row {\n    position: relative;\n    min-height: 15px;\n    padding: 2px 0;\n\n    &:nth-child(2n+1) {\n      background-color: @app-background-color;\n    }\n\n    &:hover {\n      background-color: @pane-item-border-color;\n    }\n  }\n\n  .waterfall-row-label {\n    position: relative;\n    margin: 0 5px;\n    white-space: nowrap;\n  }\n\n  .waterfall-marker {\n    position: absolute;\n    top: 2px;\n    bottom: 2px;\n  }\n\n  .waterfall-marker-section {\n    display: inline-block;\n    position: relative;\n    height: 100%;\n    vertical-align: top;\n  }\n}\n',digest:"e35a7ff8f4c72b7ab63447c07b852019f211be3f"},"node_modules/github/styles/user-mention-tooltip.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import \'variables\';\n\n.github-UserMentionTooltip {\n  display: flex;\n\n  &-avatar {\n    margin: @component-padding/2;\n\n    > img {\n      width: 60px;\n      height: 60px;\n      border-radius: @component-border-radius;\n    }\n  }\n\n  &-info {\n    flex: 1;\n    display: flex;\n    flex-direction: column;\n    justify-content: center;\n    margin: @component-padding/2 @component-padding;\n    font-size: @font-size;\n    line-height: 20px;\n    text-align: left;\n\n    > div {\n      white-space: nowrap;\n    }\n    .icon {\n      color: @text-color-subtle;\n      vertical-align: middle;\n    }\n\n    &-username {\n      font-size: 1.2em;\n      strong {\n        font-weight: 600;\n      }\n    }\n  }\n}\n',digest:"81578e2f3e4a06a29558e0c547bb84e082bc9b51"},"node_modules/github/styles/variables.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n@import "syntax-variables";\n\n@gh-background-color-blue: #006eeb;\n@gh-background-color-light-blue: #dbedff;\n@gh-background-color-yellow: #ffd93d;\n@gh-background-color-red: #dc3545;\n@gh-background-color-purple: #6f42c1;\n@gh-background-color-green: #28a745;\n\n\n// diff colors -----------------\n// Needs to be semi transparent to make it work with selections and different themes\n\n@github-diff-deleted:           fade(hsl(353, 100%, 66%), 15%); // similar to .com\'s hsl(353, 100%, 97%)\n@github-diff-added:             fade(hsl(137, 100%, 55%), 15%); // similar to .com\'s hsl(137, 100%, 95%)\n\n@github-diff-deleted-highlight: fade(hsl(353, 95%, 66%), 25%); // similar to .com\'s hsl(353, 95%, 86%)\n@github-diff-added-highlight:   fade(hsl(135, 73%, 55%), 25%); // similar to .com\'s hsl(135, 73%, 81%)\n',digest:"c9eb75db5f3647898c9605e16775cc8ffcadf55e"},"node_modules/git-diff/styles/git-diff.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "syntax-variables";\n@import "octicon-utf-codes";\n@import "octicon-mixins";\n\natom-text-editor {\n  .gutter .line-number {\n    &.git-line-modified {\n      border-left: 2px solid @syntax-color-modified;\n      padding-left: ~"calc(0.5em - 2px)";\n    }\n\n    &.git-line-added {\n      border-left: 2px solid @syntax-color-added;\n      padding-left: ~"calc(0.5em - 2px)";\n    }\n\n    @size: 4px;\n    &.git-line-removed:before,\n    &.git-previous-line-removed:before {\n      position: absolute;\n      left: 0;\n      height: 0;\n      width: 0;\n      content: " ";\n      border: solid transparent;\n      border-left-color: @syntax-color-removed;\n      border-width: @size;\n      margin-top: -@size;\n      pointer-events: none;\n    }\n    &.git-line-removed:before {\n      bottom: -@size;\n    }\n    &.git-previous-line-removed:before {\n      top: 0;\n    }\n  }\n\n  .gutter.git-diff-icon .line-number {\n    width: 100%;\n    border-left: none;\n    padding-left: 0.4em;\n\n    &:before {\n     .octicon-font();\n      display: inline-block;\n      position: relative;\n      top: -.05em;\n\n      // make sure it doesnt affect the gutter line height.\n      height: 0px;\n      width: 1em;\n      content: " ";\n      padding-right: 0.4em;\n      font-size: .95em;\n    }\n\n    &.git-line-modified:before {\n      content: @primitive-dot;\n      color: @syntax-color-modified;\n    }\n\n    &.git-line-added:before {\n      content: @plus;\n      color: @syntax-color-added;\n    }\n\n    &.git-line-removed:before,\n    &.git-previous-line-removed:before {\n      border: none; // reset triangle\n      content: @dash;\n      color: @syntax-color-removed;\n      position: relative;\n    }\n    &.git-line-removed:before {\n      top: .6em;\n    }\n    &.git-previous-line-removed:before {\n      top: -.6em;\n    }\n  }\n}\n',digest:"7fcdbf299bd40409216561eb947aa59ad64ac64a"},"node_modules/grammar-selector/styles/grammar-selector.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n.grammar-status a,\n.grammar-status a:hover {\n  color: @text-color;\n}\n',digest:"b23e8d5530f94d34c75f7500027d8dca5a25f02e"},"node_modules/image-view/styles/image-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n@spacing: @component-padding/2;\n@transparent-background-image: "atom://image-view/images/transparent-background.png";\n\n.image-view {\n  display: flex;\n  flex-direction: column;\n  background-color: @pane-item-background-color;\n  user-select: none;\n\n\n  // Image Controls -------------------\n\n  .image-controls {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    flex-wrap: wrap;\n    padding: @spacing;\n    border-bottom: 1px solid @panel-heading-border-color;\n    background-color: @panel-heading-background-color;\n\n    a {\n      display: inline-block;\n      position: relative;\n      width: 24px;\n      height: 24px;\n      margin: @spacing;\n      vertical-align: middle;\n      font-size: 0;\n      border-radius: 22px;\n      border: 2px solid #fff;\n      box-shadow: inset 0 1px 2px hsla(0,0%,0%,.4), 0 0 0 1px hsla(0,0%,0%,.1), 0 2px 2px hsla(0,0%,0%,.2);\n      background-clip: content-box;\n\n      &:hover {\n        border-color: #ccc;\n      }\n      &:active {\n        border-color: #999;\n      }\n    }\n\n    &-color-white {\n      color: #000;\n      background-color: #fff;\n      background-image: url(@transparent-background-image);\n    }\n\n    &-color-black {\n      color: #fff;\n      background-color: #000;\n      background-image: url(@transparent-background-image);\n    }\n\n    .btn-group {\n      margin: @spacing;\n    }\n\n    .reset-zoom-button {\n      min-width: 5em;\n    }\n\n    // disabled once the button is selected\n    .zoom-to-fit-button.selected {\n      pointer-events: none;\n      cursor: default;\n    }\n  }\n\n\n  // Image -------------------\n\n  .image-container {\n    flex: 1 1 0;\n    display: flex;\n    overflow: auto;\n\n    img {\n      flex: none;\n      margin: auto;\n    }\n  }\n\n  // Background color\n  [background="white"] {\n    background-color: white;\n    background-image: url(@transparent-background-image);\n  }\n  [background="black"] {\n    background-color: black;\n    background-image: url(@transparent-background-image);\n  }\n\n\n\n  // Zoom to fit -------------------\n  // Scales the image to fit the available space.\n\n  .zoom-to-fit {\n    &.image-container {\n      padding: @component-padding;\n\n      img {\n        flex: 1 1 0;\n        min-width: 0;\n        margin: 0;\n\n        // Alternative: object-fit: contain;\n        // then it would also scale larger than its original size\n        object-fit: scale-down;\n      }\n    }\n  }\n\n}\n',digest:"fe093fe40c0bc74d4cf7441cdfecf9d0253e4c53"},"node_modules/incompatible-packages/styles/incompatible-packages.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n.incompatible-packages {\n  background-color: @pane-item-background-color;\n  overflow-y: scroll;\n\n  .incompatible-package {\n    padding: 15px;\n    margin-bottom: 10px;\n    border-radius: 6px;\n    border: 1px solid #d1d1d2;\n    background-color: #fafafa;\n    overflow: hidden;\n\n    .badge {\n      margin-left: 1em;\n    }\n\n    .heading {\n      margin-top: 0px;\n    }\n\n    ul {\n      padding-left: 1em;\n    }\n\n    li {\n      list-style-type: none;\n    }\n\n    pre {\n      margin-top: 2em;\n      max-height: 25em;\n      overflow: scroll;\n      color: @text-color-error;\n    }\n  }\n}\n\n.incompatible-packages-status {\n  padding-left: 2px;\n}\n',digest:"9388e1cd27b0b0fd67e21bdbc809d996b8d27706"},"node_modules/keybinding-resolver/styles/keybinding-resolver.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n@import "octicon-mixins";\n\n.key-binding-resolver {\n  -webkit-flex: 0.25;\n  overflow: auto;\n\n  .keystroke {\n    margin-right: 1em;\n  }\n\n  table {\n    .used {\n      color: @text-color-success;\n    }\n\n    .unused {\n      color: @text-color;\n    }\n\n    .unmatched {\n      color: @text-color-subtle;\n    }\n\n    .used .command, .unused .command{\n      .octicon(check);\n    }\n\n    .unmatched .command {\n      .octicon(x);\n    }\n\n    .command, .selector, .source {\n      min-width: 10em;\n    }\n\n    .source {\n      cursor: pointer;\n    }\n  }\n}\n',digest:"a25a3b8c740ed552295164442b4ff8d8d1515f52"},"node_modules/markdown-preview/assets/primer-markdown.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n// All of our block level items should have the same margin\n@margin: 16px;\n\n// This is styling for generic markdownized text. Anything you put in a\n// container with .markdown-body on it should render generally well. It also\n// includes some GitHub Flavored Markdown specific styling (like @mentions)\n.markdown-body {\n  overflow: hidden;\n  font-family: "Helvetica Neue", Helvetica, "Segoe UI", Arial, freesans, sans-serif;\n  font-size: 16px;\n  line-height: 1.6;\n  word-wrap: break-word;\n\n  > *:first-child {\n    margin-top: 0 !important;\n  }\n\n  > *:last-child {\n    margin-bottom: 0 !important;\n  }\n\n  // Anchors like <a name="examples">. These sometimes end up wrapped around\n  // text when users mistakenly forget to close the tag or use self-closing tag\n  // syntax. We don\'t want them to appear like links.\n  // FIXME: a:not(:link):not(:visited) would be a little clearer here (and\n  // possibly faster to match), but it breaks styling of <a href> elements due\n  // to https://bugs.webkit.org/show_bug.cgi?id=142737.\n  a:not([href]) {\n    color: inherit;\n    text-decoration: none;\n  }\n\n  // Link Colors\n  .absent {\n    color: #c00;\n  }\n\n  .anchor {\n    position: absolute;\n    top: 0;\n    left: 0;\n    display: block;\n    padding-right: 6px;\n    padding-left: 30px;\n    margin-left: -30px;\n\n    &:focus {\n      outline: none;\n    }\n  }\n\n  // Headings\n  h1, h2, h3, h4, h5, h6 {\n    position: relative;\n    margin-top: 1em;\n    margin-bottom: @margin;\n    font-weight: bold;\n    line-height: 1.4;\n\n    .octicon-link {\n      display: none;\n      color: #000;\n      vertical-align: middle;\n    }\n\n    &:hover .anchor {\n      padding-left: 8px;\n      margin-left: -30px;\n      text-decoration: none;\n\n      .octicon-link {\n        display: inline-block;\n      }\n    }\n\n    tt,\n    code {\n      font-size: inherit;\n    }\n  }\n\n  h1 {\n    padding-bottom: 0.3em;\n    font-size: 2.25em;\n    line-height: 1.2;\n    border-bottom: 1px solid #eee;\n\n    .anchor {\n      line-height: 1;\n    }\n  }\n\n  h2 {\n    padding-bottom: 0.3em;\n    font-size: 1.75em;\n    line-height: 1.225;\n    border-bottom: 1px solid #eee;\n\n    .anchor {\n      line-height: 1;\n    }\n  }\n\n  h3 {\n    font-size: 1.5em;\n    line-height: 1.43;\n\n    .anchor {\n      line-height: 1.2;\n    }\n  }\n\n  h4 {\n    font-size: 1.25em;\n\n    .anchor {\n      line-height: 1.2;\n    }\n  }\n\n  h5 {\n    font-size: 1em;\n\n    .anchor {\n      line-height: 1.1;\n    }\n  }\n\n  h6 {\n    font-size: 1em;\n    color: #777;\n\n    .anchor {\n      line-height: 1.1;\n    }\n  }\n\n  p,\n  blockquote,\n  ul, ol, dl,\n  table,\n  pre {\n    margin-top: 0;\n    margin-bottom: @margin;\n  }\n\n  hr {\n    height: 4px;\n    padding: 0;\n    margin: @margin 0;\n    background-color: #e7e7e7;\n    border: 0 none;\n  }\n\n  // Lists, Blockquotes & Such\n  ul,\n  ol {\n    padding-left: 2em;\n\n    &.no-list {\n      padding: 0;\n      list-style-type: none;\n    }\n  }\n\n  // Did someone complain about list spacing? Encourage them\n  // to create the spacing with their markdown formatting.\n  // List behavior should be controled by the markup, not the css.\n  //\n  // For lists with padding between items, use blank\n  // lines between items. This will generate paragraphs with\n  // padding to space things out.\n  //\n  // - item\n  //\n  // - item\n  //\n  // - item\n  //\n  // For list without padding, don\'t use blank lines.\n  //\n  // - item\n  // - item\n  // - item\n  //\n  // Modifying the css to emulate these behaviors merely brakes\n  // one case in the process of solving another. Don\'t change\n  // this unless it\'s really really a bug.\n  ul ul,\n  ul ol,\n  ol ol,\n  ol ul {\n    margin-top: 0;\n    margin-bottom: 0;\n  }\n\n  li > p {\n    margin-top: @margin;\n  }\n\n  dl {\n    padding: 0;\n  }\n\n  dl dt {\n    padding: 0;\n    margin-top: @margin;\n    font-size: 1em;\n    font-style: italic;\n    font-weight: bold;\n  }\n\n  dl dd {\n    padding: 0 @margin;\n    margin-bottom: @margin;\n  }\n\n  blockquote {\n    padding: 0 15px;\n    color: #777;\n    border-left: 4px solid #ddd;\n\n    > :first-child {\n      margin-top: 0;\n    }\n\n    > :last-child {\n      margin-bottom: 0;\n    }\n  }\n\n  // Tables\n  table {\n    display: block;\n    width: 100%;\n    overflow: auto;\n    word-break: normal;\n    word-break: keep-all; // For Firefox to horizontally scroll wider tables.\n\n    th {\n      font-weight: bold;\n    }\n\n    th, td {\n      padding: 6px 13px;\n      border: 1px solid #ddd;\n    }\n\n    tr {\n      background-color: #fff;\n      border-top: 1px solid #ccc;\n\n      &:nth-child(2n) {\n        background-color: #f8f8f8;\n      }\n    }\n  }\n\n  // Images & Stuff\n  img {\n    max-width: 100%;\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n  }\n\n  .emoji {\n    max-width: none;\n  }\n\n  // Gollum Image Tags\n\n  // Framed\n  span.frame {\n    display: block;\n    overflow: hidden;\n\n    & > span {\n      display: block;\n      float: left;\n      width: auto;\n      padding: 7px;\n      margin: 13px 0 0;\n      overflow: hidden;\n      border: 1px solid #ddd;\n    }\n\n    span img {\n      display: block;\n      float: left;\n    }\n\n    span span {\n      display: block;\n      padding: 5px 0 0;\n      clear: both;\n      color: #333;\n    }\n  }\n\n  span.align-center {\n    display: block;\n    overflow: hidden;\n    clear: both;\n\n    & > span {\n      display: block;\n      margin: 13px auto 0;\n      overflow: hidden;\n      text-align: center;\n    }\n\n    span img {\n      margin: 0 auto;\n      text-align: center;\n    }\n  }\n\n  span.align-right {\n    display: block;\n    overflow: hidden;\n    clear: both;\n\n    & > span {\n      display: block;\n      margin: 13px 0 0;\n      overflow: hidden;\n      text-align: right;\n    }\n\n    span img {\n      margin: 0;\n      text-align: right;\n    }\n  }\n\n  span.float-left {\n    display: block;\n    float: left;\n    margin-right: 13px;\n    overflow: hidden;\n\n    span {\n      margin: 13px 0 0;\n    }\n  }\n\n  span.float-right {\n    display: block;\n    float: right;\n    margin-left: 13px;\n    overflow: hidden;\n\n    & > span {\n      display: block;\n      margin: 13px auto 0;\n      overflow: hidden;\n      text-align: right;\n    }\n  }\n\n  // Inline code snippets\n  code,\n  tt {\n    padding: 0;\n    padding-top: 0.2em;\n    padding-bottom: 0.2em;\n    margin: 0;\n    font-size: 85%;\n    background-color: rgba(0,0,0,0.04);\n    border-radius: 3px; // don\'t add padding, gives scrollbars\n\n    &:before,\n    &:after {\n      letter-spacing: -0.2em; // this creates padding\n      content: "\\00a0";\n    }\n\n    br { display: none; }\n  }\n\n  del code { text-decoration: inherit; }\n\n  // Code tags within code blocks (<pre>s)\n  pre > code {\n    padding: 0;\n    margin: 0;\n    font-size: 100%;\n    word-break: normal;\n    white-space: pre;\n    background: transparent;\n    border: 0;\n  }\n\n  .highlight {\n    margin-bottom: @margin;\n  }\n\n  .highlight pre,\n  pre {\n    padding: @margin;\n    overflow: auto;\n    font-size: 85%;\n    line-height: 1.45;\n    background-color: #f7f7f7;\n    border-radius: 3px;\n  }\n\n  .highlight pre {\n    margin-bottom: 0;\n    word-break: normal;\n  }\n\n  pre {\n    word-wrap: normal;\n  }\n\n  pre code,\n  pre tt {\n    display: inline;\n    max-width: initial;\n    padding: 0;\n    margin: 0;\n    overflow: initial;\n    line-height: inherit;\n    word-wrap: normal;\n    background-color: transparent;\n    border: 0;\n\n    &:before,\n    &:after {\n      content: normal;\n    }\n  }\n\n  kbd {\n    display: inline-block;\n    padding: 3px 5px;\n    font-size: 11px;\n    line-height: 10px;\n    color: #555;\n    vertical-align: middle;\n    background-color: #fcfcfc;\n    border: solid 1px #ccc;\n    border-bottom-color: #bbb;\n    border-radius: 3px;\n    box-shadow: inset 0 -1px 0 #bbb;\n  }\n}\n',digest:"34042e121a602019f7f5984cacf079bd171c002c"},"node_modules/markdown-preview/styles/markdown-preview-default.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// Default Markdown Preview styles\n\n// These are the default Markdown Preview styles.\n// They use the syntax-variables to adapt to the color scheme of syntax themes.\n\n\n@import "syntax-variables";\n\n.markdown-preview:not([data-use-github-style]) {\n\n  @fg: @syntax-text-color;\n  @bg: @syntax-background-color;\n\n  @fg-accent: @syntax-cursor-color;\n  @fg-strong: contrast(@bg, darken(@fg, 32%), lighten(@fg, 32%));\n  @fg-subtle: contrast(@fg, lighten(@fg, 16%), darken(@fg, 16%));\n\n  @border: contrast(@bg, lighten(@bg, 16%), darken(@bg, 16%));\n\n  @margin: 1.5em;\n\n\n  padding: 2em;\n  font-size: 1.2em;\n  color: @fg;\n  background-color: @bg;\n  overflow: auto;\n\n  & > :first-child {\n    margin-top: 0;\n  }\n\n\n  // Headings --------------------\n\n  h1, h2, h3, h4, h5, h6 {\n    line-height: 1.2;\n    margin-top: @margin;\n    margin-bottom: @margin/3;\n    color: @fg-strong;\n  }\n\n  h1 { font-size: 2.4em; font-weight: 300; }\n  h2 { font-size: 1.8em; font-weight: 400; }\n  h3 { font-size: 1.5em; font-weight: 500; }\n  h4 { font-size: 1.2em; font-weight: 600; }\n  h5 { font-size: 1.1em; font-weight: 600; }\n  h6 { font-size: 1.0em; font-weight: 600; }\n\n\n  // Emphasis --------------------\n\n  strong {\n    color: @fg-strong;\n  }\n\n  del {\n    color: @fg-subtle;\n  }\n\n\n  // Link --------------------\n\n  a,\n  a code {\n    color: @fg-accent;\n  }\n\n\n  // Images --------------------\n\n  img {\n    max-width: 100%;\n  }\n\n\n  // Paragraph --------------------\n\n  & > p {\n    margin-top: 0;\n    margin-bottom: @margin;\n  }\n\n\n  // List --------------------\n\n  & > ul,\n  & > ol {\n    margin-bottom: @margin;\n  }\n\n\n  // Blockquotes --------------------\n\n  blockquote {\n    margin: @margin 0;\n    font-size: inherit;\n    color: @fg-subtle;\n    border-color: @border;\n    border-width: 4px;\n  }\n\n\n  // HR --------------------\n\n  hr {\n    margin: @margin*2 0;\n    border-top: 2px dashed @border;\n    background: none;\n  }\n\n\n  // Table --------------------\n\n  table {\n    margin: @margin 0;\n  }\n\n  th {\n    color: @fg-strong;\n  }\n\n  th,\n  td {\n    padding: .66em 1em;\n    border: 1px solid @border;\n  }\n\n\n  // Code --------------------\n\n  code {\n    color: @fg-strong;\n    background-color: contrast(@syntax-background-color, lighten(@syntax-background-color, 8%), darken(@syntax-background-color, 6%));\n  }\n\n  atom-text-editor {\n    margin: @margin 0;\n    padding: 1em;\n    font-size: .92em;\n    border-radius: 3px;\n    background-color: contrast(@syntax-background-color, lighten(@syntax-background-color, 4%), darken(@syntax-background-color, 4%));\n  }\n\n\n  // KBD --------------------\n\n  kbd {\n    color: @fg-strong;\n    border: 1px solid @border;\n    border-bottom: 2px solid darken(@border, 6%);\n    background-color: contrast(@syntax-background-color, lighten(@syntax-background-color, 8%), darken(@syntax-background-color, 6%));\n  }\n\n}\n',digest:"a812c45bf13bc5cfb9b4050eb8eb9214071ab015"},"node_modules/markdown-preview/styles/markdown-preview-github.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// GitHub.com styles\n\n// These are the GitHub Flavored Markdown styles also found on github.com.\n// They can be anabled in the markdown-preview settings by turning on "Use GitHub.com styles".\n\n\n@import (reference) "../assets/primer-markdown";\n\n.markdown-preview[data-use-github-style] {\n\n  // Includes GitHub.com styles from `../assets/primer-markdown.less`.\n  // Source: https://github.com/primer/primer/tree/master/modules/primer-markdown\n  .markdown-body();\n\n\n  // The styles below override/complement the GitHub.com styles\n  // It\'s needed because some markup or global styles are different\n  padding: 30px;\n  font-size: 16px;\n  color: #333;\n  background-color: #fff;\n  overflow: scroll;\n\n  a {\n    color: #337ab7;\n  }\n\n  code {\n    color: inherit;\n  }\n\n  atom-text-editor {\n    padding: .8em 1em;\n    margin-bottom: 1em;\n    font-size: .85em;\n    border-radius: 4px;\n    overflow: auto;\n  }\n}\n',digest:"c67859df748822544c162c72e16789389564983c"},"node_modules/markdown-preview/styles/markdown-preview.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// Global Markdown Preview styles\n\n.markdown-preview {\n  atom-text-editor {\n    // only show scrollbars on hover\n    .scrollbars-visible-always & {\n      .vertical-scrollbar,\n      .horizontal-scrollbar {\n        visibility: hidden;\n      }\n    }\n    .scrollbars-visible-always &:hover {\n      .vertical-scrollbar,\n      .horizontal-scrollbar {\n        visibility: visible;\n      }\n    }\n    user-select: auto;\n  }\n\n  // move task list checkboxes\n  .task-list-item-checkbox {\n    position: absolute;\n    margin: .25em 0 0 -1.4em;\n  }\n\n  // hide bullet for task lists\n  // TODO: Use more specific selector once https://github.com/gjtorikian/task-lists-js/issues/5 gets fixed\n  ul label {\n    vertical-align: top;\n  }\n}\n\n.markdown-spinner {\n  margin: auto;\n  background-image: url(images/octocat-spinner-128.gif);\n  background-repeat: no-repeat;\n  background-size: 64px;\n  background-position: top center;\n  padding-top: 70px;\n  text-align: center;\n}\n',digest:"3623f0ca19c733f15bdf23a92cf5cf9522c0a8ca"},"node_modules/notifications/styles/notifications-log.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n@import "octicon-mixins";\n\n@icon-size: 30px;\n@font-family-monospace: Consolas, "Liberation Mono", Menlo, Courier, monospace;\n\n.notifications-log {\n  display: flex;\n  flex-direction: column;\n  min-width: 200px;\n\n  header {\n    flex: none;\n    background-color: @base-background-color;\n    border-bottom: 1px solid @base-border-color;\n\n    .notification-type {\n      border: none;\n      width: @icon-size;\n      height: @icon-size;\n      margin: 1px;\n      padding: 0;\n      color: @text-color-subtle;\n      opacity: .5;\n      background: @base-background-color;\n    }\n  }\n\n  .notifications-log-items  {\n    flex: auto;\n    list-style: none;\n    padding: 0;\n    margin: 0;\n    overflow: auto;\n\n    .notifications-log-item {\n      display: flex;\n      box-sizing: content-box; // Keep spacing even\n      border-bottom: 1px solid @base-border-color;\n      max-height: @icon-size;\n      overflow: hidden;\n\n      .notifications-log-notification {\n        flex: auto;\n        display: flex;\n        position: relative;\n        padding-left: @icon-size;\n        overflow: hidden;\n\n        &.icon:before {\n          position: absolute;\n          top: 0;\n          left: 0;\n          bottom: 0;\n          width: @icon-size;\n          height: 100%;\n          padding-top: @component-padding/2;\n          text-align: center;\n        }\n\n        .message {\n          flex: 0 1 auto;\n          word-wrap: break-word;\n          padding: @component-padding/2 @component-padding;\n          border-left: 1px solid @base-border-color;\n        }\n\n        .btn-toolbar {\n          flex: 1 0 auto;\n          display: flex;\n          align-items: center;\n          white-space: nowrap;\n\n          &:empty {\n            display: none;\n          }\n\n          .btn-copy-report {\n            vertical-align: middle;\n            margin-left: @component-padding/2;\n\n            &::before {\n              margin: 0;\n            }\n          }\n        }\n      }\n\n      .timestamp {\n        flex: 0 0 auto;\n        white-space: nowrap;\n        text-align: center;\n        line-height: @icon-size;\n        padding: 0 @component-padding;\n      }\n    }\n  }\n\n}\n\n// Types -------------------------------\n\n.notifications-log {\n\n  // fatal\n  .notification-type.fatal {\n    .type(@text-color-error; @background-color-error);\n  }\n\n  .hide-fatal li.fatal {\n    display: none;\n  }\n\n  .notifications-log-notification.fatal {\n    .log(@text-color-error; @background-color-error);\n  }\n\n  // error\n  .notification-type.error {\n    .type(@text-color-error; @background-color-error);\n  }\n\n  .hide-error li.error {\n    display: none;\n  }\n\n  .notifications-log-notification.error {\n    .log(@text-color-error; @background-color-error);\n  }\n\n  // warning\n  .notification-type.warning {\n    .type(@text-color-warning; @background-color-warning);\n  }\n\n  .hide-warning li.warning {\n    display: none;\n  }\n\n  .notifications-log-notification.warning {\n    .log(@text-color-warning; @background-color-warning);\n  }\n\n  // info\n  .notification-type.info {\n    .type(@text-color-info; @background-color-info);\n  }\n\n  .hide-info li.info {\n    display: none;\n  }\n\n  .notifications-log-notification.info {\n    .log(@text-color-info; @background-color-info);\n  }\n\n  // success\n  .notification-type.success {\n    .type(@text-color-success; @background-color-success);\n  }\n\n  .hide-success li.success {\n    display: none;\n  }\n\n  .notifications-log-notification.success {\n    .log(@text-color-success; @background-color-success);\n  }\n\n}\n\n// Type Mixin\n\n.type(@txt; @bg) {\n  &.show-type {\n    color: @txt;\n    opacity: 1;\n  }\n}\n\n.log(@txt; @bg) {\n  .message {\n    color: lighten(@txt, 0%);\n  }\n\n  &.icon:before {\n    color: @txt;\n  }\n}\n',digest:"547af188df482ab9d735154eec4177e43955bae6"},"node_modules/notifications/styles/notifications.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n@import "octicon-mixins";\n\n@icon-size: 30px;\n@width: 450px;\n@width-detail: 450px;\n@max-height-message: 200px;\n@max-height-detail: 500px;\n@max-height: @max-height-message + @max-height-detail + 100px; // 100px for footer. This is only used for the closing animation\n@notification-gap: 2px;\n@font-family-monospace: Consolas, "Liberation Mono", Menlo, Courier, monospace;\n\natom-notifications {\n  display: block;\n  z-index: 1000; // TODO: Have some convention about z-index stacking\n  position: absolute;\n  top: 35px;\n  right: 0;\n  bottom: 0;\n  padding: @component-padding;\n  font-size: 1.2em;\n  overflow-x: hidden;\n  overflow-y: auto;\n  pointer-events: none;\n  &::-webkit-scrollbar {\n    display: none;\n  }\n\n  atom-notification {\n    .close-all {\n      display: none;\n    }\n  }\n\n  atom-notification:first-child {\n    .close-all {\n      display: block;\n    }\n    .message {\n      padding-right: @component-padding * 2 + 95px; // space for icon and button\n    }\n  }\n\n  atom-notification:only-child {\n    .close-all {\n      display: none;\n    }\n    .message {\n      padding-right: inherit;\n    }\n    &.has-close .message {\n      padding-right: @component-padding + 24px; // space for icon\n    }\n  }\n\n  atom-notification {\n    float: right;\n    clear: right;\n    position: relative;\n    width: @width;\n    padding-left: @icon-size;\n    margin-bottom: @notification-gap;\n    max-height: @max-height;\n    word-wrap: break-word;\n    pointer-events: auto;\n\n    &.icon:before {\n      position: absolute;\n      top: 0;\n      left: 0;\n      width: @icon-size;\n      height: 100%;\n      padding-top: @component-padding;\n      text-align: center;\n      border-radius: @component-border-radius 0 0 @component-border-radius;\n    }\n\n\n    // fill space between notifiactions to prevent click throughs\n    &:after {\n      content: "";\n      display: block;\n      position: absolute;\n      left: 0;\n      right: 0;\n      bottom: -@notification-gap;\n      height: @notification-gap;\n    }\n\n    .meta,\n    .close,\n    .detail,\n    .stack-toggle,\n    .stack-container {\n      display: none;\n    }\n\n    &.fatal .meta,\n    &.has-description .meta,\n    &.has-buttons .meta,\n    &.has-close .close,\n    &.has-detail .detail,\n    &.has-stack .stack-toggle,\n    &.has-stack .stack-container {\n      display: block;\n    }\n\n    // .item\'s are used as general containers\n    .item {\n      padding: @component-padding;\n      border-top: 1px solid hsla(0,0%,0%,.1);\n      &.message {\n        border-top: none;\n        p:last-child {\n          margin-bottom: 0;\n        }\n      }\n    }\n\n    &.has-close .message {\n      padding-right: @component-padding + 24px; // space for icon\n    }\n\n    .content {\n      border-radius: 0 @component-border-radius @component-border-radius 0;\n    }\n\n    .message {\n      max-height: @max-height-message;\n      overflow-y: auto;\n    }\n\n    .close-all.btn {\n      position: absolute;\n      top: 7px;\n      right: 38px;\n      background: none;\n    }\n\n    .close {\n      position: absolute;\n      top: 0;\n      right: 0;\n      width: 38px;\n      height: 38px;\n      line-height: 38px;\n      text-align: center;\n      font-size: 16px;\n      text-shadow: none;\n      color: black;\n      opacity: .4;\n      &:hover, &:focus {\n        opacity: 1;\n      }\n      &:active {\n        opacity: .2;\n      }\n      &:before {\n        margin: 0;\n      }\n    }\n\n    &.has-detail {\n      width: @width-detail;\n    }\n\n    .detail {\n      font-size: .8em;\n      background-color: hsla(0,0%,100%,.3);\n      background-clip: padding-box;\n      max-height: @max-height-detail;\n      overflow-y: auto;\n\n      .line {\n        font-family: @font-family-monospace;\n      }\n\n      .stack-toggle {\n        margin-top: @component-padding;\n\n        .icon:before {\n          margin: 0;\n        }\n      }\n\n      .detail-content {\n        .line {\n          white-space: pre-wrap;\n        }\n      }\n\n      .stack-container {\n        margin-top: @component-padding;\n\n        .line {\n          white-space: pre;\n        }\n      }\n    }\n\n    .description {\n      font-size: .8em;\n\n      p:last-child {\n        margin-bottom: 0;\n      }\n    }\n\n    .btn-toolbar.btn-toolbar {\n      margin-top: 10px;\n      margin-bottom: -5px;\n      margin-left: 0;\n    }\n\n    .btn-toolbar.btn-toolbar > .btn {\n      margin-left: 0;\n      margin-bottom: 5px;\n    }\n\n    .btn-copy-report {\n      vertical-align: middle;\n    }\n\n    .opening {\n      cursor: progress;\n    }\n  }\n}\n\n// Types -------------------------------\n\natom-notifications {\n  atom-notification.fatal {\n    .notification(@text-color-error; @background-color-error);\n  }\n\n  atom-notification.error {\n    .notification(@text-color-error; @background-color-error);\n  }\n\n  atom-notification.warning {\n    .notification(@text-color-warning; @background-color-warning);\n  }\n\n  atom-notification.info {\n    .notification(@text-color-info; @background-color-info);\n  }\n\n  atom-notification.success {\n    .notification(@text-color-success; @background-color-success);\n  }\n}\n\n\n// Mixins -------------------------------\n\n.notification(@txt; @bg) {\n\n  .content {\n    color: darken(@txt, 40%);\n    background-color: lighten(@bg, 25%);\n  }\n\n  a {\n    color: darken(@txt, 20%);\n  }\n\n  code {\n    color: darken(@txt, 40%);\n    background-color: desaturate(lighten(@bg, 18%), 5%);\n  }\n\n  &.icon:before {\n    color: lighten(@bg, 36%);\n    background-color: @bg;\n  }\n\n  .close-all.btn {\n    border: 1px solid fadeout(darken(@txt, 40%), 70%);\n    color: fadeout(darken(@txt, 40%), 40%);\n    text-shadow: none;\n\n    &:hover {\n      background: none;\n      border-color: fadeout(darken(@txt, 40%), 20%);\n      color: darken(@txt, 40%);\n    }\n  }\n}\n\n\n// Animations -------------------------------\n\natom-notifications atom-notification {\n  -webkit-animation: notification-show .16s cubic-bezier(0.175, 0.885, 0.32, 1.27499);\n\n  &[type="fatal"] {\n    -webkit-animation: notification-show .16s cubic-bezier(0.175, 0.885, 0.32, 1.27499),\n                       notification-shake 4s 2s;\n    -webkit-animation-iteration-count: 1, 3; // shake 3 times after showing\n    &:hover {\n      -webkit-animation-play-state: paused; // stop shaking when hovering\n    }\n  }\n\n  &.remove,\n  &.remove:hover {\n    -webkit-animation: notification-hide   .12s      cubic-bezier(.34,.07,1,.2),\n                       notification-shrink .24s .12s cubic-bezier(0.5, 0, 0, 1);\n    -webkit-animation-fill-mode: forwards;\n  }\n}\n\n@-webkit-keyframes notification-show {\n    0% { opacity: 0; transform: perspective(@width) translate(0, -@icon-size) rotateX(90deg); }\n  100% { opacity: 1; transform: perspective(@width) translate(0,           0) rotateX( 0deg); }\n}\n\n@-webkit-keyframes notification-hide {\n    0% { opacity: 1; transform: scale( 1); }\n  100% { opacity: 0; transform: scale(.8); }\n}\n\n@-webkit-keyframes notification-shrink {\n    0% {  opacity: 0; max-height: @max-height; transform: scale(.8); }\n  100% {  opacity: 0; max-height: 0;           transform: scale(.8); }\n}\n\n@-webkit-keyframes notification-shake {\n    0% { transform: translateX(   0); }\n    2% { transform: translateX(-4px); }\n    4% { transform: translateX( 8px); }\n    6% { transform: translateX(-4px); }\n    8% { transform: translateX(   0); }\n  100% { transform: translateX(   0); }\n}\n',digest:"3a911249ddafbc4e8508a8e05d86a11a613f6f21"},"node_modules/package-generator/styles/package-generator.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n.package-generator .error {\n  display: none;\n}',digest:"4cd559f40d4bb3277680a5502a5179654fded2b1"},"node_modules/settings-view/styles/docks.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n// Dock overrides\n// Allows settings to be used in left/right dock\n\natom-dock.left .settings-view,\natom-dock.right .settings-view {\n  flex-direction: column;\n\n  &.pane-item {\n    background-color: @tool-panel-background-color;\n  }\n\n  .config-menu {\n    flex: none;\n    display: flex;\n    flex-wrap: wrap;\n    align-items: center;\n    justify-content: center;\n    padding: @component-padding/2;\n    min-width: 0;\n    max-width: none;\n    border: none;\n    border-bottom: 1px solid @base-border-color;\n    background-color: inherit;\n    overflow-x: initial;\n\n    .nav {\n      display: contents; // hide from DOM\n\n      & > li > a {\n        padding: 0 .5em;\n        border-radius: @component-border-radius;\n      }\n\n      .icon:before {\n        display: none;\n      }\n    }\n\n    .button-area {\n      display: contents; // hide from DOM\n\n      .icon-link-external {\n        font-size: 0;\n        width: auto;\n        margin: 0 @component-padding/2;\n        padding: @component-padding/4 @component-padding/2;\n        overflow: hidden;\n        &:before {\n          font-size: 16px;\n          margin: 0;\n        }\n      }\n    }\n  }\n\n  .panels .panels-item {\n    min-width: 100px;\n  }\n\n  .section,\n  .section:first-child, .settings-view .section:last-child {\n    padding: @component-padding*1.5;\n  }\n\n  .sub-section:not(.collapsed) .package-container {\n    padding-bottom: 0;\n  }\n\n  section .section-heading,\n  .section .section-heading {\n    font-size: 1.25em;\n  }\n\n  .sub-section .sub-section-heading {\n    font-size: 1.15em;\n\n    &.has-items::before {\n      margin-right: 0;\n      font-size: 1.15em;\n    }\n  }\n\n  .setting-title {\n    font-size: 1.1em;\n    font-weight: 500;\n    color: @text-color-highlight;\n  }\n\n  .form-control {\n    font-size: 1.1em;\n  }\n\n  .package-card {\n    padding: @component-padding;\n    font-size: inherit;\n    background-color: mix(@tool-panel-background-color, @base-background-color, 25%);\n\n    &:hover {\n      background-color: mix(@tool-panel-background-color, @base-background-color, 75%);\n    }\n\n    .package-name {\n      font-size: inherit;\n      font-weight: 600;\n    }\n\n    .package-version {\n      font-size: .9em;\n      color: @text-color-subtle;\n      font-weight: 400;\n    }\n\n    .meta {\n      display: block;\n    }\n\n    .meta-user .avatar {\n      width: 20px;\n      height: 20px;\n    }\n    .meta-user .author {\n      margin-left: .5em;\n    }\n\n    .btn-toolbar {\n      .btn-group {\n        display: flex;\n        float: none;\n        .btn {\n          flex: 1 1 auto;\n          overflow: hidden;\n          &.status-indicator {\n            flex: none;\n            border: none;\n          }\n        }\n      }\n    }\n\n  }\n\n  .themes-panel {\n    .themes-picker-item {\n      margin-top: @component-padding*1.5;\n    }\n    .theme-description {\n      margin: @component-padding/2 0;\n    }\n  }\n\n\n}\n',digest:"085a251be8ef8140a1efbf37982bb0012c13eb59"},"node_modules/settings-view/styles/package-card.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "octicon-mixins";\n@import "ui-variables";\n@import "variables";\n\n.settings-view {\n\n  // TODO: Somehow unify the "card".\n\n  .package-card {\n    padding: @component-padding*1.5;\n    margin-bottom: @component-padding;\n    list-style-type: none;\n    font-size: 1.2em;\n    border-radius: @component-border-radius*2;\n    border: 1px solid @base-border-color;\n    background-color: @package-card-background-color;\n    overflow: hidden;\n    cursor: pointer;\n    -webkit-user-select: none;\n\n    &:hover {\n      background-color: contrast(@package-card-background-color, darken(@package-card-background-color, 2%), lighten(@package-card-background-color, 2%));\n    }\n    &:active {\n      background-color: @package-card-background-color;\n    }\n\n    &.disabled {\n      background-color: @package-card-disabled-background-color;\n      .body,\n      .avatar,\n      .author,\n      .stats {\n        opacity: .5;\n      }\n    }\n\n    &.deprecated, {\n      background-color: @package-card-disabled-background-color;\n      // .body,\n      .avatar,\n      .author,\n      .stats {\n        opacity: .5;\n      }\n    }\n\n    .deprecation-badge {\n      display: none;\n      font-size: .75em;\n      text-transform: uppercase;\n    }\n\n    &.deprecated .deprecation-badge {\n      display: inline;\n    }\n\n    &.col-lg-4 {\n      min-width: 190px;\n      padding: @component-padding 0;\n      padding-left: @component-padding;\n      padding-right: @component-padding;\n    }\n\n    .thumbnail {\n      border-radius: 3px;\n      margin: 0;\n      min-height: 140px;\n      color: @text-color;\n      border-radius: @component-border-radius*2;\n      border: 1px solid @base-border-color;\n      background-color: @package-card-background-color;\n\n      .caption {\n        width: 100%;\n        position: relative;\n      }\n    }\n    .package-name {\n      margin-right: .5em;\n      font-weight: bolder;\n      color: @text-color-highlight;\n    }\n\n    .package-version {\n      font-size: .8em;\n      margin-right: @component-padding;\n    }\n\n    .description {\n      color: @text-color;\n      overflow: hidden;\n      min-height: 38px;\n      max-height: 38px;\n      text-overflow: ellipsis;\n      display: -webkit-box;\n      -webkit-line-clamp: 2; /* number of lines to show */\n      -webkit-box-orient: vertical;\n    }\n\n    .package-message p:last-child {\n      margin: 0;\n    }\n\n    .downloads {\n      color: @text-color-highlight;\n      overflow: hidden;\n      text-overflow: ellipsis;\n      display: -webkit-box;\n      -webkit-line-clamp: 1; /* number of lines to show */\n      -webkit-box-orient: vertical;\n    }\n\n    .package-status {\n      right: 0px;\n      top: 5px;\n      text-align: center;\n\n      &.icon-cloud-download {\n        color: #428bca;\n      }\n\n      &.icon-check {\n        color: #6CC644;\n      }\n\n      &.icon-alert {\n        color: #BD2C00;\n      }\n    }\n\n    .card-name {\n      font-weight: 300;\n      margin: 0 0 .2em 0;\n      font-size: 1.2em;\n      line-height: 1.4;\n\n      .css-truncate-target {\n        color: $greenDark;\n      }\n    }\n\n    .stats {\n\n      .stats-item {\n        margin-left: @component-padding*1.5;\n        height: 26px;\n        display: inline-block;\n        line-height: 24px;\n        vertical-align: top;\n\n        .icon {\n          color: @text-color-subtle;\n        }\n      }\n\n      .star-box {\n        display: inline-block;\n        vertical-align: top;\n\n        .star-button {\n          padding: 0 6px;\n\n          .octicon {\n            margin-right: 0px;\n          }\n        }\n      }\n    }\n\n    .body {\n      .css-truncate-target {\n        max-width: 100%;\n      }\n    }\n\n    .package-description {\n      white-space: normal;\n      line-height: 1.4;\n    }\n\n    .meta {\n      display: flex;\n      flex-wrap: wrap;\n      justify-content: flex-end;\n      width: 100%;\n\n      a.linked-octicon {\n        text-decoration: none;\n\n        &:hover {\n          .octicon {\n            color: $greenDark;\n          }\n\n          .value {\n            color: $greenDark;\n          }\n        }\n      }\n\n      .action {\n        border-radius: 3px;\n        padding: 3px 6px;\n\n        &:hover {\n          background-color: #eaeaea;\n        }\n      }\n\n      .value {\n        color: #999;\n      }\n    }\n\n    .meta-user {\n      flex: 1 0 auto;\n      margin-top: @component-padding;\n      margin-right: @component-padding;\n\n      .avatar {\n        border-radius: @component-border-radius;\n        height: 24px;\n        width: 24px;\n        display: inline-block;\n        vertical-align: middle;\n        background-color: hsla(0,0%,0%,.1);\n      }\n\n      .author {\n        color: @text-color-subtle;\n        margin-left: @component-padding;\n        &:focus {\n          outline: none;\n        }\n      }\n    }\n\n    .meta-controls {\n      margin-top: @component-padding/2;\n\n      .install-button.is-installing,\n      .uninstall-button.is-uninstalling {\n        opacity: 1; // override disabled style\n        background-image: linear-gradient(to right, transparent 50%, hsla(0,0%,0%,.15) 50%);\n        background-size: 10px 100%;\n        -webkit-animation: available-package-is-installing .5s linear infinite;\n      }\n\n      .status-indicator {\n        padding: 0;\n        width: @component-padding/2;\n        min-width: 4px;\n        pointer-events: none;\n        transition: background .4s;\n        background: @background-color-success;\n        &.is-disabled {\n          background: @background-color-warning;\n        }\n      }\n\n      .btn-toolbar > .btn-group {\n        float: left;\n        margin: @component-padding/2 0 0 @component-padding/2;\n      }\n    }\n\n    .meta-lower {\n      padding: 13px;\n      background-color: @input-background-color;\n      line-height: 1;\n    }\n\n    &.blank-slate {\n      text-align: center;\n      color: $beigeDark;\n      height: 132px;\n      line-height: 132px;\n    }\n\n    // End copy-paste from atom.io\n  }\n\n  // Remove hover styles if it\'s in a detail view\n  .package-detail .package-card {\n    cursor: default;\n    &:hover {\n      background-color: @package-card-background-color;\n    }\n    &.disabled {\n      background-color: @package-card-disabled-background-color;\n    }\n  }\n\n}\n\n@-webkit-keyframes available-package-is-installing {\n  100% { background-position: -10px 0px; }\n}\n',digest:"17101b6372d5441dfee92f0b166b3533f4ab00e1"},"node_modules/settings-view/styles/package-readme.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n// Package README\n\n@import "ui-variables";\n\n.settings-view {\n\n  .package-readme {\n    font-size: 1.25em;\n\n    h1 { font-size: 2em;    margin-top: 1.5em; }\n    h2 { font-size: 1.75em; margin-top: 1.5em; }\n    h3 { font-size: 1.5em;  margin-top: 1.75em; }\n    h4 { font-size: 1.25em; margin-top: 1.25em; }\n    h1, h2, h3, h4 {\n      color: @text-color-highlight;\n    }\n\n    a {\n      color: @text-color-info;\n    }\n\n    hr {\n      border-color: @text-color-subtle;\n    }\n\n    blockquote {\n      border-left-color: @text-color-subtle;\n    }\n\n    pre {\n      margin-bottom: 1em;\n    }\n\n    img {\n      max-width: 100%;\n    }\n\n    table {\n      display: block;\n      margin-bottom: 1em;\n      width: 100%;\n      overflow: auto;\n      word-break: normal;\n\n      th {\n        font-weight: bold;\n        text-align: center;\n      }\n\n      th, td {\n        padding: 6px 13px;\n        border: 1px solid @base-border-color;\n      }\n\n      tr {\n        border-top: 1px solid @base-border-color;\n        background-color: @base-background-color;\n        &:nth-child(2n) {\n          background-color: @background-color-highlight;\n        }\n      }\n    }\n\n    kbd {\n      display: inline-block;\n      padding: .3em .4em;\n      font-size: .8em;\n      line-height: 1;\n      color: @text-color-highlight;\n      vertical-align: middle;\n      background-color: lighten(@base-background-color, 10%);\n      border: solid 1px @base-border-color;\n      border-bottom-color: darken(@base-border-color, 10%);\n      border-radius: @component-border-radius;\n      box-shadow: inset 0 -1px 0 darken(@base-border-color, 10%);\n    }\n\n  }\n}\n',digest:"c7aecf94bf4c4229b6d83d8b0f913cc9bfb46231"},"node_modules/settings-view/styles/settings-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "octicon-mixins";\n@import "octicon-utf-codes";\n@import "ui-variables";\n\n@section-padding: 2 * @component-padding;\n@breadcrumb-padding: 2 * @component-padding;\n\n.settings-view {\n  display: flex;\n\n  .breadcrumb {\n    margin-bottom: 0;\n    padding: 0 @breadcrumb-padding;\n    font-size: 1.125em;\n    line-height: 3rem;\n    color: @text-color-subtle;\n    list-style: none;\n    border-bottom: 1px solid @base-border-color;\n    background-color: @base-background-color;\n\n    + .section {\n      border-top: none;\n    }\n\n    > li {\n      display: inline-block;\n      a {\n        color: @text-color;\n      }\n\n      + li:before {\n        content: "/"; // Unicode space added since inline-block means non-collapsing white-space\n        padding: 0 .75em ;\n      }\n    }\n\n    > .active a {\n      font-weight: 600;\n      color: @text-color-highlight;\n    }\n\n  }\n\n  .text {\n    color: @text-color;\n  }\n\n  .alert-type(@tx; @bg) {\n    @alert-background-color: mix(@bg, @base-background-color, 10%);\n    color: contrast(@alert-background-color, darken(@tx, 20%), lighten(@tx, 20%) );\n    border-color: darken(@alert-background-color, 10%);\n    background-color: @alert-background-color;\n\n    .alert-link {\n      color: inherit;\n      text-decoration: underline;\n    }\n  }\n\n  .alert-info     { .alert-type(@text-color-info;    @background-color-info); }\n  .alert-success  { .alert-type(@text-color-success; @background-color-success); }\n  .alert-warning  { .alert-type(@text-color-warning; @background-color-warning); }\n  .alert-error,\n  .alert-danger   { .alert-type(@text-color-error;   @background-color-error); }\n\n\n  .error-message {\n    .alert {\n      margin-bottom: 0;\n    }\n\n    .close {\n      top: -6px; // magic number... for now\n    }\n\n    .error-details {\n      .alert-type(@text-color-error;   @background-color-error);\n    }\n\n    .error-link {\n      color: inherit;\n      text-decoration: underline;\n      margin-left: @component-padding/2;\n    }\n  }\n\n  select.form-control {\n    color: @text-color;\n    border-color: @button-border-color;\n    background-color: @button-background-color;\n    &:hover,\n    &:focus {\n      box-shadow: none;\n      background-color: @button-background-color-hover;\n    }\n  }\n\n  .select-container {\n    display: flex;\n    align-items: stretch;\n  }\n\n  .themes-picker-item .btn {\n    margin-left: 2px;\n    &::before {\n      margin-right: 0;\n      text-align: left;\n    }\n  }\n\n  .checkbox {\n    padding-left: 2.25em;\n    label {\n      padding-left: 0;\n      display: block;\n    }\n    .setting-title {\n      display: inline-block;\n    }\n  }\n  input[type="checkbox"] {\n    margin: 0 .75em 0 -2.25em;\n  }\n\n  .color {\n    padding-left: 5em;\n    .setting-title {\n      margin-top: .15em;\n    }\n  }\n  input[type="color"] {\n    float: left;\n    margin: 0 0 0 -5em;\n    padding: 0;\n    width: 4em;\n    height: 1.6em;\n    border-radius: 4px;\n    border: 1px solid @base-border-color;\n    background: darken(@base-background-color, 2%);\n    &::-webkit-color-swatch-wrapper {\n      padding: 2px;\n      margin: 0;\n      border-radius: inherit;\n    }\n    &::-webkit-color-swatch {\n      border-radius: 2px;\n      border: 1px solid hsla(0,0%,0%,.1);\n    }\n  }\n\n  .editor-container {\n    margin: @component-padding*2 0;\n    &:last-child {\n      margin-bottom: 0;\n    }\n    &.settings-filter {\n      margin-bottom: 36px;\n    }\n  }\n\n  .section {\n    padding: @section-padding;\n    border-top: 1px solid @base-border-color;\n    &:first-child,\n    &:last-child {\n      padding: @section-padding;\n    }\n    &.section:empty {\n      padding: 0;\n      border-top: none;\n    }\n\n    atom-text-editor[mini] {\n      opacity: .75;\n      .selection .region {\n        background-color: contrast(@input-background-color, lighten(@input-background-color, 8%), darken(@input-background-color, 8%) );\n      }\n    }\n\n    atom-text-editor[mini].is-focused {\n      opacity: 1;\n      .selection .region {\n      background-color: contrast(@input-background-color, lighten(@input-background-color, 12%), darken(@input-background-color, 12%) );\n      }\n    }\n  }\n\n  div > .package-detail section.section.settings-panel {\n      border-top: 1px solid @base-border-color;\n  }\n\n  .section-container {\n    width: 100%;\n    max-width: 800px;\n\n    &.updates-container {\n      .package-container {\n        > .row {\n          margin-left: -@component-padding;\n          margin-right: -@component-padding;\n        }\n      }\n      .native-key-bindings, .alert-info {\n        margin-bottom: 15px;\n      }\n    }\n  }\n\n  section .section-heading,\n  .section .section-heading {\n    margin-bottom: @component-padding*2;\n    color: @text-color-highlight;\n    font-size: 1.75em;\n    font-weight: bold;\n    line-height: 1;\n    -webkit-user-select: none;\n    cursor: default;\n  }\n\n  .sub-section-heading.icon:before,\n  .section-heading.icon:before {\n    margin-right: @component-padding*.8;\n  }\n\n  .section-heading-count {\n    margin-left: .5em;\n  }\n\n  .section-body {\n    margin-top: 20px;\n  }\n\n  .sub-section {\n\n    .sub-section-heading {\n      position: sticky;\n      top: -1px; // -1px fixes a rounding issue on retina screens\n      z-index: 1;\n      margin: 0;\n      padding: @component-padding 0;\n      font-size: 1.4em;\n      font-weight: bold;\n      line-height: 1;\n      color: @text-color-highlight;\n      background-color: @base-background-color;\n      -webkit-user-select: none;\n\n      &.has-items {\n        cursor: pointer;\n\n        &::before {\n          .icon(20px);\n          content: @chevron-down;\n          color: @text-color-subtle;\n        }\n\n        &:hover:after {\n          color: @text-color-highlight;\n        }\n      }\n    }\n\n    .sub-section-body {\n      margin-top: @component-padding;\n      margin-bottom: @component-padding*3;\n      margin-left: 6px;\n      padding-left: 14px;\n      border-left: 1px solid @base-border-color;\n    }\n\n    &.collapsed {\n      .sub-section-heading.has-items:before {\n        content: @chevron-right;\n      }\n      .package-container .package-card,\n      .sub-section-body {\n        display: none !important;\n      }\n    }\n  }\n\n  .control-label {\n    -webkit-user-select: none;\n    cursor: default;\n  }\n\n  .setting-title {\n    font-size: 1.2em;\n    -webkit-user-select: none;\n  }\n\n  .setting-description {\n    color: @text-color-subtle;\n    -webkit-user-select: none;\n    cursor: default;\n\n    &:empty {\n      display: none;\n    }\n  }\n\n  .link {\n    color: @text-color-info;\n\n    &:hover, &:focus {\n      color: lighten(@text-color-info, 4%);\n    }\n  }\n\n  .config-menu {\n    flex: 1.6;\n    min-width: 180px;\n    max-width: 240px;\n    -webkit-user-select: none;\n    user-select: none;\n    padding-top: @component-padding;\n    background-color: lighten(@base-background-color, 2%);\n    border-right: 1px solid @base-border-color;\n    overflow-x: auto;\n\n    .icon:before {\n      text-align: center;\n    }\n\n    .panels-packages{\n      flex-grow: 1;\n      overflow: auto;\n      height: 0;\n\n      li + li {\n        margin-top: 0;\n      }\n\n      li > a {\n        border-radius: 1px !important;\n        padding: 12px 14px;\n        font-weight: bold;\n        line-height: 16px;\n        opacity: .85;\n        transition: opacity .1s ease-in;\n        box-shadow: inset 0 -1px 0 rgba(0,0,0, 7%);\n\n        &:hover {\n          opacity: 1;\n          box-shadow: inset 0 -1px 0 rgba(0,0,0, 7%) !important;\n        }\n      }\n\n      li:first-child {margin-top:2px;}\n      li:last-child {margin-bottom: 10px;}\n\n      li.active a, li.active a:hover {\n        opacity: 1;\n        box-shadow: 0 0 0 1px darken(#3c76dd, 10%) !important;\n\n        .package-author, .package-version {\n          color: #fff;\n          opacity: .6;\n        }\n      }\n\n      .package-version {\n        line-height: 16px;\n        margin-left: 5px;\n        font-weight: normal;\n        color: #999;\n      }\n\n      .package-author {\n        font-weight: normal;\n        display: block;\n        color: #999;\n      }\n    }\n\n    .button-area {\n      margin: 15px; // same as nav\n      > .btn {\n        width: 100%;\n      }\n    }\n\n    .nav > li {\n      margin-top: 0;\n      > a {\n        border-radius: 0;\n        white-space: nowrap;\n\n        &:hover {\n          color: @text-color-highlight;\n          background-color: @background-color-highlight;\n        }\n      }\n    }\n\n    .nav > li.active > a {\n      color: @text-color-selected;\n      background-color: @background-color-selected;\n    }\n  }\n\n  .panels {\n    flex: 8.4;\n    flex-flow: column;\n    display: flex;\n    position: relative;\n    min-width: 0;\n\n   .panels-item {\n      flex: 1;\n      min-width: 372px; // magic number: fit the Settings, Uninstall and Disable button\n      overflow: auto;\n    }\n  }\n\n  .settings-panel {\n    label {\n      color: @text-color;\n    }\n\n    .control-group + .control-group {\n      margin-top:  1.5em;\n    }\n\n    .control-group .editor-container {\n      margin: 0;\n    }\n\n    .grammar-filetypes {\n      margin-top: @component-padding;\n    }\n  }\n\n  .package-detail {\n    flex: 1;\n    display: flex;\n    flex-direction: column;\n\n    .package-keymap-table,\n    .package-grammars-table,\n    .package-snippets-table {\n      padding-top: @component-padding;\n      padding-left: @component-padding;\n\n      td {\n        white-space: nowrap;\n      }\n\n      .snippet-prefix {\n        font-family: monospace;\n      }\n    }\n\n    .package-snippets-table {\n      max-width: 100%;\n    }\n\n    .update-message {\n      padding-right: @component-padding;\n    }\n\n    .link {\n      width: -webkit-fit-content; // prevents hover area being full-width\n    }\n\n    .link,\n    .text {\n      margin: 0 15px @component-padding 15px;\n    }\n\n    .update-link,\n    .repo-link {\n      &:hover {\n        cursor: pointer;\n        text-decoration: underline;\n      }\n    }\n  }\n\n  .themes-panel {\n    .control-group {\n      margin-top:  @component-padding*3;\n    }\n    .themes-picker {\n      display: flex;\n      flex-wrap: wrap;\n      margin: 0 -@component-padding;\n    }\n    .themes-picker-item {\n      flex: 1;\n      min-width: 320px; // Enough for the UI Theme description\n      padding: 0 @component-padding;\n      .controls {\n        height: 100%;\n        display: flex;\n        flex-direction: column;\n        justify-content: space-between;\n      }\n    }\n  }\n\n  .packages {\n    display: flex;\n    flex-flow: column;\n\n    .themes-label {\n      font-size: 1.25em;\n      font-weight: bold;\n    }\n\n    .theme-chooser {\n      padding-top: @component-padding*2;\n    }\n\n    .theme-description {\n      -webkit-user-select: none;\n      cursor: default;\n    }\n\n    .package-container {\n      width: 100%;\n    }\n\n    .search-container {\n      display: flex;\n      flex-wrap: wrap;\n      margin: 0 -@component-padding/2;\n      padding-top: @component-padding*1.5;\n\n\n      .editor-container {\n        flex: 1;\n        min-width: 130px;\n        margin: @component-padding/2;\n      }\n\n      .btn-group {\n        margin: @component-padding/2;\n        padding-left: 1px; // Counter balance since btns have margin-left: -1px\n      }\n    }\n\n    .search-message {\n      margin: @component-padding 0 0;\n    }\n\n    .error-message {\n      padding: @component-padding 0;\n    }\n\n  }\n\n  .btn-retry {\n    margin-left: @component-padding;\n  }\n\n  .readme {\n    margin-top: @component-padding;\n  }\n\n  .panel-heading .label {\n    margin-left: @component-padding;\n  }\n\n  .loading-area {\n    span {\n      &::before {\n        font-size: 1.1em;\n        width: 1.1em;\n        height: 1.1em;\n      }\n    }\n  }\n\n  .error-view {\n    margin: @component-padding 0 @component-padding 0;\n  }\n\n  .packages-panel {\n    .nav {\n      .badge {\n        margin-left: @component-icon-padding;\n      }\n    }\n  }\n\n  .copy-icon {\n    cursor: pointer;\n    padding-right: 2px;\n\n    &:hover {\n      color: #2a6496;\n    }\n  }\n\n  .table {\n    table {\n      width: 100%;\n      table-layout: initial;\n    }\n\n    th {\n      padding: @component-padding - 2px @component-padding;\n      padding-left: 0;\n    }\n\n    td {\n      height: @component-line-height;\n    }\n\n    td, th {\n      padding-left: 1%;\n      padding-right: 1%;\n      white-space: nowrap;\n      overflow: hidden;\n      border-color: @base-border-color;\n    }\n\n    col.keystroke {\n      width: (15% - 2%);\n    }\n\n    col.command {\n      width: (40% - 2%);\n    }\n\n    col.source {\n      width: (10% - 2%);\n    }\n\n    col.selector {\n      width: (35%  - 2%);\n    }\n  }\n\n  .compile-tools-heading {\n    font-weight: bold;\n  }\n\n  .compile-tools-message {\n    padding-top: @component-padding;\n\n    code {\n      text-shadow: none;\n      border-width: 1px;\n      border-style: solid;\n    }\n  }\n\n  .uri-history {\n    width: 100%;\n\n    th {\n      white-space: nowrap;\n    }\n\n    td, th {\n      padding: 0 @component-padding @component-padding/2 0;\n    }\n  }\n}\n\n@media all and (max-width: 800px) {\n  .thumbnail .btn-toolbar {\n    .btn {\n      width: 100%;\n      margin: 2px 0;\n    }\n  }\n}\n\n// A tooltip that shows the body of a snippet should treat whitespace literally\n// and should align to the left so that indentation is clearer.\n.snippet-body-tooltip .tooltip-inner {\n  font-family: monospace;\n  white-space: pre !important;\n  text-align: left;\n}\n\n.package-updates-status-view:hover {\n  text-decoration: underline;\n}\n\n.available-updates-status {\n  padding-left: 2px;\n}\n\n\n// Overrides\n// TODO: Refactor + cleanup\n\n.settings-view {\n\n  .container {\n    padding: 0;\n    > .row {\n      margin-left: 0;\n      margin-right: 0;\n    }\n  }\n\n  .updates-heading-container {\n    display: flex;\n    flex-wrap: wrap;\n    justify-content: space-between;\n    align-items: center;\n  }\n\n  .update-all-button:last-child {\n    margin-left: @component-padding/2;\n  }\n\n  .keybinding-panel .is-user {\n    color: @text-color-selected;\n    background-color: @background-color-selected;\n  }\n\n  .btn-wrap-group .btn {\n    margin: 0 @component-padding/2 @component-padding/2 0;\n  }\n}\n\n.clearfix {\n  &::before {\n    display: table;\n    content: "";\n  }\n\n  &::after {\n    display: table;\n    clear: both;\n    content: "";\n  }\n}\n\n// Reset Bootstrap media queries,\n// since it breaks when resizing the treeview or in multiple panes\n\n@media (min-width: 768px) {\n  .container {\n    width: auto;\n  }\n}\n@media (min-width: 992px) {\n  .container {\n    width: auto;\n  }\n}\n@media (min-width: 1200px) {\n  .container {\n    width: auto;\n  }\n  .col-lg-8 {\n    width: 100%;\n  }\n}\n',digest:"ba13e9e5c41424602ff0211adf1eef2224f78c17"},"node_modules/settings-view/styles/variables.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n// Import only after ui-variables.less\n@package-card-background-color: lighten(@tool-panel-background-color, 8%);\n@package-card-disabled-background-color: darken(@package-card-background-color, 3%);\n',digest:"cffd057442ce83af2518c9627d28c87cfbb5fafa"},"node_modules/spell-check/styles/spell-check.atom-text-editor.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n.spell-check-misspelling .region {\n  border-bottom: 2px dotted hsla(0, 100%, 60%, 0.75);\n}\n\n.spell-check-corrections {\n  width: 25em !important;\n}\n',digest:"dabc0ce2a181159b0875d3f5d1b59be9d0ec2cfb"},"node_modules/status-bar/styles/status-bar.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n@import "octicon-mixins";\n\nstatus-bar {\n  display: block;\n  font-size: 11px;\n  line-height: @component-line-height - 3px;\n  height: @component-line-height + 1px;\n  position: relative;\n  -webkit-user-select: none;\n  cursor: default;\n  overflow: hidden;\n  white-space: nowrap;\n  min-width: -webkit-min-content;\n\n  a, a:hover {\n    color: @text-color;\n  }\n\n  .flexbox-repaint-hack {\n    padding: 0 @component-line-height/2;\n    position: absolute;\n    top: 0;\n    right: 0;\n    bottom: 0;\n    left: 0;\n    display: flex;\n    justify-content: space-between;\n  }\n\n  // Use 1/3 of space -> will get cut-off first when narrow\n  .status-bar-left {\n    flex: 1 1 33%;\n  }\n\n  // Use 2/3 of space\n  .status-bar-right {\n    padding-left: @component-padding;\n    .inline-block {\n      margin-right: 0;\n      margin-left: @component-padding*1.5;\n      & > .inline-block {\n        margin-left: 0;\n      }\n    }\n  }\n\n  // Add horizontal overflow scrolling\n  .status-bar-left,\n  .status-bar-right {\n    overflow-x: auto;\n    // prevent badly behaved status bar items from causing vertical scrolling\n    // in the status bar. They can always implement overflow: auto to scroll\n    // within themselves.\n    overflow-y: hidden;\n    &::-webkit-scrollbar {\n      display: none;\n    }\n  }\n\n  // Limit inline-blocks from getting too long\n  .inline-block {\n    max-width: 20vw;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n  }\n\n  // remove padding from buttons\n  button.inline-block {\n    padding-left: 0;\n    padding-right: 0;\n  }\n\n  // No width limit for file-info -> will get cut off if too long\n  .inline-block.file-info {\n    max-width: none;\n  }\n\n  .file-info.buffer-modified::after {\n    content: \'*\';\n  }\n\n  // All icons are smaller than normal (normal is 16px)\n  .icon:before {\n    .icon-size(14px);\n    position: relative;\n    top: 1px;\n    width: auto; // Enable auto-width since not every icon has the same width\n    margin-right: 4px;\n  }\n\n  .icon-diff-ignored:before,\n  .commits-ahead-label:before,\n  .commits-behind-label:before {\n    margin-right: -1px;\n  }\n\n  .hide,\n  .current-path:empty,\n  .cursor-position:empty,\n  .selection-count:empty {\n    display: none;\n  }\n\n  .git-view {\n    display: inline-block;\n  }\n\n  .cursor-position a,\n  .cursor-position a:hover {\n    color: @text-color;\n  }\n}\n',digest:"250cbd217ad5ffa455b523bbbbd881b09e83398e"},"node_modules/styleguide/styles/components.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n//\n// This adds some component styles specifically for the Styleguide\n// --------------------------------\n\n.styleguide {\n\n  // Icons ---------------\n\n  [data-name="icons"] {\n    .example-rendered {\n      display: flex;\n      flex-wrap: wrap;\n      align-content: flex-start;\n    }\n\n    .example-code {\n      display: none; // remove, doesn\'t make much sense here\n    }\n\n    .icon {\n      position: relative;\n      flex: 1 0 200px;\n      padding: 10px 0 10px 40px;\n      color: @text-color-subtle;\n      &:before {\n        position: absolute;\n        margin-left: -32px;\n        color: @text-color-highlight;\n        text-align: center;\n      }\n      &:hover {\n        color: @text-color-highlight;\n        &:before {\n          color: @text-color-selected;\n          font-size: 32px;\n          width: 32px;\n          height: 32px;\n          margin-top: -8px;\n          margin-left: -40px; // 32px (initial) + 8px (grow)\n        }\n      }\n    }\n\n    // Make the Gist logo bigger\n    .icon-logo-gist {\n      &:before,\n      &:hover:before {\n        font-size: 2.5em;\n        margin-top: -.05em;\n        margin-left: -1.3em;\n        width: 16px;\n        height: 16px;\n      }\n    }\n\n    // Make the GitHub logo bigger\n    .icon-logo-github {\n      &:before,\n      &:hover:before {\n        font-size: 3em;\n        margin-top: .08em;\n        margin-left: -1.2em;\n      }\n    }\n  }\n\n  // Inputs + controls ---------------\n\n  .input-search,\n  .input-textarea {\n    margin-top: @component-padding;\n  }\n\n  .input-label {\n    display: block;\n    width: -webkit-max-content;\n    margin: 0 1em 1em 0;\n  }\n\n  .input-color,\n  .input-number,\n  .input-select {\n    margin: 0 @component-padding 0 0 !important;\n  }\n\n\n  // Site colors ---------------\n\n  .ui-site-1,\n  .ui-site-2,\n  .ui-site-3,\n  .ui-site-4,\n  .ui-site-5 {\n    height: 10px;\n    width: 100px;\n  }\n\n\n  // Modals ---------------\n\n  atom-panel.modal {\n    // makde them responsive in the styleguide\n    position: relative;\n    max-width: 100%;\n    left: 0;\n    margin: 0;\n  }\n\n\n  // Misc ---------------\n\n  .popover-list {\n    position: relative;\n  }\n\n  .popover-list,\n  .select-list {\n    atom-text-editor[mini] { height: 27px; }\n  }\n\n  .tooltip {\n    position: relative;\n    opacity: 1;\n    display: inline-block;\n    margin-right: @component-padding;\n  }\n\n  [data-name="error-messages"] .example-rendered {\n    min-height: 60px; // don\'t cut off centered messages\n  }\n\n}\n',digest:"bf26369d71be6cb187463352133d755cb3fb1a4d"},"node_modules/styleguide/styles/styleguide.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n@import "syntax-variables";\n\n@styleguide-spacing: @component-padding *1.5;\n@styleguide-bg: darken(@base-background-color, 2%);\n\n.styleguide {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n\n  a {\n    text-decoration: underline;\n  }\n}\n\n.styleguide-controls {\n  position: absolute;\n  right: @component-padding;\n  top: @component-padding;\n  z-index: 100;\n}\n\n.styleguide-header {\n  padding: @styleguide-spacing;\n  border-bottom: 1px solid @base-border-color;\n  h1 {\n    font-size: 2em;\n    margin: 0 0 .5em 0;\n    color: @text-color-highlight;\n  }\n  p {\n    font-size: 1.2em;\n    &:last-of-type {\n      margin-bottom: 0;\n    }\n  }\n}\n\n.styleguide-sections {\n  flex: 1;\n  overflow: auto;\n\n  & > section {\n    background-color: @styleguide-bg;\n    padding: 0;\n    border-bottom: 1px solid @base-border-color;\n    border-top: none;\n\n    &:last-child {\n      margin-bottom: 0;\n    }\n\n    &.collapsed {\n      background-color: @base-background-color;\n      > .section-heading {\n        display: block;\n        margin: 0;\n        padding-bottom: @styleguide-spacing;\n        color: @text-color;\n        &:hover {\n          color: @text-color-highlight;\n          background-color: @background-color-highlight;\n        }\n        &:active {\n          background-color: @base-background-color;\n        }\n      }\n      > * {\n        display: none\n      }\n    }\n  }\n\n  .section-heading.section-heading {\n    padding: @styleguide-spacing @styleguide-spacing 0 @styleguide-spacing;\n    cursor: pointer;\n    font-weight: normal;\n    font-size: 1.8em;\n    color: @text-color-highlight;\n  }\n\n  section > h2 {\n    font-size: 1.5em;\n    line-height: 1.2;\n    margin: 1em @styleguide-spacing 0 @styleguide-spacing;\n    color: @text-color-highlight;\n  }\n\n  section > p {\n    font-size: 1.1em;\n    margin: .5em @styleguide-spacing 1em @styleguide-spacing;\n  }\n}\n\n// Example -------------------------------\n\n.styleguide .example {\n  @example-background: @base-background-color;\n\n  display: flex;\n  flex-wrap: wrap;\n  border-radius: @component-border-radius;\n  padding: @component-padding / 2;\n\n  .example-rendered,\n  .example-code {\n    position: relative;\n    flex: 1 1 300px;\n    min-width: 0;\n    margin: @component-padding / 2;\n    border-radius: @component-border-radius;\n    border: 1px solid @tool-panel-border-color;\n  }\n\n  .example-rendered {\n    padding: @component-padding;\n    background: @example-background;\n    overflow: hidden;\n  }\n\n  .example-code {\n    background-color: @syntax-background-color;\n    pre {\n      border: none;\n      background-color: inherit;\n    }\n  }\n}\n',digest:"70f8674ff2b98bc0af5bbbb850cebf5083e321af"},"node_modules/styleguide/styles/variables.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n@import "syntax-variables";\n\n.styleguide [data-name="variables"] {\n\n  // Text colors\n  .color( text-color );\n  .color( text-color-subtle );\n  .color( text-color-highlight );\n  .color( text-color-selected );\n  .color( text-color-info );\n  .color( text-color-success );\n  .color( text-color-warning );\n  .color( text-color-error );\n\n  // Background colors\n  .color( background-color-info );\n  .color( background-color-success );\n  .color( background-color-warning );\n  .color( background-color-error );\n  .color( background-color-highlight );\n  .color( background-color-selected );\n  .color( app-background-color );\n\n  // Base colors\n  .color( base-background-color );\n  .color( base-border-color );\n\n  // Pane colors\n  .color( pane-item-background-color );\n  .color( pane-item-border-color );\n\n  // Input colors\n  .color( input-background-color );\n  .color( input-border-color );\n\n  // Panel colors\n  .color( tool-panel-background-color );\n  .color( tool-panel-border-color );\n  .color( inset-panel-background-color );\n  .color( inset-panel-border-color );\n  .color( panel-heading-background-color );\n  .color( panel-heading-border-color );\n  .color( overlay-background-color );\n  .color( overlay-border-color );\n\n  // Button colors\n  .color( button-background-color );\n  .color( button-background-color-hover );\n  .color( button-background-color-selected );\n  .color( button-border-color );\n\n  // Tab colors\n  .color( tab-bar-background-color );\n  .color( tab-bar-border-color );\n  .color( tab-background-color );\n  .color( tab-background-color-active );\n  .color( tab-border-color );\n\n  // Tree-view colors\n  .color( tree-view-background-color );\n  .color( tree-view-border-color );\n\n  // Site colors\n  .color( ui-site-color-1 );\n  .color( ui-site-color-2 );\n  .color( ui-site-color-3 );\n  .color( ui-site-color-4 );\n  .color( ui-site-color-5 );\n\n  // Component sizes\n  .size( disclosure-arrow-size );\n  .size( component-padding );\n  .size( component-icon-padding );\n  .size( component-icon-size );\n  .size( component-line-height );\n  .size( tab-height );\n  .size( font-size );\n\n  // Misc\n  .radius( component-border-radius );\n  .font( font-family );\n\n\n  // Visualize --------------------------------\n\n  .is-color:before,\n  .is-size:after,\n  .is-radius:after {\n    content: "";\n    display: inline-block;\n    height: 20px;\n    vertical-align: middle;\n  }\n  .is-color:before {\n    margin-right: @component-padding*1.5;\n    width: 20%;\n  }\n  .is-size:after {\n    margin-left: @component-padding*1.5;\n    height: 4px;\n    background-color: @text-color;\n  }\n  .is-radius:after {\n    width: 20px;\n    margin-left: @component-padding*1.5;\n    background-color: @text-color;\n  }\n  .is-font:after {\n    margin-left: @component-padding;\n    color: @text-color-highlight;\n  }\n\n\n  // Mixins --------------------------------\n\n  .color(@variable) {\n    .is-color.@{variable}:before {\n      background-color: @@variable;\n    }\n  }\n\n  .size(@variable) {\n    .is-size.@{variable}:after {\n      width: @@variable;\n    }\n  }\n\n  .radius(@variable) {\n    .is-radius.@{variable}:after {\n      border-radius: @@variable;\n    }\n  }\n\n  .font(@variable) {\n    .is-font.@{variable}:after {\n      content: @@variable;\n      font-family: @@variable;\n    }\n  }\n\n\n  // Custom styling for vars --------------------------------\n\n  .example-code {\n    display: none; // remove, doesn\'t make much sense here\n  }\n}\n',digest:"c29607cc1fadfb7abcb490864e92816e63e8c2e9"},"node_modules/symbols-view/styles/symbols-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n// Highlight matched text\n.symbols-view .list-group .character-match {\n  color: @text-color-highlight;\n  font-weight: bold;\n}\n',digest:"0d42513a8411ac9f44466cbbddb994e532965ba2"},"node_modules/tabs/styles/layout.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n.tabs-layout-overlay {\n  background: grey;\n  position: absolute;\n  z-index: 11; // Make sure this covers absolutely-positioned docks\n  opacity: 0;\n  pointer-events: none;\n  transition: all 0.2s;\n  &.visible {\n    opacity: 0.1;\n  }\n}\n',digest:"d314bc400d4e94580ab82e1b7a49ea4c98b7c2f2"},"node_modules/tabs/styles/tabs-mru-switcher.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n.tabs-mru-switcher {\n  .list-group.list-group {\n    margin-top: 0;\n\n    // Fix to make the scrollbar appear\n    // Not necessary for all themes\n    backface-visibility: hidden;\n  }\n}\n',digest:"3a300a3e1bea67913d4620ed192ae9e2522ef45a"},"node_modules/tabs/styles/tabs.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n@import "octicon-mixins";\n\n@close-icon-size: 12px;\n\n.tab-bar {\n  display: flex;\n  -webkit-user-select: none;\n  margin: 0;\n\n  .tab {\n    font-size: 11px;\n    position: relative;\n    padding-left: 10px;\n    padding-right: 10px + @close-icon-size + 2px;\n    -webkit-user-drag: element;\n    flex: 1;\n    max-width: 175px;\n    min-width: 40px;\n    transition: max-width .25s ease-in-out;\n\n    &.active {\n      flex: 2;\n      width: -webkit-fit-content;\n\n      .title {\n        padding-right: 10px;\n      }\n    }\n\n    .title {\n      overflow: hidden;\n      white-space: pre;\n      text-overflow: ellipsis;\n      &.temp {\n        font-style: italic;\n      }\n    }\n\n    .hide-icon {\n      &.icon:before {\n        display: none;\n      }\n    }\n\n    .close-icon {\n      .octicon(x, @close-icon-size);\n      position: absolute;\n      top: 1px;\n      right: 10px;\n      cursor: default;\n    }\n\n    &.modified:hover .close-icon {\n      color: @background-color-info;\n    }\n\n    &.modified:not(:hover) .close-icon {\n      &:before { display: none; }\n      top: 11px;\n      right: 11px;\n      width: 8px;\n      height: 8px;\n      border: 2px solid @background-color-info;\n      border-radius: 12px;\n    }\n  }\n\n  /* Drag and Drop */\n  .placeholder {\n    position: relative;\n    top: 0;\n    padding: 0;\n    height: @tab-height;\n    z-index: 999;\n    list-style: none;\n    background: @background-color-info;\n    pointer-events: none;\n\n    // bar\n    &:before {\n      content: "";\n      position: absolute;\n      width: 2px;\n      margin: -1px; padding: 0;\n      height: inherit;\n      background: inherit;\n    }\n\n    // dot\n    &:after {\n      content: "";\n      position: absolute;\n      top: @tab-height;\n      margin-top: -1px;\n      margin-left: -2px;\n      z-index: 9999;\n      width: 4px;\n      height: 4px;\n      background: inherit;\n      border-radius: 4px;\n      border: 1px solid transparent;\n    }\n  }\n\n  &.hidden {\n    display: none;\n  }\n}\n',digest:"ef692077042a4fcc762e93a03d532c786c838578"},"node_modules/timecop/styles/timecop.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n.timecop {\n  .timecop-panel {\n    background-color: @tool-panel-background-color;\n  }\n\n  overflow: auto;\n\n  .panels {\n    display: flex;\n    flex-direction: row;\n  }\n\n  .package-panel {\n    display: flex;\n    flex-direction: row;\n    flex: 1;\n\n    .list-group {\n      overflow: hidden;\n    }\n\n    .inset-panel {\n      width: 100%;\n    }\n  }\n\n  .text-info {\n    margin-bottom: @component-padding;\n  }\n\n  .timing,\n  .list-item {\n    display: flex;\n    justify-content: space-between;\n    .inline-block:last-child {\n      margin-right: 0;\n    }\n  }\n\n  .timing {\n    margin-bottom: @component-padding;\n  }\n\n  .list-item {\n    margin-top: @component-padding / 2;;\n    margin-bottom: @component-padding / 2;\n  }\n\n  .package {\n    color: @text-color;\n    &:hover {\n      text-decoration: none;\n      color: @text-color-selected;\n    }\n  }\n  .timecop-line {\n    flex: 1 1 0;\n    margin-right: @component-padding;\n    margin-top: .80em;\n    border-top: 1px dashed fade(@text-color, 20%);\n  }\n\n  .package:hover + .timecop-line {\n    border-color: fade(@text-color, 60%);\n  }\n\n}\n',digest:"b845d0ed2349c16314642b453287adff298368cc"},"node_modules/tree-view/styles/tree-view.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "ui-variables";\n\n.project-root-header {\n  -webkit-user-drag: element;\n}\n\n.tree-view {\n  contain: size;\n  overflow: auto;\n  z-index: 2;\n  -webkit-user-select: none;\n\n  display: flex;\n  flex-direction: column;\n\n  .tree-view-root {\n    padding-left: @component-icon-padding;\n    padding-right: @component-padding;\n    background-color: inherit;\n\n    /*\n     * Force a new stacking context to prevent a large, duplicate paint layer from\n     * being created for tree-view\'s scrolling contents that can make the cost of\n     * layer tree updates scale at 3x the size of the layer rather than the\n     * optimal 1x.\n     *\n     * On high resolution displays, Chromium handles layers for scrolling content\n     * differently and inadvertently creates a duplicate paint layer the size of\n     * .tree-view-scroller because descendants of the scroller overlap the\n     * auto-created layer.\n     */\n    isolation: isolate;\n\n    // Expands tree-view root to take up full height.\n    // This makes sure that the context menu can still be openend in the empty\n    // area underneath the files.\n    flex-grow: 1;\n\n    // Expands tree-view root to take up as much width as needed by the content.\n    // This makes sure that the selected item\'s "bar/background" expands to full width.\n    position: relative;\n    min-width: min-content;\n  }\n\n  .header {\n    position: relative;\n  }\n\n  .tree-view-root .list-tree {\n    // Keeps selections expanded while dragging\n    position: static;\n  }\n\n  .entry {\n    // This fixes #110, see that issue for more details\n    &::before {\n      content: \'\';\n      position: absolute;\n    }\n  }\n\n  /* Drag and Drop */\n  .placeholder {\n    position: absolute;\n    left: @component-icon-padding;\n    padding: 0;\n    z-index: 999;\n    display: inline-block;\n\n    width: calc(~"100% -" @component-icon-padding);\n    background: @background-color-info;\n\n    list-style: none;\n    pointer-events: none;\n\n    // bar\n    &:before {\n      content: "";\n      position: absolute;\n      height: 2px;\n      margin: -1px; padding: 0;\n      width: inherit;\n      background: inherit;\n    }\n\n    &:after {\n      content: "";\n      position: absolute;\n      left: 0;\n      margin-top: -2px;\n      margin-left: -1px;\n      width: 4px;\n      height: 4px;\n      background: @background-color-info;\n      border-radius: 4px;\n      border: 1px solid transparent;\n    }\n\n    // ensure that placeholder doesn\'t disappear above the top of the view\n    &:first-child {\n      margin-top: 1px;\n    }\n  }\n}\n',digest:"f1313ca5057287a2c8a9e1a62469ebd00e4b4474"},"node_modules/update-package-dependencies/styles/update-package-dependencies.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n.update-package-dependencies-status .loading.inline-block {\n  vertical-align: text-bottom;\n}\n',digest:"d83c2f136f2a1dd45e3a6521e8a89d7e740277c1"},"node_modules/welcome/styles/welcome.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "octicon-mixins";\n@import "ui-variables";\n\n.welcome {\n  display: flex;\n  font-size: 1.25em;\n  line-height: 1.4;\n  color: @text-color;\n  background-color: @base-background-color;\n  overflow-x: auto;\n\n  // Overrides ----------------------\n\n  p {\n    line-height: inherit;\n  }\n\n  a {\n    color: @text-color-info;\n  }\n\n  ul {\n    padding-left: 2em;\n  }\n\n  label {\n    margin-top: 1em;\n    font-weight: normal;\n  }\n\n  .input-checkbox {\n    margin-top: -.2em;\n    margin-right: .5em;\n  }\n\n  // Components ----------------------\n\n  &-container {\n    width: 100%;\n    max-width: 580px;\n    min-width: 300px;\n    margin: auto;\n    padding: 3em 2em;\n  }\n\n  &-header {\n    margin: 0 0 3em 0;\n  }\n\n  &-logo {\n    display: block;\n    width: 100%;\n    max-width: 280px;\n    margin: 0 auto 2em auto;\n    color: @text-color-highlight;\n  }\n\n  &-title {\n    font-size: 1.4em;\n    text-align: center;\n    line-height: 1.3;\n    margin: 1em 0;\n  }\n\n  &-panel {\n  }\n\n  &-card {\n    margin: 1em 0;\n\n    border-radius: @component-border-radius*2;\n    border: 1px solid @base-border-color;\n    background-color: lighten(@base-background-color, 3%);\n  }\n\n  &-summary {\n    padding: 1em 1.5em;\n    font-size: 1.1em;\n    font-weight: 300;\n    line-height: 1.4;\n    cursor: pointer;\n    &:hover {\n      color: lighten(@text-color, 4%);\n    }\n    &::-webkit-details-marker {\n      display: none\n    }\n    &:before {\n      width: 20px;\n      color: @text-color-subtle;\n      details[open] & {\n        color: @text-color-highlight;\n      }\n    }\n    details[open] & {\n      color: @text-color-highlight;\n    }\n  }\n\n  &-highlight {\n    color: @text-color-highlight;\n  }\n\n  &-detail {\n    border-top: 1px solid @base-border-color;\n    padding: 1.5em;\n    .welcome-note {\n      margin-bottom: 0;\n    }\n    .btn {\n      margin-top: @component-padding/3;\n      margin-bottom: @component-padding/3;\n    }\n  }\n\n  &-img {\n    display: block;\n    max-width: 100%;\n    border-radius: 3px;\n    margin: 0 0 1em 0;\n    border: 1px solid @base-border-color;\n  }\n\n  &-consent {\n    margin-top: 3em;\n\n    &-choices {\n      display: flex;\n      flex-direction: row;\n      flex-wrap: wrap;\n      margin: 1em -1em;\n\n      button {\n        width: 100%\n      }\n\n      div {\n        margin: .5em 1em;\n        flex: 1;\n      }\n\n      .welcome-note {\n        margin-top: 1em;\n      }\n    }\n  }\n\n  &-key {\n    display: inline-block;\n    padding: .3em .4em;\n    font-size: .8em;\n    line-height: 1;\n    border-radius: 3px;\n    color: @text-color-highlight;\n    border: 1px solid @text-color-subtle;\n    background: hsla(0,0%,0%,.1);\n  }\n\n  &-love {\n    color: @text-color-subtle;\n    a { color: @text-color-subtle; }\n\n    .icon::before {\n      // Make these octicons look good inlined with text\n      position: relative;\n      top: 4px;\n      width: auto;\n      margin-right: 0;\n      font-size: 1.5em;\n    }\n\n    .icon-logo-github::before {\n      top: 2px;\n      font-size: 3.6em;\n      vertical-align: top;\n    }\n  }\n\n  &-note {\n    font-size: .86em;\n    color: @text-color-subtle;\n\n    .icon {\n      margin-left: 5px;\n    }\n\n    .icon::before {\n      margin-right: 0;\n    }\n  }\n\n  &-footer {\n    margin-top: 1em;\n    text-align: center;\n  }\n}\n',digest:"13f78956a7ccd8d76142e0f4c4466bd70f112ebd"},"node_modules/wrap-guide/styles/wrap-guide.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n@import "syntax-variables";\n\natom-text-editor {\n  .wrap-guide {\n    height: 100%;\n    width: 1px;\n    z-index: 3;\n    position: absolute;\n    top: 0;\n    background-color: @syntax-wrap-guide-color;\n    -webkit-transform: translateZ(0);\n    pointer-events: none;\n  }\n}\n',digest:"4f2ee93f69546025dc63fa9ef28b3e6d34bf6b4f"},"node_modules/atom-dark-ui/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// Atom Dark UI theme\n\n\n@import "styles/ui-variables.less";\n@import "styles/ui-mixins.less";\n\n@import "styles/atom.less";\n@import "styles/buttons.less";\n@import "styles/editor.less";\n@import "styles/git.less";\n@import "styles/lists.less";\n@import "styles/messages.less";\n@import "styles/nav.less";\n@import "styles/overlays.less";\n@import "styles/panels.less";\n@import "styles/panes.less";\n@import "styles/progress.less";\n@import "styles/sites.less";\n@import "styles/tabs.less";\n@import "styles/text.less";\n@import "styles/tooltips.less";\n@import "styles/tree-view.less";\n@import "styles/utilities.less";\n',digest:"d4e2b9c437a98b071fae1fccc4e273bfb5ecc05e"},"node_modules/atom-dark-ui/styles/atom.less":{content:"* {\n\tbox-sizing: border-box;\n}\n\natom-workspace {\n  background-color: @app-background-color;\n}\n\n.scrollbars-visible-always {\n  ::-webkit-scrollbar {\n    width: 10px;\n    height: 10px;\n  }\n\n  ::-webkit-scrollbar-track,\n  ::-webkit-scrollbar-corner {\n    background: @scrollbar-background-color;\n  }\n\n  ::-webkit-scrollbar-thumb {\n    background: @scrollbar-color;\n    border-radius: 5px;\n    box-shadow: 0 0 1px black inset;\n  }\n}\n",digest:"96a2721091b2920e94f88dc66c0970b5000e57bd"},"node_modules/atom-dark-ui/styles/buttons.less":{content:".btn-background (@color, @hover-color, @selected-color, @text-color) {\n  color: @text-color;\n  background-color: transparent;\n  background-image: -webkit-linear-gradient(@color, darken(@color, 5%));\n\n  &:focus {\n    color: @text-color;\n  }\n  &:hover {\n    color: @text-color-highlight;\n    background-image: -webkit-linear-gradient(@hover-color, darken(@hover-color, 5%));\n  }\n  &.selected,\n  &.selected:hover {\n    color: @text-color-highlight;\n    background-image: -webkit-linear-gradient(darken(@selected-color, 5%), @selected-color);\n    &:hover {\n      background-image: -webkit-linear-gradient(@selected-color, darken(@selected-color, 5%));\n    }\n  }\n}\n\n.btn-variant (@color) {\n  @bg: darken(@color, 10%);\n  @hover: @color;\n  @selected: @color;\n  .btn-background(@bg, @hover, @selected, @text-color-highlight);\n}\n\n.btn {\n  .btn-background(@button-background-color, @button-background-color-hover, @button-background-color-selected, @text-color);\n}\n\n.btn.btn-primary {\n  .btn-variant(@background-color-info);\n}\n.btn.btn-info {\n  .btn-variant(@background-color-info);\n}\n.btn.btn-success {\n  .btn-variant(@background-color-success);\n}\n.btn.btn-warning {\n  .btn-variant(@background-color-warning);\n}\n.btn.btn-error {\n  .btn-variant(@background-color-error);\n}\n\n.caret {\n  border-top: 5px solid #fff;\n  margin-top: -1px;\n}\n",digest:"0ebae011ad5dd7414185b6b4abc0809161b37c8f"},"node_modules/atom-dark-ui/styles/dropdowns.less":{content:".dropdown-menu {\n  background-color: @overlay-background-color;\n  border-radius: @component-border-radius;\n  border: 1px solid @base-border-color;\n  padding: 0;\n\n  > li > a {\n    .text(normal);\n  }\n\n  > li > a:hover {\n    .text(highlight);\n    background-color: @background-color-highlight;\n  }\n}\n",digest:"344a6a3a32a0e115652f60c7626fc93e1d2220c1"},"node_modules/atom-dark-ui/styles/editor.less":{content:"atom-text-editor[mini] {\n  color: @text-color-highlight;\n  background-color: @input-background-color;\n  border: 1px solid @input-border-color;\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);\n  border-radius: @component-border-radius;\n  padding-left: @component-padding/2;\n\n  .cursor { border-color: #fff; }\n  .selection .region { background-color: lighten(@input-background-color, 10%); }\n}\n\natom-text-editor[mini].is-focused {\n  background-color: lighten(@input-background-color, 5%);\n  .selection .region { background-color: desaturate(@background-color-info, 50%); }\n}\n\n// FIXME: these should go in syntax themes?\natom-text-editor {\n  .gutter.drop-shadow {\n    -webkit-box-shadow: -2px 0 10px 2px #222;\n  }\n}\n",digest:"103f4fb31d24dea86fdb95bca985829a49b36fd5"},"node_modules/atom-dark-ui/styles/git.less":{content:".status { .text(normal); }\n.status-added { .text(success); }\n.status-ignored { .text(subtle); }\n.status-modified { .text(warning); }\n.status-removed { .text(error); }\n.status-renamed { .text(info); }\n",digest:"44ecb1b340050a9a3e0cc05d8287a9749a6def83"},"node_modules/atom-dark-ui/styles/lists.less":{content:"@import \"octicon-mixins.less\"; // https://github.com/atom/atom/blob/master/static/variables/octicon-mixins.less\n\n.list-group, .list-tree {\n  li:not(.list-nested-item),\n  li.list-nested-item > .list-item {\n    .text(normal);\n  }\n\n  .generate-list-item-text-color(@class) {\n    li:not(.list-nested-item).text-@{class},\n    li.list-nested-item.text-@{class} > .list-item {\n      .text(@class);\n    }\n  }\n  .generate-list-item-text-color(subtle);\n  .generate-list-item-text-color(info);\n  .generate-list-item-text-color(success);\n  .generate-list-item-text-color(warning);\n  .generate-list-item-text-color(error);\n  .generate-list-item-text-color(selected);\n\n  .generate-list-item-status-color(@color, @status) {\n    li:not(.list-nested-item).status-@{status},\n    li.list-nested-item.status-@{status} > .list-item {\n      color: @color;\n    }\n\n    li:not(.list-nested-item).selected.status-@{status},\n    li.list-nested-item.selected.status-@{status} > .list-item {\n      color: @color;\n    }\n  }\n\n  .generate-list-item-status-color(@text-color-subtle, ignored);\n  .generate-list-item-status-color(@text-color-added, added);\n  .generate-list-item-status-color(@text-color-renamed, renamed);\n  .generate-list-item-status-color(@text-color-modified, modified);\n  .generate-list-item-status-color(@text-color-removed, removed);\n\n  li:not(.list-nested-item).selected,\n  li.list-nested-item.selected > .list-item {\n    .text(selected);\n  }\n}\n\n.select-list ol.list-group,\n&.select-list ol.list-group {\n  li.two-lines {\n    .secondary-line { color: @text-color-subtle; }\n    &.selected .secondary-line {\n      color: @text-color;\n      text-shadow: none;\n    }\n  }\n\n  // We want to highlight the background of the list items because we dont\n  // know their size.\n  li.selected {\n    background-color: @background-color-selected;\n    &:before{ display: none; }\n  }\n\n  &.mark-active{\n    @active-icon-size: 14px;\n\n    // pad in front of the text where the icon would be We'll pad the non-\n    // active items with a 'fake' icon so other classes can pad the item\n    // without worrying about the icon padding.\n    li:before {\n      content: '';\n      background-color: transparent;\n      position: static;\n      display: inline-block;\n      left: auto; right: auto;\n      height: @active-icon-size;\n      width: @active-icon-size;\n    }\n    > li:not(.active):before {\n      margin-right: @component-icon-padding;\n    }\n    li.active {\n      .octicon(check, @active-icon-size);\n      &:before {\n        margin-right: @component-icon-padding;\n        color: @text-color-success;\n      }\n    }\n  }\n}\n\n.select-list.popover-list {\n  background-color: @overlay-background-color;\n  box-shadow: 0 0 10px @base-border-color;\n  padding: @component-padding/2;\n  border-radius: @component-border-radius;\n  border: 1px solid @overlay-border-color;\n\n  atom-text-editor {\n    margin-bottom: @component-padding/2;\n  }\n\n  .list-group li {\n    padding-left: @component-padding/2;\n  }\n}\n\n.ui-sortable {\n  li {\n    line-height: 2.5;\n  }\n\n  // For sortable lists in the settings view\n  li.ui-sortable-placeholder {\n    visibility: visible !important;\n    background-color: darken(@pane-item-background-color, 10%);\n  }\n}\n\nli.ui-draggable-dragging, li.ui-sortable-helper {\n  line-height: @component-line-height;\n  height: @component-line-height;\n  border: 0;\n  border-radius: 0;\n  list-style: none;\n  padding: 0 @component-padding;\n  background: @background-color-highlight;\n  box-shadow: 0 0 1px @base-border-color;\n}\n",digest:"02b928638c2be04fefcab92f7741cf0b25c91ee4"},"node_modules/atom-dark-ui/styles/messages.less":{content:"ul.background-message {\n  font-weight: bold;\n  color: rgba(0, 0, 0, .2);\n}\n",digest:"a3796459cfcaa7f495cc023ae8fd6a74f1621cdc"},"node_modules/atom-dark-ui/styles/nav.less":{content:".nav-tabs {\n  border-bottom: 1px solid @base-border-color;\n  li {\n    a,\n    &.active a {\n      border: none;\n      margin-right: 0px;\n      margin-bottom: 1px;\n    }\n\n    a:hover,\n    &.active a,\n    &.active a:hover {\n      background-color: @background-color-highlight;\n      border: none;\n      color: @text-color-selected;\n      border-bottom-left-radius: 0px;\n      border-bottom-right-radius: 0px;\n    }\n\n    &.active a {\n      background-color: @tab-background-color-active;\n    }\n  }\n}\n",digest:"54ed0e49741845e8799c9513ae21ca7ae75f751d"},"node_modules/atom-dark-ui/styles/overlays.less":{content:"atom-panel.modal, .overlay {\n  color: @text-color;\n  background-color: @overlay-background-color;\n  padding: @component-padding;\n  border: 1px solid @overlay-border-color;\n  box-shadow: 0 0 10px @base-border-color;\n  border-radius: @component-border-radius;\n\n  atom-text-editor[mini] {\n    margin-bottom: @component-padding;\n  }\n\n  .select-list ol.list-group,\n  &.select-list ol.list-group {\n\n    background-color: lighten(@overlay-background-color, 3%);\n\n    li {\n      padding: @component-padding;\n      border-bottom: 1px solid @overlay-background-color;\n\n      &.two-lines { padding: @component-padding/2 @component-padding; }\n\n      .status.icon {\n        float: right;\n        margin-left: @component-icon-padding;\n        &:before {\n          margin-right: 0;\n        }\n      }\n\n      &.selected {\n        .status.icon {\n          color: @text-color-selected;\n        }\n      }\n    }\n  }\n}\n",digest:"3053ca4b4afe70ea0aa76744fa402dfa1eea99c6"},"node_modules/atom-dark-ui/styles/panels.less":{content:'@import "buttons.less";\n\n.panel {\n  &.bordered {\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n  }\n}\n\natom-panel, .tool-panel {\n  .text(normal);\n  position: relative;\n\n  background-color: @tool-panel-background-color;\n\n  &.bottom, &.panel-bottom,\n  &.footer, &.panel-footer {\n    border-top: 1px solid @tool-panel-border-color;\n    box-shadow: inset 0 1px 0 @background-color-highlight;\n  }\n\n  &.left, &.panel-left {\n    border-right: 1px solid @tool-panel-border-color;\n  }\n\n  &.right, &.panel-right {\n    border-left: 1px solid @tool-panel-border-color;\n  }\n}\n\n.inset-panel {\n  position: relative;\n  background-color: @inset-panel-background-color;\n}\n\n.is-blurred {\n  atom-panel,\n  .inset-panel {\n  }\n}\n\n.panel-heading {\n  .text(normal);\n\n  border-bottom: 1px solid @panel-heading-border-color;\n  border-top: 1px solid fadein(@background-color-highlight, 10%);\n\n  background-color: transparent;\n  background-image: -webkit-linear-gradient(@panel-heading-background-color, darken(@panel-heading-background-color, 10%));\n\n  .btn {\n    padding-left: 8px;\n    padding-right: 8px;\n\n    @bg: lighten(@button-background-color, 10%);\n    @hover: lighten(@button-background-color-hover, 10%);\n    @selected: lighten(@button-background-color-selected, 10%);\n    @text: lighten(@text-color, 10%);\n    .btn-background(@bg, @hover, @selected, @text);\n  }\n}\n',digest:"6eb1a666135894c46bf9fe19e68c2fd1c13d00b7"},"node_modules/atom-dark-ui/styles/panes.less":{content:".pane-item {\n  .panel {\n    border-color: fadeout(@inset-panel-border-color, 30%);\n  }\n}\n\natom-pane-container {\n  atom-pane {\n    background-color: lighten(@app-background-color, 4%);\n\n    &:focus {\n      background-color: @app-background-color;\n    }\n  }\n\n  atom-pane-axis.horizontal > * {\n    border-right: 1px solid @pane-item-border-color;\n    &:last-child { border-right: none; }\n  }\n\n  atom-pane-axis.vertical > * {\n    border-bottom: 1px solid @pane-item-border-color;\n    &:last-child { border-bottom: none; }\n  }\n}\n",digest:"ac0a9c16483bd378e2ca910040813673cd8971a8"},"node_modules/atom-dark-ui/styles/progress.less":{content:".loading-spinner(@size) {\n  width: @size;\n  height: @size;\n  display: block;\n\n  background-image: url(images/octocat-spinner-128.gif);\n  background-repeat: no-repeat;\n  background-size: cover;\n\n  &.inline-block {\n    display: inline-block;\n  }\n}\n\n.loading-spinner-large {\n  .loading-spinner(64px);\n}\n\n.loading-spinner-medium {\n  .loading-spinner(50px);\n}\n\n.loading-spinner-small {\n  .loading-spinner(32px);\n}\n\n.loading-spinner-tiny {\n  .loading-spinner(20px);\n}\n\n// Much learning from:\n// http://css-tricks.com/html5-progress-element/\n\n@progress-height: 16px;\n@progress-shine-gradient: -webkit-linear-gradient(top, rgba(255, 255, 255, .15), rgba(0, 0, 0, .15));\n\nprogress {\n  height: @progress-height;\n  -webkit-appearance: none;\n  border-radius: @component-border-radius;\n  background-color: #666;\n  background-image:\n     -webkit-linear-gradient(-30deg,\n                             transparent 33%, rgba(0, 0, 0, .1) 33%,\n                             rgba(0,0, 0, .1) 66%, transparent 66%),\n                             @progress-shine-gradient;\n  border-radius: 2px;\n  background-size: 25px @progress-height, 100% 100%, 100% 100%;\n  -webkit-animation: animate-stripes 5s linear 6; // stop animation after 6 runs (30s) to limit CPU usage\n}\n\nprogress::-webkit-progress-bar {\n  background-color: transparent;\n}\n\nprogress::-webkit-progress-value {\n  border-radius: @component-border-radius;\n  background-image: @progress-shine-gradient;\n  background-color: @background-color-success;\n}\n\nprogress[value] {\n  background-image: @progress-shine-gradient;\n  -webkit-animation: none;\n}\n\n@-webkit-keyframes animate-stripes {\n   100% { background-position: 100px 0px; }\n}\n",digest:"6f6556507a757e65b044f4a4e54c026c0c83f92f"},"node_modules/atom-dark-ui/styles/sites.less":{content:".ui-site(@num, @color) {\n  .ui-site-@{num} {\n    background-color: @color;\n  }\n}\n\n.ui-site(1, @ui-site-color-1);\n.ui-site(2, @ui-site-color-2);\n.ui-site(3, @ui-site-color-3);\n.ui-site(4, @ui-site-color-4);\n.ui-site(5, @ui-site-color-5);\n",digest:"0c4862fe989b8170bace51c17b9dd6201062ca62"},"node_modules/atom-dark-ui/styles/tabs.less":{content:"@tab-radius: 3px;\n@modified-icon-width: 8px;\n@tab-skew: 30deg;\n@tab-top-padding: 5px;\n@tab-bottom-border-height: 5px;\n@tab-border: 1px solid @tab-border-color;\n@tab-bar-bottom-border-color: #111;\n@tab-max-width: 160px;\n\n.tab-bar {\n  height: @tab-height + @tab-top-padding + @tab-bottom-border-height;\n  background: @tab-bar-background-color;\n  box-shadow: inset 0 -8px 8px -4px rgba(0,0,0, .15);\n  padding: 0 10px 0 25px;\n  overflow-x: auto;\n  overflow-y: hidden;\n\n  &::-webkit-scrollbar {\n    display: none;\n  }\n\n  .tab {\n    position: relative;\n    top: @tab-top-padding;\n    max-width: @tab-max-width;\n    height: @tab-height;\n    line-height: @tab-height;\n    padding: 0;\n    margin: 0 20px 0 5px;\n    color: @text-color;\n\n    transition: color .1s ease-in;\n    border: none;\n\n    &, &:before, &:after {\n      background-image: -webkit-linear-gradient(top, lighten(#333, 7%), #333);\n      height: @tab-height;\n    }\n\n    &:before, &:after {\n      content: '';\n      position: absolute;\n      top: 0px;\n      width: 25px;\n      height: @tab-height;\n    }\n\n    // left angled edge\n    &:before {\n      left: -14px;\n      border-top-left-radius: @tab-radius;\n      box-shadow: inset 1px 1px 0 @tab-border-color, -4px 0px 4px rgba(0,0,0,.1);\n      -webkit-transform: skewX(-@tab-skew);\n    }\n\n    // right angled edge\n    &:after {\n      right: -14px;\n      border-top-right-radius: @tab-radius;\n      box-shadow: inset -1px 1px 0 @tab-border-color, 4px 0px 4px rgba(0,0,0,.1);\n      -webkit-transform: skewX(@tab-skew);\n    }\n\n    .close-icon {\n      right: 0;\n      z-index: 3;\n      text-align: right;\n      line-height: @tab-height;\n      color: @text-color;\n\n      &:hover {\n        color: inherit;\n      }\n    }\n\n    &.modified:not(:hover) .close-icon {\n      right: 0;\n      top: @tab-height/2 - @modified-icon-width/2 + 1px;\n      width: @modified-icon-width;\n      height: @modified-icon-width;\n    }\n\n    &.modified:hover .close-icon:hover {\n      color: @text-color-highlight;\n    }\n\n    .title {\n      position: relative;\n      z-index: 1;\n      margin-top: -@tab-top-padding;\n      padding-top: @tab-top-padding;\n      padding-right: 10px;\n    }\n  }\n\n  .tab.active {\n    z-index: 1;\n    color: @text-color-highlight;\n    box-shadow: inset -1px 1px 0 @tab-border-color, 4px -4px 4px rgba(0,0,0,.1);\n\n    .close-icon {\n      line-height: @tab-height - 1px;\n      color: @text-color;\n    }\n\n    &, &:before, &:after {\n      background-image: -webkit-linear-gradient(top, lighten(@tab-background-color-active, 7%), @tab-background-color-active);\n      height: @tab-height + 1px;\n    }\n\n    &:before {\n      box-shadow: inset 1px 1px 0 @tab-border-color, -4px -4px 4px rgba(0,0,0,.1);\n    }\n\n    &:after {\n      box-shadow: inset -1px 1px 0 @tab-border-color, 4px -4px 4px rgba(0,0,0,.1);\n    }\n  }\n\n  .tab:hover {\n    color: @text-color-highlight;\n  }\n\n  .tab.active:hover .close-icon {\n    color: @text-color;\n\n    &:hover {\n      color: inherit;\n    }\n  }\n\n  .placeholder {\n    height: @tab-height + @tab-top-padding + @tab-bottom-border-height;\n    pointer-events: none;\n    &:before {\n      margin-left: -9px; // center between tabs\n    }\n    &:after {\n      top: @tab-height + @tab-top-padding + @tab-bottom-border-height - 2px;\n      margin-left: -10px; // center between tabs\n    }\n  }\n}\n\n// border\n.tab-bar + .item-views::before {\n  content: \"\";\n  position: absolute;\n  top: -5px;\n  height: @tab-bottom-border-height;\n  left: 0;\n  right: 0;\n  background-color: @tab-background-color-active;\n  border-top: 1px solid @tab-border-color;\n  border-bottom: 1px solid @tab-bar-bottom-border-color;\n  pointer-events: none;\n}\n",digest:"e079a0e71f4dae53349aa6692502f53f32fca4fe"},"node_modules/atom-dark-ui/styles/text.less":{content:"h1,\nh2,\nh3 {\n  line-height: 1em;\n  margin-bottom: 15px\n}\nh1 { font-size: 2em; }\nh2 { font-size: 1.5em; }\nh3 { font-size: 1.2em; }\n\np {\n  line-height: 1.6;\n  margin-bottom: 15px;\n}\n\nlabel {\n  font-weight: normal;\n}\n\npre {\n  box-shadow: none;\n  color: @text-color;\n  background: @inset-panel-background-color;\n  border-radius: @component-border-radius;\n  border: none;\n  margin: 0;\n}\n\ncode {\n  .text(highlight);\n  background: @background-color-highlight;\n  border-radius: @component-border-radius;\n}\n\n.markdown-preview code {\n  text-shadow: none;\n}\n\n.selected { .text(highlight); }\n\n.text-smaller { font-size: 0.9em; }\n\n.text-subtle { .text(subtle); }\n.text-highlight { .text(highlight); }\n\n.text-error { .text(error); }\n.text-info {\n  .text(info);\n  &:hover { color: @text-color-info; }\n}\n.text-warning {\n  .text(warning);\n  &:hover { color: @text-color-warning; }\n}\n.text-success {\n  .text(success);\n  &:hover { color: @text-color-success; }\n}\n\n.highlight {\n  color: @text-color-highlight;\n  font-weight: bold;\n  text-shadow: none;\n  background-color: @background-color-highlight;\n  border-radius: @component-border-radius;\n  padding: 1px 3px;\n}\n\n.highlight-color(@name, @color, @text-color) {\n  .highlight-@{name} {\n    color: lighten(saturate(@text-color, 0%), 30%);\n    font-weight: bold;\n    text-shadow: none;\n    background-color: fadeout(@color, 60%);\n    border-radius: @component-border-radius;\n    padding: 1px 3px;\n  }\n}\n.highlight-color(info, @background-color-info, @text-color-info);\n.highlight-color(warning, @background-color-warning, @text-color-warning);\n.highlight-color(error, @background-color-error, @text-color-error);\n.highlight-color(success, @background-color-success, @text-color-success);\n\n.results-view .path-details.list-item {\n  color: darken(@text-color-highlight, 18%);\n}\n",digest:"df657ac01f891767336c4c331fde07a4ff8e9f47"},"node_modules/atom-dark-ui/styles/tooltips.less":{content:".tooltip {\n  @tip-background-color: #fff;\n  @tip-text-color: #333;\n  white-space: nowrap;\n\n  .keystroke {\n    font-family: Helvetica, Arial, sans-serif;\n    font-size: 13px;\n    color: #777;\n    padding-left: 2px;\n  }\n\n  &.in { opacity: 1; }\n\n  .tooltip-inner {\n    line-height: 19px;\n    border-radius: @component-border-radius;\n    background-color: @tip-background-color;\n    color: @tip-text-color;\n    white-space: nowrap;\n    max-width: none;\n  }\n\n  &.top .tooltip-arrow {\n    border-top-color: @tip-background-color;\n  }\n  &.top-left .tooltip-arrow {\n    border-top-color: @tip-background-color;\n  }\n  &.top-right .tooltip-arrow {\n    border-top-color: @tip-background-color;\n  }\n  &.right .tooltip-arrow {\n    border-right-color: @tip-background-color;\n  }\n  &.left .tooltip-arrow {\n    border-left-color: @tip-background-color;\n  }\n  &.bottom .tooltip-arrow {\n    border-bottom-color: @tip-background-color;\n  }\n  &.bottom-left .tooltip-arrow {\n    border-bottom-color: @tip-background-color;\n  }\n  &.bottom-right .tooltip-arrow {\n    border-bottom-color: @tip-background-color;\n  }\n}\n",digest:"d2a37b596041770c1606f90975b63a1c3b29d176"},"node_modules/atom-dark-ui/styles/tree-view.less":{content:".tree-view {\n  font-size: @font-size;\n  background: @tree-view-background-color;\n\n  .selected:before {\n    background: #444;\n    box-shadow: inset -3px 0 0 rgba(0,0,0, .05);\n  }\n}\n\n.tree-view-resizer {\n  .tree-view-resize-handle {\n    width: 8px;\n  }\n}\n\n.focusable-panel {\n  opacity: 1;\n  box-shadow: inset -3px 0 0 rgba(0,0,0, .05);\n\n  &:focus {\n    background: #282828;\n\n    .selected:before {\n      background: @background-color-selected;\n    }\n  }\n}\n\n[data-show-on-right-side=true] {\n  .tree-view .selected:before,\n  .focusable-panel {\n    box-shadow: inset 3px 0 0 rgba(0,0,0, .05);\n  }\n}\n",digest:"b302d313bc3a743ed798bee862494e594350c16e"},"node_modules/atom-dark-ui/styles/ui-mixins.less":{content:"// Pattern matching; ish is cray.\n// http://lesscss.org/#-pattern-matching-and-guard-expressions\n.text(normal) {\n  font-weight: normal;\n  color: @text-color;\n  text-shadow: none;\n}\n.text(subtle) {\n  font-weight: normal;\n  color: @text-color-subtle;\n  text-shadow: none;\n}\n.text(highlight) {\n  font-weight: normal;\n  color: @text-color-highlight;\n  text-shadow: 0 1px 0 rgba(0,0,0, .5);\n}\n.text(selected) {\n  .text(highlight)\n}\n\n.text(info) {\n  color: @text-color-info;\n  text-shadow: none;\n}\n.text(success) {\n  color: @text-color-success;\n  text-shadow: none;\n}\n.text(warning) {\n  color: @text-color-warning;\n  text-shadow: none;\n}\n.text(error) {\n  color: @text-color-error;\n  text-shadow: none;\n}\n",digest:"14f1ba6503b5be697c85169d16e1a3d388dc5999"},"node_modules/atom-dark-ui/styles/ui-variables.less":{content:"// Colors\n\n@text-color: #aaa;\n@text-color-subtle: #555;\n@text-color-highlight: #fff;\n@text-color-selected: @text-color-highlight;\n\n@text-color-info: #5293d8;\n@text-color-success: #2BDA77;\n@text-color-warning: #ff982d;\n@text-color-error: #c00;\n\n@text-color-ignored: @text-color-subtle;\n@text-color-added: @text-color-success;\n@text-color-renamed: @text-color-info;\n@text-color-modified: @text-color-warning;\n@text-color-removed: @text-color-error;\n\n@background-color-info: #0098ff;\n@background-color-success: #17ca65;\n@background-color-warning: #ffaa2c;\n@background-color-error: #c00;\n@background-color-highlight: rgba(255, 255, 255, 0.07);\n@background-color-selected: #4182C4;\n\n@app-background-color: #333;\n\n@base-background-color: lighten(@tool-panel-background-color, 5%);\n@base-border-color: rgba(0, 0, 0, 0.5);\n\n@pane-item-background-color: @base-background-color;\n@pane-item-border-color: rgba(0, 0, 0, 0.5);\n\n@input-background-color: #212224;\n@input-border-color: @base-border-color;\n\n@tool-panel-background-color: #1d1f21;\n@tool-panel-border-color: @base-border-color;\n\n@inset-panel-background-color: #161719;\n@inset-panel-border-color: @base-border-color;\n\n@panel-heading-background-color: #43484d;\n@panel-heading-border-color: fadein(@base-border-color, 10%);\n\n@overlay-background-color: #202123;\n@overlay-border-color: @background-color-highlight;\n\n@button-background-color: #43484d;\n@button-background-color-hover: lighten(@button-background-color, 5%);\n@button-background-color-selected: #5c6064;\n@button-border-color: @base-border-color;\n\n@tab-bar-background-color: #222;\n@tab-bar-border-color: darken(@tab-background-color-active, 10%);\n@tab-background-color: #333;\n@tab-background-color-active: #222;\n@tab-border-color: #484848;\n\n@tree-view-background-color: #303030;\n@tree-view-border-color: @tool-panel-border-color;\n\n@scrollbar-background-color: #222425; // Needs to be opaque -> atom/atom/issues/4578\n@scrollbar-color: rgba(92, 92, 92, 0.5);\n\n@ui-site-color-1: @background-color-success; // green\n@ui-site-color-2: @background-color-info; // blue\n@ui-site-color-3: @background-color-warning; // orange\n@ui-site-color-4: #db2ff4; // purple\n@ui-site-color-5: #f5e11d; // yellow\n\n\n// Sizes\n\n@font-size: 11px;\n@input-font-size: 14px;\n\n@disclosure-arrow-size: 12px;\n\n@component-padding: 10px;\n@component-icon-padding: 5px;\n@component-icon-size: 16px;\n@component-line-height: 25px;\n@component-border-radius: 2px;\n\n@tab-height: 26px;\n\n\n// Other\n\n@font-family: system-ui;\n",digest:"bbc53164b15cea5f3aeeddd1ea77a4e7bd5f8503"},"node_modules/atom-dark-ui/styles/utilities.less":{content:".key-binding {\n  background: -webkit-linear-gradient(\n    rgba(100, 100, 100, 0.5),\n    rgba(70,70,70, 0.5));\n  -webkit-box-shadow: inset 1px 1px 0 rgba(255, 255, 255, 0.1);\n  display: inline-block;\n  line-height: 100%;\n  border-radius: @component-border-radius;\n  margin-left: @component-icon-padding;\n  font-family: Helvetica, Arial, sans-serif;\n  font-size: @font-size - 1px;\n  padding: @component-padding / 2;\n}\n\n.badge {\n  .text(highlight);\n  background: @background-color-highlight;\n}\n",digest:"1dcd44dd5d9819f6e83754118526c71046d13324"},"node_modules/atom-dark-syntax/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// Atom Dark Syntax theme\n\n@import "styles/syntax-variables.less";\n\n@import "styles/editor.less";\n@import "styles/syntax.less";\n',digest:"fefd6d4c57c776dc75502cb893663cf4656223e3"},"node_modules/atom-dark-syntax/styles/editor.less":{content:"atom-text-editor {\n  background-color: @syntax-background-color;\n  color: @syntax-text-color;\n\n  .invisible-character {\n    color: @syntax-invisible-character-color;\n  }\n\n  .indent-guide {\n    color: @syntax-indent-guide-color;\n  }\n\n  .wrap-guide {\n    background-color: @syntax-wrap-guide-color;\n  }\n\n  .gutter {\n    background-color: @syntax-gutter-background-color;\n  }\n  .gutter .cursor-line {\n    background-color: @syntax-gutter-background-color-selected;\n  }\n  .line-number.cursor-line-no-selection {\n    background-color: @syntax-gutter-background-color-selected;\n  }\n\n  .gutter .line-number.folded,\n  .gutter .line-number:after,\n  .fold-marker:after {\n    color: #fba0e3;\n  }\n\n  .invisible {\n    color: @syntax-text-color;\n  }\n\n  .cursor {\n    border-color: @syntax-cursor-color;\n  }\n\n  .selection .region {\n    background-color: @syntax-selection-color;\n  }\n\n  .bracket-matcher .region {\n    border-bottom: 1px solid #f8de7e;\n    margin-top: -1px;\n    opacity: .7;\n  }\n}\n",digest:"cfd42122f58176e934fcce4e189aa09e8e559d5c"},"node_modules/atom-dark-syntax/styles/syntax-variables.less":{content:"// This defines all syntax variables that syntax themes must implement when they\n// include a syntax-variables.less file.\n\n// General colors\n@syntax-text-color: #c5c8c6;\n@syntax-cursor-color: white;\n@syntax-selection-color: #444;\n@syntax-selection-flash-color: #eee;\n@syntax-background-color: #1d1f21;\n\n// Guide colors\n@syntax-wrap-guide-color: rgba(197, 200, 198, .1);\n@syntax-indent-guide-color: rgba(197, 200, 198, .2);\n@syntax-invisible-character-color: rgba(197, 200, 198, .2);\n\n// For find and replace markers\n@syntax-result-marker-color: #888;\n@syntax-result-marker-color-selected: white;\n\n// Gutter colors\n@syntax-gutter-text-color: @syntax-text-color;\n@syntax-gutter-text-color-selected: @syntax-gutter-text-color;\n@syntax-gutter-background-color: lighten(@syntax-background-color, 5%);\n@syntax-gutter-background-color-selected: rgba(255, 255, 255, 0.14);\n\n// For git diff info. i.e. in the gutter\n@syntax-color-renamed: #96CBFE;\n@syntax-color-added: #A8FF60;\n@syntax-color-modified: #E9C062;\n@syntax-color-removed: #CC6666;\n\n// For language entity colors\n@syntax-color-variable: #C6C5FE;\n@syntax-color-constant: #99CC99;\n@syntax-color-property: #EDEDED;\n@syntax-color-value: #F9EE98;\n@syntax-color-function: #DAD085;\n@syntax-color-method: @syntax-color-function;\n@syntax-color-class: #62B1FE;\n@syntax-color-keyword: #96CBFE;\n@syntax-color-tag: #96CBFE;\n@syntax-color-attribute: #FF73FD;\n@syntax-color-import: @syntax-color-keyword;\n@syntax-color-snippet: @syntax-color-constant;\n",digest:"b7efcf47ee4d31f39f5855b416efe692e2a1be03"},"node_modules/atom-dark-syntax/styles/syntax.less":{content:".syntax--comment {\n  color: #8a8a8a;\n}\n\n.syntax--entity {\n  color: #FFD2A7;\n\n  &.syntax--name.syntax--type {\n    text-decoration: underline;\n    color: #FFFFB6;\n  }\n\n  &.syntax--other.syntax--inherited-class {\n    color: #9B5C2E;\n  }\n}\n\n.syntax--keyword {\n  color: #96CBFE;\n\n  &.syntax--control {\n    color: #96CBFE;\n  }\n\n  &.syntax--operator {\n    color: #EDEDED;\n  }\n}\n\n.syntax--storage {\n  color: #CFCB90;\n\n  &.syntax--modifier {\n    color: #96CBFE;\n  }\n}\n\n.syntax--constant {\n  color: #99CC99;\n\n  &.syntax--numeric {\n    color: #FF73FD;\n  }\n}\n\n.syntax--variable {\n  color: #C6C5FE;\n}\n\n.syntax--invalid.syntax--deprecated {\n  text-decoration: underline;\n  color: #FD5FF1;\n}\n\n.syntax--invalid.syntax--illegal {\n  color: #FD5FF1;\n  background-color: rgba(86, 45, 86, 0.75);\n}\n\n// String interpolation in Ruby, CoffeeScript, and others\n.syntax--string {\n  .syntax--source,\n  .syntax--meta.syntax--embedded.syntax--line {\n    color: #EDEDED;\n  }\n\n  .syntax--punctuation.syntax--section.syntax--embedded {\n    color: #00A0A0;\n\n    .syntax--source {\n      color: #00A0A0;  // Required for the end of embedded strings in Ruby #716\n    }\n  }\n}\n\n.syntax--string {\n  color: #A8FF60;\n\n  .syntax--constant {\n    color: #00A0A0;\n  }\n\n  &.syntax--regexp {\n    color: #E9C062;\n\n    .syntax--constant.syntax--character.syntax--escape,\n    .syntax--source.syntax--ruby.syntax--embedded,\n    .syntax--string.syntax--regexp.syntax--arbitrary-repetition {\n      color: #FF8000;\n    }\n\n    &.syntax--group {\n      color: #C6A24F;\n      background-color: rgba(255, 255, 255, 0.06);\n    }\n\n    &.syntax--character-class {\n      color: #B18A3D;\n    }\n  }\n\n  .syntax--variable {\n    color: #8A9A95;\n  }\n}\n\n.syntax--support {\n  color: #FFFFB6;\n\n  &.syntax--function {\n    color: #DAD085;\n  }\n\n  &.syntax--constant {\n    color: #FFD2A7;\n  }\n\n  &.syntax--type.syntax--property-name.syntax--css {\n    color: #EDEDED;\n  }\n}\n\n.syntax--source .syntax--entity.syntax--name.syntax--tag,\n.syntax--source .syntax--punctuation.syntax--tag {\n  color: #96CBFE;\n}\n.syntax--source .syntax--entity.syntax--other.syntax--attribute-name {\n  color: #FF73FD;\n}\n\n.syntax--entity {\n  &.syntax--other.syntax--attribute-name {\n    color: #FF73FD;\n  }\n\n  &.syntax--name.syntax--tag.syntax--namespace,\n  &.syntax--other.syntax--attribute-name.syntax--namespace {\n    color: #E18964;\n  }\n}\n\n.syntax--meta {\n  &.syntax--preprocessor.syntax--c {\n    color: #8996A8;\n  }\n\n  &.syntax--preprocessor.syntax--c .syntax--keyword {\n    color: #AFC4DB;\n  }\n\n  &.syntax--cast {\n    color: #676767;\n  }\n\n  &.syntax--sgml.syntax--html .syntax--meta.syntax--doctype,\n  &.syntax--sgml.syntax--html .syntax--meta.syntax--doctype .syntax--entity,\n  &.syntax--sgml.syntax--html .syntax--meta.syntax--doctype .syntax--string,\n  &.syntax--xml-processing,\n  &.syntax--xml-processing .syntax--entity,\n  &.syntax--xml-processing .syntax--string {\n    color: #8a8a8a;\n  }\n\n  &.syntax--tag .syntax--entity,\n  &.syntax--tag > .syntax--punctuation,\n  &.syntax--tag.syntax--inline .syntax--entity {\n    color: #FF73FD;\n  }\n  &.syntax--tag .syntax--name,\n  &.syntax--tag.syntax--inline .syntax--name,\n  &.syntax--tag > .syntax--punctuation {\n    color: #96CBFE;\n  }\n\n  &.syntax--selector.syntax--css .syntax--entity.syntax--name.syntax--tag {\n    text-decoration: underline;\n    color: #96CBFE;\n  }\n\n  &.syntax--selector.syntax--css .syntax--entity.syntax--other.syntax--attribute-name.syntax--tag.syntax--pseudo-class {\n    color: #8F9D6A;\n  }\n\n  &.syntax--selector.syntax--css .syntax--entity.syntax--other.syntax--attribute-name.syntax--id {\n    color: #8B98AB;\n  }\n\n  &.syntax--selector.syntax--css .syntax--entity.syntax--other.syntax--attribute-name.syntax--class {\n    color: #62B1FE;\n  }\n\n  &.syntax--property-group .syntax--support.syntax--constant.syntax--property-value.syntax--css,\n  &.syntax--property-value .syntax--support.syntax--constant.syntax--property-value.syntax--css {\n    color: #F9EE98;\n  }\n\n  &.syntax--preprocessor.syntax--at-rule .syntax--keyword.syntax--control.syntax--at-rule {\n    color: #8693A5;\n  }\n\n  &.syntax--property-value .syntax--support.syntax--constant.syntax--named-color.syntax--css,\n  &.syntax--property-value .syntax--constant {\n    color: #87C38A;\n  }\n\n  &.syntax--constructor.syntax--argument.syntax--css {\n    color: #8F9D6A;\n  }\n\n  &.syntax--diff,\n  &.syntax--diff.syntax--header {\n    color: #F8F8F8;\n    background-color: #0E2231;\n  }\n\n  &.syntax--separator {\n    color: #60A633;\n    background-color: #242424;\n  }\n\n  &.syntax--line.syntax--entry.syntax--logfile,\n  &.syntax--line.syntax--exit.syntax--logfile {\n    background-color: rgba(238, 238, 238, 0.16);\n  }\n\n  &.syntax--line.syntax--error.syntax--logfile {\n    background-color: #751012;\n  }\n}\n\n// Markdown Styles\n.syntax--source.syntax--gfm {\n  color: #999;\n}\n\n.syntax--gfm {\n  .syntax--markup.syntax--heading {\n    color: #eee;\n  }\n\n  .syntax--link {\n    color: #555;\n  }\n\n  .syntax--variable.syntax--list,\n  .syntax--support.syntax--quote {\n    color: #555;\n  }\n\n  .syntax--link .syntax--entity {\n    color: #ddd;\n  }\n\n  .syntax--raw {\n    color: #aaa;\n  }\n}\n\n.syntax--markdown {\n  .syntax--paragraph {\n    color: #999;\n  }\n\n  .syntax--heading {\n    color: #eee;\n  }\n\n  .syntax--raw {\n    color: #aaa;\n  }\n\n  .syntax--link {\n    color: #555;\n\n    .syntax--string {\n      color: #555;\n\n      &.syntax--title {\n        color: #ddd;\n      }\n    }\n  }\n}\n",digest:"c104556648a6a3c59966e296413294952481e948"},"node_modules/atom-light-syntax/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// Atom Light Syntax theme\n\n@import "styles/syntax-variables.less";\n\n@import \'styles/editor.less\';\n@import \'styles/syntax.less\';\n',digest:"d496caa4d3f23f29c6516032ef78a1f9b726ead5"},"node_modules/atom-light-syntax/styles/editor.less":{content:"atom-text-editor {\n  background-color: @syntax-background-color;\n  color: @syntax-text-color;\n\n  .invisible-character {\n    color: @syntax-invisible-character-color;\n  }\n\n  .indent-guide {\n    color: @syntax-indent-guide-color;\n  }\n\n  .wrap-guide {\n    background-color: @syntax-wrap-guide-color;\n  }\n\n  .gutter {\n    color: @syntax-gutter-text-color;\n    background: @syntax-gutter-background-color;\n  }\n\n  .gutter .line-number.folded,\n  .gutter .line-number:after,\n  .fold-marker:after {\n    color: #e87b00;\n  }\n\n  .invisible {\n    color: #555;\n  }\n\n  .selection .region {\n    background-color: #e1e1e1;\n  }\n\n  .bracket-matcher .region {\n    background-color: #C9C9C9;\n    opacity: .7;\n    border-bottom: 0 none;\n  }\n\n  &.is-focused {\n    .cursor {\n      border-color: @syntax-cursor-color;\n    }\n\n    .selection .region {\n      background-color: @syntax-selection-color;\n    }\n\n    .line-number.cursor-line-no-selection,\n    .line.cursor-line {\n      background-color: @syntax-gutter-background-color-selected;\n    }\n  }\n}\n",digest:"a76ff77de523f8ae1d8e5b0aaaa0fe718fcad657"},"node_modules/atom-light-syntax/styles/syntax-variables.less":{content:"// This defines all syntax variables that syntax themes must implement when they\n// include a syntax-variables.less file.\n\n// General colors\n@syntax-text-color: #555;\n@syntax-cursor-color: black;\n@syntax-selection-color: #afc4da;\n@syntax-selection-flash-color: #69c;\n@syntax-background-color: white;\n\n// Guide colors\n@syntax-wrap-guide-color: rgba(85, 85, 85, .2);\n@syntax-indent-guide-color: rgba(85, 85, 85, .2);\n@syntax-invisible-character-color: rgba(85, 85, 85, .2);\n\n// For find and replace markers\n@syntax-result-marker-color: #999;\n@syntax-result-marker-color-selected: black;\n\n// Gutter colors\n@syntax-gutter-text-color: @syntax-text-color;\n@syntax-gutter-text-color-selected: @syntax-gutter-text-color;\n@syntax-gutter-background-color: white;\n@syntax-gutter-background-color-selected: rgba(255, 255, 134, 0.34);\n\n// For git diff info. i.e. in the gutter\n@syntax-color-renamed: #96CBFE;\n@syntax-color-added: #718C00;\n@syntax-color-modified: #ff982d;\n@syntax-color-removed: #D14;\n\n// For language entity colors\n@syntax-color-variable: #008080;\n@syntax-color-constant: #099;\n@syntax-color-property: #333;\n@syntax-color-value: @syntax-color-constant;\n@syntax-color-function: #900;\n@syntax-color-method: @syntax-color-function;\n@syntax-color-class: #606aa1;\n@syntax-color-keyword: #222;\n@syntax-color-tag: #008080;\n@syntax-color-attribute: #458;\n@syntax-color-import: @syntax-color-keyword;\n@syntax-color-snippet: @syntax-color-constant;\n",digest:"622c25b2fa9b894bc851f17b9229b5392852aebe"},"node_modules/atom-light-syntax/styles/syntax.less":{content:".syntax--comment {\n  color: #999988;\n  font-style: italic;\n}\n\n.syntax--string {\n  color: #D14;\n}\n\n// String interpolation in Ruby, CoffeeScript, and others\n.syntax--string {\n  .syntax--source,\n  .syntax--meta.syntax--embedded.syntax--line {\n    color: #5A5A5A;\n  }\n\n  .syntax--punctuation.syntax--section.syntax--embedded {\n    color: #920B2D;\n\n    .syntax--source {\n      color: #920B2D;  // Required for the end of embedded strings in Ruby #716\n    }\n  }\n}\n\n.syntax--constant {\n  &.syntax--numeric {\n    color: #D14;\n  }\n\n  &.syntax--language {\n    color: #606aa1;\n  }\n\n  &.syntax--character,\n  &.syntax--other {\n    color: #606aa1;\n  }\n\n  &.syntax--symbol {\n    color: #990073;\n  }\n\n  &.syntax--numeric.syntax--line-number.syntax--find-in-files .syntax--match {\n    color: rgba(143, 190, 0, 0.63);\n  }\n}\n\n.syntax--variable {\n  color: #008080;\n\n  &.syntax--parameter {\n    color: #606aa1;\n  }\n}\n\n// Keywords\n.syntax--keyword {\n  color: #222;\n  font-weight: bold;\n\n  &.syntax--unit {\n    color: #445588;\n  }\n\n  &.syntax--special-method {\n    color: #0086B3;\n  }\n}\n\n.syntax--storage {\n  color: #222;\n\n  &.syntax--type {\n    color: #222;\n  }\n}\n\n.syntax--entity {\n  &.syntax--name.syntax--class {\n    text-decoration: underline;\n    color: #606aa1;\n  }\n\n  &.syntax--other.syntax--inherited-class {\n    text-decoration: underline;\n    color: #606aa1;\n  }\n\n  &.syntax--name.syntax--function {\n    color: #900;\n  }\n\n  &.syntax--name.syntax--tag {\n    color: #008080;\n  }\n\n  &.syntax--other.syntax--attribute-name {\n    color: #458;\n    font-weight: bold;\n  }\n\n  &.syntax--name.syntax--filename.syntax--find-in-files {\n    color: #E6DB74;\n  }\n}\n\n.syntax--support {\n  &.syntax--constant,\n  &.syntax--function,\n  &.syntax--type {\n    color: #458;\n  }\n\n  &.syntax--class {\n    color: #008080;\n  }\n}\n\n.syntax--invalid {\n  color: #F8F8F0;\n  background-color: #00A8C6;\n\n  &.syntax--deprecated {\n    color: #F8F8F0;\n    background-color: #8FBE00;\n  }\n}\n\n\n.syntax--meta {\n  &.syntax--structure.syntax--dictionary.syntax--json > .syntax--string.syntax--quoted.syntax--double.syntax--json,\n  &.syntax--structure.syntax--dictionary.syntax--json > .syntax--string.syntax--quoted.syntax--double.syntax--json .syntax--punctuation.syntax--string {\n    color: #000080;\n  }\n\n  &.syntax--structure.syntax--dictionary.syntax--value.syntax--json > .syntax--string.syntax--quoted.syntax--double.syntax--json {\n    color: #d14;\n  }\n\n  &.syntax--diff,\n  &.syntax--diff.syntax--header {\n    color: #75715E;\n  }\n}\n\n// CSS Styles\n.syntax--css {\n  &.syntax--support.syntax--property-name {\n    font-weight: bold;\n    color: #333;\n  }\n\n  &.syntax--constant {\n    color: #099;\n  }\n}\n\n// Markdown\n.syntax--source.syntax--gfm {\n  color: #444;\n}\n\n.syntax--gfm {\n  .syntax--markup.syntax--heading {\n    color: #111;\n  }\n\n  & .syntax--link {\n    color: #888;\n  }\n\n  .syntax--variable.syntax--list {\n    color: #888;\n  }\n}\n\n.syntax--markdown {\n  .syntax--paragraph {\n    color: #444;\n  }\n\n  .syntax--heading {\n    color: #111;\n  }\n\n  .syntax--link {\n    color: #888;\n\n    .syntax--string {\n      color: #888;\n    }\n  }\n}\n",digest:"b3ff7c333f2709fba1825f3ac6fc6aa533db7dd8"},"node_modules/base16-tomorrow-dark-theme/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// Base16 Tomorrow Dark theme\n\n@import "styles/syntax-variables.less";\n\n@import "styles/editor.less";\n\n@import "styles/syntax/_base.less";\n@import "styles/syntax/cs.less";\n@import "styles/syntax/json.less";\n',digest:"dd476301964de421e40efac1cf8716e909a1d386"},"node_modules/base16-tomorrow-dark-theme/styles/colors.less":{content:"\n// Base16 Tomorrow\n// A color scheme by Chris Kempson (http://chriskempson.com)\n\n// Grayscale\n@black:           #1d1f21; // 00\n@very-dark-gray:  #282a2e; // 01\n@dark-gray:       #373b41; // 02\n@gray:            #969896; // 03\n@light-gray:      #b4b7b4; // 04\n@very-light-gray: #c5c8c6; // 05\n@almost-white:    #e0e0e0; // 06\n@white:           #ffffff; // 07\n\n// Colors\n@red:             #cc6666; // 08\n@orange:          #de935f; // 09\n@yellow:          #f0c674; // 0A\n@green:           #b5bd68; // 0B\n@cyan:            #8abeb7; // 0C\n@blue:            #81a2be; // 0D\n@purple:          #b294bb; // 0E\n@brown:           #a3685a; // 0F\n",digest:"7065bcfeb89ff1d1b5f71d142576133e451415d7"},"node_modules/base16-tomorrow-dark-theme/styles/editor.less":{content:"\n// Editor styles (background, gutter, guides)\n\natom-text-editor {\n  background-color: @syntax-background-color;\n  color: @syntax-text-color;\n\n  .wrap-guide {\n    background-color: @syntax-wrap-guide-color;\n  }\n\n  .indent-guide {\n    color: @syntax-indent-guide-color;\n  }\n\n  .invisible-character {\n    color: @syntax-invisible-character-color;\n  }\n\n  .gutter {\n    background-color: @syntax-gutter-background-color;\n    color: @syntax-gutter-text-color;\n\n    .line-number {\n      padding: 0 0.25em 0 0.5em;\n      -webkit-font-smoothing: antialiased;\n      &.cursor-line {\n        background-color: @syntax-gutter-background-color-selected;\n        color: @syntax-gutter-text-color-selected;\n      }\n\n      &.cursor-line-no-selection {\n        color: @syntax-gutter-text-color-selected;\n      }\n    }\n  }\n\n  .gutter .line-number.folded,\n  .gutter .line-number:after,\n  .fold-marker:after {\n    color: @syntax-result-marker-color;\n  }\n\n  .invisible {\n    color: @syntax-text-color;\n  }\n\n  .cursor {\n    color: @syntax-cursor-color;\n  }\n\n  .selection .region {\n    background-color: @syntax-selection-color;\n  }\n\n  .bracket-matcher .region {\n    border-color: @syntax-result-marker-color;\n  }\n}\n",digest:"e169e4520f6a8966fbd8e49fc9f30aa162c85050"},"node_modules/base16-tomorrow-dark-theme/styles/syntax-variables.less":{content:'@import "colors.less";\n\n// Official Syntax Variables\n\n// General colors\n@syntax-text-color:            @very-light-gray;\n@syntax-cursor-color:          @white;\n@syntax-selection-color:       @dark-gray;\n@syntax-selection-flash-color: @very-light-gray;\n@syntax-background-color:      @black;\n\n// Guide colors\n@syntax-wrap-guide-color:          mix(@gray, @dark-gray, 25%);\n@syntax-indent-guide-color:        mix(@gray, @dark-gray, 25%);\n@syntax-invisible-character-color: mix(@gray, @dark-gray, 25%);\n\n// For find and replace markers\n@syntax-result-marker-color:          @gray;\n@syntax-result-marker-color-selected: @white;\n\n// Gutter colors\n@syntax-gutter-text-color:                @gray;\n@syntax-gutter-text-color-selected:       @very-light-gray;\n@syntax-gutter-background-color:          @syntax-background-color;\n@syntax-gutter-background-color-selected: @syntax-selection-color;\n\n// For git diff info. i.e. in the gutter\n@syntax-color-renamed:  @blue;\n@syntax-color-added:    @green;\n@syntax-color-modified: @orange;\n@syntax-color-removed:  @red;\n\n// For language entity colors\n@syntax-color-variable:  @red;\n@syntax-color-constant:  @orange;\n@syntax-color-property:  @syntax-text-color;\n@syntax-color-value:     @green;\n@syntax-color-function:  @blue;\n@syntax-color-method:    @blue;\n@syntax-color-class:     @yellow;\n@syntax-color-keyword:   @purple;\n@syntax-color-tag:       @red;\n@syntax-color-attribute: @orange;\n@syntax-color-import:    @purple;\n@syntax-color-snippet:   @green;\n',digest:"32721f783b8e977bb4f0cb3d653f548eb9454c9d"},"node_modules/base16-tomorrow-dark-theme/styles/syntax/_base.less":{content:"\n// Language syntax highlighting\n\n.syntax--comment {\n  color: @gray;\n\n  .syntax--markup.syntax--link {\n    color: @gray;\n  }\n}\n\n.syntax--entity {\n\n  &.syntax--name.syntax--type {\n    color: @yellow;\n  }\n\n  &.syntax--other.syntax--inherited-class {\n    color: @green;\n  }\n}\n\n.syntax--keyword {\n  color: @purple;\n\n  &.syntax--control {\n    color: @purple;\n  }\n\n  &.syntax--operator {\n    color: @syntax-text-color;\n  }\n\n  &.syntax--other.syntax--special-method {\n    color: @blue;\n  }\n\n  &.syntax--other.syntax--unit {\n    color: @orange;\n  }\n}\n\n.syntax--storage {\n  color: @purple;\n}\n\n.syntax--constant {\n  color: @orange;\n\n  &.syntax--character.syntax--escape {\n    color: @cyan;\n  }\n\n  &.syntax--numeric {\n    color: @orange;\n  }\n\n  &.syntax--other.syntax--color {\n    color: @cyan;\n  }\n\n  &.syntax--other.syntax--symbol {\n    color: @cyan;\n  }\n}\n\n.syntax--variable {\n  color: @red;\n\n  &.syntax--interpolation {\n    color: @brown;\n  }\n\n  &.syntax--parameter.syntax--function {\n    color: @syntax-text-color;\n  }\n}\n\n.syntax--invalid.syntax--illegal {\n  background-color: @red;\n  color: @syntax-background-color;\n}\n\n.syntax--string {\n  color: @green;\n\n\n  &.syntax--regexp {\n    color: @cyan;\n\n    .syntax--source.syntax--ruby.syntax--embedded {\n      color: @yellow;\n    }\n  }\n\n  &.syntax--other.syntax--link {\n    color: @red;\n  }\n}\n\n.syntax--punctuation {\n  &.syntax--definition {\n    &.syntax--parameters,\n    &.syntax--array {\n      color: @syntax-text-color;\n    }\n\n    &.syntax--heading,\n    &.syntax--identity {\n      color: @blue;\n    }\n\n    &.syntax--bold {\n      color: @yellow;\n      font-weight: bold;\n    }\n\n    &.syntax--italic {\n      color: @purple;\n      font-style: italic;\n    }\n  }\n\n  &.syntax--section {\n    &.syntax--embedded {\n      color: @brown;\n    }\n\n    &.syntax--method,\n    &.syntax--class,\n    &.syntax--inner-class {\n      color: @syntax-text-color;\n    }\n  }\n}\n\n.syntax--support {\n  &.syntax--class {\n    color: @yellow;\n  }\n\n  &.syntax--function  {\n    color: @cyan;\n\n    &.syntax--any-method {\n      color: @blue;\n    }\n  }\n}\n\n.syntax--entity {\n\n  &.syntax--name.syntax--function {\n    color: @blue;\n  }\n\n  &.syntax--name.syntax--class, &.syntax--name.syntax--type.syntax--class {\n    color: @yellow;\n  }\n\n  &.syntax--name.syntax--section {\n    color: @blue;\n  }\n\n  &.syntax--name.syntax--tag {\n    color: @red;\n  }\n\n  &.syntax--other.syntax--attribute-name {\n    color: @orange;\n\n    &.syntax--id {\n      color: @blue;\n    }\n  }\n}\n\n.syntax--meta {\n  &.syntax--class {\n    color: @yellow;\n\n    &.syntax--body {\n      color: @syntax-text-color;\n    }\n  }\n\n  &.syntax--link {\n    color: @orange;\n  }\n\n  &.syntax--method-call,\n  &.syntax--method {\n    color: @syntax-text-color;\n  }\n\n  &.syntax--require {\n    color: @blue;\n  }\n\n  &.syntax--selector {\n    color: @purple;\n  }\n\n  &.syntax--separator {\n    background-color: #373b41;\n    color: @syntax-text-color;\n  }\n\n  &.syntax--tag {\n    color: @syntax-text-color;\n  }\n}\n\n.syntax--none {\n  color: @syntax-text-color;\n}\n\n.syntax--markup {\n  &.syntax--bold {\n    color: @orange;\n    font-weight: bold;\n  }\n\n  &.syntax--changed {\n    color: @purple;\n  }\n\n  &.syntax--deleted {\n    color: @red;\n  }\n\n  &.syntax--italic {\n    color: @purple;\n    font-style: italic;\n  }\n\n  &.syntax--heading {\n    color: @red;\n\n    .syntax--punctuation.syntax--definition.syntax--heading {\n      color: @blue;\n    }\n  }\n\n  &.syntax--link {\n    color: @blue;\n  }\n\n  &.syntax--inserted {\n    color: @green;\n  }\n\n  &.syntax--quote {\n    color: @orange;\n  }\n\n  &.syntax--raw {\n    color: @green;\n  }\n}\n\n.syntax--source.syntax--gfm {\n  .syntax--markup {\n    -webkit-font-smoothing: auto;\n  }\n\n  .syntax--link .syntax--entity {\n    color: @cyan;\n  }\n}\n",digest:"c30ebb5079cd61bdb51f7b6299c2e37d816ac466"},"node_modules/base16-tomorrow-dark-theme/styles/syntax/cs.less":{content:".syntax--source.syntax--cs {\n  .syntax--keyword.syntax--operator {\n    color: @purple;\n  }\n}\n",digest:"ab8e60371daf69b881f4800e1ebbee4b27ca0596"},"node_modules/base16-tomorrow-dark-theme/styles/syntax/json.less":{content:".syntax--source.syntax--json {\n  .syntax--meta.syntax--structure.syntax--dictionary.syntax--json {\n    & > .syntax--string.syntax--quoted.syntax--json {\n      & > .syntax--punctuation.syntax--string {\n        color: @red;\n      }\n      color: @red;\n    }\n  }\n\n  .syntax--meta.syntax--structure.syntax--dictionary.syntax--json, .syntax--meta.syntax--structure.syntax--array.syntax--json {\n    & > .syntax--value.syntax--json > .syntax--string.syntax--quoted.syntax--json,\n    & > .syntax--value.syntax--json > .syntax--string.syntax--quoted.syntax--json > .syntax--punctuation {\n      color: @green;\n    }\n\n    & > .syntax--constant.syntax--language.syntax--json {\n      color: @cyan;\n    }\n  }\n}\n",digest:"98318eea0552874ff8e38add508f6b1f0b1cd0a5"},"node_modules/base16-tomorrow-light-theme/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// Base16 Tomorrow Light\n\n@import "styles/syntax-variables.less";\n\n@import "styles/editor.less";\n\n@import "styles/syntax/_base.less";\n@import "styles/syntax/cs.less";\n@import "styles/syntax/json.less";\n',digest:"6892e2b19d038cf18f9f3a32e955dc02fe13c8b5"},"node_modules/base16-tomorrow-light-theme/styles/colors.less":{content:"\n// Base16 Tomorrow\n// A color scheme by Chris Kempson (http://chriskempson.com)\n\n// Grayscale\n@black:           #1d1f21; // 00\n@very-dark-gray:  #282a2e; // 01\n@dark-gray:       #373b41; // 02\n@gray:            #969896; // 03\n@light-gray:      #b4b7b4; // 04\n@very-light-gray: #c5c8c6; // 05\n@almost-white:    #e0e0e0; // 06\n@white:           #ffffff; // 07\n\n// Colors\n@red:             #cc6666; // 08\n@orange:          #de935f; // 09\n@yellow:          #f0c674; // 0A\n@green:           #b5bd68; // 0B\n@cyan:            #8abeb7; // 0C\n@blue:            #81a2be; // 0D\n@purple:          #b294bb; // 0E\n@brown:           #a3685a; // 0F\n",digest:"7065bcfeb89ff1d1b5f71d142576133e451415d7"},"node_modules/base16-tomorrow-light-theme/styles/editor.less":{content:"\n// Editor styles (background, gutter, guides)\n\natom-text-editor {\n  background-color: @syntax-background-color;\n  color: @syntax-text-color;\n\n  .wrap-guide {\n    background-color: @syntax-wrap-guide-color;\n  }\n\n  .indent-guide {\n    color: @syntax-indent-guide-color;\n  }\n\n  .invisible-character {\n    color: @syntax-invisible-character-color;\n  }\n\n  .gutter {\n    background-color: @syntax-gutter-background-color;\n    color: @syntax-gutter-text-color;\n\n    .line-number {\n      padding: 0 0.25em 0 0.5em;\n      -webkit-font-smoothing: antialiased;\n      &.cursor-line {\n        background-color: @syntax-gutter-background-color-selected;\n        color: @syntax-gutter-text-color-selected;\n      }\n\n      &.cursor-line-no-selection {\n        color: @syntax-gutter-text-color-selected;\n      }\n    }\n  }\n\n  .gutter .line-number.folded,\n  .gutter .line-number:after,\n  .fold-marker:after {\n    color: @syntax-result-marker-color;\n  }\n\n  .invisible {\n    color: @syntax-text-color;\n  }\n\n  .cursor {\n    color: @syntax-cursor-color;\n  }\n\n  .selection .region {\n    background-color: @syntax-selection-color;\n  }\n\n  .bracket-matcher .region {\n    border-color: @syntax-result-marker-color;\n  }\n}\n",digest:"e169e4520f6a8966fbd8e49fc9f30aa162c85050"},"node_modules/base16-tomorrow-light-theme/styles/syntax-variables.less":{content:'@import "colors.less";\n\n// Official Syntax Variables\n\n// General colors\n@syntax-text-color:            @black;\n@syntax-cursor-color:          @black;\n@syntax-selection-color:       @almost-white;\n@syntax-selection-flash-color: @very-dark-gray;\n@syntax-background-color:      @white;\n\n// Guide colors\n@syntax-wrap-guide-color:          @very-light-gray;\n@syntax-indent-guide-color:        @very-light-gray;\n@syntax-invisible-character-color: @very-light-gray;\n\n// For find and replace markers\n@syntax-result-marker-color:          @light-gray;\n@syntax-result-marker-color-selected: @very-light-gray;\n\n// Gutter colors\n@syntax-gutter-text-color:                @light-gray;\n@syntax-gutter-text-color-selected:       @dark-gray;\n@syntax-gutter-background-color:          @syntax-background-color;\n@syntax-gutter-background-color-selected: @syntax-selection-color;\n\n// For git diff info. i.e. in the gutter\n@syntax-color-renamed:  @blue;\n@syntax-color-added:    @green;\n@syntax-color-modified: @orange;\n@syntax-color-removed:  @red;\n\n// For language entity colors\n@syntax-color-variable:  @red;\n@syntax-color-constant:  @orange;\n@syntax-color-property:  @syntax-text-color;\n@syntax-color-value:     @green;\n@syntax-color-function:  @blue;\n@syntax-color-method:    @blue;\n@syntax-color-class:     @yellow;\n@syntax-color-keyword:   @purple;\n@syntax-color-tag:       @red;\n@syntax-color-attribute: @orange;\n@syntax-color-import:    @purple;\n@syntax-color-snippet:   @green;\n',digest:"d09bce39e451df301e4e01787640d3c81c19a0d8"},"node_modules/base16-tomorrow-light-theme/styles/syntax/_base.less":{content:"\n// Language syntax highlighting\n\n.syntax--comment {\n  color: @gray;\n\n  .syntax--markup.syntax--link {\n    color: @gray;\n  }\n}\n\n.syntax--entity {\n\n  &.syntax--name.syntax--type {\n    color: @yellow;\n  }\n\n  &.syntax--other.syntax--inherited-class {\n    color: @green;\n  }\n}\n\n.syntax--keyword {\n  color: @purple;\n\n  &.syntax--control {\n    color: @purple;\n  }\n\n  &.syntax--operator {\n    color: @syntax-text-color;\n  }\n\n  &.syntax--other.syntax--special-method {\n    color: @blue;\n  }\n\n  &.syntax--other.syntax--unit {\n    color: @orange;\n  }\n}\n\n.syntax--storage {\n  color: @purple;\n}\n\n.syntax--constant {\n  color: @orange;\n\n  &.syntax--character.syntax--escape {\n    color: @cyan;\n  }\n\n  &.syntax--numeric {\n    color: @orange;\n  }\n\n  &.syntax--other.syntax--color {\n    color: @cyan;\n  }\n\n  &.syntax--other.syntax--symbol {\n    color: @cyan;\n  }\n}\n\n.syntax--variable {\n  color: @red;\n\n  &.syntax--interpolation {\n    color: @brown;\n  }\n\n  &.syntax--parameter.syntax--function {\n    color: @syntax-text-color;\n  }\n}\n\n.syntax--invalid.syntax--illegal {\n  background-color: @red;\n  color: @syntax-background-color;\n}\n\n.syntax--string {\n  color: @green;\n\n\n  &.syntax--regexp {\n    color: @cyan;\n\n    .syntax--source.syntax--ruby.syntax--embedded {\n      color: @yellow;\n    }\n  }\n\n  &.syntax--other.syntax--link {\n    color: @red;\n  }\n}\n\n.syntax--punctuation {\n  &.syntax--definition {\n    &.syntax--parameters,\n    &.syntax--array {\n      color: @syntax-text-color;\n    }\n\n    &.syntax--heading,\n    &.syntax--identity {\n      color: @blue;\n    }\n\n    &.syntax--bold {\n      color: @yellow;\n      font-weight: bold;\n    }\n\n    &.syntax--italic {\n      color: @purple;\n      font-style: italic;\n    }\n  }\n\n  &.syntax--section {\n    &.syntax--embedded {\n      color: @brown;\n    }\n\n    &.syntax--method,\n    &.syntax--class,\n    &.syntax--inner-class {\n      color: @syntax-text-color;\n    }\n  }\n}\n\n.syntax--support {\n  &.syntax--class {\n    color: @yellow;\n  }\n\n  &.syntax--function  {\n    color: @cyan;\n\n    &.syntax--any-method {\n      color: @blue;\n    }\n  }\n}\n\n.syntax--entity {\n\n  &.syntax--name.syntax--function {\n    color: @blue;\n  }\n\n  &.syntax--name.syntax--class, &.syntax--name.syntax--type.syntax--class {\n    color: @yellow;\n  }\n\n  &.syntax--name.syntax--section {\n    color: @blue;\n  }\n\n  &.syntax--name.syntax--tag {\n    color: @red;\n  }\n\n  &.syntax--other.syntax--attribute-name {\n    color: @orange;\n\n    &.syntax--id {\n      color: @blue;\n    }\n  }\n}\n\n.syntax--meta {\n  &.syntax--class {\n    color: @yellow;\n\n    &.syntax--body {\n      color: @syntax-text-color;\n    }\n  }\n\n  &.syntax--link {\n    color: @orange;\n  }\n\n  &.syntax--method-call,\n  &.syntax--method {\n    color: @syntax-text-color;\n  }\n\n  &.syntax--require {\n    color: @blue;\n  }\n\n  &.syntax--selector {\n    color: @purple;\n  }\n\n  &.syntax--separator {\n    background-color: #373b41;\n    color: @syntax-text-color;\n  }\n\n  &.syntax--tag {\n    color: @syntax-text-color;\n  }\n}\n\n.syntax--none {\n  color: @syntax-text-color;\n}\n\n.syntax--markup {\n  &.syntax--bold {\n    color: @orange;\n    font-weight: bold;\n  }\n\n  &.syntax--changed {\n    color: @purple;\n  }\n\n  &.syntax--deleted {\n    color: @red;\n  }\n\n  &.syntax--italic {\n    color: @purple;\n    font-style: italic;\n  }\n\n  &.syntax--heading {\n    color: @red;\n\n    .syntax--punctuation.syntax--definition.syntax--heading {\n      color: @blue;\n    }\n  }\n\n  &.syntax--link {\n    color: @blue;\n  }\n\n  &.syntax--inserted {\n    color: @green;\n  }\n\n  &.syntax--quote {\n    color: @orange;\n  }\n\n  &.syntax--raw {\n    color: @green;\n  }\n}\n\n.syntax--source.syntax--gfm {\n  .syntax--markup {\n    -webkit-font-smoothing: auto;\n  }\n\n  .syntax--link .syntax--entity {\n    color: @cyan;\n  }\n}\n",digest:"c30ebb5079cd61bdb51f7b6299c2e37d816ac466"},"node_modules/base16-tomorrow-light-theme/styles/syntax/cs.less":{content:".syntax--source.syntax--cs {\n  .syntax--keyword.syntax--operator {\n    color: @purple;\n  }\n}\n",digest:"ab8e60371daf69b881f4800e1ebbee4b27ca0596"},"node_modules/base16-tomorrow-light-theme/styles/syntax/json.less":{content:".syntax--source.syntax--json {\n  .syntax--meta.syntax--structure.syntax--dictionary.syntax--json {\n    & > .syntax--string.syntax--quoted.syntax--json {\n      & > .syntax--punctuation.syntax--string {\n        color: @red;\n      }\n      color: @red;\n    }\n  }\n\n  .syntax--meta.syntax--structure.syntax--dictionary.syntax--json, .syntax--meta.syntax--structure.syntax--array.syntax--json {\n    & > .syntax--value.syntax--json > .syntax--string.syntax--quoted.syntax--json,\n    & > .syntax--value.syntax--json > .syntax--string.syntax--quoted.syntax--json > .syntax--punctuation {\n      color: @green;\n    }\n\n    & > .syntax--constant.syntax--language.syntax--json {\n      color: @cyan;\n    }\n  }\n}\n",digest:"98318eea0552874ff8e38add508f6b1f0b1cd0a5"},"node_modules/one-dark-syntax/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// Atom Syntax Theme: One\n\n@import "styles/syntax-variables.less";\n\n@import "styles/editor.less";\n\n@import "styles/syntax/_base.less";\n@import "styles/syntax/c.less";\n@import "styles/syntax/cpp.less";\n@import "styles/syntax/cs.less";\n@import "styles/syntax/css.less";\n@import "styles/syntax/elixir.less";\n@import "styles/syntax/gfm.less";\n@import "styles/syntax/go.less";\n@import "styles/syntax/ini.less";\n@import "styles/syntax/java.less";\n@import "styles/syntax/javascript.less";\n@import "styles/syntax/typescript.less";\n@import "styles/syntax/json.less";\n@import "styles/syntax/ng.less";\n@import "styles/syntax/ruby.less";\n@import "styles/syntax/php.less";\n@import "styles/syntax/python.less";\n',digest:"55b3b386f767f7c0859b3342cbc49cb500cd46d4"},"node_modules/one-dark-syntax/styles/colors.less":{content:"\n// Config -----------------------------------\n@syntax-hue:          220;\n@syntax-saturation:   13%;\n@syntax-brightness:   18%;\n\n\n// Monochrome -----------------------------------\n@mono-1: hsl(@syntax-hue, 14%, 71%); // default text\n@mono-2: hsl(@syntax-hue,  9%, 55%);\n@mono-3: hsl(@syntax-hue, 10%, 40%);\n\n// Colors -----------------------------------\n@hue-1:   hsl(187, 47%, 55%); // <-cyan\n@hue-2:   hsl(207, 82%, 66%); // <-blue\n@hue-3:   hsl(286, 60%, 67%); // <-purple\n@hue-4:   hsl( 95, 38%, 62%); // <-green\n\n@hue-5:   hsl(355, 65%, 65%); // <-red 1\n@hue-5-2: hsl(  5, 48%, 51%); // <-red 2\n\n@hue-6:   hsl( 29, 54%, 61%); // <-orange 1\n@hue-6-2: hsl( 39, 67%, 69%); // <-orange 2\n\n\n// Base colors -----------------------------------\n@syntax-fg:     @mono-1;\n@syntax-bg:     hsl(@syntax-hue, @syntax-saturation, @syntax-brightness);\n@syntax-gutter: darken(@syntax-fg, 26%);\n@syntax-guide:  fade(@syntax-fg, 15%);\n@syntax-accent: hsl(@syntax-hue, 100%, 66% );\n",digest:"66bba03e9aabff000a84c2839a9d3e9a9fa08e0e"},"node_modules/one-dark-syntax/styles/editor.less":{content:'\n// Editor styles (background, gutter, guides)\n\natom-text-editor {\n  background-color: @syntax-background-color;\n  color: @syntax-text-color;\n\n  .line.cursor-line {\n    background-color: @syntax-cursor-line;\n  }\n\n  .invisible {\n    color: @syntax-text-color;\n  }\n\n  .cursor {\n    border-left: 2px solid @syntax-cursor-color;\n  }\n\n  .selection .region {\n    background-color: @syntax-selection-color;\n  }\n\n  .bracket-matcher .region {\n    border-bottom: 1px solid @syntax-cursor-color;\n    box-sizing: border-box;\n  }\n\n  .invisible-character {\n    color: @syntax-invisible-character-color;\n  }\n\n  .indent-guide {\n    color: @syntax-indent-guide-color;\n  }\n\n  .wrap-guide {\n    background-color: @syntax-wrap-guide-color;\n  }\n\n  // find + replace\n  .find-result .region.region.region,\n  .current-result .region.region.region {\n    border-radius: 2px;\n    background-color: @syntax-result-marker-color;\n    transition: border-color .4s;\n  }\n  .find-result .region.region.region {\n    border: 2px solid transparent;\n  }\n  .current-result .region.region.region {\n    border: 2px solid @syntax-result-marker-color-selected;\n    transition-duration: .1s;\n  }\n\n  .gutter {\n\n    .line-number {\n      color: @syntax-gutter-text-color;\n      -webkit-font-smoothing: antialiased;\n\n      &.cursor-line {\n        color: @syntax-gutter-text-color-selected;\n        background-color: @syntax-gutter-background-color-selected;\n      }\n      &.cursor-line-no-selection {\n        background-color: transparent;\n      }\n\n      .icon-right {\n        color: @syntax-text-color;\n      }\n    }\n\n    &:not(.git-diff-icon) .line-number.git-line-removed {\n      &.git-line-removed::before {\n        bottom: -3px;\n      }\n      &::after {\n        content: "";\n        position: absolute;\n        left: 0px;\n        bottom: 0px;\n        width: 25px;\n        border-bottom: 1px dotted fade(@syntax-color-removed, 50%);\n        pointer-events: none;\n      }\n    }\n  }\n\n  .gutter .line-number.folded,\n  .gutter .line-number:after,\n  .fold-marker:after {\n    color: @syntax-gutter-text-color-selected;\n  }\n}\n',digest:"1b282b3b38c12bf9fbb3431b172c69a70d5f81d1"},"node_modules/one-dark-syntax/styles/syntax-variables.less":{content:'@import "colors.less";\n\n// Official Syntax Variables -----------------------------------\n\n// General colors\n@syntax-text-color:            @syntax-fg;\n@syntax-cursor-color:          @syntax-accent;\n@syntax-selection-color:       lighten(@syntax-background-color, 10%);\n@syntax-selection-flash-color: @syntax-accent;\n@syntax-background-color:      @syntax-bg;\n\n// Guide colors\n@syntax-wrap-guide-color:          @syntax-guide;\n@syntax-indent-guide-color:        @syntax-guide;\n@syntax-invisible-character-color: @syntax-guide;\n\n// For find and replace markers\n@syntax-result-marker-color:          fade(@syntax-accent, 24%);\n@syntax-result-marker-color-selected: @syntax-accent;\n\n// Gutter colors\n@syntax-gutter-text-color:                @syntax-gutter;\n@syntax-gutter-text-color-selected:       @syntax-fg;\n@syntax-gutter-background-color:          @syntax-bg; // unused\n@syntax-gutter-background-color-selected: lighten(@syntax-bg, 8%);\n\n// Git colors - For git diff info. i.e. in the gutter\n@syntax-color-renamed:  hsl(208, 100%, 60%);\n@syntax-color-added:    hsl(150,  60%, 54%);\n@syntax-color-modified: hsl(40,   60%, 70%);\n@syntax-color-removed:  hsl(0,    70%, 60%);\n\n// For language entity colors\n@syntax-color-variable:   @hue-5;\n@syntax-color-constant:   @hue-6;\n@syntax-color-property:   @syntax-fg;\n@syntax-color-value:      @syntax-fg;\n@syntax-color-function:   @hue-2;\n@syntax-color-method:     @hue-2;\n@syntax-color-class:      @hue-6-2;\n@syntax-color-keyword:    @hue-3;\n@syntax-color-tag:        @hue-5;\n@syntax-color-attribute:  @hue-6;\n@syntax-color-import:     @hue-3;\n@syntax-color-snippet:    @hue-4;\n\n\n// Custom Syntax Variables -----------------------------------\n// Don\'t use in packages\n\n@syntax-cursor-line: hsla(@syntax-hue, 100%,  80%, .04); // needs to be semi-transparent to show search results\n\n@syntax-deprecated-fg: darken(@syntax-color-modified, 50%);\n@syntax-deprecated-bg: @syntax-color-modified;\n@syntax-illegal-fg:    white;\n@syntax-illegal-bg:    @syntax-color-removed;\n',digest:"4737e2c84347b1a399426a81fc903dd3ce1abb52"},"node_modules/one-dark-syntax/styles/syntax/_base.less":{content:"// Language syntax highlighting\n\n.syntax--comment {\n  color: @mono-3;\n  font-style: italic;\n\n  .syntax--markup.syntax--link {\n    color: @mono-3;\n  }\n}\n\n.syntax--entity {\n\n  &.syntax--name.syntax--type {\n    color: @hue-6-2;\n  }\n\n  &.syntax--other.syntax--inherited-class {\n    color: @hue-4;\n  }\n}\n\n.syntax--keyword {\n  color: @hue-3;\n\n  &.syntax--control {\n    color: @hue-3;\n  }\n\n  &.syntax--operator {\n    color: @mono-1;\n  }\n\n  &.syntax--other.syntax--special-method {\n    color: @hue-2;\n  }\n\n  &.syntax--other.syntax--unit {\n    color: @hue-6;\n  }\n}\n\n.syntax--storage {\n  color: @hue-3;\n\n  &.syntax--type {\n    &.syntax--annotation,\n    &.syntax--primitive {\n      color: @hue-3;\n    }\n  }\n\n  &.syntax--modifier {\n    &.syntax--package,\n    &.syntax--import {\n      color: @mono-1;\n    }\n  }\n}\n\n.syntax--constant {\n  color: @hue-6;\n\n  &.syntax--variable {\n    color: @hue-6;\n  }\n\n  &.syntax--character.syntax--escape {\n    color: @hue-1;\n  }\n\n  &.syntax--numeric {\n    color: @hue-6;\n  }\n\n  &.syntax--other.syntax--color {\n    color: @hue-1;\n  }\n\n  &.syntax--other.syntax--symbol {\n    color: @hue-1;\n  }\n}\n\n.syntax--variable {\n  color: @hue-5;\n\n  &.syntax--interpolation {\n    color: @hue-5-2;\n  }\n\n  &.syntax--parameter {\n    color: @mono-1;\n  }\n}\n\n.syntax--string {\n  color: @hue-4;\n\n  > .syntax--source, .syntax--embedded {\n    color: @mono-1;\n  }\n\n  &.syntax--regexp {\n    color: @hue-1;\n\n    .syntax--source.syntax--ruby.syntax--embedded {\n      color: @hue-6-2;\n    }\n  }\n\n  &.syntax--other.syntax--link {\n    color: @hue-5;\n  }\n}\n\n.syntax--punctuation {\n  &.syntax--definition {\n    &.syntax--comment {\n      color: @mono-3;\n    }\n\n    &.syntax--method-parameters,\n    &.syntax--function-parameters,\n    &.syntax--parameters,\n    &.syntax--separator,\n    &.syntax--seperator,\n    &.syntax--array {\n      color: @mono-1;\n    }\n\n    &.syntax--heading,\n    &.syntax--identity {\n      color: @hue-2;\n    }\n\n    &.syntax--bold {\n      color: @hue-6-2;\n      font-weight: bold;\n    }\n\n    &.syntax--italic {\n      color: @hue-3;\n      font-style: italic;\n    }\n  }\n\n  &.syntax--section {\n    &.syntax--embedded {\n      color: @hue-5-2;\n    }\n\n    &.syntax--method,\n    &.syntax--class,\n    &.syntax--inner-class {\n      color: @mono-1;\n    }\n  }\n}\n\n.syntax--support {\n  &.syntax--class {\n    color: @hue-6-2;\n  }\n\n  &.syntax--type {\n    color: @hue-1;\n  }\n\n  &.syntax--function  {\n    color: @hue-1;\n\n    &.syntax--any-method {\n      color: @hue-2;\n    }\n  }\n}\n\n.syntax--entity {\n  &.syntax--name.syntax--function {\n    color: @hue-2;\n  }\n\n  &.syntax--name.syntax--class,\n  &.syntax--name.syntax--type.syntax--class {\n    color: @hue-6-2;\n  }\n\n  &.syntax--name.syntax--section {\n    color: @hue-2;\n  }\n\n  &.syntax--name.syntax--tag {\n    color: @hue-5;\n  }\n\n  &.syntax--other.syntax--attribute-name {\n    color: @hue-6;\n\n    &.syntax--id {\n      color: @hue-2;\n    }\n  }\n}\n\n.syntax--meta {\n  &.syntax--class {\n    color: @hue-6-2;\n\n    &.syntax--body {\n      color: @mono-1;\n    }\n  }\n\n  &.syntax--method-call,\n  &.syntax--method {\n    color: @mono-1;\n  }\n\n  &.syntax--definition {\n    &.syntax--variable {\n      color: @hue-5;\n    }\n  }\n\n  &.syntax--link {\n    color: @hue-6;\n  }\n\n  &.syntax--require {\n    color: @hue-2;\n  }\n\n  &.syntax--selector {\n    color: @hue-3;\n  }\n\n  &.syntax--separator {\n    color: @mono-1;\n  }\n\n  &.syntax--tag {\n    color: @mono-1;\n  }\n}\n\n.syntax--underline {\n  text-decoration: underline;\n}\n\n.syntax--none {\n  color: @mono-1;\n}\n\n.syntax--invalid {\n  &.syntax--deprecated {\n    color: @syntax-deprecated-fg !important;\n    background-color: @syntax-deprecated-bg !important;\n  }\n  &.syntax--illegal {\n    color: @syntax-illegal-fg !important;\n    background-color: @syntax-illegal-bg !important;\n  }\n}\n\n// Languages -------------------------------------------------\n\n.syntax--markup {\n  &.syntax--bold {\n    color: @hue-6;\n    font-weight: bold;\n  }\n\n  &.syntax--changed {\n    color: @hue-3;\n  }\n\n  &.syntax--deleted {\n    color: @hue-5;\n  }\n\n  &.syntax--italic {\n    color: @hue-3;\n    font-style: italic;\n  }\n\n  &.syntax--heading {\n    color: @hue-5;\n\n    .syntax--punctuation.syntax--definition.syntax--heading {\n      color: @hue-2;\n    }\n  }\n\n  &.syntax--link {\n    color: @hue-1;\n  }\n\n  &.syntax--inserted {\n    color: @hue-4;\n  }\n\n  &.syntax--quote {\n    color: @hue-6;\n  }\n\n  &.syntax--raw {\n    color: @hue-4;\n  }\n}\n",digest:"667a736a7206e997d02a41a05bad03a50cfb9f74"},"node_modules/one-dark-syntax/styles/syntax/c.less":{content:".syntax--source.syntax--c {\n  .syntax--keyword.syntax--operator {\n    color: @hue-3;\n  }\n}\n",digest:"ad63462d9a7352e4cd1f4ec52ea6daced57a2e51"},"node_modules/one-dark-syntax/styles/syntax/cpp.less":{content:".syntax--source.syntax--cpp {\n  .syntax--keyword.syntax--operator {\n    color: @hue-3;\n  }\n}\n",digest:"3832ba5f453df1e76fee01bea74dbfd67d606c43"},"node_modules/one-dark-syntax/styles/syntax/cs.less":{content:".syntax--source.syntax--cs {\n  .syntax--keyword.syntax--operator {\n    color: @hue-3;\n  }\n}\n",digest:"c92e873b912bb6f727365589722e17220a862b65"},"node_modules/one-dark-syntax/styles/syntax/css.less":{content:".syntax--source.syntax--css {\n  // highlight properties/values if they are supported\n  .syntax--property-name,\n  .syntax--property-value {\n    color: @mono-2;\n    &.syntax--support {\n      color: @mono-1;\n    }\n  }\n}\n",digest:"16298135832131cbf568bb0869c4019725fb5d3c"},"node_modules/one-dark-syntax/styles/syntax/elixir.less":{content:".syntax--source.syntax--elixir {\n  .syntax--source.syntax--embedded.syntax--source {\n    color: @mono-1;\n  }\n  .syntax--constant.syntax--language,\n  .syntax--constant.syntax--numeric,\n  .syntax--constant.syntax--definition  {\n    color: @hue-2;\n  }\n  .syntax--variable.syntax--definition,\n  .syntax--variable.syntax--anonymous{\n    color: @hue-3;\n  }\n  .syntax--parameter.syntax--variable.syntax--function {\n    color: @hue-6;\n    font-style: italic;\n  }\n  .syntax--quoted{\n    color: @hue-4;\n  }\n  .syntax--keyword.syntax--special-method,\n  .syntax--embedded.syntax--section,\n  .syntax--embedded.syntax--source.syntax--empty,  {\n    color: @hue-5;\n  }\n  .syntax--readwrite.syntax--module {\n    .syntax--punctuation {\n      color: @hue-5;\n    }\n  }\n  .syntax--regexp.syntax--section,\n  .syntax--regexp.syntax--string {\n    color: @hue-5-2;\n  }\n  .syntax--separator,\n  .syntax--keyword.syntax--operator  {\n    color: @hue-6;\n  }\n  .syntax--variable.syntax--constant {\n    color: @hue-6-2;\n  }\n  .syntax--array,\n  .syntax--scope,\n  .syntax--section {\n    color: @mono-2;\n  }\n}\n",digest:"f38db739e45b524cbd59b83b02386e2006a69282"},"node_modules/one-dark-syntax/styles/syntax/gfm.less":{content:".syntax--source.syntax--gfm {\n  .syntax--markup {\n    -webkit-font-smoothing: auto;\n  }\n\n  .syntax--link .syntax--entity {\n    color: @hue-2;\n  }\n}\n",digest:"c2da438ee70805f1b45524468243c2d97e711640"},"node_modules/one-dark-syntax/styles/syntax/go.less":{content:".syntax--source.syntax--go {\n  .syntax--storage.syntax--type.syntax--string {\n      color: @hue-3;\n  }\n}\n",digest:"a268ce9af009eaed960a681895dfdbb02c7e84a7"},"node_modules/one-dark-syntax/styles/syntax/ini.less":{content:".syntax--source.syntax--ini {\n  .syntax--keyword.syntax--other.syntax--definition.syntax--ini {\n    color: @hue-5;\n  }\n}\n",digest:"de894a7575d3add3eb4cc450e548334a674c2c43"},"node_modules/one-dark-syntax/styles/syntax/java.less":{content:".syntax--source.syntax--java {\n  .syntax--storage {\n    &.syntax--modifier.syntax--import {\n      color: @hue-6-2;\n    }\n\n    &.syntax--type {\n      color: @hue-6-2;\n    }\n  }\n  .syntax--keyword.syntax--operator.syntax--instanceof {\n    color: @hue-3;\n  }\n}\n\n.syntax--source.syntax--java-properties {\n  .syntax--meta.syntax--key-pair {\n    color: @hue-5;\n\n    & > .syntax--punctuation {\n      color: @mono-1;\n    }\n  }\n}\n",digest:"9d10d34cea50c9e3dfc500dcb00e671a564249ef"},"node_modules/one-dark-syntax/styles/syntax/javascript.less":{content:'.syntax--source.syntax--js {\n  .syntax--keyword.syntax--operator {\n    color: @hue-1;\n\n    // keywords are definded in https://github.com/atom/language-javascript/blob/master/grammars/javascript.cson\n    // search "instanceof" for location\n    &.syntax--delete,\n    &.syntax--in,\n    &.syntax--of,\n    &.syntax--instanceof,\n    &.syntax--new,\n    &.syntax--typeof,\n    &.syntax--void {\n      color: @hue-3;\n    }\n  }\n}\n',digest:"9f2eb70092bdcddf40197f0a028f437a5ee065d6"},"node_modules/one-dark-syntax/styles/syntax/json.less":{content:".syntax--source.syntax--json {\n  .syntax--meta.syntax--structure.syntax--dictionary.syntax--json {\n    & > .syntax--string.syntax--quoted.syntax--json {\n      & > .syntax--punctuation.syntax--string {\n        color: @hue-5;\n      }\n      color: @hue-5;\n    }\n  }\n\n  .syntax--meta.syntax--structure.syntax--dictionary.syntax--json, .syntax--meta.syntax--structure.syntax--array.syntax--json {\n    & > .syntax--value.syntax--json > .syntax--string.syntax--quoted.syntax--json,\n    & > .syntax--value.syntax--json > .syntax--string.syntax--quoted.syntax--json > .syntax--punctuation {\n      color: @hue-4;\n    }\n\n    & > .syntax--constant.syntax--language.syntax--json {\n      color: @hue-1;\n    }\n  }\n}\n",digest:"8e5404389094e83bbfce993ff30de61c512d2e80"},"node_modules/one-dark-syntax/styles/syntax/ng.less":{content:".syntax--ng {\n  &.syntax--interpolation {\n    color: @hue-5;\n\n    &.syntax--begin, &.syntax--end {\n      color: @hue-2;\n    }\n\n    .syntax--function {\n      color: @hue-5;\n\n      &.syntax--begin, &.syntax--end {\n        color: @hue-2;\n      }\n    }\n\n    .syntax--bool {\n      color: @hue-6;\n    }\n\n    .syntax--bracket {\n      color: @mono-1;\n    }\n  }\n\n  &.syntax--pipe, &.syntax--operator {\n    color: @mono-1;\n  }\n\n  &.syntax--tag {\n    color: @hue-1;\n  }\n\n  &.syntax--attribute-with-value {\n    .syntax--attribute-name {\n      color: @hue-6-2;\n    }\n\n    .syntax--string {\n      color: @hue-3;\n\n      &.syntax--begin, &.syntax--end {\n        color: @mono-1;\n      }\n    }\n  }\n}\n",digest:"06a6007e4d93c768a0e1f5047a385273944ee304"},"node_modules/one-dark-syntax/styles/syntax/php.less":{content:".syntax--source.syntax--php {\n  .syntax--class.syntax--bracket {\n    color: @mono-1;\n  }\n}\n",digest:"45f5706d756cbcc6c0a86b554a45a96e97172c17"},"node_modules/one-dark-syntax/styles/syntax/python.less":{content:".syntax--source.syntax--python {\n  .syntax--keyword.syntax--operator.syntax--logical.syntax--python {\n    color: @hue-3;\n  }\n\n  .syntax--variable.syntax--parameter {\n    color: @hue-6;\n  }\n}\n",digest:"b2a19ed1dfdc9938fe3714e8903f756e3a61dd8e"},"node_modules/one-dark-syntax/styles/syntax/ruby.less":{content:".syntax--source.syntax--ruby {\n  .syntax--constant.syntax--other.syntax--symbol > .syntax--punctuation {\n    color: inherit;\n  }\n}\n",digest:"7037880883b3ecfe2912904f9e403271d293a4f0"},"node_modules/one-dark-syntax/styles/syntax/typescript.less":{content:".syntax--source.syntax--ts {\n  .syntax--keyword.syntax--operator {\n    color: @hue-1;\n  }\n}\n\n.syntax--source.syntax--flow {\n  .syntax--keyword.syntax--operator {\n    color: @hue-1;\n  }\n}",digest:"ec2cc8646087ed78b0c1a3bcf9e224761ca3afb8"},"node_modules/one-light-syntax/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// Atom Syntax Theme: One\n\n@import "styles/syntax-variables.less";\n\n@import "styles/editor.less";\n\n@import "styles/syntax/_base.less";\n@import "styles/syntax/c.less";\n@import "styles/syntax/cpp.less";\n@import "styles/syntax/cs.less";\n@import "styles/syntax/css.less";\n@import "styles/syntax/elixir.less";\n@import "styles/syntax/gfm.less";\n@import "styles/syntax/go.less";\n@import "styles/syntax/ini.less";\n@import "styles/syntax/java.less";\n@import "styles/syntax/javascript.less";\n@import "styles/syntax/typescript.less";\n@import "styles/syntax/json.less";\n@import "styles/syntax/ng.less";\n@import "styles/syntax/ruby.less";\n@import "styles/syntax/php.less";\n@import "styles/syntax/python.less";\n',digest:"55b3b386f767f7c0859b3342cbc49cb500cd46d4"},"node_modules/one-light-syntax/styles/colors.less":{content:"\n// Config -----------------------------------\n@syntax-hue:          230;\n@syntax-saturation:    1%;\n@syntax-brightness:   98%;\n\n\n// Monochrome -----------------------------------\n@mono-1: hsl(@syntax-hue, 8%, 24%);\n@mono-2: hsl(@syntax-hue, 6%, 44%);\n@mono-3: hsl(@syntax-hue, 4%, 64%);\n\n// Colors -----------------------------------\n@hue-1:   hsl(198, 99%, 37%); // <-cyan\n@hue-2:   hsl(221, 87%, 60%); // <-blue\n@hue-3:   hsl(301, 63%, 40%); // <-purple\n@hue-4:   hsl(119, 34%, 47%); // <-green\n\n@hue-5:   hsl(  5, 74%, 59%); // <-red 1\n@hue-5-2: hsl(344, 84%, 43%); // <-red 2\n\n@hue-6:   hsl(41, 99%, 30%); // <-orange 1\n@hue-6-2: hsl(41, 99%, 38%); // <-orange 2\n\n\n// Base colors -----------------------------------\n@syntax-fg:     @mono-1;\n@syntax-bg:     hsl(@syntax-hue, @syntax-saturation, @syntax-brightness);\n@syntax-gutter: darken(@syntax-bg, 36%);\n@syntax-guide:  fade(@syntax-fg, 20%);\n@syntax-accent: hsl(@syntax-hue, 100%, 66% );\n",digest:"6e53c2e7473d04130f2592930c3470ed86daffdf"},"node_modules/one-light-syntax/styles/editor.less":{content:'// Editor styles (background, gutter, guides)\n\natom-text-editor {\n  background-color: @syntax-background-color;\n  color: @syntax-text-color;\n\n  .line.cursor-line {\n    background-color: @syntax-cursor-line;\n  }\n\n  .invisible {\n    color: @syntax-text-color;\n  }\n\n  .cursor {\n    border-left: 2px solid @syntax-cursor-color;\n  }\n\n  .selection .region {\n    background-color: @syntax-selection-color;\n  }\n\n  .bracket-matcher .region {\n    border-bottom: 1px solid @syntax-cursor-color;\n    box-sizing: border-box;\n  }\n\n  .invisible-character {\n    color: @syntax-invisible-character-color;\n  }\n\n  .indent-guide {\n    color: @syntax-indent-guide-color;\n  }\n\n  .wrap-guide {\n    background-color: @syntax-wrap-guide-color;\n  }\n\n  // find + replace\n  .find-result .region.region.region,\n  .current-result .region.region.region {\n    border-radius: 2px;\n    background-color: @syntax-result-marker-color;\n    transition: border-color .4s;\n  }\n  .find-result .region.region.region {\n    border: 2px solid transparent;\n  }\n  .current-result .region.region.region {\n    border: 2px solid @syntax-result-marker-color-selected;\n    transition-duration: .1s;\n  }\n\n  .gutter {\n    .line-number {\n      color: @syntax-gutter-text-color;\n      -webkit-font-smoothing: antialiased;\n\n      &.cursor-line {\n        color: @syntax-gutter-text-color-selected;\n        background-color: @syntax-gutter-background-color-selected;\n      }\n      &.cursor-line-no-selection {\n        background-color: transparent;\n      }\n\n      .icon-right {\n        color: @syntax-text-color;\n      }\n    }\n\n    &:not(.git-diff-icon) .line-number.git-line-removed {\n      &.git-line-removed::before {\n        bottom: -3px;\n      }\n      &::after {\n        content: "";\n        position: absolute;\n        left: 0px;\n        bottom: 0px;\n        width: 25px;\n        border-bottom: 1px dotted fade(@syntax-color-removed, 50%);\n        pointer-events: none;\n      }\n    }\n  }\n\n  .gutter .line-number.folded,\n  .gutter .line-number:after,\n  .fold-marker:after {\n    color: @syntax-gutter-text-color-selected;\n  }\n}\n',digest:"25e308c6140f46096a1f31e987ac6add9bf130f4"},"node_modules/one-light-syntax/styles/syntax-variables.less":{content:'@import "colors.less";\n\n// Official Syntax Variables -----------------------------------\n\n// General colors\n@syntax-text-color:            @syntax-fg;\n@syntax-cursor-color:          @syntax-accent;\n@syntax-selection-color:       darken(@syntax-bg, 8%);\n@syntax-selection-flash-color: @syntax-accent;\n@syntax-background-color:      @syntax-bg;\n\n// Guide colors\n@syntax-wrap-guide-color:          @syntax-guide;\n@syntax-indent-guide-color:        @syntax-guide;\n@syntax-invisible-character-color: @syntax-guide;\n\n// For find and replace markers\n@syntax-result-marker-color:          fade(@syntax-accent, 20%);\n@syntax-result-marker-color-selected: @syntax-accent;\n\n// Gutter colors -----------------------------------\n@syntax-gutter-text-color:                @syntax-gutter;\n@syntax-gutter-text-color-selected:       @syntax-fg;\n@syntax-gutter-background-color:          @syntax-bg; // unused\n@syntax-gutter-background-color-selected: darken(@syntax-bg, 8%);\n\n// Git colors - For git diff info. i.e. in the gutter\n@syntax-color-renamed:  hsl(208, 100%, 66%);\n@syntax-color-added:    hsl(132,  60%, 44%);\n@syntax-color-modified: hsl( 40,  90%, 50%);\n@syntax-color-removed:  hsl(  0, 100%, 54%);\n\n// For language entity colors\n@syntax-color-variable:   @hue-5;\n@syntax-color-constant:   @hue-6;\n@syntax-color-property:   @syntax-fg;\n@syntax-color-value:      @syntax-fg;\n@syntax-color-function:   @hue-2;\n@syntax-color-method:     @hue-2;\n@syntax-color-class:      @hue-6-2;\n@syntax-color-keyword:    @hue-3;\n@syntax-color-tag:        @hue-5;\n@syntax-color-attribute:  @hue-6;\n@syntax-color-import:     @hue-3;\n@syntax-color-snippet:    @hue-4;\n\n\n// Custom Syntax Variables -----------------------------------\n// Don\'t use in packages\n\n@syntax-cursor-line: fade(@syntax-fg, 5%); // needs to be semi-transparent to show search results\n\n@syntax-deprecated-fg: darken(@syntax-color-modified, 50%);\n@syntax-deprecated-bg: @syntax-color-modified;\n@syntax-illegal-fg:    white;\n@syntax-illegal-bg:    @syntax-color-removed;\n',digest:"e2156cb2e22e8a18c9204457764d21db6c8b73a7"},"node_modules/one-light-syntax/styles/syntax/_base.less":{content:"// Language syntax highlighting\n\n.syntax--comment {\n  color: @mono-3;\n  font-style: italic;\n\n  .syntax--markup.syntax--link {\n    color: @mono-3;\n  }\n}\n\n.syntax--entity {\n\n  &.syntax--name.syntax--type {\n    color: @hue-6-2;\n  }\n\n  &.syntax--other.syntax--inherited-class {\n    color: @hue-4;\n  }\n}\n\n.syntax--keyword {\n  color: @hue-3;\n\n  &.syntax--control {\n    color: @hue-3;\n  }\n\n  &.syntax--operator {\n    color: @mono-1;\n  }\n\n  &.syntax--other.syntax--special-method {\n    color: @hue-2;\n  }\n\n  &.syntax--other.syntax--unit {\n    color: @hue-6;\n  }\n}\n\n.syntax--storage {\n  color: @hue-3;\n\n  &.syntax--type {\n    &.syntax--annotation,\n    &.syntax--primitive {\n      color: @hue-3;\n    }\n  }\n\n  &.syntax--modifier {\n    &.syntax--package,\n    &.syntax--import {\n      color: @mono-1;\n    }\n  }\n}\n\n.syntax--constant {\n  color: @hue-6;\n\n  &.syntax--variable {\n    color: @hue-6;\n  }\n\n  &.syntax--character.syntax--escape {\n    color: @hue-1;\n  }\n\n  &.syntax--numeric {\n    color: @hue-6;\n  }\n\n  &.syntax--other.syntax--color {\n    color: @hue-1;\n  }\n\n  &.syntax--other.syntax--symbol {\n    color: @hue-1;\n  }\n}\n\n.syntax--variable {\n  color: @hue-5;\n\n  &.syntax--interpolation {\n    color: @hue-5-2;\n  }\n\n  &.syntax--parameter {\n    color: @mono-1;\n  }\n}\n\n.syntax--string {\n  color: @hue-4;\n\n  > .syntax--source, .syntax--embedded {\n    color: @mono-1;\n  }\n\n  &.syntax--regexp {\n    color: @hue-1;\n\n    .syntax--source.syntax--ruby.syntax--embedded {\n      color: @hue-6-2;\n    }\n  }\n\n  &.syntax--other.syntax--link {\n    color: @hue-5;\n  }\n}\n\n.syntax--punctuation {\n  &.syntax--definition {\n    &.syntax--comment {\n      color: @mono-3;\n    }\n\n    &.syntax--method-parameters,\n    &.syntax--function-parameters,\n    &.syntax--parameters,\n    &.syntax--separator,\n    &.syntax--seperator,\n    &.syntax--array {\n      color: @mono-1;\n    }\n\n    &.syntax--heading,\n    &.syntax--identity {\n      color: @hue-2;\n    }\n\n    &.syntax--bold {\n      color: @hue-6-2;\n      font-weight: bold;\n    }\n\n    &.syntax--italic {\n      color: @hue-3;\n      font-style: italic;\n    }\n  }\n\n  &.syntax--section {\n    &.syntax--embedded {\n      color: @hue-5-2;\n    }\n\n    &.syntax--method,\n    &.syntax--class,\n    &.syntax--inner-class {\n      color: @mono-1;\n    }\n  }\n}\n\n.syntax--support {\n  &.syntax--class {\n    color: @hue-6-2;\n  }\n\n  &.syntax--type {\n    color: @hue-1;\n  }\n\n  &.syntax--function  {\n    color: @hue-1;\n\n    &.syntax--any-method {\n      color: @hue-2;\n    }\n  }\n}\n\n.syntax--entity {\n  &.syntax--name.syntax--function {\n    color: @hue-2;\n  }\n\n  &.syntax--name.syntax--class,\n  &.syntax--name.syntax--type.syntax--class {\n    color: @hue-6-2;\n  }\n\n  &.syntax--name.syntax--section {\n    color: @hue-2;\n  }\n\n  &.syntax--name.syntax--tag {\n    color: @hue-5;\n  }\n\n  &.syntax--other.syntax--attribute-name {\n    color: @hue-6;\n\n    &.syntax--id {\n      color: @hue-2;\n    }\n  }\n}\n\n.syntax--meta {\n  &.syntax--class {\n    color: @hue-6-2;\n\n    &.syntax--body {\n      color: @mono-1;\n    }\n  }\n\n  &.syntax--method-call,\n  &.syntax--method {\n    color: @mono-1;\n  }\n\n  &.syntax--definition {\n    &.syntax--variable {\n      color: @hue-5;\n    }\n  }\n\n  &.syntax--link {\n    color: @hue-6;\n  }\n\n  &.syntax--require {\n    color: @hue-2;\n  }\n\n  &.syntax--selector {\n    color: @hue-3;\n  }\n\n  &.syntax--separator {\n    color: @mono-1;\n  }\n\n  &.syntax--tag {\n    color: @mono-1;\n  }\n}\n\n.syntax--underline {\n  text-decoration: underline;\n}\n\n.syntax--none {\n  color: @mono-1;\n}\n\n.syntax--invalid {\n  &.syntax--deprecated {\n    color: @syntax-deprecated-fg !important;\n    background-color: @syntax-deprecated-bg !important;\n  }\n  &.syntax--illegal {\n    color: @syntax-illegal-fg !important;\n    background-color: @syntax-illegal-bg !important;\n  }\n}\n\n// Languages -------------------------------------------------\n\n.syntax--markup {\n  &.syntax--bold {\n    color: @hue-6;\n    font-weight: bold;\n  }\n\n  &.syntax--changed {\n    color: @hue-3;\n  }\n\n  &.syntax--deleted {\n    color: @hue-5;\n  }\n\n  &.syntax--italic {\n    color: @hue-3;\n    font-style: italic;\n  }\n\n  &.syntax--heading {\n    color: @hue-5;\n\n    .syntax--punctuation.syntax--definition.syntax--heading {\n      color: @hue-2;\n    }\n  }\n\n  &.syntax--link {\n    color: @hue-1;\n  }\n\n  &.syntax--inserted {\n    color: @hue-4;\n  }\n\n  &.syntax--quote {\n    color: @hue-6;\n  }\n\n  &.syntax--raw {\n    color: @hue-4;\n  }\n}\n",digest:"667a736a7206e997d02a41a05bad03a50cfb9f74"},"node_modules/one-light-syntax/styles/syntax/c.less":{content:".syntax--source.syntax--c {\n  .syntax--keyword.syntax--operator {\n    color: @hue-3;\n  }\n}\n",digest:"ad63462d9a7352e4cd1f4ec52ea6daced57a2e51"},"node_modules/one-light-syntax/styles/syntax/cpp.less":{content:".syntax--source.syntax--cpp {\n  .syntax--keyword.syntax--operator {\n    color: @hue-3;\n  }\n}\n",digest:"3832ba5f453df1e76fee01bea74dbfd67d606c43"},"node_modules/one-light-syntax/styles/syntax/cs.less":{content:".syntax--source.syntax--cs {\n  .syntax--keyword.syntax--operator {\n    color: @hue-3;\n  }\n}\n",digest:"c92e873b912bb6f727365589722e17220a862b65"},"node_modules/one-light-syntax/styles/syntax/css.less":{content:".syntax--source.syntax--css {\n\n  // highlight properties/values if they are supported\n  .syntax--property-name,\n  .syntax--property-value {\n    color: @mono-2;\n    &.syntax--support {\n      color: @mono-1;\n    }\n  }\n\n}\n",digest:"d805d108e69c6469f8f840aa50d3ee9725164563"},"node_modules/one-light-syntax/styles/syntax/elixir.less":{content:".syntax--source.syntax--elixir {\n  .syntax--source.syntax--embedded.syntax--source {\n    color: @mono-1;\n  }\n  .syntax--constant.syntax--language,\n  .syntax--constant.syntax--numeric,\n  .syntax--constant.syntax--definition  {\n    color: @hue-2;\n  }\n  .syntax--variable.syntax--definition,\n  .syntax--variable.syntax--anonymous{\n    color: @hue-3;\n  }\n  .syntax--parameter.syntax--variable.syntax--function {\n    color: @hue-6;\n    font-style: italic;\n  }\n  .syntax--quoted{\n    color: @hue-4;\n  }\n  .syntax--keyword.syntax--special-method,\n  .syntax--embedded.syntax--section,\n  .syntax--embedded.syntax--source.syntax--empty,  {\n    color: @hue-5;\n  }\n  .syntax--readwrite.syntax--module {\n    .syntax--punctuation {\n      color: @hue-5;\n    }\n  }\n  .syntax--regexp.syntax--section,\n  .syntax--regexp.syntax--string {\n    color: @hue-5-2;\n  }\n  .syntax--separator,\n  .syntax--keyword.syntax--operator  {\n    color: @hue-6;\n  }\n  .syntax--variable.syntax--constant {\n    color: @hue-6-2;\n  }\n  .syntax--array,\n  .syntax--scope,\n  .syntax--section {\n    color: @mono-2;\n  }\n}\n",digest:"f38db739e45b524cbd59b83b02386e2006a69282"},"node_modules/one-light-syntax/styles/syntax/gfm.less":{content:".syntax--source.syntax--gfm {\n  .syntax--markup {\n    -webkit-font-smoothing: auto;\n  }\n\n  .syntax--link .syntax--entity {\n    color: @hue-2;\n  }\n}\n",digest:"c2da438ee70805f1b45524468243c2d97e711640"},"node_modules/one-light-syntax/styles/syntax/go.less":{content:".syntax--source.syntax--go {\n  .syntax--storage.syntax--type.syntax--string {\n      color: @hue-3;\n  }\n}\n",digest:"a268ce9af009eaed960a681895dfdbb02c7e84a7"},"node_modules/one-light-syntax/styles/syntax/ini.less":{content:".syntax--source.syntax--ini {\n  .syntax--keyword.syntax--other.syntax--definition.syntax--ini {\n    color: @hue-5;\n  }\n}\n",digest:"de894a7575d3add3eb4cc450e548334a674c2c43"},"node_modules/one-light-syntax/styles/syntax/java.less":{content:".syntax--source.syntax--java {\n  .syntax--storage {\n    &.syntax--modifier.syntax--import {\n      color: @hue-6-2;\n    }\n\n    &.syntax--type {\n      color: @hue-6-2;\n    }\n  }\n  .syntax--keyword.syntax--operator.syntax--instanceof {\n    color: @hue-3;\n  }\n}\n\n.syntax--source.syntax--java-properties {\n  .syntax--meta.syntax--key-pair {\n    color: @hue-5;\n\n    & > .syntax--punctuation {\n      color: @mono-1;\n    }\n  }\n}\n",digest:"9d10d34cea50c9e3dfc500dcb00e671a564249ef"},"node_modules/one-light-syntax/styles/syntax/javascript.less":{content:'.syntax--source.syntax--js {\n  .syntax--keyword.syntax--operator {\n    color: @hue-1;\n\n    // keywords are definded in https://github.com/atom/language-javascript/blob/master/grammars/javascript.cson\n    // search "instanceof" for location\n    &.syntax--delete,\n    &.syntax--in,\n    &.syntax--of,\n    &.syntax--instanceof,\n    &.syntax--new,\n    &.syntax--typeof,\n    &.syntax--void {\n      color: @hue-3;\n    }\n  }\n}\n',digest:"9f2eb70092bdcddf40197f0a028f437a5ee065d6"},"node_modules/one-light-syntax/styles/syntax/json.less":{content:".syntax--source.syntax--json {\n  .syntax--meta.syntax--structure.syntax--dictionary.syntax--json {\n    & > .syntax--string.syntax--quoted.syntax--json {\n      & > .syntax--punctuation.syntax--string {\n        color: @hue-5;\n      }\n      color: @hue-5;\n    }\n  }\n\n  .syntax--meta.syntax--structure.syntax--dictionary.syntax--json,\n  .syntax--meta.syntax--structure.syntax--array.syntax--json {\n    & > .syntax--value.syntax--json > .syntax--string.syntax--quoted.syntax--json,\n    & > .syntax--value.syntax--json > .syntax--string.syntax--quoted.syntax--json > .syntax--punctuation {\n      color: @hue-4;\n    }\n\n    & > .syntax--constant.syntax--language.syntax--json {\n      color: @hue-1;\n    }\n  }\n}\n",digest:"b2e4cb0fef7a06bfc26a30a299f82650552363a4"},"node_modules/one-light-syntax/styles/syntax/ng.less":{content:".syntax--ng {\n  &.syntax--interpolation {\n    color: @hue-5;\n\n    &.syntax--begin, &.syntax--end {\n      color: @hue-2;\n    }\n\n    .syntax--function {\n      color: @hue-5;\n\n      &.syntax--begin, &.syntax--end {\n        color: @hue-2;\n      }\n    }\n\n    .syntax--bool {\n      color: @hue-6;\n    }\n\n    .syntax--bracket {\n      color: @mono-1;\n    }\n  }\n\n  &.syntax--pipe, &.syntax--operator {\n    color: @mono-1;\n  }\n\n  &.syntax--tag {\n    color: @hue-1;\n  }\n\n  &.syntax--attribute-with-value {\n    .syntax--attribute-name {\n      color: @hue-6-2;\n    }\n\n    .syntax--string {\n      color: @hue-3;\n\n      &.syntax--begin, &.syntax--end {\n        color: @mono-1;\n      }\n    }\n  }\n}\n",digest:"06a6007e4d93c768a0e1f5047a385273944ee304"},"node_modules/one-light-syntax/styles/syntax/php.less":{content:".syntax--source.syntax--php {\n  .syntax--class.syntax--bracket {\n    color: @mono-1;\n  }\n}\n",digest:"45f5706d756cbcc6c0a86b554a45a96e97172c17"},"node_modules/one-light-syntax/styles/syntax/python.less":{content:".syntax--source.syntax--python {\n  .syntax--keyword.syntax--operator.syntax--logical.syntax--python {\n    color: @hue-3;\n  }\n\n  .syntax--variable.syntax--parameter {\n    color: @hue-6;\n  }\n}\n",digest:"b2a19ed1dfdc9938fe3714e8903f756e3a61dd8e"},"node_modules/one-light-syntax/styles/syntax/ruby.less":{content:".syntax--source.syntax--ruby {\n  .syntax--constant.syntax--other.syntax--symbol > .syntax--punctuation {\n    color: inherit;\n  }\n}\n",digest:"7037880883b3ecfe2912904f9e403271d293a4f0"},"node_modules/one-light-syntax/styles/syntax/typescript.less":{content:".syntax--source.syntax--ts {\n  .syntax--keyword.syntax--operator {\n    color: @hue-1;\n  }\n}\n\n.syntax--source.syntax--flow {\n  .syntax--keyword.syntax--operator {\n    color: @hue-1;\n  }\n}",digest:"ec2cc8646087ed78b0c1a3bcf9e224761ca3afb8"},"node_modules/solarized-dark-syntax/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n// Solarized Syntax Theme\n\n@import "styles/syntax-variables.less";\n\n// Editor\n@import "styles/editor.less";\n\n// Languages\n@import "styles/syntax/_base.less";\n@import "styles/syntax/c.less";\n@import "styles/syntax/coffee.less";\n@import "styles/syntax/css.less";\n@import "styles/syntax/go.less";\n@import "styles/syntax/java.less";\n@import "styles/syntax/javascript.less";\n@import "styles/syntax/markdown.less";\n@import "styles/syntax/markup.less";\n@import "styles/syntax/php.less";\n@import "styles/syntax/python.less";\n@import "styles/syntax/ruby.less";\n@import "styles/syntax/scala.less";\n@import "styles/syntax/typescript.less";\n',digest:"fa298dc3a6c8777a05c77ff831daa39ba1040cee"},"node_modules/solarized-dark-syntax/styles/colors.less":{content:"\n// Solarized color scheme\n// http://ethanschoonover.com/solarized#the-values\n\n// Background/Foreground Tones\n@base03: #002b36;\n@base02: #073642;\n\n// Content Tones\n@base01: #586e75;\n@base00: #657b83;\n@base0: #839496;\n@base1: #93a1a1;\n\n// Background/Foreground Tones\n@base2: #eee8d5;\n@base3: #fdf6e3;\n\n// Accent Colors\n@yellow: #b58900;\n@orange: #cb4b16;\n@red: #dc322f;\n@magenta: #d33682;\n@violet: #6c71c4;\n@blue: #268bd2;\n@cyan: #2aa198;\n@green: #859900;\n",digest:"b88cf362fd45cb5f470f88ca4bf885ed33b48652"},"node_modules/solarized-dark-syntax/styles/editor.less":{content:"atom-text-editor {\n  color: @syntax-text-color;\n  background-color: @syntax-background-color;\n\n  .gutter {\n    color: @syntax-gutter-text-color;\n    background-color: @syntax-gutter-background-color;\n\n    .line-number {\n      &.cursor-line {\n        background-color: @syntax-gutter-background-color-selected;\n      }\n    }\n  }\n\n  .invisible-character {\n    color: @syntax-invisible-character-color;\n  }\n\n  .indent-guide {\n    color: @syntax-indent-guide-color;\n  }\n\n  .cursor {\n    border-color: @syntax-cursor-color;\n  }\n\n  .cursor-line {\n    background-color: @syntax-cursor-line;\n  }\n\n  .selection .region {\n    background-color: @syntax-selection-color;\n  }\n\n  .fold-marker:after,\n  .gutter .line-number.folded {\n    color: @magenta;\n  }\n\n  .bracket-matcher .region {\n    border-color: @magenta;\n  }\n}\n",digest:"4408c92cb6db093998e90b7b387654142d1ac43e"},"node_modules/solarized-dark-syntax/styles/syntax-variables.less":{content:'@import "colors.less";\n\n// This defines all syntax variables that syntax themes must implement when they\n// include a syntax-variables.less file.\n\n// General colors\n@syntax-text-color: @base0;\n@syntax-cursor-color: @base3;\n@syntax-selection-color: lighten(@base02, 1%);\n@syntax-selection-flash-color: @base1;\n@syntax-background-color: @base03;\n\n// Guide colors\n@syntax-wrap-guide-color: lighten(@base02, 6%);\n@syntax-indent-guide-color: lighten(@base02, 6%);\n@syntax-invisible-character-color: lighten(@base02, 6%);\n\n// For find and replace markers\n@syntax-result-marker-color: @cyan;\n@syntax-result-marker-color-selected: @base3;\n\n// Gutter colors\n@syntax-gutter-text-color: @base0;\n@syntax-gutter-text-color-selected: @base2;\n@syntax-gutter-background-color: @base02;\n@syntax-gutter-background-color-selected: lighten(@base02, 6%);\n\n// For git diff info. i.e. in the gutter\n@syntax-color-added: @green;\n@syntax-color-renamed: @blue;\n@syntax-color-modified: @yellow;\n@syntax-color-removed: @red;\n\n// For language entity colors\n@syntax-color-variable: @blue;\n@syntax-color-constant: @yellow;\n@syntax-color-property: @yellow;\n@syntax-color-value: @cyan;\n@syntax-color-function: @blue;\n@syntax-color-method: @blue;\n@syntax-color-class: @blue;\n@syntax-color-keyword: @green;\n@syntax-color-tag: @blue;\n@syntax-color-attribute: @syntax-comment-color;\n@syntax-color-import: @red;\n@syntax-color-snippet: @syntax-color-keyword;\n\n\n// Custom variables\n// Warning: Don\'t use in packages\n\n@syntax-comment-color: @base01;\n@syntax-subtle-color: @base00;\n@syntax-emphasized-color: @base1;\n@syntax-cursor-line: fade(lighten(@syntax-background-color, 30%), 8%); // needs to be semi-transparent\n',digest:"bbb01b9cb4a1d259e186fd788c6340a9ca326036"},"node_modules/solarized-dark-syntax/styles/syntax/_base.less":{content:".syntax--comment {\n  color: @syntax-comment-color;\n  font-style: italic;\n\n  .syntax--markup.syntax--link {\n    color: @syntax-comment-color;\n  }\n}\n\n.syntax--string {\n  color: @cyan;\n  &.syntax--regexp {\n    color: @red;\n  }\n}\n\n.syntax--constant {\n  &.syntax--numeric {\n    color: @magenta;\n  }\n  &.syntax--language {\n    color: @yellow;\n  }\n  &.syntax--character,\n  &.syntax--other,\n  &.syntax--support {\n    color: @orange;\n  }\n}\n\n.syntax--variable {\n  color: @blue;\n}\n\n.syntax--keyword {\n  color: @green;\n}\n\n.syntax--storage {\n  color: @green;\n}\n\n.syntax--meta.syntax--class {\n  color: @blue;\n}\n\n.syntax--entity {\n  &.syntax--name {\n    &.syntax--class,\n    &.syntax--function,\n    &.syntax--section,\n    &.syntax--type {\n      color: @blue;\n    }\n  }\n  &.syntax--other.syntax--attribute-name {\n    color: @syntax-subtle-color;\n  }\n}\n\n.syntax--support {\n  &.syntax--function {\n    color: @blue;\n    &.syntax--builtin {\n      color: @green;\n    }\n  }\n  &.syntax--type,\n  &.syntax--class {\n    color: @green;\n  }\n}\n\n.syntax--tag {\n  &.syntax--entity.syntax--name {\n    color: @blue;\n  }\n  &.syntax--punctuation.syntax--definition {\n    &.syntax--html,\n    &.syntax--begin,\n    &.syntax--end {\n      color: @syntax-comment-color;\n    }\n  }\n}\n\n.syntax--invalid {\n  &.syntax--deprecated {\n    color: @yellow;\n    text-decoration: underline;\n  }\n  &.syntax--illegal {\n    color: @red;\n    text-decoration: underline;\n  }\n}\n\n.syntax--none {\n  color: @syntax-text-color;\n}\n",digest:"8a96a96648d262c2b2c15158b5c7a86c823a5aa4"},"node_modules/solarized-dark-syntax/styles/syntax/c.less":{content:".syntax--source.syntax--c,\n.syntax--source.syntax--cpp {\n  .syntax--meta.syntax--preprocessor {\n    color: @red;\n  }\n  .syntax--keyword.syntax--control.syntax--directive {\n    color: @orange;\n  }\n  .syntax--punctuation.syntax--string {\n    color: @cyan;\n  }\n  .syntax--constant {\n    color: @orange;\n\n    &.syntax--numeric, &.syntax--language.syntax--c {\n      color: @cyan;\n    }\n  }\n  .syntax--storage {\n    color: @yellow;\n  }\n  .syntax--entity {\n    color: @syntax-text-color;\n\n    &.syntax--name.syntax--function.syntax--preprocessor {\n      color: @red;\n    }\n  }\n  .syntax--support.syntax--type {\n    color: @yellow;\n\n    &.syntax--posix-reserved {\n      color: @syntax-text-color;\n    }\n  }\n  .syntax--variable {\n    &.syntax--other.syntax--dot-access {\n      color: @syntax-text-color;\n    }\n    &.syntax--parameter.syntax--preprocessor {\n      color: @red;\n    }\n  }\n}\n",digest:"839d65ac623e01b74b7e42269590d9feff8fa65c"},"node_modules/solarized-dark-syntax/styles/syntax/coffee.less":{content:".syntax--source.syntax--coffee {\n  .syntax--support.syntax--class {\n    color: @green;\n  }\n\n  .syntax--variable,\n  .syntax--entity.syntax--name.syntax--function,\n  .syntax--entity.syntax--name.syntax--class {\n    color: @blue;\n  }\n  .syntax--variable.syntax--parameter.syntax--function {\n    color: @syntax-text-color;\n  }\n  .syntax--variable.syntax--other.syntax--readwrite {\n    color: @green;\n  }\n\n  .syntax--storage.syntax--type.syntax--function {\n    color: @green;\n  }\n\n  .syntax--entity.syntax--name {\n    color: @syntax-text-color;\n  }\n\n  .syntax--meta.syntax--brace {\n    &.syntax--round,\n    &.syntax--square {\n      color: @syntax-text-color;\n    }\n  }\n  .syntax--meta.syntax--delimiter {\n    color: @syntax-text-color;\n  }\n\n  .syntax--storage.syntax--type.syntax--class {\n    color: @green;\n  }\n\n  .syntax--punctuation.syntax--terminator {\n    color: @syntax-text-color;\n  }\n\n  .syntax--punctuation.syntax--section.syntax--embedded {\n    color: @red;\n  }\n  .syntax--embedded.syntax--source {\n    color: @syntax-text-color;\n  }\n\n  .syntax--constant.syntax--numeric {\n    color: @magenta;\n  }\n\n  .syntax--constant.syntax--language.syntax--boolean {\n    color: @yellow;\n  }\n}\n",digest:"2736764cbf69f7adaac92819ca676cbce669b54b"},"node_modules/solarized-dark-syntax/styles/syntax/css.less":{content:".syntax--source.syntax--css {\n\n  .syntax--punctuation {\n    &.syntax--separator,\n    &.syntax--terminator {\n      color: @syntax-text-color;\n    }\n    &.syntax--property-list.syntax--begin,\n    &.syntax--property-list.syntax--end {\n      color: @red;\n    }\n    &.syntax--section.syntax--function {\n      color: @cyan;\n    }\n  }\n\n  .syntax--entity.syntax--name {\n    color: @green;\n  }\n  .syntax--attribute-name.syntax--class,\n  .syntax--id {\n    color: @blue;\n  }\n  .syntax--pseudo-element,\n  .syntax--pseudo-class {\n    color: @orange;\n  }\n\n  .syntax--property-value {\n    color: @cyan;\n  }\n  .syntax--constant.syntax--numeric {\n    color: @cyan;\n    .syntax--unit {\n      color: @cyan;\n    }\n  }\n  .syntax--rgb-value {\n    color: @cyan;\n  }\n  .syntax--support.syntax--constant {\n    color: @cyan;\n    &.syntax--media {\n      color: @red;\n    }\n  }\n\n  .syntax--keyword.syntax--important {\n    color: @red;\n  }\n\n}\n\n\n// Less/Sass should have their own files,\n// but for just a single override, here should be fine too\n\n.syntax--source.syntax--less,\n.syntax--source.syntax--scss {\n  .syntax--keyword.syntax--unit {\n    color: @cyan;\n  }\n}\n",digest:"b6fac27e3e87d879c7bc7c62b4fb67106cdbb3c7"},"node_modules/solarized-dark-syntax/styles/syntax/go.less":{content:".syntax--source.syntax--go {\n\n  .syntax--operator {\n    color: @syntax-text-color;\n    &.syntax--assignment {\n      color: @green;\n    }\n  }\n\n}\n",digest:"2a8e5aaf48786eb497de8fc9bf8f1003a8ece54b"},"node_modules/solarized-dark-syntax/styles/syntax/java.less":{content:".syntax--source.syntax--java {\n  .syntax--keyword.syntax--operator{\n    color:@green;\n  }\n  .syntax--keyword.syntax--import{\n    color: @orange;\n  }\n  .syntax--storage.syntax--modifier.syntax--import{\n    color: @syntax-comment-color;\n  }\n  .syntax--meta.syntax--class{\n    .syntax--storage.syntax--modifier{\n      color: @yellow;\n    }\n    .syntax--meta.syntax--class.syntax--identifier{\n      .syntax--entity.syntax--name.syntax--type.syntax--class{\n        color: @blue;\n      }\n    }\n  }\n  .syntax--storage.syntax--type.syntax--primitive.syntax--array{\n    color:@green;\n  }\n  .syntax--constant.syntax--numeric{\n    color:@magenta;\n  }\n  .syntax--constant.syntax--other{\n    color:@orange;\n  }\n  .syntax--storage.syntax--type{\n    color:@green;\n  }\n  .syntax--meta.syntax--method-call{\n    //@ibocon: method parameter's color\n    color:@red;\n    //@ibocon: method and variable use different hightlight\n    .syntax--meta.syntax--method{\n      color:@violet;\n    }\n    .syntax--punctuation.syntax--definition.syntax--seperator.syntax--parameter{\n      color:@green;\n    }\n  }\n  .syntax--punctuation.syntax--definition.syntax--method-parameters{\n    color: @syntax-emphasized-color;\n  }\n}\n",digest:"7ed0d0331bfcc2ca5bfa85dddaa51e547df18593"},"node_modules/solarized-dark-syntax/styles/syntax/javascript.less":{content:".syntax--source.syntax--js {\n  .syntax--comma {\n    color: @syntax-text-color;\n  }\n\n  .syntax--support.syntax--class {\n    color: @green;\n  }\n  \n  .syntax--entity {\n    &.syntax--name.syntax--type {\n      color: @yellow;\n    }\n    &.syntax--name {\n      color: @syntax-text-color;\n      \n      &.syntax--function {\n        color: @blue;\n      }\n    }\n    \n    &.syntax--name.syntax--tag {\n      color: @blue;\n    }\n    \n    &.syntax--other.syntax--attribute-name {\n      color: @yellow;\n    }\n  }\n\n\n  .syntax--meta.syntax--brace {\n    color: @syntax-text-color;\n  }\n\n  .syntax--keyword {\n    color: @syntax-text-color;\n  }\n  .syntax--keyword.syntax--operator.syntax--new {\n    color: @green;\n  }\n  .syntax--keyword.syntax--control {\n    color: @orange;\n  }\n  .syntax--keyword.syntax--control.syntax--regexp {\n    color: @cyan;\n  }\n\n  .syntax--variable {\n    color: @syntax-text-color;\n  }\n  .syntax--variable.syntax--dom {\n    color: @green;\n  }\n  .syntax--delimiter + .syntax--dom {\n    color: @syntax-text-color;\n  }\n  .syntax--name {\n    color: @syntax-text-color;\n  }\n  .syntax--variable.syntax--language {\n    color: @blue;\n  }\n  .syntax--variable.syntax--parameter {\n    color: @syntax-text-color;\n  }\n\n  .syntax--regexp {\n    color: @cyan;\n  }\n\n  .syntax--support.syntax--function {\n    color: @syntax-text-color;\n  }\n  .syntax--support.syntax--constant {\n    color: @syntax-text-color;\n  }\n  \n  .syntax--storage.syntax--modifier {\n    color: @yellow;\n  }\n\n  .syntax--punctuation.syntax--terminator.syntax--statement {\n    color: @syntax-text-color;\n  }\n\n  .syntax--meta.syntax--delimiter.syntax--method.syntax--period {\n    color: @syntax-text-color;\n  }\n  .syntax--meta.syntax--brace.syntax--square {\n    color: @blue;\n  }\n  .syntax--meta.syntax--brace.syntax--curly {\n    color: @blue;\n  }\n  \n  .syntax--string.syntax--quoted.syntax--template {\n    .syntax--embedded.syntax--source {\n      color: @syntax-text-color;\n      & > .syntax--embedded.syntax--punctuation {\n        color: @red;\n      }\n    }\n  }\n  \n  &.syntax--embedded .syntax--entity.syntax--name.syntax--tag {\n    color: @blue;\n  }\n\n  .syntax--import {\n    .syntax--control {\n      color: @orange;\n    }\n  }\n}\n\n\n// JavaScript (Rails) language-ruby-on-rails\n\n.syntax--source.syntax--js.syntax--rails {\n  .syntax--instance {\n    color: @blue;\n  }\n\n  .syntax--class {\n    color: @yellow;\n  }\n}\n",digest:"25ae08419528cd08a656192f4800b16c98af7013"},"node_modules/solarized-dark-syntax/styles/syntax/markdown.less":{content:".syntax--md,\n.syntax--gfm {\n  .syntax--link .syntax--entity {\n    color: @violet;\n  }\n\n  .syntax--list {\n    &.syntax--ordered {\n      color: @green;\n    }\n    &.syntax--unordered {\n      color: @yellow;\n    }\n  }\n\n  .syntax--raw {\n    font-style: italic;\n  }\n\n  &.syntax--support {\n    color:@syntax-comment-color;\n    &.syntax--quote {\n      color: @violet;\n    }\n  }\n}\n",digest:"817fda2f1b1a953d3a15483fe3ce3cfd00eb1d15"},"node_modules/solarized-dark-syntax/styles/syntax/markup.less":{content:".syntax--markup {\n\n  &.syntax--bold {\n    font-weight: bold;\n  }\n  &.syntax--italic {\n    font-style: italic;\n  }\n\n  &.syntax--heading {\n    color: @blue;\n  }\n\n  &.syntax--link {\n    color: @cyan;\n  }\n\n  &.syntax--deleted {\n    color: @red;\n  }\n\n  &.syntax--changed {\n    color: @yellow;\n  }\n\n  &.syntax--inserted {\n    color: @cyan;\n  }\n\n}\n",digest:"2b1893b8d2de8d42b582efbd90608833a8e26fdc"},"node_modules/solarized-dark-syntax/styles/syntax/php.less":{content:".syntax--source.syntax--php {\n  .syntax--storage {\n    &.syntax--type {\n      &.syntax--class {\n        color: @yellow;\n      }\n      &.syntax--function {\n        color: @orange;\n      }\n    }\n    &.syntax--modifier {\n      color: @yellow;\n    }\n  }\n  .syntax--entity {\n    &.syntax--name {\n      &.syntax--type.syntax--class {\n        color: @syntax-text-color;\n      }\n      &.syntax--function {\n        color: @syntax-text-color;\n      }\n    }\n    &.syntax--other {\n      color: @syntax-text-color;\n    }\n  }\n  .syntax--variable {\n    color: @blue;\n  }\n  .syntax--punctuation.syntax--definition {\n    color: @syntax-text-color;\n    &.syntax--comment {\n      color: @syntax-comment-color;\n    }\n    &.syntax--array {\n      color: @red;\n    }\n    &.syntax--string {\n      color: @syntax-text-color;\n    }\n    &.syntax--variable {\n      color: @green;\n    }\n  }\n  .syntax--support.syntax--function {\n    &.syntax--construct {\n      color: @yellow;\n    }\n    &.syntax--array {\n      color: @green;\n    }\n  }\n  .syntax--keyword {\n    &.syntax--operator {\n      &.syntax--class {\n        color: @yellow;\n      }\n      &.syntax--assignment {\n        color: @green;\n      }\n    }\n    &.syntax--other {\n      color: @red;\n    }\n  }\n}\n",digest:"4c57fce11fabe63d59d4e0d964477d7a54ee8f83"},"node_modules/solarized-dark-syntax/styles/syntax/python.less":{content:".syntax--source.syntax--python {\n  .syntax--entity {\n    color: @syntax-text-color;\n\n    &.syntax--name {\n      color: @blue;\n    }\n    &.syntax--other {\n      color: @blue;\n    }\n  }\n\n  .syntax--function {\n    color: @blue;\n\n    &.syntax--magic {\n      color: @blue;\n    }\n  }\n\n  .syntax--punctuation.syntax--string {\n    color: @cyan;\n  }\n  .syntax--keyword {\n    &.syntax--operator {\n      color: @syntax-text-color;\n      &.syntax--quantifier {\n        color: @cyan;\n      }\n      &.syntax--logical {\n        color: @green;\n      }\n    }\n    &.syntax--control.syntax--import {\n      color: @orange;\n    }\n    &.syntax--other {\n      color: @green;\n    }\n  }\n  .syntax--constant {\n    &.syntax--language {\n      color: @blue;\n    }\n    &.syntax--character {\n      color: @cyan;\n    }\n    &.syntax--other {\n      color: @red;\n    }\n  }\n\n  .syntax--entity.syntax--name.syntax--type.syntax--class {\n    color: @blue;\n  }\n  .syntax--variable {\n    color: @syntax-text-color;\n  }\n  .syntax--support {\n    &.syntax--function.syntax--builtin {\n      color: @blue;\n    }\n    &.syntax--type {\n      &.syntax--exception.syntax--python {\n        color: @yellow;\n      }\n      &.syntax--python {\n        color: @blue;\n      }\n    }\n  }\n  .syntax--storage.syntax--type.syntax--string {\n    color: @cyan;\n  }\n\n  .syntax--storage.syntax--type.syntax--class {\n    color: @green;\n    &.syntax--todo {\n      color: @magenta;\n    }\n  }\n\n  .syntax--storage.syntax--type.syntax--function {\n    color: @green;\n  }\n\n  .syntax--punctuation.syntax--definition.syntax--parameters {\n    color: @syntax-text-color;\n  }\n\n  .syntax--punctuation.syntax--section.syntax--function.syntax--begin {\n    color: @syntax-text-color;\n  }\n\n  .syntax--punctuation.syntax--separator.syntax--parameters {\n    color: @syntax-text-color;\n  }\n\n\n}\n",digest:"33190f5b629f061f135b7bbd8be544b6c06ed4f8"},"node_modules/solarized-dark-syntax/styles/syntax/ruby.less":{content:".syntax--source.syntax--ruby {\n\n  .syntax--meta.syntax--embedded {\n    .syntax--punctuation.syntax--section {\n      color: @red;\n    }\n  }\n  .syntax--punctuation.syntax--definition {\n    color: @syntax-text-color;\n    &.syntax--string {\n      color: @red;\n    }\n  }\n  .syntax--punctuation.syntax--definition.syntax--comment {\n    color: @syntax-comment-color;\n  }\n  .syntax--entity.syntax--inherited-class {\n    color: @yellow;\n  }\n  .syntax--variable {\n    &.syntax--parameter {\n      color: @syntax-text-color;\n    }\n  }\n  .syntax--variable.syntax--constant {\n    color: @yellow;\n  }\n  .syntax--constant.syntax--boolean {\n    color: @cyan;\n  }\n  .syntax--instance {\n    .syntax--punctuation.syntax--definition {\n      color: @blue;\n    }\n  }\n  .syntax--class {\n    color: @yellow;\n    &.syntax--control {\n      color: @syntax-text-color;\n    }\n  }\n  .syntax--module {\n    color: @yellow;\n  }\n  .syntax--require {\n    .syntax--keyword.syntax--other.syntax--special-method {\n      color: @orange;\n    }\n  }\n  .syntax--keyword.syntax--other.syntax--special-method {\n    color: @orange;\n  }\n  .syntax--keyword.syntax--other {\n    color: @green;\n  }\n  .syntax--keyword.syntax--control {\n    color: @green;\n  }\n  .syntax--keyword.syntax--operator {\n    color: @syntax-text-color;\n  }\n  .syntax--special-method {\n    color: @blue;\n  }\n  .syntax--symbol {\n    color: @cyan;\n    .syntax--punctuation.syntax--definition {\n      color: @cyan;\n    }\n  }\n  .syntax--hashkey {\n    color: @red;\n    .syntax--punctuation.syntax--definition {\n      color: @red;\n    }\n  }\n  .syntax--string.syntax--regexp {\n    color: @red;\n  }\n  .syntax--todo {\n    color: @magenta;\n  }\n  .syntax--variable.syntax--ruby.syntax--global {\n    color: @blue;\n    .syntax--punctuation {\n      color: @blue;\n    }\n  }\n  .syntax--variable.syntax--block {\n    color: @blue;\n  }\n  .syntax--variable.syntax--self {\n    color: @cyan;\n  }\n  .syntax--punctuation.syntax--separator {\n    color: @syntax-text-color;\n  }\n  .syntax--numeric {\n    color: @cyan;\n  }\n  .syntax--punctuation.syntax--section.syntax--regexp {\n    color: @red;\n  }\n  .syntax--string.syntax--interpolated {\n    color: @cyan;\n  }\n  .syntax--string.syntax--interpolated {\n    .syntax--embedded.syntax--line.syntax--ruby {\n      .syntax--punctuation {\n        .syntax--source.syntax--ruby {\n          color: @red;\n        }\n      }\n      .syntax--source.syntax--ruby {\n        .syntax--punctuation.syntax--array,\n        .syntax--punctuation.syntax--function {\n          color: @syntax-text-color;\n        }\n        color: @syntax-text-color;\n      }\n    }\n  }\n  .syntax--support.syntax--function {\n    color: @syntax-text-color;\n  }\n  .syntax--support.syntax--function.syntax--kernel {\n    color: @green;\n  }\n}\n",digest:"cfe9b7caebcae391298920cc1ad3ed4f945a1219"},"node_modules/solarized-dark-syntax/styles/syntax/scala.less":{content:".syntax--source.syntax--scala {\n  .syntax--variable {\n    color: @syntax-emphasized-color;\n  }\n\n  .syntax--declaration {\n    color: @syntax-emphasized-color;\n    font-weight: bold;\n  }\n  .syntax--comparison {\n    color: @syntax-emphasized-color;\n  }\n  .syntax--class, .syntax--type {\n    color: @yellow;\n  }\n  .syntax--val {\n    font-weight: normal;\n  }\n  .syntax--variable {\n    font-weight: bold;\n  }\n  .syntax--variable.syntax--parameter {\n    color: @violet;\n    font-weight: normal;\n  }\n  .syntax--control.syntax--flow {\n    color: @syntax-emphasized-color;\n    font-weight: bold;\n  }\n  .syntax--constant.syntax--language {\n    color: @syntax-emphasized-color;\n    font-weight: bold;\n  }\n  .syntax--function.syntax--declaration {\n    color: @violet;\n  }\n  .syntax--modifier.syntax--other {\n    font-weight: bold;\n  }\n  .syntax--package {\n    color: @syntax-emphasized-color;\n  }\n  .syntax--variable.syntax--import {\n    font-weight: normal;\n  }\n\n  .syntax--type {\n    .syntax--bounds, .syntax--class {\n      color: @violet;\n    }\n  }\n\n  .syntax--documentation {\n    :not(.syntax--embedded) {\n      // out of scope ?\n      // https://github.syntax--com/atom/link\n      &.syntax--link.syntax--entity {\n        color: @blue;\n        text-decoration: underline;\n      }\n      .syntax--class, .syntax--parameter {\n        color: @syntax-emphasized-color;\n      }\n      .syntax--description {\n        color: @syntax-comment-color;\n      }\n    }\n  }\n\n  .syntax--embedded {\n    color: darken(@syntax-emphasized-color, 15%);\n\n    // so we dont confused it with normal expressions\n    font-style: italic;\n    .syntax--margin, .syntax--delimiters {\n      font-style: normal;\n    }\n  }\n}\n",digest:"6edaa134daab31cecf6827ac74b9ee9653d42dab"},"node_modules/solarized-dark-syntax/styles/syntax/typescript.less":{content:".syntax--source.syntax--ts,\n.syntax--source.syntax--tsx {\n  .syntax--import {\n    .syntax--control {\n      color: @orange;\n    }\n  }\n\n  .syntax--entity {\n    &.syntax--name.syntax--type {\n      color: @yellow;\n    }\n\n    &.syntax--inherited-class {\n      color: @yellow;\n    }\n  }\n\n  .syntax--support.syntax--type {\n    color: @yellow;\n  }\n}\n",digest:"f46a840d6945c5187b0cb9e799b732b7cae28b22"},"node_modules/solarized-light-syntax/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n// Solarized Syntax Theme\n\n@import "styles/syntax-variables.less";\n\n// Editor\n@import "styles/editor.less";\n\n// Languages\n@import "styles/syntax/_base.less";\n@import "styles/syntax/c.less";\n@import "styles/syntax/coffee.less";\n@import "styles/syntax/css.less";\n@import "styles/syntax/go.less";\n@import "styles/syntax/java.less";\n@import "styles/syntax/javascript.less";\n@import "styles/syntax/markdown.less";\n@import "styles/syntax/markup.less";\n@import "styles/syntax/php.less";\n@import "styles/syntax/python.less";\n@import "styles/syntax/ruby.less";\n@import "styles/syntax/scala.less";\n@import "styles/syntax/typescript.less";\n',digest:"fa298dc3a6c8777a05c77ff831daa39ba1040cee"},"node_modules/solarized-light-syntax/styles/colors.less":{content:"\n// Solarized color scheme\n// http://ethanschoonover.com/solarized#the-values\n\n// Background/Foreground Tones\n@base03: #002b36;\n@base02: #073642;\n\n// Content Tones\n@base01: #586e75;\n@base00: #657b83;\n@base0: #839496;\n@base1: #93a1a1;\n\n// Background/Foreground Tones\n@base2: #eee8d5;\n@base3: #fdf6e3;\n\n// Accent Colors\n@yellow: #b58900;\n@orange: #cb4b16;\n@red: #dc322f;\n@magenta: #d33682;\n@violet: #6c71c4;\n@blue: #268bd2;\n@cyan: #2aa198;\n@green: #859900;\n",digest:"b88cf362fd45cb5f470f88ca4bf885ed33b48652"},"node_modules/solarized-light-syntax/styles/editor.less":{content:"atom-text-editor {\n  color: @syntax-text-color;\n  background-color: @syntax-background-color;\n\n  .gutter {\n    color: @syntax-gutter-text-color;\n    background-color: @syntax-gutter-background-color;\n\n    .line-number {\n      &.cursor-line {\n        background-color: @syntax-gutter-background-color-selected;\n      }\n    }\n  }\n\n  .invisible-character {\n    color: @syntax-invisible-character-color;\n  }\n\n  .indent-guide {\n    color: @syntax-indent-guide-color;\n  }\n\n  .cursor {\n    border-color: @syntax-cursor-color;\n  }\n\n  .cursor-line {\n    background-color: @syntax-cursor-line;\n  }\n\n  .selection .region {\n    background-color: @syntax-selection-color;\n  }\n\n  .fold-marker:after,\n  .gutter .line-number.folded {\n    color: @magenta;\n  }\n\n  .bracket-matcher .region {\n    border-color: @magenta;\n  }\n}\n",digest:"4408c92cb6db093998e90b7b387654142d1ac43e"},"node_modules/solarized-light-syntax/styles/syntax-variables.less":{content:'@import "colors.less";\n\n// This defines all syntax variables that syntax themes must implement when they\n// include a syntax-variables.less file.\n\n// General colors\n@syntax-text-color: @base00;\n@syntax-cursor-color: @base03;\n@syntax-selection-color: @base2;\n@syntax-selection-flash-color: @base0;\n@syntax-background-color: @base3;\n\n// Guide colors\n@syntax-wrap-guide-color: darken(@base2, 12%);\n@syntax-indent-guide-color: darken(@base2, 12%);\n@syntax-invisible-character-color: darken(@base2, 12%);\n\n// For find and replace markers\n@syntax-result-marker-color: @base1;\n@syntax-result-marker-color-selected: @base03;\n\n// Gutter colors\n@syntax-gutter-text-color: @base00;\n@syntax-gutter-text-color-selected: @base03;\n@syntax-gutter-background-color: @base2;\n@syntax-gutter-background-color-selected: darken(@syntax-gutter-background-color, 10%);\n\n// For git diff info. i.e. in the gutter\n@syntax-color-added: @green;\n@syntax-color-renamed: @blue;\n@syntax-color-modified: @yellow;\n@syntax-color-removed: @red;\n\n// For language entity colors\n@syntax-color-variable: @blue;\n@syntax-color-constant: @yellow;\n@syntax-color-property: @yellow;\n@syntax-color-value: @cyan;\n@syntax-color-function: @blue;\n@syntax-color-method: @blue;\n@syntax-color-class: @blue;\n@syntax-color-keyword: @green;\n@syntax-color-tag: @blue;\n@syntax-color-attribute: @syntax-comment-color;\n@syntax-color-import: @red;\n@syntax-color-snippet: @syntax-color-keyword;\n\n\n// Custom variables\n// Warning: Don\'t use in packages\n\n@syntax-comment-color: @base1;\n@syntax-subtle-color: @base00;\n@syntax-emphasized-color: @base01;\n@syntax-cursor-line: fade(darken(@syntax-background-color, 30%), 15%); // needs to be semi-transparent\n',digest:"54a17482b9891817792e54e9c0bc3c899b3f0dad"},"node_modules/solarized-light-syntax/styles/syntax/_base.less":{content:".syntax--comment {\n  color: @syntax-comment-color;\n  font-style: italic;\n\n  .syntax--markup.syntax--link {\n    color: @syntax-comment-color;\n  }\n}\n\n.syntax--string {\n  color: @cyan;\n  &.syntax--regexp {\n    color: @red;\n  }\n}\n\n.syntax--constant {\n  &.syntax--numeric {\n    color: @magenta;\n  }\n  &.syntax--language {\n    color: @yellow;\n  }\n  &.syntax--character,\n  &.syntax--other,\n  &.syntax--support {\n    color: @orange;\n  }\n}\n\n.syntax--variable {\n  color: @blue;\n}\n\n.syntax--keyword {\n  color: @green;\n}\n\n.syntax--storage {\n  color: @green;\n}\n\n.syntax--meta.syntax--class {\n  color: @blue;\n}\n\n.syntax--entity {\n  &.syntax--name {\n    &.syntax--class,\n    &.syntax--function,\n    &.syntax--section,\n    &.syntax--type {\n      color: @blue;\n    }\n  }\n  &.syntax--other.syntax--attribute-name {\n    color: @syntax-subtle-color;\n  }\n}\n\n.syntax--support {\n  &.syntax--function {\n    color: @blue;\n    &.syntax--builtin {\n      color: @green;\n    }\n  }\n  &.syntax--type,\n  &.syntax--class {\n    color: @green;\n  }\n}\n\n.syntax--tag {\n  &.syntax--entity.syntax--name {\n    color: @blue;\n  }\n  &.syntax--punctuation.syntax--definition {\n    &.syntax--html,\n    &.syntax--begin,\n    &.syntax--end {\n      color: @syntax-comment-color;\n    }\n  }\n}\n\n.syntax--invalid {\n  &.syntax--deprecated {\n    color: @yellow;\n    text-decoration: underline;\n  }\n  &.syntax--illegal {\n    color: @red;\n    text-decoration: underline;\n  }\n}\n\n.syntax--none {\n  color: @syntax-text-color;\n}\n",digest:"8a96a96648d262c2b2c15158b5c7a86c823a5aa4"},"node_modules/solarized-light-syntax/styles/syntax/c.less":{content:".syntax--source.syntax--c,\n.syntax--source.syntax--cpp {\n  .syntax--meta.syntax--preprocessor {\n    color: @red;\n  }\n  .syntax--keyword.syntax--control.syntax--directive {\n    color: @orange;\n  }\n  .syntax--punctuation.syntax--string {\n    color: @cyan;\n  }\n  .syntax--constant {\n    color: @orange;\n\n    &.syntax--numeric, &.syntax--language.syntax--c {\n      color: @cyan;\n    }\n  }\n  .syntax--storage {\n    color: @yellow;\n  }\n  .syntax--entity {\n    color: @syntax-text-color;\n\n    &.syntax--name.syntax--function.syntax--preprocessor {\n      color: @red;\n    }\n  }\n  .syntax--support.syntax--type {\n    color: @yellow;\n\n    &.syntax--posix-reserved {\n      color: @syntax-text-color;\n    }\n  }\n  .syntax--variable {\n    &.syntax--other.syntax--dot-access {\n      color: @syntax-text-color;\n    }\n    &.syntax--parameter.syntax--preprocessor {\n      color: @red;\n    }\n  }\n}\n",digest:"839d65ac623e01b74b7e42269590d9feff8fa65c"},"node_modules/solarized-light-syntax/styles/syntax/coffee.less":{content:".syntax--source.syntax--coffee {\n  .syntax--support.syntax--class {\n    color: @green;\n  }\n\n  .syntax--variable,\n  .syntax--entity.syntax--name.syntax--function,\n  .syntax--entity.syntax--name.syntax--class {\n    color: @blue;\n  }\n  .syntax--variable.syntax--parameter.syntax--function {\n    color: @syntax-text-color;\n  }\n  .syntax--variable.syntax--other.syntax--readwrite {\n    color: @green;\n  }\n\n  .syntax--storage.syntax--type.syntax--function {\n    color: @green;\n  }\n\n  .syntax--entity.syntax--name {\n    color: @syntax-text-color;\n  }\n\n  .syntax--meta.syntax--brace {\n    &.syntax--round,\n    &.syntax--square {\n      color: @syntax-text-color;\n    }\n  }\n  .syntax--meta.syntax--delimiter {\n    color: @syntax-text-color;\n  }\n\n  .syntax--storage.syntax--type.syntax--class {\n    color: @green;\n  }\n\n  .syntax--punctuation.syntax--terminator {\n    color: @syntax-text-color;\n  }\n\n  .syntax--punctuation.syntax--section.syntax--embedded {\n    color: @red;\n  }\n  .syntax--embedded.syntax--source {\n    color: @syntax-text-color;\n  }\n\n  .syntax--constant.syntax--numeric {\n    color: @magenta;\n  }\n\n  .syntax--constant.syntax--language.syntax--boolean {\n    color: @yellow;\n  }\n}\n",digest:"2736764cbf69f7adaac92819ca676cbce669b54b"},"node_modules/solarized-light-syntax/styles/syntax/css.less":{content:".syntax--source.syntax--css {\n\n  .syntax--punctuation {\n    &.syntax--separator,\n    &.syntax--terminator {\n      color: @syntax-text-color;\n    }\n    &.syntax--property-list.syntax--begin,\n    &.syntax--property-list.syntax--end {\n      color: @red;\n    }\n    &.syntax--section.syntax--function {\n      color: @cyan;\n    }\n  }\n\n  .syntax--entity.syntax--name {\n    color: @green;\n  }\n  .syntax--attribute-name.syntax--class,\n  .syntax--id {\n    color: @blue;\n  }\n  .syntax--pseudo-element,\n  .syntax--pseudo-class {\n    color: @orange;\n  }\n\n  .syntax--property-value {\n    color: @cyan;\n  }\n  .syntax--constant.syntax--numeric {\n    color: @cyan;\n    .syntax--unit {\n      color: @cyan;\n    }\n  }\n  .syntax--rgb-value {\n    color: @cyan;\n  }\n  .syntax--support.syntax--constant {\n    color: @cyan;\n    &.syntax--media {\n      color: @red;\n    }\n  }\n\n  .syntax--keyword.syntax--important {\n    color: @red;\n  }\n\n}\n\n\n// Less/Sass should have their own files,\n// but for just a single override, here should be fine too\n\n.syntax--source.syntax--less,\n.syntax--source.syntax--scss {\n  .syntax--keyword.syntax--unit {\n    color: @cyan;\n  }\n}\n",digest:"b6fac27e3e87d879c7bc7c62b4fb67106cdbb3c7"},"node_modules/solarized-light-syntax/styles/syntax/go.less":{content:".syntax--source.syntax--go {\n\n  .syntax--operator {\n    color: @syntax-text-color;\n    &.syntax--assignment {\n      color: @green;\n    }\n  }\n\n}\n",digest:"2a8e5aaf48786eb497de8fc9bf8f1003a8ece54b"},"node_modules/solarized-light-syntax/styles/syntax/java.less":{content:".syntax--source.syntax--java {\n  .syntax--keyword.syntax--operator{\n    color:@green;\n  }\n  .syntax--keyword.syntax--import{\n    color: @orange;\n  }\n  .syntax--storage.syntax--modifier.syntax--import{\n    color: @syntax-comment-color;\n  }\n  .syntax--meta.syntax--class{\n    .syntax--storage.syntax--modifier{\n      color: @yellow;\n    }\n    .syntax--meta.syntax--class.syntax--identifier{\n      .syntax--entity.syntax--name.syntax--type.syntax--class{\n        color: @blue;\n      }\n    }\n  }\n  .syntax--storage.syntax--type.syntax--primitive.syntax--array{\n    color:@green;\n  }\n  .syntax--constant.syntax--numeric{\n    color:@magenta;\n  }\n  .syntax--constant.syntax--other{\n    color:@orange;\n  }\n  .syntax--storage.syntax--type{\n    color:@green;\n  }\n  .syntax--meta.syntax--method-call{\n    //@ibocon: method parameter's color\n    color:@red;\n    //@ibocon: method and variable use different hightlight\n    .syntax--meta.syntax--method{\n      color:@violet;\n    }\n    .syntax--punctuation.syntax--definition.syntax--seperator.syntax--parameter{\n      color:@green;\n    }\n  }\n  .syntax--punctuation.syntax--definition.syntax--method-parameters{\n    color: @syntax-emphasized-color;\n  }\n}\n",digest:"7ed0d0331bfcc2ca5bfa85dddaa51e547df18593"},"node_modules/solarized-light-syntax/styles/syntax/javascript.less":{content:".syntax--source.syntax--js {\n  .syntax--comma {\n    color: @syntax-text-color;\n  }\n\n  .syntax--support.syntax--class {\n    color: @green;\n  }\n\n  .syntax--entity {\n    &.syntax--name.syntax--type {\n      color: @yellow;\n    }\n    &.syntax--name {\n      color: @syntax-text-color;\n\n      &.syntax--function {\n        color: @blue;\n      }\n    }\n\n    &.syntax--name.syntax--tag {\n      color: @blue;\n    }\n\n    &.syntax--other.syntax--attribute-name {\n      color: @yellow;\n    }\n  }\n\n\n  .syntax--meta.syntax--brace {\n    color: @syntax-text-color;\n  }\n\n  .syntax--keyword {\n    color: @syntax-text-color;\n  }\n  .syntax--keyword.syntax--operator.syntax--new {\n    color: @green;\n  }\n  .syntax--keyword.syntax--control {\n    color: @orange;\n  }\n  .syntax--keyword.syntax--control.syntax--regexp {\n    color: @cyan;\n  }\n\n  .syntax--variable {\n    color: @syntax-text-color;\n  }\n  .syntax--variable.syntax--dom {\n    color: @green;\n  }\n  .syntax--delimiter + .syntax--dom {\n    color: @syntax-text-color;\n  }\n  .syntax--name {\n    color: @syntax-text-color;\n  }\n  .syntax--variable.syntax--language {\n    color: @blue;\n  }\n  .syntax--variable.syntax--parameter {\n    color: @syntax-text-color;\n  }\n\n  .syntax--regexp {\n    color: @cyan;\n  }\n\n  .syntax--support.syntax--function {\n    color: @syntax-text-color;\n  }\n  .syntax--support.syntax--constant {\n    color: @syntax-text-color;\n  }\n\n  .syntax--storage.syntax--modifier {\n    color: @yellow;\n  }\n\n  .syntax--punctuation.syntax--terminator.syntax--statement {\n    color: @syntax-text-color;\n  }\n\n  .syntax--meta.syntax--delimiter.syntax--method.syntax--period {\n    color: @syntax-text-color;\n  }\n  .syntax--meta.syntax--brace.syntax--square {\n    color: @blue;\n  }\n  .syntax--meta.syntax--brace.syntax--curly {\n    color: @blue;\n  }\n\n  .syntax--string.syntax--quoted.syntax--template {\n    .syntax--embedded.syntax--source {\n      color: @syntax-text-color;\n      & > .syntax--embedded.syntax--punctuation {\n        color: @red;\n      }\n    }\n  }\n\n  &.syntax--embedded .syntax--entity.syntax--name.syntax--tag {\n    color: @blue;\n  }\n\n  .syntax--import {\n    .syntax--control {\n      color: @orange;\n    }\n  }\n}\n\n\n// JavaScript (Rails) language-ruby-on-rails\n\n.syntax--source.syntax--js.syntax--rails {\n  .syntax--instance {\n    color: @blue;\n  }\n\n  .syntax--class {\n    color: @yellow;\n  }\n}\n",digest:"3b220e65fa7ff3879253e24a945f650886a7982b"},"node_modules/solarized-light-syntax/styles/syntax/markdown.less":{content:".syntax--md,\n.syntax--gfm {\n  .syntax--link .syntax--entity {\n    color: @violet;\n  }\n\n  .syntax--list {\n    &.syntax--ordered {\n      color: @green;\n    }\n    &.syntax--unordered {\n      color: @yellow;\n    }\n  }\n\n  .syntax--raw {\n    font-style: italic;\n  }\n\n  &.syntax--support {\n    color:@syntax-comment-color;\n    &.syntax--quote {\n      color: @violet;\n    }\n  }\n}\n",digest:"817fda2f1b1a953d3a15483fe3ce3cfd00eb1d15"},"node_modules/solarized-light-syntax/styles/syntax/markup.less":{content:".syntax--markup {\n\n  &.syntax--bold {\n    font-weight: bold;\n  }\n  &.syntax--italic {\n    font-style: italic;\n  }\n\n  &.syntax--heading {\n    color: @blue;\n  }\n\n  &.syntax--link {\n    color: @cyan;\n  }\n\n  &.syntax--deleted {\n    color: @red;\n  }\n\n  &.syntax--changed {\n    color: @yellow;\n  }\n\n  &.syntax--inserted {\n    color: @cyan;\n  }\n\n}\n",digest:"2b1893b8d2de8d42b582efbd90608833a8e26fdc"},"node_modules/solarized-light-syntax/styles/syntax/php.less":{content:".syntax--source.syntax--php {\n  .syntax--storage {\n    &.syntax--type {\n      &.syntax--class {\n        color: @yellow;\n      }\n      &.syntax--function {\n        color: @orange;\n      }\n    }\n    &.syntax--modifier {\n      color: @yellow;\n    }\n  }\n  .syntax--entity {\n    &.syntax--name {\n      &.syntax--type.syntax--class {\n        color: @syntax-text-color;\n      }\n      &.syntax--function {\n        color: @syntax-text-color;\n      }\n    }\n    &.syntax--other {\n      color: @syntax-text-color;\n    }\n  }\n  .syntax--variable {\n    color: @blue;\n  }\n  .syntax--punctuation.syntax--definition {\n    color: @syntax-text-color;\n    &.syntax--comment {\n      color: @syntax-comment-color;\n    }\n    &.syntax--array {\n      color: @red;\n    }\n    &.syntax--string {\n      color: @syntax-text-color;\n    }\n    &.syntax--variable {\n      color: @green;\n    }\n  }\n  .syntax--support.syntax--function {\n    &.syntax--construct {\n      color: @yellow;\n    }\n    &.syntax--array {\n      color: @green;\n    }\n  }\n  .syntax--keyword {\n    &.syntax--operator {\n      &.syntax--class {\n        color: @yellow;\n      }\n      &.syntax--assignment {\n        color: @green;\n      }\n    }\n    &.syntax--other {\n      color: @red;\n    }\n  }\n}\n",digest:"4c57fce11fabe63d59d4e0d964477d7a54ee8f83"},"node_modules/solarized-light-syntax/styles/syntax/python.less":{content:".syntax--source.syntax--python {\n  .syntax--entity {\n    color: @syntax-text-color;\n\n    &.syntax--name {\n      color: @blue;\n    }\n    &.syntax--other {\n      color: @blue;\n    }\n  }\n\n  .syntax--function {\n    color: @blue;\n\n    &.syntax--magic {\n      color: @blue;\n    }\n  }\n\n  .syntax--punctuation.syntax--string {\n    color: @cyan;\n  }\n  .syntax--keyword {\n    &.syntax--operator {\n      color: @syntax-text-color;\n      &.syntax--quantifier {\n        color: @cyan;\n      }\n      &.syntax--logical {\n        color: @green;\n      }\n    }\n    &.syntax--control.syntax--import {\n      color: @orange;\n    }\n    &.syntax--other {\n      color: @green;\n    }\n  }\n  .syntax--constant {\n    &.syntax--language {\n      color: @blue;\n    }\n    &.syntax--character {\n      color: @cyan;\n    }\n    &.syntax--other {\n      color: @red;\n    }\n  }\n\n  .syntax--entity.syntax--name.syntax--type.syntax--class {\n    color: @blue;\n  }\n  .syntax--variable {\n    color: @syntax-text-color;\n  }\n  .syntax--support {\n    &.syntax--function.syntax--builtin {\n      color: @blue;\n    }\n    &.syntax--type {\n      &.syntax--exception.syntax--python {\n        color: @yellow;\n      }\n      &.syntax--python {\n        color: @blue;\n      }\n    }\n  }\n  .syntax--storage.syntax--type.syntax--string {\n    color: @cyan;\n  }\n\n  .syntax--storage.syntax--type.syntax--class {\n    color: @green;\n    &.syntax--todo {\n      color: @magenta;\n    }\n  }\n\n  .syntax--storage.syntax--type.syntax--function {\n    color: @green;\n  }\n\n  .syntax--punctuation.syntax--definition.syntax--parameters {\n    color: @syntax-text-color;\n  }\n\n  .syntax--punctuation.syntax--section.syntax--function.syntax--begin {\n    color: @syntax-text-color;\n  }\n\n  .syntax--punctuation.syntax--separator.syntax--parameters {\n    color: @syntax-text-color;\n  }\n\n\n}\n",digest:"33190f5b629f061f135b7bbd8be544b6c06ed4f8"},"node_modules/solarized-light-syntax/styles/syntax/ruby.less":{content:".syntax--source.syntax--ruby {\n\n  .syntax--meta.syntax--embedded {\n    .syntax--punctuation.syntax--section {\n      color: @red;\n    }\n  }\n  .syntax--punctuation.syntax--definition {\n    color: @syntax-text-color;\n    &.syntax--string {\n      color: @red;\n    }\n  }\n  .syntax--punctuation.syntax--definition.syntax--comment {\n    color: @syntax-comment-color;\n  }\n  .syntax--entity.syntax--inherited-class {\n    color: @yellow;\n  }\n  .syntax--variable {\n    &.syntax--parameter {\n      color: @syntax-text-color;\n    }\n  }\n  .syntax--variable.syntax--constant {\n    color: @yellow;\n  }\n  .syntax--constant.syntax--boolean {\n    color: @cyan;\n  }\n  .syntax--instance {\n    .syntax--punctuation.syntax--definition {\n      color: @blue;\n    }\n  }\n  .syntax--class {\n    color: @yellow;\n    &.syntax--control {\n      color: @syntax-text-color;\n    }\n  }\n  .syntax--module {\n    color: @yellow;\n  }\n  .syntax--require {\n    .syntax--keyword.syntax--other.syntax--special-method {\n      color: @orange;\n    }\n  }\n  .syntax--keyword.syntax--other.syntax--special-method {\n    color: @orange;\n  }\n  .syntax--keyword.syntax--other {\n    color: @green;\n  }\n  .syntax--keyword.syntax--control {\n    color: @green;\n  }\n  .syntax--keyword.syntax--operator {\n    color: @syntax-text-color;\n  }\n  .syntax--special-method {\n    color: @blue;\n  }\n  .syntax--symbol {\n    color: @cyan;\n    .syntax--punctuation.syntax--definition {\n      color: @cyan;\n    }\n  }\n  .syntax--hashkey {\n    color: @red;\n    .syntax--punctuation.syntax--definition {\n      color: @red;\n    }\n  }\n  .syntax--string.syntax--regexp {\n    color: @red;\n  }\n  .syntax--todo {\n    color: @magenta;\n  }\n  .syntax--variable.syntax--ruby.syntax--global {\n    color: @blue;\n    .syntax--punctuation {\n      color: @blue;\n    }\n  }\n  .syntax--variable.syntax--block {\n    color: @blue;\n  }\n  .syntax--variable.syntax--self {\n    color: @cyan;\n  }\n  .syntax--punctuation.syntax--separator {\n    color: @syntax-text-color;\n  }\n  .syntax--numeric {\n    color: @cyan;\n  }\n  .syntax--punctuation.syntax--section.syntax--regexp {\n    color: @red;\n  }\n  .syntax--string.syntax--interpolated {\n    color: @cyan;\n  }\n  .syntax--string.syntax--interpolated {\n    .syntax--embedded.syntax--line.syntax--ruby {\n      .syntax--punctuation {\n        .syntax--source.syntax--ruby {\n          color: @red;\n        }\n      }\n      .syntax--source.syntax--ruby {\n        .syntax--punctuation.syntax--array,\n        .syntax--punctuation.syntax--function {\n          color: @syntax-text-color;\n        }\n        color: @syntax-text-color;\n      }\n    }\n  }\n  .syntax--support.syntax--function {\n    color: @syntax-text-color;\n  }\n  .syntax--support.syntax--function.syntax--kernel {\n    color: @green;\n  }\n}\n",digest:"cfe9b7caebcae391298920cc1ad3ed4f945a1219"},"node_modules/solarized-light-syntax/styles/syntax/scala.less":{content:".syntax--source.syntax--scala {\n  .syntax--variable {\n    color: @syntax-emphasized-color;\n  }\n\n  .syntax--declaration {\n    color: @syntax-emphasized-color;\n    font-weight: bold;\n  }\n  .syntax--comparison {\n    color: @syntax-emphasized-color;\n  }\n  .syntax--class, .syntax--type {\n    color: @yellow;\n  }\n  .syntax--val {\n    font-weight: normal;\n  }\n  .syntax--variable {\n    font-weight: bold;\n  }\n  .syntax--variable.syntax--parameter {\n    color: @violet;\n    font-weight: normal;\n  }\n  .syntax--control.syntax--flow {\n    color: @syntax-emphasized-color;\n    font-weight: bold;\n  }\n  .syntax--constant.syntax--language {\n    color: @syntax-emphasized-color;\n    font-weight: bold;\n  }\n  .syntax--function.syntax--declaration {\n    color: @violet;\n  }\n  .syntax--modifier.syntax--other {\n    font-weight: bold;\n  }\n  .syntax--package {\n    color: @syntax-emphasized-color;\n  }\n  .syntax--variable.syntax--import {\n    font-weight: normal;\n  }\n\n  .syntax--type {\n    .syntax--bounds, .syntax--class {\n      color: @violet;\n    }\n  }\n\n  .syntax--documentation {\n    :not(.syntax--embedded) {\n      // out of scope ?\n      // https://github.syntax--com/atom/link\n      &.syntax--link.syntax--entity {\n        color: @blue;\n        text-decoration: underline;\n      }\n      .syntax--class, .syntax--parameter {\n        color: @syntax-emphasized-color;\n      }\n      .syntax--description {\n        color: @syntax-comment-color;\n      }\n    }\n  }\n\n  .syntax--embedded {\n    color: darken(@syntax-emphasized-color, 15%);\n\n    // so we dont confused it with normal expressions\n    font-style: italic;\n    .syntax--margin, .syntax--delimiters {\n      font-style: normal;\n    }\n  }\n}\n",digest:"6edaa134daab31cecf6827ac74b9ee9653d42dab"},"node_modules/solarized-light-syntax/styles/syntax/typescript.less":{content:".syntax--source.syntax--ts,\n.syntax--source.syntax--tsx {\n  .syntax--import {\n    .syntax--control {\n      color: @orange;\n    }\n  }\n\n  .syntax--entity {\n    &.syntax--name.syntax--type {\n      color: @yellow;\n    }\n\n    &.syntax--inherited-class {\n      color: @yellow;\n    }\n  }\n\n  .syntax--support.syntax--type {\n    color: @yellow;\n  }\n}\n",digest:"f46a840d6945c5187b0cb9e799b732b7cae28b22"},"node_modules/atom-light-ui/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// Atom Light UI theme\n\n@import "styles/ui-variables.less";\n@import "styles/ui-mixins.less";\n\n@import "styles/atom.less";\n@import "styles/utilities.less";\n@import "styles/text.less";\n@import "styles/git.less";\n@import "styles/sites.less";\n@import "styles/messages.less";\n@import "styles/progress.less";\n@import "styles/buttons.less";\n@import "styles/panels.less";\n@import "styles/panes.less";\n@import "styles/lists.less";\n@import "styles/overlays.less";\n@import "styles/editor.less";\n@import "styles/tabs.less";\n@import "styles/tooltips.less";\n@import "styles/tree-view.less";\n',digest:"9bea9c4a44b3f35bd1d76f3f933f8805f26c8127"},"node_modules/atom-light-ui/styles/atom.less":{content:"atom-workspace {\n  background-color: @app-background-color;\n}\n\n.scrollbars-visible-always {\n  ::-webkit-scrollbar {\n    width: 10px;\n    height: 10px;\n  }\n\n  ::-webkit-scrollbar-track,\n  ::-webkit-scrollbar-corner {\n    background: @scrollbar-background-color;\n  }\n\n  ::-webkit-scrollbar-thumb {\n    background: @scrollbar-color;\n    border-radius: 5px;\n\t\tbox-shadow: 0 0 1px white inset;\n  }\n}\n",digest:"8932718eb2bfebd5a7768786ed6b56967fe94194"},"node_modules/atom-light-ui/styles/buttons.less":{content:".btn-background (@color, @hover-color, @selected-color, @border-color, @text-color, @text-color-hover) {\n  @border-shadow: inset 0 0 0 1px @border-color;\n  @active-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);\n  color: @text-color;\n  background-color: transparent;\n  background-image: -webkit-linear-gradient(@color, darken(@color, 8%));\n  box-shadow: @border-shadow;\n\n  &:hover {\n    color: @text-color-hover;\n    background-image: -webkit-linear-gradient(@hover-color, darken(@hover-color, 8%));\n  }\n  &:active,\n  &.selected:hover:active {\n    box-shadow: @active-shadow, @border-shadow;\n  }\n  &.selected,\n  &.selected:hover {\n    color: @text-color-selected;\n    box-shadow: inset 0 2px 5px rgba(0, 0, 0,.3), @border-shadow;\n    text-shadow: 0 0 2px rgba(0, 0, 0, 0.3);\n    background-image: -webkit-linear-gradient(darken(@selected-color, 8%), @selected-color);\n  }\n  &.selected:hover {\n    box-shadow: @border-shadow;\n    background-image: -webkit-linear-gradient(@selected-color, darken(@selected-color, 8%));\n  }\n}\n\n.btn-variant (@color) {\n  @bg: darken(@color, 10%);\n  @hover: @color;\n  @selected: @color;\n  @border: fadeout(darken(@color, 20%), 50%);\n  .btn-background(@bg, @hover, @selected, @border, @text-color-selected, @text-color-selected);\n}\n\n.btn {\n  .btn-background(@button-background-color, @button-background-color-hover, @button-background-color-selected, @button-border-color, @text-color, @text-color-highlight);\n}\n\n.btn.btn-primary {\n  .btn-variant(@background-color-info);\n}\n.btn.btn-info {\n  .btn-variant(@background-color-info);\n}\n.btn.btn-success {\n  .btn-variant(@background-color-success);\n}\n.btn.btn-warning {\n  .btn-variant(@background-color-warning);\n}\n.btn.btn-error {\n  .btn-variant(@background-color-error);\n}\n\n.btn-group > .btn {\n  border: none;\n}\n",digest:"9f67ab7666545195f62ad080053100c9f8e9e441"},"node_modules/atom-light-ui/styles/editor.less":{content:"atom-text-editor[mini] {\n  color: lighten(@text-color, 15%);\n  background-color: darken(@input-background-color, 1%);\n  border: 1px solid lighten(@input-border-color, 10%);\n\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);\n  border-radius: @component-border-radius;\n  padding-left: @component-padding/2;\n\n  .cursor { border-color: #000; }\n  .selection .region { background-color: rgba(0, 0, 0, .2); }\n  .placeholder-text {\n    color: lighten(@text-color-subtle, 10%);\n  }\n}\n\natom-text-editor[mini].is-focused {\n  color: @text-color;\n  background-color: @input-background-color;\n  border-color: @input-border-color;\n  .placeholder-text {\n    color: @text-color-subtle;\n  }\n  .selection .region {\n    background-color: lighten(@background-color-info, 30%);\n  }\n}\n\n// FIXME: these should go in syntax themes?\natom-text-editor {\n  .gutter.drop-shadow {\n    -webkit-box-shadow: -2px 0 10px 2px #222;\n  }\n}\n",digest:"ed971b95247ff1b65a084449240dd513f02a188a"},"node_modules/atom-light-ui/styles/git.less":{content:".status { .text(normal); }\n.status-added { .text(success); }\n.status-ignored { .text(subtle); }\n.status-modified { .text(warning); }\n.status-removed { .text(error); }\n.status-renamed { .text(info); }\n",digest:"44ecb1b340050a9a3e0cc05d8287a9749a6def83"},"node_modules/atom-light-ui/styles/lists.less":{content:"@import \"octicon-mixins.less\"; // https://github.com/atom/atom/blob/master/static/variables/octicon-mixins.less\n\n.list-group, .list-tree {\n  li:not(.list-nested-item),\n  li.list-nested-item > .list-item {\n    .text(normal);\n  }\n\n  .generate-list-item-text-color(@class) {\n    li:not(.list-nested-item).text-@{class},\n    li.list-nested-item.text-@{class} > .list-item {\n      .text(@class);\n    }\n  }\n  .generate-list-item-text-color(subtle);\n  .generate-list-item-text-color(info);\n  .generate-list-item-text-color(success);\n  .generate-list-item-text-color(warning);\n  .generate-list-item-text-color(error);\n  .generate-list-item-text-color(selected);\n\n  .generate-list-item-status-color(@color, @status) {\n    li:not(.list-nested-item).status-@{status},\n    li.list-nested-item.status-@{status} > .list-item {\n      color: @color;\n    }\n\n    li:not(.list-nested-item).selected.status-@{status},\n    li.list-nested-item.selected.status-@{status} > .list-item {\n      color: darken(@color, 7%);\n    }\n  }\n  .generate-list-item-status-color(@text-color-subtle, ignored);\n  .generate-list-item-status-color(@text-color-added, added);\n  .generate-list-item-status-color(@text-color-renamed, renamed);\n  .generate-list-item-status-color(@text-color-modified, modified);\n  .generate-list-item-status-color(@text-color-removed, removed);\n\n  li:not(.list-nested-item).selected,\n  li.list-nested-item.selected > .list-item {\n    .text(selected);\n  }\n}\n\n.select-list ol.list-group,\n&.select-list ol.list-group {\n  li.two-lines {\n    .secondary-line { color: @text-color-subtle; }\n    &.selected .secondary-line {\n      color: lighten(@text-color-subtle, 10%);\n      text-shadow: none;\n    }\n  }\n\n  // We want to highlight the background of the list items because we dont\n  // know their size.\n  li.selected {\n    background-color: @background-color-selected;\n    &:before{ display: none; }\n  }\n\n  &.mark-active{\n    @active-icon-size: 14px;\n\n    // pad in front of the text where the icon would be We'll pad the non-\n    // active items with a 'fake' icon so other classes can pad the item\n    // without worrying about the icon padding.\n    li:before {\n      content: '';\n      background-color: transparent;\n      position: static;\n      display: inline-block;\n      left: auto; right: auto;\n      height: @active-icon-size;\n      width: @active-icon-size;\n    }\n    > li:not(.active):before {\n      margin-right: @component-icon-padding;\n    }\n    li.active {\n      .octicon(check, @active-icon-size);\n      &:before {\n        margin-right: @component-icon-padding;\n        color: @text-color-success;\n      }\n    }\n  }\n}\n\n.select-list.popover-list {\n  background-color: @overlay-background-color;\n  box-shadow: 0 0 10px @base-border-color;\n  padding: @component-padding/2;\n  border-radius: @component-border-radius;\n  border: 1px solid @overlay-border-color;\n\n  atom-text-editor {\n    margin-bottom: @component-padding/2;\n  }\n\n  .list-group li {\n    padding-left: @component-padding/2;\n  }\n}\n\n.ui-sortable {\n  li {\n    line-height: 2.5;\n  }\n\n  // For sortable lists in the settings view\n  li.ui-sortable-placeholder {\n    visibility: visible !important;\n    background-color: darken(@pane-item-background-color, 10%);\n  }\n}\n\nli.ui-draggable-dragging, li.ui-sortable-helper {\n  line-height: @component-line-height;\n  height: @component-line-height;\n  border: 0;\n  border-radius: 0;\n  list-style: none;\n  padding: 0 @component-padding;\n  background: @background-color-highlight;\n  box-shadow: 0 0 1px @base-border-color;\n}\n",digest:"e958ff9295785739e4121b51011c98a5b37b2259"},"node_modules/atom-light-ui/styles/messages.less":{content:"ul.background-message {\n  font-weight: bold;\n  color: rgba(0, 0, 0, .18);\n}\n",digest:"2b494a6d26831dd545609498c3d7e2c651d355e4"},"node_modules/atom-light-ui/styles/overlays.less":{content:"atom-panel.modal, .overlay {\n  color: @text-color;\n  background-color: @overlay-background-color;\n  padding: @component-padding;\n  border: 1px solid @overlay-border-color;\n  box-shadow: 0 0 10px @base-border-color;\n  border-radius: @component-border-radius;\n\n  atom-text-editor[mini] {\n    margin-bottom: @component-padding;\n  }\n\n  .select-list ol.list-group,\n  &.select-list ol.list-group {\n\n    background-color: @inset-panel-background-color;\n\n    li {\n      padding: @component-padding;\n      border-top: 1px solid @inset-panel-border-color;\n      border-left: 1px solid @inset-panel-border-color;\n      border-right: 1px solid @inset-panel-border-color;\n      &:last-child { border-bottom: 1px solid @inset-panel-border-color; }\n\n      &.two-lines { padding: @component-padding/2 @component-padding; }\n      &.selected {\n        color: @text-color;\n        background-color: @background-color-highlight;\n      }\n\n      .status.icon {\n        float: right;\n        margin-left: @component-icon-padding;\n        &:before {\n          margin-right: 0;\n        }\n      }\n    }\n\n  }\n}\n",digest:"59b18b926d5b6a1ef9e6e5bb9f9acb08e004c199"},"node_modules/atom-light-ui/styles/panels.less":{content:'@import "buttons.less";\n\n.panel {\n  &.bordered {\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n  }\n}\n\natom-panel, .tool-panel {\n  .text(normal);\n  position: relative;\n\n  background-color: @tool-panel-background-color;\n\n  &.bottom, &.panel-bottom,\n  &.footer, &.footer-bottom {\n    border-top: 1px solid @tool-panel-border-color;\n  }\n\n  &.left, &.panel-left {\n    border-right: 1px solid @tool-panel-border-color;\n  }\n\n  &.right, &.panel-right {\n    border-left: 1px solid @tool-panel-border-color;\n  }\n\n  .inset-panel {\n    border-radius: @component-border-radius;\n\n    border: 1px solid @tool-panel-border-color;\n  }\n}\n\n.inset-panel {\n  position: relative;\n  background-color: @inset-panel-background-color;\n}\n\n.panel-heading {\n  border-bottom: none;\n  padding: @component-padding - 2px @component-padding;\n\n  background-color: transparent;\n  background-image: -webkit-linear-gradient(@panel-heading-background-color, darken(@panel-heading-background-color, 10%));\n\n  .btn {\n    @bg: lighten(@button-background-color, 10%);\n    @hover: lighten(@button-background-color-hover, 10%);\n    @selected: lighten(@button-background-color-selected, 10%);\n    @text: lighten(@text-color, 10%);\n    .btn-background(@bg, @hover, @selected, @button-border-color, @text, @text);\n  }\n}\n',digest:"94e5455f1c376513e5d4d49d1415aeaa22404949"},"node_modules/atom-light-ui/styles/panes.less":{content:"atom-pane-container {\n  atom-pane {\n    background-color: lighten(@app-background-color, 3%);\n\n    &:focus {\n      background-color: @app-background-color;\n    }\n  }\n\n  atom-pane-axis.horizontal > * {\n    border-right: 1px solid @pane-item-border-color;\n    &:last-child { border-right: none; }\n  }\n\n  atom-pane-axis.vertical > * {\n    border-bottom: 1px solid @pane-item-border-color;\n    &:last-child { border-bottom: none; }\n  }\n}\n",digest:"607ed7318d571a7f443154d0e4061dea82cfa235"},"node_modules/atom-light-ui/styles/progress.less":{content:".loading-spinner(@size) {\n  width: @size;\n  height: @size;\n  display: block;\n\n  background-image: url(images/octocat-spinner-128.gif);\n  background-repeat: no-repeat;\n  background-size: cover;\n\n  &.inline-block {\n    display: inline-block;\n  }\n}\n\n.loading-spinner-large {\n  .loading-spinner(64px);\n}\n\n.loading-spinner-medium {\n  .loading-spinner(50px);\n}\n\n.loading-spinner-small {\n  .loading-spinner(32px);\n}\n\n.loading-spinner-tiny {\n  .loading-spinner(20px);\n}\n\n// Much learning from:\n// http://css-tricks.com/html5-progress-element/\n\n@progress-height: 16px;\n@progress-shine-gradient: -webkit-linear-gradient(top, rgba(255, 255, 255, .15), rgba(0, 0, 0, .15));\n\nprogress {\n  height: @progress-height;\n  -webkit-appearance: none;\n  border-radius: @component-border-radius;\n  background-color: #ccc;\n  background-image:\n     -webkit-linear-gradient(-30deg,\n                             transparent 33%, rgba(0, 0, 0, .1) 33%,\n                             rgba(0,0, 0, .1) 66%, transparent 66%),\n                             @progress-shine-gradient;\n  border-radius: 2px;\n  background-size: 25px @progress-height, 100% 100%, 100% 100%;\n  -webkit-animation: animate-stripes 5s linear 6; // stop animation after 6 runs (30s) to limit CPU usage\n}\n\nprogress::-webkit-progress-bar {\n  background-color: transparent;\n}\n\nprogress::-webkit-progress-value {\n  border-radius: @component-border-radius;\n  background-image: @progress-shine-gradient;\n  background-color: @background-color-info;\n}\n\nprogress[value] {\n  background-image: @progress-shine-gradient;\n  -webkit-animation: none;\n}\n\n@-webkit-keyframes animate-stripes {\n   100% { background-position: 100px 0px; }\n}\n",digest:"48c9480e0a0dd9beb78807235627e036ef8fff39"},"node_modules/atom-light-ui/styles/sites.less":{content:".ui-site(@num, @color) {\n  .ui-site-@{num} {\n    background-color: @color;\n  }\n}\n\n.ui-site(1, @ui-site-color-1);\n.ui-site(2, @ui-site-color-2);\n.ui-site(3, @ui-site-color-3);\n.ui-site(4, @ui-site-color-4);\n.ui-site(5, @ui-site-color-5);\n",digest:"0c4862fe989b8170bace51c17b9dd6201062ca62"},"node_modules/atom-light-ui/styles/tabs.less":{content:"@tab-radius: 3px;\n@modified-icon-width: 8px;\n@tab-skew: 30deg;\n@tab-top-padding: 5px;\n@tab-bottom-border-height: 5px;\n@tab-border: 1px solid @tab-border-color;\n@tab-bar-bottom-border-color: @tab-border-color;\n@tab-max-width: 160px;\n\n.tab-bar {\n  height: @tab-height + @tab-top-padding + @tab-bottom-border-height;\n  background-image: -webkit-linear-gradient(top, @tab-bar-background-color, lighten(@tab-bar-background-color, 9%));\n  box-shadow: inset 0 -8px 8px -4px rgba(0,0,0, .15);\n  padding: 0 10px 0 25px;\n  overflow-x: auto;\n  overflow-y: hidden;\n\n  &::-webkit-scrollbar {\n    display: none;\n  }\n\n  .tab {\n    position: relative;\n    top: @tab-top-padding;\n    max-width: @tab-max-width;\n    height: @tab-height;\n    line-height: @tab-height;\n    color: @text-color;\n    padding: 0;\n    margin: 0 20px 0 5px;\n\n    box-shadow: inset -1px -1px 1px rgba(0,0,0, .05);\n    transition: color .1s ease-in;\n\n    &, &:before, &:after {\n      background-image: -webkit-linear-gradient(top, @tab-background-color, darken(@tab-background-color, 6%));\n      border-top: @tab-border;\n    }\n\n    &:before, &:after {\n      content: '';\n      position: absolute;\n      top: -1px;\n      width: 25px;\n      height: @tab-height;\n    }\n\n    // left angled edge\n    &:before {\n      left: -14px;\n      border-top-left-radius: @tab-radius;\n      border-left: @tab-border;\n      box-shadow: inset 1px -1px 1px rgba(0,0,0, .05);\n      -webkit-transform: skewX(-@tab-skew);\n    }\n\n    // right angled edge\n    &:after {\n      right: -14px;\n      border-top-right-radius: @tab-radius;\n      border-right: @tab-border;\n      box-shadow: inset -1px -1px 1px rgba(0,0,0, .05);\n      -webkit-transform: skewX(@tab-skew);\n    }\n\n    .close-icon {\n      right: 0;\n      z-index: 3;\n      text-align: right;\n      line-height: @tab-height;\n      color: @text-color;\n\n      &:hover {\n        color: inherit;\n      }\n    }\n\n    &.modified:not(:hover) .close-icon {\n      right: 0;\n      top: @tab-height/2 - @modified-icon-width/2 + 1px;\n      width: @modified-icon-width;\n      height: @modified-icon-width;\n    }\n\n    &.modified:hover .close-icon:hover {\n      color: @text-color-highlight;\n    }\n\n    .title {\n      position: relative;\n      z-index: 1;\n      margin-top: -@tab-top-padding - 1px;\n      padding-top: @tab-top-padding + 1px;\n      padding-right: 10px;\n    }\n  }\n\n  .tab.active {\n    z-index: 1;\n    color: @text-color-highlight;\n\n    .close-icon {\n      line-height: @tab-height - 1px;\n      color: @text-color;\n    }\n\n    &, &:before, &:after {\n      background: @tab-background-color-active;\n      height: @tab-height + 1px;\n      box-shadow: none;\n    }\n  }\n\n  .tab:hover {\n    color: @text-color-highlight;\n  }\n\n  .tab.active:hover .close-icon {\n    color: @text-color;\n\n    &:hover {\n      color: inherit;\n    }\n  }\n\n  .placeholder {\n    height: @tab-height + @tab-top-padding + @tab-bottom-border-height;\n    pointer-events: none;\n    &:before {\n      margin-left: -9px; // center between tabs\n    }\n    &:after {\n      top: @tab-height + @tab-top-padding + @tab-bottom-border-height - 2px;\n      margin-left: -10px; // center between tabs\n    }\n  }\n}\n\n// border\n.tab-bar + .item-views::before {\n  content: \"\";\n  position: absolute;\n  top: -5px;\n  height: @tab-bottom-border-height;\n  left: 0;\n  right: 0;\n  background-color: @tab-background-color-active;\n  border-top: 1px solid @tab-border-color;\n  border-bottom: 1px solid @tab-bar-bottom-border-color;\n  pointer-events: none;\n}\n",digest:"8deb28bd2f813d17d45715fbe9872aa1add61459"},"node_modules/atom-light-ui/styles/text.less":{content:"h1,\nh2,\nh3 {\n  line-height: 1em;\n  margin-bottom: 15px\n}\nh1 { font-size: 2em; }\nh2 { font-size: 1.5em; }\nh3 { font-size: 1.2em; }\n\np {\n  line-height: 1.6;\n  margin-bottom: 15px;\n}\n\nlabel {\n  font-weight: normal;\n}\n\npre {\n  box-shadow: none;\n  color: @text-color;\n  background: @inset-panel-background-color;\n  border-radius: @component-border-radius;\n  border: none;\n  margin: 0;\n}\n\ncode {\n  .text(highlight);\n  background: @background-color-highlight;\n  border-radius: @component-border-radius;\n}\n\n.selected { .text(highlight); }\n\n.text-smaller { font-size: 0.9em; }\n\n.text-subtle { .text(subtle); }\n.text-highlight { .text(highlight); }\n\n.text-error { .text(error); }\n.text-info {\n  .text(info);\n  &:hover { color: @text-color-info; }\n}\n.text-warning {\n  .text(warning);\n  &:hover { color: @text-color-warning; }\n}\n.text-success {\n  .text(success);\n  &:hover { color: @text-color-success; }\n}\n\n.highlight {\n  color: @text-color-highlight;\n  font-weight: bold;\n  text-shadow: none;\n  background-color: @background-color-highlight;\n  border-radius: @component-border-radius;\n  padding: 1px 3px;\n}\n\n.highlight-color(@name, @color) {\n  .highlight-@{name} {\n    color: @text-color-highlight;\n    font-weight: bold;\n    text-shadow: none;\n    background-color: @color;\n    border-radius: @component-border-radius;\n    padding: 1px 3px;\n  }\n}\n.highlight-color(info, @background-color-info);\n.highlight-color(warning, @background-color-warning);\n.highlight-color(error, @background-color-error);\n.highlight-color(success, @background-color-success);\n",digest:"299d82ccf27c783c74d48aa22fcf3b772d4b364f"},"node_modules/atom-light-ui/styles/tooltips.less":{content:".tooltip {\n  @tip-background-color: #333;\n  @tip-text-color: #fff;\n  white-space: nowrap;\n\n  .keystroke {\n    font-family: Helvetica, Arial, sans-serif;\n    font-size: 13px;\n    color: #c0c0c0;\n    padding-left: 2px;\n  }\n\n  &.in { opacity: 1; }\n\n  .tooltip-inner {\n    line-height: 19px;\n    border-radius: @component-border-radius;\n    background-color: @tip-background-color;\n    color: @tip-text-color;\n    white-space: nowrap;\n    max-width: none;\n  }\n\n  &.top .tooltip-arrow {\n    border-top-color: @tip-background-color;\n  }\n  &.top-left .tooltip-arrow {\n    border-top-color: @tip-background-color;\n  }\n  &.top-right .tooltip-arrow {\n    border-top-color: @tip-background-color;\n  }\n  &.right .tooltip-arrow {\n    border-right-color: @tip-background-color;\n  }\n  &.left .tooltip-arrow {\n    border-left-color: @tip-background-color;\n  }\n  &.bottom .tooltip-arrow {\n    border-bottom-color: @tip-background-color;\n  }\n  &.bottom-left .tooltip-arrow {\n    border-bottom-color: @tip-background-color;\n  }\n  &.bottom-right .tooltip-arrow {\n    border-bottom-color: @tip-background-color;\n  }\n}\n",digest:"f0c12def1d8c3519d6f1ec9393abefaa470934c8"},"node_modules/atom-light-ui/styles/tree-view.less":{content:".tree-view {\n\tfont-size: @font-size;\n\tbackground: @tree-view-background-color;\n\n\t.selected:before {\n\t\tbackground: #d0d0d0;\n\t}\n}\n\n.tree-view-resizer {\n\t.tree-view-resize-handle {\n\t\twidth: 8px;\n\t}\n}\n\n.focusable-panel {\n\topacity: 1;\n\tbackground-image: -webkit-gradient(linear, left top, left bottom, from(#e8ecf1), to(#ebebeb));\n\tbackground-image: -webkit-linear-gradient(top, #e8ecf1, #ebebeb);\n\n\t&:focus {\n\t\tbackground-image: -webkit-gradient(linear, left top, left bottom, from(#e8ecf1),to(#d1d8e0));\n\t\tbackground-image: -webkit-linear-gradient(top, #e8ecf1, #d1d8e0);\n\n\t\t.selected:before {\n\t\t\tbackground: @background-color-selected;\n\t\t}\n\t}\n}\n",digest:"a301e6fdca60adedb1fa14525f0b54323bd65ba6"},"node_modules/atom-light-ui/styles/ui-mixins.less":{content:"// Pattern matching; ish is cray.\n// http://lesscss.org/#-pattern-matching-and-guard-expressions\n.text(normal) {\n  font-weight: normal;\n  color: @text-color;\n  text-shadow: 0 1px 0 rgba(255, 255, 255, .5);\n}\n.text(subtle) {\n  font-weight: normal;\n  color: @text-color-subtle;\n  text-shadow: none;\n}\n.text(highlight) {\n  font-weight: normal;\n  color: @text-color-highlight;\n}\n.text(selected) {\n  font-weight: normal;\n  color: @text-color-selected;\n  text-shadow: none;\n}\n\n.text(info) {\n  color: @text-color-info;\n  text-shadow: none;\n}\n.text(success) {\n  color: @text-color-success;\n  text-shadow: none;\n}\n.text(warning) {\n  color: @text-color-warning;\n  text-shadow: none;\n}\n.text(error) {\n  color: @text-color-error;\n  text-shadow: none;\n}\n",digest:"372a2e3006fbfc1ed89b41ca8d3f1576aa4bb3c4"},"node_modules/atom-light-ui/styles/ui-variables.less":{content:"// Colors\n\n@text-color: #444;\n@text-color-subtle: #999;\n@text-color-highlight: #000;\n@text-color-selected: #fff;\n\n@text-color-info: #5293d8;\n@text-color-success: #45A815;\n@text-color-warning: #CD8E00;\n@text-color-error: #c00;\n\n@text-color-ignored: @text-color-subtle;\n@text-color-added: @text-color-success;\n@text-color-renamed: @text-color-info;\n@text-color-modified: @text-color-warning;\n@text-color-removed: @text-color-error;\n\n@background-color-info: #0098ff;\n@background-color-success: #17ca65;\n@background-color-warning: #ff4800;\n@background-color-error: #c00;\n@background-color-highlight: rgba(0, 0, 0, .1);\n@background-color-selected: #6aa5e9;\n\n@app-background-color: #ccc;\n\n@base-background-color: #f4f4f4;\n@base-border-color: #9f9f9f;\n\n@pane-item-background-color: @base-background-color;\n@pane-item-border-color: @base-border-color;\n\n@input-background-color: white;\n@input-border-color: fadeout(@base-border-color, 10%);\n\n@tool-panel-background-color: @base-background-color;\n@tool-panel-border-color: @base-border-color;\n\n@inset-panel-background-color: #fff;\n@inset-panel-border-color: fadeout(@base-border-color, 10%);\n\n@panel-heading-background-color: #c3c3c3;\n@panel-heading-border-color: transparent;\n\n@overlay-background-color: #ececec;\n@overlay-border-color: @base-border-color;\n\n@button-background-color: @base-background-color;\n@button-background-color-hover: lighten(@button-background-color, 5%);\n@button-background-color-selected: #888;\n@button-border-color: rgba(0, 0, 0, 0.15);\n\n@tab-bar-background-color: #d8d8d8;\n@tab-bar-border-color: #ddd;\n@tab-background-color: #e8e8e8;\n@tab-background-color-active: #f0f0f0;\n@tab-border-color: lighten(@base-border-color, 10%);\n\n@tree-view-background-color: #eee;\n@tree-view-border-color: @base-border-color;\n\n@scrollbar-background-color: #F9F9F9; // Needs to be opaque -> atom/atom/issues/4578\n@scrollbar-color: #C1C1C1;\n\n@ui-site-color-1: @background-color-success; // green\n@ui-site-color-2: @background-color-info; // blue\n@ui-site-color-3: @background-color-warning; // orange\n@ui-site-color-4: #db2ff4; // purple\n@ui-site-color-5: #f5e11d; // yellow\n\n\n// Sizes\n\n@font-size: 11px;\n@input-font-size: 14px;\n@disclosure-arrow-size: 12px;\n\n@component-padding: 10px;\n@component-icon-padding: 5px;\n@component-icon-size: 16px;\n@component-line-height: 25px;\n@component-border-radius: 2px;\n\n@tab-height: 26px;\n\n\n// Other\n\n@font-family: system-ui;\n",digest:"03f77e9a506f21cad4e10eed6f10b7029baccfd0"},"node_modules/atom-light-ui/styles/utilities.less":{content:".key-binding {\n  background: #fff;\n  border: 1px solid lighten(@base-border-color, 20%);\n  text-shadow: none;\n  display: inline-block;\n  line-height: 100%;\n  border-radius: @component-border-radius;\n  margin-left: @component-icon-padding;\n  font-family: Helvetica, Arial, sans-serif;\n  font-size: @font-size - 1px;\n  padding: @component-padding / 2;\n}\n\n.badge {\n  .text(highlight);\n  background: @background-color-highlight;\n}\n",digest:"4b1dc34c51d901acdaa88925bc21c1c80bd5d879"},"node_modules/one-dark-ui/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// Atom UI Theme: One\n\n@import "styles/ui-variables.less";\n@import "styles/ui-mixins.less";\n@import "octicon-mixins.less"; // https://github.com/atom/atom/blob/master/static/variables/octicon-mixins.less\n\n@import "styles/atom.less";\n@import "styles/badges.less";\n@import "styles/buttons.less";\n@import "styles/docks.less";\n@import "styles/editor.less";\n@import "styles/git.less";\n@import "styles/inputs.less";\n@import "styles/lists.less";\n@import "styles/messages.less";\n@import "styles/nav.less";\n@import "styles/notifications.less";\n@import "styles/modal.less";\n@import "styles/panels.less";\n@import "styles/panes.less";\n@import "styles/progress.less";\n@import "styles/tabs.less";\n@import "styles/text.less";\n@import "styles/title-bar.less";\n@import "styles/tooltips.less";\n@import "styles/tree-view.less";\n@import "styles/status-bar.less";\n@import "styles/key-binding.less";\n@import "styles/sites.less";\n\n@import "styles/settings.less";\n@import "styles/packages.less";\n@import "styles/core.less";\n@import "styles/config.less";\n',digest:"9ae52af555fe1bcd2721d52c1539ca092a07aafa"},"node_modules/one-dark-ui/styles/atom.less":{content:"* {\n\tbox-sizing: border-box;\n}\n\nhtml {\n\tfont-size: @font-size;\n}\n\natom-workspace {\n\tbackground-color: @app-background-color;\n}\n\n\n// Scrollbars ------------------------------------\n\n.scrollbars-visible-always {\n\t::-webkit-scrollbar {\n\t\twidth: 10px;\n\t\theight: 10px;\n\t}\n\n\t::-webkit-scrollbar-track {\n\t\tbackground: @scrollbar-background-color;\n\t}\n\n\t::-webkit-scrollbar-thumb {\n\t\tborder-radius: 5px;\n\t\tborder: 3px solid @scrollbar-background-color;\n\t\tbackground: @scrollbar-color;\n\t\tbackground-clip: content-box;\n\t}\n\n\t::-webkit-scrollbar-corner {\n\t\tbackground: @scrollbar-background-color;\n\t}\n\n\t::-webkit-scrollbar-thumb:vertical:active {\n\t\tborder-radius: 0;\n\t\tborder-left-width: 0;\n\t\tborder-right-width: 0;\n\t}\n\n\t::-webkit-scrollbar-thumb:horizontal:active {\n\t\tborder-radius: 0;\n\t\tborder-top-width: 0;\n\t\tborder-bottom-width: 0;\n\t}\n\n\tatom-text-editor {\n\t\t::-webkit-scrollbar-track {\n\t\t\tbackground: @scrollbar-background-color-editor;\n\t\t}\n\t\t::-webkit-scrollbar-corner {\n\t\t\tbackground: @scrollbar-background-color-editor;\n\t\t}\n\t\t::-webkit-scrollbar-thumb {\n\t\t\tborder-color: @scrollbar-background-color-editor;\n\t\t\tbackground: @scrollbar-color-editor;\n\t\t}\n\t}\n}\n\n// TODO: Move to a better place, not sure where it gets used\n.caret {\n  border-top: 5px solid #fff;\n  margin-top: -1px;\n}\n",digest:"df4447499593550b61146e7af8d0f4cd17991112"},"node_modules/one-dark-ui/styles/badges.less":{content:".badge {\n  padding: @ui-padding/4 @ui-padding/2.5;\n  min-width: @ui-padding*1.25;\n  .text(highlight);\n  border-radius: @ui-size*2;\n  background-color: @badge-background-color;\n\n  // Icon ----------------------\n  &.icon {\n    font-size: @ui-size;\n    padding: @ui-padding-icon @ui-padding-icon*1.5;\n  }\n\n}\n",digest:"bfb1f9e90af654b5baa53d74c36628140507a3f7"},"node_modules/one-dark-ui/styles/buttons.less":{content:"\n@btn-border: 1px solid @button-border-color;\n@btn-padding: 0 @ui-size/1.25;\n\n// Mixins -----------------------\n\n.btn-default (@color, @hover-color, @selected-color, @text-color) {\n  color: @text-color;\n  text-shadow: none;\n  border: @btn-border;\n  background-color: @color;\n  background-image: linear-gradient(lighten(@color, 2%), @color);\n\n  &:hover {\n    color: @text-color-highlight;\n    background-image: linear-gradient(lighten(@hover-color, 2%), @hover-color);\n  }\n  &:active {\n    background: darken(@color, 4%);\n    box-shadow: none;\n  }\n  &.selected {\n    background: @selected-color;\n  }\n  &.selected:focus,\n  &.selected:hover {\n    background: lighten(@selected-color, 2%);\n  }\n  &:focus {\n    .focus(); // unfortunately :focus styles stay even after releasing mouse.\n  }\n}\n\n.btn-variant (@color) {\n  @_text-color: contrast(@color, white, hsl(0,0%,20%), 33% );\n  .btn-default(\n    @color,\n    lighten(@color, 3%),\n    saturate(darken(@color, 12%), 20%),\n    @text-color-highlight\n  );\n  color: @_text-color;\n\n  & when (@ui-lightness > 50%) {\n    border-color: transparent; // hide border on light backgrounds\n  }\n\n  &:hover,\n  &:focus {\n    color: @_text-color;\n  }\n  &:focus {\n    border-color: transparent;\n    background-clip: padding-box;\n    box-shadow: inset 0 0 0 1px fade(@base-border-color, 50%), 0 0 0 1px @color;\n  }\n\n  &.icon:before {\n    color: @_text-color;\n  }\n}\n\n\n// Buttons -----------------------\n\n.btn {\n  height: initial;\n  padding: @btn-padding;\n  font-size: @ui-size;\n  line-height: @ui-line-height;\n}\n\n.btn,\n.btn.btn-default {\n  .btn-default(@button-background-color, @button-background-color-hover, @button-background-color-selected, @text-color);\n}\n\n.btn.btn-primary {\n  .btn-variant(@accent-bg-color);\n}\n.btn.btn-info {\n  .btn-variant(@background-color-info);\n}\n.btn.btn-success {\n  .btn-variant(@background-color-success);\n}\n.btn.btn-warning {\n  .btn-variant(@background-color-warning);\n}\n.btn.btn-error {\n  .btn-variant(@background-color-error);\n}\n\n\n// Button Sizes -----------------------\n\n.btn.btn-xs,\n.btn-group-xs > .btn {\n  font-size: @ui-size*.8;\n  line-height: @ui-line-height;\n  padding: @btn-padding;\n}\n.btn.btn-sm,\n.btn-group-sm > .btn {\n  font-size: @ui-size*.9;\n  line-height: @ui-line-height;\n  padding: @btn-padding;\n}\n.btn.btn-lg,\n.btn-group-lg > .btn {\n  font-size: @ui-size * 1.5;\n  line-height: @ui-line-height;\n  padding: @btn-padding;\n}\n\n\n// Button Group -----------------------\n\n.btn-group > .btn {\n  z-index: 0;\n  &:hover {\n    z-index: 0;\n  }\n  &.btn:focus {\n    z-index: 1;\n    .focus();\n  }\n\n  &:first-child {\n    border-left: @btn-border;\n  }\n  &:last-child,\n  &.selected:last-child {\n    border-right: @btn-border;\n  }\n\n  // hide border on light backgrounds\n  & when (@ui-lightness > 50%) {\n    &.btn-primary:first-child,\n    &.btn-info:first-child,\n    &.btn-success:first-child,\n    &.btn-warning:first-child,\n    &.btn-error:first-child {\n      border-left-color: transparent;\n    }\n\n    &.btn-primary:last-child,\n    &.btn-info:last-child,\n    &.btn-success:last-child,\n    &.btn-warning:last-child,\n    &.btn-error:last-child {\n      border-right-color: transparent;\n    }\n  }\n\n  &.selected,\n  &.selected:first-child,\n  &.selected:last-child {\n    color: @button-text-color-selected;\n    border-color: @button-border-color-selected;\n  }\n\n  & when (@ui-lightness > 50%) {\n    &.selected + .btn {\n      border-left-color: @button-border-color-selected;\n    }\n    &.selected + .selected {\n      border-left-color: mix(@button-border-color, @button-border-color-selected);\n    }\n  }\n\n  &.selected:focus {\n    border-color: @button-background-color-selected;\n    box-shadow: inset 0 0 0 1px fade(@base-border-color, 50%), 0 0 0 1px @button-background-color-selected;\n  }\n}\n\n\n// Button Icons -----------------------\n\n.btn.icon:before {\n  width: auto;\n  height: auto;\n  font-size: 1.333333em;\n  vertical-align: -.1em;\n}\n",digest:"771f75f5f119b4282fb0980b2c492e5cf15ad5d3"},"node_modules/one-dark-ui/styles/config.less":{content:'\n// Theme config\n// This gets changed from the theme settings\n\n@theme-tabsizing: ~\'theme-@{ui-theme-name}-tabsizing\';\n@theme-dockButtons: ~\'theme-@{ui-theme-name}-dock-buttons\';\n@theme-stickyHeaders: ~\'theme-@{ui-theme-name}-sticky-headers\';\n@theme-closeButton: ~\'theme-@{ui-theme-name}-tab-close-button\';\n\n\n// Tabs ----------------------------------------------\n\n@tab-min-width: 7em; // ~ icon + 6 characters\n\n// Even (default)\n\n.tab-bar {\n  .tab,\n  .tab.active {\n    flex: 1 1 0;\n    max-width: 22em;\n    min-width: @tab-min-width;\n  }\n  atom-dock & {\n    .tab,\n    .tab.active {\n      max-width: none;\n    }\n  }\n\n  // TODO: Turn this into a config\n  // Truncates the beginning instead\n  // .title.title.title {\n  //   direction: rtl; // change direction\n  // }\n}\n\n\n// Maximum (full width)\n\n[@{theme-tabsizing}="maximum"] .tab-bar {\n  .tab,\n  .tab.active {\n    max-width: none;\n  }\n}\n\n\n// Minimum (show long paths)\n\n[@{theme-tabsizing}="minimum"] .tab-bar {\n  .tab,\n  .tab.active {\n    flex: 0 0 auto;\n    min-width: 2.75em;\n    max-width: @tab-min-width * 3.3;\n  }\n  atom-dock {\n    .tab,\n    .tab.active {\n      max-width: @tab-min-width * 2;\n    }\n  }\n}\n\n\n// Tabs: close button position  ------------------------------\n\n[@{theme-closeButton}="left"] {\n\n  .tab-bar .tab {\n    .close-icon {\n      right: auto;\n      left: @icon-padding-right;\n    }\n  }\n\n}\n\n\n// Hide docks toggle buttons ------------------------------\n\n[@{theme-dockButtons}="hidden"] {\n\n  // Hide docks when not open\n  .atom-dock-inner:not(.atom-dock-open) {\n    display: none;\n  }\n\n  // Hide toggle buttons\n  .atom-dock-toggle-button {\n    display: none;\n  }\n\n}\n\n\n// Sticky Projects ------------------------------\n\n[@{theme-stickyHeaders}="sticky"] {\n\n  .tree-view {\n    .project-root-header {\n      position: sticky;\n      top: 0;\n      z-index: 3;\n      padding-left: 5px;\n      padding-right: 10px;\n      border-bottom: 1px solid @base-border-color;\n      background-color: @tree-view-background-color;\n    }\n    .project-root.project-root {\n      margin-left: -5px;\n      margin-right: -10px;\n\n      // Disable selection\n      &::before {\n        display: none;\n      }\n\n      // Add selection back\n      &.selected .project-root-header {\n        background-color: @background-color-selected;\n      }\n    }\n    &:focus .selected .project-root-header.project-root-header  {\n      background: @button-background-color-selected;\n    }\n\n    // Fix sticky header from covering auto-revealed files\n    .entry.file.selected {\n      padding-top: @ui-tab-height;\n      margin-top: -@ui-tab-height;\n    }\n\n    // Fix sticky header from covering auto-revealed directories when using up/down keys\n    // for directories, scroll test moves to .header, see https://github.com/atom/tree-view/blob/d2857ad4d7eeb7dad5cf94b33257a8740211480e/lib/tree-view.coffee#L839\n    .entry.directory.selected:not(.project-root) {\n      & > .header {\n        padding-top: @ui-tab-height;\n        margin-top: -@ui-tab-height;\n      }\n      &::before {\n        margin-top: @ui-tab-height;\n      }\n    }\n\n    // Fix above directory is not being clickable\n    .entry.directory:not(.project-root) > .header {\n      z-index: 2;\n    }\n    .entry.directory.selected:not(.project-root) > .header {\n      z-index: 1;\n    }\n  }\n}\n',digest:"fcb29fb84c0b7aa85e8f68043418f04198a637b2"},"node_modules/one-dark-ui/styles/core.less":{content:"// Misc\n\n.preview-pane .results-view .path-match-number {\n  // show number also on selected item\n  color: inherit;\n  opacity: .6;\n}\n\n.tool-panel.incompatible-packages {\n  // incompatible-packages isn't really a tool-panel and more a whole pane\n  .text(normal);\n  background-color: @level-2-color;\n}\n\n// Styleguide ----------------------------------------------\n\n.styleguide {\n  // Modal\n  atom-panel.modal:after {\n    position: absolute;  // prevent overlay backdrop from leaking outside\n    left: -@ui-padding;\n    right: -@ui-padding;\n    bottom: -@ui-padding;\n  }\n}\n",digest:"4ba9309f9e37001066e7f31b17f9ff985741a298"},"node_modules/one-dark-ui/styles/docks.less":{content:"\n// Docks ------------------------------\n\n// Make handles not take up any space when dock is open\n.atom-dock-resize-handle {\n  position: absolute;\n  z-index: 11; // same as toggle buttons\n\n  &.left {\n    top: 0;\n    right: 0;\n    bottom: 0;\n  }\n  &.right {\n    top: 0;\n    left: 0;\n    bottom: 0;\n  }\n  &.bottom {\n    top: 0;\n    left: 0;\n    right: 0;\n  }\n}\n\n// Add borders\n.atom-dock-inner.atom-dock-open.left {\n  border-right: 1px solid @base-border-color;\n}\n.atom-dock-inner.atom-dock-open.right {\n  border-left: 1px solid @base-border-color;\n}\n\n// Make toggle buttons cover ^ border\n.atom-dock-toggle-button.left {\n  margin-left: -2px;\n}\n.atom-dock-toggle-button.right {\n  margin-right: -2px;\n}\n.atom-dock-inner:not(.atom-dock-open) .atom-dock-toggle-button.bottom {\n  margin-bottom: -1px;\n}\n",digest:"fe5ca63b2ddbf1b6a581c394ddf11859fd44db08"},"node_modules/one-dark-ui/styles/dropdowns.less":{content:".dropdown-menu {\n  background-color: @overlay-background-color;\n  border-radius: @component-border-radius;\n  border: 1px solid @base-border-color;\n  padding: 0;\n\n  > li > a {\n    .text(normal);\n  }\n\n  > li > a:hover {\n    .text(highlight);\n    background-color: @background-color-highlight;\n  }\n}\n",digest:"344a6a3a32a0e115652f60c7626fc93e1d2220c1"},"node_modules/one-dark-ui/styles/editor.less":{content:"\n// Editor in a panel\n\n// TODO: Find a better selector, maybe a new class like atom-text-editor[medium]\natom-panel-container atom-text-editor.is-focused {\n  .focus();\n}\n\n\n// Mini\n// Usually just single line inputs\n\natom-text-editor[mini] {\n  overflow: auto;\n  font-size: @ui-input-size;\n  line-height: @ui-line-height;\n  max-height: @ui-line-height * 5; // rows\n  padding-left: @ui-padding/3;\n  border-radius: @component-border-radius;\n  color: @text-color-highlight;\n  border: 1px solid @input-border-color;\n  background-color: @input-background-color;\n\n  .placeholder-text {\n    color: @text-color-subtle;\n  }\n\n  .selection .region {\n    background-color: @input-selection-color;\n  }\n\n  .cursor {\n    border-color: @accent-color;\n    border-width: 2px;\n  }\n\n  &.is-focused {\n    .focus();\n    background-color: @input-background-color-focus;\n    .selection .region {\n      background-color: @input-selection-color-focus;\n    }\n  }\n}\n",digest:"c372db5e2182585e75a5dbc970c85d04f9ac94c9"},"node_modules/one-dark-ui/styles/git.less":{content:".status { .text(normal); }\n.status-added    { .text(success); } // green\n.status-ignored  { .text(subtle); }  // faded\n.status-modified { .text(warning); } // orange\n.status-removed  { .text(error); }   // red\n.status-renamed  { .text(info); }    // blue\n",digest:"4cc19322834e5e93b47fe889895e14e6a7576f8d"},"node_modules/one-dark-ui/styles/inputs.less":{content:"\n//\n// Checkbox\n// -------------------------\n\n.input-checkbox {\n  &:active {\n    background-color: @accent-color;\n  }\n  &:before,\n  &:after {\n    background-color: @accent-text-color;\n  }\n  &:checked {\n    background-color: @accent-color;\n  }\n\n  &:indeterminate {\n    background-color: @accent-color;\n  }\n}\n\n\n//\n// Radio\n// -------------------------\n\n.input-radio {\n  &:before {\n    background-color: @accent-text-color;\n  }\n  &:active {\n    background-color: @accent-color;\n  }\n  &:checked {\n    background-color: @accent-color;\n  }\n}\n\n\n//\n// Range (Slider)\n// -------------------------\n\n.input-range {\n  &::-webkit-slider-thumb {\n    background-color: @accent-color;\n  }\n}\n\n\n//\n// Toggle\n// -------------------------\n\n.input-toggle {\n  &:checked {\n    background-color: @accent-color;\n  }\n  &:before {\n    background-color: @accent-text-color;\n  }\n}\n\n\n\n// States -------------------------\n\n.input-checkbox,\n.input-text,\n.input-search,\n.input-number,\n.input-textarea,\n.input-select,\n.input-color {\n  &:focus {\n    .focus();\n  }\n}\n\n.input-text,\n.input-search,\n.input-number,\n.input-textarea {\n  &:invalid {\n    .invalid();\n  }\n}\n",digest:"cbdd7828f45ee1f03e26114404290d170462d705"},"node_modules/one-dark-ui/styles/key-binding.less":{content:".key-binding {\n  display: inline-block;\n  margin-left: @ui-padding-icon;\n  padding: 0 @ui-padding/4;\n  line-height: 2;\n  font-family: inherit;\n  font-size: max(1em, @ui-size*.85);\n  letter-spacing: @ui-size/10;\n  border-radius: @component-border-radius;\n  color: @accent-bg-text-color;\n  background-color: @accent-bg-color;\n}\n",digest:"2c7039e912c9a51bc17fdb5619d12da5192a1f6f"},"node_modules/one-dark-ui/styles/lists.less":{content:".list-group,\n.list-tree {\n  li:not(.list-nested-item),\n  li.list-nested-item > .list-item {\n    .text(normal);\n  }\n\n  .generate-list-item-text-color(@class) {\n    li:not(.list-nested-item).text-@{class},\n    li.list-nested-item.text-@{class} > .list-item {\n      .text(@class);\n    }\n  }\n  .generate-list-item-text-color(subtle);\n  .generate-list-item-text-color(info);\n  .generate-list-item-text-color(success);\n  .generate-list-item-text-color(warning);\n  .generate-list-item-text-color(error);\n  .generate-list-item-text-color(selected);\n\n  .generate-list-item-status-color(@color, @status) {\n    li:not(.list-nested-item).status-@{status},\n    li.list-nested-item.status-@{status} > .list-item {\n      color: @color;\n    }\n\n    li:not(.list-nested-item).selected.status-@{status},\n    li.list-nested-item.selected.status-@{status} > .list-item {\n      color: @color;\n    }\n\n  }\n\n  .generate-list-item-status-color(@text-color-added, added);\n  .generate-list-item-status-color(@text-color-ignored, ignored);\n  .generate-list-item-status-color(@text-color-modified, modified);\n  .generate-list-item-status-color(@text-color-removed, removed);\n  .generate-list-item-status-color(@text-color-renamed, renamed);\n\n  li:not(.list-nested-item).selected,\n  li.list-nested-item.selected > .list-item {\n    .text(selected);\n  }\n\n  .no-icon {\n    padding-left: calc(@ui-padding-icon ~\"+\" @component-icon-size);\n  }\n}\n\n.list-tree.has-collapsable-children .list-nested-item > .list-item::before {\n  text-align: center;\n}\n\n.select-list ol.list-group,\n&.select-list ol.list-group {\n  li.two-lines {\n    .secondary-line {\n      color: @text-color-subtle;\n    }\n    &.selected .secondary-line {\n      color: fade(@text-color-highlight, 50%);\n      text-shadow: none;\n    }\n  }\n\n  // Reset icon to allow nesting\n  .icon {\n    display: initial;\n    height: initial;\n  }\n\n  // We want to highlight the background of the list items because we dont\n  // know their size.\n  li.selected {\n    background-color: @background-color-selected;\n    &:before{ display: none; }\n  }\n\n  &.mark-active {\n    @active-icon-size: 14px;\n\n    // pad in front of the text where the icon would be We'll pad the non-\n    // active items with a 'fake' icon so other classes can pad the item\n    // without worrying about the icon padding.\n    li:before {\n      content: '';\n      background-color: transparent;\n      position: static;\n      display: inline-block;\n      left: auto; right: auto;\n      height: @active-icon-size;\n      width: @active-icon-size;\n      font-size: @active-icon-size;\n    }\n    > li:not(.active):before {\n      margin-right: @ui-padding-icon;\n    }\n    li.active {\n      .octicon(check, @active-icon-size);\n      &:before {\n        margin-right: @ui-padding-icon;\n        color: @text-color-success;\n      }\n    }\n  }\n}\n\n.select-list.popover-list {\n  @popover-list-padding: @ui-padding/4;\n  background-color: @overlay-background-color;\n  box-shadow: 0 2px 8px 1px rgba(0, 0, 0, 0.3);\n  padding: @popover-list-padding;\n  border-radius: @component-border-radius;\n\n  atom-text-editor[mini] {\n    margin-bottom: @popover-list-padding;\n  }\n\n  ol.list-group {\n    margin-top: @popover-list-padding;\n  }\n\n  .list-group li {\n    padding-left: @popover-list-padding;\n  }\n\n  // Un-reset icon in popover lists\n  .icon.icon {\n    display: inline-block;\n    height: inherit;\n  }\n}\n\n.ui-sortable {\n  li {\n    line-height: 2.5;\n  }\n\n  // For sortable lists in the settings view\n  li.ui-sortable-placeholder {\n    visibility: visible !important;\n    background-color: darken(@pane-item-background-color, 10%);\n  }\n}\n\nli.ui-draggable-dragging,\nli.ui-sortable-helper {\n  line-height: @ui-line-height;\n  height: @ui-line-height;\n  border: 0;\n  border-radius: 0;\n  list-style: none;\n  padding: 0 @ui-padding;\n  background: @background-color-highlight;\n  box-shadow: 0 0 1px @base-border-color;\n}\n",digest:"805f0bfbc29ff389ea2123b6cc85317d5ac6f87a"},"node_modules/one-dark-ui/styles/messages.less":{content:"background-tips ul.background-message {\n  font-weight: 500;\n  font-size: 2em;\n  color: @text-color-faded;\n\n  .message {\n    padding: 0 @component-padding * 10;\n\n    .keystroke {\n      white-space: nowrap;\n      vertical-align: middle;\n      line-height: 1;\n      padding: .1em .4em;\n    }\n  }\n}\n",digest:"fbe98214c0578199506deb9b230c56019060194b"},"node_modules/one-dark-ui/styles/modal.less":{content:'\n@modal-padding: @ui-padding/2 @ui-padding/1.5;\n@modal-width: @ui-size * 50;\n\natom-panel-container.modal {\n  position: absolute;\n  top: 0; left: 0; right: 0;\n}\n\natom-panel.modal {\n  position: relative;\n  width: 100%;\n  max-width: @modal-width;\n  margin: 0 auto;\n  left: initial;\n  color: @text-color;\n  background-color: transparent;\n  padding: @ui-padding/2;\n\n  &.from-top {\n    top: @component-padding * 5;\n  }\n\n  atom-text-editor[mini] {\n    margin-bottom: @ui-padding/2;\n  }\n\n  .select-list ol.list-group,\n  &.select-list ol.list-group {\n    border: 1px solid @overlay-border-color;\n    background-color: lighten(@overlay-background-color, 2%);\n\n    &:empty {\n      border: none;\n      margin-top: 0;\n    }\n\n    li {\n      padding: @modal-padding;\n      line-height: @ui-line-height;\n      border-bottom: 1px solid @overlay-border-color;\n\n      &:last-of-type {\n        border-bottom: none;\n      }\n\n      .icon::before {\n        margin-left: 1px;\n      }\n\n      .icon.status {\n        float: right;\n        margin-left: @ui-padding-icon;\n        &:before {\n          margin-left: 0;\n          margin-right: 0;\n        }\n      }\n\n      &.selected {\n        .status.icon {\n          color: @text-color-selected;\n        }\n      }\n    }\n\n  }\n\n  .select-list .key-binding {\n    margin-top: -1px;\n    margin-left: @ui-padding/2;\n    margin-right: calc( -@ui-padding/3 ~"+" 1px);\n  }\n\n  .select-list .primary-line {\n    display: block;\n  }\n\n  & > * {\n    position: relative; // fixes stacking order\n  }\n\n  .command-palette {\n    padding: 1px; // prevents the box-shadow of the input from being cut off\n    background-color: @overlay-background-color;\n  }\n\n\n  // Container\n  &:before {\n    content: "";\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    z-index: 0;\n    background-color: @overlay-background-color;\n    border-radius: @component-border-radius*2;\n    box-shadow: 0 6px 12px -2px hsla(0,0%,0%,.4);\n  }\n\n  // Backdrop\n  // TODO: Add extra wrapper to translate individually or easier positioning\n\n  &:after {\n    content: "";\n    position: fixed;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    z-index: -1;\n    background: @overlay-backdrop-color;\n    opacity: @overlay-backdrop-opacity;\n    backface-visibility: hidden; // fixes scrollbar on retina screens\n    -webkit-animation: overlay-fade .24s cubic-bezier(0.215, 0.61, 0.355, 1);\n  }\n\n  @-webkit-keyframes overlay-fade {\n    0% { opacity: 0; }\n    100% { opacity: @overlay-backdrop-opacity; }\n  }\n\n}\n',digest:"62679c03ee0a22e217d8095f67b69d2ad79c65ae"},"node_modules/one-dark-ui/styles/nav.less":{content:".nav-tabs {\n  border-bottom: 1px solid @base-border-color;\n  li {\n    a,\n    &.active a {\n      border: none;\n      margin-right: 0px;\n      margin-bottom: 1px;\n    }\n\n    a:hover,\n    &.active a,\n    &.active a:hover {\n      background-color: @background-color-highlight;\n      border: none;\n      color: @text-color-selected;\n      border-bottom-left-radius: 0px;\n      border-bottom-right-radius: 0px;\n    }\n\n    &.active a {\n      background-color: @tab-background-color-active;\n    }\n  }\n}\n",digest:"54ed0e49741845e8799c9513ae21ca7ae75f751d"},"node_modules/one-dark-ui/styles/notifications.less":{content:"\natom-notifications {\n  font-size: @ui-size * 1.2;\n\n  atom-notification {\n    width: 32em;\n    &.has-detail {\n      width: 32em;\n    }\n\n    &:first-child.has-close .message {\n      padding-right: 9em;\n    }\n    &:only-child.has-close .message,\n    &.has-close .message {\n      padding-right: 2.5em;\n    }\n    .item {\n      padding: @ui-padding/2;\n    }\n\n    .detail,\n    .description {\n      font-size: .85em;\n    }\n\n    &.icon:before {\n      padding-top: .85em;\n    }\n    .close {\n      width: 2.5em;\n      height: 3em;\n      line-height: 3em;\n      font-size: inherit;\n    }\n    .close-all.btn {\n      top: .5em;\n      right: 2.5em;\n    }\n    .btn-copy-report {\n      line-height: 2em;\n      margin-left: .5em;\n    }\n  }\n}\n",digest:"2e08e0dc91ed0d4dcf79a1dcec241fd3ceac0cf4"},"node_modules/one-dark-ui/styles/packages.less":{content:"// Overrides packages\n\n// find-and-replace + project-find ---------------------------\n\n.find-and-replace,\n.project-find {\n  padding: @ui-padding/4;\n  .input-block-item {\n    padding: @ui-padding/4;\n  }\n}\n\n// find-and-replace\n.find-and-replace {\n  .header,\n  .input-block {\n    min-width: @ui-size*22;\n  }\n\n  .input-block-item {\n    flex: 1 1 @ui-size*22;\n  }\n  .input-block-item--flex {\n    flex: 100 1 @ui-size*22;\n  }\n\n  .btn,\n  .btn-group-options .btn {\n    font-size: @ui-size*1.1;\n    padding: 0;\n  }\n\n  .btn-group-options .btn,\n  .btn-group-options .btn.option-selection,\n  .btn-group-options .btn.option-whole-word {\n    padding: 0;\n    font-size: @ui-input-size; // keep same as text input\n  }\n\n  .find-container atom-text-editor {\n    padding-right: @ui-size*5; // leave some room for the results count\n  }\n  .find-meta-container {\n    top: 0;\n    font-size: @ui-size;\n    line-height: @ui-size*2.5;\n  }\n}\n\n// project-find\n.project-find {\n  .header,\n  .input-block {\n    min-width: @ui-size*15;\n  }\n\n  .input-block-item {\n    flex: 1 1 @ui-size*14;\n  }\n  .input-block-item--flex {\n    flex: 100 1 @ui-size*20;\n  }\n\n  .btn {\n    font-size: @ui-size*1.1;\n    padding: 0;\n  }\n  .btn-group-options .btn {\n    padding: 0;\n    font-size: @ui-input-size; // keep same as text input\n  }\n}\n\n// Colorize find-and-replace based on results\n& when (@ui-hue >= 190) and (@ui-hue <= 340) {\n  .find-and-replace {\n    &.has-no-results .find-container atom-text-editor[mini].is-focused {\n      .invalid();\n      .selection .region {\n        background-color: mix(@text-color-error, @input-background-color, 50%);\n      }\n      .cursor {\n        border-color: @text-color-error;\n      }\n    }\n\n    &.has-results .find-container atom-text-editor[mini].is-focused {\n      .valid();\n      .selection .region {\n        background-color: mix(@text-color-success, @input-background-color, 50%);\n      }\n      .cursor {\n        border-color: @text-color-success;\n      }\n    }\n\n    &.has-results    .find-container .result-counter { color: @text-color-success; }\n    &.has-no-results .find-container .result-counter { color: @text-color-error; }\n  }\n}\n\n\n\n\n// Timecop ---------------------------\n\n.timecop {\n  .timecop-panel {\n    padding: @component-padding/2;\n    background-color: @level-2-color;\n  }\n\n  .tool-panel {\n    padding: @component-padding/2;\n    background-color: @level-2-color;\n  }\n\n  .inset-panel {\n    border: 1px solid @base-border-color;\n  }\n\n  .panel-heading {\n    .text(highlight);\n    border-color: @base-border-color;\n    background-color: @level-1-color;\n  }\n\n  .list-item .inline-block {\n    line-height: 1.5;\n  }\n}\n\n\n// Command Palette + Fuzzy Finder ---------------------------\n\n.command-palette .list-group .character-match,\n.fuzzy-finder .list-group .character-match {\n  color: @accent-only-text-color;\n}\n\n\n// Deprecation Cop ---------------------------\n\n.deprecation-cop {\n  .deprecation-overview {\n    background-color: @level-2-color;\n    border-bottom: 1px solid @base-border-color;\n  }\n}\n\n\n// Tool Bar ---------------------------\n\n.tool-bar {\n  // Make it look the same as other panels\n  background-color: @level-3-color;\n  border: none;\n\n  // just a single border + more spacing\n  &.tool-bar-horizontal .tool-bar-spacer {\n    border-left: 0 none;\n    margin-left: .5em;\n    margin-right: .5em;\n  }\n  &.tool-bar-vertical .tool-bar-spacer {\n    border-bottom: 0 none;\n    margin-top: .5em;\n    margin-bottom: .5em;\n  }\n\n  // only show button styles on hover\n  button.tool-bar-btn {\n    background-color: @level-3-color;\n    background-image: none;\n    border-color: @level-3-color;\n  }\n}\n\n\n\n// GitHub package ---------------------------------------------------\n\n.github {\n\n  // Fix focus styles\n  // Since it's not possible to add a padding to <atom-text-editor>\n  // a pseudo element is used to add the border when focused.\n  &-CommitView-editor atom-text-editor.is-focused {\n    box-shadow: none;\n    &:before {\n      content: \"\";\n      position: absolute;\n      top: -2px;\n      left: -2px;\n      right: -2px;\n      bottom: -2px;\n      border: 2px solid;\n      border-color: inherit;\n      border-radius: @component-border-radius;\n    }\n  }\n\n  // Add focus styles since :focus doesn't work\n  &-CommitView-coAuthorEditor {\n    &.is-focused {\n      .focus();\n    }\n    &.is-open {\n      border-top-left-radius: 0;\n      border-top-right-radius: 0;\n    }\n\n\n    .Select-option {\n      &.is-focused {\n        border-bottom-left-radius: 0;\n        border-bottom-right-radius: 0;\n        color: @accent-text-color;\n        background-color: @accent-color;\n      }\n    }\n    .Select-menu-outer {\n      left: -2px;\n      right: -2px;\n      bottom: 100%;\n      border: 2px solid @accent-color;\n      background-color: @overlay-background-color;\n    }\n  }\n\n}\n",digest:"fde4ec7a426d574517c7e3a0c14284416b84873d"},"node_modules/one-dark-ui/styles/panels.less":{content:"\n// Panels\n\natom-panel {\n  .text(normal);\n  position: relative;\n  border-bottom: 1px solid @base-border-color;\n\n  &.top {\n    border-right: 1px solid @base-border-color;\n  }\n  &.left {\n    border-right: 1px solid @base-border-color;\n  }\n  &.right {\n    border-left: 1px solid @base-border-color;\n  }\n  &.bottom {\n    border-right: 1px solid @base-border-color;\n  }\n  &.footer:last-child {\n    border-bottom: none;\n  }\n  &.tool-panel:empty {\n    border: none;\n  }\n}\n\n.panel {\n  &.bordered {\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n  }\n}\n\n.inset-panel {\n  position: relative;\n  background-color: @inset-panel-background-color;\n  border-radius: @component-border-radius;\n  &.bordered {\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n  }\n  & .panel-heading {\n    border-color: @inset-panel-border-color;\n  }\n}\n\n.panel-heading {\n  .text(normal);\n  border-bottom: 1px solid @panel-heading-border-color;\n  background-color: @panel-heading-background-color;\n\n  .btn {\n    padding-left: 8px;\n    padding-right: 8px;\n    .btn-default(\n      lighten(@button-background-color, 10%),\n      lighten(@button-background-color-hover, 10%),\n      lighten(@button-background-color-selected, 10%),\n      lighten(@text-color, 10%)\n    );\n  }\n}\n",digest:"78e95fe77592b096e829427a1a4c35c24f9baea6"},"node_modules/one-dark-ui/styles/panes.less":{content:"\natom-pane-container {\n\n  atom-pane {\n    position: relative;\n    border-right: 1px solid @base-border-color;\n    border-bottom: 1px solid @base-border-color;\n\n    .item-views {\n      // prevent atom-text-editor from leaking ouside might improve performance\n      overflow: hidden;\n    }\n  }\n\n}\n\n// Hide right-most border\natom-pane:only-child,\natom-pane-axis.pane-row > atom-pane:last-child,\natom-pane-axis.pane-column:last-child > atom-pane {\n  border-right: none;\n}\n",digest:"517a4bfd51fba7919d84a7e89eef84db64f68d55"},"node_modules/one-dark-ui/styles/progress.less":{content:'\n// Spinner ----------------------\n\n@spinner-duration: 1.2s;\n\n.loading-spinner(@size) {\n  position: relative;\n  display: block;\n  width: 1em;\n  height: 1em;\n  font-size: @size;\n  background: radial-gradient(@accent-color .1em, transparent .11em);\n\n  &::before,\n  &::after {\n    content: "";\n    position: absolute;\n    z-index: 10; // prevent sibling elements from getting their own layers\n    top: 0;\n    left: 0;\n    border-radius: 1em;\n    width: inherit;\n    height: inherit;\n    border-radius: 1em;\n    border: 2px solid;\n    -webkit-animation: spinner-animation @spinner-duration infinite;\n    -webkit-animation-fill-mode: backwards;\n  }\n  &::before {\n    border-color: @accent-color transparent transparent transparent;\n  }\n  &::after {\n    border-color: transparent lighten(@accent-color, 15%) transparent transparent;\n    -webkit-animation-delay: @spinner-duration/2;\n  }\n\n  &.inline-block {\n    display: inline-block;\n  }\n}\n\n@-webkit-keyframes spinner-animation {\n    0% { transform: rotateZ(  0deg); -webkit-animation-timing-function: cubic-bezier(0, 0, .8, .2); }\n   50% { transform: rotateZ(180deg); -webkit-animation-timing-function: cubic-bezier(.2, .8, 1, 1); }\n  100% { transform: rotateZ(360deg); }\n}\n\n// Spinner sizes\n.loading-spinner-tiny   { .loading-spinner(16px); &::before, &::after { border-width: 1px; } }\n.loading-spinner-small  { .loading-spinner(32px); }\n.loading-spinner-medium { .loading-spinner(48px); }\n.loading-spinner-large  { .loading-spinner(64px); }\n\n\n\n\n// Progress Bar ----------------------\n\n@progress-height: 8px;\n@progress-buffer-color: fade(@progress-background-color, 20%);\n\nprogress {\n  -webkit-appearance: none;\n  height: @progress-height;\n  border-radius: @component-border-radius;\n  background-color: @input-background-color;\n  box-shadow: inset 0 0 0 1px @input-border-color;\n\n  &::-webkit-progress-bar {\n    background-color: transparent;\n  }\n\n  &::-webkit-progress-value {\n    border-radius: @component-border-radius;\n    background-color: @progress-background-color;\n  }\n\n  // Is buffering (when no value is set)\n  &:indeterminate {\n    background-image:\n       linear-gradient(-45deg, transparent 33%, @progress-buffer-color 33%,\n                               @progress-buffer-color 66%, transparent 66%);\n    background-size: 25px @progress-height, 100% 100%, 100% 100%;\n\n    // Plays animation for 1min (12runs) at normal speed,\n    // then slows down frame-rate for 9mins (108runs) to limit CPU usage\n    -webkit-animation: progress-buffering 5s linear 12,\n                       progress-buffering 5s 60s steps(10) 108;\n  }\n}\n\n@-webkit-keyframes progress-buffering {\n   100% { background-position: -100px 0px; }\n}\n',digest:"c51843dd15ee040fd7a60aaccf3e2d1071459cb0"},"node_modules/one-dark-ui/styles/settings.less":{content:'\n// Settings\n\n// Modular Scale (1.125): http://www.modularscale.com/?1&em&1.125&web&table\n@ms-6: @ui-size * 2.027;\n@ms-5: @ui-size * 1.802;\n@ms-4: @ui-size * 1.602;\n@ms-3: @ui-size * 1.424;\n@ms-2: @ui-size * 1.266;\n@ms-1: @ui-size * 1.125;\n@ms-0: @ui-size * 1;\n@ms_1: @ui-size * 0.889;\n@ms_2: @ui-size * 0.790;\n\n\n\n.settings-view {\n\n\t// Menu ------------------------------\n\n\t.config-menu {\n\t\tposition: relative;\n\t\tmin-width: @ui-size * 15;\n\t\tmax-width: @ui-size * 20;\n\t\tborder-width: 0 1px 0 0;\n\t\tborder-image: linear-gradient(@level-2-color 10px, @base-border-color 200px) 0 1 0 0 stretch;\n\t\tbackground: @level-2-color;\n\n\t\t.btn {\n\t\t\twhite-space: initial;\n\t\t\tfont-size: @ms_1;\n\t\t\tline-height: 1;\n\t\t\tpadding: @ui-padding/3 @ui-padding/2;\n\t\t\t&::before {\n\t\t\t\tvertical-align: middle;\n\t\t\t}\n\t\t}\n\n\n\t}\n\t.nav {\n\t\t& > li > a {\n\t\t\tpadding: @ui-padding/2 @ui-padding;\n\t\t\tline-height: @ui-line-height;\n\t\t}\n\t}\n\n\n\t// Sections ------------------------------\n\n\t& > .panels {\n\t\tbackground-color: @level-2-color;\n\t}\n\n\t.section-container {\n\t\tmax-width: @ui-size*60;\n\t}\n\n\t.section,\n\t.section:first-child,\n\t.section:last-child {\n\t\tpadding: @ui-padding*3;\n\t}\n\n\t.themes-panel .control-group {\n\t\tmargin-top: @ui-padding*2;\n\t}\n\n\n\t// Titles ------------------------------\n\n\t.section .section-heading {\n\t\tmargin-bottom: @ui-padding/1.5;\n\t}\n\n\t.sub-section-heading.icon:before,\n\t.section-heading.icon:before {\n\t\tmargin-right: @ui-padding-icon;\n\t}\n\n\n\n\t// Cards ------------------------------\n\n\t.sub-section:not(.collapsed) .package-container {\n\t\tpadding-bottom: @component-padding*3;\n\t}\n\n\t.package-card {\n\t\tpadding: @ui-padding;\n\t\t.meta-controls .status-indicator {\n\t\t\twidth: @ui-padding/4;\n\t\t\t&:before {\n\t\t\t\tcontent: "\\00a0"; // fixes 0 height\n\t\t\t}\n\t\t}\n\t}\n\n\n\t// Components ------------------------------\n\n\t.icon::before {\n\t\tcolor: @text-color-subtle;\n\t}\n\n\t.editor-container {\n\t\tmargin: @ui-padding 0;\n\t}\n\n\t.form-control {\n\t\tfont-size: @ui-size*1.25;\n\t\theight: @ui-line-height;\n\t\tpadding-top: 0;\n\t\tpadding-bottom: 0;\n\t}\n\n\t.update-all-button {\n\t\tfont-size: .75em;\n\t}\n\n\t.install-button {\n\t\t.btn-variant(@accent-bg-color);\n\t}\n\n\tinput[type="checkbox"] {\n\t\tbackground-color: @background-color-selected;\n\t\t&:active,\n\t\t&:checked {\n\t\t\tbackground-color: @accent-color;\n\t\t}\n\t\t&:before,\n\t\t&:after {\n\t\t\tbackground-color: @accent-text-color;\n\t\t}\n\t}\n\n\t.search-container .btn {\n\t\tfont-size: @ui-input-size;\n\t}\n\n}\n',digest:"b7a8f837ee9ccf0ec8ef897de3dca6cef997a42f"},"node_modules/one-dark-ui/styles/sites.less":{content:"// Site Colors\n\n.ui-site(@num, @color) {\n  .ui-site-@{num} {\n    background-color: @color;\n  }\n}\n\n.ui-site(1, @ui-site-color-1);\n.ui-site(2, @ui-site-color-2);\n.ui-site(3, @ui-site-color-3);\n.ui-site(4, @ui-site-color-4);\n.ui-site(5, @ui-site-color-5);\n",digest:"b27327b73cb57001e574b9d1db332766ac6d1e4e"},"node_modules/one-dark-ui/styles/status-bar.less":{content:"\n@status-bar-height: @ui-tab-height; // same as tabs\n@status-bar-padding: @ui-padding;\n\n.status-bar {\n  font-size: @ui-size;\n  height: @status-bar-height;\n  line-height: @status-bar-height;\n  background-color: @level-3-color;\n\n  .flexbox-repaint-hack {\n    padding: 0; // override default\n  }\n\n  // underlines should only be used for external links\n  a:hover,\n  a:focus {\n    text-decoration: none;\n    cursor: default;\n  }\n\n  .inline-block {\n    margin: 0; // override default\n    padding: 0 @status-bar-padding/2;\n    vertical-align: top;\n\n    &:hover {\n      text-decoration: none;\n      background-color: @level-3-color-hover;\n    }\n    &:active {\n      background-color: @level-3-color-active;\n    }\n\n    // reset on child inline-block\n    .inline-block {\n      margin: 0;\n      padding: 0;\n    }\n  }\n\n  .status-bar-right {\n    .inline-block {\n      margin-left: 0; // override default\n    }\n  }\n  .icon {\n    vertical-align: middle;\n  }\n  .icon::before {\n    font-size: 1.33333em; // should be 16px with a default of 12px\n  \twidth: auto; // use natural width\n    line-height: 1;\n    height: 1em; // same as line-height\n    margin-right: .25em;\n    top: auto;\n  }\n}\n\n\n// Package overrides -------------------------------\n\n.status-bar.status-bar {\n\n  // Read-only -> Remove hover effect\n  .is-read-only, // <- use this class in packages\n  status-bar-launch-mode,\n  busy-signal {\n    &:hover,\n    &:active,\n    .inline-block:hover,\n    .inline-block:active {\n      background-color: transparent;\n    }\n  }\n\n  // Remove underline\n  .package-updates-status-view,\n  .github-ChangedFilesCount {\n    &:hover,\n    &:focus {\n      text-decoration: none;\n      cursor: default;\n    }\n  }\n\n  // Remove margin for icon without text\n  status-bar-launch-mode::before, // Launch mode\n  .about-release-notes::before, // New release squirrel\n  .PortalStatusBarIndicator .icon::before, // Teletype\n  .icon.is-icon-only::before {\n    margin-right: 0;\n  }\n  .github-PushPull-label.is-push:empty { // GitHub package when nothing to push\n    margin-right: -.25em;\n  }\n}\n",digest:"1b2caf1dbe80d6552e3e5e9291a295af01e118e9"},"node_modules/one-dark-ui/styles/tabs.less":{content:'\n// Tabs\n\n@tab-border: 1px solid @tab-border-color;\n@title-padding: .66em;\n@icon-padding-top: .5em; // 2.5 (total) - 1.5 (text) / 2\n@icon-padding-right: .5em;\n\n.tab-bar {\n  position: relative;\n  height: @ui-tab-height;\n  box-shadow: inset 0 -1px 0 @tab-border-color;\n  background: @tab-bar-background-color;\n  overflow-x: auto;\n  overflow-y: hidden;\n  border-radius: 0;\n\n  &::-webkit-scrollbar {\n    display: none;\n  }\n\n  &:empty {\n    display: none;\n  }\n\n\n  // Tab ----------------------\n\n  .tab {\n    position: relative;\n    top: 0;\n    padding: 0;\n    margin: 0;\n    height: inherit;\n    font-size: inherit;\n    line-height: @ui-tab-height;\n    color: @tab-text-color;\n    background-color: @tab-background-color;\n    box-shadow: inherit;\n    border-left: @tab-border;\n    &.active {\n      color: @tab-text-color-active;\n      background-color: @tab-background-color-active;\n      box-shadow: none;\n    }\n    &:first-of-type {\n      border-left-color: transparent;\n    }\n    &:last-of-type {\n      // use box-shadow to not take up any space\n      box-shadow: inset 0 -1px 0 @tab-border-color, 1px 0 0 @base-border-color;\n    }\n    &.active:last-of-type {\n      box-shadow: 1px 0 0 @base-border-color;\n    }\n\n\n    // Title ----------------------\n\n    .title {\n      text-align: center;\n      margin: 0 @title-padding;\n    }\n\n    // VCS coloring ----------------------\n    &:not(.active) .status-added    { color: @tab-inactive-status-added; }\n    &:not(.active) .status-modified { color: @tab-inactive-status-modified; }\n\n\n    // Icons ----------------------\n\n    .title.title:before {\n      margin-right: .3em;\n      width: auto;\n      height: auto;\n      line-height: 1;\n      font-size: 1.125em;\n      vertical-align: -.0625em; // Adjust center for the 0.1em font-size increase\n    }\n\n    // Close icon ----------------------\n\n    .close-icon {\n      top: @icon-padding-top;\n      right: @icon-padding-right;\n      z-index: 2;\n      font-size: 1em;\n      width: 1.5em;\n      height: 1.5em;\n      line-height: 1.5;\n      text-align: center;\n      border-radius: @component-border-radius;\n      background-color: inherit;\n      overflow: hidden;\n      transform: scale(0);\n      transition: transform .08s;\n      &:hover {\n        color: @accent-text-color;\n        background-color: @accent-color;\n      }\n      &:active {\n        background-color: fade(@accent-color, 50%);\n      }\n      &::before {\n        z-index: 1;\n        font-size: 1.1em;\n        vertical-align: -.05em; // Adjust center for the 0.1em font-size increase\n        width: auto;\n        height: auto;\n        pointer-events: none;\n      }\n    }\n    &:hover .close-icon {\n      transform: scale(1);\n      transition-duration: .16s;\n    }\n  }\n\n  // Modified icon ----------------------\n\n  .tab.modified {\n    &:hover .close-icon {\n      color: @accent-color;\n      &:hover {\n        color: @accent-bg-text-color;\n      }\n    }\n    &:not(:hover) .close-icon {\n      top: @icon-padding-top;\n      right: @icon-padding-right;\n      width: 1.5em;\n      height: 1.5em;\n      line-height: 1.5;\n      color: @accent-color;\n      border-radius: @component-border-radius;\n      border: none;\n      transform: scale(1);\n      &::before {\n        content: "\\f052";\n        display: inline-block;\n      }\n    }\n  }\n\n\n  // Tabs in the docks ----------------------\n\n  atom-dock & {\n    .tab.active {\n      background-color: @tool-panel-background-color;\n    }\n  }\n\n\n  // Dragging ----------------------\n\n  .tab.is-dragging {\n    opacity: .5;\n\n    .close-icon,\n    &:before {\n      visibility: hidden;\n    }\n  }\n\n  .placeholder {\n    position: relative;\n    pointer-events: none;\n\n    // bar\n    &:before {\n      z-index: 1;\n      margin: 0;\n      width: 2px;\n      height: @ui-tab-height;\n      background-color: @accent-color;\n    }\n\n    // arrow\n    &:after {\n      z-index: 0;\n      top: @ui-tab-height/2;\n      margin: -4px 0 0 -3px;\n      border-radius: 0;\n      border: 4px solid @accent-color;\n      transform: rotate(45deg);\n      background: transparent;\n    }\n\n    &:last-child {\n      &:before {\n        margin-left: -2px;\n      }\n      &:after {\n        transform: none;\n        margin-left: -10px;\n        border-color: transparent @accent-color transparent transparent;\n      }\n    }\n  }\n\n\n  // Overrides ----------------------\n\n  // keep tabs same size when active\n  .tab,\n  .tab.active {\n    padding-right: 0;\n    .title {\n      padding: 0;\n    }\n  }\n}\n\n\n// Active/focused pane marker --------------\n\natom-pane-axis > atom-pane.active,\natom-pane-container > atom-pane.pane {\n  .tab.active:before {\n    content: "";\n    position: absolute;\n    pointer-events: none;\n    z-index: 2;\n    top: 0;\n    left: -1px; // cover left border\n    bottom: 0;\n    width: 2px;\n    background: mix(@text-color, @tab-background-color-editor, 33%);\n  }\n}\n.pane:focus-within {\n  .tab.active:before {\n    background: @accent-color;\n  }\n}\n\n// hide marker in docks\natom-dock .tab-bar .tab::before {\n  display: none;\n}\n\n\n// Custom tabs --------------\n\n.tab-bar .tab.active {\n  &[data-type$="Editor"],\n  &[data-type$="AboutView"],\n  &[data-type$="TimecopView"],\n  &[data-type$="StyleguideView"],\n  &[data-type="MarkdownPreviewView"] {\n    color: @tab-text-color-editor;\n    background-color: @tab-background-color-editor; // Match syntax background color\n  }\n}\n',digest:"f1225dd163b31414ccc77fcf06c883ae94f53dae"},"node_modules/one-dark-ui/styles/text.less":{content:"h1,\nh2,\nh3 {\n  line-height: 1em;\n  margin-bottom: 15px\n}\nh1 { font-size: 2em; }\nh2 { font-size: 1.5em; }\nh3 { font-size: 1.2em; }\n\np {\n  line-height: 1.6;\n  margin-bottom: 15px;\n}\n\nlabel {\n  font-weight: normal;\n}\n\npre {\n  box-shadow: none;\n  color: @text-color;\n  background: @inset-panel-background-color;\n  border-radius: @component-border-radius;\n  border: none;\n  margin: 0;\n}\n\ncode {\n  .text(highlight);\n  background: @background-color-highlight;\n  border-radius: @component-border-radius;\n}\n\n.selected { .text(highlight); }\n\n.text-smaller { font-size: 0.9em; }\n\n.text-subtle { .text(subtle); }\n.text-highlight { .text(highlight); }\n\n.text-error { .text(error); }\n.text-info {\n  .text(info);\n  &:hover { color: @text-color-info; }\n}\n.text-warning {\n  .text(warning);\n  &:hover { color: @text-color-warning; }\n}\n.text-success {\n  .text(success);\n  &:hover { color: @text-color-success; }\n}\n\n.highlight-mixin {\n  padding: 1px 4px;\n  border-radius: 2px;\n}\n\n.highlight {\n  .highlight-mixin();\n  font-weight: 700;\n  color: @text-color-highlight;\n  background-color: @background-color-highlight;\n}\n\n.highlight-color(@name, @background-color) {\n  .highlight-@{name} {\n    .highlight-mixin();\n    font-weight: 500;\n    color: white;\n    text-shadow: 0 1px 0px hsla(0,0%,0%,.2);\n    background-color: @background-color;\n  }\n}\n.highlight-color(   info, @background-color-info);\n.highlight-color(warning, @background-color-warning);\n.highlight-color(  error, @background-color-error);\n.highlight-color(success, @background-color-success);\n\n.results-view .path-details.list-item {\n  color: darken(@text-color-highlight, 18%);\n}\n",digest:"38471280be8bb348914ba7bf07bd03405facbd14"},"node_modules/one-dark-ui/styles/title-bar.less":{content:".title-bar {\n  height: 22px; // remove 1px since there is no border\n  border-bottom: none;\n}\n",digest:"93638036e200a218636d7f1cdb32276c0c04ce0c"},"node_modules/one-dark-ui/styles/tooltips.less":{content:".tooltip {\n  white-space: nowrap;\n  font-size: @ui-size*1.15;\n\n  &.in {\n    opacity: 1;\n    transition: opacity .12s ease-out;\n  }\n\n  .tooltip-inner {\n    line-height: 1;\n    padding: @ui-padding*.5 @ui-padding*.65;\n    border-radius: @component-border-radius;\n    background-color: @tooltip-background-color;\n    color: @tooltip-text-color;\n    white-space: nowrap;\n    max-width: none;\n  }\n\n  .keystroke {\n    font-size: max(1em, @ui-size*.85);\n    padding: .1em .4em;\n    margin: 0 @ui-padding*-.35 0 @ui-padding*.25;\n    border-radius: max(2px, @component-border-radius / 2);\n    color: @tooltip-text-key-color;\n    background: @tooltip-background-key-color;\n  }\n\n  &.top .tooltip-arrow {\n    border-top-color: @tooltip-background-color;\n  }\n  &.top-left .tooltip-arrow {\n    border-top-color: @tooltip-background-color;\n  }\n  &.top-right .tooltip-arrow {\n    border-top-color: @tooltip-background-color;\n  }\n  &.right .tooltip-arrow {\n    border-right-color: @tooltip-background-color;\n  }\n  &.left .tooltip-arrow {\n    border-left-color: @tooltip-background-color;\n  }\n  &.bottom .tooltip-arrow {\n    border-bottom-color: @tooltip-background-color;\n  }\n  &.bottom-left .tooltip-arrow {\n    border-bottom-color: @tooltip-background-color;\n  }\n  &.bottom-right .tooltip-arrow {\n    border-bottom-color: @tooltip-background-color;\n  }\n}\n",digest:"d04c888a4ae472d7609d5ae9db25e2ded92049cc"},"node_modules/one-dark-ui/styles/tree-view.less":{content:"@tree-view-height: @ui-line-height;\n\n.tree-view {\n  font-size: @ui-size;\n  background: @tree-view-background-color;\n\n  .project-root.project-root {\n    &:before {\n      height: @ui-tab-height;\n      background-clip: padding-box;\n    }\n    & > .header .name {\n      line-height: @ui-tab-height;\n    }\n  }\n\n  // Selected state\n  .selected:before {\n    background: @background-color-selected;\n  }\n\n  // Focus + selected state\n  &:focus {\n    .selected.list-item > .name, // files\n    .selected.list-nested-item > .list-item > .name, // folders\n    .selected.list-nested-item > .header:before { // arrow icon\n      color: contrast(@button-background-color-selected);\n    }\n    .selected:before {\n      background: @button-background-color-selected;\n    }\n  }\n}\n\n.theme-one-dark-ui .tree-view .project-root.project-root::before {\n  border-top: 1px solid transparent;\n  background-clip: padding-box;\n}\n\n.tree-view-resizer {\n  .tree-view-resize-handle {\n    width: 8px;\n  }\n}\n\n// Variable height, based on ems\n.list-group li:not(.list-nested-item),\n.list-tree li:not(.list-nested-item),\n.list-group li.list-nested-item > .list-item,\n.list-tree li.list-nested-item > .list-item {\n  line-height: @tree-view-height;\n}\n\n.list-group .selected::before,\n.list-tree .selected::before {\n  height: @tree-view-height;\n}\n\n// icon\n.list-group .icon,\n.list-tree .icon {\n  display: inline-block;\n  height: inherit;\n  &::before {\n    top: initial;\n    line-height: inherit;\n    height: inherit;\n    vertical-align: top;\n  }\n}\n\n// Arrow icon\n.list-group,\n.list-tree {\n  .header.header.header.header::before {\n    top: initial;\n    line-height: inherit;\n    height: inherit;\n    vertical-align: top;\n    font-size: inherit;\n  }\n}\n.tree-view .project-root-header.project-root-header.project-root-header.project-root-header::before {\n  line-height: @ui-tab-height;\n}\n",digest:"c5fdec6ed1e5aa4809d3464f7e0f197d440cbc44"},"node_modules/one-dark-ui/styles/ui-mixins.less":{content:"// Pattern matching; ish is cray.\n// http://lesscss.org/#-pattern-matching-and-guard-expressions\n\n.text(normal) {\n  font-weight: normal;\n  color: @text-color;\n}\n.text(subtle) {\n  font-weight: normal;\n  color: @text-color-subtle;\n}\n.text(highlight) {\n  font-weight: normal;\n  color: @text-color-highlight;\n}\n.text(selected) {\n  .text(highlight)\n}\n\n.text(info) {\n  color: @text-color-info;\n}\n.text(success) {\n  color: @text-color-success;\n}\n.text(warning) {\n  color: @text-color-warning;\n}\n.text(error) {\n  color: @text-color-error;\n}\n\n.focus() {\n  outline: none;\n  border-color: @accent-color;\n  box-shadow: 0 0 0 1px @accent-color;\n}\n\n.valid() {\n  border-color: @text-color-success;\n  box-shadow: 0 0 0 1px @text-color-success;\n  background-color: mix(@text-color-success, @input-background-color, 10%);\n}\n\n.invalid() {\n  border-color: @text-color-error;\n  box-shadow: 0 0 0 1px @text-color-error;\n  background-color: mix(@text-color-error, @input-background-color, 10%);\n}\n",digest:"1d69d3145b45e0f9497cfa8a8b95a95fcae3b937"},"node_modules/one-dark-ui/styles/ui-variables-custom.less":{content:'\n// ONE dark UI colors\n// ----------------------------------------------\n\n@import "syntax-variables";\n\n.ui-syntax-color() { @syntax-background-color: hsl(220,24%,20%); } .ui-syntax-color(); // fallback color\n@ui-syntax-color: @syntax-background-color;\n\n// Color guards -----------------\n@ui-s-h: hue(@ui-syntax-color);\n@ui-s-s: saturation(@ui-syntax-color);\n@ui-s-l: lightness(@ui-syntax-color);\n@ui-inv: 10%; // inverse lightness if below\n\n.ui-hue() when (@ui-s-s = 0) { @ui-hue: 220; } // Use blue hue when no saturation\n.ui-hue() when (@ui-s-s > 0) { @ui-hue: @ui-s-h; }\n.ui-hue();\n\n.ui-saturation() when (@ui-s-h <=  80) { @ui-saturation: min(@ui-s-s,  5%); } // minimize saturation for brown\n.ui-saturation() when (@ui-s-h >   80) and (@ui-s-h <  160) { @ui-saturation: min(@ui-s-s, 12%); } // reduce saturation for green\n.ui-saturation() when (@ui-s-h >= 160) and (@ui-s-l <  @ui-inv) { @ui-saturation: min(@ui-s-s, 48%); } // limit max saturation for very dark backgrounds\n.ui-saturation() when (@ui-s-h >= 160) and (@ui-s-l >= @ui-inv) { @ui-saturation: @ui-s-s; }\n.ui-saturation();\n\n.ui-lightness() when (@ui-s-l <  @ui-inv) {\n  @ui-lightness: @ui-s-l + 8%; // increase lightness when too dark\n  @ui-lightness-border: @ui-lightness*.3;\n}\n.ui-lightness() when (@ui-s-l >= @ui-inv) {\n  @ui-lightness: min(@ui-s-l, 20%); // limit max lightness (for light syntax themes)\n  @ui-lightness-border: @ui-lightness*.6;\n}\n.ui-lightness();\n\n// Main colors -----------------\n@ui-fg:     hsl(@ui-hue, min(@ui-saturation, 18%), max(@ui-lightness*3, 66%) );\n@ui-bg:     hsl(@ui-hue, @ui-saturation, @ui-lightness); // normalized @syntax-background-color\n@ui-border: hsl(@ui-hue, @ui-saturation, @ui-lightness-border);\n\n\n\n\n// Custom variables\n// These variables are only used in this theme\n// ----------------------------------------------\n\n@ui-theme-name: one-dark-ui;\n\n// Text (Custom) -----------------\n@text-color-faded: fade(@text-color, 20%);\n\n@text-color-added:    @text-color-success;  // green\n@text-color-ignored:  @text-color-subtle;   // faded\n@text-color-modified: @text-color-warning;  // orange\n@text-color-removed:  @text-color-error;    // red\n@text-color-renamed:  @text-color-info;     // blue\n\n\n// Background (Custom) -----------------\n@level-1-color: lighten(@base-background-color, 6%);\n@level-2-color: @base-background-color;\n@level-3-color: darken(@base-background-color, 3%);\n\n@level-3-color-hover:  lighten(@level-3-color, 6%);\n@level-3-color-active: lighten(@level-3-color, 3%);\n\n\n// Accent (Custom) -----------------\n@accent-luma:             luma( hsl(@ui-hue, 50%, 50%) ); // get lightness of current hue\n\n// used for marker, inputs (smaller things)\n@accent-color:            mix( hsv( @ui-hue, 100%, 66%), hsl( @ui-hue, 100%, 70%), @accent-luma ); // mix hsv + hsl (favor mostly hsl)\n@accent-text-color:       contrast(@accent-color, hsl(@ui-hue,100%,10%), #fff, 25% );\n\n// used for button, tooltip (larger things)\n@accent-bg-color:         mix( hsv( @ui-hue, 66%, 66%), hsl( @ui-hue, 66%, 60%), @accent-luma * 2 ); // mix hsv + hsl (favor hsl for dark, hsv for light colors)\n@accent-bg-text-color:    contrast(@accent-bg-color, hsl(@ui-hue,100%,10%), #fff, 30% );\n\n// used for text only\n@accent-only-text-color: mix( hsv( @ui-hue, 100%, 66%), hsl( @ui-hue, 100%, 77%), @accent-luma ); // mix hsv + hsl (favor mostly hsl)\n\n// Components (Custom) -----------------\n@badge-background-color:            lighten(@background-color-highlight, 6%);\n\n@button-text-color-selected:        @accent-bg-text-color;\n@button-border-color-selected:      @base-border-color;\n\n@checkbox-background-color:         fade(@accent-bg-color, 33%);\n\n@input-background-color-focus:      mix(@accent-bg-color, @input-background-color, 10%);\n@input-selection-color:             mix(@accent-color, @input-background-color, 25%);\n@input-selection-color-focus:       mix(@accent-color, @input-background-color, 50%);\n\n@overlay-backdrop-color:            hsl(@ui-hue, @ui-saturation, @ui-lightness*0.2);\n@overlay-backdrop-opacity:          .75;\n\n@progress-background-color:         @accent-color;\n\n@scrollbar-color:                   lighten(@ui-syntax-color, 16%);\n@scrollbar-background-color:        @level-3-color; // replaced `transparent` with a solid color to test https://github.com/atom/one-light-ui/issues/4\n@scrollbar-color-editor:            lighten(@ui-syntax-color, 16%);\n@scrollbar-background-color-editor: @ui-syntax-color;\n\n\n@tab-text-color:                    @text-color-subtle;\n@tab-text-color-active:             @text-color-highlight;\n@tab-text-color-editor:             contrast(@ui-syntax-color, darken(@ui-syntax-color, 50%), @text-color-highlight );\n@tab-background-color-editor:       @ui-syntax-color;\n@tab-inactive-status-added:         fade(@text-color-success, 55%);\n@tab-inactive-status-modified:      fade(@text-color-warning, 55%);\n\n\n@tooltip-background-color:          @accent-bg-color;\n@tooltip-text-color:                @accent-bg-text-color;\n@tooltip-text-key-color:            @tooltip-background-color;\n@tooltip-background-key-color:      @tooltip-text-color;\n\n\n// Sizes (Custom) -----------------\n\n@ui-size:                 1em;\n@ui-input-size:           @ui-size*1.15;\n@ui-padding:              @ui-size*1.5;\n@ui-padding-pane:         @ui-size*.5;\n@ui-padding-icon:         @ui-padding/3.3;\n@ui-line-height:          @ui-size*2;\n@ui-tab-height:           @ui-size*2.5;\n\n\n\n\n// Packages variables\n// These variables are used to override packages\n// ----------------------------------------------\n\n@settings-list-background-color: darken(@level-2-color, 1.5%);\n@theme-config-box-shadow: inset 0 0 3px hsla(0, 0%, 100%, .4), 0 1px 3px hsla(0, 0%, 0%, .2);\n@theme-config-box-shadow-selected: inset 0 1px 3px hsla(0, 0%, 0%, .1);\n@theme-config-border-selected: hsla(0, 0%, 100%, .75);\n\n\n\n// Debug\n// Output variables to the top of the UI\n// -------------------------------------\n\n// html:before {\n//   content: "@{variable}";\n// }\n',digest:"912cd9b31c4db8b551f47b4d0ced938a6b62dc95"},"node_modules/one-dark-ui/styles/ui-variables.less":{content:'\n@import "ui-variables-custom.less"; // import colors and custom variables\n\n// ONE dark UI variables\n// ----------------------------------------------\n\n// Official variables\n// These variables must be defined in every theme\n// Source: https://github.com/atom/atom/blob/master/static/variables/ui-variables.less\n// ----------------------------------------------\n\n\n// Text -----------------\n@text-color:            @ui-fg;\n@text-color-subtle:     fadeout(@text-color, 40%);\n@text-color-highlight:  lighten(@text-color, 20%);\n@text-color-selected:   white;\n\n@text-color-info:    hsl(219,  79%, 66%);\n@text-color-success: hsl(140,  44%, 62%);\n@text-color-warning: hsl( 36,  60%, 72%);\n@text-color-error:   hsl(  9, 100%, 64%);\n\n\n// Background -----------------\n@background-color-info:    hsl(208, 88%, 48%);\n@background-color-success: hsl(132, 58%, 40%);\n@background-color-warning: hsl( 42, 88%, 36%);\n@background-color-error:   hsl(  5, 64%, 50%);\n\n@background-color-highlight: lighten(@base-background-color, 4%);\n@background-color-selected:  lighten(@base-background-color, 8%);\n\n@app-background-color: @level-3-color;\n\n\n// Base -----------------\n@base-background-color: @ui-bg;\n@base-border-color:     @ui-border;\n\n\n// Components -----------------\n@pane-item-background-color:       @base-background-color;\n@pane-item-border-color:           @base-border-color;\n\n@input-background-color:           darken(@base-background-color, 6%);\n@input-border-color:               @base-border-color;\n\n@tool-panel-background-color:      @level-3-color;\n@tool-panel-border-color:          @base-border-color;\n\n@inset-panel-background-color:     lighten(@level-2-color, 4%);\n@inset-panel-border-color:         fadeout(@base-border-color, 15%);\n\n@panel-heading-background-color:   @level-2-color;\n@panel-heading-border-color:       @base-border-color;\n\n@overlay-background-color:         mix(@level-2-color, @level-3-color);\n@overlay-border-color:             @base-border-color;\n\n@button-background-color:          @level-1-color;\n@button-background-color-hover:    lighten(@button-background-color, 2%);\n@button-background-color-selected: @accent-bg-color;\n@button-border-color:              @base-border-color;\n\n@tab-bar-background-color:         @level-3-color;\n@tab-bar-border-color:             @base-border-color;\n@tab-background-color:             @level-3-color;\n@tab-background-color-active:      @level-2-color;\n@tab-border-color:                 @base-border-color;\n\n@tree-view-background-color:       @level-3-color;\n@tree-view-border-color:           @base-border-color;\n\n@ui-site-color-1: hsl(208, 100%, 50%); // blue\n@ui-site-color-2: hsl(160,  70%, 42%); // green\n@ui-site-color-3: hsl(32,   60%, 50%); // orange\n@ui-site-color-4: #D831B0;             // pink\n@ui-site-color-5: #EBDD5B;             // yellow\n\n\n// Sizes -----------------\n@font-size:               12px;\n@input-font-size:         14px;\n@disclosure-arrow-size:   12px;\n\n@component-padding:       10px;\n@component-icon-padding:  5px;\n@component-icon-size:     16px; // needs to stay 16px to look sharpest\n@component-line-height:   25px;\n@component-border-radius: 3px;\n\n@tab-height:              30px;\n\n\n// Font -----------------\n@font-family: system-ui;\n',digest:"f0cd54bb3195577225c676e2ba1a5f91fdd4a1ab"},"node_modules/one-light-ui/index.less":{content:'@import "variables/ui-variables";\n@import "variables/syntax-variables";\n\n// Atom UI Theme: One\n\n@import "styles/ui-variables.less";\n@import "styles/ui-mixins.less";\n@import "octicon-mixins.less"; // https://github.com/atom/atom/blob/master/static/variables/octicon-mixins.less\n\n@import "styles/atom.less";\n@import "styles/badges.less";\n@import "styles/buttons.less";\n@import "styles/docks.less";\n@import "styles/editor.less";\n@import "styles/git.less";\n@import "styles/inputs.less";\n@import "styles/lists.less";\n@import "styles/messages.less";\n@import "styles/nav.less";\n@import "styles/notifications.less";\n@import "styles/modal.less";\n@import "styles/panels.less";\n@import "styles/panes.less";\n@import "styles/progress.less";\n@import "styles/tabs.less";\n@import "styles/text.less";\n@import "styles/title-bar.less";\n@import "styles/tooltips.less";\n@import "styles/tree-view.less";\n@import "styles/status-bar.less";\n@import "styles/key-binding.less";\n@import "styles/sites.less";\n\n@import "styles/settings.less";\n@import "styles/packages.less";\n@import "styles/core.less";\n@import "styles/config.less";\n',digest:"9ae52af555fe1bcd2721d52c1539ca092a07aafa"},"node_modules/one-light-ui/styles/atom.less":{content:"* {\n\tbox-sizing: border-box;\n}\n\nhtml {\n\tfont-size: @font-size;\n}\n\natom-workspace {\n\tbackground-color: @app-background-color;\n}\n\n\n// Scrollbars ------------------------------------\n\n.scrollbars-visible-always {\n\t::-webkit-scrollbar {\n\t\twidth: 10px;\n\t\theight: 10px;\n\t}\n\n\t::-webkit-scrollbar-track {\n\t\tbackground: @scrollbar-background-color;\n\t}\n\n\t::-webkit-scrollbar-thumb {\n\t\tborder-radius: 5px;\n\t\tborder: 3px solid @scrollbar-background-color;\n\t\tbackground: @scrollbar-color;\n\t\tbackground-clip: content-box;\n\t}\n\n\t::-webkit-scrollbar-corner {\n\t\tbackground: @scrollbar-background-color;\n\t}\n\n\t::-webkit-scrollbar-thumb:vertical:active {\n\t\tborder-radius: 0;\n\t\tborder-left-width: 0;\n\t\tborder-right-width: 0;\n\t}\n\n\t::-webkit-scrollbar-thumb:horizontal:active {\n\t\tborder-radius: 0;\n\t\tborder-top-width: 0;\n\t\tborder-bottom-width: 0;\n\t}\n\n\tatom-text-editor {\n\t\t::-webkit-scrollbar-track {\n\t\t\tbackground: @scrollbar-background-color-editor;\n\t\t}\n\t\t::-webkit-scrollbar-corner {\n\t\t\tbackground: @scrollbar-background-color-editor;\n\t\t}\n\t\t::-webkit-scrollbar-thumb {\n\t\t\tborder-color: @scrollbar-background-color-editor;\n\t\t\tbackground: @scrollbar-color-editor;\n\t\t}\n\t}\n}\n\n// TODO: Move to a better place, not sure where it gets used\n.caret {\n  border-top: 5px solid #fff;\n  margin-top: -1px;\n}\n",digest:"df4447499593550b61146e7af8d0f4cd17991112"},"node_modules/one-light-ui/styles/badges.less":{content:".badge {\n  padding: @ui-padding/4 @ui-padding/2.5;\n  min-width: @ui-padding*1.25;\n  .text(highlight);\n  border-radius: @ui-size*2;\n  background-color: @badge-background-color;\n\n  // Icon ----------------------\n  &.icon {\n    font-size: @ui-size;\n    padding: @ui-padding-icon @ui-padding-icon*1.5;\n  }\n\n}\n",digest:"bfb1f9e90af654b5baa53d74c36628140507a3f7"},"node_modules/one-light-ui/styles/buttons.less":{content:"\n@btn-border: 1px solid @button-border-color;\n@btn-padding: 0 @ui-size/1.25;\n\n// Mixins -----------------------\n\n.btn-default (@color, @hover-color, @selected-color, @text-color) {\n  color: @text-color;\n  text-shadow: none;\n  border: @btn-border;\n  background-color: @color;\n  background-image: linear-gradient(lighten(@color, 2%), @color);\n\n  &:hover {\n    color: @text-color-highlight;\n    background-image: linear-gradient(lighten(@hover-color, 2%), @hover-color);\n  }\n  &:active {\n    background: darken(@color, 4%);\n    box-shadow: none;\n  }\n  &.selected {\n    background: @selected-color;\n  }\n  &.selected:focus,\n  &.selected:hover {\n    background: lighten(@selected-color, 2%);\n  }\n  &:focus {\n    .focus(); // unfortunately :focus styles stay even after releasing mouse.\n  }\n}\n\n.btn-variant (@color) {\n  @_text-color: contrast(@color, white, hsl(0,0%,20%), 33% );\n  .btn-default(\n    @color,\n    lighten(@color, 3%),\n    saturate(darken(@color, 12%), 20%),\n    @text-color-highlight\n  );\n  color: @_text-color;\n\n  & when (@ui-lightness > 50%) {\n    border-color: transparent; // hide border on light backgrounds\n  }\n\n  &:hover,\n  &:focus {\n    color: @_text-color;\n  }\n  &:focus {\n    border-color: transparent;\n    background-clip: padding-box;\n    box-shadow: inset 0 0 0 1px fade(@base-border-color, 50%), 0 0 0 1px @color;\n  }\n\n  &.icon:before {\n    color: @_text-color;\n  }\n}\n\n\n// Buttons -----------------------\n\n.btn {\n  height: initial;\n  padding: @btn-padding;\n  font-size: @ui-size;\n  line-height: @ui-line-height;\n}\n\n.btn,\n.btn.btn-default {\n  .btn-default(@button-background-color, @button-background-color-hover, @button-background-color-selected, @text-color);\n}\n\n.btn.btn-primary {\n  .btn-variant(@accent-bg-color);\n}\n.btn.btn-info {\n  .btn-variant(@background-color-info);\n}\n.btn.btn-success {\n  .btn-variant(@background-color-success);\n}\n.btn.btn-warning {\n  .btn-variant(@background-color-warning);\n}\n.btn.btn-error {\n  .btn-variant(@background-color-error);\n}\n\n\n// Button Sizes -----------------------\n\n.btn.btn-xs,\n.btn-group-xs > .btn {\n  font-size: @ui-size*.8;\n  line-height: @ui-line-height;\n  padding: @btn-padding;\n}\n.btn.btn-sm,\n.btn-group-sm > .btn {\n  font-size: @ui-size*.9;\n  line-height: @ui-line-height;\n  padding: @btn-padding;\n}\n.btn.btn-lg,\n.btn-group-lg > .btn {\n  font-size: @ui-size * 1.5;\n  line-height: @ui-line-height;\n  padding: @btn-padding;\n}\n\n\n// Button Group -----------------------\n\n.btn-group > .btn {\n  z-index: 0;\n  &:hover {\n    z-index: 0;\n  }\n  &.btn:focus {\n    z-index: 1;\n    .focus();\n  }\n\n  &:first-child {\n    border-left: @btn-border;\n  }\n  &:last-child,\n  &.selected:last-child {\n    border-right: @btn-border;\n  }\n\n  // hide border on light backgrounds\n  & when (@ui-lightness > 50%) {\n    &.btn-primary:first-child,\n    &.btn-info:first-child,\n    &.btn-success:first-child,\n    &.btn-warning:first-child,\n    &.btn-error:first-child {\n      border-left-color: transparent;\n    }\n\n    &.btn-primary:last-child,\n    &.btn-info:last-child,\n    &.btn-success:last-child,\n    &.btn-warning:last-child,\n    &.btn-error:last-child {\n      border-right-color: transparent;\n    }\n  }\n\n  &.selected,\n  &.selected:first-child,\n  &.selected:last-child {\n    color: @button-text-color-selected;\n    border-color: @button-border-color-selected;\n  }\n\n  & when (@ui-lightness > 50%) {\n    &.selected + .btn {\n      border-left-color: @button-border-color-selected;\n    }\n    &.selected + .selected {\n      border-left-color: mix(@button-border-color, @button-border-color-selected);\n    }\n  }\n\n  &.selected:focus {\n    border-color: @button-background-color-selected;\n    box-shadow: inset 0 0 0 1px fade(@base-border-color, 50%), 0 0 0 1px @button-background-color-selected;\n  }\n}\n\n\n// Button Icons -----------------------\n\n.btn.icon:before {\n  width: auto;\n  height: auto;\n  font-size: 1.333333em;\n  vertical-align: -.1em;\n}\n",digest:"771f75f5f119b4282fb0980b2c492e5cf15ad5d3"},"node_modules/one-light-ui/styles/config.less":{content:'\n// Theme config\n// This gets changed from the theme settings\n\n@theme-tabsizing: ~\'theme-@{ui-theme-name}-tabsizing\';\n@theme-dockButtons: ~\'theme-@{ui-theme-name}-dock-buttons\';\n@theme-stickyHeaders: ~\'theme-@{ui-theme-name}-sticky-headers\';\n@theme-closeButton: ~\'theme-@{ui-theme-name}-tab-close-button\';\n\n\n// Tabs ----------------------------------------------\n\n@tab-min-width: 7em; // ~ icon + 6 characters\n\n// Even (default)\n\n.tab-bar {\n  .tab,\n  .tab.active {\n    flex: 1 1 0;\n    max-width: 22em;\n    min-width: @tab-min-width;\n  }\n  atom-dock & {\n    .tab,\n    .tab.active {\n      max-width: none;\n    }\n  }\n\n  // TODO: Turn this into a config\n  // Truncates the beginning instead\n  // .title.title.title {\n  //   direction: rtl; // change direction\n  // }\n}\n\n\n// Maximum (full width)\n\n[@{theme-tabsizing}="maximum"] .tab-bar {\n  .tab,\n  .tab.active {\n    max-width: none;\n  }\n}\n\n\n// Minimum (show long paths)\n\n[@{theme-tabsizing}="minimum"] .tab-bar {\n  .tab,\n  .tab.active {\n    flex: 0 0 auto;\n    min-width: 2.75em;\n    max-width: @tab-min-width * 3.3;\n  }\n  atom-dock {\n    .tab,\n    .tab.active {\n      max-width: @tab-min-width * 2;\n    }\n  }\n}\n\n\n// Tabs: close button position  ------------------------------\n\n[@{theme-closeButton}="left"] {\n\n  .tab-bar .tab {\n    .close-icon {\n      right: auto;\n      left: @icon-padding-right;\n    }\n  }\n\n}\n\n\n// Hide docks toggle buttons ------------------------------\n\n[@{theme-dockButtons}="hidden"] {\n\n  // Hide docks when not open\n  .atom-dock-inner:not(.atom-dock-open) {\n    display: none;\n  }\n\n  // Hide toggle buttons\n  .atom-dock-toggle-button {\n    display: none;\n  }\n\n}\n\n\n// Sticky Projects ------------------------------\n\n[@{theme-stickyHeaders}="sticky"] {\n\n  .tree-view {\n    .project-root-header {\n      position: sticky;\n      top: 0;\n      z-index: 3;\n      padding-left: 5px;\n      padding-right: 10px;\n      border-bottom: 1px solid @base-border-color;\n      background-color: @tree-view-background-color;\n    }\n    .project-root.project-root {\n      margin-left: -5px;\n      margin-right: -10px;\n\n      // Disable selection\n      &::before {\n        display: none;\n      }\n\n      // Add selection back\n      &.selected .project-root-header {\n        background-color: @background-color-selected;\n      }\n    }\n    &:focus .selected .project-root-header.project-root-header  {\n      background: @button-background-color-selected;\n    }\n\n    // Fix sticky header from covering auto-revealed files\n    .entry.file.selected {\n      padding-top: @ui-tab-height;\n      margin-top: -@ui-tab-height;\n    }\n\n    // Fix sticky header from covering auto-revealed directories when using up/down keys\n    // for directories, scroll test moves to .header, see https://github.com/atom/tree-view/blob/d2857ad4d7eeb7dad5cf94b33257a8740211480e/lib/tree-view.coffee#L839\n    .entry.directory.selected:not(.project-root) {\n      & > .header {\n        padding-top: @ui-tab-height;\n        margin-top: -@ui-tab-height;\n      }\n      &::before {\n        margin-top: @ui-tab-height;\n      }\n    }\n\n    // Fix above directory is not being clickable\n    .entry.directory:not(.project-root) > .header {\n      z-index: 2;\n    }\n    .entry.directory.selected:not(.project-root) > .header {\n      z-index: 1;\n    }\n  }\n}\n',digest:"fcb29fb84c0b7aa85e8f68043418f04198a637b2"},"node_modules/one-light-ui/styles/core.less":{content:"// Misc\n\n.preview-pane .results-view .path-match-number {\n  // show number also on selected item\n  color: inherit;\n  opacity: .6;\n}\n\n.tool-panel.incompatible-packages {\n  // incompatible-packages isn't really a tool-panel and more a whole pane\n  .text(normal);\n  background-color: @level-2-color;\n}\n\n// Styleguide ----------------------------------------------\n\n.styleguide {\n  // Modal\n  atom-panel.modal:after {\n    position: absolute;  // prevent overlay backdrop from leaking outside\n    left: -@ui-padding;\n    right: -@ui-padding;\n    bottom: -@ui-padding;\n  }\n}\n",digest:"4ba9309f9e37001066e7f31b17f9ff985741a298"},"node_modules/one-light-ui/styles/docks.less":{content:"\n// Docks ------------------------------\n\n// Make handles not take up any space when dock is open\n.atom-dock-resize-handle {\n  position: absolute;\n  z-index: 11; // same as toggle buttons\n\n  &.left {\n    top: 0;\n    right: 0;\n    bottom: 0;\n  }\n  &.right {\n    top: 0;\n    left: 0;\n    bottom: 0;\n  }\n  &.bottom {\n    top: 0;\n    left: 0;\n    right: 0;\n  }\n}\n\n// Add borders\n.atom-dock-inner.atom-dock-open.left {\n  border-right: 1px solid @base-border-color;\n}\n.atom-dock-inner.atom-dock-open.right {\n  border-left: 1px solid @base-border-color;\n}\n\n// Make toggle buttons cover ^ border\n.atom-dock-toggle-button.left {\n  margin-left: -2px;\n}\n.atom-dock-toggle-button.right {\n  margin-right: -2px;\n}\n.atom-dock-inner:not(.atom-dock-open) .atom-dock-toggle-button.bottom {\n  margin-bottom: -1px;\n}\n",digest:"fe5ca63b2ddbf1b6a581c394ddf11859fd44db08"},"node_modules/one-light-ui/styles/dropdowns.less":{content:".dropdown-menu {\n  background-color: @overlay-background-color;\n  border-radius: @component-border-radius;\n  border: 1px solid @base-border-color;\n  padding: 0;\n\n  > li > a {\n    .text(normal);\n  }\n\n  > li > a:hover {\n    .text(highlight);\n    background-color: @background-color-highlight;\n  }\n}\n",digest:"344a6a3a32a0e115652f60c7626fc93e1d2220c1"},"node_modules/one-light-ui/styles/editor.less":{content:"\n// Editor in a panel\n\n// TODO: Find a better selector, maybe a new class like atom-text-editor[medium]\natom-panel-container atom-text-editor.is-focused {\n  .focus();\n}\n\n\n// Mini\n// Usually just single line inputs\n\natom-text-editor[mini] {\n  overflow: auto;\n  font-size: @ui-input-size;\n  line-height: @ui-line-height;\n  max-height: @ui-line-height * 5; // rows\n  padding-left: @ui-padding/3;\n  border-radius: @component-border-radius;\n  color: @text-color-highlight;\n  border: 1px solid @input-border-color;\n  background-color: @input-background-color;\n\n  .placeholder-text {\n    color: @text-color-subtle;\n  }\n\n  .selection .region {\n    background-color: @input-selection-color;\n  }\n\n  .cursor {\n    border-color: @accent-color;\n    border-width: 2px;\n  }\n\n  &.is-focused {\n    .focus();\n    background-color: @input-background-color-focus;\n    .selection .region {\n      background-color: @input-selection-color-focus;\n    }\n  }\n}\n",digest:"c372db5e2182585e75a5dbc970c85d04f9ac94c9"},"node_modules/one-light-ui/styles/git.less":{content:".status { .text(normal); }\n.status-added    { .text(success); } // green\n.status-ignored  { .text(subtle); }  // faded\n.status-modified { .text(warning); } // orange\n.status-removed  { .text(error); }   // red\n.status-renamed  { .text(info); }    // blue\n",digest:"4cc19322834e5e93b47fe889895e14e6a7576f8d"},"node_modules/one-light-ui/styles/inputs.less":{content:"\n//\n// Checkbox\n// -------------------------\n\n.input-checkbox {\n  &:active {\n    background-color: @accent-color;\n  }\n  &:before,\n  &:after {\n    background-color: @accent-text-color;\n  }\n  &:checked {\n    background-color: @accent-color;\n  }\n\n  &:indeterminate {\n    background-color: @accent-color;\n  }\n}\n\n\n//\n// Radio\n// -------------------------\n\n.input-radio {\n  &:before {\n    background-color: @accent-text-color;\n  }\n  &:active {\n    background-color: @accent-color;\n  }\n  &:checked {\n    background-color: @accent-color;\n  }\n}\n\n\n//\n// Range (Slider)\n// -------------------------\n\n.input-range {\n  &::-webkit-slider-thumb {\n    background-color: @accent-color;\n  }\n}\n\n\n//\n// Toggle\n// -------------------------\n\n.input-toggle {\n  &:checked {\n    background-color: @accent-color;\n  }\n  &:before {\n    background-color: @accent-text-color;\n  }\n}\n\n\n\n// States -------------------------\n\n.input-checkbox,\n.input-text,\n.input-search,\n.input-number,\n.input-textarea,\n.input-select,\n.input-color {\n  &:focus {\n    .focus();\n  }\n}\n\n.input-text,\n.input-search,\n.input-number,\n.input-textarea {\n  &:invalid {\n    .invalid();\n  }\n}\n",digest:"cbdd7828f45ee1f03e26114404290d170462d705"},"node_modules/one-light-ui/styles/key-binding.less":{content:".key-binding {\n  display: inline-block;\n  margin-left: @ui-padding-icon;\n  padding: 0 @ui-padding/4;\n  line-height: 2;\n  font-family: inherit;\n  font-size: max(1em, @ui-size*.85);\n  letter-spacing: @ui-size/10;\n  border-radius: @component-border-radius;\n  color: @accent-bg-text-color;\n  background-color: @accent-bg-color;\n}\n",digest:"2c7039e912c9a51bc17fdb5619d12da5192a1f6f"},"node_modules/one-light-ui/styles/lists.less":{content:".list-group,\n.list-tree {\n  li:not(.list-nested-item),\n  li.list-nested-item > .list-item {\n    .text(normal);\n  }\n\n  .generate-list-item-text-color(@class) {\n    li:not(.list-nested-item).text-@{class},\n    li.list-nested-item.text-@{class} > .list-item {\n      .text(@class);\n    }\n  }\n  .generate-list-item-text-color(subtle);\n  .generate-list-item-text-color(info);\n  .generate-list-item-text-color(success);\n  .generate-list-item-text-color(warning);\n  .generate-list-item-text-color(error);\n  .generate-list-item-text-color(selected);\n\n  .generate-list-item-status-color(@color, @status) {\n    li:not(.list-nested-item).status-@{status},\n    li.list-nested-item.status-@{status} > .list-item {\n      color: @color;\n    }\n\n    li:not(.list-nested-item).selected.status-@{status},\n    li.list-nested-item.selected.status-@{status} > .list-item {\n      color: @color;\n    }\n\n  }\n\n  .generate-list-item-status-color(@text-color-added, added);\n  .generate-list-item-status-color(@text-color-ignored, ignored);\n  .generate-list-item-status-color(@text-color-modified, modified);\n  .generate-list-item-status-color(@text-color-removed, removed);\n  .generate-list-item-status-color(@text-color-renamed, renamed);\n\n  li:not(.list-nested-item).selected,\n  li.list-nested-item.selected > .list-item {\n    .text(selected);\n  }\n\n  .no-icon {\n    padding-left: calc(@ui-padding-icon ~\"+\" @component-icon-size);\n  }\n}\n\n.list-tree.has-collapsable-children .list-nested-item > .list-item::before {\n  text-align: center;\n}\n\n.select-list ol.list-group,\n&.select-list ol.list-group {\n  li.two-lines {\n    .secondary-line {\n      color: @text-color-subtle;\n    }\n    &.selected .secondary-line {\n      color: fade(@text-color-highlight, 50%);\n      text-shadow: none;\n    }\n  }\n\n  // Reset icon to allow nesting\n  .icon {\n    display: initial;\n    height: initial;\n  }\n\n  // We want to highlight the background of the list items because we dont\n  // know their size.\n  li.selected {\n    background-color: @background-color-selected;\n    &:before{ display: none; }\n  }\n\n  &.mark-active {\n    @active-icon-size: 14px;\n\n    // pad in front of the text where the icon would be We'll pad the non-\n    // active items with a 'fake' icon so other classes can pad the item\n    // without worrying about the icon padding.\n    li:before {\n      content: '';\n      background-color: transparent;\n      position: static;\n      display: inline-block;\n      left: auto; right: auto;\n      height: @active-icon-size;\n      width: @active-icon-size;\n      font-size: @active-icon-size;\n    }\n    > li:not(.active):before {\n      margin-right: @ui-padding-icon;\n    }\n    li.active {\n      .octicon(check, @active-icon-size);\n      &:before {\n        margin-right: @ui-padding-icon;\n        color: @text-color-success;\n      }\n    }\n  }\n}\n\n.select-list.popover-list {\n  @popover-list-padding: @ui-padding/4;\n  background-color: @overlay-background-color;\n  box-shadow: 0 2px 8px 1px rgba(0, 0, 0, 0.3);\n  padding: @popover-list-padding;\n  border-radius: @component-border-radius;\n\n  atom-text-editor[mini] {\n    margin-bottom: @popover-list-padding;\n  }\n\n  ol.list-group {\n    margin-top: @popover-list-padding;\n  }\n\n  .list-group li {\n    padding-left: @popover-list-padding;\n  }\n\n  // Un-reset icon in popover lists\n  .icon.icon {\n    display: inline-block;\n    height: inherit;\n  }\n}\n\n.ui-sortable {\n  li {\n    line-height: 2.5;\n  }\n\n  // For sortable lists in the settings view\n  li.ui-sortable-placeholder {\n    visibility: visible !important;\n    background-color: darken(@pane-item-background-color, 10%);\n  }\n}\n\nli.ui-draggable-dragging,\nli.ui-sortable-helper {\n  line-height: @ui-line-height;\n  height: @ui-line-height;\n  border: 0;\n  border-radius: 0;\n  list-style: none;\n  padding: 0 @ui-padding;\n  background: @background-color-highlight;\n  box-shadow: 0 0 1px @base-border-color;\n}\n",digest:"805f0bfbc29ff389ea2123b6cc85317d5ac6f87a"},"node_modules/one-light-ui/styles/messages.less":{content:"background-tips ul.background-message {\n  font-weight: 500;\n  font-size: 2em;\n  color: @text-color-faded;\n\n  .message {\n    padding: 0 @component-padding * 10;\n\n    .keystroke {\n      white-space: nowrap;\n      vertical-align: middle;\n      line-height: 1;\n      padding: .1em .4em;\n    }\n  }\n}\n",digest:"fbe98214c0578199506deb9b230c56019060194b"},"node_modules/one-light-ui/styles/modal.less":{content:'\n@modal-padding: @ui-padding/2 @ui-padding/1.5;\n@modal-width: @ui-size * 50;\n\natom-panel-container.modal {\n  position: absolute;\n  top: 0; left: 0; right: 0;\n}\n\natom-panel.modal {\n  position: relative;\n  width: 100%;\n  max-width: @modal-width;\n  margin: 0 auto;\n  left: initial;\n  color: @text-color;\n  background-color: transparent;\n  padding: @ui-padding/2;\n\n  &.from-top {\n    top: @component-padding * 5;\n  }\n\n  atom-text-editor[mini] {\n    margin-bottom: @ui-padding/2;\n  }\n\n  .select-list ol.list-group,\n  &.select-list ol.list-group {\n    border: 1px solid @overlay-border-color;\n    background-color: lighten(@overlay-background-color, 2%);\n\n    &:empty {\n      border: none;\n      margin-top: 0;\n    }\n\n    li {\n      padding: @modal-padding;\n      line-height: @ui-line-height;\n      border-bottom: 1px solid @overlay-border-color;\n\n      &:last-of-type {\n        border-bottom: none;\n      }\n\n      .icon::before {\n        margin-left: 1px;\n      }\n\n      .icon.status {\n        float: right;\n        margin-left: @ui-padding-icon;\n        &:before {\n          margin-left: 0;\n          margin-right: 0;\n        }\n      }\n\n      &.selected {\n        .status.icon {\n          color: @text-color-selected;\n        }\n      }\n    }\n\n  }\n\n  .select-list .key-binding {\n    margin-top: -1px;\n    margin-left: @ui-padding/2;\n    margin-right: calc( -@ui-padding/3 ~"+" 1px);\n  }\n\n  .select-list .primary-line {\n    display: block;\n  }\n\n  & > * {\n    position: relative; // fixes stacking order\n  }\n\n  .command-palette {\n    padding: 1px; // prevents the box-shadow of the input from being cut off\n    background-color: @overlay-background-color;\n  }\n\n\n  // Container\n  &:before {\n    content: "";\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    z-index: 0;\n    background-color: @overlay-background-color;\n    border-radius: @component-border-radius*2;\n    box-shadow: 0 6px 12px -2px hsla(0,0%,0%,.4);\n  }\n\n  // Backdrop\n  // TODO: Add extra wrapper to translate individually or easier positioning\n\n  &:after {\n    content: "";\n    position: fixed;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    z-index: -1;\n    background: @overlay-backdrop-color;\n    opacity: @overlay-backdrop-opacity;\n    backface-visibility: hidden; // fixes scrollbar on retina screens\n    -webkit-animation: overlay-fade .24s cubic-bezier(0.215, 0.61, 0.355, 1);\n  }\n\n  @-webkit-keyframes overlay-fade {\n    0% { opacity: 0; }\n    100% { opacity: @overlay-backdrop-opacity; }\n  }\n\n}\n',digest:"62679c03ee0a22e217d8095f67b69d2ad79c65ae"},"node_modules/one-light-ui/styles/nav.less":{content:".nav-tabs {\n  border-bottom: 1px solid @base-border-color;\n  li {\n    a,\n    &.active a {\n      border: none;\n      margin-right: 0px;\n      margin-bottom: 1px;\n    }\n\n    a:hover,\n    &.active a,\n    &.active a:hover {\n      background-color: @background-color-highlight;\n      border: none;\n      color: @text-color-selected;\n      border-bottom-left-radius: 0px;\n      border-bottom-right-radius: 0px;\n    }\n\n    &.active a {\n      background-color: @tab-background-color-active;\n    }\n  }\n}\n",digest:"54ed0e49741845e8799c9513ae21ca7ae75f751d"},"node_modules/one-light-ui/styles/notifications.less":{content:"\natom-notifications {\n  font-size: @ui-size * 1.2;\n\n  atom-notification {\n    width: 32em;\n    &.has-detail {\n      width: 32em;\n    }\n\n    &:first-child.has-close .message {\n      padding-right: 9em;\n    }\n    &:only-child.has-close .message,\n    &.has-close .message {\n      padding-right: 2.5em;\n    }\n    .item {\n      padding: @ui-padding/2;\n    }\n\n    .detail,\n    .description {\n      font-size: .85em;\n    }\n\n    &.icon:before {\n      padding-top: .85em;\n    }\n    .close {\n      width: 2.5em;\n      height: 3em;\n      line-height: 3em;\n      font-size: inherit;\n    }\n    .close-all.btn {\n      top: .5em;\n      right: 2.5em;\n    }\n    .btn-copy-report {\n      line-height: 2em;\n      margin-left: .5em;\n    }\n  }\n}\n",digest:"2e08e0dc91ed0d4dcf79a1dcec241fd3ceac0cf4"},"node_modules/one-light-ui/styles/packages.less":{content:"// Overrides packages\n\n// find-and-replace + project-find ---------------------------\n\n.find-and-replace,\n.project-find {\n  padding: @ui-padding/4;\n  .input-block-item {\n    padding: @ui-padding/4;\n  }\n}\n\n// find-and-replace\n.find-and-replace {\n  .header,\n  .input-block {\n    min-width: @ui-size*22;\n  }\n\n  .input-block-item {\n    flex: 1 1 @ui-size*22;\n  }\n  .input-block-item--flex {\n    flex: 100 1 @ui-size*22;\n  }\n\n  .btn,\n  .btn-group-options .btn {\n    font-size: @ui-size*1.1;\n    padding: 0;\n  }\n\n  .btn-group-options .btn,\n  .btn-group-options .btn.option-selection,\n  .btn-group-options .btn.option-whole-word {\n    padding: 0;\n    font-size: @ui-input-size; // keep same as text input\n  }\n\n  .find-container atom-text-editor {\n    padding-right: @ui-size*5; // leave some room for the results count\n  }\n  .find-meta-container {\n    top: 0;\n    font-size: @ui-size;\n    line-height: @ui-size*2.5;\n  }\n}\n\n// project-find\n.project-find {\n  .header,\n  .input-block {\n    min-width: @ui-size*15;\n  }\n\n  .input-block-item {\n    flex: 1 1 @ui-size*14;\n  }\n  .input-block-item--flex {\n    flex: 100 1 @ui-size*20;\n  }\n\n  .btn {\n    font-size: @ui-size*1.1;\n    padding: 0;\n  }\n  .btn-group-options .btn {\n    padding: 0;\n    font-size: @ui-input-size; // keep same as text input\n  }\n}\n\n// Colorize find-and-replace based on results\n& when (@ui-hue >= 190) and (@ui-hue <= 340) {\n  .find-and-replace {\n    &.has-no-results .find-container atom-text-editor[mini].is-focused {\n      .invalid();\n      .selection .region {\n        background-color: mix(@text-color-error, @input-background-color, 50%);\n      }\n      .cursor {\n        border-color: @text-color-error;\n      }\n    }\n\n    &.has-results .find-container atom-text-editor[mini].is-focused {\n      .valid();\n      .selection .region {\n        background-color: mix(@text-color-success, @input-background-color, 50%);\n      }\n      .cursor {\n        border-color: @text-color-success;\n      }\n    }\n\n    &.has-results    .find-container .result-counter { color: @text-color-success; }\n    &.has-no-results .find-container .result-counter { color: @text-color-error; }\n  }\n}\n\n\n\n\n// Timecop ---------------------------\n\n.timecop {\n  .timecop-panel {\n    padding: @component-padding/2;\n    background-color: @level-2-color;\n  }\n\n  .tool-panel {\n    padding: @component-padding/2;\n    background-color: @level-2-color;\n  }\n\n  .inset-panel {\n    border: 1px solid @base-border-color;\n  }\n\n  .panel-heading {\n    .text(highlight);\n    border-color: @base-border-color;\n    background-color: @level-1-color;\n  }\n\n  .list-item .inline-block {\n    line-height: 1.5;\n  }\n}\n\n\n// Command Palette + Fuzzy Finder ---------------------------\n\n.command-palette .list-group .character-match,\n.fuzzy-finder .list-group .character-match {\n  color: @accent-only-text-color;\n}\n\n\n// Deprecation Cop ---------------------------\n\n.deprecation-cop {\n  .deprecation-overview {\n    background-color: @level-2-color;\n    border-bottom: 1px solid @base-border-color;\n  }\n}\n\n\n// Tool Bar ---------------------------\n\n.tool-bar {\n  // Make it look the same as other panels\n  background-color: @level-3-color;\n  border: none;\n\n  // just a single border + more spacing\n  &.tool-bar-horizontal .tool-bar-spacer {\n    border-left: 0 none;\n    margin-left: .5em;\n    margin-right: .5em;\n  }\n  &.tool-bar-vertical .tool-bar-spacer {\n    border-bottom: 0 none;\n    margin-top: .5em;\n    margin-bottom: .5em;\n  }\n\n  // only show button styles on hover\n  button.tool-bar-btn {\n    background-color: @level-3-color;\n    background-image: none;\n    border-color: @level-3-color;\n  }\n}\n\n\n\n// GitHub package ---------------------------------------------------\n\n.github {\n\n  // Fix focus styles\n  // Since it's not possible to add a padding to <atom-text-editor>\n  // a pseudo element is used to add the border when focused.\n  &-CommitView-editor atom-text-editor.is-focused {\n    box-shadow: none;\n    &:before {\n      content: \"\";\n      position: absolute;\n      top: -2px;\n      left: -2px;\n      right: -2px;\n      bottom: -2px;\n      border: 2px solid;\n      border-color: inherit;\n      border-radius: @component-border-radius;\n    }\n  }\n\n  // Add focus styles since :focus doesn't work\n  &-CommitView-coAuthorEditor {\n    &.is-focused {\n      .focus();\n    }\n    &.is-open {\n      border-top-left-radius: 0;\n      border-top-right-radius: 0;\n    }\n\n\n    .Select-option {\n      &.is-focused {\n        border-bottom-left-radius: 0;\n        border-bottom-right-radius: 0;\n        color: @accent-text-color;\n        background-color: @accent-color;\n      }\n    }\n    .Select-menu-outer {\n      left: -2px;\n      right: -2px;\n      bottom: 100%;\n      border: 2px solid @accent-color;\n      background-color: @overlay-background-color;\n    }\n  }\n\n}\n",digest:"fde4ec7a426d574517c7e3a0c14284416b84873d"},"node_modules/one-light-ui/styles/panels.less":{content:"\n// Panels\n\natom-panel {\n  .text(normal);\n  position: relative;\n  border-bottom: 1px solid @base-border-color;\n\n  &.top {\n    border-right: 1px solid @base-border-color;\n  }\n  &.left {\n    border-right: 1px solid @base-border-color;\n  }\n  &.right {\n    border-left: 1px solid @base-border-color;\n  }\n  &.bottom {\n    border-right: 1px solid @base-border-color;\n  }\n  &.footer:last-child {\n    border-bottom: none;\n  }\n  &.tool-panel:empty {\n    border: none;\n  }\n}\n\n.panel {\n  &.bordered {\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n  }\n}\n\n.inset-panel {\n  position: relative;\n  background-color: @inset-panel-background-color;\n  border-radius: @component-border-radius;\n  &.bordered {\n    border: 1px solid @base-border-color;\n    border-radius: @component-border-radius;\n  }\n  & .panel-heading {\n    border-color: @inset-panel-border-color;\n  }\n}\n\n.panel-heading {\n  .text(normal);\n  border-bottom: 1px solid @panel-heading-border-color;\n  background-color: @panel-heading-background-color;\n\n  .btn {\n    padding-left: 8px;\n    padding-right: 8px;\n    .btn-default(\n      lighten(@button-background-color, 10%),\n      lighten(@button-background-color-hover, 10%),\n      lighten(@button-background-color-selected, 10%),\n      lighten(@text-color, 10%)\n    );\n  }\n}\n",digest:"78e95fe77592b096e829427a1a4c35c24f9baea6"},"node_modules/one-light-ui/styles/panes.less":{content:"\natom-pane-container {\n\n  atom-pane {\n    position: relative;\n    border-right: 1px solid @base-border-color;\n    border-bottom: 1px solid @base-border-color;\n\n    .item-views {\n      // prevent atom-text-editor from leaking ouside might improve performance\n      overflow: hidden;\n    }\n  }\n\n}\n\n// Hide right-most border\natom-pane:only-child,\natom-pane-axis.pane-row > atom-pane:last-child,\natom-pane-axis.pane-column:last-child > atom-pane {\n  border-right: none;\n}\n",digest:"517a4bfd51fba7919d84a7e89eef84db64f68d55"},"node_modules/one-light-ui/styles/progress.less":{content:'\n// Spinner ----------------------\n\n@spinner-duration: 1.2s;\n\n.loading-spinner(@size) {\n  position: relative;\n  display: block;\n  width: 1em;\n  height: 1em;\n  font-size: @size;\n  background: radial-gradient(@accent-color .1em, transparent .11em);\n\n  &::before,\n  &::after {\n    content: "";\n    position: absolute;\n    z-index: 10; // prevent sibling elements from getting their own layers\n    top: 0;\n    left: 0;\n    border-radius: 1em;\n    width: inherit;\n    height: inherit;\n    border-radius: 1em;\n    border: 2px solid;\n    -webkit-animation: spinner-animation @spinner-duration infinite;\n    -webkit-animation-fill-mode: backwards;\n  }\n  &::before {\n    border-color: @accent-color transparent transparent transparent;\n  }\n  &::after {\n    border-color: transparent lighten(@accent-color, 15%) transparent transparent;\n    -webkit-animation-delay: @spinner-duration/2;\n  }\n\n  &.inline-block {\n    display: inline-block;\n  }\n}\n\n@-webkit-keyframes spinner-animation {\n    0% { transform: rotateZ(  0deg); -webkit-animation-timing-function: cubic-bezier(0, 0, .8, .2); }\n   50% { transform: rotateZ(180deg); -webkit-animation-timing-function: cubic-bezier(.2, .8, 1, 1); }\n  100% { transform: rotateZ(360deg); }\n}\n\n// Spinner sizes\n.loading-spinner-tiny   { .loading-spinner(16px); &::before, &::after { border-width: 1px; } }\n.loading-spinner-small  { .loading-spinner(32px); }\n.loading-spinner-medium { .loading-spinner(48px); }\n.loading-spinner-large  { .loading-spinner(64px); }\n\n\n\n\n// Progress Bar ----------------------\n\n@progress-height: 8px;\n@progress-buffer-color: fade(@progress-background-color, 20%);\n\nprogress {\n  -webkit-appearance: none;\n  height: @progress-height;\n  border-radius: @component-border-radius;\n  background-color: @input-background-color;\n  box-shadow: inset 0 0 0 1px @input-border-color;\n\n  &::-webkit-progress-bar {\n    background-color: transparent;\n  }\n\n  &::-webkit-progress-value {\n    border-radius: @component-border-radius;\n    background-color: @progress-background-color;\n  }\n\n  // Is buffering (when no value is set)\n  &:indeterminate {\n    background-image:\n       linear-gradient(-45deg, transparent 33%, @progress-buffer-color 33%,\n                               @progress-buffer-color 66%, transparent 66%);\n    background-size: 25px @progress-height, 100% 100%, 100% 100%;\n\n    // Plays animation for 1min (12runs) at normal speed,\n    // then slows down frame-rate for 9mins (108runs) to limit CPU usage\n    -webkit-animation: progress-buffering 5s linear 12,\n                       progress-buffering 5s 60s steps(10) 108;\n  }\n}\n\n@-webkit-keyframes progress-buffering {\n   100% { background-position: -100px 0px; }\n}\n',digest:"c51843dd15ee040fd7a60aaccf3e2d1071459cb0"},"node_modules/one-light-ui/styles/settings.less":{content:'\n// Settings\n\n// Modular Scale (1.125): http://www.modularscale.com/?1&em&1.125&web&table\n@ms-6: @ui-size * 2.027;\n@ms-5: @ui-size * 1.802;\n@ms-4: @ui-size * 1.602;\n@ms-3: @ui-size * 1.424;\n@ms-2: @ui-size * 1.266;\n@ms-1: @ui-size * 1.125;\n@ms-0: @ui-size * 1;\n@ms_1: @ui-size * 0.889;\n@ms_2: @ui-size * 0.790;\n\n\n\n.settings-view {\n\n\t// Menu ------------------------------\n\n\t.config-menu {\n\t\tposition: relative;\n\t\tmin-width: @ui-size * 15;\n\t\tmax-width: @ui-size * 20;\n\t\tborder-width: 0 1px 0 0;\n\t\tborder-image: linear-gradient(@level-2-color 10px, @base-border-color 200px) 0 1 0 0 stretch;\n\t\tbackground: @level-2-color;\n\n\t\t.btn {\n\t\t\twhite-space: initial;\n\t\t\tfont-size: @ms_1;\n\t\t\tline-height: 1;\n\t\t\tpadding: @ui-padding/3 @ui-padding/2;\n\t\t\t&::before {\n\t\t\t\tvertical-align: middle;\n\t\t\t}\n\t\t}\n\n\n\t}\n\t.nav {\n\t\t& > li > a {\n\t\t\tpadding: @ui-padding/2 @ui-padding;\n\t\t\tline-height: @ui-line-height;\n\t\t}\n\t}\n\n\n\t// Sections ------------------------------\n\n\t& > .panels {\n\t\tbackground-color: @level-2-color;\n\t}\n\n\t.section-container {\n\t\tmax-width: @ui-size*60;\n\t}\n\n\t.section,\n\t.section:first-child,\n\t.section:last-child {\n\t\tpadding: @ui-padding*3;\n\t}\n\n\t.themes-panel .control-group {\n\t\tmargin-top: @ui-padding*2;\n\t}\n\n\n\t// Titles ------------------------------\n\n\t.section .section-heading {\n\t\tmargin-bottom: @ui-padding/1.5;\n\t}\n\n\t.sub-section-heading.icon:before,\n\t.section-heading.icon:before {\n\t\tmargin-right: @ui-padding-icon;\n\t}\n\n\n\n\t// Cards ------------------------------\n\n\t.sub-section:not(.collapsed) .package-container {\n\t\tpadding-bottom: @component-padding*3;\n\t}\n\n\t.package-card {\n\t\tpadding: @ui-padding;\n\t\t.meta-controls .status-indicator {\n\t\t\twidth: @ui-padding/4;\n\t\t\t&:before {\n\t\t\t\tcontent: "\\00a0"; // fixes 0 height\n\t\t\t}\n\t\t}\n\t}\n\n\n\t// Components ------------------------------\n\n\t.icon::before {\n\t\tcolor: @text-color-subtle;\n\t}\n\n\t.editor-container {\n\t\tmargin: @ui-padding 0;\n\t}\n\n\t.form-control {\n\t\tfont-size: @ui-size*1.25;\n\t\theight: @ui-line-height;\n\t\tpadding-top: 0;\n\t\tpadding-bottom: 0;\n\t}\n\n\t.update-all-button {\n\t\tfont-size: .75em;\n\t}\n\n\t.install-button {\n\t\t.btn-variant(@accent-bg-color);\n\t}\n\n\tinput[type="checkbox"] {\n\t\tbackground-color: @background-color-selected;\n\t\t&:active,\n\t\t&:checked {\n\t\t\tbackground-color: @accent-color;\n\t\t}\n\t\t&:before,\n\t\t&:after {\n\t\t\tbackground-color: @accent-text-color;\n\t\t}\n\t}\n\n\t.search-container .btn {\n\t\tfont-size: @ui-input-size;\n\t}\n\n}\n',digest:"b7a8f837ee9ccf0ec8ef897de3dca6cef997a42f"},"node_modules/one-light-ui/styles/sites.less":{content:"// Site Colors\n\n.ui-site(@num, @color) {\n  .ui-site-@{num} {\n    background-color: @color;\n  }\n}\n\n.ui-site(1, @ui-site-color-1);\n.ui-site(2, @ui-site-color-2);\n.ui-site(3, @ui-site-color-3);\n.ui-site(4, @ui-site-color-4);\n.ui-site(5, @ui-site-color-5);\n",digest:"b27327b73cb57001e574b9d1db332766ac6d1e4e"},"node_modules/one-light-ui/styles/status-bar.less":{content:"\n@status-bar-height: @ui-tab-height; // same as tabs\n@status-bar-padding: @ui-padding;\n\n.status-bar {\n  font-size: @ui-size;\n  height: @status-bar-height;\n  line-height: @status-bar-height;\n  background-color: @level-3-color;\n\n  .flexbox-repaint-hack {\n    padding: 0; // override default\n  }\n\n  // underlines should only be used for external links\n  a:hover,\n  a:focus {\n    text-decoration: none;\n    cursor: default;\n  }\n\n  .inline-block {\n    margin: 0; // override default\n    padding: 0 @status-bar-padding/2;\n    vertical-align: top;\n\n    &:hover {\n      text-decoration: none;\n      background-color: @level-3-color-hover;\n    }\n    &:active {\n      background-color: @level-3-color-active;\n    }\n\n    // reset on child inline-block\n    .inline-block {\n      margin: 0;\n      padding: 0;\n    }\n  }\n\n  .status-bar-right {\n    .inline-block {\n      margin-left: 0; // override default\n    }\n  }\n  .icon {\n    vertical-align: middle;\n  }\n  .icon::before {\n    font-size: 1.33333em; // should be 16px with a default of 12px\n  \twidth: auto; // use natural width\n    line-height: 1;\n    height: 1em; // same as line-height\n    margin-right: .25em;\n    top: auto;\n  }\n}\n\n\n// Package overrides -------------------------------\n\n.status-bar.status-bar {\n\n  // Read-only -> Remove hover effect\n  .is-read-only, // <- use this class in packages\n  status-bar-launch-mode,\n  busy-signal {\n    &:hover,\n    &:active,\n    .inline-block:hover,\n    .inline-block:active {\n      background-color: transparent;\n    }\n  }\n\n  // Remove underline\n  .package-updates-status-view,\n  .github-ChangedFilesCount {\n    &:hover,\n    &:focus {\n      text-decoration: none;\n      cursor: default;\n    }\n  }\n\n  // Remove margin for icon without text\n  status-bar-launch-mode::before, // Launch mode\n  .about-release-notes::before, // New release squirrel\n  .PortalStatusBarIndicator .icon::before, // Teletype\n  .icon.is-icon-only::before {\n    margin-right: 0;\n  }\n  .github-PushPull-label.is-push:empty { // GitHub package when nothing to push\n    margin-right: -.25em;\n  }\n}\n",digest:"1b2caf1dbe80d6552e3e5e9291a295af01e118e9"},"node_modules/one-light-ui/styles/tabs.less":{content:'\n// Tabs\n\n@tab-border: 1px solid @tab-border-color;\n@title-padding: .66em;\n@icon-padding-top: .5em; // 2.5 (total) - 1.5 (text) / 2\n@icon-padding-right: .5em;\n\n.tab-bar {\n  position: relative;\n  height: @ui-tab-height;\n  box-shadow: inset 0 -1px 0 @tab-border-color;\n  background: @tab-bar-background-color;\n  overflow-x: auto;\n  overflow-y: hidden;\n  border-radius: 0;\n\n  &::-webkit-scrollbar {\n    display: none;\n  }\n\n  &:empty {\n    display: none;\n  }\n\n\n  // Tab ----------------------\n\n  .tab {\n    position: relative;\n    top: 0;\n    padding: 0;\n    margin: 0;\n    height: inherit;\n    font-size: inherit;\n    line-height: @ui-tab-height;\n    color: @tab-text-color;\n    background-color: @tab-background-color;\n    box-shadow: inherit;\n    border-left: @tab-border;\n    &.active {\n      color: @tab-text-color-active;\n      background-color: @tab-background-color-active;\n      box-shadow: none;\n    }\n    &:first-of-type {\n      border-left-color: transparent;\n    }\n    &:last-of-type {\n      // use box-shadow to not take up any space\n      box-shadow: inset 0 -1px 0 @tab-border-color, 1px 0 0 @base-border-color;\n    }\n    &.active:last-of-type {\n      box-shadow: 1px 0 0 @base-border-color;\n    }\n\n\n    // Title ----------------------\n\n    .title {\n      text-align: center;\n      margin: 0 @title-padding;\n    }\n\n    // VCS coloring ----------------------\n    &:not(.active) .status-added    { color: @tab-inactive-status-added; }\n    &:not(.active) .status-modified { color: @tab-inactive-status-modified; }\n\n\n    // Icons ----------------------\n\n    .title.title:before {\n      margin-right: .3em;\n      width: auto;\n      height: auto;\n      line-height: 1;\n      font-size: 1.125em;\n      vertical-align: -.0625em; // Adjust center for the 0.1em font-size increase\n    }\n\n    // Close icon ----------------------\n\n    .close-icon {\n      top: @icon-padding-top;\n      right: @icon-padding-right;\n      z-index: 2;\n      font-size: 1em;\n      width: 1.5em;\n      height: 1.5em;\n      line-height: 1.5;\n      text-align: center;\n      border-radius: @component-border-radius;\n      background-color: inherit;\n      overflow: hidden;\n      transform: scale(0);\n      transition: transform .08s;\n      &:hover {\n        color: @accent-text-color;\n        background-color: @accent-color;\n      }\n      &:active {\n        background-color: fade(@accent-color, 50%);\n      }\n      &::before {\n        z-index: 1;\n        font-size: 1.1em;\n        vertical-align: -.05em; // Adjust center for the 0.1em font-size increase\n        width: auto;\n        height: auto;\n        pointer-events: none;\n      }\n    }\n    &:hover .close-icon {\n      transform: scale(1);\n      transition-duration: .16s;\n    }\n  }\n\n  // Modified icon ----------------------\n\n  .tab.modified {\n    &:hover .close-icon {\n      color: @accent-color;\n      &:hover {\n        color: @accent-bg-text-color;\n      }\n    }\n    &:not(:hover) .close-icon {\n      top: @icon-padding-top;\n      right: @icon-padding-right;\n      width: 1.5em;\n      height: 1.5em;\n      line-height: 1.5;\n      color: @accent-color;\n      border-radius: @component-border-radius;\n      border: none;\n      transform: scale(1);\n      &::before {\n        content: "\\f052";\n        display: inline-block;\n      }\n    }\n  }\n\n\n  // Tabs in the docks ----------------------\n\n  atom-dock & {\n    .tab.active {\n      background-color: @tool-panel-background-color;\n    }\n  }\n\n\n  // Dragging ----------------------\n\n  .tab.is-dragging {\n    opacity: .5;\n\n    .close-icon,\n    &:before {\n      visibility: hidden;\n    }\n  }\n\n  .placeholder {\n    position: relative;\n    pointer-events: none;\n\n    // bar\n    &:before {\n      z-index: 1;\n      margin: 0;\n      width: 2px;\n      height: @ui-tab-height;\n      background-color: @accent-color;\n    }\n\n    // arrow\n    &:after {\n      z-index: 0;\n      top: @ui-tab-height/2;\n      margin: -4px 0 0 -3px;\n      border-radius: 0;\n      border: 4px solid @accent-color;\n      transform: rotate(45deg);\n      background: transparent;\n    }\n\n    &:last-child {\n      &:before {\n        margin-left: -2px;\n      }\n      &:after {\n        transform: none;\n        margin-left: -10px;\n        border-color: transparent @accent-color transparent transparent;\n      }\n    }\n  }\n\n\n  // Overrides ----------------------\n\n  // keep tabs same size when active\n  .tab,\n  .tab.active {\n    padding-right: 0;\n    .title {\n      padding: 0;\n    }\n  }\n}\n\n\n// Active/focused pane marker --------------\n\natom-pane-axis > atom-pane.active,\natom-pane-container > atom-pane.pane {\n  .tab.active:before {\n    content: "";\n    position: absolute;\n    pointer-events: none;\n    z-index: 2;\n    top: 0;\n    left: -1px; // cover left border\n    bottom: 0;\n    width: 2px;\n    background: mix(@text-color, @tab-background-color-editor, 33%);\n  }\n}\n.pane:focus-within {\n  .tab.active:before {\n    background: @accent-color;\n  }\n}\n\n// hide marker in docks\natom-dock .tab-bar .tab::before {\n  display: none;\n}\n\n\n// Custom tabs --------------\n\n.tab-bar .tab.active {\n  &[data-type$="Editor"],\n  &[data-type$="AboutView"],\n  &[data-type$="TimecopView"],\n  &[data-type$="StyleguideView"],\n  &[data-type="MarkdownPreviewView"] {\n    color: @tab-text-color-editor;\n    background-color: @tab-background-color-editor; // Match syntax background color\n  }\n}\n',digest:"f1225dd163b31414ccc77fcf06c883ae94f53dae"},"node_modules/one-light-ui/styles/text.less":{content:"h1,\nh2,\nh3 {\n  line-height: 1em;\n  margin-bottom: 15px\n}\nh1 { font-size: 2em; }\nh2 { font-size: 1.5em; }\nh3 { font-size: 1.2em; }\n\np {\n  line-height: 1.6;\n  margin-bottom: 15px;\n}\n\nlabel {\n  font-weight: normal;\n}\n\npre {\n  box-shadow: none;\n  color: @text-color;\n  background: @inset-panel-background-color;\n  border-radius: @component-border-radius;\n  border: none;\n  margin: 0;\n}\n\ncode {\n  .text(highlight);\n  background: @background-color-highlight;\n  border-radius: @component-border-radius;\n}\n\n.selected { .text(highlight); }\n\n.text-smaller { font-size: 0.9em; }\n\n.text-subtle { .text(subtle); }\n.text-highlight { .text(highlight); }\n\n.text-error { .text(error); }\n.text-info {\n  .text(info);\n  &:hover { color: @text-color-info; }\n}\n.text-warning {\n  .text(warning);\n  &:hover { color: @text-color-warning; }\n}\n.text-success {\n  .text(success);\n  &:hover { color: @text-color-success; }\n}\n\n.highlight-mixin {\n  padding: 1px 4px;\n  border-radius: 2px;\n}\n\n.highlight {\n  .highlight-mixin();\n  font-weight: 700;\n  color: @text-color-highlight;\n  background-color: @background-color-highlight;\n}\n\n.highlight-color(@name, @background-color) {\n  .highlight-@{name} {\n    .highlight-mixin();\n    font-weight: 500;\n    color: white;\n    text-shadow: 0 1px 0px hsla(0,0%,0%,.2);\n    background-color: @background-color;\n  }\n}\n.highlight-color(   info, @background-color-info);\n.highlight-color(warning, @background-color-warning);\n.highlight-color(  error, @background-color-error);\n.highlight-color(success, @background-color-success);\n\n.results-view .path-details.list-item {\n  color: darken(@text-color-highlight, 18%);\n}\n",digest:"38471280be8bb348914ba7bf07bd03405facbd14"},"node_modules/one-light-ui/styles/title-bar.less":{content:".title-bar {\n  height: 22px; // remove 1px since there is no border\n  border-bottom: none;\n}\n",digest:"93638036e200a218636d7f1cdb32276c0c04ce0c"},"node_modules/one-light-ui/styles/tooltips.less":{content:".tooltip {\n  white-space: nowrap;\n  font-size: @ui-size*1.15;\n\n  &.in {\n    opacity: 1;\n    transition: opacity .12s ease-out;\n  }\n\n  .tooltip-inner {\n    line-height: 1;\n    padding: @ui-padding*.5 @ui-padding*.65;\n    border-radius: @component-border-radius;\n    background-color: @tooltip-background-color;\n    color: @tooltip-text-color;\n    white-space: nowrap;\n    max-width: none;\n  }\n\n  .keystroke {\n    font-size: max(1em, @ui-size*.85);\n    padding: .1em .4em;\n    margin: 0 @ui-padding*-.35 0 @ui-padding*.25;\n    border-radius: max(2px, @component-border-radius / 2);\n    color: @tooltip-text-key-color;\n    background: @tooltip-background-key-color;\n  }\n\n  &.top .tooltip-arrow {\n    border-top-color: @tooltip-background-color;\n  }\n  &.top-left .tooltip-arrow {\n    border-top-color: @tooltip-background-color;\n  }\n  &.top-right .tooltip-arrow {\n    border-top-color: @tooltip-background-color;\n  }\n  &.right .tooltip-arrow {\n    border-right-color: @tooltip-background-color;\n  }\n  &.left .tooltip-arrow {\n    border-left-color: @tooltip-background-color;\n  }\n  &.bottom .tooltip-arrow {\n    border-bottom-color: @tooltip-background-color;\n  }\n  &.bottom-left .tooltip-arrow {\n    border-bottom-color: @tooltip-background-color;\n  }\n  &.bottom-right .tooltip-arrow {\n    border-bottom-color: @tooltip-background-color;\n  }\n}\n",digest:"d04c888a4ae472d7609d5ae9db25e2ded92049cc"},"node_modules/one-light-ui/styles/tree-view.less":{content:"@tree-view-height: @ui-line-height;\n\n.tree-view {\n  font-size: @ui-size;\n  background: @tree-view-background-color;\n\n  .project-root.project-root {\n    &:before {\n      height: @ui-tab-height;\n      background-clip: padding-box;\n    }\n    & > .header .name {\n      line-height: @ui-tab-height;\n    }\n  }\n\n  // Selected state\n  .selected:before {\n    background: @background-color-selected;\n  }\n\n  // Focus + selected state\n  &:focus {\n    .selected.list-item > .name, // files\n    .selected.list-nested-item > .list-item > .name, // folders\n    .selected.list-nested-item > .header:before { // arrow icon\n      color: contrast(@button-background-color-selected);\n    }\n    .selected:before {\n      background: @button-background-color-selected;\n    }\n  }\n}\n\n.theme-one-dark-ui .tree-view .project-root.project-root::before {\n  border-top: 1px solid transparent;\n  background-clip: padding-box;\n}\n\n.tree-view-resizer {\n  .tree-view-resize-handle {\n    width: 8px;\n  }\n}\n\n// Variable height, based on ems\n.list-group li:not(.list-nested-item),\n.list-tree li:not(.list-nested-item),\n.list-group li.list-nested-item > .list-item,\n.list-tree li.list-nested-item > .list-item {\n  line-height: @tree-view-height;\n}\n\n.list-group .selected::before,\n.list-tree .selected::before {\n  height: @tree-view-height;\n}\n\n// icon\n.list-group .icon,\n.list-tree .icon {\n  display: inline-block;\n  height: inherit;\n  &::before {\n    top: initial;\n    line-height: inherit;\n    height: inherit;\n    vertical-align: top;\n  }\n}\n\n// Arrow icon\n.list-group,\n.list-tree {\n  .header.header.header.header::before {\n    top: initial;\n    line-height: inherit;\n    height: inherit;\n    vertical-align: top;\n    font-size: inherit;\n  }\n}\n.tree-view .project-root-header.project-root-header.project-root-header.project-root-header::before {\n  line-height: @ui-tab-height;\n}\n",digest:"c5fdec6ed1e5aa4809d3464f7e0f197d440cbc44"},"node_modules/one-light-ui/styles/ui-mixins.less":{content:"// Pattern matching; ish is cray.\n// http://lesscss.org/#-pattern-matching-and-guard-expressions\n\n.text(normal) {\n  font-weight: normal;\n  color: @text-color;\n}\n.text(subtle) {\n  font-weight: normal;\n  color: @text-color-subtle;\n}\n.text(highlight) {\n  font-weight: normal;\n  color: @text-color-highlight;\n}\n.text(selected) {\n  .text(highlight)\n}\n\n.text(info) {\n  color: @text-color-info;\n}\n.text(success) {\n  color: @text-color-success;\n}\n.text(warning) {\n  color: @text-color-warning;\n}\n.text(error) {\n  color: @text-color-error;\n}\n\n.focus() {\n  outline: none;\n  border-color: @accent-color;\n  box-shadow: 0 0 0 1px @accent-color;\n}\n\n.valid() {\n  border-color: @text-color-success;\n  box-shadow: 0 0 0 1px @text-color-success;\n  background-color: mix(@text-color-success, @input-background-color, 10%);\n}\n\n.invalid() {\n  border-color: @text-color-error;\n  box-shadow: 0 0 0 1px @text-color-error;\n  background-color: mix(@text-color-error, @input-background-color, 10%);\n}\n",digest:"1d69d3145b45e0f9497cfa8a8b95a95fcae3b937"},"node_modules/one-light-ui/styles/ui-variables-custom.less":{content:'\n// ONE light UI variables\n// ----------------------------------------------\n\n@import "syntax-variables";\n\n.ui-syntax-color() { @syntax-background-color: hsl(220,1%,98%); } .ui-syntax-color(); // fallback color\n@ui-syntax-color: @syntax-background-color;\n\n// Color guards -----------------\n@ui-s-h: hue(@ui-syntax-color);\n.ui-hue() when (@ui-s-h = 0) { @ui-hue: 220; } // Use blue hue when no saturation\n.ui-hue() when (@ui-s-h > 0) { @ui-hue: @ui-s-h; }\n.ui-hue();\n\n@ui-saturation:   min( saturation(@ui-syntax-color), 24%); // max saturation\n@ui-lightness:    max(  lightness(@ui-syntax-color), 92%); // min lightness\n\n// Main colors -----------------\n@ui-fg:     hsl(@ui-hue, @ui-saturation, @ui-lightness - 72%);\n@ui-bg:     hsl(@ui-hue, @ui-saturation, @ui-lightness); // normalized @syntax-background-color\n@ui-border: darken(@level-3-color, 6%);\n\n\n\n\n// Custom variables\n// These variables are only used in this theme\n// ----------------------------------------------\n\n@ui-theme-name: one-light-ui;\n\n// Text (Custom) -----------------\n@text-color-faded: fade(@text-color, 30%);\n\n@text-color-added:    @text-color-success;  // green\n@text-color-ignored:  @text-color-subtle;   // faded\n@text-color-modified: @text-color-warning;  // orange\n@text-color-removed:  @text-color-error;    // red\n@text-color-renamed:  @text-color-info;     // blue\n\n\n// Background (Custom) -----------------\n@level-1-color: lighten(@base-background-color, 4%);\n@level-2-color: @base-background-color;\n@level-3-color: darken(@base-background-color, 6%);\n\n@level-3-color-hover:  darken(@level-3-color, 6%);\n@level-3-color-active: darken(@level-3-color, 3%);\n\n\n// Accent (Custom) -----------------\n@accent-luma:             luma( hsl(@ui-hue, 50%, 50%) ); // get lightness of current hue\n\n// used for marker, inputs (smaller things)\n@accent-color:            mix( hsv( @ui-hue, 60%, 60%), hsl( @ui-hue, 100%, 68%), @accent-luma * 2 ); // mix hsv + hsl (favor hsl for dark, hsv for light colors)\n@accent-text-color:       contrast(@accent-color, hsl(@ui-hue,100%,16%), #fff, 40% );\n\n// used for button, tooltip (larger things)\n@accent-bg-color:         mix( hsv( @ui-hue, 40%, 72%), hsl( @ui-hue, 100%, 66%), @accent-luma * 2 ); // mix hsv + hsl (favor hsl for dark, hsv for light colors)\n@accent-bg-text-color:    contrast(@accent-bg-color, hsl(@ui-hue,100%,10%), #fff, 40% );\n\n// used for text only\n@accent-only-text-color: mix( hsv( @ui-hue, 70%, 50%), hsl( @ui-hue, 100%, 60%), @accent-luma * 2 ); // mix hsv + hsl (favor hsl for dark, hsv for light colors)\n\n\n// Components (Custom) -----------------\n@badge-background-color:            @background-color-selected;\n\n@button-text-color-selected:        @accent-bg-text-color;\n@button-border-color-selected:      @accent-color;\n\n@checkbox-background-color:         fade(@accent-bg-color, 33%);\n\n@input-background-color-focus:      hsl(@ui-hue, 100%, 96%);\n@input-selection-color:             mix( hsv( @ui-hue, 33%, 95%), hsl( @ui-hue, 100%, 98%), @accent-luma * 2 ); // mix hsv + hsl (favor hsl for dark, hsv for light colors)\n@input-selection-color-focus:       mix( hsv( @ui-hue, 44%, 90%), hsl( @ui-hue, 100%, 94%), @accent-luma * 2 ); // mix hsv + hsl (favor hsl for dark, hsv for light colors)\n\n@overlay-backdrop-color:            hsl(@ui-hue, @ui-saturation*0.4, @ui-lightness*0.8);\n@overlay-backdrop-opacity:          .66;\n\n@progress-background-color:         @accent-color;\n\n@scrollbar-color:                   darken(@level-3-color, 14%);\n@scrollbar-background-color:        @level-3-color; // replaced `transparent` with a solid color to test https://github.com/atom/one-light-ui/issues/4\n@scrollbar-color-editor:            contrast(@ui-syntax-color, darken(@ui-syntax-color, 14%), lighten(@ui-syntax-color, 9%) );\n@scrollbar-background-color-editor: @ui-syntax-color;\n\n@tab-text-color:                    @text-color-subtle;\n@tab-text-color-active:             @text-color-highlight;\n@tab-text-color-editor:             contrast(@ui-syntax-color, lighten(@ui-syntax-color, 70%), @text-color-highlight );\n@tab-background-color-editor:       @ui-syntax-color;\n@tab-inactive-status-added:         fade(@text-color-success, 77%);\n@tab-inactive-status-modified:      fade(@text-color-warning, 77%);\n\n@tooltip-background-color:          @accent-bg-color;\n@tooltip-text-color:                @accent-bg-text-color;\n@tooltip-text-key-color:            @tooltip-background-color;\n@tooltip-background-key-color:      @tooltip-text-color;\n\n\n// Sizes (Custom) -----------------\n\n@ui-size:                 1em;\n@ui-input-size:           @ui-size*1.15;\n@ui-padding:              @ui-size*1.5;\n@ui-padding-pane:         @ui-size*.5;\n@ui-padding-icon:         @ui-padding/3.3;\n@ui-line-height:          @ui-size*2;\n@ui-tab-height:           @ui-size*2.5;\n\n\n\n\n\n// Packages variables\n// These variables are used to override packages\n// ----------------------------------------------\n\n@settings-list-background-color: darken(@level-2-color, 3%);\n@theme-config-box-shadow: inset 0 1px 2px hsla(0, 0%, 0%, .2), 0 1px 0 hsla(0, 0%, 100%, .3);\n@theme-config-box-shadow-selected: inset 0 1px 3px hsla(0, 0%, 0%, .2);\n@theme-config-border-selected: hsla(0, 0%, 0%, .5);\n\n\n// Debug\n// Output variables to the top of the UI\n// -------------------------------------\n\n// html:before {\n//   content: "@{variable}";\n// }\n',digest:"797f68af101f1f0e6bc480b67e1b8bf0789d49be"},"node_modules/one-light-ui/styles/ui-variables.less":{content:'\n@import "ui-variables-custom.less"; // import colors and custom variables\n\n// ONE light UI variables\n// ----------------------------------------------\n\n// Official variables\n// These variables must be defined in every theme\n// Source: https://github.com/atom/atom/blob/master/static/variables/ui-variables.less\n// ----------------------------------------------\n\n\n// Text -----------------\n@text-color:            @ui-fg;\n@text-color-subtle:     lighten(@text-color, 30%);\n@text-color-highlight:  darken(@text-color, 12%);\n@text-color-selected:   darken(@text-color-highlight, 12%);\n\n@text-color-info:    hsl(208, 100%, 54%);\n@text-color-success: hsl(132,  60%, 44%);\n@text-color-warning: hsl( 37,  90%, 44%);\n@text-color-error:   hsl(  0,  90%, 56%);\n\n\n// Background -----------------\n@background-color-info:    hsl(208, 100%, 56%);\n@background-color-success: hsl(132,  52%, 48%);\n@background-color-warning: hsl( 40,  60%, 48%);\n@background-color-error:   hsl(  5,  72%, 56%);\n\n@background-color-highlight: darken(@level-3-color, 2%);\n@background-color-selected:  darken(@level-3-color, 6%);\n\n@app-background-color: @level-3-color;\n\n\n// Base -----------------\n@base-background-color: @ui-bg;\n@base-border-color:     @ui-border;\n\n\n// Components -----------------\n@pane-item-background-color:       @base-background-color;\n@pane-item-border-color:           @base-border-color;\n\n@input-background-color:           @level-1-color;\n@input-border-color:               @base-border-color;\n\n@tool-panel-background-color:      @level-3-color;\n@tool-panel-border-color:          @base-border-color;\n\n@inset-panel-background-color:     lighten(@level-2-color, 4%);\n@inset-panel-border-color:         fadeout(@base-border-color, 15%);\n\n@panel-heading-background-color:   @level-2-color;\n@panel-heading-border-color:       @base-border-color;\n\n@overlay-background-color:         mix(@level-2-color, @level-3-color);\n@overlay-border-color:             @base-border-color;\n\n@button-background-color:          @level-1-color;\n@button-background-color-hover:    darken(@button-background-color, 4%);\n@button-background-color-selected: @accent-bg-color;\n@button-border-color:              @base-border-color;\n\n@tab-bar-background-color:         @level-3-color;\n@tab-bar-border-color:             @base-border-color;\n@tab-background-color:             @level-3-color;\n@tab-background-color-active:      @level-2-color;\n@tab-border-color:                 @base-border-color;\n\n@tree-view-background-color:       @level-3-color;\n@tree-view-border-color:           @base-border-color;\n\n@ui-site-color-1: hsl(208, 100%, 56%); // blue\n@ui-site-color-2: hsl(132,  48%, 48%); // green\n@ui-site-color-3: hsl( 40,  60%, 52%); // orange\n@ui-site-color-4: #D831B0;             // pink\n@ui-site-color-5: #EBDD5B;             // yellow\n\n\n// Sizes -----------------\n@font-size:               12px;\n@input-font-size:         14px;\n@disclosure-arrow-size:   12px;\n\n@component-padding:       10px;\n@component-icon-padding:  5px;\n@component-icon-size:     16px; // needs to stay 16px to look sharpest\n@component-line-height:   25px;\n@component-border-radius: 3px;\n\n@tab-height:              30px;\n\n\n// Font -----------------\n@font-family: system-ui;\n',digest:"c1d2e4d444fcc41f2bcc9db10193a2b0feb01d54"}},importedFilePathsByRelativeImportPath:{"node_modules/atom-dark-syntax/styles":["node_modules/atom-dark-syntax/styles/editor.less","node_modules/atom-dark-syntax/styles/syntax-variables.less","node_modules/atom-dark-syntax/styles/syntax.less"],"node_modules/atom-dark-ui/styles":["node_modules/atom-dark-ui/styles/atom.less","node_modules/atom-dark-ui/styles/buttons.less","node_modules/atom-dark-ui/styles/dropdowns.less","node_modules/atom-dark-ui/styles/editor.less","node_modules/atom-dark-ui/styles/git.less","node_modules/atom-dark-ui/styles/lists.less","node_modules/atom-dark-ui/styles/messages.less","node_modules/atom-dark-ui/styles/nav.less","node_modules/atom-dark-ui/styles/overlays.less","node_modules/atom-dark-ui/styles/panels.less","node_modules/atom-dark-ui/styles/panes.less","node_modules/atom-dark-ui/styles/progress.less","node_modules/atom-dark-ui/styles/sites.less","node_modules/atom-dark-ui/styles/tabs.less","node_modules/atom-dark-ui/styles/text.less","node_modules/atom-dark-ui/styles/tooltips.less","node_modules/atom-dark-ui/styles/tree-view.less","node_modules/atom-dark-ui/styles/ui-mixins.less","node_modules/atom-dark-ui/styles/ui-variables.less","node_modules/atom-dark-ui/styles/utilities.less"],"static/variables":["static/variables/octicon-mixins.less","static/variables/octicon-utf-codes.less","static/variables/syntax-variables.less","static/variables/ui-variables.less"],static:["static/atom-ui/README.md","static/atom-ui/_index.less","static/atom-ui/styles/badges.less","static/atom-ui/styles/button-groups.less","static/atom-ui/styles/buttons.less","static/atom-ui/styles/git-status.less","static/atom-ui/styles/icons.less","static/atom-ui/styles/inputs.less","static/atom-ui/styles/layout.less","static/atom-ui/styles/lists.less","static/atom-ui/styles/loading.less","static/atom-ui/styles/messages.less","static/atom-ui/styles/mixins/mixins.less","static/atom-ui/styles/modals.less","static/atom-ui/styles/panels.less","static/atom-ui/styles/private/README.md","static/atom-ui/styles/private/alerts.less","static/atom-ui/styles/private/close.less","static/atom-ui/styles/private/code.less","static/atom-ui/styles/private/forms.less","static/atom-ui/styles/private/links.less","static/atom-ui/styles/private/navs.less","static/atom-ui/styles/private/scaffolding.less","static/atom-ui/styles/private/sections.less","static/atom-ui/styles/private/tables.less","static/atom-ui/styles/private/utilities.less","static/atom-ui/styles/select-list.less","static/atom-ui/styles/site-colors.less","static/atom-ui/styles/text.less","static/atom-ui/styles/tooltip.less","static/atom-ui/styles/variables/variables.less","static/atom.less","static/babelrc.json","static/core-ui/_index.less","static/core-ui/cursors.less","static/core-ui/docks.less","static/core-ui/panels.less","static/core-ui/panes.less","static/core-ui/syntax.less","static/core-ui/text-editor.less","static/core-ui/title-bar.less","static/core-ui/workspace-view.less","static/icons/atomicons.woff","static/icons/octicons-2.1.2.woff","static/icons/octicons.less","static/icons/octicons.woff","static/images/octocat-spinner-128.gif","static/images/transparent-background.gif","static/index.html","static/index.js","static/jasmine.less","static/linux.less","static/normalize.less","static/scaffolding.less","static/variables/octicon-mixins.less","static/variables/octicon-utf-codes.less","static/variables/syntax-variables.less","static/variables/ui-variables.less"],"node_modules/atom-light-syntax/styles":["node_modules/atom-light-syntax/styles/editor.less","node_modules/atom-light-syntax/styles/syntax-variables.less","node_modules/atom-light-syntax/styles/syntax.less"],"node_modules/base16-tomorrow-dark-theme/styles":["node_modules/base16-tomorrow-dark-theme/styles/colors.less","node_modules/base16-tomorrow-dark-theme/styles/editor.less","node_modules/base16-tomorrow-dark-theme/styles/syntax/_base.less","node_modules/base16-tomorrow-dark-theme/styles/syntax/cs.less","node_modules/base16-tomorrow-dark-theme/styles/syntax/json.less","node_modules/base16-tomorrow-dark-theme/styles/syntax-variables.less"],"node_modules/base16-tomorrow-light-theme/styles":["node_modules/base16-tomorrow-light-theme/styles/colors.less","node_modules/base16-tomorrow-light-theme/styles/editor.less","node_modules/base16-tomorrow-light-theme/styles/syntax/_base.less","node_modules/base16-tomorrow-light-theme/styles/syntax/cs.less","node_modules/base16-tomorrow-light-theme/styles/syntax/json.less","node_modules/base16-tomorrow-light-theme/styles/syntax-variables.less"],"node_modules/one-dark-syntax/styles":["node_modules/one-dark-syntax/styles/colors.less","node_modules/one-dark-syntax/styles/editor.less","node_modules/one-dark-syntax/styles/syntax/_base.less","node_modules/one-dark-syntax/styles/syntax/c.less","node_modules/one-dark-syntax/styles/syntax/cpp.less","node_modules/one-dark-syntax/styles/syntax/cs.less","node_modules/one-dark-syntax/styles/syntax/css.less","node_modules/one-dark-syntax/styles/syntax/elixir.less","node_modules/one-dark-syntax/styles/syntax/gfm.less","node_modules/one-dark-syntax/styles/syntax/go.less","node_modules/one-dark-syntax/styles/syntax/ini.less","node_modules/one-dark-syntax/styles/syntax/java.less","node_modules/one-dark-syntax/styles/syntax/javascript.less","node_modules/one-dark-syntax/styles/syntax/json.less","node_modules/one-dark-syntax/styles/syntax/ng.less","node_modules/one-dark-syntax/styles/syntax/php.less","node_modules/one-dark-syntax/styles/syntax/python.less","node_modules/one-dark-syntax/styles/syntax/ruby.less","node_modules/one-dark-syntax/styles/syntax/typescript.less","node_modules/one-dark-syntax/styles/syntax-variables.less"],"node_modules/one-light-syntax/styles":["node_modules/one-light-syntax/styles/colors.less","node_modules/one-light-syntax/styles/editor.less","node_modules/one-light-syntax/styles/syntax/_base.less","node_modules/one-light-syntax/styles/syntax/c.less","node_modules/one-light-syntax/styles/syntax/cpp.less","node_modules/one-light-syntax/styles/syntax/cs.less","node_modules/one-light-syntax/styles/syntax/css.less","node_modules/one-light-syntax/styles/syntax/elixir.less","node_modules/one-light-syntax/styles/syntax/gfm.less","node_modules/one-light-syntax/styles/syntax/go.less","node_modules/one-light-syntax/styles/syntax/ini.less","node_modules/one-light-syntax/styles/syntax/java.less","node_modules/one-light-syntax/styles/syntax/javascript.less","node_modules/one-light-syntax/styles/syntax/json.less","node_modules/one-light-syntax/styles/syntax/ng.less","node_modules/one-light-syntax/styles/syntax/php.less","node_modules/one-light-syntax/styles/syntax/python.less","node_modules/one-light-syntax/styles/syntax/ruby.less","node_modules/one-light-syntax/styles/syntax/typescript.less","node_modules/one-light-syntax/styles/syntax-variables.less"],"node_modules/solarized-dark-syntax/styles":["node_modules/solarized-dark-syntax/styles/colors.less","node_modules/solarized-dark-syntax/styles/editor.less","node_modules/solarized-dark-syntax/styles/syntax/_base.less","node_modules/solarized-dark-syntax/styles/syntax/c.less","node_modules/solarized-dark-syntax/styles/syntax/coffee.less","node_modules/solarized-dark-syntax/styles/syntax/css.less","node_modules/solarized-dark-syntax/styles/syntax/go.less","node_modules/solarized-dark-syntax/styles/syntax/java.less","node_modules/solarized-dark-syntax/styles/syntax/javascript.less","node_modules/solarized-dark-syntax/styles/syntax/markdown.less","node_modules/solarized-dark-syntax/styles/syntax/markup.less","node_modules/solarized-dark-syntax/styles/syntax/php.less","node_modules/solarized-dark-syntax/styles/syntax/python.less","node_modules/solarized-dark-syntax/styles/syntax/ruby.less","node_modules/solarized-dark-syntax/styles/syntax/scala.less","node_modules/solarized-dark-syntax/styles/syntax/typescript.less","node_modules/solarized-dark-syntax/styles/syntax-variables.less"],"node_modules/solarized-light-syntax/styles":["node_modules/solarized-light-syntax/styles/colors.less","node_modules/solarized-light-syntax/styles/editor.less","node_modules/solarized-light-syntax/styles/syntax/_base.less","node_modules/solarized-light-syntax/styles/syntax/c.less","node_modules/solarized-light-syntax/styles/syntax/coffee.less","node_modules/solarized-light-syntax/styles/syntax/css.less","node_modules/solarized-light-syntax/styles/syntax/go.less","node_modules/solarized-light-syntax/styles/syntax/java.less","node_modules/solarized-light-syntax/styles/syntax/javascript.less","node_modules/solarized-light-syntax/styles/syntax/markdown.less","node_modules/solarized-light-syntax/styles/syntax/markup.less","node_modules/solarized-light-syntax/styles/syntax/php.less","node_modules/solarized-light-syntax/styles/syntax/python.less","node_modules/solarized-light-syntax/styles/syntax/ruby.less","node_modules/solarized-light-syntax/styles/syntax/scala.less","node_modules/solarized-light-syntax/styles/syntax/typescript.less","node_modules/solarized-light-syntax/styles/syntax-variables.less"],"node_modules/atom-light-ui/styles":["node_modules/atom-light-ui/styles/atom.less","node_modules/atom-light-ui/styles/buttons.less","node_modules/atom-light-ui/styles/editor.less","node_modules/atom-light-ui/styles/git.less","node_modules/atom-light-ui/styles/lists.less","node_modules/atom-light-ui/styles/messages.less","node_modules/atom-light-ui/styles/overlays.less","node_modules/atom-light-ui/styles/panels.less","node_modules/atom-light-ui/styles/panes.less","node_modules/atom-light-ui/styles/progress.less","node_modules/atom-light-ui/styles/sites.less","node_modules/atom-light-ui/styles/tabs.less","node_modules/atom-light-ui/styles/text.less","node_modules/atom-light-ui/styles/tooltips.less","node_modules/atom-light-ui/styles/tree-view.less","node_modules/atom-light-ui/styles/ui-mixins.less","node_modules/atom-light-ui/styles/ui-variables.less","node_modules/atom-light-ui/styles/utilities.less"],"node_modules/one-dark-ui/styles":["node_modules/one-dark-ui/styles/atom.less","node_modules/one-dark-ui/styles/badges.less","node_modules/one-dark-ui/styles/buttons.less","node_modules/one-dark-ui/styles/config.less","node_modules/one-dark-ui/styles/core.less","node_modules/one-dark-ui/styles/docks.less","node_modules/one-dark-ui/styles/dropdowns.less","node_modules/one-dark-ui/styles/editor.less","node_modules/one-dark-ui/styles/git.less","node_modules/one-dark-ui/styles/inputs.less","node_modules/one-dark-ui/styles/key-binding.less","node_modules/one-dark-ui/styles/lists.less","node_modules/one-dark-ui/styles/messages.less","node_modules/one-dark-ui/styles/modal.less","node_modules/one-dark-ui/styles/nav.less","node_modules/one-dark-ui/styles/notifications.less","node_modules/one-dark-ui/styles/packages.less","node_modules/one-dark-ui/styles/panels.less","node_modules/one-dark-ui/styles/panes.less","node_modules/one-dark-ui/styles/progress.less","node_modules/one-dark-ui/styles/settings.less","node_modules/one-dark-ui/styles/sites.less","node_modules/one-dark-ui/styles/status-bar.less","node_modules/one-dark-ui/styles/tabs.less","node_modules/one-dark-ui/styles/text.less","node_modules/one-dark-ui/styles/title-bar.less","node_modules/one-dark-ui/styles/tooltips.less","node_modules/one-dark-ui/styles/tree-view.less","node_modules/one-dark-ui/styles/ui-mixins.less","node_modules/one-dark-ui/styles/ui-variables-custom.less","node_modules/one-dark-ui/styles/ui-variables.less"],"node_modules/one-light-ui/styles":["node_modules/one-light-ui/styles/atom.less","node_modules/one-light-ui/styles/badges.less","node_modules/one-light-ui/styles/buttons.less","node_modules/one-light-ui/styles/config.less","node_modules/one-light-ui/styles/core.less","node_modules/one-light-ui/styles/docks.less","node_modules/one-light-ui/styles/dropdowns.less","node_modules/one-light-ui/styles/editor.less","node_modules/one-light-ui/styles/git.less","node_modules/one-light-ui/styles/inputs.less","node_modules/one-light-ui/styles/key-binding.less","node_modules/one-light-ui/styles/lists.less","node_modules/one-light-ui/styles/messages.less","node_modules/one-light-ui/styles/modal.less","node_modules/one-light-ui/styles/nav.less","node_modules/one-light-ui/styles/notifications.less","node_modules/one-light-ui/styles/packages.less","node_modules/one-light-ui/styles/panels.less","node_modules/one-light-ui/styles/panes.less","node_modules/one-light-ui/styles/progress.less","node_modules/one-light-ui/styles/settings.less","node_modules/one-light-ui/styles/sites.less","node_modules/one-light-ui/styles/status-bar.less","node_modules/one-light-ui/styles/tabs.less","node_modules/one-light-ui/styles/text.less","node_modules/one-light-ui/styles/title-bar.less","node_modules/one-light-ui/styles/tooltips.less","node_modules/one-light-ui/styles/tree-view.less","node_modules/one-light-ui/styles/ui-mixins.less","node_modules/one-light-ui/styles/ui-variables-custom.less","node_modules/one-light-ui/styles/ui-variables.less"]}};function generateSnapshot(){const outerScope=this;let process={};function get_process(){return process}function createElement(e){return{innerHTML:"",style:{}}}Object.defineProperties(process,{platform:{value:"linux",enumerable:!1},argv:{value:[],enumerable:!1},env:{value:{NODE_ENV:"production"},enumerable:!1}});let documentElement={textContent:"",style:{cssFloat:""}},document={};function get_document(){return document}Object.defineProperties(document,{createElement:{value:createElement,enumerable:!1},addEventListener:{value:function(){},enumerable:!1},documentElement:{value:documentElement,enumerable:!1},oninput:{value:{},enumerable:!1},onchange:{value:{},enumerable:!1}});let global={};function get_global(){return global}Object.defineProperties(global,{document:{value:document,enumerable:!1},process:{value:process,enumerable:!1},WeakMap:{value:WeakMap,enumerable:!1},isGeneratingSnapshot:{value:!0,enumerable:!1}});const globalFunctionNames=["USBOutTransferResult","USBIsochronousOutTransferResult","USBIsochronousOutTransferPacket","USBIsochronousInTransferResult","USBIsochronousInTransferPacket","USBInTransferResult","USBInterface","USBEndpoint","USBDevice","USBConnectionEvent","USBConfiguration","USBAlternateInterface","USB","NFC","BluetoothUUID","BluetoothRemoteGATTService","BluetoothRemoteGATTServer","BluetoothRemoteGATTDescriptor","BluetoothRemoteGATTCharacteristic","BluetoothDevice","BluetoothCharacteristicProperties","Bluetooth","WebAuthentication","PublicKeyCredential","AuthenticatorResponse","AuthenticatorAttestationResponse","AuthenticatorAssertionResponse","WebGLRenderingContext","WebGL2RenderingContext","Path2D","CanvasPattern","CanvasGradient","TextDetector","FaceDetector","DetectedText","DetectedFace","DetectedBarcode","BarcodeDetector","NavigationPreloadManager","SensorErrorEvent","Sensor","RelativeOrientationSensor","OrientationSensor","Magnetometer","LinearAccelerationSensor","Gyroscope","AmbientLightSensor","Accelerometer","AbsoluteOrientationSensor","webkitSpeechRecognitionEvent","webkitSpeechRecognitionError","webkitSpeechRecognition","webkitSpeechGrammarList","webkitSpeechGrammar","SpeechSynthesisUtterance","SpeechSynthesisEvent","RemotePlayback","RTCRtpSender","PushSubscriptionOptions","PushSubscription","PushManager","PresentationReceiver","PresentationConnectionList","PresentationRequest","PresentationConnectionCloseEvent","PresentationConnectionAvailableEvent","PresentationConnection","PresentationAvailability","Presentation","PermissionStatus","Permissions","PaymentResponse","PaymentRequestUpdateEvent","PaymentRequest","PaymentAddress","PaymentManager","Notification","VideoPlaybackQuality","TrackDefaultList","TrackDefault","CanvasCaptureMediaStreamTrack","PhotoCapabilities","MediaSettingsRange","ImageCapture","IDBObserverChanges","IDBObserver","IDBObservation","StorageManager","CompositorWorker","BudgetService","BroadcastChannel","SyncManager","BackgroundFetchRegistration","BackgroundFetchManager","BackgroundFetchFetch","AudioParamMap","XSLTProcessor","Worklet","VTTRegion","KeyframeEffectReadOnly","KeyframeEffect","DocumentTimeline","AnimationTimeline","AnimationPlaybackEvent","AnimationEffectTimingReadOnly","AnimationEffectTiming","AnimationEffectReadOnly","Animation","VisualViewport","SharedWorker","PerformanceServerTiming","SVGMPathElement","SVGDiscardElement","SVGAnimationElement","ResizeObserverEntry","ResizeObserver","PerformancePaintTiming","PerformanceObserverEntryList","PerformanceObserver","PerformanceNavigationTiming","IntersectionObserverEntry","IntersectionObserver","StaticRange","InputEvent","DOMRectReadOnly","DOMRect","DOMQuad","DOMPointReadOnly","DOMPoint","DOMMatrixReadOnly","DOMMatrix","ScrollTimeline","StylePropertyMapReadonly","StylePropertyMap","CSSVariableReferenceValue","CSSURLImageValue","CSSUnparsedValue","CSSUnitValue","CSSTranslation","CSSTransformValue","CSSTransformComponent","CSSStyleValue","CSSSkew","CSSScale","CSSRotation","CSSResourceValue","CSSPositionValue","CSSPerspective","CSSNumericValue","CSSMatrixComponent","CSSKeywordValue","CSSImageValue","VideoTrackList","VideoTrack","AudioTrackList","AudioTrack","AccessibleNodeList","AccessibleNode","webkitRTCPeerConnection","webkitMediaStream","WebSocket","WebGLVertexArrayObject","WebGLUniformLocation","WebGLTransformFeedback","WebGLTexture","WebGLSync","WebGLShaderPrecisionFormat","WebGLShader","WebGLSampler","WebGLRenderbuffer","WebGLQuery","WebGLProgram","WebGLFramebuffer","WebGLContextEvent","WebGLBuffer","WebGLActiveInfo","WaveShaperNode","TextEncoder","TextDecoder","SubtleCrypto","StorageEvent","Storage","StereoPannerNode","SourceBufferList","SourceBuffer","ServiceWorkerRegistration","ServiceWorkerContainer","ServiceWorker","ScriptProcessorNode","ScreenOrientation","Response","Request","RTCStatsReport","RTCSessionDescription","RTCRtpReceiver","RTCRtpContributingSource","RTCPeerConnectionIceEvent","RTCPeerConnection","RTCIceCandidate","RTCDataChannelEvent","RTCDataChannel","RTCCertificate","Plugin","PluginArray","PeriodicWave","PasswordCredential","PannerNode","OscillatorNode","OfflineAudioContext","OfflineAudioCompletionEvent","NetworkInformation","MimeType","MimeTypeArray","MediaStreamTrackEvent","MediaStreamTrack","MediaStreamEvent","MediaStream","MediaStreamAudioSourceNode","MediaStreamAudioDestinationNode","MediaSource","MediaRecorder","MediaKeys","MediaKeySystemAccess","MediaKeyStatusMap","MediaKeySession","MediaKeyMessageEvent","MediaEncryptedEvent","MediaElementAudioSourceNode","MediaDevices","MediaDeviceInfo","MIDIPort","MIDIOutputMap","MIDIOutput","MIDIMessageEvent","MIDIInputMap","MIDIInput","MIDIConnectionEvent","MIDIAccess","ImageBitmapRenderingContext","IIRFilterNode","IDBVersionChangeEvent","IDBTransaction","IDBRequest","IDBOpenDBRequest","IDBObjectStore","IDBKeyRange","IDBIndex","IDBFactory","IDBDatabase","IDBCursorWithValue","IDBCursor","Headers","GamepadEvent","Gamepad","GamepadButton","GainNode","FederatedCredential","EventSource","DynamicsCompressorNode","DeviceOrientationEvent","DeviceMotionEvent","DelayNode","DOMError","CryptoKey","Crypto","CredentialsContainer","Credential","ConvolverNode","ConstantSourceNode","CloseEvent","ChannelSplitterNode","ChannelMergerNode","CanvasRenderingContext2D","CacheStorage","Cache","BlobEvent","BiquadFilterNode","BeforeInstallPromptEvent","BatteryManager","BaseAudioContext","AudioScheduledSourceNode","AudioProcessingEvent","AudioParam","AudioNode","AudioListener","AudioDestinationNode","AudioContext","AudioBufferSourceNode","AudioBuffer","AppBannerPromptResult","AnalyserNode","postMessage","blur","focus","close","XPathResult","XPathExpression","XPathEvaluator","XMLSerializer","XMLHttpRequestUpload","XMLHttpRequestEventTarget","XMLHttpRequest","XMLDocument","Worker","Window","WheelEvent","ValidityState","VTTCue","URLSearchParams","URL","UIEvent","TreeWalker","TransitionEvent","TrackEvent","TouchList","TouchEvent","Touch","TimeRanges","TextTrackList","TextTrackCueList","TextTrackCue","TextTrack","TextMetrics","TextEvent","Text","TaskAttributionTiming","StyleSheetList","StyleSheet","ShadowRoot","Selection","SecurityPolicyViolationEvent","Screen","SVGViewElement","SVGUseElement","SVGUnitTypes","SVGTransformList","SVGTransform","SVGTitleElement","SVGTextPositioningElement","SVGTextPathElement","SVGTextElement","SVGTextContentElement","SVGTSpanElement","SVGSymbolElement","SVGSwitchElement","SVGStyleElement","SVGStringList","SVGStopElement","SVGSetElement","SVGScriptElement","SVGSVGElement","SVGRectElement","SVGRect","SVGRadialGradientElement","SVGPreserveAspectRatio","SVGPolylineElement","SVGPolygonElement","SVGPointList","SVGPoint","SVGPatternElement","SVGPathElement","SVGNumberList","SVGNumber","SVGMetadataElement","SVGMatrix","SVGMaskElement","SVGMarkerElement","SVGLinearGradientElement","SVGLineElement","SVGLengthList","SVGLength","SVGImageElement","SVGGraphicsElement","SVGGradientElement","SVGGeometryElement","SVGGElement","SVGForeignObjectElement","SVGFilterElement","SVGFETurbulenceElement","SVGFETileElement","SVGFESpotLightElement","SVGFESpecularLightingElement","SVGFEPointLightElement","SVGFEOffsetElement","SVGFEMorphologyElement","SVGFEMergeNodeElement","SVGFEMergeElement","SVGFEImageElement","SVGFEGaussianBlurElement","SVGFEFuncRElement","SVGFEFuncGElement","SVGFEFuncBElement","SVGFEFuncAElement","SVGFEFloodElement","SVGFEDropShadowElement","SVGFEDistantLightElement","SVGFEDisplacementMapElement","SVGFEDiffuseLightingElement","SVGFEConvolveMatrixElement","SVGFECompositeElement","SVGFEComponentTransferElement","SVGFEColorMatrixElement","SVGFEBlendElement","SVGEllipseElement","SVGElement","SVGDescElement","SVGDefsElement","SVGComponentTransferFunctionElement","SVGClipPathElement","SVGCircleElement","SVGAnimatedTransformList","SVGAnimatedString","SVGAnimatedRect","SVGAnimatedPreserveAspectRatio","SVGAnimatedNumberList","SVGAnimatedNumber","SVGAnimatedLengthList","SVGAnimatedLength","SVGAnimatedInteger","SVGAnimatedEnumeration","SVGAnimatedBoolean","SVGAnimatedAngle","SVGAnimateTransformElement","SVGAnimateMotionElement","SVGAnimateElement","SVGAngle","SVGAElement","Range","RadioNodeList","PromiseRejectionEvent","ProgressEvent","ProcessingInstruction","PopStateEvent","PointerEvent","PerformanceTiming","PerformanceResourceTiming","PerformanceNavigation","PerformanceMeasure","PerformanceMark","PerformanceLongTaskTiming","PerformanceEntry","Performance","PageTransitionEvent","NodeList","NodeIterator","NodeFilter","Node","Navigator","NamedNodeMap","MutationRecord","MutationObserver","MutationEvent","MouseEvent","MessagePort","MessageEvent","MessageChannel","MediaQueryListEvent","MediaQueryList","MediaList","MediaError","Location","KeyboardEvent","InputDeviceCapabilities","ImageData","ImageBitmap","IdleDeadline","History","HashChangeEvent","HTMLVideoElement","HTMLUnknownElement","HTMLUListElement","HTMLTrackElement","HTMLTitleElement","HTMLTextAreaElement","HTMLTemplateElement","HTMLTableSectionElement","HTMLTableRowElement","HTMLTableElement","HTMLTableColElement","HTMLTableCellElement","HTMLTableCaptionElement","HTMLStyleElement","HTMLSpanElement","HTMLSourceElement","HTMLSlotElement","HTMLShadowElement","HTMLSelectElement","HTMLScriptElement","HTMLQuoteElement","HTMLProgressElement","HTMLPreElement","HTMLPictureElement","HTMLParamElement","HTMLParagraphElement","HTMLOutputElement","HTMLOptionsCollection","Option","HTMLOptionElement","HTMLOptGroupElement","HTMLObjectElement","HTMLOListElement","HTMLModElement","HTMLMeterElement","HTMLMetaElement","HTMLMenuElement","HTMLMediaElement","HTMLMarqueeElement","HTMLMapElement","HTMLLinkElement","HTMLLegendElement","HTMLLabelElement","HTMLLIElement","HTMLInputElement","Image","HTMLImageElement","HTMLIFrameElement","HTMLHtmlElement","HTMLHeadingElement","HTMLHeadElement","HTMLHRElement","HTMLFrameSetElement","HTMLFrameElement","HTMLFormElement","HTMLFormControlsCollection","HTMLFontElement","HTMLFieldSetElement","HTMLEmbedElement","HTMLElement","HTMLDocument","HTMLDivElement","HTMLDirectoryElement","HTMLDialogElement","HTMLDetailsElement","HTMLDataListElement","HTMLDListElement","HTMLContentElement","HTMLCollection","HTMLCanvasElement","HTMLButtonElement","HTMLBodyElement","HTMLBaseElement","HTMLBRElement","Audio","HTMLAudioElement","HTMLAreaElement","HTMLAnchorElement","HTMLAllCollection","FormData","FontFaceSetLoadEvent","FontFace","FocusEvent","FileReader","FileList","File","EventTarget","Event","ErrorEvent","Element","DragEvent","DocumentType","DocumentFragment","Document","DataTransferItemList","DataTransferItem","DataTransfer","DOMTokenList","DOMStringMap","DOMStringList","DOMParser","DOMImplementation","DOMException","CustomEvent","CustomElementRegistry","CompositionEvent","Comment","ClipboardEvent","Clipboard","CharacterData","CSSViewportRule","CSSSupportsRule","CSSStyleSheet","CSSStyleRule","CSSStyleDeclaration","CSSRuleList","CSSRule","CSSPageRule","CSSNamespaceRule","CSSMediaRule","CSSKeyframesRule","CSSKeyframeRule","CSSImportRule","CSSGroupingRule","CSSFontFaceRule","CSS","CSSConditionRule","CDATASection","Blob","BeforeUnloadEvent","BarProp","Attr","ApplicationCacheErrorEvent","ApplicationCache","AnimationEvent","WebKitCSSMatrix","WebKitMutationObserver","WebKitAnimationEvent","WebKitTransitionEvent","onerror","onload","stop","open","alert","confirm","prompt","print","requestAnimationFrame","cancelAnimationFrame","requestIdleCallback","cancelIdleCallback","captureEvents","releaseEvents","getComputedStyle","matchMedia","moveTo","moveBy","resizeTo","resizeBy","getSelection","find","getMatchedCSSRules","webkitRequestAnimationFrame","webkitCancelAnimationFrame","btoa","atob","setTimeout","clearTimeout","setInterval","clearInterval","createImageBitmap","scroll","scrollTo","scrollBy","fetch","getComputedStyleMap","webkitRequestFileSystem","webkitResolveLocalFileSystemURL","openDatabase","SharedArrayBuffer","Buffer","setImmediate","clearImmediate","require","BudgetState","WebView","measure","profile","dir","dirxml","profileEnd","clear","table","keys","values","debug","undebug","monitor","unmonitor","inspect","copy","getEventListeners","monitorEvents","unmonitorEvents","$","$$","$x"];let globalFunctionTrampoline=null;function makeGlobalPlaceholder(e){return function(){if(null===globalFunctionTrampoline)throw new Error(`Attempt to call ${e} during snapshot generation or before snapshotResult.setGlobals()`);if(void 0===globalFunctionTrampoline[e])throw new ReferenceError(`Global method ${e} was still not defined after the snapshot was loaded`);return void 0===new.target?globalFunctionTrampoline[e](...arguments):new globalFunctionTrampoline[e](...arguments)}}for(const e of globalFunctionNames){if(void 0!==outerScope[e])continue;const t=makeGlobalPlaceholder(e);Object.defineProperties(global,{[e]:{value:t,enumerable:!1}}),outerScope[e]=t}let window={};function get_window(){return window}Object.defineProperties(window,{document:{value:document,enumerable:!1},location:{value:{href:""},enumerable:!1},addEventListener:{value:function(){},enumerable:!1},screen:{value:{},enumerable:!1}});let console={};function consoleNoop(){throw new Error("Cannot use `console` functions in the snapshot.")}function get_console(){return console}Object.defineProperties(console,{debug:{value:consoleNoop,enumerable:!1},error:{value:consoleNoop,enumerable:!1},info:{value:consoleNoop,enumerable:!1},log:{value:consoleNoop,enumerable:!1},warn:{value:consoleNoop,enumerable:!1},time:{value:consoleNoop,enumerable:!1},timeEnd:{value:consoleNoop,enumerable:!1}});let require=e=>{throw new Error(`Cannot require module "${e}".\n`+"To use Node's require you need to call `snapshotResult.setGlobals` first!")};function customRequire(e){let t=customRequire.cache[e];if(!t){t={exports:{}};const o=e.split("/").slice(0,-1).join("/");customRequire.definitions.hasOwnProperty(e)?(customRequire.cache[e]=t,customRequire.definitions[e].apply(t.exports,[t.exports,t,e,o,customRequire,function define(e){e(customRequire,t.exports,t)}])):(t.exports=require(e),customRequire.cache[e]=t)}return t.exports}return customRequire.extensions={},customRequire.cache={},customRequire.definitions={"../src/initialize-application-window.js":function(e,t,o,n,s,r){(function(){var e,o,n,r,i;o=s("../src/atom-environment.js"),e=s("../src/application-delegate.js"),n=s("../src/clipboard.js"),r=s("../src/text-editor.js"),s("../src/text-editor-component.js"),s("../src/file-system-blob-store.js"),s("../src/native-compile-cache.js"),s("../src/compile-cache.js"),s("../src/module-cache.js"),get_global().isGeneratingSnapshot&&(s("../node_modules/about/lib/main.js"),s("../node_modules/archive-view/lib/archive-editor.js"),s("../node_modules/autocomplete-atom-api/lib/main.js"),s("../node_modules/autocomplete-css/lib/main.js"),s("../node_modules/autocomplete-html/lib/main.js"),s("../node_modules/autocomplete-plus/lib/main.js"),s("../node_modules/autocomplete-snippets/lib/autocomplete-snippets.js"),s("../node_modules/autoflow/lib/autoflow.js"),s("../node_modules/autosave/lib/autosave.js"),s("../node_modules/background-tips/lib/background-tips.js"),s("../node_modules/bookmarks/lib/main.js"),s("../node_modules/bracket-matcher/lib/main.js"),s("../node_modules/command-palette/lib/command-palette-package.js"),s("../node_modules/deprecation-cop/lib/main.js"),s("../node_modules/dev-live-reload/lib/main.js"),s("../node_modules/encoding-selector/lib/main.js"),s("../node_modules/exception-reporting/lib/main.js"),s("../node_modules/dalek/lib/main.js"),s("../node_modules/find-and-replace/lib/find.js"),s("../node_modules/fuzzy-finder/lib/main.js"),s("../node_modules/github/lib/index.js"),s("../node_modules/git-diff/lib/main.js"),s("../node_modules/go-to-line/lib/go-to-line-view.js"),s("../node_modules/grammar-selector/lib/main.js"),s("../node_modules/image-view/lib/main.js"),s("../node_modules/incompatible-packages/lib/main.js"),s("../node_modules/keybinding-resolver/lib/main.js"),s("../node_modules/language-c/lib/main.js"),s("../node_modules/language-html/lib/main.js"),s("../node_modules/language-javascript/lib/main.js"),s("../node_modules/language-ruby/lib/main.js"),s("../node_modules/language-typescript/lib/main.js"),s("../node_modules/line-ending-selector/lib/main.js"),s("../node_modules/link/lib/link.js"),s("../node_modules/markdown-preview/lib/main.js"),s("../node_modules/metrics/lib/metrics.js"),s("../node_modules/notifications/lib/main.js"),s("../node_modules/open-on-github/lib/main.js"),s("../node_modules/package-generator/lib/main.js"),s("../node_modules/settings-view/lib/main.js"),s("../node_modules/snippets/lib/snippets.js"),s("../node_modules/spell-check/lib/main.js"),s("../node_modules/status-bar/lib/main.js"),s("../node_modules/styleguide/lib/styleguide.js"),s("../node_modules/symbols-view/lib/main.js"),s("../node_modules/tabs/lib/main.js"),s("../node_modules/timecop/lib/main.js"),s("../node_modules/tree-view/lib/main.js"),s("../node_modules/update-package-dependencies/lib/update-package-dependencies.js"),s("../node_modules/welcome/lib/main.js"),s("../node_modules/whitespace/lib/main.js"),s("../node_modules/wrap-guide/lib/main.js")),i=new n,r.setClipboard(i),r.viewForItem=function(e){return atom.views.getView(e)},get_global().atom=new o({clipboard:i,applicationDelegate:new e,enablePersistence:!0}),r.setScheduler(get_global().atom.views),get_global().atom.preloadPackages(),t.exports=function(e){var t,o,n,r,i,a,l,d,u,c;return o=e.blobStore,c=s("../src/update-process-env.js").updateProcessEnv,l=s("path"),s("../src/window.js"),i=s("../src/get-window-load-settings.js"),a=s("electron").ipcRenderer,u=(d=i()).resourcePath,n=d.devMode,d.env,s("../src/electron-shims.js"),r=l.join(u,"exports"),s("module").globalPaths.push(r),get_process().env.NODE_PATH=r,n||null==(t=get_process().env).NODE_ENV&&(t.NODE_ENV="production"),get_global().atom.initialize({window:get_window(),document:get_document(),blobStore:o,configDirPath:get_process().env.ATOM_HOME,env:get_process().env}),get_global().atom.startEditorWindow().then(function(){var e;return e=function(){return get_window().removeEventListener("focus",e),setTimeout(function(){return get_document().querySelector("atom-workspace").focus()},0)},get_window().addEventListener("focus",e),a.on("environment",function(e,t){return c(t)})})}}).call(this)},"../src/atom-environment.js":function(e,t,o,n,s,r){let i,a,l;function get_path(){return a=a||s("path")}let{ipcRenderer:d}={};const u=s("../node_modules/underscore-plus/lib/underscore-plus.js"),{deprecate:c}=s("../node_modules/grim/lib/grim.js"),{CompositeDisposable:m,Disposable:p,Emitter:h}=s("../node_modules/event-kit/dist/event-kit.js"),f=s("../node_modules/fs-plus/lib/fs-plus.js"),{mapSourcePosition:g}=s("../node_modules/@atom/source-map-support/source-map-support.js"),b=s("../src/window-event-handler.js"),_=s("../src/state-store.js"),y=s("../src/register-default-commands.js"),{updateProcessEnv:v}=s("../src/update-process-env.js"),j=s("../src/config-schema.js"),w=s("../src/deserializer-manager.js"),k=s("../src/view-registry.js"),x=s("../src/notification-manager.js"),S=s("../src/config.js"),C=s("../src/keymap-extensions.js"),P=s("../src/tooltip-manager.js"),R=s("../src/command-registry.js"),T=s("../src/uri-handler-registry.js"),E=s("../src/grammar-registry.js"),{HistoryManager:D}=s("../src/history-manager.js"),L=s("../src/reopen-project-menu-manager.js"),I=s("../src/style-manager.js"),M=s("../src/package-manager.js"),A=s("../src/theme-manager.js"),O=s("../src/menu-manager.js"),F=s("../src/context-menu-manager.js"),N=s("../src/command-installer.js"),B=s("../src/core-uri-handlers.js"),q=s("../src/protocol-handler-installer.js"),U=s("../src/project.js"),z=s("../src/title-bar.js"),V=s("../src/workspace.js"),W=s("../src/pane-container.js"),H=s("../src/pane-axis.js"),$=s("../src/pane.js"),G=s("../src/dock.js"),K=s("../src/text-editor.js"),Y=s("../node_modules/text-buffer/lib/text-buffer.js"),Q=s("../src/text-editor-registry.js"),J=s("../src/auto-update-manager.js");let X;function get_stat(){return X=X||function get_util(){return l=l||s("../node_modules/util/util.js")}().promisify(f.stat)}let Z=0;class AtomEnvironment{constructor(e={}){this.id=null!=e.id?e.id:Z++,this.clipboard=e.clipboard,this.updateProcessEnv=e.updateProcessEnv||v,this.enablePersistence=e.enablePersistence,this.applicationDelegate=e.applicationDelegate,this.nextProxyRequestId=0,this.unloading=!1,this.loadTime=null,this.emitter=new h,this.disposables=new m,this.pathsWithWaitSessions=new Set,this.deserializers=new w(this),this.deserializeTimings={},this.views=new k(this),this.notifications=new x,this.stateStore=new _("AtomEnvironments",1),this.config=new S({saveCallback:e=>{this.enablePersistence&&this.applicationDelegate.setUserSettings(e,this.config.getUserConfigPath())}}),this.config.setSchema(null,{type:"object",properties:u.clone(j)}),this.keymaps=new C({notificationManager:this.notifications}),this.tooltips=new P({keymapManager:this.keymaps,viewRegistry:this.views}),this.commands=new R,this.uriHandlerRegistry=new T,this.grammars=new E({config:this.config}),this.styles=new I,this.packages=new M({config:this.config,styleManager:this.styles,commandRegistry:this.commands,keymapManager:this.keymaps,notificationManager:this.notifications,grammarRegistry:this.grammars,deserializerManager:this.deserializers,viewRegistry:this.views,uriHandlerRegistry:this.uriHandlerRegistry}),this.themes=new A({packageManager:this.packages,config:this.config,styleManager:this.styles,notificationManager:this.notifications,viewRegistry:this.views}),this.menu=new O({keymapManager:this.keymaps,packageManager:this.packages}),this.contextMenu=new F({keymapManager:this.keymaps}),this.packages.setMenuManager(this.menu),this.packages.setContextMenuManager(this.contextMenu),this.packages.setThemeManager(this.themes),this.project=new U({notificationManager:this.notifications,packageManager:this.packages,grammarRegistry:this.grammars,config:this.config,applicationDelegate:this.applicationDelegate}),this.commandInstaller=new N(this.applicationDelegate),this.protocolHandlerInstaller=new q,this.textEditors=new Q({config:this.config,grammarRegistry:this.grammars,assert:this.assert.bind(this),packageManager:this.packages}),this.workspace=new V({config:this.config,project:this.project,packageManager:this.packages,grammarRegistry:this.grammars,deserializerManager:this.deserializers,notificationManager:this.notifications,applicationDelegate:this.applicationDelegate,viewRegistry:this.views,assert:this.assert.bind(this),textEditorRegistry:this.textEditors,styleManager:this.styles,enablePersistence:this.enablePersistence}),this.themes.workspace=this.workspace,this.autoUpdater=new J({applicationDelegate:this.applicationDelegate}),this.keymaps.canLoadBundledKeymapsFromMemory()&&this.keymaps.loadBundledKeymaps(),this.registerDefaultCommands(),this.registerDefaultOpeners(),this.registerDefaultDeserializers(),this.windowEventHandler=new b({atomEnvironment:this,applicationDelegate:this.applicationDelegate}),this.history=new D({project:this.project,commands:this.commands,stateStore:this.stateStore}),this.disposables.add(this.history.onDidChangeProjects(e=>{e.reloaded||this.applicationDelegate.didChangeHistoryManager()}))}initialize(e={}){s("../src/text-editor-element.js"),this.window=e.window,this.document=e.document,this.blobStore=e.blobStore,this.configDirPath=e.configDirPath;const{devMode:t,safeMode:o,resourcePath:n,userSettings:r,projectSpecification:i}=this.getLoadSettings();j.projectHome={type:"string",default:get_path().join(f.getHomeDirectory(),"github"),description:"The directory where projects are assumed to be located. Packages created using the Package Generator will be stored here by default."},this.config.initialize({mainSource:this.enablePersistence&&get_path().join(this.configDirPath,"config.cson"),projectHomeSchema:j.projectHome}),this.config.resetUserSettings(r),null!=i&&null!=i.config&&this.project.replace(i),this.menu.initialize({resourcePath:n}),this.contextMenu.initialize({resourcePath:n,devMode:t}),this.keymaps.configDirPath=this.configDirPath,this.keymaps.resourcePath=n,this.keymaps.devMode=t,this.keymaps.canLoadBundledKeymapsFromMemory()||this.keymaps.loadBundledKeymaps(),this.commands.attach(this.window),this.styles.initialize({configDirPath:this.configDirPath}),this.packages.initialize({devMode:t,configDirPath:this.configDirPath,resourcePath:n,safeMode:o}),this.themes.initialize({configDirPath:this.configDirPath,resourcePath:n,safeMode:o,devMode:t}),this.commandInstaller.initialize(this.getVersion()),this.uriHandlerRegistry.registerHostHandler("core",B.create(this)),this.autoUpdater.initialize(),this.protocolHandlerInstaller.initialize(this.config,this.notifications),this.themes.loadBaseStylesheets(),this.initialStyleElements=this.styles.getSnapshot(),e.onlyLoadBaseStyleSheets&&(this.themes.initialLoadComplete=!0),this.setBodyPlatformClass(),this.stylesElement=this.styles.buildStylesElement(),this.document.head.appendChild(this.stylesElement),this.keymaps.subscribeToFileReadFailure(),this.installUncaughtErrorHandler(),this.attachSaveStateListeners(),this.windowEventHandler.initialize(this.window,this.document);const a=this.didChangeStyles.bind(this);this.disposables.add(this.styles.onDidAddStyleElement(a)),this.disposables.add(this.styles.onDidUpdateStyleElement(a)),this.disposables.add(this.styles.onDidRemoveStyleElement(a)),this.observeAutoHideMenuBar(),this.disposables.add(this.applicationDelegate.onDidChangeHistoryManager(()=>this.history.loadState()))}preloadPackages(){return this.packages.preloadPackages()}attachSaveStateListeners(){const e=u.debounce(()=>{this.window.requestIdleCallback(()=>{this.unloading||this.saveState({isUnloading:!1})})},this.saveStateDebounceInterval);this.document.addEventListener("mousedown",e,!0),this.document.addEventListener("keydown",e,!0),this.disposables.add(new p(()=>{this.document.removeEventListener("mousedown",e,!0),this.document.removeEventListener("keydown",e,!0)}))}registerDefaultDeserializers(){this.deserializers.add(V),this.deserializers.add(W),this.deserializers.add(H),this.deserializers.add($),this.deserializers.add(G),this.deserializers.add(U),this.deserializers.add(K),this.deserializers.add(Y)}registerDefaultCommands(){y({commandRegistry:this.commands,config:this.config,commandInstaller:this.commandInstaller,notificationManager:this.notifications,project:this.project,clipboard:this.clipboard})}registerDefaultOpeners(){this.workspace.addOpener(e=>{switch(e){case"atom://.atom/stylesheet":return this.workspace.openTextFile(this.styles.getUserStyleSheetPath());case"atom://.atom/keymap":return this.workspace.openTextFile(this.keymaps.getUserKeymapPath());case"atom://.atom/config":return this.workspace.openTextFile(this.config.getUserConfigPath());case"atom://.atom/init-script":return this.workspace.openTextFile(this.getUserInitScriptPath())}})}registerDefaultTargetForKeymaps(){this.keymaps.defaultTarget=this.workspace.getElement()}observeAutoHideMenuBar(){this.disposables.add(this.config.onDidChange("core.autoHideMenuBar",({newValue:e})=>{this.setAutoHideMenuBar(e)})),this.config.get("core.autoHideMenuBar")&&this.setAutoHideMenuBar(!0)}async reset(){this.deserializers.clear(),this.registerDefaultDeserializers(),this.config.clear(),this.config.setSchema(null,{type:"object",properties:u.clone(j)}),this.keymaps.clear(),this.keymaps.loadBundledKeymaps(),this.commands.clear(),this.registerDefaultCommands(),this.styles.restoreSnapshot(this.initialStyleElements),this.menu.clear(),this.clipboard.reset(),this.notifications.clear(),this.contextMenu.clear(),await this.packages.reset(),this.workspace.reset(this.packages),this.registerDefaultOpeners(),this.project.reset(this.packages),this.workspace.subscribeToEvents(),this.grammars.clear(),this.textEditors.clear(),this.views.clear(),this.pathsWithWaitSessions.clear()}destroy(){this.project&&(this.disposables.dispose(),this.workspace&&this.workspace.destroy(),this.workspace=null,this.themes.workspace=null,this.project&&this.project.destroy(),this.project=null,this.commands.clear(),this.stylesElement&&this.stylesElement.remove(),this.autoUpdater.destroy(),this.uriHandlerRegistry.destroy(),this.uninstallWindowEventHandler())}onDidBeep(e){return this.emitter.on("did-beep",e)}onWillThrowError(e){return this.emitter.on("will-throw-error",e)}onDidThrowError(e){return this.emitter.on("did-throw-error",e)}onDidFailAssertion(e){return this.emitter.on("did-fail-assertion",e)}whenShellEnvironmentLoaded(e){return this.shellEnvironmentLoaded?(e(),new p):this.emitter.once("loaded-shell-environment",e)}inDevMode(){return null==this.devMode&&(this.devMode=this.getLoadSettings().devMode),this.devMode}inSafeMode(){return null==this.safeMode&&(this.safeMode=this.getLoadSettings().safeMode),this.safeMode}inSpecMode(){return null==this.specMode&&(this.specMode=this.getLoadSettings().isSpec),this.specMode}isFirstLoad(){return null==this.firstLoad&&(this.firstLoad=this.getLoadSettings().firstLoad),this.firstLoad}getVersion(){return null==this.appVersion&&(this.appVersion=this.getLoadSettings().appVersion),this.appVersion}getReleaseChannel(){const e=this.getVersion().match(/\d+\.\d+\.\d+(-([a-z]+)(\d+|-\w{4,})?)?$/);return e?e[2]?e[2]:"stable":"unrecognized"}isReleasedVersion(){return null!=this.getReleaseChannel().match(/stable|beta|nightly/)}getWindowLoadTime(){return this.loadTime}getLoadSettings(){return this.applicationDelegate.getWindowLoadSettings()}open(e){return this.applicationDelegate.open(e)}pickFolder(e){return this.applicationDelegate.pickFolder(e)}close(){return this.applicationDelegate.closeWindow()}getSize(){return this.applicationDelegate.getWindowSize()}setSize(e,t){return this.applicationDelegate.setWindowSize(e,t)}getPosition(){return this.applicationDelegate.getWindowPosition()}setPosition(e,t){return this.applicationDelegate.setWindowPosition(e,t)}getCurrentWindow(){return this.applicationDelegate.getCurrentWindow()}center(){return this.applicationDelegate.centerWindow()}focus(){return this.applicationDelegate.focusWindow(),this.window.focus()}show(){return this.applicationDelegate.showWindow()}hide(){return this.applicationDelegate.hideWindow()}reload(){return this.applicationDelegate.reloadWindow()}restartApplication(){return this.applicationDelegate.restartApplication()}isMaximized(){return this.applicationDelegate.isWindowMaximized()}maximize(){return this.applicationDelegate.maximizeWindow()}isFullScreen(){return this.applicationDelegate.isWindowFullScreen()}setFullScreen(e=!1){return this.applicationDelegate.setWindowFullScreen(e)}toggleFullScreen(){return this.setFullScreen(!this.isFullScreen())}async displayWindow(){await this.restoreWindowDimensions();const e=[this.restoreWindowBackground(),this.show(),this.focus()];this.windowDimensions&&this.windowDimensions.fullScreen&&e.push(this.setFullScreen(!0)),this.windowDimensions&&this.windowDimensions.maximized&&"darwin"!==get_process().platform&&e.push(this.maximize()),await Promise.all(e)}getWindowDimensions(){const e=this.getCurrentWindow(),[t,o]=e.getPosition(),[n,s]=e.getSize();return{x:t,y:o,width:n,height:s,maximized:e.isMaximized()}}setWindowDimensions({x:e,y:t,width:o,height:n}){const s=[];return null!=o&&null!=n&&s.push(this.setSize(o,n)),null!=e&&null!=t?s.push(this.setPosition(e,t)):s.push(this.center()),Promise.all(s)}isValidDimensions({x:e,y:t,width:o,height:n}={}){return o>0&&n>0&&e+o>0&&t+n>0}storeWindowDimensions(){this.windowDimensions=this.getWindowDimensions(),this.isValidDimensions(this.windowDimensions)&&localStorage.setItem("defaultWindowDimensions",JSON.stringify(this.windowDimensions))}getDefaultWindowDimensions(){const{windowDimensions:e}=this.getLoadSettings();if(e)return e;let t;try{t=JSON.parse(localStorage.getItem("defaultWindowDimensions"))}catch(e){get_console().warn("Error parsing default window dimensions",e),localStorage.removeItem("defaultWindowDimensions")}if(t&&this.isValidDimensions(t))return t;{const{width:e,height:t}=this.applicationDelegate.getPrimaryDisplayWorkAreaSize();return{x:0,y:0,width:Math.min(1024,e),height:t}}}async restoreWindowDimensions(){return this.windowDimensions&&this.isValidDimensions(this.windowDimensions)||(this.windowDimensions=this.getDefaultWindowDimensions()),await this.setWindowDimensions(this.windowDimensions),this.windowDimensions}restoreWindowBackground(){const e=get_window().localStorage.getItem("atom:window-background-color");e&&(this.backgroundStylesheet=get_document().createElement("style"),this.backgroundStylesheet.type="text/css",this.backgroundStylesheet.innerText=`html, body { background: ${e} !important; }`,get_document().head.appendChild(this.backgroundStylesheet))}storeWindowBackground(){if(this.inSpecMode())return;const e=this.window.getComputedStyle(this.workspace.getElement())["background-color"];this.window.localStorage.setItem("atom:window-background-color",e)}async startEditorWindow(){this.getLoadSettings().clearWindowState&&await this.stateStore.clear(),this.unloading=!1;const e=this.updateProcessEnvAndTriggerHooks(),t=this.loadState().then(async e=>{this.windowDimensions=e&&e.windowDimensions,this.getLoadSettings().headless||await this.displayWindow(),this.commandInstaller.installAtomCommand(!1,e=>{e&&get_console().warn(e.message)}),this.commandInstaller.installApmCommand(!1,e=>{e&&get_console().warn(e.message)}),this.disposables.add(this.applicationDelegate.onDidChangeUserSettings(e=>this.config.resetUserSettings(e))),this.disposables.add(this.applicationDelegate.onDidFailToReadUserSettings(e=>this.notifications.addError(e))),this.disposables.add(this.applicationDelegate.onDidOpenLocations(this.openLocations.bind(this))),this.disposables.add(this.applicationDelegate.onApplicationMenuCommand(this.dispatchApplicationMenuCommand.bind(this))),this.disposables.add(this.applicationDelegate.onContextMenuCommand(this.dispatchContextMenuCommand.bind(this))),this.disposables.add(this.applicationDelegate.onURIMessage(this.dispatchURIMessage.bind(this))),this.disposables.add(this.applicationDelegate.onDidRequestUnload(this.prepareToUnloadEditorWindow.bind(this))),this.listenForUpdates(),this.registerDefaultTargetForKeymaps(),this.packages.loadPackages();const t=Date.now();await this.deserialize(e),this.deserializeTimings.atom=Date.now()-t,"darwin"===get_process().platform&&"custom"===this.config.get("core.titleBar")&&(this.workspace.addHeaderPanel({item:new z({workspace:this.workspace,themes:this.themes,applicationDelegate:this.applicationDelegate})}),this.document.body.classList.add("custom-title-bar")),"darwin"===get_process().platform&&"custom-inset"===this.config.get("core.titleBar")&&(this.workspace.addHeaderPanel({item:new z({workspace:this.workspace,themes:this.themes,applicationDelegate:this.applicationDelegate})}),this.document.body.classList.add("custom-inset-title-bar")),"darwin"===get_process().platform&&"hidden"===this.config.get("core.titleBar")&&this.document.body.classList.add("hidden-title-bar"),this.document.body.appendChild(this.workspace.getElement()),this.backgroundStylesheet&&this.backgroundStylesheet.remove();let o=this.project.getPaths();this.disposables.add(this.project.onDidChangePaths(e=>{for(let t of o)this.pathsWithWaitSessions.has(t)&&!e.includes(t)&&this.applicationDelegate.didClosePathWithWaitSession(t);o=e,this.applicationDelegate.setProjectRoots(e)})),this.disposables.add(this.workspace.onDidDestroyPaneItem(({item:e})=>{const t=e.getPath&&e.getPath();this.pathsWithWaitSessions.has(t)&&this.applicationDelegate.didClosePathWithWaitSession(t)})),this.packages.activate(),this.keymaps.loadUserKeymap(),this.getLoadSettings().safeMode||this.requireUserInitScript(),this.menu.update(),await this.openInitialEmptyEditorIfNecessary()}),o=this.history.loadState().then(()=>{this.reopenProjectMenuManager=new L({menu:this.menu,commands:this.commands,history:this.history,config:this.config,open:e=>this.open({pathsToOpen:e})}),this.reopenProjectMenuManager.update()});return Promise.all([t,o,e])}serialize(e){return{version:this.constructor.version,project:this.project.serialize(e),workspace:this.workspace.serialize(),packageStates:this.packages.serialize(),grammars:this.grammars.serialize(),fullScreen:this.isFullScreen(),windowDimensions:this.windowDimensions}}async prepareToUnloadEditorWindow(){try{await this.saveState({isUnloading:!0})}catch(e){get_console().error(e)}const e=!this.workspace||await this.workspace.confirmClose({windowCloseRequested:!0,projectHasPaths:this.project.getPaths().length>0});return e&&(this.unloading=!0,await this.packages.deactivatePackages()),e}unloadEditorWindow(){this.project&&(this.storeWindowBackground(),this.saveBlobStoreSync())}saveBlobStoreSync(){this.enablePersistence&&this.blobStore.save()}openInitialEmptyEditorIfNecessary(){if(!this.config.get("core.openEmptyEditorOnStart"))return;const{hasOpenFiles:e}=this.getLoadSettings();return e||0!==this.workspace.getPaneItems().length?void 0:this.workspace.open(null)}installUncaughtErrorHandler(){this.previousWindowErrorHandler=this.window.onerror,this.window.onerror=((e,t,o,n,s)=>{const r=g({source:t,line:o,column:n});o=r.line,n=r.column,"<embedded>"===t&&(t=r.source);const i={message:e,url:t,line:o,column:n,originalError:s};let a=!0;i.preventDefault=(()=>{a=!1}),this.emitter.emit("will-throw-error",i),a&&this.openDevTools().then(()=>this.executeJavaScriptInDevTools('DevToolsAPI.showPanel("console")')),this.emitter.emit("did-throw-error",{message:e,url:t,line:o,column:n,originalError:s})})}uninstallUncaughtErrorHandler(){this.window.onerror=this.previousWindowErrorHandler}installWindowEventHandler(){this.windowEventHandler=new b({atomEnvironment:this,applicationDelegate:this.applicationDelegate}),this.windowEventHandler.initialize(this.window,this.document)}uninstallWindowEventHandler(){this.windowEventHandler&&this.windowEventHandler.unsubscribe(),this.windowEventHandler=null}didChangeStyles(e){K.didUpdateStyles(),e.textContent.indexOf("scrollbar")>=0&&K.didUpdateScrollbarStyles()}async updateProcessEnvAndTriggerHooks(){await this.updateProcessEnv(this.getLoadSettings().env),this.shellEnvironmentLoaded=!0,this.emitter.emit("loaded-shell-environment"),this.packages.triggerActivationHook("core:loaded-shell-environment")}beep(){this.config.get("core.audioBeep")&&this.applicationDelegate.playBeepSound(),this.emitter.emit("did-beep")}confirm(e={},t){if(!t)return this.applicationDelegate.confirm(e);this.applicationDelegate.confirm(e,t)}openDevTools(){return this.applicationDelegate.openWindowDevTools()}toggleDevTools(){return this.applicationDelegate.toggleWindowDevTools()}executeJavaScriptInDevTools(e){return this.applicationDelegate.executeJavaScriptInWindowDevTools(e)}assert(e,t,o){if(e)return!0;const n=new Error(`Assertion failed: ${t}`);if(Error.captureStackTrace(n,this.assert),o&&("function"==typeof o?o(n):n.metadata=o),this.emitter.emit("did-fail-assertion",n),!this.isReleasedVersion())throw n;return!1}loadThemes(){return this.themes.load()}setDocumentEdited(e){"function"==typeof this.applicationDelegate.setWindowDocumentEdited&&this.applicationDelegate.setWindowDocumentEdited(e)}setRepresentedFilename(e){"function"==typeof this.applicationDelegate.setWindowRepresentedFilename&&this.applicationDelegate.setWindowRepresentedFilename(e)}addProjectFolder(){return new Promise(e=>{this.pickFolder(t=>{this.addToProject(t||[]).then(e)})})}async addToProject(e){const t=await this.loadState(this.getStateKey(e));t&&0===this.project.getPaths().length?this.attemptRestoreProjectStateForPaths(t,e):e.map(e=>this.project.addPath(e))}async attemptRestoreProjectStateForPaths(e,t,o=[]){const n=this.workspace.getCenter();if((()=>{for(let e of this.workspace.getPaneContainers())for(let t of e.getPaneItems())if(t instanceof K){if(t.getPath()||t.isModified())return!1}else if(e===n)return!1;return!0})())return await this.restoreStateIntoThisEnvironment(e),Promise.all(o.map(e=>this.workspace.open(e)));{let e=null;const n=new Promise(t=>{e=t}),s=1===t.length?"folder":"folders";return this.confirm({message:"Previous automatically-saved project state detected",detail:`There is previously saved state for the selected ${s}. `+`Would you like to add the ${s} to this window, permanently discarding the saved state, `+`or open the ${s} in a new window, restoring the saved state?`,buttons:["&Open in new window and recover state","&Add to this window and discard state"]},n=>{if(0===n)this.open({pathsToOpen:t.concat(o),newWindow:!0,devMode:this.inDevMode(),safeMode:this.inSafeMode()}),e(Promise.resolve(null));else if(1===n){for(let e of t)this.project.addPath(e);e(Promise.all(o.map(e=>this.workspace.open(e))))}}),n}}restoreStateIntoThisEnvironment(e){e.fullScreen=this.isFullScreen();for(let e of this.workspace.getPanes())e.destroy();return this.deserialize(e)}showSaveDialogSync(e={}){return c("atom.showSaveDialogSync is deprecated and will be removed soon.\n      Please, implement ::saveAs and ::getSaveDialogOptions instead for pane items\n      or use Pane::saveItemAs for programmatic saving."),this.applicationDelegate.showSaveDialog(e)}async saveState(e,t){if(this.enablePersistence&&this.project){const o=this.serialize(e);t||(t=this.getStateKey(this.project&&this.project.getPaths())),t?await this.stateStore.save(t,o):await this.applicationDelegate.setTemporaryWindowState(o)}}loadState(e){return this.enablePersistence?(e||(e=this.getStateKey(this.getLoadSettings().initialProjectRoots)),e?this.stateStore.load(e):this.applicationDelegate.getTemporaryWindowState()):Promise.resolve(null)}async deserialize(e){if(!e)return Promise.resolve();this.setFullScreen(e.fullScreen);const t=[];this.packages.packageStates=e.packageStates||{};let o=Date.now();if(e.project)try{await this.project.deserialize(e.project,this.deserializers)}catch(e){e.missingProjectPaths||this.notifications.addError("Unable to deserialize project",{description:e.message,stack:e.stack})}if(this.deserializeTimings.project=Date.now()-o,e.grammars&&this.grammars.deserialize(e.grammars),o=Date.now(),e.workspace&&this.workspace.deserialize(e.workspace,this.deserializers),this.deserializeTimings.workspace=Date.now()-o,t.length>0){const e=1===t.length?"":t.length+" ",o=1===t.length?"folder":"folders",n=1===t.length?"is":"are",s=t.map(e=>`\`${e}\``);let r;switch(s.length){case 1:r=s[0];break;case 2:r=`${s[0]} and ${s[1]}`;break;default:r=s.slice(0,-1).join(", ")+`, and ${s[s.length-1]}`}this.notifications.addError(`Unable to open ${e}project ${o}`,{description:`Project ${o} ${r} ${n} no longer on disk.`})}}getStateKey(e){if(e&&e.length>0){return`editor-${function get_crypto(){return i=i||s("crypto")}().createHash("sha1").update(e.slice().sort().join("\n")).digest("hex")}`}return null}getConfigDirPath(){return this.configDirPath||(this.configDirPath=get_process().env.ATOM_HOME),this.configDirPath}getUserInitScriptPath(){return f.resolve(this.getConfigDirPath(),"init",["js","coffee"])||get_path().join(this.getConfigDirPath(),"init.coffee")}requireUserInitScript(){const e=this.getUserInitScriptPath();if(e)try{f.isFileSync(e)&&s(e)}catch(t){this.notifications.addError(`Failed to load \`${e}\``,{detail:t.message,dismissable:!0})}}onUpdateAvailable(e){return this.emitter.on("update-available",e)}updateAvailable(e){return this.emitter.emit("update-available",e)}listenForUpdates(){this.disposables.add(this.autoUpdater.onDidCompleteDownloadingUpdate(this.updateAvailable.bind(this)))}setBodyPlatformClass(){this.document.body.classList.add(`platform-${get_process().platform}`)}setAutoHideMenuBar(e){this.applicationDelegate.setAutoHideWindowMenuBar(e),this.applicationDelegate.setWindowMenuBarVisibility(!e)}dispatchApplicationMenuCommand(e,t){let{activeElement:o}=this.document;o===this.document.body&&(o=this.workspace.getElement()),this.commands.dispatch(o,e,t)}dispatchContextMenuCommand(e,...t){this.commands.dispatch(this.contextMenu.activeElement,e,t)}dispatchURIMessage(e){if(this.packages.hasLoadedInitialPackages())this.uriHandlerRegistry.handleURI(e);else{let t=this.packages.onDidLoadInitialPackages(()=>{t.dispose(),this.uriHandlerRegistry.handleURI(e)})}}async openLocations(e){const t=this.project&&0===this.project.getPaths().length,o=new Set,n=[],r=[],i=await Promise.all(e.map(async e=>{return{location:e,stats:e.pathToOpen?await get_stat()(e.pathToOpen).catch(()=>null):null}}));for(const{location:e,stats:t}of i){const{pathToOpen:s}=e;if(s){if(null!==t)t.isDirectory()?o.add(this.project.getDirectoryForProjectPath(s).getPath()):t.isFile()&&(e.isDirectory?r.push(e):n.push(e));else{const t=this.project.getProvidedDirectoryForProjectPath(s);t?o.add(t.getPath()):e.isDirectory?r.push(e):n.push(e)}e.hasWaitSession&&this.pathsWithWaitSessions.add(s)}else n.push(e)}let a=!1;if(o.size>0||r.length>0){const e=Array.from(o).concat(r.map(e=>e.pathToOpen)),s=await this.loadState(this.getStateKey(Array.from(e)));if(s&&t){const e=n.map(e=>e.pathToOpen);await this.attemptRestoreProjectStateForPaths(s,Array.from(o),e),a=!0}else for(let e of o)this.project.addPath(e)}if(!a){const e=[];for(const{pathToOpen:t,initialLine:o,initialColumn:s}of n)e.push(this.workspace&&this.workspace.open(t,{initialLine:o,initialColumn:s}));await Promise.all(e)}if(r.length>0){let e="Unable to open project folder";r.length>1&&(e+="s");let t="The ";1===r.length?(t+="directory `",t+=r[0].pathToOpen,t+="` does not exist."):2===r.length?(t+=`directories \`${r[0].pathToOpen}\` `,t+=`and \`${r[1].pathToOpen}\` do not exist.`):(t+="directories ",t+=r.slice(0,-1).map(e=>e.pathToOpen).map(e=>"`"+e+"`, ").join(""),t+="and `"+r[r.length-1].pathToOpen+"` do not exist."),this.notifications.addWarning(e,{description:t})}(function get_ipcRenderer(){return d=d||s("electron").ipcRenderer})().send("window-command","window:locations-opened")}resolveProxy(e){return new Promise((t,o)=>{const n=this.nextProxyRequestId++,s=this.applicationDelegate.onDidResolveProxy((e,o)=>{e===n&&(s.dispose(),t(o))});return this.applicationDelegate.resolveProxy(n,e)})}}AtomEnvironment.version=1,AtomEnvironment.prototype.saveStateDebounceInterval=1e3,t.exports=AtomEnvironment,Promise.prototype.done=function(e){return c("Atom now uses ES6 Promises instead of Q. Call promise.then instead of promise.done"),this.then(e)}},"../src/application-delegate.js":function(e,t,o,n,s,r){let{ipcRenderer:i,remote:a,shell:l}={};function get_ipcRenderer(){return i=i||s("electron").ipcRenderer}function get_remote(){return a=a||s("electron").remote}function get_shell(){return l=l||s("electron").shell}const d=s("../src/ipc-helpers.js"),{Emitter:u,Disposable:c}=s("../node_modules/event-kit/dist/event-kit.js"),m=s("../src/get-window-load-settings.js");t.exports=class ApplicationDelegate{constructor(){this.pendingSettingsUpdateCount=0,this._ipcMessageEmitter=null}ipcMessageEmitter(){return this._ipcMessageEmitter||(this._ipcMessageEmitter=new u,get_ipcRenderer().on("message",(e,t,o)=>{this._ipcMessageEmitter.emit(t,o)})),this._ipcMessageEmitter}getWindowLoadSettings(){return m()}open(e){return get_ipcRenderer().send("open",e)}pickFolder(e){return get_ipcRenderer().on("atom-pick-folder-response",function(t,o){return get_ipcRenderer().removeAllListeners("atom-pick-folder-response"),e(o)}),get_ipcRenderer().send("pick-folder","atom-pick-folder-response")}getCurrentWindow(){return get_remote().getCurrentWindow()}closeWindow(){return d.call("window-method","close")}async getTemporaryWindowState(){const e=await d.call("get-temporary-window-state");return JSON.parse(e)}setTemporaryWindowState(e){return d.call("set-temporary-window-state",JSON.stringify(e))}getWindowSize(){const[e,t]=Array.from(get_remote().getCurrentWindow().getSize());return{width:e,height:t}}setWindowSize(e,t){return d.call("set-window-size",e,t)}getWindowPosition(){const[e,t]=Array.from(get_remote().getCurrentWindow().getPosition());return{x:e,y:t}}setWindowPosition(e,t){return d.call("set-window-position",e,t)}centerWindow(){return d.call("center-window")}focusWindow(){return d.call("focus-window")}showWindow(){return d.call("show-window")}hideWindow(){return d.call("hide-window")}reloadWindow(){return d.call("window-method","reload")}restartApplication(){return get_ipcRenderer().send("restart-application")}minimizeWindow(){return d.call("window-method","minimize")}isWindowMaximized(){return get_remote().getCurrentWindow().isMaximized()}maximizeWindow(){return d.call("window-method","maximize")}unmaximizeWindow(){return d.call("window-method","unmaximize")}isWindowFullScreen(){return get_remote().getCurrentWindow().isFullScreen()}setWindowFullScreen(e=!1){return d.call("window-method","setFullScreen",e)}onDidEnterFullScreen(e){return d.on(get_ipcRenderer(),"did-enter-full-screen",e)}onDidLeaveFullScreen(e){return d.on(get_ipcRenderer(),"did-leave-full-screen",e)}async openWindowDevTools(){return await new Promise(get_process().nextTick),d.call("window-method","openDevTools")}async closeWindowDevTools(){return await new Promise(get_process().nextTick),d.call("window-method","closeDevTools")}async toggleWindowDevTools(){return await new Promise(get_process().nextTick),d.call("window-method","toggleDevTools")}executeJavaScriptInWindowDevTools(e){return get_ipcRenderer().send("execute-javascript-in-dev-tools",e)}didClosePathWithWaitSession(e){return d.call("window-method","didClosePathWithWaitSession",e)}setWindowDocumentEdited(e){return d.call("window-method","setDocumentEdited",e)}setRepresentedFilename(e){return d.call("window-method","setRepresentedFilename",e)}addRecentDocument(e){return get_ipcRenderer().send("add-recent-document",e)}setProjectRoots(e){return d.call("window-method","setProjectRoots",e)}setAutoHideWindowMenuBar(e){return d.call("window-method","setAutoHideMenuBar",e)}setWindowMenuBarVisibility(e){return get_remote().getCurrentWindow().setMenuBarVisibility(e)}getPrimaryDisplayWorkAreaSize(){return get_remote().screen.getPrimaryDisplay().workAreaSize}getUserDefault(e,t){return get_remote().systemPreferences.getUserDefault(e,t)}async setUserSettings(e,t){this.pendingSettingsUpdateCount++;try{await d.call("set-user-settings",JSON.stringify(e),t)}finally{this.pendingSettingsUpdateCount--}}onDidChangeUserSettings(e){return this.ipcMessageEmitter().on("did-change-user-settings",t=>{0===this.pendingSettingsUpdateCount&&e(t)})}onDidFailToReadUserSettings(e){return this.ipcMessageEmitter().on("did-fail-to-read-user-setting",e)}confirm(e,t){if("function"==typeof t)e=Object.assign({type:"info",normalizeAccessKeys:!0},e),get_remote().dialog.showMessageBox(get_remote().getCurrentWindow(),e,t);else{let t,{message:o,detailedMessage:n,buttons:s}=e;s||(s={}),t=Array.isArray(s)?s:Object.keys(s);const r=get_remote().dialog.showMessageBox(get_remote().getCurrentWindow(),{type:"info",message:o,detail:n,buttons:t,normalizeAccessKeys:!0});if(Array.isArray(s))return r;{const e=s[t[r]];if("function"==typeof e)return e()}}}showMessageDialog(e){}showSaveDialog(e,t){if("function"!=typeof t)return"string"==typeof e&&(e={defaultPath:e}),this.getCurrentWindow().showSaveDialog(e);this.getCurrentWindow().showSaveDialog(e,t)}playBeepSound(){return get_shell().beep()}onDidOpenLocations(e){return this.ipcMessageEmitter().on("open-locations",e)}onUpdateAvailable(e){return this.ipcMessageEmitter().on("did-begin-downloading-update",e)}onDidBeginDownloadingUpdate(e){return this.onUpdateAvailable(e)}onDidBeginCheckingForUpdate(e){return this.ipcMessageEmitter().on("checking-for-update",e)}onDidCompleteDownloadingUpdate(e){return this.ipcMessageEmitter().on("update-available",e)}onUpdateNotAvailable(e){return this.ipcMessageEmitter().on("update-not-available",e)}onUpdateError(e){return this.ipcMessageEmitter().on("update-error",e)}onApplicationMenuCommand(e){const t=(t,...o)=>e(...o);return get_ipcRenderer().on("command",t),new c(()=>get_ipcRenderer().removeListener("command",t))}onContextMenuCommand(e){const t=(t,...o)=>e(...o);return get_ipcRenderer().on("context-command",t),new c(()=>get_ipcRenderer().removeListener("context-command",t))}onURIMessage(e){const t=(t,...o)=>e(...o);return get_ipcRenderer().on("uri-message",t),new c(()=>get_ipcRenderer().removeListener("uri-message",t))}onDidRequestUnload(e){const t=async(t,o)=>{const n=await e(t);get_ipcRenderer().send("did-prepare-to-unload",n)};return get_ipcRenderer().on("prepare-to-unload",t),new c(()=>get_ipcRenderer().removeListener("prepare-to-unload",t))}onDidChangeHistoryManager(e){const t=(t,o)=>e(t);return get_ipcRenderer().on("did-change-history-manager",t),new c(()=>get_ipcRenderer().removeListener("did-change-history-manager",t))}didChangeHistoryManager(){return get_ipcRenderer().send("did-change-history-manager")}openExternal(e){return get_shell().openExternal(e)}checkForUpdate(){return get_ipcRenderer().send("command","application:check-for-update")}restartAndInstallUpdate(){return get_ipcRenderer().send("command","application:install-update")}getAutoUpdateManagerState(){return get_ipcRenderer().sendSync("get-auto-update-manager-state")}getAutoUpdateManagerErrorMessage(){return get_ipcRenderer().sendSync("get-auto-update-manager-error")}emitWillSavePath(e){return d.call("will-save-path",e)}emitDidSavePath(e){return d.call("did-save-path",e)}resolveProxy(e,t){return get_ipcRenderer().send("resolve-proxy",e,t)}onDidResolveProxy(e){const t=(t,o,n)=>e(o,n);return get_ipcRenderer().on("did-resolve-proxy",t),new c(()=>get_ipcRenderer().removeListener("did-resolve-proxy",t))}}},"../src/clipboard.js":function(e,t,o,n,s,r){let i;let{clipboard:a}={};function get_clipboard(){return a=a||s("electron").clipboard}t.exports=class Clipboard{constructor(){this.reset()}reset(){this.metadata=null,this.signatureForMetadata=null}md5(e){return function get_crypto(){return i=i||s("crypto")}().createHash("md5").update(e,"utf8").digest("hex")}write(e,t){this.signatureForMetadata=this.md5(e),this.metadata=t,get_clipboard().writeText(e)}read(){return get_clipboard().readText()}readWithMetadata(){const e=this.read();return this.signatureForMetadata===this.md5(e)?{text:e,metadata:this.metadata}:{text:e}}}},"../src/text-editor.js":function(e,t,o,n,s,r){const i=s("../node_modules/underscore-plus/lib/underscore-plus.js");let a;function get_path(){return a=a||s("path")}const l=s("../node_modules/fs-plus/lib/fs-plus.js"),d=s("../node_modules/grim/lib/grim.js"),u=s("../node_modules/dedent/dist/dedent.js"),{CompositeDisposable:c,Disposable:m,Emitter:p}=s("../node_modules/event-kit/dist/event-kit.js"),h=s("../node_modules/text-buffer/lib/text-buffer.js"),{Point:f,Range:g}=h,b=s("../src/decoration-manager.js"),_=s("../src/cursor.js"),y=s("../src/selection.js"),v=s("../src/null-grammar.js"),j=s("../src/text-mate-language-mode.js"),w=s("../src/scope-descriptor.js"),k=s("../node_modules/first-mate/lib/first-mate.js").ScopeSelector,x=s("../src/gutter-container.js");let S=null,C=null;const{isDoubleWidthCharacter:P,isHalfWidthCharacter:R,isKoreanCharacter:T,isWrapBoundary:E}=s("../src/text-utils.js"),D=/\S/;let L=0;function columnForIndentLevel(e,t,o){let n=0,s=0;const r=t*o;for(;s<r;){const t=e[n];if("\t"===t)s+=o-s%o;else{if(" "!==t)break;s++}n++}return n}function columnRangeForStartDelimiter(e,t){const o=e.search(D);if(-1===o)return null;if(!e.startsWith(t,o))return null;let n=o+t.length;return" "===e[n]&&n++,[o,n]}t.exports=class TextEditor{static setClipboard(e){this.clipboard=e}static setScheduler(e){return null==S&&(S=s("../src/text-editor-component.js")),S.setScheduler(e)}static didUpdateStyles(){return null==S&&(S=s("../src/text-editor-component.js")),S.didUpdateStyles()}static didUpdateScrollbarStyles(){return null==S&&(S=s("../src/text-editor-component.js")),S.didUpdateScrollbarStyles()}static viewForItem(e){return e.element||e}static deserialize(e,t){if(1!==e.version)return null;let o=e.tokenizedBuffer?e.tokenizedBuffer.bufferId:e.bufferId;try{if(e.buffer=t.project.bufferForIdSync(o),!e.buffer)return null}catch(e){if("read"===e.syscall)return;throw e}e.assert=t.assert.bind(t),delete e.readOnly,e.readOnly=e.readOnly2,delete e.readOnly2;const n=new TextEditor(e);if(e.registered){const e=t.textEditors.add(n);n.onDidDestroy(()=>e.dispose())}return n}constructor(e={}){if(null==this.constructor.clipboard)throw new Error("Must call TextEditor.setClipboard at least once before creating TextEditor instances");this.id=null!=e.id?e.id:L++,this.id>=L&&(L=this.id+1),this.initialScrollTopRow=e.initialScrollTopRow,this.initialScrollLeftColumn=e.initialScrollLeftColumn,this.decorationManager=e.decorationManager,this.selectionsMarkerLayer=e.selectionsMarkerLayer,this.mini=null!=e.mini&&e.mini,this.keyboardInputEnabled=null==e.keyboardInputEnabled||e.keyboardInputEnabled,this.readOnly=null!=e.readOnly&&e.readOnly,this.placeholderText=e.placeholderText,this.showLineNumbers=e.showLineNumbers,this.assert=e.assert||(e=>e),this.showInvisibles=null==e.showInvisibles||e.showInvisibles,this.autoHeight=e.autoHeight,this.autoWidth=e.autoWidth,this.scrollPastEnd=null!=e.scrollPastEnd&&e.scrollPastEnd,this.scrollSensitivity=null!=e.scrollSensitivity?e.scrollSensitivity:40,this.editorWidthInChars=e.editorWidthInChars,this.invisibles=e.invisibles,this.showIndentGuide=e.showIndentGuide,this.softWrapped=e.softWrapped,this.softWrapAtPreferredLineLength=e.softWrapAtPreferredLineLength,this.preferredLineLength=e.preferredLineLength,this.showCursorOnSelection=null==e.showCursorOnSelection||e.showCursorOnSelection,this.maxScreenLineLength=e.maxScreenLineLength,this.softTabs=null==e.softTabs||e.softTabs,this.autoIndent=null==e.autoIndent||e.autoIndent,this.autoIndentOnPaste=null==e.autoIndentOnPaste||e.autoIndentOnPaste,this.undoGroupingInterval=null!=e.undoGroupingInterval?e.undoGroupingInterval:300,this.softWrapped=null!=e.softWrapped&&e.softWrapped,this.softWrapAtPreferredLineLength=null!=e.softWrapAtPreferredLineLength&&e.softWrapAtPreferredLineLength,this.preferredLineLength=null!=e.preferredLineLength?e.preferredLineLength:80,this.maxScreenLineLength=null!=e.maxScreenLineLength?e.maxScreenLineLength:500,this.showLineNumbers=null==e.showLineNumbers||e.showLineNumbers;const{tabLength:t=2}=e;this.alive=!0,this.doBackgroundWork=this.doBackgroundWork.bind(this),this.serializationVersion=1,this.suppressSelectionMerging=!1,this.selectionFlashDuration=500,this.gutterContainer=null,this.verticalScrollMargin=2,this.horizontalScrollMargin=6,this.lineHeightInPixels=null,this.defaultCharWidth=null,this.height=null,this.width=null,this.registered=!1,this.atomicSoftTabs=!0,this.emitter=new p,this.disposables=new c,this.cursors=[],this.cursorsByMarkerId=new Map,this.selections=[],this.hasTerminatedPendingState=!1,e.buffer?this.buffer=e.buffer:(this.buffer=new h({shouldDestroyOnFileDelete:()=>atom.config.get("core.closeDeletedFileTabs")}),this.buffer.setLanguageMode(new j({buffer:this.buffer,config:atom.config})));const o=this.buffer.getLanguageMode();if(this.languageModeSubscription=o.onDidTokenize&&o.onDidTokenize(()=>{this.emitter.emit("did-tokenize")}),this.languageModeSubscription&&this.disposables.add(this.languageModeSubscription),e.displayLayer)this.displayLayer=e.displayLayer;else{const o={invisibles:this.getInvisibles(),softWrapColumn:this.getSoftWrapColumn(),showIndentGuides:this.doesShowIndentGuide(),atomicSoftTabs:null==e.atomicSoftTabs||e.atomicSoftTabs,tabLength:t,ratioForCharacter:this.ratioForCharacter.bind(this),isWrapBoundary:E,foldCharacter:"\ufeff",softWrapHangingIndent:null!=e.softWrapHangingIndentLength?e.softWrapHangingIndentLength:0};this.displayLayer=this.buffer.getDisplayLayer(e.displayLayerId),this.displayLayer?(this.displayLayer.reset(o),this.selectionsMarkerLayer=this.displayLayer.getMarkerLayer(e.selectionsMarkerLayerId)):this.displayLayer=this.buffer.addDisplayLayer(o)}this.backgroundWorkHandle=requestIdleCallback(this.doBackgroundWork),this.disposables.add(new m(()=>{if(null!=this.backgroundWorkHandle)return cancelIdleCallback(this.backgroundWorkHandle)})),this.defaultMarkerLayer=this.displayLayer.addMarkerLayer(),this.selectionsMarkerLayer||(this.selectionsMarkerLayer=this.addMarkerLayer({maintainHistory:!0,persistent:!0,role:"selections"})),this.decorationManager=new b(this),this.decorateMarkerLayer(this.selectionsMarkerLayer,{type:"cursor"}),this.isMini()||this.decorateCursorLine(),this.decorateMarkerLayer(this.displayLayer.foldsMarkerLayer,{type:"line-number",class:"folded"});for(let e of this.selectionsMarkerLayer.getMarkers())this.addSelection(e);if(this.subscribeToBuffer(),this.subscribeToDisplayLayer(),0===this.cursors.length&&!e.suppressCursorCreation){const t=Math.max(parseInt(e.initialLine)||0,0),o=Math.max(parseInt(e.initialColumn)||0,0);this.addCursorAtBufferPosition([t,o])}this.gutterContainer=new x(this),this.lineNumberGutter=this.gutterContainer.addGutter({name:"line-number",type:"line-number",priority:0,visible:e.lineNumberGutterVisible})}get element(){return this.getElement()}get editorElement(){return d.deprecate(u`\
            \`TextEditor.prototype.editorElement\` has always been private, but now
            it is gone. Reading the \`editorElement\` property still returns a
            reference to the editor element but this field will be removed in a
            later version of Atom, so we recommend using the \`element\` property instead.\
          `),this.getElement()}get displayBuffer(){return d.deprecate(u`\
            \`TextEditor.prototype.displayBuffer\` has always been private, but now
            it is gone. Reading the \`displayBuffer\` property now returns a reference
            to the containing \`TextEditor\`, which now provides *some* of the API of
            the defunct \`DisplayBuffer\` class.\
          `),this}get languageMode(){return this.buffer.getLanguageMode()}get tokenizedBuffer(){return this.buffer.getLanguageMode()}get rowsPerPage(){return this.getRowsPerPage()}decorateCursorLine(){this.cursorLineDecorations=[this.decorateMarkerLayer(this.selectionsMarkerLayer,{type:"line",class:"cursor-line",onlyEmpty:!0}),this.decorateMarkerLayer(this.selectionsMarkerLayer,{type:"line-number",class:"cursor-line"}),this.decorateMarkerLayer(this.selectionsMarkerLayer,{type:"line-number",class:"cursor-line-no-selection",onlyHead:!0,onlyEmpty:!0})]}doBackgroundWork(e){const t=this.getApproximateLongestScreenRow();this.displayLayer.doBackgroundWork(e)?this.backgroundWorkHandle=requestIdleCallback(this.doBackgroundWork):this.backgroundWorkHandle=null,this.component&&this.getApproximateLongestScreenRow()!==t&&this.component.scheduleUpdate()}update(e){const t={};for(let o of Object.keys(e)){const n=e[o];switch(o){case"autoIndent":this.autoIndent=n;break;case"autoIndentOnPaste":this.autoIndentOnPaste=n;break;case"undoGroupingInterval":this.undoGroupingInterval=n;break;case"scrollSensitivity":this.scrollSensitivity=n;break;case"encoding":this.buffer.setEncoding(n);break;case"softTabs":n!==this.softTabs&&(this.softTabs=n);break;case"atomicSoftTabs":n!==this.displayLayer.atomicSoftTabs&&(t.atomicSoftTabs=n);break;case"tabLength":n>0&&n!==this.displayLayer.tabLength&&(t.tabLength=n);break;case"softWrapped":n!==this.softWrapped&&(this.softWrapped=n,t.softWrapColumn=this.getSoftWrapColumn(),this.emitter.emit("did-change-soft-wrapped",this.isSoftWrapped()));break;case"softWrapHangingIndentLength":n!==this.displayLayer.softWrapHangingIndent&&(t.softWrapHangingIndent=n);break;case"softWrapAtPreferredLineLength":n!==this.softWrapAtPreferredLineLength&&(this.softWrapAtPreferredLineLength=n,t.softWrapColumn=this.getSoftWrapColumn());break;case"preferredLineLength":n!==this.preferredLineLength&&(this.preferredLineLength=n,t.softWrapColumn=this.getSoftWrapColumn());break;case"maxScreenLineLength":n!==this.maxScreenLineLength&&(this.maxScreenLineLength=n,t.softWrapColumn=this.getSoftWrapColumn());break;case"mini":if(n!==this.mini){if(this.mini=n,this.emitter.emit("did-change-mini",n),t.invisibles=this.getInvisibles(),t.softWrapColumn=this.getSoftWrapColumn(),t.showIndentGuides=this.doesShowIndentGuide(),this.mini){for(let e of this.cursorLineDecorations)e.destroy();this.cursorLineDecorations=null}else this.decorateCursorLine();null!=this.component&&this.component.scheduleUpdate()}break;case"readOnly":n!==this.readOnly&&(this.readOnly=n,null!=this.component&&this.component.scheduleUpdate());break;case"keyboardInputEnabled":n!==this.keyboardInputEnabled&&(this.keyboardInputEnabled=n,null!=this.component&&this.component.scheduleUpdate());break;case"placeholderText":n!==this.placeholderText&&(this.placeholderText=n,this.emitter.emit("did-change-placeholder-text",n));break;case"lineNumberGutterVisible":n!==this.lineNumberGutterVisible&&(n?this.lineNumberGutter.show():this.lineNumberGutter.hide(),this.emitter.emit("did-change-line-number-gutter-visible",this.lineNumberGutter.isVisible()));break;case"showIndentGuide":n!==this.showIndentGuide&&(this.showIndentGuide=n,t.showIndentGuides=this.doesShowIndentGuide());break;case"showLineNumbers":n!==this.showLineNumbers&&(this.showLineNumbers=n,null!=this.component&&this.component.scheduleUpdate());break;case"showInvisibles":n!==this.showInvisibles&&(this.showInvisibles=n,t.invisibles=this.getInvisibles());break;case"invisibles":i.isEqual(n,this.invisibles)||(this.invisibles=n,t.invisibles=this.getInvisibles());break;case"editorWidthInChars":n>0&&n!==this.editorWidthInChars&&(this.editorWidthInChars=n,t.softWrapColumn=this.getSoftWrapColumn());break;case"width":n!==this.width&&(this.width=n,t.softWrapColumn=this.getSoftWrapColumn());break;case"scrollPastEnd":n!==this.scrollPastEnd&&(this.scrollPastEnd=n,this.component&&this.component.scheduleUpdate());break;case"autoHeight":n!==this.autoHeight&&(this.autoHeight=n);break;case"autoWidth":n!==this.autoWidth&&(this.autoWidth=n);break;case"showCursorOnSelection":n!==this.showCursorOnSelection&&(this.showCursorOnSelection=n,this.component&&this.component.scheduleUpdate());break;default:if("ref"!==o&&"key"!==o)throw new TypeError(`Invalid TextEditor parameter: '${o}'`)}}return this.displayLayer.reset(t),this.component?this.component.getNextUpdatePromise():Promise.resolve()}scheduleComponentUpdate(){this.component&&this.component.scheduleUpdate()}serialize(){return{deserializer:"TextEditor",version:1,displayLayerId:this.displayLayer.id,selectionsMarkerLayerId:this.selectionsMarkerLayer.id,initialScrollTopRow:this.getScrollTopRow(),initialScrollLeftColumn:this.getScrollLeftColumn(),tabLength:this.displayLayer.tabLength,atomicSoftTabs:this.displayLayer.atomicSoftTabs,softWrapHangingIndentLength:this.displayLayer.softWrapHangingIndent,id:this.id,bufferId:this.buffer.id,softTabs:this.softTabs,softWrapped:this.softWrapped,softWrapAtPreferredLineLength:this.softWrapAtPreferredLineLength,preferredLineLength:this.preferredLineLength,mini:this.mini,readOnly2:this.readOnly,keyboardInputEnabled:this.keyboardInputEnabled,editorWidthInChars:this.editorWidthInChars,width:this.width,maxScreenLineLength:this.maxScreenLineLength,registered:this.registered,invisibles:this.invisibles,showInvisibles:this.showInvisibles,showIndentGuide:this.showIndentGuide,autoHeight:this.autoHeight,autoWidth:this.autoWidth}}subscribeToBuffer(){this.buffer.retain(),this.disposables.add(this.buffer.onDidChangeLanguageMode(this.handleLanguageModeChange.bind(this))),this.disposables.add(this.buffer.onDidChangePath(()=>{this.emitter.emit("did-change-title",this.getTitle()),this.emitter.emit("did-change-path",this.getPath())})),this.disposables.add(this.buffer.onDidChangeEncoding(()=>{this.emitter.emit("did-change-encoding",this.getEncoding())})),this.disposables.add(this.buffer.onDidDestroy(()=>this.destroy())),this.disposables.add(this.buffer.onDidChangeModified(()=>{!this.hasTerminatedPendingState&&this.buffer.isModified()&&this.terminatePendingState()}))}terminatePendingState(){this.hasTerminatedPendingState||this.emitter.emit("did-terminate-pending-state"),this.hasTerminatedPendingState=!0}onDidTerminatePendingState(e){return this.emitter.on("did-terminate-pending-state",e)}subscribeToDisplayLayer(){return this.disposables.add(this.displayLayer.onDidChange(e=>{this.mergeIntersectingSelections(),this.component&&this.component.didChangeDisplayLayer(e),this.emitter.emit("did-change",e.map(e=>new ChangeEvent(e)))})),this.disposables.add(this.displayLayer.onDidReset(()=>{this.mergeIntersectingSelections(),this.component&&this.component.didResetDisplayLayer(),this.emitter.emit("did-change",{})})),this.disposables.add(this.selectionsMarkerLayer.onDidCreateMarker(this.addSelection.bind(this))),this.disposables.add(this.selectionsMarkerLayer.onDidUpdate(()=>null!=this.component?this.component.didUpdateSelections():void 0))}destroy(){if(this.alive){this.alive=!1,this.disposables.dispose(),this.displayLayer.destroy();for(let e of this.selections.slice())e.destroy();this.buffer.release(),this.gutterContainer.destroy(),this.emitter.emit("did-destroy"),this.emitter.clear(),this.component&&(this.component.element.component=null),this.component=null,this.lineNumberGutter.element=null}}isAlive(){return this.alive}isDestroyed(){return!this.alive}onDidChangeTitle(e){return this.emitter.on("did-change-title",e)}onDidChangePath(e){return this.emitter.on("did-change-path",e)}onDidChange(e){return this.emitter.on("did-change",e)}onDidStopChanging(e){return this.getBuffer().onDidStopChanging(e)}onDidChangeCursorPosition(e){return this.emitter.on("did-change-cursor-position",e)}onDidChangeSelectionRange(e){return this.emitter.on("did-change-selection-range",e)}onDidChangeSoftWrapped(e){return this.emitter.on("did-change-soft-wrapped",e)}onDidChangeEncoding(e){return this.emitter.on("did-change-encoding",e)}observeGrammar(e){return e(this.getGrammar()),this.onDidChangeGrammar(e)}onDidChangeGrammar(e){return this.buffer.onDidChangeLanguageMode(()=>{e(this.buffer.getLanguageMode().grammar)})}onDidChangeModified(e){return this.getBuffer().onDidChangeModified(e)}onDidConflict(e){return this.getBuffer().onDidConflict(e)}onWillInsertText(e){return this.emitter.on("will-insert-text",e)}onDidInsertText(e){return this.emitter.on("did-insert-text",e)}onDidSave(e){return this.getBuffer().onDidSave(e)}onDidDestroy(e){return this.emitter.once("did-destroy",e)}observeCursors(e){return this.getCursors().forEach(e),this.onDidAddCursor(e)}onDidAddCursor(e){return this.emitter.on("did-add-cursor",e)}onDidRemoveCursor(e){return this.emitter.on("did-remove-cursor",e)}observeSelections(e){return this.getSelections().forEach(e),this.onDidAddSelection(e)}onDidAddSelection(e){return this.emitter.on("did-add-selection",e)}onDidRemoveSelection(e){return this.emitter.on("did-remove-selection",e)}observeDecorations(e){return this.decorationManager.observeDecorations(e)}onDidAddDecoration(e){return this.decorationManager.onDidAddDecoration(e)}onDidRemoveDecoration(e){return this.decorationManager.onDidRemoveDecoration(e)}didAddDecoration(e){this.component&&e.isType("block")&&this.component.addBlockDecoration(e)}onDidChangePlaceholderText(e){return this.emitter.on("did-change-placeholder-text",e)}onDidChangeScrollTop(e){return d.deprecate("This is now a view method. Call TextEditorElement::onDidChangeScrollTop instead."),this.getElement().onDidChangeScrollTop(e)}onDidChangeScrollLeft(e){return d.deprecate("This is now a view method. Call TextEditorElement::onDidChangeScrollLeft instead."),this.getElement().onDidChangeScrollLeft(e)}onDidRequestAutoscroll(e){return this.emitter.on("did-request-autoscroll",e)}onDidChangeIcon(e){return this.emitter.on("did-change-icon",e)}onDidUpdateDecorations(e){return this.decorationManager.onDidUpdateDecorations(e)}getURI(){return this.buffer.getUri()}copy(){const e=this.displayLayer.copy(),t=e.getMarkerLayer(this.buffer.getMarkerLayer(this.selectionsMarkerLayer.id).copy().id),o=this.getSoftTabs();return new TextEditor({buffer:this.buffer,selectionsMarkerLayer:t,softTabs:o,suppressCursorCreation:!0,tabLength:this.getTabLength(),initialScrollTopRow:this.getScrollTopRow(),initialScrollLeftColumn:this.getScrollLeftColumn(),assert:this.assert,displayLayer:e,grammar:this.getGrammar(),autoWidth:this.autoWidth,autoHeight:this.autoHeight,showCursorOnSelection:this.showCursorOnSelection})}setVisible(e){if(e){const e=this.buffer.getLanguageMode();e.startTokenizing&&e.startTokenizing()}}setMini(e){this.update({mini:e})}isMini(){return this.mini}setReadOnly(e){this.update({readOnly:e})}isReadOnly(){return this.readOnly}enableKeyboardInput(e){this.update({keyboardInputEnabled:e})}isKeyboardInputEnabled(){return this.keyboardInputEnabled}onDidChangeMini(e){return this.emitter.on("did-change-mini",e)}setLineNumberGutterVisible(e){this.update({lineNumberGutterVisible:e})}isLineNumberGutterVisible(){return this.lineNumberGutter.isVisible()}anyLineNumberGutterVisible(){return this.getGutters().some(e=>"line-number"===e.type&&e.visible)}onDidChangeLineNumberGutterVisible(e){return this.emitter.on("did-change-line-number-gutter-visible",e)}observeGutters(e){return this.gutterContainer.observeGutters(e)}onDidAddGutter(e){return this.gutterContainer.onDidAddGutter(e)}onDidRemoveGutter(e){return this.gutterContainer.onDidRemoveGutter(e)}setEditorWidthInChars(e){this.update({editorWidthInChars:e})}getEditorWidthInChars(){return null!=this.width&&this.defaultCharWidth>0?Math.max(0,Math.floor(this.width/this.defaultCharWidth)):this.editorWidthInChars}getBuffer(){return this.buffer}getTitle(){return this.getFileName()||"untitled"}getLongTitle(){if(this.getPath()){const e=this.getFileName();let t;const o=[];for(const n of atom.workspace.getTextEditors())if(n.getFileName()===e){const e=l.tildify(n.getDirectoryPath()).split(get_path().sep);o.push(e),n===this&&(t=e)}if(!t||1===o.length)return e;let n;for(let e=0,{length:s}=t;e<s;e++){const s=t[e];if(o.some(t=>t.length===e+1||t[e]!==s)){n=e;break}}return`${e} — ${get_path().join(...t.slice(n))}`}return"untitled"}getPath(){return this.buffer.getPath()}getFileName(){const e=this.getPath();if(e)return get_path().basename(e)}getDirectoryPath(){const e=this.getPath();if(e)return get_path().dirname(e)}getEncoding(){return this.buffer.getEncoding()}setEncoding(e){this.buffer.setEncoding(e)}isModified(){return this.buffer.isModified()}isEmpty(){return this.buffer.isEmpty()}save(){return this.buffer.save()}saveAs(e){return this.buffer.saveAs(e)}shouldPromptToSave({windowCloseRequested:e,projectHasPaths:t}={}){return e&&t&&atom.stateStore.isConnected()?this.buffer.isInConflict():this.isModified()&&!this.buffer.hasMultipleEditors()}getSaveDialogOptions(){return{}}getText(){return this.buffer.getText()}getTextInBufferRange(e){return this.buffer.getTextInRange(e)}getLineCount(){return this.buffer.getLineCount()}getScreenLineCount(){return this.displayLayer.getScreenLineCount()}getApproximateScreenLineCount(){return this.displayLayer.getApproximateScreenLineCount()}getLastBufferRow(){return this.buffer.getLastRow()}getLastScreenRow(){return this.getScreenLineCount()-1}lineTextForBufferRow(e){return this.buffer.lineForRow(e)}lineTextForScreenRow(e){const t=this.screenLineForScreenRow(e);if(t)return t.lineText}logScreenLines(e=0,t=this.getLastScreenRow()){for(let o=e;o<=t;o++){const e=this.lineTextForScreenRow(o);get_console().log(o,this.bufferRowForScreenRow(o),e,e.length)}}tokensForScreenRow(e){const t=[];let o=0;const n=[],{lineText:s,tags:r}=this.screenLineForScreenRow(e);for(const e of r)this.displayLayer.isOpenTag(e)?n.push(this.displayLayer.classNameForTag(e)):this.displayLayer.isCloseTag(e)?n.pop():(t.push({text:s.substr(o,e),scopes:n.slice()}),o+=e);return t}screenLineForScreenRow(e){return this.displayLayer.getScreenLine(e)}bufferRowForScreenRow(e){return this.displayLayer.translateScreenPosition(f(e,0)).row}bufferRowsForScreenRows(e,t){return this.displayLayer.bufferRowsForScreenRows(e,t+1)}screenRowForBufferRow(e){return this.displayLayer.translateBufferPosition(f(e,0)).row}getRightmostScreenPosition(){return this.displayLayer.getRightmostScreenPosition()}getApproximateRightmostScreenPosition(){return this.displayLayer.getApproximateRightmostScreenPosition()}getMaxScreenLineLength(){return this.getRightmostScreenPosition().column}getLongestScreenRow(){return this.getRightmostScreenPosition().row}getApproximateLongestScreenRow(){return this.getApproximateRightmostScreenPosition().row}lineLengthForScreenRow(e){return this.displayLayer.lineLengthForScreenRow(e)}bufferRangeForBufferRow(e,t){return this.buffer.rangeForRow(e,t&&t.includeNewline)}getTextInRange(e){return this.buffer.getTextInRange(e)}isBufferRowBlank(e){return this.buffer.isRowBlank(e)}nextNonBlankBufferRow(e){return this.buffer.nextNonBlankRow(e)}getEofBufferPosition(){return this.buffer.getEndPosition()}getCurrentParagraphBufferRange(){return this.getLastCursor().getCurrentParagraphBufferRange()}setText(e,t={}){if(this.ensureWritable("setText",t))return this.buffer.setText(e)}setTextInBufferRange(e,t,o={}){if(this.ensureWritable("setTextInBufferRange",o))return this.getBuffer().setTextInRange(e,t,o)}insertText(e,t={}){if(!this.ensureWritable("insertText",t))return;if(!this.emitWillInsertTextEvent(e))return!1;let o=!1;"skip"===t.undo&&(delete(t=Object.assign({},t)).undo,o=!0);const n=t.groupUndo?this.undoGroupingInterval:0;null==t.autoIndentNewline&&(t.autoIndentNewline=this.shouldAutoIndent()),null==t.autoDecreaseIndent&&(t.autoDecreaseIndent=this.shouldAutoIndent());const s=this.mutateSelectedText(o=>{const n=o.insertText(e,t),s={text:e,range:n};return this.emitter.emit("did-insert-text",s),n},n);return o&&this.buffer.groupLastChanges(),s}insertNewline(e={}){return this.insertText("\n",e)}delete(e={}){if(this.ensureWritable("delete",e))return this.mutateSelectedText(t=>t.delete(e))}backspace(e={}){if(this.ensureWritable("backspace",e))return this.mutateSelectedText(t=>t.backspace(e))}mutateSelectedText(e,t=0){return this.mergeIntersectingSelections(()=>this.transact(t,()=>this.getSelectionsOrderedByBufferPosition().map((t,o)=>e(t,o))))}moveLineUp(e={}){if(!this.ensureWritable("moveLineUp",e))return;const t=this.getSelectedBufferRanges().sort((e,t)=>e.compare(t));0!==t[0].start.row&&(t[t.length-1].start.row===this.getLastBufferRow()&&""===this.buffer.getLastLine()||this.transact(()=>{const e=[];for(;t.length>0;){const o=t.shift(),n=[o];for(;o.end.row===(null!=t[0]?t[0].start.row:void 0);)n.push(t[0]),o.end.row=t[0].end.row,t.shift();let s=o.start.row,r=o.end.row;o.end.row>o.start.row&&0===o.end.column&&r--,s=this.displayLayer.findBoundaryPrecedingBufferRow(s),r=this.displayLayer.findBoundaryFollowingBufferRow(r+1);const i=new g(f(s,0),f(r,0)),a=this.displayLayer.findBoundaryPrecedingBufferRow(s-1),l=i.start.row-a,d=this.displayLayer.destroyFoldsIntersectingBufferRange(i).map(e=>e.translate([-l,0]));let u=this.buffer.getTextInRange(i);"\n"!==u[u.length-1]&&(u+=this.buffer.lineEndingForRow(i.end.row-2)),this.buffer.delete(i),this.buffer.insert([a,0],u);for(let e of d)this.displayLayer.foldBufferRange(e);for(const t of n)e.push(t.translate([-l,0]))}this.setSelectedBufferRanges(e,{autoscroll:!1,preserveFolds:!0}),this.shouldAutoIndent()&&this.autoIndentSelectedRows(),this.scrollToBufferPosition([e[0].start.row,0])}))}moveLineDown(e={}){if(!this.ensureWritable("moveLineDown",e))return;const t=this.getSelectedBufferRanges();t.sort((e,t)=>t.compare(e)),this.transact(()=>{this.consolidateSelections();const e=[];for(;t.length>0;){const o=t.shift(),n=[o];for(;o.start.row===(null!=t[0]?t[0].end.row:void 0);)n.push(t[0]),o.start.row=t[0].start.row,t.shift();let s=o.start.row,r=o.end.row;o.end.row>o.start.row&&0===o.end.column&&r--,s=this.displayLayer.findBoundaryPrecedingBufferRow(s),r=this.displayLayer.findBoundaryFollowingBufferRow(r+1);const i=new g(f(s,0),f(r,0)),a=Math.min(this.buffer.getLineCount(),this.displayLayer.findBoundaryFollowingBufferRow(r+1)),l=a-i.end.row,d=this.displayLayer.destroyFoldsIntersectingBufferRange(i).map(e=>e.translate([l,0]));let u=this.buffer.getTextInRange(i);a-1===this.buffer.getLastRow()&&(u=`\n${u}`),this.buffer.insert([a,0],u),this.buffer.delete(i);for(let e of d)this.displayLayer.foldBufferRange(e);for(const t of n)e.push(t.translate([l,0]))}this.setSelectedBufferRanges(e,{autoscroll:!1,preserveFolds:!0}),this.shouldAutoIndent()&&this.autoIndentSelectedRows(),this.scrollToBufferPosition([e[0].start.row-1,0])})}moveSelectionLeft(e={}){if(!this.ensureWritable("moveSelectionLeft",e))return;const t=this.getSelectedBufferRanges(),o=t.every(e=>0!==e.start.column),n=[0,-1],s=[];o&&this.transact(()=>{for(let e of t){const t=new g(e.start.translate(n),e.start),o=this.buffer.getTextInRange(t);this.buffer.insert(e.end,o),this.buffer.delete(t),s.push(e.translate(n))}this.setSelectedBufferRanges(s)})}moveSelectionRight(e={}){if(!this.ensureWritable("moveSelectionRight",e))return;const t=this.getSelectedBufferRanges(),o=t.every(e=>e.end.column!==this.buffer.lineLengthForRow(e.end.row)),n=[0,1],s=[];o&&this.transact(()=>{for(let e of t){const t=new g(e.end,e.end.translate(n)),o=this.buffer.getTextInRange(t);this.buffer.delete(t),this.buffer.insert(e.start,o),s.push(e.translate(n))}this.setSelectedBufferRanges(s)})}duplicateLines(e={}){this.ensureWritable("duplicateLines",e)&&this.transact(()=>{const e=this.getSelectionsOrderedByBufferPosition(),t=[];let o=e.length-1;for(;o>=0;){const n=o;if(t[o]=e[o].getBufferRange(),e[o].isEmpty()){const{start:t}=e[o].getScreenRange();e[o].setScreenRange([[t.row,0],[t.row+1,0]],{preserveFolds:!0})}let[s,r]=e[o].getBufferRowRange();for(r++;o>0;){const[n,r]=e[o-1].getBufferRowRange();if(r!==s)break;s=n,t[o-1]=e[o-1].getBufferRange(),o--}const i=this.displayLayer.foldsIntersectingBufferRange([[s,0],[r,0]]);let a=this.getTextInBufferRange([[s,0],[r,0]]);r>this.getLastBufferRow()&&(a=`\n${a}`),this.buffer.insert([r,0],a);const l=r-s;for(let s=o;s<=n;s++)e[s].setBufferRange(t[s].translate([l,0]));for(const e of i){const t=this.displayLayer.bufferRangeForFold(e);this.displayLayer.foldBufferRange(t.translate([l,0]))}o--}})}replaceSelectedText(e,t){this.mutateSelectedText(o=>{o.getBufferRange(),e&&e.selectWordIfEmpty&&o.isEmpty()&&o.selectWord();const n=o.getText();o.deleteSelectedText();const s=o.insertText(t(n));o.setBufferRange(s)})}splitSelectionsIntoLines(){this.mergeIntersectingSelections(()=>{for(const e of this.getSelections()){const t=e.getBufferRange();if(t.isSingleLine())continue;const{start:o,end:n}=t;this.addSelectionForBufferRange([o,[o.row,Infinity]]);let{row:s}=o;for(;++s<n.row;)this.addSelectionForBufferRange([[s,0],[s,Infinity]]);0!==n.column&&this.addSelectionForBufferRange([[n.row,0],[n.row,n.column]]),e.destroy()}})}transpose(e={}){this.ensureWritable("transpose",e)&&this.mutateSelectedText(e=>{if(e.isEmpty()){e.selectRight();const t=e.getText();e.delete(),e.cursor.moveLeft(),e.insertText(t)}else e.insertText(e.getText().split("").reverse().join(""))})}upperCase(e={}){this.ensureWritable("upperCase",e)&&this.replaceSelectedText({selectWordIfEmpty:!0},t=>t.toUpperCase(e))}lowerCase(e={}){this.ensureWritable("lowerCase",e)&&this.replaceSelectedText({selectWordIfEmpty:!0},t=>t.toLowerCase(e))}toggleLineCommentsInSelection(e={}){this.ensureWritable("toggleLineCommentsInSelection",e)&&this.mutateSelectedText(t=>t.toggleLineComments(e))}joinLines(e={}){this.ensureWritable("joinLines",e)&&this.mutateSelectedText(e=>e.joinLines())}insertNewlineBelow(e={}){this.ensureWritable("insertNewlineBelow",e)&&this.transact(()=>{this.moveToEndOfLine(),this.insertNewline(e)})}insertNewlineAbove(e={}){this.ensureWritable("insertNewlineAbove",e)&&this.transact(()=>{const t=this.getCursorBufferPosition().row,o=this.indentationForBufferRow(t),n=0===t;this.moveToBeginningOfLine(),this.moveLeft(),this.insertNewline(e),this.shouldAutoIndent()&&this.indentationForBufferRow(t)<o&&this.setIndentationForBufferRow(t,o),n&&(this.moveUp(),this.moveToEndOfLine())})}deleteToBeginningOfWord(e={}){this.ensureWritable("deleteToBeginningOfWord",e)&&this.mutateSelectedText(t=>t.deleteToBeginningOfWord(e))}deleteToPreviousWordBoundary(e={}){this.ensureWritable("deleteToPreviousWordBoundary",e)&&this.mutateSelectedText(t=>t.deleteToPreviousWordBoundary(e))}deleteToNextWordBoundary(e={}){this.ensureWritable("deleteToNextWordBoundary",e)&&this.mutateSelectedText(t=>t.deleteToNextWordBoundary(e))}deleteToBeginningOfSubword(e={}){this.ensureWritable("deleteToBeginningOfSubword",e)&&this.mutateSelectedText(t=>t.deleteToBeginningOfSubword(e))}deleteToEndOfSubword(e={}){this.ensureWritable("deleteToEndOfSubword",e)&&this.mutateSelectedText(t=>t.deleteToEndOfSubword(e))}deleteToBeginningOfLine(e={}){this.ensureWritable("deleteToBeginningOfLine",e)&&this.mutateSelectedText(t=>t.deleteToBeginningOfLine(e))}deleteToEndOfLine(e={}){this.ensureWritable("deleteToEndOfLine",e)&&this.mutateSelectedText(t=>t.deleteToEndOfLine(e))}deleteToEndOfWord(e={}){this.ensureWritable("deleteToEndOfWord",e)&&this.mutateSelectedText(t=>t.deleteToEndOfWord(e))}deleteLine(e={}){this.ensureWritable("deleteLine",e)&&(this.mergeSelectionsOnSameRows(),this.mutateSelectedText(t=>t.deleteLine(e)))}ensureWritable(e,t){if(!t.bypassReadOnly&&this.isReadOnly()){if(atom.inDevMode()||atom.inSpecMode()){const t=new Error("Attempt to mutate a read-only TextEditor");throw t.detail=`Your package is attempting to call ${e} on an editor that has been marked read-only. `+"Pass {bypassReadOnly: true} to modify it anyway, or test editors with .isReadOnly() before attempting modifications.",t}return!1}return!0}undo(e={}){this.ensureWritable("undo",e)&&(this.avoidMergingSelections(()=>this.buffer.undo({selectionsMarkerLayer:this.selectionsMarkerLayer})),this.getLastSelection().autoscroll())}redo(e={}){this.ensureWritable("redo",e)&&(this.avoidMergingSelections(()=>this.buffer.redo({selectionsMarkerLayer:this.selectionsMarkerLayer})),this.getLastSelection().autoscroll())}transact(e,t){const o={selectionsMarkerLayer:this.selectionsMarkerLayer};return"function"==typeof e?t=e:o.groupingInterval=e,this.buffer.transact(o,t)}abortTransaction(){return this.buffer.abortTransaction()}createCheckpoint(){return this.buffer.createCheckpoint({selectionsMarkerLayer:this.selectionsMarkerLayer})}revertToCheckpoint(e){return this.buffer.revertToCheckpoint(e)}groupChangesSinceCheckpoint(e){return this.buffer.groupChangesSinceCheckpoint(e,{selectionsMarkerLayer:this.selectionsMarkerLayer})}screenPositionForBufferPosition(e,t){return t&&t.clip&&(d.deprecate("The `clip` parameter has been deprecated and will be removed soon. Please, use `clipDirection` instead."),t.clipDirection&&(t.clipDirection=t.clip)),t&&null!=t.wrapAtSoftNewlines&&(d.deprecate("The `wrapAtSoftNewlines` parameter has been deprecated and will be removed soon. Please, use `clipDirection: 'forward'` instead."),t.clipDirection&&(t.clipDirection=t.wrapAtSoftNewlines?"forward":"backward")),t&&null!=t.wrapBeyondNewlines&&(d.deprecate("The `wrapBeyondNewlines` parameter has been deprecated and will be removed soon. Please, use `clipDirection: 'forward'` instead."),t.clipDirection&&(t.clipDirection=t.wrapBeyondNewlines?"forward":"backward")),this.displayLayer.translateBufferPosition(e,t)}bufferPositionForScreenPosition(e,t){return t&&t.clip&&(d.deprecate("The `clip` parameter has been deprecated and will be removed soon. Please, use `clipDirection` instead."),t.clipDirection&&(t.clipDirection=t.clip)),t&&null!=t.wrapAtSoftNewlines&&(d.deprecate("The `wrapAtSoftNewlines` parameter has been deprecated and will be removed soon. Please, use `clipDirection: 'forward'` instead."),t.clipDirection&&(t.clipDirection=t.wrapAtSoftNewlines?"forward":"backward")),t&&null!=t.wrapBeyondNewlines&&(d.deprecate("The `wrapBeyondNewlines` parameter has been deprecated and will be removed soon. Please, use `clipDirection: 'forward'` instead."),t.clipDirection&&(t.clipDirection=t.wrapBeyondNewlines?"forward":"backward")),this.displayLayer.translateScreenPosition(e,t)}screenRangeForBufferRange(e,t){e=g.fromObject(e);const o=this.screenPositionForBufferPosition(e.start,t),n=this.screenPositionForBufferPosition(e.end,t);return new g(o,n)}bufferRangeForScreenRange(e){e=g.fromObject(e);const t=this.bufferPositionForScreenPosition(e.start),o=this.bufferPositionForScreenPosition(e.end);return new g(t,o)}clipBufferPosition(e){return this.buffer.clipPosition(e)}clipBufferRange(e){return this.buffer.clipRange(e)}clipScreenPosition(e,t){return t&&t.clip&&(d.deprecate("The `clip` parameter has been deprecated and will be removed soon. Please, use `clipDirection` instead."),t.clipDirection&&(t.clipDirection=t.clip)),t&&null!=t.wrapAtSoftNewlines&&(d.deprecate("The `wrapAtSoftNewlines` parameter has been deprecated and will be removed soon. Please, use `clipDirection: 'forward'` instead."),t.clipDirection&&(t.clipDirection=t.wrapAtSoftNewlines?"forward":"backward")),t&&null!=t.wrapBeyondNewlines&&(d.deprecate("The `wrapBeyondNewlines` parameter has been deprecated and will be removed soon. Please, use `clipDirection: 'forward'` instead."),t.clipDirection&&(t.clipDirection=t.wrapBeyondNewlines?"forward":"backward")),this.displayLayer.clipScreenPosition(e,t)}clipScreenRange(e,t){e=g.fromObject(e);const o=this.displayLayer.clipScreenPosition(e.start,t),n=this.displayLayer.clipScreenPosition(e.end,t);return g(o,n)}decorateMarker(e,t){return this.decorationManager.decorateMarker(e,t)}decorateMarkerLayer(e,t){return this.decorationManager.decorateMarkerLayer(e,t)}decorationsForScreenRowRange(e,t){return this.decorationManager.decorationsForScreenRowRange(e,t)}decorationsStateForScreenRowRange(e,t){return this.decorationManager.decorationsStateForScreenRowRange(e,t)}getDecorations(e){return this.decorationManager.getDecorations(e)}getLineDecorations(e){return this.decorationManager.getLineDecorations(e)}getLineNumberDecorations(e){return this.decorationManager.getLineNumberDecorations(e)}getHighlightDecorations(e){return this.decorationManager.getHighlightDecorations(e)}getOverlayDecorations(e){return this.decorationManager.getOverlayDecorations(e)}markBufferRange(e,t){return this.defaultMarkerLayer.markBufferRange(e,t)}markScreenRange(e,t){return this.defaultMarkerLayer.markScreenRange(e,t)}markBufferPosition(e,t){return this.defaultMarkerLayer.markBufferPosition(e,t)}markScreenPosition(e,t){return this.defaultMarkerLayer.markScreenPosition(e,t)}findMarkers(e){return this.defaultMarkerLayer.findMarkers(e)}getMarker(e){return this.defaultMarkerLayer.getMarker(e)}getMarkers(){return this.defaultMarkerLayer.getMarkers()}getMarkerCount(){return this.defaultMarkerLayer.getMarkerCount()}destroyMarker(e){const t=this.getMarker(e);t&&t.destroy()}addMarkerLayer(e){return this.displayLayer.addMarkerLayer(e)}getMarkerLayer(e){return this.displayLayer.getMarkerLayer(e)}getDefaultMarkerLayer(){return this.defaultMarkerLayer}getCursorBufferPosition(){return this.getLastCursor().getBufferPosition()}getCursorBufferPositions(){return this.getCursors().map(e=>e.getBufferPosition())}setCursorBufferPosition(e,t){return this.moveCursors(o=>o.setBufferPosition(e,t))}getCursorAtScreenPosition(e){const t=this.getSelectionAtScreenPosition(e);if(t&&t.getHeadScreenPosition().isEqual(e))return t.cursor}getCursorScreenPosition(){return this.getLastCursor().getScreenPosition()}getCursorScreenPositions(){return this.getCursors().map(e=>e.getScreenPosition())}setCursorScreenPosition(e,t){return t&&t.clip&&(d.deprecate("The `clip` parameter has been deprecated and will be removed soon. Please, use `clipDirection` instead."),t.clipDirection&&(t.clipDirection=t.clip)),t&&null!=t.wrapAtSoftNewlines&&(d.deprecate("The `wrapAtSoftNewlines` parameter has been deprecated and will be removed soon. Please, use `clipDirection: 'forward'` instead."),t.clipDirection&&(t.clipDirection=t.wrapAtSoftNewlines?"forward":"backward")),t&&null!=t.wrapBeyondNewlines&&(d.deprecate("The `wrapBeyondNewlines` parameter has been deprecated and will be removed soon. Please, use `clipDirection: 'forward'` instead."),t.clipDirection&&(t.clipDirection=t.wrapBeyondNewlines?"forward":"backward")),this.moveCursors(o=>o.setScreenPosition(e,t))}addCursorAtBufferPosition(e,t){return this.selectionsMarkerLayer.markBufferPosition(e,{invalidate:"never"}),t&&!1===t.autoscroll||this.getLastSelection().cursor.autoscroll(),this.getLastSelection().cursor}addCursorAtScreenPosition(e,t){return this.selectionsMarkerLayer.markScreenPosition(e,{invalidate:"never"}),t&&!1===t.autoscroll||this.getLastSelection().cursor.autoscroll(),this.getLastSelection().cursor}hasMultipleCursors(){return this.getCursors().length>1}moveUp(e){return this.moveCursors(t=>t.moveUp(e,{moveToEndOfSelection:!0}))}moveDown(e){return this.moveCursors(t=>t.moveDown(e,{moveToEndOfSelection:!0}))}moveLeft(e){return this.moveCursors(t=>t.moveLeft(e,{moveToEndOfSelection:!0}))}moveRight(e){return this.moveCursors(t=>t.moveRight(e,{moveToEndOfSelection:!0}))}moveToBeginningOfLine(){return this.moveCursors(e=>e.moveToBeginningOfLine())}moveToBeginningOfScreenLine(){return this.moveCursors(e=>e.moveToBeginningOfScreenLine())}moveToFirstCharacterOfLine(){return this.moveCursors(e=>e.moveToFirstCharacterOfLine())}moveToEndOfLine(){return this.moveCursors(e=>e.moveToEndOfLine())}moveToEndOfScreenLine(){return this.moveCursors(e=>e.moveToEndOfScreenLine())}moveToBeginningOfWord(){return this.moveCursors(e=>e.moveToBeginningOfWord())}moveToEndOfWord(){return this.moveCursors(e=>e.moveToEndOfWord())}moveToTop(){return this.moveCursors(e=>e.moveToTop())}moveToBottom(){return this.moveCursors(e=>e.moveToBottom())}moveToBeginningOfNextWord(){return this.moveCursors(e=>e.moveToBeginningOfNextWord())}moveToPreviousWordBoundary(){return this.moveCursors(e=>e.moveToPreviousWordBoundary())}moveToNextWordBoundary(){return this.moveCursors(e=>e.moveToNextWordBoundary())}moveToPreviousSubwordBoundary(){return this.moveCursors(e=>e.moveToPreviousSubwordBoundary())}moveToNextSubwordBoundary(){return this.moveCursors(e=>e.moveToNextSubwordBoundary())}moveToBeginningOfNextParagraph(){return this.moveCursors(e=>e.moveToBeginningOfNextParagraph())}moveToBeginningOfPreviousParagraph(){return this.moveCursors(e=>e.moveToBeginningOfPreviousParagraph())}getLastCursor(){return this.createLastSelectionIfNeeded(),i.last(this.cursors)}getWordUnderCursor(e){return this.getTextInBufferRange(this.getLastCursor().getCurrentWordBufferRange(e))}getCursors(){return this.createLastSelectionIfNeeded(),this.cursors.slice()}getCursorsOrderedByBufferPosition(){return this.getCursors().sort((e,t)=>e.compare(t))}cursorsForScreenRowRange(e,t){const o=[];for(let n of this.selectionsMarkerLayer.findMarkers({intersectsScreenRowRange:[e,t]})){const e=this.cursorsByMarkerId.get(n.id);e&&o.push(e)}return o}addCursor(e){const t=new _({editor:this,marker:e,showCursorOnSelection:this.showCursorOnSelection});return this.cursors.push(t),this.cursorsByMarkerId.set(e.id,t),t}moveCursors(e){return this.transact(()=>(this.getCursors().forEach(e),this.mergeCursors()))}cursorMoved(e){return this.emitter.emit("did-change-cursor-position",e)}mergeCursors(){const e={};for(let t of this.getCursors()){const o=t.getBufferPosition().toString();e.hasOwnProperty(o)?t.destroy():e[o]=!0}}getSelectedText(){return this.getLastSelection().getText()}getSelectedBufferRange(){return this.getLastSelection().getBufferRange()}getSelectedBufferRanges(){return this.getSelections().map(e=>e.getBufferRange())}setSelectedBufferRange(e,t){return this.setSelectedBufferRanges([e],t)}setSelectedBufferRanges(e,t={}){if(!e.length)throw new Error("Passed an empty array to setSelectedBufferRanges");const o=this.getSelections();for(let t of o.slice(e.length))t.destroy();this.mergeIntersectingSelections(t,()=>{for(let n=0;n<e.length;n++){let s=e[n];s=g.fromObject(s),o[n]?o[n].setBufferRange(s,t):this.addSelectionForBufferRange(s,t)}})}getSelectedScreenRange(){return this.getLastSelection().getScreenRange()}getSelectedScreenRanges(){return this.getSelections().map(e=>e.getScreenRange())}setSelectedScreenRange(e,t){return this.setSelectedBufferRange(this.bufferRangeForScreenRange(e,t),t)}setSelectedScreenRanges(e,t={}){if(!e.length)throw new Error("Passed an empty array to setSelectedScreenRanges");const o=this.getSelections();for(let t of o.slice(e.length))t.destroy();this.mergeIntersectingSelections(t,()=>{for(let n=0;n<e.length;n++){let s=e[n];s=g.fromObject(s),o[n]?o[n].setScreenRange(s,t):this.addSelectionForScreenRange(s,t)}})}addSelectionForBufferRange(e,t={}){return e=g.fromObject(e),t.preserveFolds||this.displayLayer.destroyFoldsContainingBufferPositions([e.start,e.end],!0),this.selectionsMarkerLayer.markBufferRange(e,{invalidate:"never",reversed:null!=t.reversed&&t.reversed}),!1!==t.autoscroll&&this.getLastSelection().autoscroll(),this.getLastSelection()}addSelectionForScreenRange(e,t={}){return this.addSelectionForBufferRange(this.bufferRangeForScreenRange(e),t)}selectToBufferPosition(e){const t=this.getLastSelection();return t.selectToBufferPosition(e),this.mergeIntersectingSelections({reversed:t.isReversed()})}selectToScreenPosition(e,t){const o=this.getLastSelection();if(o.selectToScreenPosition(e,t),!t||!t.suppressSelectionMerge)return this.mergeIntersectingSelections({reversed:o.isReversed()})}selectUp(e){return this.expandSelectionsBackward(t=>t.selectUp(e))}selectDown(e){return this.expandSelectionsForward(t=>t.selectDown(e))}selectLeft(e){return this.expandSelectionsBackward(t=>t.selectLeft(e))}selectRight(e){return this.expandSelectionsForward(t=>t.selectRight(e))}selectToTop(){return this.expandSelectionsBackward(e=>e.selectToTop())}selectToBottom(){return this.expandSelectionsForward(e=>e.selectToBottom())}selectAll(){return this.expandSelectionsForward(e=>e.selectAll())}selectToBeginningOfLine(){return this.expandSelectionsBackward(e=>e.selectToBeginningOfLine())}selectToFirstCharacterOfLine(){return this.expandSelectionsBackward(e=>e.selectToFirstCharacterOfLine())}selectToEndOfLine(){return this.expandSelectionsForward(e=>e.selectToEndOfLine())}selectToBeginningOfWord(){return this.expandSelectionsBackward(e=>e.selectToBeginningOfWord())}selectToEndOfWord(){return this.expandSelectionsForward(e=>e.selectToEndOfWord())}selectToPreviousSubwordBoundary(){return this.expandSelectionsBackward(e=>e.selectToPreviousSubwordBoundary())}selectToNextSubwordBoundary(){return this.expandSelectionsForward(e=>e.selectToNextSubwordBoundary())}selectLinesContainingCursors(){return this.expandSelectionsForward(e=>e.selectLine())}selectWordsContainingCursors(){return this.expandSelectionsForward(e=>e.selectWord())}selectToPreviousWordBoundary(){return this.expandSelectionsBackward(e=>e.selectToPreviousWordBoundary())}selectToNextWordBoundary(){return this.expandSelectionsForward(e=>e.selectToNextWordBoundary())}selectToBeginningOfNextWord(){return this.expandSelectionsForward(e=>e.selectToBeginningOfNextWord())}selectToBeginningOfNextParagraph(){return this.expandSelectionsForward(e=>e.selectToBeginningOfNextParagraph())}selectToBeginningOfPreviousParagraph(){return this.expandSelectionsBackward(e=>e.selectToBeginningOfPreviousParagraph())}selectLargerSyntaxNode(){const e=this.buffer.getLanguageMode();e.getRangeForSyntaxNodeContainingRange&&this.expandSelectionsForward(t=>{const o=t.getBufferRange(),n=e.getRangeForSyntaxNodeContainingRange(o);n&&(t._rangeStack||(t._rangeStack=[]),t._rangeStack.push(o),t.setBufferRange(n))})}selectSmallerSyntaxNode(){this.expandSelectionsForward(e=>{if(e._rangeStack){const t=e._rangeStack[e._rangeStack.length-1];t&&e.getBufferRange().containsRange(t)&&(e._rangeStack.length--,e.setBufferRange(t))}})}selectMarker(e){if(e.isValid()){const t=e.getBufferRange();return this.setSelectedBufferRange(t),t}}getLastSelection(){return this.createLastSelectionIfNeeded(),i.last(this.selections)}getSelectionAtScreenPosition(e){const t=this.selectionsMarkerLayer.findMarkers({containsScreenPosition:e});if(t.length>0)return this.cursorsByMarkerId.get(t[0].id).selection}getSelections(){return this.createLastSelectionIfNeeded(),this.selections.slice()}getSelectionsOrderedByBufferPosition(){return this.getSelections().sort((e,t)=>e.compare(t))}selectionIntersectsBufferRange(e){return this.getSelections().some(t=>t.intersectsBufferRange(e))}addSelectionBelow(){return this.expandSelectionsForward(e=>e.addSelectionBelow())}addSelectionAbove(){return this.expandSelectionsBackward(e=>e.addSelectionAbove())}expandSelectionsForward(e){this.mergeIntersectingSelections(()=>this.getSelections().forEach(e))}expandSelectionsBackward(e){this.mergeIntersectingSelections({reversed:!0},()=>this.getSelections().forEach(e))}finalizeSelections(){for(let e of this.getSelections())e.finalize()}selectionsForScreenRows(e,t){return this.getSelections().filter(o=>o.intersectsScreenRowRange(e,t))}mergeIntersectingSelections(...e){return this.mergeSelections(...e,(e,t)=>{const o=!t.isEmpty()&&!e.isEmpty();return e.intersectsWith(t,o)})}mergeSelectionsOnSameRows(...e){return this.mergeSelections(...e,(e,t)=>{const o=t.getScreenRange();return e.intersectsScreenRowRange(o.start.row,o.end.row)})}avoidMergingSelections(...e){return this.mergeSelections(...e,()=>!1)}mergeSelections(...e){const t=e.pop();let o=e.pop(),n=e.pop();if("function"!=typeof o&&(n=o,o=(()=>{})),this.suppressSelectionMerging)return o();this.suppressSelectionMerging=!0;const s=o();this.suppressSelectionMerging=!1;const r=this.getSelectionsOrderedByBufferPosition();let i=r.shift();for(const e of r)t(i,e)?i.merge(e,n):i=e;return s}addSelection(e,t={}){const o=this.addCursor(e);let n=new y(Object.assign({editor:this,marker:e,cursor:o},t));this.selections.push(n);const s=n.getBufferRange();if(this.mergeIntersectingSelections({preserveFolds:t.preserveFolds}),!n.destroyed)return this.emitter.emit("did-add-cursor",o),this.emitter.emit("did-add-selection",n),n;for(n of this.getSelections())if(n.intersectsBufferRange(s))return n}removeSelection(e){return i.remove(this.cursors,e.cursor),i.remove(this.selections,e),this.cursorsByMarkerId.delete(e.cursor.marker.id),this.emitter.emit("did-remove-cursor",e.cursor),this.emitter.emit("did-remove-selection",e)}clearSelections(e){this.consolidateSelections(),this.getLastSelection().clear(e)}consolidateSelections(){const e=this.getSelections();if(e.length>1){for(let t of e.slice(1,e.length))t.destroy();return e[0].autoscroll({center:!0}),!0}return!1}selectionRangeChanged(e){this.component&&this.component.didChangeSelectionRange(),this.emitter.emit("did-change-selection-range",e)}createLastSelectionIfNeeded(){0===this.selections.length&&this.addSelectionForBufferRange([[0,0],[0,0]],{autoscroll:!1,preserveFolds:!0})}scan(e,t={},o){return i.isFunction(t)&&(o=t,t={}),this.buffer.scan(e,t,o)}scanInBufferRange(e,t,o){return this.buffer.scanInRange(e,t,o)}backwardsScanInBufferRange(e,t,o){return this.buffer.backwardsScanInRange(e,t,o)}getSoftTabs(){return this.softTabs}setSoftTabs(e){this.softTabs=e,this.update({softTabs:this.softTabs})}hasAtomicSoftTabs(){return this.displayLayer.atomicSoftTabs}toggleSoftTabs(){this.setSoftTabs(!this.getSoftTabs())}getTabLength(){return this.displayLayer.tabLength}setTabLength(e){this.update({tabLength:e})}getInvisibles(){return!this.mini&&this.showInvisibles&&null!=this.invisibles?this.invisibles:{}}doesShowIndentGuide(){return this.showIndentGuide&&!this.mini}getSoftWrapHangingIndentLength(){return this.displayLayer.softWrapHangingIndent}usesSoftTabs(){const e=this.buffer.getLanguageMode(),t=e.isRowCommented;for(let o=0,n=Math.min(1e3,this.buffer.getLastRow());o<=n;o++){if(t&&e.isRowCommented(o))continue;const n=this.buffer.lineForRow(o);if(" "===n[0])return!0;if("\t"===n[0])return!1}}getTabText(){return this.buildIndentString(1)}normalizeTabsInBufferRange(e){if(this.getSoftTabs())return this.scanInBufferRange(/\t/g,e,({replace:e})=>e(this.getTabText()))}isSoftWrapped(){return this.softWrapped}setSoftWrapped(e){return this.update({softWrapped:e}),this.isSoftWrapped()}getPreferredLineLength(){return this.preferredLineLength}toggleSoftWrapped(){return this.setSoftWrapped(!this.isSoftWrapped())}getSoftWrapColumn(){return this.isSoftWrapped()&&!this.mini?this.softWrapAtPreferredLineLength?Math.min(this.getEditorWidthInChars(),this.preferredLineLength):this.getEditorWidthInChars():this.maxScreenLineLength}indentationForBufferRow(e){return this.indentLevelForLine(this.lineTextForBufferRow(e))}setIndentationForBufferRow(e,t,{preserveLeadingWhitespace:o}={}){let n;n=o?0:this.lineTextForBufferRow(e).match(/^\s*/)[0].length;const s=this.buildIndentString(t);return this.buffer.setTextInRange([[e,0],[e,n]],s)}indentSelectedRows(e={}){if(this.ensureWritable("indentSelectedRows",e))return this.mutateSelectedText(t=>t.indentSelectedRows(e))}outdentSelectedRows(e={}){if(this.ensureWritable("outdentSelectedRows",e))return this.mutateSelectedText(t=>t.outdentSelectedRows(e))}indentLevelForLine(e){const t=this.getTabLength();let o=0;for(let n=0,{length:s}=e;n<s;n++){const s=e[n];if("\t"===s)o+=t-o%t;else{if(" "!==s)break;o++}}return o/t}autoIndentSelectedRows(e={}){if(this.ensureWritable("autoIndentSelectedRows",e))return this.mutateSelectedText(t=>t.autoIndentSelectedRows(e))}indent(e={}){this.ensureWritable("indent",e)&&(null==e.autoIndent&&(e.autoIndent=this.shouldAutoIndent()),this.mutateSelectedText(t=>t.indent(e)))}buildIndentString(e,t=0){if(this.getSoftTabs()){const o=t%this.getTabLength();return i.multiplyString(" ",Math.floor(e*this.getTabLength())-o)}{const t=i.multiplyString(" ",Math.round((e-Math.floor(e))*this.getTabLength()));return i.multiplyString("\t",Math.floor(e))+t}}getGrammar(){const e=this.buffer.getLanguageMode();return e.getGrammar&&e.getGrammar()||v}setGrammar(e){const t=this.getBuffer();t.setLanguageMode(atom.grammars.languageModeForGrammarAndBuffer(e,t))}onDidTokenize(e){return this.emitter.on("did-tokenize",e)}getRootScopeDescriptor(){return this.buffer.getLanguageMode().rootScopeDescriptor}scopeDescriptorForBufferPosition(e){const t=this.buffer.getLanguageMode();return t.scopeDescriptorForPosition?t.scopeDescriptorForPosition(e):new w({scopes:["text"]})}syntaxTreeScopeDescriptorForBufferPosition(e){const t=this.buffer.getLanguageMode();return t.syntaxTreeScopeDescriptorForPosition?t.syntaxTreeScopeDescriptorForPosition(e):this.scopeDescriptorForBufferPosition(e)}bufferRangeForScopeAtCursor(e){return this.bufferRangeForScopeAtPosition(e,this.getCursorBufferPosition())}bufferRangeForScopeAtPosition(e,t){return this.buffer.getLanguageMode().bufferRangeForScopeAtPosition(e,t)}isBufferRowCommented(e){const t=this.lineTextForBufferRow(e).match(/\S/);if(t)return this.commentScopeSelector||(this.commentScopeSelector=new k("comment.*")),this.commentScopeSelector.matches(this.scopeDescriptorForBufferPosition([e,t.index]).scopes)}getCursorScope(){return this.getLastCursor().getScopeDescriptor()}getCursorSyntaxTreeScope(){return this.getLastCursor().getSyntaxTreeScopeDescriptor()}tokenForBufferPosition(e){return this.buffer.getLanguageMode().tokenForPosition(e)}copySelectedText(){let e=!1;for(let t of this.getSelectionsOrderedByBufferPosition()){if(t.isEmpty()){const o=t.getBufferRange();t.selectLine(),t.copy(e,!0),t.setBufferRange(o)}else t.copy(e,!1);e=!0}}copyOnlySelectedText(){let e=!1;for(let t of this.getSelectionsOrderedByBufferPosition())t.isEmpty()||(t.copy(e,!1),e=!0)}cutSelectedText(e={}){if(!this.ensureWritable("cutSelectedText",e))return;let t=!1;this.mutateSelectedText(o=>{o.isEmpty()?(o.selectLine(),o.cut(t,!0,e.bypassReadOnly)):o.cut(t,!1,e.bypassReadOnly),t=!0})}pasteText(e={}){if(!this.ensureWritable("parseText",e))return;e=Object.assign({},e);let{text:t,metadata:o}=this.constructor.clipboard.readWithMetadata();if(!this.emitWillInsertTextEvent(t))return!1;o||(o={}),null==e.autoIndent&&(e.autoIndent=this.shouldAutoIndentOnPaste()),this.mutateSelectedText((n,s)=>{let r,i,a,l;if(o.selections&&o.selections.length===this.getSelections().length?({text:a,indentBasis:i,fullLine:r}=o.selections[s]):(({indentBasis:i,fullLine:r}=o),a=t),null==i||!a.includes("\n")&&n.cursor.hasPrecedingCharactersOnLine()?e.indentBasis=null:e.indentBasis=i,r&&n.isEmpty()){const t=n.getBufferRange().start;n.setBufferRange([[t.row,0],[t.row,0]]),l=n.insertText(a,e);const o=t.translate([1,0]);n.setBufferRange([o,o])}else l=n.insertText(a,e);this.emitter.emit("did-insert-text",{text:a,range:l})})}cutToEndOfLine(e={}){if(!this.ensureWritable("cutToEndOfLine",e))return;let t=!1;this.mutateSelectedText(o=>{o.cutToEndOfLine(t,e),t=!0})}cutToEndOfBufferLine(e={}){if(!this.ensureWritable("cutToEndOfBufferLine",e))return;let t=!1;this.mutateSelectedText(o=>{o.cutToEndOfBufferLine(t,e),t=!0})}foldCurrentRow(){const{row:e}=this.getCursorBufferPosition(),t=this.buffer.getLanguageMode(),o=t.getFoldableRangeContainingPoint&&t.getFoldableRangeContainingPoint(f(e,Infinity),this.getTabLength());if(o)return this.displayLayer.foldBufferRange(o)}unfoldCurrentRow(){const{row:e}=this.getCursorBufferPosition();return this.displayLayer.destroyFoldsContainingBufferPositions([f(e,Infinity)],!1)}foldBufferRow(e){let t=f(e,Infinity);const o=this.buffer.getLanguageMode();for(;;){const e=o.getFoldableRangeContainingPoint&&o.getFoldableRangeContainingPoint(t,this.getTabLength());if(e){const o=this.displayLayer.foldsIntersectingBufferRange(g(e.start,e.start));if(0===o.length)this.displayLayer.foldBufferRange(e);else{const e=this.displayLayer.bufferRangeForFold(o[0]);if(e.start.isLessThan(t)){t=f(e.start.row,0);continue}}}break}}unfoldBufferRow(e){const t=f(e,Infinity);return this.displayLayer.destroyFoldsContainingBufferPositions([t])}foldSelectedLines(){for(let e of this.selections)e.fold()}foldAll(){const e=this.buffer.getLanguageMode(),t=e.getFoldableRanges&&e.getFoldableRanges(this.getTabLength());this.displayLayer.destroyAllFolds();for(let e of t||[])this.displayLayer.foldBufferRange(e)}unfoldAll(){const e=this.displayLayer.destroyAllFolds();return e.length>0&&this.scrollToCursorPosition(),e}foldAllAtIndentLevel(e){const t=this.buffer.getLanguageMode(),o=t.getFoldableRangesAtIndentLevel&&t.getFoldableRangesAtIndentLevel(e,this.getTabLength());this.displayLayer.destroyAllFolds();for(let e of o||[])this.displayLayer.foldBufferRange(e)}isFoldableAtBufferRow(e){const t=this.buffer.getLanguageMode();return t.isFoldableAtRow&&t.isFoldableAtRow(e)}isFoldableAtScreenRow(e){return this.isFoldableAtBufferRow(this.bufferRowForScreenRow(e))}toggleFoldAtBufferRow(e){return this.isFoldedAtBufferRow(e)?this.unfoldBufferRow(e):this.foldBufferRow(e)}isFoldedAtCursorRow(){return this.isFoldedAtBufferRow(this.getCursorBufferPosition().row)}isFoldedAtBufferRow(e){const t=g(f(e,0),f(e,this.buffer.lineLengthForRow(e)));return this.displayLayer.foldsIntersectingBufferRange(t).length>0}isFoldedAtScreenRow(e){return this.isFoldedAtBufferRow(this.bufferRowForScreenRow(e))}foldBufferRowRange(e,t){return this.foldBufferRange(g(f(e,Infinity),f(t,Infinity)))}foldBufferRange(e){return this.displayLayer.foldBufferRange(e)}destroyFoldsIntersectingBufferRange(e){return this.displayLayer.destroyFoldsIntersectingBufferRange(e)}destroyFoldsContainingBufferPositions(e,t){return this.displayLayer.destroyFoldsContainingBufferPositions(e,t)}addGutter(e){return this.gutterContainer.addGutter(e)}getGutters(){return this.gutterContainer.getGutters()}getLineNumberGutter(){return this.lineNumberGutter}gutterWithName(e){return this.gutterContainer.gutterWithName(e)}scrollToCursorPosition(e){this.getLastCursor().autoscroll({center:e&&!1!==e.center})}scrollToBufferPosition(e,t){return this.scrollToScreenPosition(this.screenPositionForBufferPosition(e),t)}scrollToScreenPosition(e,t){this.scrollToScreenRange(new g(e,e),t)}scrollToTop(){d.deprecate("This is now a view method. Call TextEditorElement::scrollToTop instead."),this.getElement().scrollToTop()}scrollToBottom(){d.deprecate("This is now a view method. Call TextEditorElement::scrollToTop instead."),this.getElement().scrollToBottom()}scrollToScreenRange(e,t={}){!1!==t.clip&&(e=this.clipScreenRange(e));const o={screenRange:e,options:t};this.component&&this.component.didRequestAutoscroll(o),this.emitter.emit("did-request-autoscroll",o)}getHorizontalScrollbarHeight(){return d.deprecate("This is now a view method. Call TextEditorElement::getHorizontalScrollbarHeight instead."),this.getElement().getHorizontalScrollbarHeight()}getVerticalScrollbarWidth(){return d.deprecate("This is now a view method. Call TextEditorElement::getVerticalScrollbarWidth instead."),this.getElement().getVerticalScrollbarWidth()}pageUp(){this.moveUp(this.getRowsPerPage())}pageDown(){this.moveDown(this.getRowsPerPage())}selectPageUp(){this.selectUp(this.getRowsPerPage())}selectPageDown(){this.selectDown(this.getRowsPerPage())}getRowsPerPage(){if(this.component){const e=this.component.getScrollContainerClientHeight(),t=this.component.getLineHeight();return Math.max(1,Math.ceil(e/t))}return 1}shouldAutoIndent(){return this.autoIndent}shouldAutoIndentOnPaste(){return this.autoIndentOnPaste}getScrollPastEnd(){return!this.getAutoHeight()&&this.scrollPastEnd}getScrollSensitivity(){return this.scrollSensitivity}getShowCursorOnSelection(){return this.showCursorOnSelection}doesShowLineNumbers(){return this.showLineNumbers}getUndoGroupingInterval(){return this.undoGroupingInterval}getNonWordCharacters(e){const t=this.buffer.getLanguageMode();return t.getNonWordCharacters&&t.getNonWordCharacters(e||f(0,0))||"/\\()\"':,.;<>~!@#$%^&*|+=[]{}`?-…"}handleLanguageModeChange(){this.unfoldAll(),this.languageModeSubscription&&(this.languageModeSubscription.dispose(),this.disposables.remove(this.languageModeSubscription));const e=this.buffer.getLanguageMode();this.component&&this.component.visible&&e.startTokenizing&&e.startTokenizing(),this.languageModeSubscription=e.onDidTokenize&&e.onDidTokenize(()=>{this.emitter.emit("did-tokenize")}),this.languageModeSubscription&&this.disposables.add(this.languageModeSubscription),this.emitter.emit("did-change-grammar",e.grammar)}getElement(){return this.component||(S||(S=s("../src/text-editor-component.js")),C||(C=s("../src/text-editor-element.js")),this.component=new S({model:this,updatedSynchronously:C.prototype.updatedSynchronously,initialScrollTopRow:this.initialScrollTopRow,initialScrollLeftColumn:this.initialScrollLeftColumn})),this.component.element}getAllowedLocations(){return["center"]}getPlaceholderText(){return this.placeholderText}setPlaceholderText(e){this.update({placeholderText:e})}pixelPositionForBufferPosition(e){return d.deprecate("This method is deprecated on the model layer. Use `TextEditorElement::pixelPositionForBufferPosition` instead"),this.getElement().pixelPositionForBufferPosition(e)}pixelPositionForScreenPosition(e){return d.deprecate("This method is deprecated on the model layer. Use `TextEditorElement::pixelPositionForScreenPosition` instead"),this.getElement().pixelPositionForScreenPosition(e)}getVerticalScrollMargin(){const e=Math.floor((this.height/this.getLineHeightInPixels()-1)/2);return Math.min(this.verticalScrollMargin,e)}setVerticalScrollMargin(e){return this.verticalScrollMargin=e,this.verticalScrollMargin}getHorizontalScrollMargin(){return Math.min(this.horizontalScrollMargin,Math.floor((this.width/this.getDefaultCharWidth()-1)/2))}setHorizontalScrollMargin(e){return this.horizontalScrollMargin=e,this.horizontalScrollMargin}getLineHeightInPixels(){return this.lineHeightInPixels}setLineHeightInPixels(e){return this.lineHeightInPixels=e,this.lineHeightInPixels}getKoreanCharWidth(){return this.koreanCharWidth}getHalfWidthCharWidth(){return this.halfWidthCharWidth}getDoubleWidthCharWidth(){return this.doubleWidthCharWidth}getDefaultCharWidth(){return this.defaultCharWidth}ratioForCharacter(e){return T(e)?this.getKoreanCharWidth()/this.getDefaultCharWidth():R(e)?this.getHalfWidthCharWidth()/this.getDefaultCharWidth():P(e)?this.getDoubleWidthCharWidth()/this.getDefaultCharWidth():1}setDefaultCharWidth(e,t,o,n){return null==t&&(t=e),null==o&&(o=e),null==n&&(n=e),(e!==this.defaultCharWidth||t!==this.doubleWidthCharWidth&&o!==this.halfWidthCharWidth&&n!==this.koreanCharWidth)&&(this.defaultCharWidth=e,this.doubleWidthCharWidth=t,this.halfWidthCharWidth=o,this.koreanCharWidth=n,this.isSoftWrapped()&&this.displayLayer.reset({softWrapColumn:this.getSoftWrapColumn()})),e}setHeight(e){d.deprecate("This is now a view method. Call TextEditorElement::setHeight instead."),this.getElement().setHeight(e)}getHeight(){return d.deprecate("This is now a view method. Call TextEditorElement::getHeight instead."),this.getElement().getHeight()}getAutoHeight(){return null==this.autoHeight||this.autoHeight}getAutoWidth(){return null!=this.autoWidth&&this.autoWidth}setWidth(e){d.deprecate("This is now a view method. Call TextEditorElement::setWidth instead."),this.getElement().setWidth(e)}getWidth(){return d.deprecate("This is now a view method. Call TextEditorElement::getWidth instead."),this.getElement().getWidth()}setFirstVisibleScreenRow(e){this.setScrollTopRow(e)}getFirstVisibleScreenRow(){return this.getElement().component.getFirstVisibleRow()}getLastVisibleScreenRow(){return this.getElement().component.getLastVisibleRow()}getVisibleRowRange(){return[this.getFirstVisibleScreenRow(),this.getLastVisibleScreenRow()]}setFirstVisibleScreenColumn(e){return this.setScrollLeftColumn(e)}getFirstVisibleScreenColumn(){return this.getElement().component.getFirstVisibleColumn()}getScrollTop(){return d.deprecate("This is now a view method. Call TextEditorElement::getScrollTop instead."),this.getElement().getScrollTop()}setScrollTop(e){d.deprecate("This is now a view method. Call TextEditorElement::setScrollTop instead."),this.getElement().setScrollTop(e)}getScrollBottom(){return d.deprecate("This is now a view method. Call TextEditorElement::getScrollBottom instead."),this.getElement().getScrollBottom()}setScrollBottom(e){d.deprecate("This is now a view method. Call TextEditorElement::setScrollBottom instead."),this.getElement().setScrollBottom(e)}getScrollLeft(){return d.deprecate("This is now a view method. Call TextEditorElement::getScrollLeft instead."),this.getElement().getScrollLeft()}setScrollLeft(e){d.deprecate("This is now a view method. Call TextEditorElement::setScrollLeft instead."),this.getElement().setScrollLeft(e)}getScrollRight(){return d.deprecate("This is now a view method. Call TextEditorElement::getScrollRight instead."),this.getElement().getScrollRight()}setScrollRight(e){d.deprecate("This is now a view method. Call TextEditorElement::setScrollRight instead."),this.getElement().setScrollRight(e)}getScrollHeight(){return d.deprecate("This is now a view method. Call TextEditorElement::getScrollHeight instead."),this.getElement().getScrollHeight()}getScrollWidth(){return d.deprecate("This is now a view method. Call TextEditorElement::getScrollWidth instead."),this.getElement().getScrollWidth()}getMaxScrollTop(){return d.deprecate("This is now a view method. Call TextEditorElement::getMaxScrollTop instead."),this.getElement().getMaxScrollTop()}getScrollTopRow(){return this.getElement().component.getScrollTopRow()}setScrollTopRow(e){this.getElement().component.setScrollTopRow(e)}getScrollLeftColumn(){return this.getElement().component.getScrollLeftColumn()}setScrollLeftColumn(e){this.getElement().component.setScrollLeftColumn(e)}intersectsVisibleRowRange(e,t){return d.deprecate("This is now a view method. Call TextEditorElement::intersectsVisibleRowRange instead."),this.getElement().intersectsVisibleRowRange(e,t)}selectionIntersectsVisibleRowRange(e){return d.deprecate("This is now a view method. Call TextEditorElement::selectionIntersectsVisibleRowRange instead."),this.getElement().selectionIntersectsVisibleRowRange(e)}screenPositionForPixelPosition(e){return d.deprecate("This is now a view method. Call TextEditorElement::screenPositionForPixelPosition instead."),this.getElement().screenPositionForPixelPosition(e)}pixelRectForScreenRange(e){return d.deprecate("This is now a view method. Call TextEditorElement::pixelRectForScreenRange instead."),this.getElement().pixelRectForScreenRange(e)}inspect(){return`<TextEditor ${this.id}>`}emitWillInsertTextEvent(e){let t=!0;return this.emitter.emit("will-insert-text",{cancel:()=>{t=!1},text:e}),t}suggestedIndentForBufferRow(e,t){const o=this.buffer.getLanguageMode();return o.suggestedIndentForBufferRow&&o.suggestedIndentForBufferRow(e,this.getTabLength(),t)}autoIndentBufferRow(e,t){const o=this.suggestedIndentForBufferRow(e,t);return this.setIndentationForBufferRow(e,o,t)}autoIndentBufferRows(e,t){let o=e;for(;o<=t;)this.autoIndentBufferRow(o),o++}autoDecreaseIndentForBufferRow(e){const t=this.buffer.getLanguageMode(),o=t.suggestedIndentForEditedBufferRow&&t.suggestedIndentForEditedBufferRow(e,this.getTabLength());null!=o&&this.setIndentationForBufferRow(e,o)}toggleLineCommentForBufferRow(e){this.toggleLineCommentsForBufferRows(e,e)}toggleLineCommentsForBufferRows(e,t){const o=this.buffer.getLanguageMode();let{commentStartString:n,commentEndString:s}=o.commentStringsForPosition&&o.commentStringsForPosition(new f(e,0))||{};if(n)if(n=n.trim(),s){s=s.trim();const o=columnRangeForStartDelimiter(this.buffer.lineForRow(e),n);if(o){const n=function columnRangeForEndDelimiter(e,t){let o=e.lastIndexOf(t);if(-1===o)return null;const n=o+t.length;if(D.test(e.slice(n)))return null;" "===e[o-1]&&o--;return[o,n]}(this.buffer.lineForRow(t),s);n&&this.buffer.transact(()=>{this.buffer.delete([[t,n[0]],[t,n[1]]]),this.buffer.delete([[e,o[0]],[e,o[1]]])})}else this.buffer.transact(()=>{const o=this.buffer.lineForRow(e).match(/^\s*/)[0].length;this.buffer.insert([e,o],n+" "),this.buffer.insert([t,this.buffer.lineLengthForRow(t)]," "+s)})}else{let o=!1,s=!1;for(let r=e;r<=t;r++){const e=this.buffer.lineForRow(r);D.test(e)&&(columnRangeForStartDelimiter(e,n)?o=!0:s=!0)}if(o&&!s)for(let o=e;o<=t;o++){const e=columnRangeForStartDelimiter(this.buffer.lineForRow(o),n);e&&this.buffer.delete([[o,e[0]],[o,e[1]]])}else{let o=Infinity,s=Infinity;for(let n=e;n<=t;n++){const e=this.buffer.lineForRow(n),t=this.indentLevelForLine(e);D.test(e)?t<o&&(o=t):t<s&&(s=t)}o=Number.isFinite(o)?o:Number.isFinite(s)?s:0;const r=this.buildIndentString(o);for(let s=e;s<=t;s++){const e=this.buffer.lineForRow(s);if(D.test(e)){const t=columnForIndentLevel(e,o,this.getTabLength());this.buffer.insert(f(s,t),n+" ")}else this.buffer.setTextInRange(new g(new f(s,0),new f(s,Infinity)),r+n+" ")}}}}rowRangeForParagraphAtBufferRow(e){if(!D.test(this.lineTextForBufferRow(e)))return;const t=this.buffer.getLanguageMode(),o=t.isRowCommented(e);let n=e;for(;n>0&&D.test(this.lineTextForBufferRow(n-1))&&t.isRowCommented(n-1)===o;)n--;let s=e;const r=this.getLineCount();for(;s+1<r&&D.test(this.lineTextForBufferRow(s+1))&&t.isRowCommented(s+1)===o;)s++;return new g(new f(n,0),new f(s,this.buffer.lineLengthForRow(s)))}};class ChangeEvent{constructor({oldRange:e,newRange:t}){this.oldRange=e,this.newRange=t}get start(){return this.newRange.start}get oldExtent(){return this.oldRange.getExtent()}get newExtent(){return this.newRange.getExtent()}}},"../src/text-editor-component.js":function(e,t,o,n,s,r){const i=s("../node_modules/etch/lib/index.js"),{Point:a,Range:l}=s("../node_modules/text-buffer/lib/text-buffer.js"),d=s("../node_modules/line-top-index/dist/line-top-index.js"),u=s("../src/text-editor.js"),{isPairedCharacter:c}=s("../src/text-utils.js");let m,p;function get_electron(){return m=m||s("electron")}const h=i.dom;let f;const g=" ",b="\ufeff";function scaleMouseDragAutoscrollDelta(e){return Math.pow(e/3,3)/280}t.exports=class TextEditorComponent{static setScheduler(e){i.setScheduler(e)}static getScheduler(){return i.getScheduler()}static didUpdateStyles(){this.attachedComponents&&this.attachedComponents.forEach(e=>{e.didUpdateStyles()})}static didUpdateScrollbarStyles(){this.attachedComponents&&this.attachedComponents.forEach(e=>{e.didUpdateScrollbarStyles()})}constructor(e){this.props=e,e.model||(e.model=new u({mini:e.mini,readOnly:e.readOnly})),this.props.model.component=this,e.element?this.element=e.element:(f||(f=s("../src/text-editor-element.js")),this.element=new f),this.element.initialize(this),this.virtualNode=h("atom-text-editor"),this.virtualNode.domNode=this.element,this.refs={},this.updateSync=this.updateSync.bind(this),this.didBlurHiddenInput=this.didBlurHiddenInput.bind(this),this.didFocusHiddenInput=this.didFocusHiddenInput.bind(this),this.didPaste=this.didPaste.bind(this),this.didTextInput=this.didTextInput.bind(this),this.didKeydown=this.didKeydown.bind(this),this.didKeyup=this.didKeyup.bind(this),this.didKeypress=this.didKeypress.bind(this),this.didCompositionStart=this.didCompositionStart.bind(this),this.didCompositionUpdate=this.didCompositionUpdate.bind(this),this.didCompositionEnd=this.didCompositionEnd.bind(this),this.updatedSynchronously=this.props.updatedSynchronously,this.didScrollDummyScrollbar=this.didScrollDummyScrollbar.bind(this),this.didMouseDownOnContent=this.didMouseDownOnContent.bind(this),this.debouncedResumeCursorBlinking=function debounce(e,t){let o,n;function later(){const s=Date.now()-o;s<t&&s>=0?n=setTimeout(later,t-s):(n=null,e())}return function(){o=Date.now(),n||(n=setTimeout(later,t))}}(this.resumeCursorBlinking.bind(this),this.props.cursorBlinkResumeDelay||300),this.lineTopIndex=new d,this.lineNodesPool=new NodePool,this.updateScheduled=!1,this.suppressUpdates=!1,this.hasInitialMeasurements=!1,this.measurements={lineHeight:0,baseCharacterWidth:0,doubleWidthCharacterWidth:0,halfWidthCharacterWidth:0,koreanCharacterWidth:0,gutterContainerWidth:0,lineNumberGutterWidth:0,clientContainerHeight:0,clientContainerWidth:0,verticalScrollbarWidth:0,horizontalScrollbarHeight:0,longestLineWidth:0},this.derivedDimensionsCache={},this.visible=!1,this.cursorsBlinking=!1,this.cursorsBlinkedOff=!1,this.nextUpdateOnlyBlinksCursors=null,this.linesToMeasure=new Map,this.extraRenderedScreenLines=new Map,this.horizontalPositionsToMeasure=new Map,this.horizontalPixelPositionsByScreenLineId=new Map,this.blockDecorationsToMeasure=new Set,this.blockDecorationsByElement=new WeakMap,this.blockDecorationSentinel=get_document().createElement("div"),this.blockDecorationSentinel.style.height="1px",this.heightsByBlockDecoration=new WeakMap,this.blockDecorationResizeObserver=new ResizeObserver(this.didResizeBlockDecorations.bind(this)),this.lineComponentsByScreenLineId=new Map,this.overlayComponents=new Set,this.shouldRenderDummyScrollbars=!0,this.remeasureScrollbars=!1,this.pendingAutoscroll=null,this.scrollTopPending=!1,this.scrollLeftPending=!1,this.scrollTop=0,this.scrollLeft=0,this.previousScrollWidth=0,this.previousScrollHeight=0,this.lastKeydown=null,this.lastKeydownBeforeKeypress=null,this.accentedCharacterMenuIsOpen=!1,this.remeasureGutterDimensions=!1,this.guttersToRender=[this.props.model.getLineNumberGutter()],this.guttersVisibility=[this.guttersToRender[0].visible],this.idsByTileStartRow=new Map,this.nextTileId=0,this.renderedTileStartRows=[],this.showLineNumbers=this.props.model.doesShowLineNumbers(),this.lineNumbersToRender={maxDigits:2,bufferRows:[],screenRows:[],keys:[],softWrappedFlags:[],foldableFlags:[]},this.decorationsToRender={lineNumbers:new Map,lines:null,highlights:[],cursors:[],overlays:[],customGutter:new Map,blocks:new Map,text:[]},this.decorationsToMeasure={highlights:[],cursors:new Map},this.textDecorationsByMarker=new Map,this.textDecorationBoundaries=[],this.pendingScrollTopRow=this.props.initialScrollTopRow,this.pendingScrollLeftColumn=this.props.initialScrollLeftColumn,this.tabIndex=this.props.element&&this.props.element.tabIndex?this.props.element.tabIndex:-1,this.measuredContent=!1,this.queryGuttersToRender(),this.queryMaxLineNumberDigits(),this.observeBlockDecorations(),this.updateClassList(),i.updateSync(this)}update(e){e.model!==this.props.model&&(this.props.model.component=null,e.model.component=this),this.props=e,this.scheduleUpdate()}pixelPositionForScreenPosition({row:e,column:t}){const o=this.pixelPositionAfterBlocksForRow(e);let n=0===t?0:this.pixelLeftForRowAndColumn(e,t);return null==n&&(this.requestHorizontalMeasurement(e,t),this.updateSync(),n=this.pixelLeftForRowAndColumn(e,t)),{top:o,left:n}}scheduleUpdate(e=!1){this.visible&&(this.suppressUpdates||(this.nextUpdateOnlyBlinksCursors=!1!==this.nextUpdateOnlyBlinksCursors&&!0===e,this.updatedSynchronously?this.updateSync():this.updateScheduled||(this.updateScheduled=!0,i.getScheduler().updateDocument(()=>{this.updateScheduled&&this.updateSync(!0)}))))}updateSync(e=!1){if(!this.visible)return void(this.updateScheduled=!1);if((this.remeasureCharacterDimensions||this.remeasureAllBlockDecorations)&&!this.isVisible())return this.resolveNextUpdatePromise&&this.resolveNextUpdatePromise(),void(this.updateScheduled=!1);const t=this.nextUpdateOnlyBlinksCursors;if(this.nextUpdateOnlyBlinksCursors=null,e&&t)return this.refs.cursorsAndInput.updateCursorBlinkSync(this.cursorsBlinkedOff),this.resolveNextUpdatePromise&&this.resolveNextUpdatePromise(),void(this.updateScheduled=!1);if(this.remeasureCharacterDimensions){const e=this.getLineHeight(),t=this.getBaseCharacterWidth(),o=this.getScrollTopRow(),n=this.getScrollLeftColumn();this.measureCharacterDimensions(),this.measureGutterDimensions(),this.queryLongestLine(),this.getLineHeight()!==e&&this.setScrollTopRow(o),this.getBaseCharacterWidth()!==t&&this.setScrollLeftColumn(n),this.remeasureCharacterDimensions=!1}if(this.measureBlockDecorations(),this.updateSyncBeforeMeasuringContent(),!0===e){const e=i.getScheduler();e.readDocument(()=>{const t=this.measureContentDuringUpdateSync();e.updateDocument(()=>{t?this.updateSync(!0):this.updateSyncAfterMeasuringContent()})})}else{this.measureContentDuringUpdateSync()?this.updateSync(!1):this.updateSyncAfterMeasuringContent()}this.updateScheduled=!1}measureBlockDecorations(){if(this.remeasureAllBlockDecorations){this.remeasureAllBlockDecorations=!1;const t=this.props.model.getDecorations();for(var e=0;e<t.length;e++){const o=t[e];o.getMarker().isValid()&&"block"===o.getProperties().type&&this.blockDecorationsToMeasure.add(o)}this.blockDecorationsToMeasure.size>0&&this.updateSyncBeforeMeasuringContent()}if(this.blockDecorationsToMeasure.size>0){const{blockDecorationMeasurementArea:e}=this.refs,t=new Set;for(e.appendChild(get_document().createElement("div")),this.blockDecorationsToMeasure.forEach(o=>{const{item:n}=o.getProperties(),s=u.viewForItem(n);if(get_document().contains(s)){const e=s.parentElement;if(!s.previousSibling){const o=this.blockDecorationSentinel.cloneNode();e.insertBefore(o,s),t.add(o)}if(!s.nextSibling){const o=this.blockDecorationSentinel.cloneNode();e.appendChild(o),t.add(o)}this.didMeasureVisibleBlockDecoration=!0}else e.appendChild(this.blockDecorationSentinel.cloneNode()),e.appendChild(s),e.appendChild(this.blockDecorationSentinel.cloneNode())}),this.resizeBlockDecorationMeasurementsArea&&(this.resizeBlockDecorationMeasurementsArea=!1,this.refs.blockDecorationMeasurementArea.style.width=this.getScrollWidth()+"px"),this.blockDecorationsToMeasure.forEach(e=>{const{item:t}=e.getProperties(),o=u.viewForItem(t),{previousSibling:n,nextSibling:s}=o,r=s.getBoundingClientRect().top-n.getBoundingClientRect().bottom;this.heightsByBlockDecoration.set(e,r),this.lineTopIndex.resizeBlock(e,r)}),t.forEach(e=>e.remove());e.firstChild;)e.firstChild.remove();this.blockDecorationsToMeasure.clear()}}updateSyncBeforeMeasuringContent(){if(this.measuredContent=!1,this.derivedDimensionsCache={},this.updateModelSoftWrapColumn(),this.pendingAutoscroll){let{screenRange:e,options:t}=this.pendingAutoscroll;this.autoscrollVertically(e,t),this.requestHorizontalMeasurement(e.start.row,e.start.column),this.requestHorizontalMeasurement(e.end.row,e.end.column)}this.populateVisibleRowRange(this.getRenderedStartRow()),this.populateVisibleTiles(),this.queryScreenLinesToRender(),this.queryLongestLine(),this.queryLineNumbersToRender(),this.queryGuttersToRender(),this.queryDecorationsToRender(),this.queryExtraScreenLinesToRender(),this.shouldRenderDummyScrollbars=!this.remeasureScrollbars,i.updateSync(this),this.updateClassList(),this.shouldRenderDummyScrollbars=!0,this.didMeasureVisibleBlockDecoration=!1}measureContentDuringUpdateSync(){let e=!1;this.remeasureGutterDimensions&&(e=this.measureGutterDimensions(),this.remeasureGutterDimensions=!1);const t=this.canScrollHorizontally()&&this.getHorizontalScrollbarHeight()>0;this.measureLongestLineWidth(),this.measureHorizontalPositions(),this.updateAbsolutePositionedDecorations();const o=this.canScrollHorizontally()&&this.getHorizontalScrollbarHeight()>0;if(this.pendingAutoscroll){this.derivedDimensionsCache={};const{screenRange:e,options:n}=this.pendingAutoscroll;this.autoscrollHorizontally(e,n),!t&&o&&this.autoscrollVertically(e,n),this.pendingAutoscroll=null}return this.linesToMeasure.clear(),this.measuredContent=!0,e||t!==o}updateSyncAfterMeasuringContent(){this.derivedDimensionsCache={},i.updateSync(this),this.currentFrameLineNumberGutterProps=null,this.scrollTopPending=!1,this.scrollLeftPending=!1,this.remeasureScrollbars&&(this.refs.verticalScrollbar.flushScrollPosition(),this.refs.horizontalScrollbar.flushScrollPosition(),this.measureScrollbarDimensions(),this.remeasureScrollbars=!1,i.updateSync(this)),this.derivedDimensionsCache={},this.resolveNextUpdatePromise&&this.resolveNextUpdatePromise()}render(){const{model:e}=this.props,t={};e.getAutoHeight()||e.getAutoWidth()||(t.contain="size");let o="100%",n="100%";this.hasInitialMeasurements&&(e.getAutoHeight()&&(o=this.getContentHeight()+this.getHorizontalScrollbarHeight()+"px"),e.getAutoWidth()?(t.width="min-content",n=this.getGutterContainerWidth()+this.getContentWidth()+this.getVerticalScrollbarWidth()+"px"):t.width=this.element.style.width);let s={};e.isMini()&&(s.mini=""),e.isReadOnly()&&(s.readonly="");const r={encoding:e.getEncoding()},i=e.getGrammar();return i&&i.scopeName&&(r.grammar=i.scopeName.replace(/\./g," ")),h("atom-text-editor",{style:t,attributes:s,dataset:r,tabIndex:-1,on:{mousewheel:this.didMouseWheel}},h.div({ref:"clientContainer",style:{position:"relative",contain:"strict",overflow:"hidden",backgroundColor:"inherit",height:o,width:n}},this.renderGutterContainer(),this.renderScrollContainer()),this.renderOverlayDecorations())}renderGutterContainer(){return this.props.model.isMini()?null:h(GutterContainerComponent,{ref:"gutterContainer",key:"gutterContainer",rootComponent:this,hasInitialMeasurements:this.hasInitialMeasurements,measuredContent:this.measuredContent,scrollTop:this.getScrollTop(),scrollHeight:this.getScrollHeight(),lineNumberGutterWidth:this.getLineNumberGutterWidth(),lineHeight:this.getLineHeight(),renderedStartRow:this.getRenderedStartRow(),renderedEndRow:this.getRenderedEndRow(),rowsPerTile:this.getRowsPerTile(),guttersToRender:this.guttersToRender,decorationsToRender:this.decorationsToRender,isLineNumberGutterVisible:this.props.model.isLineNumberGutterVisible(),showLineNumbers:this.showLineNumbers,lineNumbersToRender:this.lineNumbersToRender,didMeasureVisibleBlockDecoration:this.didMeasureVisibleBlockDecoration})}renderScrollContainer(){const e={position:"absolute",contain:"strict",overflow:"hidden",top:0,bottom:0,backgroundColor:"inherit"};return this.hasInitialMeasurements&&(e.left=this.getGutterContainerWidth()+"px",e.width=this.getScrollContainerWidth()+"px"),h.div({ref:"scrollContainer",key:"scrollContainer",className:"scroll-view",style:e},this.renderContent(),this.renderDummyScrollbars())}renderContent(){let e={contain:"strict",overflow:"hidden",backgroundColor:"inherit"};return this.hasInitialMeasurements&&(e.width=ceilToPhysicalPixelBoundary(this.getScrollWidth())+"px",e.height=ceilToPhysicalPixelBoundary(this.getScrollHeight())+"px",e.willChange="transform",e.transform=`translate(${-roundToPhysicalPixelBoundary(this.getScrollLeft())}px, ${-roundToPhysicalPixelBoundary(this.getScrollTop())}px)`),h.div({ref:"content",on:{mousedown:this.didMouseDownOnContent},style:e},this.renderLineTiles(),this.renderBlockDecorationMeasurementArea(),this.renderCharacterMeasurementLine())}renderHighlightDecorations(){return h(HighlightsComponent,{hasInitialMeasurements:this.hasInitialMeasurements,highlightDecorations:this.decorationsToRender.highlights.slice(),width:this.getScrollWidth(),height:this.getScrollHeight(),lineHeight:this.getLineHeight()})}renderLineTiles(){const e={position:"absolute",contain:"strict",overflow:"hidden"},t=[];if(t.push(this.renderHighlightDecorations()),this.hasInitialMeasurements){const{lineComponentsByScreenLineId:o}=this,n=this.getRenderedStartRow(),s=this.getRenderedEndRow(),r=this.getRowsPerTile(),i=this.getScrollWidth();for(let e=0;e<this.renderedTileStartRows.length;e++){const a=this.renderedTileStartRows[e],l=Math.min(s,a+r),d=this.pixelPositionBeforeBlocksForRow(l)-this.pixelPositionBeforeBlocksForRow(a);t.push(h(LinesTileComponent,{key:this.idsByTileStartRow.get(a),measuredContent:this.measuredContent,height:d,width:i,top:this.pixelPositionBeforeBlocksForRow(a),lineHeight:this.getLineHeight(),renderedStartRow:n,tileStartRow:a,tileEndRow:l,screenLines:this.renderedScreenLines.slice(a-n,l-n),lineDecorations:this.decorationsToRender.lines.slice(a-n,l-n),textDecorations:this.decorationsToRender.text.slice(a-n,l-n),blockDecorations:this.decorationsToRender.blocks.get(a),displayLayer:this.props.model.displayLayer,nodePool:this.lineNodesPool,lineComponentsByScreenLineId:o}))}this.extraRenderedScreenLines.forEach((e,r)=>{(r<n||r>=s)&&t.push(h(LineComponent,{key:"extra-"+e.id,offScreen:!0,screenLine:e,screenRow:r,displayLayer:this.props.model.displayLayer,nodePool:this.lineNodesPool,lineComponentsByScreenLineId:o}))}),e.width=this.getScrollWidth()+"px",e.height=this.getScrollHeight()+"px"}return t.push(this.renderPlaceholderText()),t.push(this.renderCursorsAndInput()),h.div({key:"lineTiles",ref:"lineTiles",className:"lines",style:e},t)}renderCursorsAndInput(){return h(CursorsAndInputComponent,{ref:"cursorsAndInput",key:"cursorsAndInput",didBlurHiddenInput:this.didBlurHiddenInput,didFocusHiddenInput:this.didFocusHiddenInput,didTextInput:this.didTextInput,didPaste:this.didPaste,didKeydown:this.didKeydown,didKeyup:this.didKeyup,didKeypress:this.didKeypress,didCompositionStart:this.didCompositionStart,didCompositionUpdate:this.didCompositionUpdate,didCompositionEnd:this.didCompositionEnd,measuredContent:this.measuredContent,lineHeight:this.getLineHeight(),scrollHeight:this.getScrollHeight(),scrollWidth:this.getScrollWidth(),decorationsToRender:this.decorationsToRender,cursorsBlinkedOff:this.cursorsBlinkedOff,hiddenInputPosition:this.hiddenInputPosition,tabIndex:this.tabIndex})}renderPlaceholderText(){const{model:e}=this.props;if(e.isEmpty()){const t=e.getPlaceholderText();if(null!=t)return h.div({className:"placeholder-text"},t)}return null}renderCharacterMeasurementLine(){return h.div({key:"characterMeasurementLine",ref:"characterMeasurementLine",className:"line dummy",style:{position:"absolute",visibility:"hidden"}},h.span({ref:"normalWidthCharacterSpan"},"x"),h.span({ref:"doubleWidthCharacterSpan"},"我"),h.span({ref:"halfWidthCharacterSpan"},"ﾊ"),h.span({ref:"koreanCharacterSpan"},"세"))}renderBlockDecorationMeasurementArea(){return h.div({ref:"blockDecorationMeasurementArea",key:"blockDecorationMeasurementArea",style:{contain:"strict",position:"absolute",visibility:"hidden",width:this.getScrollWidth()+"px"}})}renderDummyScrollbars(){if(this.shouldRenderDummyScrollbars&&!this.props.model.isMini()){let e,t,o,n,s,r,i,a,l;return this.hasInitialMeasurements?(e=this.getScrollHeight(),n=this.getScrollWidth(),t=this.getScrollTop(),s=this.getScrollLeft(),a=this.canScrollHorizontally(),l=this.canScrollVertically(),o=this.getHorizontalScrollbarHeight(),r=this.getVerticalScrollbarWidth(),i=this.remeasureScrollbars):i=!0,[h(DummyScrollbarComponent,{ref:"verticalScrollbar",orientation:"vertical",didScroll:this.didScrollDummyScrollbar,didMouseDown:this.didMouseDownOnContent,canScroll:l,scrollHeight:e,scrollTop:t,horizontalScrollbarHeight:o,forceScrollbarVisible:i}),h(DummyScrollbarComponent,{ref:"horizontalScrollbar",orientation:"horizontal",didScroll:this.didScrollDummyScrollbar,didMouseDown:this.didMouseDownOnContent,canScroll:a,scrollWidth:n,scrollLeft:s,verticalScrollbarWidth:r,forceScrollbarVisible:i}),h.div({ref:"scrollbarCorner",className:"scrollbar-corner",style:{position:"absolute",height:"20px",width:"20px",bottom:0,right:0,overflow:"scroll"}})]}return null}renderOverlayDecorations(){return this.decorationsToRender.overlays.map(e=>h(OverlayComponent,Object.assign({key:e.element,overlayComponents:this.overlayComponents,didResize:t=>{this.updateOverlayToRender(e),t.update(e)}},e)))}updateClassList(){const{model:e}=this.props,t=this.classList,o=["editor"];this.focused&&o.push("is-focused"),e.isMini()&&o.push("mini");for(var n=0;n<e.selections.length;n++)if(!e.selections[n].isEmpty()){o.push("has-selection");break}if(t)for(let e=0;e<t.length;e++){const n=t[e];o.includes(n)||this.element.classList.remove(n)}for(let e=0;e<o.length;e++)this.element.classList.add(o[e]);this.classList=o}queryScreenLinesToRender(){const{model:e}=this.props;this.renderedScreenLines=e.displayLayer.getScreenLines(this.getRenderedStartRow(),this.getRenderedEndRow())}queryLongestLine(){const{model:e}=this.props,t=e.getApproximateLongestScreenRow(),o=e.screenLineForScreenRow(t);(o!==this.previousLongestLine||this.remeasureCharacterDimensions)&&(this.requestLineToMeasure(t,o),this.longestLineToMeasure=o,this.previousLongestLine=o)}queryExtraScreenLinesToRender(){this.extraRenderedScreenLines.clear(),this.linesToMeasure.forEach((e,t)=>{(t<this.getRenderedStartRow()||t>=this.getRenderedEndRow())&&this.extraRenderedScreenLines.set(t,e)})}queryLineNumbersToRender(){const{model:e}=this.props;if(!e.anyLineNumberGutterVisible())return;this.showLineNumbers!==e.doesShowLineNumbers()&&(this.remeasureGutterDimensions=!0,this.showLineNumbers=e.doesShowLineNumbers()),this.queryMaxLineNumberDigits();const t=this.getRenderedStartRow(),o=this.getRenderedEndRow(),n=this.getRenderedRowCount(),s=e.bufferRowsForScreenRows(t,o),r=new Array(n),i=new Array(n),a=new Array(n),l=new Array(n);let d=t>0?e.bufferRowForScreenRow(t-1):-1,u=0;for(let n=t;n<o;n++){const o=n-t,c=s[o];c===d?(u++,l[o]=!0,i[o]=c+"-"+u):(u=0,l[o]=!1,i[o]=c);const m=s[o+1];a[o]=c!==m&&e.isFoldableAtBufferRow(c),r[o]=n,d=c}s.pop(),this.lineNumbersToRender.bufferRows=s,this.lineNumbersToRender.screenRows=r,this.lineNumbersToRender.keys=i,this.lineNumbersToRender.foldableFlags=a,this.lineNumbersToRender.softWrappedFlags=l}queryMaxLineNumberDigits(){const{model:e}=this.props;if(e.anyLineNumberGutterVisible()){const t=Math.max(2,e.getLineCount().toString().length);t!==this.lineNumbersToRender.maxDigits&&(this.remeasureGutterDimensions=!0,this.lineNumbersToRender.maxDigits=t)}}renderedScreenLineForRow(e){return this.renderedScreenLines[e-this.getRenderedStartRow()]||this.extraRenderedScreenLines.get(e)}queryGuttersToRender(){const e=this.guttersToRender,t=this.guttersVisibility;if(this.guttersToRender=this.props.model.getGutters(),this.guttersVisibility=this.guttersToRender.map(e=>e.visible),e&&e.length===this.guttersToRender.length){for(let o=0,n=this.guttersToRender.length;o<n;o++)if(this.guttersToRender[o]!==e[o]||this.guttersVisibility[o]!==t[o]){this.remeasureGutterDimensions=!0;break}}else this.remeasureGutterDimensions=!0}queryDecorationsToRender(){this.decorationsToRender.lineNumbers.clear(),this.decorationsToRender.lines=[],this.decorationsToRender.overlays.length=0,this.decorationsToRender.customGutter.clear(),this.decorationsToRender.blocks=new Map,this.decorationsToRender.text=[],this.decorationsToMeasure.highlights.length=0,this.decorationsToMeasure.cursors.clear(),this.textDecorationsByMarker.clear(),this.textDecorationBoundaries.length=0,this.props.model.decorationManager.decorationPropertiesByMarkerForScreenRowRange(this.getRenderedStartRow(),this.getRenderedEndRow()).forEach((e,t)=>{const o=t.getScreenRange(),n=t.isReversed();for(let s=0;s<e.length;s++){const r=e[s];this.addDecorationToRender(r.type,r,t,o,n)}}),this.populateTextDecorationsToRender()}addDecorationToRender(e,t,o,n,s){if(Array.isArray(e))for(let r=0,i=e.length;r<i;r++)this.addDecorationToRender(e[r],t,o,n,s);else switch(e){case"line":case"line-number":this.addLineDecorationToRender(e,t,n,s);break;case"highlight":this.addHighlightDecorationToMeasure(t,n,o.id);break;case"cursor":this.addCursorDecorationToMeasure(t,o,n,s);break;case"overlay":this.addOverlayDecorationToRender(t,o);break;case"gutter":this.addCustomGutterDecorationToRender(t,n);break;case"block":this.addBlockDecorationToRender(t,n,s);break;case"text":this.addTextDecorationToRender(t,n,o)}}addLineDecorationToRender(e,t,o,n){let s;if("line"===e)s=this.decorationsToRender.lines;else{const e=t.gutterName||"line-number";(s=this.decorationsToRender.lineNumbers.get(e))||(s=[],this.decorationsToRender.lineNumbers.set(e,s))}let r=!1;if(o.isEmpty()){if(t.onlyNonEmpty)return}else{if(t.onlyEmpty)return;!1!==t.omitEmptyLastRow&&(r=0===o.end.column)}const i=this.getRenderedStartRow();let a=o.start.row,l=o.end.row;t.onlyHead&&(n?l=a:a=l),a=Math.max(a,this.getRenderedStartRow()),l=Math.min(l,this.getRenderedEndRow()-1);for(let e=a;e<=l&&(!r||e!==o.end.row);e++){const o=s[e-i],n=o?o+" "+t.class:t.class;s[e-i]=n}}addHighlightDecorationToMeasure(e,t,o){if((t=function constrainRangeToRows(e,t,o){(e.start.row<t||e.end.row>=o)&&((e=e.copy()).start.row<t&&(e.start.row=t,e.start.column=0),e.end.row>=o&&(e.end.row=o,e.end.column=0));return e}(t,this.getRenderedStartRow(),this.getRenderedEndRow())).isEmpty())return;const{class:n,flashRequested:s,flashClass:r,flashDuration:i}=e;e.flashRequested=!1,this.decorationsToMeasure.highlights.push({screenRange:t,key:o,className:n,flashRequested:s,flashClass:r,flashDuration:i}),this.requestHorizontalMeasurement(t.start.row,t.start.column),this.requestHorizontalMeasurement(t.end.row,t.end.column)}addCursorDecorationToMeasure(e,t,o,n){const{model:s}=this.props;if(!s.getShowCursorOnSelection()&&!o.isEmpty())return;let r=this.decorationsToMeasure.cursors.get(t);if(!r){const e=s.getLastCursor().getMarker()===t,i=n?o.start:o.end,{row:a,column:l}=i;if(a<this.getRenderedStartRow()||a>=this.getRenderedEndRow())return;this.requestHorizontalMeasurement(a,l);let d=0;s.lineLengthForScreenRow(a)>l&&(d=1,this.requestHorizontalMeasurement(a,l+1)),r={screenPosition:i,columnWidth:d,isLastCursor:e},this.decorationsToMeasure.cursors.set(t,r)}e.class&&(r.className?r.className+=" "+e.class:r.className=e.class),e.style&&(r.style?Object.assign(r.style,e.style):r.style=Object.assign({},e.style))}addOverlayDecorationToRender(e,t){const{class:o,item:n,position:s,avoidOverflow:r}=e,i=u.viewForItem(n),a="tail"===s?t.getTailScreenPosition():t.getHeadScreenPosition();this.requestHorizontalMeasurement(a.row,a.column),this.decorationsToRender.overlays.push({className:o,element:i,avoidOverflow:r,screenPosition:a})}addCustomGutterDecorationToRender(e,t){let o=this.decorationsToRender.customGutter.get(e.gutterName);o||(o=[],this.decorationsToRender.customGutter.set(e.gutterName,o));const n=this.pixelPositionAfterBlocksForRow(t.start.row),s=this.pixelPositionBeforeBlocksForRow(t.end.row+1)-n;o.push({className:"decoration"+(e.class?" "+e.class:""),element:u.viewForItem(e.item),top:n,height:s})}addBlockDecorationToRender(e,t,o){const{row:n}=o?t.start:t.end;if(n<this.getRenderedStartRow()||n>=this.getRenderedEndRow())return;const s=this.tileStartRowForRow(n),r=this.renderedScreenLines[n-this.getRenderedStartRow()];let i=this.decorationsToRender.blocks.get(s);i||(i=new Map,this.decorationsToRender.blocks.set(s,i));let a=i.get(r.id);a||(a=[],i.set(r.id,a)),a.push(e),a.sort((e,t)=>e.order!==t.order?e.order-t.order:e.id-t.id)}addTextDecorationToRender(e,t,o){if(t.isEmpty())return;let n=this.textDecorationsByMarker.get(o);n||(n=[],this.textDecorationsByMarker.set(o,n),this.textDecorationBoundaries.push({position:t.start,starting:[o]}),this.textDecorationBoundaries.push({position:t.end,ending:[o]})),n.push(e)}populateTextDecorationsToRender(){this.textDecorationBoundaries.sort((e,t)=>e.position.compare(t.position));for(let e=0;e<this.textDecorationBoundaries.length;){const t=this.textDecorationBoundaries[e],o=this.textDecorationBoundaries[e+1];o&&o.position.isEqual(t.position)?(o.starting&&(t.starting?t.starting.push(...o.starting):t.starting=o.starting),o.ending&&(t.ending?t.ending.push(...o.ending):t.ending=o.ending),this.textDecorationBoundaries.splice(e+1,1)):e++}const e=this.getRenderedStartRow(),t=this.getRenderedEndRow(),o=[];for(let n=0;n<this.textDecorationBoundaries.length;n++){const s=this.textDecorationBoundaries[n];if(s.starting&&s.starting.length>1&&s.starting.sort((e,t)=>e.compare(t)),s.ending&&s.ending.length>1&&s.ending.sort((e,t)=>t.compare(e)),s.ending)for(let e=s.ending.length-1;e>=0;e--)o.splice(o.lastIndexOf(s.ending[e]),1);let r,i;s.starting&&o.push(...s.starting);for(let e=0;e<o.length;e++){const t=o[e],n=this.textDecorationsByMarker.get(t);for(let e=0;e<n.length;e++){const t=n[e];t.class&&(r?r+=" "+t.class:r=t.class),t.style&&(i?Object.assign(i,t.style):i=Object.assign({},t.style))}}s.position.row>=e&&this.addTextDecorationStart(s.position.row,s.position.column,r,i);const a=this.textDecorationBoundaries[n+1];if(a){let o=Math.max(s.position.row+1,e);const n=Math.min(a.position.row,t);for(;o<n;o++)this.addTextDecorationStart(o,0,r,i);o===a.position.row&&0!==a.position.column&&this.addTextDecorationStart(o,0,r,i)}}}addTextDecorationStart(e,t,o,n){const s=this.getRenderedStartRow();let r=this.decorationsToRender.text[e-s];r||(r=[],this.decorationsToRender.text[e-s]=r),r.push({column:t,className:o,style:n})}updateAbsolutePositionedDecorations(){this.updateHighlightsToRender(),this.updateCursorsToRender(),this.updateOverlaysToRender()}updateHighlightsToRender(){this.decorationsToRender.highlights.length=0;for(let e=0;e<this.decorationsToMeasure.highlights.length;e++){const t=this.decorationsToMeasure.highlights[e],{start:o,end:n}=t.screenRange;t.startPixelTop=this.pixelPositionAfterBlocksForRow(o.row),t.startPixelLeft=this.pixelLeftForRowAndColumn(o.row,o.column),t.endPixelTop=this.pixelPositionAfterBlocksForRow(n.row)+this.getLineHeight(),t.endPixelLeft=this.pixelLeftForRowAndColumn(n.row,n.column),this.decorationsToRender.highlights.push(t)}}updateCursorsToRender(){this.decorationsToRender.cursors.length=0,this.decorationsToMeasure.cursors.forEach(e=>{const{screenPosition:t,className:o,style:n}=e,{row:s,column:r}=t,i=this.pixelPositionAfterBlocksForRow(s),a=this.pixelLeftForRowAndColumn(s,r);let l;const d={pixelTop:i,pixelLeft:a,pixelWidth:l=0===e.columnWidth?this.getBaseCharacterWidth():this.pixelLeftForRowAndColumn(s,r+1)-a,className:o,style:n};this.decorationsToRender.cursors.push(d),e.isLastCursor&&(this.hiddenInputPosition=d)})}updateOverlayToRender(e){const t=this.getWindowInnerHeight(),o=this.getWindowInnerWidth(),n=this.refs.content.getBoundingClientRect(),{element:s,screenPosition:r,avoidOverflow:i}=e,{row:a,column:l}=r;let d=n.top+this.pixelPositionAfterBlocksForRow(a)+this.getLineHeight(),u=n.left+this.pixelLeftForRowAndColumn(a,l);const c=s.getBoundingClientRect();if(!1!==i){const e=get_window().getComputedStyle(s),n=d+parseInt(e.marginTop),r=n+c.height,i=d-this.getLineHeight()-c.height-parseInt(e.marginBottom),a=u+parseInt(e.marginLeft),l=a+c.width;r>t&&i>=0&&(d-=n-i),a<0?u-=a:l>o&&(u-=l-o)}e.pixelTop=Math.round(d),e.pixelLeft=Math.round(u)}updateOverlaysToRender(){const e=this.decorationsToRender.overlays.length;if(0===e)return null;for(let t=0;t<e;t++){const e=this.decorationsToRender.overlays[t];this.updateOverlayToRender(e)}}didAttach(){this.attached||(this.attached=!0,this.intersectionObserver=new IntersectionObserver(e=>{const{intersectionRect:t}=e[e.length-1];t.width>0||t.height>0?this.didShow():this.didHide()}),this.intersectionObserver.observe(this.element),this.resizeObserver=new ResizeObserver(this.didResize.bind(this)),this.resizeObserver.observe(this.element),this.refs.gutterContainer&&(this.gutterContainerResizeObserver=new ResizeObserver(this.didResizeGutterContainer.bind(this)),this.gutterContainerResizeObserver.observe(this.refs.gutterContainer.element)),this.overlayComponents.forEach(e=>e.didAttach()),this.isVisible()?(this.didShow(),this.refs.verticalScrollbar&&this.refs.verticalScrollbar.flushScrollPosition(),this.refs.horizontalScrollbar&&this.refs.horizontalScrollbar.flushScrollPosition()):this.didHide(),this.constructor.attachedComponents||(this.constructor.attachedComponents=new Set),this.constructor.attachedComponents.add(this))}didDetach(){this.attached&&(this.intersectionObserver.disconnect(),this.resizeObserver.disconnect(),this.gutterContainerResizeObserver&&this.gutterContainerResizeObserver.disconnect(),this.overlayComponents.forEach(e=>e.didDetach()),this.didHide(),this.attached=!1,this.constructor.attachedComponents.delete(this))}didShow(){!this.visible&&this.isVisible()&&(this.hasInitialMeasurements||this.measureDimensions(),this.visible=!0,this.props.model.setVisible(!0),this.resizeBlockDecorationMeasurementsArea=!0,this.updateSync(),this.flushPendingLogicalScrollPosition())}didHide(){this.visible&&(this.visible=!1,this.props.model.setVisible(!1))}didFocus(){this.attached||this.didAttach(),this.visible||this.didShow(),this.focused||(this.focused=!0,this.startCursorBlinking(),this.scheduleUpdate()),this.getHiddenInput().focus()}didBlur(e){e.relatedTarget===this.getHiddenInput()&&e.stopImmediatePropagation()}didBlurHiddenInput(e){this.element===e.relatedTarget||this.element.contains(e.relatedTarget)||(this.focused=!1,this.stopCursorBlinking(),this.scheduleUpdate(),this.element.dispatchEvent(new FocusEvent(e.type,e)))}didFocusHiddenInput(){this.refs.scrollContainer.scrollTop=0,this.refs.scrollContainer.scrollLeft=0,this.focused||(this.focused=!0,this.startCursorBlinking(),this.scheduleUpdate())}didMouseWheel(e){const t=this.props.model.getScrollSensitivity()/100;let{wheelDeltaX:o,wheelDeltaY:n}=e;if(Math.abs(o)>Math.abs(n)?(o*=t,n=0):(o=0,n*=t),"darwin"!==this.getPlatform()&&e.shiftKey){let e=o;o=n,n=e}const s=0!==o&&this.setScrollLeft(this.getScrollLeft()-o),r=0!==n&&this.setScrollTop(this.getScrollTop()-n);(s||r)&&this.updateSync()}didResize(){if(this.isVisible()){const e=this.measureClientContainerWidth(),t=this.measureClientContainerHeight();(e||t)&&(e&&(this.remeasureAllBlockDecorations=!0),this.resizeObserver.disconnect(),this.scheduleUpdate(),get_process().nextTick(()=>{this.resizeObserver.observe(this.element)}))}}didResizeGutterContainer(){this.isVisible()&&this.measureGutterDimensions()&&(this.gutterContainerResizeObserver.disconnect(),this.scheduleUpdate(),get_process().nextTick(()=>{this.gutterContainerResizeObserver.observe(this.refs.gutterContainer.element)}))}didScrollDummyScrollbar(){let e=!1,t=!1;this.scrollTopPending||(e=this.setScrollTop(this.refs.verticalScrollbar.element.scrollTop)),this.scrollLeftPending||(t=this.setScrollLeft(this.refs.horizontalScrollbar.element.scrollLeft)),(e||t)&&this.updateSync()}didUpdateStyles(){this.remeasureCharacterDimensions=!0,this.horizontalPixelPositionsByScreenLineId.clear(),this.scheduleUpdate()}didUpdateScrollbarStyles(){this.props.model.isMini()||(this.remeasureScrollbars=!0,this.scheduleUpdate())}didPaste(e){"linux"===this.getPlatform()&&e.preventDefault()}didTextInput(e){this.compositionCheckpoint&&(this.props.model.revertToCheckpoint(this.compositionCheckpoint),this.compositionCheckpoint=null),this.isInputEnabled()&&(e.stopPropagation()," "===e.data?get_window().setImmediate(()=>{this.refs.scrollContainer.scrollTop=0,this.refs.scrollContainer.scrollLeft=0}):e.preventDefault(),this.accentedCharacterMenuIsOpen&&this.props.model.selectLeft(),this.props.model.insertText(e.data,{groupUndo:!0}))}didKeydown(e){this.stopDragging&&"Control"!==e.key&&"Alt"!==e.key&&"Meta"!==e.key&&"Shift"!==e.key&&this.stopDragging(),null!=this.lastKeydownBeforeKeypress&&(this.lastKeydownBeforeKeypress.code===e.code&&(this.accentedCharacterMenuIsOpen=!0),this.lastKeydownBeforeKeypress=null),this.lastKeydown=e}didKeypress(e){this.lastKeydownBeforeKeypress=this.lastKeydown,this.accentedCharacterMenuIsOpen=!1}didKeyup(e){this.lastKeydownBeforeKeypress&&this.lastKeydownBeforeKeypress.code===e.code&&(this.lastKeydownBeforeKeypress=null)}didCompositionStart(){if(this.lastKeydown&&this.lastKeydown.defaultPrevented)return this.getHiddenInput().disabled=!0,void get_process().nextTick(()=>{this.getHiddenInput().disabled=!1,this.getHiddenInput().focus()});this.compositionCheckpoint=this.props.model.createCheckpoint(),this.accentedCharacterMenuIsOpen&&this.props.model.selectLeft()}didCompositionUpdate(e){this.props.model.insertText(e.data,{select:!0})}didCompositionEnd(e){e.target.value=""}didMouseDownOnContent(e){const{model:t}=this.props,{target:o,button:n,detail:s,ctrlKey:r,shiftKey:i,metaKey:a}=e,l=this.getPlatform();if(o){let e=o;for(;e&&e!==this.element;){if(this.blockDecorationsByElement.has(e))return;e=e.parentElement}}const d=this.screenPositionForMouseEvent(e);if(1===n)return t.setCursorScreenPosition(d,{autoscroll:!1}),void("linux"===l&&this.isInputEnabled()&&t.insertText(function get_clipboard(){return p=p||get_electron().clipboard}().readText("selection")));if(0!==n)return;if("darwin"===l&&r)return;if(o&&o.matches(".fold-marker")){const e=t.bufferPositionForScreenPosition(d);return void t.destroyFoldsContainingBufferPositions([e],!1)}const u=a||r&&"darwin"!==l;switch(s){case 1:if(u){const e=t.getSelectionAtScreenPosition(d);e?t.hasMultipleCursors()&&e.destroy():t.addCursorAtScreenPosition(d,{autoscroll:!1})}else i?t.selectToScreenPosition(d,{autoscroll:!1}):t.setCursorScreenPosition(d,{autoscroll:!1});break;case 2:u&&t.addCursorAtScreenPosition(d,{autoscroll:!1}),t.getLastSelection().selectWord({autoscroll:!1});break;case 3:u&&t.addCursorAtScreenPosition(d,{autoscroll:!1}),t.getLastSelection().selectLine(null,{autoscroll:!1})}this.handleMouseDragUntilMouseUp({didDrag:e=>{this.autoscrollOnMouseDrag(e);const o=this.screenPositionForMouseEvent(e);t.selectToScreenPosition(o,{suppressSelectionMerge:!0,autoscroll:!1}),this.updateSync()},didStopDragging:()=>{t.finalizeSelections(),t.mergeIntersectingSelections(),this.updateSync()}})}didMouseDownOnLineNumberGutter(e){const{model:t}=this.props,{target:o,button:n,ctrlKey:s,shiftKey:r,metaKey:i}=e;if(0!==n)return;const d=this.screenPositionForMouseEvent(e).row,u=t.bufferPositionForScreenPosition([d,0]).row;if(o&&(o.matches(".foldable .icon-right")||o.matches(".folded .icon-right")))return void t.toggleFoldAtBufferRow(u);const c=i||s&&"darwin"!==this.getPlatform(),m=t.bufferPositionForScreenPosition([d,Infinity]).row,p=l(a(u,0),a(m+1,0));let h;if(r){const e=t.getLastSelection();h=e.getBufferRange(),e.setBufferRange(h.union(p),{reversed:d<e.getScreenRange().start.row,autoscroll:!1,preserveFolds:!0,suppressSelectionMerge:!0})}else h=p,c?t.addSelectionForBufferRange(p,{autoscroll:!1,preserveFolds:!0}):t.setSelectedBufferRange(p,{autoscroll:!1,preserveFolds:!0});const f=t.screenRangeForBufferRange(h);this.handleMouseDragUntilMouseUp({didDrag:e=>{this.autoscrollOnMouseDrag(e,!0);const o=this.screenPositionForMouseEvent(e).row,n=l(a(o,0),a(o+1,0));t.getLastSelection().setScreenRange(n.union(f),{reversed:o<f.start.row,autoscroll:!1,preserveFolds:!0}),this.updateSync()},didStopDragging:()=>{t.mergeIntersectingSelections(),this.updateSync()}})}handleMouseDragUntilMouseUp({didDrag:e,didStopDragging:t}){let o,n=!1;const s=()=>{get_window().requestAnimationFrame(()=>{n&&this.visible&&(e(o),s())})};function didMouseMove(e){o=e,n||(n=!0,s())}function didMouseUp(){this.stopDragging=null,get_window().removeEventListener("mousemove",didMouseMove),get_window().removeEventListener("mouseup",didMouseUp,{capture:!0}),n&&(n=!1,t())}get_window().addEventListener("mousemove",didMouseMove),get_window().addEventListener("mouseup",didMouseUp,{capture:!0}),this.stopDragging=didMouseUp}autoscrollOnMouseDrag({clientX:e,clientY:t},o=!1){var{top:n,bottom:s,left:r,right:i}=this.refs.scrollContainer.getBoundingClientRect();let a,l,d,u;s-=40,i-=40,t<(n+=40)?(a=n-t,l=-1):t>s&&(a=t-s,l=1),e<(r+=40)?(d=r-e,u=-1):e>i&&(d=e-i,u=1);let c=!1;if(null!=a){const e=scaleMouseDragAutoscrollDelta(a)*l;c=this.setScrollTop(this.getScrollTop()+e)}if(!o&&null!=d){const e=scaleMouseDragAutoscrollDelta(d)*u;c=this.setScrollLeft(this.getScrollLeft()+e)}c&&this.updateSync()}screenPositionForMouseEvent(e){return this.screenPositionForPixelPosition(this.pixelPositionForMouseEvent(e))}pixelPositionForMouseEvent({clientX:e,clientY:t}){const o=this.refs.scrollContainer.getBoundingClientRect();e=Math.min(o.right,Math.max(o.left,e)),t=Math.min(o.bottom,Math.max(o.top,t));const n=this.refs.lineTiles.getBoundingClientRect();return{top:t-n.top,left:e-n.left}}didUpdateSelections(){this.pauseCursorBlinking(),this.scheduleUpdate()}pauseCursorBlinking(){this.stopCursorBlinking(),this.debouncedResumeCursorBlinking()}resumeCursorBlinking(){this.cursorsBlinkedOff=!0,this.startCursorBlinking()}stopCursorBlinking(){this.cursorsBlinking&&(this.cursorsBlinkedOff=!1,this.cursorsBlinking=!1,get_window().clearInterval(this.cursorBlinkIntervalHandle),this.cursorBlinkIntervalHandle=null,this.scheduleUpdate())}startCursorBlinking(){this.cursorsBlinking||(this.cursorBlinkIntervalHandle=get_window().setInterval(()=>{this.cursorsBlinkedOff=!this.cursorsBlinkedOff,this.scheduleUpdate(!0)},(this.props.cursorBlinkPeriod||800)/2),this.cursorsBlinking=!0,this.scheduleUpdate(!0))}didRequestAutoscroll(e){this.pendingAutoscroll=e,this.scheduleUpdate()}flushPendingLogicalScrollPosition(){let e=!1;this.pendingScrollTopRow>0&&(e=this.setScrollTopRow(this.pendingScrollTopRow,!1),this.pendingScrollTopRow=null);let t=!1;this.pendingScrollLeftColumn>0&&(t=this.setScrollLeftColumn(this.pendingScrollLeftColumn,!1),this.pendingScrollLeftColumn=null),(e||t)&&this.updateSync()}autoscrollVertically(e,t){const o=this.pixelPositionAfterBlocksForRow(e.start.row),n=this.pixelPositionAfterBlocksForRow(e.end.row)+this.getLineHeight(),s=this.getVerticalAutoscrollMargin();let r,i;if(t&&t.center){const e=(o+n)/2;(e<this.getScrollTop()||e>this.getScrollBottom())&&(r=e-this.getScrollContainerClientHeight()/2,i=e+this.getScrollContainerClientHeight()/2)}else r=o-s,i=n+s;return t&&!1===t.reversed?(r<this.getScrollTop()&&this.setScrollTop(r),i>this.getScrollBottom()&&this.setScrollBottom(i)):(i>this.getScrollBottom()&&this.setScrollBottom(i),r<this.getScrollTop()&&this.setScrollTop(r)),!1}autoscrollHorizontally(e,t){const o=this.getHorizontalAutoscrollMargin(),n=this.getGutterContainerWidth();let s=this.pixelLeftForRowAndColumn(e.start.row,e.start.column)+n,r=this.pixelLeftForRowAndColumn(e.end.row,e.end.column)+n;const i=Math.max(0,s-o-n),a=Math.min(this.getScrollWidth(),r+o);t&&!1===t.reversed?(i<this.getScrollLeft()&&this.setScrollLeft(i),a>this.getScrollRight()&&this.setScrollRight(a)):(a>this.getScrollRight()&&this.setScrollRight(a),i<this.getScrollLeft()&&this.setScrollLeft(i))}getVerticalAutoscrollMargin(){const e=Math.floor((this.getScrollContainerClientHeight()/this.getLineHeight()-1)/2);return Math.min(this.props.model.verticalScrollMargin,e)*this.getLineHeight()}getHorizontalAutoscrollMargin(){const e=Math.floor((this.getScrollContainerClientWidth()/this.getBaseCharacterWidth()-1)/2);return Math.min(this.props.model.horizontalScrollMargin,e)*this.getBaseCharacterWidth()}updateModelSoftWrapColumn(){const{model:e}=this.props,t=this.getScrollContainerClientWidthInBaseCharacters();if(t!==e.getEditorWidthInChars()){this.suppressUpdates=!0;const e=this.getRenderedStartRow();this.props.model.setEditorWidthInChars(t),this.populateVisibleRowRange(e),this.props.model.setEditorWidthInChars(this.getScrollContainerClientWidthInBaseCharacters()),this.derivedDimensionsCache={},this.suppressUpdates=!1}}measureDimensions(){this.measureCharacterDimensions(),this.measureGutterDimensions(),this.measureClientContainerHeight(),this.measureClientContainerWidth(),this.measureScrollbarDimensions(),this.hasInitialMeasurements=!0}measureCharacterDimensions(){this.measurements.lineHeight=Math.max(1,this.refs.characterMeasurementLine.getBoundingClientRect().height),this.measurements.baseCharacterWidth=this.refs.normalWidthCharacterSpan.getBoundingClientRect().width,this.measurements.doubleWidthCharacterWidth=this.refs.doubleWidthCharacterSpan.getBoundingClientRect().width,this.measurements.halfWidthCharacterWidth=this.refs.halfWidthCharacterSpan.getBoundingClientRect().width,this.measurements.koreanCharacterWidth=this.refs.koreanCharacterSpan.getBoundingClientRect().width,this.props.model.setLineHeightInPixels(this.measurements.lineHeight),this.props.model.setDefaultCharWidth(this.measurements.baseCharacterWidth,this.measurements.doubleWidthCharacterWidth,this.measurements.halfWidthCharacterWidth,this.measurements.koreanCharacterWidth),this.lineTopIndex.setDefaultLineHeight(this.measurements.lineHeight)}measureGutterDimensions(){let e=!1;if(this.refs.gutterContainer){const t=this.refs.gutterContainer.element.offsetWidth;t!==this.measurements.gutterContainerWidth&&(e=!0,this.measurements.gutterContainerWidth=t)}else this.measurements.gutterContainerWidth=0;if(this.refs.gutterContainer&&this.refs.gutterContainer.refs.lineNumberGutter){const t=this.refs.gutterContainer.refs.lineNumberGutter.element.offsetWidth;t!==this.measurements.lineNumberGutterWidth&&(e=!0,this.measurements.lineNumberGutterWidth=t)}else this.measurements.lineNumberGutterWidth=0;return e}measureClientContainerHeight(){const e=this.refs.clientContainer.offsetHeight;return e!==this.measurements.clientContainerHeight&&(this.measurements.clientContainerHeight=e,!0)}measureClientContainerWidth(){const e=this.refs.clientContainer.offsetWidth;return e!==this.measurements.clientContainerWidth&&(this.measurements.clientContainerWidth=e,!0)}measureScrollbarDimensions(){this.props.model.isMini()?(this.measurements.verticalScrollbarWidth=0,this.measurements.horizontalScrollbarHeight=0):(this.measurements.verticalScrollbarWidth=this.refs.verticalScrollbar.getRealScrollbarWidth(),this.measurements.horizontalScrollbarHeight=this.refs.horizontalScrollbar.getRealScrollbarHeight())}measureLongestLineWidth(){if(this.longestLineToMeasure){const e=this.lineComponentsByScreenLineId.get(this.longestLineToMeasure.id);this.measurements.longestLineWidth=e.element.firstChild.offsetWidth,this.longestLineToMeasure=null}}requestLineToMeasure(e,t){this.linesToMeasure.set(e,t)}requestHorizontalMeasurement(e,t){if(0===t)return;const o=this.props.model.screenLineForScreenRow(e);if(o){this.requestLineToMeasure(e,o);let n=this.horizontalPositionsToMeasure.get(e);null==n&&(n=[],this.horizontalPositionsToMeasure.set(e,n)),n.push(t)}}measureHorizontalPositions(){this.horizontalPositionsToMeasure.forEach((e,t)=>{e.sort((e,t)=>e-t);const o=this.renderedScreenLineForRow(t),n=this.lineComponentsByScreenLineId.get(o.id);if(!n){const n=new Error("Requested measurement of a line component that is not currently rendered");throw n.metadata={row:t,columnsToMeasure:e,renderedScreenLineIds:this.renderedScreenLines.map(e=>e.id),extraRenderedScreenLineIds:Array.from(this.extraRenderedScreenLines.keys()),lineComponentScreenLineIds:Array.from(this.lineComponentsByScreenLineId.keys()),renderedStartRow:this.getRenderedStartRow(),renderedEndRow:this.getRenderedEndRow(),requestedScreenLineId:o.id},n}const s=n.element,r=n.textNodes;let i=this.horizontalPixelPositionsByScreenLineId.get(o.id);null==i&&(i=new Map,this.horizontalPixelPositionsByScreenLineId.set(o.id,i)),this.measureHorizontalPositionsOnLine(s,r,e,i)}),this.horizontalPositionsToMeasure.clear()}measureHorizontalPositionsOnLine(e,t,o,n){let s=-1,r=0,i=0,a=null;e:for(let l=0;l<o.length;l++){const d=o[l];for(;i<t.length;){if(0===d){n.set(0,0);continue e}if(n.has(d))continue e;const o=t[i],a=r+o.textContent.length;if(d<a){let t;t=d===r?clientRectForRange(o,0,1).left:clientRectForRange(o,0,d-r).right,-1===s&&(s=e.getBoundingClientRect().left),n.set(d,Math.round(t-s));continue e}i++,r=a}if(null==a){const e=t[t.length-1];a=clientRectForRange(e,0,e.textContent.length).right}-1===s&&(s=e.getBoundingClientRect().left),n.set(d,Math.round(a-s))}}rowForPixelPosition(e){return Math.max(0,this.lineTopIndex.rowForPixelPosition(e))}heightForBlockDecorationsBeforeRow(e){return this.pixelPositionAfterBlocksForRow(e)-this.pixelPositionBeforeBlocksForRow(e)}heightForBlockDecorationsAfterRow(e){const t=this.pixelPositionAfterBlocksForRow(e)+this.getLineHeight();return this.pixelPositionBeforeBlocksForRow(e+1)-t}pixelPositionBeforeBlocksForRow(e){return this.lineTopIndex.pixelPositionBeforeBlocksForRow(e)}pixelPositionAfterBlocksForRow(e){return this.lineTopIndex.pixelPositionAfterBlocksForRow(e)}pixelLeftForRowAndColumn(e,t){if(0===t)return 0;const o=this.renderedScreenLineForRow(e);if(o){const e=this.horizontalPixelPositionsByScreenLineId.get(o.id);if(e)return e.get(t)}}screenPositionForPixelPosition({top:e,left:t}){const{model:o}=this.props,n=Math.min(this.rowForPixelPosition(e),o.getApproximateScreenLineCount()-1);let s=this.renderedScreenLineForRow(n);s||(this.requestLineToMeasure(n,o.screenLineForScreenRow(n)),this.updateSyncBeforeMeasuringContent(),this.measureContentDuringUpdateSync(),s=this.renderedScreenLineForRow(n));const r=this.refs.lineTiles.getBoundingClientRect().left+Math.max(0,t),{textNodes:i}=this.lineComponentsByScreenLineId.get(s.id);let l;{let e=0,t=i.length-1;for(;e<=t;){const o=e+(t-e>>1),n=i[o],s=clientRectForRange(n,0,n.length);if(r<s.left)t=o-1,l=Math.max(0,o-1);else{if(!(r>s.right)){l=o;break}e=o+1,l=Math.min(i.length-1,o+1)}}}const d=i[l];let u=0;{let e=0,t=d.length-1;for(;e<=t;){const o=e+(t-e>>1),n=c(d.textContent,o)?o+2:o+1,s=clientRectForRange(d,o,n);if(r<s.left)t=o-1,u=Math.max(0,o-1);else{if(!(r>s.right)){u=r<=(s.left+s.right)/2?o:n;break}e=n,u=Math.min(d.textContent.length,n)}}}let m=0;for(let e=0;e<l;e++)m+=i[e].length;return a(n,m+u)}didResetDisplayLayer(){this.spliceLineTopIndex(0,Infinity,Infinity),this.scheduleUpdate()}didChangeDisplayLayer(e){for(let t=0;t<e.length;t++){const{oldRange:o,newRange:n}=e[t];this.spliceLineTopIndex(n.start.row,o.end.row-o.start.row,n.end.row-n.start.row)}this.scheduleUpdate()}didChangeSelectionRange(){const{model:e}=this.props;"linux"===this.getPlatform()&&(this.selectionClipboardImmediateId&&clearImmediate(this.selectionClipboardImmediateId),this.selectionClipboardImmediateId=setImmediate(()=>{if(this.selectionClipboardImmediateId=null,e.isDestroyed())return;const t=e.getSelectedText();t&&get_electron().ipcRenderer.send("write-text-to-selection-clipboard",t)}))}observeBlockDecorations(){const{model:e}=this.props,t=e.getDecorations({type:"block"});for(let e=0;e<t.length;e++)this.addBlockDecoration(t[e])}addBlockDecoration(e,t=!0){const o=e.getMarker(),{item:n,position:s}=e.getProperties(),r=u.viewForItem(n);if(o.isValid()){const t=o.getHeadScreenPosition().row;this.lineTopIndex.insertBlock(e,t,0,"after"===s),this.blockDecorationsToMeasure.add(e),this.blockDecorationsByElement.set(r,e),this.blockDecorationResizeObserver.observe(r),this.scheduleUpdate()}if(t){let t=o.isValid();const n=o.bufferMarker.onDidChange(({textChanged:n})=>{const s=o.isValid();t&&!s?(t=!1,this.blockDecorationsToMeasure.delete(e),this.heightsByBlockDecoration.delete(e),this.blockDecorationsByElement.delete(r),this.blockDecorationResizeObserver.unobserve(r),this.lineTopIndex.removeBlock(e),this.scheduleUpdate()):!t&&s?(t=!0,this.addBlockDecoration(e,!1)):s&&!n&&(this.lineTopIndex.moveBlock(e,o.getHeadScreenPosition().row),this.scheduleUpdate())}),s=e.onDidDestroy(()=>{n.dispose(),s.dispose(),t&&(t=!1,this.blockDecorationsToMeasure.delete(e),this.heightsByBlockDecoration.delete(e),this.blockDecorationsByElement.delete(r),this.blockDecorationResizeObserver.unobserve(r),this.lineTopIndex.removeBlock(e),this.scheduleUpdate())})}}didResizeBlockDecorations(e){if(this.visible)for(let t=0;t<e.length;t++){const{target:o,contentRect:n}=e[t],s=this.blockDecorationsByElement.get(o),r=this.heightsByBlockDecoration.get(s);this.element.contains(o)&&n.height!==r&&this.invalidateBlockDecorationDimensions(s)}}invalidateBlockDecorationDimensions(e){this.blockDecorationsToMeasure.add(e),this.scheduleUpdate()}spliceLineTopIndex(e,t,o){this.lineTopIndex.splice(e,t,o).forEach(e=>{const t=e.getMarker().getHeadScreenPosition();this.lineTopIndex.moveBlock(e,t.row)})}isVisible(){return this.element.offsetWidth>0||this.element.offsetHeight>0}getWindowInnerHeight(){return get_window().innerHeight}getWindowInnerWidth(){return get_window().innerWidth}getLineHeight(){return this.measurements.lineHeight}getBaseCharacterWidth(){return this.measurements.baseCharacterWidth}getLongestLineWidth(){return this.measurements.longestLineWidth}getClientContainerHeight(){return this.measurements.clientContainerHeight}getClientContainerWidth(){return this.measurements.clientContainerWidth}getScrollContainerWidth(){return this.props.model.getAutoWidth()?this.getScrollWidth():this.getClientContainerWidth()-this.getGutterContainerWidth()}getScrollContainerHeight(){return this.props.model.getAutoHeight()?this.getScrollHeight()+this.getHorizontalScrollbarHeight():this.getClientContainerHeight()}getScrollContainerClientWidth(){return this.getScrollContainerWidth()-this.getVerticalScrollbarWidth()}getScrollContainerClientHeight(){return this.getScrollContainerHeight()-this.getHorizontalScrollbarHeight()}canScrollVertically(){const{model:e}=this.props;return!e.isMini()&&(!e.getAutoHeight()&&this.getContentHeight()>this.getScrollContainerClientHeight())}canScrollHorizontally(){const{model:e}=this.props;return!e.isMini()&&(!e.getAutoWidth()&&(!e.isSoftWrapped()&&this.getContentWidth()>this.getScrollContainerClientWidth()))}getScrollHeight(){return this.props.model.getScrollPastEnd()?this.getContentHeight()+Math.max(3*this.getLineHeight(),this.getScrollContainerClientHeight()-3*this.getLineHeight()):this.props.model.getAutoHeight()?this.getContentHeight():Math.max(this.getContentHeight(),this.getScrollContainerClientHeight())}getScrollWidth(){const{model:e}=this.props;return e.isSoftWrapped()?this.getScrollContainerClientWidth():e.getAutoWidth()?this.getContentWidth():Math.max(this.getContentWidth(),this.getScrollContainerClientWidth())}getContentHeight(){return this.pixelPositionAfterBlocksForRow(this.props.model.getApproximateScreenLineCount())}getContentWidth(){return Math.ceil(this.getLongestLineWidth()+this.getBaseCharacterWidth())}getScrollContainerClientWidthInBaseCharacters(){return Math.floor(this.getScrollContainerClientWidth()/this.getBaseCharacterWidth())}getGutterContainerWidth(){return this.measurements.gutterContainerWidth}getLineNumberGutterWidth(){return this.measurements.lineNumberGutterWidth}getVerticalScrollbarWidth(){return this.measurements.verticalScrollbarWidth}getHorizontalScrollbarHeight(){return this.measurements.horizontalScrollbarHeight}getRowsPerTile(){return this.props.rowsPerTile||6}tileStartRowForRow(e){return e-e%this.getRowsPerTile()}getRenderedStartRow(){return null==this.derivedDimensionsCache.renderedStartRow&&(this.derivedDimensionsCache.renderedStartRow=this.tileStartRowForRow(this.getFirstVisibleRow())),this.derivedDimensionsCache.renderedStartRow}getRenderedEndRow(){return null==this.derivedDimensionsCache.renderedEndRow&&(this.derivedDimensionsCache.renderedEndRow=Math.min(this.props.model.getApproximateScreenLineCount(),this.getRenderedStartRow()+this.getVisibleTileCount()*this.getRowsPerTile())),this.derivedDimensionsCache.renderedEndRow}getRenderedRowCount(){return null==this.derivedDimensionsCache.renderedRowCount&&(this.derivedDimensionsCache.renderedRowCount=Math.max(0,this.getRenderedEndRow()-this.getRenderedStartRow())),this.derivedDimensionsCache.renderedRowCount}getRenderedTileCount(){return null==this.derivedDimensionsCache.renderedTileCount&&(this.derivedDimensionsCache.renderedTileCount=Math.ceil(this.getRenderedRowCount()/this.getRowsPerTile())),this.derivedDimensionsCache.renderedTileCount}getFirstVisibleRow(){return null==this.derivedDimensionsCache.firstVisibleRow&&(this.derivedDimensionsCache.firstVisibleRow=this.rowForPixelPosition(this.getScrollTop())),this.derivedDimensionsCache.firstVisibleRow}getLastVisibleRow(){return null==this.derivedDimensionsCache.lastVisibleRow&&(this.derivedDimensionsCache.lastVisibleRow=Math.min(this.props.model.getApproximateScreenLineCount()-1,this.rowForPixelPosition(this.getScrollBottom()))),this.derivedDimensionsCache.lastVisibleRow}getVisibleTileCount(){if(null==this.derivedDimensionsCache.visibleTileCount){const e=this.getScrollContainerHeight()/this.getLineHeight()/this.getRowsPerTile();this.derivedDimensionsCache.visibleTileCount=Math.ceil(e)+1}return this.derivedDimensionsCache.visibleTileCount}getFirstVisibleColumn(){return Math.floor(this.getScrollLeft()/this.getBaseCharacterWidth())}getScrollTop(){return this.scrollTop=Math.min(this.getMaxScrollTop(),this.scrollTop),this.scrollTop}setScrollTop(e){return!Number.isNaN(e)&&null!=e&&((e=roundToPhysicalPixelBoundary(Math.max(0,Math.min(this.getMaxScrollTop(),e))))!==this.scrollTop&&(this.derivedDimensionsCache={},this.scrollTopPending=!0,this.scrollTop=e,this.element.emitter.emit("did-change-scroll-top",e),!0))}getMaxScrollTop(){return Math.round(Math.max(0,this.getScrollHeight()-this.getScrollContainerClientHeight()))}getScrollBottom(){return this.getScrollTop()+this.getScrollContainerClientHeight()}setScrollBottom(e){return this.setScrollTop(e-this.getScrollContainerClientHeight())}getScrollLeft(){return this.scrollLeft}setScrollLeft(e){return!Number.isNaN(e)&&null!=e&&((e=roundToPhysicalPixelBoundary(Math.max(0,Math.min(this.getMaxScrollLeft(),e))))!==this.scrollLeft&&(this.scrollLeftPending=!0,this.scrollLeft=e,this.element.emitter.emit("did-change-scroll-left",e),!0))}getMaxScrollLeft(){return Math.round(Math.max(0,this.getScrollWidth()-this.getScrollContainerClientWidth()))}getScrollRight(){return this.getScrollLeft()+this.getScrollContainerClientWidth()}setScrollRight(e){return this.setScrollLeft(e-this.getScrollContainerClientWidth())}setScrollTopRow(e,t=!0){if(this.hasInitialMeasurements){const o=this.setScrollTop(this.pixelPositionBeforeBlocksForRow(e));return o&&t&&this.scheduleUpdate(),o}return this.pendingScrollTopRow=e,!1}getScrollTopRow(){return this.hasInitialMeasurements?this.rowForPixelPosition(this.getScrollTop()):this.pendingScrollTopRow||0}setScrollLeftColumn(e,t=!0){if(this.hasInitialMeasurements&&null!=this.getLongestLineWidth()){const o=this.setScrollLeft(e*this.getBaseCharacterWidth());return o&&t&&this.scheduleUpdate(),o}return this.pendingScrollLeftColumn=e,!1}getScrollLeftColumn(){return this.hasInitialMeasurements&&null!=this.getLongestLineWidth()?Math.round(this.getScrollLeft()/this.getBaseCharacterWidth()):this.pendingScrollLeftColumn||0}populateVisibleRowRange(e){const{model:t}=this.props,o=t.getApproximateScreenLineCount(),n=e+this.getVisibleTileCount()*this.getRowsPerTile();this.props.model.displayLayer.populateSpatialIndexIfNeeded(Infinity,n),t.getApproximateScreenLineCount()!==o&&(this.derivedDimensionsCache={})}populateVisibleTiles(){const e=this.getRenderedStartRow(),t=this.getRenderedEndRow(),o=[];for(let n=0;n<this.renderedTileStartRows.length;n++){const s=this.renderedTileStartRows[n];if(s<e||s>=t){const e=this.idsByTileStartRow.get(s);o.push(e),this.idsByTileStartRow.delete(s)}}const n=this.getRowsPerTile();this.renderedTileStartRows.length=this.getRenderedTileCount();for(let s=e,r=0;s<t;s+=n,r++)this.renderedTileStartRows[r]=s,this.idsByTileStartRow.has(s)||(o.length>0?this.idsByTileStartRow.set(s,o.shift()):this.idsByTileStartRow.set(s,this.nextTileId++));this.renderedTileStartRows.sort((e,t)=>this.idsByTileStartRow.get(e)-this.idsByTileStartRow.get(t))}getNextUpdatePromise(){return this.nextUpdatePromise||(this.nextUpdatePromise=new Promise(e=>{this.resolveNextUpdatePromise=(()=>{this.nextUpdatePromise=null,this.resolveNextUpdatePromise=null,e()})})),this.nextUpdatePromise}setInputEnabled(e){this.props.model.update({keyboardInputEnabled:e})}isInputEnabled(){return!this.props.model.isReadOnly()&&this.props.model.isKeyboardInputEnabled()}getHiddenInput(){return this.refs.cursorsAndInput.refs.hiddenInput}getPlatform(){return this.props.platform||get_process().platform}getChromeVersion(){return this.props.chromeVersion||parseInt(get_process().versions.chrome)}};class DummyScrollbarComponent{constructor(e){this.props=e,i.initialize(this)}update(e){const t=this.props;this.props=e,i.updateSync(this),(e.scrollTop!==t.scrollTop||e.scrollLeft!==t.scrollLeft)&&this.flushScrollPosition()}flushScrollPosition(){"horizontal"===this.props.orientation?this.element.scrollLeft=this.props.scrollLeft:this.element.scrollTop=this.props.scrollTop}render(){const{orientation:e,scrollWidth:t,scrollHeight:o,verticalScrollbarWidth:n,horizontalScrollbarHeight:s,canScroll:r,forceScrollbarVisible:i,didScroll:a}=this.props,l={position:"absolute",contain:"content",zIndex:1,willChange:"transform"};r||(l.visibility="hidden");const d={};if("horizontal"===e){let e=n||0;l.bottom=0,l.left=0,l.right=e+"px",l.height="15px",l.overflowY="hidden",l.overflowX=i?"scroll":"auto",l.cursor="default",d.height="15px",d.width=(t||0)+"px"}else{let e=s||0;l.right=0,l.top=0,l.bottom=e+"px",l.width="15px",l.overflowX="hidden",l.overflowY=i?"scroll":"auto",l.cursor="default",d.width="15px",d.height=(o||0)+"px"}return h.div({className:`${e}-scrollbar`,style:l,on:{scroll:a,mousedown:this.didMouseDown}},h.div({style:d}))}didMouseDown(e){let{bottom:t,right:o}=this.element.getBoundingClientRect();("horizontal"===this.props.orientation?e.clientY>=t-this.getRealScrollbarHeight():e.clientX>=o-this.getRealScrollbarWidth())||this.props.didMouseDown(e)}getRealScrollbarWidth(){return this.element.offsetWidth-this.element.clientWidth}getRealScrollbarHeight(){return this.element.offsetHeight-this.element.clientHeight}}class GutterContainerComponent{constructor(e){this.props=e,i.initialize(this)}update(e){this.shouldUpdate(e)&&(this.props=e,i.updateSync(this))}shouldUpdate(e){return!e.measuredContent||e.lineNumberGutterWidth!==this.props.lineNumberGutterWidth}render(){const{hasInitialMeasurements:e,scrollTop:t,scrollHeight:o,guttersToRender:n,decorationsToRender:s}=this.props,r={willChange:"transform",display:"flex"};return e&&(r.transform=`translateY(${-roundToPhysicalPixelBoundary(t)}px)`),h.div({ref:"gutterContainer",key:"gutterContainer",className:"gutter-container",style:{position:"relative",zIndex:1,backgroundColor:"inherit"}},h.div({style:r},n.map(e=>"line-number"===e.type?this.renderLineNumberGutter(e):h(CustomGutterComponent,{key:e,element:e.getElement(),name:e.name,visible:e.isVisible(),height:o,decorations:s.customGutter.get(e.name)}))))}renderLineNumberGutter(e){const{rootComponent:t,showLineNumbers:o,hasInitialMeasurements:n,lineNumbersToRender:s,renderedStartRow:r,renderedEndRow:i,rowsPerTile:a,decorationsToRender:l,didMeasureVisibleBlockDecoration:d,scrollHeight:u,lineNumberGutterWidth:c,lineHeight:m}=this.props;if(!e.isVisible())return null;const p="line-number"===e.name,f=p?"lineNumberGutter":void 0,g=p?c:void 0;if(n){const{maxDigits:n,keys:c,bufferRows:p,screenRows:b,softWrappedFlags:_,foldableFlags:y}=s;return h(LineNumberGutterComponent,{ref:f,element:e.getElement(),name:e.name,className:e.className,labelFn:e.labelFn,onMouseDown:e.onMouseDown,onMouseMove:e.onMouseMove,rootComponent:t,startRow:r,endRow:i,rowsPerTile:a,maxDigits:n,keys:c,bufferRows:p,screenRows:b,softWrappedFlags:_,foldableFlags:y,decorations:l.lineNumbers.get(e.name)||[],blockDecorations:l.blocks,didMeasureVisibleBlockDecoration:d,height:u,width:g,lineHeight:m,showLineNumbers:o})}return h(LineNumberGutterComponent,{ref:f,element:e.getElement(),name:e.name,className:e.className,onMouseDown:e.onMouseDown,onMouseMove:e.onMouseMove,maxDigits:s.maxDigits,showLineNumbers:o})}}class LineNumberGutterComponent{constructor(e){this.props=e,this.element=this.props.element,this.virtualNode=h.div(null),this.virtualNode.domNode=this.element,this.nodePool=new NodePool,i.updateSync(this)}update(e){this.shouldUpdate(e)&&(this.props=e,i.updateSync(this))}render(){const{rootComponent:e,showLineNumbers:t,height:o,width:n,startRow:s,endRow:r,rowsPerTile:i,maxDigits:a,keys:l,bufferRows:d,screenRows:u,softWrappedFlags:c,foldableFlags:m,decorations:p,className:f}=this.props;let b=null;if(d){b=new Array(e.renderedTileStartRows.length);for(let o=0;o<e.renderedTileStartRows.length;o++){const f=e.renderedTileStartRows[o],_=Math.min(r,f+i),y=new Array(_-f);for(let o=f;o<_;o++){const r=o-f,i=o-s,b=l[i],_=c[i],v=m[i],j=d[i],w=u[i];let k="line-number";v&&(k+=" foldable");const x=p[o-s];x&&(k=k+" "+x);let S=null;t&&(null==this.props.labelFn?(S=_?"•":j+1,S=g.repeat(a-S.length)+S):S=this.props.labelFn({bufferRow:j,screenRow:w,foldable:v,softWrapped:_,maxDigits:a}));let C=e.heightForBlockDecorationsBeforeRow(o);r>0&&(C+=e.heightForBlockDecorationsAfterRow(o-1)),y[o-f]=h(LineNumberComponent,{key:b,className:k,width:n,bufferRow:j,screenRow:w,number:S,marginTop:C,nodePool:this.nodePool})}const v=e.pixelPositionBeforeBlocksForRow(f),j=e.pixelPositionBeforeBlocksForRow(_)-v,w=null!=n&&n>0?n+"px":"";b[o]=h.div({key:e.idsByTileStartRow.get(f),style:{contain:"layout style",position:"absolute",top:0,height:j+"px",width:w,transform:`translateY(${v}px)`}},...y)}}let _="gutter line-numbers";return f&&(_+=" "+f),h.div({className:_,attributes:{"gutter-name":this.props.name},style:{position:"relative",height:ceilToPhysicalPixelBoundary(o)+"px"},on:{mousedown:this.didMouseDown,mousemove:this.didMouseMove}},h.div({key:"placeholder",className:"line-number dummy",style:{visibility:"hidden"}},t?"0".repeat(a):null,h.div({className:"icon-right"})),b)}shouldUpdate(e){const t=this.props;if(t.showLineNumbers!==e.showLineNumbers)return!0;if(t.height!==e.height)return!0;if(t.width!==e.width)return!0;if(t.lineHeight!==e.lineHeight)return!0;if(t.startRow!==e.startRow)return!0;if(t.endRow!==e.endRow)return!0;if(t.rowsPerTile!==e.rowsPerTile)return!0;if(t.maxDigits!==e.maxDigits)return!0;if(t.labelFn!==e.labelFn)return!0;if(t.className!==e.className)return!0;if(e.didMeasureVisibleBlockDecoration)return!0;if(!arraysEqual(t.keys,e.keys))return!0;if(!arraysEqual(t.bufferRows,e.bufferRows))return!0;if(!arraysEqual(t.foldableFlags,e.foldableFlags))return!0;if(!arraysEqual(t.decorations,e.decorations))return!0;let o=t.startRow,n=e.startRow;for(;o<t.endRow||n<e.endRow;){let s=t.blockDecorations.get(o),r=e.blockDecorations.get(n);if(s&&r){if(s.size!==r.size)return!0;let e=!1;if(s.forEach((t,o)=>{if(!e){const n=r.get(o);e=null==n||!arraysEqual(t,n)}}),e)return!0;if(r.forEach((t,o)=>{if(!e){const t=s.get(o);e=null==t}}),e)return!0}else{if(s)return!0;if(r)return!0}o+=t.rowsPerTile,n+=e.rowsPerTile}return!1}didMouseDown(e){if(null==this.props.onMouseDown)this.props.rootComponent.didMouseDownOnLineNumberGutter(e);else{const{bufferRow:t,screenRow:o}=e.target.dataset;this.props.onMouseDown({bufferRow:parseInt(t,10),screenRow:parseInt(o,10),domEvent:e})}}didMouseMove(e){if(null!=this.props.onMouseMove){const{bufferRow:t,screenRow:o}=e.target.dataset;this.props.onMouseMove({bufferRow:parseInt(t,10),screenRow:parseInt(o,10),domEvent:e})}}}class LineNumberComponent{constructor(e){const{className:t,width:o,marginTop:n,bufferRow:s,screenRow:r,number:i,nodePool:a}=e;this.props=e;const l={};null!=o&&o>0&&(l.width=o+"px"),null!=n&&n>0&&(l.marginTop=n+"px"),this.element=a.getElement("DIV",t,l),this.element.dataset.bufferRow=s,this.element.dataset.screenRow=r,i&&this.element.appendChild(a.getTextNode(i)),this.element.appendChild(a.getElement("DIV","icon-right",null))}destroy(){this.element.remove(),this.props.nodePool.release(this.element)}update(e){const{nodePool:t,className:o,width:n,marginTop:s,bufferRow:r,screenRow:i,number:a}=e;if(this.props.bufferRow!==r&&(this.element.dataset.bufferRow=r),this.props.screenRow!==i&&(this.element.dataset.screenRow=i),this.props.className!==o&&(this.element.className=o),this.props.width!==n&&(this.element.style.width=null!=n&&n>0?n+"px":""),this.props.marginTop!==s&&(this.element.style.marginTop=null!=s&&s>0?s+"px":""),this.props.number!==a){if(null!=this.props.number){const e=this.element.firstChild;e.remove(),t.release(e)}null!=a&&this.element.insertBefore(t.getTextNode(a),this.element.firstChild)}this.props=e}}class CustomGutterComponent{constructor(e){this.props=e,this.element=this.props.element,this.virtualNode=h.div(null),this.virtualNode.domNode=this.element,i.updateSync(this)}update(e){this.props=e,i.updateSync(this)}destroy(){i.destroy(this)}render(){let e="gutter";return this.props.className&&(e+=" "+this.props.className),h.div({className:e,attributes:{"gutter-name":this.props.name},style:{display:this.props.visible?"":"none"}},h.div({className:"custom-decorations",style:{height:this.props.height+"px"}},this.renderDecorations()))}renderDecorations(){return this.props.decorations?this.props.decorations.map(({className:e,element:t,top:o,height:n})=>h(CustomGutterDecorationComponent,{className:e,element:t,top:o,height:n})):null}}class CustomGutterDecorationComponent{constructor(e){this.props=e,this.element=get_document().createElement("div");const{top:t,height:o,className:n,element:s}=this.props;this.element.style.position="absolute",this.element.style.top=t+"px",this.element.style.height=o+"px",null!=n&&(this.element.className=n),null!=s&&(this.element.appendChild(s),s.style.height=o+"px")}update(e){const t=this.props;this.props=e,e.top!==t.top&&(this.element.style.top=e.top+"px"),e.height!==t.height&&(this.element.style.height=e.height+"px",e.element&&(e.element.style.height=e.height+"px")),e.className!==t.className&&(this.element.className=e.className||""),e.element!==t.element&&(this.element.firstChild&&this.element.firstChild.remove(),null!=e.element&&(this.element.appendChild(e.element),e.element.style.height=e.height+"px"))}}class CursorsAndInputComponent{constructor(e){this.props=e,i.initialize(this)}update(e){e.measuredContent&&(this.props=e,i.updateSync(this))}updateCursorBlinkSync(e){this.props.cursorsBlinkedOff=e;const t=this.getCursorsClassName();this.refs.cursors.className=t,this.virtualNode.props.className=t}render(){const{lineHeight:e,decorationsToRender:t,scrollHeight:o,scrollWidth:n}=this.props,s=this.getCursorsClassName(),r=e+"px",i=[this.renderHiddenInput()];for(let e=0;e<t.cursors.length;e++){const{pixelLeft:o,pixelTop:s,pixelWidth:a,className:l,style:d}=t.cursors[e];let u="cursor";l&&(u+=" "+l);const c={height:r,width:Math.min(a,n-o)+"px",transform:`translate(${o}px, ${s}px)`};d&&Object.assign(c,d),i.push(h.div({className:u,style:c}))}return h.div({key:"cursors",ref:"cursors",className:s,style:{position:"absolute",contain:"strict",zIndex:1,width:n+"px",height:o+"px",pointerEvents:"none",userSelect:"none"}},i)}getCursorsClassName(){return this.props.cursorsBlinkedOff?"cursors blink-off":"cursors"}renderHiddenInput(){const{lineHeight:e,hiddenInputPosition:t,didBlurHiddenInput:o,didFocusHiddenInput:n,didPaste:s,didTextInput:r,didKeydown:i,didKeyup:a,didKeypress:l,didCompositionStart:d,didCompositionUpdate:u,didCompositionEnd:c,tabIndex:m}=this.props;let p,f;return t?(p=t.pixelTop,f=t.pixelLeft):(p=0,f=0),h.input({ref:"hiddenInput",key:"hiddenInput",className:"hidden-input",on:{blur:o,focus:n,paste:s,textInput:r,keydown:i,keyup:a,keypress:l,compositionstart:d,compositionupdate:u,compositionend:c},tabIndex:m,style:{position:"absolute",width:"1px",height:e+"px",top:p+"px",left:f+"px",opacity:0,padding:0,border:0}})}}class LinesTileComponent{constructor(e){this.props=e,i.initialize(this),this.createLines(),this.updateBlockDecorations({},e)}update(e){if(this.shouldUpdate(e)){const t=this.props;this.props=e,i.updateSync(this),e.measuredContent||(this.updateLines(t,e),this.updateBlockDecorations(t,e))}}destroy(){for(let e=0;e<this.lineComponents.length;e++)this.lineComponents[e].destroy();return this.lineComponents.length=0,i.destroy(this)}render(){const{height:e,width:t,top:o}=this.props;return h.div({style:{contain:"layout style",position:"absolute",height:e+"px",width:t+"px",transform:`translateY(${o}px)`}})}createLines(){const{tileStartRow:e,screenLines:t,lineDecorations:o,textDecorations:n,nodePool:s,displayLayer:r,lineComponentsByScreenLineId:i}=this.props;this.lineComponents=[];for(let a=0,l=t.length;a<l;a++){const l=new LineComponent({screenLine:t[a],screenRow:e+a,lineDecoration:o[a],textDecorations:n[a],displayLayer:r,nodePool:s,lineComponentsByScreenLineId:i});this.element.appendChild(l.element),this.lineComponents.push(l)}}updateLines(e,t){for(var{screenLines:o,tileStartRow:n,lineDecorations:s,textDecorations:r,nodePool:i,displayLayer:a,lineComponentsByScreenLineId:l}=t,d=e.screenLines,u=o,c=d.length,m=u.length,p=0,h=0,f=0;p<c||h<m;){var g=d[p],b=u[h];if(p>=c){var _=new LineComponent({screenLine:b,screenRow:n+h,lineDecoration:s[h],textDecorations:r[h],displayLayer:a,nodePool:i,lineComponentsByScreenLineId:l});this.element.appendChild(_.element),this.lineComponents.push(_),h++,f++}else if(h>=m)this.lineComponents[f].destroy(),this.lineComponents.splice(f,1),p++;else if(g===b){this.lineComponents[f].update({screenRow:n+h,lineDecoration:s[h],textDecorations:r[h]}),p++,h++,f++}else{var y=u.indexOf(g),v=d.indexOf(b);if(h<y&&y<m){for(var j=[];h<y;){_=new LineComponent({screenLine:u[h],screenRow:n+h,lineDecoration:s[h],textDecorations:r[h],displayLayer:a,nodePool:i,lineComponentsByScreenLineId:l});this.element.insertBefore(_.element,this.getFirstElementForScreenLine(e,g)),j.push(_),h++}this.lineComponents.splice(f,0,...j),f+=j.length}else if(p<v&&v<c)for(;p<v;)this.lineComponents[f].destroy(),this.lineComponents.splice(f,1),p++;else{var w=this.lineComponents[f];_=new LineComponent({screenLine:u[h],screenRow:n+h,lineDecoration:s[h],textDecorations:r[h],displayLayer:a,nodePool:i,lineComponentsByScreenLineId:l});this.element.insertBefore(_.element,w.element),w.destroy(),this.lineComponents[f]=_,p++,h++,f++}}}}getFirstElementForScreenLine(e,t){var o=e.blockDecorations?e.blockDecorations.get(t.id):null;if(o){var n=[];for(let e=0;e<o.length;e++){var s=o[e];"after"!==s.position&&n.push(u.viewForItem(s.item))}for(let e=0;e<n.length;e++){var r=n[e];if(!n.includes(r.previousSibling))return r}}return e.lineComponentsByScreenLineId.get(t.id).element}updateBlockDecorations(e,t){var{blockDecorations:o,lineComponentsByScreenLineId:n}=t;e.blockDecorations&&e.blockDecorations.forEach((e,o)=>{for(var n=t.blockDecorations?t.blockDecorations.get(o):null,s=0;s<e.length;s++){var r=e[s];if(!n||!n.includes(r)){var i=u.viewForItem(r.item);i.parentElement===this.element&&i.remove()}}}),o&&o.forEach((t,o)=>{const s=e.blockDecorations?e.blockDecorations.get(o):null,r=n.get(o).element;let i=r;for(let e=0;e<t.length;e++){const o=t[e],n=u.viewForItem(o.item);s&&s.includes(o)?"after"===o.position&&(i=n):"after"===o.position?(this.element.insertBefore(n,i.nextSibling),i=n):this.element.insertBefore(n,r)}})}shouldUpdate(e){const t=this.props;if(t.top!==e.top)return!0;if(t.height!==e.height)return!0;if(t.width!==e.width)return!0;if(t.lineHeight!==e.lineHeight)return!0;if(t.tileStartRow!==e.tileStartRow)return!0;if(t.tileEndRow!==e.tileEndRow)return!0;if(!arraysEqual(t.screenLines,e.screenLines))return!0;if(!arraysEqual(t.lineDecorations,e.lineDecorations))return!0;if(t.blockDecorations&&e.blockDecorations){if(t.blockDecorations.size!==e.blockDecorations.size)return!0;let o=!1;if(t.blockDecorations.forEach((t,n)=>{if(!o){const s=e.blockDecorations.get(n);o=null==s||!arraysEqual(t,s)}}),o)return!0;if(e.blockDecorations.forEach((e,n)=>{if(!o){const e=t.blockDecorations.get(n);o=null==e}}),o)return!0}else{if(t.blockDecorations)return!0;if(e.blockDecorations)return!0}if(t.textDecorations.length!==e.textDecorations.length)return!0;for(let o=0;o<t.textDecorations.length;o++)if(!textDecorationsEqual(t.textDecorations[o],e.textDecorations[o]))return!0;return!1}}class LineComponent{constructor(e){const{nodePool:t,screenRow:o,screenLine:n,lineComponentsByScreenLineId:s,offScreen:r}=e;this.props=e,this.element=t.getElement("DIV",this.buildClassName(),null),this.element.dataset.screenRow=o,this.textNodes=[],r&&(this.element.style.position="absolute",this.element.style.visibility="hidden",this.element.dataset.offScreen=!0),this.appendContents(),s.set(n.id,this)}update(e){this.props.lineDecoration!==e.lineDecoration&&(this.props.lineDecoration=e.lineDecoration,this.element.className=this.buildClassName()),this.props.screenRow!==e.screenRow&&(this.props.screenRow=e.screenRow,this.element.dataset.screenRow=e.screenRow),textDecorationsEqual(this.props.textDecorations,e.textDecorations)||(this.props.textDecorations=e.textDecorations,this.element.firstChild.remove(),this.appendContents())}destroy(){const{nodePool:e,lineComponentsByScreenLineId:t,screenLine:o}=this.props;t.get(o.id)===this&&t.delete(o.id),this.element.remove(),e.release(this.element)}appendContents(){const{displayLayer:e,nodePool:t,screenLine:o,textDecorations:n}=this.props;this.textNodes.length=0;const{lineText:s,tags:r}=o;let i=t.getElement("SPAN",null,null);this.element.appendChild(i);let a=0,l=0,d=null,u=null,c=n?n[a]:null;c&&0===c.column&&(l=c.column,d=c.className,u=c.style,c=n[++a]);for(let o=0;o<r.length;o++){const m=r[o];if(0!==m)if(e.isCloseTag(m))i=i.parentElement;else if(e.isOpenTag(m)){const o=t.getElement("SPAN",e.classNameForTag(m),null);i.appendChild(o),i=o}else{const e=l+m;for(;c&&c.column<=e;){const e=s.substring(l,c.column);this.appendTextNode(i,e,d,u),l=c.column,d=c.className,u=c.style,c=n[++a]}if(l<e){const t=s.substring(l,e);this.appendTextNode(i,t,d,u),l=e}}}if(0===l){const e=t.getTextNode(" ");this.element.appendChild(e),this.textNodes.push(e)}if(s.endsWith(e.foldCharacter)){const e=t.getTextNode(b);this.element.appendChild(e),this.textNodes.push(e)}}appendTextNode(e,t,o,n){const{nodePool:s}=this.props;if(o||n){const t=s.getElement("SPAN",o,n);e.appendChild(t),e=t}const r=s.getTextNode(t);e.appendChild(r),this.textNodes.push(r)}buildClassName(){const{lineDecoration:e}=this.props;let t="line";return null!=e&&(t=t+" "+e),t}}class HighlightsComponent{constructor(e){this.props={},this.element=get_document().createElement("div"),this.element.className="highlights",this.element.style.contain="strict",this.element.style.position="absolute",this.element.style.overflow="hidden",this.element.style.userSelect="none",this.highlightComponentsByKey=new Map,this.update(e)}destroy(){this.highlightComponentsByKey.forEach(e=>{e.destroy()}),this.highlightComponentsByKey.clear()}update(e){if(this.shouldUpdate(e)){this.props=e;const{height:t,width:o,lineHeight:n,highlightDecorations:s}=this.props;this.element.style.height=t+"px",this.element.style.width=o+"px";const r=new Set;if(s)for(let e=0;e<s.length;e++){const t=s[e],o=Object.assign({lineHeight:n},s[e]);let i=this.highlightComponentsByKey.get(t.key);i?i.update(o):(i=new HighlightComponent(o),this.element.appendChild(i.element),this.highlightComponentsByKey.set(t.key,i)),s[e].flashRequested=!1,r.add(t.key)}this.highlightComponentsByKey.forEach((e,t)=>{r.has(t)||(e.destroy(),this.highlightComponentsByKey.delete(t))})}}shouldUpdate(e){const t=this.props;if(!e.hasInitialMeasurements)return!1;if(t.width!==e.width)return!0;if(t.height!==e.height)return!0;if(t.lineHeight!==e.lineHeight)return!0;if(!t.highlightDecorations&&e.highlightDecorations)return!0;if(t.highlightDecorations&&!e.highlightDecorations)return!0;if(t.highlightDecorations&&e.highlightDecorations){if(t.highlightDecorations.length!==e.highlightDecorations.length)return!0;for(let o=0,n=t.highlightDecorations.length;o<n;o++){const n=t.highlightDecorations[o],s=e.highlightDecorations[o];if(n.className!==s.className)return!0;if(s.flashRequested)return!0;if(n.startPixelTop!==s.startPixelTop)return!0;if(n.startPixelLeft!==s.startPixelLeft)return!0;if(n.endPixelTop!==s.endPixelTop)return!0;if(n.endPixelLeft!==s.endPixelLeft)return!0;if(!n.screenRange.isEqual(s.screenRange))return!0}}}}class HighlightComponent{constructor(e){this.props=e,i.initialize(this),this.props.flashRequested&&this.performFlash()}destroy(){return this.timeoutsByClassName&&(this.timeoutsByClassName.forEach(e=>{get_window().clearTimeout(e)}),this.timeoutsByClassName.clear()),i.destroy(this)}update(e){this.props=e,i.updateSync(this),e.flashRequested&&this.performFlash()}performFlash(){const{flashClass:e,flashDuration:t}=this.props;this.timeoutsByClassName||(this.timeoutsByClassName=new Map),this.timeoutsByClassName.has(e)?(get_window().clearTimeout(this.timeoutsByClassName.get(e)),this.timeoutsByClassName.delete(e),this.element.classList.remove(e),requestAnimationFrame(()=>this.performFlash())):(this.element.classList.add(e),this.timeoutsByClassName.set(e,get_window().setTimeout(()=>{this.element.classList.remove(e)},t)))}render(){const{className:e,screenRange:t,lineHeight:o,startPixelTop:n,startPixelLeft:s,endPixelTop:r,endPixelLeft:i}=this.props,a="region "+e;let l;return t.start.row===t.end.row?l=h.div({className:a,style:{position:"absolute",boxSizing:"border-box",top:n+"px",left:s+"px",width:i-s+"px",height:o+"px"}}):((l=[]).push(h.div({className:a,style:{position:"absolute",boxSizing:"border-box",top:n+"px",left:s+"px",right:0,height:o+"px"}})),t.end.row-t.start.row>1&&l.push(h.div({className:a,style:{position:"absolute",boxSizing:"border-box",top:n+o+"px",left:0,right:0,height:r-n-2*o+"px"}})),i>0&&l.push(h.div({className:a,style:{position:"absolute",boxSizing:"border-box",top:r-o+"px",left:0,width:i+"px",height:o+"px"}}))),h.div({className:"highlight "+e},l)}}class OverlayComponent{constructor(e){this.props=e,this.element=get_document().createElement("atom-overlay"),null!=this.props.className&&this.element.classList.add(this.props.className),this.element.appendChild(this.props.element),this.element.style.position="fixed",this.element.style.zIndex=4,this.element.style.top=(this.props.pixelTop||0)+"px",this.element.style.left=(this.props.pixelLeft||0)+"px",this.currentContentRect=null,this.resizeObserver=new ResizeObserver(e=>{const{contentRect:t}=e[0];!this.currentContentRect||this.currentContentRect.width===t.width&&this.currentContentRect.height===t.height||(this.resizeObserver.disconnect(),this.props.didResize(this),get_process().nextTick(()=>{this.resizeObserver.observe(this.props.element)})),this.currentContentRect=t}),this.didAttach(),this.props.overlayComponents.add(this)}destroy(){this.props.overlayComponents.delete(this),this.didDetach()}getNextUpdatePromise(){return this.nextUpdatePromise||(this.nextUpdatePromise=new Promise(e=>{this.resolveNextUpdatePromise=(()=>{this.nextUpdatePromise=null,this.resolveNextUpdatePromise=null,e()})})),this.nextUpdatePromise}update(e){const t=this.props;this.props=Object.assign({},t,e),null!=this.props.pixelTop&&(this.element.style.top=this.props.pixelTop+"px"),null!=this.props.pixelLeft&&(this.element.style.left=this.props.pixelLeft+"px"),e.className!==t.className&&(null!=t.className&&this.element.classList.remove(t.className),null!=e.className&&this.element.classList.add(e.className)),this.resolveNextUpdatePromise&&this.resolveNextUpdatePromise()}didAttach(){this.resizeObserver.observe(this.props.element)}didDetach(){this.resizeObserver.disconnect()}}let _;function clientRectForRange(e,t,o){return _||(_=get_document().createRange()),_.setStart(e,t),_.setEnd(e,o),_.getBoundingClientRect()}function textDecorationsEqual(e,t){if(!e&&t)return!1;if(e&&!t)return!1;if(e&&t){if(e.length!==t.length)return!1;for(let o=0;o<e.length;o++){if(e[o].column!==t[o].column)return!1;if(e[o].className!==t[o].className)return!1;if(!objectsEqual(e[o].style,t[o].style))return!1}}return!0}function arraysEqual(e,t){if(e.length!==t.length)return!1;for(let o=0,n=e.length;o<n;o++)if(e[o]!==t[o])return!1;return!0}function objectsEqual(e,t){if(!e&&t)return!1;if(e&&!t)return!1;if(e&&t){for(const o in e)if(e[o]!==t[o])return!1;for(const o in t)if(e[o]!==t[o])return!1}return!0}class NodePool{constructor(){this.elementsByType={},this.textNodes=[]}getElement(e,t,o){var n,s=this.elementsByType[e];if(s)for(;s.length>0;){var r=s[s.length-1];if(r&&r.length>0){n=r.pop(),0===r.length&&s.pop();break}s.pop()}if(n){n.className=t||"",n.attributeStyleMap.forEach((e,t)=>{o&&null!=o[t]||(n.style[t]="")}),o&&Object.assign(n.style,o);for(const e in n.dataset)delete n.dataset[e];for(;n.firstChild;)n.firstChild.remove();return n}var i=get_document().createElement(e);return t&&(i.className=t),o&&Object.assign(i.style,o),i}getTextNode(e){if(this.textNodes.length>0){var t=this.textNodes.pop();return t.textContent=e,t}return get_document().createTextNode(e)}release(e,t=0){var{nodeName:o}=e;if("#text"===o)this.textNodes.push(e);else{var n=this.elementsByType[o];n||(n=[],this.elementsByType[o]=n);var s=n[t];s||(s=[],n[t]=s),s.push(e);for(var r=0;r<e.childNodes.length;r++)this.release(e.childNodes[r],t+1)}}}function roundToPhysicalPixelBoundary(e){const t=1/get_window().devicePixelRatio;return Math.round(e/t)*t}function ceilToPhysicalPixelBoundary(e){const t=1/get_window().devicePixelRatio;return Math.ceil(e/t)*t}},"../src/file-system-blob-store.js":function(e,t,o,n,s,r){"use strict";const i=s("../node_modules/fs-plus/lib/fs-plus.js");let a;function get_path(){return a=a||s("path")}t.exports=class FileSystemBlobStore{static load(e){let t=new FileSystemBlobStore(e);return t.load(),t}constructor(e){this.blobFilename=get_path().join(e,"BLOB"),this.blobMapFilename=get_path().join(e,"MAP"),this.lockFilename=get_path().join(e,"LOCK"),this.reset()}reset(){this.inMemoryBlobs=new Map,this.storedBlob=Buffer.alloc(0),this.storedBlobMap={},this.usedKeys=new Set}load(){if(i.existsSync(this.blobMapFilename)&&i.existsSync(this.blobFilename))try{this.storedBlob=i.readFileSync(this.blobFilename),this.storedBlobMap=JSON.parse(i.readFileSync(this.blobMapFilename))}catch(e){this.reset()}}save(){let e=this.getDump(),t=Buffer.concat(e[0]),o=JSON.stringify(e[1]),n=!1;try{i.writeFileSync(this.lockFilename,"LOCK",{flag:"wx"}),n=!0,i.writeFileSync(this.blobFilename,t),i.writeFileSync(this.blobMapFilename,o)}catch(e){if("EEXIST"!==e.code)throw e}finally{n&&i.unlinkSync(this.lockFilename)}}has(e){return this.inMemoryBlobs.has(e)||this.storedBlobMap.hasOwnProperty(e)}get(e){if(this.has(e))return this.usedKeys.add(e),this.getFromMemory(e)||this.getFromStorage(e)}set(e,t){return this.usedKeys.add(e),this.inMemoryBlobs.set(e,t)}delete(e){this.inMemoryBlobs.delete(e),delete this.storedBlobMap[e]}getFromMemory(e){return this.inMemoryBlobs.get(e)}getFromStorage(e){if(this.storedBlobMap[e])return this.storedBlob.slice.apply(this.storedBlob,this.storedBlobMap[e])}getDump(){let e=[],t={},o=0;function dump(n,s){let r=s(n);e.push(r),t[n]=[o,o+r.length],o+=r.length}for(let e of this.inMemoryBlobs.keys())this.usedKeys.has(e)&&dump(e,this.getFromMemory.bind(this));for(let e of Object.keys(this.storedBlobMap))!t[e]&&this.usedKeys.has(e)&&dump(e,this.getFromStorage.bind(this));return[e,t]}}},"../src/native-compile-cache.js":function(e,t,o,n,s,r){let i,a,l,d;function get_Module(){return i=i||s("module")}function get_path(){return a=a||s("path")}function get_cachedVm(){return l=l||s("../node_modules/cached-run-in-this-context/lib/main.js")}function computeHash(e){return function get_crypto(){return d=d||s("crypto")}().createHash("sha1").update(e,"utf8").digest("hex")}t.exports=new class NativeCompileCache{constructor(){this.cacheStore=null,this.previousModuleCompile=null}setCacheStore(e){this.cacheStore=e}setV8Version(e){this.v8Version=e.toString()}install(){this.savePreviousModuleCompile(),this.overrideModuleCompile()}uninstall(){this.restorePreviousModuleCompile()}savePreviousModuleCompile(){this.previousModuleCompile=get_Module().prototype._compile}overrideModuleCompile(){let e=this;get_Module().prototype._compile=function(t,o){let n=this;function require(e){return n.require(e)}t=t.replace(/^#!.*/,""),require.resolve=function(e){return get_Module()._resolveFilename(e,n)},require.main=get_process().mainModule,require.extensions=get_Module()._extensions,require.cache=get_Module()._cache;let s=get_path().dirname(o),r=get_Module().wrap(t),i=computeHash(r+e.v8Version),a=null;if(e.cacheStore.has(i)){let t=e.cacheStore.get(i),n=get_cachedVm().runInThisContextCached(r,o,t);a=n.result,n.wasRejected&&e.cacheStore.delete(i)}else{let t;try{t=get_cachedVm().runInThisContext(r,o)}catch(e){throw get_console().error(`Error running script ${o}`),e}t.cacheBuffer&&e.cacheStore.set(i,t.cacheBuffer),a=t.result}let l=[n.exports,require,n,o,s,get_process(),get_global(),Buffer];return a.apply(n.exports,l)}}restorePreviousModuleCompile(){get_Module().prototype._compile=this.previousModuleCompile}}},"../src/compile-cache.js":function(e,t,o,n,s,r){"use strict";var i;function get_path(){return i=i||s("path")}var a=s("../node_modules/fs-plus/lib/fs-plus.js"),l=s("../node_modules/@atom/source-map-support/source-map-support.js"),d=s("../src/package-transpilation-registry.js"),u=null,c=new d,m={".js":c.wrapTranspiler(s("../src/babel.js")),".ts":c.wrapTranspiler(s("../src/typescript.js")),".tsx":c.wrapTranspiler(s("../src/typescript.js")),".coffee":c.wrapTranspiler(s("../src/coffee-script.js"))};e.addTranspilerConfigForPath=function(e,t,o,n){e=a.realpathSync(e),c.addTranspilerConfigForPath(e,t,o,n)},e.removeTranspilerConfigForPath=function(e){e=a.realpathSync(e),c.removeTranspilerConfigForPath(e)};var p={},h=null;function compileFileAtPath(e,t,o){var n=a.readFileSync(t,"utf8");if(e.shouldCompile(n,t)){var s=e.getCachePath(n,t),r=readCachedJavaScript(s);return null!=r?p[o].hits++:(p[o].misses++,function writeCachedJavaScript(e,t){var o=get_path().join(h,e);a.writeFileSync(o,t,"utf8")}(s,r=e.compile(n,t))),r}return n}function readCachedJavaScript(e){var t=get_path().join(h,e);if(a.isFileSync(t))try{return a.readFileSync(t,"utf8")}catch(e){}return null}e.setAtomHomeDirectory=function(e){var t=get_path().join(e,"compile-cache");"root"===get_process().env.USER&&get_process().env.SUDO_USER&&get_process().env.SUDO_USER!==get_process().env.USER&&(t=get_path().join(t,"root")),this.setCacheDirectory(t)},e.setCacheDirectory=function(e){h=e},e.getCacheDirectory=function(){return h},e.addPathToCache=function(e,t){this.setAtomHomeDirectory(t);var o=get_path().extname(e);if(".cson"===o)return u||(u=s("../node_modules/season/lib/cson.js")).setCacheDir(this.getCacheDirectory()),u.readFileSync(e);var n=m[o];return n?compileFileAtPath(n,e,o):void 0},e.getCacheStats=function(){return p},e.resetCacheStats=function(){Object.keys(m).forEach(function(e){p[e]={hits:0,misses:0}})};var f=/\/\/[#@]\s*sourceMappingURL=([^'"\n]+)\s*$/gm;e.install=function(e,t){const o={originalPositionFor({line:t,column:o}){const{relativePath:n,row:s}=snapshotResult.translateSnapshotRow(t);return{column:o,line:s,source:get_path().join(e,"static",n),name:null}}};l.install({handleUncaughtExceptions:!1,retrieveSourceMap:function(e){if("<embedded>"===e)return{map:o};if(!h||!a.isFileSync(e))return null;try{var t=a.readFileSync(e,"utf8")}catch(e){return get_console().warn("Error reading source file",e.stack),null}var n,s,r=m[get_path().extname(e)];r||(r=m[".js"]);try{var i=readCachedJavaScript(r.getCachePath(t,e))}catch(e){return get_console().warn("Error reading compiled file",e.stack),null}if(null==i)return null;for(f.lastIndex=0;n=f.exec(i);)s=n;if(null==s)return null;var l=s[1],d=l.slice(l.indexOf(",")+1);try{var u=JSON.parse(Buffer.from(d,"base64"))}catch(e){return get_console().warn("Error parsing source map",e.stack),null}return{map:u,url:null}}});var n=Error.prepareStackTrace,s=n;function prepareStackTraceWithRawStackAssignment(e,t){return e.rawStack?n(e,t):(e.rawStack=t,s(e,t))}Error.stackTraceLimit=30,Object.defineProperty(Error,"prepareStackTrace",{get:function(){return prepareStackTraceWithRawStackAssignment},set:function(e){s=e,get_process().nextTick(function(){s=n})}}),Error.prototype.getRawStack=function(){return this.stack,this.rawStack},Object.keys(m).forEach(function(e){var o=m[e];Object.defineProperty(t.extensions,e,{enumerable:!0,writable:!1,value:function(t,n){var s=compileFileAtPath(o,n,e);return t._compile(s,n)}})})},e.supportedExtensions=Object.keys(m),e.resetCacheStats()},"../src/module-cache.js":function(e,t,o,n,s,r){let i,a;function get_Module(){return i=i||s("module")}function get_path(){return a=a||s("path")}const l=s("../node_modules/semver/semver.js");class Range extends l.Range{constructor(){super(...arguments),this.matchedVersions=new Set,this.unmatchedVersions=new Set}test(e){if(this.matchedVersions.has(e))return!0;if(this.unmatchedVersions.has(e))return!1;const t=super.test(...arguments);return t?this.matchedVersions.add(e):this.unmatchedVersions.add(e),t}}let d=null;const u={builtins:{},debug:!1,dependencies:{},extensions:{},folders:{},ranges:{},registered:!1,resourcePath:null,resourcePathWithTrailingSlash:null};let c;c="win32"===get_process().platform?e=>e&&(":"===e[1]||"\\"===e[0]&&"\\"===e[1]):e=>e&&"/"===e[0];const m=e=>e.startsWith(u.resourcePathWithTrailingSlash);function satisfies(e,t){let o;return(o=u.ranges[t])||(o=new Range(t),u.ranges[t]=o),o.test(e)}e.create=function(e){const t=s("../node_modules/fs-plus/lib/fs-plus.js");e=t.realpathSync(e);const o=get_path().join(e,"package.json"),n=JSON.parse(t.readFileSync(o)),r={version:1,dependencies:[],extensions:{},folders:[]};!function loadDependencies(e,t,o,n){const r=s("../node_modules/fs-plus/lib/fs-plus.js");for(let a of r.listSync(get_path().join(e,"node_modules"))){if(".bin"===get_path().basename(a))continue;if(t===e&&o.packageDependencies&&o.packageDependencies.hasOwnProperty(get_path().basename(a)))continue;const l=get_path().join(a,"package.json");if(!r.isFileSync(l))continue;const d=JSON.parse(r.readFileSync(l));if(d&&d.version){var i;try{i=s.resolve(a)}catch(e){i=null}i&&n.dependencies.push({name:d.name,version:d.version,path:get_path().relative(t,i)}),loadDependencies(a,t,o,n)}}}(e,e,n,r),function loadFolderCompatibility(e,t,o,n){const r=s("../node_modules/fs-plus/lib/fs-plus.js"),i=get_path().join(e,"package.json");if(!r.isFileSync(i))return;const a=JSON.parse(r.readFileSync(i)).dependencies||{};for(let e in a)l.validRange(a[e])||delete a[e];const d=[".js",".coffee",".json",".node"];let u={};r.traverseTreeSync(e,function onFile(e){const o=get_path().extname(e);if(d.includes(o)){const o=get_path().relative(t,get_path().dirname(e));u[o]=!0}},e=>"node_modules"!==get_path().basename(e)),(u=Object.keys(u)).length>0&&Object.keys(a).length>0&&n.folders.push({paths:u,dependencies:a});for(let s of r.listSync(get_path().join(e,"node_modules")))".bin"!==get_path().basename(s)&&(t===e&&o.packageDependencies&&o.packageDependencies.hasOwnProperty(get_path().basename(s))||loadFolderCompatibility(s,t,o,n))}(e,e,n,r),function loadExtensions(e,t,o,n){const r=s("../node_modules/fs-plus/lib/fs-plus.js"),i=[".js",".coffee",".json",".node"],a=get_path().join(t,"node_modules");r.traverseTreeSync(t,function onFile(e){const o=(e=get_path().relative(t,e)).split(get_path().sep);if(o.includes("test"))return;if(o.includes("tests"))return;if(o.includes("spec"))return;if(o.includes("specs"))return;if(o.length>1&&!["exports","lib","node_modules","src","static","vendor"].includes(o[0]))return;const s=get_path().extname(e);i.includes(s)&&(null==n.extensions[s]&&(n.extensions[s]=[]),n.extensions[s].push(e))},function onDirectory(e){if("atom"===o.name&&get_path().dirname(e)===a){const t=get_path().basename(e);if(o.packageDependencies&&o.packageDependencies.hasOwnProperty(t))return!1}return!0})}(0,e,n,r),n._atomModuleCache=r,t.writeFileSync(o,JSON.stringify(n,null,2))},e.register=function({resourcePath:e,devMode:t}={}){if(u.registered)return;const o=get_Module()._resolveFilename;get_Module()._resolveFilename=function(e,t){let n=function resolveModulePath(e,t){if(!e)return;if(!t||!t.filename)return;if(d||(d=get_process().binding("natives")),d.hasOwnProperty(e))return;if("."===e[0])return;if(c(e))return;const o=get_path().dirname(t.filename),n=u.folders[o]&&u.folders[o][e];if(!n){const t=u.builtins[e];return t||void 0}const s=u.dependencies[e];if(null!=s)for(let e in s){const t=s[e];if((get_Module()._cache[t]||m(t))&&satisfies(e,n))return t}}(e,t);return n||(n=function resolveFilePath(e,t){if(!e)return;if(!t||!t.filename)return;if("."!==e[0]&&!c(e))return;const o=get_path().resolve(get_path().dirname(t.filename),e);if(!m(o))return;let n=get_path().extname(o);if(n){if(u.extensions[n]&&u.extensions[n].has(o))return o}else for(n in u.extensions){const e=`${o}${n}`;if(u.extensions[n].has(e))return e}}(e,t)),n||o(e,t)},u.registered=!0,u.resourcePath=e,u.resourcePathWithTrailingSlash=`${e}${get_path().sep}`,function registerBuiltins(e){if(e||!u.resourcePath.startsWith("/usr/lib/atom/")){const e=s("../node_modules/fs-plus/lib/fs-plus.js"),t=get_path().join(u.resourcePath,"exports","atom.js");e.isFileSync(t)&&(u.builtins.atom=t)}null==u.builtins.atom&&(u.builtins.atom=get_path().join(u.resourcePath,"exports","atom.js"));const t=get_path().join(get_process().resourcesPath,"electron.asar"),o=get_path().join(t,"common","api"),n=["callbacks-registry","clipboard","crash-reporter","shell"];for(const e of n)u.builtins[e]=get_path().join(o,`${e}.js`);const r=get_path().join(t,"renderer","api"),i=["ipc-renderer","remote","screen"];for(const e of i)u.builtins[e]=get_path().join(r,`${e}.js`)}(t)},e.add=function(e,t){if(null==t)try{t=s(`${e}${get_path().sep}package.json`)}catch(e){return}const o=t&&t._atomModuleCache;if(o){for(const t of o.dependencies||[])u.dependencies[t.name]||(u.dependencies[t.name]={}),u.dependencies[t.name][t.version]||(u.dependencies[t.name][t.version]=`${e}${get_path().sep}${t.path}`);for(const t of o.folders||[])for(const o of t.paths)o?u.folders[`${e}${get_path().sep}${o}`]=t.dependencies:u.folders[e]=t.dependencies;for(const t in o.extensions){const n=o.extensions[t];u.extensions[t]||(u.extensions[t]=new Set);for(let o of n)u.extensions[t].add(`${e}${get_path().sep}${o}`)}}},e.cache=u,e.Range=Range},"../node_modules/about/lib/main.js":function(e,t,o,n,s,r){let{CompositeDisposable:i}={};const a=s("../node_modules/about/node_modules/semver/semver.js"),l=s("../node_modules/about/lib/update-manager.js"),d=s("../node_modules/about/lib/about.js"),u=s("../node_modules/about/lib/components/about-status-bar.js");let c;t.exports={activate(){this.subscriptions=new(function get_CompositeDisposable(){return i=i||s("atom").CompositeDisposable}()),this.createModel();let e=get_window().localStorage.getItem("about:version-available");("dev"===atom.getReleaseChannel()||e&&a.lte(e,atom.getVersion()))&&this.clearUpdateState(),this.subscriptions.add(c.onDidChange(()=>{c.getState()===l.State.UpdateAvailableToInstall&&(get_window().localStorage.setItem("about:version-available",c.getAvailableVersion()),this.showStatusBarIfNeeded())})),this.subscriptions.add(atom.commands.add("atom-workspace","about:clear-update-state",()=>{this.clearUpdateState()}))},deactivate(){this.model.destroy(),this.statusBarTile&&this.statusBarTile.destroy(),c&&(c.dispose(),c=void 0)},clearUpdateState(){get_window().localStorage.removeItem("about:version-available")},consumeStatusBar(e){this.statusBar=e,this.showStatusBarIfNeeded()},deserializeAboutView(e){return this.model||this.createModel(),this.model.deserialize(e)},createModel(){c=c||new l,this.model=new d({uri:"atom://about",currentAtomVersion:atom.getVersion(),currentElectronVersion:get_process().versions.electron,currentChromeVersion:get_process().versions.chrome,currentNodeVersion:get_process().version,updateManager:c})},isUpdateAvailable(){let e=get_window().localStorage.getItem("about:version-available");return e&&a.gt(e,atom.getVersion())},showStatusBarIfNeeded(){if(this.isUpdateAvailable()&&this.statusBar){let e=new u;return this.statusBarTile&&this.statusBarTile.destroy(),this.statusBarTile=this.statusBar.addRightTile({item:e,priority:-100}),this.statusBarTile}}}},"../node_modules/archive-view/lib/archive-editor.js":function(e,t,o,n,s,r){const i=s("../node_modules/fs-plus/lib/fs-plus.js");let a;function get_path(){return a=a||s("path")}let{Disposable:l}={};function get_Disposable(){return l=l||s("atom").Disposable}const d=s("../node_modules/archive-view/lib/get-icon-services.js"),u=s("../node_modules/archive-view/lib/archive-editor-view.js");t.exports={activate(){this.disposable=atom.workspace.addOpener((e="")=>{if(function isPathSupported(e){switch(get_path().extname(e)){case".egg":case".epub":case".jar":case".love":case".nupkg":case".tar":case".tgz":case".war":case".whl":case".xpi":case".zip":return!0;case".gz":return".tar"===get_path().extname(get_path().basename(e,".gz"));default:return!1}}(e)&&i.isFileSync(e))return new u(e)})},deactivate(){this.disposable.dispose();for(const e of atom.workspace.getPaneItems())e instanceof u&&e.destroy()},consumeElementIcons:e=>(d().setElementIcons(e),new(get_Disposable())(()=>d().resetElementIcons())),consumeFileIcons:e=>(d().setFileIcons(e),new(get_Disposable())(()=>d().resetFileIcons())),deserialize(e={}){if(i.isFileSync(e.path))return new u(e.path);get_console().warn(`Can't build ArchiveEditorView for path "${e.path}"; file no longer exists`)}}},"../node_modules/autocomplete-atom-api/lib/main.js":function(e,t,o,n,s,r){(function(){var e;e=s("../node_modules/autocomplete-atom-api/lib/provider.js"),t.exports={activate:function(){return e.load()},getProvider:function(){return e}}}).call(this)},"../node_modules/autocomplete-css/lib/main.js":function(e,t,o,n,s,r){(function(){var e;e=s("../node_modules/autocomplete-css/lib/provider.js"),t.exports={activate:function(){},getProvider:function(){return e}}}).call(this)},"../node_modules/autocomplete-html/lib/main.js":function(e,t,o,n,s,r){const i=s("../node_modules/autocomplete-html/lib/tree-sitter-provider.js"),a=s("../node_modules/autocomplete-html/lib/text-mate-provider.js"),l={selector:".text.html",disableForSelector:".text.html .comment",priority:1,filterSuggestions:!0,getSuggestions:e=>e.editor.getBuffer().getLanguageMode().tree?i(e):a(e),onDidInsertSuggestion({editor:e,suggestion:t}){"attribute"===t.type&&setTimeout(this.triggerAutocomplete.bind(this,e),1)},triggerAutocomplete(e){atom.commands.dispatch(e.getElement(),"autocomplete-plus:activate",{activatedManually:!1})}};t.exports={activate(){},getProvider:()=>l}},"../node_modules/autocomplete-plus/lib/main.js":function(e,t,o,n,s,r){let{CompositeDisposable:i}={};function get_CompositeDisposable(){return i=i||s("atom").CompositeDisposable}const a=s("../node_modules/autocomplete-plus/lib/autocomplete-manager.js");t.exports={subscriptions:null,autocompleteManager:new a,activate(){this.subscriptions=new(get_CompositeDisposable()),this.autocompleteManager||(this.autocompleteManager=new a),this.subscriptions.add(this.autocompleteManager),this.autocompleteManager.initialize()},deactivate(){this.subscriptions&&this.subscriptions.dispose(),this.subscriptions=null,this.autocompleteManager=null},provideWatchEditor(){return this.autocompleteManager.watchEditor.bind(this.autocompleteManager)},consumeSnippets(e){this.autocompleteManager.setSnippetsManager(e)},consumeProvider_1(e){if(e&&e.provider)return this.consumeProvider([e.provider],1)},consumeProvider_1_1(e){if(e&&e.providers)return this.consumeProvider(e.providers,1)},consumeProvider_2(e){return this.consumeProvider(e,2)},consumeProvider_3(e){return this.consumeProvider(e,3)},consumeProvider_4(e){return this.consumeProvider(e,4)},consumeProvider(e,t=3){if(!e)return;if(e&&!Array.isArray(e)&&(e=[e]),!e.length>0)return;const o=new(get_CompositeDisposable());for(let n=0;n<e.length;n++){const s=e[n];o.add(this.autocompleteManager.providerManager.registerProvider(s,t))}return o}}},"../node_modules/autocomplete-snippets/lib/autocomplete-snippets.js":function(e,t,o,n,s,r){t.exports={provider:null,activate(){},deactivate(){this.provider=null},provide(){if(null==this.provider){const e=s("../node_modules/autocomplete-snippets/lib/snippets-provider.js");this.provider=new e,null!=this.snippets&&this.provider.setSnippetsSource(this.snippets)}return this.provider},consumeSnippets(e){return this.snippets=e,null!=this.provider?this.provider.setSnippetsSource(this.snippets):void 0}}},"../node_modules/autoflow/lib/autoflow.js":function(e,t,o,n,s,r){(function(){var e,o;o=s("../node_modules/underscore-plus/lib/underscore-plus.js"),e=/[^\s]/,t.exports={activate:function(){return this.commandDisposable=atom.commands.add("atom-text-editor",{"autoflow:reflow-selection":(e=this,function(t){return e.reflowSelection(t.currentTarget.getModel())})});var e},deactivate:function(){var e;return null!=(e=this.commandDisposable)&&e.dispose(),this.commandDisposable=null},reflowSelection:function(e){var t,o,n;if((t=e.getSelectedBufferRange()).isEmpty()&&(t=e.getCurrentParagraphBufferRange()),null!=t)return o={wrapColumn:this.getPreferredLineLength(e),tabLength:this.getTabLength(e)},n=this.reflow(e.getTextInRange(t),o),e.getBuffer().setTextInRange(t,n)},reflow:function(e,t){var n,s,r,i,a,l,d,u,c,m,p,h,f,g,b,_,y,v,j,w,k,x,S,C,P,R,T,E;for(R=t.wrapColumn,S=t.tabLength,w=[],(f=(e=e.replace(/\r\n?/g,"\n")).match(/^\s*\n/))?e=e.substr(f.length):f="",(P=e.match(/\n\s*$/))?e=e.substr(0,e.length-P.length):P="",j=e.split(/\n\s*\n/g),C=S?Array(S+1).join(" "):"",u=0,g=j.length;u<g;u++){for(s=j[u].split("\n"),n=[],a=[],p=/^\s*\\\w+(\[.*\])?\{\w+\}(\[.*\])?\s*$/g,h=/^\s*\\\w+\s*\{\s*$/g,m=/^\s*\}\s*$/g;s[0].match(p)||s[0].match(h);)n.push(s[0]),s.shift();for(;s[s.length-1].match(p)||s[s.length-1].match(m);)a.unshift(s[s.length-1]),s.pop();for(y=_=s[0].match(/^\s*(\/\/|\/\*|;;|#'|\|\|\||--|[#%*>-])?\s*/g)[0],C&&(y=_.replace(/\t/g,C)),_&&(l=o.escapeRegExp(_),s=s.map(function(e){return e.replace(RegExp("^"+l),"")})),s=s.map(function(e){return e.replace(/^\s+/,"")}),v=[],r=[],i=y.length,T=_.replace(/^(\s*)\/\*/,"$1  ").replace(/^(\s*)-(?!-)/,"$1 "),d=!0,c=0,b=(k=this.segmentText(s.join(" "))).length;c<b;c++)x=k[c],this.wrapSegment(x,i,R)&&(!0!==d&&(-1===_.search(/^\s*\/\*/)&&-1===_.search(/^\s*-(?!-)/)||(_=T)),v.push(_+r.join("")),r=[],i=y.length,d=!1),r.push(x),i+=x.length;v.push(_+r.join("")),E=n.concat(v.concat(a)),w.push(E.join("\n").replace(/\s+\n/g,"\n"))}return f+w.join("\n\n")+P},getTabLength:function(e){var t;return null!=(t=atom.config.get("editor.tabLength",{scope:e.getRootScopeDescriptor()}))?t:2},getPreferredLineLength:function(e){return atom.config.get("editor.preferredLineLength",{scope:e.getRootScopeDescriptor()})},wrapSegment:function(t,o,n){return e.test(t)&&o+t.length>n&&(o>0||t.length<n)},segmentText:function(e){var t,o,n;for(n=[],o=/[\s]+|[^\s]+/g;t=o.exec(e);)n.push(t[0]);return n}}}).call(this)},"../node_modules/autosave/lib/autosave.js":function(e,t,o,n,s,r){const i=s("../node_modules/fs-plus/lib/fs-plus.js");let{CompositeDisposable:a,Disposable:l}={};const{dontSaveIf:d,shouldSave:u}=s("../node_modules/autosave/lib/controls.js");t.exports={subscriptions:null,provideService:()=>({dontSaveIf:d}),activate(){this.subscriptions=new(function get_CompositeDisposable(){return a=a||s("atom").CompositeDisposable}());const e=e=>{if(e.target===get_window())this.autosaveAllPaneItems();else if(e.target.matches("atom-text-editor:not(mini)")&&!e.target.contains(e.relatedTarget))return this.autosavePaneItem(e.target.getModel())};get_window().addEventListener("blur",e,!0),this.subscriptions.add(new(function get_Disposable(){return l=l||s("atom").Disposable}())(()=>get_window().removeEventListener("blur",e,!0))),this.subscriptions.add(atom.workspace.onDidAddPaneItem(({item:e})=>this.autosavePaneItem(e,!0))),this.subscriptions.add(atom.workspace.onWillDestroyPaneItem(({item:e})=>this.autosavePaneItem(e)))},deactivate(){return this.subscriptions.dispose(),this.autosaveAllPaneItems()},autosavePaneItem(e,t=!1){if(!atom.config.get("autosave.enabled"))return;if(!e)return;if("function"!=typeof e.getURI||!e.getURI())return;if("function"!=typeof e.isModified||!e.isModified())return;if("function"!=typeof e.getPath||!e.getPath())return;if(!u(e))return;try{if(!i.statSync(e.getPath()).isFile())return}catch(e){if("ENOENT"!==e.code)return;if(!t)return}const o=atom.workspace.paneForItem(e);let n=Promise.resolve();return o?n=o.saveItem(e):"function"==typeof e.save&&(n=e.save()),n},autosaveAllPaneItems(){return Promise.all(atom.workspace.getPaneItems().map(e=>this.autosavePaneItem(e)))}}},"../node_modules/background-tips/lib/background-tips.js":function(e,t,o,n,s,r){const i=s("../node_modules/background-tips/lib/background-tips-view.js");t.exports={activate(){this.backgroundTipsView=new i},deactivate(){this.backgroundTipsView.destroy()}}},"../node_modules/bookmarks/lib/main.js":function(e,t,o,n,s,r){(function(){var e,o,n,r,i;e=null,o=s("../node_modules/bookmarks/lib/bookmarks-view.js"),i=null,r=null,t.exports={activate:function(t){var a,l;return i=[],l=new WeakSet,a=null,r=new(function get_CompositeDisposable(){return n=n||s("atom").CompositeDisposable}()),atom.commands.add("atom-workspace","bookmarks:view-all",function(){return null==a&&(a=new o(i)),a.show()}),atom.workspace.observeTextEditors(function(o){var n,a;if(!l.has(o))return null==e&&(e=s("../node_modules/bookmarks/lib/bookmarks.js")),n=(a=t[o.id])?e.deserialize(o,a):new e(o),i.push(n),l.add(o),r.add(o.onDidDestroy(function(){var e;return-1!==(e=i.indexOf(n))&&i.splice(e,1),n.destroy(),l.delete(o)}))})},deactivate:function(){var e,t;for("undefined"!=typeof bookmarksView&&null!==bookmarksView&&bookmarksView.destroy(),e=0,t=i.length;e<t;e++)i[e].deactivate();return r.dispose()},serialize:function(){var e,t,o,n;for(t={},o=0,n=i.length;o<n;o++)t[(e=i[o]).editor.id]=e.serialize();return t}}}).call(this)},"../node_modules/bracket-matcher/lib/main.js":function(e,t,o,n,s,r){const i=s("../node_modules/bracket-matcher/lib/match-manager.js"),a=s("../node_modules/bracket-matcher/lib/bracket-matcher-view.js"),l=s("../node_modules/bracket-matcher/lib/bracket-matcher.js");t.exports={activate(){const e=new WeakSet;atom.workspace.observeTextEditors(t=>{if(e.has(t))return;const o=atom.views.getView(t),n=new i(t,o);new a(t,o,n),new l(t,o,n),e.add(t),t.onDidDestroy(()=>e.delete(t))})}}},"../node_modules/command-palette/lib/command-palette-package.js":function(e,t,o,n,s,r){Object.defineProperty(e,"__esModule",{value:!0});var i,a=function(){function defineProperties(e,t){for(var o=0;o<t.length;o++){var n=t[o];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(e,t,o){return t&&defineProperties(e.prototype,t),o&&defineProperties(e,o),e}}();var l=function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}(s("../node_modules/command-palette/lib/command-palette-view.js")),d=new(function(){function CommandPalettePackage(){!function _classCallCheck(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,CommandPalettePackage)}return a(CommandPalettePackage,[{key:"activate",value:function activate(){var e=this;return this.commandPaletteView=new l.default,this.disposables=new(function get__atom(){return i=i||s("atom")}().CompositeDisposable),this.disposables.add(atom.commands.add("atom-workspace",{"command-palette:toggle":function commandPaletteToggle(){e.commandPaletteView.toggle()},"command-palette:show-hidden-commands":function commandPaletteShowHiddenCommands(){e.commandPaletteView.show(!0)}})),this.disposables.add(atom.config.observe("command-palette.useAlternateScoring",function(t){e.commandPaletteView.update({useAlternateScoring:t})})),this.disposables.add(atom.config.observe("command-palette.preserveLastSearch",function(t){e.commandPaletteView.update({preserveLastSearch:t})})),this.commandPaletteView.show()}},{key:"deactivate",value:function _asyncToGenerator(e){return function(){var t=e.apply(this,arguments);return new Promise(function(e,o){var n=step.bind(null,"next"),s=step.bind(null,"throw");function step(r,i){try{var a=t[r](i),l=a.value}catch(e){return void o(e)}a.done?e(l):Promise.resolve(l).then(n,s)}n()})}}(function*(){this.disposables.dispose(),yield this.commandPaletteView.destroy()})}]),CommandPalettePackage}());e.default=d,t.exports=e.default},"../node_modules/deprecation-cop/lib/main.js":function(e,t,o,n,s,r){let{Disposable:i,CompositeDisposable:a}={};function get_Disposable(){return i=i||s("atom").Disposable}const l=s("../node_modules/deprecation-cop/lib/deprecation-cop-view.js"),d=s("../node_modules/deprecation-cop/lib/deprecation-cop-status-bar-view.js"),u="atom://deprecation-cop";t.exports=new class DeprecationCopPackage{activate(){this.disposables=new(function get_CompositeDisposable(){return a=a||s("atom").CompositeDisposable}()),this.disposables.add(atom.workspace.addOpener(e=>{if(e===u)return this.deserializeDeprecationCopView({uri:e})})),this.disposables.add(atom.commands.add("atom-workspace","deprecation-cop:view",()=>{atom.workspace.open(u)}))}deactivate(){this.disposables.dispose();const e=atom.workspace.paneForURI(u);e&&e.destroyItem(e.itemForURI(u))}deserializeDeprecationCopView(e){return new l(e)}consumeStatusBar(e){const t=new d,o=e.addRightTile({item:t,priority:150});this.disposables.add(new(get_Disposable())(()=>{t.destroy()})),this.disposables.add(new(get_Disposable())(()=>{o.destroy()}))}}},"../node_modules/dev-live-reload/lib/main.js":function(e,t,o,n,s,r){t.exports={activate(e){atom.inDevMode()&&!atom.inSpecMode()&&(atom.packages.hasActivatedInitialPackages()?this.startWatching():this.activatedDisposable=atom.packages.onDidActivateInitialPackages(()=>this.startWatching()))},deactivate(){this.activatedDisposable&&this.activatedDisposable.dispose(),this.commandDisposable&&this.commandDisposable.dispose(),this.uiWatcher&&this.uiWatcher.destroy()},startWatching(){const e=s("../node_modules/dev-live-reload/lib/ui-watcher.js");this.uiWatcher=new e({themeManager:atom.themes}),this.commandDisposable=atom.commands.add("atom-workspace","dev-live-reload:reload-all",()=>this.uiWatcher.reloadAll()),this.activatedDisposable&&this.activatedDisposable.dispose()}}},"../node_modules/encoding-selector/lib/main.js":function(e,t,o,n,s,r){const i=s("../node_modules/encoding-selector/lib/encoding-list-view.js"),a=s("../node_modules/encoding-selector/lib/encoding-status-view.js"),l={utf8:{list:"UTF-8",status:"UTF-8"},utf16le:{list:"UTF-16 LE",status:"UTF-16 LE"},utf16be:{list:"UTF-16 BE",status:"UTF-16 BE"},windows1252:{list:"Western (Windows 1252)",status:"Windows 1252"},iso88591:{list:"Western (ISO 8859-1)",status:"ISO 8859-1"},iso88593:{list:"Western (ISO 8859-3)",status:"ISO 8859-3"},iso885915:{list:"Western (ISO 8859-15)",status:"ISO 8859-15"},macroman:{list:"Western (Mac Roman)",status:"Mac Roman"},cp437:{list:"DOS (CP 437)",status:"CP437"},cp850:{list:"DOS (CP 850)",status:"CP850"},windows1256:{list:"Arabic (Windows 1256)",status:"Windows 1256"},iso88596:{list:"Arabic (ISO 8859-6)",status:"ISO 8859-6"},windows1257:{list:"Baltic (Windows 1257)",status:"Windows 1257"},iso88594:{list:"Baltic (ISO 8859-4)",status:"ISO 8859-4"},windows1250:{list:"Central European (Windows 1250)",status:"Windows 1250"},iso88592:{list:"Central European (ISO 8859-2)",status:"ISO 8859-2"},windows1251:{list:"Cyrillic (Windows 1251)",status:"Windows 1251"},cp866:{list:"Cyrillic (CP 866)",status:"CP 866"},iso88595:{list:"Cyrillic (ISO 8859-5)",status:"ISO 8859-5"},koi8r:{list:"Cyrillic (KOI8-R)",status:"KOI8-R"},koi8u:{list:"Cyrillic (KOI8-U)",status:"KOI8-U"},iso885913:{list:"Estonian (ISO 8859-13)",status:"ISO 8859-13"},windows1253:{list:"Greek (Windows 1253)",status:"Windows 1253"},iso88597:{list:"Greek (ISO 8859-7)",status:"ISO 8859-7"},windows1255:{list:"Hebrew (Windows 1255)",status:"Windows 1255"},iso88598:{list:"Hebrew (ISO 8859-8)",status:"ISO 8859-8"},iso885916:{list:"Romanian (ISO 8859-16)",status:"ISO 8859-16"},windows1254:{list:"Turkish (Windows 1254)",status:"Windows 1254"},iso88599:{list:"Turkish (ISO 8859-9)",status:"ISO 8859-9"},windows1258:{list:"Vietnamese (Windows 1254)",status:"Windows 1254"},gbk:{list:"Chinese (GBK)",status:"GBK"},gb18030:{list:"Chinese (GB18030)",status:"GB18030"},cp950:{list:"Traditional Chinese (Big5)",status:"Big5"},big5hkscs:{list:"Traditional Chinese (Big5-HKSCS)",status:"Big5-HKSCS"},shiftjis:{list:"Japanese (Shift JIS)",status:"Shift JIS"},cp932:{list:"Japanese (CP 932)",status:"CP 932"},eucjp:{list:"Japanese (EUC-JP)",status:"EUC-JP"},euckr:{list:"Korean (EUC-KR)",status:"EUC-KR"}},d={iso885914:{list:"Celtic (ISO 8859-14)",status:"ISO 8859-14"},iso885910:{list:"Nordic (ISO 8859-10)",status:"ISO 8859-10"}};let u=null,c=null,m=null;t.exports={activate(){"win32"!==get_process().platform&&Object.assign(l,d),m=atom.commands.add("atom-text-editor","encoding-selector:show",()=>{u||(u=new i(l)),u.toggle()})},deactivate(){m&&m.dispose(),m=null,c&&c.destroy(),c=null,u&&u.destroy(),u=null},consumeStatusBar(e){(c=new a(e,l)).attach()}}},"../node_modules/exception-reporting/lib/main.js":function(e,t,o,n,s,r){var i;Object.defineProperty(e,"__esModule",{value:!0});var a=void 0;function getReporter(){if(!a){var e=s("../node_modules/exception-reporting/lib/reporter.js");a=new e}return a}e.default={activate:function activate(){this.subscriptions=new(function get__atom(){return i=i||s("atom")}().CompositeDisposable),atom.config.get("exception-reporting.userId")||atom.config.set("exception-reporting.userId",s("../node_modules/node-uuid/uuid.js").v4()),this.subscriptions.add(atom.onDidThrowError(function(e){e.message,e.url,e.line,e.column;var t=e.originalError;try{getReporter().reportUncaughtException(t)}catch(e){try{get_console().error("Error reporting uncaught exception",e),getReporter().reportUncaughtException(e)}catch(e){}}})),null!=atom.onDidFailAssertion&&this.subscriptions.add(atom.onDidFailAssertion(function(e){try{getReporter().reportFailedAssertion(e)}catch(t){try{get_console().error("Error reporting assertion failure",t),getReporter().reportUncaughtException(t)}catch(e){}}}))}},t.exports=e.default},"../node_modules/dalek/lib/main.js":function(e,t,o,n,s,r){var i=s("../node_modules/dalek/lib/dalek.js"),a=s("../node_modules/dalek/node_modules/grim/lib/grim.js");t.exports={activate:function activate(){atom.packages.onDidActivateInitialPackages(function _asyncToGenerator(e){return function(){var t=e.apply(this,arguments);return new Promise(function(e,o){var n=step.bind(null,"next"),s=step.bind(null,"throw");function step(r,i){try{var a=t[r](i),l=a.value}catch(e){return void o(e)}a.done?e(l):Promise.resolve(l).then(n,s)}n()})}}(function*(){for(var e=yield i.enumerate(),t=0;t<e.length;t++){var o=e[t];a.deprecate('You have the core package "'+o+'" installed as a community package. See https://github.com/atom/atom/blob/master/packages/dalek/README.md for how this causes problems and instructions on how to correct the situation.',{packageName:o})}}))}}},"../node_modules/find-and-replace/lib/find.js":function(e,t,o,n,s,r){(function(){var e,o,n,r,i,a,l,d,u,c,m,p,h,f,g;function get_ref(){return f=f||s("atom")}function get_CompositeDisposable(){return o=o||get_ref().CompositeDisposable}function get_Disposable(){return n=n||get_ref().Disposable}function get_TextBuffer(){return p=p||get_ref().TextBuffer}m=s("../node_modules/find-and-replace/lib/select-next.js"),g=s("../node_modules/find-and-replace/lib/history.js"),a=g.History,l=g.HistoryCycler,r=s("../node_modules/find-and-replace/lib/find-options.js"),e=s("../node_modules/find-and-replace/lib/buffer-search.js"),h=s("../node_modules/find-and-replace/lib/get-icon-services.js"),i=s("../node_modules/find-and-replace/lib/find-view.js"),d=s("../node_modules/find-and-replace/lib/project-find-view.js"),u=s("../node_modules/find-and-replace/lib/project/results-model.js"),c=s("../node_modules/find-and-replace/lib/project/results-pane.js"),t.exports={activate:function(t){var o,n,s,i,l,d,p,h,f,g;return n=(l=null!=t?t:{}).findOptions,o=l.findHistory,d=l.replaceHistory,i=l.pathsHistory,atom.config.get("find-and-replace.openProjectFindResultsInRightPane")&&atom.config.set("find-and-replace.projectSearchResultsPaneSplitDirection","right"),atom.config.unset("find-and-replace.openProjectFindResultsInRightPane"),atom.workspace.addOpener(function(e){if(e===c.URI)return new c}),this.subscriptions=new(get_CompositeDisposable()),this.currentItemSub=new(get_Disposable()),this.findHistory=new a(o),this.replaceHistory=new a(d),this.pathsHistory=new a(i),this.findOptions=new r(n),this.findModel=new e(this.findOptions),this.resultsModel=new u(this.findOptions),this.subscriptions.add(atom.workspace.getCenter().observeActivePaneItem((g=this,function(e){return g.subscriptions.delete(g.currentItemSub),g.currentItemSub.dispose(),atom.workspace.isTextEditor(e)?g.findModel.setEditor(e):null!=(null!=e?e.observeEmbeddedTextEditor:void 0)?(g.currentItemSub=e.observeEmbeddedTextEditor(function(t){if(atom.workspace.getCenter().getActivePaneItem()===e)return g.findModel.setEditor(t)}),g.subscriptions.add(g.currentItemSub)):null!=(null!=e?e.getEmbeddedTextEditor:void 0)?g.findModel.setEditor(e.getEmbeddedTextEditor()):g.findModel.setEditor(null)}))),this.subscriptions.add(atom.commands.add(".find-and-replace, .project-find","window:focus-next-pane",function(){return atom.views.getView(atom.workspace).focus()})),this.subscriptions.add(atom.commands.add("atom-workspace","project-find:show",function(e){return function(){return e.createViews(),h(e.projectFindPanel,e.findPanel,function(){return e.projectFindView.focusFindElement()})}}(this))),this.subscriptions.add(atom.commands.add("atom-workspace","project-find:toggle",function(e){return function(){return e.createViews(),f(e.projectFindPanel,e.findPanel,function(){return e.projectFindView.focusFindElement()})}}(this))),this.subscriptions.add(atom.commands.add("atom-workspace","project-find:show-in-current-directory",function(e){return function(t){var o;return o=t.target,e.createViews(),e.findPanel.hide(),e.projectFindPanel.show(),e.projectFindView.focusFindElement(),e.projectFindView.findInCurrentlySelectedDirectory(o)}}(this))),this.subscriptions.add(atom.commands.add("atom-workspace","find-and-replace:use-selection-as-find-pattern",function(e){return function(){var t,o;if(!((null!=(t=e.projectFindPanel)?t.isVisible():void 0)||(null!=(o=e.findPanel)?o.isVisible():void 0)))return e.createViews()}}(this))),this.subscriptions.add(atom.commands.add("atom-workspace","find-and-replace:use-selection-as-replace-pattern",function(e){return function(){var t,o;if(!((null!=(t=e.projectFindPanel)?t.isVisible():void 0)||(null!=(o=e.findPanel)?o.isVisible():void 0)))return e.createViews()}}(this))),this.subscriptions.add(atom.commands.add("atom-workspace","find-and-replace:toggle",function(e){return function(){return e.createViews(),f(e.findPanel,e.projectFindPanel,function(){return e.findView.focusFindEditor()})}}(this))),this.subscriptions.add(atom.commands.add("atom-workspace","find-and-replace:show",function(e){return function(){return e.createViews(),h(e.findPanel,e.projectFindPanel,function(){return e.findView.focusFindEditor()})}}(this))),this.subscriptions.add(atom.commands.add("atom-workspace","find-and-replace:show-replace",function(e){return function(){return e.createViews(),h(e.findPanel,e.projectFindPanel,function(){return e.findView.focusReplaceEditor()})}}(this))),this.subscriptions.add(atom.commands.add("atom-workspace","find-and-replace:clear-history",function(e){return function(){return e.findHistory.clear(),e.replaceHistory.clear()}}(this))),s=function(e){return function(t){var o,n,s;if(!("ATOM-TEXT-EDITOR"===(s=t.target).tagName&&s.hasAttribute("mini")))return null!=(o=e.findPanel)&&o.hide(),null!=(n=e.projectFindPanel)?n.hide():void 0}}(this),this.subscriptions.add(atom.commands.add("atom-workspace",{"core:cancel":s,"core:close":s})),p=function(e){return function(t){var o,n;return null==e.selectNextObjects&&(e.selectNextObjects=new WeakMap),o=t.getModel(),null==(n=e.selectNextObjects.get(o))&&(n=new m(o),e.selectNextObjects.set(o,n)),n}}(this),h=function(e,t,o){return t.hide(),e.show(),"function"==typeof o?o():void 0},f=function(e,t,o){return t.hide(),e.isVisible()?e.hide():(e.show(),"function"==typeof o?o():void 0)},this.subscriptions.add(atom.commands.add(".editor:not(.mini)",{"find-and-replace:select-next":function(e){return p(this).findAndSelectNext()},"find-and-replace:select-all":function(e){return p(this).findAndSelectAll()},"find-and-replace:select-undo":function(e){return p(this).undoLastSelection()},"find-and-replace:select-skip":function(e){return p(this).skipCurrentSelection()}}))},consumeElementIcons:function(e){return h().setElementIcons(e),new(get_Disposable())(function(){return h().resetElementIcons()})},consumeFileIcons:function(e){return h().setFileIcons(e),new(get_Disposable())(function(){return h().resetFileIcons()})},toggleAutocompletions:function(e){var t,o;if(null!=this.findView)return e?(this.autocompleteSubscriptions=new(get_CompositeDisposable()),null!=(t="function"==typeof this.autocompleteWatchEditor?this.autocompleteWatchEditor(this.findView.findEditor,["default"]):void 0)?this.autocompleteSubscriptions.add(t):void 0):null!=(o=this.autocompleteSubscriptions)?o.dispose():void 0},consumeAutocompleteWatchEditor:function(e){var t;return this.autocompleteWatchEditor=e,atom.config.observe("find-and-replace.autocompleteSearches",(t=this,function(e){return t.toggleAutocompletions(e)})),new(get_Disposable())(function(e){return function(){var t;return null!=(t=e.autocompleteSubscriptions)&&t.dispose(),e.autocompleteWatchEditor=null}}(this))},provideService:function(){return{resultsMarkerLayerForTextEditor:this.findModel.resultsMarkerLayerForTextEditor.bind(this.findModel)}},createViews:function(){var e,t,o,n;if(null==this.findView)return t={findBuffer:e=new(get_TextBuffer()),replaceBuffer:n=new(get_TextBuffer()),pathsBuffer:o=new(get_TextBuffer()),findHistoryCycler:new l(e,this.findHistory),replaceHistoryCycler:new l(n,this.replaceHistory),pathsHistoryCycler:new l(o,this.pathsHistory)},this.findView=new i(this.findModel,t),this.projectFindView=new d(this.resultsModel,t),this.findPanel=atom.workspace.addBottomPanel({item:this.findView,visible:!1,className:"tool-panel panel-bottom"}),this.projectFindPanel=atom.workspace.addBottomPanel({item:this.projectFindView,visible:!1,className:"tool-panel panel-bottom"}),this.findView.setPanel(this.findPanel),this.projectFindView.setPanel(this.projectFindPanel),c.model=this.resultsModel,this.toggleAutocompletions(atom.config.get("find-and-replace.autocompleteSearches"))},deactivate:function(){var e,t,o,n,s,r,i;return null!=(e=this.findPanel)&&e.destroy(),this.findPanel=null,null!=(t=this.findView)&&t.destroy(),this.findView=null,null!=(o=this.findModel)&&o.destroy(),this.findModel=null,null!=(n=this.projectFindPanel)&&n.destroy(),this.projectFindPanel=null,null!=(s=this.projectFindView)&&s.destroy(),this.projectFindView=null,c.model=null,this.resultsModel=null,null!=(r=this.autocompleteSubscriptions)&&r.dispose(),this.autocompleteManagerService=null,null!=(i=this.subscriptions)&&i.dispose(),this.subscriptions=null},serialize:function(){return{findOptions:this.findOptions.serialize(),findHistory:this.findHistory.serialize(),replaceHistory:this.replaceHistory.serialize(),pathsHistory:this.pathsHistory.serialize()}}}}).call(this)},"../node_modules/fuzzy-finder/lib/main.js":function(e,t,o,n,s,r){let{CompositeDisposable:i,Disposable:a}={};function get_Disposable(){return a=a||s("atom").Disposable}const l=s("../node_modules/fuzzy-finder/lib/get-icon-services.js");t.exports={activate(e){this.active=!0,this.disposables=new(function get_CompositeDisposable(){return i=i||s("atom").CompositeDisposable}()),this.disposables.add(atom.commands.add("atom-workspace",{"fuzzy-finder:toggle-file-finder":()=>{this.createProjectView().toggle()},"fuzzy-finder:toggle-buffer-finder":()=>{this.createBufferView().toggle()},"fuzzy-finder:toggle-git-status-finder":()=>{this.createGitStatusView().toggle()}})),get_process().nextTick(()=>this.startLoadPathsTask());for(let t of atom.workspace.getTextEditors())t.lastOpened=e[t.getPath()];this.disposables.add(atom.workspace.observePanes(e=>{this.disposables.add(e.observeActiveItem(e=>{null!=e&&(e.lastOpened=Date.now())}))}))},deactivate(){this.disposables.dispose(),null!=this.projectView&&(this.projectView.destroy(),this.projectView=null),null!=this.bufferView&&(this.bufferView.destroy(),this.bufferView=null),null!=this.gitStatusView&&(this.gitStatusView.destroy(),this.gitStatusView=null),this.projectPaths=null,this.stopLoadPathsTask(),this.active=!1},consumeElementIcons:e=>(l().setElementIcons(e),new(get_Disposable())(()=>l().resetElementIcons())),consumeFileIcons:e=>(l().setFileIcons(e),new(get_Disposable())(()=>l().resetFileIcons())),consumeTeletype(e){this.teletypeService=e,this.bufferView&&this.bufferView.setTeletypeService(e),this.projectView&&this.projectView.setTeletypeService(e)},serialize(){const e={};for(let t of atom.workspace.getTextEditors()){const o=t.getPath();null!=o&&(e[o]=t.lastOpened)}return e},createProjectView(){if(this.stopLoadPathsTask(),null==this.projectView){const e=s("../node_modules/fuzzy-finder/lib/project-view.js");this.projectView=new e(this.projectPaths),this.projectPaths=null,this.teletypeService&&this.projectView.setTeletypeService(this.teletypeService)}return this.projectView},createGitStatusView(){if(null==this.gitStatusView){const e=s("../node_modules/fuzzy-finder/lib/git-status-view.js");this.gitStatusView=new e}return this.gitStatusView},createBufferView(){if(null==this.bufferView){const e=s("../node_modules/fuzzy-finder/lib/buffer-view.js");this.bufferView=new e,this.teletypeService&&this.bufferView.setTeletypeService(this.teletypeService)}return this.bufferView},startLoadPathsTask(){if(this.stopLoadPathsTask(),!this.active)return;if(0===atom.project.getPaths().length)return;const e=s("../node_modules/fuzzy-finder/lib/path-loader.js");this.loadPathsTask=e.startTask(e=>{this.projectPaths=e}),this.projectPathsSubscription=atom.project.onDidChangePaths(()=>{this.projectPaths=null,this.stopLoadPathsTask()})},stopLoadPathsTask(){null!=this.projectPathsSubscription&&this.projectPathsSubscription.dispose(),this.projectPathsSubscription=null,null!=this.loadPathsTask&&this.loadPathsTask.terminate(),this.loadPathsTask=null}}},"../node_modules/github/lib/index.js":function(e,t,o,n,s,r){"use strict";var i=function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}(s("../node_modules/github/lib/github-package.js"));let a;const l={initialize(){a=new i.default({workspace:atom.workspace,project:atom.project,commandRegistry:atom.commands,notificationManager:atom.notifications,tooltips:atom.tooltips,styles:atom.styles,keymaps:atom.keymaps,grammars:atom.grammars,config:atom.config,deserializers:atom.deserializers,confirm:atom.confirm.bind(atom),getLoadSettings:atom.getLoadSettings.bind(atom),configDirPath:atom.getConfigDirPath()})}};t.exports=new Proxy(l,{get(e,t){if(a&&Reflect.has(a,t)){let e=a[t];return"function"==typeof e&&(e=e.bind(a)),e}return e[t]}})},"../node_modules/git-diff/lib/main.js":function(e,t,o,n,s,r){const i=s("../node_modules/git-diff/lib/git-diff-view.js"),a=s("../node_modules/git-diff/lib/diff-list-view.js");let l=null;t.exports={activate(){const e=new WeakSet;atom.workspace.observeTextEditors(t=>{e.has(t)||(new i(t).start(),atom.commands.add(atom.views.getView(t),"git-diff:toggle-diff-list",()=>{null==l&&(l=new a),l.toggle()}),e.add(t),t.onDidDestroy(()=>e.delete(t)))})},deactivate(){l&&l.destroy(),l=null}}},"../node_modules/go-to-line/lib/go-to-line-view.js":function(e,t,o,n,s,r){Object.defineProperty(e,"__esModule",{value:!0});var i,a=function(){function defineProperties(e,t){for(var o=0;o<t.length;o++){var n=t[o];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(e,t,o){return t&&defineProperties(e.prototype,t),o&&defineProperties(e,o),e}}();function get__atom(){return i=i||s("atom")}var l=function(){function GoToLineView(){var e=this;!function _classCallCheck(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,GoToLineView),this.miniEditor=new(get__atom().TextEditor)({mini:!0}),this.miniEditor.element.addEventListener("blur",this.close.bind(this)),this.message=get_document().createElement("div"),this.message.classList.add("message"),this.element=get_document().createElement("div"),this.element.classList.add("go-to-line"),this.element.appendChild(this.miniEditor.element),this.element.appendChild(this.message),this.panel=atom.workspace.addModalPanel({item:this,visible:!1}),atom.commands.add("atom-text-editor","go-to-line:toggle",function(){return e.toggle(),!1}),atom.commands.add(this.miniEditor.element,"core:confirm",function(){e.navigate()}),atom.commands.add(this.miniEditor.element,"core:cancel",function(){e.close()}),this.miniEditor.onWillInsertText(function(e){e.text.match(/[^0-9:]/)&&e.cancel()}),this.miniEditor.onDidChange(function(){e.navigate({keepOpen:!0})})}return a(GoToLineView,[{key:"toggle",value:function toggle(){this.panel.isVisible()?this.close():this.open()}},{key:"close",value:function close(){this.panel.isVisible()&&(this.miniEditor.setText(""),this.panel.hide(),this.miniEditor.element.hasFocus()&&this.restoreFocus())}},{key:"navigate",value:function navigate(){var e=arguments.length<=0||void 0===arguments[0]?{}:arguments[0],t=this.miniEditor.getText(),o=atom.workspace.getActiveTextEditor();if(e.keepOpen||this.close(),o&&t.length){var n=o.getCursorBufferPosition().row,s=t.split(/:+/)[0]||"",r=s.length>0?parseInt(s)-1:n,i=t.split(/:+/)[1]||"",a=i.length>0?parseInt(i)-1:-1,l=new(get__atom().Point)(r,a);o.setCursorBufferPosition(l),o.unfoldBufferRow(r),a<0&&o.moveToFirstCharacterOfLine(),o.scrollToBufferPosition(l,{center:!0})}}},{key:"storeFocusedElement",value:function storeFocusedElement(){return this.previouslyFocusedElement=get_document().activeElement,this.previouslyFocusedElement}},{key:"restoreFocus",value:function restoreFocus(){if(this.previouslyFocusedElement&&this.previouslyFocusedElement.parentElement)return this.previouslyFocusedElement.focus();atom.views.getView(atom.workspace).focus()}},{key:"open",value:function open(){!this.panel.isVisible()&&atom.workspace.getActiveTextEditor()&&(this.storeFocusedElement(),this.panel.show(),this.message.textContent='Enter a <row> or <row>:<column> to go there. Examples: "3" for row 3 or "2:7" for row 2 and column 7',this.miniEditor.element.focus())}}]),GoToLineView}();e.default={activate:function activate(){return new l}},t.exports=e.default},"../node_modules/grammar-selector/lib/main.js":function(e,t,o,n,s,r){const i=s("../node_modules/grammar-selector/lib/grammar-list-view.js"),a=s("../node_modules/grammar-selector/lib/grammar-status-view.js");let l=null,d=null,u=null;t.exports={activate(){l=atom.commands.add("atom-text-editor","grammar-selector:show",()=>{d||(d=new i),d.toggle()})},deactivate(){l&&l.dispose(),l=null,u&&u.destroy(),u=null,d&&d.destroy(),d=null},consumeStatusBar(e){(u=new a(e)).attach()}}},"../node_modules/image-view/lib/main.js":function(e,t,o,n,s,r){let i;const a=s("../node_modules/image-view/lib/image-editor.js");let{CompositeDisposable:l}={};const d=[".bmp",".gif",".ico",".jpeg",".jpg",".png",".webp"];t.exports={config:{defaultBackgroundColor:{type:"string",enum:["white","black","transparent"],default:"transparent"}},activate(){this.imageEditorStatusView=null,this.disposables=new(function get_CompositeDisposable(){return l=l||s("atom").CompositeDisposable}()),this.disposables.add(atom.workspace.addOpener(e=>{const t=function get_path(){return i=i||s("path")}().extname(e).toLowerCase();if(d.includes(t))return new a(e)})),this.disposables.add(atom.workspace.getCenter().onDidChangeActivePaneItem(()=>this.attachImageEditorStatusView()))},deactivate(){this.imageEditorStatusView&&this.imageEditorStatusView.destroy(),this.disposables.dispose()},consumeStatusBar(e){this.statusBar=e,this.attachImageEditorStatusView()},attachImageEditorStatusView(){if(this.imageEditorStatusView||null==this.statusBar)return;if(!(atom.workspace.getCenter().getActivePaneItem()instanceof a))return;const e=s("../node_modules/image-view/lib/image-editor-status-view.js");this.imageEditorStatusView=new e(this.statusBar),this.imageEditorStatusView.attach()},deserialize:e=>a.deserialize(e)}},"../node_modules/incompatible-packages/lib/main.js":function(e,t,o,n,s,r){var i;function get__atom(){return i=i||s("atom")}Object.defineProperty(e,"__esModule",{value:!0}),e.activate=function activate(){(l=new(get__atom().CompositeDisposable)).add(atom.workspace.addOpener(function(e){if(e===a.default)return deserializeIncompatiblePackagesComponent()})),l.add(atom.commands.add("atom-workspace",{"incompatible-packages:view":function incompatiblePackagesView(){atom.workspace.open(a.default)}}))},e.deactivate=function deactivate(){l.dispose()},e.consumeStatusBar=function consumeStatusBar(e){var t=0;for(var o of atom.packages.getLoadedPackages())o.isCompatible()||t++;t>0&&(n=function createIcon(e){return new(s("../node_modules/incompatible-packages/lib/status-icon-component.js"))({count:e})}(t),r=e.addRightTile({item:n,priority:200}),n.element.addEventListener("click",function(){atom.commands.dispatch(n.element,"incompatible-packages:view")}),l.add(new(get__atom().Disposable)(function(){return r.destroy()})));var n,r},e.deserializeIncompatiblePackagesComponent=deserializeIncompatiblePackagesComponent;var a=function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}(s("../node_modules/incompatible-packages/lib/view-uri.js")),l=null;function deserializeIncompatiblePackagesComponent(){return new(s("../node_modules/incompatible-packages/lib/incompatible-packages-component.js"))(atom.packages)}},"../node_modules/keybinding-resolver/lib/main.js":function(e,t,o,n,s,r){let{CompositeDisposable:i}={};const a=s("../node_modules/keybinding-resolver/lib/keybinding-resolver-view.js");t.exports={keybindingResolverView:null,activate(e={}){this.disposables=new(function get_CompositeDisposable(){return i=i||s("atom").CompositeDisposable}());const{attached:t}=e;t&&this.getKeybindingResolverView().toggle(),this.disposables.add(atom.commands.add("atom-workspace",{"key-binding-resolver:toggle":()=>this.getKeybindingResolverView().toggle(),"core:cancel":()=>this.getKeybindingResolverView().detach(),"core:close":()=>this.getKeybindingResolverView().detach()}))},getKeybindingResolverView(){return null==this.keybindingResolverView&&(this.keybindingResolverView=new a),this.keybindingResolverView},deactivate(){if(this.disposables.dispose(),null!=this.keybindingResolverView)return this.keybindingResolverView.destroy()},serialize(){if(null!=this.keybindingResolverView)return this.keybindingResolverView.serialize()}}},"../node_modules/language-c/lib/main.js":function(e,t,o,n,s,r){e.activate=function(){atom.grammars.addInjectionPoint&&(atom.grammars.addInjectionPoint("source.c",{type:"preproc_arg",language:e=>"c",content:e=>e}),atom.grammars.addInjectionPoint("source.cpp",{type:"preproc_arg",language:e=>"cpp",content:e=>e}))}},"../node_modules/language-html/lib/main.js":function(e,t,o,n,s,r){e.activate=function(){atom.grammars.addInjectionPoint&&(atom.grammars.addInjectionPoint("text.html.basic",{type:"raw_element",language:e=>"script"===e.firstChild.child(1).text?"javascript":"css",content:e=>e.child(1)}),atom.grammars.addInjectionPoint("text.html.ejs",{type:"template",language:e=>"javascript",content:e=>e.descendantsOfType("code")}),atom.grammars.addInjectionPoint("text.html.ejs",{type:"template",language:e=>"html",content:e=>e.descendantsOfType("content")}),atom.grammars.addInjectionPoint("text.html.erb",{type:"template",language:e=>"ruby",content:e=>e.descendantsOfType("code")}),atom.grammars.addInjectionPoint("text.html.erb",{type:"template",language:e=>"html",content:e=>e.descendantsOfType("content")}))}},"../node_modules/language-javascript/lib/main.js":function(e,t,o,n,s,r){e.activate=function(){if(atom.grammars.addInjectionPoint){atom.grammars.addInjectionPoint("source.js",{type:"call_expression",language(e){const{firstChild:t}=e;switch(t.type){case"identifier":return languageStringForTemplateTag(t.text);case"call_expression":return languageStringForTemplateTag(t.children[0].text);case"member_expression":if(t.startPosition.row===t.endPosition.row)return languageStringForTemplateTag(t.text)}},content(e){const{lastChild:t}=e;if("template_string"===t.type)return t}}),atom.grammars.addInjectionPoint("source.js",{type:"assignment_expression",language(e){const{firstChild:t}=e;if("member_expression"===t.type&&"innerHTML"===t.lastChild.text)return"html"},content(e){const{lastChild:t}=e;if("template_string"===t.type)return t}}),atom.grammars.addInjectionPoint("source.js",{type:"regex_pattern",language:e=>"regex",content:e=>e});for(const e of["source.js","source.flow","source.ts"])atom.grammars.addInjectionPoint(e,{type:"comment",language(e){if(e.text.startsWith("/**"))return"jsdoc"},content:e=>e})}};const i=/\bstyled\b|\bcss\b/i,a=/\bgraphql\b|\bgql\b/i,l=/\bsql\b/i;function languageStringForTemplateTag(e){return i.test(e)?"CSS":a.test(e)?"GraphQL":l.test(e)?"SQL":e}},"../node_modules/language-ruby/lib/main.js":function(e,t,o,n,s,r){e.activate=function(){atom.grammars.addInjectionPoint&&(atom.grammars.addInjectionPoint("source.ruby",{type:"heredoc_body",language:e=>e.lastChild.text,content:e=>e}),atom.grammars.addInjectionPoint("source.ruby",{type:"regex",language:()=>"regex",content:e=>e}))}},"../node_modules/language-typescript/lib/main.js":function(e,t,o,n,s,r){e.activate=function(){for(const e of["source.ts","source.flow"])atom.grammars.addInjectionPoint(e,{type:"call_expression",language(e){const{firstChild:t}=e;switch(t.type){case"identifier":return languageStringForTemplateTag(t.text);case"member_expression":if(t.startPosition.row===t.endPosition.row)return languageStringForTemplateTag(t.text)}},content(e){const{lastChild:t}=e;if("template_string"===t.type)return t}}),atom.grammars.addInjectionPoint(e,{type:"assignment_expression",language(e){const{firstChild:t}=e;if("member_expression"===t.type&&"innerHTML"===t.lastChild.text)return"html"},content(e){const{lastChild:t}=e;if("template_string"===t.type)return t}}),atom.grammars.addInjectionPoint(e,{type:"regex_pattern",language:e=>"regex",content:e=>e})};const i=/\bstyled\b/i;function languageStringForTemplateTag(e){return i.test(e)?"CSS":e}},"../node_modules/line-ending-selector/lib/main.js":function(e,t,o,n,s,r){Object.defineProperty(e,"__esModule",{value:!0});var i=function(){return function(e,t){if(Array.isArray(e))return e;if(Symbol.iterator in Object(e))return function sliceIterator(e,t){var o=[],n=!0,s=!1,r=void 0;try{for(var i,a=e[Symbol.iterator]();!(n=(i=a.next()).done)&&(o.push(i.value),!t||o.length!==t);n=!0);}catch(e){s=!0,r=e}finally{try{!n&&a.return&&a.return()}finally{if(s)throw r}}return o}(e,t);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}e.activate=function activate(){(f=new(get__atom().CompositeDisposable)).add(atom.commands.add("atom-text-editor",{"line-ending-selector:show":function lineEndingSelectorShow(e){g||(b=new d.default({items:[{name:"LF",value:"\n"},{name:"CRLF",value:"\r\n"}],filterKeyForItem:function filterKeyForItem(e){return e.name},didConfirmSelection:function didConfirmSelection(e){setLineEnding(atom.workspace.getActiveTextEditor(),e.value),g.hide()},didCancelSelection:function didCancelSelection(){g.hide()},elementForItem:function elementForItem(e){var t=get_document().createElement("li");return t.textContent=e.name,t}}),g=atom.workspace.addModalPanel({item:b}),f.add(new(get__atom().Disposable)(function(){b.destroy(),g.destroy(),g=null}))),b.reset(),g.show(),b.focus()},"line-ending-selector:convert-to-LF":function lineEndingSelectorConvertToLF(e){var t=e.target.closest("atom-text-editor");setLineEnding(t.getModel(),"\n")},"line-ending-selector:convert-to-CRLF":function lineEndingSelectorConvertToCRLF(e){var t=e.target.closest("atom-text-editor");setLineEnding(t.getModel(),"\r\n")}}))},e.deactivate=function deactivate(){f.dispose()},e.consumeStatusBar=function consumeStatusBar(e){var t=new u.default,o=null,n=null,s=l.default.debounce(function(e){(function getLineEndings(e){return"function"==typeof e.find?Promise.all([e.find(p),e.find(h)]).then(function(e){var t=i(e,2),o=t[0],n=t[1],s=new Set;return o&&s.add("\n"),n&&s.add("\r\n"),s}):new Promise(function(t){for(var o=new Set,n=0;n<e.getLineCount()-1;n++)o.add(e.lineEndingForRow(n));t(o)})})(e).then(function(o){if(0===o.size){var n=function getDefaultLineEnding(){switch(atom.config.get("line-ending-selector.defaultLineEnding")){case"LF":return"\n";case"CRLF":return"\r\n";case"OS Default":default:return"win32"===c.default.getProcessPlatform()?"\r\n":"\n"}}();e.setPreferredLineEnding(n),o=(new Set).add(n)}t.setLineEndings(o)})},0);f.add(atom.workspace.observeActiveTextEditor(function(e){var r;o&&o.dispose(),e&&e.getBuffer?(r=e.getBuffer(),s(r),o=r.onDidChange(function(e){var o=e.oldText,n=e.newText;t.hasLineEnding("\n")?t.hasLineEnding("\r\n")?o.indexOf("\n")&&s(r):n.indexOf("\r\n")>=0&&s(r):n.indexOf("\n")>=0&&s(r)})):(t.setLineEndings(new Set),o=null),n&&(f.remove(n),n.dispose()),n=atom.tooltips.add(t.element,{title:function title(){return"File uses "+t.description()+" line endings"}}),f.add(n)})),f.add(new(get__atom().Disposable)(function(){o&&o.dispose()})),t.onClick(function(){var e=atom.workspace.getActiveTextEditor();atom.commands.dispatch(atom.views.getView(e),"line-ending-selector:show")});var r=e.addRightTile({item:t,priority:200});f.add(new(get__atom().Disposable)(function(){return r.destroy()}))};var a,l=_interopRequireDefault(s("../node_modules/underscore-plus/lib/underscore-plus.js"));function get__atom(){return a=a||s("atom")}var d=_interopRequireDefault(s("../node_modules/atom-select-list/src/select-list-view.js")),u=_interopRequireDefault(s("../node_modules/line-ending-selector/lib/status-bar-item.js")),c=_interopRequireDefault(s("../node_modules/line-ending-selector/lib/helpers.js")),m=/\r\n|\n/g,p=/(\A|[^\r])\n/g,h=/\r\n/g,f=null,g=null,b=null;function setLineEnding(e,t){if(e&&e.getBuffer){var o=e.getBuffer();o.setPreferredLineEnding(t),o.setText(o.getText().replace(m,t))}}},"../node_modules/link/lib/link.js":function(e,t,o,n,s,r){let i;let{shell:a}={};const l=s("../node_modules/underscore-plus/lib/underscore-plus.js"),d=/markup\.underline\.link/;t.exports={activate(){this.commandDisposable=atom.commands.add("atom-text-editor","link:open",()=>this.openLink())},deactivate(){this.commandDisposable.dispose()},openLink(){const e=atom.workspace.getActiveTextEditor();if(null==e)return;let t=this.linkUnderCursor(e);if(null==t)return;"source.gfm"===e.getGrammar().scopeName&&(t=this.linkForName(e,t));const{protocol:o}=function get_url(){return i=i||s("url")}().parse(t);"http:"!==o&&"https:"!==o&&"atom:"!==o||function get_shell(){return a=a||s("electron").shell}().openExternal(t)},linkUnderCursor(e){const t=e.getCursorBufferPosition(),o=this.linkAtPosition(e,t);return null!=o?o:t.column>0?this.linkAtPosition(e,t.translate([0,-1])):void 0},linkAtPosition(e,t){const o=e.tokenForBufferPosition(t);if(o&&o.value&&o.scopes.some(e=>d.test(e)))return o.value},linkForName(e,t){let o=t;const n=new RegExp(`^\\s*\\[${l.escapeRegExp(t)}\\]\\s*:\\s*(.+)$`,"g");return e.backwardsScanInBufferRange(n,[[0,0],[Infinity,Infinity]],({match:e,stop:t})=>{o=e[1],t()}),o}}},"../node_modules/markdown-preview/lib/main.js":function(e,t,o,n,s,r){(function(){var e,o,n,r,i,a=[].indexOf||function(e){for(var t=0,o=this.length;t<o;t++)if(t in this&&this[t]===e)return t;return-1};function get_CompositeDisposable(){return e=e||s("atom").CompositeDisposable}n=s("../node_modules/fs-plus/lib/fs-plus.js"),o=null,i=null,r=function(e){return null==o&&(o=s("../node_modules/markdown-preview/lib/markdown-preview-view.js")),e instanceof o},t.exports={activate:function(){var e,t,o,n,s,r;for(this.disposables=new(get_CompositeDisposable()),this.commandSubscriptions=new(get_CompositeDisposable()),this.disposables.add(atom.config.observe("markdown-preview.grammars",(r=this,function(e){var t,o,n;for(r.commandSubscriptions.dispose(),r.commandSubscriptions=new(get_CompositeDisposable()),null==e&&(e=[]),o=0,n=(e=e.map(function(e){return e.replace(/\./g," ")})).length;o<n;o++)t=e[o],r.commandSubscriptions.add(atom.commands.add("atom-text-editor[data-grammar='"+t+"']",{"markdown-preview:toggle":function(){return r.toggle()},"markdown-preview:copy-html":{displayName:"Markdown Preview: Copy HTML",didDispatch:function(){return r.copyHTML()}},"markdown-preview:save-as-html":{displayName:"Markdown Preview: Save as HTML",didDispatch:function(){return r.saveAsHTML()}},"markdown-preview:toggle-break-on-single-newline":function(){var e;return e="markdown-preview.breakOnSingleNewline",atom.config.set(e,!atom.config.get(e))},"markdown-preview:toggle-github-style":function(){var e;return e="markdown-preview.useGitHubStyle",atom.config.set(e,!atom.config.get(e))}}))}))),n=this.previewFile.bind(this),t=0,o=(s=["markdown","md","mdown","mkd","mkdown","ron","txt"]).length;t<o;t++)e=s[t],this.disposables.add(atom.commands.add(".tree-view .file .name[data-name$=\\."+e+"]","markdown-preview:preview-file",n));return this.disposables.add(atom.workspace.addOpener(function(e){return function(t){var o,n,s;if(n=(s=t.split("://"))[0],o=s[1],"markdown-preview"===n){try{o=decodeURI(o)}catch(e){return}return o.startsWith("editor/")?e.createMarkdownPreviewView({editorId:o.substring(7)}):e.createMarkdownPreviewView({filePath:o})}}}(this)))},deactivate:function(){return this.disposables.dispose(),this.commandSubscriptions.dispose()},createMarkdownPreviewView:function(e){if(e.editorId||n.isFileSync(e.filePath))return null==o&&(o=s("../node_modules/markdown-preview/lib/markdown-preview-view.js")),new o(e)},toggle:function(){var e,t,o,n;if(r(atom.workspace.getActivePaneItem()))atom.workspace.destroyActivePaneItem();else if(null!=(e=atom.workspace.getActiveTextEditor())&&(t=null!=(o=atom.config.get("markdown-preview.grammars"))?o:[],n=e.getGrammar().scopeName,!(a.call(t,n)<0)))return this.removePreviewForEditor(e)?void 0:this.addPreviewForEditor(e)},uriForEditor:function(e){return"markdown-preview://editor/"+e.id},removePreviewForEditor:function(e){var t,o;return o=this.uriForEditor(e),null!=(t=atom.workspace.paneForURI(o))&&(t.destroyItem(t.itemForURI(o)),!0)},addPreviewForEditor:function(e){var t,o,n;return n=this.uriForEditor(e),o=atom.workspace.getActivePane(),t={searchAllPanes:!0},atom.config.get("markdown-preview.openPreviewInSplitPane")&&(t.split="right"),atom.workspace.open(n,t).then(function(e){if(r(e))return o.activate()})},previewFile:function(e){var t,o,n,s,r;if(o=e.target.dataset.path){for(n=0,s=(r=atom.workspace.getTextEditors()).length;n<s;n++)if((t=r[n]).getPath()===o)return void this.addPreviewForEditor(t);return atom.workspace.open("markdown-preview://"+encodeURI(o),{searchAllPanes:!0})}},copyHTML:function(){var e,t;if(null!=(e=atom.workspace.getActiveTextEditor()))return null==i&&(i=s("../node_modules/markdown-preview/lib/renderer.js")),t=e.getSelectedText()||e.getText(),new Promise(function(o){return i.toHTML(t,e.getPath(),e.getGrammar(),function(e,t){return e?get_console().warn("Copying Markdown as HTML failed",e):(atom.clipboard.write(t),o())})})},saveAsHTML:function(){var e,t,o,n,s,i,l,d;if(e=atom.workspace.getActivePaneItem(),r(e))atom.workspace.getActivePane().saveItemAs(e);else if(null!=(t=atom.workspace.getActiveTextEditor())&&(o=null!=(i=atom.config.get("markdown-preview.grammars"))?i:[],l=t.getGrammar().scopeName,!(a.call(o,l)<0)))return d=this.uriForEditor(t),s=null!=(n=atom.workspace.paneForURI(d))?n.itemForURI(d):void 0,r(s)?n.saveItemAs(s):void 0}}}).call(this)},"../node_modules/metrics/lib/metrics.js":function(e,t,o,n,s,r){let i,{CompositeDisposable:a}={};function get_path(){return i=i||s("path")}const l=s("../node_modules/metrics/lib/reporter.js"),d=s("../node_modules/fs-plus/lib/fs-plus.js"),u=s("../node_modules/metrics/node_modules/grim/lib/grim.js"),{getDomain:c}=s("../node_modules/metrics/lib/repository-helpers.js"),m={"vim-mode:move-up":!0,"vim-mode:move-down":!0,"vim-mode:move-left":!0,"vim-mode:move-right":!0};t.exports={activate({sessionLength:e}){this.subscriptions=new(function get_CompositeDisposable(){return a=a||s("atom").CompositeDisposable}()),this.shouldIncludePanesAndCommands=Math.random()<.05,this.begin(e)},deactivate(){null!=this.subscriptions&&this.subscriptions.dispose()},serialize(){return{sessionLength:Date.now()-this.sessionStart}},provideReporter:()=>({incrementCounter:l.incrementCounter.bind(l),addCustomEvent:l.addCustomEvent.bind(l),sendEvent:l.sendEvent.bind(l),sendTiming:l.sendTiming.bind(l),addTiming:l.addTiming.bind(l),sendException:l.sendException.bind(l)}),begin(e){this.sessionStart=Date.now(),e&&l.sendEvent("window","ended",null,e),l.sendEvent("window","started"),this.subscriptions.add(atom.onDidThrowError(e=>{let t=e;"string"!=typeof e&&(t=e.message),t=(t=h(t)||"Unknown").replace("Uncaught ","").slice(0,150),l.sendException(t)})),this.subscriptions.add(atom.textEditors.observe(e=>{const t=e.getGrammar();t&&l.sendEvent("file","open",t.scopeName)})),this.subscriptions.add(atom.config.onDidChange("core.telemetryConsent",({newValue:e,oldValue:t})=>{"undecided"!==e&&l.sendEvent("setting","core.telemetryConsent",e);const o="limited"!==e;l.getStore().setOptOut(o)})),this.watchActivationOfOptionalPackages(),this.watchLoadingOfUserDefinedKeyBindings(),this.watchUserInitScriptChanges(),this.watchUserStylesheetChanges(),this.watchPaneItems(),this.watchRepositories(),this.watchCommands(),this.watchDeprecations(),null!=atom.getLoadSettings().shellLoadTime&&l.sendTiming("shell","load",atom.getLoadSettings().shellLoadTime),get_process().nextTick(()=>l.sendTiming("core","load",atom.getWindowLoadTime()))},watchActivationOfOptionalPackages(){this.subscriptions.add(atom.packages.onDidActivateInitialPackages(()=>{const e=atom.packages.getActivePackages().filter(e=>!atom.packages.isBundledPackage(e.name));l.sendEvent("package","numberOptionalPackagesActivatedAtStartup",null,e.length)}))},watchLoadingOfUserDefinedKeyBindings(){this.subscriptions.add(atom.keymaps.onDidLoadUserKeymap(()=>{const e=atom.keymaps.getKeyBindings().filter(e=>e.source===atom.keymaps.getUserKeymapPath());l.sendEvent("key-binding","numberUserDefinedKeyBindingsLoadedAtStartup",null,e.length)}))},watchUserInitScriptChanges(){this.subscriptions.add(atom.workspace.observeTextEditors(e=>{if(e.getPath()===atom.getUserInitScriptPath()){const t=e.onDidSave(()=>l.sendEvent("customization","userInitScriptChanged"));this.subscriptions.add(e.onDidDestroy(()=>t.dispose()))}}))},watchUserStylesheetChanges(){this.subscriptions.add(atom.workspace.observeTextEditors(e=>{if(e.getPath()===atom.styles.getUserStyleSheetPath()){const t=e.onDidSave(()=>l.sendEvent("customization","userStylesheetChanged"));this.subscriptions.add(e.onDidDestroy(()=>t.dispose()))}}))},watchPaneItems(){this.subscriptions.add(atom.workspace.onDidAddPaneItem(({item:e})=>{this.shouldIncludePanesAndCommands&&l.sendPaneItem(e)}))},watchRepositories(){null!=atom.project.observeRepositories&&this.subscriptions.add(atom.project.observeRepositories(e=>{const t=c(e.getOriginURL());l.addCustomEvent("repository",{action:"open",domain:t})}))},watchCommands(){this.subscriptions.add(atom.commands.onWillDispatch(e=>{if(!this.shouldIncludePanesAndCommands)return;const{type:t}=e;null!=e.detail&&e.detail.jQueryTrigger||t.startsWith("core:")||t.startsWith("editor:")||t.includes(":")&&(t in m||l.sendCommand(t))}))},watchDeprecations(){let e;this.deprecationCache={},this.packageVersionCache={},atom.packages.onDidActivateInitialPackages(()=>{e=atom.packages.getLoadedPackages();for(let t of e)this.packageVersionCache[t.name]=f(t);setImmediate(()=>{for(let e of u.getDeprecations())this.reportDeprecation(e)})}),atom.packages.onDidLoadPackage(e=>{this.packageVersionCache[e.name]||(this.packageVersionCache[e.name]=f(e))}),u.on("updated",e=>{setImmediate(()=>this.reportDeprecation(e))})},reportDeprecation(e){const t=e.getMessage().slice(0,500);for(let o in e.stacks){const n=e.stacks[o],s=n.metadata&&n.metadata.packageName?n.metadata.packageName:(this.getPackageName(n)||"").toLowerCase();if(!s)continue;if(!this.packageVersionCache[s]){const e=atom.packages.getLoadedPackage(s);this.packageVersionCache[s]=f(e)}const r=`${s}@${this.packageVersionCache[s]}`;null==this.deprecationCache[r+t]&&(this.deprecationCache[r+t]=!0,l.sendEvent("deprecation-v3",r,t))}},getFileNameFromCallSite:e=>null!=e.fileName?e.fileName:e.getFileName(),getPackageName(e){const t=this.getPackagePathsByPackageName();for(let o=0;o<e.length;o++){const n=this.getFileNameFromCallSite(e[o]);if(!n)return;if(!n.includes(get_path().sep+"node_modules"+get_path().sep)){for(let e in t){const o=t[e],s=get_path().relative(o,n);if(!/^\.\./.test(s))return e}if(atom.getUserInitScriptPath()===n)return"init-script"}}},getPackagePathsByPackageName(){if(null!=this.packagePathsByPackageName)return this.packagePathsByPackageName;this.packagePathsByPackageName={};for(let e of atom.packages.getLoadedPackages())this.packagePathsByPackageName[e.name]=e.path,(e.path.indexOf(".atom/dev/packages")>-1||e.path.indexOf(".atom/packages")>-1)&&(this.packagePathsByPackageName[e.name]=d.absolute(e.path));return this.packagePathsByPackageName}};const p=/'?((\/|\\|[a-z]:\\)[^\s']+)+'?/gi,h=e=>e.replace(p,"<path>"),f=function(e){return e&&e.metadata&&e.metadata.version||"unknown"}},"../node_modules/notifications/lib/main.js":function(e,t,o,n,s,r){(function(){var e,o,n,r,i,a,l,d,u;function get_ref(){return u=u||s("atom")}l=s("../node_modules/fs-plus/lib/fs-plus.js"),a=null,n=s("../node_modules/notifications/lib/notification-element.js"),i=s("../node_modules/notifications/lib/notifications-log.js"),r={isInitialized:!1,subscriptions:null,duplicateTimeDelay:500,lastNotification:null,activate:function(t){var o,n,r,a,l;for(s("../node_modules/notifications/lib/command-logger.js").start(),this.subscriptions=new(function get_CompositeDisposable(){return e=e||get_ref().CompositeDisposable}()),o=0,n=(a=atom.notifications.getNotifications()).length;o<n;o++)r=a[o],this.addNotificationView(r);return this.subscriptions.add(atom.notifications.onDidAddNotification((l=this,function(e){return l.addNotificationView(e)}))),this.subscriptions.add(atom.onWillThrowError(function(e){var t,o,n,s,r,i,a;if(n=e.message,a=e.url,t=e.line,r=e.originalError,i=e.preventDefault,"BufferedProcessError"===r.name)return n=n.replace("Uncaught BufferedProcessError: ",""),atom.notifications.addError(n,{dismissable:!0});if("ENOENT"===r.code&&!/\/atom/i.test(n)&&(o=/spawn (.+) ENOENT/.exec(n)))return n="'"+o[1]+"' could not be spawned.\nIs it installed and on your path?\nIf so please open an issue on the package spawning the process.",atom.notifications.addError(n,{dismissable:!0});if(!atom.inDevMode()||atom.config.get("notifications.showErrorsInDevMode")){if(i(),r.stack&&!d(r.stack))return;return s={detail:a+":"+t,stack:r.stack,dismissable:!0},atom.notifications.addFatalError(n,s)}})),this.subscriptions.add(atom.commands.add("atom-workspace","core:cancel",function(){var e,t,o,n;for(n=[],e=0,t=(o=atom.notifications.getNotifications()).length;e<t;e++)r=o[e],n.push(r.dismiss());return n})),this.subscriptions.add(atom.config.observe("notifications.defaultTimeout",function(e){return function(t){return e.visibilityDuration=t}}(this))),atom.inDevMode()&&this.subscriptions.add(atom.commands.add("atom-workspace","notifications:trigger-error",function(){var e,t;try{return abc+2}catch(o){return t={detail:(e=o).stack.split("\n")[1],stack:e.stack,dismissable:!0},atom.notifications.addFatalError("Uncaught "+e.stack.split("\n")[0],t)}})),null!=this.notificationsLog&&this.addNotificationsLogSubscriptions(),this.subscriptions.add(atom.workspace.addOpener(function(e){return function(t){if(t===i.prototype.getURI())return e.createLog()}}(this))),this.subscriptions.add(atom.commands.add("atom-workspace","notifications:toggle-log",function(){return atom.workspace.toggle(i.prototype.getURI())}))},deactivate:function(){var e,t,o;return this.subscriptions.dispose(),null!=(e=this.notificationsElement)&&e.remove(),null!=(t=this.notificationsPanel)&&t.destroy(),null!=(o=this.notificationsLog)&&o.destroy(),this.subscriptions=null,this.notificationsElement=null,this.notificationsPanel=null,this.isInitialized=!1},initializeIfNotInitialized:function(){var e;if(!this.isInitialized)return this.subscriptions.add(atom.views.addViewProvider(function get_Notification(){return o=o||get_ref().Notification}(),(e=this,function(t){return new n(t,e.visibilityDuration)}))),this.notificationsElement=get_document().createElement("atom-notifications"),atom.views.getView(atom.workspace).appendChild(this.notificationsElement),this.isInitialized=!0},createLog:function(e){return this.notificationsLog=new i(this.duplicateTimeDelay,null!=e?e.typesHidden:void 0),null!=this.subscriptions&&this.addNotificationsLogSubscriptions(),this.notificationsLog},addNotificationsLogSubscriptions:function(){var e;return this.subscriptions.add(this.notificationsLog.onDidDestroy((e=this,function(){return e.notificationsLog=null}))),this.subscriptions.add(this.notificationsLog.onItemClick(function(e){return function(t){var o;if((o=atom.views.getView(t)).makeDismissable(),o.element.classList.contains("remove"))return o.element.classList.remove("remove"),e.notificationsElement.appendChild(o.element),t.dismissed=!1,t.setDisplayed(!0)}}(this)))},addNotificationView:function(e){var t,o;if(null!=e&&(this.initializeIfNotInitialized(),!e.wasDisplayed()))return null!=this.lastNotification?e.getTimestamp()-this.lastNotification.getTimestamp()<this.duplicateTimeDelay&&e.isEqual(this.lastNotification)||(this.notificationsElement.appendChild(atom.views.getView(e).element),null!=(t=this.notificationsLog)&&t.addNotification(e)):(this.notificationsElement.appendChild(atom.views.getView(e).element),null!=(o=this.notificationsLog)&&o.addNotification(e)),e.setDisplayed(!0),this.lastNotification=e}},d=function(e){var t,o,n,r;for(null==a&&(a=s("../node_modules/stacktrace-parser/dist/stack-trace-parser.cjs.js")),o=0,n=(r=a.parse(e)).length;o<n;o++)if("<embedded>"===(t=r[o].file)||l.isAbsolute(t))return!0;return!1},t.exports=r}).call(this)},"../node_modules/open-on-github/lib/main.js":function(e,t,o,n,s,r){let{Disposable:i}={};const a=s("../node_modules/open-on-github/lib/github-file.js");function getActivePath(){const e=atom.workspace.getActivePaneItem();if(e&&"function"==typeof e.getPath)return e.getPath()}function getSelectedRange(){const e=atom.workspace.getActivePaneItem();if(e&&"function"==typeof e.getSelectedBufferRange)return e.getSelectedBufferRange()}t.exports={activate(){this.commandsSubscription=new(function get_Disposable(){return i=i||s("atom").Disposable}()),this.commandsSubscription=atom.commands.add("atom-pane",{"open-on-github:file":()=>{const e=getActivePath();e&&a.fromPath(e).open(getSelectedRange())},"open-on-github:file-on-master":()=>{const e=getActivePath();e&&a.fromPath(e).openOnMaster(getSelectedRange())},"open-on-github:blame":()=>{const e=getActivePath();e&&a.fromPath(e).blame(getSelectedRange())},"open-on-github:history":()=>{const e=getActivePath();e&&a.fromPath(e).history()},"open-on-github:issues":()=>{const e=getActivePath();e&&a.fromPath(e).openIssues()},"open-on-github:pull-requests":()=>{const e=getActivePath();if(e)return a.fromPath(e).openPullRequests()},"open-on-github:copy-url":()=>{const e=getActivePath();e&&a.fromPath(e).copyURL(getSelectedRange())},"open-on-github:branch-compare":()=>{const e=getActivePath();e&&a.fromPath(e).openBranchCompare()},"open-on-github:repository":()=>{const e=getActivePath();e&&a.fromPath(e).openRepository()}})},deactivate(){this.commandsSubscription.dispose()}}},"../node_modules/package-generator/lib/main.js":function(e,t,o,n,s,r){const i=s("../node_modules/package-generator/lib/package-generator-view.js");t.exports={activate(){this.view=new i},deactivate(){this.view&&this.view.destroy()}}},"../node_modules/settings-view/lib/main.js":function(e,t,o,n,s,r){let i=null,a=null,l=null;const d=s("../node_modules/settings-view/lib/package-manager.js");let u=null;const c={getSnippets:()=>atom.config.scopedSettingsStore.propertySets},m="atom://config";t.exports={handleURI(e){switch(e.pathname){case"/show-package":this.showPackage(e.query.package)}},showPackage(e){atom.workspace.open(`atom://config/packages/${e}`)},activate(){atom.workspace.addOpener(e=>{if(e.startsWith(m)){if(null==a||a.destroyed)a=this.createSettingsView({uri:e});else{const e=atom.workspace.paneForItem(a);e&&e.activate()}return a.showPanelForURI(e),a}}),atom.commands.add("atom-workspace",{"settings-view:open"(){atom.workspace.open(m)},"settings-view:core"(){atom.workspace.open("atom://config/core")},"settings-view:editor"(){atom.workspace.open("atom://config/editor")},"settings-view:show-keybindings"(){atom.workspace.open("atom://config/keybindings")},"settings-view:change-themes"(){atom.workspace.open("atom://config/themes")},"settings-view:install-packages-and-themes"(){atom.workspace.open("atom://config/install")},"settings-view:view-installed-themes"(){atom.workspace.open("atom://config/themes")},"settings-view:uninstall-themes"(){atom.workspace.open("atom://config/themes")},"settings-view:view-installed-packages"(){atom.workspace.open("atom://config/packages")},"settings-view:uninstall-packages"(){atom.workspace.open("atom://config/packages")},"settings-view:check-for-package-updates"(){atom.workspace.open("atom://config/updates")}}),"win32"===get_process().platform&&null!=s("atom").WinShell&&atom.commands.add("atom-workspace",{"settings-view:system"(){atom.workspace.open("atom://config/system")}}),localStorage.getItem("hasSeenDeprecatedNotification")||(null==u&&(u=new d),u.getInstalled().then(e=>{e.user&&e.user.length&&this.showDeprecatedNotification(e)}))},deactivate(){a&&a.destroy(),l&&l.destroy(),a=null,u=null,l=null},consumeStatusBar(e){null==u&&(u=new d),u.getOutdated().then(t=>{if(u){const o=s("../node_modules/settings-view/lib/package-updates-status-view.js");(l=new o).initialize(e,u,t)}})},consumeSnippets(e){"function"==typeof e.getUnparsedSnippets&&(c.getSnippets=e.getUnparsedSnippets.bind(e)),"function"==typeof e.getUserSnippetsPath&&(c.getUserSnippetsPath=e.getUserSnippetsPath.bind(e))},createSettingsView:e=>(null==i&&(i=s("../node_modules/settings-view/lib/settings-view.js")),null==u&&(u=new d),e.packageManager=u,e.snippetsProvider=c,a=new i(e)),showDeprecatedNotification(e){localStorage.setItem("hasSeenDeprecatedNotification",!0);const t=e.user.filter(({name:e,version:t})=>atom.packages.isDeprecatedPackage(e,t));if(!t.length)return;let o="were",n="have",s="packages";1===e.length&&(s="package",o="was",n="has");const r=atom.notifications.addWarning(`${t.length} ${s} ${n} deprecations and ${o} not loaded.`,{description:"This message will show only one time. Deprecated packages can be viewed in the settings view.",detail:t.map(e=>e.name).join(", "),dismissable:!0,buttons:[{text:"View Deprecated Packages",onDidClick(){atom.commands.dispatch(atom.views.getView(atom.workspace),"settings-view:view-installed-packages"),r.dismiss()}}]})}}},"../node_modules/snippets/lib/snippets.js":function(e,t,o,n,s,r){(function(){var e,o,n,r,i,a,l,d,u,c,m,p,h,f,g,b=[].slice;function get_path(){return f=f||s("path")}function get_ref(){return g=g||s("atom")}function get_CompositeDisposable(){return o=o||get_ref().CompositeDisposable}c=s("../node_modules/underscore-plus/lib/underscore-plus.js"),m=s("../node_modules/async/lib/async.js"),e=s("../node_modules/season/lib/cson.js"),p=s("../node_modules/fs-plus/lib/fs-plus.js"),l=s("../node_modules/scoped-property-store/lib/scoped-property-store.js"),d=s("../node_modules/snippets/lib/snippet.js"),u=s("../node_modules/snippets/lib/snippet-expansion.js"),r=s("../node_modules/snippets/lib/editor-store.js"),h=s("../node_modules/snippets/lib/helpers.js").getPackageRoot,t.exports={activate:function(){var e,t;return this.loaded=!1,this.userSnippetsPath=null,this.snippetIdCounter=0,this.snippetsByPackage=new Map,this.parsedSnippetsById=new Map,this.editorMarkerLayers=new WeakMap,this.scopedPropertyStore=new l,this.disabledSnippetsScopedPropertyStore=new l,this.subscriptions=new(get_CompositeDisposable()),this.subscriptions.add(atom.workspace.addOpener((t=this,function(e){if("atom://.atom/snippets"===e)return atom.workspace.openTextFile(t.getUserSnippetsPath())}))),this.loadAll(),this.watchUserSnippets(function(e){return function(t){return e.subscriptions.add(t)}}(this)),this.subscriptions.add(atom.config.onDidChange("core.packagesWithSnippetsDisabled",function(e){return function(t){var o,n;return o=t.newValue,n=t.oldValue,e.handleDisabledPackagesDidChange(o,n)}}(this))),e=this,this.subscriptions.add(atom.commands.add("atom-text-editor",{"snippets:expand":function(t){var o;return o=this.getModel(),e.snippetToExpandUnderCursor(o)?(e.clearExpansions(o),e.expandSnippetsUnderCursors(o)):t.abortKeyBinding()},"snippets:next-tab-stop":function(t){var o;if(o=this.getModel(),!e.goToNextTabStop(o))return t.abortKeyBinding()},"snippets:previous-tab-stop":function(t){var o;if(o=this.getModel(),!e.goToPreviousTabStop(o))return t.abortKeyBinding()},"snippets:available":function(t){var o,n;return n=this.getModel(),o=s("../node_modules/snippets/lib/snippets-available.js"),null==e.availableSnippetsView&&(e.availableSnippetsView=new o(e)),e.availableSnippetsView.toggle(n)}}))},deactivate:function(){var e,t;return null!=(e=this.emitter)&&e.dispose(),this.emitter=null,this.editorSnippetExpansions=null,atom.config.transact((t=this,function(){return t.subscriptions.dispose()}))},getUserSnippetsPath:function(){return null!=this.userSnippetsPath?this.userSnippetsPath:(this.userSnippetsPath=e.resolve(get_path().join(atom.getConfigDirPath(),"snippets")),null==this.userSnippetsPath&&(this.userSnippetsPath=get_path().join(atom.getConfigDirPath(),"snippets.cson")),this.userSnippetsPath)},loadAll:function(){return this.loadBundledSnippets((e=this,function(t){return e.loadPackageSnippets(function(o){return e.loadUserSnippets(function(n){return atom.config.transact(function(){var s,r,i,a,l,d;for(r=0,i=(a=[t,o,n]).length;r<i;r++)for(s in l=a[r])d=l[s],e.add(s,d)}),e.doneLoading()})})}));var e},loadBundledSnippets:function(t){var o;return o=e.resolve(get_path().join(h(),"lib","snippets")),this.loadSnippetsFile(o,function(e){var n;return(n={})[o]=e,t(n)})},loadUserSnippets:function(e){var t,o;return t=this.getUserSnippetsPath(),p.stat(t,(o=this,function(n,s){return(null!=s?s.isFile():void 0)?o.loadSnippetsFile(t,function(o){var n;return(n={})[t]=o,e(n)}):e({})}))},watchUserSnippets:function(e){var t,o;return t=this.getUserSnippetsPath(),p.stat(t,(o=this,function(s,r){var i,l,d;if(null!=r?r.isFile():void 0){d=new(get_CompositeDisposable()),l=new(function get_File(){return a=a||get_ref().File}())(t);try{d.add(l.onDidChange(function(){return o.handleUserSnippetsDidChange()})),d.add(l.onDidDelete(function(){return o.handleUserSnippetsDidChange()})),d.add(l.onDidRename(function(){return o.handleUserSnippetsDidChange()}))}catch(e){i="Unable to watch path: `snippets.cson`. Make sure you have permissions\nto the `~/.atom` directory and `"+t+"`.\n\nOn linux there are currently problems with watch sizes. See\n[this document][watches] for more info.\n[watches]:https://github.com/atom/atom/blob/master/docs/build-instructions/linux.md#typeerror-unable-to-watch-path",atom.notifications.addError(i,{dismissable:!0})}return e(d)}return e(new(function get_Disposable(){return n=n||get_ref().Disposable}())(function(){}))}))},handleUserSnippetsDidChange:function(){var e,t;return e=this.getUserSnippetsPath(),atom.config.transact((t=this,function(){return t.clearSnippetsForPath(e),t.loadSnippetsFile(e,function(o){return t.add(e,o)})}))},handleDisabledPackagesDidChange:function(e,t){var o,n,s,r,i,a,l,d;for(a=[],l=[],null==t&&(t=[]),null==e&&(e=[]),o=0,s=t.length;o<s;o++)i=t[o],e.includes(i)||a.push(i);for(n=0,r=e.length;n<r;n++)i=e[n],t.includes(i)||l.push(i);return atom.config.transact((d=this,function(){var e,t,o,n,s;for(e=0,o=l.length;e<o;e++)i=l[e],d.removeSnippetsForPackage(i);for(s=[],t=0,n=a.length;t<n;t++)i=a[t],s.push(d.addSnippetsForPackage(i));return s}))},addSnippetsForPackage:function(e){var t,o,n,s;for(t in o=[],n=this.snippetsByPackage.get(e))s=n[t],o.push(this.add(t,s));return o},removeSnippetsForPackage:function(e){var t,o,n;for(t in n=this.snippetsByPackage.get(e),this.addSnippetsInDisabledPackage(n),o=[],n)n[t],o.push(this.clearSnippetsForPath(t));return o},loadPackageSnippets:function(e){var t,o,n,s,r;return t=atom.config.get("core.packagesWithSnippetsDisabled")||[],n=atom.packages.getLoadedPackages().sort(function(e,t){return/\/app\.asar\/node_modules\//.test(e.path)?-1:1}),s=function(){var e,t,s;for(s=[],e=0,t=n.length;e<t;e++)o=n[e],s.push(get_path().join(o.path,"snippets"));return s}(),m.map(s,this.loadSnippetsDirectory.bind(this),(r=this,function(o,s){var i,a,l,d,u,m,p;for(i=[],a=0,d=(p=function(){var e;for(l in e=[],s)m=s[l],e.push({result:m,pack:n[l]});return e}()).length;a<d;a++)u=p[a],0!==Object.keys(u.result).length&&(r.snippetsByPackage.set(u.pack.name,u.result),t.includes(u.pack.name)?r.addSnippetsInDisabledPackage(u.result):i.push(u.result));return e(c.extend.apply(c,[{}].concat(b.call(i))))}))},doneLoading:function(){return this.loaded=!0,this.getEmitter().emit("did-load-snippets")},onDidLoadSnippets:function(e){return this.getEmitter().on("did-load-snippets",e)},getEmitter:function(){return null!=this.emitter?this.emitter:this.emitter=new(function get_Emitter(){return i=i||get_ref().Emitter}())},loadSnippetsDirectory:function(e,t){return p.isDirectory(e,(o=this,function(n){return n?p.readdir(e,function(n,s){return n?(get_console().warn("Error reading snippets directory "+e,n),t(null,{})):m.map(s,function(t,n){var s;return s=get_path().join(e,t),o.loadSnippetsFile(s,function(e){return n(null,{filePath:s,snippets:e})})},function(e,o){var n,s,r,i,a,l;for(l={},s=0,r=o.length;s<r;s++)n=(i=o[s]).filePath,a=i.snippets,l[n]=a;return t(null,l)})}):t(null,{})}));var o},loadSnippetsFile:function(t,o){return e.isObjectPath(t)?e.readFile(t,{allowDuplicateKeys:!1},function(e,n){var s;return null==n&&(n={}),null!=e&&(get_console().warn("Error reading snippets file '"+t+"': "+(null!=(s=e.stack)?s:e)),atom.notifications.addError("Failed to load snippets from '"+t+"'",{detail:e.message,dismissable:!0})),o(n)}):o({})},add:function(e,t,o){var n,s,r,i,a,l,d;for(a in null==o&&(o=!1),t){for(r in d={},l=t[a])i=(n=l[r]).prefix,s=n.body,n.name=r,n.id=this.snippetIdCounter++,"string"==typeof s?d[i]=n:null==s&&(d[i]=null);this.storeUnparsedSnippets(d,e,a,o)}},addSnippetsInDisabledPackage:function(e){var t,o,n;for(t in o=[],e)n=e[t],o.push(this.add(t,n,!0));return o},getScopeChain:function(e){var t;return null==(t=null!=e&&"function"==typeof e.getScopesArray?e.getScopesArray():void 0)&&(t=e),t.map(function(e){return"."!==e[0]&&(e="."+e),e}).join(" ")},storeUnparsedSnippets:function(e,t,o,n){var s;return null==n&&(n=!1),(s={})[o]={snippets:e},(n?this.disabledSnippetsScopedPropertyStore:this.scopedPropertyStore).addProperties(t,s,{priority:this.priorityForSource(t)})},clearSnippetsForPath:function(e){var t,o,n,s;for(s in this.scopedPropertyStore.propertiesForSource(e)){for(o in n=this.scopedPropertyStore.propertiesForSourceAndSelector(e,s))t=n[o],this.parsedSnippetsById.delete(t.id);this.scopedPropertyStore.removePropertiesForSourceAndSelector(e,s)}},parsedSnippetsForScopes:function(e){var t,o,n,s,r,i,a;if(a=this.scopedPropertyStore.getPropertyValue(this.getScopeChain(e),"snippets"),null!=(n="function"==typeof(o=atom.config).getLegacyScopeDescriptorForNewScopeDescriptor?o.getLegacyScopeDescriptorForNewScopeDescriptor(e):void 0)&&(i=this.scopedPropertyStore.getPropertyValue(this.getScopeChain(n),"snippets")),r={},null!=a)for(s in a)"string"==typeof(null!=(t=a[s])?t.body:void 0)&&(r[s]=this.getParsedSnippet(t));if(null!=i)for(s in i)t=i[s],null==r[s]&&"string"==typeof(null!=t?t.body:void 0)&&(r[s]=this.getParsedSnippet(t));return r},getParsedSnippet:function(e){var t,o,n,s,r,i,a,l,u,c,m;return null==(m=this.parsedSnippetsById.get(e.id))&&(r=e.id,u=e.prefix,l=e.name,t=e.body,o=e.bodyTree,n=e.description,s=e.descriptionMoreURL,c=e.rightLabelHTML,i=e.leftLabel,a=e.leftLabelHTML,null==o&&(o=this.getBodyParser().parse(t)),m=new d({id:r,name:l,prefix:u,bodyTree:o,description:n,descriptionMoreURL:s,rightLabelHTML:c,leftLabel:i,leftLabelHTML:a,bodyText:t}),this.parsedSnippetsById.set(e.id,m)),m},priorityForSource:function(e){return e===this.getUserSnippetsPath()?1e3:0},getBodyParser:function(){return null!=this.bodyParser?this.bodyParser:this.bodyParser=s("../node_modules/snippets/lib/snippet-body-parser.js")},getPrefixText:function(e,t){var o,n,s,r,i,a,l,d,u,c,m,p,h;for(p=this.wordRegexForSnippets(e),c=(d=[])[0],m=d[1],r=0,i=(u=t.getCursors()).length;r<i;r++){if(a=(o=u[r]).getBufferPosition(),l=o.getBeginningOfCurrentWordBufferPosition({wordRegex:p}),n=t.getTextInRange([l,a]),null!=c&&n!==c)return null;if(c=n,h=o.getBeginningOfCurrentWordBufferPosition(),s=t.getTextInRange([h,a]),null!=m&&s!==m)return null;m=s}return{snippetPrefix:c,wordPrefix:m}},wordRegexForSnippets:function(e){var t,o,n,s,r;for(n in r={},e)for(t=0,o=n.length;t<o;t++)r[n[t]]=!0;return s=Object.keys(r).join(""),new RegExp("["+c.escapeRegExp(s)+"]+")},snippetForPrefix:function(e,t,o){var n,s,r;for(r in n=null,e)s=e[r],t.endsWith(r)&&o.length<=r.length&&(null==n||r.length>n.prefix.length)&&(n=s);return n},getSnippets:function(e){return this.parsedSnippetsForScopes(e.getLastCursor().getScopeDescriptor())},snippetToExpandUnderCursor:function(e){var t,o;return!!e.getLastSelection().isEmpty()&&(o=this.getSnippets(e),!c.isEmpty(o)&&((t=this.getPrefixText(o,e))?this.snippetForPrefix(o,t.snippetPrefix,t.wordPrefix):void 0))},expandSnippetsUnderCursors:function(e){var t,o;return!!(t=this.snippetToExpandUnderCursor(e))&&(this.getStore(e).observeHistory({undo:(o=this,function(t){return o.onUndoOrRedo(e,t,!0)}),redo:function(t){return function(o){return t.onUndoOrRedo(e,o,!1)}}(this)}),this.findOrCreateMarkerLayer(e),e.transact(function(o){return function(){var n,s,r,i,a,l;for(i=0,a=(r=e.getCursors()).length;i<a;i++)l=(s=(n=r[i]).getBufferPosition()).translate([0,-t.prefix.length],[0,0]),n.selection.setBufferRange([l,s]),o.insert(t,e,n)}}(this)),!0)},goToNextTabStop:function(e){var t,o,n,s,r;for(s=!1,o=0,n=(r=this.getExpansions(e)).length;o<n;o++)(null!=(t=r[o])?t.goToNextTabStop():void 0)&&(s=!0);return s},goToPreviousTabStop:function(e){var t,o,n,s,r;for(s=!1,o=0,n=(r=this.getExpansions(e)).length;o<n;o++)(null!=(t=r[o])?t.goToPreviousTabStop():void 0)&&(s=!0);return s},getStore:function(e){return r.findOrCreate(e)},createMarkerLayer:function(e){return this.editorMarkerLayers.set(e,e.addMarkerLayer({maintainHistory:!0}))},findOrCreateMarkerLayer:function(e){var t;return null==(t=this.editorMarkerLayers.get(e))&&(t=e.addMarkerLayer({maintainHistory:!0}),this.editorMarkerLayers.set(e,t)),t},getExpansions:function(e){return this.getStore(e).getExpansions()},clearExpansions:function(e){var t;return(t=this.getStore(e)).clearExpansions(),t.stopObserving(),t.stopObservingHistory()},addExpansion:function(e,t){return this.getStore(e).addExpansion(t)},textChanged:function(e,t){var o,n;if(n=this.getStore(e),0!==(o=n.getExpansions()).length&&!o[0].isIgnoringBufferChanges)return this.ignoringTextChangesForEditor(e,function(){return e.transact(function(){var e,n,s,r;for(r=[],n=0,s=o.length;n<s;n++)e=o[n],r.push(e.textChanged(t));return r})}),this.makeCheckpoint(e)},ignoringTextChangesForEditor:function(e,t){return this.stopObservingEditor(e),t(),this.observeEditor(e)},observeEditor:function(e){return this.getStore(e).observe((t=this,function(o){return t.textChanged(e,o)}));var t},stopObservingEditor:function(e){return this.getStore(e).stopObserving()},makeCheckpoint:function(e){return this.getStore(e).makeCheckpoint()},insert:function(e,t,o){var n;return null==t&&(t=atom.workspace.getActiveTextEditor()),null==o&&(o=t.getLastCursor()),"string"==typeof e&&(n=this.getBodyParser().parse(e),e=new d({name:"__anonymous",prefix:"",bodyTree:n,bodyText:e})),new u(e,t,o,this)},getUnparsedSnippets:function(){var e,t;return t=[],(e=function(e){var o,n,s,r,i;for(i=[],o=0,s=e.length;o<s;o++)n=e[o],(r=c.deepClone(n)).selectorString=n.selector.toString(),i.push(t.push(r));return i})(this.scopedPropertyStore.propertySets),e(this.disabledSnippetsScopedPropertyStore.propertySets),t},provideSnippets:function(){return{bundledSnippetsLoaded:(e=this,function(){return e.loaded}),insertSnippet:this.insert.bind(this),snippetsForScopes:this.parsedSnippetsForScopes.bind(this),getUnparsedSnippets:this.getUnparsedSnippets.bind(this),getUserSnippetsPath:this.getUserSnippetsPath.bind(this)};var e},onUndoOrRedo:function(e,t){var o,n,s,r,i;for(i=[],s=0,r=(o=this.getExpansions(e)).length;s<r;s++)n=o[s],i.push(n.onUndoOrRedo(t));return i}}}).call(this)},"../node_modules/spell-check/lib/main.js":function(e,t,o,n,s,r){(function(){var e,o,n,r=[].indexOf||function(e){for(var t=0,o=this.length;t<o;t++)if(t in this&&this[t]===e)return t;return-1};o=null,n={},t.exports={activate:function(){var t,r;return this.subs=new(function get_CompositeDisposable(){return e=e||s("atom").CompositeDisposable}()),this.globalArgs={locales:atom.config.get("spell-check.locales"),localePaths:atom.config.get("spell-check.localePaths"),useLocales:atom.config.get("spell-check.useLocales"),knownWords:atom.config.get("spell-check.knownWords"),addKnownWords:atom.config.get("spell-check.addKnownWords"),checkerPaths:[]},t=this.getInstance(this.globalArgs),this.excludedScopeRegexLists=[],this.subs.add(atom.config.observe("spell-check.excludedScopes",(r=this,function(e){return r.excludedScopeRegexLists=e.map(function(e){var t,o,n,s,r;for(r=[],o=0,n=(s=e.split(/\s+/)[0].split(".")).length;o<n;o++)(t=s[o])&&r.push(new RegExp("\\b"+t+"\\b"));return r}),r.updateViews()}))),this.subs.add(atom.config.onDidChange("spell-check.locales",function(e){return function(o){var n;return n=o.newValue,o.oldValue,e.globalArgs.locales=n,t.setGlobalArgs(e.globalArgs)}}(this))),this.subs.add(atom.config.onDidChange("spell-check.localePaths",function(e){return function(o){var n;return n=o.newValue,o.oldValue,e.globalArgs.localePaths=n,t.setGlobalArgs(e.globalArgs)}}(this))),this.subs.add(atom.config.onDidChange("spell-check.useLocales",function(e){return function(o){var n;return n=o.newValue,o.oldValue,e.globalArgs.useLocales=n,t.setGlobalArgs(e.globalArgs)}}(this))),this.subs.add(atom.config.onDidChange("spell-check.knownWords",function(e){return function(o){var n;return n=o.newValue,o.oldValue,e.globalArgs.knownWords=n,t.setGlobalArgs(e.globalArgs)}}(this))),this.subs.add(atom.config.onDidChange("spell-check.addKnownWords",function(e){return function(o){var n;return n=o.newValue,o.oldValue,e.globalArgs.addKnownWords=n,t.setGlobalArgs(e.globalArgs)}}(this))),this.subs.add(atom.commands.add("atom-workspace",{"spell-check:toggle":function(e){return function(){return e.toggle()}}(this)})),this.viewsByEditor=new WeakMap,this.contextMenuEntries=[],this.subs.add(atom.workspace.observeTextEditors(function(e){return function(r){var i,a,l;if(!(e.viewsByEditor.has(r)||r.getBuffer().getLength()>2097152))return null==o&&(o=s("../node_modules/spell-check/lib/spell-check-view.js")),l=new o(r,e,t),a=r.id,n[a]={view:l,active:!0,editor:r},i=r.onDidDestroy(function(){return l.destroy(),delete n[a],e.subs.remove(i)}),e.subs.add(i),e.viewsByEditor.set(r,l)}}(this)))},deactivate:function(){var e,t;for(e in null!=(t=this.instance)&&t.deactivate(),this.instance=null,n)n[e].view.destroy();return n={},this.viewsByEditor=new WeakMap,this.subs.dispose()},consumeSpellCheckers:function(e){var t,o,n,s,i;for(e instanceof Array||(e=[e]),i=[],o=0,n=e.length;o<n;o++)t=e[o],r.call(this.globalArgs.checkerPaths,t)<0?(null!=(s=this.instance)&&s.addCheckerPath(t),i.push(this.globalArgs.checkerPaths.push(t))):i.push(void 0);return i},misspellingMarkersForEditor:function(e){return this.viewsByEditor.get(e).markerLayer.getMarkers()},updateViews:function(){var e,t,o;for(e in t=[],n)(o=n[e]).active?t.push(o.view.updateMisspellings()):t.push(void 0);return t},getInstance:function(e){var t,o,n,r,i;if(!this.instance)for(t=s("../node_modules/spell-check/lib/spell-check-manager.js"),this.instance=t,this.instance.setGlobalArgs(e),n=0,r=(i=e.checkerPaths).length;n<r;n++)o=i[n],this.instance.addCheckerPath(o);return this.instance},toggle:function(){var e;if(atom.workspace.getActiveTextEditor()&&(e=atom.workspace.getActiveTextEditor().id,n.hasOwnProperty(e)))return n[e].active?(n[e].active=!1,n[e].view.unsubscribeFromBuffer()):(n[e].active=!0,n[e].view.subscribeToBuffer())}}}).call(this)},"../node_modules/status-bar/lib/main.js":function(e,t,o,n,s,r){(function(){var e,o,n,r,i,a,l,d,u,c,m=[].slice;function get_ref(){return c=c||s("atom")}a=s("../node_modules/status-bar/node_modules/grim/lib/grim.js"),u=s("../node_modules/status-bar/lib/status-bar-view.js"),r=s("../node_modules/status-bar/lib/file-info-view.js"),o=s("../node_modules/status-bar/lib/cursor-position-view.js"),d=s("../node_modules/status-bar/lib/selection-count-view.js"),i=s("../node_modules/status-bar/lib/git-view.js"),l=s("../node_modules/status-bar/lib/launch-mode-view.js"),t.exports={activate:function(){var t,s,a,c,m;return this.emitters=new(function get_Emitter(){return n=n||get_ref().Emitter}()),this.subscriptions=new(function get_CompositeDisposable(){return e=e||get_ref().CompositeDisposable}()),this.statusBar=new u,this.attachStatusBar(),this.subscriptions.add(atom.config.onDidChange("status-bar.fullWidth",(m=this,function(){return m.attachStatusBar()}))),this.updateStatusBarVisibility(),this.statusBarVisibilitySubscription=atom.config.observe("status-bar.isVisible",function(e){return function(){return e.updateStatusBarVisibility()}}(this)),atom.commands.add("atom-workspace","status-bar:toggle",function(e){return function(){return e.statusBarPanel.isVisible()?atom.config.set("status-bar.isVisible",!1):atom.config.set("status-bar.isVisible",!0)}}(this)),c=(a=atom.getLoadSettings()).safeMode,t=a.devMode,(c||t)&&(s=new l({safeMode:c,devMode:t}),this.statusBar.addLeftTile({item:s.element,priority:-1})),this.fileInfo=new r,this.statusBar.addLeftTile({item:this.fileInfo.element,priority:0}),this.cursorPosition=new o,this.statusBar.addLeftTile({item:this.cursorPosition.element,priority:1}),this.selectionCount=new d,this.statusBar.addLeftTile({item:this.selectionCount.element,priority:2}),this.gitInfo=new i,this.gitInfoTile=this.statusBar.addRightTile({item:this.gitInfo.element,priority:0})},deactivate:function(){var e,t,o,n,s,r,i,a,l;if(null!=(e=this.statusBarVisibilitySubscription)&&e.dispose(),this.statusBarVisibilitySubscription=null,null!=(t=this.gitInfo)&&t.destroy(),this.gitInfo=null,null!=(o=this.fileInfo)&&o.destroy(),this.fileInfo=null,null!=(n=this.cursorPosition)&&n.destroy(),this.cursorPosition=null,null!=(s=this.selectionCount)&&s.destroy(),this.selectionCount=null,null!=(r=this.statusBarPanel)&&r.destroy(),this.statusBarPanel=null,null!=(i=this.statusBar)&&i.destroy(),this.statusBar=null,null!=(a=this.subscriptions)&&a.dispose(),this.subscriptions=null,null!=(l=this.emitters)&&l.dispose(),this.emitters=null,null!=atom.__workspaceView)return delete atom.__workspaceView.statusBar},updateStatusBarVisibility:function(){return atom.config.get("status-bar.isVisible")?this.statusBarPanel.show():this.statusBarPanel.hide()},provideStatusBar:function(){return{addLeftTile:this.statusBar.addLeftTile.bind(this.statusBar),addRightTile:this.statusBar.addRightTile.bind(this.statusBar),getLeftTiles:this.statusBar.getLeftTiles.bind(this.statusBar),getRightTiles:this.statusBar.getRightTiles.bind(this.statusBar),disableGitInfoTile:this.gitInfoTile.destroy.bind(this.gitInfoTile)}},attachStatusBar:function(){var e;return null!=this.statusBarPanel&&this.statusBarPanel.destroy(),e={item:this.statusBar,priority:0},atom.config.get("status-bar.fullWidth")?this.statusBarPanel=atom.workspace.addFooterPanel(e):this.statusBarPanel=atom.workspace.addBottomPanel(e)},legacyProvideStatusBar:function(){var e;return e=this.provideStatusBar(),{addLeftTile:function(){var t;return t=1<=arguments.length?m.call(arguments,0):[],a.deprecate("Use version ^1.0.0 of the status-bar Service API."),e.addLeftTile.apply(e,t)},addRightTile:function(){var t;return t=1<=arguments.length?m.call(arguments,0):[],a.deprecate("Use version ^1.0.0 of the status-bar Service API."),e.addRightTile.apply(e,t)},getLeftTiles:function(){return a.deprecate("Use version ^1.0.0 of the status-bar Service API."),e.getLeftTiles()},getRightTiles:function(){return a.deprecate("Use version ^1.0.0 of the status-bar Service API."),e.getRightTiles()}}}}}).call(this)},"../node_modules/styleguide/lib/styleguide.js":function(e,t,o,n,s,r){let{CompositeDisposable:i}={};let a=null;t.exports={activate(){this.subscriptions=new(function get_CompositeDisposable(){return i=i||s("atom").CompositeDisposable}()),this.subscriptions.add(atom.workspace.addOpener(e=>{if("atom://styleguide"===e)return this.createStyleguideView({uri:"atom://styleguide"})})),this.subscriptions.add(atom.commands.add("atom-workspace","styleguide:show",()=>atom.workspace.open("atom://styleguide")))},deactivate(){this.subscriptions.dispose()},createStyleguideView:e=>(null==a&&(a=s("../node_modules/styleguide/lib/styleguide-view.js")),new a(e))}},"../node_modules/symbols-view/lib/main.js":function(e,t,o,n,s,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default={activate:function activate(){var e=this;this.stack=[],this.workspaceSubscription=atom.commands.add("atom-workspace",{"symbols-view:toggle-project-symbols":function symbolsViewToggleProjectSymbols(){e.createProjectView().toggle()}}),this.editorSubscription=atom.commands.add("atom-text-editor",{"symbols-view:toggle-file-symbols":function symbolsViewToggleFileSymbols(){e.createFileView().toggle()},"symbols-view:go-to-declaration":function symbolsViewGoToDeclaration(){e.createGoToView().toggle()},"symbols-view:return-from-declaration":function symbolsViewReturnFromDeclaration(){e.createGoBackView().toggle()}})},deactivate:function deactivate(){null!=this.fileView&&(this.fileView.destroy(),this.fileView=null),null!=this.projectView&&(this.projectView.destroy(),this.projectView=null),null!=this.goToView&&(this.goToView.destroy(),this.goToView=null),null!=this.goBackView&&(this.goBackView.destroy(),this.goBackView=null),null!=this.workspaceSubscription&&(this.workspaceSubscription.dispose(),this.workspaceSubscription=null),null!=this.editorSubscription&&(this.editorSubscription.dispose(),this.editorSubscription=null)},createFileView:function createFileView(){if(this.fileView)return this.fileView;var e=s("../node_modules/symbols-view/lib/file-view.js");return this.fileView=new e(this.stack),this.fileView},createProjectView:function createProjectView(){if(this.projectView)return this.projectView;var e=s("../node_modules/symbols-view/lib/project-view.js");return this.projectView=new e(this.stack),this.projectView},createGoToView:function createGoToView(){if(this.goToView)return this.goToView;var e=s("../node_modules/symbols-view/lib/go-to-view.js");return this.goToView=new e(this.stack),this.goToView},createGoBackView:function createGoBackView(){if(this.goBackView)return this.goBackView;var e=s("../node_modules/symbols-view/lib/go-back-view.js");return this.goBackView=new e(this.stack),this.goBackView}},t.exports=e.default},"../node_modules/tabs/lib/main.js":function(e,t,o,n,s,r){let{CompositeDisposable:i,Disposable:a}={};function get_Disposable(){return a=a||s("atom").Disposable}const l=s("../node_modules/tabs/lib/get-icon-services.js"),d=s("../node_modules/tabs/lib/layout.js"),u=s("../node_modules/tabs/lib/tab-bar-view.js"),c=s("../node_modules/tabs/lib/mru-list-view.js"),m=s("../node_modules/underscore-plus/lib/underscore-plus.js");t.exports={activate(){this.subscriptions=new(function get_CompositeDisposable(){return i=i||s("atom").CompositeDisposable}()),d.activate(),this.tabBarViews=[],this.mruListViews=[];this.updateTraversalKeybinds=(()=>{let e=atom.keymaps.findKeyBindings({target:get_document().body,keystrokes:"ctrl-tab"});if(!(e.length>1&&"tabs package"!==e[0].source||(e=atom.keymaps.findKeyBindings({target:get_document().body,keystrokes:"ctrl-shift-tab"})).length>1&&"tabs package"!==e[0].source))if(atom.config.get("tabs.enableMruTabSwitching"))atom.keymaps.removeBindingsFromSource("tabs package");else{const e={body:{"ctrl-tab":"pane:show-next-item","ctrl-tab ^ctrl":"unset!","ctrl-shift-tab":"pane:show-previous-item","ctrl-shift-tab ^ctrl":"unset!"}};atom.keymaps.add("tabs package",e,0)}}),this.subscriptions.add(atom.config.observe("tabs.enableMruTabSwitching",()=>this.updateTraversalKeybinds())),this.subscriptions.add(atom.keymaps.onDidLoadUserKeymap(()=>this.updateTraversalKeybinds())),this.subscriptions.add(atom.commands.add("atom-workspace",{"tabs:close-all-tabs":()=>{for(let e=this.tabBarViews.length-1;e>=0;e--)this.tabBarViews[e].closeAllTabs()}}));const e={center:atom.workspace.getCenter(),left:atom.workspace.getLeftDock(),right:atom.workspace.getRightDock(),bottom:atom.workspace.getBottomDock()};Object.keys(e).forEach(t=>{const o=e[t];o&&this.subscriptions.add(o.observePanes(e=>{const o=new u(e,t),n=new c;n.initialize(e);const s=e.getElement();s.insertBefore(o.element,s.firstChild),this.tabBarViews.push(o),e.onDidDestroy(()=>m.remove(this.tabBarViews,o)),this.mruListViews.push(n),e.onDidDestroy(()=>m.remove(this.mruListViews,n))}))})},deactivate(){d.deactivate(),this.subscriptions.dispose(),null!=this.fileIconsDisposable&&this.fileIconsDisposable.dispose();for(let e of this.tabBarViews)e.destroy();for(let e of this.mruListViews)e.destroy()},consumeElementIcons(e){return l().setElementIcons(e),this.updateFileIcons(),new(get_Disposable())(()=>{l().resetElementIcons(),this.updateFileIcons()})},consumeFileIcons(e){return l().setFileIcons(e),this.updateFileIcons(),new(get_Disposable())(()=>{l().resetFileIcons(),this.updateFileIcons()})},updateFileIcons(){for(let e of this.tabBarViews)for(let t of e.getTabs())t.updateIcon()}}},"../node_modules/timecop/lib/main.js":function(e,t,o,n,s,r){let{CompositeDisposable:i}={};let a=null;const l="atom://timecop";t.exports={activate(){this.subscriptions=new(function get_CompositeDisposable(){return i=i||s("atom").CompositeDisposable}()),this.subscriptions.add(atom.workspace.addOpener(e=>{if(e===l)return this.createTimecopView({uri:l})})),this.subscriptions.add(atom.commands.add("atom-workspace","timecop:view",()=>atom.workspace.open(l)))},deactivate(){this.subscriptions.dispose()},createTimecopView:e=>(null==a&&(a=s("../node_modules/timecop/lib/timecop-view.js")),new a(e))}},"../node_modules/tree-view/lib/main.js":function(e,t,o,n,s,r){const i=s("../node_modules/tree-view/lib/tree-view-package.js");t.exports=new i},"../node_modules/update-package-dependencies/lib/update-package-dependencies.js":function(e,t,o,n,s,r){let{BufferedProcess:i}={};const a=s("../node_modules/update-package-dependencies/lib/update-package-dependencies-status-view.js");t.exports={activate(){this.subscription=atom.commands.add("atom-workspace","update-package-dependencies:update",()=>this.update())},deactivate(){this.subscription.dispose(),this.updatePackageDependenciesStatusView&&(this.updatePackageDependenciesStatusView.detach(),this.updatePackageDependenciesStatusView=null)},consumeStatusBar(e){this.updatePackageDependenciesStatusView=new a(e)},update(){if(this.process)return;this.updatePackageDependenciesStatusView&&this.updatePackageDependenciesStatusView.attach();let e="";const t=atom.packages.getApmPath(),o={cwd:this.getActiveProjectPath(),env:Object.assign({},get_process().env,{NODE_ENV:"development"})};this.process=this.runBufferedProcess({command:t,args:["install","--no-color"],stderr:t=>{e+=t},exit:t=>{this.process=null,this.updatePackageDependenciesStatusView&&this.updatePackageDependenciesStatusView.detach(),0===t?atom.notifications.addSuccess("Package dependencies updated"):atom.notifications.addError("Failed to update package dependencies",{detail:e,dismissable:!0})},options:o})},runBufferedProcess:e=>new(function get_BufferedProcess(){return i=i||s("atom").BufferedProcess}())(e),getActiveProjectPath(){const e=atom.workspace.getActivePaneItem();return e&&"function"==typeof e.getPath?atom.project.relativizePath(e.getPath())[0]:atom.project.getPaths()[0]}}},"../node_modules/welcome/lib/main.js":function(e,t,o,n,s,r){Object.defineProperty(e,"__esModule",{value:!0});var i=function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}(s("../node_modules/welcome/lib/welcome-package.js"));e.default=new i.default,t.exports=e.default},"../node_modules/whitespace/lib/main.js":function(e,t,o,n,s,r){const i=s("../node_modules/whitespace/lib/whitespace.js");t.exports={activate(){this.whitespace=new i},deactivate(){this.whitespace&&this.whitespace.destroy(),this.whitespace=null}}},"../node_modules/wrap-guide/lib/main.js":function(e,t,o,n,s,r){(function(){var e,o;o=s("../node_modules/wrap-guide/lib/wrap-guide-element.js"),t.exports={activate:function(){return this.subscriptions=new(function get_CompositeDisposable(){return e=e||s("atom").CompositeDisposable}()),this.wrapGuides=new Map,this.subscriptions.add(atom.workspace.observeTextEditors((t=this,function(e){var n,s;if(!t.wrapGuides.has(e))return n=atom.views.getView(e),s=new o(e,n),t.wrapGuides.set(e,s),t.subscriptions.add(e.onDidDestroy(function(){return t.wrapGuides.get(e).destroy(),t.wrapGuides.delete(e)}))})));var t},deactivate:function(){return this.subscriptions.dispose(),this.wrapGuides.forEach(function(e,t){return e.destroy()}),this.wrapGuides.clear()},uniqueAscending:function(e){return e.filter(function(t,o){return e.indexOf(t)===o}).sort(function(e,t){return e-t})}}}).call(this)},"../src/update-process-env.js":function(e,t,o,n,s,r){let i,a;const l=new Set(["NODE_ENV","NODE_PATH","ATOM_HOME","ATOM_DISABLE_SHELLING_OUT_FOR_ENVIRONMENT"]),d=new Set(["darwin","linux"]);function shouldGetEnvFromShell(e){return!!d.has(get_process().platform)&&(!(!e||!e.SHELL||""===e.SHELL.trim())&&(!e.ATOM_DISABLE_SHELLING_OUT_FOR_ENVIRONMENT&&!get_process().env.ATOM_DISABLE_SHELLING_OUT_FOR_ENVIRONMENT))}t.exports={updateProcessEnv:async function updateProcessEnv(e){let t;if(e&&(shouldGetEnvFromShell(e)?t=await async function getEnvFromShell(e){let{stdout:t,error:o}=await new Promise(t=>{let o,n,r="",i=!1;const l=()=>{!i&&o&&(o.kill(),i=!0)};get_process().once("exit",l),setTimeout(()=>{l()},5e3),o=function get_childProcess(){return a=a||s("child_process")}().spawn(e.SHELL,["-ilc","command env"],{encoding:"utf8",detached:!0,stdio:["ignore","pipe",get_process().stderr]});const d=[];o.on("error",e=>{i=!0,n=e}),o.stdout.on("data",e=>{d.push(e)}),o.on("close",(e,o)=>{i=!0,get_process().removeListener("exit",l),d.length&&(r=Buffer.concat(d).toString("utf8")),t({stdout:r,error:n})})});if(o&&(o.handle&&o.handle(),get_console().log("warning: "+e.SHELL+' -ilc "command env" failed with signal ('+o.signal+")"),get_console().log(o)),!t||""===t.trim())return null;let n={};for(let e of t.split("\n"))if(e.includes("=")){let t=e.split("="),o=t.shift(),s=t.join("=");n[o]=s}return n}(e):(e.PWD||e.PROMPT||e.PSModulePath)&&(t=e)),t){for(let e in get_process().env)l.has(e)||delete get_process().env[e];for(let e in t)(!l.has(e)||!get_process().env[e]&&t[e])&&(get_process().env[e]=t[e]);t.ATOM_HOME&&function get_fs(){return i=i||s("fs")}().existsSync(t.ATOM_HOME)&&(get_process().env.ATOM_HOME=t.ATOM_HOME)}},shouldGetEnvFromShell:shouldGetEnvFromShell}},"../src/window.js":function(e,t,o,n,s,r){get_window().measure=function(e,t){let o=Date.now(),n=t(),s=Date.now()-o;return get_console().log(e,s),n},get_window().profile=function(e,t){get_window().measure(e,function(){get_console().profile(e);let o=t();return get_console().profileEnd(e),o})}},"../src/get-window-load-settings.js":function(e,t,o,n,s,r){let{remote:i}={};let a=null;t.exports=(()=>(a||(a=JSON.parse(function get_remote(){return i=i||s("electron").remote}().getCurrentWindow().loadSettingsJSON)),a))},"../node_modules/underscore-plus/lib/underscore-plus.js":function(e,t,o,n,s,r){(function(){var e,o,n,r,i,a,l,d,u=[].slice;d=s("../node_modules/underscore/underscore.js"),n={cmd:"⌘",ctrl:"⌃",alt:"⌥",option:"⌥",shift:"⇧",enter:"⏎",left:"←",right:"→",up:"↑",down:"↓"},r={cmd:"Cmd",ctrl:"Ctrl",alt:"Alt",option:"Alt",shift:"Shift",enter:"Enter",left:"Left",right:"Right",up:"Up",down:"Down"},a={"~":"`",_:"-","+":"=","|":"\\","{":"[","}":"]",":":";",'"':"'","<":",",">":".","?":"/"},l=function(e){var t,o,n,s,r;if(n=0,o=[],null==e)return o;for(t=s=0,r=e.length;s<r;t=++s)"."!==e[t]||0!==t&&"\\"===e[t-1]||(o.push(e.substring(n,t)),n=t+1);return o.push(e.substr(n,e.length)),o},o=function(e){return d.isObject(e)&&!d.isArray(e)},i={adviseBefore:function(e,t,o){var n;return n=e[t],e[t]=function(){var e;if(e=1<=arguments.length?u.call(arguments,0):[],!1!==o.apply(this,e))return n.apply(this,e)}},camelize:function(e){return e?e.replace(/[_-]+(\w)/g,function(e){return e[1].toUpperCase()}):""},capitalize:function(e){return e?"github"===e.toLowerCase()?"GitHub":e[0].toUpperCase()+e.slice(1):""},compactObject:function(e){var t,o,n;for(t in o={},e)null!=(n=e[t])&&(o[t]=n);return o},dasherize:function(e){return e?(e=e[0].toLowerCase()+e.slice(1)).replace(/([A-Z])|(_)/g,function(e,t){return t?"-"+t.toLowerCase():"-"}):""},deepClone:function(e){return d.isArray(e)?e.map(function(e){return i.deepClone(e)}):d.isObject(e)&&!d.isFunction(e)?i.mapObject(e,function(e,t){return[e,i.deepClone(t)]}):e},deepExtend:function(e){var t,n,s,r,a,l,d;for(r=e,t=0;++t<arguments.length;)if(s=arguments[t],o(r)&&o(s))for(a=0,l=(d=Object.keys(s)).length;a<l;a++)r[n=d[a]]=i.deepExtend(r[n],s[n]);else r=i.deepClone(s);return r},deepContains:function(e,t){var o,n,s;if(null==e)return!1;for(n=0,s=e.length;n<s;n++)if(o=e[n],d.isEqual(o,t))return!0;return!1},endsWith:function(e,t){return null==t&&(t=""),!!e&&-1!==e.indexOf(t,e.length-t.length)},escapeAttribute:function(e){return e?e.replace(/"/g,"&quot;").replace(/\n/g,"").replace(/\\/g,"-"):""},escapeRegExp:function(e){return e?e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&"):""},humanizeEventName:function(e,t){var o,n,s,r;return n=(r=e.split(":"))[0],null==(o=r[1])?i.undasherize(n):(s=i.undasherize(n),null==t&&(t=i.undasherize(o)),s+": "+t)},humanizeKey:function(e,t){var o;return null==t&&(t=get_process().platform),e?(o="darwin"===t?n:r)[e]?o[e]:1===e.length&&null!=a[e]?[o.shift,a[e]]:1===e.length&&e===e.toUpperCase()&&e.toUpperCase()!==e.toLowerCase()?[o.shift,e.toUpperCase()]:1===e.length||/f[0-9]{1,2}/.test(e)?e.toUpperCase():"darwin"===t?e:i.capitalize(e):e},humanizeKeystroke:function(e,t){var o,n,s,r,a,l,u,c,m,p;if(null==t&&(t=get_process().platform),!e)return e;for(o=[],u=0,m=(a=e.split(" ")).length;u<m;u++){for(r=[],n=c=0,p=(l=(e=a[u]).split("-")).length;c<p;n=++c)""===(s=l[n])&&""===l[n-1]&&(s="-"),s&&r.push(i.humanizeKey(s,t));r=d.uniq(d.flatten(r)),r="darwin"===t?r.join(""):r.join("+"),o.push(r)}return o.join(" ")},isSubset:function(e,t){return d.every(e,function(e){return d.include(t,e)})},losslessInvert:function(e){var t,o,n;for(o in t={},e)null==t[n=e[o]]&&(t[n]=[]),t[n].push(o);return t},mapObject:function(e,t){var o,n,s,r,i,a,l;for(n={},r=0,i=(a=Object.keys(e)).length;r<i;r++)o=(l=t(o=a[r],e[o]))[0],s=l[1],n[o]=s;return n},multiplyString:function(e,t){var o,n;for(o="",n=0;n<t;)o+=e,n++;return o},pluralize:function(e,t,o){return null==e&&(e=0),null==o&&(o=t+"s"),1===e?e+" "+t:e+" "+o},remove:function(e,t){var o;return(o=e.indexOf(t))>=0&&e.splice(o,1),e},setValueForKeyPath:function(e,t,o){var n,s;for(s=l(t);s.length>1;)null==e[n=s.shift()]&&(e[n]={}),e=e[n];return null!=o?e[s.shift()]=o:delete e[s.shift()]},hasKeyPath:function(e,t){var o,n,s,r;for(s=0,r=(n=l(t)).length;s<r;s++){if(o=n[s],!e.hasOwnProperty(o))return!1;e=e[o]}return!0},spliceWithArray:function(e,t,o,n,s){var r,i,a,l;if(null==s&&(s=1e5),n.length<s)return e.splice.apply(e,[t,o].concat(u.call(n)));for(e.splice(t,o),l=[],r=i=0,a=n.length;s>0?i<=a:i>=a;r=i+=s)l.push(e.splice.apply(e,[t+r,0].concat(u.call(n.slice(r,r+s)))));return l},sum:function(e){var t,o,n;for(t=0,o=0,n=e.length;o<n;o++)t+=e[o];return t},uncamelcase:function(e){var t;return e?(t=e.replace(/([A-Z])|_+/g,function(e,t){return null==t&&(t="")," "+t}),i.capitalize(t.trim())):""},undasherize:function(e){return e?e.split("-").map(i.capitalize).join(" "):""},underscore:function(e){return e?(e=e[0].toLowerCase()+e.slice(1)).replace(/([A-Z])|-+/g,function(e,t){return null==t&&(t=""),"_"+t.toLowerCase()}):""},valueForKeyPath:function(e,t){var o,n,s;for(n=0,s=(o=l(t)).length;n<s;n++)if(null==(e=e[o[n]]))return;return e},isEqual:function(t,o,n,s){return d.isArray(n)&&d.isArray(s)?e(t,o,n,s):e(t,o)},isEqualForProperties:function(){var e,t,o,n,s,r;for(e=arguments[0],t=arguments[1],s=0,r=(o=3<=arguments.length?u.call(arguments,2):[]).length;s<r;s++)if(n=o[s],!d.isEqual(e[n],t[n]))return!1;return!0}},e=function(t,o,n,s){var r,i,a,l,u,c,m,p,h,f,g,b,_,y;if(null==n&&(n=[]),null==s&&(s=[]),t===o)return d.isEqual(t,o);if(d.isFunction(t)||d.isFunction(o))return d.isEqual(t,o);for(b=n.length;b--;)if(n[b]===t)return s[b]===o;if(n.push(t),s.push(o),h=!1,d.isFunction(null!=t?t.isEqual:void 0))h=t.isEqual(o,n,s);else if(d.isFunction(null!=o?o.isEqual:void 0))h=o.isEqual(t,s,n);else if(d.isArray(t)&&d.isArray(o)&&t.length===o.length){for(h=!0,f=_=0,y=t.length;_<y;f=++_)if(a=t[f],!e(a,o[f],n,s)){h=!1;break}}else if(d.isRegExp(t)&&d.isRegExp(o))h=d.isEqual(t,o);else if(d.isElement(t)&&d.isElement(o))h=t===o;else if(d.isObject(t)&&d.isObject(o))if(r=t.constructor,c=o.constructor,i=d.isFunction(r)&&r instanceof r,m=d.isFunction(c)&&c instanceof c,r===c||i&&m){for(g in l=0,h=!0,t)if(u=t[g],d.has(t,g)&&(l++,!d.has(o,g)||!e(u,o[g],n,s))){h=!1;break}if(h){for(g in p=0,o)o[g],d.has(o,g)&&p++;h=l===p}}else h=!1;else h=d.isEqual(t,o);return n.pop(),s.pop(),h},t.exports=d.extend({},d,i)}).call(this)},"../node_modules/grim/lib/grim.js":function(e,t,o,n,s,r){(function(){var e,o,n,r;o=s("../node_modules/emissary/lib/emissary.js").Emitter,e=s("../node_modules/grim/lib/deprecation.js"),null==get_global().__grim__&&(r=get_global().__grim__={deprecations:{},includeDeprecatedAPIs:!0,getDeprecations:function(){var e,t,o,n,s,i,a,l;for(s in t=[],l=r.deprecations)for(i in o=l[s])for(a in n=o[i])e=n[a],t.push(e);return t},getDeprecationsLength:function(){return this.getDeprecations().length},clearDeprecations:function(){r.deprecations={}},logDeprecations:function(){var e,t,o,n;for((t=this.getDeprecations()).sort(function(e,t){return t.getCallCount()-e.getCallCount()}),get_console().warn("\nCalls to deprecated functions\n-----------------------------"),o=0,n=t.length;o<n;o++)e=t[o],get_console().warn("("+e.getCallCount()+") "+e.getOriginName()+" : "+e.getMessage(),e)},deprecate:function(t,o){var s,i,a,l,d,u,c,m,p,h,f,g,b;u=Error.stackTraceLimit,Error.stackTraceLimit=7,a=new Error,Error.captureStackTrace(a),Error.stackTraceLimit=u,l=(i=(m=(m=null!=(g="function"==typeof a.getRawStack?a.getRawStack():void 0)?g:n(a)).slice(1))[0]).getFileName(),d=i.getLineNumber(),c=null!=(b=null!=o?o.packageName:void 0)?b:"",null==(p=r.deprecations)[l]&&(p[l]={}),null==(h=r.deprecations[l])[d]&&(h[d]={}),null==(f=r.deprecations[l][d])[c]&&(f[c]=new e(t)),(s=r.deprecations[l][d][c]).addStack(m,o),r.emit("updated",s)},addSerializedDeprecation:function(t){var o,n,s,i,a,l,d,u,c,m,p,h,f,g,b;for(i=(o=e.deserialize(t)).getMessage(),n=o.fileName,s=o.lineNumber,a=null!=(f=null!=(g=(d=o.getStacks())[0])&&null!=(b=g.metadata)?b.packageName:void 0)?f:"",null==(u=r.deprecations)[n]&&(u[n]={}),null==(c=r.deprecations[n])[s]&&(c[s]={}),null==(m=r.deprecations[n][s])[a]&&(m[a]=new e(i,n,s)),o=r.deprecations[n][s][a],p=0,h=d.length;p<h;p++)l=d[p],o.addStack(l,l.metadata);r.emit("updated",o)}},o.extend(r)),n=function(e){var t,o;return t=Error.prepareStackTrace,Error.prepareStackTrace=function(e,t){return t},o=e.stack,Error.prepareStackTrace=t,o},t.exports=get_global().__grim__}).call(this)},"../node_modules/event-kit/dist/event-kit.js":function(e,t,o,n,s,r){"use strict";e.Emitter=s("../node_modules/event-kit/dist/emitter.js"),e.Disposable=s("../node_modules/event-kit/dist/disposable.js"),e.CompositeDisposable=s("../node_modules/event-kit/dist/composite-disposable.js")},"../node_modules/fs-plus/lib/fs-plus.js":function(e,t,o,n,s,r){(function(){var e,o,n,r,i,a,l,d,u,c,m,p,h,f,g,b,_,y,v,j=[].slice;function get_fs(){return d=d||s("fs")}function get_path(){return b=b||s("path")}v=s("../node_modules/underscore-plus/lib/underscore-plus.js"),a=s("../node_modules/fs-plus/node_modules/async/lib/async.js"),g=s("../node_modules/mkdirp/index.js"),_=s("../node_modules/rimraf/rimraf.js"),u={__esModule:!1,getHomeDirectory:function(){return"win32"!==get_process().platform||get_process().env.HOME?get_process().env.HOME:get_process().env.USERPROFILE},absolute:function(e){if(null==e)return null;e=u.resolveHome(e);try{return get_fs().realpathSync(e)}catch(t){return t,e}},normalize:function(e){return null==e?null:u.resolveHome(get_path().normalize(e.toString()))},resolveHome:function(e){return"~"===e?u.getHomeDirectory():0===e.indexOf("~"+get_path().sep)?""+u.getHomeDirectory()+e.substring(1):e},tildify:function(e){var t,o;return"win32"===get_process().platform?e:(o=u.normalize(e),null==(t=u.getHomeDirectory())?e:o===t?"~":o.startsWith(get_path().join(t,get_path().sep))?get_path().join("~",get_path().sep,o.substring(t.length+1)):e)},getAppDataDirectory:function(){switch(get_process().platform){case"darwin":return u.absolute(get_path().join("~","Library","Application Support"));case"linux":return"/var/lib";case"win32":return get_process().env.APPDATA;default:return null}},isAbsolute:function(e){return null==e&&(e=""),"win32"!==get_process().platform?"/"===e[0]:":"===e[1]||"\\"===e[0]&&"\\"===e[1]},existsSync:function(e){return h(e)&&!1!==y(e)},isDirectorySync:function(e){var t;return!!h(e)&&(!!(t=y(e))&&t.isDirectory())},isDirectory:function(e,t){return h(e)?get_fs().stat(e,function(e,o){return t(null==e&&o.isDirectory())}):t(!1)},isFileSync:function(e){var t;return!!h(e)&&(!!(t=y(e))&&t.isFile())},isSymbolicLinkSync:function(e){var t;return!!h(e)&&(!!(t=f(e))&&t.isSymbolicLink())},isSymbolicLink:function(e,t){return h(e)?get_fs().lstat(e,function(e,o){return"function"==typeof t?t(null!=o&&o.isSymbolicLink()):void 0}):get_process().nextTick(function(){return"function"==typeof t?t(!1):void 0})},isExecutableSync:function(e){var t;return!!h(e)&&(!!(t=y(e))&&0!=(1&t.mode))},getSizeSync:function(e){var t;return h(e)&&null!=(t=y(e).size)?t:-1},listSync:function(e,t){var o;return u.isDirectorySync(e)?(o=get_fs().readdirSync(e),t&&(o=u.filterExtensions(o,t)),o=(o=o.sort(function(e,t){return e.toLowerCase().localeCompare(t.toLowerCase())})).map(function(t){return get_path().join(e,t)})):[]},list:function(){var e,t,o,n;return n=arguments[0],(o=2<=arguments.length?j.call(arguments,1):[]).length>1&&(t=o.shift()),e=o.shift(),get_fs().readdir(n,function(o,s){return null!=o?e(o):(t&&(s=u.filterExtensions(s,t)),s=(s=s.sort(function(e,t){return e.toLowerCase().localeCompare(t.toLowerCase())})).map(function(e){return get_path().join(n,e)}),e(null,s))})},filterExtensions:function(e,t){return t=t.map(function(e){return""===e?e:"."+e.replace(/^\./,"")}),e.filter(function(e){return v.include(t,get_path().extname(e))})},listTreeSync:function(e){var t,o;return o=[],t=function(e){return o.push(e),!0},u.traverseTreeSync(e,t,t),o},move:function(e,t,o){return m(e,t,function(n,s){var r,i;if(!n)return s?(i=get_path().dirname(t),get_fs().exists(i,function(n){if(!n)return u.makeTree(i,function(n){if(!n)return get_fs().rename(e,t,o);o(n)});get_fs().rename(e,t,o)})):((r=new Error("'"+t+"' already exists.")).code="EEXIST",void o(r));o(n)})},moveSync:function(e,t){var o,n;if(!p(e,t))throw(o=new Error("'"+t+"' already exists.")).code="EEXIST",o;return n=get_path().dirname(t),get_fs().existsSync(n)||u.makeTreeSync(n),get_fs().renameSync(e,t)},removeSync:function(e){return _.sync(e)},remove:function(e,t){return _(e,t)},writeFileSync:function(e,t,o){return g.sync(get_path().dirname(e)),get_fs().writeFileSync(e,t,o)},writeFile:function(e,t,o,n){return n=v.last(arguments),g(get_path().dirname(e),function(s){return null!=s?"function"==typeof n?n(s):void 0:get_fs().writeFile(e,t,o,n)})},copy:function(e,t,o){return g(get_path().dirname(t),function(n){var s,r;if(null==n)return(r=get_fs().createReadStream(e)).on("error",function(e){return"function"==typeof o&&o(e),o=null}),(s=get_fs().createWriteStream(t)).on("error",function(e){return"function"==typeof o&&o(e),o=null}),s.on("close",function(){return"function"==typeof o&&o(),o=null}),r.pipe(s);"function"==typeof o&&o(n)})},copySync:function(e,t){var o,n,s,r,i,a,l;for(r=get_fs().readdirSync(e),g.sync(t),l=[],i=0,a=r.length;i<a;i++)n=r[i],s=get_path().join(e,n),o=get_path().join(t,n),u.isDirectorySync(s)?l.push(u.copySync(s,o)):l.push(u.copyFileSync(s,o));return l},copyFileSync:function(e,t,o){var n,s,r,i,a,l;null==o&&(o=16384),g.sync(get_path().dirname(t)),i=null,a=null;try{for(i=get_fs().openSync(e,"r"),a=get_fs().openSync(t,"w"),s=1,r=0,l=[];s>0;)n=new Buffer(o),s=get_fs().readSync(i,n,0,n.length,r),get_fs().writeSync(a,n,0,s,r),l.push(r+=s);return l}finally{null!=i&&get_fs().closeSync(i),null!=a&&get_fs().closeSync(a)}},makeTreeSync:function(e){if(!u.isDirectorySync(e))return g.sync(e)},makeTree:function(e,t){return u.isDirectory(e,function(o){return o?"function"==typeof t?t():void 0:g(e,function(e){return"function"==typeof t?t(e):void 0})})},traverseTreeSync:function(e,t,o){var n;if(null==o&&(o=t),u.isDirectorySync(e))return(n=function(e,t,o){var s,r,i,a,l,d,u;for(l=0,d=(u=get_fs().readdirSync(e)).length;l<d;l++)r=u[l],s=get_path().join(e,r),(a=get_fs().lstatSync(s)).isSymbolicLink()&&(i=y(s))&&(a=i),a.isDirectory()?o(s)&&n(s,t,o):a.isFile()&&t(s)})(e,t,o)},traverseTree:function(e,t,o,n){return get_fs().readdir(e,function(s,r){var i,l,d,u,c;if(s)return"function"==typeof n?n():void 0;for((l=a.queue(function(e,n){return get_fs().stat(e,function(s,r){return s?n(s):r.isFile()?(t(e),n()):r.isDirectory()&&o(e)?get_fs().readdir(e,function(t,o){var s,r,i;if(t)return n(t);for(r=0,i=o.length;r<i;r++)s=o[r],l.unshift(get_path().join(e,s));return n()}):n()})})).concurrency=1,l.drain=n,c=[],d=0,u=r.length;d<u;d++)i=r[d],c.push(l.push(get_path().join(e,i)));return c})},md5ForPath:function(e){var t;return t=get_fs().readFileSync(e),s("crypto").createHash("md5").update(t).digest("hex")},resolve:function(){var e,t,o,n,s,r,i,a,l,d;if(e=1<=arguments.length?j.call(arguments,0):[],v.isArray(v.last(e))&&(o=e.pop()),r=null!=(d=e.pop())?d.toString():void 0,s=e,r){if(u.isAbsolute(r)){if(o&&(i=u.resolveExtension(r,o)))return i;if(u.existsSync(r))return r}for(a=0,l=s.length;a<l;a++)if(n=s[a],t=get_path().join(n,r),o){if(i=u.resolveExtension(t,o))return i}else if(u.existsSync(t))return u.absolute(t)}},resolveOnLoadPath:function(){var e,o,n;return e=1<=arguments.length?j.call(arguments,0):[],n=null,n=null!=t.paths?t.paths:get_process().resourcesPath?[get_path().join(get_process().resourcesPath,"app","node_modules")]:[],o=function get_Module(){return i=i||s("module")}().globalPaths.concat(n),u.resolve.apply(u,j.call(o).concat(j.call(e)))},resolveExtension:function(e,t){var o,n,s,r;for(s=0,r=t.length;s<r;s++)if(""===(o=t[s])){if(u.existsSync(e))return u.absolute(e)}else if(n=e+"."+o.replace(/^\./,""),u.existsSync(n))return u.absolute(n)},isCompressedExtension:function(e){return null!=e&&o.hasOwnProperty(e.toLowerCase())},isImageExtension:function(e){return null!=e&&n.hasOwnProperty(e.toLowerCase())},isPdfExtension:function(e){return".pdf"===(null!=e?e.toLowerCase():void 0)},isBinaryExtension:function(t){return null!=t&&e.hasOwnProperty(t.toLowerCase())},isReadmePath:function(e){var t;return t=get_path().extname(e),"readme"===get_path().basename(e,t).toLowerCase()&&(""===t||u.isMarkdownExtension(t))},isMarkdownExtension:function(e){return null!=e&&r.hasOwnProperty(e.toLowerCase())},isCaseInsensitive:function(){var e,t;return null==u.caseInsensitiveFs&&(e=y(get_process().execPath.toLowerCase()),t=y(get_process().execPath.toUpperCase()),u.caseInsensitiveFs=!(!e||!t)&&(e.dev===t.dev&&e.ino===t.ino)),u.caseInsensitiveFs},isCaseSensitive:function(){return!u.isCaseInsensitive()},statSyncNoException:function(){var e;return e=1<=arguments.length?j.call(arguments,0):[],y.apply(null,e)},lstatSyncNoException:function(){var e;return e=1<=arguments.length?j.call(arguments,0):[],f.apply(null,e)}},c=null,l=function(){return null===c&&(c=get_process().versions.electron&&parseInt(get_process().versions.electron.split(".")[0])<=2),c},y=function(){var e;if(e=1<=arguments.length?j.call(arguments,0):[],get_fs().statSyncNoException&&l())return get_fs().statSyncNoException.apply(get_fs(),e);try{return get_fs().statSync.apply(get_fs(),e)}catch(e){return e,!1}},f=function(){var e;if(e=1<=arguments.length?j.call(arguments,0):[],get_fs().lstatSyncNoException&&l())return get_fs().lstatSyncNoException.apply(get_fs(),e);try{return get_fs().lstatSync.apply(get_fs(),e)}catch(e){return e,!1}},e={".ds_store":!0,".a":!0,".exe":!0,".o":!0,".pyc":!0,".pyo":!0,".so":!0,".woff":!0},o={".bz2":!0,".egg":!0,".epub":!0,".gem":!0,".gz":!0,".jar":!0,".lz":!0,".lzma":!0,".lzo":!0,".rar":!0,".tar":!0,".tgz":!0,".war":!0,".whl":!0,".xpi":!0,".xz":!0,".z":!0,".zip":!0},n={".gif":!0,".ico":!0,".jpeg":!0,".jpg":!0,".png":!0,".tif":!0,".tiff":!0,".webp":!0},r={".markdown":!0,".md":!0,".mdown":!0,".mkd":!0,".mkdown":!0,".rmd":!0,".ron":!0},h=function(e){return null!=e&&"string"==typeof e&&e.length>0},m=function(e,t,o){return get_fs().stat(e,function(n,s){if(!n)return get_fs().stat(t,function(n,r){if(!n||"ENOENT"!==n.code)return o(void 0,e.toLowerCase()===t.toLowerCase()&&s.dev===r.dev&&s.ino===r.ino);o(void 0,!0)});o(n)})},p=function(e,t){var o,n;return n=y(e),o=y(t),!n||!o||e.toLowerCase()===t.toLowerCase()&&n.dev===o.dev&&n.ino===o.ino},t.exports=new Proxy({},{get:function(e,t){var o;return null!=(o=u[t])?o:get_fs()[t]},set:function(e,t,o){return u[t]=o}})}).call(this)},"../node_modules/@atom/source-map-support/source-map-support.js":function(e,t,o,n,s,r){var i,a,l=s("../node_modules/source-map/lib/source-map.js").SourceMapConsumer;function get_path(){return i=i||s("path")}function get_fs(){return a=a||s("fs")}var d=!1,u=!1,c="auto",m={},p={},h=/^data:application\/json[^,]+base64,/;function isInBrowser(){return"browser"===c||"node"!==c&&(void 0!==get_window()&&"function"==typeof XMLHttpRequest)}function retrieveFile(e){if((e=e.trim())in m)return m[e];try{if(isInBrowser()){var t=new XMLHttpRequest;t.open("GET",e,!1),t.send(null);var o=null;4===t.readyState&&200===t.status&&(o=t.responseText)}else o=get_fs().readFileSync(e,"utf8")}catch(e){o=null}return m[e]=o}function supportRelativeURL(e,t){if(!e)return t;var o=get_path().dirname(e),n=/^\w+:\/\/[^\/]*/.exec(o),s=n?n[0]:"";return s+get_path().resolve(o.slice(s.length),t)}function retrieveSourceMap(e){var t,o=function retrieveSourceMapURL(e){var t;if(isInBrowser()){var o=new XMLHttpRequest;o.open("GET",e,!1),o.send(null),t=4===o.readyState?o.responseText:null;var n=o.getResponseHeader("SourceMap")||o.getResponseHeader("X-SourceMap");if(n)return n}t=retrieveFile(e);for(var s,r,i=/(?:\/\/[@#][ \t]+sourceMappingURL=([^\s'"]+?)[ \t]*$)|(?:\/\*[@#][ \t]+sourceMappingURL=([^\*]+?)[ \t]*(?:\*\/)[ \t]*$)/gm;r=i.exec(t);)s=r;return s?s[1]:null}(e);if(!o)return null;if(h.test(o)){var n=o.slice(o.indexOf(",")+1);t=new Buffer(n,"base64").toString(),o=null}else t=retrieveFile(o=supportRelativeURL(e,o));return t?{url:o,map:t}:null}function mapSourcePosition(e){var t=p[e.source];if(!t){var o,n=retrieveSourceMap(e.source);if(n)o=n.map.originalPositionFor?n.map:new l(n.map),(t=p[e.source]={url:n.url,map:o}).map.sourcesContent&&t.map.sources.forEach(function(e,o){var n=t.map.sourcesContent[o];if(n){var s=supportRelativeURL(t.url,e);m[s]=n}});else t=p[e.source]={url:null,map:null}}if(t&&t.map){var s=t.map.originalPositionFor(e);if(null!==s.source)return s.source=supportRelativeURL(t.url,s.source),s}return e}function CallSiteToString(){var e,t="";if(this.isNative())t="native";else{!(e=this.getScriptNameOrSourceURL())&&this.isEval()&&(t=this.getEvalOrigin(),t+=", "),t+=e||"<anonymous>";var o=this.getLineNumber();if(null!=o){t+=":"+o;var n=this.getColumnNumber();n&&(t+=":"+n)}}var s="",r=this.getFunctionName(),i=!0,a=this.isConstructor();if(!(this.isToplevel()||a)){var l=this.getTypeName(),d=this.getMethodName();r?(l&&0!=r.indexOf(l)&&(s+=l+"."),s+=r,d&&r.indexOf("."+d)!=r.length-d.length-1&&(s+=" [as "+d+"]")):s+=l+"."+(d||"<anonymous>")}else a?s+="new "+(r||"<anonymous>"):r?s+=r:(s+=t,i=!1);return i&&(s+=" ("+t+")"),s}function cloneCallSite(e){var t={};return Object.getOwnPropertyNames(Object.getPrototypeOf(e)).forEach(function(o){t[o]=/^(?:is|get)/.test(o)?function(){return e[o].call(e)}:e[